=head1 NAME

SQL::SyntaxModel::L::en - Localization of SQL::SyntaxModel for English

=cut

######################################################################

package SQL::SyntaxModel::L::en;
use 5.006;
use strict;
use warnings;
use vars qw($VERSION);
$VERSION = '0.04';

######################################################################

=head1 DEPENDENCIES

Perl Version: 5.006

Standard Modules: I<none>

Nonstandard Modules: I<This module has no enforced dependencies, but it is
designed to be used by Locale::KeyedText when that module localizes error
messages generated by SQL::SyntaxModel.>

=head1 COPYRIGHT AND LICENSE

This file is part of the SQL::SyntaxModel library (libSQLSM).

SQL::SyntaxModel is Copyright (c) 1999-2004, Darren R. Duncan.  All rights reserved.
Address comments, suggestions, and bug reports to B<perl@DarrenDuncan.net>, or
visit "http://www.DarrenDuncan.net" for more information.

SQL::SyntaxModel is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License (GPL) version 2 as published
by the Free Software Foundation (http://www.fsf.org/).  You should have
received a copy of the GPL as part of the SQL::SyntaxModel distribution, in the
file named "LICENSE"; if not, write to the Free Software Foundation, Inc., 59
Temple Place, Suite 330, Boston, MA 02111-1307 USA.

Linking SQL::SyntaxModel statically or dynamically with other modules is making
a combined work based on SQL::SyntaxModel.  Thus, the terms and conditions of
the GPL cover the whole combination.  As a special exception, the copyright
holders of SQL::SyntaxModel give you permission to link SQL::SyntaxModel with
independent modules, regardless of the license terms of these independent
modules, and to copy and distribute the resulting combined work under terms of
your choice, provided that every copy of the combined work is accompanied by a
complete copy of the source code of SQL::SyntaxModel (the version of
SQL::SyntaxModel used to produce the combined work), being distributed under
the terms of the GPL plus this exception.  An independent module is a module
which is not derived from or based on SQL::SyntaxModel, and which is fully
useable when not linked to SQL::SyntaxModel in any form.

Any versions of SQL::SyntaxModel that you modify and distribute must carry
prominent notices stating that you changed the files and the date of any
changes, in addition to preserving this original copyright notice and other
credits. SQL::SyntaxModel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.

While it is by no means required, the copyright holders of SQL::SyntaxModel
would appreciate being informed any time you create a modified version of
SQL::SyntaxModel that you are willing to distribute, because that is a
practical way of suggesting improvements to the standard version.

=cut

######################################################################

my %text_strings = (
	'SSM_C_GET_NODE_NO_ARG_TYPE' => 
		"get_node(): missing NODE_TYPE argument",
	'SSM_C_GET_NODE_NO_ARG_ID' => 
		"get_node(): missing NODE_ID argument",
	'SSM_C_GET_NODE_BAD_TYPE' => 
		"get_node(): invalid NODE_TYPE argument; there is no Node Type named '{TYPE}'",

	'SSM_C_GET_CH_NODES_BAD_TYPE' => 
		"get_child_nodes(): invalid NODE_TYPE argument; there is no Node Type named '{TYPE}'",

	'SSM_N_NEW_NODE_NO_ARGS' => 
		"new_node(): missing NODE_TYPE argument",
	'SSM_N_NEW_NODE_BAD_TYPE' => 
		"new_node(): invalid NODE_TYPE argument; there is no Node Type named '{TYPE}'",

	'SSM_N_DEL_NODE_IN_CONT' => 
		"delete_node(): this Node can not be deleted because it is ".
		"still in a Container; you must take it from there first",

	'SSM_N_CLEAR_NODE_ID_IN_CONT' => 
		"clear_node_id(): you can not clear the Node Id (value '{ID}') of this ".
		"'{TYPE}' Node because the Node is in a Container",

	'SSM_N_SET_NODE_ID_NO_ARGS' => 
		"set_node_id(): missing NEW_ID argument",
	'SSM_N_SET_NODE_ID_BAD_ARG' => 
		"set_node_id(): invalid NEW_ID argument; a Node Id may only be a positive integer; ".
		"you tried to set it to '{ARG}'",
	'SSM_N_SET_NODE_ID_DUPL_ID' => 
		"set_node_id(): invalid NEW_ID argument; the Node Id value of '{ID}' you tried to set ".
		"is already in use by another '{TYPE}' Node in the same Container; it must be unique",

	'SSM_N_EXP_LIT_AT_NO_ARGS' => 
		"expected_literal_attribute_type(): missing ATTR_NAME argument",
	'SSM_N_EXP_LIT_AT_INVAL_NM' => 
		"expected_literal_attribute_type(): invalid ATTR_NAME argument; ".
		"there is no literal attribute named '{NAME}' in '{HOSTTYPE}' Nodes",

	'SSM_N_SET_LIT_AT_NO_ARG_VAL' => 
		"set_literal_attribute(): missing ATTR_VALUE argument",
	'SSM_N_SET_LIT_AT_INVAL_V_BOOL' => 
		"set_literal_attribute(): invalid ATTR_VALUE argument; ".
		"the literal attribute named '{NAME}' in '{HOSTTYPE}' Nodes may only be a ".
		"boolean value, as expressed by '0' or '1'; you tried to set it to '{VAL}'",
	'SSM_N_SET_LIT_AT_INVAL_V_UINT' => 
		"set_literal_attribute(): invalid ATTR_VALUE argument; ".
		"the literal attribute named '{NAME}' in '{HOSTTYPE}' Nodes may only be a ".
		"non-negative integer; you tried to set it to '{VAL}'",
	'SSM_N_SET_LIT_AT_INVAL_V_SINT' => 
		"set_literal_attribute(): invalid ATTR_VALUE argument; ".
		"the literal attribute named '{NAME}' in '{HOSTTYPE}' Nodes may only be an ".
		"integer; you tried to set it to '{VAL}'",

	'SSM_N_SET_LIT_ATS_NO_ARGS' => 
		"set_literal_attributes(): missing ATTRS argument",
	'SSM_N_SET_LIT_ATS_BAD_ARGS' => 
		"set_literal_attributes(): invalid ATTRS argument; ".
		"it is not a hash ref, but rather is '{ARG}",

	'SSM_N_EXP_ENUM_AT_NO_ARGS' => 
		"expected_enumerated_attribute_type(): missing ATTR_NAME argument",
	'SSM_N_EXP_ENUM_AT_INVAL_NM' => 
		"expected_enumerated_attribute_type(): invalid ATTR_NAME argument; ".
		"there is no enumerated attribute named '{NAME}' in '{HOSTTYPE}' Nodes",

	'SSM_N_SET_ENUM_AT_NO_ARG_VAL' => 
		"set_enumerated_attribute(): missing ATTR_VALUE argument",
	'SSM_N_SET_ENUM_AT_INVAL_V' => 
		"set_enumerated_attribute(): invalid ATTR_VALUE argument; ".
		"the enumerated attribute named '{NAME}' in '{HOSTTYPE}' Nodes may only be a ".
		"'{ENUMTYPE}' value; you tried to set it to '{VAL}'",

	'SSM_N_SET_ENUM_ATS_NO_ARGS' => 
		"set_enumerated_attributes(): missing ATTRS argument",
	'SSM_N_SET_ENUM_ATS_BAD_ARGS' => 
		"set_enumerated_attributes(): invalid ATTRS argument; ".
		"it is not a hash ref, but rather is '{ARG}'",

	'SSM_N_EXP_NREF_AT_NO_ARGS' => 
		"expected_node_ref_attribute_type(): missing ATTR_NAME argument",
	'SSM_N_EXP_NREF_AT_INVAL_NM' => 
		"expected_node_ref_attribute_type(): invalid ATTR_NAME argument; ".
		"there is no Node attribute named '{NAME}' in '{HOSTTYPE}' Nodes",

	'SSM_N_SET_NREF_AT_NO_ARG_VAL' => 
		"set_node_ref_attribute(): missing ATTR_VALUE argument",
	'SSM_N_SET_NREF_AT_WRONG_NODE_TYPE' => 
		"set_node_ref_attribute(): invalid ATTR_VALUE argument; the attribute named ".
		"'{NAME}' in '{HOSTTYPE}' Nodes may only reference a '{EXPTYPE}' Node, but ".
		"you tried to set it to a '{GIVEN}' Node",
	'SSM_N_SET_NREF_AT_DIFF_CONT' => 
		"set_node_ref_attribute(): invalid ATTR_VALUE argument; that Node is not in ".
		"the same Container as the current Node, so they can not be linked",
	'SSM_N_SET_NREF_AT_ONE_CONT' => 
		"set_node_ref_attribute(): invalid ATTR_VALUE argument; a Node that is in a ".
		"Container can not be linked to one that is not",
	'SSM_N_SET_NREF_AT_MISS_NID' => 
		"set_node_ref_attribute(): invalid ATTR_VALUE argument; the given Node ".
		"lacks a Node Id, and one is required to link to it from this one",
	'SSM_N_SET_NREF_AT_BAD_ARG_VAL' => 
		"set_node_ref_attribute(): invalid ATTR_VALUE argument; '{ARG}' is not a Node ref, ".
		"and a Node Id may only be a positive integer",
	'SSM_N_SET_NREF_AT_NONEX_NID' => 
		"set_node_ref_attribute(): invalid ATTR_VALUE argument; '{ARG}' is not a Node ref, ".
		"and it does not match the Id of any '{EXPTYPE}' Node in this Container",
	'SSM_N_SET_NREF_AT_RECIP_LINKS' => 
		"set_node_ref_attribute(): invalid ATTR_VALUE argument; the given Node is not yet ".
		"in reciprocating status, so the current Node can not yet become a child of it",

	'SSM_N_SET_NREF_ATS_NO_ARGS' => 
		"set_node_ref_attributes(): missing ATTRS argument",
	'SSM_N_SET_NREF_ATS_BAD_ARGS' => 
		"set_node_ref_attributes(): invalid ATTRS argument; ".
		"it is not a hash ref, but rather is '{ARG}'",

	'SSM_N_EXP_AT_MT_NO_ARGS' => 
		"expected_attribute_major_type(): missing ATTR_NAME argument",
	'SSM_N_EXP_AT_MT_INVAL_NM' => 
		"expected_attribute_major_type(): invalid ATTR_NAME argument; ".
		"there is no attribute named '{NAME}' in '{HOSTTYPE}' Nodes",

	'SSM_N_SET_ATS_NO_ARGS' => 
		"set_attributes(): missing ATTRS argument",
	'SSM_N_SET_ATS_BAD_ARGS' => 
		"set_attributes(): invalid ATTRS argument; ".
		"it is not a hash ref, but rather is '{ARG}'",

	'SSM_N_SET_P_NODE_ATNM_NO_ARGS' => 
		"set_parent_node_attribute_name(): missing ATTR_NAME argument",
	'SSM_N_SET_P_NODE_ATNM_INVAL_NM' => 
		"set_parent_node_attribute_name(): invalid ATTR_NAME argument; ".
		"either there is no Node attribute named '{NAME}' in '{HOSTTYPE}' Nodes, ".
		"or that attribute can not be used as the primary parent Node",

	'SSM_N_EST_P_NODE_ATNM_NO_ARGS' => 
		"estimate_parent_node_attribute_name(): missing NEW_PARENT argument",
	'SSM_N_EST_P_NODE_ATNM_BAD_ARG' => 
		"estimate_parent_node_attribute_name(): invalid NEW_PARENT argument; ".
		"it is not a Node object, but rather is '{ARG}'",

	'SSM_N_PI_CONT_NO_ARGS' => 
		"put_in_container(): missing NEW_CONTAINER argument",
	'SSM_N_PI_CONT_BAD_ARG' => 
		"put_in_container(): invalid NEW_CONTAINER argument; ".
		"it is not a Container object, but rather is '{ARG}'",
	'SSM_N_PI_CONT_NO_NODE_ID' => 
		"put_in_container(): this Node can not be put in a Container yet ".
		"as this Node has no NODE_ID defined",
	'SSM_N_PI_CONT_HAVE_ALREADY' => 
		"put_in_container(): this Node already lives in a Container; you ".
		"must take this Node from there before putting it in a different one",
	'SSM_N_PI_CONT_DUPL_ID' => 
		"put_in_container(): this Node can not be put into the given Container ".
		"because its Node Id value of '{ID}' is already in use by another '{TYPE}' Node ".
		"in the same Container; one of them needs to be changed first",
	'SSM_N_PI_CONT_NONEX_AT_NODE' => 
		"put_in_container(): this Node can not be put into the given Container ".
		"because the Node attribute named '{ATNM}' expects to link to a '{TYPE}' Node ".
		"with a Node Id of '{ID}', but no such Node exists in the given Container",

	'SSM_N_TF_CONT_RECIP_LINKS' => 
		"take_from_container(): this Node can not be taken from its Container yet ".
		"as other Nodes that this Node refers to in its attributes have reciprocal links to it",

	'SSM_N_ADD_RL_NO_NODE_ID' => 
		"add_reciprocal_links(): this Node is not in a Container, ".
		"so no other Nodes can link to it as a child",

	'SSM_N_REM_RL_HAS_CHILD' => 
		"remove_reciprocal_links(): this Node has child Nodes of its ".
		"own, so it can not be removed from reciprocating status",

	'SSM_N_MOVE_PRE_SIB_NO_RL' => 
		"move_before_sibling(): this Node is not in reciprocating ".
		"status and therefore it is not present in any child list; it has no siblings",
	'SSM_N_MOVE_PRE_SIB_NO_S_ARG' => 
		"move_before_sibling(): missing SIBLING argument",
	'SSM_N_MOVE_PRE_SIB_BAD_S_ARG' => 
		"move_before_sibling(): invalid SIBLING argument; ".
		"it is not a Node object, but rather is '{ARG}'",
	'SSM_N_MOVE_PRE_SIB_S_NO_RL' => 
		"move_before_sibling(): invalid SIBLING argument; that Node is not in reciprocating ".
		"status and therefore it is not present in any child list; it has no siblings",
	'SSM_N_MOVE_PRE_SIB_S_DIFF_CONT' => 
		"move_before_sibling(): invalid SIBLING argument; that Node is not in ".
		"the same Container (if any) as the current Node, so they can not be siblings",
	'SSM_N_MOVE_PRE_SIB_BAD_P_ARG' => 
		"move_before_sibling(): invalid PARENT argument; ".
		"it is not a Node object, but rather is '{ARG}'",
	'SSM_N_MOVE_PRE_SIB_P_DIFF_CONT' => 
		"move_before_sibling(): invalid PARENT argument; that Node is not in ".
		"the same Container (if any) as the current Node, so they can not be related",
	'SSM_N_MOVE_PRE_SIB_NO_P_ARG_OR_PP_OR_PS' => 
		"move_before_sibling(): no PARENT argument was given, and the current Node ".
		"has no primary parent Node or parent pseudo-Node for it to default to",
	'SSM_N_MOVE_PRE_SIB_P_NOT_P' => 
		"move_before_sibling(): invalid PARENT argument; ".
		"the current Node is not a child of that Node",
	'SSM_N_MOVE_PRE_SIB_S_NOT_S' => 
		"move_before_sibling(): invalid SIBLING argument; ".
		"the current Node does not share PARENT (or its primary parent) with that Node",

	'SSM_N_GET_CH_NODES_BAD_TYPE' => 
		"get_child_nodes(): invalid NODE_TYPE argument; there is no Node Type named '{TYPE}'",

	'SSM_N_ADD_CH_NODE_NO_ARGS' => 
		"add_child_node(): missing NEW_CHILD argument",
	'SSM_N_ADD_CH_NODE_BAD_ARG' => 
		"add_child_node(): invalid NEW_CHILD argument; ".
		"it is not a Node object, but rather is '{ARG}'",
	'SSM_N_ADD_CH_NODE_NO_EST' => 
		"add_child_node(): the current Node can not be the primary parent of the given Node",

	'SSM_N_TEMA_ATS_NID_VAL_NO_SET' => 
		"test_mandatory_attributes(): this '{HOSTTYPE}' Node has failed a test; ".
		"the Node ID must be given a value",
	'SSM_N_TEMA_ATS_LIT_VAL_NO_SET' => 
		"test_mandatory_attributes(): this '{HOSTTYPE}' Node has failed a test; ".
		"the literal attribute named '{NAME}' must be given a value",
	'SSM_N_TEMA_ATS_ENUM_VAL_NO_SET' => 
		"test_mandatory_attributes(): this '{HOSTTYPE}' Node has failed a test; ".
		"the enumerated attribute named '{NAME}' must be given a value",
	'SSM_N_TEMA_ATS_NREF_VAL_NO_SET' => 
		"test_mandatory_attributes(): this '{HOSTTYPE}' Node has failed a test; ".
		"the node attribute named '{NAME}' must be given a value",
);

######################################################################

sub get_text_by_key {
	return( $text_strings{$_[1]} );
}

######################################################################

1;
__END__

=head1 SYNOPSIS

	use Locale::KeyedText;
	use SQL::SyntaxModel;

	# do work ...

	my $translator = Locale::KeyedText->new_translator( ['SQL::SyntaxModel::L::'], ['en'] );

	# do work ...

	eval {
		# do work with SQL::SyntaxModel, which may throw an exception ...
	};
	if( my $error_message_object = $@ ) {
		# examine object here if you want and programmatically recover...

		# or otherwise do the next few lines...
		my $error_user_text = $translator->translate_message( $error_message_object );
		# display $error_user_text to user by some appropriate means
	}

	# continue working, which may involve using SQL::SyntaxModel some more ...

=head1 DESCRIPTION

The SQL::SyntaxModel::L::en Perl 5 module contains localization data for
SQL::SyntaxModel.  It is designed to be interpreted by Locale::KeyedText.

This class is optional and you can still use SQL::SyntaxModel effectively without 
it, especially if you plan to either show users different error messages than this 
class defines, or not show them anything because you are "handling it".

=head1 SYNTAX

This class does not export any functions or methods, so you need to call them
using object notation.  This means using B<Class-E<gt>function()> for functions
and B<$object-E<gt>method()> for methods.  If you are inheriting this class for
your own modules, then that often means something like B<$self-E<gt>method()>.  

=head1 FUNCTIONS

=head2 get_text_by_key( MSG_KEY )

	my $user_text_template = SQL::SyntaxModel::L::en->get_text_by_key( 'foo' );

This function takes a Message Key string in MSG_KEY and returns the associated
user text template string, if there is one, or undef if not.

=head1 SEE ALSO

perl(1), Locale::KeyedText, SQL::SyntaxModel.

=cut
