# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.
BEGIN { require 5.8.1; }
use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;
check_conflicts();

my %WriteMakefileArgs = (
  'ABSTRACT' => 'routines for manipulating stashes',
  'AUTHOR' => 'Jesse Luehrs <doy at tozt dot net>',
  'BUILD_REQUIRES' => {
    'Test::Fatal' => '0',
    'Test::More' => '0.88',
    'Test::Requires' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'Dist::CheckConflicts' => '0.02',
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'Package-Stash',
  'EXE_FILES' => [
    'bin/package-stash-conflicts'
  ],
  'LICENSE' => 'perl',
  'NAME' => 'Package::Stash',
  'PREREQ_PM' => {
    'Dist::CheckConflicts' => '0.02',
    'Package::DeprecationManager' => '0',
    'Scalar::Util' => '0'
  },
  'VERSION' => '0.32',
  'test' => {
    'TESTS' => 't/*.t t/impl-selection/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

$WriteMakefileArgs{PREREQ_PM}{'Package::Stash::XS'} = 0.24
  if can_cc();

WriteMakefile(%WriteMakefileArgs);

use Config ();
use File::Spec ();

# check if we can run some command
sub can_run {
        my ($cmd) = @_;

        my $_cmd = $cmd;
        return $_cmd if (-x $_cmd or $_cmd = MM->maybe_command($_cmd));

        for my $dir ((split /$Config::Config{path_sep}/, $ENV{PATH}), '.') {
                next if $dir eq '';
                my $abs = File::Spec->catfile($dir, $_[0]);
                return $abs if (-x $abs or $abs = MM->maybe_command($abs));
        }

        return;
}

# can we locate a (the) C compiler
sub can_cc {
        my @chunks = split(/ /, $Config::Config{cc}) or return;

        # $Config{cc} may contain args; try to find out the program part
        while (@chunks) {
                return can_run("@chunks") || (pop(@chunks), next);
        }

        return;
}

sub check_conflicts {
    if ( eval { require 'lib/Package/Stash/Conflicts.pm'; 1; } ) {
        if ( eval { Package::Stash::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually using the 'package-stash-conflicts' script that is installed with
    this distribution once the installation finishes.
***
EOF
    }

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
