package Locales::DB::Language::bs;

# Auto generated from CLDR

$Locales::DB::Language::bs::VERSION = '0.07';

$Locales::DB::Language::bs::cldr_version = '2.0';

%Locales::DB::Language::bs::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Jezik\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [ 'sr_Latn' ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'many',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ mod\ 10\ in\ 2\.\.4\ and\ n\ mod\ 100\ not\ in\ 12\.\.14",
            'many' => "n\ mod\ 10\ is\ 0\ or\ n\ mod\ 10\ in\ 5\.\.9\ or\ n\ mod\ 100\ in\ 11\.\.14",
            'one'  => "n\ mod\ 10\ is\ 1\ and\ n\ mod\ 100\ is\ not\ 11"
        },
        'category_rules_compiled' => {
            'few'  => "sub\ \{\ return\ \'few\'\ if\ \(\ \(\(\ int\(\$_\[0\]\)\ \=\=\ \$_\[0\]\ \&\&\ \(\$_\[0\]\ \%\ 10\)\ \>\=\ 2\ \&\&\ \(\$_\[0\]\ \%\ 10\)\ \<\=\ 4\ \)\ \&\&\ \(\ int\(\$_\[0\]\)\ \!\=\ \$_\[0\]\ \|\|\ \(\$_\[0\]\ \%\ 100\)\ \<\ 12\ \|\|\ \(\$_\[0\]\ \%\ 100\)\ \>\ 14\ \)\)\)\;\ return\;\}\;",
            'many' => "sub\ \{\ return\ \'many\'\ if\ \(\ \(\(\ \(\$_\[0\]\ \%\ 10\)\ \=\=\ 0\)\)\ \|\|\ \ \(\(\ int\(\$_\[0\]\)\ \=\=\ \$_\[0\]\ \&\&\ \(\$_\[0\]\ \%\ 10\)\ \>\=\ 5\ \&\&\ \(\$_\[0\]\ \%\ 10\)\ \<\=\ 9\ \)\)\ \|\|\ \ \(\(\ int\(\$_\[0\]\)\ \=\=\ \$_\[0\]\ \&\&\ \(\$_\[0\]\ \%\ 100\)\ \>\=\ 11\ \&\&\ \(\$_\[0\]\ \%\ 100\)\ \<\=\ 14\ \)\)\)\;\ return\;\}\;",
            'one'  => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \(\$_\[0\]\ \%\ 10\)\ \=\=\ 1\)\ \&\&\ \(\ \(\$_\[0\]\ \%\ 100\)\ \!\=\ 11\)\)\)\;\ return\;\}\;"
        }
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "da\:d"
    },
);

%Locales::DB::Language::bs::code_to_name = (
    'aa'    => 'afarski',
    'ab'    => 'abkazijski',
    'ace'   => 'ačineski',
    'ach'   => 'akoli',
    'ada'   => 'adangmejski',
    'ady'   => 'adigejski',
    'ae'    => 'avestanski',
    'af'    => 'afrikanerski',
    'afa'   => "afro\-azijatski",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'akadijski',
    'ale'   => 'aljut',
    'alg'   => "algonkvijanski\ jezik",
    'alt'   => "južni\ altai",
    'am'    => 'amharski',
    'an'    => 'aragonežanski',
    'ang'   => 'staroengleski',
    'anp'   => 'angika',
    'apa'   => "apački\ jezik",
    'ar'    => 'arapski',
    'arc'   => 'armajski',
    'arn'   => 'arokanijski',
    'arp'   => 'arapaho',
    'art'   => 'veštački',
    'arw'   => 'aravak',
    'as'    => 'asemijski',
    'asa'   => 'Asu',
    'ast'   => 'asturijski',
    'ath'   => 'atapaskan',
    'aus'   => "australijski\ jezik",
    'av'    => 'avarski',
    'awa'   => 'avadhi',
    'ay'    => 'ajmara',
    'az'    => 'azerbejdžanski',
    'ba'    => 'baškir',
    'bad'   => 'banda',
    'bai'   => 'bamileke',
    'bal'   => 'baluči',
    'ban'   => 'balinezijski',
    'bas'   => 'basa',
    'bat'   => "baltički\ jezik",
    'be'    => 'beloruski',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'berber',
    'bez'   => 'Bena',
    'bg'    => 'bugarski',
    'bh'    => 'biharski',
    'bho'   => 'bojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalski',
    'bnt'   => 'bantu',
    'bo'    => 'tibetanski',
    'br'    => 'bretonski',
    'bra'   => 'braj',
    'brx'   => 'Bodo',
    'bs'    => 'bosanski',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'buginežanskii',
    'byn'   => 'blin',
    'ca'    => 'katalonski',
    'cad'   => 'kado',
    'cai'   => "jezik\ centralno\-američkih\ indijanaca",
    'car'   => 'karipski',
    'cau'   => 'kavkaski',
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'čečenski',
    'ceb'   => 'cebuano',
    'cel'   => "keltski\ jezik",
    'cgg'   => 'Chiga',
    'ch'    => 'čamoro',
    'chb'   => 'čibča',
    'chg'   => 'čagatai',
    'chk'   => 'čukeski',
    'chm'   => 'mari',
    'chn'   => 'činukski',
    'cho'   => 'čoktavski',
    'chp'   => 'čipvijanski',
    'chr'   => 'čeroki',
    'chy'   => 'čejenski',
    'cmc'   => "čamski\ jezik",
    'co'    => 'korzikanski',
    'cop'   => 'koptski',
    'cpe'   => "kreolski\ ili\ pidžin\ zasnovan\ na\ engleskom",
    'cpf'   => "kreolski\ ili\ pidžin\ zasnovan\ na\ francuskom",
    'cpp'   => "kreolski\ ili\ pidžin\ baziran\ na\ portugalskom",
    'cr'    => 'kri',
    'crh'   => "krimeanski\ turski",
    'crp'   => "kreolski\ ili\ pidžin",
    'cs'    => 'češki',
    'csb'   => 'kašubijanski',
    'cu'    => 'staroslovenski',
    'cus'   => "kušitički\ jezik",
    'cv'    => 'čuvaški',
    'cy'    => 'velški',
    'da'    => 'danski',
    'dak'   => 'dakota',
    'dar'   => 'dargva',
    'dav'   => 'Taita',
    'day'   => 'dajaški',
    'de'    => 'njemački',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'delaver',
    'den'   => 'slavski',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "dravidijski\ jezik",
    'dsb'   => "niski\ sorbijanski",
    'dua'   => 'duala',
    'dum'   => "srednji\ holandski",
    'dv'    => 'divehijski',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'đula',
    'dz'    => 'džonga',
    'ebu'   => 'Embu',
    'ee'    => 'eve',
    'efi'   => 'efikski',
    'egy'   => 'staroegipatski',
    'eka'   => 'ekajuk',
    'el'    => 'grčki',
    'elx'   => 'elamitski',
    'en'    => 'engleski',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "srednji\ engleski",
    'eo'    => 'esperanto',
    'es'    => 'španjolski',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estonski',
    'eu'    => 'baskijski',
    'ewo'   => 'evondo',
    'fa'    => 'persijski',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulah',
    'fi'    => 'finski',
    'fil'   => 'filipinski',
    'fiu'   => "ugro\-finski\ jezik",
    'fj'    => 'fidžijski',
    'fo'    => 'farski',
    'fon'   => 'fon',
    'fr'    => 'francuski',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "srednji\ francuski",
    'fro'   => 'starofrancuski',
    'frr'   => "severno\-frizijski",
    'frs'   => "istočni\ frizijski",
    'fur'   => 'friulijski',
    'fy'    => 'frizijski',
    'ga'    => 'irski',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaja',
    'gd'    => "škotski\ galski",
    'gem'   => "germanski\ jezik",
    'gez'   => 'džiz',
    'gil'   => 'gilbertški',
    'gl'    => 'galski',
    'gmh'   => "srednji\ visoki\ nemački",
    'gn'    => 'gvarani',
    'goh'   => 'staronemački',
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotski',
    'grb'   => 'grebo',
    'grc'   => 'starogrčki',
    'gsw'   => "švajcarsko\ nemački",
    'gu'    => 'gudžarati',
    'guz'   => 'Gusii',
    'gv'    => 'manks',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'havajski',
    'he'    => 'hebrejski',
    'hi'    => 'hindi',
    'hil'   => 'hiligajnon',
    'him'   => 'himačali',
    'hit'   => 'hitite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'hrvatski',
    'hsb'   => "gornji\ sorbijski",
    'ht'    => 'haićanski',
    'hu'    => 'mađarski',
    'hup'   => 'hupa',
    'hy'    => 'jermenski',
    'hz'    => 'herero',
    'ia'    => 'interlingva',
    'iba'   => 'iban',
    'id'    => 'indonezijski',
    'ie'    => 'interlingve',
    'ig'    => 'igbo',
    'ii'    => "sičuan\ ji",
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'iloko',
    'inc'   => 'indik',
    'ine'   => "indo\-evropski\ jezik",
    'inh'   => 'ingušetski',
    'io'    => 'ido',
    'ira'   => "iranski\ jezik",
    'iro'   => 'irokvojanski',
    'is'    => 'islandski',
    'it'    => 'talijanski',
    'iu'    => 'inuktitut',
    'ja'    => 'japanski',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "judeo\-persijski",
    'jrb'   => "judeo\-arapski",
    'jv'    => 'javanski',
    'ka'    => 'gruzijski',
    'kaa'   => "kara\-kalpaški",
    'kab'   => 'kabile',
    'kac'   => 'kačin',
    'kaj'   => 'žju',
    'kam'   => 'kamba',
    'kar'   => 'karenski',
    'kaw'   => 'kavi',
    'kbd'   => 'kabardijski',
    'kcg'   => 'tjap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'kasi',
    'khi'   => "koisanski\ jezik",
    'kho'   => 'kotanizijski',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuju',
    'kj'    => 'kuanjama',
    'kk'    => 'kozački',
    'kl'    => 'kalalisutski',
    'kln'   => 'Kalenjin',
    'km'    => 'kmerski',
    'kmb'   => 'kimbundu',
    'kn'    => 'kanada',
    'ko'    => 'korejski',
    'kok'   => 'konkani',
    'kos'   => 'kosreanski',
    'kpe'   => 'kpele',
    'kr'    => 'kanuri',
    'krc'   => "karačaj\-balkar",
    'krl'   => 'karelijski',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'kašmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdski',
    'kum'   => 'kumik',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'korniški',
    'ky'    => 'kirgiski',
    'la'    => 'latinski',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'luksemburški',
    'lez'   => 'lezgian',
    'lg'    => 'ganda',
    'li'    => 'limburgiš',
    'ln'    => 'lingala',
    'lo'    => 'laoški',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litvanski',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lušai',
    'luy'   => 'Luyia',
    'lv'    => 'letonski',
    'mad'   => 'madureški',
    'mag'   => 'magahi',
    'mai'   => 'maitili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => 'austronežanski',
    'mas'   => 'masai',
    'mdf'   => 'mokša',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagazijski',
    'mga'   => "srednji\ irski",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'maršalski',
    'mi'    => 'maorski',
    'mic'   => 'mikmak',
    'min'   => 'minangkabau',
    'mis'   => "razni\ jezici",
    'mk'    => 'makedonski',
    'mkh'   => "mon\-kmerski\ jezik",
    'ml'    => 'malajalam',
    'mn'    => 'mongolski',
    'mnc'   => 'manču',
    'mni'   => 'manipuri',
    'mno'   => "manobo\ jezik",
    'mo'    => 'moldavski',
    'moh'   => 'mahavski',
    'mos'   => 'mosi',
    'mr'    => 'marati',
    'ms'    => 'malajski',
    'mt'    => 'melteški',
    'mua'   => 'Mundang',
    'mul'   => "više\ jezika",
    'mun'   => "munda\ jezik",
    'mus'   => 'kriški',
    'mwl'   => 'mirandeški',
    'mwr'   => 'marvari',
    'my'    => 'burmanski',
    'myn'   => "majanski\ jezik",
    'myv'   => 'erzija',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "jezik\ severno\-američkih\ indijanaca",
    'nap'   => 'neapolitanski',
    'naq'   => 'Nama',
    'nb'    => "norveški\ bokmål",
    'nd'    => "severni\ ndebele",
    'nds'   => "niski\ nemački",
    'ne'    => 'nepalski',
    'new'   => 'nevari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "niger\-kordofanijski\ jezik",
    'niu'   => 'niuean',
    'nl'    => 'holandski',
    'nl_be' => 'flamanski',
    'nmg'   => 'Kwasio',
    'nn'    => "norveški\ njorsk",
    'no'    => 'norveški',
    'nog'   => 'nogai',
    'non'   => "stari\ norski",
    'nqo'   => 'n’ko',
    'nr'    => "južni\ ndebele",
    'nso'   => "severni\ soto",
    'nub'   => "nubijski\ jezik",
    'nus'   => 'Nuer',
    'nv'    => 'navaho',
    'nwc'   => "klasični\ nevari",
    'ny'    => 'njanja',
    'nym'   => 'njamvezi',
    'nyn'   => 'njankole',
    'nyo'   => 'njoro',
    'nzi'   => 'nzima',
    'oc'    => 'provansalski',
    'oj'    => 'ojibva',
    'om'    => 'oromo',
    'or'    => 'orijski',
    'os'    => 'osetski',
    'osa'   => 'osage',
    'ota'   => "otomanski\ turski",
    'oto'   => "otomanski\ jezik",
    'pa'    => 'pandžabski',
    'paa'   => "papuanski\ jezik",
    'pag'   => 'pangasinski',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauanski',
    'peo'   => 'staropersijski',
    'phi'   => "filipinski\ jezik",
    'phn'   => 'feničanski',
    'pi'    => 'pali',
    'pl'    => 'poljski',
    'pon'   => 'ponpejski',
    'pra'   => "prakritski\ jezik",
    'pro'   => 'staroprovansalski',
    'ps'    => 'paštunski',
    'pt'    => 'portugalski',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'kvenča',
    'raj'   => 'rađastani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongan',
    'rm'    => "reto\-romanski",
    'rn'    => 'rundi',
    'ro'    => 'rumunski',
    'roa'   => "romanski\ jezik",
    'rof'   => 'Rombo',
    'rom'   => 'romani',
    'ru'    => 'ruski',
    'rup'   => 'aromanijski',
    'rw'    => 'kinjarvanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sanskrit',
    'sad'   => 'sandave',
    'sah'   => 'jakut',
    'sai'   => "jezik\ južno\-američkih\ indijanaca",
    'sal'   => "sališanski\ jezik",
    'sam'   => "samaritanski\ aramejski",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sardinijski',
    'scn'   => 'sicilijanski',
    'sco'   => 'škotski',
    'sd'    => 'sindi',
    'se'    => "severni\ sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkap',
    'sem'   => "semitski\ jezik",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => 'staroirski',
    'sgn'   => "jezik\ znakova",
    'sh'    => 'srpskohrvatski',
    'shi'   => 'Tachelhit',
    'shn'   => 'šan',
    'si'    => 'singaleski',
    'sid'   => 'sidamo',
    'sio'   => "siuanski\ jezik",
    'sit'   => "sino\-tibetanski\ jezik",
    'sk'    => 'slovački',
    'sl'    => 'slovenački',
    'sla'   => "slovenski\ jezik",
    'sm'    => 'samoanski',
    'sma'   => "južni\ sami",
    'smi'   => "sami\ jezik",
    'smj'   => "lule\ sami",
    'smn'   => "inari\ sami",
    'sms'   => "skoltski\ jezik",
    'sn'    => 'šona',
    'snk'   => 'soninke',
    'so'    => 'somalski',
    'sog'   => 'sodžijenski',
    'son'   => 'songai',
    'sq'    => 'albanski',
    'sr'    => 'srpski',
    'srn'   => "srananski\ tongo",
    'srr'   => 'serer',
    'ss'    => 'svati',
    'ssa'   => "nilo\-saharski\ jezik",
    'ssy'   => 'Saho',
    'st'    => 'sesoto',
    'su'    => 'sudanski',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerski',
    'sv'    => 'švedski',
    'sw'    => 'svahili',
    'swb'   => 'komorski',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klasični\ sirijski",
    'syr'   => 'sirijski',
    'ta'    => 'tamilski',
    'tai'   => "tai\ jezik",
    'te'    => 'telugu',
    'tem'   => 'timne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tađik',
    'th'    => 'tajlandski',
    'ti'    => 'tigrinja',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turkmenski',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalski',
    'tlh'   => 'klingonski',
    'tli'   => 'tlingit',
    'tmh'   => 'tamašek',
    'tn'    => 'tsvana',
    'to'    => 'tonga',
    'tog'   => "njasa\ tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turski',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimšian',
    'tt'    => 'tatarski',
    'tum'   => 'tumbuka',
    'tup'   => "tupi\ jezik",
    'tut'   => "altaički\ jezik",
    'tvl'   => 'tuvalu',
    'tw'    => 'tvi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahićanski',
    'tyv'   => 'tuvinijski',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurt',
    'ug'    => 'ujgurski',
    'uga'   => 'ugaritski',
    'uk'    => 'ukrajinski',
    'umb'   => 'umbundu',
    'und'   => "nepoznati\ ili\ nevažeći\ jezik",
    'ur'    => 'urdu',
    'uz'    => 'uzbečki',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vijetnamski',
    'vo'    => 'volapük',
    'vot'   => 'votski',
    'vun'   => 'Vunjo',
    'wa'    => 'valun',
    'wae'   => 'Walser',
    'wak'   => "vakašanski\ jezik",
    'wal'   => 'valamo',
    'war'   => 'varej',
    'was'   => 'vašo',
    'wen'   => "sorbijanski\ jezik",
    'wo'    => 'volof',
    'xal'   => 'kalmik',
    'xh'    => 'khosa',
    'xog'   => 'Soga',
    'yao'   => 'jao',
    'yap'   => 'japeški',
    'yav'   => 'Yangben',
    'yi'    => 'jidiš',
    'yo'    => 'jorubanski',
    'ypk'   => 'jupik',
    'yue'   => 'kantonski',
    'za'    => 'zuang',
    'zap'   => 'zapotečki',
    'zbl'   => 'blisimboli',
    'zen'   => 'zenaga',
    'zh'    => 'kineski',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "bez\ lingvističkog\ sadržaja",
    'zza'   => 'zaza',
);

%Locales::DB::Language::bs::name_to_code = (
    'abkazijski'                              => 'ab',
    'adangmejski'                             => 'ada',
    'adigejski'                               => 'ady',
    'afarski'                                 => 'aa',
    'afrihili'                                => 'afh',
    'afrikanerski'                            => 'af',
    'afroazijatski'                           => 'afa',
    'aghem'                                   => 'agq',
    'ainu'                                    => 'ain',
    'ajmara'                                  => 'ay',
    'akadijski'                               => 'akk',
    'akan'                                    => 'ak',
    'akoli'                                   => 'ach',
    'albanski'                                => 'sq',
    'algonkvijanskijezik'                     => 'alg',
    'aljut'                                   => 'ale',
    'altaičkijezik'                          => 'tut',
    'amharski'                                => 'am',
    'angika'                                  => 'anp',
    'apačkijezik'                            => 'apa',
    'aragonežanski'                          => 'an',
    'arapaho'                                 => 'arp',
    'arapski'                                 => 'ar',
    'aravak'                                  => 'arw',
    'armajski'                                => 'arc',
    'arokanijski'                             => 'arn',
    'aromanijski'                             => 'rup',
    'asemijski'                               => 'as',
    'asturijski'                              => 'ast',
    'asu'                                     => 'asa',
    'atapaskan'                               => 'ath',
    'atsam'                                   => 'cch',
    'australianenglish'                       => 'en_au',
    'australijskijezik'                       => 'aus',
    'austriangerman'                          => 'de_at',
    'austronežanski'                         => 'map',
    'avadhi'                                  => 'awa',
    'avarski'                                 => 'av',
    'avestanski'                              => 'ae',
    'azerbejdžanski'                         => 'az',
    'ačineski'                               => 'ace',
    'bafia'                                   => 'ksf',
    'balinezijski'                            => 'ban',
    'baltičkijezik'                          => 'bat',
    'baluči'                                 => 'bal',
    'bambara'                                 => 'bm',
    'bamileke'                                => 'bai',
    'banda'                                   => 'bad',
    'bantu'                                   => 'bnt',
    'basa'                                    => 'bas',
    'baskijski'                               => 'eu',
    'batak'                                   => 'btk',
    'baškir'                                 => 'ba',
    'beja'                                    => 'bej',
    'beloruski'                               => 'be',
    'bemba'                                   => 'bem',
    'bena'                                    => 'bez',
    'bengalski'                               => 'bn',
    'berber'                                  => 'ber',
    'bezlingvističkogsadržaja'              => 'zxx',
    'biharski'                                => 'bh',
    'bikol'                                   => 'bik',
    'bini'                                    => 'bin',
    'bislama'                                 => 'bi',
    'blin'                                    => 'byn',
    'blisimboli'                              => 'zbl',
    'bodo'                                    => 'brx',
    'bojpuri'                                 => 'bho',
    'bosanski'                                => 'bs',
    'braj'                                    => 'bra',
    'brazilianportuguese'                     => 'pt_br',
    'bretonski'                               => 'br',
    'britishenglish'                          => 'en_gb',
    'bugarski'                                => 'bg',
    'buginežanskii'                          => 'bug',
    'buriat'                                  => 'bua',
    'burmanski'                               => 'my',
    'canadianenglish'                         => 'en_ca',
    'canadianfrench'                          => 'fr_ca',
    'cayuga'                                  => 'cay',
    'cebuano'                                 => 'ceb',
    'centralmoroccotamazight'                 => 'tzm',
    'chiga'                                   => 'cgg',
    'colognian'                               => 'ksh',
    'congoswahili'                            => 'swc',
    'dajaški'                                => 'day',
    'dakota'                                  => 'dak',
    'danski'                                  => 'da',
    'dargva'                                  => 'dar',
    'delaver'                                 => 'del',
    'dinka'                                   => 'din',
    'divehijski'                              => 'dv',
    'dogri'                                   => 'doi',
    'dogrib'                                  => 'dgr',
    'dravidijskijezik'                        => 'dra',
    'duala'                                   => 'dua',
    'džiz'                                   => 'gez',
    'džonga'                                 => 'dz',
    'efikski'                                 => 'efi',
    'ekajuk'                                  => 'eka',
    'elamitski'                               => 'elx',
    'embu'                                    => 'ebu',
    'engleski'                                => 'en',
    'erzija'                                  => 'myv',
    'esperanto'                               => 'eo',
    'estonski'                                => 'et',
    'eve'                                     => 'ee',
    'evondo'                                  => 'ewo',
    'fang'                                    => 'fan',
    'fanti'                                   => 'fat',
    'farski'                                  => 'fo',
    'feničanski'                             => 'phn',
    'fidžijski'                              => 'fj',
    'filipinski'                              => 'fil',
    'filipinskijezik'                         => 'phi',
    'finski'                                  => 'fi',
    'flamanski'                               => 'nl_be',
    'fon'                                     => 'fon',
    'francuski'                               => 'fr',
    'friulijski'                              => 'fur',
    'frizijski'                               => 'fy',
    'fulah'                                   => 'ff',
    'ga'                                      => 'gaa',
    'gajo'                                    => 'gay',
    'galski'                                  => 'gl',
    'ganda'                                   => 'lg',
    'gbaja'                                   => 'gba',
    'germanskijezik'                          => 'gem',
    'gilbertški'                             => 'gil',
    'gondi'                                   => 'gon',
    'gornjisorbijski'                         => 'hsb',
    'gorontalo'                               => 'gor',
    'gotski'                                  => 'got',
    'grebo'                                   => 'grb',
    'gruzijski'                               => 'ka',
    'grčki'                                  => 'el',
    'gudžarati'                              => 'gu',
    'gusii'                                   => 'guz',
    'gvarani'                                 => 'gn',
    "gwich\Ê\¼in"                           => 'gwi',
    'haida'                                   => 'hai',
    'haićanski'                              => 'ht',
    'hausa'                                   => 'ha',
    'havajski'                                => 'haw',
    'hebrejski'                               => 'he',
    'herero'                                  => 'hz',
    'hiligajnon'                              => 'hil',
    'himačali'                               => 'him',
    'hindi'                                   => 'hi',
    'hirimotu'                                => 'ho',
    'hitite'                                  => 'hit',
    'hmong'                                   => 'hmn',
    'holandski'                               => 'nl',
    'hrvatski'                                => 'hr',
    'hupa'                                    => 'hup',
    'iban'                                    => 'iba',
    'iberianportuguese'                       => 'pt_pt',
    'iberianspanish'                          => 'es_es',
    'ido'                                     => 'io',
    'igbo'                                    => 'ig',
    'ijo'                                     => 'ijo',
    'iloko'                                   => 'ilo',
    'inarisami'                               => 'smn',
    'indik'                                   => 'inc',
    'indoevropskijezik'                       => 'ine',
    'indonezijski'                            => 'id',
    'ingušetski'                             => 'inh',
    'interlingva'                             => 'ia',
    'interlingve'                             => 'ie',
    'inuktitut'                               => 'iu',
    'inupiak'                                 => 'ik',
    'iranskijezik'                            => 'ira',
    'irokvojanski'                            => 'iro',
    'irski'                                   => 'ga',
    'islandski'                               => 'is',
    'istočnifrizijski'                       => 'frs',
    'jakut'                                   => 'sah',
    'jao'                                     => 'yao',
    'japanski'                                => 'ja',
    'japeški'                                => 'yap',
    'javanski'                                => 'jv',
    'jermenski'                               => 'hy',
    'jezikcentralnoameričkihindijanaca'      => 'cai',
    'jezikjužnoameričkihindijanaca'         => 'sai',
    'jeziksevernoameričkihindijanaca'        => 'nai',
    'jezikznakova'                            => 'sgn',
    'jidiš'                                  => 'yi',
    'jolafonyi'                               => 'dyo',
    'jorubanski'                              => 'yo',
    'judeoarapski'                            => 'jrb',
    'judeopersijski'                          => 'jpr',
    'jupik'                                   => 'ypk',
    'južnialtai'                             => 'alt',
    'južnindebele'                           => 'nr',
    'južnisami'                              => 'sma',
    'kabardijski'                             => 'kbd',
    'kabile'                                  => 'kab',
    'kabuverdianu'                            => 'kea',
    'kado'                                    => 'cad',
    'kalalisutski'                            => 'kl',
    'kalenjin'                                => 'kln',
    'kalmik'                                  => 'xal',
    'kamba'                                   => 'kam',
    'kanada'                                  => 'kn',
    'kantonski'                               => 'yue',
    'kanuri'                                  => 'kr',
    'karakalpaški'                           => 'kaa',
    'karačajbalkar'                          => 'krc',
    'karelijski'                              => 'krl',
    'karenski'                                => 'kar',
    'karipski'                                => 'car',
    'kasi'                                    => 'kha',
    'katalonski'                              => 'ca',
    'kavi'                                    => 'kaw',
    'kavkaski'                                => 'cau',
    'kačin'                                  => 'kac',
    'kašmiri'                                => 'ks',
    'kašubijanski'                           => 'csb',
    'keltskijezik'                            => 'cel',
    'khosa'                                   => 'xh',
    'kikuju'                                  => 'ki',
    'kimbundu'                                => 'kmb',
    'kineski'                                 => 'zh',
    'kinjarvanda'                             => 'rw',
    'kirgiski'                                => 'ky',
    'klasičninevari'                         => 'nwc',
    'klasičnisirijski'                       => 'syc',
    'klingonski'                              => 'tlh',
    'kmerski'                                 => 'km',
    'koisanskijezik'                          => 'khi',
    'komi'                                    => 'kv',
    'komorski'                                => 'swb',
    'kongo'                                   => 'kg',
    'konkani'                                 => 'kok',
    'koptski'                                 => 'cop',
    'korejski'                                => 'ko',
    'korniški'                               => 'kw',
    'koro'                                    => 'kfo',
    'korzikanski'                             => 'co',
    'kosreanski'                              => 'kos',
    'kotanizijski'                            => 'kho',
    'koyraborosenni'                          => 'ses',
    'koyrachiini'                             => 'khq',
    'kozački'                                => 'kk',
    'kpele'                                   => 'kpe',
    'kreolskiilipidžin'                      => 'crp',
    'kreolskiilipidžinbazirannaportugalskom' => 'cpp',
    'kreolskiilipidžinzasnovannaengleskom'   => 'cpe',
    'kreolskiilipidžinzasnovannafrancuskom'  => 'cpf',
    'kri'                                     => 'cr',
    'krimeanskiturski'                        => 'crh',
    'kriški'                                 => 'mus',
    'kru'                                     => 'kro',
    'kuanjama'                                => 'kj',
    'kumik'                                   => 'kum',
    'kurdski'                                 => 'ku',
    'kurukh'                                  => 'kru',
    'kutenai'                                 => 'kut',
    'kušitičkijezik'                        => 'cus',
    'kvenča'                                 => 'qu',
    'kwasio'                                  => 'nmg',
    'ladino'                                  => 'lad',
    'lamba'                                   => 'lam',
    'landa'                                   => 'lah',
    'langi'                                   => 'lag',
    'laoški'                                 => 'lo',
    'latinski'                                => 'la',
    'letonski'                                => 'lv',
    'lezgian'                                 => 'lez',
    'limburgiš'                              => 'li',
    'lingala'                                 => 'ln',
    'litvanski'                               => 'lt',
    'lojban'                                  => 'jbo',
    'lozi'                                    => 'loz',
    'lubakatanga'                             => 'lu',
    'lubalulua'                               => 'lua',
    'luiseno'                                 => 'lui',
    'luksemburški'                           => 'lb',
    'lulesami'                                => 'smj',
    'lunda'                                   => 'lun',
    'luo'                                     => 'luo',
    'luyia'                                   => 'luy',
    'lušai'                                  => 'lus',
    'machame'                                 => 'jmc',
    'madureški'                              => 'mad',
    'magahi'                                  => 'mag',
    'mahavski'                                => 'moh',
    'maitili'                                 => 'mai',
    'majanskijezik'                           => 'myn',
    'makasar'                                 => 'mak',
    'makedonski'                              => 'mk',
    'makhuwameetto'                           => 'mgh',
    'makonde'                                 => 'kde',
    'malagazijski'                            => 'mg',
    'malajalam'                               => 'ml',
    'malajski'                                => 'ms',
    'mandar'                                  => 'mdr',
    'mandingo'                                => 'man',
    'manipuri'                                => 'mni',
    'manks'                                   => 'gv',
    'manobojezik'                             => 'mno',
    'manču'                                  => 'mnc',
    'maorski'                                 => 'mi',
    'marati'                                  => 'mr',
    'mari'                                    => 'chm',
    'marvari'                                 => 'mwr',
    'maršalski'                              => 'mh',
    'masai'                                   => 'mas',
    'mađarski'                               => 'hu',
    'melteški'                               => 'mt',
    'mende'                                   => 'men',
    'meru'                                    => 'mer',
    'mikmak'                                  => 'mic',
    'minangkabau'                             => 'min',
    'mirandeški'                             => 'mwl',
    'mokša'                                  => 'mdf',
    'moldavski'                               => 'mo',
    'mongo'                                   => 'lol',
    'mongolski'                               => 'mn',
    'monkmerskijezik'                         => 'mkh',
    'morisyen'                                => 'mfe',
    'mosi'                                    => 'mos',
    'mundajezik'                              => 'mun',
    'mundang'                                 => 'mua',
    'nahuatl'                                 => 'nah',
    'nama'                                    => 'naq',
    'nauru'                                   => 'na',
    'navaho'                                  => 'nv',
    'ndonga'                                  => 'ng',
    'neapolitanski'                           => 'nap',
    'nepalski'                                => 'ne',
    'nepoznatiilinevažećijezik'             => 'und',
    'nevari'                                  => 'new',
    'nias'                                    => 'nia',
    'nigerkordofanijskijezik'                 => 'nic',
    'nilosaharskijezik'                       => 'ssa',
    'niskinemački'                           => 'nds',
    'niskisorbijanski'                        => 'dsb',
    'niuean'                                  => 'niu',
    'njamvezi'                                => 'nym',
    'njanja'                                  => 'ny',
    'njankole'                                => 'nyn',
    'njasatonga'                              => 'tog',
    'njemački'                               => 'de',
    'njoro'                                   => 'nyo',
    'nogai'                                   => 'nog',
    'norveški'                               => 'no',
    'norveškibokmål'                        => 'nb',
    'norveškinjorsk'                         => 'nn',
    'nubijskijezik'                           => 'nub',
    'nuer'                                    => 'nus',
    'nzima'                                   => 'nzi',
    'n’ko'                                  => 'nqo',
    'ojibva'                                  => 'oj',
    'orijski'                                 => 'or',
    'oromo'                                   => 'om',
    'osage'                                   => 'osa',
    'osetski'                                 => 'os',
    'otomanskijezik'                          => 'oto',
    'otomanskiturski'                         => 'ota',
    'pahlavi'                                 => 'pal',
    'palauanski'                              => 'pau',
    'pali'                                    => 'pi',
    'pampanga'                                => 'pam',
    'pandžabski'                             => 'pa',
    'pangasinski'                             => 'pag',
    'papiamento'                              => 'pap',
    'papuanskijezik'                          => 'paa',
    'paštunski'                              => 'ps',
    'persijski'                               => 'fa',
    'poljski'                                 => 'pl',
    'ponpejski'                               => 'pon',
    'portugalski'                             => 'pt',
    'prakritskijezik'                         => 'pra',
    'provansalski'                            => 'oc',
    'rapanui'                                 => 'rap',
    'rarotongan'                              => 'rar',
    'raznijezici'                             => 'mis',
    'rađastani'                              => 'raj',
    'retoromanski'                            => 'rm',
    'romani'                                  => 'rom',
    'romanskijezik'                           => 'roa',
    'rombo'                                   => 'rof',
    'rumunski'                                => 'ro',
    'rundi'                                   => 'rn',
    'ruski'                                   => 'ru',
    'rwa'                                     => 'rwk',
    'saho'                                    => 'ssy',
    'sališanskijezik'                        => 'sal',
    'samaritanskiaramejski'                   => 'sam',
    'samburu'                                 => 'saq',
    'samijezik'                               => 'smi',
    'samoanski'                               => 'sm',
    'sandave'                                 => 'sad',
    'sango'                                   => 'sg',
    'sangu'                                   => 'sbp',
    'sanskrit'                                => 'sa',
    'santali'                                 => 'sat',
    'sardinijski'                             => 'sc',
    'sasak'                                   => 'sas',
    'selkap'                                  => 'sel',
    'semitskijezik'                           => 'sem',
    'sena'                                    => 'seh',
    'seneca'                                  => 'see',
    'serer'                                   => 'srr',
    'sesoto'                                  => 'st',
    'severnindebele'                          => 'nd',
    'severnisami'                             => 'se',
    'severnisoto'                             => 'nso',
    'severnofrizijski'                        => 'frr',
    'shambala'                                => 'ksb',
    'sicilijanski'                            => 'scn',
    'sidamo'                                  => 'sid',
    'siksika'                                 => 'bla',
    'sindi'                                   => 'sd',
    'singaleski'                              => 'si',
    'sinotibetanskijezik'                     => 'sit',
    'sirijski'                                => 'syr',
    'siuanskijezik'                           => 'sio',
    'sičuanji'                               => 'ii',
    'skoltskijezik'                           => 'sms',
    'slavski'                                 => 'den',
    'slovački'                               => 'sk',
    'slovenački'                             => 'sl',
    'slovenskijezik'                          => 'sla',
    'sodžijenski'                            => 'sog',
    'soga'                                    => 'xog',
    'somalski'                                => 'so',
    'songai'                                  => 'son',
    'soninke'                                 => 'snk',
    'sorbijanskijezik'                        => 'wen',
    'srananskitongo'                          => 'srn',
    'srednjiengleski'                         => 'enm',
    'srednjifrancuski'                        => 'frm',
    'srednjiholandski'                        => 'dum',
    'srednjiirski'                            => 'mga',
    'srednjivisokinemački'                   => 'gmh',
    'srpski'                                  => 'sr',
    'srpskohrvatski'                          => 'sh',
    'starinorski'                             => 'non',
    'staroegipatski'                          => 'egy',
    'staroengleski'                           => 'ang',
    'starofrancuski'                          => 'fro',
    'starogrčki'                             => 'grc',
    'staroirski'                              => 'sga',
    'staronemački'                           => 'goh',
    'staropersijski'                          => 'peo',
    'staroprovansalski'                       => 'pro',
    'staroslovenski'                          => 'cu',
    'sudanski'                                => 'su',
    'sukuma'                                  => 'suk',
    'sumerski'                                => 'sux',
    'susu'                                    => 'sus',
    'svahili'                                 => 'sw',
    'svati'                                   => 'ss',
    'swissfrench'                             => 'fr_ch',
    'swisshighgerman'                         => 'de_ch',
    'tachelhit'                               => 'shi',
    'tagalski'                                => 'tl',
    'tahićanski'                             => 'ty',
    'taijezik'                                => 'tai',
    'taita'                                   => 'dav',
    'tajlandski'                              => 'th',
    'talijanski'                              => 'it',
    'tamašek'                                => 'tmh',
    'tamilski'                                => 'ta',
    'taroko'                                  => 'trv',
    'tasawaq'                                 => 'twq',
    'tatarski'                                => 'tt',
    'tađik'                                  => 'tg',
    'telugu'                                  => 'te',
    'tereno'                                  => 'ter',
    'teso'                                    => 'teo',
    'tetum'                                   => 'tet',
    'tibetanski'                              => 'bo',
    'tigre'                                   => 'tig',
    'tigrinja'                                => 'ti',
    'timne'                                   => 'tem',
    'tiv'                                     => 'tiv',
    'tjap'                                    => 'kcg',
    'tlingit'                                 => 'tli',
    'tokelau'                                 => 'tkl',
    'tokpisin'                                => 'tpi',
    'tonga'                                   => 'to',
    'tsimšian'                               => 'tsi',
    'tsonga'                                  => 'ts',
    'tsvana'                                  => 'tn',
    'tumbuka'                                 => 'tum',
    'tupijezik'                               => 'tup',
    'turkmenski'                              => 'tk',
    'turski'                                  => 'tr',
    'tuvalu'                                  => 'tvl',
    'tuvinijski'                              => 'tyv',
    'tvi'                                     => 'tw',
    "u\.s\.english"                           => 'en_us',
    'udmurt'                                  => 'udm',
    'ugaritski'                               => 'uga',
    'ugrofinskijezik'                         => 'fiu',
    'ujgurski'                                => 'ug',
    'ukrajinski'                              => 'uk',
    'umbundu'                                 => 'umb',
    'urdu'                                    => 'ur',
    'uzbečki'                                => 'uz',
    'vai'                                     => 'vai',
    'vakašanskijezik'                        => 'wak',
    'valamo'                                  => 'wal',
    'valun'                                   => 'wa',
    'varej'                                   => 'war',
    'vašo'                                   => 'was',
    'velški'                                 => 'cy',
    'venda'                                   => 've',
    'veštački'                              => 'art',
    'vijetnamski'                             => 'vi',
    'višejezika'                             => 'mul',
    'volapük'                                => 'vo',
    'volof'                                   => 'wo',
    'votski'                                  => 'vot',
    'vunjo'                                   => 'vun',
    'walser'                                  => 'wae',
    'yangben'                                 => 'yav',
    'zande'                                   => 'znd',
    'zapotečki'                              => 'zap',
    'zarma'                                   => 'dje',
    'zaza'                                    => 'zza',
    'zenaga'                                  => 'zen',
    'zuang'                                   => 'za',
    'zulu'                                    => 'zu',
    'zuni'                                    => 'zun',
    'čagatai'                                => 'chg',
    'čamoro'                                 => 'ch',
    'čamskijezik'                            => 'cmc',
    'čejenski'                               => 'chy',
    'čeroki'                                 => 'chr',
    'čečenski'                              => 'ce',
    'češki'                                 => 'cs',
    'čibča'                                 => 'chb',
    'činukski'                               => 'chn',
    'čipvijanski'                            => 'chp',
    'čoktavski'                              => 'cho',
    'čukeski'                                => 'chk',
    'čuvaški'                               => 'cv',
    'đula'                                   => 'dyu',
    'šan'                                    => 'shn',
    'škotski'                                => 'sco',
    'škotskigalski'                          => 'gd',
    'šona'                                   => 'sn',
    'španjolski'                             => 'es',
    'švajcarskonemački'                     => 'gsw',
    'švedski'                                => 'sv',
    'žju'                                    => 'kaj',
);

1;
