# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..8\n"; }
END {print "not ok 1\n" unless $loaded;}
use IMAPClient;
$loaded = 1;
print "ok 1\n";


######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

unless ( -f "./.test" ) { exit;}

my $test = 1;
my %parms;
open TST,"./.test" or exit;
while (defined(my $l = <TST>)) {
	my($p,$v)=split(/=/,$l);
	chomp $v;
	$parms{$p}=$v;
}
close TST;
my $imap ;
eval { $imap = Mail::IMAPClient->new( 
		Server 	=> "$parms{server}"||"localhost",
		Port 	=> "$parms{port}"  || '143',
		User 	=> "$parms{user}"  || scalar(getpwuid($<)),
		Password=> "$parms{passed}"|| scalar(getpwuid($<)),
		Debug   => 0,
) } ;
if ($imap) {
	print "ok ",++$test,"\n";
} else {	
	print "not ok ",++$test,"\n";
}

if ( eval { $imap->select('inbox') } ) {
	print "ok ",++$test,"\n";
} else {	
	print "not ok ",++$test,"\n";
	print $imap->History,"\n";
}

if ( eval { $imap->create("IMAPClient_$$") } ) {
	print "ok ",++$test,"\n";
} else {	
	print "not ok ",++$test,"\n";
}

if ( eval { $imap->exists("IMAPClient_$$") } ) {
	print "ok ",++$test,"\n";
} else {	
	print "not ok ",++$test,"\n";
}


if ( eval { $imap->append("IMAPClient_$$",&testmsg)} ) {
	print "ok ",++$test,"\n";
} else {	
	print "not ok ",++$test,"\n";
}

if ( eval { $imap->select("IMAPClient_$$") } ) {
	print "ok ",++$test,"\n";
} else {	
	print "not ok ",++$test,"\n";
}

sleep 3;
my @hits = ();
eval { @hits = $imap->search(qq(SUBJECT "Testing")) } ;
if ( scalar(@hits) == 1 ) {
	print "ok ",++$test,"\n";
} else {	
	print "not ok ",++$test,"\n";
}






















sub testmsg {
		my $m = qq{Date:  @{[$imap->Rfc822_date(time)]}
To: <$parms{user}\@$parms{server}>
From: Perl <$parms{user}\@$parms{server}>
Subject: Testing from pid $$

This is a test message generated by 'make test' during the installation of 
that nifty Mail::IMAPClient module from CPAN. Like all things perl, it's 
way cool.

};

	return $m;
}
