# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130805;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'geographic' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441404", "Honiton",
"441446", "Barry",
"441453", "Dursley",
"441269", "Ammanford",
"441651", "Oldmeldrum",
"4419646", "Patrington",
"4413395", "Aboyne",
"441373", "Frome",
"441888", "Turriff",
"441304", "Dover",
"4419644", "Patrington",
"441353", "Ely",
"441963", "Wincanton",
"441346", "Fraserburgh",
"441938", "Welshpool",
"441549", "Lairg",
"441745", "Rhyl",
"441531", "Ledbury",
"441947", "Whitby",
"441913", "Durham",
"441642", "Middlesbrough",
"4412298", "Barrow\-in\-Furness",
"441671", "Newton\ Stewart",
"441900", "Workington",
"441473", "Ipswich",
"442896", "Belfast",
"441728", "Saxmundham",
"441290", "Cumnock",
"441267", "Carmarthen",
"4415077", "Louth",
"4414302", "North\ Cave",
"441405", "Goole",
"441243", "Chichester",
"441256", "Basingstoke",
"442886", "Cookstown",
"441280", "Buckingham",
"441547", "Knighton",
"44286", "Northern\ Ireland",
"441721", "Peebles",
"441276", "Camberley",
"4414301", "North\ Cave\/Market\ Weighton",
"441678", "Bala",
"442870", "Coleraine",
"441563", "Kilmarnock",
"441538", "Ipstones",
"44281", "Northern\ Ireland",
"441305", "Dorchester",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441744", "St\ Helens",
"4419759", "Alford\ \(Aberdeen\)",
"441949", "Whatton",
"441931", "Shap",
"441706", "Rochdale",
"4419755", "Alford\ \(Aberdeen\)",
"441491", "Henley\-on\-Thames",
"4415394", "Hawkshead",
"441761", "Temple\ Cloud",
"441282", "Burnley",
"4414379", "Haverfordwest",
"441873", "Abergavenny",
"441388", "Bishop\ Auckland",
"441609", "Northallerton",
"442824", "Northern\ Ireland",
"4414233", "Boroughbridge",
"441227", "Canterbury",
"441235", "Abingdon",
"4415396", "Sedbergh",
"441502", "Lowestoft",
"44118", "Reading",
"442841", "Rostrevor",
"441488", "Hungerford",
"441381", "Fortrose",
"441923", "Watford",
"441733", "Peterborough",
"4414300", "North\ Cave\/Market\ Weighton",
"441768", "Penrith",
"44241", "Coventry",
"4413399", "Ballater",
"442848", "Northern\ Ireland",
"441481", "Guernsey",
"441902", "Wolverhampton",
"441683", "Moffat",
"441292", "Ayr",
"441805", "Torrington",
"442837", "Armagh",
"442825", "Ballymena",
"441398", "Dulverton",
"441234", "Bedford",
"4418473", "Thurso",
"44114700", "Sheffield",
"441650", "Cemmaes\ Road",
"441288", "Bude",
"441382", "Dundee",
"4414303", "North\ Cave",
"441435", "Heathfield",
"441869", "Bicester",
"441664", "Melton\ Mowbray",
"441427", "Gainsborough",
"441530", "Coalville",
"44161", "Manchester",
"441926", "Warwick",
"4416973", "Wigton",
"441291", "Chepstow",
"4418470", "Thurso\/Tongue",
"441736", "Penzance",
"441482", "Kingston\-upon\-Hull",
"441670", "Morpeth",
"441327", "Daventry",
"441508", "Brooke",
"441335", "Ashbourne",
"441856", "Orkney",
"441843", "Thanet",
"441880", "Tarbert",
"441665", "Alnwick",
"441429", "Hartlepool",
"441492", "Colwyn\ Bay",
"442871", "Londonderry",
"442842", "Kircubbin",
"441501", "Harthill",
"441720", "Isles\ of\ Scilly",
"441298", "Buxton",
"4414230", "Harrogate\/Boroughbridge",
"441908", "Milton\ Keynes",
"441334", "St\ Andrews",
"441329", "Fareham",
"4418515", "Stornoway",
"441392", "Exeter",
"441876", "Lochmaddy",
"441526", "Martin",
"4418519", "Great\ Bernera",
"441584", "Ludlow",
"441760", "Swaffham",
"441557", "Kirkcudbright",
"441985", "Warminster",
"4415074", "Alford\ \(Lincs\)",
"441490", "Corwen",
"4418471", "Thurso\/Tongue",
"441273", "Brighton",
"441566", "Launceston",
"441882", "Kinloch\ Rannoch",
"441754", "Skegness",
"4414348", "Hexham",
"441369", "Dunoon",
"441959", "Westerham",
"441787", "Sudbury",
"441932", "Weybridge",
"441625", "Macclesfield",
"441637", "Newquay",
"4418472", "Thurso",
"441204", "Bolton",
"441994", "St\ Clears",
"4415076", "Louth",
"442840", "Banbridge",
"441253", "Blackpool",
"441799", "Saffron\ Walden",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441246", "Chesterfield",
"441722", "Salisbury",
"442883", "Northern\ Ireland",
"441835", "St\ Boswells",
"441469", "Killingholme",
"441827", "Tamworth",
"441577", "Kinross",
"441343", "Elgin",
"441356", "Brechin",
"441380", "Devizes",
"441559", "Llandysul",
"441916", "Tyneside",
"441652", "Brigg",
"441957", "Mid\ Yell",
"441367", "Faringdon",
"441789", "Stratford\-upon\-Avon",
"4414231", "Harrogate\/Boroughbridge",
"441984", "Watchet\ \(Williton\)",
"4416868", "Newtown",
"442893", "Ballyclare",
"441476", "Grantham",
"441205", "Boston",
"441995", "Garstang",
"4419647", "Patrington",
"441594", "Lydney",
"441456", "Glenurquhart",
"441443", "Pontypridd",
"441672", "Marlborough",
"441480", "Huntingdon",
"441977", "Pontefract",
"441641", "Strathy",
"441834", "Narberth",
"441639", "Neath",
"441775", "Spalding",
"4414232", "Harrogate",
"441467", "Inverurie",
"441829", "Tarporley",
"441624", "Isle\ of\ Man",
"441579", "Liskeard",
"441797", "Rye",
"441892", "Tunbridge\ Wells",
"441376", "Braintree",
"4418908", "Coldstream",
"441732", "Sevenoaks",
"44131", "Edinburgh",
"441974", "Llanon",
"441450", "Hawick",
"441825", "Uckfield",
"441575", "Kirriemuir",
"441837", "Okehampton",
"441779", "Peterhead",
"441597", "Llandrindod\ Wells",
"441848", "Thornhill",
"441794", "Romsey",
"441209", "Redruth",
"441922", "Walsall",
"4413398", "Aboyne",
"441635", "Newbury",
"441464", "Insch",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"44141", "Glasgow",
"441350", "Dunkeld",
"441785", "Stafford",
"441386", "Evesham",
"4412295", "Barrow\-in\-Furness",
"441910", "Tyneside\/Durham\/Sunderland",
"441364", "Ashburton",
"441954", "Madingley",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441903", "Worthing",
"441293", "Crawley",
"441759", "Pocklington",
"441987", "Ebbsfleet",
"441555", "Lanark",
"441599", "Kyle",
"441795", "Sittingbourne",
"441841", "Newquay\ \(Padstow\)",
"441465", "Girvan",
"441777", "Retford",
"441634", "Medway",
"441522", "Lincoln",
"441872", "Truro",
"4413885", "Stanhope\ \(Eastgate\)",
"442846", "Northern\ Ireland",
"441824", "Ruthin",
"441629", "Matlock",
"441207", "Consett",
"441692", "North\ Walsham",
"441997", "Strathpeffer",
"441283", "Burton\-on\-Trent",
"441766", "Porthmadog",
"441503", "Looe",
"441955", "Wick",
"441496", "Port\ Ellen",
"441554", "Llanelli",
"4413873", "Langholm",
"441560", "Moscow",
"441757", "Selby",
"441989", "Ross\-on\-Wye",
"4414378", "Haverfordwest",
"441852", "Kilmelford",
"4419643", "Patrington",
"441784", "Staines",
"44280", "Northern\ Ireland",
"441271", "Barnstaple",
"4419758", "Strathdon",
"441242", "Cheltenham",
"4415072", "Spilsby\ \(Horncastle\)",
"441337", "Ladybank",
"441325", "Darlington",
"442898", "Belfast",
"441690", "Betws\-y\-Coed",
"441726", "St\ Austell",
"4414307", "Market\ Weighton",
"441348", "Fishguard",
"441144", "Sheffield",
"441870", "Isle\ of\ Benbecula",
"441520", "Lochcarron",
"4418476", "Tongue",
"441562", "Kidderminster",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441425", "Ringwood",
"4418474", "Thurso",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"442881", "Newtownstewart",
"441864", "Abington\ \(Crawford\)",
"441669", "Rothbury",
"4414236", "Harrogate",
"441536", "Kettering",
"441920", "Ware",
"441341", "Barmouth",
"441145", "Sheffield",
"441708", "Romford",
"4412299", "Millom",
"441372", "Esher",
"441896", "Galashiels",
"441730", "Petersfield",
"442891", "Bangor\ \(Co\.\ Down\)",
"441452", "Gloucester",
"441324", "Falkirk",
"441278", "Bridgwater",
"441676", "Meriden",
"441258", "Blandford",
"441656", "Bridgend",
"441912", "Tyneside",
"441643", "Minehead",
"441865", "Oxford",
"441439", "Helmsley",
"441472", "Grimsby",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"442888", "Northern\ Ireland",
"4414234", "Boroughbridge",
"441352", "Mold",
"441962", "Winchester",
"441424", "Hastings",
"441667", "Nairn",
"44114708", "Sheffield",
"44114702", "Sheffield",
"442829", "Kilrea",
"441646", "Milford\ Haven",
"441653", "Malton",
"441248", "Bangor\ \(Gwynedd\)",
"4420", "London",
"4418909", "Ayton",
"4419641", "Hornsea\/Patrington",
"441809", "Tomdoun",
"441604", "Northampton",
"441451", "Stow\-on\-the\-Wold",
"442892", "Lisburn",
"441371", "Great\ Dunmow",
"441237", "Bideford",
"441225", "Bath",
"441342", "East\ Grinstead",
"4419642", "Hornsea",
"4416869", "Newtown",
"441568", "Leominster",
"44283", "Northern\ Ireland",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"4414237", "Harrogate",
"441442", "Hemel\ Hempstead",
"441673", "Market\ Rasen",
"441911", "Tyneside\/Durham\/Sunderland",
"441224", "Aberdeen",
"441840", "Camelford",
"441883", "Caterham",
"4414304", "North\ Cave",
"441807", "Ballindalloch",
"442827", "Ballymoney",
"441702", "Southend\-on\-Sea",
"441458", "Glastonbury",
"44115", "Nottingham",
"441239", "Cardigan",
"441241", "Arbroath",
"4414349", "Bellingham",
"441918", "Tyneside",
"441252", "Aldershot",
"4416974", "Raughton\ Head",
"441723", "Scarborough",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"442882", "Omagh",
"44117", "Bristol",
"4418477", "Tongue",
"441933", "Wellingborough",
"441968", "Penicuik",
"441358", "Ellon",
"4418518", "Stornoway",
"4414306", "Market\ Weighton",
"441561", "Laurencekirk",
"441763", "Royston",
"441691", "Oswestry",
"441738", "Perth",
"441309", "Forres",
"441945", "Wisbech",
"441506", "Bathgate",
"441544", "Kington",
"441493", "Great\ Yarmouth",
"441270", "Crewe",
"441747", "Shaftesbury",
"441871", "Castlebay",
"44121", "Birmingham",
"441842", "Thetford",
"4415242", "Hornby",
"441700", "Rothesay",
"441928", "Runcorn",
"4414345", "Haltwhistle",
"442867", "Lisnaskea",
"441409", "Holsworthy",
"441264", "Andover",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441250", "Blairgowrie",
"441286", "Caernarfon",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"4419640", "Hornsea\/Patrington",
"442880", "Carrickmore",
"441340", "Craigellachie\ \(Aberlour\)",
"441383", "Dunfermline",
"441307", "Forfar",
"441878", "Lochboisdale",
"441528", "Laggan",
"4415073", "Louth",
"441944", "West\ Heslerton",
"441749", "Shepton\ Mallet",
"441545", "Llanarth",
"441296", "Aylesbury",
"442890", "Belfast",
"4416865", "Newtown",
"441698", "Motherwell",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441440", "Haverhill",
"441483", "Guildford",
"441407", "Holyhead",
"441858", "Market\ Harborough",
"4419467", "Gosforth",
"4418905", "Ayton",
"44239", "Portsmouth",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441262", "Bridlington",
"4414346", "Hexham",
"4414309", "Market\ Weighton",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441368", "Dunbar",
"4415078", "Alford\ \(Lincs\)",
"4419752", "Alford\ \(Aberdeen\)",
"4413390", "Aboyne\/Ballater",
"441978", "Wrexham",
"441571", "Lochinver",
"441821", "Kinrossie",
"441542", "Keith",
"441806", "Shetland",
"442826", "Northern\ Ireland",
"441844", "Thame",
"441631", "Oban",
"441798", "Pulborough",
"44116", "Leicester",
"4414344", "Bellingham",
"441433", "Hathersage",
"44114701", "Sheffield",
"441951", "Colonsay",
"441361", "Duns",
"441558", "Llandeilo",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"4416866", "Newtown",
"4412297", "Millom",
"441788", "Rugby",
"4418904", "Coldstream",
"4417687", "Keswick",
"441845", "Thirsk",
"44238", "Southampton",
"441461", "Gretna",
"44114709", "Sheffield",
"4418906", "Ayton",
"441663", "New\ Mills",
"441236", "Coatbridge",
"442830", "Newry",
"441638", "Newmarket",
"441828", "Coupar\ Angus",
"441578", "Lauder",
"441600", "Monmouth",
"441647", "Moretonhampstead",
"441942", "Wigan",
"4416864", "Llanidloes",
"441971", "Scourie",
"441623", "Mansfield",
"4418513", "Stornoway",
"441289", "Berwick\-upon\-Tweed",
"441406", "Holbeach",
"441593", "Lybster",
"441255", "Clacton\-on\-Sea",
"441444", "Haywards\ Heath",
"442885", "Ballygawley",
"4413391", "Aboyne\/Ballater",
"441833", "Barnard\ Castle",
"441297", "Axminster",
"441983", "Isle\ of\ Wight",
"441275", "Clevedon",
"442894", "Antrim",
"441306", "Dorking",
"441344", "Bracknell",
"442879", "Magherafelt",
"4413392", "Aboyne",
"441509", "Loughborough",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441993", "Witney",
"441287", "Guisborough",
"441445", "Gairloch",
"441254", "Blackburn",
"442884", "Northern\ Ireland",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441773", "Ripley",
"441428", "Haslemere",
"442866", "Enniskillen",
"441260", "Congleton",
"441141", "Sheffield",
"441753", "Slough",
"441299", "Bewdley",
"441746", "Bridgnorth",
"441909", "Worksop",
"4414305", "North\ Cave",
"441704", "Southport",
"441583", "Carradale",
"441328", "Fakenham",
"442877", "Limavady",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441274", "Bradford",
"442895", "Belfast",
"441540", "Kingussie",
"441564", "Lapworth",
"441780", "Stamford",
"441355", "East\ Kilbride",
"441743", "Shrewsbury",
"441756", "Skipton",
"4418475", "Thurso",
"441915", "Sunderland",
"441586", "Campbeltown",
"441497", "Hay\-on\-Wye",
"441862", "Tain",
"441550", "Llandovery",
"441767", "Sandy",
"441389", "Dumbarton",
"441475", "Greenock",
"441206", "Colchester",
"441608", "Chipping\ Norton",
"441570", "Lampeter",
"441455", "Hinckley",
"441244", "Chester",
"442847", "Northern\ Ireland",
"441776", "Stranraer",
"441397", "Fort\ William",
"442838", "Portadown",
"44151", "Liverpool",
"441630", "Market\ Drayton",
"441142", "Sheffield",
"441375", "Grays\ Thurrock",
"441489", "Bishops\ Waltham",
"441914", "Tyneside",
"4418510", "Great\ Bernera\/Stornoway",
"441986", "Bungay",
"441950", "Sandwick",
"441360", "Killearn",
"441474", "Gravesend",
"441303", "Folkestone",
"441769", "South\ Molton",
"441387", "Dumfries",
"441565", "Knutsford",
"441422", "Halifax",
"4414235", "Harrogate",
"441354", "Chatteris",
"441499", "Inveraray",
"441790", "Spilsby",
"441228", "Carlisle",
"442849", "Northern\ Ireland",
"441626", "Newton\ Abbot",
"441460", "Chard",
"4419753", "Strathdon",
"441403", "Horsham",
"441970", "Aberystwyth",
"441487", "Warboys",
"441322", "Dartford",
"441454", "Chipping\ Sodbury",
"441245", "Chelmsford",
"4414373", "Clynderwen\ \(Clunderwen\)",
"4419648", "Hornsea",
"441420", "Alton",
"441855", "Ballachulish",
"441268", "Basildon",
"441233", "Ashford\ \(Kent\)",
"441666", "Malmesbury",
"4412294", "Barrow\-in\-Furness",
"441952", "Telford",
"441362", "Dereham",
"441684", "Malvern",
"4418907", "Ayton",
"441889", "Rugeley",
"441972", "Glenborrodale",
"4412296", "Barrow\-in\-Furness",
"441677", "Bedale",
"441320", "Fort\ Augustus",
"441939", "Wem",
"4417684", "Pooley\ Bridge",
"441548", "Kingsbridge",
"441695", "Skelmersdale",
"4414239", "Boroughbridge",
"441792", "Swansea",
"441462", "Hitchin",
"441924", "Wakefield",
"4416867", "Llanidloes",
"441729", "Settle",
"441875", "Tranent",
"441525", "Leighton\ Buzzard",
"441685", "Merthyr\ Tydfil",
"441803", "Torquay",
"441887", "Aberfeldy",
"441261", "Banff",
"441782", "Stoke\-on\-Trent",
"442823", "Northern\ Ireland",
"441854", "Ullapool",
"441659", "Sanquhar",
"4418512", "Stornoway",
"441436", "Helensburgh",
"4413393", "Aboyne",
"441140", "Sheffield",
"441937", "Wetherby",
"441925", "Warrington",
"441874", "Brecon",
"441524", "Lancaster",
"441727", "St\ Albans",
"441539", "Kendal",
"441572", "Oakham",
"441822", "Tavistock",
"4418479", "Tongue",
"4418511", "Great\ Bernera\/Stornoway",
"441899", "Biggar",
"441694", "Church\ Stretton",
"441948", "Whitchurch",
"4414347", "Hexham",
"441772", "Preston",
"441934", "Weston\-super\-Mare",
"441308", "Bridport",
"441527", "Redditch",
"441877", "Callander",
"441535", "Keighley",
"441146", "Sheffield",
"4412290", "Barrow\-in\-Furness\/Millom",
"4418903", "Coldstream",
"441895", "Uxbridge",
"441992", "Lea\ Valley",
"441202", "Bournemouth",
"441697", "Brampton",
"4414377", "Haverfordwest",
"441724", "Scunthorpe",
"441675", "Coleshill",
"441330", "Banchory",
"441929", "Wareham",
"44114705", "Sheffield",
"441582", "Luton",
"441655", "Maybole",
"4415075", "Spilsby\ \(Horncastle\)",
"441408", "Golspie",
"441866", "Kilchrenan",
"4416863", "Llanidloes",
"441223", "Cambridge",
"441752", "Plymouth",
"441689", "Orpington",
"441884", "Tiverton",
"441857", "Sanday",
"441592", "Kirkcaldy",
"441326", "Falmouth",
"441674", "Montrose",
"441529", "Sleaford",
"441737", "Redhill",
"441879", "Scarinish",
"441725", "Rockbourne",
"441832", "Clopton",
"441622", "Maidstone",
"44114704", "Sheffield",
"441935", "Yeovil",
"441534", "Jersey",
"441748", "Richmond",
"441301", "Arrochar",
"441885", "Pencombe",
"442868", "Kesh",
"4414343", "Haltwhistle",
"441654", "Machynlleth",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441859", "Harris",
"441982", "Builth\ Wells",
"441603", "Norwich",
"441687", "Mallaig",
"4413397", "Ballater",
"442828", "Larne",
"441620", "North\ Berwick",
"441249", "Chippenham",
"441796", "Pitlochry",
"441808", "Tomatin",
"441377", "Driffield",
"441466", "Huntly",
"441395", "Budleigh\ Salterton",
"441590", "Lymington",
"442845", "Northern\ Ireland",
"4412292", "Barrow\-in\-Furness",
"441484", "Huddersfield",
"441830", "Kirkwhelpington",
"441457", "Glossop",
"442311", "Southampton",
"441980", "Amesbury",
"441477", "Holmes\ Chapel",
"441569", "Stonehaven",
"441765", "Ripon",
"441917", "Sunderland",
"441943", "Guiseley",
"441366", "Downham\ Market",
"441495", "Pontypool",
"4412291", "Barrow\-in\-Furness\/Millom",
"441384", "Dudley",
"441357", "Strathaven",
"441967", "Strontian",
"441200", "Clitheroe",
"442844", "Downpatrick",
"441576", "Lockerbie",
"441485", "Hunstanton",
"441379", "Diss",
"441332", "Derby",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441770", "Isle\ of\ Arran",
"442821", "Martinstown",
"4415079", "Alford\ \(Lincs\)",
"441263", "Cromer",
"441636", "Newark\-on\-Trent",
"441394", "Felixstowe",
"4418514", "Great\ Bernera",
"4419757", "Strathdon",
"441919", "Durham",
"441786", "Stirling",
"441750", "Selkirk",
"4413882", "Stanhope\ \(Eastgate\)",
"441479", "Grantown\-on\-Spey",
"441567", "Killin",
"44114703", "Sheffield",
"4418516", "Great\ Bernera",
"441432", "Hereford",
"4414308", "Market\ Weighton",
"441580", "Cranbrook",
"441359", "Pakenham",
"441969", "Leyburn",
"441764", "Crieff",
"441543", "Cannock",
"441556", "Castle\ Douglas",
"441494", "High\ Wycombe",
"442822", "Northern\ Ireland",
"441707", "Welwyn\ Garden\ City",
"442899", "Northern\ Ireland",
"441740", "Sedgefield",
"4418478", "Thurso",
"441349", "Dingwall",
"4419756", "Strathdon",
"441277", "Brentwood",
"4418517", "Stornoway",
"441553", "Kings\ Lynn",
"441295", "Banbury",
"441546", "Lochgilphead",
"441905", "Worcester",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"442887", "Dungannon",
"4415395", "Grange\-over\-Sands",
"441823", "Taunton",
"441573", "Kelso",
"4419754", "Alford\ \(Aberdeen\)",
"441284", "Bury\ St\ Edmunds",
"441257", "Coppull",
"44287", "Northern\ Ireland",
"441449", "Stowmarket",
"441431", "Helmsdale",
"4414342", "Bellingham",
"441633", "Newport",
"441668", "Bamburgh",
"442897", "Saintfield",
"441363", "Crediton",
"441953", "Wymondham",
"441946", "Whitehaven",
"441709", "Rotherham",
"441505", "Johnstone",
"441294", "Ardrossan",
"441904", "York",
"441300", "Cerne\ Abbas",
"4414238", "Harrogate",
"441279", "Bishops\ Stortford",
"4418902", "Coldstream",
"441347", "Easingwold",
"4416861", "Newtown\/Llanidloes",
"441259", "Alloa",
"441793", "Swindon",
"441661", "Prudhoe",
"44292", "Cardiff",
"441463", "Inverness",
"441438", "Stevenage",
"44113", "Leeds",
"442889", "Fivemiletown",
"441400", "Honington",
"441285", "Cirencester",
"4416862", "Llanidloes",
"4419649", "Hornsea",
"4418901", "Coldstream\/Ayton",
"441302", "Doncaster",
"4419645", "Hornsea",
"441778", "Bourne",
"4413396", "Ballater",
"441621", "Maldon",
"44247", "Coventry",
"441644", "New\ Galloway",
"441208", "Bodmin",
"441606", "Northwich",
"441591", "Llanwrtyd\ Wells",
"44291", "Cardiff",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441323", "Eastbourne",
"441588", "Bishops\ Castle",
"441981", "Wormbridge",
"442310", "Portsmouth",
"44114707", "Sheffield",
"441758", "Pwllheli",
"4413394", "Ballater",
"4418900", "Coldstream\/Ayton",
"441598", "Lynton",
"4412293", "Millom",
"441863", "Ardgay",
"441838", "Dalmally",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441226", "Barnsley",
"442820", "Ballycastle",
"441628", "Maidenhead",
"441771", "Maud",
"4416860", "Newtown\/Llanidloes",
"4414376", "Haverfordwest",
"441751", "Pickering",
"441143", "Sheffield",
"4417683", "Appleby",
"441988", "Wigtown",
"441581", "New\ Luce",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;