#! perl
# Copyright (C) 2007, The Perl Foundation.
# $Id: 113-init_optimize.04.t 21449 2007-09-21 09:32:00Z paultcochrane $
# 113-init_optimize.04.t

use strict;
use warnings;
use Test::More tests => 12;
use Carp;
use lib qw( lib t/configure/testlib );
use_ok('config::init::defaults');
use_ok('config::init::optimize');
use Parrot::Configure;
use Parrot::Configure::Options qw( process_options );
use Parrot::Configure::Test qw( test_step_thru_runstep);

my $args = process_options(
    {
        argv => [q{--optimize=O2}],
        mode => q{configure},
    }
);

my $conf = Parrot::Configure->new();

test_step_thru_runstep( $conf, q{init::defaults}, $args );

my ( $task, $step_name, @step_params, $step, $ret );
my $pkg = q{init::optimize};

$conf->add_steps($pkg);
$conf->options->set( %{$args} );
$task        = $conf->steps->[1];
$step_name   = $task->step;
@step_params = @{ $task->params };

$step = $step_name->new();
ok( defined $step, "$step_name constructor returned defined value" );
isa_ok( $step, $step_name );
ok( $step->description(), "$step_name has description" );

$ret = $step->runstep($conf);
ok( defined $ret, "$step_name runstep() returned defined value" );

pass("Keep Devel::Cover happy");
pass("Completed all tests in $0");

################### DOCUMENTATION ###################

=head1 NAME

113-init_optimize.04.t - test config::init::optimize

=head1 SYNOPSIS

    % prove t/configure/113-init_optimize.04.t

=head1 DESCRIPTION

The files in this directory test functionality used by F<Configure.pl>.

The tests in this file test subroutines exported by
config::init::optimize in the case where a specific optimization is
passed as the value of C<--optimize>.

=head1 AUTHOR

James E Keenan

=head1 SEE ALSO

config::init::optimize, F<Configure.pl>.

=cut

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
