# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 24;
BEGIN { use_ok('Lingua::PT::Inflect') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

is(sing2plural(''),'');

is(sing2plural('mesa'),'mesas');
is(sing2plural('pai'),'pais');

is(sing2plural('flor'),'flores');
is(sing2plural('lquene'),'lquenes');
is(sing2plural('pas'),'pases');
is(sing2plural('raz'),'razes');

is(sing2plural('mo'),'mos');
is(sing2plural('co'),'ces');
is(sing2plural('leo'),'lees');

is(sing2plural('homem'),'homens');
is(sing2plural('tom'),'tons');

is(sing2plural('casal'),'casais');
is(sing2plural('boi'),'bois');
is(sing2plural('paul'),'pauis');

is(sing2plural('anel'),'anis');
is(sing2plural('farol'),'faris');

TODO: {

local $TODO = 'check if the last sillable is tonic or not, and decide on that';

#is(sing2plural('funil'),'funis');
#is(sing2plural('barril'),'barris');

#is(sing2plural('rptil'),'rpteis');
#is(sing2plural('fssil'),'fsseis');

}

is(sing2plural('gas'),'gases');
is(sing2plural('francs'),'franceses');

is(sing2plural('lpis'),'lpis');
is(sing2plural('pires'),'pires');
is(sing2plural('prex'),'prex');
is(sing2plural('inox'),'inox');
