package WWW::Salesforce::Constants;
{
    use strict;
    use warnings;

    #thanks to Jun Shimizu
    BEGIN {
        use vars qw(%TYPES);
        %TYPES = (
            'Account' => {
                'AccountNumber'        => 'xsd:string',
                'Active__c'            => 'xsd:string',
                'AnnualRevenue'        => 'xsd:double',
                'BillingCity'          => 'xsd:string',
                'BillingCountry'       => 'xsd:string',
                'BillingPostalCode'    => 'xsd:string',
                'BillingState'         => 'xsd:string',
                'BillingStreet'        => 'xsd:string',
                'CreatedById'          => 'xsd:string',
                'CreatedDate'          => 'xsd:dateTime',
                'CustomerPriority__c'  => 'xsd:string',
                'Description'          => 'xsd:string',
                'Fax'                  => 'xsd:string',
                'Industry'             => 'xsd:string',
                'LastModifiedById'     => 'xsd:string',
                'LastModifiedDate'     => 'xsd:dateTime',
                'Name'                 => 'xsd:string',
                'NumberOfEmployees'    => 'xsd:int',
                'NumberofLocations__c' => 'xsd:double',
                'OwnerId'              => 'xsd:string',
                'Ownership'            => 'xsd:string',
                'ParentId'             => 'xsd:string',
                'Phone'                => 'xsd:string',
                'Rating'               => 'xsd:string',
                'SLAExpirationDate__c' => 'xsd:date',
                'SLASerialNumber__c'   => 'xsd:string',
                'SLA__c'               => 'xsd:string',
                'ShippingCity'         => 'xsd:string',
                'ShippingCountry'      => 'xsd:string',
                'ShippingPostalCode'   => 'xsd:string',
                'ShippingState'        => 'xsd:string',
                'ShippingStreet'       => 'xsd:string',
                'Sic'                  => 'xsd:string',
                'Site'                 => 'xsd:string',
                'SystemModstamp'       => 'xsd:dateTime',
                'TickerSymbol'         => 'xsd:string',
                'Type'                 => 'xsd:string',
                'UpsellOpportunity__c' => 'xsd:string',
                'Website'              => 'xsd:string',
            },
            'AccountContactRole' => {
                'AccountId'        => 'xsd:string',
                'ContactId'        => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrimary'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Role'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'AccountPartner' => {
                'AccountFromId'    => 'xsd:string',
                'AccountToId'      => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrimary'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OpportunityId'    => 'xsd:string',
                'Role'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'AccountShare' => {
                'AccountAccessLevel'     => 'xsd:string',
                'AccountId'              => 'xsd:string',
                'CaseAccessLevel'        => 'xsd:string',
                'LastModifiedById'       => 'xsd:string',
                'LastModifiedDate'       => 'xsd:dateTime',
                'OpportunityAccessLevel' => 'xsd:string',
                'RowCause'               => 'xsd:string',
                'UserOrGroupId'          => 'xsd:string',
            },
            'Approval' => {
                'ApproveComment'   => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OwnerId'          => 'xsd:string',
                'ParentId'         => 'xsd:string',
                'RequestComment'   => 'xsd:string',
                'Status'           => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Asset' => {
                'AccountId'           => 'xsd:string',
                'ContactId'           => 'xsd:string',
                'CreatedById'         => 'xsd:string',
                'CreatedDate'         => 'xsd:dateTime',
                'Description'         => 'xsd:string',
                'InstallDate'         => 'xsd:date',
                'IsCompetitorProduct' => 'xsd:boolean',
                'LastModifiedById'    => 'xsd:string',
                'LastModifiedDate'    => 'xsd:dateTime',
                'Name'                => 'xsd:string',
                'Price'               => 'xsd:double',
                'Product2Id'          => 'xsd:string',
                'PurchaseDate'        => 'xsd:date',
                'Quantity'            => 'xsd:double',
                'SerialNumber'        => 'xsd:string',
                'Status'              => 'xsd:string',
                'SystemModstamp'      => 'xsd:dateTime',
                'UsageEndDate'        => 'xsd:date',
            },
            'AssignmentRule' => {
                'Active'           => 'xsd:boolean',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'RuleType'         => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Attachment' => {
                'Body'             => 'xsd:base64Binary',
                'BodyLength'       => 'xsd:int',
                'ContentType'      => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrivate'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'OwnerId'          => 'xsd:string',
                'ParentId'         => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'BusinessHours' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'FridayEnd'        => 'xsd:string',
                'FridayStart'      => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MondayEnd'        => 'xsd:string',
                'MondayStart'      => 'xsd:string',
                'SaturdayEnd'      => 'xsd:string',
                'SaturdayStart'    => 'xsd:string',
                'SundayEnd'        => 'xsd:string',
                'SundayStart'      => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'ThursdayEnd'      => 'xsd:string',
                'ThursdayStart'    => 'xsd:string',
                'TuesdayEnd'       => 'xsd:string',
                'TuesdayStart'     => 'xsd:string',
                'WednesdayEnd'     => 'xsd:string',
                'WednesdayStart'   => 'xsd:string',
            },
            'BusinessProcess' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Description'      => 'xsd:string',
                'IsActive'         => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'TableEnumOrId'    => 'xsd:string',
            },
            'Campaign' => {
                'ActualCost'               => 'xsd:double',
                'AmountAllOpportunities'   => 'xsd:double',
                'AmountWonOpportunities'   => 'xsd:double',
                'BudgetedCost'             => 'xsd:double',
                'CreatedById'              => 'xsd:string',
                'CreatedDate'              => 'xsd:dateTime',
                'Description'              => 'xsd:string',
                'EndDate'                  => 'xsd:date',
                'ExpectedResponse'         => 'xsd:double',
                'ExpectedRevenue'          => 'xsd:double',
                'Field1__c'                => 'xsd:string',
                'IsActive'                 => 'xsd:boolean',
                'LastModifiedById'         => 'xsd:string',
                'LastModifiedDate'         => 'xsd:dateTime',
                'Name'                     => 'xsd:string',
                'NumberOfContacts'         => 'xsd:int',
                'NumberOfConvertedLeads'   => 'xsd:int',
                'NumberOfLeads'            => 'xsd:int',
                'NumberOfOpportunities'    => 'xsd:int',
                'NumberOfResponses'        => 'xsd:int',
                'NumberOfWonOpportunities' => 'xsd:int',
                'NumberSent'               => 'xsd:double',
                'OwnerId'                  => 'xsd:string',
                'StartDate'                => 'xsd:date',
                'Status'                   => 'xsd:string',
                'SystemModstamp'           => 'xsd:dateTime',
                'Type'                     => 'xsd:string',
            },
            'CampaignMember' => {
                'CampaignId'         => 'xsd:string',
                'ContactId'          => 'xsd:string',
                'CreatedById'        => 'xsd:string',
                'CreatedDate'        => 'xsd:dateTime',
                'FirstRespondedDate' => 'xsd:date',
                'HasResponded'       => 'xsd:boolean',
                'LastModifiedById'   => 'xsd:string',
                'LastModifiedDate'   => 'xsd:dateTime',
                'LeadId'             => 'xsd:string',
                'Status'             => 'xsd:string',
                'SystemModstamp'     => 'xsd:dateTime',
            },
            'Case' => {
                'AssetId'                 => 'xsd:string',
                'CaseNumber'              => 'xsd:string',
                'ClosedDate'              => 'xsd:dateTime',
                'ContactId'               => 'xsd:string',
                'CreatedById'             => 'xsd:string',
                'CreatedDate'             => 'xsd:dateTime',
                'Description'             => 'xsd:string',
                'EngineeringReqNumber__c' => 'xsd:string',
                'IsClosed'                => 'xsd:boolean',
                'IsEscalated'             => 'xsd:boolean',
                'LastModifiedById'        => 'xsd:string',
                'LastModifiedDate'        => 'xsd:dateTime',
                'Origin'                  => 'xsd:string',
                'OwnerId'                 => 'xsd:string',
                'PotentialLiability__c'   => 'xsd:string',
                'Priority'                => 'xsd:string',
                'Product__c'              => 'xsd:string',
                'Reason'                  => 'xsd:string',
                'SLAViolation__c'         => 'xsd:string',
                'Status'                  => 'xsd:string',
                'Subject'                 => 'xsd:string',
                'SuppliedCompany'         => 'xsd:string',
                'SuppliedEmail'           => 'xsd:string',
                'SuppliedName'            => 'xsd:string',
                'SuppliedPhone'           => 'xsd:string',
                'SystemModstamp'          => 'xsd:dateTime',
                'Type'                    => 'xsd:string',
            },
            'CaseComment' => {
                'CommentBody'    => 'xsd:string',
                'CreatedById'    => 'xsd:string',
                'CreatedDate'    => 'xsd:dateTime',
                'IsPublished'    => 'xsd:boolean',
                'ParentId'       => 'xsd:string',
                'SystemModstamp' => 'xsd:dateTime',
            },
            'CaseHistory' => {
                'CaseId'      => 'xsd:string',
                'CreatedById' => 'xsd:string',
                'CreatedDate' => 'xsd:dateTime',
                'Field'       => 'xsd:string',
                'NewValue'    => 'xsd:anyType',
                'OldValue'    => 'xsd:anyType',
            },
            'CaseShare' => {
                'CaseAccessLevel'  => 'xsd:string',
                'CaseId'           => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'RowCause'         => 'xsd:string',
                'UserOrGroupId'    => 'xsd:string',
            },
            'CaseSolution' => {
                'CaseId'         => 'xsd:string',
                'CreatedById'    => 'xsd:string',
                'CreatedDate'    => 'xsd:dateTime',
                'SolutionId'     => 'xsd:string',
                'SystemModstamp' => 'xsd:dateTime',
            },
            'CaseStatus' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsClosed'         => 'xsd:boolean',
                'IsDefault'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MasterLabel'      => 'xsd:string',
                'SortOrder'        => 'xsd:int',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Contact' => {
                'AccountId'         => 'xsd:string',
                'AssistantName'     => 'xsd:string',
                'AssistantPhone'    => 'xsd:string',
                'Birthdate'         => 'xsd:date',
                'CreatedById'       => 'xsd:string',
                'CreatedDate'       => 'xsd:dateTime',
                'Department'        => 'xsd:string',
                'Description'       => 'xsd:string',
                'Email'             => 'xsd:string',
                'Fax'               => 'xsd:string',
                'FirstName'         => 'xsd:string',
                'HomePhone'         => 'xsd:string',
                'Languages__c'      => 'xsd:string',
                'LastCURequestDate' => 'xsd:dateTime',
                'LastCUUpdateDate'  => 'xsd:dateTime',
                'LastModifiedById'  => 'xsd:string',
                'LastModifiedDate'  => 'xsd:dateTime',
                'LastName'          => 'xsd:string',
                'LeadSource'        => 'xsd:string',
                'Level__c'          => 'xsd:string',
                'MailingCity'       => 'xsd:string',
                'MailingCountry'    => 'xsd:string',
                'MailingPostalCode' => 'xsd:string',
                'MailingState'      => 'xsd:string',
                'MailingStreet'     => 'xsd:string',
                'MobilePhone'       => 'xsd:string',
                'OtherCity'         => 'xsd:string',
                'OtherCountry'      => 'xsd:string',
                'OtherPhone'        => 'xsd:string',
                'OtherPostalCode'   => 'xsd:string',
                'OtherState'        => 'xsd:string',
                'OtherStreet'       => 'xsd:string',
                'OwnerId'           => 'xsd:string',
                'Phone'             => 'xsd:string',
                'ReportsToId'       => 'xsd:string',
                'Salutation'        => 'xsd:string',
                'SystemModstamp'    => 'xsd:dateTime',
                'Title'             => 'xsd:string',
            },
            'Contract' => {
                'AccountId'             => 'xsd:string',
                'ActivatedById'         => 'xsd:string',
                'ActivatedDate'         => 'xsd:dateTime',
                'BillingCity'           => 'xsd:string',
                'BillingCountry'        => 'xsd:string',
                'BillingPostalCode'     => 'xsd:string',
                'BillingState'          => 'xsd:string',
                'BillingStreet'         => 'xsd:string',
                'CompanySignedDate'     => 'xsd:date',
                'CompanySignedId'       => 'xsd:string',
                'ContractNumber'        => 'xsd:string',
                'ContractTerm'          => 'xsd:int',
                'CreatedById'           => 'xsd:string',
                'CreatedDate'           => 'xsd:dateTime',
                'CustomerSignedDate'    => 'xsd:date',
                'CustomerSignedId'      => 'xsd:string',
                'CustomerSignedTitle'   => 'xsd:string',
                'Description'           => 'xsd:string',
                'EndDate'               => 'xsd:date',
                'LastApprovedDate'      => 'xsd:dateTime',
                'LastModifiedById'      => 'xsd:string',
                'LastModifiedDate'      => 'xsd:dateTime',
                'OwnerExpirationNotice' => 'xsd:string',
                'OwnerId'               => 'xsd:string',
                'SpecialTerms'          => 'xsd:string',
                'StartDate'             => 'xsd:date',
                'Status'                => 'xsd:string',
                'StatusCode'            => 'xsd:string',
                'SystemModstamp'        => 'xsd:dateTime',
            },
            'ContractContactRole' => {
                'ContactId'        => 'xsd:string',
                'ContractId'       => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrimary'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Role'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'ContractStatus' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsDefault'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MasterLabel'      => 'xsd:string',
                'SortOrder'        => 'xsd:int',
                'StatusCode'       => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'CustomObject1__c' => {
                'Contact__c'       => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Field1__c'        => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Lead__c'          => 'xsd:string',
                'Name'             => 'xsd:string',
                'OwnerId'          => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Customer__c' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'OwnerId'          => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Document' => {
                'AuthorId'          => 'xsd:string',
                'Body'              => 'xsd:base64Binary',
                'BodyLength'        => 'xsd:int',
                'ContentType'       => 'xsd:string',
                'CreatedById'       => 'xsd:string',
                'CreatedDate'       => 'xsd:dateTime',
                'Description'       => 'xsd:string',
                'FolderId'          => 'xsd:string',
                'IsInternalUseOnly' => 'xsd:boolean',
                'IsPublic'          => 'xsd:boolean',
                'Keywords'          => 'xsd:string',
                'LastModifiedById'  => 'xsd:string',
                'LastModifiedDate'  => 'xsd:dateTime',
                'Name'              => 'xsd:string',
                'SystemModstamp'    => 'xsd:dateTime',
                'Type'              => 'xsd:string',
                'Url'               => 'xsd:string',
            },
            'EntityHistory' => {
                'CreatedById'       => 'xsd:string',
                'CreatedDate'       => 'xsd:dateTime',
                'FieldName'         => 'xsd:string',
                'NewValue'          => 'xsd:anyType',
                'OldValue'          => 'xsd:anyType',
                'ParentId'          => 'xsd:string',
                'ParentSobjectType' => 'xsd:string',
            },
            'Event' => {
                'AccountId'                => 'xsd:string',
                'ActivityDate'             => 'xsd:date',
                'ActivityDateTime'         => 'xsd:dateTime',
                'CreatedById'              => 'xsd:string',
                'CreatedDate'              => 'xsd:dateTime',
                'Description'              => 'xsd:string',
                'DurationInMinutes'        => 'xsd:int',
                'IsAllDayEvent'            => 'xsd:boolean',
                'IsChild'                  => 'xsd:boolean',
                'IsGroupEvent'             => 'xsd:boolean',
                'IsPrivate'                => 'xsd:boolean',
                'IsRecurrence'             => 'xsd:boolean',
                'LastModifiedById'         => 'xsd:string',
                'LastModifiedDate'         => 'xsd:dateTime',
                'Location'                 => 'xsd:string',
                'OwnerId'                  => 'xsd:string',
                'RecurrenceActivityId'     => 'xsd:string',
                'RecurrenceDayOfMonth'     => 'xsd:int',
                'RecurrenceDayOfWeekMask'  => 'xsd:int',
                'RecurrenceEndDateOnly'    => 'xsd:date',
                'RecurrenceInstance'       => 'xsd:string',
                'RecurrenceInterval'       => 'xsd:int',
                'RecurrenceMonthOfYear'    => 'xsd:string',
                'RecurrenceStartDateTime'  => 'xsd:dateTime',
                'RecurrenceTimeZoneSidKey' => 'xsd:string',
                'RecurrenceType'           => 'xsd:string',
                'ShowAs'                   => 'xsd:string',
                'Subject'                  => 'xsd:string',
                'SystemModstamp'           => 'xsd:dateTime',
                'WhatId'                   => 'xsd:string',
                'WhoId'                    => 'xsd:string',
            },
            'EventAttendee' => {
                'AttendeeId'       => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'EventId'          => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'RespondedDate'    => 'xsd:dateTime',
                'Response'         => 'xsd:string',
                'Status'           => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'FiscalYearSettings' => {
                'IsStandardYear'     => 'xsd:boolean',
                'Name'               => 'xsd:string',
                'PeriodId'           => 'xsd:string',
                'PeriodLabelScheme'  => 'xsd:string',
                'PeriodPrefix'       => 'xsd:string',
                'QuarterLabelScheme' => 'xsd:string',
                'QuarterPrefix'      => 'xsd:string',
                'SystemModstamp'     => 'xsd:dateTime',
                'WeekLabelScheme'    => 'xsd:string',
                'YearType'           => 'xsd:string',
            },
            'Folder' => {
                'AccessType'       => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsReadonly'       => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'Type'             => 'xsd:string',
            },
            'Group' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Email'            => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'OwnerId'          => 'xsd:string',
                'RelatedId'        => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'Type'             => 'xsd:string',
            },
            'GroupMember' => {
                'GroupId'        => 'xsd:string',
                'SystemModstamp' => 'xsd:dateTime',
                'UserOrGroupId'  => 'xsd:string',
            },
            'Lead' => {
                'AnnualRevenue'          => 'xsd:double',
                'City'                   => 'xsd:string',
                'Company'                => 'xsd:string',
                'ConvertedAccountId'     => 'xsd:string',
                'ConvertedContactId'     => 'xsd:string',
                'ConvertedDate'          => 'xsd:date',
                'ConvertedOpportunityId' => 'xsd:string',
                'Country'                => 'xsd:string',
                'CreatedById'            => 'xsd:string',
                'CreatedDate'            => 'xsd:dateTime',
                'CurrentGenerators__c'   => 'xsd:string',
                'Description'            => 'xsd:string',
                'Email'                  => 'xsd:string',
                'Fax'                    => 'xsd:string',
                'Field1__c'              => 'xsd:date',
                'FirstName'              => 'xsd:string',
                'Industry'               => 'xsd:string',
                'IsConverted'            => 'xsd:boolean',
                'IsUnreadByOwner'        => 'xsd:boolean',
                'LastModifiedById'       => 'xsd:string',
                'LastModifiedDate'       => 'xsd:dateTime',
                'LastName'               => 'xsd:string',
                'LeadSource'             => 'xsd:string',
                'MobilePhone'            => 'xsd:string',
                'NumberOfEmployees'      => 'xsd:int',
                'NumberofLocations__c'   => 'xsd:double',
                'OwnerId'                => 'xsd:string',
                'Phone'                  => 'xsd:string',
                'PostalCode'             => 'xsd:string',
                'Primary__c'             => 'xsd:string',
                'ProductInterest__c'     => 'xsd:string',
                'Rating'                 => 'xsd:string',
                'SICCode__c'             => 'xsd:string',
                'Salutation'             => 'xsd:string',
                'State'                  => 'xsd:string',
                'Status'                 => 'xsd:string',
                'Street'                 => 'xsd:string',
                'SystemModstamp'         => 'xsd:dateTime',
                'Title'                  => 'xsd:string',
                'Website'                => 'xsd:string',
            },
            'LeadShare' => {
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'LeadAccessLevel'  => 'xsd:string',
                'LeadId'           => 'xsd:string',
                'RowCause'         => 'xsd:string',
                'UserOrGroupId'    => 'xsd:string',
            },
            'LeadStatus' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsConverted'      => 'xsd:boolean',
                'IsDefault'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MasterLabel'      => 'xsd:string',
                'SortOrder'        => 'xsd:int',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'MailmergeTemplate' => {
                'Body'             => 'xsd:base64Binary',
                'BodyLength'       => 'xsd:int',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Description'      => 'xsd:string',
                'Filename'         => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'LastUsedDate'     => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Note' => {
                'Body'             => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrivate'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OwnerId'          => 'xsd:string',
                'ParentId'         => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'Title'            => 'xsd:string',
            },
            'Opportunity' => {
                'AccountId'                     => 'xsd:string',
                'Amount'                        => 'xsd:double',
                'CampaignId'                    => 'xsd:string',
                'CloseDate'                     => 'xsd:date',
                'CreatedById'                   => 'xsd:string',
                'CreatedDate'                   => 'xsd:dateTime',
                'CurrentGenerators__c'          => 'xsd:string',
                'DeliveryInstallationStatus__c' => 'xsd:string',
                'Description'                   => 'xsd:string',
                'ExpectedRevenue'               => 'xsd:double',
                'ForecastCategory'              => 'xsd:string',
                'HasOpportunityLineItem'        => 'xsd:boolean',
                'IsClosed'                      => 'xsd:boolean',
                'IsPrivate'                     => 'xsd:boolean',
                'IsWon'                         => 'xsd:boolean',
                'LastModifiedById'              => 'xsd:string',
                'LastModifiedDate'              => 'xsd:dateTime',
                'LeadSource'                    => 'xsd:string',
                'MainCompetitors__c'            => 'xsd:string',
                'Name'                          => 'xsd:string',
                'NextStep'                      => 'xsd:string',
                'OrderNumber__c'                => 'xsd:string',
                'OwnerId'                       => 'xsd:string',
                'Pricebook2Id'                  => 'xsd:string',
                'PricebookId'                   => 'xsd:string',
                'Probability'                   => 'xsd:double',
                'StageName'                     => 'xsd:string',
                'SystemModstamp'                => 'xsd:dateTime',
                'TotalOpportunityQuantity'      => 'xsd:double',
                'TrackingNumber__c'             => 'xsd:string',
                'Type'                          => 'xsd:string',
            },
            'OpportunityCompetitor' => {
                'CompetitorName'   => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OpportunityId'    => 'xsd:string',
                'Strengths'        => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'Weaknesses'       => 'xsd:string',
            },
            'OpportunityContactRole' => {
                'ContactId'        => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrimary'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OpportunityId'    => 'xsd:string',
                'Role'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'OpportunityHistory' => {
                'Amount'           => 'xsd:double',
                'CloseDate'        => 'xsd:date',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'ExpectedRevenue'  => 'xsd:double',
                'ForecastCategory' => 'xsd:string',
                'OpportunityId'    => 'xsd:string',
                'Probability'      => 'xsd:double',
                'StageName'        => 'xsd:string',
            },
            'OpportunityLineItem' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Description'      => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'ListPrice'        => 'xsd:double',
                'OpportunityId'    => 'xsd:string',
                'PricebookEntryId' => 'xsd:string',
                'ProductId'        => 'xsd:string',
                'Quantity'         => 'xsd:double',
                'ServiceDate'      => 'xsd:date',
                'SortOrder'        => 'xsd:int',
                'SystemModstamp'   => 'xsd:dateTime',
                'TotalPrice'       => 'xsd:double',
                'UnitPrice'        => 'xsd:double',
            },
            'OpportunityPartner' => {
                'AccountToId'      => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrimary'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OpportunityId'    => 'xsd:string',
                'Role'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'OpportunityShare' => {
                'LastModifiedById'       => 'xsd:string',
                'LastModifiedDate'       => 'xsd:dateTime',
                'OpportunityAccessLevel' => 'xsd:string',
                'OpportunityId'          => 'xsd:string',
                'RowCause'               => 'xsd:string',
                'UserOrGroupId'          => 'xsd:string',
            },
            'OpportunityStage' => {
                'CreatedById'        => 'xsd:string',
                'CreatedDate'        => 'xsd:dateTime',
                'DefaultProbability' => 'xsd:double',
                'Description'        => 'xsd:string',
                'ForecastCategory'   => 'xsd:string',
                'IsActive'           => 'xsd:boolean',
                'IsClosed'           => 'xsd:boolean',
                'IsWon'              => 'xsd:boolean',
                'LastModifiedById'   => 'xsd:string',
                'LastModifiedDate'   => 'xsd:dateTime',
                'MasterLabel'        => 'xsd:string',
                'SortOrder'          => 'xsd:int',
                'SystemModstamp'     => 'xsd:dateTime',
            },
            'Organization' => {
                'City'                           => 'xsd:string',
                'ComplianceBccEmail'             => 'xsd:string',
                'Country'                        => 'xsd:string',
                'CreatedById'                    => 'xsd:string',
                'CreatedDate'                    => 'xsd:dateTime',
                'DefaultAccountAndContactAccess' => 'xsd:string',
                'DefaultCalendarAccess'          => 'xsd:string',
                'DefaultCaseAccess'              => 'xsd:string',
                'DefaultLeadAccess'              => 'xsd:string',
                'DefaultLocaleSidKey'            => 'xsd:string',
                'DefaultOpportunityAccess'       => 'xsd:string',
                'DefaultPricebookAccess'         => 'xsd:string',
                'Division'                       => 'xsd:string',
                'Fax'                            => 'xsd:string',
                'FiscalYearStartMonth'           => 'xsd:int',
                'LanguageLocaleKey'              => 'xsd:string',
                'LastModifiedById'               => 'xsd:string',
                'LastModifiedDate'               => 'xsd:dateTime',
                'MaxActionsPerRule'              => 'xsd:int',
                'MaxRulesPerEntity'              => 'xsd:int',
                'Name'                           => 'xsd:string',
                'Phone'                          => 'xsd:string',
                'PostalCode'                     => 'xsd:string',
                'PrimaryContact'                 => 'xsd:string',
                'ReceivesAdminInfoEmails'        => 'xsd:boolean',
                'ReceivesInfoEmails'             => 'xsd:boolean',
                'State'                          => 'xsd:string',
                'Street'                         => 'xsd:string',
                'SystemModstamp'                 => 'xsd:dateTime',
                'UiSkin'                         => 'xsd:string',
                'UsesStartDateAsFiscalYearName'  => 'xsd:boolean',
                'WebToCaseDefaultOrigin'         => 'xsd:string',
            },
            'Partner' => {
                'AccountFromId'    => 'xsd:string',
                'AccountToId'      => 'xsd:string',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsPrimary'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OpportunityId'    => 'xsd:string',
                'Role'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'PartnerRole' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MasterLabel'      => 'xsd:string',
                'ReverseRole'      => 'xsd:string',
                'SortOrder'        => 'xsd:int',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Period' => {
                'EndDate'          => 'xsd:date',
                'IsForecastPeriod' => 'xsd:boolean',
                'Number'           => 'xsd:int',
                'PeriodLabel'      => 'xsd:string',
                'QuarterLabel'     => 'xsd:string',
                'StartDate'        => 'xsd:date',
                'SystemModstamp'   => 'xsd:dateTime',
                'Type'             => 'xsd:string',
            },
            'Pricebook' => {
                'IsActive'         => 'xsd:boolean',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Pricebook2' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Description'      => 'xsd:string',
                'IsActive'         => 'xsd:boolean',
                'IsStandard'       => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'PricebookEntry' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsActive'         => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'Pricebook2Id'     => 'xsd:string',
                'Product2Id'       => 'xsd:string',
                'ProductCode'      => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'UnitPrice'        => 'xsd:double',
                'UseStandardPrice' => 'xsd:boolean',
            },
            'Product' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'DefaultPrice'     => 'xsd:double',
                'Description'      => 'xsd:string',
                'IsActive'         => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'PricebookId'      => 'xsd:string',
                'ProductCode'      => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Product2' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Description'      => 'xsd:string',
                'Family'           => 'xsd:string',
                'IsActive'         => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'ProductCode'      => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Profile' => {
                'CreatedById'                         => 'xsd:string',
                'CreatedDate'                         => 'xsd:dateTime',
                'Description'                         => 'xsd:string',
                'LastModifiedById'                    => 'xsd:string',
                'LastModifiedDate'                    => 'xsd:dateTime',
                'Name'                                => 'xsd:string',
                'PermissionsApiUserOnly'              => 'xsd:boolean',
                'PermissionsConvertLeads'             => 'xsd:boolean',
                'PermissionsCreateMultiforce'         => 'xsd:boolean',
                'PermissionsCustomizeApplication'     => 'xsd:boolean',
                'PermissionsEditActivatedOrders'      => 'xsd:boolean',
                'PermissionsEditEvent'                => 'xsd:boolean',
                'PermissionsEditForecast'             => 'xsd:boolean',
                'PermissionsEditOppLineItemUnitPrice' => 'xsd:boolean',
                'PermissionsEditPublicDocuments'      => 'xsd:boolean',
                'PermissionsEditReadonlyFields'       => 'xsd:boolean',
                'PermissionsEditTask'                 => 'xsd:boolean',
                'PermissionsImportLeads'              => 'xsd:boolean',
                'PermissionsInstallMultiforce'        => 'xsd:boolean',
                'PermissionsManageCases'              => 'xsd:boolean',
                'PermissionsManageCategories'         => 'xsd:boolean',
                'PermissionsManageCssUsers'           => 'xsd:boolean',
                'PermissionsManageDashboards'         => 'xsd:boolean',
                'PermissionsManageLeads'              => 'xsd:boolean',
                'PermissionsManageSelfService'        => 'xsd:boolean',
                'PermissionsManageSolutions'          => 'xsd:boolean',
                'PermissionsManageTerritories'        => 'xsd:boolean',
                'PermissionsManageUsers'              => 'xsd:boolean',
                'PermissionsModifyAllData'            => 'xsd:boolean',
                'PermissionsPasswordNeverExpires'     => 'xsd:boolean',
                'PermissionsPublishMultiforce'        => 'xsd:boolean',
                'PermissionsRunReports'               => 'xsd:boolean',
                'PermissionsSendSitRequests'          => 'xsd:boolean',
                'PermissionsTransferAnyEntity'        => 'xsd:boolean',
                'PermissionsTransferAnyLead'          => 'xsd:boolean',
                'PermissionsUseTeamReassignWizards'   => 'xsd:boolean',
                'PermissionsViewAgentConsole'         => 'xsd:boolean',
                'PermissionsViewAllData'              => 'xsd:boolean',
                'PermissionsViewSetup'                => 'xsd:boolean',
                'SystemModstamp'                      => 'xsd:dateTime',
            },
            'RecordType' => {
                'BusinessProcessId' => 'xsd:string',
                'CreatedById'       => 'xsd:string',
                'CreatedDate'       => 'xsd:dateTime',
                'Description'       => 'xsd:string',
                'IsActive'          => 'xsd:boolean',
                'LastModifiedById'  => 'xsd:string',
                'LastModifiedDate'  => 'xsd:dateTime',
                'Name'              => 'xsd:string',
                'SobjectType'       => 'xsd:string',
                'SystemModstamp'    => 'xsd:dateTime',
            },
            'Scontrol' => {
                'Binary'           => 'xsd:base64Binary',
                'BodyLength'       => 'xsd:int',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Description'      => 'xsd:string',
                'Filename'         => 'xsd:string',
                'HtmlWrapper'      => 'xsd:string',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'Name'             => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'SelfServiceUser' => {
                'ContactId'         => 'xsd:string',
                'CreatedById'       => 'xsd:string',
                'CreatedDate'       => 'xsd:dateTime',
                'Email'             => 'xsd:string',
                'FirstName'         => 'xsd:string',
                'IsActive'          => 'xsd:boolean',
                'LanguageLocaleKey' => 'xsd:string',
                'LastLoginDate'     => 'xsd:dateTime',
                'LastModifiedById'  => 'xsd:string',
                'LastModifiedDate'  => 'xsd:dateTime',
                'LastName'          => 'xsd:string',
                'LocaleSidKey'      => 'xsd:string',
                'SuperUser'         => 'xsd:boolean',
                'SystemModstamp'    => 'xsd:dateTime',
                'TimeZoneSidKey'    => 'xsd:string',
                'Username'          => 'xsd:string',
            },
            'Solution' => {
                'CreatedById'           => 'xsd:string',
                'CreatedDate'           => 'xsd:dateTime',
                'IsPublished'           => 'xsd:boolean',
                'IsPublishedInPublicKb' => 'xsd:boolean',
                'IsReviewed'            => 'xsd:boolean',
                'LastModifiedById'      => 'xsd:string',
                'LastModifiedDate'      => 'xsd:dateTime',
                'OwnerId'               => 'xsd:string',
                'SolutionName'          => 'xsd:string',
                'SolutionNote'          => 'xsd:string',
                'SolutionNumber'        => 'xsd:string',
                'Status'                => 'xsd:string',
                'SystemModstamp'        => 'xsd:dateTime',
            },
            'SolutionStatus' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsDefault'        => 'xsd:boolean',
                'IsReviewed'       => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MasterLabel'      => 'xsd:string',
                'SortOrder'        => 'xsd:int',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'Task' => {
                'AccountId'        => 'xsd:string',
                'ActivityDate'     => 'xsd:date',
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'Description'      => 'xsd:string',
                'IsClosed'         => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'OwnerId'          => 'xsd:string',
                'Priority'         => 'xsd:string',
                'Status'           => 'xsd:string',
                'Subject'          => 'xsd:string',
                'SystemModstamp'   => 'xsd:dateTime',
                'WhatId'           => 'xsd:string',
                'WhoId'            => 'xsd:string',
            },
            'TaskPriority' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsDefault'        => 'xsd:boolean',
                'IsHighPriority'   => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MasterLabel'      => 'xsd:string',
                'SortOrder'        => 'xsd:int',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'TaskStatus' => {
                'CreatedById'      => 'xsd:string',
                'CreatedDate'      => 'xsd:dateTime',
                'IsClosed'         => 'xsd:boolean',
                'IsDefault'        => 'xsd:boolean',
                'LastModifiedById' => 'xsd:string',
                'LastModifiedDate' => 'xsd:dateTime',
                'MasterLabel'      => 'xsd:string',
                'SortOrder'        => 'xsd:int',
                'SystemModstamp'   => 'xsd:dateTime',
            },
            'User' => {
                'Alias'                         => 'xsd:string',
                'City'                          => 'xsd:string',
                'CompanyName'                   => 'xsd:string',
                'Country'                       => 'xsd:string',
                'CreatedById'                   => 'xsd:string',
                'CreatedDate'                   => 'xsd:dateTime',
                'Department'                    => 'xsd:string',
                'Division'                      => 'xsd:string',
                'Email'                         => 'xsd:string',
                'EmailEncodingKey'              => 'xsd:string',
                'EmployeeNumber'                => 'xsd:string',
                'Fax'                           => 'xsd:string',
                'FirstName'                     => 'xsd:string',
                'IsActive'                      => 'xsd:boolean',
                'LanguageLocaleKey'             => 'xsd:string',
                'LastLoginDate'                 => 'xsd:dateTime',
                'LastModifiedById'              => 'xsd:string',
                'LastModifiedDate'              => 'xsd:dateTime',
                'LastName'                      => 'xsd:string',
                'LocaleSidKey'                  => 'xsd:string',
                'MobilePhone'                   => 'xsd:string',
                'OfflinePdaTrialExpirationDate' => 'xsd:dateTime',
                'OfflineTrialExpirationDate'    => 'xsd:dateTime',
                'Phone'                         => 'xsd:string',
                'PostalCode'                    => 'xsd:string',
                'ProfileId'                     => 'xsd:string',
                'ReceivesAdminInfoEmails'       => 'xsd:boolean',
                'ReceivesInfoEmails'            => 'xsd:boolean',
                'State'                         => 'xsd:string',
                'Street'                        => 'xsd:string',
                'SystemModstamp'                => 'xsd:dateTime',
                'TimeZoneSidKey'                => 'xsd:string',
                'Title'                         => 'xsd:string',
                'UserPermissionsMarketingUser'  => 'xsd:boolean',
                'UserPermissionsOfflineUser'    => 'xsd:boolean',
                'UserRoleId'                    => 'xsd:string',
                'Username'                      => 'xsd:string',
            },
            'UserRole' => {
                'CaseAccessForAccountOwner'        => 'xsd:string',
                'LastModifiedById'                 => 'xsd:string',
                'LastModifiedDate'                 => 'xsd:dateTime',
                'Name'                             => 'xsd:string',
                'OpportunityAccessForAccountOwner' => 'xsd:string',
                'ParentRoleId'                     => 'xsd:string',
                'RollupDescription'                => 'xsd:string',
                'SystemModstamp'                   => 'xsd:dateTime',
            },
            'WebLink' => {
                'CreatedById'       => 'xsd:string',
                'CreatedDate'       => 'xsd:dateTime',
                'EncodingKey'       => 'xsd:string',
                'HasMenubar'        => 'xsd:boolean',
                'HasScrollbars'     => 'xsd:boolean',
                'HasToolbar'        => 'xsd:boolean',
                'Height'            => 'xsd:int',
                'IsResizable'       => 'xsd:boolean',
                'LastModifiedById'  => 'xsd:string',
                'LastModifiedDate'  => 'xsd:dateTime',
                'LinkType'          => 'xsd:string',
                'Name'              => 'xsd:string',
                'OpenType'          => 'xsd:string',
                'PageOrSobjectType' => 'xsd:string',
                'Position'          => 'xsd:string',
                'ScontrolId'        => 'xsd:string',
                'ShowsLocation'     => 'xsd:boolean',
                'ShowsStatus'       => 'xsd:boolean',
                'SystemModstamp'    => 'xsd:dateTime',
                'Url'               => 'xsd:string',
                'Width'             => 'xsd:int',
            },
            'sObject' => {},
        );
    }
}

#magically delicious
1;
