/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.gui;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.ttt.salt.TBXException;
import org.ttt.salt.TBXFile;
import org.ttt.salt.gui.TBXValidator;

public class TBXResults
extends JFrame
implements WindowListener {
    public static final String RCSID = "$Id: TBXResults.java 88 2008-11-18 03:10:15Z lanhel $";
    public static final String TITLE_PROPERTY = "Title";
    public static final String TITLE_CHANGE = "TitleChange";
    private JScrollPane scroll;

    public TBXResults(File file, TBXFile tbx, String log) {
        super(String.format("%1s %2$tF %2$tT", file.getName(), new Date()));
        ResourceBundle bndl = ResourceBundle.getBundle("org.ttt.salt.gui.TBXValidator");
        JTextArea text = new JTextArea();
        text.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        if (tbx != null) {
            for (TBXException err : tbx.getInvalidatingExceptions()) {
                text.append(err.getLocalizedMessage());
                text.append("\n");
            }
        }
        text.append("\n");
        text.append("****************************************\n");
        text.append("Log messages.\n\n");
        text.append(log);
        this.setTextProperties(text);
        this.scroll = new JScrollPane(text, 22, 32);
        this.add(this.scroll);
        this.addWindowListener(this);
        this.addWindowListener(TBXValidator.getInstance());
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    private void setTextProperties(JTextArea text) {
        int fontSize = 12;
        int columns = 80;
        int rows = 50;
        text.setFont(new Font("Serif", 0, 12));
        text.setColumns(80);
        text.setRows(50);
    }

    public void windowOpened(WindowEvent evt) {
        this.scroll.getVerticalScrollBar().setValue(this.scroll.getVerticalScrollBar().getMinimum());
        this.scroll.getHorizontalScrollBar().setValue(this.scroll.getHorizontalScrollBar().getMinimum());
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void save() {
    }

    public void print(PrinterJob printjob) throws PrinterException {
        Printer printer = new Printer(printjob);
        printjob.printDialog();
        printjob.setPageable(printer);
        printjob.print();
    }

    private class Printer
    implements Pageable,
    Printable {
        private PrinterJob printjob;

        public Printer(PrinterJob pj) {
            this.printjob = pj;
        }

        public int getNumberOfPages() {
            return -1;
        }

        public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
            return this.printjob.defaultPage();
        }

        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            return this;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            System.out.println("print " + pageIndex);
            return pageIndex < 3 ? 0 : 1;
        }
    }
}

