/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.gui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ISOReference {
    public static final String RCSID = "$Id: ISOReference.java 1 2008-05-23 03:51:58Z lanhel $";
    private static final ISOReference INSTANCE = new ISOReference();
    private SortedSet<ISO639> iso639;
    private SortedSet<ISO3166> iso3166;

    public static ISOReference getInstance() {
        return INSTANCE;
    }

    private ISOReference() {
    }

    public SortedSet<ISO639> get639() {
        if (this.iso639 == null) {
            try {
                this.iso639 = new TreeSet<ISO639>();
                LineNumberReader rdr = this.getResourceReader("ISO639.txt");
                String line = rdr.readLine();
                while (line != null) {
                    if (!line.matches("^\\s*(#.*)?")) {
                        String[] parts = line.split("\\|");
                        String alpha2 = parts[0].trim();
                        String alpha3 = parts[1].trim();
                        String name = parts[2].trim();
                        ISO639 o = new ISO639(alpha2, alpha3, name);
                        this.iso639.add(o);
                    }
                    line = rdr.readLine();
                }
            }
            catch (IOException err) {
                Logger.getLogger("org.ttt.salt.gui").log(Level.WARNING, "ISO 639 table is invalid.", err);
            }
        }
        return this.iso639;
    }

    public SortedSet<ISO3166> get3166() {
        if (this.iso3166 == null) {
            try {
                this.iso3166 = new TreeSet<ISO3166>();
                LineNumberReader rdr = this.getResourceReader("ISO3166.txt");
                String line = rdr.readLine();
                while (line != null) {
                    if (!line.matches("^\\s*(#.*)?")) {
                        String[] parts = line.split("\\|");
                        String alpha2 = parts[0].trim();
                        String alpha3 = parts[1].trim();
                        String name = parts[2].trim();
                        ISO3166 o = new ISO3166(alpha2, alpha3, name);
                        this.iso3166.add(o);
                    }
                    line = rdr.readLine();
                }
            }
            catch (IOException err) {
                Logger.getLogger("org.ttt.salt.gui").log(Level.WARNING, "ISO 3166 table is invalid.", err);
            }
        }
        return this.iso3166;
    }

    private LineNumberReader getResourceReader(String name) throws IOException {
        InputStream instm = this.getClass().getResourceAsStream(name);
        if (instm == null) {
            throw new IOException("Resource not found: " + name);
        }
        InputStreamReader in = new InputStreamReader(instm, "UTF-8");
        LineNumberReader ret = new LineNumberReader(in);
        return ret;
    }

    public SortedSet<String> get639alpha2() {
        TreeSet<String> ret = new TreeSet<String>();
        SortedSet<ISO639> set = this.get639();
        for (ISO639 o : set) {
            if (!o.alpha2.equals("")) continue;
            ret.add(o.alpha2);
        }
        return ret;
    }

    public SortedSet<String> get3166alpha2() {
        TreeSet<String> ret = new TreeSet<String>();
        SortedSet<ISO3166> set = this.get3166();
        for (ISO3166 o : set) {
            if (!o.alpha2.equals("")) continue;
            ret.add(o.alpha2);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ISO3166
    implements Comparable<ISO3166> {
        private final String alpha2;
        private final String alpha3;
        private final String name;

        private ISO3166(String a2, String a3, String n) {
            this.alpha2 = a2;
            this.alpha3 = a3;
            this.name = n;
        }

        public String getAlpha2() {
            return this.alpha2;
        }

        public String getAlpha3() {
            return this.alpha3;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(ISO3166 o) {
            return this.alpha2.compareTo(o.alpha2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ISO639
    implements Comparable<ISO639> {
        private final String alpha2;
        private final String alpha3;
        private final String name;

        private ISO639(String a2, String a3, String n) {
            this.alpha2 = a2;
            this.alpha3 = a3;
            this.name = n;
        }

        public String getAlpha2() {
            return this.alpha2;
        }

        public String getAlpha3() {
            return this.alpha3;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.format("%3s | %4s | %s", this.alpha2, this.alpha3, this.name);
        }

        @Override
        public int compareTo(ISO639 o) {
            return this.alpha2.compareTo(o.alpha2);
        }
    }
}

