/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flyingtitans.util.GetOpt;
import org.ttt.salt.Configuration;
import org.ttt.salt.TBXException;
import org.ttt.salt.TBXFile;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    public static final String RCSID = "$Id";
    private static final String OPTIONS = "h";
    private static final String[] LONG_OPTIONS = new String[]{"nolang", "help", "version", "environment", "lang=", "country=", "variant=", "loglevel="};
    private static final Logger LOGGER;
    private static Main instance;
    private final GetOpt options = new GetOpt();

    public static void main(String[] argv) {
        try {
            instance = new Main(argv);
            Main obj = Main.getInstance();
            obj.dispatch();
        }
        catch (IllegalArgumentException err) {
            System.err.println("Illegal command line parameter.");
            System.err.println("Use -h for more information.");
        }
        catch (FileNotFoundException err) {
            System.err.println(err.getLocalizedMessage());
        }
        catch (SecurityException err) {
            System.err.println(err);
        }
        catch (IOException err) {
            System.err.println(err);
        }
        catch (SAXException err) {
            System.err.println(err);
        }
    }

    public static Main getInstance() {
        return instance;
    }

    private Main(String[] argv) throws IOException {
        this.options.parseArgs(argv, OPTIONS, LONG_OPTIONS);
        String lang = this.options.containsOption("--lang") ? this.options.getParameter("--lang") : Locale.getDefault().getLanguage();
        String country = this.options.containsOption("--country") ? this.options.getParameter("--country") : Locale.getDefault().getCountry();
        String variant = this.options.containsOption("--variant") ? this.options.getParameter("--variant") : Locale.getDefault().getVariant();
        Locale def = new Locale(lang, country, variant);
        Locale.setDefault(def);
        String loglevel = this.options.containsOption("--loglevel") ? this.options.getParameter("--loglevel") : "SEVERE";
        Level level = Level.parse(loglevel);
        LOGGER.setLevel(level);
    }

    private void dispatch() throws IOException, SAXException {
        boolean exit = false;
        ResourceBundle bundle = ResourceBundle.getBundle("org.ttt.salt.Main");
        if (this.options.containsOption("-h") || this.options.containsOption("--help")) {
            System.out.println(bundle.getString("Usage"));
            exit = true;
        }
        if (this.options.containsOption("--version")) {
            String rcsidpat = "^\\$Id(: (\\S+) (\\d+) (\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2})Z (\\S+))?\\s*\\$$";
            Matcher matcher = Pattern.compile(rcsidpat).matcher(RCSID);
            if (matcher.matches() && matcher.group(1) != null) {
                String version = matcher.group(3);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.set(Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)));
                String msg = bundle.getString("Version");
                System.out.println(MessageFormat.format(msg, matcher.group(3), cal.getTime()));
            } else {
                String msg = bundle.getString("VersionBad");
                System.out.println(MessageFormat.format(msg, RCSID));
            }
            exit = true;
        }
        if (this.options.containsOption("--environment")) {
            System.out.println("Arguments:");
            System.out.println("\t" + this.options);
            System.out.println();
            System.out.println("Environment:");
            String spaces = "                            ";
            TreeMap<Object, Object> env = new TreeMap<Object, Object>(System.getProperties());
            Iterator iter = env.keySet().iterator();
            while (iter.hasNext()) {
                String name = iter.next().toString();
                String value = env.get(name).toString();
                System.out.print(name);
                int pad = name.length() < spaces.length() ? name.length() : spaces.length() - 1;
                System.out.print(spaces.substring(pad));
                System.out.print("= ");
                System.out.println(value);
            }
            System.out.println();
        }
        if (exit) {
            System.exit(0);
        }
        this.checkSystem();
        this.initSystem();
        List<String> paths = Arrays.asList(this.options.getArgs());
        List<File> files = this.checkFiles(paths);
        this.processFiles(files);
    }

    private void checkSystem() {
    }

    private void initSystem() {
    }

    private List<File> checkFiles(List<String> files) throws IOException {
        ResourceBundle bundle = ResourceBundle.getBundle("org.ttt.salt.Main");
        ArrayList<File> ret = new ArrayList<File>();
        ListIterator<String> paths = files.listIterator();
        while (paths.hasNext()) {
            String msg;
            String path = paths.next();
            File file = path.startsWith(File.separator) ? new File(path) : new File(System.getProperty("user.dir"), path);
            Object[] args = new Object[]{file};
            if (!file.exists()) {
                msg = MessageFormat.format(bundle.getString("PathMissing"), args);
                System.out.println(msg);
                continue;
            }
            if (!file.isFile()) {
                msg = MessageFormat.format(bundle.getString("PathNotNormalFile"), args);
                System.out.println(msg);
                continue;
            }
            if (!file.canRead()) {
                msg = MessageFormat.format(bundle.getString("PathSecurityViolation"), args);
                System.out.println(msg);
                continue;
            }
            ret.add(file);
        }
        return ret;
    }

    private void processFiles(List<File> files) throws IOException, SAXException {
        Configuration config = new Configuration();
        config.setCheckLang(!this.options.containsOption("--nolang"));
        for (File file : files) {
            String msg;
            Object[] args;
            ResourceBundle bundle;
            TBXFile dv = new TBXFile(file.toURI().toURL(), (Configuration)config.clone());
            dv.parseAndValidate();
            if (dv.isValid()) {
                bundle = ResourceBundle.getBundle("org.ttt.salt.Main");
                args = new Object[]{file};
                msg = MessageFormat.format(bundle.getString("FileValid"), args);
                System.out.println(msg);
                continue;
            }
            bundle = ResourceBundle.getBundle("org.ttt.salt.Main");
            args = new Object[]{file.getCanonicalPath()};
            msg = MessageFormat.format(bundle.getString("FileInvalid"), args);
            System.out.println(msg);
            for (TBXException err : dv.getInvalidatingExceptions()) {
                System.err.println(err.getLocalizedMessage());
                LOGGER.log(Level.FINER, "", err);
            }
        }
    }

    static {
        try {
            System.setProperty("java.util.logging.config.class", "org.ttt.salt.LogConfig");
            LogManager.getLogManager().readConfiguration();
        }
        catch (IOException err) {
            err.printStackTrace();
            System.exit(1);
        }
        LOGGER = Logger.getLogger("org.ttt.salt");
    }
}

