use strict;
use inc::Module::Install;
use Module::Install::GithubMeta;
use Module::Install::ReadmeFromPod;
use Module::Install::AutoLicense;
name 'smokebrew';
author 'Chris Williams <chris@bingosnet.co.uk>';
version_from 'lib/App/SmokeBrew.pm';
abstract_from 'bin/smokebrew';
readme_from 'bin/smokebrew';
license 'perl';
auto_license holder => 'Chris Williams';
perl_version '5.006';
build_requires 'Test::More' => 0.47;
build_requires 'File::Temp' => '0.22';
requires 'Archive::Extract' => '0.40';
requires 'Config::INI::Reader' => '0.014';
requires 'CPAN::Perl::Releases' => '0.02';
requires 'Devel::PatchPerl' => '0.24';
requires 'File::Fetch' => '0.24';
requires 'File::Path' => '2.08';
requires 'File::pushd' => '1.00';
requires 'File::Spec' => '3.31';
requires 'IPC::Cmd' => '0.58';
requires 'List::MoreUtils' => '0.22';
requires 'Log::Message::Simple' => '0.06';
requires 'Module::CoreList' => '2.49';
requires 'Module::Load::Conditional' => '0.38';
requires 'Module::Pluggable' => '3.9';
requires 'Moose' => '1.03';
requires 'Moose::Role' => '1.03';
requires 'Moose::Util::TypeConstraints' => '1.03';
requires 'MooseX::ConfigFromFile' => '0.02';
requires 'MooseX::Getopt' => '0.27';
requires 'MooseX::Types::Email' => '0.003';
requires 'MooseX::Types::Moose' => '0.21';
requires 'MooseX::Types::Path::Class' => '0.05';
requires 'MooseX::Types::URI' => '0.03';
requires 'Parse::CPAN::Meta' => '1.40';
requires 'Perl::Version' => '1.009';
requires 'URI' => '1.54';
auto_provides;
githubmeta;
clean_files 'dist smokebrew.cfg';
makemaker_args(dist => { PREOP => "$^X ./tools/git-log.pl > ./Changes" });
install_script 'bin/smokebrew';
WriteAll();
