use strict;
use warnings;
use Test::More;

use Dua;

{
    my $dua = Dua->new;

    is $dua->name, 'UNKNOWN', 'blank';
    ok !$dua->is_bot;
    ok !$dua->is_ios;
    ok !$dua->is_android;
    ok !$dua->is_linux;
    ok !$dua->is_windows;
}

{
    my $dua = Dua->new('-');

    is $dua->name, 'UNKNOWN', '-';
    ok !$dua->is_bot;
    ok !$dua->is_ios;
    ok !$dua->is_android;
    ok !$dua->is_linux;
    ok !$dua->is_windows;
}

{
    my $dua = Dua::parse('Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)');

    is $dua->name, 'Googlebot', 'function call';
    ok $dua->is_bot;
    ok !$dua->is_ios;
    ok !$dua->is_android;
    ok !$dua->is_linux;
    ok !$dua->is_windows;
}

{
    my $dua = Dua->parse('Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)');

    is $dua->name, 'Googlebot', 'function call';
    ok $dua->is_bot;
    ok !$dua->is_ios;
    ok !$dua->is_android;
    ok !$dua->is_linux;
    ok !$dua->is_windows;
}

done_testing;
