package Date::Easy;

use strict;
use warnings;
use autodie;

our $VERSION = '0.01_01'; # TRIAL VERSION

use Date::Easy::Date ();
use Date::Easy::Datetime ();

use Exporter;
use parent 'Exporter';
our @EXPORT = ( @Date::Easy::Date::EXPORT_OK, @Date::Easy::Datetime::EXPORT_OK, );


sub import
{
	Date::Easy::Date->import(':all');
	Date::Easy::Datetime->import(':all', @_[1..$#_]);
	@_ = (shift);
	goto &Exporter::import;
}



1;

# ABSTRACT: easy dates with Time::Piece compatibility
# COPYRIGHT

__END__

=pod

=head1 NAME

Date::Easy - easy dates with Time::Piece compatibility

=head1 VERSION

This document describes version 0.01_01 of Date::Easy.

=head1 DESCRIPTION

More complete docs coming soon.  For now, refer to my blog series
I<L<A Date with CPAN|http://blogs.perl.org/users/buddy_burden/2015/09/a-date-with-cpan-part-1-state-of-the-union.html>>.

=for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Perldoc

You can find documentation for this module with the perldoc command.

  perldoc Date::Easy

=head2 Bugs / Feature Requests

		This module is on GitHub.  Feel free to fork and submit patches.  Please note that I develop
		via TDD (Test-Driven Development), so a patch that includes a failing test is much more
		likely to get accepted (or least likely to get accepted more quickly).

		If you just want to report a problem or suggest a feature, that's okay too.  You can create
		an issue on GitHub here: L<http://github.com/barefootcoder/date-easy/issues>.

=head2 Source Code

none
L<https://github.com/barefootcoder/date-easy>

  git clone https://github.com/barefootcoder/date-easy.git

=head1 AUTHOR

Buddy Burden <barefootcoder@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Buddy Burden.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
