package Acme::CPANAuthors::BackPAN::OneHundred;
use strict;
use warnings;

{
    no strict "vars";
    $VERSION = "1.00";
}

use Acme::CPANAuthors::Register (

    'SHARYANTO'     => 'Steven Haryanto',
    'TOBYINK'       => 'Toby Inkster',
    'RJBS'          => 'Ricardo SIGNES',
    'ADAMK'         => 'Adam Kennedy',
    'ZOFFIX'        => 'Zoffix Znet',
    'TOKUHIROM'     => 'Tokuhiro Matsuno',
    'MIYAGAWA'      => 'Tatsuhiko Miyagawa',
    'BINGOS'        => 'Chris Williams',
    'FLORA'         => 'Florian Ragwitz',
    'SMUELLER'      => 'Steffen Mueller',
    'MARCEL'        => 'Marcel Gruenauer',
    'DAGOLDEN'      => 'David Golden',
    'INGY'          => 'Ingy dot Net',
    'BOBTFISH'      => 'Tomas Doran',
    'NUFFIN'        => 'Yuval Kogman',
    'ETHER'         => 'Karen Etheridge',
    'DMAKI'         => 'Daisuke Maki',
    'GUGOD'         => 'Liu Kang Min',
    'DROLSKY'       => 'Dave Rolsky',
    'BDFOY'         => 'brian d foy',
    'AUTRIJUS'      => 'Audrey Tang',
    'KENTNL'        => 'Kent Fredric',
    'RSAVAGE'       => 'Ron Savage',
    'SIMON'         => 'Simon Cozens',
    'SHLOMIF'       => 'Shlomi Fish',
    'LBROCARD'      => 'Leon Brocard',
    'FAYLAND'       => 'Fayland Lin',
    'MRAMBERG'      => 'Marcus Ramberg',
    'PEVANS'        => 'Paul Evans',
    'BARBIE'        => 'Barbie',
    'MLEHMANN'      => 'Marc Lehmann',
    'SALVA'         => 'Salvador Fandino Garcia',
    'SZABGAB'       => 'Gabor Szabo',
    'LEOCHARRE'     => 'Leo Charre',
    'DMUEY'         => 'Daniel Muey',

);

q<
We are programmed just to do
Anything you want us to

We are the robots, we are the robots
We are the robots, we are the robots

Lyrics copyright Ralf Htter
>

__END__

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::BackPAN::OneHundred - The CPAN Authors who have 100+ distributions on BackPAN

=head1 DESCRIPTION

This class provides a hash of CPAN authors' PAUSE ID and name to be 
used with the C<Acme::CPANAuthors> module.

This module was created to capture all those CPAN Authors who have valiantly
submitted their modules and distributions to CPAN, and now have the honour of
having submitted 100 or more distributions to CPAN. 

Note that the CPAN authors listed here may not be maintaining 100 or more
distributions on CPAN, but have submitted 100 or more distributions to PAUSE, 
where some older distributions may have been deprecated or adopted by other 
authors. The numbers here represent the number of distributions a CPAN author 
has listed on BackPAN.

See L<http://backpan.cpantesters.org>.

=head1 THE AUTHORS

   1.  430  SHARYANTO     Steven Haryanto
   2.  299  TOBYINK       Toby Inkster
   3.  290  RJBS          Ricardo SIGNES
   4.  287  ADAMK         Adam Kennedy
   5.  269  ZOFFIX        Zoffix Znet
   6.  249  TOKUHIROM     Tokuhiro Matsuno
   7.  230  MIYAGAWA      Tatsuhiko Miyagawa
   8.  210  BINGOS        Chris Williams
   9.  207  FLORA         Florian Ragwitz
  10.  189  SMUELLER      Steffen Mueller
  11.  182  MARCEL        Marcel Gruenauer
  12.  177  DAGOLDEN      David Golden
  13.  176  INGY          Ingy dot Net
  14.  172  BOBTFISH      Tomas Doran
  15.  161  NUFFIN        Yuval Kogman
  16.  138  ETHER         Karen Etheridge
  17.  137  DMAKI         Daisuke Maki
  18.  135  GUGOD         Liu Kang Min
  19.  134  DROLSKY       Dave Rolsky
  20.  126  BDFOY         brian d foy
  21.  125  AUTRIJUS      Audrey Tang
  22.  125  KENTNL        Kent Fredric
  23.  123  RSAVAGE       Ron Savage
  24.  121  SIMON         Simon Cozens
  25.  113  SHLOMIF       Shlomi Fish
  26.  111  LBROCARD      Leon Brocard
  27.  111  FAYLAND       Fayland Lin
  28.  110  MRAMBERG      Marcus Ramberg
  29.  109  PEVANS        Paul Evans
  30.  107  BARBIE        Barbie
  31.  106  MLEHMANN      Marc Lehmann
  32.  106  SALVA         Salvador Fandino Garcia
  33.  104  SZABGAB       Gabor Szabo
  34.  101  LEOCHARRE     Leo Charre
  35.  101  DMUEY         Daniel Muey

List last updated: 2014-06-01T07:48:11

=head1 MAINTENANCE

If you are aware of any CPAN author that has attained the heady heights of 100
distributions on CPAN, and who is not listed here, please send me their ID/name
via email or RT, and I will update the module. If there are any mistakes, 
please contact me as soon as possible, and I'll amend the entry right away.

=head1 SEE ALSO

L<Acme::CPANAuthors> - Main class to manipulate this one

L<Acme::CPANAuthors::CPAN::OneHundred> - 100+ distributions on CPAN.

=head1 SUPPORT

Bugs, patches and feature requests can be reported at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Acme-CPANAuthors-BackPAN-OneHundred>

=item * GitHub

L<http://github.com/barbie/acme-cpanauthors-cpan-onehundred>

=back

There are no known bugs at the time of this release. However, if you spot a
bug or are experiencing difficulties that are not explained within the POD
documentation, please send an email to barbie@cpan.org or submit a bug to 
the RT queue. However, it would help greatly if you are able to pinpoint 
problems or even supply a patch. 

Fixes are dependent upon their severity and my availability. Should a fix 
not be forthcoming, please feel free to (politely) remind me.

=head1 ACKNOWLEDGEMENTS

Thanks to Kenichi Ishigaki for writing C<Acme::CPANAuthors>.

=head1 AUTHOR

  Barbie, <barbie@cpan.org>
  for Miss Barbell Productions <http://www.missbarbell.co.uk>.

=head1 COPYRIGHT & LICENSE

  Copyright 2014 Barbie for Miss Barbell Productions.

  This distribution is free software; you can redistribute it and/or
  modify it under the Artistic License 2.0.

=cut
