use ExtUtils::MakeMaker;
WriteMakefile(
	NAME             => "PEF::Front",
	AUTHOR           => "Anton Petrusevich",
	VERSION          => "0.01",
	LICENSE          => "artistic_2",
	INSTALLDIRS      => 'site',
	MIN_PERL_VERSION => "5.014000",
	META_MERGE       => {
		"meta-spec" => {version => 2},
		resources   => {
			bugtracker => {web => 'https://github.com/jef-sure/pef-front-psgi-dist/issues'},
			repository => {
				type => 'git',
				url  => 'https://github.com/jef-sure/pef-front-psgi-dist.git',
				web  => 'https://github.com/jef-sure/pef-front-psgi-dist',
			},
		},
	},
	PREREQ_PM => {
		'Cache::FastMmap'       => 0,
		'Carp'                  => 0,
		'Data::Dumper'          => 0,
		'Digest::SHA'           => 0,
		'DBIx::Connector'       => "0.52",
		'Exporter'              => 0,
		'Encode'                => 0,
		'Fcntl'                 => 0,
		'File::Basename'        => 0,
		'File::Find'            => 0,
		'FindBin'               => 0,
		'GDBM_File'             => 0,
		'GD::SecurityImage'     => 0,
		'Geo::IPfree'           => 0,
		'JSON'                  => 0,
		'Locale::PO'            => 0,
		'LWP::UserAgent'        => 0,
		'MLDBM'                 => 0,
		'MLDBM::Sync'           => "0.30",
		'POSIX'                 => 0,
		'Regexp::Common'        => 0,
		'Scalar::Util'          => 0,
		'Socket'                => 0,
		'Storable'              => 0,
		'strict'                => 0,
		'Sub::Name'             => 0,
		'Template::Alloy'       => 0,
		'Time::Duration::Parse' => "0.06",
		'Time::HiRes'           => 0,
		'URI'                   => 0,
		'URI::Escape'           => 0,
		'utf8'                  => 0,
		'warnings'              => 0,
		'XML::Simple'           => "2",
		'YAML::XS'              => "0.38",
	},
	TEST_REQUIRES => {'Test::More' => 0},
	test          => {TESTS        => "t/*.t"},
	dist          => {
		DIST_DEFAULT => 'all tardist',
		COMPRESS     => 'gzip -vf',
		SUFFIX       => '.gz',
	},
	clean     => {FILES => '*~',},
	realclean => {FILES => '*~',},
);
