package main;
use Evo;
use Evo::Mdn;
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 550_000 * $ENV{TEST_EVO_PERF};
my $N      = 500_000;

my $mdn    = Evo::Mdn->new;
my $sender = My::Obj->new;
my $me     = My::Obj->new;
$mdn->subscribe($me, $sender, 0, sub { });

my $t = timeit($N, sub { $mdn->broadcast($sender, 'foo') });

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;

{

  package My::Obj;
  use Evo -class;
}

