package main;
use Evo;
use Test::More;
use Evo::Mdn;
use Test::Fatal;

my ($FROM, $MSG);

my $mdn  = Evo::Mdn->new;
my $from = Receiver->new;
my $me   = Receiver->new;

$mdn->subscribe($me, $from);
$mdn->broadcast($from, 'foo');

is $FROM, $from;
is $MSG,  'foo';

# unsubscribe, must be unchanged
$mdn->unsubscribe($me, $from);
$mdn->broadcast($from, 'BAD');
is $FROM, $from;
is $MSG,  'foo';

# must be empty
($FROM, $me, $from) = ();
is_deeply $mdn->senders, {};

{

  package Receiver;
  use Evo -class;

  sub when_message {
    my ($self, $msg, $from) = @_;
    $FROM = $from;
    $MSG  = $msg;
  }
}

done_testing;
