package main;
use Evo ':all';
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 2_600_000 * $ENV{TEST_EVO_PERF};
my $N      = 3000_000;

call {foo => 'MyFoo'}, sub {

  my $t = timeit($N, sub { die unless dep('foo') eq 'MyFoo'; });

  diag timestr $t;
  my $perf = $N / $t->cpu_a;
  ok $perf > $EXPECT, "$perf > $EXPECT";

};

done_testing;
