use Evo;
use Test::More;
use Evo::Spy;

my ($before, $after);
sub before_each { $before = shift }
sub after_each  { $after  = shift }
sub it { $before->(); pop->(); $after->() }

my ($i, $spy, $want);
my @return;
before_each sub {
  $want   = 33;
  @return = ();
  $i      = 0;
  $spy    = Evo::Spy->new(
    sub {
      $i++;
      $want = wantarray;
      return if !defined $want;
      return $want ? (1, 2) : '1-2';
    }
  );
};

after_each sub {
  is @{$spy->calls}, 1;
  is $i, 1;
  is $spy->calls->[0]->{wantarray},     $want;
  is_deeply $spy->calls->[0]->{return}, \@return;
};

it 'must execude fn by fn want scalar', sub {
  push @return, scalar $spy->fn->();
  ok defined $want && !$want;
  is $return[0], '1-2';
};
it 'must execude fn by fn want array', sub {
  @return = $spy->fn->();
  is_deeply \@return, [1, 2];
  ok $want;
};
it 'must execude fn by fn want nothing', sub {
  $spy->fn->();
  ok !defined $want;
};
it 'must execude fn by fn want scalar', sub {
  push @return, scalar $spy->();
  ok defined $want && !$want;
  is $return[0], '1-2';
};
it 'must execude fn by fn want array', sub {
  @return = $spy->();
  is_deeply \@return, [1, 2];
  ok $want;
};
it 'must execude fn by fn want nothing', sub {
  $spy->();
  ok !defined $want;
};


done_testing;
