package Railway::Wrappers;
use Evo;
use Exporter 'import';

our @EXPORT_OK = qw(w_dsl_init);
our %EXPORT_TAGS = (all => \@EXPORT_OK);

sub w_dsl_init () {
  my $dsl_init = sub {
    my ($bldr, $next) = @_;
    sub { $bldr->single('dsl')->call({train => shift}, @_, $next); }
  };
}

1;

# ABSTRACT: A library with wrappers

__END__

=pod

=encoding UTF-8

=head1 NAME

Railway::Wrappers - A library with wrappers

=head1 VERSION

version 0.0170

=head1 DESCRIPTION

A library for wrappers.

=head1 METHODS

=head2 w_dsl_init

Start DSL.
Shifts first argument, save it to dsl_stash under 'train' key,
and invoke method with remaining arguments using L<Evo::Manager/"dsl_init">

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
