package Railway::Way;
use Evo -class;

has stations => sub { [] };

sub add {
  my ($self, $code) = @_;
  push @{$self->stations}, $code;
  $self;
}

sub get {
  my ($self, $index) = @_;
  $self->stations->[$index];
}

1;

# ABSTRACT: A way, a queue of stations

__END__

=pod

=encoding UTF-8

=head1 NAME

Railway::Way - A way, a queue of stations

=head1 VERSION

version 0.0170

=head1 SYNOPSIS

  my $bldr  = Railway::Builder->new;
  my $way   = $bldr->build_way;
  my $train = $bldr->build_train;

  $way->add(sub { say "station1 " })->add(sub { say "station2" });
  $train->way($way)->start;

=head1 DESCRIPTION

An abstract instance that holds your execution code

=head1 ATTRIBUTES

=head2 stations

A queue of stations

=head1 METHODS

=head2 add

  $way->add(sub{})->add(sub {});

Add build a station

=head2 get

Get a station

  my $station = $way->get(0);

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
