package Evo::Class;
use Evo;
use Evo::Class::Base;
use Module::Load;
use Module::Loaded;


my $NAME
  = eval { require Sub::Util; Sub::Util->can('set_subname') } || sub { $_[1] };

my $HAS_XS = !$ENV{NO_EVO_CLASS_XS} && do {
  local $@;
  eval { require Class::XSAccessor; Class::XSAccessor->VERSION('1.19'); };
};


sub _monkey_patch {
  my ($class, %patch) = @_;
  no strict 'refs';    ## no critic
  no warnings 'redefine';
  *{"${class}::$_"} = $NAME->("${class}::$_", $patch{$_}) for keys %patch;
}


sub _new_pure_hash { bless {%{$_[1]}}, ref $_[0] || $_[0] }

# new
if ($HAS_XS) {
  Class::XSAccessor->import(constructor => '_new_xs');
  _monkey_patch 'Evo::Class::Base', new => sub {
    ref $_[1] ? _new_pure_hash(@_) : _new_xs(@_);
  };
}

sub _simple_attrs {
  my ($class, $attrs) = @_;

  return Class::XSAccessor->import(
    class     => $class,
    replace   => 1,
    accessors => $attrs,
    chained   => 1
  ) if $HAS_XS;

  foreach my $attr (@$attrs) {
    _monkey_patch($class, $attr,
      sub { return $_[0]{$attr} if @_ == 1; $_[0]{$attr} = $_[1]; $_[0] });
  }

}

sub attr {
  my ($self, $attrs, $value) = @_;
  return unless (my $class = ref $self || $self) && $attrs;
  $attrs = ref $attrs eq 'ARRAY' ? $attrs : [$attrs];

  Carp::croak('Default has to be a code reference or constant value')
    if ref $value && ref $value ne 'CODE';

  do { Carp::croak(qq{Attribute "$_" invalid}) unless $_ =~ /^[a-zA-Z_]\w*$/ }
    for @$attrs;

  # simple attr, can use xs
  return _simple_attrs($class, $attrs) unless defined $value;

  # Very performance sensitive code with lots of micro-optimizations
  for my $attr (@$attrs) {
    if (ref $value) {
      _monkey_patch $class, $attr, sub {
        return
          exists $_[0]{$attr} ? $_[0]{$attr} : ($_[0]{$attr} = $value->($_[0]))
          if @_ == 1;
        $_[0]{$attr} = $_[1];
        $_[0];
      };
    }
    else {
      _monkey_patch $class, $attr, sub {
        return exists $_[0]{$attr} ? $_[0]{$attr} : ($_[0]{$attr} = $value)
          if @_ == 1;
        $_[0]{$attr} = $_[1];
        $_[0];
      };
    }
  }
}

sub _setup_class {
  my ($class, $target, @bases) = @_;

  mark_as_loaded($target) unless is_loaded($target);
  _monkey_patch $target, 'has', sub { attr($target, @_) };
  _monkey_patch $target, 'extends', sub { _isa($target, @_) };

  return _isa($target, @bases) if @bases;

  no strict 'refs';    ## no critic
  my $isa = \@{"${target}::ISA"};

  # has bases, nothing to do
  return if @$isa;
  push @$isa, 'Evo::Class::Base';
}

sub _isa {
  my ($target, @bases) = @_;
  no strict 'refs';    ## no critic
  my $isa = \@{"${target}::ISA"};

  # delete last :: and push it to isa
  foreach my $base (map { /(.+)::+$/ ? $1 : $_ } @bases) {
    load $base unless is_loaded($base);
    push @$isa, $base;
  }
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Class

=head1 VERSION

version 0.0170

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
