use Evo;
use Test::More;
use Test::Fatal;

use Railway::Way;
use Railway::Train;

my @passed;
my $way
  = Railway::Way->new->add(sub { push @passed, shift })
  ->add(sub { push @passed, 2; })
  ->add(sub { push @passed, 3; shift->power(0) })
  ->add(sub { push @passed, 'bad' });

my $tr = Railway::Train->new(way => $way);
$tr->done(sub {fail})->prepare->run;
is((shift @passed), $tr, 'train is first arg');
is_deeply \@passed, [2, 3], 'right flow';

@passed = ();
$tr     = Railway::Train->new;
$tr->way->add(sub { });
$tr->start(sub { push @passed, shift });
is_deeply \@passed, [$tr], 'passed to finish';

like exception { Railway::Train->new->run }, qr/no power/,
  'not started without prepare';

like exception { Railway::Train->new->power(0) }, qr/same power/i,
  'same power';

done_testing;
