package main;
use Evo;
use Test::More;
use Test::Fatal;
use Evo::Stash::Once;

my ($stash, $me, $key);

sub before_each {
  $stash = Evo::Stash::Once->new;
  $me    = My::Obj->new;
  $key   = My::Obj->new;
}

before_each;

$stash->set($key, $me);
is $stash->get($key), $me;

# weaken
before_each;
$stash->set($key, $me, 1);
is $stash->get($key), $me;

# only once
before_each;
$stash->set($key, $me);
like exception {
  $stash->set($key, $me)
},
  qr /already has/;

{

  package My::Obj;
  use Evo -class;
}

done_testing;
