use Evo;
use Test::More;
use Evo::Mdn;
use Test::Fatal;

my (@MSGS);

{

  package My::Obj;
  use Evo -class;
}

my $mdn    = Evo::Mdn->new;
my $sender = My::Obj->new;
my @rcv;
push @rcv, My::Obj->new for 1 .. 3;

$mdn->subscribe($_, $sender, 0, sub { push @MSGS, $_[2] }) for @rcv;
$mdn->broadcast($sender, 'foo');
is_deeply \@MSGS, ['foo', 'foo', 'foo'];

$mdn->delete_all_subscribers($sender);
$mdn->broadcast($sender, 'BAD');
is_deeply \@MSGS, ['foo', 'foo', 'foo'];

done_testing;
