package Evo::Stash;
use Evo -class;
use Hash::Util::FieldHash;
use Scalar::Util;

has data => sub { {} };

sub new {
  my $self = shift->SUPER::new(@_);
  Hash::Util::FieldHash::fieldhashes($self->data);
  $self;
}

sub set {
  my ($self, $key, $me, $weaken) = @_;
  $self->data->{$key} = $me;
  Scalar::Util::weaken $self->data->{$key} if $weaken;
  $key;
}

sub get {
  my ($self, $key) = @_;
  $self->data->{$key};
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Stash

=head1 VERSION

version 0.0170

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
