package main;
use Evo::Base -strict;
use Test::More;
use Evo::MDN;
use Evo::MDN::Util ':all';
use Test::Fatal;

my ($FROM, $MSG, $DESTROYED);
my $mdn  = Evo::MDN->new;
my $from = Evo::Base->new;

my ($me, $id);

# firstly check if implementation didn't change

# not store
$me = Evo::Base->new;
$mdn->subscribe($me, $from, 0, sub { });
ok is_subscribed $me, $from;

undef $me;
ok !list_subscribers $from;

# store
my $res = 0;
$me = Evo::Base->new;
ok !list_subscribers $from;
$mdn->subscribe($me, $from, 1, sub { $res += $_[1] });
ok is_subscribed $me, $from;
ok is_stored $me,     $from;
undef $me;
$mdn->broadcast($from, 22);
is $res, 22;
ok list_subscribers $from;


done_testing;
