package Evo::Util;
use Evo::Base -strict;

# die outside dsl_call (if dsl_stash not exists)
# die if trying to get unexisting value by key
# die if trying to override existing value in the same dsl_call
sub _dsl_stash {
  my ($name, $self, $key, $val) = @_;
  my $dsl_stash = $self->{$name};
  $dsl_stash or Carp::confess 'Using dsl_stash outside station';
  return $dsl_stash unless $key;

  # get
  unless ($val) {
    Carp::confess "Using dsl_stash with wrong key '$key'"
      unless exists $dsl_stash->{$key};
    return $dsl_stash->{$key} unless $val;
  }

  # set, die if already exists
  Carp::confess "Attemt to override existing key '$key'"
    if exists $dsl_stash->{$key};
  $dsl_stash->{$key} = $val;
  $self;
}

sub run_wrappers {
  my ($mngr, $cb) = (shift, pop);
  my @wrappers = reverse @_;
  foreach my $w (@wrappers) {
    $cb = $w->($mngr, $cb);
  }
  return $cb;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Util

=head1 VERSION

version 0.0158

=head1 DESCRIPTION

Utilites for package. For internal usage

=head1 METHODS

=head2 run_wrappers

Run wrappers in reverse order passing a last argument to each invocation

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
