use Evo::Base -strict;
use Evo;
use Benchmark ':all';
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 300_000;
my $N      = 1000_000;

my $m = Evo::Manager->singleton;
my $k;

my $t = timeit(
  $N,
  sub {
    Evo::asap { $k++ };
  }
);

ok $k = $N, "$k = $N";
diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
