package Evo::Train;
use Evo::Base 'Railway::Train';
use Evo::Manager;

# always dsl_stash train
sub is_dsl_stash($self) {
  return unless $self->manager->dsl_check_stash('train');
  $self->manager->dsl_stash('train') == $self;
}

1;

# ABSTRACT: A train, running engine

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Train - A train, running engine

=head1 VERSION

version 0.0155

=head1 SYNOPSIS

  use Evo::Manager;
  my $mngr  = Evo::Manager->new;
  my $train = $mngr->build_train;

  our $foo = 'Non blocking';

  # will print Non blocking
  $train->asap(
    sub {
      local $foo = 'Blocking';
      $train->asap(sub { say $foo });
    }
  );

=head1 DESCRIPTION

This is a subclass of L<Railway::Train>

=head1 METHODS

=head2 is_dsl_stash

  my $bool = $self->is_dsl_stash;

Returns true if we are in this train, false otherwise

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
