package main;
use Evo::Base -strict;
use Evo::Manager;
use Evo;
use Time::Piece;
use Time::HiRes;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my ($start, $end, $dur);
my $me     = Receiver->new;
my $sender = Evo::Base->new;

#1M 8.5mb 7s
my $N = 1_000_000;

$start = localtime;

for (1 .. $N) {
  Evo::mdn_subscribe $me,     $sender;
  Evo::mdn_broadcast $sender, 'foo';
  Evo::mdn_unsubscribe $me,   $sender;
}

$end = localtime;
$dur = $end - $start;
diag "Build $N:, $dur";
ok $dur< 10;

done_testing;

{

  package Receiver;
  use Evo::Base -base;
  sub when_message($self, $msg, $from) {$msg}
}

