package main;
use Evo::Base -strict;
use Test::More tests => 2;
use Evo ':mdn';

my $from = Foo->new;
my $to   = Foo->new;
my @messages;

mdn_subscribe $to,   $from;
mdn_broadcast $from, 'hello';
mdn_broadcast $from, 'world';
mdn_unsubscribe $to, $from;
mdn_broadcast $from, 'bad';

is_deeply \@messages, [qw(hello world)];

mdn_subscribe $to,   $from;
mdn_broadcast $from, 'cartman';
mdn_unsubscribe_from_all $to;
mdn_broadcast $from, 'bad';

is_deeply \@messages, [qw(hello world cartman)];

{

  package Foo;
  use Evo::Base -base;
  sub when_message { push @messages, $_[1] }
}


