use Evo::Base -strict;
use Test::More tests => 17;
use Test::Fatal;
use Evo::Manager;

my $evo = Evo::Manager->singleton;

like exception { $evo->current }, qr/outside/, 'dies outside dsl';
like exception { $evo->current('foo') }, qr/outside/, 'dies outside dsl';

$evo->dsl_call(
  {foo => 'bar', a => 2, exists => undef},
  sub {

    like exception { $evo->current('bad_key') }, qr/wrong key 'bad_key'/,
      'wrong key';

    like exception { $evo->current('foo' => 'bad') }, qr/existing key 'foo'/,
      'dies on overrides';

    is $evo->current('foo'), 'bar', 'right value';
    is_deeply $evo->current, {foo => 'bar', a => 2, exists => undef},
      'right current';

    is_deeply $evo->check_current, {foo => 'bar', a => 2, exists => undef},
      'right check_current result';
    ok $evo->check_current('foo'),    'exists';
    ok $evo->check_current('exists'), 'exists';
  }
);

# must not die
ok !$evo->check_current, 'lives';
ok !$evo->check_current('foo'), 'lives';


# must be the same object

$evo->dsl_call(
  {foo => 'bar', a => 1},
  sub {
    my $new = Evo::Manager->new;
    is $new->current, $evo->current, 'same current';
    is $new->current('foo'), 'bar', 'same current val';
    ok $new->check_current('foo'), 'same check current check';
    $new->dsl_extend(
      {foo2 => 'bar2'},
      sub {
        is $new->current('foo'),  'bar',  'same extended current';
        is $new->current('foo2'), 'bar2', 'same extended current';
        my $new2 = Evo::Manager->new;
        $new2->dsl_call({}, sub { ok !$new2->current->{foo}, 'new current' });
      }
    );
  }
);

done_testing;

1;
