#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.10 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'USE' => 33,
			'SET' => 69,
			'FILTER' => 29,
			'rawperl' => 68,
			'META' => 28,
			'RAW' => 64,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'VIEW' => 37,
			"{" => 36,
			"\${" => 70,
			'IF' => 49,
			'BLOCK' => 14,
			'perl' => 15,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'REF' => 10,
			'TRY' => 47,
			"[" => 45,
			'THROW' => 8,
			'WHILE' => 7,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'NEXT' => 60,
			'TEXT' => 25,
			'GET' => 59,
			'SWITCH' => 22,
			'FOR' => 21,
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53
		},
		DEFAULT => -3,
		GOTOS => {
			'javascript' => 35,
			'directive' => 72,
			'switch' => 39,
			'loop' => 74,
			'term' => 73,
			'lterm' => 75,
			'item' => 40,
			'filter' => 26,
			'expr' => 27,
			'use' => 66,
			'anonblock' => 65,
			'view' => 31,
			'node' => 30,
			'macro' => 67,
			'assign' => 32,
			'chunk' => 34,
			'try' => 52,
			'template' => 51,
			'statement' => 16,
			'capture' => 50,
			'ident' => 56,
			'defblockname' => 23,
			'atomexpr' => 24,
			'wrapper' => 3,
			'defblock' => 42,
			'sterm' => 4,
			'chunks' => 44,
			'condition' => 43,
			'raw' => 9,
			'atomdir' => 46,
			'block' => 48,
			'setlist' => 13
		}
	},
	{#State 1
		DEFAULT => -38
	},
	{#State 2
		ACTIONS => {
			"\$" => 81,
			'NUMBER' => 85,
			"\"" => 86,
			'IDENT' => 78,
			'FILENAME' => 80,
			'LITERAL' => 84
		},
		GOTOS => {
			'name' => 77,
			'filename' => 82,
			'nameargs' => 79,
			'filepart' => 76,
			'names' => 83
		}
	},
	{#State 3
		DEFAULT => -44
	},
	{#State 4
		DEFAULT => -105
	},
	{#State 5
		ACTIONS => {
			"(" => 5,
			"\"" => 6,
			'IDENT' => 55,
			"\$" => 41,
			'LITERAL' => 18,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70,
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45
		},
		GOTOS => {
			'ident' => 87,
			'sterm' => 4,
			'expr' => 89,
			'assign' => 88,
			'term' => 73,
			'item' => 40,
			'lterm' => 75,
			'node' => 30
		}
	},
	{#State 6
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 90
		}
	},
	{#State 7
		ACTIONS => {
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			"(" => 5,
			'IDENT' => 55,
			"\"" => 6,
			"\$" => 41,
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10
		},
		GOTOS => {
			'expr' => 91,
			'node' => 30,
			'ident' => 93,
			'term' => 73,
			'sterm' => 4,
			'item' => 40,
			'lterm' => 75
		}
	},
	{#State 8
		ACTIONS => {
			'FILENAME' => 80,
			'LITERAL' => 84,
			"\$" => 81,
			'IDENT' => 78,
			"\"" => 86,
			'NUMBER' => 85
		},
		GOTOS => {
			'name' => 77,
			'filename' => 82,
			'nameargs' => 94,
			'filepart' => 76,
			'names' => 83
		}
	},
	{#State 9
		DEFAULT => -14
	},
	{#State 10
		ACTIONS => {
			"\${" => 70,
			"\$" => 41,
			'IDENT' => 55
		},
		GOTOS => {
			'node' => 30,
			'item' => 40,
			'ident' => 95
		}
	},
	{#State 11
		ACTIONS => {
			'FILENAME' => 80,
			'LITERAL' => 84,
			"\$" => 81,
			'IDENT' => 78,
			'NUMBER' => 85,
			"\"" => 86
		},
		GOTOS => {
			'nameargs' => 96,
			'filename' => 82,
			'name' => 77,
			'names' => 83,
			'filepart' => 76
		}
	},
	{#State 12
		DEFAULT => -114
	},
	{#State 13
		ACTIONS => {
			"\$" => 41,
			'IDENT' => 55,
			"\${" => 70,
			'COMMA' => 98,
			'LITERAL' => 97
		},
		DEFAULT => -20,
		GOTOS => {
			'node' => 30,
			'item' => 40,
			'ident' => 100,
			'assign' => 99
		}
	},
	{#State 14
		ACTIONS => {
			'IDENT' => 102,
			'NUMBER' => 85,
			'LITERAL' => 105,
			'FILENAME' => 80
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 101,
			'metadata' => 107,
			'filename' => 106,
			'blockname' => 103,
			'meta' => 104,
			'filepart' => 76
		}
	},
	{#State 15
		DEFAULT => -27
	},
	{#State 16
		ACTIONS => {
			";" => 108
		}
	},
	{#State 17
		ACTIONS => {
			"\$" => 81,
			"\"" => 86,
			'NUMBER' => 85,
			'IDENT' => 78,
			'FILENAME' => 80,
			'LITERAL' => 84
		},
		GOTOS => {
			'name' => 77,
			'filename' => 82,
			'nameargs' => 109,
			'filepart' => 76,
			'names' => 83
		}
	},
	{#State 18
		ACTIONS => {
			'ASSIGN' => 110
		},
		DEFAULT => -113
	},
	{#State 19
		ACTIONS => {
			'IDENT' => 111
		}
	},
	{#State 20
		ACTIONS => {
			"(" => 5,
			'IDENT' => 55,
			"\"" => 6,
			"\$" => 41,
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45
		},
		GOTOS => {
			'node' => 30,
			'expr' => 112,
			'term' => 73,
			'ident' => 93,
			'sterm' => 4,
			'lterm' => 75,
			'item' => 40
		}
	},
	{#State 21
		ACTIONS => {
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12,
			'LITERAL' => 92,
			"\${" => 70,
			"{" => 36,
			"\$" => 41,
			"\"" => 6,
			'IDENT' => 115
		},
		GOTOS => {
			'node' => 30,
			'item' => 40,
			'lterm' => 75,
			'loopvar' => 114,
			'sterm' => 4,
			'ident' => 93,
			'term' => 113
		}
	},
	{#State 22
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			"\"" => 6,
			"(" => 5,
			'IDENT' => 55,
			"\$" => 41
		},
		GOTOS => {
			'node' => 30,
			'expr' => 116,
			'term' => 73,
			'sterm' => 4,
			'ident' => 93,
			'item' => 40,
			'lterm' => 75
		}
	},
	{#State 23
		ACTIONS => {
			'IDENT' => 117
		},
		DEFAULT => -88,
		GOTOS => {
			'meta' => 104,
			'metadata' => 107,
			'blockargs' => 118
		}
	},
	{#State 24
		ACTIONS => {
			'WHILE' => 121,
			'UNLESS' => 124,
			'IF' => 119,
			'FOR' => 122,
			'FILTER' => 123,
			'WRAPPER' => 120
		}
	},
	{#State 25
		DEFAULT => -6
	},
	{#State 26
		DEFAULT => -45
	},
	{#State 27
		ACTIONS => {
			'CMPOP' => 128,
			'DIV' => 131,
			'AND' => 132,
			'BINOP' => 129,
			";" => -17,
			'CAT' => 134,
			'OR' => 133,
			'MOD' => 127,
			"?" => 125,
			"/" => 126,
			"+" => 130
		},
		DEFAULT => -28
	},
	{#State 28
		ACTIONS => {
			'IDENT' => 117
		},
		GOTOS => {
			'metadata' => 135,
			'meta' => 104
		}
	},
	{#State 29
		ACTIONS => {
			'NUMBER' => 85,
			'IDENT' => 143,
			"\"" => 138,
			"\$" => 141,
			"\${" => 70,
			'LITERAL' => 139,
			'FILENAME' => 80
		},
		GOTOS => {
			'filepart' => 76,
			'item' => 137,
			'name' => 77,
			'filename' => 82,
			'lnameargs' => 136,
			'names' => 83,
			'lvalue' => 140,
			'nameargs' => 142
		}
	},
	{#State 30
		DEFAULT => -128
	},
	{#State 31
		DEFAULT => -15
	},
	{#State 32
		DEFAULT => -150
	},
	{#State 33
		ACTIONS => {
			"\$" => 141,
			"\"" => 138,
			'IDENT' => 143,
			'NUMBER' => 85,
			'FILENAME' => 80,
			'LITERAL' => 139,
			"\${" => 70
		},
		GOTOS => {
			'name' => 77,
			'filename' => 82,
			'filepart' => 76,
			'item' => 137,
			'nameargs' => 142,
			'lnameargs' => 144,
			'names' => 83,
			'lvalue' => 140
		}
	},
	{#State 34
		DEFAULT => -5
	},
	{#State 35
		DEFAULT => -26
	},
	{#State 36
		ACTIONS => {
			'LITERAL' => 146,
			"\${" => 70,
			'IDENT' => 55,
			"\$" => 41
		},
		DEFAULT => -120,
		GOTOS => {
			'params' => 147,
			'param' => 149,
			'hash' => 148,
			'item' => 145
		}
	},
	{#State 37
		ACTIONS => {
			'IDENT' => 78,
			'NUMBER' => 85,
			"\"" => 86,
			"\$" => 81,
			'LITERAL' => 84,
			'FILENAME' => 80
		},
		GOTOS => {
			'filepart' => 76,
			'names' => 83,
			'name' => 77,
			'nameargs' => 150,
			'filename' => 82
		}
	},
	{#State 38
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			"(" => 5,
			'IDENT' => 55,
			"\"" => 6,
			"\$" => 41
		},
		GOTOS => {
			'node' => 30,
			'expr' => 151,
			'sterm' => 4,
			'ident' => 93,
			'term' => 73,
			'item' => 40,
			'lterm' => 75
		}
	},
	{#State 39
		DEFAULT => -23
	},
	{#State 40
		ACTIONS => {
			"(" => 152
		},
		DEFAULT => -129
	},
	{#State 41
		ACTIONS => {
			'IDENT' => 153
		}
	},
	{#State 42
		DEFAULT => -9
	},
	{#State 43
		DEFAULT => -22
	},
	{#State 44
		ACTIONS => {
			'USE' => 33,
			'SET' => 69,
			'FILTER' => 29,
			'rawperl' => 68,
			'META' => 28,
			'RAW' => 64,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'VIEW' => 37,
			"{" => 36,
			"\${" => 70,
			'IF' => 49,
			'perl' => 15,
			'BLOCK' => 14,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'TRY' => 47,
			'REF' => 10,
			"[" => 45,
			'THROW' => 8,
			'WHILE' => 7,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'NEXT' => 60,
			'GET' => 59,
			'TEXT' => 25,
			'SWITCH' => 22,
			'FOR' => 21,
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53
		},
		DEFAULT => -2,
		GOTOS => {
			'defblock' => 42,
			'sterm' => 4,
			'expr' => 27,
			'wrapper' => 3,
			'filter' => 26,
			'chunk' => 154,
			'setlist' => 13,
			'assign' => 32,
			'view' => 31,
			'node' => 30,
			'macro' => 67,
			'atomdir' => 46,
			'use' => 66,
			'raw' => 9,
			'anonblock' => 65,
			'condition' => 43,
			'directive' => 72,
			'ident' => 56,
			'try' => 52,
			'capture' => 50,
			'statement' => 16,
			'javascript' => 35,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'term' => 73,
			'defblockname' => 23,
			'loop' => 74,
			'switch' => 39
		}
	},
	{#State 45
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			'LITERAL' => 92,
			"{" => 36,
			"]" => 156,
			"\${" => 70,
			'IDENT' => 55,
			"\"" => 6,
			"\$" => 41
		},
		GOTOS => {
			'ident' => 93,
			'sterm' => 159,
			'range' => 158,
			'list' => 155,
			'term' => 157,
			'lterm' => 75,
			'item' => 40,
			'node' => 30
		}
	},
	{#State 46
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 47
		ACTIONS => {
			";" => 160
		}
	},
	{#State 48
		DEFAULT => -1
	},
	{#State 49
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70,
			'IDENT' => 55,
			"(" => 5,
			"\"" => 6,
			"\$" => 41
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'sterm' => 4,
			'ident' => 93,
			'term' => 73,
			'expr' => 161,
			'node' => 30
		}
	},
	{#State 50
		DEFAULT => -11
	},
	{#State 51
		ACTIONS => {
			'' => 162
		}
	},
	{#State 52
		DEFAULT => -25
	},
	{#State 53
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			"(" => 5,
			"\"" => 6,
			'IDENT' => 55,
			"\$" => 41
		},
		GOTOS => {
			'item' => 40,
			'lterm' => 75,
			'ident' => 93,
			'sterm' => 4,
			'term' => 73,
			'node' => 30,
			'expr' => 163
		}
	},
	{#State 54
		ACTIONS => {
			"\$" => 41,
			'IDENT' => 55,
			"\${" => 70,
			'LITERAL' => 97
		},
		GOTOS => {
			'node' => 30,
			'setlist' => 164,
			'item' => 40,
			'assign' => 32,
			'ident' => 100
		}
	},
	{#State 55
		DEFAULT => -131
	},
	{#State 56
		ACTIONS => {
			'ASSIGN' => 166,
			'DOT' => 165
		},
		DEFAULT => -110
	},
	{#State 57
		ACTIONS => {
			'NUMBER' => 85,
			'IDENT' => 78,
			"\"" => 86,
			"\$" => 81,
			'LITERAL' => 84,
			'FILENAME' => 80
		},
		GOTOS => {
			'filepart' => 76,
			'names' => 83,
			'name' => 77,
			'nameargs' => 167,
			'filename' => 82
		}
	},
	{#State 58
		ACTIONS => {
			"\$" => 81,
			'NUMBER' => 85,
			"\"" => 86,
			'IDENT' => 78,
			'FILENAME' => 80,
			'LITERAL' => 84
		},
		GOTOS => {
			'names' => 83,
			'filepart' => 76,
			'filename' => 82,
			'nameargs' => 168,
			'name' => 77
		}
	},
	{#State 59
		ACTIONS => {
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45,
			'IDENT' => 55,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70
		},
		GOTOS => {
			'term' => 73,
			'sterm' => 4,
			'ident' => 93,
			'lterm' => 75,
			'item' => 40,
			'expr' => 169,
			'node' => 30
		}
	},
	{#State 60
		DEFAULT => -42
	},
	{#State 61
		DEFAULT => -40
	},
	{#State 62
		DEFAULT => -39
	},
	{#State 63
		DEFAULT => -41
	},
	{#State 64
		ACTIONS => {
			"\${" => 70,
			'FILENAME' => 80,
			'LITERAL' => 139,
			"\$" => 141,
			'IDENT' => 143,
			"\"" => 138,
			'NUMBER' => 85
		},
		GOTOS => {
			'names' => 83,
			'lvalue' => 140,
			'lnameargs' => 170,
			'nameargs' => 142,
			'item' => 137,
			'filepart' => 76,
			'filename' => 82,
			'name' => 77
		}
	},
	{#State 65
		DEFAULT => -10
	},
	{#State 66
		DEFAULT => -13
	},
	{#State 67
		DEFAULT => -12
	},
	{#State 68
		DEFAULT => -16
	},
	{#State 69
		ACTIONS => {
			'IDENT' => 55,
			"\$" => 41,
			'LITERAL' => 97,
			"\${" => 70
		},
		GOTOS => {
			'item' => 40,
			'setlist' => 171,
			'ident' => 100,
			'assign' => 32,
			'node' => 30
		}
	},
	{#State 70
		ACTIONS => {
			"\${" => 70,
			'LITERAL' => 92,
			'REF' => 10,
			"\$" => 41,
			"\"" => 6,
			'IDENT' => 55,
			'NUMBER' => 12
		},
		GOTOS => {
			'item' => 40,
			'ident' => 93,
			'sterm' => 172,
			'node' => 30
		}
	},
	{#State 71
		ACTIONS => {
			";" => 173
		}
	},
	{#State 72
		DEFAULT => -8
	},
	{#State 73
		DEFAULT => -147
	},
	{#State 74
		DEFAULT => -24
	},
	{#State 75
		DEFAULT => -104
	},
	{#State 76
		DEFAULT => -172
	},
	{#State 77
		DEFAULT => -167
	},
	{#State 78
		DEFAULT => -174
	},
	{#State 79
		ACTIONS => {
			";" => 174
		}
	},
	{#State 80
		DEFAULT => -173
	},
	{#State 81
		ACTIONS => {
			"\${" => 70,
			"\$" => 41,
			'IDENT' => 55
		},
		GOTOS => {
			'item' => 40,
			'ident' => 175,
			'node' => 30
		}
	},
	{#State 82
		ACTIONS => {
			'DOT' => 176
		},
		DEFAULT => -169
	},
	{#State 83
		ACTIONS => {
			"(" => 179,
			"+" => 178
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 177
		}
	},
	{#State 84
		DEFAULT => -170
	},
	{#State 85
		DEFAULT => -175
	},
	{#State 86
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 180
		}
	},
	{#State 87
		ACTIONS => {
			'DOT' => 165,
			'ASSIGN' => 181
		},
		DEFAULT => -110
	},
	{#State 88
		ACTIONS => {
			")" => 182
		}
	},
	{#State 89
		ACTIONS => {
			'CAT' => 134,
			'CMPOP' => 128,
			'DIV' => 131,
			'AND' => 132,
			'BINOP' => 129,
			'MOD' => 127,
			"?" => 125,
			'OR' => 133,
			")" => 183,
			"+" => 130,
			"/" => 126
		}
	},
	{#State 90
		ACTIONS => {
			";" => 187,
			"\${" => 70,
			"\$" => 41,
			"\"" => 185,
			'IDENT' => 55,
			'TEXT' => 184
		},
		GOTOS => {
			'quotable' => 186,
			'node' => 30,
			'ident' => 188,
			'item' => 40
		}
	},
	{#State 91
		ACTIONS => {
			'CMPOP' => 128,
			'CAT' => 134,
			'DIV' => 131,
			'AND' => 132,
			'BINOP' => 129,
			'OR' => 133,
			'MOD' => 127,
			"?" => 125,
			";" => 189,
			"/" => 126,
			"+" => 130
		}
	},
	{#State 92
		DEFAULT => -113
	},
	{#State 93
		ACTIONS => {
			'DOT' => 165
		},
		DEFAULT => -110
	},
	{#State 94
		DEFAULT => -37
	},
	{#State 95
		ACTIONS => {
			'DOT' => 165
		},
		DEFAULT => -111
	},
	{#State 96
		DEFAULT => -35
	},
	{#State 97
		ACTIONS => {
			'ASSIGN' => 110
		}
	},
	{#State 98
		DEFAULT => -149
	},
	{#State 99
		DEFAULT => -148
	},
	{#State 100
		ACTIONS => {
			'ASSIGN' => 181,
			'DOT' => 165
		}
	},
	{#State 101
		ACTIONS => {
			";" => 190
		}
	},
	{#State 102
		ACTIONS => {
			'ASSIGN' => 191
		},
		DEFAULT => -174
	},
	{#State 103
		DEFAULT => -84
	},
	{#State 104
		DEFAULT => -100
	},
	{#State 105
		DEFAULT => -86
	},
	{#State 106
		ACTIONS => {
			'DOT' => 176
		},
		DEFAULT => -85
	},
	{#State 107
		ACTIONS => {
			'IDENT' => 117,
			'COMMA' => 192
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 193
		}
	},
	{#State 108
		DEFAULT => -7
	},
	{#State 109
		DEFAULT => -34
	},
	{#State 110
		ACTIONS => {
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45,
			"\"" => 6,
			'IDENT' => 55,
			"(" => 5,
			"\$" => 41,
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70
		},
		GOTOS => {
			'node' => 30,
			'expr' => 194,
			'item' => 40,
			'lterm' => 75,
			'ident' => 93,
			'sterm' => 4,
			'term' => 73
		}
	},
	{#State 111
		ACTIONS => {
			'FILTER' => 29,
			'SET' => 69,
			'CLEAR' => 61,
			'STOP' => 62,
			'LAST' => 63,
			"{" => 36,
			"\${" => 70,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'THROW' => 8,
			"[" => 45,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'TRY' => 47,
			'REF' => 10,
			'IF' => 49,
			'BLOCK' => 195,
			'perl' => 15,
			'WRAPPER' => 2,
			'RETURN' => 1,
			"(" => 196,
			"\"" => 6,
			"\$" => 41,
			'WHILE' => 7,
			'CALL' => 20,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'SWITCH' => 22,
			'FOR' => 21,
			'NEXT' => 60,
			'GET' => 59,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53,
			'IDENT' => 55,
			'DEFAULT' => 54
		},
		GOTOS => {
			'expr' => 197,
			'wrapper' => 3,
			'filter' => 26,
			'sterm' => 4,
			'node' => 30,
			'atomdir' => 46,
			'condition' => 43,
			'setlist' => 13,
			'mdir' => 199,
			'assign' => 32,
			'try' => 52,
			'javascript' => 35,
			'directive' => 198,
			'ident' => 87,
			'switch' => 39,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'loop' => 74,
			'term' => 73
		}
	},
	{#State 112
		ACTIONS => {
			'CMPOP' => 128,
			'DIV' => 131,
			'AND' => 132,
			'BINOP' => 129,
			'CAT' => 134,
			'OR' => 133,
			'MOD' => 127,
			"?" => 125,
			"/" => 126,
			"+" => 130
		},
		DEFAULT => -31
	},
	{#State 113
		DEFAULT => -157,
		GOTOS => {
			'args' => 200
		}
	},
	{#State 114
		ACTIONS => {
			";" => 201
		}
	},
	{#State 115
		ACTIONS => {
			'IN' => 202,
			'ASSIGN' => 203
		},
		DEFAULT => -131
	},
	{#State 116
		ACTIONS => {
			'DIV' => 131,
			'CAT' => 134,
			'CMPOP' => 128,
			'BINOP' => 129,
			'AND' => 132,
			";" => 204,
			'MOD' => 127,
			"?" => 125,
			'OR' => 133,
			"+" => 130,
			"/" => 126
		}
	},
	{#State 117
		ACTIONS => {
			'ASSIGN' => 191
		}
	},
	{#State 118
		ACTIONS => {
			";" => 205
		}
	},
	{#State 119
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			"\"" => 6,
			"(" => 5,
			'IDENT' => 55,
			"\$" => 41
		},
		GOTOS => {
			'term' => 73,
			'sterm' => 4,
			'ident' => 93,
			'lterm' => 75,
			'item' => 40,
			'expr' => 206,
			'node' => 30
		}
	},
	{#State 120
		ACTIONS => {
			'NUMBER' => 85,
			"\"" => 86,
			'IDENT' => 78,
			"\$" => 81,
			'LITERAL' => 84,
			'FILENAME' => 80
		},
		GOTOS => {
			'nameargs' => 207,
			'filename' => 82,
			'name' => 77,
			'names' => 83,
			'filepart' => 76
		}
	},
	{#State 121
		ACTIONS => {
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 92,
			"\$" => 41,
			'IDENT' => 55,
			"(" => 5,
			"\"" => 6,
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12
		},
		GOTOS => {
			'expr' => 208,
			'node' => 30,
			'sterm' => 4,
			'term' => 73,
			'ident' => 93,
			'item' => 40,
			'lterm' => 75
		}
	},
	{#State 122
		ACTIONS => {
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45,
			"\$" => 41,
			"\"" => 6,
			'IDENT' => 115,
			"\${" => 70,
			"{" => 36,
			'LITERAL' => 92
		},
		GOTOS => {
			'sterm' => 4,
			'term' => 113,
			'ident' => 93,
			'loopvar' => 209,
			'lterm' => 75,
			'item' => 40,
			'node' => 30
		}
	},
	{#State 123
		ACTIONS => {
			'IDENT' => 143,
			"\"" => 138,
			'NUMBER' => 85,
			"\$" => 141,
			"\${" => 70,
			'LITERAL' => 139,
			'FILENAME' => 80
		},
		GOTOS => {
			'lvalue' => 140,
			'names' => 83,
			'lnameargs' => 210,
			'nameargs' => 142,
			'item' => 137,
			'filepart' => 76,
			'filename' => 82,
			'name' => 77
		}
	},
	{#State 124
		ACTIONS => {
			"\$" => 41,
			'IDENT' => 55,
			"(" => 5,
			"\"" => 6,
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 92,
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45
		},
		GOTOS => {
			'expr' => 211,
			'node' => 30,
			'item' => 40,
			'lterm' => 75,
			'ident' => 93,
			'term' => 73,
			'sterm' => 4
		}
	},
	{#State 125
		ACTIONS => {
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45,
			'IDENT' => 55,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'ident' => 93,
			'term' => 73,
			'sterm' => 4,
			'expr' => 212,
			'node' => 30
		}
	},
	{#State 126
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70,
			"(" => 5,
			"\"" => 6,
			'IDENT' => 55,
			"\$" => 41
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'term' => 73,
			'sterm' => 4,
			'ident' => 93,
			'node' => 30,
			'expr' => 213
		}
	},
	{#State 127
		ACTIONS => {
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45,
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5,
			'NOT' => 53,
			'LITERAL' => 92,
			"\${" => 70,
			"{" => 36
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'term' => 73,
			'ident' => 93,
			'sterm' => 4,
			'node' => 30,
			'expr' => 214
		}
	},
	{#State 128
		ACTIONS => {
			'NOT' => 53,
			'LITERAL' => 92,
			"\${" => 70,
			"{" => 36,
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5,
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12
		},
		GOTOS => {
			'term' => 73,
			'ident' => 93,
			'sterm' => 4,
			'lterm' => 75,
			'item' => 40,
			'node' => 30,
			'expr' => 215
		}
	},
	{#State 129
		ACTIONS => {
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			"\"" => 6,
			'IDENT' => 55,
			"(" => 5,
			"\$" => 41,
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10
		},
		GOTOS => {
			'item' => 40,
			'lterm' => 75,
			'sterm' => 4,
			'term' => 73,
			'ident' => 93,
			'expr' => 216,
			'node' => 30
		}
	},
	{#State 130
		ACTIONS => {
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53,
			'IDENT' => 55,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10
		},
		GOTOS => {
			'expr' => 217,
			'node' => 30,
			'sterm' => 4,
			'ident' => 93,
			'term' => 73,
			'item' => 40,
			'lterm' => 75
		}
	},
	{#State 131
		ACTIONS => {
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 92,
			"\${" => 70,
			"{" => 36,
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45
		},
		GOTOS => {
			'expr' => 218,
			'node' => 30,
			'item' => 40,
			'lterm' => 75,
			'sterm' => 4,
			'term' => 73,
			'ident' => 93
		}
	},
	{#State 132
		ACTIONS => {
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5,
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 92,
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'term' => 73,
			'sterm' => 4,
			'ident' => 93,
			'expr' => 219,
			'node' => 30
		}
	},
	{#State 133
		ACTIONS => {
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'sterm' => 4,
			'ident' => 93,
			'term' => 73,
			'node' => 30,
			'expr' => 220
		}
	},
	{#State 134
		ACTIONS => {
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			"{" => 36,
			"\${" => 70,
			'LITERAL' => 92,
			'NOT' => 53
		},
		GOTOS => {
			'expr' => 221,
			'node' => 30,
			'term' => 73,
			'sterm' => 4,
			'ident' => 93,
			'item' => 40,
			'lterm' => 75
		}
	},
	{#State 135
		ACTIONS => {
			'IDENT' => 117,
			'COMMA' => 192
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 193
		}
	},
	{#State 136
		ACTIONS => {
			";" => 222
		}
	},
	{#State 137
		DEFAULT => -160
	},
	{#State 138
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 223
		}
	},
	{#State 139
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 140
		ACTIONS => {
			'ASSIGN' => 224
		}
	},
	{#State 141
		ACTIONS => {
			'IDENT' => 225,
			"\$" => 41,
			"\${" => 70
		},
		GOTOS => {
			'ident' => 175,
			'item' => 40,
			'node' => 30
		}
	},
	{#State 142
		DEFAULT => -159
	},
	{#State 143
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 144
		DEFAULT => -75
	},
	{#State 145
		ACTIONS => {
			'ASSIGN' => 226
		}
	},
	{#State 146
		ACTIONS => {
			'ASSIGN' => 227
		}
	},
	{#State 147
		ACTIONS => {
			'LITERAL' => 146,
			'COMMA' => 229,
			"\${" => 70,
			'IDENT' => 55,
			"\$" => 41
		},
		DEFAULT => -119,
		GOTOS => {
			'item' => 145,
			'param' => 228
		}
	},
	{#State 148
		ACTIONS => {
			"}" => 230
		}
	},
	{#State 149
		DEFAULT => -123
	},
	{#State 150
		ACTIONS => {
			";" => 231
		}
	},
	{#State 151
		ACTIONS => {
			"/" => 126,
			"+" => 130,
			'OR' => 133,
			";" => 232,
			"?" => 125,
			'MOD' => 127,
			'AND' => 132,
			'BINOP' => 129,
			'CMPOP' => 128,
			'CAT' => 134,
			'DIV' => 131
		}
	},
	{#State 152
		DEFAULT => -157,
		GOTOS => {
			'args' => 233
		}
	},
	{#State 153
		DEFAULT => -133
	},
	{#State 154
		DEFAULT => -4
	},
	{#State 155
		ACTIONS => {
			'IDENT' => 55,
			"\"" => 6,
			"\$" => 41,
			"{" => 36,
			"]" => 235,
			'COMMA' => 236,
			"\${" => 70,
			'LITERAL' => 92,
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45
		},
		GOTOS => {
			'item' => 40,
			'lterm' => 75,
			'ident' => 93,
			'sterm' => 4,
			'term' => 234,
			'node' => 30
		}
	},
	{#State 156
		DEFAULT => -108
	},
	{#State 157
		DEFAULT => -117
	},
	{#State 158
		ACTIONS => {
			"]" => 237
		}
	},
	{#State 159
		ACTIONS => {
			'TO' => 238
		},
		DEFAULT => -105
	},
	{#State 160
		ACTIONS => {
			'VIEW' => 37,
			"\${" => 70,
			"{" => 36,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			'CLEAR' => 61,
			'STOP' => 62,
			'RAW' => 64,
			'LAST' => 63,
			'rawperl' => 68,
			'META' => 28,
			'FILTER' => 29,
			'SET' => 69,
			'USE' => 33,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'TEXT' => 25,
			'GET' => 59,
			'NEXT' => 60,
			'FOR' => 21,
			'SWITCH' => 22,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'WHILE' => 7,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			"[" => 45,
			'THROW' => 8,
			'perl' => 15,
			'BLOCK' => 14,
			'IF' => 49,
			'REF' => 10,
			'TRY' => 47,
			'INCLUDE' => 11,
			'NUMBER' => 12
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 4,
			'defblock' => 42,
			'filter' => 26,
			'expr' => 27,
			'wrapper' => 3,
			'block' => 239,
			'assign' => 32,
			'setlist' => 13,
			'chunk' => 34,
			'raw' => 9,
			'condition' => 43,
			'anonblock' => 65,
			'use' => 66,
			'chunks' => 44,
			'atomdir' => 46,
			'macro' => 67,
			'node' => 30,
			'view' => 31,
			'ident' => 56,
			'directive' => 72,
			'capture' => 50,
			'statement' => 16,
			'javascript' => 35,
			'try' => 52,
			'defblockname' => 23,
			'loop' => 74,
			'term' => 73,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'switch' => 39
		}
	},
	{#State 161
		ACTIONS => {
			'MOD' => 127,
			"?" => 125,
			";" => 240,
			'OR' => 133,
			"+" => 130,
			"/" => 126,
			'DIV' => 131,
			'CAT' => 134,
			'CMPOP' => 128,
			'BINOP' => 129,
			'AND' => 132
		}
	},
	{#State 162
		DEFAULT => 0
	},
	{#State 163
		ACTIONS => {
			'CAT' => 134,
			'MOD' => 127,
			'DIV' => 131,
			"+" => 130,
			"/" => 126,
			'CMPOP' => 128,
			'BINOP' => 129
		},
		DEFAULT => -143
	},
	{#State 164
		ACTIONS => {
			'IDENT' => 55,
			"\$" => 41,
			'LITERAL' => 97,
			"\${" => 70,
			'COMMA' => 98
		},
		DEFAULT => -33,
		GOTOS => {
			'item' => 40,
			'ident' => 100,
			'assign' => 99,
			'node' => 30
		}
	},
	{#State 165
		ACTIONS => {
			'IDENT' => 55,
			'NUMBER' => 242,
			"\$" => 41,
			"\${" => 70
		},
		GOTOS => {
			'node' => 241,
			'item' => 40
		}
	},
	{#State 166
		ACTIONS => {
			'IF' => 49,
			'BLOCK' => 195,
			'perl' => 15,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'TRY' => 47,
			'REF' => 10,
			"[" => 45,
			'THROW' => 8,
			'WHILE' => 7,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'GET' => 59,
			'NEXT' => 60,
			'SWITCH' => 22,
			'FOR' => 21,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'CALL' => 20,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53,
			'SET' => 69,
			'FILTER' => 29,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			"{" => 36,
			"\${" => 70
		},
		GOTOS => {
			'expr' => 244,
			'wrapper' => 3,
			'filter' => 26,
			'sterm' => 4,
			'atomdir' => 46,
			'node' => 30,
			'condition' => 43,
			'mdir' => 243,
			'setlist' => 13,
			'assign' => 32,
			'javascript' => 35,
			'try' => 52,
			'directive' => 198,
			'ident' => 87,
			'switch' => 39,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'loop' => 74,
			'term' => 73
		}
	},
	{#State 167
		DEFAULT => -43
	},
	{#State 168
		DEFAULT => -36
	},
	{#State 169
		ACTIONS => {
			"?" => 125,
			'MOD' => 127,
			'OR' => 133,
			"+" => 130,
			"/" => 126,
			'CAT' => 134,
			'CMPOP' => 128,
			'DIV' => 131,
			'AND' => 132,
			'BINOP' => 129
		},
		DEFAULT => -30
	},
	{#State 170
		DEFAULT => -76
	},
	{#State 171
		ACTIONS => {
			'IDENT' => 55,
			"\$" => 41,
			"\${" => 70,
			'COMMA' => 98,
			'LITERAL' => 97
		},
		DEFAULT => -32,
		GOTOS => {
			'item' => 40,
			'assign' => 99,
			'ident' => 100,
			'node' => 30
		}
	},
	{#State 172
		ACTIONS => {
			"}" => 245
		}
	},
	{#State 173
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 246
		}
	},
	{#State 174
		ACTIONS => {
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"\${" => 70,
			"{" => 36,
			'VIEW' => 37,
			'SET' => 69,
			'USE' => 33,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'RAW' => 64,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'FOR' => 21,
			'SWITCH' => 22,
			'NEXT' => 60,
			'TEXT' => 25,
			'GET' => 59,
			'MACRO' => 19,
			";" => -19,
			'CALL' => 20,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'TRY' => 47,
			'REF' => 10,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'BLOCK' => 14,
			'perl' => 15,
			'IF' => 49,
			'THROW' => 8,
			"[" => 45,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'WHILE' => 7,
			'RETURN' => 1,
			'WRAPPER' => 2
		},
		DEFAULT => -3,
		GOTOS => {
			'defblock' => 42,
			'sterm' => 4,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'block' => 247,
			'assign' => 32,
			'setlist' => 13,
			'chunk' => 34,
			'condition' => 43,
			'raw' => 9,
			'anonblock' => 65,
			'chunks' => 44,
			'use' => 66,
			'atomdir' => 46,
			'macro' => 67,
			'node' => 30,
			'view' => 31,
			'ident' => 56,
			'directive' => 72,
			'javascript' => 35,
			'statement' => 16,
			'capture' => 50,
			'try' => 52,
			'term' => 73,
			'defblockname' => 23,
			'loop' => 74,
			'atomexpr' => 24,
			'item' => 40,
			'lterm' => 75,
			'switch' => 39
		}
	},
	{#State 175
		ACTIONS => {
			'DOT' => 165
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 248
		}
	},
	{#State 176
		ACTIONS => {
			'NUMBER' => 85,
			'IDENT' => 78,
			'FILENAME' => 80
		},
		GOTOS => {
			'filepart' => 249
		}
	},
	{#State 177
		ACTIONS => {
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'COMMA' => 252,
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45,
			'IDENT' => 55,
			'LITERAL' => 253,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70
		},
		DEFAULT => -164,
		GOTOS => {
			'item' => 255,
			'lterm' => 75,
			'term' => 73,
			'node' => 30,
			'ident' => 251,
			'sterm' => 4,
			'expr' => 254,
			'param' => 250
		}
	},
	{#State 178
		ACTIONS => {
			'IDENT' => 78,
			'NUMBER' => 85,
			"\"" => 86,
			'FILENAME' => 80,
			'LITERAL' => 84
		},
		GOTOS => {
			'filepart' => 76,
			'filename' => 82,
			'name' => 256
		}
	},
	{#State 179
		DEFAULT => -157,
		GOTOS => {
			'args' => 257
		}
	},
	{#State 180
		ACTIONS => {
			'TEXT' => 184,
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 258,
			";" => 187,
			"\${" => 70
		},
		GOTOS => {
			'ident' => 188,
			'item' => 40,
			'quotable' => 186,
			'node' => 30
		}
	},
	{#State 181
		ACTIONS => {
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10,
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70,
			"(" => 5,
			"\"" => 6,
			'IDENT' => 55,
			"\$" => 41
		},
		GOTOS => {
			'node' => 30,
			'expr' => 259,
			'item' => 40,
			'lterm' => 75,
			'ident' => 93,
			'sterm' => 4,
			'term' => 73
		}
	},
	{#State 182
		DEFAULT => -145
	},
	{#State 183
		DEFAULT => -146
	},
	{#State 184
		DEFAULT => -179
	},
	{#State 185
		DEFAULT => -112
	},
	{#State 186
		DEFAULT => -176
	},
	{#State 187
		DEFAULT => -180
	},
	{#State 188
		ACTIONS => {
			'DOT' => 165
		},
		DEFAULT => -178
	},
	{#State 189
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 260
		}
	},
	{#State 190
		ACTIONS => {
			'TEXT' => 25,
			'NEXT' => 60,
			'GET' => 59,
			'SWITCH' => 22,
			'FOR' => 21,
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53,
			'IF' => 49,
			'perl' => 15,
			'BLOCK' => 14,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'TRY' => 47,
			'REF' => 10,
			"[" => 45,
			'THROW' => 8,
			'WHILE' => 7,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'VIEW' => 37,
			"{" => 36,
			"\${" => 70,
			'USE' => 33,
			'SET' => 69,
			'FILTER' => 29,
			'META' => 28,
			'rawperl' => 68,
			'LAST' => 63,
			'RAW' => 64,
			'STOP' => 62,
			'CLEAR' => 61
		},
		DEFAULT => -3,
		GOTOS => {
			'atomexpr' => 24,
			'item' => 40,
			'lterm' => 75,
			'loop' => 74,
			'defblockname' => 23,
			'term' => 73,
			'switch' => 39,
			'directive' => 72,
			'ident' => 56,
			'capture' => 50,
			'statement' => 16,
			'javascript' => 35,
			'try' => 52,
			'setlist' => 13,
			'chunk' => 34,
			'block' => 261,
			'assign' => 32,
			'macro' => 67,
			'atomdir' => 46,
			'view' => 31,
			'node' => 30,
			'raw' => 9,
			'anonblock' => 65,
			'condition' => 43,
			'chunks' => 44,
			'use' => 66,
			'sterm' => 4,
			'defblock' => 42,
			'wrapper' => 3,
			'expr' => 27,
			'filter' => 26
		}
	},
	{#State 191
		ACTIONS => {
			"\"" => 262,
			'NUMBER' => 263,
			'LITERAL' => 264
		}
	},
	{#State 192
		DEFAULT => -99
	},
	{#State 193
		DEFAULT => -98
	},
	{#State 194
		ACTIONS => {
			'BINOP' => 129,
			'AND' => 132,
			'DIV' => 131,
			'CMPOP' => 128,
			'CAT' => 134,
			"/" => 126,
			"+" => 130,
			'OR' => 133,
			"?" => 125,
			'MOD' => 127
		},
		DEFAULT => -152
	},
	{#State 195
		ACTIONS => {
			";" => 265
		}
	},
	{#State 196
		ACTIONS => {
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12,
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 18,
			"\$" => 41,
			'IDENT' => 267,
			"\"" => 6,
			"(" => 5
		},
		GOTOS => {
			'expr' => 89,
			'sterm' => 4,
			'ident' => 87,
			'margs' => 266,
			'node' => 30,
			'assign' => 88,
			'term' => 73,
			'lterm' => 75,
			'item' => 40
		}
	},
	{#State 197
		ACTIONS => {
			'CAT' => 134,
			"?" => 125,
			'MOD' => 127,
			'OR' => 133,
			"+" => 130,
			"/" => 126,
			'DIV' => 131,
			'CMPOP' => 128,
			'BINOP' => 129,
			'AND' => 132
		},
		DEFAULT => -28
	},
	{#State 198
		DEFAULT => -93
	},
	{#State 199
		DEFAULT => -92
	},
	{#State 200
		ACTIONS => {
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12,
			'COMMA' => 252,
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 253,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'IDENT' => 55
		},
		DEFAULT => -66,
		GOTOS => {
			'expr' => 254,
			'param' => 250,
			'ident' => 251,
			'sterm' => 4,
			'node' => 30,
			'term' => 73,
			'lterm' => 75,
			'item' => 255
		}
	},
	{#State 201
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 268
		}
	},
	{#State 202
		ACTIONS => {
			'LITERAL' => 92,
			"\${" => 70,
			"{" => 36,
			"\$" => 41,
			"\"" => 6,
			'IDENT' => 55,
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12
		},
		GOTOS => {
			'node' => 30,
			'lterm' => 75,
			'item' => 40,
			'term' => 269,
			'sterm' => 4,
			'ident' => 93
		}
	},
	{#State 203
		ACTIONS => {
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 6,
			"\${" => 70,
			"{" => 36,
			'LITERAL' => 92,
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'sterm' => 4,
			'term' => 270,
			'ident' => 93,
			'node' => 30
		}
	},
	{#State 204
		ACTIONS => {
			'TEXT' => 25,
			'GET' => 59,
			'NEXT' => 60,
			'FOR' => 21,
			'SWITCH' => 22,
			'PROCESS' => 58,
			'DEBUG' => 57,
			'CALL' => 20,
			";" => -19,
			'MACRO' => 19,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'IF' => 49,
			'perl' => 15,
			'BLOCK' => 14,
			'REF' => 10,
			'TRY' => 47,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			"[" => 45,
			'THROW' => 8,
			'WHILE' => 7,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			'VIEW' => 37,
			"\${" => 70,
			"{" => 36,
			'SET' => 69,
			'USE' => 33,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'LAST' => 63,
			'RAW' => 64,
			'STOP' => 62,
			'CLEAR' => 61
		},
		DEFAULT => -3,
		GOTOS => {
			'setlist' => 13,
			'chunk' => 34,
			'block' => 271,
			'assign' => 32,
			'macro' => 67,
			'atomdir' => 46,
			'view' => 31,
			'node' => 30,
			'condition' => 43,
			'anonblock' => 65,
			'raw' => 9,
			'chunks' => 44,
			'use' => 66,
			'sterm' => 4,
			'defblock' => 42,
			'expr' => 27,
			'wrapper' => 3,
			'filter' => 26,
			'atomexpr' => 24,
			'item' => 40,
			'lterm' => 75,
			'term' => 73,
			'loop' => 74,
			'defblockname' => 23,
			'switch' => 39,
			'directive' => 72,
			'ident' => 56,
			'capture' => 50,
			'javascript' => 35,
			'statement' => 16,
			'try' => 52
		}
	},
	{#State 205
		ACTIONS => {
			'SET' => 69,
			'USE' => 33,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'RAW' => 64,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			'VIEW' => 37,
			"\${" => 70,
			"{" => 36,
			'perl' => 15,
			'BLOCK' => 14,
			'IF' => 49,
			'REF' => 10,
			'TRY' => 47,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			"[" => 45,
			'THROW' => 8,
			'WHILE' => 7,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'GET' => 59,
			'TEXT' => 25,
			'NEXT' => 60,
			'FOR' => 21,
			'SWITCH' => 22,
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'INSERT' => 17,
			'LITERAL' => 18
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 23,
			'atomexpr' => 24,
			'try' => 52,
			'template' => 272,
			'statement' => 16,
			'capture' => 50,
			'ident' => 56,
			'chunks' => 44,
			'condition' => 43,
			'raw' => 9,
			'atomdir' => 46,
			'block' => 48,
			'setlist' => 13,
			'wrapper' => 3,
			'sterm' => 4,
			'defblock' => 42,
			'switch' => 39,
			'term' => 73,
			'loop' => 74,
			'lterm' => 75,
			'item' => 40,
			'javascript' => 35,
			'directive' => 72,
			'use' => 66,
			'anonblock' => 65,
			'node' => 30,
			'view' => 31,
			'macro' => 67,
			'assign' => 32,
			'chunk' => 34,
			'filter' => 26,
			'expr' => 27
		}
	},
	{#State 206
		ACTIONS => {
			'MOD' => 127,
			"?" => 125,
			'OR' => 133,
			"+" => 130,
			"/" => 126,
			'DIV' => 131,
			'CAT' => 134,
			'CMPOP' => 128,
			'BINOP' => 129,
			'AND' => 132
		},
		DEFAULT => -47
	},
	{#State 207
		DEFAULT => -68
	},
	{#State 208
		ACTIONS => {
			"+" => 130,
			"/" => 126,
			"?" => 125,
			'MOD' => 127,
			'OR' => 133,
			'AND' => 132,
			'BINOP' => 129,
			'CAT' => 134,
			'CMPOP' => 128,
			'DIV' => 131
		},
		DEFAULT => -63
	},
	{#State 209
		DEFAULT => -60
	},
	{#State 210
		DEFAULT => -82
	},
	{#State 211
		ACTIONS => {
			'OR' => 133,
			"?" => 125,
			'MOD' => 127,
			"/" => 126,
			"+" => 130,
			'DIV' => 131,
			'CMPOP' => 128,
			'CAT' => 134,
			'BINOP' => 129,
			'AND' => 132
		},
		DEFAULT => -49
	},
	{#State 212
		ACTIONS => {
			"+" => 130,
			"/" => 126,
			'MOD' => 127,
			"?" => 125,
			'OR' => 133,
			":" => 273,
			'AND' => 132,
			'BINOP' => 129,
			'CAT' => 134,
			'CMPOP' => 128,
			'DIV' => 131
		}
	},
	{#State 213
		ACTIONS => {
			'MOD' => 127,
			'DIV' => 131
		},
		DEFAULT => -135
	},
	{#State 214
		DEFAULT => -138
	},
	{#State 215
		ACTIONS => {
			'BINOP' => 129,
			"+" => 130,
			"/" => 126,
			'DIV' => 131,
			'MOD' => 127
		},
		DEFAULT => -139
	},
	{#State 216
		ACTIONS => {
			"/" => 126,
			"+" => 130,
			'DIV' => 131,
			'MOD' => 127
		},
		DEFAULT => -134
	},
	{#State 217
		ACTIONS => {
			"/" => 126,
			'DIV' => 131,
			'MOD' => 127
		},
		DEFAULT => -136
	},
	{#State 218
		ACTIONS => {
			'MOD' => 127
		},
		DEFAULT => -137
	},
	{#State 219
		ACTIONS => {
			'MOD' => 127,
			'CAT' => 134,
			'DIV' => 131,
			"+" => 130,
			"/" => 126,
			'BINOP' => 129,
			'CMPOP' => 128
		},
		DEFAULT => -141
	},
	{#State 220
		ACTIONS => {
			'DIV' => 131,
			'CAT' => 134,
			'MOD' => 127,
			'BINOP' => 129,
			'CMPOP' => 128,
			"/" => 126,
			"+" => 130
		},
		DEFAULT => -142
	},
	{#State 221
		ACTIONS => {
			'BINOP' => 129,
			'CMPOP' => 128,
			"/" => 126,
			"+" => 130,
			'DIV' => 131,
			'MOD' => 127
		},
		DEFAULT => -140
	},
	{#State 222
		ACTIONS => {
			'rawperl' => 68,
			'META' => 28,
			'FILTER' => 29,
			'SET' => 69,
			'USE' => 33,
			'CLEAR' => 61,
			'STOP' => 62,
			'LAST' => 63,
			'RAW' => 64,
			'VIEW' => 37,
			"\${" => 70,
			"{" => 36,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"[" => 45,
			'THROW' => 8,
			'IF' => 49,
			'perl' => 15,
			'BLOCK' => 14,
			'TRY' => 47,
			'REF' => 10,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'WHILE' => 7,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'MACRO' => 19,
			";" => -19,
			'CALL' => 20,
			'GET' => 59,
			'TEXT' => 25,
			'NEXT' => 60,
			'FOR' => 21,
			'SWITCH' => 22,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'DEFAULT' => 54,
			'IDENT' => 55
		},
		DEFAULT => -3,
		GOTOS => {
			'expr' => 27,
			'wrapper' => 3,
			'filter' => 26,
			'defblock' => 42,
			'sterm' => 4,
			'atomdir' => 46,
			'macro' => 67,
			'node' => 30,
			'view' => 31,
			'anonblock' => 65,
			'condition' => 43,
			'raw' => 9,
			'chunks' => 44,
			'use' => 66,
			'setlist' => 13,
			'chunk' => 34,
			'block' => 274,
			'assign' => 32,
			'statement' => 16,
			'capture' => 50,
			'javascript' => 35,
			'try' => 52,
			'directive' => 72,
			'ident' => 56,
			'switch' => 39,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'defblockname' => 23,
			'loop' => 74,
			'term' => 73
		}
	},
	{#State 223
		ACTIONS => {
			'TEXT' => 184,
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 275,
			"\${" => 70,
			";" => 187
		},
		GOTOS => {
			'ident' => 188,
			'item' => 40,
			'quotable' => 186,
			'node' => 30
		}
	},
	{#State 224
		ACTIONS => {
			'NUMBER' => 85,
			'IDENT' => 78,
			"\"" => 86,
			"\$" => 81,
			'LITERAL' => 84,
			'FILENAME' => 80
		},
		GOTOS => {
			'filename' => 82,
			'nameargs' => 276,
			'name' => 77,
			'names' => 83,
			'filepart' => 76
		}
	},
	{#State 225
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 226
		ACTIONS => {
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 92,
			"\$" => 41,
			"\"" => 6,
			'IDENT' => 55,
			"(" => 5,
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'sterm' => 4,
			'term' => 73,
			'ident' => 93,
			'node' => 30,
			'expr' => 277
		}
	},
	{#State 227
		ACTIONS => {
			"\$" => 41,
			'IDENT' => 55,
			"(" => 5,
			"\"" => 6,
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 92,
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'ident' => 93,
			'sterm' => 4,
			'term' => 73,
			'node' => 30,
			'expr' => 278
		}
	},
	{#State 228
		DEFAULT => -121
	},
	{#State 229
		DEFAULT => -122
	},
	{#State 230
		DEFAULT => -109
	},
	{#State 231
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 279
		}
	},
	{#State 232
		ACTIONS => {
			'TRY' => 47,
			'REF' => 10,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'perl' => 15,
			'BLOCK' => 14,
			'IF' => 49,
			'THROW' => 8,
			"[" => 45,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'WHILE' => 7,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'FOR' => 21,
			'SWITCH' => 22,
			'GET' => 59,
			'TEXT' => 25,
			'NEXT' => 60,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'PROCESS' => 58,
			'DEBUG' => 57,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'SET' => 69,
			'USE' => 33,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'LAST' => 63,
			'RAW' => 64,
			'STOP' => 62,
			'CLEAR' => 61,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"\${" => 70,
			"{" => 36,
			'VIEW' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 56,
			'directive' => 72,
			'try' => 52,
			'javascript' => 35,
			'statement' => 16,
			'capture' => 50,
			'defblockname' => 23,
			'term' => 73,
			'loop' => 74,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'switch' => 39,
			'defblock' => 42,
			'sterm' => 4,
			'filter' => 26,
			'expr' => 27,
			'wrapper' => 3,
			'assign' => 32,
			'block' => 280,
			'chunk' => 34,
			'setlist' => 13,
			'chunks' => 44,
			'use' => 66,
			'raw' => 9,
			'condition' => 43,
			'anonblock' => 65,
			'view' => 31,
			'node' => 30,
			'atomdir' => 46,
			'macro' => 67
		}
	},
	{#State 233
		ACTIONS => {
			"\${" => 70,
			'COMMA' => 252,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 253,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'IDENT' => 55,
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12,
			")" => 281
		},
		GOTOS => {
			'node' => 30,
			'lterm' => 75,
			'item' => 255,
			'term' => 73,
			'expr' => 254,
			'param' => 250,
			'sterm' => 4,
			'ident' => 251
		}
	},
	{#State 234
		DEFAULT => -115
	},
	{#State 235
		DEFAULT => -106
	},
	{#State 236
		DEFAULT => -116
	},
	{#State 237
		DEFAULT => -107
	},
	{#State 238
		ACTIONS => {
			'LITERAL' => 92,
			"\${" => 70,
			"\$" => 41,
			'REF' => 10,
			'IDENT' => 55,
			'NUMBER' => 12,
			"\"" => 6
		},
		GOTOS => {
			'node' => 30,
			'item' => 40,
			'sterm' => 282,
			'ident' => 93
		}
	},
	{#State 239
		ACTIONS => {
			'CATCH' => 285,
			'FINAL' => 283
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 284
		}
	},
	{#State 240
		ACTIONS => {
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'GET' => 59,
			'TEXT' => 25,
			'NEXT' => 60,
			'SWITCH' => 22,
			'FOR' => 21,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53,
			'IDENT' => 55,
			'DEFAULT' => 54,
			"[" => 45,
			'THROW' => 8,
			'BLOCK' => 14,
			'IF' => 49,
			'perl' => 15,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'TRY' => 47,
			'REF' => 10,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'WHILE' => 7,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'VIEW' => 37,
			"{" => 36,
			"\${" => 70,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'FILTER' => 29,
			'rawperl' => 68,
			'META' => 28,
			'USE' => 33,
			'SET' => 69,
			'STOP' => 62,
			'CLEAR' => 61,
			'LAST' => 63,
			'RAW' => 64
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 52,
			'statement' => 16,
			'capture' => 50,
			'javascript' => 35,
			'ident' => 56,
			'directive' => 72,
			'switch' => 39,
			'defblockname' => 23,
			'term' => 73,
			'loop' => 74,
			'lterm' => 75,
			'item' => 40,
			'atomexpr' => 24,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'defblock' => 42,
			'sterm' => 4,
			'use' => 66,
			'chunks' => 44,
			'anonblock' => 65,
			'raw' => 9,
			'condition' => 43,
			'node' => 30,
			'view' => 31,
			'atomdir' => 46,
			'macro' => 67,
			'assign' => 32,
			'block' => 286,
			'chunk' => 34,
			'setlist' => 13
		}
	},
	{#State 241
		DEFAULT => -126
	},
	{#State 242
		DEFAULT => -127
	},
	{#State 243
		DEFAULT => -90
	},
	{#State 244
		ACTIONS => {
			";" => -151,
			'AND' => 132,
			'BINOP' => 129,
			'IDENT' => -151,
			'CMPOP' => 128,
			'LITERAL' => -151,
			'DIV' => 131,
			"\${" => -151,
			"+" => 130,
			"/" => 126,
			'MOD' => 127,
			"?" => 125,
			'OR' => 133,
			"\$" => -151,
			'CAT' => 134,
			'COMMA' => -151
		},
		DEFAULT => -28
	},
	{#State 245
		DEFAULT => -132
	},
	{#State 246
		ACTIONS => {
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53,
			'IDENT' => 55,
			'DEFAULT' => 54,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'PROCESS' => 58,
			'DEBUG' => 57,
			'SWITCH' => 22,
			'FOR' => 21,
			'GET' => 59,
			'NEXT' => 60,
			'TEXT' => 25,
			'WRAPPER' => 2,
			'RETURN' => 1,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'WHILE' => 7,
			'THROW' => 8,
			"[" => 45,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'TRY' => 47,
			'REF' => 10,
			'BLOCK' => 14,
			'IF' => 49,
			'perl' => 15,
			"{" => 36,
			"\${" => 70,
			'VIEW' => 37,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'CLEAR' => 61,
			'STOP' => 62,
			'LAST' => 63,
			'RAW' => 64,
			'FILTER' => 29,
			'META' => 28,
			'rawperl' => 68,
			'USE' => 33,
			'SET' => 69
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 73,
			'defblockname' => 23,
			'loop' => 74,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'switch' => 39,
			'ident' => 56,
			'directive' => 72,
			'try' => 52,
			'capture' => 50,
			'javascript' => 35,
			'statement' => 16,
			'assign' => 32,
			'block' => 287,
			'chunk' => 34,
			'setlist' => 13,
			'chunks' => 44,
			'use' => 66,
			'anonblock' => 65,
			'raw' => 9,
			'condition' => 43,
			'node' => 30,
			'view' => 31,
			'atomdir' => 46,
			'macro' => 67,
			'sterm' => 4,
			'defblock' => 42,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27
		}
	},
	{#State 247
		ACTIONS => {
			'END' => 288
		}
	},
	{#State 248
		ACTIONS => {
			'IDENT' => 55,
			'LITERAL' => 253,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'COMMA' => 252,
			'NUMBER' => 12,
			'REF' => 10,
			"[" => 45
		},
		DEFAULT => -163,
		GOTOS => {
			'sterm' => 4,
			'ident' => 251,
			'expr' => 254,
			'param' => 250,
			'term' => 73,
			'lterm' => 75,
			'item' => 255,
			'node' => 30
		}
	},
	{#State 249
		DEFAULT => -171
	},
	{#State 250
		DEFAULT => -154
	},
	{#State 251
		ACTIONS => {
			'DOT' => 165,
			'ASSIGN' => 289
		},
		DEFAULT => -110
	},
	{#State 252
		DEFAULT => -156
	},
	{#State 253
		ACTIONS => {
			'ASSIGN' => 227
		},
		DEFAULT => -113
	},
	{#State 254
		ACTIONS => {
			'AND' => 132,
			'BINOP' => 129,
			'CMPOP' => 128,
			'DIV' => 131,
			'CAT' => 134,
			"/" => 126,
			"+" => 130,
			'OR' => 133,
			'MOD' => 127,
			"?" => 125
		},
		DEFAULT => -153
	},
	{#State 255
		ACTIONS => {
			'ASSIGN' => 226,
			"(" => 152
		},
		DEFAULT => -129
	},
	{#State 256
		DEFAULT => -166
	},
	{#State 257
		ACTIONS => {
			"\${" => 70,
			'COMMA' => 252,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 253,
			"\$" => 41,
			"(" => 5,
			'IDENT' => 55,
			"\"" => 6,
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12,
			")" => 290
		},
		GOTOS => {
			'expr' => 254,
			'param' => 250,
			'sterm' => 4,
			'ident' => 251,
			'node' => 30,
			'term' => 73,
			'lterm' => 75,
			'item' => 255
		}
	},
	{#State 258
		DEFAULT => -168
	},
	{#State 259
		ACTIONS => {
			'DIV' => 131,
			'CMPOP' => 128,
			'BINOP' => 129,
			'AND' => 132,
			'CAT' => 134,
			'OR' => 133,
			"?" => 125,
			'MOD' => 127,
			"/" => 126,
			"+" => 130
		},
		DEFAULT => -151
	},
	{#State 260
		ACTIONS => {
			'WHILE' => 7,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'perl' => 15,
			'IF' => 49,
			'BLOCK' => 14,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'REF' => 10,
			'TRY' => 47,
			"[" => 45,
			'THROW' => 8,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53,
			'GET' => 59,
			'TEXT' => 25,
			'NEXT' => 60,
			'SWITCH' => 22,
			'FOR' => 21,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'CALL' => 20,
			";" => -19,
			'MACRO' => 19,
			'LAST' => 63,
			'RAW' => 64,
			'STOP' => 62,
			'CLEAR' => 61,
			'USE' => 33,
			'SET' => 69,
			'FILTER' => 29,
			'rawperl' => 68,
			'META' => 28,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'VIEW' => 37,
			"{" => 36,
			"\${" => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 65,
			'raw' => 9,
			'condition' => 43,
			'use' => 66,
			'chunks' => 44,
			'macro' => 67,
			'atomdir' => 46,
			'view' => 31,
			'node' => 30,
			'block' => 291,
			'assign' => 32,
			'setlist' => 13,
			'chunk' => 34,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'defblock' => 42,
			'sterm' => 4,
			'switch' => 39,
			'term' => 73,
			'defblockname' => 23,
			'loop' => 74,
			'atomexpr' => 24,
			'item' => 40,
			'lterm' => 75,
			'capture' => 50,
			'statement' => 16,
			'javascript' => 35,
			'try' => 52,
			'ident' => 56,
			'directive' => 72
		}
	},
	{#State 261
		ACTIONS => {
			'END' => 292
		}
	},
	{#State 262
		ACTIONS => {
			'TEXT' => 293
		}
	},
	{#State 263
		DEFAULT => -103
	},
	{#State 264
		DEFAULT => -101
	},
	{#State 265
		ACTIONS => {
			'RAW' => 64,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'SET' => 69,
			'USE' => 33,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			'VIEW' => 37,
			"\${" => 70,
			"{" => 36,
			'WHILE' => 7,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'IF' => 49,
			'BLOCK' => 14,
			'perl' => 15,
			'TRY' => 47,
			'REF' => 10,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			"[" => 45,
			'THROW' => 8,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'INSERT' => 17,
			'LITERAL' => 18,
			'TEXT' => 25,
			'NEXT' => 60,
			'GET' => 59,
			'FOR' => 21,
			'SWITCH' => 22,
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 56,
			'directive' => 72,
			'try' => 52,
			'statement' => 16,
			'capture' => 50,
			'javascript' => 35,
			'loop' => 74,
			'defblockname' => 23,
			'term' => 73,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'switch' => 39,
			'sterm' => 4,
			'defblock' => 42,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'assign' => 32,
			'block' => 294,
			'chunk' => 34,
			'setlist' => 13,
			'use' => 66,
			'chunks' => 44,
			'anonblock' => 65,
			'condition' => 43,
			'raw' => 9,
			'view' => 31,
			'node' => 30,
			'atomdir' => 46,
			'macro' => 67
		}
	},
	{#State 266
		ACTIONS => {
			'COMMA' => 296,
			'IDENT' => 295,
			")" => 297
		}
	},
	{#State 267
		ACTIONS => {
			'IDENT' => -97,
			")" => -97,
			'COMMA' => -97
		},
		DEFAULT => -131
	},
	{#State 268
		ACTIONS => {
			'PROCESS' => 58,
			'DEBUG' => 57,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'TEXT' => 25,
			'NEXT' => 60,
			'GET' => 59,
			'SWITCH' => 22,
			'FOR' => 21,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NOT' => 53,
			'IDENT' => 55,
			'DEFAULT' => 54,
			"[" => 45,
			'THROW' => 8,
			'perl' => 15,
			'BLOCK' => 14,
			'IF' => 49,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'REF' => 10,
			'TRY' => 47,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'WHILE' => 7,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'VIEW' => 37,
			"{" => 36,
			"\${" => 70,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'FILTER' => 29,
			'rawperl' => 68,
			'META' => 28,
			'USE' => 33,
			'SET' => 69,
			'STOP' => 62,
			'CLEAR' => 61,
			'LAST' => 63,
			'RAW' => 64
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 56,
			'directive' => 72,
			'capture' => 50,
			'javascript' => 35,
			'statement' => 16,
			'try' => 52,
			'loop' => 74,
			'defblockname' => 23,
			'term' => 73,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'switch' => 39,
			'defblock' => 42,
			'sterm' => 4,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'block' => 298,
			'assign' => 32,
			'setlist' => 13,
			'chunk' => 34,
			'anonblock' => 65,
			'raw' => 9,
			'condition' => 43,
			'use' => 66,
			'chunks' => 44,
			'macro' => 67,
			'atomdir' => 46,
			'view' => 31,
			'node' => 30
		}
	},
	{#State 269
		DEFAULT => -157,
		GOTOS => {
			'args' => 299
		}
	},
	{#State 270
		DEFAULT => -157,
		GOTOS => {
			'args' => 300
		}
	},
	{#State 271
		ACTIONS => {
			'CASE' => 301
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 302
		}
	},
	{#State 272
		ACTIONS => {
			'END' => 303
		}
	},
	{#State 273
		ACTIONS => {
			'NOT' => 53,
			'LITERAL' => 92,
			"\${" => 70,
			"{" => 36,
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5,
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'ident' => 93,
			'term' => 73,
			'sterm' => 4,
			'node' => 30,
			'expr' => 304
		}
	},
	{#State 274
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 275
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 276
		DEFAULT => -158
	},
	{#State 277
		ACTIONS => {
			'DIV' => 131,
			'AND' => 132,
			'MOD' => 127,
			'OR' => 133,
			'CAT' => 134,
			'CMPOP' => 128,
			'BINOP' => 129,
			"?" => 125,
			"+" => 130,
			"/" => 126
		},
		DEFAULT => -125
	},
	{#State 278
		ACTIONS => {
			"?" => 125,
			"/" => 126,
			"+" => 130,
			'CMPOP' => 128,
			'BINOP' => 129,
			'OR' => 133,
			'MOD' => 127,
			'CAT' => 134,
			'DIV' => 131,
			'AND' => 132
		},
		DEFAULT => -124
	},
	{#State 279
		ACTIONS => {
			'SET' => 69,
			'USE' => 33,
			'rawperl' => 68,
			'META' => 28,
			'FILTER' => 29,
			'LAST' => 63,
			'RAW' => 64,
			'CLEAR' => 61,
			'STOP' => 62,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"\${" => 70,
			"{" => 36,
			'VIEW' => 37,
			'REF' => 10,
			'TRY' => 47,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'IF' => 49,
			'BLOCK' => 14,
			'perl' => 15,
			'THROW' => 8,
			"[" => 45,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'WHILE' => 7,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'FOR' => 21,
			'SWITCH' => 22,
			'NEXT' => 60,
			'TEXT' => 25,
			'GET' => 59,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 39,
			'term' => 73,
			'defblockname' => 23,
			'loop' => 74,
			'lterm' => 75,
			'item' => 40,
			'atomexpr' => 24,
			'try' => 52,
			'statement' => 16,
			'capture' => 50,
			'javascript' => 35,
			'ident' => 56,
			'directive' => 72,
			'chunks' => 44,
			'use' => 66,
			'raw' => 9,
			'condition' => 43,
			'anonblock' => 65,
			'view' => 31,
			'node' => 30,
			'macro' => 67,
			'atomdir' => 46,
			'assign' => 32,
			'block' => 306,
			'chunk' => 34,
			'setlist' => 13,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'defblock' => 42,
			'sterm' => 4
		}
	},
	{#State 280
		ACTIONS => {
			'ELSIF' => 309,
			'ELSE' => 308
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 307
		}
	},
	{#State 281
		DEFAULT => -130
	},
	{#State 282
		DEFAULT => -118
	},
	{#State 283
		ACTIONS => {
			";" => 310
		}
	},
	{#State 284
		ACTIONS => {
			'END' => 311
		}
	},
	{#State 285
		ACTIONS => {
			'FILENAME' => 80,
			";" => 312,
			'DEFAULT' => 313,
			'NUMBER' => 85,
			'IDENT' => 78
		},
		GOTOS => {
			'filename' => 314,
			'filepart' => 76
		}
	},
	{#State 286
		ACTIONS => {
			'ELSIF' => 309,
			'ELSE' => 308
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 315
		}
	},
	{#State 287
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 288
		DEFAULT => -67
	},
	{#State 289
		ACTIONS => {
			'LITERAL' => 92,
			'NOT' => 53,
			"{" => 36,
			"\${" => 70,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			"[" => 45,
			'NUMBER' => 12,
			'REF' => 10
		},
		GOTOS => {
			'lterm' => 75,
			'item' => 40,
			'term' => 73,
			'sterm' => 4,
			'ident' => 93,
			'expr' => 317,
			'node' => 30
		}
	},
	{#State 290
		DEFAULT => -165
	},
	{#State 291
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 292
		DEFAULT => -89
	},
	{#State 293
		ACTIONS => {
			"\"" => 319
		}
	},
	{#State 294
		ACTIONS => {
			'END' => 320
		}
	},
	{#State 295
		DEFAULT => -95
	},
	{#State 296
		DEFAULT => -96
	},
	{#State 297
		ACTIONS => {
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'INSERT' => 17,
			'LITERAL' => 18,
			'FOR' => 21,
			'SWITCH' => 22,
			'GET' => 59,
			'NEXT' => 60,
			'CALL' => 20,
			'PROCESS' => 58,
			'DEBUG' => 57,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'WHILE' => 7,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'TRY' => 47,
			'REF' => 10,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'BLOCK' => 195,
			'IF' => 49,
			'perl' => 15,
			'THROW' => 8,
			"[" => 45,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"\${" => 70,
			"{" => 36,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'SET' => 69,
			'FILTER' => 29
		},
		GOTOS => {
			'sterm' => 4,
			'filter' => 26,
			'expr' => 197,
			'wrapper' => 3,
			'assign' => 32,
			'setlist' => 13,
			'mdir' => 321,
			'condition' => 43,
			'node' => 30,
			'atomdir' => 46,
			'ident' => 87,
			'directive' => 198,
			'try' => 52,
			'javascript' => 35,
			'term' => 73,
			'loop' => 74,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'switch' => 39
		}
	},
	{#State 298
		ACTIONS => {
			'END' => 322
		}
	},
	{#State 299
		ACTIONS => {
			'REF' => 10,
			'NUMBER' => 12,
			"[" => 45,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 253,
			'COMMA' => 252,
			"\${" => 70,
			"{" => 36
		},
		DEFAULT => -65,
		GOTOS => {
			'sterm' => 4,
			'ident' => 251,
			'param' => 250,
			'expr' => 254,
			'term' => 73,
			'item' => 255,
			'lterm' => 75,
			'node' => 30
		}
	},
	{#State 300
		ACTIONS => {
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12,
			'NOT' => 53,
			'LITERAL' => 253,
			'COMMA' => 252,
			"\${" => 70,
			"{" => 36,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'IDENT' => 55
		},
		DEFAULT => -64,
		GOTOS => {
			'sterm' => 4,
			'ident' => 251,
			'param' => 250,
			'expr' => 254,
			'lterm' => 75,
			'item' => 255,
			'term' => 73,
			'node' => 30
		}
	},
	{#State 301
		ACTIONS => {
			"[" => 45,
			";" => 325,
			'REF' => 10,
			'NUMBER' => 12,
			'LITERAL' => 92,
			"\${" => 70,
			"{" => 36,
			'DEFAULT' => 324,
			"\$" => 41,
			"\"" => 6,
			'IDENT' => 55
		},
		GOTOS => {
			'node' => 30,
			'term' => 323,
			'sterm' => 4,
			'ident' => 93,
			'lterm' => 75,
			'item' => 40
		}
	},
	{#State 302
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 303
		DEFAULT => -83
	},
	{#State 304
		ACTIONS => {
			"/" => 126,
			"+" => 130,
			"?" => 125,
			'BINOP' => 129,
			'CMPOP' => 128,
			'OR' => 133,
			'MOD' => 127,
			'CAT' => 134,
			'AND' => 132,
			'DIV' => 131
		},
		DEFAULT => -144
	},
	{#State 305
		DEFAULT => -81
	},
	{#State 306
		ACTIONS => {
			'END' => 327
		}
	},
	{#State 307
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 308
		ACTIONS => {
			";" => 329
		}
	},
	{#State 309
		ACTIONS => {
			"[" => 45,
			'REF' => 10,
			'NUMBER' => 12,
			"\${" => 70,
			"{" => 36,
			'NOT' => 53,
			'LITERAL' => 92,
			"\$" => 41,
			'IDENT' => 55,
			"\"" => 6,
			"(" => 5
		},
		GOTOS => {
			'item' => 40,
			'lterm' => 75,
			'sterm' => 4,
			'ident' => 93,
			'term' => 73,
			'node' => 30,
			'expr' => 330
		}
	},
	{#State 310
		ACTIONS => {
			'LITERAL' => 18,
			'INSERT' => 17,
			'NOT' => 53,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'MACRO' => 19,
			";" => -19,
			'CALL' => 20,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'SWITCH' => 22,
			'FOR' => 21,
			'GET' => 59,
			'NEXT' => 60,
			'TEXT' => 25,
			'WRAPPER' => 2,
			'RETURN' => 1,
			"(" => 5,
			"\"" => 6,
			"\$" => 41,
			'WHILE' => 7,
			'THROW' => 8,
			"[" => 45,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'REF' => 10,
			'TRY' => 47,
			'IF' => 49,
			'BLOCK' => 14,
			'perl' => 15,
			"{" => 36,
			"\${" => 70,
			'VIEW' => 37,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'CLEAR' => 61,
			'STOP' => 62,
			'LAST' => 63,
			'RAW' => 64,
			'FILTER' => 29,
			'rawperl' => 68,
			'META' => 28,
			'USE' => 33,
			'SET' => 69
		},
		DEFAULT => -3,
		GOTOS => {
			'setlist' => 13,
			'chunk' => 34,
			'block' => 331,
			'assign' => 32,
			'atomdir' => 46,
			'macro' => 67,
			'node' => 30,
			'view' => 31,
			'anonblock' => 65,
			'condition' => 43,
			'raw' => 9,
			'use' => 66,
			'chunks' => 44,
			'sterm' => 4,
			'defblock' => 42,
			'wrapper' => 3,
			'expr' => 27,
			'filter' => 26,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'term' => 73,
			'loop' => 74,
			'defblockname' => 23,
			'switch' => 39,
			'directive' => 72,
			'ident' => 56,
			'capture' => 50,
			'statement' => 16,
			'javascript' => 35,
			'try' => 52
		}
	},
	{#State 311
		DEFAULT => -69
	},
	{#State 312
		ACTIONS => {
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'INSERT' => 17,
			'LITERAL' => 18,
			'NEXT' => 60,
			'TEXT' => 25,
			'GET' => 59,
			'FOR' => 21,
			'SWITCH' => 22,
			'PROCESS' => 58,
			'DEBUG' => 57,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'WHILE' => 7,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'IF' => 49,
			'perl' => 15,
			'BLOCK' => 14,
			'TRY' => 47,
			'REF' => 10,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			"[" => 45,
			'THROW' => 8,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			'VIEW' => 37,
			"\${" => 70,
			"{" => 36,
			'LAST' => 63,
			'RAW' => 64,
			'STOP' => 62,
			'CLEAR' => 61,
			'SET' => 69,
			'USE' => 33,
			'rawperl' => 68,
			'META' => 28,
			'FILTER' => 29
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 72,
			'ident' => 56,
			'try' => 52,
			'statement' => 16,
			'javascript' => 35,
			'capture' => 50,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'defblockname' => 23,
			'term' => 73,
			'loop' => 74,
			'switch' => 39,
			'sterm' => 4,
			'defblock' => 42,
			'expr' => 27,
			'wrapper' => 3,
			'filter' => 26,
			'chunk' => 34,
			'setlist' => 13,
			'assign' => 32,
			'block' => 332,
			'view' => 31,
			'node' => 30,
			'macro' => 67,
			'atomdir' => 46,
			'use' => 66,
			'chunks' => 44,
			'condition' => 43,
			'raw' => 9,
			'anonblock' => 65
		}
	},
	{#State 313
		ACTIONS => {
			";" => 333
		}
	},
	{#State 314
		ACTIONS => {
			'DOT' => 176,
			";" => 334
		}
	},
	{#State 315
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 316
		DEFAULT => -80
	},
	{#State 317
		ACTIONS => {
			'CAT' => 134,
			"/" => 126,
			"+" => 130,
			'OR' => 133,
			'MOD' => 127,
			"?" => 125,
			'BINOP' => 129,
			'AND' => 132,
			'DIV' => 131,
			'CMPOP' => 128
		},
		DEFAULT => -155
	},
	{#State 318
		DEFAULT => -62
	},
	{#State 319
		DEFAULT => -102
	},
	{#State 320
		DEFAULT => -94
	},
	{#State 321
		DEFAULT => -91
	},
	{#State 322
		DEFAULT => -59
	},
	{#State 323
		ACTIONS => {
			";" => 336
		}
	},
	{#State 324
		ACTIONS => {
			";" => 337
		}
	},
	{#State 325
		ACTIONS => {
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"\${" => 70,
			"{" => 36,
			'VIEW' => 37,
			'SET' => 69,
			'USE' => 33,
			'rawperl' => 68,
			'META' => 28,
			'FILTER' => 29,
			'RAW' => 64,
			'LAST' => 63,
			'STOP' => 62,
			'CLEAR' => 61,
			'FOR' => 21,
			'SWITCH' => 22,
			'NEXT' => 60,
			'GET' => 59,
			'TEXT' => 25,
			'MACRO' => 19,
			";" => -19,
			'CALL' => 20,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'TRY' => 47,
			'REF' => 10,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'IF' => 49,
			'perl' => 15,
			'BLOCK' => 14,
			'THROW' => 8,
			"[" => 45,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'WHILE' => 7,
			'RETURN' => 1,
			'WRAPPER' => 2
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 34,
			'setlist' => 13,
			'assign' => 32,
			'block' => 338,
			'view' => 31,
			'node' => 30,
			'macro' => 67,
			'atomdir' => 46,
			'chunks' => 44,
			'use' => 66,
			'raw' => 9,
			'anonblock' => 65,
			'condition' => 43,
			'defblock' => 42,
			'sterm' => 4,
			'expr' => 27,
			'wrapper' => 3,
			'filter' => 26,
			'item' => 40,
			'lterm' => 75,
			'atomexpr' => 24,
			'defblockname' => 23,
			'loop' => 74,
			'term' => 73,
			'switch' => 39,
			'directive' => 72,
			'ident' => 56,
			'try' => 52,
			'javascript' => 35,
			'capture' => 50,
			'statement' => 16
		}
	},
	{#State 326
		DEFAULT => -53
	},
	{#State 327
		DEFAULT => -78
	},
	{#State 328
		DEFAULT => -48
	},
	{#State 329
		ACTIONS => {
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'FOR' => 21,
			'SWITCH' => 22,
			'NEXT' => 60,
			'TEXT' => 25,
			'GET' => 59,
			'CALL' => 20,
			";" => -19,
			'MACRO' => 19,
			'DEBUG' => 57,
			'PROCESS' => 58,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'WHILE' => 7,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'REF' => 10,
			'TRY' => 47,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'BLOCK' => 14,
			'perl' => 15,
			'IF' => 49,
			'THROW' => 8,
			"[" => 45,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"\${" => 70,
			"{" => 36,
			'VIEW' => 37,
			'LAST' => 63,
			'RAW' => 64,
			'CLEAR' => 61,
			'STOP' => 62,
			'SET' => 69,
			'USE' => 33,
			'rawperl' => 68,
			'META' => 28,
			'FILTER' => 29
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 56,
			'directive' => 72,
			'javascript' => 35,
			'statement' => 16,
			'capture' => 50,
			'try' => 52,
			'term' => 73,
			'defblockname' => 23,
			'loop' => 74,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'switch' => 39,
			'sterm' => 4,
			'defblock' => 42,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'block' => 339,
			'assign' => 32,
			'setlist' => 13,
			'chunk' => 34,
			'anonblock' => 65,
			'raw' => 9,
			'condition' => 43,
			'chunks' => 44,
			'use' => 66,
			'atomdir' => 46,
			'macro' => 67,
			'view' => 31,
			'node' => 30
		}
	},
	{#State 330
		ACTIONS => {
			"/" => 126,
			"+" => 130,
			'OR' => 133,
			"?" => 125,
			";" => 340,
			'MOD' => 127,
			'AND' => 132,
			'BINOP' => 129,
			'CMPOP' => 128,
			'CAT' => 134,
			'DIV' => 131
		}
	},
	{#State 331
		DEFAULT => -73
	},
	{#State 332
		ACTIONS => {
			'CATCH' => 285,
			'FINAL' => 283
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 341
		}
	},
	{#State 333
		ACTIONS => {
			'TEXT' => 25,
			'NEXT' => 60,
			'GET' => 59,
			'FOR' => 21,
			'SWITCH' => 22,
			'DEBUG' => 57,
			'PROCESS' => 58,
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'INSERT' => 17,
			'LITERAL' => 18,
			'perl' => 15,
			'BLOCK' => 14,
			'IF' => 49,
			'TRY' => 47,
			'REF' => 10,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			"[" => 45,
			'THROW' => 8,
			'WHILE' => 7,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			'VIEW' => 37,
			"\${" => 70,
			"{" => 36,
			'SET' => 69,
			'USE' => 33,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'RAW' => 64,
			'LAST' => 63,
			'CLEAR' => 61,
			'STOP' => 62
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 72,
			'ident' => 56,
			'capture' => 50,
			'statement' => 16,
			'javascript' => 35,
			'try' => 52,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'loop' => 74,
			'defblockname' => 23,
			'term' => 73,
			'switch' => 39,
			'sterm' => 4,
			'defblock' => 42,
			'expr' => 27,
			'wrapper' => 3,
			'filter' => 26,
			'setlist' => 13,
			'chunk' => 34,
			'block' => 342,
			'assign' => 32,
			'atomdir' => 46,
			'macro' => 67,
			'node' => 30,
			'view' => 31,
			'anonblock' => 65,
			'raw' => 9,
			'condition' => 43,
			'use' => 66,
			'chunks' => 44
		}
	},
	{#State 334
		ACTIONS => {
			'RAW' => 64,
			'LAST' => 63,
			'CLEAR' => 61,
			'STOP' => 62,
			'USE' => 33,
			'SET' => 69,
			'FILTER' => 29,
			'META' => 28,
			'rawperl' => 68,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			"{" => 36,
			"\${" => 70,
			'VIEW' => 37,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'WHILE' => 7,
			'WRAPPER' => 2,
			'RETURN' => 1,
			'NUMBER' => 12,
			'INCLUDE' => 11,
			'REF' => 10,
			'TRY' => 47,
			'IF' => 49,
			'perl' => 15,
			'BLOCK' => 14,
			'THROW' => 8,
			"[" => 45,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'LITERAL' => 18,
			'INSERT' => 17,
			'NOT' => 53,
			'SWITCH' => 22,
			'FOR' => 21,
			'TEXT' => 25,
			'NEXT' => 60,
			'GET' => 59,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'PROCESS' => 58,
			'DEBUG' => 57
		},
		DEFAULT => -3,
		GOTOS => {
			'capture' => 50,
			'javascript' => 35,
			'statement' => 16,
			'try' => 52,
			'ident' => 56,
			'directive' => 72,
			'switch' => 39,
			'term' => 73,
			'loop' => 74,
			'defblockname' => 23,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'filter' => 26,
			'expr' => 27,
			'wrapper' => 3,
			'defblock' => 42,
			'sterm' => 4,
			'condition' => 43,
			'anonblock' => 65,
			'raw' => 9,
			'chunks' => 44,
			'use' => 66,
			'atomdir' => 46,
			'macro' => 67,
			'node' => 30,
			'view' => 31,
			'block' => 343,
			'assign' => 32,
			'setlist' => 13,
			'chunk' => 34
		}
	},
	{#State 335
		DEFAULT => -46
	},
	{#State 336
		ACTIONS => {
			'RAW' => 64,
			'LAST' => 63,
			'CLEAR' => 61,
			'STOP' => 62,
			'SET' => 69,
			'USE' => 33,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			"\${" => 70,
			"{" => 36,
			'VIEW' => 37,
			"\$" => 41,
			"\"" => 6,
			"(" => 5,
			'WHILE' => 7,
			'RETURN' => 1,
			'WRAPPER' => 2,
			'TRY' => 47,
			'REF' => 10,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'BLOCK' => 14,
			'IF' => 49,
			'perl' => 15,
			'THROW' => 8,
			"[" => 45,
			'DEFAULT' => 54,
			'IDENT' => 55,
			'NOT' => 53,
			'INSERT' => 17,
			'LITERAL' => 18,
			'FOR' => 21,
			'SWITCH' => 22,
			'GET' => 59,
			'TEXT' => 25,
			'NEXT' => 60,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'PROCESS' => 58,
			'DEBUG' => 57
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 39,
			'defblockname' => 23,
			'loop' => 74,
			'term' => 73,
			'atomexpr' => 24,
			'lterm' => 75,
			'item' => 40,
			'capture' => 50,
			'javascript' => 35,
			'statement' => 16,
			'try' => 52,
			'ident' => 56,
			'directive' => 72,
			'raw' => 9,
			'condition' => 43,
			'anonblock' => 65,
			'chunks' => 44,
			'use' => 66,
			'macro' => 67,
			'atomdir' => 46,
			'node' => 30,
			'view' => 31,
			'block' => 344,
			'assign' => 32,
			'setlist' => 13,
			'chunk' => 34,
			'filter' => 26,
			'wrapper' => 3,
			'expr' => 27,
			'defblock' => 42,
			'sterm' => 4
		}
	},
	{#State 337
		ACTIONS => {
			"\${" => 70,
			"{" => 36,
			'VIEW' => 37,
			'JAVASCRIPT' => 71,
			'UNLESS' => 38,
			'STOP' => 62,
			'CLEAR' => 61,
			'LAST' => 63,
			'RAW' => 64,
			'META' => 28,
			'rawperl' => 68,
			'FILTER' => 29,
			'SET' => 69,
			'USE' => 33,
			'NOT' => 53,
			'LITERAL' => 18,
			'INSERT' => 17,
			'DEFAULT' => 54,
			'IDENT' => 55,
			";" => -19,
			'CALL' => 20,
			'MACRO' => 19,
			'DEBUG' => 57,
			'PROCESS' => 58,
			'FOR' => 21,
			'SWITCH' => 22,
			'TEXT' => 25,
			'GET' => 59,
			'NEXT' => 60,
			'RETURN' => 1,
			'WRAPPER' => 2,
			"\$" => 41,
			"(" => 5,
			"\"" => 6,
			'WHILE' => 7,
			'THROW' => 8,
			"[" => 45,
			'REF' => 10,
			'TRY' => 47,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'IF' => 49,
			'BLOCK' => 14,
			'perl' => 15
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 39,
			'lterm' => 75,
			'item' => 40,
			'atomexpr' => 24,
			'loop' => 74,
			'defblockname' => 23,
			'term' => 73,
			'try' => 52,
			'javascript' => 35,
			'capture' => 50,
			'statement' => 16,
			'directive' => 72,
			'ident' => 56,
			'view' => 31,
			'node' => 30,
			'macro' => 67,
			'atomdir' => 46,
			'chunks' => 44,
			'use' => 66,
			'anonblock' => 65,
			'condition' => 43,
			'raw' => 9,
			'chunk' => 34,
			'setlist' => 13,
			'assign' => 32,
			'block' => 345,
			'expr' => 27,
			'wrapper' => 3,
			'filter' => 26,
			'sterm' => 4,
			'defblock' => 42
		}
	},
	{#State 338
		DEFAULT => -56
	},
	{#State 339
		DEFAULT => -51
	},
	{#State 340
		ACTIONS => {
			";" => -19,
			'MACRO' => 19,
			'CALL' => 20,
			'PROCESS' => 58,
			'DEBUG' => 57,
			'SWITCH' => 22,
			'FOR' => 21,
			'TEXT' => 25,
			'GET' => 59,
			'NEXT' => 60,
			'LITERAL' => 18,
			'INSERT' => 17,
			'NOT' => 53,
			'IDENT' => 55,
			'DEFAULT' => 54,
			'THROW' => 8,
			"[" => 45,
			'INCLUDE' => 11,
			'NUMBER' => 12,
			'REF' => 10,
			'TRY' => 47,
			'IF' => 49,
			'BLOCK' => 14,
			'perl' => 15,
			'WRAPPER' => 2,
			'RETURN' => 1,
			"\"" => 6,
			"(" => 5,
			"\$" => 41,
			'WHILE' => 7,
			"{" => 36,
			"\${" => 70,
			'VIEW' => 37,
			'UNLESS' => 38,
			'JAVASCRIPT' => 71,
			'FILTER' => 29,
			'META' => 28,
			'rawperl' => 68,
			'USE' => 33,
			'SET' => 69,
			'STOP' => 62,
			'CLEAR' => 61,
			'RAW' => 64,
			'LAST' => 63
		},
		DEFAULT => -3,
		GOTOS => {
			'assign' => 32,
			'block' => 346,
			'chunk' => 34,
			'setlist' => 13,
			'chunks' => 44,
			'use' => 66,
			'anonblock' => 65,
			'condition' => 43,
			'raw' => 9,
			'view' => 31,
			'node' => 30,
			'atomdir' => 46,
			'macro' => 67,
			'defblock' => 42,
			'sterm' => 4,
			'filter' => 26,
			'expr' => 27,
			'wrapper' => 3,
			'loop' => 74,
			'term' => 73,
			'defblockname' => 23,
			'lterm' => 75,
			'item' => 40,
			'atomexpr' => 24,
			'switch' => 39,
			'ident' => 56,
			'directive' => 72,
			'try' => 52,
			'capture' => 50,
			'javascript' => 35,
			'statement' => 16
		}
	},
	{#State 341
		DEFAULT => -72
	},
	{#State 342
		ACTIONS => {
			'CATCH' => 285,
			'FINAL' => 283
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 347
		}
	},
	{#State 343
		ACTIONS => {
			'CATCH' => 285,
			'FINAL' => 283
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 348
		}
	},
	{#State 344
		ACTIONS => {
			'CASE' => 301
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 349
		}
	},
	{#State 345
		DEFAULT => -55
	},
	{#State 346
		ACTIONS => {
			'ELSE' => 308,
			'ELSIF' => 309
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 350
		}
	},
	{#State 347
		DEFAULT => -71
	},
	{#State 348
		DEFAULT => -70
	},
	{#State 349
		DEFAULT => -54
	},
	{#State 350
		DEFAULT => -50
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
