use common::sense;

our $VERSION = '0.75';

# ABSTRACT: Work with a deck of playing cards in the fashion engineered by Duane O'Brien of I.B.M. developerWorks.

package Helper::Deck {
    use Moose;
    
    use common::sense;
 
    use List::Util qw(shuffle);
   
    use feature 'say';
   
    sub roll {
        my $self = shift;
        my $sides = shift;
        return(int( rand( $sides ) + 1));
    }
   
    sub random_nick {
        my $self = shift;
        my @nicks = @_;
 
        return((shuffle(@nicks))[-1]);
    }
   
    sub random_name {
        my $self = shift;
        my @names = @_;
 
        return((shuffle(@names))[-1]);
    }
   
    use Data::Dumper;
    
    sub random_scenario {
        my $self = shift;
        my %args = @_;
       
        my @settings = shuffle(@{$args{settings}});
        my @objectives = shuffle(@{$args{objectives}});
        my @antagonists = shuffle(@{$args{antagonists}});
        my @complications = shuffle(@{$args{complications}});
            
        return(
            'setting' => $settings[-1],
            'objective' => $objectives[-1],
            'antagonist' => $antagonists[-1],
            'complication' => $complications[-1],
        );
    }
   
    sub build_deck {
        my $self = shift;
        
        my @suits = (
            'Spades',
            'Hearts',
            'Clubs',
            'Diamonds',
        );
       
        my @faces = (
            'Two',
            'Three',
            'Four',
            'Five',
            'Six',
            'Seven',
            'Eight',
            'Nine',
            'Ten',
            'Jack',
            'Queen',
            'King',
            'Ace',
        );
       
        my @deck;
       
        foreach my $suit (@suits) {
            foreach my $face (@faces) {
                push @deck,\%{{'face' => $face, 'suit' => $suit}};
            }
        }
        
        return(\@deck);
    }
   
    sub shuffle_deck {
        my $self = shift;
        my $deck_ref = shift;
        my @deck = @{$deck_ref};
        my @shuffled_deck = shuffle(@deck);
        return(\@shuffled_deck);
    }
   
    sub top_card {
        my $self = shift;
        my $deck_ref = shift;
        my $card = pop @{$deck_ref};
        return($card);        
    }
   
    sub card_to_string {
        my $self = shift;
        my $card_ref = shift;
        my %card = %{$card_ref};
       
        return($card{face} . ' of ' . $card{suit});
    }
   
    sub draw {
        my $self = shift;
        my $deck_ref = shift;
        my $max = shift;
        my @deck = @{$deck_ref};
        my @draw;
       
        foreach my $item (1 .. $max ) {
            push(@draw,$self->top_card($deck_ref));
        }
       
        return(\@draw);
    }
   
    sub calculate_odds {
        my $self = shift;
        my $deck = shift;
        my $chosen = shift;
              
        my $remaining = scalar @{$deck};
        my $odds = 0;
        foreach my $card (@{$deck}) {
            $odds++ if (($card->{'face'} eq $chosen->{'face'} && $card->{'suit'} eq $chosen->{'suit'}) || ($card->{'face'} eq '' && $card->{'suit'} eq $chosen->{'suit'}) || ($chosen->{'face'} eq $chosen->{'face'} && $card->{'suit'} eq ''));
        }
       
        return($odds . ' in ' . $remaining);
    }
   
    sub build_lc_letter_array {
        my $self = shift;
        return('a' .. 'z');
    }
    
    sub build_uc_letter_array {
        my $self = shift;
        return('A' .. 'Z');
    }
}
 
1;

__END__

# MAN3 POD

=head1 NAME

Helper::Deck - Work with a deck of playing cards in the fashion engineered by Duane O'Brien of I.B.M. developerWorks.

=cut

=head1 SYNOPSIS

    ...
    
=cut

=head1 INTRODUCTION

Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam scelerisque id nunc nec volutpat. Etiam pellentesque tristique arcu, non consequat magna fermentum ac. Cras ut ultricies eros. Maecenas eros justo, ullamcorper a sapien id, viverra ultrices eros. Morbi sem neque, posuere et pretium eget, bibendum sollicitudin lacus. Aliquam eleifend sollicitudin diam, eu mattis nisl maximus sed. Nulla imperdiet semper molestie. Morbi massa odio, condimentum sed ipsum ac, gravida ultrices erat. Nullam eget dignissim mauris, non tristique erat. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae;

=cut

=head1 METHODS

=head2 method1
    Usage :
    
        Arguments : 
            a1 = argument one,
            a2 = argument two,
        Return :
            r = description of return value,
            
        my $r = $obj->method1($a1, $a2);

Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam scelerisque id nunc nec volutpat. Etiam pellentesque tristique arcu, non consequat magna fermentum ac. Cras ut ultricies eros. Maecenas eros justo, ullamcorper a sapien id, viverra ultrices eros. Morbi sem neque, posuere et pretium eget, bibendum sollicitudin lacus. Aliquam eleifend sollicitudin diam, eu mattis nisl maximus sed. Nulla imperdiet semper molestie. Morbi massa odio, condimentum sed ipsum ac, gravida ultrices erat. Nullam eget dignissim mauris, non tristique erat. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae;

=cut

=head1 AUTHOR

Jason McVeigh, <jmcveigh@outlook.com>

=cut

=head1 COPYRIGHT AND LICENSE

Copyright 2016 by Jason McVeigh

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut