use Perlmazing;
use Win32::Symlinks;
use Test::More;

if ($^O eq 'MSWin32') {
	my @parts = File::Spec->splitpath(cwd);
	my $volume = shift @parts;
	my $error;
	if ($volume and $volume =~ /^\w:$/) {
		my $cmd = $ENV{COMSPEC} || 'cmd.exe';
		my $r = `"$cmd" /c fsutil fsinfo volumeinfo $volume 2>&1`;
		if ($r !~ /:\s+NTFS\n/) {
			$error = 'This code seems to be running on a filesystem different than NTFS.';
		}
	} else {
		$error = 'Could not detect the current system volume.';
	}
	if ($error) {
		plan skip_all => $error;
	}
}

plan tests => 25;

my $folder1 = 'testfolder'.time;
my $folder2 = 'testfolder_link'.time;
my $file1 = 'testfile1'.time;
my $file2 = 'testfile_link'.time;
my $invalid_path = 'invalid_path'.time;
my $content1 = 'Hello world! '.scalar localtime;
sleep 1;
my $content2 = 'Hello world! '.scalar localtime;


mkdir $folder1;
open my $out, '>', $file1 or die "Cannot create file $file1: $!";
print $out $content1;
close $out;

is -f $file1, 1, 'File1 exists';

my $file1_data = slurp $file1;
is $file1_data, $content1, 'File1 has the right content';

symlink $folder1, $folder2;
is -d $folder2, 1, 'Folder2 exists';
is -l $folder2, 1, 'Folder2 is a symlink';
is readlink($folder2), $folder1, 'Symlink points correctly';

symlink File::Spec->catfile('..', $file1), File::Spec->catfile($folder2, $file2);
is -f File::Spec->catfile($folder2, $file2), 1, 'File2 exists';
is -l File::Spec->catfile($folder2, $file2), 1, 'File2 is a symlink';
is readlink(File::Spec->catfile($folder2, $file2)), File::Spec->catfile('..', $file1), 'File2 points correctly';

my $file2_data = slurp (File::Spec->catfile($folder2, $file2));
is $file2_data, $content1, 'File2 data is correct';

open my $out2, '>', File::Spec->catfile($folder2, $file2) or die "Cannot write to $file2: $!";
print $out2 $content2;
close $out2;

$file2_data = slurp (File::Spec->catfile($folder2, $file2));
is $file2_data, $content2, 'File2 new data is correct';

$file1_data = slurp $file1;
is $file1_data, $content2, 'File1 new data is correct';

symlink $invalid_path, 'invalid_symlink';
is -l 'invalid_symlink', 1, 'Invalid symlink was created and is symlink';
isnt -f 'invalid_symlink', 1, 'Invalid symlink returns false with -f';
isnt -d 'invalid_symlink', 1, 'Invalid symlink returns false with -d';
isnt -e 'invalid_symlink', 1, 'Invalid symlink returns false with -e';
is readlink('invalid_symlink'), $invalid_path, 'Readlink works with invalid symlink';
unlink 'invalid_symlink';
isnt -l 'invalid_symlink', 1, 'Invalid symlink is gone';

unlink $folder2;
isnt -d $folder2, 1, 'Folder2 is gone with unlink';

is -f File::Spec->catfile($folder1, $file2), 1, 'File2 still exists in Folder1';
is -l File::Spec->catfile($folder1, $file2), 1, 'File2 is a symlink as expected';
$file1_data = slurp (File::Spec->catfile($folder1, $file2));
is $file1_data, $content2, 'The content of the symlinked file is correct';

unlink File::Spec->catfile($folder1, $file2);
isnt -f File::Spec->catfile($folder1, $file2), 1, 'File2 is gone with unlink';

unlink $file1;
isnt -f $file1, 1, 'File1 is gone with unlink';

unlink $folder1;
is -d $folder1, 1, 'Folder1 was not removed by unlink';

rmdir $folder1;
isnt -d $folder1, 1, 'Folder1 is gone';
