use 5.006;
use strict;
use warnings;
use ExtUtils::MakeMaker;
my $file_spec = eval {
	require File::Spec;
};

my %WriteMakefileArgs = (
    NAME             => 'Win32::Symlinks',
    AUTHOR           => q{Francisco Zarabozo <zarabozo@cpan.org>},
    VERSION_FROM     => 'lib/Win32/Symlinks.pm',
    ABSTRACT_FROM    => 'lib/Win32/Symlinks.pm',
    LICENSE          => 'perl_5',
    MIN_PERL_VERSION => '5.006',
    CONFIGURE_REQUIRES => {
		'ExtUtils::MakeMaker' => '7.12',
		'Perlmazing'		  => '1.2816',
    },
    TEST_REQUIRES => {
        'Test::More' => '0',
		'Perlmazing' => '1.2816',
    },
    PREREQ_PM => {
        'Perlmazing' => '1.2816',
    },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Win32-Symlinks-*' },
	#CCFLAGS => '-Wall -std=c99',
	OPTIMIZE => '-O3',
	XSMULTI => 1,
);

# Compatibility with old versions of ExtUtils::MakeMaker
unless (eval { ExtUtils::MakeMaker->VERSION('6.64'); 1 }) {
    my $test_requires = delete $WriteMakefileArgs{TEST_REQUIRES} || {};
    @{$WriteMakefileArgs{PREREQ_PM}}{keys %$test_requires} = values %$test_requires;
}

unless (eval { ExtUtils::MakeMaker->VERSION('6.55_03'); 1 }) {
    my $build_requires = delete $WriteMakefileArgs{BUILD_REQUIRES} || {};
    @{$WriteMakefileArgs{PREREQ_PM}}{keys %$build_requires} = values %$build_requires;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
    unless eval { ExtUtils::MakeMaker->VERSION('6.52'); 1 };
delete $WriteMakefileArgs{MIN_PERL_VERSION}
    unless eval { ExtUtils::MakeMaker->VERSION('6.48'); 1 };
delete $WriteMakefileArgs{LICENSE}
    unless eval { ExtUtils::MakeMaker->VERSION('6.31'); 1 };


rm_dir('lib');
if ($^O eq 'MSWin32') {
	cp_dir('lib_win32', 'lib');
} else {
	cp_dir('lib_mockup', 'lib');
}

WriteMakefile(%WriteMakefileArgs);

# Using custom file management functions to avoid calling for uninstalled modules in Makefile.PL

sub rm_dir {
	my $path = shift;
	$path = get_path($path);
	return unless -e $path;
	if (-d $path) {
		opendir my $dir, $path or die "Cannot open directory $path: $!";
		while (my $item = readdir $dir) {
			next if $item =~ /^(\.|\..)$/;
			my $i = get_path($path, $item);
			if (-f $i) {
				my $r = unlink $i;
				die "Cannot remove file $i: $!" unless $r;
			} elsif (-d $i) {
				rm_dir($i);
			}
		}
		closedir $dir;
		my $r = rmdir $path;
		die "Cannot remove directory $path: $!" unless $r;
	} else {
		die "$path is not a directory!";
	}
}

sub cp_dir {
	my ($path_old, $path_new) = (shift, shift);
	$path_old = get_path($path_old);
	$path_new = get_path($path_new);
	if (-e $path_new) {
		die "Cannot copy $path_old into $path_new: the destination exists!\n";
	}
	if (-d $path_old) {
		mkdir $path_new;
		opendir my $dir, $path_old or die "Cannot open directory $path_old: $!";
		while (my $item = readdir $dir) {
			next if $item =~ /^(\.|\..)$/;
			my $i_old = get_path($path_old, $item);
			my $i_new = get_path($path_new, $item);
			if (-f $i_old) {
				open my $in, '<', $i_old or die "Cannot read file $i_old: $!";
				binmode $in;
				open my $out, '>', $i_new or die "Cannot create file $i_new: $!";
				binmode $out;
				while (defined (my $line = <$in>)) {
					print $out $line;
				}
				close $out;
				close $in;
			} elsif (-d $i_old) {
				cp_dir($i_old, $i_new);
			}
		}
		closedir $dir;
	} else {
		die "$path_old is not a directory!";
	}
}

sub get_path {
	my @items = @_;
	for my $i (@items) {
		if ($file_spec) {
			$i = File::Spec->catdir(File::Spec->splitdir($i));
		}
	}
	if ($file_spec) {
		return File::Spec->catdir(@items);
	}
	join '/', @items;
}