package Twilio::Calls::Call;
use Perlmazing;
use parent 'Twilio::Collection::Resource';

sub recordings {
	my $self = shift;
	my $r = $self->Twilio->get($self->get_root_url.$self->{subresource_uris}->{recordings}, {PageSize => 1000});
	for my $i (@{$r->{recordings}}) {
		push @{$self->{recordings}}, $i;
	}
	while ($r->{next_page_uri}) {
		$r = $self->Twilio->get($self->get_root_url.$r->{next_page_uri}, {PageSize => 1000});
		for my $i (@{$r->{recordings}}) {
			push @{$self->{recordings}}, $i;
		}
	}
	for my $i (@{$self->{recordings}}) {
		$i = Twilio::Recordings::Recording->new(Twilio => $self->Twilio, %$i);
	}
	@{$self->{recordings}};
}

sub notifications {
	my $self = shift;
	my $r = $self->Twilio->get($self->get_root_url.$self->{subresource_uris}->{notifications}, {PageSize => 1000});
	for my $i (@{$r->{notifications}}) {
		push @{$self->{notifications}}, $i;
	}
	while ($r->{next_page_uri}) {
		$r = $self->Twilio->get($self->get_root_url.$r->{next_page_uri}, {PageSize => 1000});
		for my $i (@{$r->{notifications}}) {
			push @{$self->{notifications}}, $i;
		}
	}
	for my $i (@{$self->{notifications}}) {
		$i = Twilio::Notifications::Notification->new(Twilio => $self->Twilio, %$i);
	}
	@{$self->{notifications}};
}

sub url : lvalue {
	my $self = shift;
	$self->{url};
}

1;
