package QQ::exmail;

=encoding utf8

=head1 Name
QQ::exmail

=head1 DESCRIPTION
腾讯企业邮->接口文档
L<https://exmail.qq.com/qy_mng_logic/doc#10001>
=cut

use strict;
use Encode;
use LWP::UserAgent;
use JSON;
use utf8;

our $VERSION = '1.04';
our @EXPORT = qw/ gettoken /;

=head2 gettoken
gettoken(corpid,corpsecrect);
L<https://exmail.qq.com/qy_mng_logic/doc#10003>
=cut

sub gettoken {
    if ( @_ && $_[0] && $_[1] ) {
        my $corpid = $_[0];
        my $corpsecret = $_[1];
        my $ua = LWP::UserAgent->new;
        $ua->timeout(30);
        $ua->env_proxy;

        my $response = $ua->get("https://api.exmail.qq.com/cgi-bin/gettoken?corpid=$corpid&corpsecret=$corpsecret");
        if ($response->is_success) {
            return from_json($response->decoded_content,{utf8 => 1, allow_nonref => 1});
        }

    }
    return 0;
}


1;
__END__
