#!perl
use 5.006;
use strict;
use warnings;
use Test::More tests => 2;

BEGIN {
    use_ok( 'Tk::JDialog' ) || print "Bail out!\n";
}

diag( "Testing Tk::JDialog $Tk::JDialog::VERSION, Perl $], $^X" );

sub sam {
	my $mw = MainWindow->new( -title => 'Test' );
	my $Dialog = $mw->JDialog(
	     -title          => 'Choose!',   #DISPLAY A WINDOW TITLE
	     -text           => 'Press Ok to Continue',  #DISPLAY A CAPTION
	     -bitmap         => 'info',      #DISPLAY BUILT-IN info BITMAP.
	     -default_button => '~Ok',
	     -escape_button  => '~Cancel',
	     -buttons        => ['~Ok', '~Cancel', '~Quit'], #DISPLAY 3 BUTTONS
	);
	my $button_label = $Dialog->Show();
	return ($button_label =~ /\~(?:Ok|Cancel|Quit)$/) ? 1 : 0;
}

#&sam() ? print "not ok 2\n" : print "ok 2\n";
#print "..done: 2 tests completed.\n";
is(&sam(), 1, 'running Tk::JDialog sample program');

diag( "Testing Tk::JDialog $Tk::JDialog::VERSION, Perl $], $^X" );

__END__
