use strict;
use ExtUtils::MakeMaker 6.17;

my $EUMM = eval( $ExtUtils::MakeMaker::VERSION );

my $meta = {
  "abstract"           => "Moose-like OO, fast to load, with zero dependencies",
  "author"             => ["Toby Inkster (TOBYINK) <tobyink\@cpan.org>"],
  "dynamic_config"     => 1,
  "generated_by"       => "Dist::Inkt::Profile::TOBYINK version 0.024, CPAN::Meta::Converter version 2.150010",
  "keywords"           => [],
  "license"            => ["perl_5"],
  "meta-spec"          => {
                            url => "http://search.cpan.org/perldoc?CPAN::Meta::Spec",
                            version => 2,
                          },
  "name"               => "Mite",
  "no_index"           => { directory => ["eg", "examples", "inc", "t", "xt"] },
  "prereqs"            => {
                            configure => { requires => { "ExtUtils::MakeMaker" => 6.17 } },
                            develop   => { recommends => { "Dist::Inkt" => 0.001 } },
                            runtime   => {
                                           requires => {
                                             "Getopt::Kingpin"      => "0.10",
                                             "Import::Into"         => 0,
                                             "Module::Pluggable"    => 5.2,
                                             "namespace::autoclean" => 0,
                                             "Path::Tiny"           => 0.052,
                                             "perl"                 => 5.010001,
                                             "Types::Path::Tiny"    => 0,
                                             "Types::Standard"      => "1.014000",
                                             "YAML::XS"             => 0.41,
                                           },
                                         },
                            test      => {
                                           requires => {
                                             "Capture::Tiny"         => 0.22,
                                             "Child"                 => "0.010",
                                             "Devel::Hide"           => 0.0009,
                                             "Fennec"                => 2.016,
                                             "File::Copy::Recursive" => 0.38,
                                             "Test::Compile"         => 0.24,
                                             "Test::Deep"            => "0.110",
                                             "Test::FailWarnings"    => 0.008,
                                             "Test::Most"            => 0.31,
                                             "Test::Output"          => 1.02,
                                             "Test::Sims"            => 20130412,
                                           },
                                         },
                          },
  "provides"           => {
                            "Mite"                        => { file => "lib/Mite.pm", version => 0.006005 },
                            "Mite::App"                   => { file => "lib/Mite/App.pm", version => 0.006005 },
                            "Mite::App::Command"          => { file => "lib/Mite/App/Command.pm", version => 0.006005 },
                            "Mite::App::Command::clean"   => { file => "lib/Mite/App/Command/clean.pm", version => 0.006005 },
                            "Mite::App::Command::compile" => { file => "lib/Mite/App/Command/compile.pm", version => 0.006005 },
                            "Mite::App::Command::init"    => { file => "lib/Mite/App/Command/init.pm", version => 0.006005 },
                            "Mite::App::Command::preview" => { file => "lib/Mite/App/Command/preview.pm", version => 0.006005 },
                            "Mite::Attribute"             => { file => "lib/Mite/Attribute.pm", version => 0.006005 },
                            "Mite::Class"                 => { file => "lib/Mite/Class.pm", version => 0.006005 },
                            "Mite::Compiled"              => { file => "lib/Mite/Compiled.pm", version => 0.006005 },
                            "Mite::Config"                => { file => "lib/Mite/Config.pm", version => 0.006005 },
                            "Mite::MakeMaker"             => { file => "lib/Mite/MakeMaker.pm", version => 0.006005 },
                            "Mite::Miteception"           => { file => "lib/Mite/Miteception.pm", version => 0.006005 },
                            "Mite::ModuleBuild"           => { file => "lib/Mite/ModuleBuild.pm", version => 0.006005 },
                            "Mite::Project"               => { file => "lib/Mite/Project.pm", version => 0.006005 },
                            "Mite::Role"                  => { file => "lib/Mite/Role.pm", version => 0.006005 },
                            "Mite::Role::Tiny"            => { file => "lib/Mite/Role/Tiny.pm", version => 0.006005 },
                            "Mite::Shim"                  => { file => "lib/Mite/Shim.pm" },
                            "Mite::Source"                => { file => "lib/Mite/Source.pm", version => 0.006005 },
                          },
  "release_status"     => "stable",
  "resources"          => {
                            bugtracker   => { web => "https://github.com/tobyink/p5-mite/issues" },
                            homepage     => "https://metacpan.org/release/Mite",
                            license      => ["http://dev.perl.org/licenses/"],
                            repository   => {
                                              type => "git",
                                              url  => "git://github.com/tobyink/p5-mite.git",
                                              web  => "https://github.com/tobyink/p5-mite",
                                            },
                            x_identifier => "http://purl.org/NET/cpan-uri/dist/Mite/project",
                          },
  "version"            => 0.006005,
  "x_contributors"     => ["Michael G Schwern (MSCHWERN) <mschwern\@cpan.org>"],
  "x_provides_scripts" => { mite => { file => "bin/mite" } },
};

my %dynamic_config;
do {
if ($] < 5.010000) {
	$meta->{prereqs}{runtime}{requires}{'MRO::Compat'} = 0;
}

if ($] < 5.014000) {
        $meta->{prereqs}{runtime}{requires}{'Devel::GlobalDestruction'} = 0;
}

};

my %WriteMakefileArgs = (
	ABSTRACT   => $meta->{abstract},
	AUTHOR     => ($EUMM >= 6.5702 ? $meta->{author} : $meta->{author}[0]),
	DISTNAME   => $meta->{name},
	VERSION    => $meta->{version},
	EXE_FILES  => [ map $_->{file}, values %{ $meta->{x_provides_scripts} || {} } ],
	NAME       => do { my $n = $meta->{name}; $n =~ s/-/::/g; $n },
	test       => { TESTS => "t/*.t t/MakeMaker/*.t t/Mite-Attribute/*.t t/Mite-Class/*.t t/Mite-Compiled/*.t t/Mite-Config/*.t t/Mite-Project/*.t t/Mite-Role-Tiny/*.t t/Mite-Role/*.t t/Mite-Shim/*.t t/Mite-Source/*.t t/Module-Build/*.t t/Test-Mite/*.t t/mite/*.t" },
	%dynamic_config,
);

$WriteMakefileArgs{LICENSE} = $meta->{license}[0] if $EUMM >= 6.3001;

sub deps
{
	my %r;
	for my $stage (@_)
	{
		for my $dep (keys %{$meta->{prereqs}{$stage}{requires}})
		{
			next if $dep eq 'perl';
			my $ver = $meta->{prereqs}{$stage}{requires}{$dep};
			$r{$dep} = $ver if !exists($r{$dep}) || $ver >= $r{$dep};
		}
	}
	\%r;
}

my ($build_requires, $configure_requires, $runtime_requires, $test_requires);
if ($EUMM >= 6.6303)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{TEST_REQUIRES}      ||= deps('test');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');
}
elsif ($EUMM >= 6.5503)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build', 'test');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');	
}
elsif ($EUMM >= 6.52)
{
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime', 'build', 'test');	
}
else
{
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('configure', 'build', 'test', 'runtime');	
}

{
	my ($minperl) = reverse sort(
		grep defined && /^[0-9]+(\.[0-9]+)?$/,
		map $meta->{prereqs}{$_}{requires}{perl},
		qw( configure build runtime )
	);
	
	if (defined($minperl))
	{
		die "Installing $meta->{name} requires Perl >= $minperl"
			unless $] >= $minperl;
		
		$WriteMakefileArgs{MIN_PERL_VERSION} ||= $minperl
			if $EUMM >= 6.48;
	}
}


my $mm = WriteMakefile(%WriteMakefileArgs);

exit(0);

