package Geo::Coordinates::OSTN02;
require Exporter;
use strict;
use warnings;

our @ISA = qw(Exporter);
our $VERSION = '2.00';
our @EXPORT = qw();
our @EXPORT_OK = qw(
    OSGB36_to_ETRS89
    ETRS89_to_OSGB36
);

# OSTN02 Data (lots of it...)
print STDERR "Loading OSTN02 transformation data...";
our %ostn_shift_for=(
80=>[91.888,-81.603,53.184,2],
81=>[91.903,-81.597,53.178,2],
82=>[91.917,-81.592,53.173,2],
83=>[91.936,-81.582,53.168,2],
84=>[91.956,-81.569,53.164,2],
85=>[91.976,-81.557,53.160,2],
86=>[91.996,-81.545,53.157,2],
87=>[92.016,-81.534,53.154,2],
88=>[92.035,-81.522,53.151,2],
89=>[92.056,-81.510,53.148,2],
90=>[92.076,-81.497,53.143,2],
91=>[92.096,-81.485,53.139,2],
92=>[92.116,-81.473,53.135,2],
93=>[92.139,-81.462,53.131,2],
94=>[92.163,-81.450,53.127,2],
95=>[92.188,-81.439,53.123,2],
96=>[92.212,-81.428,53.117,2],
97=>[92.236,-81.416,53.112,2],
98=>[92.261,-81.405,53.105,2],
99=>[92.285,-81.394,53.098,2],
100=>[92.310,-81.382,53.092,2],
780=>[91.873,-81.579,53.192,2],
781=>[91.887,-81.574,53.184,2],
782=>[91.902,-81.569,53.178,2],
783=>[91.916,-81.563,53.172,2],
784=>[91.932,-81.557,53.167,2],
785=>[91.951,-81.545,53.162,2],
786=>[91.971,-81.533,53.158,2],
787=>[91.992,-81.521,53.155,2],
788=>[92.012,-81.509,53.152,2],
789=>[92.031,-81.497,53.148,2],
790=>[92.052,-81.484,53.145,2],
791=>[92.072,-81.473,53.140,2],
792=>[92.091,-81.461,53.136,2],
793=>[92.115,-81.450,53.132,2],
794=>[92.140,-81.437,53.128,2],
795=>[92.164,-81.426,53.124,2],
796=>[92.189,-81.415,53.119,2],
797=>[92.213,-81.403,53.114,2],
798=>[92.237,-81.392,53.108,2],
799=>[92.262,-81.381,53.102,2],
800=>[92.286,-81.369,53.094,2],
801=>[92.311,-81.358,53.089,2],
802=>[92.336,-81.347,53.082,2],
1480=>[91.858,-81.556,53.201,2],
1481=>[91.872,-81.550,53.193,2],
1482=>[91.887,-81.545,53.185,2],
1483=>[91.901,-81.540,53.179,2],
1484=>[91.916,-81.535,53.172,2],
1485=>[91.930,-81.529,53.166,2],
1486=>[91.947,-81.520,53.161,2],
1487=>[91.967,-81.508,53.157,2],
1488=>[91.988,-81.496,53.154,2],
1489=>[92.007,-81.484,53.150,2],
1490=>[92.027,-81.472,53.146,2],
1491=>[92.048,-81.460,53.143,2],
1492=>[92.068,-81.448,53.137,2],
1493=>[92.092,-81.437,53.133,2],
1494=>[92.117,-81.425,53.129,2],
1495=>[92.141,-81.414,53.124,2],
1496=>[92.165,-81.403,53.120,2],
1497=>[92.190,-81.391,53.116,2],
1498=>[92.214,-81.380,53.110,2],
1499=>[92.239,-81.368,53.105,2],
1500=>[92.263,-81.356,53.098,2],
1501=>[92.288,-81.345,53.091,2],
1502=>[92.312,-81.334,53.085,2],
1503=>[92.337,-81.322,53.079,2],
1504=>[92.356,-81.315,53.072,2],
1569=>[93.499,-80.739,53.060,1],
1570=>[93.513,-80.729,53.056,1],
1571=>[93.520,-80.719,53.050,1],
1572=>[93.528,-80.709,53.045,1],
2181=>[91.857,-81.527,53.204,2],
2182=>[91.872,-81.522,53.195,2],
2183=>[91.886,-81.516,53.187,2],
2184=>[91.900,-81.511,53.180,2],
2185=>[91.915,-81.506,53.173,2],
2186=>[91.929,-81.500,53.167,2],
2187=>[91.944,-81.495,53.161,2],
2188=>[91.963,-81.484,53.157,2],
2189=>[91.984,-81.472,53.152,2],
2190=>[92.003,-81.459,53.148,2],
2191=>[92.023,-81.447,53.144,2],
2192=>[92.044,-81.435,53.140,2],
2193=>[92.069,-81.424,53.135,2],
2194=>[92.093,-81.412,53.130,2],
2195=>[92.118,-81.401,53.126,2],
2196=>[92.142,-81.390,53.121,2],
2197=>[92.166,-81.378,53.117,2],
2198=>[92.191,-81.367,53.112,2],
2199=>[92.215,-81.356,53.106,2],
2200=>[92.240,-81.344,53.101,2],
2201=>[92.264,-81.333,53.094,2],
2202=>[92.289,-81.321,53.088,2],
2203=>[92.313,-81.310,53.082,2],
2204=>[92.333,-81.302,53.075,2],
2205=>[92.351,-81.294,53.069,2],
2206=>[92.369,-81.287,53.061,2],
2226=>[92.739,-81.134,53.425,1],
2227=>[92.758,-81.127,53.415,1],
2228=>[92.776,-81.118,53.405,1],
2229=>[92.794,-81.111,53.394,1],
2230=>[92.813,-81.103,53.384,1],
2269=>[93.478,-80.729,53.068,1],
2270=>[93.494,-80.718,53.063,1],
2271=>[93.510,-80.707,53.058,1],
2272=>[93.518,-80.698,53.053,1],
2273=>[93.525,-80.688,53.048,1],
2274=>[93.533,-80.678,53.042,1],
2275=>[93.540,-80.667,53.037,1],
2276=>[93.547,-80.657,53.032,1],
2277=>[93.554,-80.648,53.026,1],
2278=>[93.561,-80.638,53.019,1],
2279=>[93.568,-80.628,53.011,1],
2280=>[93.575,-80.618,53.003,1],
2881=>[91.843,-81.503,53.219,2],
2882=>[91.857,-81.497,53.208,2],
2883=>[91.871,-81.492,53.198,2],
2884=>[91.885,-81.487,53.189,2],
2885=>[91.900,-81.481,53.182,2],
2886=>[91.915,-81.476,53.174,2],
2887=>[91.929,-81.472,53.168,2],
2888=>[91.943,-81.466,53.162,2],
2889=>[91.959,-81.459,53.157,2],
2890=>[91.979,-81.447,53.152,2],
2891=>[91.999,-81.434,53.147,2],
2892=>[92.021,-81.423,53.143,2],
2893=>[92.045,-81.412,53.139,2],
2894=>[92.070,-81.400,53.133,2],
2895=>[92.094,-81.389,53.128,2],
2896=>[92.119,-81.377,53.123,2],
2897=>[92.143,-81.365,53.118,2],
2898=>[92.167,-81.354,53.113,2],
2899=>[92.192,-81.343,53.108,2],
2900=>[92.217,-81.331,53.103,2],
2901=>[92.241,-81.320,53.097,2],
2902=>[92.266,-81.309,53.091,2],
2903=>[92.290,-81.297,53.084,2],
2904=>[92.309,-81.289,53.078,2],
2905=>[92.328,-81.281,53.072,2],
2906=>[92.346,-81.274,53.065,2],
2907=>[92.365,-81.266,53.058,2],
2926=>[92.716,-81.121,53.429,1],
2927=>[92.734,-81.114,53.419,1],
2928=>[92.753,-81.106,53.409,1],
2929=>[92.771,-81.099,53.397,1],
2930=>[92.790,-81.091,53.387,1],
2931=>[92.808,-81.083,53.377,1],
2932=>[92.827,-81.075,53.366,1],
2933=>[92.845,-81.068,53.357,1],
2934=>[92.864,-81.060,53.347,1],
2935=>[92.882,-81.052,53.338,1],
2936=>[92.901,-81.045,53.329,1],
2969=>[93.457,-80.718,53.075,1],
2970=>[93.473,-80.708,53.070,1],
2971=>[93.489,-80.698,53.065,1],
2972=>[93.505,-80.687,53.060,1],
2973=>[93.516,-80.676,53.056,1],
2974=>[93.523,-80.667,53.051,1],
2975=>[93.531,-80.657,53.046,1],
2976=>[93.538,-80.647,53.040,1],
2977=>[93.545,-80.636,53.035,1],
2978=>[93.552,-80.626,53.029,1],
2979=>[93.559,-80.616,53.022,1],
2980=>[93.566,-80.607,53.015,1],
2981=>[93.573,-80.597,53.007,1],
2982=>[93.579,-80.586,52.999,1],
2983=>[93.586,-80.576,52.991,1],
3581=>[91.827,-81.479,53.239,2],
3582=>[91.842,-81.474,53.226,2],
3583=>[91.856,-81.469,53.214,2],
3584=>[91.871,-81.463,53.203,2],
3585=>[91.885,-81.458,53.193,2],
3586=>[91.899,-81.453,53.185,2],
3587=>[91.914,-81.447,53.177,2],
3588=>[91.928,-81.442,53.170,2],
3589=>[91.943,-81.437,53.163,2],
3590=>[91.957,-81.431,53.157,2],
3591=>[91.975,-81.422,53.152,2],
3592=>[91.997,-81.410,53.147,2],
3593=>[92.022,-81.399,53.142,2],
3594=>[92.047,-81.387,53.137,2],
3595=>[92.071,-81.376,53.132,2],
3596=>[92.095,-81.365,53.127,2],
3597=>[92.120,-81.353,53.121,2],
3598=>[92.144,-81.342,53.116,2],
3599=>[92.169,-81.331,53.110,2],
3600=>[92.193,-81.319,53.105,2],
3601=>[92.218,-81.308,53.099,2],
3602=>[92.242,-81.296,53.094,2],
3603=>[92.267,-81.284,53.087,2],
3604=>[92.286,-81.276,53.080,2],
3605=>[92.305,-81.268,53.074,2],
3606=>[92.323,-81.261,53.068,2],
3607=>[92.342,-81.253,53.061,2],
3608=>[92.360,-81.246,53.054,2],
3609=>[92.379,-81.238,53.047,2],
3626=>[92.693,-81.108,53.434,1],
3627=>[92.711,-81.101,53.423,1],
3628=>[92.730,-81.093,53.413,1],
3629=>[92.748,-81.086,53.402,1],
3630=>[92.767,-81.078,53.391,1],
3631=>[92.785,-81.071,53.380,1],
3632=>[92.804,-81.063,53.369,1],
3633=>[92.822,-81.055,53.359,1],
3634=>[92.841,-81.048,53.349,1],
3635=>[92.859,-81.039,53.339,1],
3636=>[92.877,-81.032,53.329,1],
3637=>[92.896,-81.024,53.320,1],
3638=>[92.915,-81.017,53.310,1],
3639=>[92.933,-81.009,53.301,1],
3669=>[93.435,-80.708,53.079,1],
3670=>[93.451,-80.698,53.075,1],
3671=>[93.468,-80.687,53.072,1],
3672=>[93.484,-80.676,53.067,1],
3673=>[93.500,-80.666,53.062,1],
3674=>[93.514,-80.655,53.058,1],
3675=>[93.521,-80.645,53.054,1],
3676=>[93.529,-80.635,53.049,1],
3677=>[93.536,-80.626,53.043,1],
3678=>[93.543,-80.615,53.037,1],
3679=>[93.550,-80.605,53.031,1],
3680=>[93.557,-80.595,53.024,1],
3681=>[93.564,-80.585,53.017,1],
3682=>[93.571,-80.576,53.010,1],
3683=>[93.577,-80.565,53.002,1],
3684=>[93.584,-80.555,52.994,1],
3685=>[93.591,-80.545,52.985,1],
4282=>[91.827,-81.450,53.247,2],
4283=>[91.841,-81.445,53.233,2],
4284=>[91.856,-81.440,53.221,2],
4285=>[91.870,-81.434,53.209,2],
4286=>[91.884,-81.429,53.199,2],
4287=>[91.899,-81.424,53.189,2],
4288=>[91.913,-81.419,53.180,2],
4289=>[91.928,-81.413,53.173,2],
4290=>[91.942,-81.408,53.166,2],
4291=>[91.956,-81.403,53.159,2],
4292=>[91.974,-81.398,53.153,2],
4293=>[91.999,-81.386,53.147,2],
4294=>[92.023,-81.375,53.142,2],
4295=>[92.048,-81.363,53.137,2],
4296=>[92.072,-81.352,53.131,2],
4297=>[92.096,-81.340,53.125,2],
4298=>[92.121,-81.329,53.119,2],
4299=>[92.145,-81.318,53.114,2],
4300=>[92.170,-81.306,53.108,2],
4301=>[92.195,-81.295,53.102,2],
4302=>[92.219,-81.284,53.096,2],
4303=>[92.243,-81.272,53.090,2],
4304=>[92.263,-81.263,53.084,2],
4305=>[92.282,-81.256,53.076,2],
4306=>[92.300,-81.248,53.070,2],
4307=>[92.319,-81.240,53.064,2],
4308=>[92.337,-81.233,53.058,2],
4309=>[92.356,-81.225,53.051,2],
4310=>[92.374,-81.218,53.044,2],
4311=>[92.392,-81.210,53.037,2],
4327=>[92.688,-81.088,53.429,1],
4328=>[92.707,-81.080,53.417,1],
4329=>[92.725,-81.073,53.406,1],
4330=>[92.743,-81.065,53.395,1],
4331=>[92.762,-81.058,53.384,1],
4332=>[92.781,-81.050,53.373,1],
4333=>[92.799,-81.043,53.361,1],
4334=>[92.817,-81.035,53.351,1],
4335=>[92.836,-81.027,53.340,1],
4336=>[92.855,-81.020,53.329,1],
4337=>[92.873,-81.012,53.320,1],
4338=>[92.892,-81.004,53.309,1],
4339=>[92.910,-80.996,53.300,1],
4340=>[92.928,-80.989,53.291,1],
4369=>[93.414,-80.698,53.081,1],
4370=>[93.430,-80.687,53.078,1],
4371=>[93.446,-80.676,53.075,1],
4372=>[93.463,-80.666,53.071,1],
4373=>[93.479,-80.655,53.068,1],
4374=>[93.495,-80.645,53.064,1],
4375=>[93.512,-80.634,53.060,1],
4376=>[93.519,-80.624,53.055,1],
4377=>[93.526,-80.614,53.051,1],
4378=>[93.534,-80.604,53.045,1],
4379=>[93.541,-80.594,53.039,1],
4380=>[93.548,-80.584,53.033,1],
4381=>[93.555,-80.574,53.026,1],
4382=>[93.562,-80.564,53.019,1],
4383=>[93.569,-80.554,53.011,1],
4384=>[93.575,-80.544,53.003,1],
4385=>[93.582,-80.534,52.995,1],
4386=>[93.589,-80.524,52.986,1],
4387=>[93.593,-80.519,52.977,1],
4983=>[91.826,-81.422,53.257,2],
4984=>[91.841,-81.416,53.242,2],
4985=>[91.855,-81.411,53.228,2],
4986=>[91.869,-81.406,53.216,2],
4987=>[91.884,-81.400,53.205,2],
4988=>[91.898,-81.395,53.195,2],
4989=>[91.913,-81.390,53.185,2],
4990=>[91.927,-81.384,53.177,2],
4991=>[91.940,-81.378,53.169,2],
4992=>[91.954,-81.373,53.162,2],
4993=>[91.968,-81.367,53.155,2],
4994=>[92.000,-81.363,53.149,2],
4995=>[92.024,-81.351,53.142,2],
4996=>[92.049,-81.340,53.137,2],
4997=>[92.073,-81.328,53.131,2],
4998=>[92.097,-81.316,53.124,2],
4999=>[92.122,-81.305,53.118,2],
5000=>[92.147,-81.293,53.112,2],
5001=>[92.171,-81.282,53.106,2],
5002=>[92.196,-81.271,53.100,2],
5003=>[92.220,-81.259,53.093,2],
5004=>[92.240,-81.251,53.086,2],
5005=>[92.259,-81.243,53.080,2],
5006=>[92.277,-81.236,53.072,2],
5007=>[92.296,-81.228,53.065,2],
5008=>[92.314,-81.220,53.059,2],
5009=>[92.333,-81.212,53.054,2],
5010=>[92.351,-81.205,53.047,2],
5011=>[92.369,-81.197,53.040,2],
5012=>[92.388,-81.190,53.033,2],
5027=>[92.665,-81.075,53.435,1],
5028=>[92.684,-81.068,53.423,1],
5029=>[92.702,-81.060,53.411,1],
5030=>[92.721,-81.052,53.400,1],
5031=>[92.739,-81.045,53.388,1],
5032=>[92.758,-81.037,53.376,1],
5033=>[92.776,-81.030,53.364,1],
5034=>[92.794,-81.022,53.352,1],
5035=>[92.813,-81.014,53.341,1],
5036=>[92.832,-81.007,53.330,1],
5037=>[92.850,-80.999,53.320,1],
5038=>[92.868,-80.992,53.309,1],
5039=>[92.887,-80.984,53.299,1],
5040=>[92.905,-80.977,53.289,1],
5041=>[92.924,-80.968,53.280,1],
5042=>[92.942,-80.961,53.271,1],
5069=>[93.392,-80.687,53.082,1],
5070=>[93.409,-80.676,53.078,1],
5071=>[93.425,-80.666,53.076,1],
5072=>[93.441,-80.655,53.073,1],
5073=>[93.458,-80.645,53.070,1],
5074=>[93.474,-80.634,53.067,1],
5075=>[93.490,-80.624,53.065,1],
5076=>[93.507,-80.613,53.061,1],
5077=>[93.517,-80.603,53.056,1],
5078=>[93.524,-80.593,53.052,1],
5079=>[93.532,-80.583,53.046,1],
5080=>[93.539,-80.573,53.041,1],
5081=>[93.546,-80.563,53.035,1],
5082=>[93.553,-80.553,53.028,1],
5083=>[93.560,-80.543,53.021,1],
5084=>[93.567,-80.533,53.013,1],
5085=>[93.573,-80.523,53.005,1],
5086=>[93.580,-80.514,52.997,1],
5087=>[93.583,-80.510,52.988,1],
5088=>[93.586,-80.504,52.979,1],
5089=>[93.590,-80.500,52.970,1],
5090=>[93.593,-80.495,52.961,1],
5683=>[91.811,-81.398,53.286,2],
5684=>[91.825,-81.393,53.269,2],
5685=>[91.840,-81.387,53.253,2],
5686=>[91.855,-81.382,53.238,2],
5687=>[91.869,-81.377,53.225,2],
5688=>[91.883,-81.371,53.213,2],
5689=>[91.896,-81.365,53.202,2],
5690=>[91.911,-81.359,53.192,2],
5691=>[91.925,-81.354,53.182,2],
5692=>[91.939,-81.349,53.174,2],
5693=>[91.953,-81.343,53.165,2],
5694=>[91.966,-81.337,53.158,2],
5695=>[92.000,-81.339,53.151,2],
5696=>[92.026,-81.328,53.144,2],
5697=>[92.050,-81.315,53.137,2],
5698=>[92.074,-81.304,53.131,2],
5699=>[92.099,-81.293,53.124,2],
5700=>[92.123,-81.281,53.117,2],
5701=>[92.148,-81.270,53.110,2],
5702=>[92.172,-81.259,53.104,2],
5703=>[92.197,-81.247,53.098,2],
5704=>[92.217,-81.238,53.090,2],
5705=>[92.236,-81.231,53.083,2],
5706=>[92.254,-81.223,53.076,2],
5707=>[92.273,-81.215,53.069,2],
5708=>[92.291,-81.208,53.062,2],
5709=>[92.309,-81.200,53.055,2],
5710=>[92.328,-81.192,53.049,2],
5711=>[92.347,-81.184,53.042,2],
5712=>[92.365,-81.177,53.036,2],
5713=>[92.383,-81.169,53.030,2],
5727=>[92.642,-81.062,53.441,1],
5728=>[92.660,-81.055,53.429,1],
5729=>[92.679,-81.047,53.416,1],
5730=>[92.698,-81.039,53.404,1],
5731=>[92.716,-81.032,53.392,1],
5732=>[92.734,-81.024,53.380,1],
5733=>[92.753,-81.017,53.368,1],
5734=>[92.772,-81.009,53.355,1],
5735=>[92.790,-81.002,53.343,1],
5736=>[92.808,-80.994,53.331,1],
5737=>[92.827,-80.986,53.320,1],
5738=>[92.845,-80.979,53.309,1],
5739=>[92.864,-80.971,53.298,1],
5740=>[92.882,-80.964,53.288,1],
5741=>[92.901,-80.956,53.278,1],
5742=>[92.919,-80.949,53.268,1],
5743=>[92.938,-80.941,53.260,1],
5769=>[93.371,-80.676,53.081,1],
5770=>[93.387,-80.667,53.077,1],
5771=>[93.404,-80.656,53.074,1],
5772=>[93.420,-80.645,53.071,1],
5773=>[93.436,-80.635,53.069,1],
5774=>[93.452,-80.624,53.067,1],
5775=>[93.469,-80.613,53.064,1],
5776=>[93.485,-80.603,53.063,1],
5777=>[93.502,-80.592,53.061,1],
5778=>[93.515,-80.582,53.057,1],
5779=>[93.522,-80.572,53.052,1],
5780=>[93.530,-80.562,53.047,1],
5781=>[93.537,-80.552,53.042,1],
5782=>[93.544,-80.541,53.035,1],
5783=>[93.551,-80.532,53.029,1],
5784=>[93.558,-80.522,53.022,1],
5785=>[93.565,-80.512,53.015,1],
5786=>[93.570,-80.504,53.006,1],
5787=>[93.573,-80.500,52.998,1],
5788=>[93.576,-80.495,52.989,1],
5789=>[93.580,-80.490,52.980,1],
5790=>[93.583,-80.485,52.971,1],
5791=>[93.586,-80.481,52.962,1],
5792=>[93.590,-80.476,52.953,1],
6384=>[91.811,-81.369,53.300,2],
6385=>[91.825,-81.364,53.282,2],
6386=>[91.839,-81.358,53.265,2],
6387=>[91.853,-81.353,53.249,2],
6388=>[91.867,-81.347,53.235,2],
6389=>[91.881,-81.341,53.222,2],
6390=>[91.895,-81.335,53.210,2],
6391=>[91.909,-81.330,53.199,2],
6392=>[91.923,-81.325,53.189,2],
6393=>[91.937,-81.318,53.179,2],
6394=>[91.951,-81.313,53.170,2],
6395=>[91.965,-81.307,53.161,2],
6396=>[91.985,-81.304,53.154,2],
6397=>[92.028,-81.306,53.146,2],
6398=>[92.052,-81.293,53.139,2],
6399=>[92.076,-81.281,53.132,2],
6400=>[92.100,-81.268,53.124,2],
6401=>[92.125,-81.257,53.116,2],
6402=>[92.149,-81.246,53.109,2],
6403=>[92.173,-81.234,53.103,2],
6404=>[92.194,-81.225,53.095,2],
6405=>[92.213,-81.218,53.088,2],
6406=>[92.231,-81.210,53.080,2],
6407=>[92.249,-81.202,53.073,2],
6408=>[92.268,-81.195,53.065,2],
6409=>[92.286,-81.187,53.058,2],
6410=>[92.305,-81.180,53.051,2],
6411=>[92.323,-81.172,53.045,2],
6412=>[92.342,-81.165,53.039,2],
6413=>[92.360,-81.156,53.032,2],
6414=>[92.379,-81.149,53.026,2],
6415=>[92.398,-81.141,53.018,2],
6428=>[92.638,-81.043,53.436,1],
6429=>[92.656,-81.035,53.423,1],
6430=>[92.674,-81.027,53.409,1],
6431=>[92.693,-81.019,53.397,1],
6432=>[92.711,-81.011,53.384,1],
6433=>[92.730,-81.004,53.371,1],
6434=>[92.748,-80.996,53.359,1],
6435=>[92.767,-80.989,53.346,1],
6436=>[92.785,-80.981,53.333,1],
6437=>[92.804,-80.974,53.321,1],
6438=>[92.822,-80.966,53.309,1],
6439=>[92.841,-80.958,53.298,1],
6440=>[92.859,-80.951,53.287,1],
6441=>[92.878,-80.943,53.277,1],
6442=>[92.896,-80.936,53.267,1],
6443=>[92.915,-80.928,53.257,1],
6444=>[92.933,-80.920,53.248,1],
6445=>[92.951,-80.913,53.240,1],
6470=>[93.366,-80.656,53.074,1],
6471=>[93.382,-80.645,53.071,1],
6472=>[93.399,-80.635,53.069,1],
6473=>[93.415,-80.624,53.066,1],
6474=>[93.431,-80.613,53.065,1],
6475=>[93.447,-80.603,53.063,1],
6476=>[93.464,-80.592,53.062,1],
6477=>[93.480,-80.582,53.061,1],
6478=>[93.497,-80.571,53.058,1],
6479=>[93.513,-80.560,53.055,1],
6480=>[93.520,-80.551,53.052,1],
6481=>[93.528,-80.541,53.047,1],
6482=>[93.535,-80.531,53.042,1],
6483=>[93.542,-80.520,53.036,1],
6484=>[93.549,-80.510,53.029,1],
6485=>[93.556,-80.500,53.022,1],
6486=>[93.560,-80.494,53.015,1],
6487=>[93.563,-80.490,53.007,1],
6488=>[93.567,-80.485,52.998,1],
6489=>[93.570,-80.481,52.990,1],
6490=>[93.573,-80.475,52.981,1],
6491=>[93.576,-80.471,52.972,1],
6492=>[93.580,-80.466,52.963,1],
6493=>[93.583,-80.462,52.954,1],
6494=>[93.586,-80.457,52.944,1],
7085=>[91.809,-81.340,53.315,2],
7086=>[91.823,-81.334,53.297,2],
7087=>[91.837,-81.328,53.279,2],
7088=>[91.851,-81.322,53.262,2],
7089=>[91.865,-81.317,53.247,2],
7090=>[91.879,-81.311,53.233,2],
7091=>[91.893,-81.306,53.220,2],
7092=>[91.907,-81.300,53.208,2],
7093=>[91.921,-81.294,53.197,2],
7094=>[91.935,-81.289,53.186,2],
7095=>[91.949,-81.283,53.176,2],
7096=>[91.963,-81.278,53.166,2],
7097=>[91.977,-81.271,53.158,2],
7098=>[92.024,-81.279,53.150,2],
7099=>[92.054,-81.271,53.142,2],
7100=>[92.078,-81.259,53.134,2],
7101=>[92.102,-81.246,53.125,2],
7102=>[92.126,-81.234,53.117,2],
7103=>[92.150,-81.221,53.109,2],
7104=>[92.171,-81.212,53.101,2],
7105=>[92.190,-81.205,53.094,2],
7106=>[92.208,-81.197,53.086,2],
7107=>[92.226,-81.190,53.078,2],
7108=>[92.245,-81.182,53.070,2],
7109=>[92.264,-81.174,53.062,2],
7110=>[92.282,-81.167,53.055,2],
7111=>[92.300,-81.159,53.048,2],
7112=>[92.319,-81.152,53.042,2],
7113=>[92.337,-81.144,53.035,2],
7114=>[92.356,-81.137,53.028,2],
7115=>[92.374,-81.129,53.022,2],
7116=>[92.392,-81.121,53.015,2],
7129=>[92.633,-81.022,53.430,1],
7130=>[92.651,-81.014,53.417,1],
7131=>[92.670,-81.007,53.403,1],
7132=>[92.689,-80.999,53.390,1],
7133=>[92.707,-80.991,53.377,1],
7134=>[92.725,-80.983,53.363,1],
7135=>[92.744,-80.976,53.350,1],
7136=>[92.762,-80.968,53.336,1],
7137=>[92.781,-80.961,53.322,1],
7138=>[92.799,-80.953,53.311,1],
7139=>[92.817,-80.945,53.299,1],
7140=>[92.836,-80.938,53.287,1],
7141=>[92.855,-80.930,53.276,1],
7142=>[92.873,-80.923,53.265,1],
7143=>[92.892,-80.915,53.255,1],
7144=>[92.910,-80.908,53.245,1],
7145=>[92.928,-80.900,53.236,1],
7146=>[92.947,-80.892,53.227,1],
7170=>[93.345,-80.645,53.069,1],
7171=>[93.361,-80.635,53.067,1],
7172=>[93.377,-80.624,53.065,1],
7173=>[93.394,-80.613,53.063,1],
7174=>[93.410,-80.603,53.061,1],
7175=>[93.426,-80.592,53.060,1],
7176=>[93.442,-80.582,53.059,1],
7177=>[93.459,-80.571,53.059,1],
7178=>[93.475,-80.560,53.057,1],
7179=>[93.492,-80.550,53.056,1],
7180=>[93.508,-80.540,53.054,1],
7181=>[93.518,-80.529,53.050,1],
7182=>[93.525,-80.519,53.046,1],
7183=>[93.533,-80.510,53.041,1],
7184=>[93.540,-80.499,53.035,1],
7185=>[93.547,-80.489,53.029,1],
7186=>[93.550,-80.485,53.022,1],
7187=>[93.553,-80.480,53.015,1],
7188=>[93.557,-80.475,53.007,1],
7189=>[93.560,-80.471,52.999,1],
7190=>[93.563,-80.466,52.990,1],
7191=>[93.567,-80.461,52.981,1],
7192=>[93.570,-80.457,52.972,1],
7193=>[93.573,-80.452,52.963,1],
7194=>[93.577,-80.447,52.955,1],
7195=>[93.580,-80.443,52.945,1],
7196=>[93.583,-80.438,52.935,1],
7786=>[91.807,-81.309,53.333,2],
7787=>[91.821,-81.304,53.314,2],
7788=>[91.835,-81.298,53.295,2],
7789=>[91.849,-81.293,53.277,2],
7790=>[91.863,-81.287,53.261,2],
7791=>[91.877,-81.281,53.246,2],
7792=>[91.891,-81.275,53.232,2],
7793=>[91.905,-81.270,53.219,2],
7794=>[91.919,-81.265,53.206,2],
7795=>[91.933,-81.259,53.194,2],
7796=>[91.947,-81.253,53.183,2],
7797=>[91.961,-81.247,53.173,2],
7798=>[91.975,-81.242,53.164,2],
7799=>[92.009,-81.244,53.155,2],
7800=>[92.056,-81.249,53.146,2],
7801=>[92.079,-81.236,53.137,2],
7802=>[92.103,-81.224,53.128,2],
7803=>[92.128,-81.212,53.120,2],
7804=>[92.147,-81.199,53.111,2],
7805=>[92.165,-81.191,53.103,2],
7806=>[92.185,-81.184,53.094,2],
7807=>[92.203,-81.177,53.085,2],
7808=>[92.222,-81.169,53.077,2],
7809=>[92.240,-81.162,53.068,2],
7810=>[92.259,-81.154,53.060,2],
7811=>[92.277,-81.146,53.053,2],
7812=>[92.296,-81.139,53.046,2],
7813=>[92.314,-81.131,53.039,2],
7814=>[92.333,-81.124,53.032,2],
7815=>[92.351,-81.116,53.026,2],
7816=>[92.370,-81.108,53.019,2],
7817=>[92.388,-81.101,53.012,2],
7830=>[92.628,-81.002,53.425,1],
7831=>[92.647,-80.994,53.411,1],
7832=>[92.665,-80.986,53.396,1],
7833=>[92.684,-80.979,53.382,1],
7834=>[92.702,-80.971,53.369,1],
7835=>[92.721,-80.964,53.355,1],
7836=>[92.739,-80.955,53.341,1],
7837=>[92.758,-80.948,53.327,1],
7838=>[92.776,-80.940,53.313,1],
7839=>[92.795,-80.933,53.300,1],
7840=>[92.813,-80.925,53.288,1],
7841=>[92.832,-80.917,53.275,1],
7842=>[92.850,-80.910,53.264,1],
7843=>[92.868,-80.902,53.253,1],
7844=>[92.887,-80.895,53.243,1],
7845=>[92.906,-80.887,53.233,1],
7846=>[92.924,-80.880,53.223,1],
7847=>[92.942,-80.872,53.214,1],
7848=>[92.961,-80.864,53.206,1],
7870=>[93.323,-80.635,53.064,1],
7871=>[93.339,-80.624,53.062,1],
7872=>[93.356,-80.613,53.059,1],
7873=>[93.372,-80.603,53.057,1],
7874=>[93.389,-80.592,53.056,1],
7875=>[93.405,-80.582,53.055,1],
7876=>[93.421,-80.572,53.054,1],
7877=>[93.437,-80.561,53.054,1],
7878=>[93.454,-80.551,53.054,1],
7879=>[93.470,-80.540,53.053,1],
7880=>[93.487,-80.529,53.053,1],
7881=>[93.503,-80.519,53.052,1],
7882=>[93.516,-80.508,53.048,1],
7883=>[93.523,-80.498,53.044,1],
7884=>[93.531,-80.488,53.039,1],
7885=>[93.537,-80.479,53.034,1],
7886=>[93.540,-80.475,53.028,1],
7887=>[93.543,-80.470,53.021,1],
7888=>[93.547,-80.466,53.014,1],
7889=>[93.550,-80.461,53.006,1],
7890=>[93.553,-80.457,52.998,1],
7891=>[93.557,-80.452,52.990,1],
7892=>[93.560,-80.447,52.981,1],
7893=>[93.563,-80.442,52.972,1],
7894=>[93.567,-80.438,52.964,1],
7895=>[93.570,-80.433,52.955,1],
7896=>[93.573,-80.428,52.945,1],
7897=>[93.577,-80.424,52.936,1],
7898=>[93.580,-80.419,52.927,1],
8486=>[91.791,-81.285,53.374,2],
8487=>[91.805,-81.280,53.353,2],
8488=>[91.819,-81.274,53.332,2],
8489=>[91.834,-81.268,53.313,2],
8490=>[91.847,-81.262,53.294,2],
8491=>[91.861,-81.257,53.277,2],
8492=>[91.875,-81.251,53.261,2],
8493=>[91.889,-81.246,53.245,2],
8494=>[91.904,-81.240,53.231,2],
8495=>[91.917,-81.234,53.218,2],
8496=>[91.931,-81.229,53.204,2],
8497=>[91.945,-81.223,53.193,2],
8498=>[91.959,-81.218,53.182,2],
8499=>[91.974,-81.212,53.171,2],
8500=>[91.994,-81.209,53.161,2],
8501=>[92.048,-81.219,53.151,2],
8502=>[92.081,-81.214,53.141,2],
8503=>[92.105,-81.201,53.132,2],
8504=>[92.126,-81.190,53.123,2],
8505=>[92.142,-81.179,53.114,2],
8506=>[92.158,-81.168,53.105,2],
8507=>[92.177,-81.162,53.094,2],
8508=>[92.197,-81.155,53.085,2],
8509=>[92.216,-81.148,53.076,2],
8510=>[92.236,-81.141,53.067,2],
8511=>[92.254,-81.133,53.059,2],
8512=>[92.273,-81.126,53.051,2],
8513=>[92.291,-81.118,53.044,2],
8514=>[92.309,-81.111,53.037,2],
8515=>[92.328,-81.103,53.030,2],
8516=>[92.347,-81.096,53.023,2],
8517=>[92.365,-81.088,53.016,2],
8518=>[92.383,-81.080,53.009,2],
8531=>[92.624,-80.981,53.419,1],
8532=>[92.642,-80.974,53.405,1],
8533=>[92.661,-80.966,53.389,1],
8534=>[92.679,-80.958,53.375,1],
8535=>[92.698,-80.951,53.362,1],
8536=>[92.716,-80.943,53.347,1],
8537=>[92.734,-80.936,53.332,1],
8538=>[92.753,-80.928,53.318,1],
8539=>[92.772,-80.920,53.304,1],
8540=>[92.790,-80.912,53.290,1],
8541=>[92.808,-80.905,53.277,1],
8542=>[92.827,-80.897,53.265,1],
8543=>[92.845,-80.889,53.253,1],
8544=>[92.864,-80.882,53.241,1],
8545=>[92.882,-80.874,53.231,1],
8546=>[92.901,-80.867,53.220,1],
8547=>[92.919,-80.859,53.210,1],
8548=>[92.938,-80.851,53.200,1],
8549=>[92.956,-80.844,53.193,1],
8550=>[92.975,-80.836,53.184,1],
8551=>[92.991,-80.826,53.176,1],
8571=>[93.318,-80.614,53.055,1],
8572=>[93.334,-80.604,53.053,1],
8573=>[93.351,-80.593,53.051,1],
8574=>[93.367,-80.582,53.049,1],
8575=>[93.383,-80.572,53.048,1],
8576=>[93.400,-80.561,53.047,1],
8577=>[93.416,-80.551,53.047,1],
8578=>[93.432,-80.540,53.048,1],
8579=>[93.449,-80.529,53.048,1],
8580=>[93.465,-80.519,53.048,1],
8581=>[93.482,-80.508,53.048,1],
8582=>[93.498,-80.497,53.048,1],
8583=>[93.514,-80.487,53.047,1],
8584=>[93.521,-80.477,53.044,1],
8585=>[93.526,-80.469,53.038,1],
8586=>[93.530,-80.465,53.032,1],
8587=>[93.533,-80.460,53.026,1],
8588=>[93.537,-80.456,53.019,1],
8589=>[93.540,-80.451,53.012,1],
8590=>[93.543,-80.447,53.005,1],
8591=>[93.547,-80.442,52.998,1],
8592=>[93.550,-80.438,52.990,1],
8593=>[93.553,-80.432,52.981,1],
8594=>[93.557,-80.428,52.972,1],
8595=>[93.560,-80.423,52.964,1],
8596=>[93.563,-80.419,52.954,1],
8597=>[93.567,-80.414,52.945,1],
8598=>[93.570,-80.410,52.937,1],
8599=>[93.573,-80.405,52.928,1],
8600=>[93.577,-80.400,52.919,1],
9187=>[91.790,-81.255,53.395,2],
9188=>[91.803,-81.249,53.373,2],
9189=>[91.817,-81.244,53.352,2],
9190=>[91.831,-81.238,53.332,2],
9191=>[91.846,-81.233,53.312,2],
9192=>[91.860,-81.227,53.294,2],
9193=>[91.873,-81.221,53.277,2],
9194=>[91.887,-81.215,53.260,2],
9195=>[91.901,-81.210,53.245,2],
9196=>[91.916,-81.204,53.231,2],
9197=>[91.930,-81.199,53.217,2],
9198=>[91.943,-81.193,53.204,2],
9199=>[91.957,-81.187,53.191,2],
9200=>[91.971,-81.182,53.180,2],
9201=>[91.986,-81.176,53.169,2],
9202=>[92.032,-81.184,53.158,2],
9203=>[92.083,-81.191,53.147,2],
9204=>[92.104,-81.180,53.137,2],
9205=>[92.120,-81.168,53.127,2],
9206=>[92.136,-81.158,53.117,2],
9207=>[92.152,-81.147,53.106,2],
9208=>[92.170,-81.138,53.096,2],
9209=>[92.190,-81.131,53.086,2],
9210=>[92.209,-81.124,53.076,2],
9211=>[92.228,-81.118,53.067,2],
9212=>[92.248,-81.112,53.059,2],
9213=>[92.268,-81.105,53.050,2],
9214=>[92.287,-81.098,53.043,2],
9215=>[92.305,-81.090,53.035,2],
9216=>[92.323,-81.083,53.027,2],
9217=>[92.342,-81.075,53.020,2],
9218=>[92.360,-81.068,53.014,2],
9219=>[92.379,-81.060,53.007,2],
9232=>[92.619,-80.961,53.414,1],
9233=>[92.638,-80.953,53.399,1],
9234=>[92.656,-80.945,53.384,1],
9235=>[92.674,-80.938,53.370,1],
9236=>[92.693,-80.930,53.355,1],
9237=>[92.712,-80.923,53.339,1],
9238=>[92.730,-80.915,53.325,1],
9239=>[92.748,-80.908,53.310,1],
9240=>[92.767,-80.900,53.296,1],
9241=>[92.785,-80.892,53.281,1],
9242=>[92.804,-80.884,53.267,1],
9243=>[92.823,-80.877,53.254,1],
9244=>[92.841,-80.869,53.241,1],
9245=>[92.859,-80.861,53.230,1],
9246=>[92.878,-80.854,53.218,1],
9247=>[92.896,-80.846,53.207,1],
9248=>[92.915,-80.839,53.197,1],
9249=>[92.933,-80.831,53.187,1],
9250=>[92.951,-80.823,53.179,1],
9251=>[92.970,-80.815,53.171,1],
9252=>[92.986,-80.804,53.163,1],
9253=>[93.002,-80.794,53.155,1],
9254=>[93.018,-80.783,53.148,1],
9255=>[93.035,-80.773,53.141,1],
9256=>[93.051,-80.762,53.135,1],
9257=>[93.068,-80.751,53.129,1],
9272=>[93.313,-80.593,53.044,1],
9273=>[93.329,-80.582,53.042,1],
9274=>[93.346,-80.572,53.041,1],
9275=>[93.362,-80.561,53.040,1],
9276=>[93.378,-80.551,53.040,1],
9277=>[93.395,-80.540,53.039,1],
9278=>[93.411,-80.529,53.039,1],
9279=>[93.427,-80.519,53.040,1],
9280=>[93.444,-80.508,53.041,1],
9281=>[93.460,-80.497,53.043,1],
9282=>[93.477,-80.487,53.044,1],
9283=>[93.493,-80.476,53.045,1],
9284=>[93.509,-80.466,53.045,1],
9285=>[93.516,-80.460,53.042,1],
9286=>[93.520,-80.455,53.036,1],
9287=>[93.523,-80.450,53.029,1],
9288=>[93.526,-80.446,53.022,1],
9289=>[93.530,-80.441,53.016,1],
9290=>[93.533,-80.437,53.009,1],
9291=>[93.537,-80.432,53.003,1],
9292=>[93.540,-80.428,52.996,1],
9293=>[93.543,-80.423,52.989,1],
9294=>[93.547,-80.418,52.980,1],
9295=>[93.550,-80.413,52.971,1],
9296=>[93.553,-80.409,52.964,1],
9297=>[93.557,-80.404,52.954,1],
9298=>[93.560,-80.400,52.946,1],
9299=>[93.563,-80.395,52.937,1],
9300=>[93.567,-80.391,52.928,1],
9301=>[93.570,-80.386,52.919,1],
9302=>[93.574,-80.381,52.910,1],
9888=>[91.788,-81.225,53.418,2],
9889=>[91.802,-81.219,53.395,2],
9890=>[91.815,-81.214,53.373,2],
9891=>[91.829,-81.209,53.352,2],
9892=>[91.844,-81.202,53.331,2],
9893=>[91.858,-81.197,53.313,2],
9894=>[91.872,-81.191,53.294,2],
9895=>[91.885,-81.186,53.277,2],
9896=>[91.899,-81.180,53.260,2],
9897=>[91.914,-81.174,53.245,2],
9898=>[91.928,-81.169,53.230,2],
9899=>[91.942,-81.163,53.216,2],
9900=>[91.955,-81.158,53.202,2],
9901=>[91.969,-81.152,53.190,2],
9902=>[91.984,-81.146,53.178,2],
9903=>[92.018,-81.149,53.166,2],
9904=>[92.067,-81.160,53.154,2],
9905=>[92.091,-81.157,53.143,2],
9906=>[92.111,-81.147,53.132,2],
9907=>[92.131,-81.137,53.121,2],
9908=>[92.147,-81.126,53.109,2],
9909=>[92.163,-81.115,53.099,2],
9910=>[92.182,-81.108,53.088,2],
9911=>[92.202,-81.102,53.078,2],
9912=>[92.221,-81.095,53.068,2],
9913=>[92.240,-81.088,53.059,2],
9914=>[92.260,-81.082,53.050,2],
9915=>[92.279,-81.075,53.042,2],
9916=>[92.299,-81.068,53.034,2],
9917=>[92.318,-81.061,53.026,2],
9918=>[92.338,-81.055,53.019,2],
9919=>[92.356,-81.047,53.011,2],
9920=>[92.374,-81.039,53.004,2],
9933=>[92.615,-80.940,53.409,1],
9934=>[92.633,-80.933,53.394,1],
9935=>[92.651,-80.925,53.379,1],
9936=>[92.670,-80.917,53.363,1],
9937=>[92.689,-80.910,53.348,1],
9938=>[92.707,-80.902,53.333,1],
9939=>[92.725,-80.895,53.317,1],
9940=>[92.744,-80.887,53.302,1],
9941=>[92.762,-80.880,53.286,1],
9942=>[92.781,-80.872,53.271,1],
9943=>[92.799,-80.864,53.257,1],
9944=>[92.818,-80.857,53.244,1],
9945=>[92.836,-80.848,53.231,1],
9946=>[92.855,-80.841,53.218,1],
9947=>[92.873,-80.833,53.206,1],
9948=>[92.892,-80.826,53.195,1],
9949=>[92.910,-80.818,53.184,1],
9950=>[92.929,-80.811,53.174,1],
9951=>[92.947,-80.803,53.165,1],
9952=>[92.965,-80.794,53.158,1],
9953=>[92.981,-80.783,53.150,1],
9954=>[92.997,-80.773,53.141,1],
9955=>[93.013,-80.762,53.135,1],
9956=>[93.030,-80.751,53.128,1],
9957=>[93.046,-80.741,53.121,1],
9958=>[93.063,-80.730,53.115,1],
9959=>[93.079,-80.720,53.109,1],
9960=>[93.095,-80.710,53.103,1],
9961=>[93.112,-80.699,53.097,1],
9962=>[93.128,-80.688,53.090,1],
9972=>[93.292,-80.582,53.036,1],
9973=>[93.308,-80.572,53.033,1],
9974=>[93.324,-80.561,53.032,1],
9975=>[93.341,-80.551,53.030,1],
9976=>[93.357,-80.540,53.029,1],
9977=>[93.373,-80.529,53.029,1],
9978=>[93.390,-80.519,53.029,1],
9979=>[93.406,-80.508,53.030,1],
9980=>[93.422,-80.498,53.032,1],
9981=>[93.439,-80.488,53.034,1],
9982=>[93.455,-80.477,53.037,1],
9983=>[93.468,-80.466,53.040,1],
9984=>[93.481,-80.457,53.042,1],
9985=>[93.497,-80.450,53.042,1],
9986=>[93.509,-80.445,53.039,1],
9987=>[93.513,-80.441,53.032,1],
9988=>[93.516,-80.436,53.025,1],
9989=>[93.520,-80.431,53.018,1],
9990=>[93.523,-80.427,53.012,1],
9991=>[93.526,-80.422,53.006,1],
9992=>[93.530,-80.418,53.000,1],
9993=>[93.534,-80.413,52.994,1],
9994=>[93.537,-80.409,52.987,1],
9995=>[93.540,-80.403,52.979,1],
9996=>[93.543,-80.399,52.971,1],
9997=>[93.547,-80.394,52.963,1],
9998=>[93.550,-80.390,52.954,1],
9999=>[93.553,-80.385,52.945,1],
10000=>[93.557,-80.381,52.936,1],
10001=>[93.560,-80.376,52.927,1],
10002=>[93.564,-80.371,52.919,1],
10003=>[93.574,-80.363,52.910,1],
10589=>[91.786,-81.195,53.441,2],
10590=>[91.800,-81.190,53.418,2],
10591=>[91.814,-81.184,53.395,2],
10592=>[91.828,-81.178,53.373,2],
10593=>[91.842,-81.173,53.352,2],
10594=>[91.856,-81.167,53.332,2],
10595=>[91.870,-81.162,53.313,2],
10596=>[91.884,-81.155,53.294,2],
10597=>[91.898,-81.150,53.277,2],
10598=>[91.912,-81.144,53.261,2],
10599=>[91.926,-81.139,53.245,2],
10600=>[91.940,-81.133,53.229,2],
10601=>[91.954,-81.127,53.215,2],
10602=>[91.968,-81.122,53.201,2],
10603=>[91.982,-81.116,53.187,2],
10604=>[92.003,-81.113,53.174,2],
10605=>[92.038,-81.129,53.162,2],
10606=>[92.066,-81.133,53.150,2],
10607=>[92.086,-81.123,53.138,2],
10608=>[92.107,-81.112,53.125,2],
10609=>[92.127,-81.102,53.114,2],
10610=>[92.150,-81.093,53.103,2],
10611=>[92.174,-81.085,53.092,2],
10612=>[92.194,-81.078,53.081,2],
10613=>[92.213,-81.071,53.070,2],
10614=>[92.233,-81.065,53.060,2],
10615=>[92.252,-81.058,53.051,2],
10616=>[92.272,-81.052,53.042,2],
10617=>[92.291,-81.045,53.034,2],
10618=>[92.311,-81.039,53.026,2],
10619=>[92.331,-81.032,53.018,2],
10620=>[92.350,-81.025,53.011,2],
10621=>[92.369,-81.019,53.003,2],
10634=>[92.610,-80.920,53.405,1],
10635=>[92.629,-80.912,53.390,1],
10636=>[92.647,-80.905,53.373,1],
10637=>[92.665,-80.897,53.357,1],
10638=>[92.684,-80.889,53.342,1],
10639=>[92.702,-80.882,53.327,1],
10640=>[92.721,-80.874,53.310,1],
10641=>[92.739,-80.867,53.294,1],
10642=>[92.758,-80.859,53.278,1],
10643=>[92.776,-80.851,53.263,1],
10644=>[92.795,-80.844,53.248,1],
10645=>[92.813,-80.836,53.234,1],
10646=>[92.832,-80.829,53.220,1],
10647=>[92.850,-80.821,53.207,1],
10648=>[92.868,-80.813,53.195,1],
10649=>[92.887,-80.805,53.183,1],
10650=>[92.906,-80.798,53.172,1],
10651=>[92.924,-80.790,53.162,1],
10652=>[92.942,-80.782,53.152,1],
10653=>[92.959,-80.773,53.145,1],
10654=>[92.976,-80.762,53.137,1],
10655=>[92.992,-80.752,53.128,1],
10656=>[93.008,-80.742,53.121,1],
10657=>[93.025,-80.731,53.114,1],
10658=>[93.041,-80.720,53.107,1],
10659=>[93.058,-80.710,53.102,1],
10660=>[93.074,-80.699,53.096,1],
10661=>[93.090,-80.688,53.090,1],
10662=>[93.107,-80.678,53.083,1],
10663=>[93.123,-80.667,53.077,1],
10664=>[93.139,-80.657,53.071,1],
10665=>[93.156,-80.646,53.064,1],
10673=>[93.286,-80.561,53.023,1],
10674=>[93.303,-80.551,53.021,1],
10675=>[93.319,-80.541,53.020,1],
10676=>[93.336,-80.530,53.018,1],
10677=>[93.352,-80.519,53.017,1],
10678=>[93.368,-80.509,53.017,1],
10679=>[93.384,-80.498,53.018,1],
10680=>[93.401,-80.488,53.020,1],
10681=>[93.414,-80.476,53.022,1],
10682=>[93.426,-80.465,53.025,1],
10683=>[93.439,-80.454,53.030,1],
10684=>[93.452,-80.449,53.034,1],
10685=>[93.468,-80.443,53.037,1],
10686=>[93.485,-80.435,53.037,1],
10687=>[93.498,-80.430,53.034,1],
10688=>[93.506,-80.426,53.029,1],
10689=>[93.510,-80.422,53.021,1],
10690=>[93.513,-80.417,53.014,1],
10691=>[93.516,-80.413,53.009,1],
10692=>[93.520,-80.408,53.003,1],
10693=>[93.523,-80.403,52.998,1],
10694=>[93.526,-80.399,52.993,1],
10695=>[93.530,-80.394,52.985,1],
10696=>[93.534,-80.389,52.977,1],
10697=>[93.537,-80.385,52.970,1],
10698=>[93.540,-80.380,52.962,1],
10699=>[93.543,-80.375,52.953,1],
10700=>[93.547,-80.371,52.944,1],
10701=>[93.550,-80.366,52.935,1],
10702=>[93.554,-80.361,52.927,1],
10703=>[93.564,-80.353,52.919,1],
10704=>[93.574,-80.344,52.910,1],
10705=>[93.584,-80.335,52.901,1],
11291=>[91.798,-81.159,53.441,2],
11292=>[91.812,-81.154,53.417,2],
11293=>[91.826,-81.149,53.394,2],
11294=>[91.840,-81.143,53.373,2],
11295=>[91.854,-81.137,53.352,2],
11296=>[91.868,-81.131,53.332,2],
11297=>[91.882,-81.126,53.312,2],
11298=>[91.896,-81.120,53.295,2],
11299=>[91.910,-81.115,53.278,2],
11300=>[91.924,-81.108,53.260,2],
11301=>[91.938,-81.103,53.244,2],
11302=>[91.952,-81.098,53.229,2],
11303=>[91.965,-81.096,53.214,2],
11304=>[91.979,-81.095,53.199,2],
11305=>[91.992,-81.095,53.186,2],
11306=>[92.010,-81.098,53.173,2],
11307=>[92.040,-81.108,53.159,2],
11308=>[92.061,-81.098,53.145,2],
11309=>[92.082,-81.088,53.133,2],
11310=>[92.112,-81.079,53.121,2],
11311=>[92.143,-81.070,53.108,2],
11312=>[92.164,-81.063,53.096,2],
11313=>[92.184,-81.055,53.084,2],
11314=>[92.205,-81.049,53.073,2],
11315=>[92.224,-81.042,53.062,2],
11316=>[92.244,-81.035,53.052,2],
11317=>[92.265,-81.028,53.044,2],
11318=>[92.284,-81.022,53.035,2],
11319=>[92.303,-81.015,53.026,2],
11320=>[92.323,-81.008,53.018,2],
11321=>[92.342,-81.002,53.011,2],
11322=>[92.362,-80.996,53.003,2],
11336=>[92.624,-80.892,53.384,1],
11337=>[92.642,-80.884,53.368,1],
11338=>[92.661,-80.877,53.352,1],
11339=>[92.679,-80.869,53.336,1],
11340=>[92.698,-80.861,53.320,1],
11341=>[92.716,-80.854,53.303,1],
11342=>[92.735,-80.846,53.287,1],
11343=>[92.753,-80.839,53.271,1],
11344=>[92.772,-80.831,53.255,1],
11345=>[92.790,-80.823,53.239,1],
11346=>[92.808,-80.816,53.225,1],
11347=>[92.827,-80.808,53.210,1],
11348=>[92.846,-80.801,53.197,1],
11349=>[92.864,-80.793,53.184,1],
11350=>[92.882,-80.786,53.172,1],
11351=>[92.901,-80.777,53.160,1],
11352=>[92.919,-80.770,53.150,1],
11353=>[92.938,-80.762,53.140,1],
11354=>[92.954,-80.752,53.132,1],
11355=>[92.971,-80.742,53.124,1],
11356=>[92.987,-80.731,53.116,1],
11357=>[93.003,-80.720,53.108,1],
11358=>[93.020,-80.710,53.101,1],
11359=>[93.036,-80.699,53.094,1],
11360=>[93.053,-80.688,53.088,1],
11361=>[93.069,-80.678,53.082,1],
11362=>[93.085,-80.667,53.076,1],
11363=>[93.101,-80.657,53.070,1],
11364=>[93.118,-80.646,53.064,1],
11365=>[93.134,-80.635,53.058,1],
11366=>[93.151,-80.625,53.052,1],
11367=>[93.167,-80.614,53.046,1],
11374=>[93.281,-80.541,53.011,1],
11375=>[93.298,-80.530,53.009,1],
11376=>[93.314,-80.519,53.007,1],
11377=>[93.331,-80.509,53.006,1],
11378=>[93.347,-80.498,53.005,1],
11379=>[93.360,-80.487,53.004,1],
11380=>[93.372,-80.476,53.006,1],
11381=>[93.385,-80.465,53.008,1],
11382=>[93.398,-80.453,53.011,1],
11383=>[93.410,-80.444,53.016,1],
11384=>[93.424,-80.441,53.021,1],
11385=>[93.440,-80.435,53.027,1],
11386=>[93.456,-80.428,53.029,1],
11387=>[93.473,-80.420,53.029,1],
11388=>[93.486,-80.415,53.027,1],
11389=>[93.496,-80.412,53.023,1],
11390=>[93.503,-80.407,53.017,1],
11391=>[93.507,-80.403,53.011,1],
11392=>[93.510,-80.398,53.007,1],
11393=>[93.513,-80.394,53.002,1],
11394=>[93.516,-80.389,52.997,1],
11395=>[93.520,-80.385,52.991,1],
11396=>[93.523,-80.380,52.984,1],
11397=>[93.526,-80.375,52.977,1],
11398=>[93.530,-80.370,52.969,1],
11399=>[93.534,-80.366,52.961,1],
11400=>[93.537,-80.361,52.952,1],
11401=>[93.540,-80.356,52.943,1],
11402=>[93.544,-80.352,52.934,1],
11403=>[93.554,-80.343,52.926,1],
11404=>[93.564,-80.334,52.918,1],
11405=>[93.574,-80.325,52.909,1],
11406=>[93.584,-80.317,52.901,1],
11407=>[93.594,-80.309,52.892,1],
11992=>[91.796,-81.130,53.465,2],
11993=>[91.810,-81.124,53.441,2],
11994=>[91.824,-81.118,53.417,2],
11995=>[91.838,-81.113,53.395,2],
11996=>[91.852,-81.107,53.373,2],
11997=>[91.866,-81.102,53.352,2],
11998=>[91.880,-81.096,53.332,2],
11999=>[91.894,-81.090,53.314,2],
12000=>[91.908,-81.089,53.296,2],
12001=>[91.921,-81.088,53.277,2],
12002=>[91.934,-81.087,53.261,2],
12003=>[91.947,-81.086,53.245,2],
12004=>[91.961,-81.086,53.229,2],
12005=>[91.974,-81.085,53.213,2],
12006=>[91.987,-81.084,53.198,2],
12007=>[92.001,-81.083,53.184,2],
12008=>[92.015,-81.083,53.169,2],
12009=>[92.040,-81.075,53.155,2],
12010=>[92.065,-81.067,53.141,2],
12011=>[92.090,-81.059,53.128,2],
12012=>[92.115,-81.051,53.115,2],
12013=>[92.140,-81.043,53.102,2],
12014=>[92.165,-81.035,53.090,2],
12015=>[92.190,-81.027,53.078,2],
12016=>[92.215,-81.020,53.067,2],
12017=>[92.235,-81.013,53.056,2],
12018=>[92.255,-81.006,53.047,2],
12019=>[92.275,-80.999,53.037,2],
12020=>[92.295,-80.992,53.028,2],
12021=>[92.315,-80.986,53.020,2],
12022=>[92.335,-80.979,53.011,2],
12023=>[92.354,-80.972,53.003,2],
12038=>[92.638,-80.864,53.364,1],
12039=>[92.656,-80.856,53.348,1],
12040=>[92.674,-80.848,53.332,1],
12041=>[92.693,-80.841,53.315,1],
12042=>[92.712,-80.833,53.297,1],
12043=>[92.730,-80.826,53.281,1],
12044=>[92.748,-80.818,53.264,1],
12045=>[92.767,-80.811,53.247,1],
12046=>[92.785,-80.803,53.231,1],
12047=>[92.804,-80.795,53.216,1],
12048=>[92.823,-80.788,53.201,1],
12049=>[92.841,-80.780,53.187,1],
12050=>[92.859,-80.773,53.173,1],
12051=>[92.878,-80.765,53.161,1],
12052=>[92.897,-80.757,53.149,1],
12053=>[92.915,-80.750,53.137,1],
12054=>[92.933,-80.742,53.128,1],
12055=>[92.949,-80.731,53.120,1],
12056=>[92.966,-80.720,53.111,1],
12057=>[92.982,-80.710,53.103,1],
12058=>[92.998,-80.699,53.096,1],
12059=>[93.015,-80.688,53.089,1],
12060=>[93.031,-80.678,53.082,1],
12061=>[93.048,-80.667,53.075,1],
12062=>[93.064,-80.657,53.069,1],
12063=>[93.080,-80.646,53.063,1],
12064=>[93.096,-80.635,53.057,1],
12065=>[93.113,-80.626,53.051,1],
12066=>[93.129,-80.615,53.045,1],
12067=>[93.146,-80.604,53.039,1],
12068=>[93.162,-80.594,53.034,1],
12069=>[93.179,-80.583,53.028,1],
12070=>[93.195,-80.573,53.022,1],
12075=>[93.276,-80.519,52.999,1],
12076=>[93.293,-80.509,52.996,1],
12077=>[93.306,-80.498,52.994,1],
12078=>[93.319,-80.487,52.992,1],
12079=>[93.331,-80.475,52.991,1],
12080=>[93.343,-80.464,52.991,1],
12081=>[93.356,-80.453,52.993,1],
12082=>[93.368,-80.442,52.996,1],
12083=>[93.382,-80.437,53.000,1],
12084=>[93.396,-80.433,53.006,1],
12085=>[93.412,-80.427,53.012,1],
12086=>[93.428,-80.420,53.018,1],
12087=>[93.444,-80.413,53.021,1],
12088=>[93.460,-80.406,53.021,1],
12089=>[93.475,-80.400,53.019,1],
12090=>[93.485,-80.396,53.016,1],
12091=>[93.494,-80.393,53.012,1],
12092=>[93.500,-80.388,53.009,1],
12093=>[93.503,-80.384,53.005,1],
12094=>[93.507,-80.379,53.001,1],
12095=>[93.510,-80.375,52.996,1],
12096=>[93.513,-80.370,52.991,1],
12097=>[93.517,-80.366,52.983,1],
12098=>[93.520,-80.361,52.976,1],
12099=>[93.523,-80.356,52.968,1],
12100=>[93.526,-80.351,52.960,1],
12101=>[93.530,-80.347,52.951,1],
12102=>[93.534,-80.342,52.943,1],
12103=>[93.544,-80.333,52.935,1],
12104=>[93.554,-80.325,52.926,1],
12105=>[93.564,-80.316,52.917,1],
12106=>[93.574,-80.307,52.910,1],
12107=>[93.584,-80.299,52.901,1],
12108=>[93.594,-80.290,52.892,1],
12693=>[91.794,-81.099,53.489,2],
12694=>[91.808,-81.094,53.465,2],
12695=>[91.822,-81.089,53.442,2],
12696=>[91.836,-81.083,53.418,2],
12697=>[91.850,-81.081,53.396,2],
12698=>[91.863,-81.080,53.375,2],
12699=>[91.876,-81.080,53.354,2],
12700=>[91.889,-81.079,53.335,2],
12701=>[91.903,-81.078,53.316,2],
12702=>[91.916,-81.077,53.297,2],
12703=>[91.930,-81.077,53.279,2],
12704=>[91.943,-81.076,53.261,2],
12705=>[91.956,-81.075,53.244,2],
12706=>[91.970,-81.075,53.228,2],
12707=>[91.985,-81.074,53.212,2],
12708=>[91.999,-81.074,53.196,2],
12709=>[92.013,-81.069,53.181,2],
12710=>[92.027,-81.060,53.165,2],
12711=>[92.042,-81.050,53.151,2],
12712=>[92.060,-81.042,53.137,2],
12713=>[92.082,-81.033,53.123,2],
12714=>[92.107,-81.026,53.109,2],
12715=>[92.132,-81.017,53.097,2],
12716=>[92.157,-81.010,53.085,2],
12717=>[92.181,-81.002,53.073,2],
12718=>[92.207,-80.994,53.062,2],
12719=>[92.232,-80.986,53.051,2],
12720=>[92.258,-80.978,53.041,2],
12721=>[92.284,-80.971,53.032,2],
12722=>[92.306,-80.963,53.023,2],
12723=>[92.325,-80.956,53.014,2],
12724=>[92.346,-80.949,53.005,2],
12740=>[92.652,-80.836,53.344,1],
12741=>[92.670,-80.828,53.328,1],
12742=>[92.689,-80.820,53.310,1],
12743=>[92.707,-80.813,53.293,1],
12744=>[92.725,-80.805,53.276,1],
12745=>[92.744,-80.798,53.258,1],
12746=>[92.763,-80.790,53.242,1],
12747=>[92.781,-80.782,53.225,1],
12748=>[92.799,-80.775,53.209,1],
12749=>[92.818,-80.767,53.194,1],
12750=>[92.836,-80.760,53.179,1],
12751=>[92.855,-80.752,53.164,1],
12752=>[92.873,-80.745,53.152,1],
12753=>[92.892,-80.737,53.140,1],
12754=>[92.910,-80.729,53.128,1],
12755=>[92.928,-80.720,53.118,1],
12756=>[92.944,-80.710,53.108,1],
12757=>[92.960,-80.699,53.100,1],
12758=>[92.977,-80.688,53.092,1],
12759=>[92.993,-80.678,53.084,1],
12760=>[93.010,-80.668,53.077,1],
12761=>[93.026,-80.657,53.070,1],
12762=>[93.043,-80.647,53.063,1],
12763=>[93.059,-80.636,53.057,1],
12764=>[93.075,-80.626,53.050,1],
12765=>[93.091,-80.615,53.045,1],
12766=>[93.108,-80.604,53.039,1],
12767=>[93.124,-80.594,53.033,1],
12768=>[93.141,-80.583,53.027,1],
12769=>[93.157,-80.573,53.022,1],
12770=>[93.174,-80.562,53.017,1],
12771=>[93.190,-80.551,53.011,1],
12772=>[93.206,-80.541,53.005,1],
12773=>[93.222,-80.530,52.999,1],
12774=>[93.238,-80.519,52.994,1],
12775=>[93.252,-80.509,52.990,1],
12776=>[93.265,-80.497,52.986,1],
12777=>[93.277,-80.486,52.983,1],
12778=>[93.289,-80.475,52.981,1],
12779=>[93.302,-80.464,52.979,1],
12780=>[93.314,-80.453,52.979,1],
12781=>[93.327,-80.441,52.979,1],
12782=>[93.340,-80.433,52.981,1],
12783=>[93.353,-80.429,52.983,1],
12784=>[93.367,-80.425,52.986,1],
12785=>[93.383,-80.419,52.992,1],
12786=>[93.400,-80.412,52.999,1],
12787=>[93.416,-80.405,53.006,1],
12788=>[93.432,-80.397,53.010,1],
12789=>[93.448,-80.391,53.012,1],
12790=>[93.463,-80.385,53.011,1],
12791=>[93.473,-80.381,53.009,1],
12792=>[93.483,-80.378,53.008,1],
12793=>[93.493,-80.374,53.007,1],
12794=>[93.497,-80.369,53.006,1],
12795=>[93.500,-80.365,53.002,1],
12796=>[93.503,-80.360,52.997,1],
12797=>[93.507,-80.356,52.992,1],
12798=>[93.510,-80.351,52.983,1],
12799=>[93.513,-80.347,52.975,1],
12800=>[93.517,-80.341,52.966,1],
12801=>[93.520,-80.337,52.959,1],
12802=>[93.523,-80.332,52.951,1],
12803=>[93.534,-80.324,52.942,1],
12804=>[93.544,-80.315,52.934,1],
12805=>[93.554,-80.306,52.925,1],
12806=>[93.564,-80.297,52.916,1],
12807=>[93.574,-80.289,52.909,1],
12808=>[93.584,-80.280,52.900,1],
12809=>[93.594,-80.272,52.892,1],
13394=>[91.792,-81.074,53.513,2],
13395=>[91.805,-81.073,53.490,2],
13396=>[91.818,-81.072,53.466,2],
13397=>[91.832,-81.071,53.442,2],
13398=>[91.845,-81.071,53.420,2],
13399=>[91.858,-81.070,53.398,2],
13400=>[91.872,-81.069,53.377,2],
13401=>[91.885,-81.068,53.356,2],
13402=>[91.898,-81.068,53.336,2],
13403=>[91.913,-81.068,53.316,2],
13404=>[91.927,-81.067,53.298,2],
13405=>[91.942,-81.066,53.280,2],
13406=>[91.956,-81.066,53.262,2],
13407=>[91.970,-81.065,53.245,2],
13408=>[91.985,-81.065,53.228,2],
13409=>[91.999,-81.060,53.211,2],
13410=>[92.012,-81.055,53.194,2],
13411=>[92.026,-81.050,53.178,2],
13412=>[92.040,-81.038,53.162,2],
13413=>[92.054,-81.026,53.148,2],
13414=>[92.070,-81.017,53.133,2],
13415=>[92.086,-81.009,53.119,2],
13416=>[92.106,-81.001,53.105,2],
13417=>[92.127,-80.992,53.093,2],
13418=>[92.149,-80.984,53.080,2],
13419=>[92.173,-80.976,53.068,2],
13420=>[92.199,-80.968,53.057,2],
13421=>[92.223,-80.960,53.047,2],
13422=>[92.248,-80.952,53.037,2],
13423=>[92.274,-80.944,53.027,2],
13424=>[92.299,-80.936,53.017,2],
13442=>[92.665,-80.808,53.325,1],
13443=>[92.684,-80.800,53.308,1],
13444=>[92.702,-80.792,53.290,1],
13445=>[92.721,-80.785,53.273,1],
13446=>[92.739,-80.777,53.254,1],
13447=>[92.758,-80.770,53.237,1],
13448=>[92.776,-80.762,53.220,1],
13449=>[92.795,-80.754,53.204,1],
13450=>[92.813,-80.747,53.188,1],
13451=>[92.832,-80.739,53.173,1],
13452=>[92.850,-80.732,53.157,1],
13453=>[92.869,-80.724,53.144,1],
13454=>[92.887,-80.717,53.132,1],
13455=>[92.906,-80.709,53.120,1],
13456=>[92.923,-80.700,53.109,1],
13457=>[92.939,-80.689,53.100,1],
13458=>[92.955,-80.679,53.091,1],
13459=>[92.972,-80.668,53.083,1],
13460=>[92.988,-80.657,53.075,1],
13461=>[93.005,-80.647,53.067,1],
13462=>[93.021,-80.636,53.060,1],
13463=>[93.038,-80.626,53.053,1],
13464=>[93.054,-80.615,53.047,1],
13465=>[93.070,-80.604,53.041,1],
13466=>[93.086,-80.594,53.034,1],
13467=>[93.103,-80.583,53.028,1],
13468=>[93.119,-80.573,53.022,1],
13469=>[93.136,-80.562,53.016,1],
13470=>[93.152,-80.551,53.010,1],
13471=>[93.168,-80.541,53.005,1],
13472=>[93.185,-80.530,52.999,1],
13473=>[93.198,-80.519,52.993,1],
13474=>[93.211,-80.508,52.987,1],
13475=>[93.223,-80.497,52.982,1],
13476=>[93.235,-80.486,52.977,1],
13477=>[93.248,-80.475,52.973,1],
13478=>[93.260,-80.463,52.970,1],
13479=>[93.273,-80.452,52.967,1],
13480=>[93.285,-80.441,52.966,1],
13481=>[93.298,-80.430,52.965,1],
13482=>[93.311,-80.425,52.966,1],
13483=>[93.325,-80.422,52.967,1],
13484=>[93.339,-80.418,52.969,1],
13485=>[93.355,-80.411,52.973,1],
13486=>[93.371,-80.404,52.979,1],
13487=>[93.388,-80.397,52.986,1],
13488=>[93.404,-80.390,52.993,1],
13489=>[93.420,-80.383,52.998,1],
13490=>[93.436,-80.375,53.001,1],
13491=>[93.451,-80.369,53.001,1],
13492=>[93.462,-80.366,53.002,1],
13493=>[93.472,-80.362,53.002,1],
13494=>[93.481,-80.359,53.002,1],
13495=>[93.490,-80.355,53.002,1],
13496=>[93.493,-80.350,52.999,1],
13497=>[93.497,-80.346,52.996,1],
13498=>[93.500,-80.341,52.992,1],
13499=>[93.503,-80.337,52.983,1],
13500=>[93.507,-80.332,52.974,1],
13501=>[93.510,-80.327,52.965,1],
13502=>[93.513,-80.322,52.956,1],
13503=>[93.523,-80.314,52.948,1],
13504=>[93.534,-80.305,52.940,1],
13505=>[93.544,-80.297,52.931,1],
13506=>[93.554,-80.288,52.923,1],
13507=>[93.564,-80.279,52.915,1],
13508=>[93.574,-80.271,52.906,1],
13509=>[93.584,-80.262,52.899,1],
13510=>[93.594,-80.253,52.891,1],
13511=>[93.604,-80.244,52.884,1],
14096=>[91.801,-81.062,53.514,2],
14097=>[91.814,-81.061,53.490,2],
14098=>[91.827,-81.061,53.467,2],
14099=>[91.841,-81.060,53.445,2],
14100=>[91.856,-81.060,53.422,2],
14101=>[91.870,-81.059,53.399,2],
14102=>[91.884,-81.059,53.378,2],
14103=>[91.898,-81.058,53.357,2],
14104=>[91.913,-81.058,53.336,2],
14105=>[91.927,-81.058,53.318,2],
14106=>[91.942,-81.057,53.299,2],
14107=>[91.956,-81.056,53.280,2],
14108=>[91.970,-81.055,53.262,2],
14109=>[91.984,-81.051,53.245,2],
14110=>[91.998,-81.046,53.226,2],
14111=>[92.011,-81.041,53.209,2],
14112=>[92.025,-81.036,53.192,2],
14113=>[92.039,-81.027,53.176,2],
14114=>[92.053,-81.015,53.160,2],
14115=>[92.067,-81.003,53.146,2],
14116=>[92.082,-80.992,53.131,2],
14117=>[92.098,-80.984,53.116,2],
14118=>[92.114,-80.976,53.103,2],
14119=>[92.131,-80.967,53.089,2],
14120=>[92.152,-80.959,53.077,2],
14121=>[92.173,-80.951,53.065,2],
14122=>[92.194,-80.942,53.054,2],
14123=>[92.215,-80.934,53.043,2],
14124=>[92.240,-80.927,53.032,2],
14125=>[92.265,-80.918,53.022,2],
14144=>[92.680,-80.780,53.307,1],
14145=>[92.698,-80.773,53.289,1],
14146=>[92.716,-80.764,53.272,1],
14147=>[92.735,-80.757,53.253,1],
14148=>[92.753,-80.749,53.235,1],
14149=>[92.772,-80.742,53.218,1],
14150=>[92.790,-80.734,53.200,1],
14151=>[92.808,-80.726,53.183,1],
14152=>[92.827,-80.719,53.168,1],
14153=>[92.846,-80.711,53.152,1],
14154=>[92.864,-80.704,53.138,1],
14155=>[92.882,-80.696,53.126,1],
14156=>[92.901,-80.688,53.114,1],
14157=>[92.918,-80.679,53.103,1],
14158=>[92.934,-80.668,53.093,1],
14159=>[92.950,-80.657,53.084,1],
14160=>[92.967,-80.647,53.075,1],
14161=>[92.983,-80.636,53.067,1],
14162=>[93.000,-80.626,53.059,1],
14163=>[93.016,-80.615,53.051,1],
14164=>[93.032,-80.604,53.045,1],
14165=>[93.049,-80.594,53.038,1],
14166=>[93.065,-80.583,53.031,1],
14167=>[93.081,-80.573,53.024,1],
14168=>[93.098,-80.562,53.018,1],
14169=>[93.114,-80.551,53.012,1],
14170=>[93.131,-80.541,53.005,1],
14171=>[93.144,-80.530,52.999,1],
14172=>[93.156,-80.519,52.993,1],
14173=>[93.169,-80.508,52.987,1],
14174=>[93.182,-80.497,52.981,1],
14175=>[93.194,-80.485,52.975,1],
14176=>[93.206,-80.474,52.969,1],
14177=>[93.219,-80.463,52.964,1],
14178=>[93.231,-80.452,52.960,1],
14179=>[93.243,-80.441,52.956,1],
14180=>[93.256,-80.429,52.953,1],
14181=>[93.269,-80.421,52.951,1],
14182=>[93.283,-80.417,52.951,1],
14183=>[93.297,-80.413,52.952,1],
14184=>[93.310,-80.410,52.952,1],
14185=>[93.327,-80.403,52.954,1],
14186=>[93.343,-80.397,52.959,1],
14187=>[93.359,-80.389,52.965,1],
14188=>[93.375,-80.382,52.971,1],
14189=>[93.392,-80.375,52.978,1],
14190=>[93.408,-80.368,52.984,1],
14191=>[93.424,-80.360,52.988,1],
14192=>[93.440,-80.353,52.991,1],
14193=>[93.450,-80.350,52.993,1],
14194=>[93.460,-80.347,52.994,1],
14195=>[93.470,-80.344,52.995,1],
14196=>[93.480,-80.340,52.995,1],
14197=>[93.487,-80.336,52.995,1],
14198=>[93.490,-80.331,52.992,1],
14199=>[93.493,-80.327,52.989,1],
14200=>[93.497,-80.322,52.980,1],
14201=>[93.500,-80.318,52.971,1],
14202=>[93.503,-80.312,52.961,1],
14203=>[93.513,-80.304,52.952,1],
14204=>[93.523,-80.296,52.944,1],
14205=>[93.534,-80.287,52.935,1],
14206=>[93.544,-80.278,52.927,1],
14207=>[93.554,-80.269,52.919,1],
14208=>[93.564,-80.261,52.911,1],
14209=>[93.574,-80.252,52.903,1],
14210=>[93.584,-80.243,52.897,1],
14211=>[93.594,-80.235,52.890,1],
14212=>[93.604,-80.226,52.882,1],
14797=>[91.798,-81.052,53.539,2],
14798=>[91.812,-81.052,53.515,2],
14799=>[91.826,-81.052,53.492,2],
14800=>[91.841,-81.051,53.469,2],
14801=>[91.856,-81.050,53.446,2],
14802=>[91.870,-81.050,53.424,2],
14803=>[91.884,-81.049,53.401,2],
14804=>[91.898,-81.049,53.380,2],
14805=>[91.913,-81.049,53.359,2],
14806=>[91.927,-81.048,53.339,2],
14807=>[91.942,-81.048,53.319,2],
14808=>[91.956,-81.046,53.299,2],
14809=>[91.969,-81.042,53.280,2],
14810=>[91.984,-81.036,53.262,2],
14811=>[91.997,-81.032,53.243,2],
14812=>[92.011,-81.027,53.225,2],
14813=>[92.024,-81.023,53.208,2],
14814=>[92.038,-81.017,53.190,2],
14815=>[92.052,-81.005,53.175,2],
14816=>[92.066,-80.992,53.159,2],
14817=>[92.080,-80.980,53.144,2],
14818=>[92.094,-80.968,53.129,2],
14819=>[92.109,-80.959,53.114,2],
14820=>[92.126,-80.951,53.100,2],
14821=>[92.142,-80.943,53.087,2],
14822=>[92.158,-80.935,53.074,2],
14823=>[92.177,-80.927,53.063,2],
14824=>[92.198,-80.918,53.051,2],
14825=>[92.219,-80.910,53.040,2],
14826=>[92.239,-80.902,53.029,2],
14846=>[92.693,-80.752,53.289,1],
14847=>[92.712,-80.745,53.271,1],
14848=>[92.730,-80.737,53.253,1],
14849=>[92.748,-80.729,53.234,1],
14850=>[92.767,-80.721,53.216,1],
14851=>[92.786,-80.714,53.199,1],
14852=>[92.804,-80.706,53.182,1],
14853=>[92.823,-80.698,53.165,1],
14854=>[92.841,-80.691,53.150,1],
14855=>[92.859,-80.683,53.136,1],
14856=>[92.878,-80.676,53.122,1],
14857=>[92.897,-80.668,53.109,1],
14858=>[92.913,-80.657,53.099,1],
14859=>[92.929,-80.647,53.088,1],
14860=>[92.945,-80.636,53.079,1],
14861=>[92.962,-80.626,53.069,1],
14862=>[92.978,-80.615,53.060,1],
14863=>[92.995,-80.604,53.052,1],
14864=>[93.011,-80.594,53.044,1],
14865=>[93.027,-80.584,53.037,1],
14866=>[93.044,-80.573,53.029,1],
14867=>[93.060,-80.563,53.022,1],
14868=>[93.076,-80.552,53.015,1],
14869=>[93.090,-80.541,53.009,1],
14870=>[93.102,-80.529,53.002,1],
14871=>[93.115,-80.519,52.995,1],
14872=>[93.128,-80.507,52.988,1],
14873=>[93.140,-80.496,52.982,1],
14874=>[93.152,-80.485,52.976,1],
14875=>[93.165,-80.474,52.969,1],
14876=>[93.178,-80.463,52.962,1],
14877=>[93.190,-80.451,52.956,1],
14878=>[93.202,-80.441,52.951,1],
14879=>[93.215,-80.429,52.946,1],
14880=>[93.227,-80.418,52.943,1],
14881=>[93.240,-80.413,52.940,1],
14882=>[93.255,-80.410,52.938,1],
14883=>[93.268,-80.406,52.936,1],
14884=>[93.282,-80.402,52.937,1],
14885=>[93.298,-80.396,52.938,1],
14886=>[93.314,-80.388,52.941,1],
14887=>[93.331,-80.381,52.945,1],
14888=>[93.347,-80.375,52.951,1],
14889=>[93.363,-80.367,52.956,1],
14890=>[93.379,-80.360,52.961,1],
14891=>[93.396,-80.353,52.968,1],
14892=>[93.412,-80.346,52.973,1],
14893=>[93.428,-80.338,52.978,1],
14894=>[93.438,-80.335,52.981,1],
14895=>[93.448,-80.331,52.983,1],
14896=>[93.458,-80.328,52.985,1],
14897=>[93.468,-80.325,52.986,1],
14898=>[93.478,-80.322,52.987,1],
14899=>[93.483,-80.317,52.986,1],
14900=>[93.487,-80.312,52.983,1],
14901=>[93.490,-80.308,52.975,1],
14902=>[93.493,-80.303,52.966,1],
14903=>[93.503,-80.294,52.955,1],
14904=>[93.513,-80.286,52.946,1],
14905=>[93.523,-80.277,52.938,1],
14906=>[93.534,-80.269,52.930,1],
14907=>[93.544,-80.260,52.922,1],
14908=>[93.554,-80.251,52.915,1],
14909=>[93.564,-80.243,52.908,1],
14910=>[93.574,-80.234,52.900,1],
14911=>[93.584,-80.225,52.894,1],
14912=>[93.594,-80.216,52.887,1],
14913=>[93.604,-80.208,52.879,1],
15498=>[91.798,-81.043,53.563,2],
15499=>[91.812,-81.043,53.540,2],
15500=>[91.826,-81.042,53.516,2],
15501=>[91.841,-81.042,53.493,2],
15502=>[91.856,-81.041,53.470,2],
15503=>[91.870,-81.040,53.447,2],
15504=>[91.884,-81.040,53.425,2],
15505=>[91.898,-81.039,53.402,2],
15506=>[91.913,-81.039,53.381,2],
15507=>[91.927,-81.039,53.360,2],
15508=>[91.942,-81.037,53.339,2],
15509=>[91.955,-81.033,53.319,2],
15510=>[91.969,-81.027,53.300,2],
15511=>[91.983,-81.023,53.281,2],
15512=>[91.996,-81.018,53.262,2],
15513=>[92.010,-81.013,53.243,2],
15514=>[92.023,-81.008,53.225,2],
15515=>[92.037,-81.004,53.207,2],
15516=>[92.051,-80.995,53.190,2],
15517=>[92.065,-80.983,53.174,2],
15518=>[92.079,-80.971,53.158,2],
15519=>[92.093,-80.958,53.142,2],
15520=>[92.107,-80.945,53.128,2],
15521=>[92.122,-80.934,53.113,2],
15522=>[92.138,-80.926,53.098,2],
15523=>[92.154,-80.918,53.085,2],
15524=>[92.170,-80.910,53.073,2],
15525=>[92.186,-80.902,53.061,2],
15526=>[92.202,-80.894,53.050,2],
15548=>[92.707,-80.723,53.272,1],
15549=>[92.725,-80.717,53.253,1],
15550=>[92.744,-80.709,53.235,1],
15551=>[92.763,-80.701,53.216,1],
15552=>[92.781,-80.694,53.199,1],
15553=>[92.799,-80.685,53.182,1],
15554=>[92.818,-80.678,53.165,1],
15555=>[92.837,-80.670,53.149,1],
15556=>[92.855,-80.663,53.135,1],
15557=>[92.873,-80.655,53.121,1],
15558=>[92.892,-80.647,53.108,1],
15559=>[92.908,-80.636,53.098,1],
15560=>[92.924,-80.626,53.088,1],
15561=>[92.940,-80.616,53.078,1],
15562=>[92.957,-80.605,53.067,1],
15563=>[92.973,-80.594,53.057,1],
15564=>[92.990,-80.584,53.049,1],
15565=>[93.006,-80.573,53.040,1],
15566=>[93.022,-80.563,53.032,1],
15567=>[93.036,-80.551,53.023,1],
15568=>[93.049,-80.541,53.016,1],
15569=>[93.061,-80.529,53.008,1],
15570=>[93.074,-80.518,53.001,1],
15571=>[93.086,-80.507,52.993,1],
15572=>[93.098,-80.496,52.986,1],
15573=>[93.111,-80.485,52.979,1],
15574=>[93.123,-80.473,52.972,1],
15575=>[93.136,-80.462,52.966,1],
15576=>[93.148,-80.451,52.958,1],
15577=>[93.160,-80.440,52.951,1],
15578=>[93.173,-80.428,52.944,1],
15579=>[93.186,-80.418,52.938,1],
15580=>[93.198,-80.409,52.933,1],
15581=>[93.212,-80.405,52.930,1],
15582=>[93.226,-80.401,52.927,1],
15583=>[93.240,-80.398,52.924,1],
15584=>[93.254,-80.394,52.922,1],
15585=>[93.270,-80.388,52.923,1],
15586=>[93.286,-80.381,52.924,1],
15587=>[93.302,-80.374,52.927,1],
15588=>[93.319,-80.366,52.931,1],
15589=>[93.335,-80.359,52.936,1],
15590=>[93.351,-80.352,52.941,1],
15591=>[93.367,-80.345,52.946,1],
15592=>[93.383,-80.337,52.952,1],
15593=>[93.400,-80.331,52.958,1],
15594=>[93.416,-80.324,52.962,1],
15595=>[93.427,-80.319,52.966,1],
15596=>[93.437,-80.316,52.969,1],
15597=>[93.446,-80.312,52.970,1],
15598=>[93.457,-80.309,52.972,1],
15599=>[93.467,-80.306,52.972,1],
15600=>[93.477,-80.303,52.971,1],
15601=>[93.480,-80.298,52.969,1],
15602=>[93.483,-80.294,52.963,1],
15603=>[93.493,-80.284,52.956,1],
15604=>[93.503,-80.276,52.947,1],
15605=>[93.513,-80.268,52.938,1],
15606=>[93.523,-80.259,52.930,1],
15607=>[93.534,-80.250,52.923,1],
15608=>[93.544,-80.241,52.916,1],
15609=>[93.554,-80.233,52.910,1],
15610=>[93.564,-80.224,52.904,1],
15611=>[93.574,-80.215,52.896,1],
15612=>[93.584,-80.207,52.890,1],
15613=>[93.594,-80.198,52.884,1],
15614=>[93.604,-80.190,52.876,1],
16200=>[91.812,-81.033,53.563,2],
16201=>[91.826,-81.033,53.540,2],
16202=>[91.841,-81.032,53.516,2],
16203=>[91.856,-81.032,53.493,2],
16204=>[91.870,-81.031,53.470,2],
16205=>[91.884,-81.030,53.448,2],
16206=>[91.898,-81.030,53.425,2],
16207=>[91.913,-81.030,53.404,2],
16208=>[91.927,-81.028,53.382,2],
16209=>[91.941,-81.024,53.361,2],
16210=>[91.954,-81.018,53.341,2],
16211=>[91.968,-81.014,53.321,2],
16212=>[91.982,-81.009,53.301,2],
16213=>[91.996,-81.004,53.282,2],
16214=>[92.009,-80.999,53.263,2],
16215=>[92.023,-80.995,53.244,2],
16216=>[92.036,-80.990,53.226,2],
16217=>[92.050,-80.984,53.208,2],
16218=>[92.064,-80.972,53.191,2],
16219=>[92.078,-80.960,53.175,2],
16220=>[92.092,-80.948,53.159,2],
16221=>[92.106,-80.936,53.143,2],
16222=>[92.121,-80.924,53.128,2],
16223=>[92.135,-80.911,53.112,2],
16224=>[92.150,-80.901,53.099,2],
16225=>[92.165,-80.893,53.086,2],
16226=>[92.181,-80.885,53.073,2],
16227=>[92.198,-80.877,53.061,2],
16250=>[92.719,-80.694,53.256,1],
16251=>[92.738,-80.687,53.237,1],
16252=>[92.758,-80.680,53.218,1],
16253=>[92.776,-80.673,53.200,1],
16254=>[92.795,-80.666,53.184,1],
16255=>[92.813,-80.658,53.167,1],
16256=>[92.832,-80.650,53.150,1],
16257=>[92.850,-80.642,53.136,1],
16258=>[92.869,-80.635,53.122,1],
16259=>[92.886,-80.626,53.110,1],
16260=>[92.903,-80.616,53.099,1],
16261=>[92.919,-80.605,53.090,1],
16262=>[92.935,-80.594,53.080,1],
16263=>[92.952,-80.584,53.068,1],
16264=>[92.968,-80.573,53.058,1],
16265=>[92.982,-80.563,53.048,1],
16266=>[92.995,-80.551,53.040,1],
16267=>[93.007,-80.540,53.030,1],
16268=>[93.019,-80.529,53.021,1],
16269=>[93.032,-80.518,53.012,1],
16270=>[93.045,-80.507,53.003,1],
16271=>[93.057,-80.495,52.995,1],
16272=>[93.069,-80.484,52.986,1],
16273=>[93.082,-80.473,52.979,1],
16274=>[93.094,-80.462,52.971,1],
16275=>[93.107,-80.450,52.963,1],
16276=>[93.119,-80.439,52.955,1],
16277=>[93.132,-80.428,52.948,1],
16278=>[93.144,-80.417,52.941,1],
16279=>[93.156,-80.406,52.934,1],
16280=>[93.170,-80.401,52.927,1],
16281=>[93.184,-80.397,52.922,1],
16282=>[93.198,-80.394,52.917,1],
16283=>[93.212,-80.390,52.913,1],
16284=>[93.225,-80.387,52.911,1],
16285=>[93.241,-80.380,52.909,1],
16286=>[93.258,-80.373,52.909,1],
16287=>[93.274,-80.366,52.911,1],
16288=>[93.290,-80.359,52.913,1],
16289=>[93.306,-80.352,52.916,1],
16290=>[93.323,-80.344,52.921,1],
16291=>[93.339,-80.337,52.926,1],
16292=>[93.355,-80.330,52.932,1],
16293=>[93.371,-80.323,52.937,1],
16294=>[93.388,-80.316,52.942,1],
16295=>[93.404,-80.309,52.946,1],
16296=>[93.415,-80.304,52.949,1],
16297=>[93.425,-80.301,52.952,1],
16298=>[93.435,-80.297,52.954,1],
16299=>[93.445,-80.294,52.954,1],
16300=>[93.455,-80.290,52.955,1],
16301=>[93.465,-80.287,52.954,1],
16302=>[93.474,-80.284,52.953,1],
16303=>[93.483,-80.275,52.949,1],
16304=>[93.493,-80.266,52.942,1],
16305=>[93.503,-80.258,52.935,1],
16306=>[93.513,-80.249,52.928,1],
16307=>[93.523,-80.240,52.922,1],
16308=>[93.534,-80.232,52.916,1],
16309=>[93.544,-80.223,52.910,1],
16310=>[93.554,-80.215,52.904,1],
16311=>[93.564,-80.206,52.899,1],
16312=>[93.574,-80.197,52.893,1],
16313=>[93.584,-80.188,52.887,1],
16314=>[93.594,-80.180,52.880,1],
16315=>[93.604,-80.171,52.873,1],
16316=>[93.614,-80.162,52.867,1],
16902=>[91.826,-81.024,53.563,2],
16903=>[91.841,-81.023,53.540,2],
16904=>[91.856,-81.022,53.517,2],
16905=>[91.870,-81.022,53.494,2],
16906=>[91.884,-81.021,53.472,2],
16907=>[91.898,-81.021,53.449,2],
16908=>[91.913,-81.019,53.427,2],
16909=>[91.926,-81.014,53.406,2],
16910=>[91.940,-81.009,53.384,2],
16911=>[91.954,-81.005,53.363,2],
16912=>[91.967,-81.000,53.343,2],
16913=>[91.981,-80.995,53.322,2],
16914=>[91.995,-80.990,53.303,2],
16915=>[92.008,-80.986,53.284,2],
16916=>[92.022,-80.980,53.265,2],
16917=>[92.035,-80.976,53.246,2],
16918=>[92.050,-80.971,53.228,2],
16919=>[92.063,-80.962,53.210,2],
16920=>[92.077,-80.949,53.193,2],
16921=>[92.091,-80.937,53.176,2],
16922=>[92.105,-80.925,53.160,2],
16923=>[92.120,-80.913,53.144,2],
16924=>[92.134,-80.901,53.129,2],
16925=>[92.148,-80.889,53.114,2],
16926=>[92.162,-80.877,53.100,2],
16927=>[92.177,-80.868,53.086,2],
16951=>[92.689,-80.674,53.260,1],
16952=>[92.715,-80.667,53.241,1],
16953=>[92.741,-80.659,53.223,1],
16954=>[92.768,-80.651,53.205,1],
16955=>[92.789,-80.644,53.188,1],
16956=>[92.809,-80.638,53.171,1],
16957=>[92.827,-80.630,53.154,1],
16958=>[92.846,-80.623,53.139,1],
16959=>[92.864,-80.614,53.125,1],
16960=>[92.881,-80.605,53.113,1],
16961=>[92.898,-80.594,53.104,1],
16962=>[92.914,-80.584,53.095,1],
16963=>[92.928,-80.573,53.085,1],
16964=>[92.941,-80.562,53.074,1],
16965=>[92.953,-80.551,53.063,1],
16966=>[92.966,-80.540,53.053,1],
16967=>[92.978,-80.529,53.042,1],
16968=>[92.991,-80.517,53.033,1],
16969=>[93.003,-80.506,53.023,1],
16970=>[93.015,-80.495,53.011,1],
16971=>[93.028,-80.484,53.000,1],
16972=>[93.040,-80.472,52.991,1],
16973=>[93.053,-80.461,52.981,1],
16974=>[93.065,-80.450,52.973,1],
16975=>[93.077,-80.439,52.964,1],
16976=>[93.090,-80.428,52.956,1],
16977=>[93.102,-80.416,52.947,1],
16978=>[93.115,-80.406,52.939,1],
16979=>[93.128,-80.397,52.932,1],
16980=>[93.142,-80.393,52.924,1],
16981=>[93.155,-80.390,52.917,1],
16982=>[93.169,-80.386,52.911,1],
16983=>[93.183,-80.382,52.905,1],
16984=>[93.197,-80.378,52.901,1],
16985=>[93.213,-80.372,52.898,1],
16986=>[93.229,-80.365,52.897,1],
16987=>[93.246,-80.358,52.897,1],
16988=>[93.262,-80.351,52.898,1],
16989=>[93.278,-80.344,52.900,1],
16990=>[93.294,-80.337,52.905,1],
16991=>[93.310,-80.329,52.909,1],
16992=>[93.327,-80.322,52.914,1],
16993=>[93.343,-80.316,52.918,1],
16994=>[93.359,-80.308,52.922,1],
16995=>[93.375,-80.301,52.925,1],
16996=>[93.392,-80.294,52.929,1],
16997=>[93.404,-80.289,52.931,1],
16998=>[93.414,-80.286,52.932,1],
16999=>[93.424,-80.282,52.934,1],
17000=>[93.433,-80.279,52.935,1],
17001=>[93.443,-80.275,52.935,1],
17002=>[93.453,-80.272,52.936,1],
17003=>[93.463,-80.256,52.936,1],
17004=>[93.483,-80.256,52.932,1],
17005=>[93.493,-80.248,52.927,1],
17006=>[93.503,-80.240,52.922,1],
17007=>[93.513,-80.231,52.917,1],
17008=>[93.523,-80.222,52.913,1],
17009=>[93.534,-80.213,52.909,1],
17010=>[93.544,-80.205,52.904,1],
17011=>[93.554,-80.196,52.898,1],
17012=>[93.564,-80.187,52.894,1],
17013=>[93.574,-80.179,52.889,1],
17014=>[93.584,-80.170,52.883,1],
17015=>[93.594,-80.162,52.877,1],
17016=>[93.604,-80.153,52.871,1],
17017=>[93.614,-80.144,52.865,1],
17058=>[93.990,-79.964,52.391,1],
17059=>[93.999,-79.962,52.375,1],
17060=>[94.007,-79.961,52.361,1],
17061=>[94.016,-79.959,52.346,1],
17062=>[94.025,-79.958,52.330,1],
17063=>[94.033,-79.956,52.315,1],
17064=>[94.042,-79.955,52.299,1],
17065=>[94.050,-79.953,52.284,1],
17066=>[94.059,-79.952,52.268,1],
17603=>[91.826,-81.014,53.587,2],
17604=>[91.841,-81.013,53.564,2],
17605=>[91.856,-81.013,53.541,2],
17606=>[91.870,-81.012,53.518,2],
17607=>[91.884,-81.012,53.496,2],
17608=>[91.898,-81.010,53.473,2],
17609=>[91.912,-81.005,53.451,2],
17610=>[91.926,-81.000,53.429,2],
17611=>[91.939,-80.996,53.407,2],
17612=>[91.953,-80.991,53.387,2],
17613=>[91.966,-80.986,53.366,2],
17614=>[91.980,-80.981,53.346,2],
17615=>[91.994,-80.977,53.326,2],
17616=>[92.008,-80.971,53.307,2],
17617=>[92.021,-80.967,53.287,2],
17618=>[92.035,-80.962,53.268,2],
17619=>[92.049,-80.958,53.249,2],
17620=>[92.062,-80.952,53.230,2],
17621=>[92.076,-80.939,53.213,2],
17622=>[92.090,-80.927,53.196,2],
17623=>[92.104,-80.915,53.179,2],
17624=>[92.119,-80.903,53.162,2],
17625=>[92.133,-80.890,53.147,2],
17626=>[92.147,-80.878,53.131,2],
17627=>[92.161,-80.866,53.116,2],
17652=>[92.651,-80.655,53.266,1],
17653=>[92.677,-80.648,53.247,1],
17654=>[92.704,-80.640,53.230,1],
17655=>[92.730,-80.632,53.211,1],
17656=>[92.757,-80.625,53.193,1],
17657=>[92.783,-80.617,53.176,1],
17658=>[92.809,-80.610,53.160,1],
17659=>[92.836,-80.601,53.145,1],
17660=>[92.860,-80.594,53.131,1],
17661=>[92.874,-80.584,53.120,1],
17662=>[92.887,-80.573,53.110,1],
17663=>[92.899,-80.561,53.101,1],
17664=>[92.912,-80.551,53.091,1],
17665=>[92.924,-80.539,53.080,1],
17666=>[92.936,-80.528,53.070,1],
17667=>[92.949,-80.517,53.059,1],
17668=>[92.961,-80.506,53.048,1],
17669=>[92.974,-80.494,53.038,1],
17670=>[92.986,-80.483,53.027,1],
17671=>[92.999,-80.472,53.014,1],
17672=>[93.011,-80.461,53.001,1],
17673=>[93.023,-80.450,52.989,1],
17674=>[93.036,-80.438,52.978,1],
17675=>[93.049,-80.428,52.968,1],
17676=>[93.061,-80.416,52.958,1],
17677=>[93.073,-80.405,52.950,1],
17678=>[93.086,-80.394,52.941,1],
17679=>[93.099,-80.389,52.932,1],
17680=>[93.113,-80.385,52.924,1],
17681=>[93.127,-80.381,52.915,1],
17682=>[93.141,-80.378,52.908,1],
17683=>[93.155,-80.375,52.901,1],
17684=>[93.168,-80.371,52.895,1],
17685=>[93.185,-80.364,52.891,1],
17686=>[93.201,-80.357,52.888,1],
17687=>[93.217,-80.350,52.887,1],
17688=>[93.233,-80.343,52.886,1],
17689=>[93.250,-80.336,52.888,1],
17690=>[93.266,-80.329,52.890,1],
17691=>[93.282,-80.322,52.895,1],
17692=>[93.298,-80.315,52.899,1],
17693=>[93.314,-80.307,52.902,1],
17694=>[93.331,-80.300,52.905,1],
17695=>[93.347,-80.293,52.907,1],
17696=>[93.363,-80.286,52.909,1],
17697=>[93.379,-80.278,52.911,1],
17698=>[93.392,-80.274,52.912,1],
17699=>[93.402,-80.270,52.914,1],
17700=>[93.412,-80.267,52.916,1],
17701=>[93.422,-80.263,52.917,1],
17702=>[93.432,-80.260,52.917,1],
17703=>[93.442,-80.243,52.917,1],
17704=>[93.451,-80.225,52.917,1],
17705=>[93.465,-80.226,52.916,1],
17706=>[93.488,-80.227,52.913,1],
17707=>[93.503,-80.221,52.909,1],
17708=>[93.513,-80.212,52.906,1],
17709=>[93.523,-80.204,52.903,1],
17710=>[93.534,-80.195,52.901,1],
17711=>[93.544,-80.187,52.897,1],
17712=>[93.554,-80.178,52.892,1],
17713=>[93.564,-80.169,52.889,1],
17714=>[93.574,-80.160,52.884,1],
17715=>[93.584,-80.152,52.879,1],
17716=>[93.594,-80.143,52.874,1],
17717=>[93.604,-80.134,52.869,1],
17718=>[93.614,-80.126,52.863,1],
17719=>[93.624,-80.117,52.857,1],
17758=>[93.981,-79.951,52.416,1],
17759=>[93.989,-79.949,52.401,1],
17760=>[93.998,-79.948,52.386,1],
17761=>[94.006,-79.946,52.372,1],
17762=>[94.015,-79.945,52.357,1],
17763=>[94.024,-79.943,52.341,1],
17764=>[94.032,-79.942,52.326,1],
17765=>[94.041,-79.940,52.310,1],
17766=>[94.049,-79.939,52.295,1],
17767=>[94.058,-79.938,52.279,1],
17768=>[94.066,-79.936,52.263,1],
18305=>[91.841,-81.004,53.588,2],
18306=>[91.856,-81.003,53.565,2],
18307=>[91.870,-81.003,53.542,2],
18308=>[91.884,-81.001,53.520,2],
18309=>[91.897,-80.996,53.497,2],
18310=>[91.911,-80.991,53.476,2],
18311=>[91.925,-80.986,53.454,2],
18312=>[91.939,-80.982,53.432,2],
18313=>[91.952,-80.977,53.411,2],
18314=>[91.966,-80.972,53.390,2],
18315=>[91.980,-80.967,53.370,2],
18316=>[91.993,-80.962,53.350,2],
18317=>[92.007,-80.958,53.330,2],
18318=>[92.020,-80.953,53.310,2],
18319=>[92.034,-80.948,53.290,2],
18320=>[92.048,-80.943,53.271,2],
18321=>[92.062,-80.939,53.252,2],
18322=>[92.075,-80.929,53.234,2],
18323=>[92.089,-80.917,53.217,2],
18324=>[92.103,-80.905,53.199,2],
18325=>[92.118,-80.892,53.182,2],
18326=>[92.132,-80.880,53.166,2],
18327=>[92.146,-80.868,53.149,2],
18353=>[92.616,-80.638,53.274,1],
18354=>[92.641,-80.629,53.256,1],
18355=>[92.666,-80.622,53.237,1],
18356=>[92.693,-80.613,53.219,1],
18357=>[92.719,-80.606,53.201,1],
18358=>[92.745,-80.598,53.183,1],
18359=>[92.772,-80.591,53.167,1],
18360=>[92.798,-80.583,53.152,1],
18361=>[92.824,-80.576,53.139,1],
18362=>[92.850,-80.568,53.129,1],
18363=>[92.868,-80.554,53.119,1],
18364=>[92.882,-80.539,53.108,1],
18365=>[92.895,-80.528,53.098,1],
18366=>[92.908,-80.516,53.087,1],
18367=>[92.920,-80.505,53.077,1],
18368=>[92.932,-80.494,53.067,1],
18369=>[92.945,-80.483,53.055,1],
18370=>[92.957,-80.472,53.043,1],
18371=>[92.970,-80.460,53.031,1],
18372=>[92.982,-80.450,53.018,1],
18373=>[92.995,-80.438,53.005,1],
18374=>[93.007,-80.427,52.991,1],
18375=>[93.019,-80.416,52.978,1],
18376=>[93.032,-80.405,52.967,1],
18377=>[93.044,-80.394,52.956,1],
18378=>[93.057,-80.385,52.946,1],
18379=>[93.071,-80.381,52.937,1],
18380=>[93.085,-80.378,52.928,1],
18381=>[93.098,-80.374,52.919,1],
18382=>[93.113,-80.370,52.910,1],
18383=>[93.126,-80.367,52.902,1],
18384=>[93.140,-80.363,52.894,1],
18385=>[93.156,-80.356,52.888,1],
18386=>[93.172,-80.350,52.884,1],
18387=>[93.189,-80.342,52.880,1],
18388=>[93.205,-80.335,52.878,1],
18389=>[93.221,-80.328,52.879,1],
18390=>[93.237,-80.321,52.880,1],
18391=>[93.254,-80.314,52.882,1],
18392=>[93.270,-80.306,52.885,1],
18393=>[93.286,-80.300,52.888,1],
18394=>[93.302,-80.293,52.891,1],
18395=>[93.319,-80.285,52.892,1],
18396=>[93.335,-80.278,52.892,1],
18397=>[93.351,-80.271,52.893,1],
18398=>[93.367,-80.264,52.893,1],
18399=>[93.380,-80.259,52.894,1],
18400=>[93.391,-80.255,52.896,1],
18401=>[93.401,-80.252,52.897,1],
18402=>[93.410,-80.248,52.898,1],
18403=>[93.420,-80.233,52.899,1],
18404=>[93.430,-80.211,52.899,1],
18405=>[93.439,-80.194,52.900,1],
18406=>[93.445,-80.196,52.899,1],
18407=>[93.470,-80.196,52.898,1],
18408=>[93.493,-80.196,52.897,1],
18409=>[93.513,-80.194,52.895,1],
18410=>[93.523,-80.185,52.894,1],
18411=>[93.534,-80.177,52.892,1],
18412=>[93.544,-80.168,52.890,1],
18413=>[93.554,-80.159,52.887,1],
18414=>[93.564,-80.151,52.884,1],
18415=>[93.574,-80.142,52.881,1],
18416=>[93.584,-80.134,52.876,1],
18417=>[93.594,-80.124,52.871,1],
18418=>[93.604,-80.116,52.867,1],
18419=>[93.614,-80.107,52.861,1],
18420=>[93.624,-80.099,52.856,1],
18421=>[93.634,-80.090,52.851,1],
18458=>[93.971,-79.938,52.440,1],
18459=>[93.980,-79.936,52.425,1],
18460=>[93.988,-79.935,52.410,1],
18461=>[93.997,-79.933,52.396,1],
18462=>[94.005,-79.932,52.382,1],
18463=>[94.014,-79.930,52.367,1],
18464=>[94.023,-79.929,52.352,1],
18465=>[94.031,-79.927,52.336,1],
18466=>[94.040,-79.926,52.321,1],
18467=>[94.048,-79.925,52.305,1],
18468=>[94.057,-79.924,52.290,1],
18469=>[94.065,-79.922,52.275,1],
18470=>[94.074,-79.921,52.259,1],
18497=>[94.231,-79.587,51.699,1],
18498=>[94.244,-79.567,51.671,1],
18499=>[94.257,-79.548,51.644,1],
18500=>[94.269,-79.528,51.616,1],
18501=>[94.282,-79.508,51.586,1],
18502=>[94.295,-79.488,51.558,1],
18503=>[94.308,-79.469,51.530,1],
18504=>[94.320,-79.449,51.501,1],
18505=>[94.337,-79.471,51.473,1],
18506=>[94.353,-79.503,51.443,1],
18507=>[94.370,-79.534,51.413,1],
18508=>[94.388,-79.565,51.383,1],
18509=>[94.405,-79.596,51.353,1],
19007=>[91.856,-80.994,53.588,2],
19008=>[91.869,-80.992,53.566,2],
19009=>[91.883,-80.986,53.544,2],
19010=>[91.897,-80.982,53.522,2],
19011=>[91.911,-80.977,53.501,2],
19012=>[91.924,-80.972,53.479,2],
19013=>[91.938,-80.967,53.456,2],
19014=>[91.951,-80.963,53.436,2],
19015=>[91.965,-80.958,53.416,2],
19016=>[91.979,-80.953,53.395,2],
19017=>[91.993,-80.949,53.374,2],
19018=>[92.006,-80.944,53.353,2],
19019=>[92.020,-80.939,53.333,2],
19020=>[92.033,-80.934,53.313,2],
19021=>[92.047,-80.930,53.294,2],
19022=>[92.061,-80.925,53.275,2],
19023=>[92.074,-80.919,53.257,2],
19024=>[92.088,-80.907,53.238,2],
19025=>[92.102,-80.894,53.220,2],
19026=>[92.117,-80.882,53.203,2],
19027=>[92.131,-80.870,53.186,2],
19054=>[92.598,-80.621,53.285,1],
19055=>[92.619,-80.613,53.266,1],
19056=>[92.640,-80.604,53.248,1],
19057=>[92.661,-80.596,53.229,1],
19058=>[92.683,-80.588,53.210,1],
19059=>[92.708,-80.580,53.192,1],
19060=>[92.734,-80.572,53.176,1],
19061=>[92.760,-80.564,53.161,1],
19062=>[92.786,-80.557,53.147,1],
19063=>[92.812,-80.549,53.136,1],
19064=>[92.839,-80.541,53.126,1],
19065=>[92.859,-80.529,53.117,1],
19066=>[92.873,-80.514,53.106,1],
19067=>[92.888,-80.500,53.096,1],
19068=>[92.902,-80.485,53.086,1],
19069=>[92.916,-80.471,53.075,1],
19070=>[92.928,-80.460,53.062,1],
19071=>[92.940,-80.449,53.049,1],
19072=>[92.953,-80.438,53.035,1],
19073=>[92.966,-80.426,53.022,1],
19074=>[92.978,-80.416,53.009,1],
19075=>[92.990,-80.404,52.994,1],
19076=>[93.003,-80.393,52.979,1],
19077=>[93.015,-80.382,52.967,1],
19078=>[93.029,-80.377,52.955,1],
19079=>[93.043,-80.373,52.945,1],
19080=>[93.057,-80.370,52.935,1],
19081=>[93.070,-80.366,52.925,1],
19082=>[93.084,-80.363,52.915,1],
19083=>[93.098,-80.359,52.906,1],
19084=>[93.112,-80.356,52.898,1],
19085=>[93.128,-80.349,52.890,1],
19086=>[93.144,-80.341,52.884,1],
19087=>[93.160,-80.334,52.879,1],
19088=>[93.177,-80.328,52.876,1],
19089=>[93.193,-80.320,52.873,1],
19090=>[93.209,-80.313,52.873,1],
19091=>[93.225,-80.306,52.874,1],
19092=>[93.241,-80.299,52.875,1],
19093=>[93.258,-80.292,52.877,1],
19094=>[93.274,-80.284,52.878,1],
19095=>[93.290,-80.278,52.878,1],
19096=>[93.306,-80.270,52.879,1],
19097=>[93.323,-80.263,52.879,1],
19098=>[93.339,-80.256,52.878,1],
19099=>[93.355,-80.249,52.877,1],
19100=>[93.369,-80.243,52.878,1],
19101=>[93.379,-80.240,52.878,1],
19102=>[93.389,-80.237,52.878,1],
19103=>[93.399,-80.222,52.879,1],
19104=>[93.409,-80.201,52.881,1],
19105=>[93.419,-80.179,52.883,1],
19106=>[93.427,-80.163,52.883,1],
19107=>[93.433,-80.165,52.883,1],
19108=>[93.450,-80.165,52.884,1],
19109=>[93.475,-80.165,52.885,1],
19110=>[93.498,-80.166,52.885,1],
19111=>[93.522,-80.166,52.884,1],
19112=>[93.534,-80.159,52.883,1],
19113=>[93.544,-80.149,52.883,1],
19114=>[93.554,-80.141,52.881,1],
19115=>[93.564,-80.132,52.879,1],
19116=>[93.574,-80.124,52.876,1],
19117=>[93.584,-80.115,52.872,1],
19118=>[93.594,-80.106,52.868,1],
19119=>[93.604,-80.098,52.864,1],
19120=>[93.614,-80.089,52.859,1],
19121=>[93.624,-80.080,52.853,1],
19122=>[93.634,-80.071,52.848,1],
19123=>[93.644,-80.063,52.841,1],
19158=>[93.962,-79.925,52.462,1],
19159=>[93.970,-79.924,52.448,1],
19160=>[93.979,-79.922,52.434,1],
19161=>[93.987,-79.921,52.419,1],
19162=>[93.996,-79.919,52.405,1],
19163=>[94.004,-79.918,52.391,1],
19164=>[94.013,-79.916,52.377,1],
19165=>[94.022,-79.914,52.361,1],
19166=>[94.030,-79.913,52.346,1],
19167=>[94.039,-79.912,52.330,1],
19168=>[94.047,-79.911,52.315,1],
19169=>[94.056,-79.909,52.299,1],
19170=>[94.064,-79.908,52.284,1],
19171=>[94.073,-79.906,52.268,1],
19196=>[94.251,-79.560,51.765,1],
19197=>[94.241,-79.567,51.738,1],
19198=>[94.229,-79.573,51.712,1],
19199=>[94.241,-79.554,51.685,1],
19200=>[94.254,-79.535,51.657,1],
19201=>[94.266,-79.515,51.629,1],
19202=>[94.279,-79.495,51.600,1],
19203=>[94.292,-79.476,51.572,1],
19204=>[94.305,-79.456,51.543,1],
19205=>[94.317,-79.436,51.514,1],
19206=>[94.332,-79.439,51.486,1],
19207=>[94.349,-79.471,51.456,1],
19208=>[94.366,-79.502,51.426,1],
19209=>[94.383,-79.533,51.395,1],
19210=>[94.400,-79.565,51.365,1],
19211=>[94.417,-79.596,51.334,1],
19212=>[94.434,-79.627,51.304,1],
19709=>[91.869,-80.977,53.589,2],
19710=>[91.882,-80.973,53.567,2],
19711=>[91.896,-80.968,53.546,2],
19712=>[91.910,-80.963,53.524,2],
19713=>[91.923,-80.958,53.503,2],
19714=>[91.937,-80.954,53.482,2],
19715=>[91.951,-80.949,53.461,2],
19716=>[91.964,-80.944,53.440,2],
19717=>[91.978,-80.939,53.419,2],
19718=>[91.992,-80.935,53.398,2],
19719=>[92.005,-80.930,53.377,2],
19720=>[92.019,-80.925,53.358,2],
19721=>[92.032,-80.920,53.337,2],
19722=>[92.047,-80.915,53.317,2],
19723=>[92.060,-80.911,53.298,2],
19724=>[92.074,-80.906,53.279,2],
19725=>[92.087,-80.896,53.261,2],
19726=>[92.101,-80.884,53.242,2],
19727=>[92.116,-80.872,53.224,2],
19755=>[92.581,-80.605,53.296,1],
19756=>[92.602,-80.597,53.278,1],
19757=>[92.623,-80.588,53.259,1],
19758=>[92.644,-80.580,53.240,1],
19759=>[92.665,-80.572,53.221,1],
19760=>[92.686,-80.563,53.203,1],
19761=>[92.707,-80.555,53.187,1],
19762=>[92.727,-80.547,53.171,1],
19763=>[92.749,-80.538,53.157,1],
19764=>[92.775,-80.531,53.145,1],
19765=>[92.801,-80.522,53.136,1],
19766=>[92.828,-80.515,53.127,1],
19767=>[92.850,-80.505,53.117,1],
19768=>[92.864,-80.490,53.107,1],
19769=>[92.879,-80.475,53.096,1],
19770=>[92.894,-80.460,53.084,1],
19771=>[92.908,-80.444,53.070,1],
19772=>[92.922,-80.429,53.056,1],
19773=>[92.936,-80.415,53.042,1],
19774=>[92.949,-80.403,53.028,1],
19775=>[92.961,-80.393,53.013,1],
19776=>[92.974,-80.381,52.998,1],
19777=>[92.987,-80.373,52.982,1],
19778=>[93.000,-80.369,52.968,1],
19779=>[93.014,-80.366,52.956,1],
19780=>[93.028,-80.362,52.945,1],
19781=>[93.042,-80.358,52.935,1],
19782=>[93.056,-80.355,52.924,1],
19783=>[93.070,-80.351,52.913,1],
19784=>[93.083,-80.347,52.904,1],
19785=>[93.099,-80.341,52.895,1],
19786=>[93.116,-80.334,52.888,1],
19787=>[93.132,-80.327,52.882,1],
19788=>[93.148,-80.319,52.877,1],
19789=>[93.164,-80.312,52.874,1],
19790=>[93.181,-80.306,52.872,1],
19791=>[93.197,-80.298,52.870,1],
19792=>[93.213,-80.291,52.869,1],
19793=>[93.229,-80.284,52.869,1],
19794=>[93.246,-80.277,52.869,1],
19795=>[93.262,-80.270,52.869,1],
19796=>[93.278,-80.262,52.868,1],
19797=>[93.294,-80.256,52.869,1],
19798=>[93.311,-80.248,52.868,1],
19799=>[93.327,-80.241,52.867,1],
19800=>[93.343,-80.234,52.866,1],
19801=>[93.357,-80.228,52.865,1],
19802=>[93.367,-80.225,52.864,1],
19803=>[93.377,-80.212,52.863,1],
19804=>[93.387,-80.190,52.864,1],
19805=>[93.397,-80.169,52.866,1],
19806=>[93.407,-80.148,52.869,1],
19807=>[93.416,-80.132,52.870,1],
19808=>[93.421,-80.134,52.871,1],
19809=>[93.432,-80.134,52.873,1],
19810=>[93.455,-80.135,52.874,1],
19811=>[93.479,-80.135,52.875,1],
19812=>[93.503,-80.136,52.876,1],
19813=>[93.527,-80.136,52.876,1],
19814=>[93.544,-80.131,52.876,1],
19815=>[93.554,-80.123,52.875,1],
19816=>[93.564,-80.114,52.875,1],
19817=>[93.574,-80.106,52.871,1],
19818=>[93.584,-80.096,52.868,1],
19819=>[93.594,-80.088,52.865,1],
19820=>[93.604,-80.079,52.861,1],
19821=>[93.614,-80.071,52.856,1],
19822=>[93.624,-80.062,52.851,1],
19823=>[93.634,-80.053,52.846,1],
19824=>[93.644,-80.045,52.839,1],
19825=>[93.654,-80.036,52.832,1],
19858=>[93.953,-79.912,52.484,1],
19859=>[93.961,-79.911,52.470,1],
19860=>[93.970,-79.909,52.457,1],
19861=>[93.978,-79.908,52.442,1],
19862=>[93.987,-79.906,52.428,1],
19863=>[93.995,-79.905,52.414,1],
19864=>[94.004,-79.903,52.400,1],
19865=>[94.012,-79.902,52.386,1],
19866=>[94.021,-79.900,52.370,1],
19867=>[94.030,-79.899,52.355,1],
19868=>[94.038,-79.898,52.340,1],
19869=>[94.047,-79.896,52.325,1],
19870=>[94.055,-79.895,52.309,1],
19871=>[94.064,-79.893,52.293,1],
19872=>[94.072,-79.892,52.277,1],
19873=>[94.081,-79.890,52.260,1],
19896=>[94.265,-79.535,51.804,1],
19897=>[94.255,-79.541,51.778,1],
19898=>[94.244,-79.546,51.752,1],
19899=>[94.232,-79.552,51.725,1],
19900=>[94.238,-79.541,51.699,1],
19901=>[94.251,-79.521,51.672,1],
19902=>[94.263,-79.501,51.643,1],
19903=>[94.276,-79.482,51.614,1],
19904=>[94.289,-79.462,51.586,1],
19905=>[94.301,-79.442,51.558,1],
19906=>[94.315,-79.422,51.528,1],
19907=>[94.328,-79.408,51.500,1],
19908=>[94.345,-79.439,51.470,1],
19909=>[94.361,-79.470,51.439,1],
19910=>[94.379,-79.502,51.408,1],
19911=>[94.396,-79.533,51.377,1],
19912=>[94.413,-79.564,51.347,1],
19913=>[94.429,-79.595,51.316,1],
19914=>[94.447,-79.627,51.285,1],
20412=>[91.895,-80.954,53.569,2],
20413=>[91.909,-80.949,53.548,2],
20414=>[91.923,-80.945,53.527,2],
20415=>[91.936,-80.939,53.506,2],
20416=>[91.950,-80.935,53.485,2],
20417=>[91.963,-80.930,53.464,2],
20418=>[91.977,-80.926,53.443,2],
20419=>[91.991,-80.920,53.422,2],
20420=>[92.005,-80.916,53.402,2],
20421=>[92.018,-80.911,53.382,2],
20422=>[92.032,-80.906,53.361,2],
20423=>[92.046,-80.902,53.341,2],
20424=>[92.059,-80.897,53.322,2],
20425=>[92.073,-80.892,53.302,2],
20426=>[92.087,-80.886,53.284,2],
20427=>[92.101,-80.873,53.265,2],
20456=>[92.565,-80.588,53.309,1],
20457=>[92.586,-80.580,53.290,1],
20458=>[92.606,-80.572,53.272,1],
20459=>[92.628,-80.563,53.253,1],
20460=>[92.648,-80.555,53.234,1],
20461=>[92.669,-80.547,53.216,1],
20462=>[92.690,-80.538,53.199,1],
20463=>[92.711,-80.530,53.183,1],
20464=>[92.732,-80.522,53.167,1],
20465=>[92.753,-80.513,53.156,1],
20466=>[92.773,-80.505,53.146,1],
20467=>[92.794,-80.497,53.138,1],
20468=>[92.816,-80.489,53.129,1],
20469=>[92.841,-80.480,53.119,1],
20470=>[92.855,-80.465,53.108,1],
20471=>[92.870,-80.450,53.094,1],
20472=>[92.884,-80.435,53.079,1],
20473=>[92.899,-80.419,53.064,1],
20474=>[92.913,-80.404,53.049,1],
20475=>[92.930,-80.388,53.033,1],
20476=>[92.946,-80.371,53.018,1],
20477=>[92.962,-80.365,53.002,1],
20478=>[92.977,-80.364,52.985,1],
20479=>[92.992,-80.362,52.971,1],
20480=>[93.007,-80.359,52.958,1],
20481=>[93.022,-80.356,52.947,1],
20482=>[93.038,-80.353,52.936,1],
20483=>[93.053,-80.350,52.926,1],
20484=>[93.066,-80.344,52.915,1],
20485=>[93.078,-80.337,52.907,1],
20486=>[93.091,-80.328,52.898,1],
20487=>[93.105,-80.319,52.890,1],
20488=>[93.120,-80.312,52.884,1],
20489=>[93.136,-80.305,52.879,1],
20490=>[93.152,-80.298,52.875,1],
20491=>[93.169,-80.290,52.873,1],
20492=>[93.185,-80.284,52.869,1],
20493=>[93.201,-80.276,52.866,1],
20494=>[93.217,-80.269,52.864,1],
20495=>[93.234,-80.262,52.862,1],
20496=>[93.250,-80.255,52.862,1],
20497=>[93.266,-80.247,52.861,1],
20498=>[93.282,-80.240,52.860,1],
20499=>[93.298,-80.233,52.859,1],
20500=>[93.315,-80.226,52.857,1],
20501=>[93.331,-80.218,52.856,1],
20502=>[93.346,-80.212,52.854,1],
20503=>[93.356,-80.202,52.853,1],
20504=>[93.365,-80.181,52.852,1],
20505=>[93.375,-80.159,52.853,1],
20506=>[93.386,-80.137,52.855,1],
20507=>[93.395,-80.116,52.857,1],
20508=>[93.404,-80.101,52.859,1],
20509=>[93.410,-80.102,52.860,1],
20510=>[93.415,-80.104,52.861,1],
20511=>[93.436,-80.104,52.863,1],
20512=>[93.461,-80.105,52.865,1],
20513=>[93.484,-80.105,52.867,1],
20514=>[93.508,-80.106,52.869,1],
20515=>[93.532,-80.106,52.869,1],
20516=>[93.554,-80.104,52.870,1],
20517=>[93.564,-80.096,52.870,1],
20518=>[93.573,-80.087,52.868,1],
20519=>[93.583,-80.078,52.866,1],
20520=>[93.593,-80.070,52.862,1],
20521=>[93.604,-80.061,52.858,1],
20522=>[93.614,-80.052,52.853,1],
20523=>[93.624,-80.043,52.848,1],
20524=>[93.634,-80.035,52.843,1],
20525=>[93.644,-80.026,52.837,1],
20526=>[93.654,-80.018,52.830,1],
20527=>[93.664,-80.009,52.823,1],
20557=>[93.934,-79.901,52.517,1],
20558=>[93.943,-79.899,52.505,1],
20559=>[93.952,-79.898,52.492,1],
20560=>[93.960,-79.896,52.479,1],
20561=>[93.969,-79.895,52.465,1],
20562=>[93.977,-79.893,52.451,1],
20563=>[93.986,-79.892,52.438,1],
20564=>[93.994,-79.890,52.425,1],
20565=>[94.003,-79.889,52.410,1],
20566=>[94.011,-79.887,52.395,1],
20567=>[94.020,-79.886,52.381,1],
20568=>[94.029,-79.885,52.365,1],
20569=>[94.037,-79.883,52.349,1],
20570=>[94.046,-79.882,52.334,1],
20571=>[94.054,-79.880,52.318,1],
20572=>[94.063,-79.879,52.302,1],
20573=>[94.071,-79.877,52.286,1],
20574=>[94.080,-79.876,52.270,1],
20575=>[94.088,-79.874,52.253,1],
20596=>[94.268,-79.528,51.841,1],
20597=>[94.269,-79.515,51.816,1],
20598=>[94.258,-79.520,51.790,1],
20599=>[94.247,-79.526,51.765,1],
20600=>[94.236,-79.532,51.739,1],
20601=>[94.235,-79.527,51.713,1],
20602=>[94.248,-79.507,51.686,1],
20603=>[94.260,-79.488,51.657,1],
20604=>[94.273,-79.468,51.629,1],
20605=>[94.286,-79.448,51.601,1],
20606=>[94.298,-79.429,51.572,1],
20607=>[94.312,-79.409,51.543,1],
20608=>[94.324,-79.389,51.515,1],
20609=>[94.340,-79.407,51.485,1],
20610=>[94.357,-79.439,51.453,1],
20611=>[94.374,-79.470,51.423,1],
20612=>[94.391,-79.501,51.392,1],
20613=>[94.408,-79.532,51.360,1],
20614=>[94.425,-79.564,51.329,1],
20615=>[94.442,-79.595,51.297,1],
20616=>[94.459,-79.626,51.266,1],
20617=>[94.476,-79.658,51.234,1],
21115=>[91.922,-80.930,53.551,2],
21116=>[91.936,-80.926,53.530,2],
21117=>[91.949,-80.921,53.509,2],
21118=>[91.963,-80.917,53.488,2],
21119=>[91.977,-80.911,53.468,2],
21120=>[91.990,-80.907,53.447,2],
21121=>[92.004,-80.902,53.427,2],
21122=>[92.017,-80.897,53.406,2],
21123=>[92.031,-80.892,53.385,2],
21124=>[92.045,-80.888,53.366,2],
21125=>[92.059,-80.883,53.346,2],
21126=>[92.072,-80.878,53.326,2],
21157=>[92.548,-80.573,53.324,1],
21158=>[92.569,-80.564,53.305,1],
21159=>[92.590,-80.556,53.286,1],
21160=>[92.611,-80.547,53.267,1],
21161=>[92.632,-80.539,53.249,1],
21162=>[92.652,-80.531,53.231,1],
21163=>[92.673,-80.522,53.214,1],
21164=>[92.694,-80.514,53.197,1],
21165=>[92.715,-80.506,53.181,1],
21166=>[92.736,-80.497,53.169,1],
21167=>[92.757,-80.489,53.159,1],
21168=>[92.778,-80.481,53.150,1],
21169=>[92.798,-80.472,53.142,1],
21170=>[92.819,-80.464,53.132,1],
21171=>[92.840,-80.456,53.120,1],
21172=>[92.863,-80.432,53.106,1],
21173=>[92.883,-80.408,53.090,1],
21174=>[92.901,-80.391,53.073,1],
21175=>[92.917,-80.374,53.056,1],
21176=>[92.934,-80.357,53.039,1],
21177=>[92.951,-80.341,53.022,1],
21178=>[92.966,-80.336,53.005,1],
21179=>[92.981,-80.339,52.989,1],
21180=>[92.995,-80.342,52.975,1],
21181=>[93.009,-80.346,52.962,1],
21182=>[93.023,-80.349,52.950,1],
21183=>[93.036,-80.347,52.939,1],
21184=>[93.048,-80.341,52.929,1],
21185=>[93.060,-80.334,52.919,1],
21186=>[93.072,-80.326,52.910,1],
21187=>[93.085,-80.318,52.901,1],
21188=>[93.099,-80.309,52.893,1],
21189=>[93.113,-80.300,52.886,1],
21190=>[93.126,-80.291,52.881,1],
21191=>[93.140,-80.283,52.876,1],
21192=>[93.157,-80.275,52.872,1],
21193=>[93.173,-80.269,52.868,1],
21194=>[93.189,-80.261,52.863,1],
21195=>[93.205,-80.254,52.860,1],
21196=>[93.221,-80.247,52.859,1],
21197=>[93.238,-80.240,52.857,1],
21198=>[93.255,-80.233,52.856,1],
21199=>[93.271,-80.225,52.854,1],
21200=>[93.288,-80.218,52.852,1],
21201=>[93.304,-80.211,52.849,1],
21202=>[93.321,-80.204,52.848,1],
21203=>[93.334,-80.192,52.847,1],
21204=>[93.344,-80.170,52.846,1],
21205=>[93.354,-80.149,52.845,1],
21206=>[93.364,-80.127,52.845,1],
21207=>[93.373,-80.106,52.845,1],
21208=>[93.383,-80.084,52.846,1],
21209=>[93.392,-80.069,52.848,1],
21210=>[93.398,-80.071,52.850,1],
21211=>[93.404,-80.073,52.851,1],
21212=>[93.418,-80.074,52.854,1],
21213=>[93.441,-80.074,52.857,1],
21214=>[93.466,-80.074,52.860,1],
21215=>[93.489,-80.074,52.863,1],
21216=>[93.513,-80.075,52.864,1],
21217=>[93.537,-80.075,52.865,1],
21218=>[93.561,-80.076,52.866,1],
21219=>[93.573,-80.068,52.865,1],
21220=>[93.583,-80.060,52.863,1],
21221=>[93.593,-80.051,52.860,1],
21222=>[93.604,-80.043,52.856,1],
21223=>[93.614,-80.034,52.851,1],
21224=>[93.624,-80.025,52.846,1],
21225=>[93.634,-80.017,52.841,1],
21226=>[93.644,-80.008,52.835,1],
21227=>[93.654,-79.999,52.828,1],
21228=>[93.664,-79.990,52.822,1],
21229=>[93.674,-79.982,52.814,1],
21230=>[93.684,-79.973,52.805,1],
21231=>[93.694,-79.965,52.796,1],
21232=>[93.704,-79.956,52.788,1],
21233=>[93.714,-79.947,52.779,1],
21234=>[93.724,-79.939,52.769,1],
21235=>[93.734,-79.930,52.760,1],
21236=>[93.745,-79.921,52.750,1],
21258=>[93.933,-79.886,52.524,1],
21259=>[93.942,-79.885,52.512,1],
21260=>[93.951,-79.883,52.500,1],
21261=>[93.959,-79.882,52.487,1],
21262=>[93.968,-79.880,52.474,1],
21263=>[93.976,-79.879,52.460,1],
21264=>[93.985,-79.877,52.447,1],
21265=>[93.993,-79.876,52.434,1],
21266=>[94.002,-79.874,52.420,1],
21267=>[94.010,-79.874,52.405,1],
21268=>[94.019,-79.872,52.390,1],
21269=>[94.028,-79.871,52.375,1],
21270=>[94.036,-79.869,52.359,1],
21271=>[94.045,-79.867,52.344,1],
21272=>[94.053,-79.866,52.328,1],
21273=>[94.062,-79.864,52.312,1],
21274=>[94.070,-79.863,52.295,1],
21275=>[94.079,-79.861,52.279,1],
21276=>[94.087,-79.860,52.262,1],
21296=>[94.259,-79.541,51.878,1],
21297=>[94.267,-79.514,51.853,1],
21298=>[94.272,-79.494,51.828,1],
21299=>[94.261,-79.501,51.803,1],
21300=>[94.250,-79.507,51.778,1],
21301=>[94.239,-79.512,51.753,1],
21302=>[94.232,-79.514,51.727,1],
21303=>[94.245,-79.494,51.699,1],
21304=>[94.258,-79.475,51.671,1],
21305=>[94.270,-79.455,51.643,1],
21306=>[94.283,-79.435,51.615,1],
21307=>[94.296,-79.416,51.587,1],
21308=>[94.309,-79.396,51.558,1],
21309=>[94.321,-79.376,51.529,1],
21310=>[94.336,-79.376,51.499,1],
21311=>[94.353,-79.407,51.468,1],
21312=>[94.369,-79.438,51.437,1],
21313=>[94.387,-79.469,51.405,1],
21314=>[94.404,-79.501,51.373,1],
21315=>[94.421,-79.532,51.342,1],
21316=>[94.437,-79.563,51.310,1],
21317=>[94.455,-79.595,51.277,1],
21318=>[94.472,-79.626,51.245,1],
21319=>[94.485,-79.664,51.212,1],
21320=>[94.493,-79.707,51.179,1],
21819=>[91.962,-80.902,53.513,2],
21820=>[91.976,-80.898,53.492,2],
21821=>[91.990,-80.893,53.472,2],
21822=>[92.003,-80.888,53.451,2],
21823=>[92.017,-80.883,53.430,2],
21858=>[92.533,-80.556,53.339,1],
21859=>[92.553,-80.548,53.321,1],
21860=>[92.573,-80.540,53.301,1],
21861=>[92.594,-80.532,53.283,1],
21862=>[92.615,-80.523,53.265,1],
21863=>[92.636,-80.515,53.247,1],
21864=>[92.657,-80.507,53.229,1],
21865=>[92.677,-80.498,53.212,1],
21866=>[92.698,-80.490,53.196,1],
21867=>[92.719,-80.482,53.184,1],
21868=>[92.740,-80.473,53.174,1],
21869=>[92.761,-80.465,53.165,1],
21870=>[92.782,-80.457,53.156,1],
21871=>[92.802,-80.448,53.146,1],
21872=>[92.824,-80.440,53.133,1],
21873=>[92.844,-80.431,53.117,1],
21874=>[92.866,-80.415,53.101,1],
21875=>[92.889,-80.388,53.084,1],
21876=>[92.912,-80.360,53.066,1],
21877=>[92.935,-80.333,53.048,1],
21878=>[92.955,-80.309,53.030,1],
21879=>[92.971,-80.306,53.013,1],
21880=>[92.983,-80.311,52.996,1],
21881=>[92.994,-80.316,52.981,1],
21882=>[93.006,-80.321,52.968,1],
21883=>[93.018,-80.326,52.955,1],
21884=>[93.030,-80.331,52.944,1],
21885=>[93.042,-80.330,52.933,1],
21886=>[93.054,-80.323,52.924,1],
21887=>[93.067,-80.316,52.914,1],
21888=>[93.080,-80.306,52.904,1],
21889=>[93.093,-80.298,52.895,1],
21890=>[93.107,-80.289,52.888,1],
21891=>[93.119,-80.279,52.882,1],
21892=>[93.136,-80.270,52.877,1],
21893=>[93.161,-80.262,52.872,1],
21894=>[93.178,-80.254,52.867,1],
21895=>[93.194,-80.247,52.862,1],
21896=>[93.211,-80.240,52.858,1],
21897=>[93.227,-80.233,52.856,1],
21898=>[93.244,-80.225,52.855,1],
21899=>[93.261,-80.218,52.853,1],
21900=>[93.277,-80.211,52.851,1],
21901=>[93.294,-80.204,52.848,1],
21902=>[93.310,-80.196,52.846,1],
21903=>[93.320,-80.186,52.844,1],
21904=>[93.325,-80.165,52.843,1],
21905=>[93.333,-80.140,52.842,1],
21906=>[93.342,-80.117,52.840,1],
21907=>[93.352,-80.096,52.839,1],
21908=>[93.362,-80.074,52.840,1],
21909=>[93.372,-80.052,52.840,1],
21910=>[93.380,-80.038,52.841,1],
21911=>[93.386,-80.040,52.843,1],
21912=>[93.392,-80.042,52.845,1],
21913=>[93.399,-80.043,52.847,1],
21914=>[93.423,-80.043,52.851,1],
21915=>[93.446,-80.043,52.855,1],
21916=>[93.471,-80.044,52.859,1],
21917=>[93.494,-80.044,52.860,1],
21918=>[93.518,-80.045,52.861,1],
21919=>[93.542,-80.045,52.863,1],
21920=>[93.566,-80.046,52.862,1],
21921=>[93.583,-80.042,52.861,1],
21922=>[93.593,-80.033,52.859,1],
21923=>[93.604,-80.024,52.854,1],
21924=>[93.614,-80.015,52.850,1],
21925=>[93.624,-80.007,52.845,1],
21926=>[93.634,-79.998,52.840,1],
21927=>[93.644,-79.990,52.834,1],
21928=>[93.654,-79.981,52.827,1],
21929=>[93.664,-79.972,52.820,1],
21930=>[93.674,-79.964,52.813,1],
21931=>[93.684,-79.955,52.804,1],
21932=>[93.694,-79.946,52.795,1],
21933=>[93.704,-79.937,52.787,1],
21934=>[93.714,-79.929,52.778,1],
21935=>[93.724,-79.920,52.769,1],
21936=>[93.734,-79.911,52.760,1],
21937=>[93.745,-79.904,52.751,1],
21938=>[93.753,-79.902,52.741,1],
21959=>[93.933,-79.872,52.532,1],
21960=>[93.941,-79.871,52.520,1],
21961=>[93.950,-79.869,52.508,1],
21962=>[93.959,-79.867,52.495,1],
21963=>[93.967,-79.866,52.483,1],
21964=>[93.976,-79.864,52.469,1],
21965=>[93.984,-79.863,52.455,1],
21966=>[93.993,-79.861,52.442,1],
21967=>[94.001,-79.861,52.429,1],
21968=>[94.010,-79.859,52.415,1],
21969=>[94.018,-79.858,52.400,1],
21970=>[94.027,-79.856,52.384,1],
21971=>[94.035,-79.855,52.369,1],
21972=>[94.044,-79.853,52.353,1],
21973=>[94.052,-79.852,52.337,1],
21974=>[94.061,-79.850,52.321,1],
21975=>[94.069,-79.849,52.304,1],
21976=>[94.078,-79.847,52.288,1],
21977=>[94.086,-79.845,52.270,1],
21978=>[94.095,-79.844,52.253,1],
21995=>[94.241,-79.579,51.934,1],
21996=>[94.249,-79.553,51.912,1],
21997=>[94.258,-79.527,51.888,1],
21998=>[94.266,-79.501,51.864,1],
21999=>[94.275,-79.476,51.840,1],
22000=>[94.264,-79.480,51.815,1],
22001=>[94.253,-79.486,51.790,1],
22002=>[94.243,-79.492,51.765,1],
22003=>[94.231,-79.498,51.739,1],
22004=>[94.242,-79.481,51.712,1],
22005=>[94.255,-79.461,51.685,1],
22006=>[94.267,-79.441,51.656,1],
22007=>[94.280,-79.422,51.628,1],
22008=>[94.293,-79.402,51.600,1],
22009=>[94.306,-79.382,51.572,1],
22010=>[94.318,-79.363,51.543,1],
22011=>[94.331,-79.344,51.513,1],
22012=>[94.348,-79.375,51.482,1],
22013=>[94.365,-79.407,51.451,1],
22014=>[94.382,-79.438,51.419,1],
22015=>[94.399,-79.469,51.386,1],
22016=>[94.416,-79.501,51.354,1],
22017=>[94.433,-79.532,51.322,1],
22018=>[94.450,-79.563,51.290,1],
22019=>[94.465,-79.598,51.255,1],
22020=>[94.474,-79.641,51.222,1],
22021=>[94.483,-79.684,51.189,1],
22022=>[94.491,-79.727,51.156,1],
22559=>[92.529,-80.539,53.357,1],
22560=>[92.546,-80.531,53.338,1],
22561=>[92.562,-80.523,53.319,1],
22562=>[92.578,-80.515,53.301,1],
22563=>[92.598,-80.507,53.282,1],
22564=>[92.619,-80.498,53.263,1],
22565=>[92.640,-80.490,53.244,1],
22566=>[92.661,-80.482,53.227,1],
22567=>[92.682,-80.473,53.212,1],
22568=>[92.703,-80.465,53.200,1],
22569=>[92.723,-80.457,53.190,1],
22570=>[92.744,-80.448,53.180,1],
22571=>[92.765,-80.440,53.170,1],
22572=>[92.786,-80.431,53.159,1],
22573=>[92.807,-80.423,53.146,1],
22574=>[92.828,-80.415,53.130,1],
22575=>[92.848,-80.406,53.113,1],
22576=>[92.869,-80.398,53.096,1],
22577=>[92.892,-80.371,53.078,1],
22578=>[92.915,-80.344,53.060,1],
22579=>[92.938,-80.316,53.042,1],
22580=>[92.961,-80.289,53.025,1],
22581=>[92.976,-80.288,53.007,1],
22582=>[92.989,-80.294,52.991,1],
22583=>[93.001,-80.299,52.976,1],
22584=>[93.013,-80.303,52.963,1],
22585=>[93.024,-80.309,52.951,1],
22586=>[93.037,-80.314,52.940,1],
22587=>[93.049,-80.312,52.929,1],
22588=>[93.061,-80.305,52.918,1],
22589=>[93.074,-80.296,52.907,1],
22590=>[93.087,-80.287,52.896,1],
22591=>[93.098,-80.277,52.889,1],
22592=>[93.109,-80.266,52.882,1],
22593=>[93.131,-80.257,52.876,1],
22594=>[93.156,-80.249,52.871,1],
22595=>[93.181,-80.240,52.866,1],
22596=>[93.200,-80.233,52.862,1],
22597=>[93.216,-80.225,52.858,1],
22598=>[93.233,-80.218,52.856,1],
22599=>[93.250,-80.212,52.854,1],
22600=>[93.266,-80.204,52.851,1],
22601=>[93.283,-80.197,52.849,1],
22602=>[93.299,-80.190,52.847,1],
22603=>[93.309,-80.178,52.844,1],
22604=>[93.307,-80.162,52.842,1],
22605=>[93.315,-80.137,52.841,1],
22606=>[93.324,-80.113,52.839,1],
22607=>[93.332,-80.089,52.837,1],
22608=>[93.341,-80.065,52.836,1],
22609=>[93.350,-80.043,52.836,1],
22610=>[93.360,-80.021,52.836,1],
22611=>[93.368,-80.007,52.836,1],
22612=>[93.374,-80.008,52.838,1],
22613=>[93.380,-80.011,52.840,1],
22614=>[93.386,-80.012,52.844,1],
22615=>[93.404,-80.013,52.847,1],
22616=>[93.428,-80.013,52.852,1],
22617=>[93.451,-80.013,52.856,1],
22618=>[93.476,-80.014,52.859,1],
22619=>[93.499,-80.014,52.860,1],
22620=>[93.523,-80.015,52.861,1],
22621=>[93.547,-80.015,52.861,1],
22622=>[93.571,-80.015,52.860,1],
22623=>[93.593,-80.015,52.857,1],
22624=>[93.604,-80.005,52.853,1],
22625=>[93.614,-79.997,52.848,1],
22626=>[93.624,-79.989,52.844,1],
22627=>[93.634,-79.980,52.839,1],
22628=>[93.644,-79.971,52.833,1],
22629=>[93.654,-79.962,52.826,1],
22630=>[93.664,-79.954,52.819,1],
22631=>[93.674,-79.945,52.812,1],
22632=>[93.684,-79.936,52.804,1],
22633=>[93.694,-79.928,52.795,1],
22634=>[93.704,-79.919,52.786,1],
22635=>[93.714,-79.911,52.778,1],
22636=>[93.724,-79.902,52.770,1],
22637=>[93.734,-79.893,52.760,1],
22638=>[93.744,-79.889,52.751,1],
22639=>[93.752,-79.889,52.742,1],
22640=>[93.761,-79.887,52.733,1],
22661=>[93.940,-79.856,52.527,1],
22662=>[93.949,-79.855,52.514,1],
22663=>[93.958,-79.853,52.502,1],
22664=>[93.966,-79.852,52.490,1],
22665=>[93.975,-79.850,52.477,1],
22666=>[93.983,-79.849,52.464,1],
22667=>[93.992,-79.848,52.451,1],
22668=>[94.000,-79.846,52.437,1],
22669=>[94.009,-79.845,52.423,1],
22670=>[94.017,-79.843,52.409,1],
22671=>[94.026,-79.842,52.393,1],
22672=>[94.035,-79.840,52.377,1],
22673=>[94.043,-79.839,52.362,1],
22674=>[94.052,-79.837,52.345,1],
22675=>[94.060,-79.836,52.329,1],
22676=>[94.069,-79.834,52.313,1],
22677=>[94.077,-79.833,52.296,1],
22678=>[94.086,-79.831,52.278,1],
22679=>[94.095,-79.830,52.260,1],
22695=>[94.231,-79.592,51.964,1],
22696=>[94.240,-79.565,51.943,1],
22697=>[94.248,-79.539,51.921,1],
22698=>[94.257,-79.513,51.898,1],
22699=>[94.265,-79.488,51.874,1],
22700=>[94.274,-79.462,51.851,1],
22701=>[94.267,-79.460,51.826,1],
22702=>[94.257,-79.466,51.801,1],
22703=>[94.246,-79.472,51.776,1],
22704=>[94.235,-79.478,51.751,1],
22705=>[94.239,-79.467,51.725,1],
22706=>[94.252,-79.447,51.697,1],
22707=>[94.264,-79.428,51.669,1],
22708=>[94.277,-79.408,51.641,1],
22709=>[94.290,-79.388,51.613,1],
22710=>[94.302,-79.369,51.585,1],
22711=>[94.316,-79.349,51.556,1],
22712=>[94.328,-79.329,51.527,1],
22713=>[94.344,-79.344,51.495,1],
22714=>[94.361,-79.375,51.463,1],
22715=>[94.378,-79.407,51.430,1],
22716=>[94.395,-79.438,51.398,1],
22717=>[94.412,-79.469,51.365,1],
22718=>[94.429,-79.501,51.333,1],
22719=>[94.445,-79.532,51.301,1],
22720=>[94.454,-79.576,51.266,1],
22721=>[94.463,-79.619,51.232,1],
22722=>[94.472,-79.662,51.198,1],
22723=>[94.481,-79.705,51.166,1],
22724=>[94.489,-79.748,51.132,1],
22725=>[94.498,-79.792,51.099,1],
23260=>[92.525,-80.522,53.375,1],
23261=>[92.542,-80.514,53.357,1],
23262=>[92.558,-80.506,53.338,1],
23263=>[92.573,-80.498,53.319,1],
23264=>[92.589,-80.490,53.300,1],
23265=>[92.605,-80.482,53.281,1],
23266=>[92.623,-80.474,53.263,1],
23267=>[92.644,-80.466,53.245,1],
23268=>[92.665,-80.457,53.229,1],
23269=>[92.686,-80.449,53.217,1],
23270=>[92.707,-80.441,53.206,1],
23271=>[92.727,-80.432,53.195,1],
23272=>[92.748,-80.424,53.184,1],
23273=>[92.769,-80.416,53.172,1],
23274=>[92.790,-80.407,53.159,1],
23275=>[92.811,-80.399,53.144,1],
23276=>[92.832,-80.391,53.127,1],
23277=>[92.853,-80.382,53.110,1],
23278=>[92.873,-80.374,53.092,1],
23279=>[92.896,-80.353,53.074,1],
23280=>[92.919,-80.326,53.056,1],
23281=>[92.941,-80.299,53.038,1],
23282=>[92.965,-80.272,53.021,1],
23283=>[92.979,-80.270,53.004,1],
23284=>[92.992,-80.275,52.987,1],
23285=>[93.005,-80.281,52.972,1],
23286=>[93.017,-80.286,52.958,1],
23287=>[93.030,-80.291,52.946,1],
23288=>[93.043,-80.296,52.934,1],
23289=>[93.055,-80.294,52.922,1],
23290=>[93.066,-80.284,52.910,1],
23291=>[93.077,-80.274,52.900,1],
23292=>[93.088,-80.263,52.892,1],
23293=>[93.101,-80.253,52.884,1],
23294=>[93.126,-80.245,52.876,1],
23295=>[93.151,-80.237,52.871,1],
23296=>[93.176,-80.228,52.866,1],
23297=>[93.201,-80.219,52.862,1],
23298=>[93.222,-80.212,52.859,1],
23299=>[93.239,-80.204,52.857,1],
23300=>[93.256,-80.197,52.855,1],
23301=>[93.272,-80.190,52.851,1],
23302=>[93.289,-80.183,52.848,1],
23303=>[93.297,-80.171,52.845,1],
23304=>[93.296,-80.154,52.843,1],
23305=>[93.297,-80.134,52.842,1],
23306=>[93.305,-80.110,52.840,1],
23307=>[93.314,-80.086,52.839,1],
23308=>[93.323,-80.062,52.836,1],
23309=>[93.331,-80.037,52.834,1],
23310=>[93.340,-80.013,52.833,1],
23311=>[93.348,-79.990,52.832,1],
23312=>[93.357,-79.976,52.833,1],
23313=>[93.362,-79.977,52.834,1],
23314=>[93.370,-79.982,52.836,1],
23315=>[93.381,-79.992,52.840,1],
23316=>[93.395,-79.988,52.844,1],
23317=>[93.409,-79.983,52.849,1],
23318=>[93.433,-79.983,52.854,1],
23319=>[93.457,-79.983,52.857,1],
23320=>[93.481,-79.983,52.859,1],
23321=>[93.504,-79.983,52.860,1],
23322=>[93.529,-79.984,52.860,1],
23323=>[93.552,-79.984,52.858,1],
23324=>[93.576,-79.985,52.856,1],
23325=>[93.600,-79.985,52.851,1],
23326=>[93.614,-79.979,52.847,1],
23327=>[93.624,-79.970,52.842,1],
23328=>[93.634,-79.961,52.838,1],
23329=>[93.644,-79.953,52.831,1],
23330=>[93.654,-79.944,52.824,1],
23331=>[93.664,-79.936,52.818,1],
23332=>[93.674,-79.927,52.810,1],
23333=>[93.684,-79.918,52.802,1],
23334=>[93.694,-79.909,52.794,1],
23335=>[93.704,-79.901,52.785,1],
23336=>[93.714,-79.892,52.777,1],
23337=>[93.724,-79.883,52.770,1],
23338=>[93.734,-79.877,52.760,1],
23339=>[93.743,-79.876,52.751,1],
23340=>[93.751,-79.874,52.742,1],
23341=>[93.760,-79.873,52.733,1],
23362=>[93.939,-79.842,52.533,1],
23363=>[93.948,-79.840,52.521,1],
23364=>[93.957,-79.839,52.509,1],
23365=>[93.965,-79.837,52.496,1],
23366=>[93.974,-79.836,52.483,1],
23367=>[93.982,-79.835,52.470,1],
23368=>[93.991,-79.833,52.457,1],
23369=>[93.999,-79.832,52.443,1],
23370=>[94.008,-79.830,52.429,1],
23371=>[94.016,-79.829,52.414,1],
23372=>[94.025,-79.827,52.399,1],
23373=>[94.034,-79.826,52.383,1],
23374=>[94.042,-79.824,52.367,1],
23375=>[94.051,-79.823,52.351,1],
23376=>[94.059,-79.821,52.335,1],
23377=>[94.068,-79.820,52.319,1],
23378=>[94.076,-79.818,52.302,1],
23379=>[94.085,-79.817,52.285,1],
23380=>[94.094,-79.816,52.267,1],
23381=>[94.102,-79.814,52.250,1],
23395=>[94.222,-79.604,51.993,1],
23396=>[94.230,-79.578,51.971,1],
23397=>[94.239,-79.552,51.951,1],
23398=>[94.247,-79.526,51.930,1],
23399=>[94.256,-79.501,51.907,1],
23400=>[94.264,-79.474,51.883,1],
23401=>[94.273,-79.448,51.860,1],
23402=>[94.271,-79.440,51.835,1],
23403=>[94.260,-79.446,51.810,1],
23404=>[94.249,-79.452,51.786,1],
23405=>[94.238,-79.457,51.762,1],
23406=>[94.236,-79.454,51.736,1],
23407=>[94.249,-79.435,51.709,1],
23408=>[94.261,-79.415,51.681,1],
23409=>[94.274,-79.394,51.653,1],
23410=>[94.287,-79.375,51.625,1],
23411=>[94.299,-79.355,51.597,1],
23412=>[94.313,-79.335,51.569,1],
23413=>[94.325,-79.316,51.539,1],
23414=>[94.339,-79.313,51.508,1],
23415=>[94.356,-79.344,51.475,1],
23416=>[94.373,-79.375,51.442,1],
23417=>[94.390,-79.406,51.409,1],
23418=>[94.407,-79.438,51.376,1],
23419=>[94.424,-79.469,51.343,1],
23420=>[94.434,-79.510,51.311,1],
23421=>[94.443,-79.553,51.276,1],
23422=>[94.452,-79.596,51.241,1],
23423=>[94.461,-79.639,51.207,1],
23424=>[94.470,-79.683,51.174,1],
23425=>[94.479,-79.726,51.140,1],
23426=>[94.487,-79.770,51.107,1],
23961=>[92.521,-80.505,53.395,1],
23962=>[92.537,-80.497,53.377,1],
23963=>[92.553,-80.489,53.358,1],
23964=>[92.569,-80.481,53.339,1],
23965=>[92.585,-80.473,53.320,1],
23966=>[92.601,-80.465,53.301,1],
23967=>[92.618,-80.457,53.282,1],
23968=>[92.634,-80.449,53.264,1],
23969=>[92.649,-80.441,53.247,1],
23970=>[92.669,-80.433,53.233,1],
23971=>[92.690,-80.425,53.221,1],
23972=>[92.711,-80.416,53.210,1],
23973=>[92.732,-80.408,53.199,1],
23974=>[92.753,-80.400,53.186,1],
23975=>[92.773,-80.391,53.173,1],
23976=>[92.794,-80.383,53.157,1],
23977=>[92.815,-80.375,53.141,1],
23978=>[92.836,-80.366,53.124,1],
23979=>[92.857,-80.358,53.108,1],
23980=>[92.877,-80.350,53.090,1],
23981=>[92.899,-80.337,53.072,1],
23982=>[92.922,-80.309,53.053,1],
23983=>[92.945,-80.282,53.036,1],
23984=>[92.968,-80.255,53.019,1],
23985=>[92.983,-80.252,53.001,1],
23986=>[92.996,-80.257,52.983,1],
23987=>[93.008,-80.262,52.966,1],
23988=>[93.021,-80.268,52.952,1],
23989=>[93.034,-80.273,52.939,1],
23990=>[93.047,-80.278,52.926,1],
23991=>[93.057,-80.271,52.914,1],
23992=>[93.067,-80.261,52.904,1],
23993=>[93.078,-80.250,52.895,1],
23994=>[93.096,-80.241,52.887,1],
23995=>[93.121,-80.232,52.879,1],
23996=>[93.146,-80.224,52.873,1],
23997=>[93.171,-80.215,52.868,1],
23998=>[93.196,-80.207,52.864,1],
23999=>[93.221,-80.199,52.861,1],
24000=>[93.245,-80.190,52.858,1],
24001=>[93.262,-80.183,52.855,1],
24002=>[93.278,-80.176,52.852,1],
24003=>[93.286,-80.164,52.848,1],
24004=>[93.284,-80.146,52.845,1],
24005=>[93.283,-80.129,52.842,1],
24006=>[93.288,-80.108,52.840,1],
24007=>[93.296,-80.083,52.838,1],
24008=>[93.304,-80.059,52.836,1],
24009=>[93.313,-80.034,52.833,1],
24010=>[93.322,-80.010,52.831,1],
24011=>[93.330,-79.986,52.830,1],
24012=>[93.339,-79.964,52.827,1],
24013=>[93.354,-79.958,52.828,1],
24014=>[93.365,-79.968,52.830,1],
24015=>[93.375,-79.977,52.831,1],
24016=>[93.387,-79.987,52.836,1],
24017=>[93.404,-79.974,52.840,1],
24018=>[93.418,-79.968,52.845,1],
24019=>[93.431,-79.962,52.852,1],
24020=>[93.444,-79.956,52.856,1],
24021=>[93.462,-79.953,52.858,1],
24022=>[93.485,-79.953,52.860,1],
24023=>[93.509,-79.953,52.859,1],
24024=>[93.533,-79.954,52.857,1],
24025=>[93.557,-79.954,52.854,1],
24026=>[93.581,-79.955,52.849,1],
24027=>[93.605,-79.955,52.845,1],
24028=>[93.624,-79.952,52.841,1],
24029=>[93.634,-79.943,52.835,1],
24030=>[93.644,-79.934,52.829,1],
24031=>[93.654,-79.926,52.823,1],
24032=>[93.664,-79.917,52.816,1],
24033=>[93.674,-79.908,52.808,1],
24034=>[93.684,-79.900,52.800,1],
24035=>[93.694,-79.891,52.792,1],
24036=>[93.704,-79.883,52.784,1],
24037=>[93.714,-79.874,52.776,1],
24038=>[93.724,-79.865,52.769,1],
24039=>[93.733,-79.863,52.759,1],
24040=>[93.742,-79.861,52.750,1],
24041=>[93.751,-79.860,52.742,1],
24042=>[93.759,-79.858,52.733,1],
24043=>[93.768,-79.857,52.724,1],
24063=>[93.938,-79.827,52.538,1],
24064=>[93.947,-79.826,52.527,1],
24065=>[93.956,-79.824,52.514,1],
24066=>[93.964,-79.823,52.501,1],
24067=>[93.973,-79.822,52.488,1],
24068=>[93.981,-79.820,52.475,1],
24069=>[93.990,-79.819,52.462,1],
24070=>[93.998,-79.817,52.449,1],
24071=>[94.007,-79.816,52.435,1],
24072=>[94.015,-79.814,52.419,1],
24073=>[94.024,-79.813,52.404,1],
24074=>[94.033,-79.811,52.388,1],
24075=>[94.041,-79.810,52.372,1],
24076=>[94.050,-79.808,52.356,1],
24077=>[94.058,-79.807,52.340,1],
24078=>[94.067,-79.805,52.324,1],
24079=>[94.075,-79.804,52.307,1],
24080=>[94.084,-79.803,52.290,1],
24081=>[94.092,-79.802,52.272,1],
24082=>[94.101,-79.800,52.254,1],
24083=>[94.110,-79.798,52.237,1],
24094=>[94.204,-79.642,52.038,1],
24095=>[94.212,-79.616,52.018,1],
24096=>[94.221,-79.590,51.997,1],
24097=>[94.229,-79.564,51.977,1],
24098=>[94.238,-79.538,51.957,1],
24099=>[94.247,-79.513,51.936,1],
24100=>[94.255,-79.487,51.914,1],
24101=>[94.264,-79.461,51.891,1],
24102=>[94.272,-79.435,51.867,1],
24103=>[94.274,-79.420,51.843,1],
24104=>[94.263,-79.426,51.819,1],
24105=>[94.252,-79.432,51.795,1],
24106=>[94.241,-79.438,51.772,1],
24107=>[94.233,-79.441,51.746,1],
24108=>[94.246,-79.421,51.719,1],
24109=>[94.259,-79.401,51.692,1],
24110=>[94.271,-79.382,51.664,1],
24111=>[94.284,-79.362,51.636,1],
24112=>[94.297,-79.342,51.609,1],
24113=>[94.310,-79.322,51.581,1],
24114=>[94.322,-79.303,51.551,1],
24115=>[94.335,-79.283,51.519,1],
24116=>[94.352,-79.312,51.486,1],
24117=>[94.369,-79.343,51.453,1],
24118=>[94.386,-79.375,51.420,1],
24119=>[94.403,-79.406,51.386,1],
24120=>[94.415,-79.444,51.353,1],
24121=>[94.424,-79.488,51.319,1],
24122=>[94.432,-79.531,51.284,1],
24123=>[94.441,-79.574,51.250,1],
24124=>[94.450,-79.617,51.216,1],
24125=>[94.459,-79.661,51.182,1],
24126=>[94.468,-79.704,51.148,1],
24127=>[94.477,-79.747,51.114,1],
24662=>[92.517,-80.488,53.417,1],
24663=>[92.533,-80.480,53.398,1],
24664=>[92.549,-80.472,53.379,1],
24665=>[92.565,-80.464,53.359,1],
24666=>[92.581,-80.457,53.342,1],
24667=>[92.597,-80.448,53.322,1],
24668=>[92.614,-80.440,53.303,1],
24669=>[92.629,-80.432,53.284,1],
24670=>[92.645,-80.424,53.266,1],
24671=>[92.661,-80.416,53.250,1],
24672=>[92.677,-80.408,53.235,1],
24673=>[92.694,-80.400,53.224,1],
24674=>[92.715,-80.391,53.211,1],
24675=>[92.736,-80.383,53.199,1],
24676=>[92.757,-80.375,53.185,1],
24677=>[92.778,-80.366,53.170,1],
24678=>[92.798,-80.358,53.154,1],
24679=>[92.819,-80.350,53.138,1],
24680=>[92.840,-80.341,53.122,1],
24681=>[92.861,-80.333,53.105,1],
24682=>[92.882,-80.325,53.087,1],
24683=>[92.903,-80.316,53.068,1],
24684=>[92.925,-80.292,53.051,1],
24685=>[92.948,-80.265,53.033,1],
24686=>[92.971,-80.237,53.014,1],
24687=>[92.987,-80.234,52.995,1],
24688=>[92.999,-80.239,52.978,1],
24689=>[93.012,-80.244,52.961,1],
24690=>[93.025,-80.250,52.947,1],
24691=>[93.038,-80.255,52.933,1],
24692=>[93.048,-80.256,52.921,1],
24693=>[93.058,-80.248,52.910,1],
24694=>[93.068,-80.237,52.901,1],
24695=>[93.091,-80.228,52.892,1],
24696=>[93.116,-80.220,52.884,1],
24697=>[93.141,-80.212,52.877,1],
24698=>[93.166,-80.203,52.871,1],
24699=>[93.191,-80.194,52.866,1],
24700=>[93.216,-80.186,52.862,1],
24701=>[93.241,-80.178,52.859,1],
24702=>[93.266,-80.169,52.857,1],
24703=>[93.275,-80.156,52.853,1],
24704=>[93.273,-80.139,52.848,1],
24705=>[93.271,-80.122,52.844,1],
24706=>[93.270,-80.105,52.842,1],
24707=>[93.278,-80.080,52.838,1],
24708=>[93.287,-80.056,52.835,1],
24709=>[93.295,-80.032,52.833,1],
24710=>[93.304,-80.008,52.830,1],
24711=>[93.313,-79.990,52.828,1],
24712=>[93.322,-79.971,52.826,1],
24713=>[93.334,-79.957,52.823,1],
24714=>[93.358,-79.952,52.823,1],
24715=>[93.370,-79.962,52.825,1],
24716=>[93.381,-79.971,52.828,1],
24717=>[93.392,-79.981,52.833,1],
24718=>[93.414,-79.961,52.837,1],
24719=>[93.427,-79.955,52.842,1],
24720=>[93.440,-79.949,52.848,1],
24721=>[93.453,-79.943,52.852,1],
24722=>[93.467,-79.936,52.856,1],
24723=>[93.480,-79.930,52.857,1],
24724=>[93.493,-79.924,52.856,1],
24725=>[93.514,-79.923,52.854,1],
24726=>[93.538,-79.924,52.850,1],
24727=>[93.562,-79.924,52.846,1],
24728=>[93.586,-79.924,52.842,1],
24729=>[93.610,-79.924,52.837,1],
24730=>[93.634,-79.924,52.832,1],
24731=>[93.644,-79.916,52.826,1],
24732=>[93.654,-79.908,52.821,1],
24733=>[93.664,-79.899,52.815,1],
24734=>[93.674,-79.890,52.807,1],
24735=>[93.684,-79.881,52.798,1],
24736=>[93.694,-79.873,52.791,1],
24737=>[93.704,-79.864,52.783,1],
24738=>[93.714,-79.855,52.775,1],
24739=>[93.724,-79.850,52.767,1],
24740=>[93.732,-79.849,52.758,1],
24741=>[93.741,-79.847,52.749,1],
24742=>[93.750,-79.845,52.741,1],
24743=>[93.758,-79.844,52.732,1],
24744=>[93.767,-79.842,52.723,1],
24764=>[93.938,-79.813,52.541,1],
24765=>[93.946,-79.811,52.530,1],
24766=>[93.955,-79.811,52.517,1],
24767=>[93.964,-79.809,52.505,1],
24768=>[93.972,-79.808,52.493,1],
24769=>[93.981,-79.806,52.479,1],
24770=>[93.989,-79.805,52.466,1],
24771=>[93.998,-79.803,52.453,1],
24772=>[94.006,-79.802,52.439,1],
24773=>[94.015,-79.800,52.423,1],
24774=>[94.024,-79.798,52.408,1],
24775=>[94.032,-79.797,52.392,1],
24776=>[94.041,-79.795,52.376,1],
24777=>[94.049,-79.794,52.360,1],
24778=>[94.058,-79.792,52.344,1],
24779=>[94.066,-79.791,52.328,1],
24780=>[94.075,-79.790,52.310,1],
24781=>[94.083,-79.789,52.293,1],
24782=>[94.092,-79.787,52.275,1],
24783=>[94.101,-79.786,52.258,1],
24784=>[94.109,-79.784,52.241,1],
24785=>[94.117,-79.783,52.223,1],
24794=>[94.194,-79.654,52.064,1],
24795=>[94.203,-79.629,52.043,1],
24796=>[94.211,-79.603,52.023,1],
24797=>[94.220,-79.577,52.003,1],
24798=>[94.228,-79.551,51.983,1],
24799=>[94.237,-79.525,51.963,1],
24800=>[94.246,-79.499,51.942,1],
24801=>[94.254,-79.473,51.921,1],
24802=>[94.263,-79.447,51.898,1],
24803=>[94.271,-79.422,51.875,1],
24804=>[94.277,-79.400,51.851,1],
24805=>[94.266,-79.406,51.828,1],
24806=>[94.255,-79.412,51.805,1],
24807=>[94.245,-79.418,51.782,1],
24808=>[94.234,-79.423,51.757,1],
24809=>[94.243,-79.407,51.730,1],
24810=>[94.256,-79.388,51.702,1],
24811=>[94.268,-79.368,51.676,1],
24812=>[94.281,-79.348,51.649,1],
24813=>[94.294,-79.328,51.622,1],
24814=>[94.307,-79.309,51.594,1],
24815=>[94.319,-79.289,51.563,1],
24816=>[94.332,-79.269,51.530,1],
24817=>[94.347,-79.280,51.496,1],
24818=>[94.364,-79.312,51.463,1],
24819=>[94.382,-79.343,51.430,1],
24820=>[94.395,-79.379,51.396,1],
24821=>[94.404,-79.422,51.363,1],
24822=>[94.413,-79.465,51.329,1],
24823=>[94.422,-79.508,51.294,1],
24824=>[94.430,-79.551,51.259,1],
24825=>[94.439,-79.595,51.225,1],
24826=>[94.448,-79.639,51.190,1],
24827=>[94.457,-79.682,51.156,1],
24828=>[94.466,-79.725,51.122,1],
25363=>[92.513,-80.472,53.438,1],
25364=>[92.529,-80.463,53.420,1],
25365=>[92.545,-80.455,53.401,1],
25366=>[92.561,-80.447,53.382,1],
25367=>[92.577,-80.439,53.363,1],
25368=>[92.593,-80.431,53.343,1],
25369=>[92.609,-80.423,53.323,1],
25370=>[92.625,-80.415,53.304,1],
25371=>[92.641,-80.407,53.285,1],
25372=>[92.657,-80.399,53.267,1],
25373=>[92.673,-80.391,53.250,1],
25374=>[92.690,-80.383,53.234,1],
25375=>[92.705,-80.375,53.221,1],
25376=>[92.721,-80.367,53.208,1],
25377=>[92.740,-80.359,53.195,1],
25378=>[92.761,-80.350,53.182,1],
25379=>[92.782,-80.342,53.167,1],
25380=>[92.802,-80.334,53.152,1],
25381=>[92.824,-80.325,53.136,1],
25382=>[92.844,-80.317,53.119,1],
25383=>[92.865,-80.309,53.101,1],
25384=>[92.886,-80.300,53.083,1],
25385=>[92.907,-80.292,53.065,1],
25386=>[92.929,-80.275,53.047,1],
25387=>[92.951,-80.248,53.026,1],
25388=>[92.975,-80.221,53.007,1],
25389=>[92.990,-80.216,52.988,1],
25390=>[93.003,-80.222,52.970,1],
25391=>[93.016,-80.226,52.954,1],
25392=>[93.028,-80.231,52.940,1],
25393=>[93.041,-80.236,52.927,1],
25394=>[93.048,-80.233,52.915,1],
25395=>[93.061,-80.225,52.906,1],
25396=>[93.086,-80.216,52.896,1],
25397=>[93.111,-80.208,52.888,1],
25398=>[93.135,-80.199,52.880,1],
25399=>[93.157,-80.189,52.874,1],
25400=>[93.180,-80.178,52.869,1],
25401=>[93.202,-80.168,52.865,1],
25402=>[93.224,-80.159,52.862,1],
25403=>[93.247,-80.148,52.859,1],
25404=>[93.261,-80.137,52.855,1],
25405=>[93.260,-80.115,52.850,1],
25406=>[93.258,-80.097,52.845,1],
25407=>[93.260,-80.077,52.841,1],
25408=>[93.269,-80.053,52.837,1],
25409=>[93.278,-80.034,52.833,1],
25410=>[93.287,-80.015,52.829,1],
25411=>[93.296,-79.996,52.827,1],
25412=>[93.305,-79.977,52.825,1],
25413=>[93.317,-79.961,52.822,1],
25414=>[93.331,-79.952,52.819,1],
25415=>[93.352,-79.947,52.819,1],
25416=>[93.376,-79.957,52.821,1],
25417=>[93.387,-79.966,52.825,1],
25418=>[93.398,-79.976,52.829,1],
25419=>[93.421,-79.949,52.834,1],
25420=>[93.436,-79.940,52.839,1],
25421=>[93.449,-79.934,52.844,1],
25422=>[93.463,-79.928,52.849,1],
25423=>[93.476,-79.923,52.853,1],
25424=>[93.489,-79.917,52.854,1],
25425=>[93.502,-79.911,52.853,1],
25426=>[93.516,-79.905,52.851,1],
25427=>[93.529,-79.899,52.846,1],
25428=>[93.543,-79.893,52.843,1],
25429=>[93.567,-79.893,52.840,1],
25430=>[93.591,-79.894,52.835,1],
25431=>[93.615,-79.894,52.829,1],
25432=>[93.639,-79.895,52.823,1],
25433=>[93.654,-79.889,52.817,1],
25434=>[93.664,-79.880,52.810,1],
25435=>[93.674,-79.872,52.803,1],
25436=>[93.684,-79.863,52.796,1],
25437=>[93.694,-79.855,52.789,1],
25438=>[93.704,-79.845,52.781,1],
25439=>[93.714,-79.837,52.772,1],
25440=>[93.723,-79.836,52.764,1],
25441=>[93.731,-79.834,52.757,1],
25442=>[93.740,-79.833,52.748,1],
25443=>[93.749,-79.831,52.739,1],
25444=>[93.757,-79.830,52.731,1],
25445=>[93.766,-79.828,52.722,1],
25446=>[93.774,-79.827,52.713,1],
25465=>[93.937,-79.798,52.544,1],
25466=>[93.945,-79.798,52.533,1],
25467=>[93.954,-79.796,52.520,1],
25468=>[93.963,-79.795,52.509,1],
25469=>[93.971,-79.793,52.496,1],
25470=>[93.980,-79.792,52.483,1],
25471=>[93.988,-79.790,52.469,1],
25472=>[93.997,-79.789,52.456,1],
25473=>[94.005,-79.787,52.442,1],
25474=>[94.014,-79.786,52.427,1],
25475=>[94.023,-79.784,52.411,1],
25476=>[94.031,-79.783,52.395,1],
25477=>[94.040,-79.781,52.379,1],
25478=>[94.048,-79.780,52.363,1],
25479=>[94.057,-79.778,52.346,1],
25480=>[94.065,-79.777,52.331,1],
25481=>[94.074,-79.776,52.313,1],
25482=>[94.082,-79.774,52.295,1],
25483=>[94.091,-79.773,52.278,1],
25484=>[94.100,-79.771,52.261,1],
25485=>[94.108,-79.770,52.244,1],
25486=>[94.117,-79.768,52.228,1],
25487=>[94.125,-79.767,52.211,1],
25492=>[94.168,-79.719,52.122,1],
25493=>[94.177,-79.692,52.104,1],
25494=>[94.185,-79.667,52.087,1],
25495=>[94.194,-79.641,52.068,1],
25496=>[94.202,-79.615,52.048,1],
25497=>[94.210,-79.589,52.028,1],
25498=>[94.219,-79.563,52.008,1],
25499=>[94.227,-79.538,51.988,1],
25500=>[94.236,-79.512,51.968,1],
25501=>[94.245,-79.486,51.948,1],
25502=>[94.253,-79.460,51.927,1],
25503=>[94.262,-79.434,51.904,1],
25504=>[94.270,-79.408,51.882,1],
25505=>[94.279,-79.382,51.860,1],
25506=>[94.269,-79.386,51.838,1],
25507=>[94.259,-79.391,51.816,1],
25508=>[94.248,-79.397,51.794,1],
25509=>[94.237,-79.404,51.769,1],
25510=>[94.240,-79.394,51.742,1],
25511=>[94.253,-79.374,51.714,1],
25512=>[94.265,-79.354,51.688,1],
25513=>[94.278,-79.335,51.663,1],
25514=>[94.291,-79.315,51.637,1],
25515=>[94.303,-79.295,51.609,1],
25516=>[94.316,-79.275,51.577,1],
25517=>[94.329,-79.256,51.542,1],
25518=>[94.343,-79.249,51.508,1],
25519=>[94.360,-79.280,51.475,1],
25520=>[94.376,-79.313,51.441,1],
25521=>[94.384,-79.357,51.406,1],
25522=>[94.393,-79.400,51.372,1],
25523=>[94.402,-79.443,51.338,1],
25524=>[94.411,-79.486,51.303,1],
25525=>[94.419,-79.529,51.268,1],
25526=>[94.428,-79.573,51.233,1],
25527=>[94.437,-79.616,51.198,1],
25528=>[94.446,-79.659,51.164,1],
25529=>[94.455,-79.702,51.129,1],
26065=>[92.525,-80.447,53.442,1],
26066=>[92.541,-80.438,53.423,1],
26067=>[92.557,-80.430,53.404,1],
26068=>[92.573,-80.422,53.385,1],
26069=>[92.589,-80.414,53.365,1],
26070=>[92.605,-80.406,53.345,1],
26071=>[92.621,-80.398,53.325,1],
26072=>[92.637,-80.390,53.305,1],
26073=>[92.653,-80.382,53.285,1],
26074=>[92.669,-80.374,53.266,1],
26075=>[92.685,-80.366,53.248,1],
26076=>[92.701,-80.358,53.232,1],
26077=>[92.717,-80.350,53.216,1],
26078=>[92.733,-80.342,53.201,1],
26079=>[92.749,-80.334,53.187,1],
26080=>[92.766,-80.326,53.174,1],
26081=>[92.786,-80.318,53.160,1],
26082=>[92.807,-80.309,53.146,1],
26083=>[92.828,-80.301,53.131,1],
26084=>[92.849,-80.293,53.115,1],
26085=>[92.869,-80.284,53.097,1],
26086=>[92.890,-80.276,53.077,1],
26087=>[92.911,-80.268,53.058,1],
26088=>[92.932,-80.259,53.037,1],
26089=>[92.955,-80.231,53.017,1],
26090=>[92.978,-80.204,52.998,1],
26091=>[92.994,-80.198,52.978,1],
26092=>[93.007,-80.203,52.961,1],
26093=>[93.019,-80.209,52.946,1],
26094=>[93.032,-80.214,52.933,1],
26095=>[93.042,-80.213,52.921,1],
26096=>[93.050,-80.208,52.910,1],
26097=>[93.068,-80.196,52.901,1],
26098=>[93.090,-80.186,52.892,1],
26099=>[93.112,-80.176,52.884,1],
26100=>[93.135,-80.166,52.877,1],
26101=>[93.157,-80.156,52.871,1],
26102=>[93.180,-80.146,52.867,1],
26103=>[93.202,-80.136,52.863,1],
26104=>[93.224,-80.125,52.859,1],
26105=>[93.248,-80.120,52.855,1],
26106=>[93.247,-80.099,52.850,1],
26107=>[93.245,-80.078,52.844,1],
26108=>[93.252,-80.060,52.840,1],
26109=>[93.261,-80.041,52.835,1],
26110=>[93.270,-80.022,52.830,1],
26111=>[93.279,-80.002,52.824,1],
26112=>[93.288,-79.983,52.822,1],
26113=>[93.298,-79.967,52.819,1],
26114=>[93.313,-79.958,52.817,1],
26115=>[93.328,-79.949,52.815,1],
26116=>[93.347,-79.942,52.815,1],
26117=>[93.381,-79.952,52.817,1],
26118=>[93.393,-79.961,52.820,1],
26119=>[93.403,-79.971,52.824,1],
26120=>[93.428,-79.940,52.830,1],
26121=>[93.445,-79.927,52.834,1],
26122=>[93.459,-79.921,52.840,1],
26123=>[93.472,-79.914,52.845,1],
26124=>[93.485,-79.908,52.849,1],
26125=>[93.498,-79.902,52.851,1],
26126=>[93.512,-79.896,52.851,1],
26127=>[93.525,-79.891,52.849,1],
26128=>[93.538,-79.885,52.844,1],
26129=>[93.552,-79.879,52.841,1],
26130=>[93.565,-79.873,52.838,1],
26131=>[93.578,-79.867,52.833,1],
26132=>[93.596,-79.864,52.827,1],
26133=>[93.620,-79.864,52.821,1],
26134=>[93.644,-79.864,52.814,1],
26135=>[93.664,-79.862,52.807,1],
26136=>[93.674,-79.853,52.800,1],
26137=>[93.684,-79.845,52.793,1],
26138=>[93.694,-79.836,52.787,1],
26139=>[93.704,-79.827,52.778,1],
26140=>[93.713,-79.823,52.770,1],
26141=>[93.722,-79.821,52.762,1],
26142=>[93.730,-79.820,52.755,1],
26143=>[93.739,-79.818,52.746,1],
26144=>[93.748,-79.817,52.738,1],
26145=>[93.756,-79.815,52.730,1],
26146=>[93.765,-79.814,52.721,1],
26147=>[93.773,-79.812,52.712,1],
26148=>[93.782,-79.811,52.704,1],
26166=>[93.936,-79.785,52.546,1],
26167=>[93.944,-79.783,52.535,1],
26168=>[93.953,-79.782,52.523,1],
26169=>[93.962,-79.780,52.511,1],
26170=>[93.970,-79.779,52.499,1],
26171=>[93.979,-79.777,52.486,1],
26172=>[93.987,-79.776,52.472,1],
26173=>[93.996,-79.774,52.458,1],
26174=>[94.004,-79.773,52.445,1],
26175=>[94.013,-79.771,52.430,1],
26176=>[94.022,-79.770,52.414,1],
26177=>[94.030,-79.768,52.398,1],
26178=>[94.039,-79.767,52.383,1],
26179=>[94.047,-79.765,52.366,1],
26180=>[94.056,-79.764,52.349,1],
26181=>[94.064,-79.763,52.334,1],
26182=>[94.073,-79.761,52.316,1],
26183=>[94.081,-79.760,52.298,1],
26184=>[94.090,-79.758,52.281,1],
26185=>[94.099,-79.757,52.264,1],
26186=>[94.107,-79.755,52.248,1],
26187=>[94.116,-79.754,52.231,1],
26188=>[94.124,-79.752,52.214,1],
26189=>[94.133,-79.751,52.196,1],
26190=>[94.141,-79.749,52.178,1],
26191=>[94.150,-79.748,52.160,1],
26192=>[94.158,-79.731,52.142,1],
26193=>[94.167,-79.705,52.125,1],
26194=>[94.176,-79.679,52.108,1],
26195=>[94.184,-79.654,52.091,1],
26196=>[94.193,-79.628,52.071,1],
26197=>[94.201,-79.601,52.051,1],
26198=>[94.210,-79.576,52.032,1],
26199=>[94.218,-79.550,52.012,1],
26200=>[94.227,-79.524,51.992,1],
26201=>[94.236,-79.498,51.973,1],
26202=>[94.244,-79.473,51.953,1],
26203=>[94.252,-79.447,51.932,1],
26204=>[94.261,-79.421,51.910,1],
26205=>[94.269,-79.395,51.889,1],
26206=>[94.278,-79.369,51.868,1],
26207=>[94.273,-79.366,51.848,1],
26208=>[94.262,-79.372,51.829,1],
26209=>[94.251,-79.378,51.807,1],
26210=>[94.240,-79.383,51.783,1],
26211=>[94.237,-79.381,51.754,1],
26212=>[94.250,-79.361,51.727,1],
26213=>[94.262,-79.341,51.702,1],
26214=>[94.275,-79.322,51.678,1],
26215=>[94.288,-79.302,51.653,1],
26216=>[94.300,-79.282,51.624,1],
26217=>[94.314,-79.263,51.593,1],
26218=>[94.326,-79.243,51.556,1],
26219=>[94.339,-79.223,51.521,1],
26220=>[94.355,-79.248,51.487,1],
26221=>[94.364,-79.291,51.451,1],
26222=>[94.373,-79.334,51.415,1],
26223=>[94.382,-79.377,51.381,1],
26224=>[94.391,-79.420,51.348,1],
26225=>[94.400,-79.463,51.312,1],
26226=>[94.409,-79.507,51.276,1],
26227=>[94.417,-79.551,51.241,1],
26228=>[94.426,-79.594,51.206,1],
26229=>[94.435,-79.637,51.171,1],
26230=>[94.444,-79.680,51.137,1],
26766=>[92.521,-80.429,53.465,1],
26767=>[92.537,-80.422,53.446,1],
26768=>[92.553,-80.413,53.426,1],
26769=>[92.569,-80.405,53.407,1],
26770=>[92.585,-80.397,53.387,1],
26771=>[92.601,-80.389,53.367,1],
26772=>[92.617,-80.381,53.347,1],
26773=>[92.633,-80.373,53.325,1],
26774=>[92.649,-80.365,53.305,1],
26775=>[92.665,-80.357,53.284,1],
26776=>[92.681,-80.349,53.265,1],
26777=>[92.697,-80.341,53.245,1],
26778=>[92.713,-80.333,53.227,1],
26779=>[92.729,-80.325,53.210,1],
26780=>[92.745,-80.317,53.195,1],
26781=>[92.761,-80.309,53.180,1],
26782=>[92.777,-80.301,53.166,1],
26783=>[92.793,-80.293,53.153,1],
26784=>[92.811,-80.284,53.139,1],
26785=>[92.832,-80.276,53.124,1],
26786=>[92.853,-80.268,53.107,1],
26787=>[92.873,-80.259,53.088,1],
26788=>[92.895,-80.251,53.068,1],
26789=>[92.915,-80.243,53.047,1],
26790=>[92.936,-80.234,53.027,1],
26791=>[92.958,-80.214,53.007,1],
26792=>[92.981,-80.187,52.987,1],
26793=>[92.998,-80.180,52.968,1],
26794=>[93.010,-80.185,52.952,1],
26795=>[93.023,-80.190,52.938,1],
26796=>[93.035,-80.193,52.926,1],
26797=>[93.042,-80.190,52.915,1],
26798=>[93.056,-80.177,52.905,1],
26799=>[93.070,-80.164,52.896,1],
26800=>[93.089,-80.153,52.888,1],
26801=>[93.112,-80.143,52.880,1],
26802=>[93.134,-80.133,52.873,1],
26803=>[93.156,-80.123,52.867,1],
26804=>[93.179,-80.113,52.862,1],
26805=>[93.201,-80.103,52.859,1],
26806=>[93.225,-80.096,52.854,1],
26807=>[93.233,-80.083,52.849,1],
26808=>[93.231,-80.062,52.844,1],
26809=>[93.244,-80.047,52.839,1],
26810=>[93.253,-80.028,52.833,1],
26811=>[93.262,-80.009,52.827,1],
26812=>[93.271,-79.990,52.821,1],
26813=>[93.281,-79.971,52.817,1],
26814=>[93.295,-79.962,52.814,1],
26815=>[93.310,-79.953,52.811,1],
26816=>[93.325,-79.944,52.810,1],
26817=>[93.341,-79.936,52.811,1],
26818=>[93.387,-79.946,52.813,1],
26819=>[93.398,-79.955,52.816,1],
26820=>[93.410,-79.961,52.821,1],
26821=>[93.435,-79.930,52.826,1],
26822=>[93.454,-79.913,52.830,1],
26823=>[93.468,-79.907,52.837,1],
26824=>[93.481,-79.901,52.842,1],
26825=>[93.494,-79.895,52.846,1],
26826=>[93.508,-79.889,52.849,1],
26827=>[93.521,-79.883,52.849,1],
26828=>[93.534,-79.877,52.848,1],
26829=>[93.548,-79.871,52.844,1],
26830=>[93.561,-79.864,52.841,1],
26831=>[93.574,-79.858,52.838,1],
26832=>[93.587,-79.853,52.832,1],
26833=>[93.601,-79.847,52.825,1],
26834=>[93.614,-79.841,52.818,1],
26835=>[93.627,-79.835,52.812,1],
26836=>[93.649,-79.834,52.805,1],
26837=>[93.673,-79.834,52.798,1],
26838=>[93.684,-79.827,52.791,1],
26839=>[93.694,-79.817,52.784,1],
26840=>[93.704,-79.810,52.776,1],
26841=>[93.713,-79.808,52.768,1],
26842=>[93.721,-79.807,52.761,1],
26843=>[93.730,-79.805,52.753,1],
26844=>[93.739,-79.804,52.745,1],
26845=>[93.747,-79.802,52.737,1],
26846=>[93.756,-79.801,52.729,1],
26847=>[93.764,-79.799,52.720,1],
26848=>[93.773,-79.798,52.712,1],
26849=>[93.781,-79.796,52.704,1],
26867=>[93.935,-79.770,52.549,1],
26868=>[93.943,-79.769,52.538,1],
26869=>[93.952,-79.767,52.526,1],
26870=>[93.961,-79.766,52.514,1],
26871=>[93.969,-79.764,52.501,1],
26872=>[93.978,-79.763,52.488,1],
26873=>[93.986,-79.761,52.475,1],
26874=>[93.995,-79.760,52.461,1],
26875=>[94.003,-79.758,52.447,1],
26876=>[94.012,-79.757,52.432,1],
26877=>[94.020,-79.755,52.416,1],
26878=>[94.029,-79.754,52.400,1],
26879=>[94.038,-79.752,52.385,1],
26880=>[94.046,-79.751,52.369,1],
26881=>[94.055,-79.750,52.352,1],
26882=>[94.063,-79.748,52.336,1],
26883=>[94.072,-79.747,52.318,1],
26884=>[94.080,-79.745,52.300,1],
26885=>[94.089,-79.744,52.284,1],
26886=>[94.098,-79.742,52.267,1],
26887=>[94.106,-79.741,52.250,1],
26888=>[94.115,-79.739,52.233,1],
26889=>[94.123,-79.738,52.216,1],
26890=>[94.132,-79.736,52.198,1],
26891=>[94.140,-79.735,52.180,1],
26892=>[94.149,-79.733,52.162,1],
26893=>[94.157,-79.717,52.144,1],
26894=>[94.166,-79.692,52.127,1],
26895=>[94.175,-79.666,52.111,1],
26896=>[94.183,-79.640,52.093,1],
26897=>[94.192,-79.614,52.074,1],
26898=>[94.200,-79.588,52.054,1],
26899=>[94.209,-79.563,52.034,1],
26900=>[94.217,-79.537,52.014,1],
26901=>[94.226,-79.510,51.995,1],
26902=>[94.235,-79.485,51.976,1],
26903=>[94.243,-79.459,51.956,1],
26904=>[94.252,-79.433,51.936,1],
26905=>[94.260,-79.407,51.914,1],
26906=>[94.269,-79.382,51.895,1],
26907=>[94.277,-79.356,51.876,1],
26908=>[94.276,-79.346,51.858,1],
26909=>[94.265,-79.352,51.839,1],
26910=>[94.265,-79.353,51.817,1],
26911=>[94.278,-79.352,51.792,1],
26912=>[94.290,-79.350,51.764,1],
26913=>[94.302,-79.348,51.737,1],
26914=>[94.313,-79.338,51.712,1],
26915=>[94.319,-79.316,51.688,1],
26916=>[94.326,-79.296,51.662,1],
26917=>[94.332,-79.275,51.634,1],
26918=>[94.337,-79.254,51.604,1],
26919=>[94.339,-79.233,51.569,1],
26920=>[94.340,-79.212,51.534,1],
26921=>[94.345,-79.225,51.498,1],
26922=>[94.354,-79.269,51.460,1],
26923=>[94.362,-79.312,51.424,1],
26924=>[94.371,-79.355,51.389,1],
26925=>[94.380,-79.398,51.355,1],
26926=>[94.389,-79.441,51.319,1],
26927=>[94.398,-79.485,51.284,1],
26928=>[94.407,-79.528,51.249,1],
26929=>[94.415,-79.571,51.215,1],
26930=>[94.424,-79.614,51.179,1],
26931=>[94.433,-79.657,51.145,1],
27468=>[92.533,-80.404,53.469,1],
27469=>[92.549,-80.397,53.449,1],
27470=>[92.565,-80.388,53.429,1],
27471=>[92.581,-80.380,53.410,1],
27472=>[92.597,-80.372,53.389,1],
27473=>[92.613,-80.364,53.368,1],
27474=>[92.629,-80.356,53.347,1],
27475=>[92.645,-80.348,53.325,1],
27476=>[92.661,-80.340,53.304,1],
27477=>[92.677,-80.332,53.283,1],
27478=>[92.693,-80.324,53.262,1],
27479=>[92.709,-80.316,53.243,1],
27480=>[92.725,-80.308,53.223,1],
27481=>[92.741,-80.300,53.204,1],
27482=>[92.757,-80.292,53.187,1],
27483=>[92.773,-80.284,53.172,1],
27484=>[92.789,-80.276,53.159,1],
27485=>[92.805,-80.268,53.145,1],
27486=>[92.821,-80.259,53.131,1],
27487=>[92.838,-80.252,53.115,1],
27488=>[92.857,-80.243,53.096,1],
27489=>[92.878,-80.235,53.077,1],
27490=>[92.899,-80.227,53.056,1],
27491=>[92.919,-80.218,53.035,1],
27492=>[92.940,-80.210,53.015,1],
27493=>[92.961,-80.197,52.995,1],
27494=>[92.985,-80.170,52.975,1],
27495=>[93.001,-80.162,52.957,1],
27496=>[93.014,-80.167,52.943,1],
27497=>[93.027,-80.172,52.932,1],
27498=>[93.035,-80.171,52.920,1],
27499=>[93.048,-80.159,52.910,1],
27500=>[93.062,-80.146,52.901,1],
27501=>[93.075,-80.134,52.893,1],
27502=>[93.089,-80.121,52.884,1],
27503=>[93.111,-80.111,52.876,1],
27504=>[93.134,-80.100,52.869,1],
27505=>[93.156,-80.090,52.863,1],
27506=>[93.178,-80.080,52.859,1],
27507=>[93.202,-80.073,52.855,1],
27508=>[93.219,-80.066,52.850,1],
27509=>[93.222,-80.047,52.845,1],
27510=>[93.236,-80.035,52.838,1],
27511=>[93.246,-80.015,52.831,1],
27512=>[93.255,-79.996,52.825,1],
27513=>[93.264,-79.977,52.819,1],
27514=>[93.278,-79.968,52.813,1],
27515=>[93.292,-79.958,52.808,1],
27516=>[93.307,-79.949,52.805,1],
27517=>[93.322,-79.940,52.805,1],
27518=>[93.337,-79.931,52.807,1],
27519=>[93.386,-79.940,52.809,1],
27520=>[93.404,-79.950,52.814,1],
27521=>[93.417,-79.952,52.819,1],
27522=>[93.442,-79.921,52.823,1],
27523=>[93.464,-79.899,52.828,1],
27524=>[93.477,-79.892,52.834,1],
27525=>[93.490,-79.886,52.839,1],
27526=>[93.503,-79.880,52.844,1],
27527=>[93.517,-79.875,52.846,1],
27528=>[93.530,-79.869,52.846,1],
27529=>[93.544,-79.863,52.846,1],
27530=>[93.557,-79.857,52.844,1],
27531=>[93.570,-79.851,52.842,1],
27532=>[93.583,-79.845,52.839,1],
27533=>[93.596,-79.839,52.834,1],
27534=>[93.610,-79.833,52.826,1],
27535=>[93.623,-79.827,52.818,1],
27536=>[93.636,-79.820,52.811,1],
27537=>[93.650,-79.815,52.805,1],
27538=>[93.663,-79.809,52.798,1],
27539=>[93.678,-79.804,52.790,1],
27540=>[93.694,-79.799,52.783,1],
27541=>[93.703,-79.795,52.776,1],
27542=>[93.712,-79.794,52.768,1],
27543=>[93.720,-79.792,52.759,1],
27544=>[93.729,-79.791,52.752,1],
27545=>[93.737,-79.789,52.744,1],
27546=>[93.746,-79.788,52.736,1],
27547=>[93.755,-79.786,52.728,1],
27548=>[93.763,-79.785,52.720,1],
27549=>[93.772,-79.783,52.712,1],
27550=>[93.780,-79.782,52.705,1],
27551=>[93.789,-79.780,52.697,1],
27568=>[93.934,-79.756,52.550,1],
27569=>[93.943,-79.755,52.539,1],
27570=>[93.952,-79.753,52.527,1],
27571=>[93.960,-79.751,52.514,1],
27572=>[93.969,-79.750,52.501,1],
27573=>[93.977,-79.748,52.489,1],
27574=>[93.986,-79.747,52.475,1],
27575=>[93.994,-79.745,52.461,1],
27576=>[94.003,-79.744,52.447,1],
27577=>[94.011,-79.742,52.432,1],
27578=>[94.020,-79.741,52.417,1],
27579=>[94.029,-79.739,52.401,1],
27580=>[94.037,-79.739,52.385,1],
27581=>[94.046,-79.737,52.368,1],
27582=>[94.054,-79.736,52.352,1],
27583=>[94.063,-79.734,52.336,1],
27584=>[94.071,-79.733,52.318,1],
27585=>[94.080,-79.731,52.301,1],
27586=>[94.088,-79.730,52.285,1],
27587=>[94.097,-79.728,52.267,1],
27588=>[94.106,-79.726,52.250,1],
27589=>[94.114,-79.725,52.234,1],
27590=>[94.123,-79.723,52.217,1],
27591=>[94.131,-79.722,52.199,1],
27592=>[94.140,-79.720,52.181,1],
27593=>[94.148,-79.720,52.163,1],
27594=>[94.157,-79.704,52.146,1],
27595=>[94.165,-79.678,52.129,1],
27596=>[94.174,-79.652,52.112,1],
27597=>[94.182,-79.626,52.094,1],
27598=>[94.191,-79.601,52.075,1],
27599=>[94.199,-79.575,52.055,1],
27600=>[94.208,-79.549,52.034,1],
27601=>[94.216,-79.523,52.016,1],
27602=>[94.225,-79.498,51.997,1],
27603=>[94.234,-79.472,51.977,1],
27604=>[94.242,-79.446,51.959,1],
27605=>[94.251,-79.419,51.939,1],
27606=>[94.259,-79.394,51.918,1],
27607=>[94.268,-79.368,51.900,1],
27608=>[94.276,-79.342,51.882,1],
27609=>[94.286,-79.325,51.865,1],
27610=>[94.293,-79.325,51.847,1],
27611=>[94.301,-79.326,51.825,1],
27612=>[94.309,-79.326,51.799,1],
27613=>[94.317,-79.326,51.771,1],
27614=>[94.325,-79.326,51.743,1],
27615=>[94.329,-79.330,51.718,1],
27616=>[94.329,-79.316,51.693,1],
27617=>[94.331,-79.294,51.667,1],
27618=>[94.332,-79.273,51.640,1],
27619=>[94.334,-79.253,51.611,1],
27620=>[94.335,-79.231,51.577,1],
27621=>[94.337,-79.210,51.542,1],
27622=>[94.334,-79.209,51.505,1],
27623=>[94.343,-79.246,51.467,1],
27624=>[94.352,-79.289,51.431,1],
27625=>[94.360,-79.333,51.396,1],
27626=>[94.369,-79.376,51.362,1],
27627=>[94.378,-79.419,51.327,1],
27628=>[94.387,-79.463,51.291,1],
27629=>[94.396,-79.506,51.256,1],
27630=>[94.405,-79.549,51.222,1],
27631=>[94.413,-79.592,51.186,1],
27632=>[94.422,-79.636,51.151,1],
28169=>[92.528,-80.388,53.493,1],
28170=>[92.545,-80.379,53.473,1],
28171=>[92.561,-80.372,53.453,1],
28172=>[92.577,-80.363,53.433,1],
28173=>[92.593,-80.355,53.412,1],
28174=>[92.609,-80.347,53.390,1],
28175=>[92.625,-80.339,53.369,1],
28176=>[92.641,-80.331,53.347,1],
28177=>[92.657,-80.323,53.325,1],
28178=>[92.673,-80.315,53.304,1],
28179=>[92.689,-80.307,53.283,1],
28180=>[92.705,-80.299,53.261,1],
28181=>[92.721,-80.291,53.240,1],
28182=>[92.737,-80.283,53.220,1],
28183=>[92.753,-80.275,53.200,1],
28184=>[92.769,-80.267,53.182,1],
28185=>[92.785,-80.259,53.165,1],
28186=>[92.801,-80.251,53.149,1],
28187=>[92.817,-80.243,53.135,1],
28188=>[92.833,-80.234,53.120,1],
28189=>[92.849,-80.227,53.104,1],
28190=>[92.865,-80.218,53.085,1],
28191=>[92.882,-80.211,53.065,1],
28192=>[92.903,-80.203,53.044,1],
28193=>[92.924,-80.194,53.022,1],
28194=>[92.944,-80.186,53.000,1],
28195=>[92.965,-80.178,52.981,1],
28196=>[92.988,-80.153,52.964,1],
28197=>[93.005,-80.144,52.949,1],
28198=>[93.018,-80.149,52.937,1],
28199=>[93.028,-80.151,52.926,1],
28200=>[93.040,-80.141,52.915,1],
28201=>[93.054,-80.128,52.907,1],
28202=>[93.067,-80.115,52.898,1],
28203=>[93.081,-80.102,52.888,1],
28204=>[93.094,-80.090,52.879,1],
28205=>[93.111,-80.077,52.872,1],
28206=>[93.133,-80.068,52.865,1],
28207=>[93.155,-80.058,52.859,1],
28208=>[93.179,-80.049,52.855,1],
28209=>[93.206,-80.049,52.850,1],
28210=>[93.213,-80.034,52.845,1],
28211=>[93.227,-80.021,52.838,1],
28212=>[93.237,-80.003,52.831,1],
28213=>[93.247,-79.984,52.823,1],
28214=>[93.260,-79.973,52.816,1],
28215=>[93.275,-79.964,52.811,1],
28216=>[93.289,-79.955,52.807,1],
28217=>[93.304,-79.946,52.804,1],
28218=>[93.319,-79.936,52.805,1],
28219=>[93.334,-79.927,52.806,1],
28220=>[93.380,-79.935,52.808,1],
28221=>[93.409,-79.945,52.813,1],
28222=>[93.424,-79.943,52.818,1],
28223=>[93.449,-79.912,52.823,1],
28224=>[93.473,-79.885,52.827,1],
28225=>[93.486,-79.879,52.832,1],
28226=>[93.499,-79.873,52.836,1],
28227=>[93.513,-79.867,52.841,1],
28228=>[93.526,-79.861,52.842,1],
28229=>[93.540,-79.855,52.843,1],
28230=>[93.553,-79.849,52.843,1],
28231=>[93.566,-79.842,52.844,1],
28232=>[93.579,-79.837,52.843,1],
28233=>[93.592,-79.831,52.840,1],
28234=>[93.606,-79.825,52.835,1],
28235=>[93.619,-79.819,52.827,1],
28236=>[93.632,-79.813,52.819,1],
28237=>[93.646,-79.807,52.810,1],
28238=>[93.659,-79.801,52.804,1],
28239=>[93.672,-79.795,52.797,1],
28240=>[93.684,-79.787,52.790,1],
28241=>[93.694,-79.777,52.784,1],
28242=>[93.708,-79.770,52.776,1],
28243=>[93.715,-79.772,52.767,1],
28244=>[93.721,-79.775,52.758,1],
28245=>[93.728,-79.776,52.750,1],
28246=>[93.736,-79.775,52.742,1],
28247=>[93.745,-79.773,52.734,1],
28248=>[93.754,-79.772,52.726,1],
28249=>[93.762,-79.770,52.718,1],
28250=>[93.771,-79.769,52.710,1],
28251=>[93.779,-79.767,52.702,1],
28252=>[93.788,-79.766,52.695,1],
28269=>[93.933,-79.742,52.550,1],
28270=>[93.942,-79.740,52.539,1],
28271=>[93.951,-79.739,52.526,1],
28272=>[93.959,-79.737,52.513,1],
28273=>[93.968,-79.736,52.500,1],
28274=>[93.976,-79.734,52.489,1],
28275=>[93.985,-79.733,52.475,1],
28276=>[93.993,-79.731,52.461,1],
28277=>[94.002,-79.730,52.446,1],
28278=>[94.010,-79.728,52.432,1],
28279=>[94.019,-79.726,52.416,1],
28280=>[94.028,-79.726,52.401,1],
28281=>[94.036,-79.724,52.385,1],
28282=>[94.045,-79.723,52.368,1],
28283=>[94.053,-79.721,52.351,1],
28284=>[94.062,-79.720,52.336,1],
28285=>[94.070,-79.718,52.318,1],
28286=>[94.079,-79.717,52.301,1],
28287=>[94.087,-79.715,52.284,1],
28288=>[94.096,-79.714,52.267,1],
28289=>[94.105,-79.712,52.250,1],
28290=>[94.113,-79.711,52.233,1],
28291=>[94.122,-79.709,52.217,1],
28292=>[94.130,-79.708,52.199,1],
28293=>[94.139,-79.707,52.181,1],
28294=>[94.147,-79.705,52.163,1],
28295=>[94.156,-79.691,52.145,1],
28296=>[94.165,-79.665,52.128,1],
28297=>[94.173,-79.639,52.111,1],
28298=>[94.182,-79.614,52.094,1],
28299=>[94.190,-79.588,52.074,1],
28300=>[94.199,-79.561,52.054,1],
28301=>[94.207,-79.535,52.034,1],
28302=>[94.215,-79.510,52.016,1],
28303=>[94.224,-79.484,51.997,1],
28304=>[94.232,-79.458,51.978,1],
28305=>[94.241,-79.432,51.959,1],
28306=>[94.250,-79.407,51.940,1],
28307=>[94.258,-79.381,51.921,1],
28308=>[94.266,-79.354,51.903,1],
28309=>[94.274,-79.328,51.886,1],
28310=>[94.288,-79.313,51.869,1],
28311=>[94.296,-79.313,51.850,1],
28312=>[94.305,-79.313,51.827,1],
28313=>[94.312,-79.313,51.802,1],
28314=>[94.320,-79.313,51.774,1],
28315=>[94.328,-79.313,51.745,1],
28316=>[94.326,-79.322,51.718,1],
28317=>[94.326,-79.313,51.693,1],
28318=>[94.327,-79.293,51.667,1],
28319=>[94.329,-79.272,51.641,1],
28320=>[94.331,-79.250,51.613,1],
28321=>[94.332,-79.229,51.581,1],
28322=>[94.331,-79.214,51.546,1],
28323=>[94.323,-79.217,51.509,1],
28324=>[94.332,-79.224,51.472,1],
28325=>[94.341,-79.267,51.437,1],
28326=>[94.350,-79.310,51.403,1],
28327=>[94.358,-79.353,51.370,1],
28328=>[94.367,-79.397,51.334,1],
28329=>[94.376,-79.440,51.298,1],
28330=>[94.385,-79.483,51.262,1],
28331=>[94.394,-79.526,51.228,1],
28332=>[94.403,-79.570,51.193,1],
28333=>[94.411,-79.613,51.157,1],
28871=>[92.541,-80.363,53.498,1],
28872=>[92.557,-80.354,53.478,1],
28873=>[92.573,-80.347,53.457,1],
28874=>[92.589,-80.338,53.435,1],
28875=>[92.605,-80.330,53.413,1],
28876=>[92.621,-80.322,53.392,1],
28877=>[92.637,-80.314,53.370,1],
28878=>[92.653,-80.306,53.347,1],
28879=>[92.669,-80.298,53.326,1],
28880=>[92.685,-80.290,53.304,1],
28881=>[92.701,-80.282,53.282,1],
28882=>[92.717,-80.274,53.259,1],
28883=>[92.733,-80.266,53.238,1],
28884=>[92.749,-80.258,53.217,1],
28885=>[92.765,-80.250,53.197,1],
28886=>[92.781,-80.242,53.178,1],
28887=>[92.797,-80.234,53.159,1],
28888=>[92.813,-80.226,53.142,1],
28889=>[92.829,-80.218,53.126,1],
28890=>[92.845,-80.209,53.109,1],
28891=>[92.861,-80.202,53.091,1],
28892=>[92.877,-80.193,53.071,1],
28893=>[92.894,-80.186,53.050,1],
28894=>[92.909,-80.178,53.029,1],
28895=>[92.928,-80.169,53.007,1],
28896=>[92.948,-80.161,52.988,1],
28897=>[92.970,-80.153,52.972,1],
28898=>[92.991,-80.136,52.956,1],
28899=>[93.009,-80.126,52.943,1],
28900=>[93.021,-80.131,52.932,1],
28901=>[93.031,-80.124,52.922,1],
28902=>[93.046,-80.111,52.914,1],
28903=>[93.059,-80.098,52.902,1],
28904=>[93.073,-80.085,52.891,1],
28905=>[93.086,-80.072,52.883,1],
28906=>[93.100,-80.059,52.874,1],
28907=>[93.114,-80.046,52.867,1],
28908=>[93.133,-80.035,52.860,1],
28909=>[93.155,-80.025,52.855,1],
28910=>[93.183,-80.026,52.850,1],
28911=>[93.204,-80.019,52.844,1],
28912=>[93.219,-80.007,52.838,1],
28913=>[93.230,-79.990,52.830,1],
28914=>[93.242,-79.977,52.822,1],
28915=>[93.257,-79.968,52.816,1],
28916=>[93.272,-79.959,52.811,1],
28917=>[93.286,-79.950,52.807,1],
28918=>[93.301,-79.941,52.805,1],
28919=>[93.316,-79.932,52.805,1],
28920=>[93.331,-79.923,52.806,1],
28921=>[93.374,-79.930,52.808,1],
28922=>[93.415,-79.939,52.814,1],
28923=>[93.431,-79.933,52.818,1],
28924=>[93.457,-79.902,52.822,1],
28925=>[93.482,-79.871,52.825,1],
28926=>[93.495,-79.864,52.828,1],
28927=>[93.509,-79.859,52.831,1],
28928=>[93.522,-79.853,52.835,1],
28929=>[93.535,-79.847,52.836,1],
28930=>[93.549,-79.841,52.838,1],
28931=>[93.562,-79.835,52.839,1],
28932=>[93.575,-79.829,52.841,1],
28933=>[93.588,-79.823,52.841,1],
28934=>[93.602,-79.817,52.838,1],
28935=>[93.615,-79.811,52.835,1],
28936=>[93.628,-79.805,52.828,1],
28937=>[93.641,-79.799,52.820,1],
28938=>[93.653,-79.791,52.811,1],
28939=>[93.663,-79.781,52.804,1],
28940=>[93.673,-79.771,52.797,1],
28941=>[93.683,-79.761,52.790,1],
28942=>[93.693,-79.751,52.785,1],
28943=>[93.706,-79.743,52.776,1],
28944=>[93.721,-79.737,52.765,1],
28945=>[93.734,-79.733,52.756,1],
28946=>[93.741,-79.735,52.746,1],
28947=>[93.748,-79.737,52.738,1],
28948=>[93.754,-79.740,52.730,1],
28949=>[93.761,-79.742,52.723,1],
28950=>[93.767,-79.745,52.715,1],
28951=>[93.774,-79.747,52.707,1],
28952=>[93.780,-79.750,52.700,1],
28953=>[93.787,-79.752,52.693,1],
28954=>[93.795,-79.751,52.686,1],
28956=>[93.813,-79.748,52.671,1],
28957=>[93.821,-79.746,52.663,1],
28958=>[93.830,-79.745,52.655,1],
28959=>[93.838,-79.743,52.648,1],
28960=>[93.847,-79.742,52.640,1],
28961=>[93.855,-79.740,52.632,1],
28962=>[93.864,-79.739,52.623,1],
28963=>[93.872,-79.737,52.615,1],
28964=>[93.881,-79.736,52.607,1],
28965=>[93.890,-79.734,52.597,1],
28970=>[93.932,-79.727,52.548,1],
28971=>[93.941,-79.726,52.536,1],
28972=>[93.949,-79.724,52.524,1],
28973=>[93.958,-79.723,52.511,1],
28974=>[93.967,-79.721,52.499,1],
28975=>[93.975,-79.720,52.486,1],
28976=>[93.984,-79.718,52.472,1],
28977=>[93.992,-79.717,52.459,1],
28978=>[94.001,-79.715,52.445,1],
28979=>[94.009,-79.714,52.430,1],
28980=>[94.018,-79.713,52.415,1],
28981=>[94.027,-79.711,52.399,1],
28982=>[94.035,-79.710,52.384,1],
28983=>[94.044,-79.708,52.367,1],
28984=>[94.052,-79.707,52.350,1],
28985=>[94.061,-79.705,52.334,1],
28986=>[94.069,-79.704,52.317,1],
28987=>[94.078,-79.702,52.299,1],
28988=>[94.086,-79.701,52.283,1],
28989=>[94.095,-79.699,52.266,1],
28990=>[94.104,-79.698,52.249,1],
28991=>[94.112,-79.696,52.232,1],
28992=>[94.121,-79.695,52.216,1],
28993=>[94.129,-79.694,52.198,1],
28994=>[94.138,-79.692,52.180,1],
28995=>[94.146,-79.691,52.162,1],
28996=>[94.155,-79.677,52.144,1],
28997=>[94.164,-79.651,52.127,1],
28998=>[94.172,-79.626,52.110,1],
28999=>[94.181,-79.600,52.092,1],
29000=>[94.189,-79.574,52.073,1],
29001=>[94.198,-79.548,52.053,1],
29002=>[94.206,-79.523,52.033,1],
29003=>[94.215,-79.497,52.014,1],
29004=>[94.223,-79.470,51.996,1],
29005=>[94.232,-79.444,51.977,1],
29006=>[94.241,-79.419,51.959,1],
29007=>[94.249,-79.393,51.940,1],
29008=>[94.257,-79.366,51.921,1],
29009=>[94.264,-79.340,51.903,1],
29010=>[94.273,-79.314,51.886,1],
29011=>[94.289,-79.304,51.868,1],
29012=>[94.300,-79.300,51.848,1],
29013=>[94.308,-79.300,51.826,1],
29014=>[94.316,-79.300,51.801,1],
29015=>[94.323,-79.300,51.773,1],
29016=>[94.327,-79.303,51.745,1],
29017=>[94.324,-79.315,51.719,1],
29018=>[94.323,-79.312,51.694,1],
29019=>[94.324,-79.291,51.668,1],
29020=>[94.326,-79.270,51.642,1],
29021=>[94.327,-79.249,51.614,1],
29022=>[94.329,-79.228,51.584,1],
29023=>[94.323,-79.219,51.550,1],
29024=>[94.311,-79.225,51.514,1],
29025=>[94.321,-79.219,51.478,1],
29026=>[94.330,-79.245,51.443,1],
29027=>[94.339,-79.288,51.409,1],
29028=>[94.348,-79.332,51.376,1],
29029=>[94.356,-79.375,51.340,1],
29030=>[94.365,-79.418,51.304,1],
29031=>[94.374,-79.461,51.269,1],
29032=>[94.383,-79.504,51.235,1],
29033=>[94.392,-79.548,51.199,1],
29034=>[94.401,-79.591,51.164,1],
29035=>[94.409,-79.634,51.128,1],
29572=>[92.538,-80.349,53.524,1],
29573=>[92.553,-80.337,53.503,1],
29574=>[92.569,-80.329,53.482,1],
29575=>[92.585,-80.322,53.460,1],
29576=>[92.600,-80.313,53.439,1],
29577=>[92.617,-80.305,53.417,1],
29578=>[92.633,-80.297,53.394,1],
29579=>[92.649,-80.289,53.372,1],
29580=>[92.665,-80.281,53.350,1],
29581=>[92.681,-80.273,53.327,1],
29582=>[92.697,-80.265,53.304,1],
29583=>[92.713,-80.257,53.280,1],
29584=>[92.729,-80.249,53.258,1],
29585=>[92.745,-80.241,53.236,1],
29586=>[92.761,-80.233,53.215,1],
29587=>[92.777,-80.225,53.194,1],
29588=>[92.793,-80.217,53.173,1],
29589=>[92.809,-80.209,53.153,1],
29590=>[92.825,-80.201,53.134,1],
29591=>[92.841,-80.193,53.116,1],
29592=>[92.857,-80.184,53.098,1],
29593=>[92.873,-80.177,53.078,1],
29594=>[92.889,-80.168,53.058,1],
29595=>[92.905,-80.161,53.037,1],
29596=>[92.921,-80.153,53.016,1],
29597=>[92.937,-80.144,52.998,1],
29598=>[92.953,-80.137,52.981,1],
29599=>[92.974,-80.128,52.965,1],
29600=>[92.995,-80.119,52.951,1],
29601=>[93.012,-80.108,52.939,1],
29602=>[93.023,-80.106,52.928,1],
29603=>[93.037,-80.093,52.918,1],
29604=>[93.051,-80.080,52.907,1],
29605=>[93.065,-80.067,52.896,1],
29606=>[93.078,-80.054,52.886,1],
29607=>[93.092,-80.041,52.877,1],
29608=>[93.106,-80.028,52.869,1],
29609=>[93.119,-80.015,52.861,1],
29610=>[93.133,-80.002,52.855,1],
29611=>[93.172,-80.017,52.849,1],
29612=>[93.190,-80.005,52.842,1],
29613=>[93.208,-79.993,52.836,1],
29614=>[93.224,-79.983,52.829,1],
29615=>[93.239,-79.974,52.823,1],
29616=>[93.254,-79.965,52.816,1],
29617=>[93.269,-79.955,52.811,1],
29618=>[93.283,-79.946,52.807,1],
29619=>[93.298,-79.937,52.805,1],
29620=>[93.313,-79.928,52.805,1],
29621=>[93.328,-79.919,52.806,1],
29622=>[93.369,-79.924,52.809,1],
29623=>[93.418,-79.934,52.815,1],
29624=>[93.438,-79.924,52.818,1],
29625=>[93.464,-79.893,52.821,1],
29626=>[93.489,-79.862,52.822,1],
29627=>[93.505,-79.851,52.824,1],
29628=>[93.518,-79.845,52.827,1],
29629=>[93.531,-79.839,52.831,1],
29630=>[93.545,-79.833,52.832,1],
29631=>[93.558,-79.827,52.833,1],
29632=>[93.571,-79.821,52.834,1],
29633=>[93.584,-79.815,52.835,1],
29634=>[93.597,-79.809,52.836,1],
29635=>[93.611,-79.803,52.834,1],
29636=>[93.623,-79.795,52.831,1],
29637=>[93.632,-79.785,52.825,1],
29638=>[93.642,-79.775,52.819,1],
29639=>[93.652,-79.765,52.810,1],
29640=>[93.662,-79.755,52.803,1],
29641=>[93.672,-79.745,52.797,1],
29642=>[93.682,-79.735,52.791,1],
29643=>[93.692,-79.725,52.784,1],
29644=>[93.704,-79.717,52.774,1],
29645=>[93.719,-79.710,52.762,1],
29646=>[93.734,-79.704,52.752,1],
29647=>[93.750,-79.698,52.742,1],
29648=>[93.761,-79.695,52.734,1],
29649=>[93.767,-79.698,52.725,1],
29650=>[93.774,-79.700,52.718,1],
29651=>[93.780,-79.702,52.710,1],
29652=>[93.787,-79.705,52.703,1],
29653=>[93.793,-79.708,52.697,1],
29654=>[93.800,-79.710,52.690,1],
29655=>[93.806,-79.713,52.683,1],
29656=>[93.813,-79.715,52.675,1],
29657=>[93.820,-79.717,52.668,1],
29658=>[93.826,-79.720,52.661,1],
29659=>[93.833,-79.723,52.653,1],
29660=>[93.840,-79.725,52.645,1],
29661=>[93.846,-79.727,52.638,1],
29662=>[93.855,-79.726,52.629,1],
29663=>[93.863,-79.724,52.621,1],
29664=>[93.872,-79.723,52.613,1],
29665=>[93.880,-79.721,52.604,1],
29666=>[93.889,-79.720,52.595,1],
29667=>[93.898,-79.719,52.586,1],
29668=>[93.906,-79.717,52.576,1],
29669=>[93.915,-79.716,52.566,1],
29670=>[93.923,-79.714,52.556,1],
29671=>[93.932,-79.713,52.545,1],
29672=>[93.940,-79.711,52.533,1],
29673=>[93.949,-79.710,52.521,1],
29674=>[93.958,-79.708,52.508,1],
29675=>[93.966,-79.707,52.495,1],
29676=>[93.975,-79.705,52.482,1],
29677=>[93.983,-79.704,52.469,1],
29678=>[93.992,-79.702,52.455,1],
29679=>[94.000,-79.701,52.442,1],
29680=>[94.009,-79.700,52.427,1],
29681=>[94.017,-79.698,52.411,1],
29682=>[94.026,-79.697,52.395,1],
29683=>[94.035,-79.695,52.379,1],
29684=>[94.043,-79.694,52.363,1],
29685=>[94.051,-79.692,52.347,1],
29686=>[94.060,-79.691,52.332,1],
29687=>[94.068,-79.689,52.315,1],
29688=>[94.077,-79.688,52.297,1],
29689=>[94.085,-79.686,52.280,1],
29690=>[94.094,-79.685,52.264,1],
29691=>[94.103,-79.683,52.247,1],
29692=>[94.111,-79.682,52.230,1],
29693=>[94.120,-79.681,52.214,1],
29694=>[94.128,-79.679,52.197,1],
29695=>[94.137,-79.678,52.179,1],
29696=>[94.145,-79.676,52.160,1],
29697=>[94.154,-79.664,52.142,1],
29698=>[94.163,-79.638,52.124,1],
29699=>[94.171,-79.612,52.107,1],
29700=>[94.180,-79.586,52.091,1],
29701=>[94.188,-79.560,52.072,1],
29702=>[94.197,-79.535,52.051,1],
29703=>[94.205,-79.509,52.032,1],
29704=>[94.214,-79.483,52.013,1],
29705=>[94.222,-79.457,51.994,1],
29706=>[94.231,-79.431,51.975,1],
29707=>[94.239,-79.405,51.957,1],
29708=>[94.247,-79.379,51.939,1],
29709=>[94.254,-79.352,51.920,1],
29710=>[94.262,-79.325,51.903,1],
29711=>[94.273,-79.305,51.885,1],
29712=>[94.289,-79.294,51.866,1],
29713=>[94.303,-79.286,51.847,1],
29714=>[94.311,-79.287,51.825,1],
29715=>[94.319,-79.287,51.801,1],
29716=>[94.327,-79.287,51.773,1],
29717=>[94.325,-79.296,51.746,1],
29718=>[94.321,-79.307,51.721,1],
29719=>[94.319,-79.310,51.697,1],
29720=>[94.321,-79.289,51.671,1],
29721=>[94.322,-79.268,51.645,1],
29722=>[94.324,-79.247,51.617,1],
29723=>[94.325,-79.226,51.587,1],
29724=>[94.316,-79.225,51.554,1],
29725=>[94.302,-79.231,51.519,1],
29726=>[94.310,-79.226,51.483,1],
29727=>[94.319,-79.222,51.449,1],
29728=>[94.328,-79.266,51.415,1],
29729=>[94.337,-79.309,51.382,1],
29730=>[94.346,-79.352,51.347,1],
29731=>[94.354,-79.395,51.311,1],
29732=>[94.363,-79.438,51.276,1],
29733=>[94.372,-79.482,51.241,1],
29734=>[94.381,-79.525,51.206,1],
29735=>[94.390,-79.569,51.170,1],
29736=>[94.398,-79.612,51.135,1],
29737=>[94.407,-79.655,51.098,1],
29738=>[94.416,-79.698,51.061,1],
30274=>[92.552,-80.327,53.528,1],
30275=>[92.565,-80.315,53.507,1],
30276=>[92.580,-80.304,53.485,1],
30277=>[92.596,-80.297,53.464,1],
30278=>[92.613,-80.288,53.442,1],
30279=>[92.629,-80.280,53.419,1],
30280=>[92.645,-80.272,53.396,1],
30281=>[92.661,-80.264,53.374,1],
30282=>[92.676,-80.256,53.351,1],
30283=>[92.693,-80.248,53.327,1],
30284=>[92.709,-80.240,53.304,1],
30285=>[92.725,-80.232,53.281,1],
30286=>[92.741,-80.224,53.258,1],
30287=>[92.757,-80.216,53.235,1],
30288=>[92.773,-80.208,53.213,1],
30289=>[92.789,-80.200,53.191,1],
30290=>[92.805,-80.192,53.169,1],
30291=>[92.821,-80.184,53.148,1],
30292=>[92.837,-80.176,53.127,1],
30293=>[92.853,-80.168,53.106,1],
30294=>[92.869,-80.159,53.086,1],
30295=>[92.885,-80.152,53.066,1],
30296=>[92.901,-80.143,53.047,1],
30297=>[92.917,-80.136,53.027,1],
30298=>[92.933,-80.127,53.009,1],
30299=>[92.949,-80.119,52.991,1],
30300=>[92.965,-80.112,52.975,1],
30301=>[92.981,-80.103,52.960,1],
30302=>[92.999,-80.095,52.946,1],
30303=>[93.015,-80.088,52.935,1],
30304=>[93.029,-80.075,52.923,1],
30305=>[93.043,-80.062,52.911,1],
30306=>[93.059,-80.050,52.900,1],
30307=>[93.083,-80.040,52.890,1],
30308=>[93.108,-80.030,52.880,1],
30309=>[93.132,-80.020,52.871,1],
30310=>[93.157,-80.009,52.863,1],
30311=>[93.182,-79.999,52.855,1],
30312=>[93.200,-79.990,52.848,1],
30313=>[93.211,-79.983,52.841,1],
30314=>[93.222,-79.975,52.835,1],
30315=>[93.233,-79.968,52.829,1],
30316=>[93.246,-79.960,52.822,1],
30317=>[93.259,-79.953,52.816,1],
30318=>[93.272,-79.946,52.811,1],
30319=>[93.285,-79.938,52.808,1],
30320=>[93.297,-79.931,52.807,1],
30321=>[93.310,-79.924,52.808,1],
30322=>[93.325,-79.914,52.810,1],
30323=>[93.363,-79.918,52.812,1],
30324=>[93.413,-79.929,52.814,1],
30325=>[93.445,-79.914,52.816,1],
30326=>[93.471,-79.883,52.818,1],
30327=>[93.496,-79.853,52.820,1],
30328=>[93.514,-79.837,52.821,1],
30329=>[93.527,-79.831,52.823,1],
30330=>[93.541,-79.825,52.827,1],
30331=>[93.554,-79.819,52.829,1],
30332=>[93.567,-79.813,52.830,1],
30333=>[93.580,-79.807,52.829,1],
30334=>[93.592,-79.799,52.829,1],
30335=>[93.602,-79.789,52.829,1],
30336=>[93.612,-79.779,52.829,1],
30337=>[93.622,-79.769,52.825,1],
30338=>[93.632,-79.759,52.820,1],
30339=>[93.641,-79.749,52.815,1],
30340=>[93.651,-79.739,52.807,1],
30341=>[93.661,-79.729,52.800,1],
30342=>[93.671,-79.719,52.794,1],
30343=>[93.681,-79.709,52.788,1],
30344=>[93.691,-79.699,52.779,1],
30345=>[93.702,-79.690,52.769,1],
30346=>[93.717,-79.683,52.758,1],
30347=>[93.732,-79.677,52.746,1],
30348=>[93.748,-79.670,52.736,1],
30349=>[93.763,-79.664,52.727,1],
30350=>[93.778,-79.657,52.720,1],
30351=>[93.787,-79.657,52.713,1],
30352=>[93.793,-79.661,52.705,1],
30353=>[93.800,-79.663,52.698,1],
30354=>[93.806,-79.665,52.692,1],
30355=>[93.813,-79.668,52.685,1],
30356=>[93.820,-79.670,52.678,1],
30357=>[93.826,-79.673,52.671,1],
30358=>[93.833,-79.675,52.664,1],
30359=>[93.840,-79.678,52.657,1],
30360=>[93.846,-79.680,52.650,1],
30361=>[93.853,-79.683,52.641,1],
30362=>[93.859,-79.686,52.634,1],
30363=>[93.866,-79.688,52.626,1],
30364=>[93.872,-79.690,52.618,1],
30365=>[93.879,-79.692,52.610,1],
30366=>[93.886,-79.695,52.601,1],
30367=>[93.892,-79.698,52.591,1],
30368=>[93.899,-79.700,52.582,1],
30369=>[93.905,-79.703,52.573,1],
30370=>[93.914,-79.701,52.562,1],
30371=>[93.922,-79.700,52.552,1],
30372=>[93.931,-79.698,52.541,1],
30373=>[93.939,-79.697,52.530,1],
30374=>[93.948,-79.695,52.517,1],
30375=>[93.957,-79.694,52.505,1],
30376=>[93.965,-79.692,52.491,1],
30377=>[93.974,-79.691,52.478,1],
30378=>[93.982,-79.689,52.465,1],
30379=>[93.991,-79.688,52.452,1],
30380=>[93.999,-79.687,52.437,1],
30381=>[94.008,-79.686,52.423,1],
30382=>[94.016,-79.684,52.408,1],
30383=>[94.025,-79.683,52.392,1],
30384=>[94.034,-79.681,52.376,1],
30385=>[94.042,-79.679,52.360,1],
30386=>[94.051,-79.678,52.344,1],
30387=>[94.059,-79.676,52.329,1],
30388=>[94.068,-79.675,52.312,1],
30389=>[94.076,-79.673,52.295,1],
30390=>[94.085,-79.672,52.279,1],
30391=>[94.094,-79.670,52.262,1],
30392=>[94.102,-79.669,52.245,1],
30393=>[94.111,-79.668,52.229,1],
30394=>[94.119,-79.667,52.213,1],
30395=>[94.128,-79.665,52.195,1],
30396=>[94.136,-79.664,52.177,1],
30397=>[94.145,-79.662,52.159,1],
30398=>[94.153,-79.651,52.141,1],
30399=>[94.162,-79.625,52.123,1],
30400=>[94.171,-79.599,52.106,1],
30401=>[94.179,-79.573,52.088,1],
30402=>[94.187,-79.547,52.069,1],
30403=>[94.196,-79.521,52.049,1],
30404=>[94.204,-79.495,52.030,1],
30405=>[94.213,-79.469,52.011,1],
30406=>[94.221,-79.443,51.992,1],
30407=>[94.228,-79.416,51.974,1],
30408=>[94.237,-79.390,51.957,1],
30409=>[94.245,-79.363,51.939,1],
30410=>[94.252,-79.338,51.920,1],
30411=>[94.260,-79.311,51.902,1],
30412=>[94.274,-79.295,51.884,1],
30413=>[94.289,-79.285,51.866,1],
30414=>[94.306,-79.275,51.848,1],
30415=>[94.314,-79.273,51.827,1],
30416=>[94.322,-79.273,51.803,1],
30417=>[94.326,-79.278,51.775,1],
30418=>[94.322,-79.288,51.749,1],
30419=>[94.319,-79.300,51.724,1],
30420=>[94.316,-79.308,51.700,1],
30421=>[94.317,-79.288,51.675,1],
30422=>[94.319,-79.266,51.649,1],
30423=>[94.320,-79.245,51.621,1],
30424=>[94.321,-79.225,51.592,1],
30425=>[94.308,-79.231,51.559,1],
30426=>[94.294,-79.237,51.525,1],
30427=>[94.298,-79.234,51.489,1],
30428=>[94.308,-79.228,51.456,1],
30429=>[94.317,-79.244,51.422,1],
30430=>[94.326,-79.287,51.388,1],
30431=>[94.335,-79.330,51.354,1],
30432=>[94.343,-79.373,51.319,1],
30433=>[94.352,-79.416,51.284,1],
30434=>[94.361,-79.460,51.249,1],
30435=>[94.370,-79.503,51.213,1],
30436=>[94.379,-79.546,51.177,1],
30437=>[94.388,-79.589,51.142,1],
30438=>[94.396,-79.632,51.105,1],
30439=>[94.405,-79.676,51.068,1],
30440=>[94.414,-79.719,51.030,1],
30441=>[94.423,-79.762,50.993,1],
30977=>[92.578,-80.292,53.510,1],
30978=>[92.592,-80.280,53.489,1],
30979=>[92.609,-80.272,53.467,1],
30980=>[92.625,-80.263,53.444,1],
30981=>[92.641,-80.255,53.421,1],
30982=>[92.656,-80.247,53.398,1],
30983=>[92.672,-80.239,53.375,1],
30984=>[92.689,-80.231,53.351,1],
30985=>[92.705,-80.223,53.328,1],
30986=>[92.721,-80.215,53.304,1],
30987=>[92.737,-80.207,53.281,1],
30988=>[92.753,-80.199,53.257,1],
30989=>[92.769,-80.191,53.234,1],
30990=>[92.785,-80.183,53.211,1],
30991=>[92.801,-80.174,53.188,1],
30992=>[92.817,-80.167,53.166,1],
30993=>[92.833,-80.159,53.144,1],
30994=>[92.849,-80.151,53.122,1],
30995=>[92.865,-80.143,53.101,1],
30996=>[92.881,-80.134,53.081,1],
30997=>[92.897,-80.127,53.061,1],
30998=>[92.913,-80.118,53.040,1],
30999=>[92.929,-80.111,53.021,1],
31000=>[92.945,-80.102,53.003,1],
31001=>[92.961,-80.094,52.986,1],
31002=>[92.977,-80.087,52.970,1],
31003=>[92.993,-80.078,52.955,1],
31004=>[93.009,-80.071,52.942,1],
31005=>[93.023,-80.062,52.928,1],
31006=>[93.044,-80.052,52.916,1],
31007=>[93.064,-80.041,52.904,1],
31008=>[93.085,-80.030,52.893,1],
31009=>[93.106,-80.020,52.883,1],
31010=>[93.126,-80.009,52.874,1],
31011=>[93.147,-79.999,52.864,1],
31012=>[93.167,-79.988,52.855,1],
31013=>[93.188,-79.977,52.847,1],
31014=>[93.213,-79.968,52.841,1],
31015=>[93.231,-79.960,52.834,1],
31016=>[93.243,-79.952,52.828,1],
31017=>[93.256,-79.945,52.822,1],
31018=>[93.269,-79.937,52.817,1],
31019=>[93.281,-79.930,52.813,1],
31020=>[93.295,-79.922,52.811,1],
31021=>[93.308,-79.914,52.810,1],
31022=>[93.322,-79.906,52.811,1],
31023=>[93.335,-79.898,52.811,1],
31024=>[93.359,-79.895,52.811,1],
31025=>[93.406,-79.902,52.813,1],
31026=>[93.442,-79.889,52.814,1],
31027=>[93.478,-79.874,52.815,1],
31028=>[93.503,-79.843,52.817,1],
31029=>[93.523,-79.823,52.818,1],
31030=>[93.537,-79.817,52.820,1],
31031=>[93.550,-79.811,52.822,1],
31032=>[93.561,-79.803,52.825,1],
31033=>[93.571,-79.793,52.827,1],
31034=>[93.581,-79.783,52.827,1],
31035=>[93.591,-79.773,52.824,1],
31036=>[93.601,-79.763,52.823,1],
31037=>[93.611,-79.753,52.821,1],
31038=>[93.621,-79.743,52.817,1],
31039=>[93.631,-79.733,52.813,1],
31040=>[93.640,-79.723,52.809,1],
31041=>[93.650,-79.713,52.802,1],
31042=>[93.660,-79.703,52.796,1],
31043=>[93.670,-79.693,52.790,1],
31044=>[93.680,-79.683,52.782,1],
31045=>[93.690,-79.673,52.773,1],
31046=>[93.700,-79.664,52.763,1],
31047=>[93.715,-79.657,52.751,1],
31048=>[93.730,-79.651,52.740,1],
31049=>[93.746,-79.644,52.730,1],
31050=>[93.761,-79.638,52.721,1],
31051=>[93.776,-79.631,52.713,1],
31052=>[93.791,-79.625,52.707,1],
31053=>[93.806,-79.618,52.700,1],
31054=>[93.813,-79.620,52.693,1],
31055=>[93.820,-79.623,52.687,1],
31056=>[93.826,-79.626,52.680,1],
31057=>[93.833,-79.628,52.673,1],
31058=>[93.840,-79.630,52.667,1],
31059=>[93.846,-79.633,52.660,1],
31060=>[93.853,-79.636,52.653,1],
31061=>[93.859,-79.638,52.646,1],
31062=>[93.866,-79.640,52.638,1],
31063=>[93.872,-79.643,52.630,1],
31064=>[93.879,-79.645,52.623,1],
31065=>[93.886,-79.648,52.615,1],
31066=>[93.892,-79.651,52.607,1],
31067=>[93.899,-79.653,52.598,1],
31068=>[93.905,-79.655,52.588,1],
31069=>[93.912,-79.657,52.578,1],
31070=>[93.918,-79.661,52.569,1],
31071=>[93.925,-79.663,52.558,1],
31072=>[93.931,-79.665,52.547,1],
31073=>[93.938,-79.668,52.537,1],
31074=>[93.944,-79.670,52.526,1],
31075=>[93.951,-79.673,52.513,1],
31076=>[93.958,-79.675,52.501,1],
31077=>[93.965,-79.678,52.488,1],
31078=>[93.973,-79.676,52.475,1],
31079=>[93.981,-79.675,52.462,1],
31080=>[93.990,-79.674,52.448,1],
31081=>[93.998,-79.673,52.434,1],
31082=>[94.007,-79.671,52.419,1],
31083=>[94.015,-79.670,52.404,1],
31084=>[94.024,-79.668,52.388,1],
31085=>[94.033,-79.667,52.373,1],
31086=>[94.041,-79.665,52.357,1],
31087=>[94.050,-79.664,52.342,1],
31088=>[94.058,-79.662,52.327,1],
31089=>[94.067,-79.661,52.310,1],
31090=>[94.075,-79.659,52.293,1],
31091=>[94.084,-79.657,52.277,1],
31092=>[94.092,-79.656,52.259,1],
31093=>[94.101,-79.655,52.243,1],
31094=>[94.110,-79.654,52.227,1],
31095=>[94.118,-79.652,52.211,1],
31096=>[94.127,-79.651,52.193,1],
31097=>[94.135,-79.649,52.175,1],
31098=>[94.144,-79.648,52.157,1],
31099=>[94.152,-79.637,52.140,1],
31100=>[94.161,-79.611,52.122,1],
31101=>[94.170,-79.585,52.105,1],
31102=>[94.178,-79.560,52.087,1],
31103=>[94.187,-79.534,52.068,1],
31104=>[94.195,-79.508,52.048,1],
31105=>[94.203,-79.482,52.029,1],
31106=>[94.211,-79.455,52.010,1],
31107=>[94.219,-79.429,51.991,1],
31108=>[94.226,-79.402,51.974,1],
31109=>[94.235,-79.375,51.958,1],
31110=>[94.242,-79.349,51.940,1],
31111=>[94.250,-79.322,51.922,1],
31112=>[94.258,-79.297,51.904,1],
31113=>[94.274,-79.286,51.886,1],
31114=>[94.290,-79.275,51.868,1],
31115=>[94.306,-79.265,51.850,1],
31116=>[94.318,-79.260,51.829,1],
31117=>[94.325,-79.260,51.805,1],
31118=>[94.323,-79.270,51.779,1],
31119=>[94.320,-79.281,51.754,1],
31120=>[94.316,-79.292,51.729,1],
31121=>[94.313,-79.303,51.706,1],
31122=>[94.314,-79.285,51.682,1],
31123=>[94.315,-79.265,51.657,1],
31124=>[94.317,-79.244,51.630,1],
31125=>[94.314,-79.231,51.599,1],
31126=>[94.300,-79.237,51.567,1],
31127=>[94.287,-79.243,51.533,1],
31128=>[94.286,-79.242,51.497,1],
31129=>[94.296,-79.235,51.463,1],
31130=>[94.306,-79.228,51.430,1],
31131=>[94.315,-79.264,51.397,1],
31132=>[94.324,-79.307,51.362,1],
31133=>[94.333,-79.350,51.328,1],
31134=>[94.341,-79.394,51.293,1],
31135=>[94.350,-79.438,51.256,1],
31136=>[94.359,-79.481,51.220,1],
31137=>[94.368,-79.524,51.185,1],
31138=>[94.377,-79.567,51.149,1],
31139=>[94.386,-79.610,51.112,1],
31140=>[94.394,-79.654,51.074,1],
31141=>[94.403,-79.697,51.037,1],
31142=>[94.412,-79.740,50.999,1],
31143=>[94.424,-79.760,50.962,1],
31680=>[92.605,-80.257,53.492,1],
31681=>[92.621,-80.247,53.469,1],
31682=>[92.636,-80.238,53.447,1],
31683=>[92.652,-80.231,53.424,1],
31684=>[92.668,-80.222,53.401,1],
31685=>[92.685,-80.214,53.377,1],
31686=>[92.701,-80.206,53.351,1],
31687=>[92.717,-80.198,53.327,1],
31688=>[92.732,-80.190,53.304,1],
31689=>[92.748,-80.182,53.279,1],
31690=>[92.765,-80.174,53.255,1],
31691=>[92.781,-80.166,53.232,1],
31692=>[92.797,-80.158,53.208,1],
31693=>[92.813,-80.149,53.185,1],
31694=>[92.829,-80.142,53.162,1],
31695=>[92.845,-80.134,53.140,1],
31696=>[92.861,-80.126,53.118,1],
31697=>[92.877,-80.118,53.097,1],
31698=>[92.893,-80.109,53.076,1],
31699=>[92.909,-80.102,53.055,1],
31700=>[92.925,-80.093,53.035,1],
31701=>[92.941,-80.086,53.017,1],
31702=>[92.957,-80.077,52.998,1],
31703=>[92.973,-80.069,52.981,1],
31704=>[92.989,-80.062,52.965,1],
31705=>[93.005,-80.053,52.949,1],
31706=>[93.021,-80.046,52.934,1],
31707=>[93.036,-80.036,52.920,1],
31708=>[93.047,-80.030,52.908,1],
31709=>[93.068,-80.019,52.895,1],
31710=>[93.088,-80.008,52.885,1],
31711=>[93.109,-79.998,52.876,1],
31712=>[93.129,-79.987,52.866,1],
31713=>[93.150,-79.977,52.856,1],
31714=>[93.170,-79.966,52.847,1],
31715=>[93.194,-79.956,52.840,1],
31716=>[93.219,-79.947,52.834,1],
31717=>[93.241,-79.938,52.828,1],
31718=>[93.256,-79.930,52.823,1],
31719=>[93.271,-79.921,52.820,1],
31720=>[93.286,-79.913,52.817,1],
31721=>[93.301,-79.905,52.814,1],
31722=>[93.315,-79.896,52.814,1],
31723=>[93.330,-79.888,52.813,1],
31724=>[93.345,-79.880,52.812,1],
31725=>[93.360,-79.871,52.812,1],
31726=>[93.393,-79.859,52.813,1],
31727=>[93.428,-79.846,52.813,1],
31728=>[93.465,-79.833,52.814,1],
31729=>[93.500,-79.820,52.815,1],
31730=>[93.531,-79.807,52.817,1],
31731=>[93.541,-79.797,52.818,1],
31732=>[93.550,-79.787,52.819,1],
31733=>[93.560,-79.777,52.821,1],
31734=>[93.570,-79.767,52.823,1],
31735=>[93.580,-79.757,52.823,1],
31736=>[93.590,-79.747,52.820,1],
31737=>[93.600,-79.737,52.817,1],
31738=>[93.610,-79.727,52.813,1],
31739=>[93.620,-79.717,52.810,1],
31740=>[93.630,-79.707,52.806,1],
31741=>[93.640,-79.697,52.802,1],
31742=>[93.649,-79.687,52.797,1],
31743=>[93.659,-79.677,52.790,1],
31744=>[93.670,-79.667,52.783,1],
31745=>[93.679,-79.657,52.776,1],
31746=>[93.689,-79.647,52.765,1],
31747=>[93.699,-79.637,52.754,1],
31748=>[93.713,-79.630,52.742,1],
31749=>[93.728,-79.624,52.733,1],
31750=>[93.744,-79.617,52.723,1],
31751=>[93.759,-79.611,52.714,1],
31752=>[93.774,-79.604,52.707,1],
31753=>[93.789,-79.598,52.700,1],
31754=>[93.804,-79.592,52.693,1],
31755=>[93.820,-79.585,52.688,1],
31756=>[93.833,-79.581,52.682,1],
31757=>[93.840,-79.583,52.676,1],
31758=>[93.846,-79.585,52.669,1],
31759=>[93.853,-79.588,52.663,1],
31760=>[93.859,-79.591,52.657,1],
31761=>[93.866,-79.593,52.649,1],
31762=>[93.872,-79.595,52.642,1],
31763=>[93.879,-79.598,52.635,1],
31764=>[93.886,-79.601,52.627,1],
31765=>[93.892,-79.603,52.620,1],
31766=>[93.899,-79.606,52.612,1],
31767=>[93.905,-79.608,52.604,1],
31768=>[93.912,-79.610,52.595,1],
31769=>[93.918,-79.613,52.585,1],
31770=>[93.925,-79.616,52.575,1],
31771=>[93.931,-79.618,52.565,1],
31772=>[93.938,-79.620,52.554,1],
31773=>[93.944,-79.623,52.544,1],
31774=>[93.951,-79.626,52.533,1],
31775=>[93.958,-79.628,52.522,1],
31776=>[93.965,-79.630,52.509,1],
31777=>[93.971,-79.633,52.497,1],
31778=>[93.978,-79.636,52.485,1],
31779=>[93.984,-79.638,52.471,1],
31780=>[93.991,-79.641,52.458,1],
31781=>[93.997,-79.643,52.444,1],
31782=>[94.004,-79.645,52.431,1],
31783=>[94.010,-79.648,52.416,1],
31784=>[94.017,-79.651,52.401,1],
31785=>[94.024,-79.653,52.386,1],
31786=>[94.032,-79.652,52.370,1],
31787=>[94.040,-79.651,52.354,1],
31788=>[94.049,-79.649,52.339,1],
31789=>[94.057,-79.648,52.324,1],
31790=>[94.066,-79.646,52.308,1],
31791=>[94.074,-79.645,52.291,1],
31792=>[94.083,-79.643,52.274,1],
31793=>[94.091,-79.642,52.257,1],
31794=>[94.100,-79.641,52.241,1],
31795=>[94.109,-79.639,52.225,1],
31796=>[94.117,-79.638,52.209,1],
31797=>[94.126,-79.636,52.192,1],
31798=>[94.134,-79.635,52.174,1],
31799=>[94.143,-79.633,52.156,1],
31800=>[94.151,-79.624,52.139,1],
31801=>[94.160,-79.598,52.122,1],
31802=>[94.169,-79.572,52.104,1],
31803=>[94.177,-79.546,52.086,1],
31804=>[94.185,-79.520,52.067,1],
31805=>[94.193,-79.494,52.047,1],
31806=>[94.201,-79.467,52.029,1],
31807=>[94.209,-79.441,52.010,1],
31808=>[94.217,-79.414,51.991,1],
31809=>[94.224,-79.388,51.975,1],
31810=>[94.232,-79.361,51.959,1],
31811=>[94.240,-79.335,51.943,1],
31812=>[94.248,-79.308,51.925,1],
31813=>[94.259,-79.287,51.906,1],
31814=>[94.274,-79.276,51.888,1],
31815=>[94.290,-79.266,51.870,1],
31816=>[94.307,-79.256,51.851,1],
31817=>[94.321,-79.247,51.830,1],
31818=>[94.324,-79.251,51.808,1],
31819=>[94.321,-79.263,51.784,1],
31820=>[94.317,-79.273,51.760,1],
31821=>[94.314,-79.285,51.736,1],
31822=>[94.310,-79.296,51.713,1],
31823=>[94.310,-79.284,51.690,1],
31824=>[94.312,-79.263,51.665,1],
31825=>[94.314,-79.242,51.639,1],
31826=>[94.306,-79.237,51.608,1],
31827=>[94.293,-79.243,51.575,1],
31828=>[94.279,-79.249,51.542,1],
31829=>[94.275,-79.250,51.507,1],
31830=>[94.285,-79.244,51.472,1],
31831=>[94.294,-79.237,51.439,1],
31832=>[94.304,-79.242,51.407,1],
31833=>[94.313,-79.285,51.372,1],
31834=>[94.322,-79.328,51.337,1],
31835=>[94.331,-79.372,51.302,1],
31836=>[94.339,-79.415,51.265,1],
31837=>[94.348,-79.458,51.229,1],
31838=>[94.357,-79.501,51.193,1],
31839=>[94.366,-79.545,51.157,1],
31840=>[94.374,-79.588,51.119,1],
31841=>[94.384,-79.631,51.082,1],
31842=>[94.392,-79.674,51.044,1],
31843=>[94.403,-79.708,51.006,1],
31844=>[94.416,-79.720,50.968,1],
31845=>[94.429,-79.734,50.931,1],
31846=>[94.442,-79.747,50.894,1],
32383=>[92.633,-80.222,53.472,1],
32384=>[92.648,-80.213,53.448,1],
32385=>[92.664,-80.206,53.425,1],
32386=>[92.681,-80.197,53.400,1],
32387=>[92.697,-80.189,53.376,1],
32388=>[92.712,-80.181,53.352,1],
32389=>[92.728,-80.173,53.327,1],
32390=>[92.744,-80.165,53.303,1],
32391=>[92.761,-80.157,53.278,1],
32392=>[92.777,-80.149,53.254,1],
32393=>[92.793,-80.141,53.229,1],
32394=>[92.808,-80.133,53.205,1],
32395=>[92.825,-80.124,53.182,1],
32396=>[92.841,-80.117,53.160,1],
32397=>[92.857,-80.109,53.137,1],
32398=>[92.873,-80.101,53.115,1],
32399=>[92.889,-80.093,53.093,1],
32400=>[92.905,-80.084,53.071,1],
32401=>[92.921,-80.077,53.051,1],
32402=>[92.937,-80.068,53.031,1],
32403=>[92.953,-80.061,53.012,1],
32404=>[92.969,-80.052,52.993,1],
32405=>[92.985,-80.044,52.975,1],
32406=>[93.001,-80.037,52.959,1],
32407=>[93.017,-80.028,52.942,1],
32408=>[93.033,-80.021,52.927,1],
32409=>[93.049,-80.008,52.913,1],
32410=>[93.056,-80.005,52.900,1],
32411=>[93.071,-79.997,52.889,1],
32412=>[93.091,-79.987,52.878,1],
32413=>[93.112,-79.976,52.868,1],
32414=>[93.133,-79.965,52.859,1],
32415=>[93.153,-79.955,52.851,1],
32416=>[93.174,-79.944,52.842,1],
32417=>[93.199,-79.935,52.836,1],
32418=>[93.222,-79.926,52.831,1],
32419=>[93.237,-79.918,52.826,1],
32420=>[93.252,-79.909,52.824,1],
32421=>[93.267,-79.901,52.821,1],
32422=>[93.282,-79.892,52.819,1],
32423=>[93.296,-79.884,52.818,1],
32424=>[93.311,-79.876,52.817,1],
32425=>[93.330,-79.867,52.815,1],
32426=>[93.353,-79.857,52.814,1],
32427=>[93.379,-79.846,52.814,1],
32428=>[93.415,-79.834,52.814,1],
32429=>[93.451,-79.821,52.815,1],
32430=>[93.487,-79.808,52.816,1],
32431=>[93.519,-79.795,52.817,1],
32432=>[93.534,-79.778,52.818,1],
32433=>[93.549,-79.762,52.817,1],
32434=>[93.559,-79.751,52.818,1],
32435=>[93.569,-79.741,52.818,1],
32436=>[93.579,-79.731,52.818,1],
32437=>[93.589,-79.721,52.815,1],
32438=>[93.599,-79.711,52.811,1],
32439=>[93.609,-79.701,52.807,1],
32440=>[93.619,-79.691,52.803,1],
32441=>[93.629,-79.681,52.799,1],
32442=>[93.639,-79.671,52.795,1],
32443=>[93.648,-79.661,52.789,1],
32444=>[93.658,-79.651,52.782,1],
32445=>[93.669,-79.642,52.774,1],
32446=>[93.679,-79.631,52.767,1],
32447=>[93.688,-79.621,52.756,1],
32448=>[93.698,-79.611,52.745,1],
32449=>[93.712,-79.604,52.733,1],
32450=>[93.727,-79.597,52.724,1],
32451=>[93.742,-79.591,52.715,1],
32452=>[93.757,-79.585,52.708,1],
32453=>[93.772,-79.578,52.701,1],
32454=>[93.787,-79.572,52.694,1],
32455=>[93.802,-79.565,52.688,1],
32456=>[93.818,-79.559,52.683,1],
32457=>[93.833,-79.552,52.678,1],
32458=>[93.848,-79.546,52.672,1],
32459=>[93.859,-79.544,52.665,1],
32460=>[93.866,-79.546,52.660,1],
32461=>[93.872,-79.548,52.653,1],
32462=>[93.879,-79.551,52.646,1],
32463=>[93.886,-79.554,52.640,1],
32464=>[93.892,-79.556,52.632,1],
32465=>[93.899,-79.558,52.625,1],
32466=>[93.905,-79.561,52.617,1],
32467=>[93.912,-79.563,52.610,1],
32468=>[93.918,-79.566,52.601,1],
32469=>[93.925,-79.568,52.592,1],
32470=>[93.931,-79.571,52.582,1],
32471=>[93.938,-79.573,52.572,1],
32472=>[93.944,-79.576,52.562,1],
32473=>[93.951,-79.579,52.552,1],
32474=>[93.958,-79.581,52.541,1],
32475=>[93.965,-79.583,52.530,1],
32476=>[93.971,-79.585,52.518,1],
32477=>[93.978,-79.588,52.506,1],
32478=>[93.984,-79.591,52.493,1],
32479=>[93.991,-79.593,52.480,1],
32480=>[93.997,-79.596,52.467,1],
32481=>[94.004,-79.598,52.454,1],
32482=>[94.010,-79.601,52.440,1],
32483=>[94.017,-79.603,52.427,1],
32484=>[94.024,-79.606,52.412,1],
32485=>[94.030,-79.608,52.397,1],
32486=>[94.037,-79.610,52.383,1],
32487=>[94.043,-79.614,52.367,1],
32488=>[94.050,-79.616,52.352,1],
32489=>[94.056,-79.618,52.336,1],
32490=>[94.063,-79.620,52.321,1],
32491=>[94.069,-79.623,52.305,1],
32492=>[94.076,-79.626,52.288,1],
32493=>[94.083,-79.628,52.272,1],
32494=>[94.091,-79.628,52.255,1],
32495=>[94.100,-79.626,52.239,1],
32496=>[94.108,-79.625,52.223,1],
32497=>[94.117,-79.623,52.208,1],
32498=>[94.125,-79.622,52.191,1],
32499=>[94.134,-79.620,52.174,1],
32500=>[94.142,-79.619,52.156,1],
32501=>[94.150,-79.610,52.140,1],
32502=>[94.159,-79.585,52.124,1],
32503=>[94.168,-79.558,52.106,1],
32504=>[94.175,-79.532,52.087,1],
32505=>[94.183,-79.506,52.068,1],
32506=>[94.191,-79.479,52.048,1],
32507=>[94.199,-79.453,52.029,1],
32508=>[94.207,-79.426,52.010,1],
32509=>[94.214,-79.400,51.994,1],
32510=>[94.222,-79.373,51.978,1],
32511=>[94.230,-79.347,51.962,1],
32512=>[94.238,-79.320,51.946,1],
32513=>[94.246,-79.294,51.927,1],
32514=>[94.259,-79.278,51.908,1],
32515=>[94.275,-79.267,51.889,1],
32516=>[94.291,-79.256,51.871,1],
32517=>[94.307,-79.246,51.852,1],
32518=>[94.323,-79.235,51.832,1],
32519=>[94.322,-79.244,51.811,1],
32520=>[94.318,-79.255,51.789,1],
32521=>[94.315,-79.266,51.767,1],
32522=>[94.311,-79.277,51.744,1],
32523=>[94.308,-79.288,51.721,1],
32524=>[94.307,-79.282,51.698,1],
32525=>[94.309,-79.261,51.674,1],
32526=>[94.310,-79.240,51.648,1],
32527=>[94.298,-79.243,51.617,1],
32528=>[94.285,-79.249,51.585,1],
32529=>[94.272,-79.254,51.552,1],
32530=>[94.264,-79.258,51.518,1],
32531=>[94.273,-79.251,51.484,1],
32532=>[94.283,-79.244,51.450,1],
32533=>[94.293,-79.238,51.417,1],
32534=>[94.302,-79.263,51.382,1],
32535=>[94.311,-79.306,51.346,1],
32536=>[94.320,-79.350,51.311,1],
32537=>[94.329,-79.393,51.275,1],
32538=>[94.337,-79.436,51.239,1],
32539=>[94.346,-79.479,51.202,1],
32540=>[94.355,-79.523,51.165,1],
32541=>[94.364,-79.566,51.128,1],
32542=>[94.372,-79.609,51.090,1],
32543=>[94.382,-79.652,51.051,1],
32544=>[94.394,-79.668,51.013,1],
32545=>[94.407,-79.682,50.974,1],
32546=>[94.420,-79.695,50.937,1],
32547=>[94.433,-79.708,50.899,1],
32548=>[94.447,-79.720,50.861,1],
33085=>[92.646,-80.200,53.473,1],
33086=>[92.660,-80.188,53.449,1],
33087=>[92.676,-80.181,53.425,1],
33088=>[92.692,-80.172,53.400,1],
33089=>[92.708,-80.164,53.376,1],
33090=>[92.724,-80.156,53.351,1],
33091=>[92.740,-80.148,53.326,1],
33092=>[92.757,-80.140,53.301,1],
33093=>[92.773,-80.132,53.276,1],
33094=>[92.788,-80.124,53.252,1],
33095=>[92.804,-80.116,53.228,1],
33096=>[92.820,-80.108,53.204,1],
33097=>[92.837,-80.100,53.180,1],
33098=>[92.853,-80.092,53.157,1],
33099=>[92.869,-80.084,53.134,1],
33100=>[92.885,-80.076,53.111,1],
33101=>[92.901,-80.068,53.089,1],
33102=>[92.917,-80.059,53.068,1],
33103=>[92.933,-80.052,53.046,1],
33104=>[92.949,-80.043,53.026,1],
33105=>[92.965,-80.036,53.006,1],
33106=>[92.981,-80.027,52.987,1],
33107=>[92.997,-80.019,52.970,1],
33108=>[93.013,-80.012,52.952,1],
33109=>[93.029,-80.003,52.936,1],
33110=>[93.046,-79.994,52.920,1],
33111=>[93.063,-79.981,52.907,1],
33112=>[93.070,-79.977,52.893,1],
33113=>[93.076,-79.974,52.880,1],
33114=>[93.095,-79.965,52.871,1],
33115=>[93.116,-79.954,52.863,1],
33116=>[93.136,-79.943,52.854,1],
33117=>[93.156,-79.933,52.846,1],
33118=>[93.180,-79.923,52.840,1],
33119=>[93.203,-79.914,52.835,1],
33120=>[93.218,-79.905,52.831,1],
33121=>[93.233,-79.897,52.829,1],
33122=>[93.248,-79.889,52.827,1],
33123=>[93.263,-79.880,52.824,1],
33124=>[93.277,-79.872,52.823,1],
33125=>[93.301,-79.862,52.821,1],
33126=>[93.324,-79.852,52.819,1],
33127=>[93.347,-79.843,52.818,1],
33128=>[93.370,-79.833,52.818,1],
33129=>[93.402,-79.821,52.818,1],
33130=>[93.438,-79.808,52.818,1],
33131=>[93.474,-79.795,52.819,1],
33132=>[93.506,-79.783,52.819,1],
33133=>[93.521,-79.766,52.819,1],
33134=>[93.537,-79.750,52.817,1],
33135=>[93.551,-79.734,52.815,1],
33136=>[93.566,-79.718,52.814,1],
33137=>[93.578,-79.705,52.812,1],
33138=>[93.588,-79.695,52.809,1],
33139=>[93.598,-79.686,52.805,1],
33140=>[93.608,-79.675,52.801,1],
33141=>[93.618,-79.665,52.796,1],
33142=>[93.628,-79.655,52.791,1],
33143=>[93.638,-79.645,52.786,1],
33144=>[93.648,-79.636,52.779,1],
33145=>[93.657,-79.625,52.772,1],
33146=>[93.667,-79.615,52.764,1],
33147=>[93.678,-79.605,52.756,1],
33148=>[93.687,-79.595,52.746,1],
33149=>[93.697,-79.585,52.736,1],
33150=>[93.710,-79.577,52.725,1],
33151=>[93.725,-79.570,52.716,1],
33152=>[93.740,-79.564,52.708,1],
33153=>[93.755,-79.557,52.701,1],
33154=>[93.770,-79.551,52.694,1],
33155=>[93.785,-79.545,52.688,1],
33156=>[93.800,-79.538,52.682,1],
33157=>[93.816,-79.532,52.678,1],
33158=>[93.831,-79.526,52.672,1],
33159=>[93.846,-79.520,52.667,1],
33160=>[93.861,-79.513,52.661,1],
33161=>[93.876,-79.507,52.656,1],
33162=>[93.886,-79.506,52.649,1],
33163=>[93.892,-79.509,52.642,1],
33164=>[93.899,-79.511,52.636,1],
33165=>[93.905,-79.513,52.629,1],
33166=>[93.912,-79.516,52.622,1],
33167=>[93.918,-79.519,52.614,1],
33168=>[93.925,-79.521,52.606,1],
33169=>[93.931,-79.523,52.598,1],
33170=>[93.938,-79.526,52.590,1],
33171=>[93.944,-79.529,52.580,1],
33172=>[93.951,-79.531,52.570,1],
33173=>[93.958,-79.533,52.559,1],
33174=>[93.965,-79.536,52.548,1],
33175=>[93.971,-79.538,52.537,1],
33176=>[93.978,-79.541,52.525,1],
33177=>[93.984,-79.544,52.514,1],
33178=>[93.991,-79.546,52.501,1],
33179=>[93.997,-79.548,52.488,1],
33180=>[94.004,-79.551,52.475,1],
33181=>[94.010,-79.554,52.463,1],
33182=>[94.017,-79.556,52.450,1],
33183=>[94.024,-79.558,52.436,1],
33184=>[94.030,-79.561,52.423,1],
33185=>[94.037,-79.563,52.408,1],
33186=>[94.043,-79.566,52.393,1],
33187=>[94.050,-79.569,52.379,1],
33188=>[94.056,-79.571,52.364,1],
33189=>[94.063,-79.573,52.349,1],
33190=>[94.069,-79.576,52.333,1],
33191=>[94.076,-79.579,52.319,1],
33192=>[94.082,-79.581,52.302,1],
33193=>[94.089,-79.583,52.285,1],
33194=>[94.096,-79.585,52.269,1],
33195=>[94.103,-79.588,52.253,1],
33196=>[94.109,-79.591,52.237,1],
33197=>[94.116,-79.593,52.222,1],
33198=>[94.122,-79.596,52.206,1],
33199=>[94.129,-79.598,52.190,1],
33200=>[94.135,-79.601,52.174,1],
33201=>[94.142,-79.604,52.158,1],
33202=>[94.150,-79.597,52.142,1],
33203=>[94.157,-79.570,52.125,1],
33204=>[94.166,-79.544,52.107,1],
33205=>[94.173,-79.517,52.089,1],
33206=>[94.181,-79.491,52.070,1],
33207=>[94.189,-79.464,52.050,1],
33208=>[94.197,-79.438,52.030,1],
33209=>[94.205,-79.412,52.012,1],
33210=>[94.212,-79.385,51.996,1],
33211=>[94.220,-79.359,51.980,1],
33212=>[94.228,-79.332,51.965,1],
33213=>[94.236,-79.306,51.949,1],
33214=>[94.244,-79.279,51.930,1],
33215=>[94.260,-79.268,51.910,1],
33216=>[94.275,-79.257,51.890,1],
33217=>[94.291,-79.247,51.870,1],
33218=>[94.300,-79.244,51.851,1],
33219=>[94.308,-79.242,51.832,1],
33220=>[94.317,-79.239,51.814,1],
33221=>[94.316,-79.247,51.794,1],
33222=>[94.312,-79.258,51.774,1],
33223=>[94.309,-79.269,51.753,1],
33224=>[94.305,-79.281,51.730,1],
33225=>[94.303,-79.280,51.707,1],
33226=>[94.305,-79.259,51.684,1],
33227=>[94.305,-79.242,51.660,1],
33228=>[94.291,-79.248,51.630,1],
33229=>[94.277,-79.254,51.599,1],
33230=>[94.264,-79.260,51.566,1],
33231=>[94.252,-79.266,51.533,1],
33232=>[94.262,-79.259,51.498,1],
33233=>[94.272,-79.253,51.464,1],
33234=>[94.281,-79.246,51.430,1],
33235=>[94.291,-79.241,51.393,1],
33236=>[94.300,-79.284,51.357,1],
33237=>[94.309,-79.327,51.321,1],
33238=>[94.318,-79.370,51.284,1],
33239=>[94.327,-79.413,51.249,1],
33240=>[94.335,-79.457,51.213,1],
33241=>[94.344,-79.500,51.176,1],
33242=>[94.353,-79.543,51.137,1],
33243=>[94.362,-79.586,51.099,1],
33244=>[94.372,-79.616,51.059,1],
33245=>[94.386,-79.629,51.020,1],
33246=>[94.399,-79.642,50.981,1],
33247=>[94.412,-79.655,50.943,1],
33248=>[94.425,-79.668,50.905,1],
33249=>[94.438,-79.681,50.867,1],
33788=>[92.673,-80.165,53.450,1],
33789=>[92.688,-80.156,53.425,1],
33790=>[92.704,-80.147,53.400,1],
33791=>[92.720,-80.139,53.375,1],
33792=>[92.736,-80.131,53.350,1],
33793=>[92.753,-80.123,53.325,1],
33794=>[92.768,-80.115,53.299,1],
33795=>[92.784,-80.107,53.275,1],
33796=>[92.800,-80.099,53.251,1],
33797=>[92.816,-80.091,53.226,1],
33798=>[92.833,-80.083,53.202,1],
33799=>[92.849,-80.075,53.178,1],
33800=>[92.865,-80.067,53.154,1],
33801=>[92.880,-80.059,53.130,1],
33802=>[92.897,-80.051,53.107,1],
33803=>[92.913,-80.043,53.085,1],
33804=>[92.929,-80.035,53.064,1],
33805=>[92.945,-80.027,53.043,1],
33806=>[92.961,-80.018,53.022,1],
33807=>[92.977,-80.011,53.002,1],
33808=>[92.993,-80.002,52.982,1],
33809=>[93.009,-79.994,52.964,1],
33810=>[93.025,-79.987,52.947,1],
33811=>[93.041,-79.978,52.930,1],
33812=>[93.058,-79.968,52.915,1],
33813=>[93.076,-79.954,52.900,1],
33814=>[93.083,-79.950,52.887,1],
33815=>[93.090,-79.946,52.875,1],
33816=>[93.098,-79.943,52.866,1],
33817=>[93.119,-79.932,52.857,1],
33818=>[93.139,-79.921,52.851,1],
33819=>[93.160,-79.911,52.846,1],
33820=>[93.184,-79.902,52.841,1],
33821=>[93.199,-79.893,52.837,1],
33822=>[93.214,-79.885,52.835,1],
33823=>[93.228,-79.877,52.833,1],
33824=>[93.248,-79.867,52.831,1],
33825=>[93.271,-79.858,52.829,1],
33826=>[93.295,-79.848,52.826,1],
33827=>[93.318,-79.839,52.824,1],
33828=>[93.341,-79.829,52.822,1],
33829=>[93.364,-79.819,52.821,1],
33830=>[93.389,-79.809,52.821,1],
33831=>[93.425,-79.796,52.821,1],
33832=>[93.461,-79.783,52.822,1],
33833=>[93.494,-79.770,52.822,1],
33834=>[93.509,-79.754,52.820,1],
33835=>[93.524,-79.738,52.817,1],
33836=>[93.539,-79.722,52.814,1],
33837=>[93.554,-79.706,52.810,1],
33838=>[93.569,-79.689,52.807,1],
33839=>[93.584,-79.673,52.804,1],
33840=>[93.597,-79.659,52.800,1],
33841=>[93.607,-79.649,52.795,1],
33842=>[93.617,-79.639,52.788,1],
33843=>[93.627,-79.629,52.782,1],
33844=>[93.637,-79.620,52.777,1],
33845=>[93.647,-79.609,52.770,1],
33846=>[93.657,-79.599,52.762,1],
33847=>[93.666,-79.589,52.754,1],
33848=>[93.677,-79.579,52.746,1],
33849=>[93.687,-79.570,52.736,1],
33850=>[93.696,-79.559,52.727,1],
33851=>[93.708,-79.551,52.717,1],
33852=>[93.723,-79.544,52.708,1],
33853=>[93.738,-79.538,52.700,1],
33854=>[93.753,-79.531,52.692,1],
33855=>[93.768,-79.525,52.686,1],
33856=>[93.783,-79.518,52.680,1],
33857=>[93.798,-79.512,52.675,1],
33858=>[93.814,-79.505,52.672,1],
33859=>[93.829,-79.499,52.667,1],
33860=>[93.844,-79.492,52.662,1],
33861=>[93.859,-79.486,52.657,1],
33862=>[93.874,-79.479,52.652,1],
33863=>[93.890,-79.473,52.646,1],
33864=>[93.905,-79.466,52.639,1],
33865=>[93.912,-79.469,52.633,1],
33866=>[93.918,-79.471,52.627,1],
33867=>[93.925,-79.474,52.620,1],
33868=>[93.931,-79.476,52.612,1],
33869=>[93.938,-79.479,52.604,1],
33870=>[93.944,-79.482,52.595,1],
33871=>[93.951,-79.484,52.587,1],
33872=>[93.958,-79.486,52.577,1],
33873=>[93.965,-79.488,52.566,1],
33874=>[93.971,-79.491,52.555,1],
33875=>[93.978,-79.494,52.544,1],
33876=>[93.984,-79.496,52.533,1],
33877=>[93.991,-79.499,52.522,1],
33878=>[93.997,-79.501,52.510,1],
33879=>[94.004,-79.504,52.497,1],
33880=>[94.010,-79.506,52.484,1],
33881=>[94.017,-79.509,52.471,1],
33882=>[94.024,-79.511,52.458,1],
33883=>[94.030,-79.513,52.445,1],
33884=>[94.037,-79.516,52.432,1],
33885=>[94.043,-79.519,52.419,1],
33886=>[94.050,-79.521,52.404,1],
33887=>[94.056,-79.523,52.390,1],
33888=>[94.063,-79.526,52.375,1],
33889=>[94.069,-79.529,52.361,1],
33890=>[94.076,-79.531,52.346,1],
33891=>[94.082,-79.534,52.332,1],
33892=>[94.089,-79.536,52.317,1],
33893=>[94.096,-79.538,52.300,1],
33894=>[94.103,-79.541,52.283,1],
33895=>[94.105,-79.546,52.267,1],
33896=>[94.106,-79.551,52.250,1],
33897=>[94.107,-79.557,52.234,1],
33898=>[94.109,-79.562,52.219,1],
33899=>[94.110,-79.568,52.205,1],
33900=>[94.113,-79.573,52.190,1],
33901=>[94.122,-79.574,52.174,1],
33902=>[94.135,-79.571,52.159,1],
33903=>[94.146,-79.558,52.143,1],
33904=>[94.154,-79.550,52.126,1],
33905=>[94.162,-79.524,52.109,1],
33906=>[94.170,-79.499,52.092,1],
33907=>[94.178,-79.474,52.073,1],
33908=>[94.187,-79.448,52.053,1],
33909=>[94.195,-79.423,52.032,1],
33910=>[94.202,-79.397,52.014,1],
33911=>[94.210,-79.370,51.997,1],
33912=>[94.218,-79.344,51.982,1],
33913=>[94.226,-79.318,51.967,1],
33914=>[94.234,-79.291,51.951,1],
33915=>[94.244,-79.269,51.932,1],
33916=>[94.260,-79.259,51.911,1],
33917=>[94.268,-79.256,51.890,1],
33918=>[94.276,-79.254,51.870,1],
33919=>[94.284,-79.251,51.851,1],
33920=>[94.293,-79.249,51.834,1],
33921=>[94.301,-79.247,51.817,1],
33922=>[94.309,-79.244,51.798,1],
33923=>[94.310,-79.250,51.780,1],
33924=>[94.306,-79.262,51.761,1],
33925=>[94.302,-79.273,51.739,1],
33926=>[94.300,-79.278,51.717,1],
33927=>[94.301,-79.257,51.694,1],
33928=>[94.296,-79.248,51.671,1],
33929=>[94.283,-79.254,51.642,1],
33930=>[94.270,-79.260,51.611,1],
33931=>[94.257,-79.266,51.579,1],
33932=>[94.243,-79.272,51.547,1],
33933=>[94.251,-79.267,51.514,1],
33934=>[94.260,-79.260,51.479,1],
33935=>[94.270,-79.253,51.445,1],
33936=>[94.280,-79.247,51.408,1],
33937=>[94.289,-79.262,51.370,1],
33938=>[94.298,-79.305,51.333,1],
33939=>[94.307,-79.348,51.296,1],
33940=>[94.316,-79.391,51.259,1],
33941=>[94.325,-79.435,51.223,1],
33942=>[94.333,-79.478,51.185,1],
33943=>[94.342,-79.521,51.147,1],
33944=>[94.351,-79.563,51.108,1],
33945=>[94.364,-79.577,51.068,1],
33946=>[94.377,-79.590,51.028,1],
33947=>[94.391,-79.603,50.989,1],
33948=>[94.404,-79.616,50.951,1],
33949=>[94.417,-79.629,50.912,1],
33950=>[94.430,-79.642,50.873,1],
34491=>[92.700,-80.131,53.424,1],
34492=>[92.716,-80.122,53.399,1],
34493=>[92.732,-80.114,53.374,1],
34494=>[92.748,-80.106,53.348,1],
34495=>[92.764,-80.098,53.324,1],
34496=>[92.780,-80.090,53.299,1],
34497=>[92.796,-80.082,53.274,1],
34498=>[92.812,-80.074,53.249,1],
34499=>[92.829,-80.066,53.223,1],
34500=>[92.845,-80.058,53.199,1],
34501=>[92.860,-80.050,53.175,1],
34502=>[92.876,-80.042,53.150,1],
34503=>[92.893,-80.034,53.126,1],
34504=>[92.909,-80.026,53.103,1],
34505=>[92.925,-80.018,53.081,1],
34506=>[92.941,-80.010,53.059,1],
34507=>[92.956,-80.002,53.038,1],
34508=>[92.973,-79.993,53.017,1],
34509=>[92.989,-79.986,52.996,1],
34510=>[93.005,-79.977,52.978,1],
34511=>[93.021,-79.970,52.959,1],
34512=>[93.037,-79.961,52.942,1],
34513=>[93.053,-79.953,52.925,1],
34514=>[93.070,-79.942,52.909,1],
34515=>[93.088,-79.928,52.894,1],
34516=>[93.097,-79.923,52.881,1],
34517=>[93.103,-79.919,52.870,1],
34518=>[93.111,-79.915,52.860,1],
34519=>[93.122,-79.909,52.854,1],
34520=>[93.143,-79.899,52.850,1],
34521=>[93.165,-79.889,52.846,1],
34522=>[93.180,-79.881,52.842,1],
34523=>[93.195,-79.872,52.840,1],
34524=>[93.219,-79.863,52.838,1],
34525=>[93.242,-79.853,52.835,1],
34526=>[93.265,-79.843,52.834,1],
34527=>[93.288,-79.834,52.831,1],
34528=>[93.312,-79.824,52.828,1],
34529=>[93.335,-79.814,52.825,1],
34530=>[93.358,-79.805,52.825,1],
34531=>[93.382,-79.795,52.825,1],
34532=>[93.412,-79.784,52.824,1],
34533=>[93.447,-79.771,52.824,1],
34534=>[93.482,-79.758,52.823,1],
34535=>[93.497,-79.742,52.822,1],
34536=>[93.512,-79.726,52.818,1],
34537=>[93.527,-79.710,52.813,1],
34538=>[93.542,-79.694,52.808,1],
34539=>[93.557,-79.677,52.804,1],
34540=>[93.572,-79.661,52.800,1],
34541=>[93.586,-79.645,52.796,1],
34542=>[93.602,-79.629,52.789,1],
34543=>[93.616,-79.614,52.781,1],
34544=>[93.626,-79.604,52.773,1],
34545=>[93.636,-79.593,52.768,1],
34546=>[93.646,-79.583,52.760,1],
34547=>[93.656,-79.573,52.752,1],
34548=>[93.665,-79.563,52.744,1],
34549=>[93.676,-79.554,52.735,1],
34550=>[93.686,-79.543,52.727,1],
34551=>[93.695,-79.533,52.718,1],
34552=>[93.706,-79.524,52.710,1],
34553=>[93.721,-79.517,52.701,1],
34554=>[93.736,-79.511,52.692,1],
34555=>[93.751,-79.504,52.684,1],
34556=>[93.767,-79.498,52.678,1],
34557=>[93.782,-79.491,52.673,1],
34558=>[93.797,-79.485,52.669,1],
34559=>[93.812,-79.479,52.666,1],
34560=>[93.827,-79.473,52.662,1],
34561=>[93.842,-79.466,52.657,1],
34562=>[93.857,-79.460,52.653,1],
34563=>[93.872,-79.453,52.648,1],
34564=>[93.888,-79.447,52.643,1],
34565=>[93.903,-79.440,52.637,1],
34566=>[93.918,-79.434,52.631,1],
34567=>[93.931,-79.429,52.625,1],
34568=>[93.938,-79.432,52.618,1],
34569=>[93.944,-79.434,52.610,1],
34570=>[93.951,-79.437,52.602,1],
34571=>[93.958,-79.439,52.593,1],
34572=>[93.965,-79.441,52.584,1],
34573=>[93.971,-79.444,52.574,1],
34574=>[93.978,-79.447,52.562,1],
34575=>[93.984,-79.449,52.551,1],
34576=>[93.991,-79.451,52.540,1],
34577=>[93.997,-79.454,52.529,1],
34578=>[94.004,-79.457,52.518,1],
34579=>[94.010,-79.459,52.505,1],
34580=>[94.017,-79.461,52.493,1],
34581=>[94.024,-79.464,52.480,1],
34582=>[94.030,-79.466,52.467,1],
34583=>[94.037,-79.469,52.454,1],
34584=>[94.043,-79.472,52.440,1],
34585=>[94.050,-79.474,52.427,1],
34586=>[94.056,-79.476,52.414,1],
34587=>[94.059,-79.481,52.401,1],
34588=>[94.060,-79.487,52.386,1],
34589=>[94.061,-79.492,52.371,1],
34590=>[94.062,-79.498,52.357,1],
34591=>[94.063,-79.504,52.344,1],
34592=>[94.064,-79.509,52.331,1],
34593=>[94.065,-79.514,52.316,1],
34594=>[94.067,-79.520,52.299,1],
34595=>[94.068,-79.526,52.281,1],
34596=>[94.069,-79.531,52.265,1],
34597=>[94.070,-79.536,52.248,1],
34598=>[94.075,-79.540,52.232,1],
34599=>[94.084,-79.542,52.219,1],
34600=>[94.093,-79.544,52.205,1],
34601=>[94.102,-79.546,52.190,1],
34602=>[94.112,-79.548,52.174,1],
34603=>[94.128,-79.507,52.158,1],
34604=>[94.143,-79.506,52.140,1],
34605=>[94.149,-79.506,52.123,1],
34606=>[94.158,-79.496,52.107,1],
34607=>[94.167,-79.476,52.090,1],
34608=>[94.175,-79.451,52.073,1],
34609=>[94.183,-79.426,52.054,1],
34610=>[94.191,-79.400,52.034,1],
34611=>[94.199,-79.375,52.014,1],
34612=>[94.207,-79.350,51.996,1],
34613=>[94.215,-79.325,51.981,1],
34614=>[94.223,-79.299,51.966,1],
34615=>[94.231,-79.274,51.950,1],
34616=>[94.238,-79.267,51.931,1],
34617=>[94.245,-79.266,51.911,1],
34618=>[94.253,-79.263,51.890,1],
34619=>[94.261,-79.261,51.870,1],
34620=>[94.269,-79.259,51.853,1],
34621=>[94.277,-79.256,51.837,1],
34622=>[94.285,-79.254,51.821,1],
34623=>[94.294,-79.251,51.802,1],
34624=>[94.302,-79.249,51.785,1],
34625=>[94.303,-79.254,51.768,1],
34626=>[94.300,-79.266,51.748,1],
34627=>[94.296,-79.276,51.727,1],
34628=>[94.298,-79.256,51.704,1],
34629=>[94.289,-79.253,51.681,1],
34630=>[94.276,-79.259,51.652,1],
34631=>[94.262,-79.266,51.622,1],
34632=>[94.249,-79.272,51.591,1],
34633=>[94.236,-79.278,51.561,1],
34634=>[94.239,-79.275,51.529,1],
34635=>[94.249,-79.268,51.495,1],
34636=>[94.259,-79.262,51.461,1],
34637=>[94.268,-79.255,51.423,1],
34638=>[94.278,-79.248,51.385,1],
34639=>[94.287,-79.282,51.347,1],
34640=>[94.296,-79.325,51.309,1],
34641=>[94.305,-79.369,51.272,1],
34642=>[94.314,-79.412,51.234,1],
34643=>[94.322,-79.455,51.196,1],
34644=>[94.331,-79.499,51.157,1],
34645=>[94.342,-79.525,51.118,1],
34646=>[94.356,-79.538,51.077,1],
34647=>[94.369,-79.551,51.037,1],
34648=>[94.382,-79.563,50.998,1],
34649=>[94.395,-79.576,50.959,1],
34650=>[94.408,-79.589,50.919,1],
34651=>[94.421,-79.602,50.880,1],
34652=>[94.434,-79.616,50.840,1],
35195=>[92.744,-80.089,53.372,1],
35196=>[92.760,-80.081,53.347,1],
35197=>[92.776,-80.073,53.321,1],
35198=>[92.792,-80.065,53.296,1],
35199=>[92.808,-80.057,53.271,1],
35200=>[92.825,-80.049,53.245,1],
35201=>[92.840,-80.041,53.221,1],
35202=>[92.856,-80.033,53.196,1],
35203=>[92.872,-80.025,53.171,1],
35204=>[92.888,-80.017,53.147,1],
35205=>[92.905,-80.008,53.123,1],
35206=>[92.921,-80.001,53.099,1],
35207=>[92.936,-79.993,53.076,1],
35208=>[92.952,-79.985,53.054,1],
35209=>[92.969,-79.977,53.033,1],
35210=>[92.985,-79.968,53.011,1],
35211=>[93.001,-79.961,52.992,1],
35212=>[93.017,-79.952,52.973,1],
35213=>[93.032,-79.945,52.953,1],
35214=>[93.049,-79.936,52.935,1],
35215=>[93.065,-79.928,52.918,1],
35216=>[93.082,-79.916,52.901,1],
35217=>[93.100,-79.902,52.888,1],
35218=>[93.111,-79.896,52.875,1],
35219=>[93.117,-79.892,52.864,1],
35220=>[93.124,-79.888,52.858,1],
35221=>[93.131,-79.884,52.854,1],
35222=>[93.146,-79.877,52.851,1],
35223=>[93.166,-79.868,52.847,1],
35224=>[93.189,-79.858,52.844,1],
35225=>[93.213,-79.849,52.841,1],
35226=>[93.236,-79.839,52.838,1],
35227=>[93.259,-79.830,52.836,1],
35228=>[93.282,-79.820,52.833,1],
35229=>[93.306,-79.810,52.830,1],
35230=>[93.329,-79.801,52.828,1],
35231=>[93.352,-79.791,52.827,1],
35232=>[93.375,-79.781,52.826,1],
35233=>[93.399,-79.772,52.826,1],
35234=>[93.434,-79.759,52.826,1],
35235=>[93.470,-79.746,52.825,1],
35236=>[93.485,-79.730,52.823,1],
35237=>[93.500,-79.714,52.818,1],
35238=>[93.515,-79.698,52.813,1],
35239=>[93.530,-79.682,52.807,1],
35240=>[93.545,-79.665,52.802,1],
35241=>[93.559,-79.649,52.796,1],
35242=>[93.574,-79.633,52.790,1],
35243=>[93.589,-79.617,52.782,1],
35244=>[93.604,-79.601,52.773,1],
35245=>[93.619,-79.585,52.765,1],
35246=>[93.634,-79.569,52.758,1],
35247=>[93.645,-79.557,52.750,1],
35248=>[93.655,-79.548,52.742,1],
35249=>[93.665,-79.538,52.734,1],
35250=>[93.675,-79.527,52.725,1],
35251=>[93.685,-79.517,52.718,1],
35252=>[93.695,-79.507,52.710,1],
35253=>[93.704,-79.498,52.701,1],
35254=>[93.719,-79.491,52.692,1],
35255=>[93.734,-79.484,52.684,1],
35256=>[93.750,-79.478,52.676,1],
35257=>[93.765,-79.472,52.670,1],
35258=>[93.780,-79.465,52.665,1],
35259=>[93.795,-79.459,52.662,1],
35260=>[93.810,-79.452,52.660,1],
35261=>[93.825,-79.446,52.657,1],
35262=>[93.840,-79.439,52.653,1],
35263=>[93.855,-79.433,52.649,1],
35264=>[93.870,-79.426,52.646,1],
35265=>[93.886,-79.420,52.642,1],
35266=>[93.901,-79.413,52.636,1],
35267=>[93.916,-79.407,52.630,1],
35268=>[93.931,-79.400,52.625,1],
35269=>[93.946,-79.394,52.619,1],
35270=>[93.958,-79.392,52.612,1],
35271=>[93.965,-79.394,52.603,1],
35272=>[93.971,-79.397,52.593,1],
35273=>[93.978,-79.399,52.584,1],
35274=>[93.984,-79.402,52.572,1],
35275=>[93.991,-79.404,52.561,1],
35276=>[93.997,-79.407,52.549,1],
35277=>[94.004,-79.410,52.537,1],
35278=>[94.010,-79.412,52.525,1],
35279=>[94.013,-79.416,52.513,1],
35280=>[94.014,-79.422,52.500,1],
35281=>[94.015,-79.428,52.488,1],
35282=>[94.016,-79.433,52.476,1],
35283=>[94.017,-79.438,52.463,1],
35284=>[94.018,-79.444,52.449,1],
35285=>[94.019,-79.450,52.436,1],
35286=>[94.020,-79.455,52.423,1],
35287=>[94.022,-79.460,52.411,1],
35288=>[94.023,-79.466,52.397,1],
35289=>[94.024,-79.472,52.383,1],
35290=>[94.025,-79.477,52.368,1],
35291=>[94.026,-79.483,52.354,1],
35292=>[94.027,-79.488,52.341,1],
35293=>[94.028,-79.494,52.331,1],
35294=>[94.029,-79.500,52.316,1],
35295=>[94.030,-79.505,52.298,1],
35296=>[94.037,-79.508,52.279,1],
35297=>[94.046,-79.510,52.262,1],
35298=>[94.055,-79.512,52.246,1],
35299=>[94.064,-79.513,52.230,1],
35300=>[94.073,-79.516,52.218,1],
35301=>[94.083,-79.517,52.205,1],
35302=>[94.092,-79.519,52.190,1],
35303=>[94.128,-79.478,52.173,1],
35304=>[94.139,-79.432,52.156,1],
35305=>[94.141,-79.453,52.137,1],
35306=>[94.145,-79.463,52.119,1],
35307=>[94.154,-79.453,52.104,1],
35308=>[94.163,-79.443,52.087,1],
35309=>[94.171,-79.429,52.070,1],
35310=>[94.179,-79.403,52.052,1],
35311=>[94.187,-79.378,52.033,1],
35312=>[94.195,-79.352,52.013,1],
35313=>[94.203,-79.327,51.993,1],
35314=>[94.211,-79.302,51.976,1],
35315=>[94.219,-79.276,51.962,1],
35316=>[94.227,-79.257,51.947,1],
35317=>[94.234,-79.267,51.929,1],
35318=>[94.239,-79.266,51.910,1],
35319=>[94.245,-79.266,51.892,1],
35320=>[94.250,-79.266,51.874,1],
35321=>[94.255,-79.265,51.858,1],
35322=>[94.262,-79.263,51.843,1],
35323=>[94.270,-79.261,51.826,1],
35324=>[94.278,-79.259,51.807,1],
35325=>[94.286,-79.256,51.790,1],
35326=>[94.295,-79.254,51.773,1],
35327=>[94.297,-79.258,51.755,1],
35328=>[94.294,-79.269,51.734,1],
35329=>[94.294,-79.254,51.712,1],
35330=>[94.281,-79.259,51.687,1],
35331=>[94.268,-79.266,51.660,1],
35332=>[94.255,-79.272,51.632,1],
35333=>[94.242,-79.278,51.603,1],
35334=>[94.228,-79.284,51.573,1],
35335=>[94.227,-79.283,51.542,1],
35336=>[94.238,-79.276,51.510,1],
35337=>[94.247,-79.269,51.478,1],
35338=>[94.257,-79.263,51.441,1],
35339=>[94.267,-79.256,51.403,1],
35340=>[94.276,-79.260,51.363,1],
35341=>[94.285,-79.303,51.326,1],
35342=>[94.294,-79.347,51.287,1],
35343=>[94.302,-79.390,51.247,1],
35344=>[94.312,-79.433,51.208,1],
35345=>[94.321,-79.473,51.168,1],
35346=>[94.334,-79.485,51.127,1],
35347=>[94.347,-79.498,51.086,1],
35348=>[94.360,-79.511,51.047,1],
35349=>[94.373,-79.524,51.007,1],
35350=>[94.387,-79.537,50.967,1],
35351=>[94.400,-79.550,50.928,1],
35352=>[94.413,-79.563,50.887,1],
35353=>[94.426,-79.576,50.847,1],
35899=>[92.788,-80.048,53.318,1],
35900=>[92.804,-80.040,53.292,1],
35901=>[92.820,-80.032,53.267,1],
35902=>[92.836,-80.024,53.242,1],
35903=>[92.852,-80.016,53.216,1],
35904=>[92.868,-80.008,53.192,1],
35905=>[92.884,-80.000,53.166,1],
35906=>[92.901,-79.992,53.141,1],
35907=>[92.916,-79.983,53.117,1],
35908=>[92.932,-79.976,53.094,1],
35909=>[92.948,-79.968,53.071,1],
35910=>[92.965,-79.960,53.048,1],
35911=>[92.981,-79.952,53.027,1],
35912=>[92.997,-79.943,53.007,1],
35913=>[93.012,-79.936,52.986,1],
35914=>[93.028,-79.927,52.965,1],
35915=>[93.045,-79.920,52.947,1],
35916=>[93.061,-79.911,52.929,1],
35917=>[93.077,-79.903,52.911,1],
35918=>[93.095,-79.889,52.896,1],
35919=>[93.113,-79.876,52.883,1],
35920=>[93.124,-79.868,52.871,1],
35921=>[93.131,-79.864,52.863,1],
35922=>[93.138,-79.861,52.859,1],
35923=>[93.144,-79.857,52.856,1],
35924=>[93.160,-79.851,52.851,1],
35925=>[93.184,-79.843,52.847,1],
35926=>[93.207,-79.835,52.843,1],
35927=>[93.230,-79.825,52.839,1],
35928=>[93.253,-79.815,52.837,1],
35929=>[93.276,-79.805,52.834,1],
35930=>[93.300,-79.796,52.831,1],
35931=>[93.323,-79.786,52.830,1],
35932=>[93.346,-79.776,52.829,1],
35933=>[93.369,-79.767,52.828,1],
35934=>[93.393,-79.758,52.828,1],
35935=>[93.421,-79.746,52.828,1],
35936=>[93.457,-79.734,52.826,1],
35937=>[93.473,-79.717,52.823,1],
35938=>[93.488,-79.701,52.819,1],
35939=>[93.502,-79.686,52.813,1],
35940=>[93.517,-79.670,52.806,1],
35941=>[93.533,-79.653,52.799,1],
35942=>[93.547,-79.637,52.792,1],
35943=>[93.562,-79.621,52.785,1],
35944=>[93.577,-79.605,52.777,1],
35945=>[93.592,-79.588,52.767,1],
35946=>[93.607,-79.573,52.758,1],
35947=>[93.622,-79.557,52.751,1],
35948=>[93.637,-79.541,52.743,1],
35949=>[93.651,-79.524,52.735,1],
35950=>[93.664,-79.511,52.727,1],
35951=>[93.674,-79.501,52.717,1],
35952=>[93.684,-79.491,52.708,1],
35953=>[93.694,-79.482,52.699,1],
35954=>[93.704,-79.472,52.690,1],
35955=>[93.717,-79.464,52.682,1],
35956=>[93.732,-79.457,52.674,1],
35957=>[93.748,-79.451,52.668,1],
35958=>[93.763,-79.444,52.662,1],
35959=>[93.778,-79.438,52.658,1],
35960=>[93.793,-79.432,52.656,1],
35961=>[93.808,-79.426,52.655,1],
35962=>[93.823,-79.419,52.653,1],
35963=>[93.838,-79.413,52.650,1],
35964=>[93.854,-79.407,52.647,1],
35965=>[93.869,-79.400,52.645,1],
35966=>[93.884,-79.394,52.642,1],
35967=>[93.899,-79.387,52.637,1],
35968=>[93.914,-79.381,52.631,1],
35969=>[93.929,-79.374,52.627,1],
35970=>[93.944,-79.368,52.623,1],
35971=>[93.960,-79.363,52.616,1],
35972=>[93.971,-79.360,52.607,1],
35973=>[93.969,-79.363,52.597,1],
35974=>[93.970,-79.369,52.586,1],
35975=>[93.971,-79.374,52.574,1],
35976=>[93.972,-79.379,52.561,1],
35977=>[93.973,-79.385,52.548,1],
35978=>[93.975,-79.391,52.536,1],
35979=>[93.976,-79.396,52.523,1],
35980=>[93.977,-79.402,52.510,1],
35981=>[93.978,-79.407,52.498,1],
35982=>[93.979,-79.413,52.486,1],
35983=>[93.980,-79.418,52.473,1],
35984=>[93.981,-79.424,52.460,1],
35985=>[93.982,-79.429,52.447,1],
35986=>[93.983,-79.435,52.434,1],
35987=>[93.984,-79.441,52.421,1],
35988=>[93.985,-79.446,52.408,1],
35989=>[93.986,-79.451,52.394,1],
35990=>[93.987,-79.457,52.379,1],
35991=>[93.988,-79.463,52.366,1],
35992=>[93.989,-79.468,52.353,1],
35993=>[93.991,-79.474,52.342,1],
35994=>[93.999,-79.476,52.330,1],
35995=>[94.008,-79.478,52.315,1],
35996=>[94.017,-79.479,52.297,1],
35997=>[94.027,-79.482,52.278,1],
35998=>[94.036,-79.483,52.260,1],
35999=>[94.045,-79.485,52.243,1],
36000=>[94.054,-79.487,52.228,1],
36001=>[94.063,-79.488,52.216,1],
36002=>[94.072,-79.491,52.203,1],
36003=>[94.121,-79.447,52.189,1],
36004=>[94.099,-79.427,52.171,1],
36005=>[94.136,-79.379,52.153,1],
36006=>[94.138,-79.400,52.134,1],
36007=>[94.141,-79.419,52.114,1],
36008=>[94.149,-79.409,52.099,1],
36009=>[94.158,-79.399,52.083,1],
36010=>[94.167,-79.390,52.067,1],
36011=>[94.175,-79.380,52.048,1],
36012=>[94.183,-79.355,52.030,1],
36013=>[94.191,-79.329,52.010,1],
36014=>[94.199,-79.304,51.990,1],
36015=>[94.207,-79.279,51.972,1],
36016=>[94.215,-79.253,51.957,1],
36017=>[94.223,-79.253,51.943,1],
36018=>[94.230,-79.263,51.925,1],
36019=>[94.236,-79.266,51.909,1],
36020=>[94.241,-79.266,51.893,1],
36021=>[94.246,-79.265,51.877,1],
36022=>[94.251,-79.265,51.863,1],
36023=>[94.257,-79.264,51.848,1],
36024=>[94.262,-79.264,51.832,1],
36025=>[94.267,-79.263,51.812,1],
36026=>[94.272,-79.263,51.795,1],
36027=>[94.279,-79.261,51.779,1],
36028=>[94.287,-79.259,51.761,1],
36029=>[94.291,-79.261,51.742,1],
36030=>[94.287,-79.259,51.720,1],
36031=>[94.274,-79.266,51.696,1],
36032=>[94.261,-79.272,51.670,1],
36033=>[94.247,-79.278,51.643,1],
36034=>[94.234,-79.284,51.615,1],
36035=>[94.220,-79.290,51.585,1],
36036=>[94.216,-79.291,51.555,1],
36037=>[94.226,-79.284,51.523,1],
36038=>[94.236,-79.278,51.490,1],
36039=>[94.246,-79.271,51.454,1],
36040=>[94.255,-79.264,51.417,1],
36041=>[94.265,-79.257,51.379,1],
36042=>[94.274,-79.281,51.343,1],
36043=>[94.283,-79.324,51.304,1],
36044=>[94.292,-79.368,51.263,1],
36045=>[94.300,-79.411,51.222,1],
36046=>[94.313,-79.433,51.181,1],
36047=>[94.326,-79.446,51.139,1],
36048=>[94.339,-79.459,51.098,1],
36049=>[94.352,-79.472,51.057,1],
36050=>[94.365,-79.485,51.016,1],
36051=>[94.378,-79.498,50.976,1],
36052=>[94.392,-79.511,50.936,1],
36053=>[94.405,-79.524,50.896,1],
36054=>[94.418,-79.537,50.855,1],
36055=>[94.431,-79.550,50.815,1],
36602=>[92.816,-80.015,53.289,1],
36603=>[92.832,-80.007,53.263,1],
36604=>[92.848,-79.999,53.237,1],
36605=>[92.864,-79.991,53.212,1],
36606=>[92.880,-79.983,53.186,1],
36607=>[92.896,-79.975,53.160,1],
36608=>[92.912,-79.967,53.136,1],
36609=>[92.928,-79.958,53.112,1],
36610=>[92.944,-79.951,53.089,1],
36611=>[92.960,-79.943,53.065,1],
36612=>[92.977,-79.935,53.043,1],
36613=>[92.992,-79.927,53.022,1],
36614=>[93.008,-79.918,53.000,1],
36615=>[93.024,-79.911,52.979,1],
36616=>[93.041,-79.902,52.959,1],
36617=>[93.057,-79.895,52.940,1],
36618=>[93.073,-79.886,52.922,1],
36619=>[93.089,-79.877,52.906,1],
36620=>[93.108,-79.863,52.892,1],
36621=>[93.126,-79.849,52.879,1],
36622=>[93.138,-79.841,52.870,1],
36623=>[93.144,-79.837,52.863,1],
36624=>[93.151,-79.833,52.857,1],
36625=>[93.158,-79.830,52.852,1],
36626=>[93.179,-79.823,52.848,1],
36627=>[93.202,-79.814,52.844,1],
36628=>[93.224,-79.807,52.840,1],
36629=>[93.248,-79.798,52.837,1],
36630=>[93.271,-79.791,52.835,1],
36631=>[93.294,-79.782,52.832,1],
36632=>[93.317,-79.772,52.830,1],
36633=>[93.340,-79.763,52.830,1],
36634=>[93.363,-79.753,52.830,1],
36635=>[93.387,-79.743,52.830,1],
36636=>[93.410,-79.734,52.829,1],
36637=>[93.444,-79.721,52.827,1],
36638=>[93.461,-79.705,52.824,1],
36639=>[93.476,-79.689,52.820,1],
36640=>[93.490,-79.673,52.813,1],
36641=>[93.505,-79.657,52.805,1],
36642=>[93.520,-79.641,52.797,1],
36643=>[93.535,-79.625,52.789,1],
36644=>[93.550,-79.609,52.781,1],
36645=>[93.565,-79.593,52.772,1],
36646=>[93.580,-79.576,52.762,1],
36647=>[93.594,-79.560,52.753,1],
36648=>[93.610,-79.545,52.744,1],
36649=>[93.625,-79.529,52.737,1],
36650=>[93.639,-79.512,52.729,1],
36651=>[93.654,-79.496,52.721,1],
36652=>[93.669,-79.480,52.711,1],
36653=>[93.683,-79.466,52.702,1],
36654=>[93.693,-79.456,52.693,1],
36655=>[93.703,-79.445,52.684,1],
36656=>[93.715,-79.438,52.676,1],
36657=>[93.730,-79.431,52.669,1],
36658=>[93.746,-79.425,52.662,1],
36659=>[93.761,-79.418,52.656,1],
36660=>[93.776,-79.412,52.652,1],
36661=>[93.791,-79.405,52.650,1],
36662=>[93.806,-79.399,52.651,1],
36663=>[93.822,-79.392,52.650,1],
36664=>[93.837,-79.386,52.650,1],
36665=>[93.852,-79.380,52.647,1],
36666=>[93.866,-79.378,52.645,1],
36667=>[93.882,-79.375,52.643,1],
36668=>[93.896,-79.372,52.640,1],
36669=>[93.911,-79.369,52.636,1],
36670=>[93.926,-79.366,52.633,1],
36671=>[93.941,-79.363,52.630,1],
36672=>[93.946,-79.360,52.623,1],
36673=>[93.951,-79.357,52.614,1],
36674=>[93.946,-79.356,52.603,1],
36675=>[93.938,-79.357,52.591,1],
36676=>[93.935,-79.359,52.579,1],
36677=>[93.936,-79.365,52.565,1],
36678=>[93.937,-79.370,52.550,1],
36679=>[93.938,-79.375,52.536,1],
36680=>[93.939,-79.382,52.523,1],
36681=>[93.940,-79.387,52.509,1],
36682=>[93.941,-79.392,52.498,1],
36683=>[93.942,-79.398,52.485,1],
36684=>[93.943,-79.404,52.472,1],
36685=>[93.944,-79.409,52.459,1],
36686=>[93.945,-79.415,52.447,1],
36687=>[93.946,-79.420,52.433,1],
36688=>[93.947,-79.426,52.420,1],
36689=>[93.949,-79.432,52.407,1],
36690=>[93.950,-79.437,52.393,1],
36691=>[93.952,-79.442,52.379,1],
36692=>[93.961,-79.444,52.366,1],
36693=>[93.970,-79.446,52.354,1],
36694=>[93.979,-79.447,52.342,1],
36695=>[93.988,-79.449,52.329,1],
36696=>[93.998,-79.451,52.313,1],
36697=>[94.007,-79.453,52.296,1],
36698=>[94.016,-79.455,52.277,1],
36699=>[94.025,-79.457,52.258,1],
36700=>[94.035,-79.458,52.241,1],
36701=>[94.044,-79.460,52.225,1],
36702=>[94.053,-79.462,52.212,1],
36703=>[94.096,-79.425,52.199,1],
36704=>[94.107,-79.390,52.184,1],
36705=>[94.109,-79.345,52.167,1],
36706=>[94.134,-79.326,52.148,1],
36707=>[94.136,-79.347,52.129,1],
36708=>[94.138,-79.369,52.110,1],
36709=>[94.145,-79.366,52.093,1],
36710=>[94.153,-79.356,52.077,1],
36711=>[94.162,-79.346,52.061,1],
36712=>[94.171,-79.336,52.042,1],
36713=>[94.179,-79.326,52.024,1],
36714=>[94.187,-79.306,52.006,1],
36715=>[94.195,-79.281,51.987,1],
36716=>[94.203,-79.256,51.968,1],
36717=>[94.211,-79.238,51.951,1],
36718=>[94.218,-79.249,51.937,1],
36719=>[94.225,-79.259,51.921,1],
36720=>[94.232,-79.266,51.906,1],
36721=>[94.237,-79.265,51.893,1],
36722=>[94.243,-79.265,51.880,1],
36723=>[94.248,-79.264,51.867,1],
36724=>[94.253,-79.264,51.854,1],
36725=>[94.258,-79.263,51.838,1],
36726=>[94.263,-79.263,51.818,1],
36727=>[94.269,-79.263,51.801,1],
36728=>[94.274,-79.262,51.786,1],
36729=>[94.279,-79.262,51.767,1],
36730=>[94.284,-79.261,51.749,1],
36731=>[94.285,-79.261,51.728,1],
36732=>[94.267,-79.271,51.705,1],
36733=>[94.253,-79.277,51.679,1],
36734=>[94.240,-79.283,51.653,1],
36735=>[94.226,-79.289,51.626,1],
36736=>[94.213,-79.295,51.597,1],
36737=>[94.205,-79.298,51.566,1],
36738=>[94.214,-79.292,51.534,1],
36739=>[94.224,-79.285,51.501,1],
36740=>[94.234,-79.278,51.464,1],
36741=>[94.244,-79.272,51.429,1],
36742=>[94.254,-79.266,51.394,1],
36743=>[94.263,-79.259,51.359,1],
36744=>[94.272,-79.302,51.320,1],
36745=>[94.281,-79.345,51.278,1],
36746=>[94.291,-79.381,51.235,1],
36747=>[94.304,-79.394,51.193,1],
36748=>[94.317,-79.407,51.151,1],
36749=>[94.330,-79.419,51.109,1],
36750=>[94.344,-79.432,51.068,1],
36751=>[94.357,-79.446,51.026,1],
36752=>[94.370,-79.459,50.985,1],
36753=>[94.383,-79.472,50.945,1],
36754=>[94.396,-79.485,50.904,1],
36755=>[94.409,-79.498,50.864,1],
36756=>[94.422,-79.510,50.824,1],
37308=>[92.892,-79.958,53.180,1],
37309=>[92.908,-79.950,53.156,1],
37310=>[92.924,-79.942,53.131,1],
37311=>[92.940,-79.933,53.106,1],
37312=>[92.956,-79.926,53.083,1],
37313=>[92.972,-79.918,53.060,1],
37314=>[92.988,-79.910,53.037,1],
37315=>[93.004,-79.902,53.015,1],
37316=>[93.020,-79.893,52.993,1],
37317=>[93.037,-79.886,52.973,1],
37318=>[93.053,-79.877,52.953,1],
37319=>[93.068,-79.870,52.935,1],
37320=>[93.084,-79.861,52.918,1],
37321=>[93.101,-79.851,52.902,1],
37322=>[93.120,-79.837,52.889,1],
37323=>[93.138,-79.823,52.877,1],
37324=>[93.151,-79.814,52.868,1],
37325=>[93.158,-79.810,52.860,1],
37326=>[93.165,-79.806,52.854,1],
37327=>[93.174,-79.802,52.850,1],
37328=>[93.197,-79.794,52.847,1],
37329=>[93.220,-79.786,52.843,1],
37330=>[93.242,-79.778,52.839,1],
37331=>[93.266,-79.770,52.836,1],
37332=>[93.289,-79.762,52.834,1],
37333=>[93.311,-79.755,52.834,1],
37334=>[93.335,-79.746,52.834,1],
37335=>[93.358,-79.739,52.834,1],
37336=>[93.381,-79.730,52.834,1],
37337=>[93.404,-79.720,52.832,1],
37338=>[93.431,-79.709,52.830,1],
37339=>[93.448,-79.693,52.826,1],
37340=>[93.463,-79.677,52.821,1],
37341=>[93.478,-79.661,52.814,1],
37342=>[93.493,-79.645,52.806,1],
37343=>[93.508,-79.629,52.796,1],
37344=>[93.523,-79.613,52.787,1],
37345=>[93.538,-79.597,52.778,1],
37346=>[93.553,-79.581,52.768,1],
37347=>[93.568,-79.564,52.758,1],
37348=>[93.582,-79.548,52.748,1],
37349=>[93.597,-79.532,52.740,1],
37350=>[93.612,-79.516,52.732,1],
37351=>[93.627,-79.500,52.725,1],
37352=>[93.642,-79.484,52.717,1],
37353=>[93.657,-79.468,52.708,1],
37354=>[93.672,-79.452,52.699,1],
37355=>[93.687,-79.435,52.690,1],
37356=>[93.702,-79.419,52.681,1],
37357=>[93.713,-79.411,52.673,1],
37358=>[93.728,-79.404,52.665,1],
37359=>[93.744,-79.398,52.658,1],
37360=>[93.759,-79.395,52.652,1],
37361=>[93.773,-79.393,52.649,1],
37362=>[93.788,-79.390,52.647,1],
37363=>[93.803,-79.387,52.648,1],
37364=>[93.818,-79.385,52.649,1],
37365=>[93.833,-79.382,52.649,1],
37366=>[93.848,-79.379,52.647,1],
37367=>[93.862,-79.375,52.645,1],
37368=>[93.877,-79.373,52.643,1],
37369=>[93.892,-79.370,52.641,1],
37370=>[93.907,-79.367,52.638,1],
37371=>[93.918,-79.364,52.636,1],
37372=>[93.922,-79.360,52.634,1],
37373=>[93.926,-79.357,52.628,1],
37374=>[93.931,-79.353,52.619,1],
37375=>[93.929,-79.352,52.609,1],
37376=>[93.921,-79.352,52.597,1],
37377=>[93.913,-79.353,52.585,1],
37378=>[93.905,-79.353,52.571,1],
37379=>[93.901,-79.356,52.555,1],
37380=>[93.902,-79.361,52.539,1],
37381=>[93.903,-79.366,52.525,1],
37382=>[93.904,-79.372,52.512,1],
37383=>[93.905,-79.378,52.499,1],
37384=>[93.906,-79.383,52.487,1],
37385=>[93.907,-79.389,52.473,1],
37386=>[93.908,-79.394,52.460,1],
37387=>[93.909,-79.400,52.447,1],
37388=>[93.910,-79.406,52.434,1],
37389=>[93.914,-79.410,52.420,1],
37390=>[93.923,-79.412,52.408,1],
37391=>[93.932,-79.413,52.394,1],
37392=>[93.941,-79.416,52.381,1],
37393=>[93.951,-79.417,52.368,1],
37394=>[93.960,-79.419,52.356,1],
37395=>[93.969,-79.421,52.342,1],
37396=>[93.978,-79.422,52.327,1],
37397=>[93.987,-79.425,52.311,1],
37398=>[93.996,-79.426,52.294,1],
37399=>[94.006,-79.428,52.275,1],
37400=>[94.015,-79.430,52.256,1],
37401=>[94.024,-79.432,52.238,1],
37402=>[94.033,-79.434,52.221,1],
37403=>[94.071,-79.402,52.207,1],
37404=>[94.115,-79.353,52.193,1],
37405=>[94.084,-79.346,52.178,1],
37406=>[94.085,-79.346,52.161,1],
37407=>[94.116,-79.328,52.142,1],
37408=>[94.133,-79.295,52.124,1],
37409=>[94.135,-79.316,52.106,1],
37410=>[94.140,-79.322,52.088,1],
37411=>[94.149,-79.313,52.072,1],
37412=>[94.157,-79.303,52.056,1],
37413=>[94.166,-79.293,52.037,1],
37414=>[94.175,-79.283,52.019,1],
37415=>[94.183,-79.273,52.002,1],
37416=>[94.191,-79.259,51.984,1],
37417=>[94.200,-79.234,51.964,1],
37418=>[94.207,-79.234,51.947,1],
37419=>[94.214,-79.244,51.932,1],
37420=>[94.221,-79.255,51.917,1],
37421=>[94.228,-79.265,51.904,1],
37422=>[94.234,-79.265,51.892,1],
37423=>[94.239,-79.264,51.881,1],
37424=>[94.244,-79.264,51.868,1],
37425=>[94.249,-79.263,51.855,1],
37426=>[94.254,-79.263,51.841,1],
37427=>[94.260,-79.263,51.822,1],
37428=>[94.265,-79.262,51.805,1],
37429=>[94.270,-79.262,51.790,1],
37430=>[94.275,-79.261,51.772,1],
37431=>[94.281,-79.259,51.754,1],
37432=>[94.289,-79.254,51.733,1],
37433=>[94.297,-79.250,51.711,1],
37434=>[94.278,-79.259,51.686,1],
37435=>[94.260,-79.269,51.660,1],
37436=>[94.242,-79.278,51.633,1],
37437=>[94.223,-79.288,51.605,1],
37438=>[94.204,-79.298,51.575,1],
37439=>[94.206,-79.297,51.543,1],
37440=>[94.213,-79.293,51.510,1],
37441=>[94.222,-79.287,51.474,1],
37442=>[94.232,-79.280,51.439,1],
37443=>[94.242,-79.273,51.407,1],
37444=>[94.252,-79.267,51.372,1],
37445=>[94.261,-79.280,51.333,1],
37446=>[94.270,-79.323,51.291,1],
37447=>[94.282,-79.341,51.247,1],
37448=>[94.295,-79.354,51.204,1],
37449=>[94.309,-79.367,51.162,1],
37450=>[94.322,-79.380,51.120,1],
37451=>[94.335,-79.394,51.078,1],
37452=>[94.348,-79.407,51.036,1],
37453=>[94.361,-79.419,50.995,1],
37454=>[94.374,-79.432,50.954,1],
37455=>[94.388,-79.445,50.913,1],
37456=>[94.401,-79.458,50.873,1],
37457=>[94.414,-79.471,50.833,1],
38013=>[92.952,-79.908,53.102,1],
38014=>[92.968,-79.901,53.078,1],
38015=>[92.984,-79.892,53.054,1],
38016=>[93.000,-79.885,53.031,1],
38017=>[93.016,-79.877,53.009,1],
38018=>[93.032,-79.868,52.989,1],
38019=>[93.048,-79.861,52.969,1],
38020=>[93.064,-79.852,52.948,1],
38021=>[93.080,-79.845,52.930,1],
38022=>[93.096,-79.836,52.914,1],
38023=>[93.114,-79.824,52.899,1],
38024=>[93.132,-79.811,52.886,1],
38025=>[93.150,-79.797,52.875,1],
38026=>[93.165,-79.786,52.865,1],
38027=>[93.171,-79.783,52.858,1],
38028=>[93.179,-79.779,52.853,1],
38029=>[93.192,-79.773,52.850,1],
38030=>[93.215,-79.766,52.847,1],
38031=>[93.238,-79.758,52.843,1],
38032=>[93.261,-79.750,52.840,1],
38033=>[93.284,-79.742,52.838,1],
38034=>[93.307,-79.734,52.838,1],
38035=>[93.330,-79.726,52.839,1],
38036=>[93.353,-79.718,52.839,1],
38037=>[93.376,-79.710,52.838,1],
38038=>[93.399,-79.702,52.836,1],
38039=>[93.422,-79.694,52.833,1],
38040=>[93.434,-79.685,52.829,1],
38041=>[93.448,-79.669,52.823,1],
38042=>[93.463,-79.654,52.816,1],
38043=>[93.477,-79.638,52.808,1],
38044=>[93.492,-79.622,52.797,1],
38045=>[93.506,-79.606,52.787,1],
38046=>[93.521,-79.590,52.777,1],
38047=>[93.536,-79.575,52.767,1],
38048=>[93.550,-79.559,52.757,1],
38049=>[93.565,-79.543,52.747,1],
38050=>[93.579,-79.527,52.740,1],
38051=>[93.594,-79.511,52.734,1],
38052=>[93.609,-79.496,52.727,1],
38053=>[93.623,-79.480,52.720,1],
38054=>[93.638,-79.464,52.710,1],
38055=>[93.652,-79.448,52.701,1],
38056=>[93.667,-79.432,52.692,1],
38057=>[93.682,-79.417,52.683,1],
38058=>[93.707,-79.404,52.673,1],
38059=>[93.725,-79.399,52.664,1],
38060=>[93.740,-79.397,52.656,1],
38061=>[93.755,-79.394,52.650,1],
38062=>[93.769,-79.391,52.646,1],
38063=>[93.784,-79.388,52.644,1],
38064=>[93.799,-79.385,52.646,1],
38065=>[93.814,-79.382,52.648,1],
38066=>[93.829,-79.380,52.648,1],
38067=>[93.844,-79.377,52.647,1],
38068=>[93.858,-79.374,52.645,1],
38069=>[93.873,-79.372,52.642,1],
38070=>[93.888,-79.369,52.640,1],
38071=>[93.893,-79.365,52.639,1],
38072=>[93.898,-79.361,52.638,1],
38073=>[93.902,-79.358,52.636,1],
38074=>[93.907,-79.354,52.630,1],
38075=>[93.911,-79.350,52.622,1],
38076=>[93.912,-79.348,52.613,1],
38077=>[93.904,-79.348,52.601,1],
38078=>[93.896,-79.349,52.588,1],
38079=>[93.888,-79.350,52.574,1],
38080=>[93.880,-79.350,52.558,1],
38081=>[93.872,-79.350,52.543,1],
38082=>[93.866,-79.352,52.529,1],
38083=>[93.867,-79.357,52.516,1],
38084=>[93.868,-79.363,52.504,1],
38085=>[93.869,-79.369,52.491,1],
38086=>[93.870,-79.374,52.478,1],
38087=>[93.875,-79.378,52.466,1],
38088=>[93.885,-79.379,52.453,1],
38089=>[93.894,-79.382,52.439,1],
38090=>[93.903,-79.383,52.425,1],
38091=>[93.912,-79.385,52.412,1],
38092=>[93.922,-79.387,52.398,1],
38093=>[93.931,-79.388,52.383,1],
38094=>[93.940,-79.391,52.369,1],
38095=>[93.949,-79.392,52.355,1],
38096=>[93.959,-79.394,52.340,1],
38097=>[93.968,-79.396,52.323,1],
38098=>[93.977,-79.397,52.306,1],
38099=>[93.986,-79.400,52.288,1],
38100=>[93.995,-79.401,52.270,1],
38101=>[94.004,-79.404,52.252,1],
38102=>[94.014,-79.405,52.234,1],
38103=>[94.047,-79.379,52.217,1],
38104=>[94.101,-79.328,52.200,1],
38105=>[94.109,-79.325,52.186,1],
38106=>[94.094,-79.332,52.170,1],
38107=>[94.080,-79.338,52.152,1],
38108=>[94.094,-79.334,52.135,1],
38109=>[94.117,-79.293,52.117,1],
38110=>[94.133,-79.263,52.100,1],
38111=>[94.136,-79.278,52.084,1],
38112=>[94.144,-79.269,52.068,1],
38113=>[94.153,-79.259,52.051,1],
38114=>[94.161,-79.249,52.032,1],
38115=>[94.170,-79.239,52.014,1],
38116=>[94.179,-79.229,51.997,1],
38117=>[94.187,-79.219,51.980,1],
38118=>[94.195,-79.219,51.960,1],
38119=>[94.202,-79.230,51.943,1],
38120=>[94.209,-79.240,51.928,1],
38121=>[94.217,-79.250,51.914,1],
38122=>[94.224,-79.260,51.902,1],
38123=>[94.229,-79.264,51.891,1],
38124=>[94.235,-79.264,51.881,1],
38125=>[94.240,-79.263,51.868,1],
38126=>[94.246,-79.263,51.855,1],
38127=>[94.251,-79.263,51.842,1],
38128=>[94.256,-79.262,51.824,1],
38129=>[94.261,-79.262,51.808,1],
38130=>[94.266,-79.261,51.792,1],
38131=>[94.272,-79.260,51.774,1],
38132=>[94.280,-79.255,51.755,1],
38133=>[94.287,-79.250,51.735,1],
38134=>[94.295,-79.245,51.713,1],
38135=>[94.303,-79.241,51.689,1],
38136=>[94.290,-79.247,51.663,1],
38137=>[94.272,-79.257,51.636,1],
38138=>[94.253,-79.267,51.609,1],
38139=>[94.235,-79.276,51.579,1],
38140=>[94.226,-79.281,51.548,1],
38141=>[94.229,-79.280,51.516,1],
38142=>[94.231,-79.278,51.482,1],
38143=>[94.234,-79.278,51.448,1],
38144=>[94.237,-79.276,51.417,1],
38145=>[94.241,-79.275,51.382,1],
38146=>[94.250,-79.268,51.343,1],
38147=>[94.261,-79.289,51.302,1],
38148=>[94.274,-79.302,51.259,1],
38149=>[94.287,-79.315,51.215,1],
38150=>[94.300,-79.328,51.172,1],
38151=>[94.314,-79.341,51.131,1],
38152=>[94.327,-79.354,51.089,1],
38153=>[94.340,-79.367,51.047,1],
38154=>[94.353,-79.380,51.005,1],
38155=>[94.366,-79.393,50.964,1],
38156=>[94.380,-79.406,50.922,1],
38157=>[94.393,-79.419,50.881,1],
38158=>[94.406,-79.432,50.841,1],
38716=>[92.980,-79.876,53.072,1],
38717=>[92.996,-79.867,53.049,1],
38718=>[93.012,-79.860,53.027,1],
38719=>[93.028,-79.852,53.006,1],
38720=>[93.044,-79.843,52.985,1],
38721=>[93.060,-79.836,52.965,1],
38722=>[93.076,-79.827,52.946,1],
38723=>[93.092,-79.820,52.929,1],
38724=>[93.109,-79.811,52.913,1],
38725=>[93.126,-79.798,52.899,1],
38726=>[93.144,-79.785,52.887,1],
38727=>[93.162,-79.770,52.875,1],
38728=>[93.179,-79.759,52.866,1],
38729=>[93.185,-79.755,52.859,1],
38730=>[93.192,-79.751,52.853,1],
38731=>[93.210,-79.745,52.851,1],
38732=>[93.233,-79.737,52.848,1],
38733=>[93.256,-79.729,52.846,1],
38734=>[93.279,-79.721,52.844,1],
38735=>[93.302,-79.714,52.844,1],
38736=>[93.325,-79.705,52.844,1],
38737=>[93.348,-79.698,52.844,1],
38738=>[93.371,-79.689,52.842,1],
38739=>[93.394,-79.682,52.840,1],
38740=>[93.416,-79.675,52.837,1],
38741=>[93.436,-79.667,52.833,1],
38742=>[93.444,-79.657,52.826,1],
38743=>[93.452,-79.645,52.818,1],
38744=>[93.461,-79.635,52.810,1],
38745=>[93.469,-79.623,52.799,1],
38746=>[93.482,-79.608,52.789,1],
38747=>[93.497,-79.592,52.778,1],
38748=>[93.512,-79.576,52.768,1],
38749=>[93.526,-79.561,52.758,1],
38750=>[93.541,-79.545,52.748,1],
38751=>[93.556,-79.529,52.742,1],
38752=>[93.570,-79.513,52.737,1],
38753=>[93.585,-79.498,52.731,1],
38754=>[93.600,-79.482,52.724,1],
38755=>[93.614,-79.466,52.715,1],
38756=>[93.629,-79.451,52.706,1],
38757=>[93.643,-79.435,52.696,1],
38758=>[93.665,-79.421,52.687,1],
38759=>[93.693,-79.410,52.677,1],
38760=>[93.721,-79.397,52.667,1],
38761=>[93.736,-79.395,52.657,1],
38762=>[93.751,-79.392,52.651,1],
38763=>[93.766,-79.389,52.645,1],
38764=>[93.780,-79.387,52.641,1],
38765=>[93.795,-79.384,52.643,1],
38766=>[93.810,-79.381,52.645,1],
38767=>[93.825,-79.379,52.645,1],
38768=>[93.840,-79.375,52.643,1],
38769=>[93.855,-79.372,52.642,1],
38770=>[93.864,-79.369,52.641,1],
38771=>[93.868,-79.366,52.638,1],
38772=>[93.873,-79.362,52.637,1],
38773=>[93.877,-79.358,52.636,1],
38774=>[93.882,-79.355,52.636,1],
38775=>[93.887,-79.351,52.630,1],
38776=>[93.891,-79.347,52.623,1],
38777=>[93.894,-79.344,52.614,1],
38778=>[93.886,-79.344,52.602,1],
38779=>[93.879,-79.345,52.589,1],
38780=>[93.871,-79.345,52.576,1],
38781=>[93.864,-79.346,52.560,1],
38782=>[93.857,-79.346,52.548,1],
38783=>[93.849,-79.346,52.535,1],
38784=>[93.842,-79.347,52.522,1],
38785=>[93.840,-79.346,52.511,1],
38786=>[93.848,-79.347,52.498,1],
38787=>[93.856,-79.349,52.485,1],
38788=>[93.865,-79.351,52.473,1],
38789=>[93.874,-79.353,52.460,1],
38790=>[93.884,-79.355,52.445,1],
38791=>[93.893,-79.357,52.430,1],
38792=>[93.902,-79.358,52.415,1],
38793=>[93.911,-79.360,52.400,1],
38794=>[93.921,-79.362,52.384,1],
38795=>[93.930,-79.364,52.368,1],
38796=>[93.939,-79.366,52.353,1],
38797=>[93.948,-79.367,52.337,1],
38798=>[93.958,-79.369,52.320,1],
38799=>[93.967,-79.371,52.303,1],
38800=>[93.976,-79.373,52.285,1],
38801=>[93.985,-79.375,52.267,1],
38802=>[93.994,-79.376,52.250,1],
38803=>[94.023,-79.357,52.232,1],
38804=>[94.053,-79.338,52.215,1],
38805=>[94.082,-79.335,52.198,1],
38806=>[94.087,-79.318,52.181,1],
38807=>[94.087,-79.319,52.164,1],
38808=>[94.090,-79.325,52.146,1],
38809=>[94.076,-79.332,52.128,1],
38810=>[94.096,-79.303,52.111,1],
38811=>[94.117,-79.256,52.093,1],
38812=>[94.132,-79.232,52.077,1],
38813=>[94.140,-79.225,52.061,1],
38814=>[94.148,-79.216,52.044,1],
38815=>[94.157,-79.212,52.025,1],
38816=>[94.165,-79.222,52.007,1],
38817=>[94.174,-79.231,51.989,1],
38818=>[94.180,-79.228,51.973,1],
38819=>[94.184,-79.222,51.955,1],
38820=>[94.198,-79.225,51.939,1],
38821=>[94.205,-79.236,51.924,1],
38822=>[94.212,-79.246,51.912,1],
38823=>[94.219,-79.256,51.900,1],
38824=>[94.226,-79.264,51.890,1],
38825=>[94.231,-79.263,51.881,1],
38826=>[94.237,-79.263,51.869,1],
38827=>[94.242,-79.263,51.855,1],
38828=>[94.247,-79.262,51.841,1],
38829=>[94.252,-79.262,51.825,1],
38830=>[94.258,-79.261,51.809,1],
38831=>[94.263,-79.261,51.793,1],
38832=>[94.270,-79.256,51.774,1],
38833=>[94.278,-79.252,51.754,1],
38834=>[94.286,-79.247,51.734,1],
38835=>[94.293,-79.241,51.713,1],
38836=>[94.301,-79.237,51.690,1],
38837=>[94.310,-79.231,51.665,1],
38838=>[94.302,-79.235,51.638,1],
38839=>[94.283,-79.245,51.610,1],
38840=>[94.265,-79.255,51.581,1],
38841=>[94.247,-79.265,51.551,1],
38842=>[94.249,-79.263,51.520,1],
38843=>[94.252,-79.263,51.487,1],
38844=>[94.255,-79.261,51.455,1],
38845=>[94.257,-79.260,51.424,1],
38846=>[94.260,-79.259,51.389,1],
38847=>[94.258,-79.262,51.351,1],
38848=>[94.260,-79.259,51.311,1],
38849=>[94.269,-79.266,51.269,1],
38850=>[94.279,-79.275,51.226,1],
38851=>[94.292,-79.289,51.182,1],
38852=>[94.305,-79.302,51.141,1],
38853=>[94.318,-79.315,51.099,1],
38854=>[94.331,-79.328,51.057,1],
38855=>[94.345,-79.341,51.015,1],
38856=>[94.358,-79.353,50.973,1],
38857=>[94.371,-79.366,50.932,1],
38858=>[94.384,-79.380,50.890,1],
38859=>[94.397,-79.393,50.849,1],
39418=>[92.992,-79.851,53.069,1],
39419=>[93.008,-79.842,53.046,1],
39420=>[93.024,-79.835,53.024,1],
39421=>[93.040,-79.827,53.003,1],
39422=>[93.056,-79.818,52.982,1],
39423=>[93.072,-79.811,52.963,1],
39424=>[93.088,-79.802,52.945,1],
39425=>[93.105,-79.795,52.929,1],
39426=>[93.121,-79.786,52.914,1],
39427=>[93.139,-79.772,52.900,1],
39428=>[93.157,-79.758,52.888,1],
39429=>[93.175,-79.745,52.877,1],
39430=>[93.192,-79.732,52.868,1],
39431=>[93.199,-79.728,52.862,1],
39432=>[93.206,-79.724,52.858,1],
39433=>[93.228,-79.717,52.856,1],
39434=>[93.251,-79.708,52.854,1],
39435=>[93.274,-79.701,52.852,1],
39436=>[93.297,-79.692,52.850,1],
39437=>[93.320,-79.685,52.848,1],
39438=>[93.343,-79.676,52.847,1],
39439=>[93.366,-79.669,52.845,1],
39440=>[93.389,-79.661,52.842,1],
39441=>[93.411,-79.655,52.838,1],
39442=>[93.433,-79.648,52.832,1],
39443=>[93.447,-79.640,52.826,1],
39444=>[93.455,-79.629,52.819,1],
39445=>[93.463,-79.618,52.811,1],
39446=>[93.471,-79.607,52.801,1],
39447=>[93.479,-79.596,52.791,1],
39448=>[93.487,-79.585,52.780,1],
39449=>[93.495,-79.574,52.771,1],
39450=>[93.503,-79.563,52.760,1],
39451=>[93.517,-79.548,52.750,1],
39452=>[93.532,-79.532,52.745,1],
39453=>[93.546,-79.516,52.741,1],
39454=>[93.561,-79.500,52.736,1],
39455=>[93.575,-79.485,52.729,1],
39456=>[93.590,-79.469,52.720,1],
39457=>[93.605,-79.453,52.711,1],
39458=>[93.623,-79.438,52.701,1],
39459=>[93.651,-79.426,52.691,1],
39460=>[93.679,-79.414,52.681,1],
39461=>[93.707,-79.403,52.671,1],
39462=>[93.732,-79.393,52.660,1],
39463=>[93.747,-79.391,52.652,1],
39464=>[93.762,-79.388,52.646,1],
39465=>[93.776,-79.385,52.640,1],
39466=>[93.791,-79.382,52.641,1],
39467=>[93.806,-79.379,52.642,1],
39468=>[93.821,-79.376,52.642,1],
39469=>[93.835,-79.374,52.640,1],
39470=>[93.839,-79.370,52.639,1],
39471=>[93.844,-79.366,52.638,1],
39472=>[93.848,-79.363,52.637,1],
39473=>[93.853,-79.359,52.636,1],
39474=>[93.857,-79.356,52.635,1],
39475=>[93.865,-79.350,52.634,1],
39476=>[93.877,-79.343,52.629,1],
39477=>[93.890,-79.335,52.622,1],
39478=>[93.896,-79.332,52.613,1],
39479=>[93.895,-79.333,52.601,1],
39480=>[93.894,-79.334,52.590,1],
39481=>[93.888,-79.335,52.577,1],
39482=>[93.880,-79.335,52.563,1],
39483=>[93.873,-79.335,52.552,1],
39484=>[93.865,-79.335,52.541,1],
39485=>[93.858,-79.335,52.531,1],
39486=>[93.860,-79.337,52.519,1],
39487=>[93.863,-79.339,52.507,1],
39488=>[93.870,-79.336,52.494,1],
39489=>[93.878,-79.332,52.481,1],
39490=>[93.887,-79.330,52.467,1],
39491=>[93.894,-79.332,52.452,1],
39492=>[93.902,-79.333,52.435,1],
39493=>[93.910,-79.335,52.418,1],
39494=>[93.918,-79.337,52.401,1],
39495=>[93.925,-79.338,52.383,1],
39496=>[93.933,-79.340,52.366,1],
39497=>[93.941,-79.341,52.350,1],
39498=>[93.949,-79.343,52.334,1],
39499=>[93.957,-79.344,52.318,1],
39500=>[93.965,-79.346,52.301,1],
39501=>[93.972,-79.347,52.283,1],
39502=>[93.980,-79.349,52.264,1],
39503=>[93.987,-79.355,52.248,1],
39504=>[94.015,-79.351,52.230,1],
39505=>[94.044,-79.347,52.213,1],
39506=>[94.073,-79.344,52.196,1],
39507=>[94.068,-79.321,52.177,1],
39508=>[94.059,-79.306,52.159,1],
39509=>[94.062,-79.313,52.139,1],
39510=>[94.065,-79.319,52.122,1],
39511=>[94.078,-79.320,52.104,1],
39512=>[94.100,-79.275,52.086,1],
39513=>[94.122,-79.229,52.070,1],
39514=>[94.135,-79.218,52.054,1],
39515=>[94.143,-79.228,52.037,1],
39516=>[94.151,-79.237,52.018,1],
39517=>[94.159,-79.246,52.000,1],
39518=>[94.166,-79.237,51.982,1],
39519=>[94.173,-79.229,51.967,1],
39520=>[94.175,-79.226,51.950,1],
39521=>[94.185,-79.227,51.935,1],
39522=>[94.201,-79.231,51.921,1],
39523=>[94.208,-79.242,51.910,1],
39524=>[94.215,-79.252,51.900,1],
39525=>[94.222,-79.263,51.890,1],
39526=>[94.227,-79.263,51.880,1],
39527=>[94.232,-79.263,51.868,1],
39528=>[94.238,-79.262,51.855,1],
39529=>[94.243,-79.262,51.842,1],
39530=>[94.249,-79.261,51.826,1],
39531=>[94.254,-79.261,51.809,1],
39532=>[94.260,-79.258,51.792,1],
39533=>[94.268,-79.253,51.773,1],
39534=>[94.276,-79.248,51.752,1],
39535=>[94.284,-79.243,51.731,1],
39536=>[94.292,-79.238,51.711,1],
39537=>[94.299,-79.233,51.688,1],
39538=>[94.308,-79.228,51.663,1],
39539=>[94.316,-79.223,51.637,1],
39540=>[94.314,-79.224,51.609,1],
39541=>[94.295,-79.234,51.580,1],
39542=>[94.276,-79.243,51.549,1],
39543=>[94.269,-79.247,51.520,1],
39544=>[94.272,-79.246,51.490,1],
39545=>[94.275,-79.244,51.459,1],
39546=>[94.277,-79.244,51.428,1],
39547=>[94.280,-79.242,51.394,1],
39548=>[94.254,-79.263,51.357,1],
39549=>[94.262,-79.253,51.318,1],
39550=>[94.277,-79.247,51.278,1],
39551=>[94.285,-79.253,51.236,1],
39552=>[94.294,-79.261,51.193,1],
39553=>[94.302,-79.269,51.150,1],
39554=>[94.311,-79.276,51.108,1],
39555=>[94.323,-79.288,51.066,1],
39556=>[94.336,-79.301,51.024,1],
39557=>[94.349,-79.314,50.983,1],
39558=>[94.362,-79.328,50.941,1],
39559=>[94.376,-79.341,50.899,1],
39560=>[94.389,-79.353,50.857,1],
39561=>[94.402,-79.366,50.817,1],
40120=>[93.004,-79.826,53.066,1],
40121=>[93.020,-79.817,53.043,1],
40122=>[93.036,-79.810,53.022,1],
40123=>[93.052,-79.802,53.000,1],
40124=>[93.068,-79.793,52.980,1],
40125=>[93.084,-79.786,52.962,1],
40126=>[93.100,-79.777,52.946,1],
40127=>[93.116,-79.770,52.929,1],
40128=>[93.133,-79.760,52.915,1],
40129=>[93.151,-79.746,52.902,1],
40130=>[93.169,-79.732,52.890,1],
40131=>[93.187,-79.718,52.880,1],
40132=>[93.206,-79.704,52.872,1],
40133=>[93.212,-79.701,52.868,1],
40134=>[93.223,-79.696,52.864,1],
40135=>[93.246,-79.688,52.862,1],
40136=>[93.269,-79.680,52.859,1],
40137=>[93.292,-79.672,52.857,1],
40138=>[93.315,-79.664,52.854,1],
40139=>[93.338,-79.656,52.851,1],
40140=>[93.361,-79.648,52.848,1],
40141=>[93.383,-79.642,52.844,1],
40142=>[93.405,-79.636,52.839,1],
40143=>[93.427,-79.629,52.834,1],
40144=>[93.450,-79.623,52.827,1],
40145=>[93.458,-79.612,52.820,1],
40146=>[93.466,-79.601,52.812,1],
40147=>[93.474,-79.590,52.803,1],
40148=>[93.482,-79.579,52.794,1],
40149=>[93.490,-79.568,52.783,1],
40150=>[93.498,-79.557,52.774,1],
40151=>[93.506,-79.546,52.765,1],
40152=>[93.514,-79.535,52.757,1],
40153=>[93.521,-79.524,52.751,1],
40154=>[93.530,-79.513,52.746,1],
40155=>[93.538,-79.502,52.741,1],
40156=>[93.552,-79.486,52.735,1],
40157=>[93.566,-79.471,52.726,1],
40158=>[93.581,-79.455,52.716,1],
40159=>[93.609,-79.443,52.705,1],
40160=>[93.637,-79.432,52.695,1],
40161=>[93.665,-79.419,52.685,1],
40162=>[93.693,-79.408,52.674,1],
40163=>[93.721,-79.396,52.663,1],
40164=>[93.743,-79.389,52.654,1],
40165=>[93.758,-79.386,52.647,1],
40166=>[93.772,-79.383,52.642,1],
40167=>[93.787,-79.381,52.639,1],
40168=>[93.802,-79.378,52.639,1],
40169=>[93.810,-79.375,52.639,1],
40170=>[93.815,-79.371,52.637,1],
40171=>[93.819,-79.367,52.637,1],
40172=>[93.824,-79.363,52.636,1],
40173=>[93.835,-79.357,52.636,1],
40174=>[93.847,-79.349,52.634,1],
40175=>[93.860,-79.342,52.633,1],
40176=>[93.872,-79.335,52.633,1],
40177=>[93.885,-79.327,52.628,1],
40178=>[93.897,-79.319,52.621,1],
40179=>[93.898,-79.319,52.612,1],
40180=>[93.896,-79.320,52.601,1],
40181=>[93.895,-79.322,52.590,1],
40182=>[93.894,-79.322,52.579,1],
40183=>[93.893,-79.323,52.567,1],
40184=>[93.889,-79.324,52.556,1],
40185=>[93.882,-79.325,52.546,1],
40186=>[93.877,-79.325,52.536,1],
40187=>[93.880,-79.327,52.524,1],
40188=>[93.884,-79.328,52.511,1],
40189=>[93.888,-79.330,52.497,1],
40190=>[93.893,-79.329,52.483,1],
40191=>[93.901,-79.325,52.468,1],
40192=>[93.909,-79.322,52.452,1],
40193=>[93.917,-79.319,52.434,1],
40194=>[93.925,-79.315,52.416,1],
40195=>[93.933,-79.314,52.399,1],
40196=>[93.941,-79.316,52.381,1],
40197=>[93.948,-79.317,52.365,1],
40198=>[93.957,-79.319,52.349,1],
40199=>[93.964,-79.321,52.332,1],
40200=>[93.972,-79.322,52.316,1],
40201=>[93.980,-79.324,52.299,1],
40202=>[93.988,-79.325,52.281,1],
40203=>[94.000,-79.329,52.262,1],
40204=>[94.006,-79.342,52.246,1],
40205=>[94.006,-79.360,52.229,1],
40206=>[94.035,-79.357,52.211,1],
40207=>[94.063,-79.353,52.194,1],
40208=>[94.048,-79.325,52.175,1],
40209=>[94.031,-79.294,52.155,1],
40210=>[94.034,-79.300,52.134,1],
40211=>[94.051,-79.301,52.115,1],
40212=>[94.071,-79.301,52.097,1],
40213=>[94.091,-79.300,52.079,1],
40214=>[94.113,-79.269,52.064,1],
40215=>[94.129,-79.243,52.047,1],
40216=>[94.137,-79.253,52.030,1],
40217=>[94.145,-79.256,52.012,1],
40218=>[94.151,-79.247,51.993,1],
40219=>[94.158,-79.239,51.975,1],
40220=>[94.164,-79.232,51.961,1],
40221=>[94.165,-79.230,51.946,1],
40222=>[94.172,-79.229,51.933,1],
40223=>[94.189,-79.232,51.921,1],
40224=>[94.203,-79.237,51.911,1],
40225=>[94.210,-79.247,51.901,1],
40226=>[94.218,-79.258,51.890,1],
40227=>[94.224,-79.263,51.879,1],
40228=>[94.229,-79.262,51.867,1],
40229=>[94.235,-79.262,51.855,1],
40230=>[94.240,-79.261,51.842,1],
40231=>[94.245,-79.261,51.826,1],
40232=>[94.251,-79.259,51.809,1],
40233=>[94.259,-79.254,51.791,1],
40234=>[94.266,-79.249,51.772,1],
40235=>[94.274,-79.244,51.752,1],
40236=>[94.282,-79.239,51.732,1],
40237=>[94.290,-79.234,51.712,1],
40238=>[94.298,-79.229,51.688,1],
40239=>[94.306,-79.225,51.663,1],
40240=>[94.314,-79.219,51.637,1],
40241=>[94.322,-79.215,51.609,1],
40242=>[94.325,-79.212,51.581,1],
40243=>[94.307,-79.222,51.552,1],
40244=>[94.290,-79.231,51.524,1],
40245=>[94.292,-79.229,51.494,1],
40246=>[94.295,-79.228,51.464,1],
40247=>[94.297,-79.227,51.432,1],
40248=>[94.266,-79.257,51.397,1],
40249=>[94.255,-79.259,51.361,1],
40250=>[94.260,-79.251,51.324,1],
40251=>[94.282,-79.238,51.285,1],
40252=>[94.294,-79.234,51.244,1],
40253=>[94.302,-79.241,51.203,1],
40254=>[94.311,-79.248,51.161,1],
40255=>[94.319,-79.256,51.118,1],
40256=>[94.327,-79.263,51.075,1],
40257=>[94.335,-79.271,51.034,1],
40258=>[94.344,-79.278,50.992,1],
40259=>[94.354,-79.288,50.949,1],
40260=>[94.367,-79.301,50.907,1],
40261=>[94.381,-79.314,50.866,1],
40262=>[94.394,-79.327,50.825,1],
40822=>[93.016,-79.801,53.063,1],
40823=>[93.032,-79.792,53.041,1],
40824=>[93.048,-79.785,53.020,1],
40825=>[93.064,-79.776,52.999,1],
40826=>[93.080,-79.768,52.980,1],
40827=>[93.096,-79.761,52.963,1],
40828=>[93.112,-79.752,52.947,1],
40829=>[93.128,-79.745,52.932,1],
40830=>[93.145,-79.733,52.918,1],
40831=>[93.163,-79.720,52.906,1],
40832=>[93.182,-79.706,52.895,1],
40833=>[93.200,-79.692,52.885,1],
40834=>[93.218,-79.678,52.880,1],
40835=>[93.226,-79.673,52.875,1],
40836=>[93.241,-79.667,52.871,1],
40837=>[93.264,-79.660,52.866,1],
40838=>[93.287,-79.651,52.863,1],
40839=>[93.310,-79.644,52.861,1],
40840=>[93.333,-79.636,52.857,1],
40841=>[93.356,-79.629,52.853,1],
40842=>[93.378,-79.623,52.847,1],
40843=>[93.400,-79.616,52.841,1],
40844=>[93.422,-79.610,52.836,1],
40845=>[93.444,-79.604,52.829,1],
40846=>[93.461,-79.595,52.821,1],
40847=>[93.469,-79.584,52.814,1],
40848=>[93.477,-79.573,52.805,1],
40849=>[93.485,-79.562,52.796,1],
40850=>[93.493,-79.551,52.786,1],
40851=>[93.500,-79.540,52.778,1],
40852=>[93.508,-79.529,52.769,1],
40853=>[93.516,-79.518,52.762,1],
40854=>[93.524,-79.507,52.755,1],
40855=>[93.533,-79.496,52.749,1],
40856=>[93.540,-79.485,52.744,1],
40857=>[93.549,-79.475,52.739,1],
40858=>[93.559,-79.467,52.730,1],
40859=>[93.572,-79.463,52.720,1],
40860=>[93.596,-79.450,52.708,1],
40861=>[93.623,-79.436,52.696,1],
40862=>[93.651,-79.425,52.685,1],
40863=>[93.679,-79.413,52.674,1],
40864=>[93.707,-79.401,52.665,1],
40865=>[93.735,-79.389,52.657,1],
40866=>[93.754,-79.385,52.651,1],
40867=>[93.768,-79.382,52.646,1],
40868=>[93.781,-79.379,52.641,1],
40869=>[93.786,-79.375,52.638,1],
40870=>[93.791,-79.371,52.637,1],
40871=>[93.804,-79.363,52.635,1],
40872=>[93.817,-79.356,52.635,1],
40873=>[93.829,-79.348,52.635,1],
40874=>[93.842,-79.341,52.634,1],
40875=>[93.854,-79.334,52.634,1],
40876=>[93.867,-79.326,52.633,1],
40877=>[93.880,-79.319,52.632,1],
40878=>[93.892,-79.311,52.627,1],
40879=>[93.901,-79.306,52.621,1],
40880=>[93.899,-79.307,52.612,1],
40881=>[93.898,-79.308,52.601,1],
40882=>[93.897,-79.309,52.591,1],
40883=>[93.895,-79.310,52.581,1],
40884=>[93.894,-79.311,52.570,1],
40885=>[93.893,-79.312,52.560,1],
40886=>[93.890,-79.315,52.550,1],
40887=>[93.896,-79.316,52.540,1],
40888=>[93.902,-79.316,52.528,1],
40889=>[93.905,-79.319,52.514,1],
40890=>[93.908,-79.320,52.498,1],
40891=>[93.912,-79.322,52.484,1],
40892=>[93.916,-79.323,52.468,1],
40893=>[93.924,-79.319,52.451,1],
40894=>[93.932,-79.316,52.432,1],
40895=>[93.940,-79.312,52.416,1],
40896=>[93.948,-79.308,52.399,1],
40897=>[93.956,-79.304,52.381,1],
40898=>[93.964,-79.300,52.366,1],
40899=>[93.972,-79.297,52.349,1],
40900=>[93.980,-79.298,52.332,1],
40901=>[93.987,-79.300,52.315,1],
40902=>[93.995,-79.302,52.297,1],
40903=>[94.009,-79.307,52.280,1],
40904=>[94.025,-79.313,52.262,1],
40905=>[94.026,-79.329,52.245,1],
40906=>[94.017,-79.353,52.228,1],
40907=>[94.026,-79.366,52.211,1],
40908=>[94.047,-79.358,52.193,1],
40909=>[94.029,-79.328,52.173,1],
40910=>[94.013,-79.297,52.153,1],
40911=>[94.026,-79.287,52.132,1],
40912=>[94.045,-79.284,52.113,1],
40913=>[94.064,-79.281,52.094,1],
40914=>[94.084,-79.281,52.075,1],
40915=>[94.104,-79.281,52.058,1],
40916=>[94.124,-79.268,52.042,1],
40917=>[94.131,-79.266,52.025,1],
40918=>[94.137,-79.257,52.006,1],
40919=>[94.143,-79.249,51.988,1],
40920=>[94.150,-79.241,51.971,1],
40921=>[94.154,-79.235,51.958,1],
40922=>[94.156,-79.233,51.946,1],
40923=>[94.158,-79.231,51.936,1],
40924=>[94.175,-79.234,51.926,1],
40925=>[94.192,-79.238,51.914,1],
40926=>[94.206,-79.244,51.902,1],
40927=>[94.213,-79.253,51.891,1],
40928=>[94.220,-79.262,51.879,1],
40929=>[94.225,-79.262,51.867,1],
40930=>[94.230,-79.261,51.855,1],
40931=>[94.236,-79.261,51.841,1],
40932=>[94.241,-79.260,51.826,1],
40933=>[94.249,-79.255,51.810,1],
40934=>[94.257,-79.250,51.792,1],
40935=>[94.265,-79.245,51.772,1],
40936=>[94.272,-79.241,51.752,1],
40937=>[94.280,-79.235,51.734,1],
40938=>[94.288,-79.231,51.715,1],
40939=>[94.296,-79.225,51.691,1],
40940=>[94.304,-79.221,51.665,1],
40941=>[94.312,-79.216,51.639,1],
40942=>[94.320,-79.211,51.612,1],
40943=>[94.328,-79.206,51.584,1],
40944=>[94.335,-79.201,51.557,1],
40945=>[94.318,-79.209,51.530,1],
40946=>[94.313,-79.213,51.500,1],
40947=>[94.315,-79.212,51.468,1],
40948=>[94.296,-79.231,51.435,1],
40949=>[94.261,-79.261,51.400,1],
40950=>[94.255,-79.256,51.364,1],
40951=>[94.258,-79.248,51.329,1],
40952=>[94.285,-79.231,51.291,1],
40953=>[94.299,-79.225,51.252,1],
40954=>[94.311,-79.222,51.211,1],
40955=>[94.319,-79.228,51.169,1],
40956=>[94.327,-79.235,51.127,1],
40957=>[94.335,-79.243,51.085,1],
40958=>[94.344,-79.250,51.043,1],
40959=>[94.352,-79.258,51.001,1],
40960=>[94.360,-79.266,50.958,1],
40961=>[94.368,-79.273,50.916,1],
40962=>[94.377,-79.280,50.875,1],
40963=>[94.385,-79.288,50.834,1],
41524=>[93.028,-79.776,53.061,1],
41525=>[93.044,-79.767,53.040,1],
41526=>[93.060,-79.760,53.019,1],
41527=>[93.076,-79.751,53.000,1],
41528=>[93.092,-79.744,52.982,1],
41529=>[93.108,-79.736,52.965,1],
41530=>[93.124,-79.727,52.949,1],
41531=>[93.140,-79.720,52.935,1],
41532=>[93.157,-79.708,52.921,1],
41533=>[93.176,-79.693,52.910,1],
41534=>[93.194,-79.679,52.900,1],
41535=>[93.212,-79.666,52.893,1],
41536=>[93.230,-79.652,52.887,1],
41537=>[93.240,-79.646,52.881,1],
41538=>[93.259,-79.639,52.876,1],
41539=>[93.282,-79.631,52.872,1],
41540=>[93.305,-79.623,52.868,1],
41541=>[93.328,-79.616,52.862,1],
41542=>[93.350,-79.609,52.856,1],
41543=>[93.372,-79.603,52.850,1],
41544=>[93.395,-79.597,52.843,1],
41545=>[93.417,-79.590,52.838,1],
41546=>[93.439,-79.584,52.831,1],
41547=>[93.461,-79.577,52.824,1],
41548=>[93.472,-79.567,52.815,1],
41549=>[93.480,-79.556,52.807,1],
41550=>[93.487,-79.545,52.799,1],
41551=>[93.495,-79.534,52.790,1],
41552=>[93.503,-79.523,52.782,1],
41553=>[93.511,-79.512,52.773,1],
41554=>[93.521,-79.504,52.765,1],
41555=>[93.531,-79.497,52.758,1],
41556=>[93.541,-79.489,52.752,1],
41557=>[93.551,-79.482,52.747,1],
41558=>[93.561,-79.474,52.741,1],
41559=>[93.571,-79.467,52.732,1],
41560=>[93.587,-79.464,52.722,1],
41561=>[93.604,-79.461,52.711,1],
41562=>[93.621,-79.457,52.697,1],
41563=>[93.647,-79.441,52.686,1],
41564=>[93.672,-79.426,52.676,1],
41565=>[93.698,-79.411,52.668,1],
41566=>[93.723,-79.396,52.662,1],
41567=>[93.750,-79.383,52.656,1],
41568=>[93.761,-79.377,52.650,1],
41569=>[93.774,-79.369,52.644,1],
41570=>[93.786,-79.363,52.639,1],
41571=>[93.799,-79.355,52.636,1],
41572=>[93.811,-79.347,52.636,1],
41573=>[93.824,-79.340,52.636,1],
41574=>[93.836,-79.332,52.636,1],
41575=>[93.849,-79.325,52.635,1],
41576=>[93.861,-79.318,52.634,1],
41577=>[93.874,-79.310,52.634,1],
41578=>[93.887,-79.303,52.634,1],
41579=>[93.899,-79.295,52.630,1],
41580=>[93.902,-79.294,52.623,1],
41581=>[93.901,-79.294,52.614,1],
41582=>[93.898,-79.297,52.605,1],
41583=>[93.895,-79.300,52.595,1],
41584=>[93.891,-79.303,52.584,1],
41585=>[93.888,-79.307,52.572,1],
41586=>[93.885,-79.310,52.563,1],
41587=>[93.888,-79.310,52.553,1],
41588=>[93.896,-79.309,52.543,1],
41589=>[93.905,-79.310,52.530,1],
41590=>[93.917,-79.310,52.515,1],
41591=>[93.929,-79.310,52.500,1],
41592=>[93.933,-79.312,52.484,1],
41593=>[93.936,-79.313,52.467,1],
41594=>[93.939,-79.315,52.450,1],
41595=>[93.946,-79.313,52.432,1],
41596=>[93.955,-79.309,52.415,1],
41597=>[93.963,-79.306,52.399,1],
41598=>[93.971,-79.302,52.383,1],
41599=>[93.978,-79.298,52.368,1],
41600=>[93.986,-79.294,52.351,1],
41601=>[93.994,-79.291,52.332,1],
41602=>[94.005,-79.290,52.314,1],
41603=>[94.019,-79.294,52.296,1],
41604=>[94.034,-79.297,52.279,1],
41605=>[94.047,-79.300,52.261,1],
41606=>[94.045,-79.315,52.244,1],
41607=>[94.038,-79.341,52.228,1],
41608=>[94.029,-79.365,52.211,1],
41609=>[94.028,-79.361,52.192,1],
41610=>[94.019,-79.328,52.173,1],
41611=>[94.011,-79.296,52.153,1],
41612=>[94.026,-79.289,52.131,1],
41613=>[94.046,-79.286,52.111,1],
41614=>[94.065,-79.284,52.092,1],
41615=>[94.084,-79.281,52.073,1],
41616=>[94.104,-79.278,52.057,1],
41617=>[94.112,-79.268,52.040,1],
41618=>[94.123,-79.267,52.024,1],
41619=>[94.129,-79.259,52.005,1],
41620=>[94.136,-79.250,51.987,1],
41621=>[94.142,-79.243,51.972,1],
41622=>[94.144,-79.239,51.960,1],
41623=>[94.146,-79.237,51.949,1],
41624=>[94.148,-79.234,51.940,1],
41625=>[94.161,-79.237,51.931,1],
41626=>[94.179,-79.240,51.919,1],
41627=>[94.196,-79.244,51.906,1],
41628=>[94.209,-79.250,51.893,1],
41629=>[94.216,-79.259,51.879,1],
41630=>[94.221,-79.261,51.867,1],
41631=>[94.227,-79.261,51.855,1],
41632=>[94.232,-79.260,51.843,1],
41633=>[94.240,-79.256,51.827,1],
41634=>[94.247,-79.251,51.811,1],
41635=>[94.255,-79.247,51.794,1],
41636=>[94.263,-79.241,51.774,1],
41637=>[94.271,-79.237,51.755,1],
41638=>[94.278,-79.231,51.737,1],
41639=>[94.286,-79.227,51.718,1],
41640=>[94.294,-79.222,51.694,1],
41641=>[94.302,-79.217,51.669,1],
41642=>[94.310,-79.212,51.642,1],
41643=>[94.318,-79.207,51.616,1],
41644=>[94.326,-79.202,51.590,1],
41645=>[94.333,-79.197,51.565,1],
41646=>[94.341,-79.192,51.536,1],
41647=>[94.333,-79.197,51.506,1],
41648=>[94.327,-79.203,51.473,1],
41649=>[94.274,-79.253,51.438,1],
41650=>[94.261,-79.257,51.403,1],
41651=>[94.256,-79.252,51.368,1],
41652=>[94.255,-79.245,51.333,1],
41653=>[94.282,-79.228,51.296,1],
41654=>[94.305,-79.216,51.258,1],
41655=>[94.316,-79.212,51.219,1],
41656=>[94.327,-79.209,51.178,1],
41657=>[94.336,-79.216,51.136,1],
41658=>[94.344,-79.222,51.095,1],
41659=>[94.352,-79.230,51.052,1],
41660=>[94.360,-79.237,51.010,1],
41661=>[94.368,-79.245,50.968,1],
41662=>[94.377,-79.253,50.925,1],
41663=>[94.385,-79.260,50.884,1],
41664=>[94.394,-79.268,50.843,1],
41724=>[95.166,-80.028,48.741,1],
41725=>[95.186,-80.034,48.705,1],
41726=>[95.210,-80.035,48.668,1],
41727=>[95.233,-80.037,48.631,1],
41728=>[95.257,-80.038,48.595,1],
41729=>[95.280,-80.040,48.560,1],
41730=>[95.304,-80.041,48.524,1],
41731=>[95.328,-80.043,48.489,1],
42226=>[93.040,-79.751,53.061,1],
42227=>[93.056,-79.742,53.040,1],
42228=>[93.072,-79.735,53.020,1],
42229=>[93.088,-79.726,53.001,1],
42230=>[93.104,-79.719,52.984,1],
42231=>[93.120,-79.711,52.967,1],
42232=>[93.136,-79.702,52.952,1],
42233=>[93.152,-79.695,52.938,1],
42234=>[93.170,-79.681,52.926,1],
42235=>[93.188,-79.667,52.915,1],
42236=>[93.206,-79.654,52.906,1],
42237=>[93.224,-79.639,52.899,1],
42238=>[93.242,-79.626,52.893,1],
42239=>[93.255,-79.618,52.887,1],
42240=>[93.277,-79.610,52.881,1],
42241=>[93.300,-79.602,52.875,1],
42242=>[93.323,-79.596,52.868,1],
42243=>[93.345,-79.590,52.861,1],
42244=>[93.367,-79.583,52.855,1],
42245=>[93.389,-79.577,52.848,1],
42246=>[93.411,-79.570,52.843,1],
42247=>[93.433,-79.564,52.837,1],
42248=>[93.455,-79.558,52.829,1],
42249=>[93.474,-79.551,52.822,1],
42250=>[93.484,-79.541,52.813,1],
42251=>[93.493,-79.534,52.804,1],
42252=>[93.503,-79.526,52.796,1],
42253=>[93.513,-79.519,52.787,1],
42254=>[93.523,-79.511,52.778,1],
42255=>[93.533,-79.504,52.769,1],
42256=>[93.543,-79.496,52.761,1],
42257=>[93.553,-79.488,52.754,1],
42258=>[93.563,-79.481,52.748,1],
42259=>[93.573,-79.473,52.741,1],
42260=>[93.587,-79.469,52.732,1],
42261=>[93.603,-79.466,52.722,1],
42262=>[93.619,-79.463,52.710,1],
42263=>[93.635,-79.460,52.699,1],
42264=>[93.651,-79.457,52.689,1],
42265=>[93.673,-79.447,52.679,1],
42266=>[93.698,-79.432,52.673,1],
42267=>[93.723,-79.418,52.667,1],
42268=>[93.745,-79.404,52.661,1],
42269=>[93.758,-79.396,52.654,1],
42270=>[93.771,-79.387,52.648,1],
42271=>[93.784,-79.379,52.642,1],
42272=>[93.797,-79.369,52.638,1],
42273=>[93.809,-79.361,52.638,1],
42274=>[93.823,-79.353,52.639,1],
42275=>[93.836,-79.344,52.639,1],
42276=>[93.848,-79.335,52.637,1],
42277=>[93.861,-79.326,52.637,1],
42278=>[93.873,-79.310,52.637,1],
42279=>[93.885,-79.295,52.637,1],
42280=>[93.897,-79.286,52.633,1],
42281=>[93.897,-79.289,52.626,1],
42282=>[93.893,-79.293,52.618,1],
42283=>[93.890,-79.296,52.609,1],
42284=>[93.886,-79.299,52.599,1],
42285=>[93.883,-79.303,52.587,1],
42286=>[93.880,-79.306,52.574,1],
42287=>[93.878,-79.308,52.564,1],
42288=>[93.889,-79.303,52.554,1],
42289=>[93.897,-79.301,52.543,1],
42290=>[93.903,-79.303,52.530,1],
42291=>[93.913,-79.303,52.515,1],
42292=>[93.926,-79.303,52.501,1],
42293=>[93.938,-79.303,52.484,1],
42294=>[93.951,-79.304,52.468,1],
42295=>[93.961,-79.305,52.451,1],
42296=>[93.964,-79.306,52.434,1],
42297=>[93.969,-79.306,52.417,1],
42298=>[93.977,-79.303,52.401,1],
42299=>[93.985,-79.299,52.385,1],
42300=>[93.993,-79.295,52.369,1],
42301=>[94.001,-79.291,52.351,1],
42302=>[94.016,-79.295,52.332,1],
42303=>[94.030,-79.298,52.313,1],
42304=>[94.032,-79.299,52.295,1],
42305=>[94.034,-79.300,52.277,1],
42306=>[94.036,-79.300,52.260,1],
42307=>[94.038,-79.300,52.243,1],
42308=>[94.036,-79.316,52.227,1],
42309=>[94.030,-79.343,52.210,1],
42310=>[94.024,-79.360,52.192,1],
42311=>[94.016,-79.327,52.174,1],
42312=>[94.008,-79.294,52.154,1],
42313=>[94.027,-79.291,52.131,1],
42314=>[94.046,-79.288,52.111,1],
42315=>[94.065,-79.286,52.092,1],
42316=>[94.084,-79.284,52.073,1],
42317=>[94.091,-79.272,52.057,1],
42318=>[94.097,-79.259,52.041,1],
42319=>[94.115,-79.269,52.024,1],
42320=>[94.121,-79.261,52.006,1],
42321=>[94.128,-79.253,51.989,1],
42322=>[94.133,-79.245,51.974,1],
42323=>[94.135,-79.243,51.963,1],
42324=>[94.137,-79.241,51.954,1],
42325=>[94.138,-79.238,51.945,1],
42326=>[94.148,-79.238,51.937,1],
42327=>[94.165,-79.242,51.924,1],
42328=>[94.182,-79.245,51.911,1],
42329=>[94.199,-79.249,51.896,1],
42330=>[94.212,-79.255,51.881,1],
42331=>[94.218,-79.261,51.868,1],
42332=>[94.223,-79.260,51.856,1],
42333=>[94.229,-79.258,51.845,1],
42334=>[94.238,-79.253,51.829,1],
42335=>[94.246,-79.248,51.812,1],
42336=>[94.253,-79.243,51.795,1],
42337=>[94.261,-79.238,51.776,1],
42338=>[94.269,-79.233,51.757,1],
42339=>[94.277,-79.228,51.738,1],
42340=>[94.284,-79.223,51.718,1],
42341=>[94.292,-79.218,51.695,1],
42342=>[94.300,-79.213,51.670,1],
42343=>[94.308,-79.208,51.644,1],
42344=>[94.316,-79.203,51.621,1],
42345=>[94.324,-79.198,51.597,1],
42346=>[94.332,-79.194,51.572,1],
42347=>[94.339,-79.189,51.544,1],
42348=>[94.345,-79.187,51.512,1],
42349=>[94.305,-79.226,51.479,1],
42350=>[94.267,-79.258,51.443,1],
42351=>[94.262,-79.253,51.409,1],
42352=>[94.257,-79.248,51.374,1],
42353=>[94.253,-79.243,51.340,1],
42354=>[94.280,-79.226,51.304,1],
42355=>[94.307,-79.209,51.266,1],
42356=>[94.321,-79.203,51.227,1],
42357=>[94.332,-79.200,51.187,1],
42358=>[94.344,-79.196,51.146,1],
42359=>[94.352,-79.203,51.104,1],
42360=>[94.360,-79.209,51.062,1],
42361=>[94.369,-79.217,51.019,1],
42362=>[94.377,-79.225,50.977,1],
42363=>[94.386,-79.232,50.935,1],
42364=>[94.394,-79.240,50.893,1],
42365=>[94.402,-79.247,50.852,1],
42424=>[95.144,-79.976,48.779,1],
42425=>[95.158,-79.989,48.743,1],
42426=>[95.176,-79.996,48.707,1],
42427=>[95.200,-79.997,48.671,1],
42428=>[95.224,-79.999,48.634,1],
42429=>[95.247,-80.000,48.597,1],
42430=>[95.271,-80.002,48.561,1],
42431=>[95.294,-80.003,48.526,1],
42432=>[95.318,-80.005,48.490,1],
42433=>[95.341,-80.006,48.455,1],
42434=>[95.365,-80.008,48.419,1],
42928=>[93.052,-79.726,53.062,1],
42929=>[93.068,-79.717,53.041,1],
42930=>[93.084,-79.710,53.022,1],
42931=>[93.100,-79.701,53.004,1],
42932=>[93.116,-79.694,52.987,1],
42933=>[93.132,-79.686,52.971,1],
42934=>[93.148,-79.677,52.957,1],
42935=>[93.164,-79.669,52.944,1],
42936=>[93.183,-79.655,52.932,1],
42937=>[93.201,-79.641,52.922,1],
42938=>[93.219,-79.627,52.912,1],
42939=>[93.237,-79.614,52.904,1],
42940=>[93.255,-79.600,52.898,1],
42941=>[93.272,-79.590,52.891,1],
42942=>[93.295,-79.583,52.883,1],
42943=>[93.317,-79.576,52.875,1],
42944=>[93.339,-79.570,52.868,1],
42945=>[93.361,-79.564,52.862,1],
42946=>[93.382,-79.558,52.856,1],
42947=>[93.403,-79.553,52.850,1],
42948=>[93.425,-79.547,52.844,1],
42949=>[93.446,-79.541,52.836,1],
42950=>[93.467,-79.535,52.829,1],
42951=>[93.483,-79.532,52.820,1],
42952=>[93.499,-79.529,52.811,1],
42953=>[93.515,-79.526,52.803,1],
42954=>[93.525,-79.518,52.794,1],
42955=>[93.536,-79.510,52.785,1],
42956=>[93.546,-79.503,52.776,1],
42957=>[93.555,-79.495,52.767,1],
42958=>[93.565,-79.488,52.760,1],
42959=>[93.575,-79.480,52.752,1],
42960=>[93.586,-79.473,52.746,1],
42961=>[93.602,-79.470,52.737,1],
42962=>[93.618,-79.468,52.726,1],
42963=>[93.634,-79.465,52.713,1],
42964=>[93.650,-79.462,52.704,1],
42965=>[93.666,-79.459,52.695,1],
42966=>[93.682,-79.457,52.686,1],
42967=>[93.698,-79.454,52.679,1],
42968=>[93.723,-79.439,52.672,1],
42969=>[93.741,-79.429,52.666,1],
42970=>[93.754,-79.419,52.660,1],
42971=>[93.766,-79.411,52.653,1],
42972=>[93.779,-79.403,52.648,1],
42973=>[93.791,-79.387,52.644,1],
42974=>[93.802,-79.371,52.643,1],
42975=>[93.814,-79.356,52.643,1],
42976=>[93.826,-79.340,52.642,1],
42977=>[93.838,-79.324,52.641,1],
42978=>[93.849,-79.309,52.641,1],
42979=>[93.861,-79.293,52.641,1],
42980=>[93.874,-79.286,52.640,1],
42981=>[93.888,-79.285,52.636,1],
42982=>[93.888,-79.288,52.630,1],
42983=>[93.885,-79.291,52.621,1],
42984=>[93.881,-79.295,52.613,1],
42985=>[93.878,-79.298,52.602,1],
42986=>[93.874,-79.301,52.589,1],
42987=>[93.871,-79.305,52.577,1],
42988=>[93.880,-79.301,52.566,1],
42989=>[93.891,-79.296,52.555,1],
42990=>[93.899,-79.294,52.544,1],
42991=>[93.904,-79.296,52.530,1],
42992=>[93.910,-79.297,52.516,1],
42993=>[93.922,-79.297,52.502,1],
42994=>[93.934,-79.297,52.485,1],
42995=>[93.947,-79.297,52.469,1],
42996=>[93.960,-79.298,52.452,1],
42997=>[93.972,-79.298,52.436,1],
42998=>[93.985,-79.299,52.419,1],
42999=>[93.992,-79.300,52.403,1],
43000=>[94.000,-79.296,52.386,1],
43001=>[94.011,-79.297,52.368,1],
43002=>[94.014,-79.297,52.350,1],
43003=>[94.016,-79.298,52.331,1],
43004=>[94.018,-79.299,52.311,1],
43005=>[94.020,-79.299,52.293,1],
43006=>[94.023,-79.300,52.275,1],
43007=>[94.025,-79.300,52.257,1],
43008=>[94.027,-79.301,52.240,1],
43009=>[94.029,-79.301,52.224,1],
43010=>[94.026,-79.318,52.208,1],
43011=>[94.020,-79.344,52.192,1],
43012=>[94.013,-79.325,52.175,1],
43013=>[94.008,-79.296,52.155,1],
43014=>[94.027,-79.293,52.132,1],
43015=>[94.047,-79.291,52.111,1],
43016=>[94.066,-79.288,52.092,1],
43017=>[94.071,-79.275,52.073,1],
43018=>[94.077,-79.263,52.056,1],
43019=>[94.082,-79.251,52.041,1],
43020=>[94.100,-79.259,52.027,1],
43021=>[94.113,-79.263,52.009,1],
43022=>[94.120,-79.254,51.993,1],
43023=>[94.124,-79.249,51.979,1],
43024=>[94.125,-79.247,51.969,1],
43025=>[94.127,-79.244,51.960,1],
43026=>[94.129,-79.241,51.951,1],
43027=>[94.134,-79.241,51.942,1],
43028=>[94.151,-79.244,51.929,1],
43029=>[94.168,-79.247,51.914,1],
43030=>[94.185,-79.251,51.900,1],
43031=>[94.202,-79.254,51.884,1],
43032=>[94.214,-79.260,51.871,1],
43033=>[94.220,-79.259,51.858,1],
43034=>[94.228,-79.254,51.847,1],
43035=>[94.236,-79.249,51.831,1],
43036=>[94.244,-79.244,51.813,1],
43037=>[94.251,-79.239,51.795,1],
43038=>[94.259,-79.234,51.777,1],
43039=>[94.267,-79.229,51.757,1],
43040=>[94.273,-79.226,51.737,1],
43041=>[94.280,-79.222,51.717,1],
43042=>[94.286,-79.219,51.694,1],
43043=>[94.293,-79.216,51.670,1],
43044=>[94.299,-79.212,51.647,1],
43045=>[94.306,-79.208,51.625,1],
43046=>[94.313,-79.205,51.603,1],
43047=>[94.319,-79.201,51.578,1],
43048=>[94.321,-79.203,51.551,1],
43049=>[94.317,-79.213,51.520,1],
43050=>[94.282,-79.249,51.485,1],
43051=>[94.268,-79.254,51.449,1],
43052=>[94.263,-79.250,51.415,1],
43053=>[94.258,-79.244,51.381,1],
43054=>[94.252,-79.239,51.347,1],
43055=>[94.278,-79.223,51.312,1],
43056=>[94.305,-79.206,51.275,1],
43057=>[94.327,-79.194,51.235,1],
43058=>[94.338,-79.190,51.196,1],
43059=>[94.349,-79.187,51.155,1],
43060=>[94.360,-79.183,51.113,1],
43061=>[94.369,-79.190,51.071,1],
43062=>[94.377,-79.197,51.029,1],
43063=>[94.386,-79.204,50.987,1],
43064=>[94.394,-79.212,50.945,1],
43065=>[94.402,-79.219,50.903,1],
43066=>[94.410,-79.227,50.862,1],
43124=>[95.123,-79.924,48.818,1],
43125=>[95.136,-79.936,48.781,1],
43126=>[95.149,-79.949,48.745,1],
43127=>[95.167,-79.958,48.709,1],
43128=>[95.190,-79.959,48.672,1],
43129=>[95.214,-79.961,48.636,1],
43130=>[95.237,-79.962,48.599,1],
43131=>[95.261,-79.964,48.563,1],
43132=>[95.284,-79.965,48.527,1],
43133=>[95.308,-79.967,48.492,1],
43134=>[95.332,-79.968,48.456,1],
43135=>[95.355,-79.970,48.421,1],
43136=>[95.379,-79.971,48.386,1],
43629=>[93.048,-79.709,53.084,1],
43630=>[93.064,-79.701,53.063,1],
43631=>[93.080,-79.692,53.043,1],
43632=>[93.095,-79.685,53.025,1],
43633=>[93.112,-79.676,53.008,1],
43634=>[93.128,-79.669,52.992,1],
43635=>[93.144,-79.661,52.976,1],
43636=>[93.160,-79.652,52.962,1],
43637=>[93.177,-79.642,52.950,1],
43638=>[93.195,-79.629,52.939,1],
43639=>[93.213,-79.615,52.928,1],
43640=>[93.231,-79.601,52.918,1],
43641=>[93.249,-79.587,52.910,1],
43642=>[93.267,-79.573,52.901,1],
43643=>[93.286,-79.566,52.892,1],
43644=>[93.307,-79.560,52.886,1],
43645=>[93.329,-79.554,52.879,1],
43646=>[93.350,-79.548,52.872,1],
43647=>[93.371,-79.542,52.866,1],
43648=>[93.392,-79.536,52.859,1],
43649=>[93.413,-79.531,52.852,1],
43650=>[93.435,-79.525,52.845,1],
43651=>[93.456,-79.520,52.837,1],
43652=>[93.474,-79.515,52.829,1],
43653=>[93.490,-79.512,52.819,1],
43654=>[93.505,-79.508,52.811,1],
43655=>[93.521,-79.505,52.802,1],
43656=>[93.537,-79.502,52.793,1],
43657=>[93.553,-79.499,52.785,1],
43658=>[93.567,-79.494,52.776,1],
43659=>[93.577,-79.487,52.768,1],
43660=>[93.587,-79.479,52.760,1],
43661=>[93.601,-79.475,52.753,1],
43662=>[93.617,-79.473,52.743,1],
43663=>[93.633,-79.469,52.732,1],
43664=>[93.649,-79.466,52.720,1],
43665=>[93.665,-79.463,52.710,1],
43666=>[93.681,-79.460,52.702,1],
43667=>[93.694,-79.456,52.694,1],
43668=>[93.707,-79.451,52.686,1],
43669=>[93.720,-79.446,52.679,1],
43670=>[93.732,-79.432,52.673,1],
43671=>[93.744,-79.416,52.666,1],
43672=>[93.756,-79.400,52.659,1],
43673=>[93.767,-79.385,52.654,1],
43674=>[93.779,-79.369,52.650,1],
43675=>[93.791,-79.353,52.649,1],
43676=>[93.802,-79.338,52.649,1],
43677=>[93.814,-79.322,52.649,1],
43678=>[93.826,-79.306,52.647,1],
43679=>[93.837,-79.291,52.647,1],
43680=>[93.851,-79.286,52.646,1],
43681=>[93.865,-79.285,52.644,1],
43682=>[93.879,-79.285,52.639,1],
43683=>[93.880,-79.287,52.633,1],
43684=>[93.876,-79.291,52.625,1],
43685=>[93.873,-79.294,52.616,1],
43686=>[93.869,-79.297,52.605,1],
43687=>[93.866,-79.300,52.592,1],
43688=>[93.870,-79.299,52.579,1],
43689=>[93.881,-79.294,52.568,1],
43690=>[93.892,-79.288,52.558,1],
43691=>[93.900,-79.288,52.545,1],
43692=>[93.906,-79.288,52.533,1],
43693=>[93.911,-79.290,52.519,1],
43694=>[93.918,-79.291,52.504,1],
43695=>[93.930,-79.291,52.487,1],
43696=>[93.943,-79.291,52.470,1],
43697=>[93.956,-79.292,52.453,1],
43698=>[93.968,-79.292,52.438,1],
43699=>[93.981,-79.292,52.422,1],
43700=>[93.994,-79.292,52.404,1],
43701=>[94.004,-79.292,52.385,1],
43702=>[94.003,-79.295,52.367,1],
43703=>[94.003,-79.297,52.348,1],
43704=>[94.004,-79.298,52.329,1],
43705=>[94.007,-79.299,52.310,1],
43706=>[94.009,-79.300,52.291,1],
43707=>[94.011,-79.300,52.273,1],
43708=>[94.013,-79.300,52.255,1],
43709=>[94.015,-79.301,52.238,1],
43710=>[94.017,-79.302,52.223,1],
43711=>[94.019,-79.302,52.207,1],
43712=>[94.017,-79.319,52.192,1],
43713=>[94.010,-79.324,52.175,1],
43714=>[94.008,-79.298,52.155,1],
43715=>[94.028,-79.295,52.133,1],
43716=>[94.046,-79.292,52.113,1],
43717=>[94.051,-79.280,52.094,1],
43718=>[94.057,-79.267,52.077,1],
43719=>[94.063,-79.255,52.062,1],
43720=>[94.068,-79.242,52.048,1],
43721=>[94.084,-79.249,52.035,1],
43722=>[94.103,-79.259,52.019,1],
43723=>[94.112,-79.256,52.004,1],
43724=>[94.114,-79.252,51.992,1],
43725=>[94.116,-79.250,51.982,1],
43726=>[94.118,-79.247,51.973,1],
43727=>[94.120,-79.245,51.964,1],
43728=>[94.121,-79.243,51.953,1],
43729=>[94.137,-79.246,51.939,1],
43730=>[94.154,-79.250,51.923,1],
43731=>[94.172,-79.253,51.907,1],
43732=>[94.189,-79.256,51.891,1],
43733=>[94.208,-79.258,51.876,1],
43734=>[94.214,-79.259,51.862,1],
43735=>[94.221,-79.256,51.850,1],
43736=>[94.227,-79.252,51.833,1],
43737=>[94.234,-79.248,51.815,1],
43738=>[94.241,-79.245,51.796,1],
43739=>[94.247,-79.241,51.776,1],
43740=>[94.254,-79.237,51.755,1],
43741=>[94.260,-79.234,51.735,1],
43742=>[94.267,-79.231,51.715,1],
43743=>[94.273,-79.227,51.692,1],
43744=>[94.280,-79.224,51.670,1],
43745=>[94.286,-79.220,51.650,1],
43746=>[94.292,-79.216,51.630,1],
43747=>[94.299,-79.213,51.608,1],
43748=>[94.297,-79.221,51.585,1],
43749=>[94.293,-79.231,51.558,1],
43750=>[94.290,-79.241,51.527,1],
43751=>[94.274,-79.256,51.493,1],
43752=>[94.269,-79.250,51.458,1],
43753=>[94.264,-79.245,51.423,1],
43754=>[94.258,-79.241,51.389,1],
43755=>[94.253,-79.235,51.355,1],
43756=>[94.275,-79.220,51.321,1],
43757=>[94.302,-79.203,51.284,1],
43758=>[94.330,-79.187,51.245,1],
43759=>[94.343,-79.181,51.204,1],
43760=>[94.354,-79.178,51.164,1],
43761=>[94.365,-79.174,51.123,1],
43762=>[94.377,-79.170,51.081,1],
43763=>[94.386,-79.177,51.039,1],
43764=>[94.394,-79.184,50.997,1],
43765=>[94.402,-79.192,50.954,1],
43766=>[94.410,-79.199,50.913,1],
43767=>[94.419,-79.206,50.873,1],
43824=>[95.102,-79.871,48.858,1],
43825=>[95.115,-79.884,48.821,1],
43826=>[95.128,-79.897,48.784,1],
43827=>[95.141,-79.910,48.748,1],
43828=>[95.157,-79.921,48.711,1],
43829=>[95.180,-79.922,48.674,1],
43830=>[95.204,-79.924,48.637,1],
43831=>[95.228,-79.925,48.601,1],
43832=>[95.251,-79.926,48.565,1],
43833=>[95.275,-79.927,48.529,1],
43834=>[95.298,-79.929,48.493,1],
43835=>[95.322,-79.930,48.457,1],
43836=>[95.345,-79.932,48.423,1],
43837=>[95.369,-79.933,48.387,1],
44331=>[93.060,-79.684,53.086,1],
44332=>[93.075,-79.676,53.066,1],
44333=>[93.091,-79.667,53.047,1],
44334=>[93.108,-79.660,53.030,1],
44335=>[93.124,-79.651,53.013,1],
44336=>[93.140,-79.644,52.997,1],
44337=>[93.156,-79.636,52.982,1],
44338=>[93.171,-79.627,52.969,1],
44339=>[93.189,-79.617,52.956,1],
44340=>[93.207,-79.602,52.944,1],
44341=>[93.225,-79.588,52.933,1],
44342=>[93.243,-79.575,52.924,1],
44343=>[93.262,-79.561,52.914,1],
44344=>[93.280,-79.550,52.904,1],
44345=>[93.298,-79.544,52.898,1],
44346=>[93.318,-79.538,52.890,1],
44347=>[93.339,-79.532,52.884,1],
44348=>[93.360,-79.526,52.878,1],
44349=>[93.381,-79.520,52.872,1],
44350=>[93.402,-79.515,52.865,1],
44351=>[93.423,-79.509,52.858,1],
44352=>[93.445,-79.503,52.850,1],
44353=>[93.465,-79.498,52.842,1],
44354=>[93.480,-79.494,52.833,1],
44355=>[93.496,-79.491,52.824,1],
44356=>[93.512,-79.488,52.814,1],
44357=>[93.528,-79.485,52.805,1],
44358=>[93.544,-79.482,52.796,1],
44359=>[93.559,-79.479,52.789,1],
44360=>[93.575,-79.476,52.780,1],
44361=>[93.588,-79.472,52.772,1],
44362=>[93.603,-79.467,52.761,1],
44363=>[93.616,-79.462,52.750,1],
44364=>[93.628,-79.457,52.739,1],
44365=>[93.641,-79.452,52.729,1],
44366=>[93.654,-79.447,52.719,1],
44367=>[93.667,-79.443,52.711,1],
44368=>[93.680,-79.438,52.704,1],
44369=>[93.693,-79.433,52.695,1],
44370=>[93.707,-79.426,52.688,1],
44371=>[93.720,-79.414,52.681,1],
44372=>[93.732,-79.398,52.673,1],
44373=>[93.744,-79.382,52.666,1],
44374=>[93.756,-79.367,52.660,1],
44375=>[93.767,-79.351,52.657,1],
44376=>[93.779,-79.336,52.656,1],
44377=>[93.790,-79.320,52.656,1],
44378=>[93.802,-79.304,52.655,1],
44379=>[93.814,-79.289,52.654,1],
44380=>[93.827,-79.285,52.653,1],
44381=>[93.841,-79.285,52.651,1],
44382=>[93.855,-79.285,52.648,1],
44383=>[93.869,-79.284,52.643,1],
44384=>[93.871,-79.286,52.636,1],
44385=>[93.867,-79.289,52.627,1],
44386=>[93.864,-79.293,52.619,1],
44387=>[93.861,-79.296,52.608,1],
44388=>[93.860,-79.297,52.595,1],
44389=>[93.871,-79.292,52.583,1],
44390=>[93.883,-79.287,52.572,1],
44391=>[93.894,-79.281,52.561,1],
44392=>[93.902,-79.280,52.548,1],
44393=>[93.907,-79.281,52.535,1],
44394=>[93.913,-79.283,52.521,1],
44395=>[93.919,-79.284,52.506,1],
44396=>[93.926,-79.285,52.489,1],
44397=>[93.939,-79.285,52.472,1],
44398=>[93.952,-79.285,52.456,1],
44399=>[93.964,-79.286,52.439,1],
44400=>[93.980,-79.285,52.421,1],
44401=>[93.995,-79.283,52.403,1],
44402=>[94.004,-79.283,52.385,1],
44403=>[94.004,-79.286,52.367,1],
44404=>[94.003,-79.288,52.348,1],
44405=>[94.003,-79.291,52.329,1],
44406=>[94.003,-79.294,52.310,1],
44407=>[94.002,-79.296,52.291,1],
44408=>[94.002,-79.298,52.272,1],
44409=>[94.002,-79.300,52.254,1],
44410=>[94.004,-79.301,52.238,1],
44411=>[94.006,-79.302,52.222,1],
44412=>[94.008,-79.302,52.207,1],
44413=>[94.010,-79.303,52.192,1],
44414=>[94.007,-79.320,52.175,1],
44415=>[94.009,-79.300,52.156,1],
44416=>[94.026,-79.296,52.135,1],
44417=>[94.031,-79.284,52.116,1],
44418=>[94.037,-79.271,52.098,1],
44419=>[94.043,-79.259,52.083,1],
44420=>[94.048,-79.247,52.070,1],
44421=>[94.054,-79.234,52.057,1],
44422=>[94.069,-79.239,52.045,1],
44423=>[94.087,-79.250,52.031,1],
44424=>[94.103,-79.258,52.018,1],
44425=>[94.105,-79.256,52.007,1],
44426=>[94.107,-79.253,51.997,1],
44427=>[94.109,-79.250,51.987,1],
44428=>[94.112,-79.247,51.977,1],
44429=>[94.114,-79.243,51.965,1],
44430=>[94.129,-79.243,51.949,1],
44431=>[94.148,-79.244,51.932,1],
44432=>[94.167,-79.246,51.914,1],
44433=>[94.186,-79.247,51.898,1],
44434=>[94.197,-79.253,51.882,1],
44435=>[94.202,-79.265,51.866,1],
44436=>[94.208,-79.264,51.852,1],
44437=>[94.214,-79.260,51.834,1],
44438=>[94.221,-79.256,51.816,1],
44439=>[94.227,-79.253,51.797,1],
44440=>[94.234,-79.250,51.776,1],
44441=>[94.241,-79.246,51.755,1],
44442=>[94.247,-79.242,51.735,1],
44443=>[94.253,-79.239,51.716,1],
44444=>[94.260,-79.235,51.694,1],
44445=>[94.266,-79.231,51.672,1],
44446=>[94.273,-79.228,51.652,1],
44447=>[94.277,-79.228,51.632,1],
44448=>[94.273,-79.238,51.611,1],
44449=>[94.270,-79.248,51.588,1],
44450=>[94.266,-79.257,51.564,1],
44451=>[94.268,-79.251,51.536,1],
44452=>[94.275,-79.252,51.503,1],
44453=>[94.270,-79.247,51.468,1],
44454=>[94.264,-79.241,51.433,1],
44455=>[94.259,-79.237,51.399,1],
44456=>[94.254,-79.231,51.366,1],
44457=>[94.273,-79.218,51.331,1],
44458=>[94.300,-79.201,51.294,1],
44459=>[94.327,-79.184,51.255,1],
44460=>[94.348,-79.172,51.214,1],
44461=>[94.360,-79.169,51.174,1],
44462=>[94.371,-79.165,51.132,1],
44463=>[94.383,-79.161,51.091,1],
44464=>[94.394,-79.158,51.049,1],
44465=>[94.402,-79.164,51.007,1],
44466=>[94.410,-79.172,50.964,1],
44467=>[94.419,-79.179,50.923,1],
44468=>[94.427,-79.186,50.883,1],
44524=>[95.080,-79.819,48.897,1],
44525=>[95.093,-79.832,48.861,1],
44526=>[95.106,-79.845,48.824,1],
44527=>[95.119,-79.858,48.787,1],
44528=>[95.132,-79.871,48.750,1],
44529=>[95.147,-79.883,48.713,1],
44530=>[95.171,-79.884,48.676,1],
44531=>[95.194,-79.886,48.639,1],
44532=>[95.218,-79.887,48.603,1],
44533=>[95.241,-79.889,48.567,1],
44534=>[95.265,-79.890,48.531,1],
44535=>[95.288,-79.892,48.495,1],
44536=>[95.312,-79.893,48.459,1],
44537=>[95.336,-79.895,48.424,1],
44538=>[95.359,-79.896,48.389,1],
44539=>[95.383,-79.897,48.353,1],
45033=>[93.071,-79.659,53.089,1],
45034=>[93.087,-79.651,53.070,1],
45035=>[93.103,-79.642,53.051,1],
45036=>[93.120,-79.635,53.034,1],
45037=>[93.136,-79.626,53.017,1],
45038=>[93.152,-79.619,53.002,1],
45039=>[93.167,-79.610,52.988,1],
45040=>[93.184,-79.602,52.975,1],
45041=>[93.201,-79.590,52.962,1],
45042=>[93.219,-79.576,52.950,1],
45043=>[93.237,-79.563,52.939,1],
45044=>[93.256,-79.548,52.928,1],
45045=>[93.274,-79.535,52.919,1],
45046=>[93.292,-79.529,52.910,1],
45047=>[93.311,-79.523,52.903,1],
45048=>[93.330,-79.516,52.896,1],
45049=>[93.349,-79.510,52.892,1],
45050=>[93.370,-79.504,52.886,1],
45051=>[93.391,-79.498,52.880,1],
45052=>[93.412,-79.493,52.873,1],
45053=>[93.433,-79.487,52.866,1],
45054=>[93.455,-79.482,52.857,1],
45055=>[93.471,-79.478,52.848,1],
45056=>[93.487,-79.475,52.839,1],
45057=>[93.502,-79.472,52.829,1],
45058=>[93.518,-79.468,52.819,1],
45059=>[93.534,-79.465,52.810,1],
45060=>[93.550,-79.462,52.801,1],
45061=>[93.560,-79.457,52.792,1],
45062=>[93.570,-79.453,52.782,1],
45063=>[93.586,-79.448,52.770,1],
45064=>[93.602,-79.444,52.759,1],
45065=>[93.615,-79.439,52.749,1],
45066=>[93.628,-79.435,52.739,1],
45067=>[93.640,-79.429,52.729,1],
45068=>[93.653,-79.425,52.721,1],
45069=>[93.666,-79.419,52.713,1],
45070=>[93.680,-79.415,52.705,1],
45071=>[93.694,-79.407,52.698,1],
45072=>[93.708,-79.396,52.690,1],
45073=>[93.720,-79.381,52.682,1],
45074=>[93.732,-79.365,52.674,1],
45075=>[93.744,-79.349,52.667,1],
45076=>[93.755,-79.334,52.665,1],
45077=>[93.767,-79.318,52.664,1],
45078=>[93.778,-79.303,52.664,1],
45079=>[93.790,-79.287,52.662,1],
45080=>[93.804,-79.285,52.660,1],
45081=>[93.818,-79.285,52.658,1],
45082=>[93.832,-79.284,52.656,1],
45083=>[93.846,-79.283,52.651,1],
45084=>[93.860,-79.282,52.645,1],
45085=>[93.862,-79.285,52.638,1],
45086=>[93.859,-79.288,52.629,1],
45087=>[93.856,-79.291,52.621,1],
45088=>[93.852,-79.294,52.610,1],
45089=>[93.862,-79.291,52.598,1],
45090=>[93.873,-79.285,52.587,1],
45091=>[93.885,-79.279,52.576,1],
45092=>[93.896,-79.274,52.565,1],
45093=>[93.903,-79.273,52.552,1],
45094=>[93.909,-79.275,52.538,1],
45095=>[93.914,-79.275,52.524,1],
45096=>[93.920,-79.277,52.508,1],
45097=>[93.926,-79.278,52.492,1],
45098=>[93.935,-79.279,52.475,1],
45099=>[93.949,-79.278,52.458,1],
45100=>[93.965,-79.277,52.441,1],
45101=>[93.981,-79.275,52.422,1],
45102=>[93.996,-79.274,52.404,1],
45103=>[94.005,-79.274,52.386,1],
45104=>[94.005,-79.277,52.368,1],
45105=>[94.004,-79.279,52.350,1],
45106=>[94.004,-79.281,52.331,1],
45107=>[94.003,-79.285,52.311,1],
45108=>[94.003,-79.287,52.293,1],
45109=>[94.002,-79.289,52.275,1],
45110=>[94.002,-79.292,52.256,1],
45111=>[94.002,-79.294,52.239,1],
45112=>[94.001,-79.297,52.223,1],
45113=>[94.001,-79.300,52.209,1],
45114=>[94.000,-79.302,52.194,1],
45115=>[94.001,-79.303,52.178,1],
45116=>[94.006,-79.300,52.159,1],
45117=>[94.011,-79.288,52.138,1],
45118=>[94.017,-79.275,52.120,1],
45119=>[94.023,-79.263,52.103,1],
45120=>[94.028,-79.250,52.090,1],
45121=>[94.034,-79.237,52.079,1],
45122=>[94.040,-79.225,52.069,1],
45123=>[94.054,-79.229,52.058,1],
45124=>[94.072,-79.240,52.047,1],
45125=>[94.098,-79.256,52.036,1],
45126=>[94.101,-79.254,52.025,1],
45127=>[94.104,-79.250,52.013,1],
45128=>[94.107,-79.245,52.002,1],
45129=>[94.110,-79.240,51.990,1],
45130=>[94.113,-79.234,51.976,1],
45131=>[94.125,-79.234,51.960,1],
45132=>[94.144,-79.235,51.942,1],
45133=>[94.164,-79.237,51.923,1],
45134=>[94.181,-79.239,51.905,1],
45135=>[94.185,-79.250,51.887,1],
45136=>[94.190,-79.262,51.870,1],
45137=>[94.195,-79.272,51.853,1],
45138=>[94.201,-79.269,51.835,1],
45139=>[94.207,-79.265,51.816,1],
45140=>[94.214,-79.261,51.796,1],
45141=>[94.220,-79.258,51.775,1],
45142=>[94.227,-79.254,51.755,1],
45143=>[94.234,-79.250,51.736,1],
45144=>[94.240,-79.247,51.718,1],
45145=>[94.247,-79.244,51.697,1],
45146=>[94.253,-79.240,51.675,1],
45147=>[94.253,-79.246,51.655,1],
45148=>[94.249,-79.255,51.634,1],
45149=>[94.246,-79.265,51.614,1],
45150=>[94.248,-79.256,51.592,1],
45151=>[94.251,-79.244,51.569,1],
45152=>[94.258,-79.227,51.542,1],
45153=>[94.276,-79.206,51.511,1],
45154=>[94.270,-79.243,51.477,1],
45155=>[94.265,-79.237,51.443,1],
45156=>[94.260,-79.233,51.409,1],
45157=>[94.255,-79.228,51.377,1],
45158=>[94.270,-79.215,51.342,1],
45159=>[94.298,-79.198,51.304,1],
45160=>[94.325,-79.181,51.264,1],
45161=>[94.352,-79.165,51.224,1],
45162=>[94.365,-79.159,51.183,1],
45163=>[94.377,-79.156,51.142,1],
45164=>[94.388,-79.152,51.100,1],
45165=>[94.399,-79.149,51.059,1],
45166=>[94.410,-79.145,51.018,1],
45167=>[94.419,-79.151,50.975,1],
45168=>[94.427,-79.159,50.934,1],
45169=>[94.435,-79.166,50.894,1],
45224=>[95.058,-79.767,48.938,1],
45225=>[95.071,-79.780,48.901,1],
45226=>[95.085,-79.792,48.864,1],
45227=>[95.098,-79.805,48.827,1],
45228=>[95.111,-79.818,48.791,1],
45229=>[95.124,-79.832,48.753,1],
45230=>[95.137,-79.845,48.715,1],
45231=>[95.161,-79.846,48.678,1],
45232=>[95.184,-79.848,48.642,1],
45233=>[95.208,-79.849,48.605,1],
45234=>[95.232,-79.851,48.568,1],
45235=>[95.255,-79.852,48.533,1],
45236=>[95.279,-79.854,48.498,1],
45237=>[95.302,-79.855,48.462,1],
45238=>[95.326,-79.857,48.426,1],
45239=>[95.349,-79.858,48.390,1],
45240=>[95.373,-79.860,48.355,1],
45241=>[95.397,-79.861,48.320,1],
45735=>[93.083,-79.634,53.092,1],
45736=>[93.099,-79.626,53.074,1],
45737=>[93.116,-79.617,53.056,1],
45738=>[93.132,-79.610,53.039,1],
45739=>[93.147,-79.601,53.023,1],
45740=>[93.163,-79.594,53.008,1],
45741=>[93.180,-79.585,52.995,1],
45742=>[93.196,-79.577,52.982,1],
45743=>[93.214,-79.563,52.970,1],
45744=>[93.232,-79.550,52.958,1],
45745=>[93.250,-79.536,52.947,1],
45746=>[93.268,-79.523,52.936,1],
45747=>[93.286,-79.513,52.928,1],
45748=>[93.305,-79.507,52.920,1],
45749=>[93.324,-79.501,52.913,1],
45750=>[93.342,-79.494,52.908,1],
45751=>[93.360,-79.488,52.904,1],
45752=>[93.380,-79.482,52.898,1],
45753=>[93.401,-79.477,52.892,1],
45754=>[93.422,-79.471,52.883,1],
45755=>[93.444,-79.465,52.874,1],
45756=>[93.462,-79.461,52.864,1],
45757=>[93.477,-79.458,52.855,1],
45758=>[93.493,-79.454,52.845,1],
45759=>[93.509,-79.451,52.835,1],
45760=>[93.521,-79.447,52.825,1],
45761=>[93.532,-79.443,52.815,1],
45762=>[93.541,-79.438,52.805,1],
45763=>[93.552,-79.434,52.793,1],
45764=>[93.568,-79.429,52.781,1],
45765=>[93.585,-79.426,52.770,1],
45766=>[93.601,-79.421,52.760,1],
45767=>[93.614,-79.416,52.749,1],
45768=>[93.627,-79.411,52.740,1],
45769=>[93.640,-79.407,52.732,1],
45770=>[93.653,-79.401,52.723,1],
45771=>[93.666,-79.397,52.715,1],
45772=>[93.681,-79.386,52.707,1],
45773=>[93.695,-79.376,52.700,1],
45774=>[93.708,-79.363,52.692,1],
45775=>[93.720,-79.347,52.685,1],
45776=>[93.731,-79.332,52.680,1],
45777=>[93.743,-79.316,52.675,1],
45778=>[93.755,-79.300,52.672,1],
45779=>[93.767,-79.285,52.670,1],
45780=>[93.781,-79.285,52.667,1],
45781=>[93.795,-79.284,52.665,1],
45782=>[93.809,-79.284,52.662,1],
45783=>[93.823,-79.283,52.658,1],
45784=>[93.837,-79.282,52.653,1],
45785=>[93.851,-79.281,52.647,1],
45786=>[93.854,-79.284,52.640,1],
45787=>[93.851,-79.287,52.632,1],
45788=>[93.847,-79.291,52.623,1],
45789=>[93.852,-79.288,52.612,1],
45790=>[93.864,-79.283,52.600,1],
45791=>[93.875,-79.278,52.590,1],
45792=>[93.886,-79.272,52.579,1],
45793=>[93.897,-79.267,52.567,1],
45794=>[93.905,-79.266,52.555,1],
45795=>[93.910,-79.267,52.541,1],
45796=>[93.916,-79.269,52.526,1],
45797=>[93.922,-79.270,52.510,1],
45798=>[93.927,-79.271,52.494,1],
45799=>[93.936,-79.270,52.478,1],
45800=>[93.951,-79.269,52.461,1],
45801=>[93.966,-79.268,52.443,1],
45802=>[93.982,-79.266,52.424,1],
45803=>[93.997,-79.265,52.407,1],
45804=>[94.006,-79.266,52.389,1],
45805=>[94.005,-79.268,52.371,1],
45806=>[94.005,-79.270,52.352,1],
45807=>[94.004,-79.273,52.333,1],
45808=>[94.004,-79.275,52.313,1],
45809=>[94.004,-79.278,52.295,1],
45810=>[94.003,-79.281,52.278,1],
45811=>[94.003,-79.283,52.260,1],
45812=>[94.002,-79.285,52.243,1],
45813=>[94.002,-79.288,52.226,1],
45814=>[94.001,-79.291,52.211,1],
45815=>[94.001,-79.293,52.196,1],
45816=>[94.003,-79.292,52.180,1],
45817=>[94.004,-79.288,52.163,1],
45818=>[94.002,-79.278,52.143,1],
45819=>[94.002,-79.266,52.126,1],
45820=>[94.008,-79.254,52.111,1],
45821=>[94.014,-79.241,52.098,1],
45822=>[94.019,-79.229,52.088,1],
45823=>[94.025,-79.217,52.079,1],
45824=>[94.039,-79.219,52.072,1],
45825=>[94.061,-79.233,52.062,1],
45826=>[94.085,-79.246,52.052,1],
45827=>[94.099,-79.247,52.042,1],
45828=>[94.102,-79.242,52.029,1],
45829=>[94.105,-79.237,52.017,1],
45830=>[94.108,-79.231,52.004,1],
45831=>[94.111,-79.226,51.990,1],
45832=>[94.122,-79.225,51.972,1],
45833=>[94.141,-79.226,51.953,1],
45834=>[94.160,-79.228,51.933,1],
45835=>[94.169,-79.236,51.913,1],
45836=>[94.174,-79.247,51.893,1],
45837=>[94.178,-79.259,51.874,1],
45838=>[94.183,-79.269,51.855,1],
45839=>[94.188,-79.277,51.835,1],
45840=>[94.194,-79.273,51.814,1],
45841=>[94.201,-79.269,51.795,1],
45842=>[94.207,-79.266,51.775,1],
45843=>[94.214,-79.263,51.756,1],
45844=>[94.220,-79.259,51.738,1],
45845=>[94.227,-79.256,51.719,1],
45846=>[94.232,-79.253,51.700,1],
45847=>[94.229,-79.263,51.679,1],
45848=>[94.225,-79.272,51.658,1],
45849=>[94.228,-79.263,51.637,1],
45850=>[94.231,-79.249,51.617,1],
45851=>[94.235,-79.236,51.597,1],
45852=>[94.238,-79.222,51.573,1],
45853=>[94.253,-79.199,51.546,1],
45854=>[94.273,-79.169,51.517,1],
45855=>[94.271,-79.226,51.484,1],
45856=>[94.266,-79.234,51.451,1],
45857=>[94.261,-79.228,51.419,1],
45858=>[94.255,-79.224,51.387,1],
45859=>[94.268,-79.212,51.352,1],
45860=>[94.295,-79.195,51.314,1],
45861=>[94.323,-79.178,51.273,1],
45862=>[94.350,-79.162,51.233,1],
45863=>[94.370,-79.150,51.192,1],
45864=>[94.382,-79.147,51.150,1],
45865=>[94.393,-79.143,51.110,1],
45866=>[94.404,-79.140,51.069,1],
45867=>[94.416,-79.136,51.028,1],
45868=>[94.427,-79.132,50.985,1],
45869=>[94.435,-79.138,50.945,1],
45870=>[94.444,-79.146,50.906,1],
45924=>[95.037,-79.714,48.978,1],
45925=>[95.050,-79.727,48.941,1],
45926=>[95.063,-79.740,48.904,1],
45927=>[95.076,-79.753,48.867,1],
45928=>[95.090,-79.767,48.830,1],
45929=>[95.103,-79.780,48.793,1],
45930=>[95.116,-79.792,48.756,1],
45931=>[95.129,-79.805,48.718,1],
45932=>[95.151,-79.808,48.682,1],
45933=>[95.175,-79.810,48.645,1],
45934=>[95.198,-79.811,48.608,1],
45935=>[95.222,-79.813,48.571,1],
45936=>[95.245,-79.814,48.537,1],
45937=>[95.269,-79.816,48.501,1],
45938=>[95.293,-79.817,48.465,1],
45939=>[95.316,-79.819,48.429,1],
45940=>[95.340,-79.820,48.393,1],
45941=>[95.363,-79.822,48.358,1],
45942=>[95.387,-79.823,48.324,1],
46436=>[93.079,-79.617,53.115,1],
46437=>[93.095,-79.609,53.096,1],
46438=>[93.112,-79.601,53.078,1],
46439=>[93.127,-79.592,53.061,1],
46440=>[93.143,-79.585,53.045,1],
46441=>[93.159,-79.576,53.030,1],
46442=>[93.176,-79.569,53.016,1],
46443=>[93.192,-79.560,53.002,1],
46444=>[93.208,-79.551,52.990,1],
46445=>[93.226,-79.538,52.978,1],
46446=>[93.244,-79.524,52.966,1],
46447=>[93.263,-79.510,52.955,1],
46448=>[93.281,-79.498,52.946,1],
46449=>[93.299,-79.491,52.938,1],
46450=>[93.318,-79.485,52.931,1],
46451=>[93.336,-79.479,52.927,1],
46452=>[93.355,-79.473,52.922,1],
46453=>[93.373,-79.467,52.916,1],
46454=>[93.392,-79.461,52.909,1],
46455=>[93.411,-79.455,52.901,1],
46456=>[93.432,-79.449,52.893,1],
46457=>[93.452,-79.444,52.885,1],
46458=>[93.468,-79.441,52.875,1],
46459=>[93.484,-79.438,52.865,1],
46460=>[93.493,-79.433,52.854,1],
46461=>[93.503,-79.429,52.843,1],
46462=>[93.513,-79.424,52.832,1],
46463=>[93.523,-79.419,52.820,1],
46464=>[93.534,-79.415,52.807,1],
46465=>[93.551,-79.411,52.795,1],
46466=>[93.567,-79.407,52.784,1],
46467=>[93.584,-79.402,52.773,1],
46468=>[93.600,-79.398,52.761,1],
46469=>[93.613,-79.393,52.752,1],
46470=>[93.626,-79.388,52.743,1],
46471=>[93.639,-79.383,52.734,1],
46472=>[93.652,-79.376,52.725,1],
46473=>[93.667,-79.366,52.717,1],
46474=>[93.682,-79.357,52.710,1],
46475=>[93.696,-79.345,52.704,1],
46476=>[93.708,-79.329,52.699,1],
46477=>[93.720,-79.314,52.694,1],
46478=>[93.731,-79.298,52.688,1],
46479=>[93.744,-79.285,52.683,1],
46480=>[93.758,-79.285,52.678,1],
46481=>[93.771,-79.284,52.674,1],
46482=>[93.785,-79.283,52.671,1],
46483=>[93.799,-79.282,52.667,1],
46484=>[93.814,-79.282,52.663,1],
46485=>[93.828,-79.281,52.657,1],
46486=>[93.842,-79.281,52.651,1],
46487=>[93.846,-79.282,52.644,1],
46488=>[93.842,-79.286,52.636,1],
46489=>[93.843,-79.287,52.627,1],
46490=>[93.854,-79.281,52.616,1],
46491=>[93.865,-79.276,52.605,1],
46492=>[93.876,-79.270,52.595,1],
46493=>[93.888,-79.265,52.584,1],
46494=>[93.899,-79.259,52.573,1],
46495=>[93.906,-79.259,52.560,1],
46496=>[93.912,-79.260,52.547,1],
46497=>[93.917,-79.262,52.532,1],
46498=>[93.923,-79.263,52.517,1],
46499=>[93.931,-79.263,52.500,1],
46500=>[93.941,-79.261,52.482,1],
46501=>[93.952,-79.260,52.464,1],
46502=>[93.967,-79.259,52.446,1],
46503=>[93.983,-79.257,52.429,1],
46504=>[93.998,-79.256,52.412,1],
46505=>[94.007,-79.256,52.394,1],
46506=>[94.006,-79.259,52.375,1],
46507=>[94.006,-79.261,52.356,1],
46508=>[94.005,-79.264,52.335,1],
46509=>[94.005,-79.266,52.316,1],
46510=>[94.004,-79.269,52.299,1],
46511=>[94.004,-79.272,52.283,1],
46512=>[94.004,-79.274,52.266,1],
46513=>[94.003,-79.276,52.248,1],
46514=>[94.003,-79.279,52.230,1],
46515=>[94.004,-79.279,52.213,1],
46516=>[94.007,-79.278,52.197,1],
46517=>[94.010,-79.277,52.182,1],
46518=>[94.011,-79.273,52.167,1],
46519=>[94.008,-79.263,52.149,1],
46520=>[94.006,-79.253,52.133,1],
46521=>[94.004,-79.243,52.119,1],
46522=>[94.001,-79.232,52.107,1],
46523=>[94.005,-79.221,52.097,1],
46524=>[94.010,-79.208,52.089,1],
46525=>[94.025,-79.210,52.085,1],
46526=>[94.047,-79.220,52.076,1],
46527=>[94.065,-79.225,52.066,1],
46528=>[94.083,-79.230,52.056,1],
46529=>[94.100,-79.234,52.043,1],
46530=>[94.103,-79.228,52.031,1],
46531=>[94.106,-79.223,52.017,1],
46532=>[94.109,-79.218,52.002,1],
46533=>[94.119,-79.216,51.983,1],
46534=>[94.138,-79.217,51.963,1],
46535=>[94.153,-79.222,51.942,1],
46536=>[94.157,-79.232,51.920,1],
46537=>[94.162,-79.244,51.899,1],
46538=>[94.167,-79.255,51.877,1],
46539=>[94.171,-79.266,51.857,1],
46540=>[94.176,-79.278,51.835,1],
46541=>[94.181,-79.281,51.815,1],
46542=>[94.188,-79.278,51.796,1],
46543=>[94.194,-79.274,51.778,1],
46544=>[94.200,-79.271,51.761,1],
46545=>[94.207,-79.267,51.742,1],
46546=>[94.209,-79.270,51.724,1],
46547=>[94.205,-79.280,51.705,1],
46548=>[94.208,-79.268,51.685,1],
46549=>[94.211,-79.255,51.664,1],
46550=>[94.215,-79.241,51.643,1],
46551=>[94.218,-79.228,51.622,1],
46552=>[94.221,-79.215,51.601,1],
46553=>[94.226,-79.200,51.576,1],
46554=>[94.247,-79.170,51.550,1],
46555=>[94.268,-79.140,51.522,1],
46556=>[94.273,-79.171,51.491,1],
46557=>[94.267,-79.230,51.460,1],
46558=>[94.261,-79.225,51.429,1],
46559=>[94.256,-79.220,51.396,1],
46560=>[94.266,-79.209,51.359,1],
46561=>[94.293,-79.193,51.320,1],
46562=>[94.320,-79.176,51.280,1],
46563=>[94.347,-79.159,51.240,1],
46564=>[94.374,-79.142,51.199,1],
46565=>[94.387,-79.137,51.159,1],
46566=>[94.399,-79.134,51.119,1],
46567=>[94.410,-79.130,51.079,1],
46568=>[94.421,-79.127,51.038,1],
46569=>[94.432,-79.123,50.996,1],
46570=>[94.443,-79.119,50.957,1],
46571=>[94.452,-79.125,50.917,1],
46625=>[95.028,-79.675,48.981,1],
46626=>[95.042,-79.688,48.944,1],
46627=>[95.055,-79.701,48.908,1],
46628=>[95.068,-79.714,48.871,1],
46629=>[95.081,-79.727,48.834,1],
46630=>[95.094,-79.740,48.796,1],
46631=>[95.107,-79.753,48.759,1],
46632=>[95.120,-79.766,48.722,1],
46633=>[95.141,-79.770,48.685,1],
46634=>[95.165,-79.772,48.648,1],
46635=>[95.188,-79.773,48.612,1],
46636=>[95.212,-79.775,48.575,1],
46637=>[95.236,-79.776,48.540,1],
46638=>[95.259,-79.778,48.504,1],
46639=>[95.282,-79.780,48.467,1],
46640=>[95.306,-79.781,48.432,1],
46641=>[95.330,-79.783,48.396,1],
46642=>[95.353,-79.784,48.361,1],
46643=>[95.377,-79.786,48.326,1],
46644=>[95.401,-79.787,48.291,1],
46711=>[96.850,-79.882,46.251,1],
46712=>[96.872,-79.886,46.227,1],
46713=>[96.894,-79.891,46.203,1],
47138=>[93.091,-79.592,53.120,1],
47139=>[93.107,-79.584,53.102,1],
47140=>[93.123,-79.576,53.084,1],
47141=>[93.139,-79.567,53.067,1],
47142=>[93.155,-79.560,53.052,1],
47143=>[93.171,-79.551,53.038,1],
47144=>[93.188,-79.544,53.024,1],
47145=>[93.203,-79.535,53.010,1],
47146=>[93.220,-79.525,52.998,1],
47147=>[93.238,-79.511,52.987,1],
47148=>[93.257,-79.498,52.976,1],
47149=>[93.275,-79.484,52.966,1],
47150=>[93.293,-79.476,52.957,1],
47151=>[93.311,-79.469,52.951,1],
47152=>[93.330,-79.463,52.946,1],
47153=>[93.349,-79.457,52.941,1],
47154=>[93.367,-79.451,52.935,1],
47155=>[93.386,-79.445,52.928,1],
47156=>[93.404,-79.439,52.921,1],
47157=>[93.423,-79.433,52.914,1],
47158=>[93.442,-79.427,52.907,1],
47159=>[93.455,-79.423,52.897,1],
47160=>[93.465,-79.419,52.887,1],
47161=>[93.475,-79.414,52.876,1],
47162=>[93.485,-79.410,52.864,1],
47163=>[93.495,-79.405,52.852,1],
47164=>[93.504,-79.400,52.840,1],
47165=>[93.516,-79.396,52.827,1],
47166=>[93.533,-79.392,52.814,1],
47167=>[93.549,-79.388,52.801,1],
47168=>[93.566,-79.384,52.789,1],
47169=>[93.582,-79.379,52.777,1],
47170=>[93.599,-79.375,52.766,1],
47171=>[93.612,-79.370,52.757,1],
47172=>[93.625,-79.366,52.746,1],
47173=>[93.639,-79.357,52.739,1],
47174=>[93.654,-79.347,52.734,1],
47175=>[93.669,-79.337,52.729,1],
47176=>[93.684,-79.326,52.722,1],
47177=>[93.696,-79.312,52.716,1],
47178=>[93.708,-79.296,52.710,1],
47179=>[93.720,-79.285,52.704,1],
47180=>[93.734,-79.284,52.698,1],
47181=>[93.748,-79.284,52.692,1],
47182=>[93.762,-79.283,52.686,1],
47183=>[93.776,-79.282,52.680,1],
47184=>[93.790,-79.281,52.675,1],
47185=>[93.804,-79.281,52.670,1],
47186=>[93.819,-79.280,52.663,1],
47187=>[93.833,-79.280,52.656,1],
47188=>[93.837,-79.281,52.649,1],
47189=>[93.834,-79.285,52.642,1],
47190=>[93.845,-79.279,52.632,1],
47191=>[93.856,-79.274,52.622,1],
47192=>[93.867,-79.269,52.612,1],
47193=>[93.878,-79.263,52.601,1],
47194=>[93.889,-79.258,52.590,1],
47195=>[93.900,-79.253,52.579,1],
47196=>[93.907,-79.252,52.566,1],
47197=>[93.913,-79.253,52.553,1],
47198=>[93.919,-79.254,52.538,1],
47199=>[93.927,-79.254,52.523,1],
47200=>[93.936,-79.253,52.506,1],
47201=>[93.946,-79.252,52.488,1],
47202=>[93.956,-79.250,52.469,1],
47203=>[93.968,-79.250,52.452,1],
47204=>[93.984,-79.248,52.436,1],
47205=>[93.999,-79.247,52.420,1],
47206=>[94.007,-79.247,52.402,1],
47207=>[94.007,-79.250,52.383,1],
47208=>[94.006,-79.253,52.362,1],
47209=>[94.006,-79.255,52.341,1],
47210=>[94.006,-79.257,52.322,1],
47211=>[94.005,-79.260,52.304,1],
47212=>[94.005,-79.263,52.288,1],
47213=>[94.004,-79.265,52.272,1],
47214=>[94.005,-79.266,52.253,1],
47215=>[94.008,-79.264,52.235,1],
47216=>[94.011,-79.263,52.217,1],
47217=>[94.013,-79.263,52.201,1],
47218=>[94.016,-79.261,52.187,1],
47219=>[94.018,-79.259,52.172,1],
47220=>[94.015,-79.249,52.155,1],
47221=>[94.013,-79.238,52.140,1],
47222=>[94.010,-79.228,52.126,1],
47223=>[94.008,-79.218,52.116,1],
47224=>[94.006,-79.208,52.108,1],
47225=>[94.003,-79.199,52.101,1],
47226=>[94.008,-79.195,52.096,1],
47227=>[94.026,-79.200,52.087,1],
47228=>[94.044,-79.204,52.078,1],
47229=>[94.062,-79.209,52.068,1],
47230=>[94.080,-79.213,52.056,1],
47231=>[94.099,-79.219,52.042,1],
47232=>[94.105,-79.215,52.028,1],
47233=>[94.107,-79.209,52.012,1],
47234=>[94.116,-79.206,51.993,1],
47235=>[94.134,-79.208,51.972,1],
47236=>[94.141,-79.218,51.951,1],
47237=>[94.145,-79.229,51.927,1],
47238=>[94.150,-79.241,51.904,1],
47239=>[94.154,-79.252,51.881,1],
47240=>[94.159,-79.263,51.858,1],
47241=>[94.164,-79.275,51.837,1],
47242=>[94.168,-79.286,51.817,1],
47243=>[94.174,-79.286,51.799,1],
47244=>[94.181,-79.282,51.783,1],
47245=>[94.187,-79.279,51.766,1],
47246=>[94.185,-79.287,51.748,1],
47247=>[94.188,-79.274,51.731,1],
47248=>[94.192,-79.260,51.711,1],
47249=>[94.195,-79.247,51.691,1],
47250=>[94.198,-79.234,51.670,1],
47251=>[94.202,-79.221,51.649,1],
47252=>[94.205,-79.207,51.627,1],
47253=>[94.208,-79.194,51.605,1],
47254=>[94.221,-79.172,51.580,1],
47255=>[94.242,-79.142,51.554,1],
47256=>[94.262,-79.112,51.526,1],
47257=>[94.274,-79.116,51.497,1],
47258=>[94.268,-79.190,51.468,1],
47259=>[94.262,-79.221,51.438,1],
47260=>[94.257,-79.216,51.405,1],
47261=>[94.263,-79.206,51.367,1],
47262=>[94.290,-79.190,51.327,1],
47263=>[94.318,-79.173,51.287,1],
47264=>[94.345,-79.156,51.248,1],
47265=>[94.372,-79.140,51.208,1],
47266=>[94.393,-79.128,51.168,1],
47267=>[94.404,-79.125,51.129,1],
47268=>[94.415,-79.121,51.089,1],
47269=>[94.426,-79.118,51.049,1],
47270=>[94.437,-79.114,51.008,1],
47271=>[94.449,-79.110,50.968,1],
47272=>[94.460,-79.106,50.929,1],
47326=>[95.020,-79.636,48.985,1],
47327=>[95.033,-79.648,48.948,1],
47328=>[95.046,-79.662,48.912,1],
47329=>[95.059,-79.675,48.875,1],
47330=>[95.072,-79.688,48.837,1],
47331=>[95.086,-79.701,48.800,1],
47332=>[95.099,-79.714,48.762,1],
47333=>[95.112,-79.726,48.725,1],
47334=>[95.131,-79.733,48.689,1],
47335=>[95.155,-79.734,48.652,1],
47336=>[95.179,-79.736,48.615,1],
47337=>[95.202,-79.737,48.579,1],
47338=>[95.226,-79.739,48.542,1],
47339=>[95.249,-79.740,48.506,1],
47340=>[95.273,-79.742,48.471,1],
47341=>[95.297,-79.743,48.435,1],
47342=>[95.320,-79.745,48.399,1],
47343=>[95.343,-79.746,48.364,1],
47344=>[95.367,-79.748,48.329,1],
47345=>[95.391,-79.749,48.294,1],
47346=>[95.414,-79.751,48.259,1],
47411=>[96.823,-79.859,46.274,1],
47412=>[96.846,-79.864,46.251,1],
47413=>[96.868,-79.868,46.227,1],
47414=>[96.891,-79.874,46.202,1],
47415=>[96.913,-79.878,46.177,1],
47416=>[96.936,-79.883,46.153,1],
47417=>[96.958,-79.887,46.128,1],
47418=>[96.997,-79.887,46.105,1],
47419=>[97.043,-79.884,46.081,1],
47420=>[97.089,-79.882,46.058,1],
47421=>[97.135,-79.880,46.035,1],
47840=>[93.104,-79.569,53.126,1],
47841=>[93.119,-79.559,53.108,1],
47842=>[93.135,-79.551,53.091,1],
47843=>[93.151,-79.542,53.076,1],
47844=>[93.167,-79.535,53.061,1],
47845=>[93.183,-79.526,53.047,1],
47846=>[93.199,-79.519,53.034,1],
47847=>[93.215,-79.510,53.021,1],
47848=>[93.233,-79.499,53.009,1],
47849=>[93.251,-79.485,52.998,1],
47850=>[93.269,-79.471,52.989,1],
47851=>[93.287,-79.460,52.980,1],
47852=>[93.306,-79.454,52.972,1],
47853=>[93.324,-79.448,52.966,1],
47854=>[93.343,-79.442,52.960,1],
47855=>[93.361,-79.436,52.955,1],
47856=>[93.380,-79.430,52.950,1],
47857=>[93.398,-79.424,52.943,1],
47858=>[93.417,-79.418,52.937,1],
47859=>[93.434,-79.412,52.931,1],
47860=>[93.443,-79.407,52.921,1],
47861=>[93.451,-79.402,52.911,1],
47862=>[93.460,-79.397,52.899,1],
47863=>[93.468,-79.391,52.887,1],
47864=>[93.476,-79.386,52.875,1],
47865=>[93.486,-79.382,52.862,1],
47866=>[93.498,-79.377,52.849,1],
47867=>[93.515,-79.373,52.836,1],
47868=>[93.532,-79.369,52.822,1],
47869=>[93.548,-79.365,52.808,1],
47870=>[93.565,-79.360,52.795,1],
47871=>[93.581,-79.357,52.784,1],
47872=>[93.598,-79.352,52.774,1],
47873=>[93.612,-79.347,52.764,1],
47874=>[93.626,-79.337,52.758,1],
47875=>[93.641,-79.327,52.753,1],
47876=>[93.656,-79.316,52.749,1],
47877=>[93.671,-79.306,52.742,1],
47878=>[93.684,-79.294,52.736,1],
47879=>[93.697,-79.285,52.729,1],
47880=>[93.711,-79.284,52.722,1],
47881=>[93.725,-79.283,52.715,1],
47882=>[93.739,-79.282,52.707,1],
47883=>[93.753,-79.281,52.699,1],
47884=>[93.767,-79.281,52.692,1],
47885=>[93.781,-79.281,52.685,1],
47886=>[93.795,-79.280,52.679,1],
47887=>[93.809,-79.279,52.672,1],
47888=>[93.823,-79.278,52.665,1],
47889=>[93.829,-79.280,52.657,1],
47890=>[93.835,-79.278,52.649,1],
47891=>[93.846,-79.272,52.641,1],
47892=>[93.857,-79.267,52.631,1],
47893=>[93.868,-79.262,52.621,1],
47894=>[93.880,-79.256,52.610,1],
47895=>[93.891,-79.250,52.598,1],
47896=>[93.902,-79.245,52.586,1],
47897=>[93.909,-79.245,52.573,1],
47898=>[93.915,-79.246,52.559,1],
47899=>[93.922,-79.247,52.545,1],
47900=>[93.931,-79.245,52.531,1],
47901=>[93.941,-79.244,52.514,1],
47902=>[93.951,-79.243,52.495,1],
47903=>[93.961,-79.241,52.476,1],
47904=>[93.971,-79.241,52.460,1],
47905=>[93.985,-79.239,52.445,1],
47906=>[94.000,-79.237,52.429,1],
47907=>[94.008,-79.238,52.411,1],
47908=>[94.008,-79.241,52.391,1],
47909=>[94.007,-79.244,52.370,1],
47910=>[94.007,-79.246,52.348,1],
47911=>[94.006,-79.248,52.328,1],
47912=>[94.006,-79.251,52.309,1],
47913=>[94.006,-79.252,52.294,1],
47914=>[94.009,-79.251,52.277,1],
47915=>[94.012,-79.250,52.259,1],
47916=>[94.014,-79.249,52.240,1],
47917=>[94.017,-79.248,52.223,1],
47918=>[94.019,-79.247,52.208,1],
47919=>[94.023,-79.246,52.194,1],
47920=>[94.025,-79.244,52.180,1],
47921=>[94.023,-79.234,52.165,1],
47922=>[94.019,-79.228,52.150,1],
47923=>[94.015,-79.220,52.137,1],
47924=>[94.012,-79.213,52.127,1],
47925=>[94.009,-79.206,52.119,1],
47926=>[94.005,-79.200,52.112,1],
47927=>[94.010,-79.195,52.106,1],
47928=>[94.022,-79.194,52.097,1],
47929=>[94.034,-79.194,52.088,1],
47930=>[94.046,-79.192,52.079,1],
47931=>[94.060,-79.193,52.067,1],
47932=>[94.077,-79.197,52.054,1],
47933=>[94.096,-79.202,52.040,1],
47934=>[94.106,-79.201,52.023,1],
47935=>[94.112,-79.197,52.003,1],
47936=>[94.125,-79.203,51.980,1],
47937=>[94.129,-79.215,51.956,1],
47938=>[94.134,-79.226,51.932,1],
47939=>[94.138,-79.237,51.908,1],
47940=>[94.143,-79.249,51.883,1],
47941=>[94.147,-79.260,51.861,1],
47942=>[94.152,-79.272,51.840,1],
47943=>[94.156,-79.282,51.821,1],
47944=>[94.161,-79.294,51.804,1],
47945=>[94.165,-79.293,51.788,1],
47946=>[94.169,-79.279,51.772,1],
47947=>[94.172,-79.266,51.756,1],
47948=>[94.175,-79.253,51.738,1],
47949=>[94.179,-79.240,51.719,1],
47950=>[94.182,-79.226,51.698,1],
47951=>[94.185,-79.213,51.677,1],
47952=>[94.189,-79.200,51.655,1],
47953=>[94.192,-79.187,51.632,1],
47954=>[94.195,-79.173,51.609,1],
47955=>[94.216,-79.143,51.583,1],
47956=>[94.237,-79.114,51.557,1],
47957=>[94.253,-79.093,51.530,1],
47958=>[94.267,-79.089,51.503,1],
47959=>[94.269,-79.136,51.475,1],
47960=>[94.263,-79.210,51.446,1],
47961=>[94.258,-79.212,51.413,1],
47962=>[94.261,-79.204,51.374,1],
47963=>[94.288,-79.187,51.334,1],
47964=>[94.316,-79.170,51.295,1],
47965=>[94.343,-79.153,51.256,1],
47966=>[94.370,-79.137,51.217,1],
47967=>[94.397,-79.120,51.178,1],
47968=>[94.409,-79.115,51.138,1],
47969=>[94.420,-79.112,51.099,1],
47970=>[94.432,-79.109,51.060,1],
47971=>[94.443,-79.105,51.020,1],
47972=>[94.454,-79.101,50.979,1],
47973=>[94.466,-79.097,50.940,1],
48027=>[95.012,-79.596,48.990,1],
48028=>[95.025,-79.610,48.952,1],
48029=>[95.038,-79.623,48.915,1],
48030=>[95.051,-79.636,48.879,1],
48031=>[95.064,-79.648,48.841,1],
48032=>[95.077,-79.661,48.804,1],
48033=>[95.091,-79.674,48.767,1],
48034=>[95.104,-79.687,48.731,1],
48035=>[95.122,-79.695,48.694,1],
48036=>[95.145,-79.696,48.657,1],
48037=>[95.169,-79.698,48.620,1],
48038=>[95.192,-79.699,48.583,1],
48039=>[95.216,-79.701,48.547,1],
48040=>[95.240,-79.702,48.511,1],
48041=>[95.263,-79.704,48.475,1],
48042=>[95.286,-79.705,48.440,1],
48043=>[95.310,-79.707,48.403,1],
48044=>[95.334,-79.708,48.367,1],
48045=>[95.357,-79.710,48.332,1],
48046=>[95.381,-79.711,48.297,1],
48047=>[95.404,-79.713,48.262,1],
48069=>[95.851,-79.581,47.504,1],
48070=>[95.874,-79.594,47.472,1],
48071=>[95.896,-79.607,47.440,1],
48072=>[95.919,-79.620,47.409,1],
48073=>[95.942,-79.633,47.376,1],
48074=>[95.965,-79.646,47.345,1],
48075=>[95.988,-79.659,47.313,1],
48076=>[96.011,-79.673,47.281,1],
48077=>[96.033,-79.679,47.251,1],
48111=>[96.797,-79.836,46.298,1],
48112=>[96.820,-79.841,46.273,1],
48113=>[96.842,-79.846,46.250,1],
48114=>[96.865,-79.851,46.226,1],
48115=>[96.887,-79.855,46.202,1],
48116=>[96.910,-79.860,46.177,1],
48117=>[96.932,-79.864,46.152,1],
48118=>[96.955,-79.869,46.128,1],
48119=>[96.993,-79.869,46.105,1],
48120=>[97.039,-79.866,46.081,1],
48121=>[97.086,-79.864,46.058,1],
48122=>[97.133,-79.861,46.035,1],
48123=>[97.132,-79.873,46.013,1],
48124=>[97.131,-79.884,45.989,1],
48125=>[97.131,-79.897,45.965,1],
48126=>[97.134,-79.926,45.941,1],
48127=>[97.138,-79.954,45.920,1],
48542=>[93.117,-79.546,53.133,1],
48543=>[93.131,-79.534,53.115,1],
48544=>[93.147,-79.526,53.100,1],
48545=>[93.163,-79.518,53.085,1],
48546=>[93.179,-79.510,53.071,1],
48547=>[93.195,-79.501,53.058,1],
48548=>[93.211,-79.494,53.045,1],
48549=>[93.227,-79.485,53.033,1],
48550=>[93.245,-79.473,53.022,1],
48551=>[93.263,-79.459,53.012,1],
48552=>[93.281,-79.445,53.003,1],
48553=>[93.300,-79.438,52.995,1],
48554=>[93.319,-79.432,52.988,1],
48555=>[93.337,-79.426,52.983,1],
48556=>[93.355,-79.420,52.979,1],
48557=>[93.374,-79.414,52.972,1],
48558=>[93.393,-79.408,52.966,1],
48559=>[93.411,-79.402,52.959,1],
48560=>[93.426,-79.397,52.951,1],
48561=>[93.437,-79.392,52.941,1],
48562=>[93.445,-79.387,52.930,1],
48563=>[93.453,-79.382,52.919,1],
48564=>[93.462,-79.377,52.909,1],
48565=>[93.470,-79.372,52.897,1],
48566=>[93.478,-79.366,52.885,1],
48567=>[93.489,-79.361,52.872,1],
48568=>[93.505,-79.357,52.860,1],
48569=>[93.521,-79.352,52.846,1],
48570=>[93.538,-79.347,52.831,1],
48571=>[93.554,-79.344,52.817,1],
48572=>[93.570,-79.339,52.804,1],
48573=>[93.586,-79.335,52.794,1],
48574=>[93.602,-79.329,52.786,1],
48575=>[93.617,-79.319,52.779,1],
48576=>[93.631,-79.309,52.774,1],
48577=>[93.646,-79.298,52.770,1],
48578=>[93.660,-79.288,52.763,1],
48579=>[93.675,-79.280,52.756,1],
48580=>[93.689,-79.279,52.749,1],
48581=>[93.702,-79.279,52.740,1],
48582=>[93.716,-79.279,52.732,1],
48583=>[93.730,-79.279,52.724,1],
48584=>[93.744,-79.279,52.715,1],
48585=>[93.758,-79.279,52.707,1],
48586=>[93.772,-79.279,52.699,1],
48587=>[93.786,-79.279,52.692,1],
48588=>[93.800,-79.278,52.685,1],
48589=>[93.814,-79.278,52.677,1],
48590=>[93.826,-79.275,52.669,1],
48591=>[93.837,-79.270,52.661,1],
48592=>[93.848,-79.265,52.652,1],
48593=>[93.859,-79.259,52.643,1],
48594=>[93.870,-79.254,52.633,1],
48595=>[93.881,-79.249,52.622,1],
48596=>[93.892,-79.244,52.610,1],
48597=>[93.903,-79.238,52.598,1],
48598=>[93.910,-79.237,52.585,1],
48599=>[93.917,-79.238,52.571,1],
48600=>[93.927,-79.237,52.557,1],
48601=>[93.936,-79.236,52.541,1],
48602=>[93.946,-79.234,52.523,1],
48603=>[93.956,-79.234,52.504,1],
48604=>[93.966,-79.232,52.485,1],
48605=>[93.975,-79.231,52.471,1],
48606=>[93.986,-79.230,52.455,1],
48607=>[94.001,-79.228,52.437,1],
48608=>[94.009,-79.229,52.419,1],
48609=>[94.008,-79.232,52.398,1],
48610=>[94.008,-79.234,52.377,1],
48611=>[94.007,-79.237,52.354,1],
48612=>[94.007,-79.239,52.333,1],
48613=>[94.010,-79.237,52.314,1],
48614=>[94.013,-79.237,52.297,1],
48615=>[94.015,-79.235,52.281,1],
48616=>[94.018,-79.234,52.264,1],
48617=>[94.020,-79.234,52.246,1],
48618=>[94.023,-79.232,52.230,1],
48619=>[94.023,-79.232,52.217,1],
48620=>[94.023,-79.231,52.204,1],
48621=>[94.023,-79.231,52.191,1],
48622=>[94.025,-79.234,52.176,1],
48623=>[94.021,-79.228,52.162,1],
48624=>[94.018,-79.221,52.149,1],
48625=>[94.014,-79.214,52.139,1],
48626=>[94.011,-79.206,52.131,1],
48627=>[94.007,-79.200,52.124,1],
48628=>[94.011,-79.196,52.118,1],
48629=>[94.024,-79.194,52.109,1],
48630=>[94.036,-79.194,52.100,1],
48631=>[94.048,-79.192,52.091,1],
48632=>[94.059,-79.191,52.079,1],
48633=>[94.071,-79.190,52.066,1],
48634=>[94.083,-79.189,52.051,1],
48635=>[94.096,-79.188,52.034,1],
48636=>[94.109,-79.189,52.012,1],
48637=>[94.113,-79.200,51.989,1],
48638=>[94.118,-79.212,51.963,1],
48639=>[94.123,-79.223,51.938,1],
48640=>[94.128,-79.234,51.913,1],
48641=>[94.133,-79.247,51.889,1],
48642=>[94.138,-79.258,51.867,1],
48643=>[94.143,-79.269,51.846,1],
48644=>[94.148,-79.281,51.827,1],
48645=>[94.150,-79.289,51.810,1],
48646=>[94.148,-79.288,51.795,1],
48647=>[94.151,-79.273,51.780,1],
48648=>[94.155,-79.257,51.764,1],
48649=>[94.159,-79.241,51.746,1],
48650=>[94.164,-79.225,51.727,1],
48651=>[94.168,-79.209,51.705,1],
48652=>[94.172,-79.194,51.683,1],
48653=>[94.176,-79.179,51.661,1],
48654=>[94.179,-79.165,51.638,1],
48655=>[94.189,-79.146,51.614,1],
48656=>[94.204,-79.131,51.587,1],
48657=>[94.219,-79.115,51.561,1],
48658=>[94.234,-79.100,51.534,1],
48659=>[94.247,-79.100,51.510,1],
48660=>[94.259,-79.118,51.483,1],
48661=>[94.265,-79.156,51.454,1],
48662=>[94.258,-79.208,51.420,1],
48663=>[94.259,-79.201,51.382,1],
48664=>[94.286,-79.184,51.342,1],
48665=>[94.313,-79.168,51.302,1],
48666=>[94.340,-79.151,51.264,1],
48667=>[94.367,-79.134,51.225,1],
48668=>[94.395,-79.117,51.186,1],
48669=>[94.415,-79.106,51.148,1],
48670=>[94.426,-79.103,51.110,1],
48671=>[94.437,-79.100,51.071,1],
48672=>[94.449,-79.096,51.031,1],
48673=>[94.460,-79.092,50.991,1],
48674=>[94.471,-79.088,50.953,1],
48728=>[95.003,-79.557,48.994,1],
48729=>[95.016,-79.570,48.956,1],
48730=>[95.030,-79.583,48.920,1],
48731=>[95.043,-79.596,48.883,1],
48732=>[95.056,-79.609,48.846,1],
48733=>[95.069,-79.622,48.808,1],
48734=>[95.082,-79.635,48.772,1],
48735=>[95.095,-79.648,48.736,1],
48736=>[95.112,-79.657,48.699,1],
48737=>[95.135,-79.659,48.662,1],
48738=>[95.159,-79.661,48.626,1],
48739=>[95.183,-79.662,48.589,1],
48740=>[95.206,-79.664,48.552,1],
48741=>[95.230,-79.664,48.516,1],
48742=>[95.253,-79.666,48.480,1],
48743=>[95.277,-79.667,48.444,1],
48744=>[95.301,-79.669,48.408,1],
48745=>[95.324,-79.670,48.372,1],
48746=>[95.347,-79.672,48.337,1],
48747=>[95.371,-79.673,48.301,1],
48748=>[95.395,-79.675,48.265,1],
48749=>[95.418,-79.676,48.230,1],
48758=>[95.630,-79.690,47.913,1],
48759=>[95.654,-79.692,47.879,1],
48760=>[95.678,-79.693,47.845,1],
48761=>[95.693,-79.673,47.810,1],
48762=>[95.708,-79.651,47.776,1],
48763=>[95.723,-79.630,47.742,1],
48764=>[95.738,-79.609,47.709,1],
48765=>[95.753,-79.588,47.675,1],
48766=>[95.768,-79.566,47.641,1],
48767=>[95.783,-79.545,47.608,1],
48768=>[95.802,-79.540,47.575,1],
48769=>[95.824,-79.553,47.542,1],
48770=>[95.847,-79.566,47.509,1],
48771=>[95.870,-79.579,47.477,1],
48772=>[95.893,-79.592,47.445,1],
48773=>[95.916,-79.605,47.413,1],
48774=>[95.939,-79.618,47.380,1],
48775=>[95.961,-79.631,47.348,1],
48776=>[95.984,-79.645,47.317,1],
48777=>[96.007,-79.656,47.285,1],
48778=>[96.030,-79.661,47.254,1],
48779=>[96.052,-79.665,47.224,1],
48811=>[96.771,-79.814,46.324,1],
48812=>[96.794,-79.818,46.298,1],
48813=>[96.816,-79.823,46.273,1],
48814=>[96.839,-79.828,46.250,1],
48815=>[96.861,-79.833,46.226,1],
48816=>[96.884,-79.837,46.201,1],
48817=>[96.906,-79.842,46.177,1],
48818=>[96.929,-79.846,46.152,1],
48819=>[96.951,-79.851,46.128,1],
48820=>[96.990,-79.851,46.104,1],
48821=>[97.036,-79.849,46.081,1],
48822=>[97.083,-79.845,46.058,1],
48823=>[97.129,-79.843,46.035,1],
48824=>[97.130,-79.854,46.013,1],
48825=>[97.129,-79.865,45.989,1],
48826=>[97.128,-79.877,45.965,1],
48827=>[97.132,-79.906,45.942,1],
48828=>[97.135,-79.935,45.920,1],
48829=>[97.139,-79.964,45.899,1],
49244=>[93.130,-79.523,53.141,1],
49245=>[93.144,-79.511,53.125,1],
49246=>[93.159,-79.501,53.110,1],
49247=>[93.175,-79.493,53.096,1],
49248=>[93.191,-79.485,53.083,1],
49249=>[93.207,-79.476,53.071,1],
49250=>[93.223,-79.469,53.059,1],
49251=>[93.239,-79.460,53.046,1],
49252=>[93.258,-79.447,53.036,1],
49253=>[93.276,-79.432,53.027,1],
49254=>[93.294,-79.423,53.018,1],
49255=>[93.312,-79.417,53.012,1],
49256=>[93.331,-79.411,53.007,1],
49257=>[93.349,-79.405,53.002,1],
49258=>[93.368,-79.399,52.994,1],
49259=>[93.386,-79.393,52.987,1],
49260=>[93.404,-79.387,52.979,1],
49261=>[93.419,-79.382,52.970,1],
49262=>[93.431,-79.378,52.959,1],
49263=>[93.439,-79.372,52.949,1],
49264=>[93.447,-79.367,52.938,1],
49265=>[93.455,-79.362,52.927,1],
49266=>[93.463,-79.357,52.916,1],
49267=>[93.471,-79.352,52.904,1],
49268=>[93.485,-79.346,52.891,1],
49269=>[93.500,-79.341,52.878,1],
49270=>[93.516,-79.337,52.864,1],
49271=>[93.532,-79.332,52.849,1],
49272=>[93.548,-79.328,52.836,1],
49273=>[93.564,-79.323,52.826,1],
49274=>[93.581,-79.319,52.817,1],
49275=>[93.596,-79.314,52.810,1],
49276=>[93.611,-79.304,52.802,1],
49277=>[93.626,-79.294,52.796,1],
49278=>[93.640,-79.284,52.790,1],
49279=>[93.655,-79.273,52.784,1],
49280=>[93.669,-79.267,52.777,1],
49281=>[93.683,-79.263,52.769,1],
49282=>[93.697,-79.263,52.759,1],
49283=>[93.711,-79.263,52.750,1],
49284=>[93.725,-79.263,52.741,1],
49285=>[93.739,-79.263,52.733,1],
49286=>[93.753,-79.263,52.724,1],
49287=>[93.767,-79.263,52.716,1],
49288=>[93.780,-79.263,52.707,1],
49289=>[93.794,-79.263,52.700,1],
49290=>[93.807,-79.264,52.692,1],
49291=>[93.820,-79.263,52.684,1],
49292=>[93.833,-79.259,52.675,1],
49293=>[93.846,-79.256,52.666,1],
49294=>[93.859,-79.252,52.657,1],
49295=>[93.871,-79.247,52.647,1],
49296=>[93.883,-79.241,52.636,1],
49297=>[93.894,-79.236,52.625,1],
49298=>[93.905,-79.231,52.613,1],
49299=>[93.912,-79.231,52.599,1],
49300=>[93.922,-79.229,52.585,1],
49301=>[93.932,-79.228,52.569,1],
49302=>[93.941,-79.227,52.552,1],
49303=>[93.951,-79.225,52.534,1],
49304=>[93.961,-79.225,52.515,1],
49305=>[93.971,-79.223,52.498,1],
49306=>[93.980,-79.222,52.483,1],
49307=>[93.990,-79.221,52.467,1],
49308=>[94.002,-79.219,52.449,1],
49309=>[94.009,-79.220,52.429,1],
49310=>[94.009,-79.223,52.408,1],
49311=>[94.009,-79.225,52.386,1],
49312=>[94.011,-79.225,52.364,1],
49313=>[94.014,-79.223,52.344,1],
49314=>[94.016,-79.222,52.324,1],
49315=>[94.017,-79.222,52.307,1],
49316=>[94.017,-79.221,52.290,1],
49317=>[94.017,-79.220,52.274,1],
49318=>[94.017,-79.220,52.258,1],
49319=>[94.017,-79.219,52.243,1],
49320=>[94.017,-79.219,52.229,1],
49321=>[94.017,-79.219,52.216,1],
49322=>[94.017,-79.218,52.203,1],
49323=>[94.019,-79.222,52.189,1],
49324=>[94.024,-79.228,52.176,1],
49325=>[94.020,-79.221,52.164,1],
49326=>[94.017,-79.214,52.155,1],
49327=>[94.013,-79.207,52.147,1],
49328=>[94.010,-79.200,52.139,1],
49329=>[94.013,-79.196,52.131,1],
49330=>[94.025,-79.194,52.123,1],
49331=>[94.037,-79.194,52.113,1],
49332=>[94.049,-79.193,52.102,1],
49333=>[94.061,-79.191,52.091,1],
49334=>[94.073,-79.190,52.077,1],
49335=>[94.085,-79.189,52.062,1],
49336=>[94.094,-79.187,52.044,1],
49337=>[94.100,-79.188,52.022,1],
49338=>[94.107,-79.200,51.998,1],
49339=>[94.112,-79.211,51.971,1],
49340=>[94.117,-79.223,51.945,1],
49341=>[94.122,-79.234,51.919,1],
49342=>[94.127,-79.246,51.896,1],
49343=>[94.132,-79.257,51.875,1],
49344=>[94.137,-79.269,51.855,1],
49345=>[94.138,-79.276,51.835,1],
49346=>[94.138,-79.282,51.818,1],
49347=>[94.136,-79.280,51.803,1],
49348=>[94.133,-79.277,51.788,1],
49349=>[94.135,-79.265,51.772,1],
49350=>[94.139,-79.249,51.754,1],
49351=>[94.143,-79.233,51.734,1],
49352=>[94.147,-79.217,51.711,1],
49353=>[94.151,-79.201,51.689,1],
49354=>[94.155,-79.184,51.666,1],
49355=>[94.160,-79.169,51.642,1],
49356=>[94.170,-79.152,51.618,1],
49357=>[94.185,-79.137,51.591,1],
49358=>[94.199,-79.121,51.565,1],
49359=>[94.214,-79.106,51.539,1],
49360=>[94.227,-79.112,51.515,1],
49361=>[94.239,-79.130,51.489,1],
49362=>[94.251,-79.147,51.460,1],
49363=>[94.260,-79.175,51.427,1],
49364=>[94.256,-79.198,51.390,1],
49365=>[94.283,-79.181,51.351,1],
49366=>[94.311,-79.165,51.311,1],
49367=>[94.338,-79.148,51.273,1],
49368=>[94.365,-79.131,51.235,1],
49369=>[94.393,-79.115,51.197,1],
49370=>[94.420,-79.097,51.159,1],
49371=>[94.431,-79.093,51.121,1],
49372=>[94.442,-79.090,51.083,1],
49373=>[94.454,-79.087,51.043,1],
49374=>[94.465,-79.083,51.004,1],
49375=>[94.476,-79.079,50.966,1],
49376=>[94.488,-79.075,50.928,1],
49429=>[94.995,-79.518,48.999,1],
49430=>[95.008,-79.531,48.961,1],
49431=>[95.021,-79.544,48.924,1],
49432=>[95.034,-79.557,48.887,1],
49433=>[95.047,-79.570,48.850,1],
49434=>[95.060,-79.582,48.814,1],
49435=>[95.073,-79.596,48.777,1],
49436=>[95.087,-79.609,48.741,1],
49437=>[95.102,-79.620,48.704,1],
49438=>[95.126,-79.621,48.668,1],
49439=>[95.149,-79.623,48.632,1],
49440=>[95.173,-79.624,48.596,1],
49441=>[95.196,-79.626,48.559,1],
49442=>[95.220,-79.627,48.522,1],
49443=>[95.244,-79.629,48.486,1],
49444=>[95.267,-79.630,48.449,1],
49445=>[95.290,-79.632,48.413,1],
49446=>[95.314,-79.633,48.377,1],
49447=>[95.338,-79.634,48.341,1],
49448=>[95.361,-79.636,48.305,1],
49449=>[95.385,-79.637,48.269,1],
49450=>[95.408,-79.639,48.234,1],
49451=>[95.432,-79.640,48.199,1],
49452=>[95.456,-79.642,48.164,1],
49453=>[95.479,-79.643,48.129,1],
49454=>[95.503,-79.645,48.093,1],
49455=>[95.526,-79.646,48.057,1],
49456=>[95.550,-79.648,48.022,1],
49457=>[95.573,-79.649,47.987,1],
49458=>[95.597,-79.651,47.952,1],
49459=>[95.621,-79.652,47.918,1],
49460=>[95.644,-79.654,47.883,1],
49461=>[95.668,-79.655,47.849,1],
49462=>[95.686,-79.642,47.815,1],
49463=>[95.701,-79.621,47.781,1],
49464=>[95.716,-79.600,47.748,1],
49465=>[95.731,-79.579,47.714,1],
49466=>[95.746,-79.557,47.680,1],
49467=>[95.761,-79.536,47.647,1],
49468=>[95.776,-79.515,47.614,1],
49469=>[95.798,-79.525,47.580,1],
49470=>[95.821,-79.538,47.547,1],
49471=>[95.844,-79.551,47.514,1],
49472=>[95.867,-79.564,47.481,1],
49473=>[95.890,-79.577,47.450,1],
49474=>[95.912,-79.590,47.418,1],
49475=>[95.935,-79.603,47.385,1],
49476=>[95.958,-79.617,47.353,1],
49477=>[95.981,-79.629,47.321,1],
49478=>[96.004,-79.638,47.289,1],
49479=>[96.026,-79.643,47.258,1],
49480=>[96.048,-79.648,47.228,1],
49511=>[96.745,-79.791,46.349,1],
49512=>[96.768,-79.796,46.323,1],
49513=>[96.790,-79.801,46.297,1],
49514=>[96.813,-79.805,46.273,1],
49515=>[96.835,-79.810,46.249,1],
49516=>[96.858,-79.814,46.225,1],
49517=>[96.880,-79.819,46.201,1],
49518=>[96.902,-79.823,46.177,1],
49519=>[96.925,-79.828,46.152,1],
49520=>[96.948,-79.833,46.128,1],
49521=>[96.986,-79.833,46.104,1],
49522=>[97.033,-79.830,46.081,1],
49523=>[97.079,-79.827,46.058,1],
49524=>[97.125,-79.825,46.035,1],
49525=>[97.127,-79.836,46.013,1],
49526=>[97.126,-79.847,45.989,1],
49527=>[97.125,-79.858,45.965,1],
49528=>[97.129,-79.887,45.943,1],
49529=>[97.133,-79.915,45.921,1],
49530=>[97.136,-79.944,45.899,1],
49531=>[97.140,-79.973,45.878,1],
49532=>[97.143,-80.002,45.855,1],
49945=>[93.129,-79.513,53.166,1],
49946=>[93.143,-79.501,53.151,1],
49947=>[93.157,-79.489,53.137,1],
49948=>[93.171,-79.477,53.122,1],
49949=>[93.187,-79.468,53.108,1],
49950=>[93.203,-79.460,53.096,1],
49951=>[93.219,-79.451,53.084,1],
49952=>[93.235,-79.444,53.072,1],
49953=>[93.252,-79.434,53.061,1],
49954=>[93.270,-79.420,53.052,1],
49955=>[93.288,-79.407,53.042,1],
49956=>[93.306,-79.401,53.036,1],
49957=>[93.325,-79.395,53.029,1],
49958=>[93.344,-79.389,53.022,1],
49959=>[93.362,-79.383,53.015,1],
49960=>[93.380,-79.377,53.007,1],
49961=>[93.396,-79.372,52.998,1],
49962=>[93.411,-79.368,52.988,1],
49963=>[93.424,-79.363,52.977,1],
49964=>[93.432,-79.358,52.966,1],
49965=>[93.440,-79.353,52.955,1],
49966=>[93.448,-79.347,52.944,1],
49967=>[93.457,-79.342,52.933,1],
49968=>[93.466,-79.337,52.921,1],
49969=>[93.481,-79.332,52.908,1],
49970=>[93.495,-79.326,52.894,1],
49971=>[93.510,-79.321,52.880,1],
49972=>[93.526,-79.316,52.867,1],
49973=>[93.543,-79.313,52.855,1],
49974=>[93.559,-79.308,52.846,1],
49975=>[93.575,-79.303,52.838,1],
49976=>[93.591,-79.300,52.832,1],
49977=>[93.606,-79.289,52.824,1],
49978=>[93.621,-79.279,52.816,1],
49979=>[93.635,-79.269,52.810,1],
49980=>[93.649,-79.259,52.804,1],
49981=>[93.663,-79.254,52.796,1],
49982=>[93.678,-79.249,52.787,1],
49983=>[93.692,-79.246,52.778,1],
49984=>[93.706,-79.246,52.769,1],
49985=>[93.719,-79.246,52.760,1],
49986=>[93.733,-79.246,52.751,1],
49987=>[93.747,-79.246,52.743,1],
49988=>[93.761,-79.246,52.735,1],
49989=>[93.775,-79.246,52.726,1],
49990=>[93.789,-79.246,52.718,1],
49991=>[93.799,-79.253,52.709,1],
49992=>[93.813,-79.250,52.701,1],
49993=>[93.826,-79.246,52.692,1],
49994=>[93.839,-79.242,52.683,1],
49995=>[93.852,-79.238,52.674,1],
49996=>[93.865,-79.234,52.664,1],
49997=>[93.878,-79.230,52.654,1],
49998=>[93.892,-79.226,52.643,1],
49999=>[93.905,-79.222,52.631,1],
50000=>[93.915,-79.221,52.616,1],
50001=>[93.925,-79.220,52.600,1],
50002=>[93.936,-79.219,52.582,1],
50003=>[93.946,-79.218,52.565,1],
50004=>[93.956,-79.216,52.547,1],
50005=>[93.966,-79.216,52.529,1],
50006=>[93.975,-79.214,52.513,1],
50007=>[93.985,-79.213,52.497,1],
50008=>[93.995,-79.212,52.481,1],
50009=>[94.004,-79.210,52.464,1],
50010=>[94.010,-79.211,52.442,1],
50011=>[94.012,-79.211,52.421,1],
50012=>[94.013,-79.210,52.399,1],
50013=>[94.013,-79.210,52.377,1],
50014=>[94.013,-79.209,52.357,1],
50015=>[94.013,-79.209,52.338,1],
50016=>[94.013,-79.208,52.320,1],
50017=>[94.013,-79.208,52.303,1],
50018=>[94.013,-79.207,52.287,1],
50019=>[94.013,-79.206,52.272,1],
50020=>[94.012,-79.206,52.258,1],
50021=>[94.012,-79.206,52.245,1],
50022=>[94.012,-79.205,52.232,1],
50023=>[94.012,-79.205,52.219,1],
50024=>[94.014,-79.206,52.205,1],
50025=>[94.018,-79.213,52.193,1],
50026=>[94.022,-79.220,52.182,1],
50027=>[94.019,-79.215,52.174,1],
50028=>[94.015,-79.207,52.165,1],
50029=>[94.012,-79.200,52.157,1],
50030=>[94.014,-79.196,52.149,1],
50031=>[94.027,-79.195,52.139,1],
50032=>[94.039,-79.194,52.128,1],
50033=>[94.051,-79.193,52.116,1],
50034=>[94.063,-79.191,52.102,1],
50035=>[94.074,-79.190,52.088,1],
50036=>[94.080,-79.187,52.072,1],
50037=>[94.085,-79.184,52.053,1],
50038=>[94.092,-79.187,52.031,1],
50039=>[94.099,-79.200,52.007,1],
50040=>[94.106,-79.211,51.980,1],
50041=>[94.111,-79.222,51.953,1],
50042=>[94.116,-79.234,51.929,1],
50043=>[94.121,-79.245,51.906,1],
50044=>[94.126,-79.257,51.885,1],
50045=>[94.126,-79.263,51.864,1],
50046=>[94.126,-79.269,51.845,1],
50047=>[94.126,-79.275,51.827,1],
50048=>[94.124,-79.272,51.811,1],
50049=>[94.121,-79.269,51.795,1],
50050=>[94.119,-79.266,51.779,1],
50051=>[94.119,-79.256,51.761,1],
50052=>[94.123,-79.241,51.740,1],
50053=>[94.127,-79.224,51.717,1],
50054=>[94.131,-79.208,51.694,1],
50055=>[94.135,-79.192,51.671,1],
50056=>[94.143,-79.175,51.646,1],
50057=>[94.153,-79.159,51.620,1],
50058=>[94.165,-79.142,51.595,1],
50059=>[94.180,-79.127,51.570,1],
50060=>[94.194,-79.112,51.545,1],
50061=>[94.207,-79.125,51.520,1],
50062=>[94.219,-79.142,51.494,1],
50063=>[94.231,-79.159,51.466,1],
50064=>[94.243,-79.177,51.435,1],
50065=>[94.255,-79.195,51.399,1],
50066=>[94.281,-79.179,51.361,1],
50067=>[94.309,-79.162,51.321,1],
50068=>[94.336,-79.145,51.284,1],
50069=>[94.363,-79.128,51.246,1],
50070=>[94.390,-79.112,51.208,1],
50071=>[94.417,-79.095,51.170,1],
50072=>[94.436,-79.084,51.133,1],
50073=>[94.448,-79.081,51.095,1],
50074=>[94.459,-79.078,51.056,1],
50075=>[94.470,-79.074,51.018,1],
50076=>[94.482,-79.070,50.980,1],
50077=>[94.493,-79.066,50.941,1],
50078=>[94.504,-79.062,50.904,1],
50130=>[94.986,-79.479,49.004,1],
50131=>[94.999,-79.491,48.967,1],
50132=>[95.013,-79.504,48.930,1],
50133=>[95.026,-79.517,48.894,1],
50134=>[95.039,-79.530,48.857,1],
50135=>[95.052,-79.544,48.820,1],
50136=>[95.065,-79.557,48.783,1],
50137=>[95.078,-79.570,48.746,1],
50138=>[95.092,-79.582,48.710,1],
50139=>[95.116,-79.583,48.675,1],
50140=>[95.139,-79.585,48.640,1],
50141=>[95.163,-79.586,48.604,1],
50142=>[95.187,-79.588,48.565,1],
50143=>[95.210,-79.589,48.528,1],
50144=>[95.234,-79.591,48.492,1],
50145=>[95.257,-79.592,48.455,1],
50146=>[95.281,-79.594,48.419,1],
50147=>[95.305,-79.595,48.383,1],
50148=>[95.328,-79.597,48.346,1],
50149=>[95.351,-79.598,48.310,1],
50150=>[95.375,-79.600,48.274,1],
50151=>[95.399,-79.601,48.238,1],
50152=>[95.422,-79.603,48.203,1],
50153=>[95.446,-79.604,48.168,1],
50154=>[95.469,-79.605,48.133,1],
50155=>[95.493,-79.607,48.097,1],
50156=>[95.517,-79.608,48.062,1],
50157=>[95.540,-79.610,48.027,1],
50158=>[95.564,-79.611,47.992,1],
50159=>[95.587,-79.613,47.957,1],
50160=>[95.611,-79.614,47.922,1],
50161=>[95.634,-79.616,47.888,1],
50162=>[95.658,-79.617,47.854,1],
50163=>[95.679,-79.612,47.821,1],
50164=>[95.694,-79.591,47.787,1],
50165=>[95.709,-79.570,47.754,1],
50166=>[95.724,-79.548,47.720,1],
50167=>[95.739,-79.527,47.687,1],
50168=>[95.754,-79.506,47.653,1],
50169=>[95.772,-79.497,47.619,1],
50170=>[95.795,-79.510,47.586,1],
50171=>[95.818,-79.523,47.553,1],
50172=>[95.840,-79.536,47.520,1],
50173=>[95.863,-79.549,47.487,1],
50174=>[95.886,-79.562,47.456,1],
50175=>[95.909,-79.575,47.424,1],
50176=>[95.932,-79.588,47.390,1],
50177=>[95.955,-79.601,47.358,1],
50178=>[95.977,-79.614,47.326,1],
50179=>[96.000,-79.620,47.294,1],
50180=>[96.022,-79.625,47.263,1],
50181=>[96.045,-79.629,47.231,1],
50182=>[96.067,-79.634,47.200,1],
50211=>[96.719,-79.769,46.375,1],
50212=>[96.742,-79.773,46.350,1],
50213=>[96.764,-79.778,46.324,1],
50214=>[96.787,-79.783,46.298,1],
50215=>[96.809,-79.787,46.272,1],
50216=>[96.831,-79.792,46.249,1],
50217=>[96.854,-79.796,46.225,1],
50218=>[96.877,-79.801,46.201,1],
50219=>[96.899,-79.806,46.176,1],
50220=>[96.922,-79.811,46.152,1],
50221=>[96.944,-79.815,46.127,1],
50222=>[96.982,-79.814,46.104,1],
50223=>[97.029,-79.812,46.081,1],
50224=>[97.076,-79.809,46.058,1],
50225=>[97.122,-79.807,46.035,1],
50226=>[97.125,-79.817,46.013,1],
50227=>[97.124,-79.829,45.989,1],
50228=>[97.123,-79.840,45.965,1],
50229=>[97.126,-79.867,45.942,1],
50230=>[97.130,-79.896,45.920,1],
50231=>[97.134,-79.925,45.899,1],
50232=>[97.137,-79.953,45.877,1],
50233=>[97.141,-79.982,45.855,1],
50234=>[97.144,-80.010,45.834,1],
50647=>[93.142,-79.491,53.178,1],
50648=>[93.156,-79.479,53.163,1],
50649=>[93.170,-79.466,53.149,1],
50650=>[93.185,-79.454,53.135,1],
50651=>[93.199,-79.443,53.122,1],
50652=>[93.215,-79.435,53.110,1],
50653=>[93.231,-79.426,53.098,1],
50654=>[93.247,-79.419,53.087,1],
50655=>[93.264,-79.408,53.077,1],
50656=>[93.282,-79.394,53.067,1],
50657=>[93.300,-79.385,53.059,1],
50658=>[93.319,-79.379,53.051,1],
50659=>[93.338,-79.374,53.044,1],
50660=>[93.356,-79.368,53.036,1],
50661=>[93.373,-79.362,53.027,1],
50662=>[93.388,-79.357,53.018,1],
50663=>[93.403,-79.353,53.007,1],
50664=>[93.418,-79.349,52.996,1],
50665=>[93.426,-79.344,52.985,1],
50666=>[93.434,-79.338,52.972,1],
50667=>[93.442,-79.333,52.962,1],
50668=>[93.450,-79.328,52.950,1],
50669=>[93.462,-79.322,52.937,1],
50670=>[93.476,-79.317,52.924,1],
50671=>[93.491,-79.312,52.910,1],
50672=>[93.506,-79.306,52.896,1],
50673=>[93.521,-79.301,52.883,1],
50674=>[93.538,-79.297,52.874,1],
50675=>[93.554,-79.293,52.866,1],
50676=>[93.570,-79.288,52.859,1],
50677=>[93.586,-79.284,52.852,1],
50678=>[93.601,-79.274,52.844,1],
50679=>[93.615,-79.264,52.837,1],
50680=>[93.630,-79.254,52.829,1],
50681=>[93.644,-79.247,52.822,1],
50682=>[93.658,-79.241,52.814,1],
50683=>[93.672,-79.236,52.805,1],
50684=>[93.686,-79.231,52.796,1],
50685=>[93.700,-79.229,52.787,1],
50686=>[93.714,-79.229,52.779,1],
50687=>[93.728,-79.229,52.770,1],
50688=>[93.742,-79.229,52.762,1],
50689=>[93.756,-79.229,52.754,1],
50690=>[93.770,-79.229,52.745,1],
50691=>[93.780,-79.237,52.736,1],
50692=>[93.792,-79.240,52.728,1],
50693=>[93.805,-79.236,52.719,1],
50694=>[93.819,-79.232,52.710,1],
50695=>[93.832,-79.228,52.701,1],
50696=>[93.845,-79.224,52.691,1],
50697=>[93.858,-79.220,52.683,1],
50698=>[93.871,-79.216,52.672,1],
50699=>[93.885,-79.213,52.660,1],
50700=>[93.899,-79.213,52.647,1],
50701=>[93.899,-79.210,52.630,1],
50702=>[93.910,-79.209,52.613,1],
50703=>[93.921,-79.209,52.596,1],
50704=>[93.931,-79.207,52.579,1],
50705=>[93.942,-79.206,52.562,1],
50706=>[93.954,-79.205,52.546,1],
50707=>[93.964,-79.204,52.530,1],
50708=>[93.975,-79.203,52.515,1],
50709=>[93.986,-79.202,52.498,1],
50710=>[93.997,-79.200,52.481,1],
50711=>[94.007,-79.203,52.460,1],
50712=>[94.008,-79.200,52.438,1],
50713=>[94.008,-79.197,52.417,1],
50714=>[94.008,-79.197,52.395,1],
50715=>[94.008,-79.196,52.375,1],
50716=>[94.008,-79.196,52.355,1],
50717=>[94.008,-79.195,52.337,1],
50718=>[94.008,-79.194,52.321,1],
50719=>[94.008,-79.194,52.305,1],
50720=>[94.008,-79.194,52.290,1],
50721=>[94.008,-79.193,52.275,1],
50722=>[94.008,-79.193,52.262,1],
50723=>[94.008,-79.192,52.250,1],
50724=>[94.008,-79.191,52.238,1],
50725=>[94.008,-79.191,52.224,1],
50726=>[94.012,-79.198,52.212,1],
50727=>[94.016,-79.205,52.202,1],
50728=>[94.020,-79.212,52.194,1],
50729=>[94.018,-79.208,52.185,1],
50730=>[94.014,-79.201,52.176,1],
50731=>[94.016,-79.196,52.168,1],
50732=>[94.028,-79.195,52.157,1],
50733=>[94.040,-79.194,52.144,1],
50734=>[94.052,-79.193,52.130,1],
50735=>[94.060,-79.190,52.114,1],
50736=>[94.066,-79.187,52.098,1],
50737=>[94.071,-79.184,52.081,1],
50738=>[94.077,-79.181,52.062,1],
50739=>[94.084,-79.187,52.040,1],
50740=>[94.091,-79.199,52.015,1],
50741=>[94.098,-79.210,51.989,1],
50742=>[94.105,-79.222,51.963,1],
50743=>[94.110,-79.234,51.939,1],
50744=>[94.114,-79.244,51.918,1],
50745=>[94.114,-79.250,51.898,1],
50746=>[94.114,-79.256,51.878,1],
50747=>[94.114,-79.261,51.860,1],
50748=>[94.114,-79.266,51.842,1],
50749=>[94.111,-79.263,51.824,1],
50750=>[94.109,-79.260,51.807,1],
50751=>[94.106,-79.257,51.789,1],
50752=>[94.104,-79.254,51.769,1],
50753=>[94.103,-79.247,51.746,1],
50754=>[94.107,-79.231,51.722,1],
50755=>[94.111,-79.216,51.698,1],
50756=>[94.117,-79.200,51.673,1],
50757=>[94.127,-79.182,51.648,1],
50758=>[94.137,-79.165,51.623,1],
50759=>[94.147,-79.149,51.599,1],
50760=>[94.160,-79.133,51.575,1],
50761=>[94.175,-79.118,51.551,1],
50762=>[94.187,-79.136,51.525,1],
50763=>[94.199,-79.153,51.499,1],
50764=>[94.211,-79.172,51.473,1],
50765=>[94.235,-79.179,51.442,1],
50766=>[94.260,-79.175,51.408,1],
50767=>[94.280,-79.171,51.372,1],
50768=>[94.306,-79.159,51.333,1],
50769=>[94.333,-79.143,51.295,1],
50770=>[94.360,-79.126,51.257,1],
50771=>[94.388,-79.109,51.219,1],
50772=>[94.415,-79.092,51.182,1],
50773=>[94.442,-79.075,51.145,1],
50774=>[94.453,-79.072,51.107,1],
50775=>[94.465,-79.068,51.069,1],
50776=>[94.476,-79.065,51.031,1],
50777=>[94.487,-79.061,50.992,1],
50778=>[94.498,-79.057,50.955,1],
50779=>[94.509,-79.053,50.917,1],
50780=>[94.521,-79.049,50.880,1],
50781=>[94.532,-79.046,50.843,1],
50829=>[94.952,-79.413,49.083,1],
50830=>[94.965,-79.426,49.046,1],
50831=>[94.978,-79.439,49.010,1],
50832=>[94.991,-79.452,48.973,1],
50833=>[95.004,-79.465,48.937,1],
50834=>[95.017,-79.478,48.900,1],
50835=>[95.031,-79.491,48.863,1],
50836=>[95.044,-79.504,48.826,1],
50837=>[95.057,-79.517,48.789,1],
50838=>[95.070,-79.530,48.753,1],
50839=>[95.083,-79.543,48.717,1],
50840=>[95.106,-79.545,48.683,1],
50841=>[95.130,-79.547,48.648,1],
50842=>[95.153,-79.548,48.614,1],
50843=>[95.177,-79.550,48.575,1],
50844=>[95.200,-79.551,48.537,1],
50845=>[95.224,-79.553,48.499,1],
50846=>[95.248,-79.554,48.461,1],
50847=>[95.271,-79.556,48.425,1],
50848=>[95.295,-79.557,48.388,1],
50849=>[95.318,-79.559,48.352,1],
50850=>[95.342,-79.560,48.315,1],
50851=>[95.366,-79.562,48.279,1],
50852=>[95.389,-79.563,48.243,1],
50853=>[95.412,-79.565,48.209,1],
50854=>[95.436,-79.567,48.173,1],
50855=>[95.460,-79.568,48.138,1],
50856=>[95.483,-79.570,48.102,1],
50857=>[95.507,-79.571,48.067,1],
50858=>[95.530,-79.573,48.032,1],
50859=>[95.554,-79.574,47.997,1],
50860=>[95.578,-79.575,47.962,1],
50861=>[95.601,-79.576,47.928,1],
50862=>[95.625,-79.578,47.894,1],
50863=>[95.648,-79.579,47.860,1],
50864=>[95.672,-79.581,47.827,1],
50865=>[95.687,-79.561,47.793,1],
50866=>[95.702,-79.540,47.760,1],
50867=>[95.717,-79.518,47.727,1],
50868=>[95.732,-79.497,47.693,1],
50869=>[95.747,-79.476,47.660,1],
50870=>[95.768,-79.482,47.626,1],
50871=>[95.792,-79.495,47.593,1],
50872=>[95.814,-79.508,47.560,1],
50873=>[95.837,-79.521,47.527,1],
50874=>[95.860,-79.534,47.494,1],
50875=>[95.883,-79.548,47.462,1],
50876=>[95.905,-79.560,47.430,1],
50877=>[95.928,-79.573,47.397,1],
50878=>[95.951,-79.586,47.364,1],
50879=>[95.974,-79.598,47.331,1],
50880=>[95.996,-79.602,47.299,1],
50881=>[96.019,-79.607,47.268,1],
50882=>[96.041,-79.611,47.236,1],
50883=>[96.063,-79.616,47.205,1],
50884=>[96.086,-79.620,47.174,1],
50911=>[96.693,-79.746,46.401,1],
50912=>[96.716,-79.751,46.375,1],
50913=>[96.738,-79.755,46.350,1],
50914=>[96.760,-79.760,46.324,1],
50915=>[96.783,-79.764,46.298,1],
50916=>[96.806,-79.769,46.273,1],
50917=>[96.828,-79.773,46.249,1],
50918=>[96.851,-79.779,46.226,1],
50919=>[96.873,-79.783,46.201,1],
50920=>[96.895,-79.788,46.177,1],
50921=>[96.918,-79.792,46.152,1],
50922=>[96.940,-79.797,46.127,1],
50923=>[96.979,-79.797,46.104,1],
50924=>[97.026,-79.794,46.082,1],
50925=>[97.072,-79.792,46.059,1],
50926=>[97.118,-79.789,46.036,1],
50927=>[97.123,-79.798,46.013,1],
50928=>[97.122,-79.811,45.990,1],
50929=>[97.121,-79.822,45.966,1],
50930=>[97.124,-79.849,45.942,1],
50931=>[97.127,-79.877,45.921,1],
50932=>[97.131,-79.905,45.899,1],
50933=>[97.135,-79.934,45.877,1],
50934=>[97.138,-79.963,45.855,1],
50935=>[97.145,-79.975,45.834,1],
50936=>[97.152,-79.983,45.812,1],
51348=>[93.141,-79.481,53.204,1],
51349=>[93.155,-79.469,53.190,1],
51350=>[93.169,-79.456,53.176,1],
51351=>[93.184,-79.444,53.163,1],
51352=>[93.198,-79.432,53.149,1],
51353=>[93.212,-79.419,53.136,1],
51354=>[93.227,-79.410,53.124,1],
51355=>[93.243,-79.401,53.113,1],
51356=>[93.259,-79.394,53.103,1],
51357=>[93.276,-79.382,53.093,1],
51358=>[93.295,-79.370,53.083,1],
51359=>[93.313,-79.364,53.074,1],
51360=>[93.332,-79.358,53.066,1],
51361=>[93.350,-79.352,53.057,1],
51362=>[93.365,-79.347,53.047,1],
51363=>[93.380,-79.343,53.037,1],
51364=>[93.395,-79.338,53.026,1],
51365=>[93.410,-79.334,53.015,1],
51366=>[93.420,-79.328,53.002,1],
51367=>[93.428,-79.324,52.990,1],
51368=>[93.436,-79.319,52.979,1],
51369=>[93.444,-79.313,52.967,1],
51370=>[93.457,-79.308,52.954,1],
51371=>[93.472,-79.303,52.942,1],
51372=>[93.487,-79.297,52.928,1],
51373=>[93.502,-79.291,52.915,1],
51374=>[93.516,-79.286,52.904,1],
51375=>[93.532,-79.281,52.894,1],
51376=>[93.548,-79.277,52.886,1],
51377=>[93.564,-79.272,52.879,1],
51378=>[93.580,-79.269,52.872,1],
51379=>[93.595,-79.259,52.865,1],
51380=>[93.610,-79.249,52.857,1],
51381=>[93.625,-79.239,52.848,1],
51382=>[93.638,-79.234,52.839,1],
51383=>[93.652,-79.228,52.830,1],
51384=>[93.666,-79.223,52.822,1],
51385=>[93.681,-79.218,52.813,1],
51386=>[93.695,-79.212,52.805,1],
51387=>[93.709,-79.212,52.798,1],
51388=>[93.722,-79.212,52.789,1],
51389=>[93.736,-79.212,52.780,1],
51390=>[93.751,-79.212,52.772,1],
51391=>[93.762,-79.219,52.764,1],
51392=>[93.772,-79.228,52.755,1],
51393=>[93.785,-79.226,52.747,1],
51394=>[93.798,-79.222,52.738,1],
51395=>[93.811,-79.219,52.728,1],
51396=>[93.824,-79.215,52.719,1],
51397=>[93.837,-79.210,52.709,1],
51398=>[93.850,-79.206,52.701,1],
51399=>[93.864,-79.204,52.689,1],
51400=>[93.878,-79.204,52.676,1],
51401=>[93.893,-79.204,52.663,1],
51402=>[93.890,-79.201,52.645,1],
51403=>[93.894,-79.199,52.628,1],
51404=>[93.905,-79.198,52.611,1],
51405=>[93.916,-79.197,52.596,1],
51406=>[93.926,-79.196,52.580,1],
51407=>[93.937,-79.194,52.565,1],
51408=>[93.948,-79.194,52.549,1],
51409=>[93.960,-79.192,52.532,1],
51410=>[93.970,-79.191,52.515,1],
51411=>[93.990,-79.192,52.496,1],
51412=>[93.997,-79.195,52.473,1],
51413=>[93.999,-79.199,52.451,1],
51414=>[94.001,-79.198,52.429,1],
51415=>[94.002,-79.192,52.407,1],
51416=>[94.003,-79.186,52.388,1],
51417=>[94.003,-79.182,52.370,1],
51418=>[94.003,-79.182,52.355,1],
51419=>[94.003,-79.181,52.339,1],
51420=>[94.003,-79.181,52.323,1],
51421=>[94.003,-79.181,52.308,1],
51422=>[94.003,-79.180,52.295,1],
51423=>[94.003,-79.179,52.283,1],
51424=>[94.003,-79.178,52.271,1],
51425=>[94.003,-79.178,52.260,1],
51426=>[94.003,-79.178,52.247,1],
51427=>[94.006,-79.183,52.235,1],
51428=>[94.010,-79.190,52.224,1],
51429=>[94.014,-79.197,52.216,1],
51430=>[94.018,-79.203,52.207,1],
51431=>[94.017,-79.201,52.197,1],
51432=>[94.018,-79.196,52.188,1],
51433=>[94.030,-79.195,52.176,1],
51434=>[94.041,-79.194,52.162,1],
51435=>[94.046,-79.190,52.145,1],
51436=>[94.052,-79.187,52.127,1],
51437=>[94.057,-79.184,52.109,1],
51438=>[94.063,-79.181,52.090,1],
51439=>[94.068,-79.177,52.070,1],
51440=>[94.075,-79.187,52.048,1],
51441=>[94.083,-79.199,52.025,1],
51442=>[94.090,-79.210,51.999,1],
51443=>[94.097,-79.222,51.975,1],
51444=>[94.102,-79.231,51.952,1],
51445=>[94.102,-79.237,51.931,1],
51446=>[94.102,-79.242,51.912,1],
51447=>[94.102,-79.248,51.894,1],
51448=>[94.102,-79.254,51.876,1],
51449=>[94.102,-79.258,51.857,1],
51450=>[94.099,-79.255,51.838,1],
51451=>[94.097,-79.252,51.819,1],
51452=>[94.094,-79.249,51.799,1],
51453=>[94.091,-79.246,51.777,1],
51454=>[94.089,-79.243,51.753,1],
51455=>[94.086,-79.239,51.727,1],
51456=>[94.091,-79.223,51.702,1],
51457=>[94.101,-79.206,51.676,1],
51458=>[94.111,-79.190,51.651,1],
51459=>[94.121,-79.172,51.627,1],
51460=>[94.130,-79.156,51.604,1],
51461=>[94.140,-79.139,51.581,1],
51462=>[94.154,-79.131,51.558,1],
51463=>[94.167,-79.148,51.534,1],
51464=>[94.188,-79.158,51.508,1],
51465=>[94.216,-79.163,51.483,1],
51466=>[94.243,-79.169,51.453,1],
51467=>[94.266,-79.153,51.420,1],
51468=>[94.283,-79.128,51.385,1],
51469=>[94.306,-79.147,51.346,1],
51470=>[94.331,-79.140,51.308,1],
51471=>[94.358,-79.123,51.270,1],
51472=>[94.386,-79.106,51.232,1],
51473=>[94.413,-79.090,51.195,1],
51474=>[94.440,-79.072,51.158,1],
51475=>[94.459,-79.063,51.120,1],
51476=>[94.470,-79.059,51.081,1],
51477=>[94.481,-79.056,51.043,1],
51478=>[94.492,-79.052,51.005,1],
51479=>[94.504,-79.048,50.967,1],
51480=>[94.515,-79.044,50.930,1],
51481=>[94.526,-79.040,50.893,1],
51482=>[94.538,-79.037,50.856,1],
51483=>[94.549,-79.034,50.819,1],
51529=>[94.933,-79.365,49.126,1],
51530=>[94.943,-79.374,49.089,1],
51531=>[94.956,-79.387,49.052,1],
51532=>[94.969,-79.400,49.015,1],
51533=>[94.983,-79.413,48.979,1],
51534=>[94.996,-79.426,48.943,1],
51535=>[95.009,-79.439,48.907,1],
51536=>[95.022,-79.452,48.870,1],
51537=>[95.035,-79.465,48.833,1],
51538=>[95.048,-79.478,48.797,1],
51539=>[95.061,-79.491,48.760,1],
51540=>[95.074,-79.504,48.724,1],
51541=>[95.096,-79.507,48.690,1],
51542=>[95.120,-79.509,48.657,1],
51543=>[95.143,-79.510,48.624,1],
51544=>[95.167,-79.512,48.586,1],
51545=>[95.191,-79.513,48.546,1],
51546=>[95.214,-79.515,48.506,1],
51547=>[95.238,-79.516,48.468,1],
51548=>[95.261,-79.518,48.430,1],
51549=>[95.285,-79.520,48.394,1],
51550=>[95.309,-79.521,48.357,1],
51551=>[95.332,-79.523,48.321,1],
51552=>[95.355,-79.524,48.285,1],
51553=>[95.379,-79.526,48.249,1],
51554=>[95.403,-79.527,48.214,1],
51555=>[95.426,-79.529,48.178,1],
51556=>[95.450,-79.530,48.143,1],
51557=>[95.473,-79.532,48.107,1],
51558=>[95.497,-79.533,48.072,1],
51559=>[95.521,-79.535,48.037,1],
51560=>[95.544,-79.536,48.002,1],
51561=>[95.568,-79.538,47.968,1],
51562=>[95.591,-79.539,47.934,1],
51563=>[95.615,-79.541,47.900,1],
51564=>[95.638,-79.542,47.867,1],
51565=>[95.662,-79.544,47.833,1],
51566=>[95.680,-79.531,47.800,1],
51567=>[95.695,-79.510,47.767,1],
51568=>[95.710,-79.488,47.734,1],
51569=>[95.726,-79.467,47.701,1],
51570=>[95.742,-79.454,47.667,1],
51571=>[95.765,-79.467,47.634,1],
51572=>[95.788,-79.480,47.601,1],
51573=>[95.811,-79.493,47.568,1],
51574=>[95.833,-79.506,47.534,1],
51575=>[95.856,-79.520,47.502,1],
51576=>[95.879,-79.532,47.469,1],
51577=>[95.902,-79.545,47.436,1],
51578=>[95.925,-79.558,47.403,1],
51579=>[95.948,-79.571,47.370,1],
51580=>[95.970,-79.579,47.337,1],
51581=>[95.992,-79.584,47.304,1],
51582=>[96.015,-79.588,47.273,1],
51583=>[96.038,-79.593,47.241,1],
51584=>[96.060,-79.598,47.210,1],
51585=>[96.083,-79.603,47.178,1],
51611=>[96.667,-79.723,46.426,1],
51612=>[96.689,-79.728,46.401,1],
51613=>[96.712,-79.733,46.376,1],
51614=>[96.735,-79.737,46.350,1],
51615=>[96.757,-79.742,46.323,1],
51616=>[96.780,-79.746,46.299,1],
51617=>[96.802,-79.751,46.274,1],
51618=>[96.824,-79.756,46.250,1],
51619=>[96.847,-79.761,46.226,1],
51620=>[96.869,-79.765,46.202,1],
51621=>[96.892,-79.770,46.177,1],
51622=>[96.914,-79.774,46.152,1],
51623=>[96.937,-79.779,46.128,1],
51624=>[96.976,-79.779,46.105,1],
51625=>[97.022,-79.776,46.082,1],
51626=>[97.069,-79.773,46.060,1],
51627=>[97.115,-79.770,46.037,1],
51628=>[97.120,-79.780,46.013,1],
51629=>[97.120,-79.792,45.990,1],
51630=>[97.119,-79.803,45.966,1],
51631=>[97.122,-79.829,45.943,1],
51632=>[97.125,-79.858,45.922,1],
51633=>[97.129,-79.886,45.899,1],
51634=>[97.132,-79.915,45.878,1],
51635=>[97.138,-79.933,45.856,1],
51636=>[97.145,-79.941,45.834,1],
51637=>[97.152,-79.949,45.812,1],
51638=>[97.159,-79.956,45.791,1],
51639=>[97.166,-79.964,45.771,1],
52050=>[93.154,-79.458,53.217,1],
52051=>[93.168,-79.446,53.203,1],
52052=>[93.183,-79.434,53.190,1],
52053=>[93.197,-79.422,53.177,1],
52054=>[93.211,-79.410,53.164,1],
52055=>[93.225,-79.397,53.151,1],
52056=>[93.239,-79.385,53.140,1],
52057=>[93.255,-79.376,53.129,1],
52058=>[93.271,-79.369,53.117,1],
52059=>[93.289,-79.356,53.107,1],
52060=>[93.307,-79.348,53.097,1],
52061=>[93.326,-79.342,53.088,1],
52062=>[93.342,-79.338,53.077,1],
52063=>[93.357,-79.333,53.067,1],
52064=>[93.372,-79.328,53.057,1],
52065=>[93.387,-79.324,53.045,1],
52066=>[93.402,-79.319,53.033,1],
52067=>[93.413,-79.314,53.020,1],
52068=>[93.421,-79.309,53.008,1],
52069=>[93.429,-79.303,52.996,1],
52070=>[93.438,-79.299,52.984,1],
52071=>[93.453,-79.293,52.972,1],
52072=>[93.468,-79.288,52.959,1],
52073=>[93.483,-79.282,52.946,1],
52074=>[93.497,-79.277,52.934,1],
52075=>[93.512,-79.272,52.923,1],
52076=>[93.527,-79.266,52.915,1],
52077=>[93.543,-79.262,52.907,1],
52078=>[93.559,-79.257,52.899,1],
52079=>[93.575,-79.253,52.893,1],
52080=>[93.590,-79.244,52.885,1],
52081=>[93.605,-79.234,52.877,1],
52082=>[93.619,-79.227,52.868,1],
52083=>[93.633,-79.222,52.858,1],
52084=>[93.647,-79.216,52.848,1],
52085=>[93.661,-79.210,52.839,1],
52086=>[93.675,-79.205,52.831,1],
52087=>[93.689,-79.200,52.824,1],
52088=>[93.703,-79.196,52.817,1],
52089=>[93.717,-79.196,52.809,1],
52090=>[93.731,-79.196,52.800,1],
52091=>[93.743,-79.200,52.792,1],
52092=>[93.753,-79.209,52.783,1],
52093=>[93.764,-79.216,52.775,1],
52094=>[93.777,-79.212,52.767,1],
52095=>[93.790,-79.209,52.757,1],
52096=>[93.803,-79.205,52.748,1],
52097=>[93.817,-79.201,52.738,1],
52098=>[93.830,-79.197,52.730,1],
52099=>[93.844,-79.196,52.720,1],
52100=>[93.858,-79.195,52.707,1],
52101=>[93.873,-79.195,52.693,1],
52102=>[93.888,-79.195,52.679,1],
52103=>[93.884,-79.192,52.661,1],
52104=>[93.878,-79.188,52.644,1],
52105=>[93.889,-79.187,52.629,1],
52106=>[93.900,-79.186,52.614,1],
52107=>[93.911,-79.185,52.600,1],
52108=>[93.922,-79.184,52.585,1],
52109=>[93.932,-79.183,52.569,1],
52110=>[93.943,-79.181,52.551,1],
52111=>[93.962,-79.182,52.531,1],
52112=>[93.981,-79.184,52.510,1],
52113=>[93.988,-79.186,52.486,1],
52114=>[93.990,-79.190,52.463,1],
52115=>[93.992,-79.195,52.441,1],
52116=>[93.994,-79.197,52.422,1],
52117=>[93.995,-79.190,52.405,1],
52118=>[93.996,-79.184,52.389,1],
52119=>[93.997,-79.178,52.376,1],
52120=>[93.997,-79.172,52.360,1],
52121=>[93.998,-79.168,52.345,1],
52122=>[93.998,-79.167,52.330,1],
52123=>[93.998,-79.166,52.317,1],
52124=>[93.998,-79.166,52.306,1],
52125=>[93.998,-79.165,52.295,1],
52126=>[93.998,-79.165,52.284,1],
52127=>[93.998,-79.165,52.272,1],
52128=>[94.000,-79.169,52.260,1],
52129=>[94.004,-79.175,52.249,1],
52130=>[94.008,-79.182,52.241,1],
52131=>[94.012,-79.189,52.232,1],
52132=>[94.016,-79.196,52.222,1],
52133=>[94.019,-79.196,52.211,1],
52134=>[94.027,-79.194,52.197,1],
52135=>[94.032,-79.190,52.180,1],
52136=>[94.038,-79.187,52.161,1],
52137=>[94.043,-79.184,52.142,1],
52138=>[94.049,-79.180,52.122,1],
52139=>[94.054,-79.177,52.102,1],
52140=>[94.060,-79.175,52.081,1],
52141=>[94.067,-79.187,52.060,1],
52142=>[94.074,-79.198,52.036,1],
52143=>[94.082,-79.209,52.013,1],
52144=>[94.086,-79.218,51.990,1],
52145=>[94.089,-79.225,51.969,1],
52146=>[94.089,-79.230,51.949,1],
52147=>[94.089,-79.235,51.931,1],
52148=>[94.089,-79.241,51.913,1],
52149=>[94.090,-79.247,51.894,1],
52150=>[94.089,-79.250,51.874,1],
52151=>[94.086,-79.247,51.853,1],
52152=>[94.084,-79.244,51.832,1],
52153=>[94.082,-79.241,51.809,1],
52154=>[94.079,-79.237,51.784,1],
52155=>[94.077,-79.234,51.759,1],
52156=>[94.077,-79.231,51.732,1],
52157=>[94.081,-79.223,51.706,1],
52158=>[94.090,-79.207,51.680,1],
52159=>[94.099,-79.191,51.655,1],
52160=>[94.108,-79.175,51.631,1],
52161=>[94.117,-79.159,51.610,1],
52162=>[94.126,-79.144,51.589,1],
52163=>[94.142,-79.136,51.568,1],
52164=>[94.170,-79.142,51.545,1],
52165=>[94.197,-79.147,51.521,1],
52166=>[94.224,-79.153,51.496,1],
52167=>[94.252,-79.159,51.466,1],
52168=>[94.269,-79.131,51.434,1],
52169=>[94.282,-79.103,51.400,1],
52170=>[94.308,-79.107,51.361,1],
52171=>[94.332,-79.122,51.322,1],
52172=>[94.356,-79.120,51.284,1],
52173=>[94.383,-79.103,51.245,1],
52174=>[94.410,-79.087,51.208,1],
52175=>[94.437,-79.070,51.170,1],
52176=>[94.464,-79.053,51.133,1],
52177=>[94.475,-79.050,51.094,1],
52178=>[94.486,-79.046,51.055,1],
52179=>[94.498,-79.043,51.018,1],
52180=>[94.509,-79.039,50.980,1],
52181=>[94.521,-79.035,50.943,1],
52182=>[94.532,-79.031,50.906,1],
52183=>[94.543,-79.028,50.869,1],
52184=>[94.554,-79.024,50.832,1],
52185=>[94.565,-79.021,50.795,1],
52186=>[94.577,-79.017,50.757,1],
52228=>[94.925,-79.329,49.206,1],
52229=>[94.933,-79.337,49.169,1],
52230=>[94.942,-79.344,49.132,1],
52231=>[94.950,-79.352,49.095,1],
52232=>[94.958,-79.360,49.059,1],
52233=>[94.967,-79.366,49.023,1],
52234=>[94.975,-79.374,48.987,1],
52235=>[94.987,-79.387,48.950,1],
52236=>[95.000,-79.400,48.914,1],
52237=>[95.014,-79.413,48.878,1],
52238=>[95.027,-79.426,48.842,1],
52239=>[95.040,-79.438,48.805,1],
52240=>[95.053,-79.451,48.768,1],
52241=>[95.066,-79.464,48.732,1],
52242=>[95.087,-79.469,48.697,1],
52243=>[95.110,-79.471,48.664,1],
52244=>[95.133,-79.473,48.630,1],
52245=>[95.157,-79.474,48.591,1],
52246=>[95.181,-79.476,48.552,1],
52247=>[95.204,-79.477,48.513,1],
52248=>[95.228,-79.479,48.475,1],
52249=>[95.252,-79.480,48.438,1],
52250=>[95.275,-79.482,48.401,1],
52251=>[95.299,-79.483,48.364,1],
52252=>[95.322,-79.485,48.327,1],
52253=>[95.346,-79.486,48.291,1],
52254=>[95.370,-79.488,48.255,1],
52255=>[95.393,-79.489,48.219,1],
52256=>[95.416,-79.491,48.184,1],
52257=>[95.440,-79.492,48.148,1],
52258=>[95.464,-79.494,48.112,1],
52259=>[95.487,-79.495,48.077,1],
52260=>[95.511,-79.497,48.042,1],
52261=>[95.534,-79.498,48.007,1],
52262=>[95.558,-79.500,47.974,1],
52263=>[95.582,-79.501,47.940,1],
52264=>[95.605,-79.503,47.907,1],
52265=>[95.629,-79.504,47.874,1],
52266=>[95.652,-79.506,47.841,1],
52267=>[95.673,-79.501,47.808,1],
52268=>[95.688,-79.479,47.775,1],
52269=>[95.703,-79.458,47.741,1],
52270=>[95.719,-79.437,47.708,1],
52271=>[95.739,-79.439,47.674,1],
52272=>[95.761,-79.452,47.641,1],
52273=>[95.784,-79.465,47.609,1],
52274=>[95.807,-79.478,47.575,1],
52275=>[95.830,-79.491,47.542,1],
52276=>[95.853,-79.504,47.509,1],
52277=>[95.876,-79.517,47.475,1],
52278=>[95.898,-79.530,47.442,1],
52279=>[95.921,-79.543,47.410,1],
52280=>[95.944,-79.557,47.376,1],
52281=>[95.967,-79.561,47.343,1],
52282=>[95.989,-79.566,47.310,1],
52283=>[96.012,-79.570,47.277,1],
52284=>[96.034,-79.576,47.245,1],
52285=>[96.056,-79.580,47.214,1],
52286=>[96.079,-79.585,47.182,1],
52287=>[96.102,-79.589,47.150,1],
52308=>[96.574,-79.687,46.532,1],
52309=>[96.596,-79.692,46.505,1],
52310=>[96.618,-79.696,46.477,1],
52311=>[96.641,-79.701,46.452,1],
52312=>[96.664,-79.705,46.427,1],
52313=>[96.686,-79.710,46.403,1],
52314=>[96.709,-79.714,46.376,1],
52315=>[96.731,-79.719,46.350,1],
52316=>[96.753,-79.723,46.325,1],
52317=>[96.776,-79.729,46.300,1],
52318=>[96.798,-79.733,46.276,1],
52319=>[96.821,-79.738,46.252,1],
52320=>[96.843,-79.742,46.227,1],
52321=>[96.866,-79.747,46.203,1],
52322=>[96.888,-79.751,46.179,1],
52323=>[96.911,-79.756,46.154,1],
52324=>[96.933,-79.761,46.130,1],
52325=>[96.972,-79.761,46.106,1],
52326=>[97.019,-79.758,46.084,1],
52327=>[97.065,-79.755,46.062,1],
52328=>[97.112,-79.752,46.039,1],
52329=>[97.118,-79.762,46.016,1],
52330=>[97.117,-79.773,45.992,1],
52331=>[97.117,-79.785,45.968,1],
52332=>[97.119,-79.810,45.944,1],
52333=>[97.123,-79.839,45.922,1],
52334=>[97.126,-79.867,45.900,1],
52335=>[97.131,-79.891,45.878,1],
52336=>[97.138,-79.899,45.857,1],
52337=>[97.145,-79.906,45.834,1],
52338=>[97.152,-79.914,45.812,1],
52339=>[97.159,-79.921,45.791,1],
52340=>[97.166,-79.929,45.771,1],
52341=>[97.173,-79.936,45.750,1],
52751=>[93.153,-79.447,53.244,1],
52752=>[93.167,-79.435,53.230,1],
52753=>[93.182,-79.423,53.217,1],
52754=>[93.196,-79.411,53.204,1],
52755=>[93.210,-79.399,53.191,1],
52756=>[93.224,-79.387,53.178,1],
52757=>[93.238,-79.375,53.166,1],
52758=>[93.252,-79.363,53.155,1],
52759=>[93.267,-79.351,53.142,1],
52760=>[93.283,-79.343,53.131,1],
52761=>[93.301,-79.333,53.121,1],
52762=>[93.320,-79.327,53.110,1],
52763=>[93.335,-79.322,53.099,1],
52764=>[93.350,-79.318,53.088,1],
52765=>[93.364,-79.313,53.077,1],
52766=>[93.379,-79.309,53.066,1],
52767=>[93.395,-79.304,53.054,1],
52768=>[93.407,-79.300,53.040,1],
52769=>[93.415,-79.294,53.026,1],
52770=>[93.423,-79.289,53.013,1],
52771=>[93.434,-79.284,53.000,1],
52772=>[93.448,-79.278,52.988,1],
52773=>[93.464,-79.273,52.976,1],
52774=>[93.478,-79.268,52.964,1],
52775=>[93.493,-79.263,52.953,1],
52776=>[93.508,-79.257,52.943,1],
52777=>[93.523,-79.252,52.935,1],
52778=>[93.538,-79.247,52.927,1],
52779=>[93.553,-79.242,52.919,1],
52780=>[93.570,-79.237,52.913,1],
52781=>[93.585,-79.230,52.905,1],
52782=>[93.600,-79.219,52.897,1],
52783=>[93.614,-79.214,52.887,1],
52784=>[93.628,-79.209,52.877,1],
52785=>[93.642,-79.203,52.867,1],
52786=>[93.655,-79.198,52.858,1],
52787=>[93.670,-79.193,52.850,1],
52788=>[93.684,-79.187,52.843,1],
52789=>[93.698,-79.182,52.836,1],
52790=>[93.712,-79.178,52.829,1],
52791=>[93.724,-79.182,52.821,1],
52792=>[93.734,-79.191,52.812,1],
52793=>[93.745,-79.200,52.804,1],
52794=>[93.757,-79.203,52.796,1],
52795=>[93.770,-79.199,52.787,1],
52796=>[93.783,-79.195,52.778,1],
52797=>[93.796,-79.191,52.768,1],
52798=>[93.809,-79.187,52.759,1],
52799=>[93.824,-79.187,52.751,1],
52800=>[93.838,-79.187,52.741,1],
52801=>[93.853,-79.186,52.728,1],
52802=>[93.867,-79.186,52.713,1],
52803=>[93.882,-79.186,52.698,1],
52804=>[93.879,-79.183,52.682,1],
52805=>[93.870,-79.179,52.666,1],
52806=>[93.873,-79.177,52.651,1],
52807=>[93.884,-79.175,52.637,1],
52808=>[93.895,-79.175,52.623,1],
52809=>[93.906,-79.173,52.607,1],
52810=>[93.917,-79.172,52.589,1],
52811=>[93.934,-79.172,52.570,1],
52812=>[93.955,-79.174,52.549,1],
52813=>[93.970,-79.175,52.527,1],
52814=>[93.978,-79.178,52.503,1],
52815=>[93.981,-79.181,52.480,1],
52816=>[93.983,-79.186,52.459,1],
52817=>[93.985,-79.190,52.442,1],
52818=>[93.987,-79.194,52.426,1],
52819=>[93.988,-79.190,52.412,1],
52820=>[93.989,-79.184,52.399,1],
52821=>[93.990,-79.177,52.384,1],
52822=>[93.991,-79.171,52.369,1],
52823=>[93.991,-79.165,52.356,1],
52824=>[93.992,-79.159,52.342,1],
52825=>[93.993,-79.153,52.331,1],
52826=>[93.993,-79.153,52.321,1],
52827=>[93.993,-79.152,52.310,1],
52828=>[93.993,-79.151,52.299,1],
52829=>[93.994,-79.153,52.287,1],
52830=>[93.998,-79.160,52.276,1],
52831=>[94.002,-79.167,52.269,1],
52832=>[94.006,-79.174,52.259,1],
52833=>[94.011,-79.184,52.247,1],
52834=>[94.016,-79.193,52.235,1],
52835=>[94.019,-79.190,52.219,1],
52836=>[94.024,-79.187,52.201,1],
52837=>[94.029,-79.184,52.180,1],
52838=>[94.035,-79.180,52.160,1],
52839=>[94.040,-79.177,52.139,1],
52840=>[94.046,-79.174,52.118,1],
52841=>[94.052,-79.175,52.098,1],
52842=>[94.059,-79.187,52.076,1],
52843=>[94.065,-79.197,52.053,1],
52844=>[94.069,-79.204,52.030,1],
52845=>[94.073,-79.212,52.008,1],
52846=>[94.076,-79.219,51.987,1],
52847=>[94.076,-79.224,51.967,1],
52848=>[94.077,-79.228,51.950,1],
52849=>[94.077,-79.234,51.932,1],
52850=>[94.078,-79.239,51.912,1],
52851=>[94.077,-79.241,51.891,1],
52852=>[94.074,-79.238,51.868,1],
52853=>[94.073,-79.235,51.844,1],
52854=>[94.073,-79.231,51.818,1],
52855=>[94.074,-79.228,51.792,1],
52856=>[94.075,-79.225,51.765,1],
52857=>[94.076,-79.221,51.736,1],
52858=>[94.079,-79.213,51.709,1],
52859=>[94.088,-79.197,51.684,1],
52860=>[94.097,-79.182,51.661,1],
52861=>[94.106,-79.166,51.640,1],
52862=>[94.115,-79.150,51.620,1],
52863=>[94.127,-79.132,51.602,1],
52864=>[94.150,-79.112,51.583,1],
52865=>[94.178,-79.123,51.563,1],
52866=>[94.205,-79.134,51.540,1],
52867=>[94.232,-79.143,51.516,1],
52868=>[94.256,-79.137,51.487,1],
52869=>[94.269,-79.109,51.455,1],
52870=>[94.281,-79.081,51.420,1],
52871=>[94.305,-79.078,51.379,1],
52872=>[94.332,-79.086,51.338,1],
52873=>[94.358,-79.096,51.298,1],
52874=>[94.381,-79.100,51.259,1],
52875=>[94.408,-79.084,51.221,1],
52876=>[94.435,-79.067,51.183,1],
52877=>[94.463,-79.050,51.146,1],
52878=>[94.481,-79.041,51.107,1],
52879=>[94.492,-79.037,51.069,1],
52880=>[94.503,-79.034,51.030,1],
52881=>[94.514,-79.030,50.993,1],
52882=>[94.526,-79.026,50.956,1],
52883=>[94.537,-79.022,50.919,1],
52884=>[94.548,-79.019,50.883,1],
52885=>[94.559,-79.015,50.845,1],
52886=>[94.571,-79.012,50.807,1],
52887=>[94.582,-79.008,50.770,1],
52888=>[94.594,-79.004,50.733,1],
52928=>[94.925,-79.302,49.249,1],
52929=>[94.933,-79.309,49.213,1],
52930=>[94.942,-79.316,49.177,1],
52931=>[94.950,-79.324,49.140,1],
52932=>[94.958,-79.332,49.103,1],
52933=>[94.967,-79.339,49.067,1],
52934=>[94.975,-79.347,49.030,1],
52935=>[94.983,-79.354,48.994,1],
52936=>[94.991,-79.361,48.958,1],
52937=>[94.999,-79.369,48.921,1],
52938=>[95.008,-79.376,48.886,1],
52939=>[95.019,-79.386,48.850,1],
52940=>[95.032,-79.399,48.813,1],
52941=>[95.045,-79.412,48.777,1],
52942=>[95.058,-79.426,48.741,1],
52943=>[95.076,-79.432,48.705,1],
52944=>[95.100,-79.433,48.670,1],
52945=>[95.124,-79.435,48.635,1],
52946=>[95.147,-79.436,48.597,1],
52947=>[95.171,-79.438,48.559,1],
52948=>[95.194,-79.439,48.520,1],
52949=>[95.218,-79.441,48.483,1],
52950=>[95.242,-79.442,48.445,1],
52951=>[95.265,-79.444,48.408,1],
52952=>[95.289,-79.445,48.370,1],
52953=>[95.313,-79.447,48.334,1],
52954=>[95.336,-79.448,48.297,1],
52955=>[95.359,-79.450,48.260,1],
52956=>[95.383,-79.451,48.225,1],
52957=>[95.407,-79.453,48.190,1],
52958=>[95.430,-79.454,48.154,1],
52959=>[95.454,-79.456,48.118,1],
52960=>[95.477,-79.457,48.083,1],
52961=>[95.501,-79.459,48.048,1],
52962=>[95.525,-79.460,48.014,1],
52963=>[95.548,-79.462,47.980,1],
52964=>[95.572,-79.463,47.946,1],
52965=>[95.595,-79.465,47.913,1],
52966=>[95.619,-79.466,47.880,1],
52967=>[95.642,-79.468,47.847,1],
52968=>[95.666,-79.469,47.815,1],
52969=>[95.682,-79.449,47.782,1],
52970=>[95.696,-79.428,47.750,1],
52971=>[95.712,-79.411,47.717,1],
52972=>[95.735,-79.424,47.684,1],
52973=>[95.758,-79.437,47.650,1],
52974=>[95.781,-79.450,47.618,1],
52975=>[95.804,-79.463,47.584,1],
52976=>[95.827,-79.476,47.550,1],
52977=>[95.849,-79.489,47.517,1],
52978=>[95.872,-79.502,47.483,1],
52979=>[95.895,-79.516,47.450,1],
52980=>[95.918,-79.529,47.416,1],
52981=>[95.941,-79.538,47.382,1],
52982=>[95.963,-79.543,47.348,1],
52983=>[95.985,-79.548,47.315,1],
52984=>[96.008,-79.553,47.282,1],
52985=>[96.031,-79.557,47.250,1],
52986=>[96.053,-79.562,47.218,1],
52987=>[96.076,-79.567,47.186,1],
52988=>[96.098,-79.571,47.154,1],
53005=>[96.480,-79.650,46.640,1],
53006=>[96.503,-79.654,46.613,1],
53007=>[96.525,-79.659,46.586,1],
53008=>[96.547,-79.664,46.559,1],
53009=>[96.570,-79.669,46.532,1],
53010=>[96.592,-79.673,46.505,1],
53011=>[96.615,-79.678,46.478,1],
53012=>[96.638,-79.683,46.452,1],
53013=>[96.660,-79.687,46.428,1],
53014=>[96.682,-79.692,46.403,1],
53015=>[96.705,-79.696,46.378,1],
53016=>[96.727,-79.701,46.351,1],
53017=>[96.750,-79.706,46.326,1],
53018=>[96.772,-79.711,46.301,1],
53019=>[96.795,-79.715,46.277,1],
53020=>[96.817,-79.720,46.253,1],
53021=>[96.840,-79.724,46.229,1],
53022=>[96.862,-79.729,46.205,1],
53023=>[96.885,-79.733,46.181,1],
53024=>[96.907,-79.739,46.157,1],
53025=>[96.930,-79.743,46.132,1],
53026=>[96.969,-79.742,46.109,1],
53027=>[97.015,-79.740,46.087,1],
53028=>[97.062,-79.737,46.065,1],
53029=>[97.108,-79.735,46.042,1],
53030=>[97.116,-79.743,46.018,1],
53031=>[97.115,-79.755,45.995,1],
53032=>[97.114,-79.767,45.970,1],
53033=>[97.117,-79.791,45.946,1],
53034=>[97.120,-79.819,45.924,1],
53035=>[97.124,-79.848,45.901,1],
53036=>[97.131,-79.857,45.879,1],
53037=>[97.138,-79.864,45.857,1],
53038=>[97.145,-79.872,45.834,1],
53039=>[97.152,-79.880,45.812,1],
53040=>[97.159,-79.887,45.791,1],
53041=>[97.166,-79.895,45.770,1],
53042=>[97.173,-79.902,45.749,1],
53043=>[97.180,-79.910,45.729,1],
53452=>[93.153,-79.438,53.271,1],
53453=>[93.166,-79.425,53.257,1],
53454=>[93.181,-79.413,53.244,1],
53455=>[93.195,-79.400,53.231,1],
53456=>[93.209,-79.388,53.218,1],
53457=>[93.223,-79.376,53.205,1],
53458=>[93.237,-79.364,53.193,1],
53459=>[93.251,-79.352,53.181,1],
53460=>[93.265,-79.340,53.167,1],
53461=>[93.279,-79.328,53.156,1],
53462=>[93.295,-79.317,53.144,1],
53463=>[93.312,-79.313,53.132,1],
53464=>[93.327,-79.308,53.121,1],
53465=>[93.342,-79.303,53.109,1],
53466=>[93.357,-79.299,53.098,1],
53467=>[93.371,-79.294,53.087,1],
53468=>[93.386,-79.290,53.074,1],
53469=>[93.401,-79.285,53.061,1],
53470=>[93.409,-79.280,53.047,1],
53471=>[93.417,-79.275,53.034,1],
53472=>[93.429,-79.269,53.022,1],
53473=>[93.444,-79.264,53.010,1],
53474=>[93.459,-79.259,52.997,1],
53475=>[93.474,-79.253,52.985,1],
53476=>[93.489,-79.248,52.974,1],
53477=>[93.504,-79.242,52.963,1],
53478=>[93.518,-79.237,52.955,1],
53479=>[93.533,-79.231,52.947,1],
53480=>[93.548,-79.226,52.940,1],
53481=>[93.564,-79.222,52.932,1],
53482=>[93.579,-79.215,52.924,1],
53483=>[93.594,-79.206,52.916,1],
53484=>[93.608,-79.201,52.907,1],
53485=>[93.622,-79.196,52.897,1],
53486=>[93.636,-79.190,52.888,1],
53487=>[93.650,-79.185,52.879,1],
53488=>[93.664,-79.180,52.871,1],
53489=>[93.678,-79.175,52.864,1],
53490=>[93.692,-79.170,52.856,1],
53491=>[93.705,-79.167,52.849,1],
53492=>[93.716,-79.173,52.842,1],
53493=>[93.726,-79.182,52.834,1],
53494=>[93.736,-79.190,52.826,1],
53495=>[93.749,-79.189,52.817,1],
53496=>[93.762,-79.185,52.808,1],
53497=>[93.775,-79.181,52.799,1],
53498=>[93.789,-79.178,52.790,1],
53499=>[93.803,-79.178,52.781,1],
53500=>[93.818,-79.178,52.772,1],
53501=>[93.833,-79.178,52.761,1],
53502=>[93.847,-79.177,52.749,1],
53503=>[93.862,-79.177,52.735,1],
53504=>[93.876,-79.177,52.719,1],
53505=>[93.873,-79.174,52.703,1],
53506=>[93.864,-79.170,52.688,1],
53507=>[93.857,-79.166,52.674,1],
53508=>[93.868,-79.165,52.660,1],
53509=>[93.879,-79.164,52.644,1],
53510=>[93.890,-79.162,52.628,1],
53511=>[93.906,-79.162,52.609,1],
53512=>[93.926,-79.164,52.589,1],
53513=>[93.946,-79.165,52.569,1],
53514=>[93.960,-79.167,52.548,1],
53515=>[93.967,-79.170,52.526,1],
53516=>[93.972,-79.173,52.504,1],
53517=>[93.974,-79.178,52.484,1],
53518=>[93.976,-79.181,52.468,1],
53519=>[93.978,-79.186,52.453,1],
53520=>[93.980,-79.190,52.440,1],
53521=>[93.981,-79.188,52.427,1],
53522=>[93.982,-79.182,52.412,1],
53523=>[93.983,-79.176,52.398,1],
53524=>[93.984,-79.170,52.385,1],
53525=>[93.985,-79.164,52.371,1],
53526=>[93.986,-79.157,52.359,1],
53527=>[93.986,-79.151,52.348,1],
53528=>[93.987,-79.145,52.339,1],
53529=>[93.988,-79.139,52.328,1],
53530=>[93.989,-79.138,52.318,1],
53531=>[93.993,-79.147,52.307,1],
53532=>[93.998,-79.156,52.297,1],
53533=>[94.003,-79.166,52.287,1],
53534=>[94.008,-79.176,52.274,1],
53535=>[94.013,-79.186,52.261,1],
53536=>[94.017,-79.185,52.244,1],
53537=>[94.020,-79.182,52.224,1],
53538=>[94.024,-79.179,52.201,1],
53539=>[94.028,-79.176,52.180,1],
53540=>[94.032,-79.174,52.159,1],
53541=>[94.037,-79.170,52.138,1],
53542=>[94.044,-79.175,52.117,1],
53543=>[94.048,-79.183,52.095,1],
53544=>[94.052,-79.190,52.073,1],
53545=>[94.056,-79.198,52.050,1],
53546=>[94.060,-79.206,52.028,1],
53547=>[94.063,-79.213,52.007,1],
53548=>[94.064,-79.218,51.986,1],
53549=>[94.064,-79.223,51.969,1],
53550=>[94.065,-79.228,51.950,1],
53551=>[94.065,-79.233,51.930,1],
53552=>[94.070,-79.233,51.908,1],
53553=>[94.070,-79.229,51.883,1],
53554=>[94.071,-79.225,51.857,1],
53555=>[94.072,-79.222,51.830,1],
53556=>[94.073,-79.218,51.802,1],
53557=>[94.073,-79.215,51.773,1],
53558=>[94.074,-79.211,51.743,1],
53559=>[94.077,-79.204,51.716,1],
53560=>[94.086,-79.188,51.691,1],
53561=>[94.095,-79.172,51.670,1],
53562=>[94.104,-79.156,51.651,1],
53563=>[94.114,-79.140,51.634,1],
53564=>[94.135,-79.115,51.618,1],
53565=>[94.157,-79.090,51.600,1],
53566=>[94.185,-79.099,51.580,1],
53567=>[94.212,-79.109,51.559,1],
53568=>[94.240,-79.120,51.535,1],
53569=>[94.257,-79.112,51.507,1],
53570=>[94.269,-79.087,51.474,1],
53571=>[94.281,-79.059,51.438,1],
53572=>[94.301,-79.048,51.396,1],
53573=>[94.328,-79.057,51.354,1],
53574=>[94.355,-79.065,51.313,1],
53575=>[94.383,-79.074,51.273,1],
53576=>[94.406,-79.081,51.234,1],
53577=>[94.433,-79.065,51.197,1],
53578=>[94.460,-79.047,51.159,1],
53579=>[94.486,-79.032,51.121,1],
53580=>[94.497,-79.028,51.082,1],
53581=>[94.508,-79.024,51.044,1],
53582=>[94.520,-79.021,51.007,1],
53583=>[94.531,-79.017,50.970,1],
53584=>[94.542,-79.013,50.933,1],
53585=>[94.554,-79.010,50.896,1],
53586=>[94.565,-79.006,50.858,1],
53587=>[94.576,-79.002,50.821,1],
53588=>[94.588,-78.999,50.783,1],
53589=>[94.599,-78.995,50.746,1],
53590=>[94.610,-78.991,50.709,1],
53591=>[94.619,-78.997,50.672,1],
53628=>[94.925,-79.274,49.293,1],
53629=>[94.933,-79.281,49.256,1],
53630=>[94.942,-79.289,49.220,1],
53631=>[94.950,-79.296,49.184,1],
53632=>[94.958,-79.303,49.149,1],
53633=>[94.967,-79.311,49.111,1],
53634=>[94.975,-79.319,49.075,1],
53635=>[94.983,-79.326,49.039,1],
53636=>[94.991,-79.334,49.002,1],
53637=>[95.000,-79.341,48.966,1],
53638=>[95.008,-79.349,48.930,1],
53639=>[95.017,-79.356,48.894,1],
53640=>[95.025,-79.363,48.858,1],
53641=>[95.033,-79.371,48.822,1],
53642=>[95.041,-79.379,48.786,1],
53643=>[95.049,-79.386,48.750,1],
53644=>[95.067,-79.394,48.713,1],
53645=>[95.091,-79.396,48.677,1],
53646=>[95.114,-79.397,48.640,1],
53647=>[95.137,-79.399,48.603,1],
53648=>[95.161,-79.400,48.566,1],
53649=>[95.185,-79.402,48.528,1],
53650=>[95.208,-79.403,48.490,1],
53651=>[95.232,-79.404,48.452,1],
53652=>[95.255,-79.406,48.415,1],
53653=>[95.279,-79.407,48.378,1],
53654=>[95.303,-79.409,48.341,1],
53655=>[95.326,-79.410,48.303,1],
53656=>[95.350,-79.412,48.266,1],
53657=>[95.374,-79.413,48.232,1],
53658=>[95.397,-79.415,48.195,1],
53659=>[95.420,-79.416,48.159,1],
53660=>[95.444,-79.418,48.124,1],
53661=>[95.468,-79.419,48.089,1],
53662=>[95.491,-79.421,48.055,1],
53663=>[95.515,-79.422,48.020,1],
53664=>[95.538,-79.424,47.986,1],
53665=>[95.562,-79.425,47.952,1],
53666=>[95.586,-79.427,47.920,1],
53667=>[95.609,-79.429,47.887,1],
53668=>[95.633,-79.430,47.854,1],
53669=>[95.656,-79.432,47.822,1],
53670=>[95.675,-79.419,47.790,1],
53671=>[95.690,-79.398,47.759,1],
53672=>[95.709,-79.396,47.727,1],
53673=>[95.732,-79.409,47.694,1],
53674=>[95.755,-79.422,47.662,1],
53675=>[95.777,-79.435,47.628,1],
53676=>[95.800,-79.448,47.594,1],
53677=>[95.823,-79.461,47.559,1],
53678=>[95.846,-79.474,47.525,1],
53679=>[95.869,-79.488,47.491,1],
53680=>[95.892,-79.501,47.457,1],
53681=>[95.914,-79.513,47.423,1],
53682=>[95.937,-79.521,47.388,1],
53683=>[95.959,-79.526,47.353,1],
53684=>[95.982,-79.530,47.319,1],
53685=>[96.005,-79.535,47.286,1],
53686=>[96.027,-79.539,47.254,1],
53687=>[96.049,-79.544,47.222,1],
53688=>[96.072,-79.548,47.190,1],
53689=>[96.094,-79.553,47.157,1],
53704=>[96.432,-79.623,46.698,1],
53705=>[96.454,-79.627,46.669,1],
53706=>[96.476,-79.632,46.640,1],
53707=>[96.499,-79.637,46.613,1],
53708=>[96.521,-79.642,46.586,1],
53709=>[96.544,-79.646,46.559,1],
53710=>[96.567,-79.651,46.532,1],
53711=>[96.589,-79.655,46.506,1],
53712=>[96.611,-79.660,46.479,1],
53713=>[96.634,-79.664,46.453,1],
53714=>[96.656,-79.669,46.429,1],
53715=>[96.679,-79.674,46.404,1],
53716=>[96.701,-79.679,46.379,1],
53717=>[96.724,-79.683,46.353,1],
53718=>[96.746,-79.688,46.327,1],
53719=>[96.768,-79.692,46.302,1],
53720=>[96.791,-79.697,46.278,1],
53721=>[96.814,-79.701,46.254,1],
53722=>[96.836,-79.706,46.231,1],
53723=>[96.859,-79.711,46.207,1],
53724=>[96.881,-79.716,46.183,1],
53725=>[96.903,-79.720,46.161,1],
53726=>[96.926,-79.725,46.137,1],
53727=>[96.965,-79.724,46.114,1],
53728=>[97.012,-79.722,46.093,1],
53729=>[97.058,-79.719,46.069,1],
53730=>[97.105,-79.717,46.045,1],
53731=>[97.114,-79.725,46.021,1],
53732=>[97.113,-79.736,45.998,1],
53733=>[97.112,-79.748,45.973,1],
53734=>[97.114,-79.771,45.949,1],
53735=>[97.118,-79.800,45.925,1],
53736=>[97.124,-79.814,45.903,1],
53737=>[97.131,-79.822,45.880,1],
53738=>[97.138,-79.830,45.856,1],
53739=>[97.145,-79.837,45.834,1],
53740=>[97.152,-79.845,45.812,1],
53741=>[97.159,-79.852,45.790,1],
53742=>[97.166,-79.860,45.770,1],
53743=>[97.173,-79.867,45.749,1],
53744=>[97.180,-79.875,45.728,1],
53745=>[97.187,-79.883,45.707,1],
54154=>[93.166,-79.415,53.285,1],
54155=>[93.180,-79.403,53.272,1],
54156=>[93.194,-79.391,53.258,1],
54157=>[93.208,-79.379,53.245,1],
54158=>[93.222,-79.366,53.232,1],
54159=>[93.236,-79.354,53.219,1],
54160=>[93.250,-79.341,53.206,1],
54161=>[93.264,-79.329,53.193,1],
54162=>[93.278,-79.317,53.181,1],
54163=>[93.292,-79.305,53.168,1],
54164=>[93.304,-79.297,53.156,1],
54165=>[93.319,-79.293,53.142,1],
54166=>[93.334,-79.288,53.130,1],
54167=>[93.349,-79.284,53.119,1],
54168=>[93.364,-79.279,53.108,1],
54169=>[93.379,-79.275,53.095,1],
54170=>[93.394,-79.270,53.081,1],
54171=>[93.402,-79.266,53.068,1],
54172=>[93.410,-79.260,53.056,1],
54173=>[93.425,-79.255,53.045,1],
54174=>[93.440,-79.250,53.033,1],
54175=>[93.455,-79.244,53.020,1],
54176=>[93.470,-79.238,53.009,1],
54177=>[93.485,-79.233,52.997,1],
54178=>[93.499,-79.228,52.987,1],
54179=>[93.514,-79.222,52.977,1],
54180=>[93.529,-79.217,52.969,1],
54181=>[93.544,-79.212,52.962,1],
54182=>[93.559,-79.206,52.954,1],
54183=>[93.574,-79.200,52.946,1],
54184=>[93.588,-79.194,52.938,1],
54185=>[93.603,-79.188,52.928,1],
54186=>[93.617,-79.183,52.918,1],
54187=>[93.630,-79.178,52.909,1],
54188=>[93.643,-79.175,52.901,1],
54189=>[93.656,-79.172,52.893,1],
54190=>[93.670,-79.169,52.886,1],
54191=>[93.683,-79.165,52.880,1],
54192=>[93.696,-79.162,52.873,1],
54193=>[93.707,-79.164,52.865,1],
54194=>[93.718,-79.172,52.857,1],
54195=>[93.728,-79.179,52.848,1],
54196=>[93.742,-79.175,52.840,1],
54197=>[93.755,-79.172,52.831,1],
54198=>[93.769,-79.169,52.822,1],
54199=>[93.783,-79.169,52.812,1],
54200=>[93.798,-79.169,52.802,1],
54201=>[93.813,-79.169,52.793,1],
54202=>[93.827,-79.169,52.781,1],
54203=>[93.842,-79.168,52.768,1],
54204=>[93.856,-79.168,52.755,1],
54205=>[93.870,-79.168,52.741,1],
54206=>[93.868,-79.165,52.726,1],
54207=>[93.859,-79.161,52.712,1],
54208=>[93.850,-79.157,52.698,1],
54209=>[93.852,-79.154,52.682,1],
54210=>[93.863,-79.153,52.666,1],
54211=>[93.878,-79.153,52.648,1],
54212=>[93.898,-79.154,52.629,1],
54213=>[93.919,-79.156,52.610,1],
54214=>[93.939,-79.156,52.591,1],
54215=>[93.949,-79.159,52.572,1],
54216=>[93.957,-79.162,52.550,1],
54217=>[93.963,-79.165,52.530,1],
54218=>[93.965,-79.169,52.512,1],
54219=>[93.967,-79.173,52.497,1],
54220=>[93.969,-79.178,52.483,1],
54221=>[93.971,-79.181,52.470,1],
54222=>[93.973,-79.186,52.457,1],
54223=>[93.974,-79.187,52.443,1],
54224=>[93.975,-79.181,52.429,1],
54225=>[93.976,-79.175,52.416,1],
54226=>[93.977,-79.169,52.402,1],
54227=>[93.978,-79.162,52.389,1],
54228=>[93.979,-79.156,52.377,1],
54229=>[93.980,-79.150,52.368,1],
54230=>[93.980,-79.144,52.358,1],
54231=>[93.984,-79.139,52.348,1],
54232=>[93.990,-79.139,52.338,1],
54233=>[93.995,-79.149,52.327,1],
54234=>[94.000,-79.159,52.316,1],
54235=>[94.005,-79.169,52.302,1],
54236=>[94.010,-79.178,52.289,1],
54237=>[94.014,-79.181,52.271,1],
54238=>[94.017,-79.178,52.250,1],
54239=>[94.021,-79.175,52.227,1],
54240=>[94.025,-79.172,52.205,1],
54241=>[94.029,-79.169,52.183,1],
54242=>[94.032,-79.166,52.161,1],
54243=>[94.031,-79.169,52.139,1],
54244=>[94.035,-79.177,52.117,1],
54245=>[94.039,-79.184,52.093,1],
54246=>[94.043,-79.192,52.071,1],
54247=>[94.047,-79.200,52.048,1],
54248=>[94.050,-79.207,52.026,1],
54249=>[94.051,-79.212,52.005,1],
54250=>[94.051,-79.217,51.986,1],
54251=>[94.052,-79.222,51.967,1],
54252=>[94.059,-79.223,51.947,1],
54253=>[94.070,-79.222,51.924,1],
54254=>[94.070,-79.219,51.898,1],
54255=>[94.070,-79.216,51.871,1],
54256=>[94.070,-79.212,51.843,1],
54257=>[94.071,-79.208,51.814,1],
54258=>[94.072,-79.204,51.783,1],
54259=>[94.072,-79.201,51.752,1],
54260=>[94.075,-79.194,51.726,1],
54261=>[94.084,-79.179,51.704,1],
54262=>[94.093,-79.163,51.683,1],
54263=>[94.102,-79.147,51.665,1],
54264=>[94.122,-79.123,51.651,1],
54265=>[94.144,-79.098,51.636,1],
54266=>[94.166,-79.072,51.618,1],
54267=>[94.192,-79.074,51.599,1],
54268=>[94.220,-79.084,51.577,1],
54269=>[94.248,-79.095,51.554,1],
54270=>[94.261,-79.080,51.525,1],
54271=>[94.271,-79.059,51.492,1],
54272=>[94.281,-79.037,51.454,1],
54273=>[94.298,-79.019,51.412,1],
54274=>[94.325,-79.028,51.370,1],
54275=>[94.352,-79.036,51.328,1],
54276=>[94.380,-79.044,51.287,1],
54277=>[94.407,-79.053,51.248,1],
54278=>[94.430,-79.062,51.210,1],
54279=>[94.458,-79.045,51.173,1],
54280=>[94.485,-79.028,51.135,1],
54281=>[94.502,-79.019,51.096,1],
54282=>[94.514,-79.015,51.058,1],
54283=>[94.525,-79.012,51.020,1],
54284=>[94.537,-79.008,50.983,1],
54285=>[94.548,-79.004,50.946,1],
54286=>[94.559,-79.001,50.909,1],
54287=>[94.570,-78.997,50.871,1],
54288=>[94.581,-78.993,50.834,1],
54289=>[94.593,-78.990,50.796,1],
54290=>[94.604,-78.986,50.759,1],
54291=>[94.615,-78.982,50.722,1],
54292=>[94.627,-78.978,50.685,1],
54293=>[94.635,-78.984,50.647,1],
54327=>[94.917,-79.238,49.375,1],
54328=>[94.925,-79.246,49.338,1],
54329=>[94.933,-79.253,49.301,1],
54330=>[94.942,-79.261,49.264,1],
54331=>[94.950,-79.269,49.228,1],
54332=>[94.959,-79.276,49.193,1],
54333=>[94.967,-79.284,49.157,1],
54334=>[94.975,-79.291,49.120,1],
54335=>[94.983,-79.298,49.083,1],
54336=>[94.991,-79.306,49.048,1],
54337=>[95.000,-79.313,49.012,1],
54338=>[95.008,-79.321,48.975,1],
54339=>[95.017,-79.328,48.939,1],
54340=>[95.025,-79.336,48.903,1],
54341=>[95.033,-79.343,48.867,1],
54342=>[95.041,-79.350,48.832,1],
54343=>[95.052,-79.366,48.796,1],
54344=>[95.068,-79.385,48.760,1],
54345=>[95.082,-79.385,48.723,1],
54346=>[95.105,-79.389,48.686,1],
54347=>[95.136,-79.394,48.649,1],
54348=>[95.164,-79.394,48.611,1],
54349=>[95.181,-79.390,48.574,1],
54350=>[95.198,-79.385,48.537,1],
54351=>[95.215,-79.381,48.499,1],
54352=>[95.232,-79.376,48.460,1],
54353=>[95.249,-79.372,48.423,1],
54354=>[95.269,-79.370,48.386,1],
54355=>[95.293,-79.372,48.348,1],
54356=>[95.316,-79.372,48.310,1],
54357=>[95.340,-79.374,48.272,1],
54358=>[95.364,-79.375,48.237,1],
54359=>[95.387,-79.377,48.201,1],
54360=>[95.411,-79.379,48.165,1],
54361=>[95.435,-79.380,48.130,1],
54362=>[95.458,-79.382,48.095,1],
54363=>[95.481,-79.383,48.059,1],
54364=>[95.505,-79.385,48.025,1],
54365=>[95.529,-79.386,47.991,1],
54366=>[95.552,-79.388,47.958,1],
54367=>[95.576,-79.389,47.927,1],
54368=>[95.599,-79.391,47.895,1],
54369=>[95.623,-79.392,47.863,1],
54370=>[95.647,-79.394,47.831,1],
54371=>[95.668,-79.389,47.798,1],
54372=>[95.683,-79.368,47.769,1],
54373=>[95.705,-79.381,47.739,1],
54374=>[95.729,-79.394,47.708,1],
54375=>[95.751,-79.407,47.676,1],
54376=>[95.774,-79.420,47.641,1],
54377=>[95.797,-79.433,47.605,1],
54378=>[95.820,-79.446,47.569,1],
54379=>[95.842,-79.460,47.534,1],
54380=>[95.865,-79.473,47.499,1],
54381=>[95.888,-79.485,47.464,1],
54382=>[95.911,-79.498,47.429,1],
54383=>[95.934,-79.503,47.393,1],
54384=>[95.956,-79.507,47.357,1],
54385=>[95.978,-79.512,47.324,1],
54386=>[96.001,-79.516,47.290,1],
54387=>[96.023,-79.521,47.257,1],
54388=>[96.046,-79.526,47.225,1],
54389=>[96.068,-79.530,47.192,1],
54390=>[96.091,-79.535,47.160,1],
54391=>[96.113,-79.540,47.128,1],
54404=>[96.405,-79.600,46.729,1],
54405=>[96.428,-79.604,46.699,1],
54406=>[96.450,-79.610,46.668,1],
54407=>[96.473,-79.614,46.640,1],
54408=>[96.496,-79.619,46.613,1],
54409=>[96.518,-79.623,46.586,1],
54410=>[96.540,-79.628,46.559,1],
54411=>[96.563,-79.632,46.532,1],
54412=>[96.585,-79.637,46.505,1],
54413=>[96.608,-79.642,46.479,1],
54414=>[96.630,-79.647,46.454,1],
54415=>[96.653,-79.651,46.429,1],
54416=>[96.675,-79.656,46.405,1],
54417=>[96.697,-79.661,46.380,1],
54418=>[96.720,-79.665,46.355,1],
54419=>[96.743,-79.670,46.330,1],
54420=>[96.765,-79.674,46.304,1],
54421=>[96.788,-79.679,46.279,1],
54422=>[96.810,-79.684,46.256,1],
54423=>[96.832,-79.689,46.232,1],
54424=>[96.855,-79.693,46.209,1],
54425=>[96.878,-79.698,46.187,1],
54426=>[96.900,-79.702,46.167,1],
54427=>[96.923,-79.707,46.148,1],
54428=>[96.962,-79.706,46.128,1],
54429=>[97.009,-79.704,46.105,1],
54430=>[97.055,-79.701,46.082,1],
54431=>[97.103,-79.698,46.057,1],
54432=>[97.111,-79.707,46.030,1],
54433=>[97.111,-79.718,46.003,1],
54434=>[97.110,-79.730,45.976,1],
54435=>[97.112,-79.752,45.951,1],
54436=>[97.117,-79.772,45.927,1],
54437=>[97.124,-79.780,45.905,1],
54438=>[97.131,-79.787,45.881,1],
54439=>[97.138,-79.795,45.857,1],
54440=>[97.145,-79.803,45.834,1],
54441=>[97.152,-79.811,45.812,1],
54442=>[97.159,-79.818,45.791,1],
54443=>[97.166,-79.826,45.770,1],
54444=>[97.173,-79.833,45.748,1],
54445=>[97.180,-79.841,45.728,1],
54446=>[97.188,-79.849,45.707,1],
54447=>[97.195,-79.856,45.686,1],
54855=>[93.165,-79.404,53.312,1],
54856=>[93.179,-79.392,53.299,1],
54857=>[93.193,-79.380,53.285,1],
54858=>[93.207,-79.368,53.271,1],
54859=>[93.221,-79.356,53.258,1],
54860=>[93.235,-79.344,53.245,1],
54861=>[93.249,-79.332,53.232,1],
54862=>[93.263,-79.319,53.219,1],
54863=>[93.277,-79.307,53.206,1],
54864=>[93.291,-79.295,53.192,1],
54865=>[93.303,-79.290,53.179,1],
54866=>[93.314,-79.283,53.165,1],
54867=>[93.326,-79.274,53.152,1],
54868=>[93.341,-79.269,53.141,1],
54869=>[93.356,-79.265,53.129,1],
54870=>[93.371,-79.260,53.116,1],
54871=>[93.386,-79.256,53.103,1],
54872=>[93.396,-79.250,53.090,1],
54873=>[93.406,-79.245,53.079,1],
54874=>[93.421,-79.240,53.068,1],
54875=>[93.436,-79.234,53.057,1],
54876=>[93.450,-79.229,53.045,1],
54877=>[93.466,-79.224,53.034,1],
54878=>[93.480,-79.219,53.022,1],
54879=>[93.495,-79.213,53.013,1],
54880=>[93.510,-79.208,53.003,1],
54881=>[93.524,-79.203,52.993,1],
54882=>[93.540,-79.197,52.986,1],
54883=>[93.554,-79.191,52.978,1],
54884=>[93.569,-79.187,52.970,1],
54885=>[93.582,-79.184,52.961,1],
54886=>[93.595,-79.180,52.950,1],
54887=>[93.608,-79.177,52.940,1],
54888=>[93.621,-79.174,52.931,1],
54889=>[93.634,-79.170,52.924,1],
54890=>[93.647,-79.167,52.916,1],
54891=>[93.660,-79.164,52.910,1],
54892=>[93.673,-79.161,52.904,1],
54893=>[93.686,-79.157,52.897,1],
54894=>[93.699,-79.154,52.889,1],
54895=>[93.709,-79.163,52.882,1],
54896=>[93.721,-79.165,52.873,1],
54897=>[93.734,-79.162,52.864,1],
54898=>[93.749,-79.160,52.855,1],
54899=>[93.763,-79.160,52.846,1],
54900=>[93.778,-79.159,52.836,1],
54901=>[93.792,-79.159,52.826,1],
54902=>[93.806,-79.159,52.816,1],
54903=>[93.821,-79.159,52.803,1],
54904=>[93.836,-79.159,52.791,1],
54905=>[93.850,-79.159,52.778,1],
54906=>[93.865,-79.159,52.764,1],
54907=>[93.862,-79.156,52.750,1],
54908=>[93.853,-79.152,52.737,1],
54909=>[93.845,-79.148,52.724,1],
54910=>[93.837,-79.143,52.706,1],
54911=>[93.850,-79.143,52.689,1],
54912=>[93.870,-79.144,52.671,1],
54913=>[93.891,-79.146,52.651,1],
54914=>[93.911,-79.147,52.632,1],
54915=>[93.931,-79.148,52.613,1],
54916=>[93.939,-79.150,52.595,1],
54917=>[93.946,-79.153,52.576,1],
54918=>[93.954,-79.156,52.558,1],
54919=>[93.956,-79.160,52.542,1],
54920=>[93.958,-79.164,52.529,1],
54921=>[93.960,-79.169,52.515,1],
54922=>[93.962,-79.173,52.502,1],
54923=>[93.964,-79.177,52.489,1],
54924=>[93.966,-79.181,52.476,1],
54925=>[93.968,-79.186,52.462,1],
54926=>[93.968,-79.180,52.450,1],
54927=>[93.969,-79.174,52.435,1],
54928=>[93.970,-79.167,52.421,1],
54929=>[93.971,-79.161,52.408,1],
54930=>[93.972,-79.155,52.398,1],
54931=>[93.973,-79.149,52.387,1],
54932=>[93.979,-79.145,52.378,1],
54933=>[93.985,-79.142,52.368,1],
54934=>[93.991,-79.141,52.357,1],
54935=>[93.996,-79.151,52.345,1],
54936=>[94.001,-79.161,52.331,1],
54937=>[94.006,-79.171,52.317,1],
54938=>[94.011,-79.176,52.299,1],
54939=>[94.014,-79.173,52.277,1],
54940=>[94.018,-79.170,52.255,1],
54941=>[94.022,-79.168,52.232,1],
54942=>[94.026,-79.165,52.209,1],
54943=>[94.026,-79.166,52.186,1],
54944=>[94.025,-79.169,52.163,1],
54945=>[94.024,-79.173,52.140,1],
54946=>[94.026,-79.178,52.116,1],
54947=>[94.030,-79.186,52.093,1],
54948=>[94.034,-79.194,52.070,1],
54949=>[94.038,-79.202,52.047,1],
54950=>[94.038,-79.206,52.025,1],
54951=>[94.039,-79.212,52.006,1],
54952=>[94.044,-79.213,51.986,1],
54953=>[94.055,-79.212,51.963,1],
54954=>[94.066,-79.212,51.939,1],
54955=>[94.071,-79.209,51.913,1],
54956=>[94.070,-79.206,51.885,1],
54957=>[94.069,-79.202,51.856,1],
54958=>[94.069,-79.198,51.826,1],
54959=>[94.070,-79.194,51.796,1],
54960=>[94.071,-79.191,51.766,1],
54961=>[94.073,-79.185,51.743,1],
54962=>[94.082,-79.169,51.722,1],
54963=>[94.091,-79.153,51.703,1],
54964=>[94.109,-79.131,51.687,1],
54965=>[94.131,-79.106,51.671,1],
54966=>[94.153,-79.081,51.656,1],
54967=>[94.175,-79.055,51.638,1],
54968=>[94.200,-79.049,51.618,1],
54969=>[94.227,-79.060,51.597,1],
54970=>[94.254,-79.068,51.572,1],
54971=>[94.264,-79.048,51.541,1],
54972=>[94.274,-79.027,51.507,1],
54973=>[94.284,-79.006,51.469,1],
54974=>[94.297,-78.995,51.427,1],
54975=>[94.322,-78.998,51.384,1],
54976=>[94.349,-79.006,51.343,1],
54977=>[94.377,-79.015,51.302,1],
54978=>[94.404,-79.024,51.263,1],
54979=>[94.431,-79.032,51.224,1],
54980=>[94.455,-79.042,51.186,1],
54981=>[94.482,-79.025,51.148,1],
54982=>[94.508,-79.010,51.110,1],
54983=>[94.520,-79.006,51.072,1],
54984=>[94.531,-79.002,51.034,1],
54985=>[94.542,-78.999,50.997,1],
54986=>[94.553,-78.995,50.959,1],
54987=>[94.564,-78.991,50.922,1],
54988=>[94.575,-78.988,50.884,1],
54989=>[94.587,-78.984,50.847,1],
54990=>[94.598,-78.981,50.809,1],
54991=>[94.610,-78.977,50.772,1],
54992=>[94.621,-78.973,50.734,1],
54993=>[94.632,-78.969,50.697,1],
54994=>[94.643,-78.966,50.660,1],
54995=>[94.652,-78.971,50.622,1],
54996=>[94.661,-78.979,50.584,1],
54997=>[94.669,-78.987,50.547,1],
54998=>[94.677,-78.994,50.508,1],
55027=>[94.917,-79.211,49.421,1],
55028=>[94.925,-79.219,49.384,1],
55029=>[94.933,-79.225,49.346,1],
55030=>[94.942,-79.233,49.310,1],
55031=>[94.950,-79.241,49.274,1],
55032=>[94.959,-79.248,49.238,1],
55033=>[94.967,-79.256,49.202,1],
55034=>[94.975,-79.263,49.166,1],
55035=>[94.983,-79.271,49.129,1],
55036=>[94.992,-79.278,49.093,1],
55037=>[95.000,-79.285,49.057,1],
55038=>[95.008,-79.293,49.022,1],
55039=>[95.017,-79.300,48.986,1],
55040=>[95.025,-79.308,48.950,1],
55041=>[95.035,-79.321,48.914,1],
55042=>[95.047,-79.339,48.878,1],
55043=>[95.060,-79.357,48.843,1],
55044=>[95.072,-79.375,48.808,1],
55045=>[95.111,-79.400,48.772,1],
55046=>[95.101,-79.382,48.734,1],
55047=>[95.125,-79.385,48.697,1],
55048=>[95.148,-79.389,48.659,1],
55049=>[95.172,-79.393,48.622,1],
55050=>[95.199,-79.397,48.584,1],
55051=>[95.237,-79.403,48.547,1],
55052=>[95.273,-79.408,48.509,1],
55053=>[95.292,-79.404,48.470,1],
55054=>[95.309,-79.400,48.432,1],
55055=>[95.326,-79.395,48.394,1],
55056=>[95.343,-79.391,48.356,1],
55057=>[95.360,-79.386,48.318,1],
55058=>[95.378,-79.382,48.281,1],
55059=>[95.395,-79.377,48.245,1],
55060=>[95.412,-79.372,48.208,1],
55061=>[95.429,-79.368,48.173,1],
55062=>[95.447,-79.363,48.138,1],
55063=>[95.464,-79.359,48.102,1],
55064=>[95.481,-79.354,48.066,1],
55065=>[95.498,-79.350,48.031,1],
55066=>[95.519,-79.348,47.998,1],
55067=>[95.542,-79.350,47.966,1],
55068=>[95.566,-79.351,47.934,1],
55069=>[95.590,-79.353,47.903,1],
55070=>[95.613,-79.354,47.872,1],
55071=>[95.636,-79.356,47.841,1],
55072=>[95.660,-79.357,47.812,1],
55073=>[95.679,-79.353,47.781,1],
55074=>[95.702,-79.366,47.752,1],
55075=>[95.725,-79.379,47.722,1],
55076=>[95.748,-79.392,47.689,1],
55077=>[95.770,-79.405,47.654,1],
55078=>[95.794,-79.418,47.618,1],
55079=>[95.816,-79.432,47.583,1],
55080=>[95.839,-79.444,47.547,1],
55081=>[95.862,-79.457,47.510,1],
55082=>[95.885,-79.470,47.472,1],
55083=>[95.907,-79.480,47.434,1],
55084=>[95.930,-79.485,47.398,1],
55085=>[95.952,-79.489,47.362,1],
55086=>[95.975,-79.494,47.327,1],
55087=>[95.997,-79.498,47.293,1],
55088=>[96.020,-79.503,47.260,1],
55089=>[96.042,-79.508,47.228,1],
55090=>[96.064,-79.513,47.194,1],
55091=>[96.087,-79.517,47.162,1],
55092=>[96.110,-79.522,47.129,1],
55103=>[96.357,-79.573,46.788,1],
55104=>[96.379,-79.577,46.758,1],
55105=>[96.402,-79.582,46.728,1],
55106=>[96.425,-79.587,46.698,1],
55107=>[96.447,-79.592,46.668,1],
55108=>[96.469,-79.596,46.640,1],
55109=>[96.492,-79.601,46.612,1],
55110=>[96.514,-79.605,46.585,1],
55111=>[96.537,-79.610,46.559,1],
55112=>[96.559,-79.614,46.532,1],
55113=>[96.582,-79.620,46.505,1],
55114=>[96.604,-79.624,46.479,1],
55115=>[96.626,-79.629,46.454,1],
55116=>[96.650,-79.632,46.430,1],
55117=>[96.674,-79.636,46.407,1],
55118=>[96.697,-79.640,46.382,1],
55119=>[96.722,-79.644,46.357,1],
55120=>[96.745,-79.648,46.332,1],
55121=>[96.769,-79.651,46.306,1],
55122=>[96.793,-79.655,46.281,1],
55123=>[96.817,-79.660,46.258,1],
55124=>[96.841,-79.664,46.235,1],
55125=>[96.865,-79.667,46.213,1],
55126=>[96.888,-79.671,46.192,1],
55127=>[96.912,-79.675,46.173,1],
55128=>[96.927,-79.685,46.156,1],
55129=>[96.972,-79.683,46.136,1],
55130=>[97.021,-79.679,46.114,1],
55131=>[97.070,-79.676,46.091,1],
55132=>[97.098,-79.672,46.067,1],
55133=>[97.120,-79.668,46.042,1],
55134=>[97.115,-79.690,46.014,1],
55135=>[97.108,-79.711,45.986,1],
55136=>[97.110,-79.730,45.958,1],
55137=>[97.117,-79.738,45.932,1],
55138=>[97.124,-79.745,45.908,1],
55139=>[97.131,-79.753,45.883,1],
55140=>[97.138,-79.761,45.859,1],
55141=>[97.145,-79.768,45.835,1],
55142=>[97.152,-79.776,45.813,1],
55143=>[97.160,-79.783,45.791,1],
55144=>[97.167,-79.791,45.769,1],
55145=>[97.174,-79.798,45.748,1],
55146=>[97.181,-79.806,45.727,1],
55147=>[97.188,-79.814,45.707,1],
55148=>[97.195,-79.822,45.685,1],
55149=>[97.202,-79.830,45.664,1],
55556=>[93.164,-79.394,53.339,1],
55557=>[93.178,-79.382,53.325,1],
55558=>[93.192,-79.370,53.312,1],
55559=>[93.206,-79.358,53.298,1],
55560=>[93.220,-79.345,53.284,1],
55561=>[93.234,-79.333,53.271,1],
55562=>[93.248,-79.321,53.257,1],
55563=>[93.262,-79.309,53.244,1],
55564=>[93.276,-79.297,53.231,1],
55565=>[93.290,-79.285,53.217,1],
55566=>[93.304,-79.279,53.204,1],
55567=>[93.313,-79.277,53.189,1],
55568=>[93.324,-79.269,53.176,1],
55569=>[93.336,-79.259,53.164,1],
55570=>[93.348,-79.250,53.151,1],
55571=>[93.363,-79.246,53.138,1],
55572=>[93.378,-79.241,53.125,1],
55573=>[93.390,-79.236,53.113,1],
55574=>[93.402,-79.231,53.103,1],
55575=>[93.417,-79.225,53.092,1],
55576=>[93.431,-79.220,53.081,1],
55577=>[93.446,-79.215,53.070,1],
55578=>[93.461,-79.209,53.059,1],
55579=>[93.476,-79.204,53.049,1],
55580=>[93.491,-79.199,53.040,1],
55581=>[93.505,-79.194,53.030,1],
55582=>[93.520,-79.188,53.021,1],
55583=>[93.534,-79.184,53.013,1],
55584=>[93.549,-79.179,53.004,1],
55585=>[93.563,-79.174,52.994,1],
55586=>[93.576,-79.172,52.984,1],
55587=>[93.588,-79.170,52.973,1],
55588=>[93.600,-79.169,52.963,1],
55589=>[93.612,-79.167,52.955,1],
55590=>[93.625,-79.165,52.947,1],
55591=>[93.638,-79.162,52.940,1],
55592=>[93.650,-79.159,52.934,1],
55593=>[93.663,-79.156,52.929,1],
55594=>[93.677,-79.153,52.922,1],
55595=>[93.690,-79.150,52.915,1],
55596=>[93.701,-79.154,52.908,1],
55597=>[93.714,-79.152,52.900,1],
55598=>[93.728,-79.151,52.890,1],
55599=>[93.743,-79.151,52.881,1],
55600=>[93.757,-79.151,52.871,1],
55601=>[93.772,-79.150,52.861,1],
55602=>[93.786,-79.150,52.851,1],
55603=>[93.801,-79.150,52.840,1],
55604=>[93.816,-79.150,52.827,1],
55605=>[93.830,-79.150,52.815,1],
55606=>[93.845,-79.150,52.802,1],
55607=>[93.859,-79.150,52.789,1],
55608=>[93.857,-79.147,52.776,1],
55609=>[93.848,-79.143,52.763,1],
55610=>[93.839,-79.139,52.748,1],
55611=>[93.832,-79.135,52.732,1],
55612=>[93.842,-79.134,52.714,1],
55613=>[93.863,-79.136,52.695,1],
55614=>[93.883,-79.137,52.676,1],
55615=>[93.904,-79.138,52.656,1],
55616=>[93.921,-79.140,52.638,1],
55617=>[93.928,-79.142,52.621,1],
55618=>[93.936,-79.145,52.604,1],
55619=>[93.943,-79.147,52.588,1],
55620=>[93.946,-79.151,52.575,1],
55621=>[93.948,-79.156,52.562,1],
55622=>[93.951,-79.160,52.550,1],
55623=>[93.953,-79.164,52.537,1],
55624=>[93.955,-79.169,52.525,1],
55625=>[93.957,-79.173,52.512,1],
55626=>[93.958,-79.177,52.498,1],
55627=>[93.960,-79.181,52.485,1],
55628=>[93.962,-79.178,52.470,1],
55629=>[93.963,-79.172,52.455,1],
55630=>[93.963,-79.166,52.440,1],
55631=>[93.964,-79.160,52.428,1],
55632=>[93.968,-79.156,52.417,1],
55633=>[93.974,-79.152,52.407,1],
55634=>[93.981,-79.148,52.396,1],
55635=>[93.987,-79.145,52.385,1],
55636=>[93.993,-79.143,52.373,1],
55637=>[93.998,-79.154,52.360,1],
55638=>[94.003,-79.164,52.345,1],
55639=>[94.008,-79.172,52.327,1],
55640=>[94.012,-79.169,52.306,1],
55641=>[94.015,-79.166,52.283,1],
55642=>[94.019,-79.163,52.260,1],
55643=>[94.020,-79.163,52.236,1],
55644=>[94.019,-79.166,52.213,1],
55645=>[94.019,-79.169,52.188,1],
55646=>[94.018,-79.173,52.163,1],
55647=>[94.017,-79.176,52.139,1],
55648=>[94.016,-79.180,52.116,1],
55649=>[94.020,-79.188,52.092,1],
55650=>[94.025,-79.196,52.069,1],
55651=>[94.025,-79.200,52.047,1],
55652=>[94.030,-79.203,52.026,1],
55653=>[94.041,-79.203,52.004,1],
55654=>[94.052,-79.201,51.978,1],
55655=>[94.063,-79.200,51.952,1],
55656=>[94.072,-79.199,51.926,1],
55657=>[94.071,-79.195,51.898,1],
55658=>[94.070,-79.192,51.868,1],
55659=>[94.068,-79.188,51.839,1],
55660=>[94.069,-79.184,51.810,1],
55661=>[94.069,-79.181,51.784,1],
55662=>[94.071,-79.176,51.763,1],
55663=>[94.080,-79.160,51.743,1],
55664=>[94.096,-79.140,51.725,1],
55665=>[94.118,-79.114,51.709,1],
55666=>[94.139,-79.089,51.692,1],
55667=>[94.161,-79.063,51.675,1],
55668=>[94.183,-79.038,51.657,1],
55669=>[94.207,-79.025,51.637,1],
55670=>[94.235,-79.036,51.615,1],
55671=>[94.257,-79.037,51.589,1],
55672=>[94.267,-79.015,51.556,1],
55673=>[94.277,-78.995,51.521,1],
55674=>[94.289,-78.981,51.482,1],
55675=>[94.309,-78.991,51.440,1],
55676=>[94.329,-79.000,51.398,1],
55677=>[94.351,-78.997,51.356,1],
55678=>[94.374,-78.990,51.315,1],
55679=>[94.400,-78.994,51.276,1],
55680=>[94.427,-79.002,51.237,1],
55681=>[94.455,-79.011,51.200,1],
55682=>[94.480,-79.022,51.162,1],
55683=>[94.507,-79.006,51.124,1],
55684=>[94.525,-78.997,51.086,1],
55685=>[94.536,-78.993,51.049,1],
55686=>[94.547,-78.990,51.011,1],
55687=>[94.558,-78.986,50.974,1],
55688=>[94.570,-78.982,50.936,1],
55689=>[94.581,-78.979,50.898,1],
55690=>[94.593,-78.975,50.860,1],
55691=>[94.604,-78.971,50.822,1],
55692=>[94.615,-78.968,50.785,1],
55693=>[94.626,-78.964,50.747,1],
55694=>[94.637,-78.960,50.710,1],
55695=>[94.648,-78.957,50.672,1],
55696=>[94.660,-78.953,50.634,1],
55697=>[94.669,-78.959,50.597,1],
55698=>[94.677,-78.966,50.559,1],
55699=>[94.685,-78.974,50.521,1],
55700=>[94.694,-78.981,50.483,1],
55701=>[94.702,-78.989,50.445,1],
55702=>[94.710,-78.996,50.407,1],
55703=>[94.718,-79.003,50.369,1],
55704=>[94.726,-79.011,50.331,1],
55705=>[94.735,-79.018,50.294,1],
55706=>[94.743,-79.026,50.257,1],
55727=>[94.917,-79.183,49.467,1],
55728=>[94.925,-79.190,49.430,1],
55729=>[94.934,-79.198,49.392,1],
55730=>[94.942,-79.206,49.356,1],
55731=>[94.951,-79.213,49.319,1],
55732=>[94.959,-79.220,49.283,1],
55733=>[94.967,-79.228,49.247,1],
55734=>[94.975,-79.235,49.211,1],
55735=>[94.983,-79.243,49.175,1],
55736=>[94.992,-79.250,49.139,1],
55737=>[95.000,-79.258,49.103,1],
55738=>[95.008,-79.266,49.067,1],
55739=>[95.018,-79.276,49.032,1],
55740=>[95.030,-79.294,48.996,1],
55741=>[95.042,-79.313,48.961,1],
55742=>[95.055,-79.331,48.925,1],
55743=>[95.067,-79.349,48.890,1],
55744=>[95.079,-79.367,48.855,1],
55745=>[95.115,-79.391,48.820,1],
55746=>[95.135,-79.400,48.783,1],
55747=>[95.120,-79.378,48.746,1],
55748=>[95.144,-79.382,48.708,1],
55749=>[95.168,-79.385,48.670,1],
55750=>[95.192,-79.389,48.633,1],
55751=>[95.215,-79.393,48.595,1],
55752=>[95.239,-79.397,48.557,1],
55753=>[95.263,-79.401,48.519,1],
55754=>[95.300,-79.407,48.481,1],
55755=>[95.337,-79.412,48.442,1],
55756=>[95.374,-79.417,48.403,1],
55757=>[95.403,-79.419,48.365,1],
55758=>[95.420,-79.414,48.328,1],
55759=>[95.438,-79.410,48.291,1],
55760=>[95.455,-79.405,48.253,1],
55761=>[95.472,-79.400,48.217,1],
55762=>[95.489,-79.396,48.182,1],
55763=>[95.506,-79.391,48.146,1],
55764=>[95.523,-79.387,48.110,1],
55765=>[95.540,-79.382,48.074,1],
55766=>[95.558,-79.378,48.039,1],
55767=>[95.575,-79.373,48.005,1],
55768=>[95.592,-79.369,47.974,1],
55769=>[95.609,-79.364,47.942,1],
55770=>[95.626,-79.360,47.911,1],
55771=>[95.642,-79.354,47.881,1],
55772=>[95.652,-79.346,47.852,1],
55773=>[95.661,-79.338,47.825,1],
55774=>[95.670,-79.340,47.794,1],
55775=>[95.691,-79.352,47.763,1],
55776=>[95.718,-79.364,47.732,1],
55777=>[95.744,-79.377,47.699,1],
55778=>[95.767,-79.390,47.664,1],
55779=>[95.790,-79.404,47.628,1],
55780=>[95.813,-79.416,47.592,1],
55781=>[95.835,-79.429,47.555,1],
55782=>[95.859,-79.442,47.517,1],
55783=>[95.881,-79.456,47.477,1],
55784=>[95.904,-79.462,47.438,1],
55785=>[95.926,-79.466,47.401,1],
55786=>[95.949,-79.471,47.365,1],
55787=>[95.971,-79.476,47.329,1],
55788=>[95.993,-79.481,47.295,1],
55789=>[96.016,-79.485,47.262,1],
55790=>[96.039,-79.490,47.229,1],
55791=>[96.061,-79.494,47.196,1],
55792=>[96.084,-79.499,47.163,1],
55793=>[96.106,-79.504,47.130,1],
55803=>[96.340,-79.545,46.818,1],
55804=>[96.365,-79.548,46.788,1],
55805=>[96.388,-79.552,46.757,1],
55806=>[96.412,-79.556,46.727,1],
55807=>[96.436,-79.560,46.697,1],
55808=>[96.460,-79.563,46.667,1],
55809=>[96.484,-79.567,46.639,1],
55810=>[96.508,-79.571,46.612,1],
55811=>[96.532,-79.575,46.584,1],
55812=>[96.555,-79.579,46.558,1],
55813=>[96.579,-79.582,46.532,1],
55814=>[96.603,-79.586,46.505,1],
55815=>[96.627,-79.590,46.479,1],
55816=>[96.651,-79.594,46.455,1],
55817=>[96.675,-79.598,46.431,1],
55818=>[96.698,-79.601,46.408,1],
55819=>[96.723,-79.605,46.384,1],
55820=>[96.746,-79.609,46.359,1],
55821=>[96.770,-79.613,46.333,1],
55822=>[96.794,-79.617,46.308,1],
55823=>[96.818,-79.620,46.283,1],
55824=>[96.842,-79.624,46.260,1],
55825=>[96.866,-79.628,46.238,1],
55826=>[96.890,-79.632,46.217,1],
55827=>[96.909,-79.639,46.197,1],
55828=>[96.920,-79.651,46.180,1],
55829=>[96.939,-79.661,46.161,1],
55830=>[96.987,-79.657,46.141,1],
55831=>[97.036,-79.653,46.119,1],
55832=>[97.068,-79.649,46.096,1],
55833=>[97.090,-79.645,46.075,1],
55834=>[97.111,-79.642,46.054,1],
55835=>[97.134,-79.638,46.028,1],
55836=>[97.130,-79.659,45.999,1],
55837=>[97.116,-79.690,45.970,1],
55838=>[97.117,-79.703,45.940,1],
55839=>[97.124,-79.711,45.912,1],
55840=>[97.132,-79.718,45.886,1],
55841=>[97.139,-79.726,45.861,1],
55842=>[97.146,-79.733,45.836,1],
55843=>[97.153,-79.742,45.813,1],
55844=>[97.160,-79.749,45.790,1],
55845=>[97.167,-79.757,45.769,1],
55846=>[97.174,-79.764,45.747,1],
55847=>[97.181,-79.772,45.726,1],
55848=>[97.188,-79.780,45.706,1],
55849=>[97.195,-79.787,45.684,1],
55850=>[97.202,-79.795,45.663,1],
55851=>[97.209,-79.802,45.642,1],
56258=>[93.177,-79.372,53.352,1],
56259=>[93.191,-79.360,53.338,1],
56260=>[93.205,-79.347,53.324,1],
56261=>[93.219,-79.335,53.311,1],
56262=>[93.233,-79.323,53.297,1],
56263=>[93.247,-79.311,53.283,1],
56264=>[93.261,-79.299,53.269,1],
56265=>[93.275,-79.286,53.256,1],
56266=>[93.289,-79.274,53.243,1],
56267=>[93.304,-79.269,53.229,1],
56268=>[93.313,-79.266,53.214,1],
56269=>[93.323,-79.263,53.200,1],
56270=>[93.334,-79.255,53.187,1],
56271=>[93.346,-79.244,53.174,1],
56272=>[93.357,-79.234,53.161,1],
56273=>[93.370,-79.226,53.148,1],
56274=>[93.383,-79.222,53.137,1],
56275=>[93.398,-79.216,53.126,1],
56276=>[93.412,-79.211,53.115,1],
56277=>[93.427,-79.206,53.103,1],
56278=>[93.441,-79.200,53.093,1],
56279=>[93.456,-79.196,53.083,1],
56280=>[93.471,-79.190,53.073,1],
56281=>[93.485,-79.186,53.064,1],
56282=>[93.499,-79.181,53.055,1],
56283=>[93.514,-79.176,53.046,1],
56284=>[93.529,-79.172,53.038,1],
56285=>[93.543,-79.166,53.029,1],
56286=>[93.557,-79.162,53.019,1],
56287=>[93.571,-79.158,53.008,1],
56288=>[93.583,-79.156,52.997,1],
56289=>[93.595,-79.155,52.988,1],
56290=>[93.608,-79.153,52.979,1],
56291=>[93.620,-79.152,52.972,1],
56292=>[93.632,-79.150,52.966,1],
56293=>[93.644,-79.149,52.960,1],
56294=>[93.656,-79.147,52.954,1],
56295=>[93.669,-79.146,52.948,1],
56296=>[93.681,-79.144,52.941,1],
56297=>[93.693,-79.143,52.935,1],
56298=>[93.708,-79.142,52.927,1],
56299=>[93.722,-79.142,52.918,1],
56300=>[93.737,-79.142,52.908,1],
56301=>[93.752,-79.142,52.898,1],
56302=>[93.766,-79.141,52.887,1],
56303=>[93.781,-79.141,52.876,1],
56304=>[93.795,-79.141,52.865,1],
56305=>[93.810,-79.141,52.853,1],
56306=>[93.825,-79.141,52.840,1],
56307=>[93.839,-79.140,52.827,1],
56308=>[93.854,-79.140,52.815,1],
56309=>[93.851,-79.137,52.802,1],
56310=>[93.843,-79.134,52.788,1],
56311=>[93.834,-79.130,52.773,1],
56312=>[93.837,-79.128,52.757,1],
56313=>[93.842,-79.127,52.740,1],
56314=>[93.855,-79.128,52.720,1],
56315=>[93.875,-79.128,52.701,1],
56316=>[93.896,-79.130,52.682,1],
56317=>[93.911,-79.131,52.664,1],
56318=>[93.918,-79.134,52.648,1],
56319=>[93.925,-79.137,52.633,1],
56320=>[93.933,-79.139,52.619,1],
56321=>[93.937,-79.143,52.608,1],
56322=>[93.939,-79.147,52.595,1],
56323=>[93.941,-79.151,52.583,1],
56324=>[93.943,-79.156,52.571,1],
56325=>[93.945,-79.160,52.559,1],
56326=>[93.947,-79.164,52.546,1],
56327=>[93.949,-79.169,52.532,1],
56328=>[93.951,-79.173,52.518,1],
56329=>[93.953,-79.177,52.503,1],
56330=>[93.955,-79.178,52.487,1],
56331=>[93.956,-79.171,52.472,1],
56332=>[93.957,-79.165,52.459,1],
56333=>[93.963,-79.162,52.446,1],
56334=>[93.970,-79.158,52.434,1],
56335=>[93.976,-79.155,52.423,1],
56336=>[93.983,-79.151,52.412,1],
56337=>[93.989,-79.147,52.400,1],
56338=>[93.995,-79.147,52.387,1],
56339=>[94.000,-79.156,52.372,1],
56340=>[94.005,-79.166,52.355,1],
56341=>[94.009,-79.164,52.335,1],
56342=>[94.012,-79.162,52.311,1],
56343=>[94.015,-79.159,52.287,1],
56344=>[94.014,-79.163,52.262,1],
56345=>[94.013,-79.166,52.237,1],
56346=>[94.012,-79.170,52.213,1],
56347=>[94.011,-79.173,52.188,1],
56348=>[94.011,-79.176,52.162,1],
56349=>[94.010,-79.180,52.138,1],
56350=>[94.009,-79.183,52.115,1],
56351=>[94.011,-79.190,52.092,1],
56352=>[94.015,-79.194,52.068,1],
56353=>[94.026,-79.193,52.045,1],
56354=>[94.037,-79.191,52.021,1],
56355=>[94.048,-79.190,51.992,1],
56356=>[94.059,-79.190,51.965,1],
56357=>[94.070,-79.188,51.936,1],
56358=>[94.072,-79.185,51.908,1],
56359=>[94.071,-79.182,51.879,1],
56360=>[94.069,-79.178,51.852,1],
56361=>[94.068,-79.175,51.826,1],
56362=>[94.068,-79.171,51.803,1],
56363=>[94.069,-79.166,51.786,1],
56364=>[94.082,-79.147,51.768,1],
56365=>[94.104,-79.122,51.749,1],
56366=>[94.126,-79.096,51.730,1],
56367=>[94.148,-79.071,51.713,1],
56368=>[94.170,-79.046,51.695,1],
56369=>[94.192,-79.021,51.676,1],
56370=>[94.214,-79.000,51.656,1],
56371=>[94.242,-79.011,51.633,1],
56372=>[94.260,-79.005,51.605,1],
56373=>[94.270,-78.984,51.571,1],
56374=>[94.281,-78.967,51.535,1],
56375=>[94.301,-78.977,51.495,1],
56376=>[94.322,-78.987,51.452,1],
56377=>[94.341,-78.996,51.410,1],
56378=>[94.361,-79.006,51.369,1],
56379=>[94.383,-79.006,51.328,1],
56380=>[94.406,-78.998,51.289,1],
56381=>[94.429,-78.990,51.251,1],
56382=>[94.452,-78.983,51.215,1],
56383=>[94.479,-78.990,51.178,1],
56384=>[94.506,-78.999,51.140,1],
56385=>[94.530,-78.988,51.102,1],
56386=>[94.541,-78.984,51.064,1],
56387=>[94.553,-78.981,51.026,1],
56388=>[94.564,-78.977,50.988,1],
56389=>[94.575,-78.973,50.950,1],
56390=>[94.586,-78.970,50.912,1],
56391=>[94.598,-78.966,50.873,1],
56392=>[94.609,-78.962,50.835,1],
56393=>[94.620,-78.959,50.798,1],
56394=>[94.631,-78.955,50.760,1],
56395=>[94.643,-78.951,50.723,1],
56396=>[94.654,-78.948,50.685,1],
56397=>[94.666,-78.944,50.647,1],
56398=>[94.677,-78.940,50.609,1],
56399=>[94.685,-78.946,50.571,1],
56400=>[94.694,-78.953,50.533,1],
56401=>[94.702,-78.961,50.495,1],
56402=>[94.710,-78.968,50.457,1],
56403=>[94.718,-78.976,50.419,1],
56404=>[94.727,-78.984,50.381,1],
56405=>[94.735,-78.991,50.343,1],
56406=>[94.743,-78.998,50.305,1],
56407=>[94.752,-79.006,50.268,1],
56408=>[94.760,-79.013,50.230,1],
56409=>[94.768,-79.021,50.192,1],
56410=>[94.776,-79.028,50.154,1],
56411=>[94.785,-79.036,50.117,1],
56425=>[94.901,-79.140,49.590,1],
56426=>[94.909,-79.148,49.553,1],
56427=>[94.917,-79.156,49.514,1],
56428=>[94.925,-79.162,49.477,1],
56429=>[94.934,-79.170,49.440,1],
56430=>[94.942,-79.178,49.403,1],
56431=>[94.951,-79.185,49.366,1],
56432=>[94.959,-79.193,49.329,1],
56433=>[94.967,-79.200,49.293,1],
56434=>[94.975,-79.208,49.256,1],
56435=>[94.983,-79.215,49.221,1],
56436=>[94.992,-79.222,49.185,1],
56437=>[95.001,-79.231,49.149,1],
56438=>[95.013,-79.250,49.114,1],
56439=>[95.025,-79.268,49.078,1],
56440=>[95.038,-79.286,49.043,1],
56441=>[95.050,-79.304,49.008,1],
56442=>[95.062,-79.322,48.973,1],
56443=>[95.074,-79.341,48.938,1],
56444=>[95.087,-79.359,48.903,1],
56445=>[95.119,-79.382,48.868,1],
56446=>[95.120,-79.374,48.832,1],
56447=>[95.126,-79.370,48.795,1],
56448=>[95.137,-79.372,48.758,1],
56449=>[95.162,-79.376,48.720,1],
56450=>[95.187,-79.382,48.682,1],
56451=>[95.211,-79.385,48.644,1],
56452=>[95.235,-79.389,48.605,1],
56453=>[95.259,-79.393,48.567,1],
56454=>[95.282,-79.397,48.530,1],
56455=>[95.306,-79.401,48.492,1],
56456=>[95.330,-79.405,48.453,1],
56457=>[95.364,-79.410,48.415,1],
56458=>[95.401,-79.415,48.376,1],
56459=>[95.438,-79.421,48.339,1],
56460=>[95.475,-79.426,48.302,1],
56461=>[95.512,-79.432,48.264,1],
56462=>[95.532,-79.428,48.228,1],
56463=>[95.549,-79.423,48.192,1],
56464=>[95.566,-79.419,48.155,1],
56465=>[95.583,-79.414,48.119,1],
56466=>[95.593,-79.407,48.083,1],
56467=>[95.603,-79.398,48.047,1],
56468=>[95.612,-79.390,48.015,1],
56469=>[95.621,-79.382,47.983,1],
56470=>[95.631,-79.373,47.951,1],
56471=>[95.640,-79.365,47.921,1],
56472=>[95.650,-79.357,47.891,1],
56473=>[95.659,-79.349,47.863,1],
56474=>[95.669,-79.341,47.835,1],
56475=>[95.678,-79.336,47.804,1],
56476=>[95.687,-79.346,47.772,1],
56477=>[95.696,-79.357,47.739,1],
56478=>[95.705,-79.367,47.704,1],
56479=>[95.730,-79.379,47.668,1],
56480=>[95.756,-79.391,47.631,1],
56481=>[95.783,-79.404,47.592,1],
56482=>[95.810,-79.417,47.554,1],
56483=>[95.837,-79.429,47.516,1],
56484=>[95.877,-79.434,47.478,1],
56485=>[95.906,-79.441,47.440,1],
56486=>[95.925,-79.452,47.403,1],
56487=>[95.949,-79.457,47.367,1],
56488=>[95.974,-79.460,47.331,1],
56489=>[95.999,-79.462,47.296,1],
56490=>[96.024,-79.464,47.262,1],
56491=>[96.049,-79.466,47.230,1],
56492=>[96.074,-79.469,47.197,1],
56493=>[96.099,-79.472,47.164,1],
56494=>[96.124,-79.474,47.131,1],
56495=>[96.150,-79.476,47.099,1],
56502=>[96.318,-79.501,46.877,1],
56503=>[96.342,-79.505,46.848,1],
56504=>[96.366,-79.509,46.818,1],
56505=>[96.389,-79.513,46.788,1],
56506=>[96.413,-79.516,46.758,1],
56507=>[96.437,-79.520,46.727,1],
56508=>[96.461,-79.524,46.696,1],
56509=>[96.485,-79.528,46.665,1],
56510=>[96.509,-79.532,46.637,1],
56511=>[96.533,-79.535,46.610,1],
56512=>[96.556,-79.539,46.583,1],
56513=>[96.581,-79.543,46.557,1],
56514=>[96.604,-79.547,46.531,1],
56515=>[96.628,-79.551,46.506,1],
56516=>[96.652,-79.554,46.480,1],
56517=>[96.676,-79.558,46.456,1],
56518=>[96.700,-79.562,46.432,1],
56519=>[96.724,-79.567,46.408,1],
56520=>[96.747,-79.570,46.384,1],
56521=>[96.771,-79.574,46.360,1],
56522=>[96.795,-79.578,46.335,1],
56523=>[96.819,-79.582,46.310,1],
56524=>[96.843,-79.585,46.286,1],
56525=>[96.867,-79.589,46.263,1],
56526=>[96.891,-79.593,46.242,1],
56527=>[96.902,-79.605,46.221,1],
56528=>[96.913,-79.617,46.201,1],
56529=>[96.924,-79.630,46.182,1],
56530=>[96.954,-79.635,46.161,1],
56531=>[97.003,-79.631,46.140,1],
56532=>[97.038,-79.627,46.117,1],
56533=>[97.060,-79.623,46.097,1],
56534=>[97.082,-79.620,46.077,1],
56535=>[97.103,-79.616,46.056,1],
56536=>[97.125,-79.612,46.029,1],
56537=>[97.147,-79.608,46.004,1],
56538=>[97.158,-79.616,45.977,1],
56539=>[97.149,-79.639,45.947,1],
56540=>[97.124,-79.676,45.916,1],
56541=>[97.132,-79.684,45.888,1],
56542=>[97.139,-79.692,45.862,1],
56543=>[97.146,-79.699,45.837,1],
56544=>[97.153,-79.707,45.813,1],
56545=>[97.160,-79.714,45.790,1],
56546=>[97.167,-79.722,45.769,1],
56547=>[97.174,-79.730,45.747,1],
56548=>[97.181,-79.737,45.726,1],
56549=>[97.188,-79.745,45.705,1],
56550=>[97.195,-79.752,45.684,1],
56551=>[97.203,-79.760,45.662,1],
56552=>[97.210,-79.768,45.642,1],
56553=>[97.217,-79.776,45.623,1],
56959=>[93.176,-79.362,53.379,1],
56960=>[93.190,-79.350,53.365,1],
56961=>[93.204,-79.337,53.351,1],
56962=>[93.218,-79.325,53.337,1],
56963=>[93.232,-79.313,53.323,1],
56964=>[93.247,-79.300,53.310,1],
56965=>[93.260,-79.288,53.296,1],
56966=>[93.274,-79.276,53.282,1],
56967=>[93.288,-79.264,53.268,1],
56968=>[93.304,-79.257,53.253,1],
56969=>[93.314,-79.255,53.239,1],
56970=>[93.324,-79.253,53.224,1],
56971=>[93.333,-79.250,53.212,1],
56972=>[93.345,-79.241,53.198,1],
56973=>[93.356,-79.230,53.185,1],
56974=>[93.367,-79.220,53.173,1],
56975=>[93.379,-79.209,53.160,1],
56976=>[93.393,-79.203,53.148,1],
56977=>[93.407,-79.198,53.136,1],
56978=>[93.421,-79.193,53.125,1],
56979=>[93.436,-79.188,53.114,1],
56980=>[93.450,-79.183,53.104,1],
56981=>[93.465,-79.178,53.094,1],
56982=>[93.479,-79.174,53.086,1],
56983=>[93.494,-79.169,53.077,1],
56984=>[93.508,-79.164,53.069,1],
56985=>[93.522,-79.159,53.062,1],
56986=>[93.537,-79.154,53.053,1],
56987=>[93.551,-79.149,53.044,1],
56988=>[93.566,-79.144,53.033,1],
56989=>[93.578,-79.142,53.022,1],
56990=>[93.590,-79.140,53.013,1],
56991=>[93.603,-79.139,53.004,1],
56992=>[93.615,-79.137,52.998,1],
56993=>[93.627,-79.136,52.991,1],
56994=>[93.639,-79.134,52.985,1],
56995=>[93.651,-79.133,52.980,1],
56996=>[93.663,-79.131,52.974,1],
56997=>[93.676,-79.131,52.968,1],
56998=>[93.687,-79.134,52.962,1],
56999=>[93.702,-79.134,52.954,1],
57000=>[93.716,-79.133,52.945,1],
57001=>[93.731,-79.133,52.934,1],
57002=>[93.746,-79.133,52.924,1],
57003=>[93.761,-79.132,52.913,1],
57004=>[93.775,-79.132,52.902,1],
57005=>[93.790,-79.132,52.890,1],
57006=>[93.804,-79.132,52.879,1],
57007=>[93.819,-79.132,52.866,1],
57008=>[93.834,-79.131,52.854,1],
57009=>[93.848,-79.131,52.842,1],
57010=>[93.846,-79.128,52.830,1],
57011=>[93.837,-79.125,52.816,1],
57012=>[93.838,-79.123,52.800,1],
57013=>[93.843,-79.122,52.783,1],
57014=>[93.847,-79.121,52.766,1],
57015=>[93.852,-79.119,52.747,1],
57016=>[93.868,-79.120,52.728,1],
57017=>[93.889,-79.121,52.709,1],
57018=>[93.900,-79.123,52.692,1],
57019=>[93.908,-79.126,52.676,1],
57020=>[93.915,-79.128,52.662,1],
57021=>[93.922,-79.131,52.650,1],
57022=>[93.928,-79.134,52.639,1],
57023=>[93.930,-79.138,52.627,1],
57024=>[93.932,-79.143,52.615,1],
57025=>[93.934,-79.147,52.603,1],
57026=>[93.936,-79.151,52.591,1],
57027=>[93.938,-79.156,52.578,1],
57028=>[93.940,-79.159,52.564,1],
57029=>[93.942,-79.164,52.549,1],
57030=>[93.944,-79.169,52.534,1],
57031=>[93.946,-79.172,52.519,1],
57032=>[93.948,-79.176,52.504,1],
57033=>[93.953,-79.172,52.489,1],
57034=>[93.959,-79.168,52.475,1],
57035=>[93.965,-79.165,52.460,1],
57036=>[93.972,-79.161,52.449,1],
57037=>[93.978,-79.157,52.438,1],
57038=>[93.984,-79.154,52.426,1],
57039=>[93.991,-79.150,52.414,1],
57040=>[93.997,-79.149,52.400,1],
57041=>[94.002,-79.159,52.382,1],
57042=>[94.006,-79.159,52.362,1],
57043=>[94.010,-79.157,52.338,1],
57044=>[94.009,-79.160,52.314,1],
57045=>[94.008,-79.163,52.288,1],
57046=>[94.007,-79.166,52.262,1],
57047=>[94.006,-79.170,52.238,1],
57048=>[94.005,-79.173,52.213,1],
57049=>[94.004,-79.177,52.186,1],
57050=>[94.003,-79.180,52.161,1],
57051=>[94.003,-79.182,52.136,1],
57052=>[94.003,-79.184,52.112,1],
57053=>[94.011,-79.183,52.086,1],
57054=>[94.022,-79.181,52.061,1],
57055=>[94.033,-79.181,52.034,1],
57056=>[94.044,-79.180,52.005,1],
57057=>[94.055,-79.178,51.976,1],
57058=>[94.066,-79.178,51.947,1],
57059=>[94.073,-79.175,51.918,1],
57060=>[94.072,-79.172,51.892,1],
57061=>[94.070,-79.169,51.868,1],
57062=>[94.069,-79.165,51.847,1],
57063=>[94.068,-79.161,51.827,1],
57064=>[94.069,-79.155,51.810,1],
57065=>[94.091,-79.131,51.792,1],
57066=>[94.113,-79.105,51.770,1],
57067=>[94.135,-79.080,51.752,1],
57068=>[94.156,-79.054,51.733,1],
57069=>[94.179,-79.029,51.714,1],
57070=>[94.200,-79.003,51.694,1],
57071=>[94.222,-78.978,51.673,1],
57072=>[94.250,-78.987,51.649,1],
57073=>[94.263,-78.972,51.621,1],
57074=>[94.274,-78.953,51.586,1],
57075=>[94.294,-78.963,51.548,1],
57076=>[94.314,-78.973,51.507,1],
57077=>[94.334,-78.982,51.465,1],
57078=>[94.354,-78.992,51.423,1],
57079=>[94.373,-79.002,51.381,1],
57080=>[94.394,-79.012,51.341,1],
57081=>[94.415,-79.015,51.303,1],
57082=>[94.437,-79.006,51.266,1],
57083=>[94.461,-78.999,51.231,1],
57084=>[94.484,-78.991,51.195,1],
57085=>[94.506,-78.984,51.158,1],
57086=>[94.530,-78.977,51.119,1],
57087=>[94.547,-78.975,51.081,1],
57088=>[94.558,-78.971,51.042,1],
57089=>[94.569,-78.968,51.003,1],
57090=>[94.580,-78.964,50.965,1],
57091=>[94.592,-78.961,50.926,1],
57092=>[94.603,-78.957,50.887,1],
57093=>[94.614,-78.953,50.849,1],
57094=>[94.626,-78.949,50.811,1],
57095=>[94.637,-78.946,50.773,1],
57096=>[94.648,-78.942,50.736,1],
57097=>[94.660,-78.939,50.697,1],
57098=>[94.671,-78.935,50.659,1],
57099=>[94.682,-78.931,50.621,1],
57100=>[94.693,-78.927,50.583,1],
57101=>[94.702,-78.933,50.545,1],
57102=>[94.710,-78.940,50.507,1],
57103=>[94.718,-78.948,50.469,1],
57104=>[94.727,-78.955,50.431,1],
57105=>[94.735,-78.963,50.393,1],
57106=>[94.744,-78.971,50.355,1],
57107=>[94.752,-78.978,50.317,1],
57108=>[94.760,-78.985,50.280,1],
57109=>[94.768,-78.993,50.242,1],
57110=>[94.776,-79.000,50.204,1],
57111=>[94.785,-79.008,50.166,1],
57112=>[94.793,-79.015,50.128,1],
57113=>[94.802,-79.023,50.090,1],
57114=>[94.810,-79.031,50.053,1],
57115=>[94.818,-79.038,50.015,1],
57116=>[94.826,-79.045,49.978,1],
57117=>[94.835,-79.053,49.939,1],
57123=>[94.884,-79.097,49.714,1],
57124=>[94.893,-79.105,49.676,1],
57125=>[94.901,-79.112,49.638,1],
57126=>[94.909,-79.120,49.601,1],
57127=>[94.917,-79.128,49.564,1],
57128=>[94.926,-79.135,49.526,1],
57129=>[94.934,-79.143,49.489,1],
57130=>[94.942,-79.150,49.451,1],
57131=>[94.951,-79.157,49.413,1],
57132=>[94.959,-79.165,49.376,1],
57133=>[94.967,-79.172,49.340,1],
57134=>[94.975,-79.180,49.304,1],
57135=>[94.984,-79.187,49.267,1],
57136=>[94.996,-79.205,49.232,1],
57137=>[95.008,-79.223,49.196,1],
57138=>[95.020,-79.241,49.160,1],
57139=>[95.033,-79.259,49.125,1],
57140=>[95.045,-79.278,49.090,1],
57141=>[95.057,-79.296,49.056,1],
57142=>[95.069,-79.315,49.021,1],
57143=>[95.082,-79.333,48.986,1],
57144=>[95.090,-79.347,48.952,1],
57145=>[95.104,-79.357,48.917,1],
57146=>[95.116,-79.358,48.882,1],
57147=>[95.127,-79.360,48.846,1],
57148=>[95.139,-79.361,48.809,1],
57149=>[95.151,-79.363,48.772,1],
57150=>[95.175,-79.366,48.734,1],
57151=>[95.199,-79.372,48.695,1],
57152=>[95.224,-79.376,48.657,1],
57153=>[95.249,-79.381,48.619,1],
57154=>[95.274,-79.386,48.581,1],
57155=>[95.299,-79.391,48.543,1],
57156=>[95.323,-79.395,48.505,1],
57157=>[95.348,-79.400,48.467,1],
57158=>[95.373,-79.405,48.429,1],
57159=>[95.397,-79.409,48.392,1],
57160=>[95.427,-79.413,48.356,1],
57161=>[95.465,-79.419,48.320,1],
57162=>[95.503,-79.423,48.281,1],
57163=>[95.542,-79.428,48.244,1],
57164=>[95.570,-79.425,48.207,1],
57165=>[95.580,-79.419,48.169,1],
57166=>[95.590,-79.413,48.131,1],
57167=>[95.600,-79.408,48.094,1],
57168=>[95.610,-79.401,48.058,1],
57169=>[95.620,-79.393,48.027,1],
57170=>[95.629,-79.385,47.994,1],
57171=>[95.638,-79.376,47.961,1],
57172=>[95.648,-79.368,47.930,1],
57173=>[95.657,-79.360,47.898,1],
57174=>[95.667,-79.352,47.867,1],
57175=>[95.676,-79.344,47.837,1],
57176=>[95.686,-79.335,47.804,1],
57177=>[95.695,-79.342,47.770,1],
57178=>[95.704,-79.353,47.735,1],
57179=>[95.713,-79.363,47.701,1],
57180=>[95.722,-79.373,47.666,1],
57181=>[95.732,-79.383,47.630,1],
57182=>[95.741,-79.394,47.594,1],
57183=>[95.768,-79.407,47.557,1],
57184=>[95.818,-79.404,47.519,1],
57185=>[95.872,-79.401,47.481,1],
57186=>[95.925,-79.397,47.442,1],
57187=>[95.945,-79.408,47.403,1],
57188=>[95.965,-79.419,47.366,1],
57189=>[95.984,-79.430,47.330,1],
57190=>[96.004,-79.441,47.296,1],
57191=>[96.023,-79.452,47.262,1],
57192=>[96.043,-79.463,47.229,1],
57193=>[96.062,-79.474,47.196,1],
57194=>[96.084,-79.482,47.163,1],
57195=>[96.108,-79.485,47.130,1],
57196=>[96.133,-79.488,47.098,1],
57197=>[96.159,-79.490,47.066,1],
57198=>[96.184,-79.492,47.034,1],
57199=>[96.209,-79.494,47.002,1],
57200=>[96.234,-79.497,46.970,1],
57201=>[96.259,-79.499,46.939,1],
57202=>[96.285,-79.501,46.908,1],
57203=>[96.310,-79.504,46.875,1],
57204=>[96.334,-79.507,46.845,1],
57205=>[96.360,-79.509,46.816,1],
57206=>[96.385,-79.511,46.785,1],
57207=>[96.410,-79.513,46.755,1],
57208=>[96.435,-79.516,46.725,1],
57209=>[96.460,-79.518,46.694,1],
57210=>[96.485,-79.521,46.663,1],
57211=>[96.511,-79.523,46.635,1],
57212=>[96.536,-79.526,46.608,1],
57213=>[96.560,-79.528,46.581,1],
57214=>[96.586,-79.530,46.556,1],
57215=>[96.611,-79.532,46.530,1],
57216=>[96.636,-79.535,46.504,1],
57217=>[96.661,-79.538,46.479,1],
57218=>[96.686,-79.540,46.455,1],
57219=>[96.712,-79.542,46.432,1],
57220=>[96.737,-79.545,46.409,1],
57221=>[96.762,-79.547,46.385,1],
57222=>[96.787,-79.549,46.361,1],
57223=>[96.812,-79.551,46.337,1],
57224=>[96.837,-79.554,46.311,1],
57225=>[96.862,-79.557,46.288,1],
57226=>[96.884,-79.559,46.267,1],
57227=>[96.895,-79.571,46.246,1],
57228=>[96.906,-79.584,46.225,1],
57229=>[96.917,-79.596,46.204,1],
57230=>[96.928,-79.609,46.182,1],
57231=>[96.969,-79.608,46.160,1],
57232=>[97.008,-79.604,46.138,1],
57233=>[97.030,-79.601,46.115,1],
57234=>[97.051,-79.598,46.095,1],
57235=>[97.073,-79.594,46.075,1],
57236=>[97.095,-79.590,46.053,1],
57237=>[97.119,-79.585,46.027,1],
57238=>[97.147,-79.579,46.003,1],
57239=>[97.174,-79.568,45.977,1],
57240=>[97.202,-79.557,45.948,1],
57241=>[97.181,-79.589,45.917,1],
57242=>[97.155,-79.628,45.889,1],
57243=>[97.139,-79.657,45.863,1],
57244=>[97.146,-79.664,45.838,1],
57245=>[97.153,-79.672,45.813,1],
57246=>[97.160,-79.679,45.790,1],
57247=>[97.167,-79.688,45.769,1],
57248=>[97.174,-79.695,45.747,1],
57249=>[97.181,-79.703,45.725,1],
57250=>[97.188,-79.711,45.704,1],
57251=>[97.195,-79.718,45.682,1],
57252=>[97.203,-79.726,45.661,1],
57253=>[97.210,-79.733,45.641,1],
57254=>[97.217,-79.741,45.623,1],
57255=>[97.224,-79.748,45.605,1],
57660=>[93.175,-79.351,53.405,1],
57661=>[93.189,-79.339,53.392,1],
57662=>[93.203,-79.327,53.377,1],
57663=>[93.217,-79.315,53.363,1],
57664=>[93.231,-79.303,53.349,1],
57665=>[93.246,-79.291,53.336,1],
57666=>[93.260,-79.278,53.322,1],
57667=>[93.273,-79.266,53.307,1],
57668=>[93.288,-79.253,53.293,1],
57669=>[93.304,-79.247,53.278,1],
57670=>[93.314,-79.244,53.263,1],
57671=>[93.324,-79.241,53.249,1],
57672=>[93.334,-79.239,53.236,1],
57673=>[93.343,-79.237,53.223,1],
57674=>[93.355,-79.226,53.209,1],
57675=>[93.366,-79.216,53.196,1],
57676=>[93.377,-79.206,53.182,1],
57677=>[93.389,-79.196,53.169,1],
57678=>[93.396,-79.194,53.156,1],
57679=>[93.415,-79.181,53.144,1],
57680=>[93.430,-79.175,53.134,1],
57681=>[93.444,-79.171,53.123,1],
57682=>[93.459,-79.166,53.111,1],
57683=>[93.473,-79.161,53.102,1],
57684=>[93.488,-79.156,53.093,1],
57685=>[93.502,-79.151,53.086,1],
57686=>[93.516,-79.147,53.081,1],
57687=>[93.531,-79.141,53.075,1],
57688=>[93.546,-79.137,53.068,1],
57689=>[93.560,-79.131,53.058,1],
57690=>[93.573,-79.128,53.047,1],
57691=>[93.585,-79.127,53.038,1],
57692=>[93.598,-79.125,53.030,1],
57693=>[93.610,-79.124,53.023,1],
57694=>[93.622,-79.122,53.016,1],
57695=>[93.634,-79.121,53.010,1],
57696=>[93.646,-79.119,53.007,1],
57697=>[93.658,-79.118,53.001,1],
57698=>[93.666,-79.123,52.995,1],
57699=>[93.679,-79.125,52.988,1],
57700=>[93.695,-79.125,52.980,1],
57701=>[93.710,-79.125,52.971,1],
57702=>[93.725,-79.125,52.960,1],
57703=>[93.740,-79.124,52.950,1],
57704=>[93.755,-79.124,52.939,1],
57705=>[93.769,-79.123,52.928,1],
57706=>[93.784,-79.123,52.916,1],
57707=>[93.798,-79.123,52.905,1],
57708=>[93.813,-79.123,52.892,1],
57709=>[93.828,-79.122,52.880,1],
57710=>[93.842,-79.122,52.869,1],
57711=>[93.840,-79.119,52.856,1],
57712=>[93.839,-79.117,52.843,1],
57713=>[93.844,-79.116,52.827,1],
57714=>[93.848,-79.115,52.810,1],
57715=>[93.853,-79.114,52.792,1],
57716=>[93.857,-79.112,52.774,1],
57717=>[93.862,-79.112,52.755,1],
57718=>[93.881,-79.112,52.736,1],
57719=>[93.890,-79.115,52.718,1],
57720=>[93.897,-79.118,52.701,1],
57721=>[93.905,-79.120,52.688,1],
57722=>[93.912,-79.122,52.675,1],
57723=>[93.919,-79.125,52.665,1],
57724=>[93.921,-79.130,52.652,1],
57725=>[93.923,-79.134,52.639,1],
57726=>[93.925,-79.138,52.626,1],
57727=>[93.927,-79.143,52.614,1],
57728=>[93.929,-79.147,52.601,1],
57729=>[93.931,-79.151,52.587,1],
57730=>[93.933,-79.156,52.574,1],
57731=>[93.935,-79.158,52.561,1],
57732=>[93.939,-79.160,52.547,1],
57733=>[93.942,-79.163,52.532,1],
57734=>[93.946,-79.169,52.518,1],
57735=>[93.953,-79.168,52.503,1],
57736=>[93.960,-79.167,52.488,1],
57737=>[93.967,-79.165,52.476,1],
57738=>[93.973,-79.164,52.463,1],
57739=>[93.980,-79.160,52.451,1],
57740=>[93.986,-79.157,52.441,1],
57741=>[93.992,-79.153,52.427,1],
57742=>[93.999,-79.151,52.409,1],
57743=>[94.003,-79.156,52.388,1],
57744=>[94.004,-79.156,52.365,1],
57745=>[94.003,-79.160,52.341,1],
57746=>[94.002,-79.163,52.314,1],
57747=>[94.001,-79.166,52.288,1],
57748=>[94.001,-79.168,52.263,1],
57749=>[94.001,-79.169,52.237,1],
57750=>[94.002,-79.170,52.209,1],
57751=>[94.002,-79.172,52.183,1],
57752=>[94.002,-79.173,52.156,1],
57753=>[94.002,-79.175,52.129,1],
57754=>[94.010,-79.173,52.103,1],
57755=>[94.019,-79.171,52.076,1],
57756=>[94.030,-79.169,52.048,1],
57757=>[94.041,-79.169,52.017,1],
57758=>[94.052,-79.168,51.989,1],
57759=>[94.063,-79.166,51.960,1],
57760=>[94.074,-79.165,51.932,1],
57761=>[94.073,-79.162,51.908,1],
57762=>[94.072,-79.158,51.888,1],
57763=>[94.070,-79.155,51.869,1],
57764=>[94.069,-79.151,51.851,1],
57765=>[94.082,-79.131,51.834,1],
57766=>[94.101,-79.106,51.814,1],
57767=>[94.122,-79.084,51.792,1],
57768=>[94.143,-79.062,51.772,1],
57769=>[94.165,-79.037,51.753,1],
57770=>[94.187,-79.012,51.734,1],
57771=>[94.209,-78.987,51.713,1],
57772=>[94.231,-78.961,51.691,1],
57773=>[94.257,-78.961,51.665,1],
57774=>[94.267,-78.940,51.636,1],
57775=>[94.286,-78.949,51.599,1],
57776=>[94.306,-78.959,51.560,1],
57777=>[94.326,-78.968,51.519,1],
57778=>[94.346,-78.978,51.476,1],
57779=>[94.366,-78.988,51.435,1],
57780=>[94.386,-78.998,51.394,1],
57781=>[94.406,-79.007,51.354,1],
57782=>[94.426,-79.017,51.317,1],
57783=>[94.447,-79.023,51.281,1],
57784=>[94.469,-79.015,51.247,1],
57785=>[94.492,-79.007,51.212,1],
57786=>[94.514,-78.996,51.176,1],
57787=>[94.535,-78.970,51.139,1],
57788=>[94.553,-78.971,51.100,1],
57789=>[94.563,-78.964,51.060,1],
57790=>[94.574,-78.959,51.020,1],
57791=>[94.586,-78.955,50.980,1],
57792=>[94.597,-78.952,50.941,1],
57793=>[94.609,-78.948,50.902,1],
57794=>[94.620,-78.944,50.864,1],
57795=>[94.631,-78.940,50.825,1],
57796=>[94.642,-78.937,50.787,1],
57797=>[94.653,-78.933,50.749,1],
57798=>[94.665,-78.930,50.710,1],
57799=>[94.676,-78.926,50.672,1],
57800=>[94.687,-78.922,50.634,1],
57801=>[94.699,-78.918,50.596,1],
57802=>[94.710,-78.915,50.558,1],
57803=>[94.718,-78.921,50.521,1],
57804=>[94.727,-78.927,50.482,1],
57805=>[94.735,-78.935,50.443,1],
57806=>[94.744,-78.943,50.405,1],
57807=>[94.752,-78.950,50.367,1],
57808=>[94.760,-78.958,50.329,1],
57809=>[94.768,-78.965,50.292,1],
57810=>[94.777,-78.973,50.253,1],
57811=>[94.785,-78.980,50.215,1],
57812=>[94.793,-78.987,50.178,1],
57813=>[94.802,-78.995,50.139,1],
57814=>[94.810,-79.002,50.101,1],
57815=>[94.818,-79.010,50.065,1],
57816=>[94.826,-79.018,50.027,1],
57817=>[94.835,-79.025,49.990,1],
57818=>[94.843,-79.032,49.953,1],
57819=>[94.851,-79.040,49.915,1],
57820=>[94.859,-79.047,49.877,1],
57821=>[94.868,-79.055,49.840,1],
57822=>[94.876,-79.062,49.802,1],
57823=>[94.884,-79.070,49.765,1],
57824=>[94.893,-79.078,49.727,1],
57825=>[94.901,-79.085,49.689,1],
57826=>[94.909,-79.092,49.650,1],
57827=>[94.917,-79.100,49.612,1],
57828=>[94.926,-79.107,49.575,1],
57829=>[94.934,-79.115,49.538,1],
57830=>[94.943,-79.122,49.501,1],
57831=>[94.951,-79.130,49.463,1],
57832=>[94.959,-79.137,49.424,1],
57833=>[94.967,-79.144,49.387,1],
57834=>[94.979,-79.160,49.351,1],
57835=>[94.991,-79.178,49.315,1],
57836=>[95.003,-79.197,49.279,1],
57837=>[95.016,-79.215,49.243,1],
57838=>[95.028,-79.233,49.208,1],
57839=>[95.040,-79.251,49.173,1],
57840=>[95.052,-79.270,49.138,1],
57841=>[95.062,-79.286,49.104,1],
57842=>[95.069,-79.299,49.069,1],
57843=>[95.075,-79.311,49.035,1],
57844=>[95.082,-79.324,49.001,1],
57845=>[95.096,-79.337,48.967,1],
57846=>[95.114,-79.345,48.933,1],
57847=>[95.129,-79.348,48.897,1],
57848=>[95.141,-79.350,48.861,1],
57849=>[95.153,-79.351,48.823,1],
57850=>[95.164,-79.353,48.785,1],
57851=>[95.187,-79.357,48.748,1],
57852=>[95.212,-79.362,48.710,1],
57853=>[95.237,-79.366,48.672,1],
57854=>[95.261,-79.371,48.634,1],
57855=>[95.286,-79.376,48.597,1],
57856=>[95.311,-79.381,48.558,1],
57857=>[95.336,-79.385,48.520,1],
57858=>[95.361,-79.390,48.483,1],
57859=>[95.386,-79.395,48.445,1],
57860=>[95.410,-79.400,48.409,1],
57861=>[95.430,-79.400,48.373,1],
57862=>[95.461,-79.408,48.337,1],
57863=>[95.500,-79.413,48.298,1],
57864=>[95.540,-79.416,48.259,1],
57865=>[95.569,-79.412,48.221,1],
57866=>[95.583,-79.404,48.182,1],
57867=>[95.593,-79.399,48.143,1],
57868=>[95.603,-79.394,48.105,1],
57869=>[95.613,-79.388,48.068,1],
57870=>[95.623,-79.382,48.035,1],
57871=>[95.633,-79.377,48.002,1],
57872=>[95.644,-79.372,47.968,1],
57873=>[95.654,-79.366,47.935,1],
57874=>[95.664,-79.360,47.902,1],
57875=>[95.674,-79.355,47.869,1],
57876=>[95.684,-79.347,47.836,1],
57877=>[95.693,-79.338,47.802,1],
57878=>[95.702,-79.338,47.767,1],
57879=>[95.712,-79.349,47.731,1],
57880=>[95.721,-79.359,47.697,1],
57881=>[95.731,-79.369,47.663,1],
57882=>[95.741,-79.379,47.628,1],
57883=>[95.751,-79.389,47.593,1],
57884=>[95.774,-79.395,47.557,1],
57885=>[95.827,-79.391,47.520,1],
57886=>[95.879,-79.386,47.482,1],
57887=>[95.932,-79.382,47.442,1],
57888=>[95.961,-79.378,47.403,1],
57889=>[95.981,-79.386,47.365,1],
57890=>[96.002,-79.394,47.329,1],
57891=>[96.022,-79.402,47.295,1],
57892=>[96.042,-79.410,47.261,1],
57893=>[96.062,-79.419,47.228,1],
57894=>[96.082,-79.431,47.194,1],
57895=>[96.101,-79.441,47.161,1],
57896=>[96.121,-79.453,47.128,1],
57897=>[96.141,-79.463,47.096,1],
57898=>[96.160,-79.475,47.063,1],
57899=>[96.180,-79.485,47.031,1],
57900=>[96.199,-79.497,47.000,1],
57901=>[96.219,-79.507,46.968,1],
57902=>[96.243,-79.510,46.937,1],
57903=>[96.268,-79.513,46.905,1],
57904=>[96.294,-79.515,46.873,1],
57905=>[96.319,-79.517,46.843,1],
57906=>[96.344,-79.520,46.813,1],
57907=>[96.369,-79.523,46.782,1],
57908=>[96.394,-79.525,46.752,1],
57909=>[96.419,-79.527,46.722,1],
57910=>[96.444,-79.529,46.691,1],
57911=>[96.469,-79.532,46.660,1],
57912=>[96.495,-79.534,46.632,1],
57913=>[96.520,-79.537,46.605,1],
57914=>[96.545,-79.539,46.578,1],
57915=>[96.570,-79.541,46.553,1],
57916=>[96.595,-79.544,46.528,1],
57917=>[96.620,-79.546,46.502,1],
57918=>[96.645,-79.548,46.477,1],
57919=>[96.670,-79.551,46.454,1],
57920=>[96.695,-79.554,46.432,1],
57921=>[96.721,-79.556,46.409,1],
57922=>[96.746,-79.558,46.386,1],
57923=>[96.771,-79.560,46.362,1],
57924=>[96.796,-79.563,46.338,1],
57925=>[96.821,-79.565,46.313,1],
57926=>[96.851,-79.563,46.291,1],
57927=>[96.877,-79.558,46.270,1],
57928=>[96.897,-79.554,46.249,1],
57929=>[96.910,-79.563,46.228,1],
57930=>[96.921,-79.576,46.206,1],
57931=>[96.936,-79.586,46.182,1],
57932=>[96.978,-79.582,46.159,1],
57933=>[97.000,-79.579,46.135,1],
57934=>[97.021,-79.575,46.113,1],
57935=>[97.045,-79.570,46.091,1],
57936=>[97.073,-79.564,46.069,1],
57937=>[97.100,-79.557,46.047,1],
57938=>[97.127,-79.551,46.023,1],
57939=>[97.155,-79.544,45.998,1],
57940=>[97.182,-79.532,45.972,1],
57941=>[97.199,-79.530,45.944,1],
57942=>[97.214,-79.536,45.915,1],
57943=>[97.213,-79.541,45.888,1],
57944=>[97.187,-79.578,45.862,1],
57945=>[97.161,-79.616,45.838,1],
57946=>[97.153,-79.638,45.813,1],
57947=>[97.160,-79.645,45.789,1],
57948=>[97.167,-79.653,45.766,1],
57949=>[97.174,-79.661,45.745,1],
57950=>[97.181,-79.668,45.724,1],
57951=>[97.188,-79.676,45.702,1],
57952=>[97.195,-79.683,45.681,1],
57953=>[97.203,-79.691,45.660,1],
57954=>[97.210,-79.698,45.640,1],
57955=>[97.217,-79.707,45.622,1],
57956=>[97.224,-79.714,45.604,1],
57957=>[97.231,-79.722,45.585,1],
58362=>[93.188,-79.328,53.417,1],
58363=>[93.202,-79.316,53.404,1],
58364=>[93.216,-79.304,53.389,1],
58365=>[93.230,-79.292,53.375,1],
58366=>[93.245,-79.280,53.361,1],
58367=>[93.259,-79.268,53.347,1],
58368=>[93.273,-79.256,53.332,1],
58369=>[93.287,-79.244,53.317,1],
58370=>[93.305,-79.235,53.302,1],
58371=>[93.314,-79.233,53.288,1],
58372=>[93.324,-79.231,53.273,1],
58373=>[93.334,-79.228,53.260,1],
58374=>[93.344,-79.225,53.247,1],
58375=>[93.353,-79.222,53.233,1],
58376=>[93.365,-79.212,53.219,1],
58377=>[93.376,-79.202,53.205,1],
58378=>[93.388,-79.191,53.191,1],
58379=>[93.398,-79.182,53.178,1],
58380=>[93.406,-79.178,53.165,1],
58381=>[93.417,-79.175,53.153,1],
58382=>[93.436,-79.162,53.142,1],
58383=>[93.453,-79.153,53.130,1],
58384=>[93.468,-79.149,53.120,1],
58385=>[93.482,-79.143,53.111,1],
58386=>[93.496,-79.139,53.104,1],
58387=>[93.511,-79.134,53.099,1],
58388=>[93.525,-79.129,53.095,1],
58389=>[93.540,-79.125,53.091,1],
58390=>[93.554,-79.119,53.083,1],
58391=>[93.569,-79.115,53.074,1],
58392=>[93.581,-79.113,53.065,1],
58393=>[93.593,-79.112,53.058,1],
58394=>[93.605,-79.110,53.051,1],
58395=>[93.617,-79.109,53.045,1],
58396=>[93.630,-79.107,53.039,1],
58397=>[93.642,-79.106,53.034,1],
58398=>[93.649,-79.110,53.029,1],
58399=>[93.657,-79.115,53.023,1],
58400=>[93.671,-79.117,53.016,1],
58401=>[93.688,-79.116,53.007,1],
58402=>[93.703,-79.116,52.997,1],
58403=>[93.718,-79.116,52.987,1],
58404=>[93.733,-79.115,52.976,1],
58405=>[93.748,-79.115,52.966,1],
58406=>[93.763,-79.115,52.955,1],
58407=>[93.777,-79.115,52.943,1],
58408=>[93.792,-79.114,52.931,1],
58409=>[93.807,-79.114,52.919,1],
58410=>[93.822,-79.113,52.906,1],
58411=>[93.837,-79.113,52.894,1],
58412=>[93.840,-79.112,52.882,1],
58413=>[93.845,-79.110,52.869,1],
58414=>[93.849,-79.109,52.855,1],
58415=>[93.854,-79.108,52.838,1],
58416=>[93.858,-79.107,52.819,1],
58417=>[93.863,-79.106,52.800,1],
58418=>[93.867,-79.105,52.781,1],
58419=>[93.872,-79.104,52.762,1],
58420=>[93.880,-79.106,52.743,1],
58421=>[93.887,-79.109,52.727,1],
58422=>[93.894,-79.112,52.713,1],
58423=>[93.902,-79.114,52.701,1],
58424=>[93.909,-79.117,52.689,1],
58425=>[93.912,-79.121,52.677,1],
58426=>[93.914,-79.125,52.663,1],
58427=>[93.915,-79.130,52.649,1],
58428=>[93.918,-79.133,52.637,1],
58429=>[93.921,-79.135,52.624,1],
58430=>[93.924,-79.137,52.611,1],
58431=>[93.928,-79.140,52.599,1],
58432=>[93.931,-79.142,52.586,1],
58433=>[93.934,-79.144,52.573,1],
58434=>[93.937,-79.147,52.559,1],
58435=>[93.941,-79.155,52.546,1],
58436=>[93.946,-79.160,52.531,1],
58437=>[93.953,-79.159,52.516,1],
58438=>[93.960,-79.158,52.504,1],
58439=>[93.966,-79.157,52.492,1],
58440=>[93.973,-79.156,52.479,1],
58441=>[93.980,-79.154,52.468,1],
58442=>[93.987,-79.153,52.453,1],
58443=>[93.994,-79.152,52.436,1],
58444=>[94.000,-79.151,52.414,1],
58445=>[94.000,-79.153,52.391,1],
58446=>[94.000,-79.154,52.366,1],
58447=>[94.000,-79.156,52.339,1],
58448=>[94.000,-79.157,52.312,1],
58449=>[94.000,-79.159,52.285,1],
58450=>[94.000,-79.159,52.258,1],
58451=>[94.000,-79.161,52.228,1],
58452=>[94.001,-79.162,52.201,1],
58453=>[94.001,-79.164,52.172,1],
58454=>[94.002,-79.165,52.143,1],
58455=>[94.010,-79.163,52.116,1],
58456=>[94.019,-79.161,52.089,1],
58457=>[94.028,-79.159,52.060,1],
58458=>[94.037,-79.158,52.030,1],
58459=>[94.048,-79.156,52.003,1],
58460=>[94.059,-79.156,51.976,1],
58461=>[94.070,-79.155,51.949,1],
58462=>[94.074,-79.152,51.928,1],
58463=>[94.073,-79.148,51.910,1],
58464=>[94.071,-79.144,51.893,1],
58465=>[94.076,-79.134,51.875,1],
58466=>[94.095,-79.108,51.856,1],
58467=>[94.113,-79.081,51.836,1],
58468=>[94.133,-79.057,51.813,1],
58469=>[94.154,-79.035,51.792,1],
58470=>[94.176,-79.013,51.773,1],
58471=>[94.197,-78.991,51.754,1],
58472=>[94.218,-78.969,51.732,1],
58473=>[94.240,-78.944,51.708,1],
58474=>[94.260,-78.929,51.681,1],
58475=>[94.278,-78.935,51.649,1],
58476=>[94.298,-78.945,51.611,1],
58477=>[94.319,-78.954,51.571,1],
58478=>[94.338,-78.964,51.531,1],
58479=>[94.358,-78.974,51.488,1],
58480=>[94.378,-78.984,51.447,1],
58481=>[94.398,-78.993,51.406,1],
58482=>[94.418,-79.003,51.367,1],
58483=>[94.438,-79.013,51.331,1],
58484=>[94.458,-79.023,51.297,1],
58485=>[94.478,-79.030,51.264,1],
58486=>[94.495,-78.984,51.229,1],
58487=>[94.516,-78.968,51.194,1],
58488=>[94.538,-78.959,51.157,1],
58489=>[94.556,-78.961,51.118,1],
58490=>[94.570,-78.962,51.078,1],
58491=>[94.581,-78.955,51.037,1],
58492=>[94.592,-78.949,50.998,1],
58493=>[94.603,-78.943,50.958,1],
58494=>[94.614,-78.939,50.918,1],
58495=>[94.625,-78.935,50.879,1],
58496=>[94.636,-78.931,50.840,1],
58497=>[94.647,-78.927,50.801,1],
58498=>[94.659,-78.924,50.763,1],
58499=>[94.670,-78.920,50.725,1],
58500=>[94.682,-78.917,50.687,1],
58501=>[94.693,-78.913,50.648,1],
58502=>[94.704,-78.909,50.610,1],
58503=>[94.715,-78.905,50.572,1],
58504=>[94.726,-78.902,50.535,1],
58505=>[94.736,-78.908,50.496,1],
58506=>[94.744,-78.915,50.456,1],
58507=>[94.752,-78.922,50.418,1],
58508=>[94.760,-78.930,50.380,1],
58509=>[94.768,-78.937,50.342,1],
58510=>[94.777,-78.945,50.305,1],
58511=>[94.785,-78.952,50.267,1],
58512=>[94.793,-78.960,50.229,1],
58513=>[94.802,-78.968,50.191,1],
58514=>[94.810,-78.974,50.153,1],
58515=>[94.818,-78.982,50.115,1],
58516=>[94.827,-78.990,50.078,1],
58517=>[94.835,-78.997,50.041,1],
58518=>[94.843,-79.005,50.003,1],
58519=>[94.851,-79.012,49.966,1],
58520=>[94.859,-79.020,49.928,1],
58521=>[94.868,-79.027,49.890,1],
58522=>[94.876,-79.034,49.852,1],
58523=>[94.885,-79.042,49.816,1],
58524=>[94.893,-79.049,49.778,1],
58525=>[94.901,-79.057,49.740,1],
58526=>[94.909,-79.065,49.702,1],
58527=>[94.917,-79.072,49.663,1],
58528=>[94.926,-79.079,49.625,1],
58529=>[94.934,-79.087,49.588,1],
58530=>[94.943,-79.094,49.551,1],
58531=>[94.951,-79.102,49.512,1],
58532=>[94.961,-79.115,49.474,1],
58533=>[94.974,-79.134,49.437,1],
58534=>[94.986,-79.152,49.400,1],
58535=>[94.998,-79.170,49.364,1],
58536=>[95.011,-79.188,49.328,1],
58537=>[95.023,-79.207,49.292,1],
58538=>[95.034,-79.225,49.256,1],
58539=>[95.041,-79.237,49.221,1],
58540=>[95.047,-79.250,49.187,1],
58541=>[95.054,-79.263,49.153,1],
58542=>[95.060,-79.275,49.119,1],
58543=>[95.066,-79.288,49.085,1],
58544=>[95.074,-79.300,49.051,1],
58545=>[95.089,-79.313,49.017,1],
58546=>[95.103,-79.325,48.983,1],
58547=>[95.122,-79.333,48.948,1],
58548=>[95.142,-79.338,48.912,1],
58549=>[95.154,-79.340,48.875,1],
58550=>[95.166,-79.341,48.837,1],
58551=>[95.178,-79.343,48.801,1],
58552=>[95.199,-79.347,48.764,1],
58553=>[95.225,-79.352,48.726,1],
58554=>[95.249,-79.357,48.689,1],
58555=>[95.274,-79.361,48.652,1],
58556=>[95.299,-79.366,48.614,1],
58557=>[95.324,-79.371,48.576,1],
58558=>[95.348,-79.375,48.539,1],
58559=>[95.373,-79.381,48.502,1],
58560=>[95.398,-79.385,48.465,1],
58561=>[95.416,-79.380,48.427,1],
58562=>[95.431,-79.388,48.389,1],
58563=>[95.458,-79.397,48.350,1],
58564=>[95.497,-79.401,48.311,1],
58565=>[95.537,-79.406,48.271,1],
58566=>[95.566,-79.400,48.232,1],
58567=>[95.585,-79.390,48.193,1],
58568=>[95.595,-79.384,48.153,1],
58569=>[95.606,-79.379,48.113,1],
58570=>[95.616,-79.373,48.074,1],
58571=>[95.626,-79.368,48.039,1],
58572=>[95.636,-79.362,48.004,1],
58573=>[95.647,-79.357,47.969,1],
58574=>[95.657,-79.351,47.935,1],
58575=>[95.667,-79.346,47.903,1],
58576=>[95.677,-79.340,47.870,1],
58577=>[95.687,-79.335,47.836,1],
58578=>[95.697,-79.329,47.800,1],
58579=>[95.713,-79.332,47.764,1],
58580=>[95.724,-79.344,47.728,1],
58581=>[95.734,-79.354,47.695,1],
58582=>[95.744,-79.365,47.660,1],
58583=>[95.754,-79.375,47.625,1],
58584=>[95.764,-79.385,47.589,1],
58585=>[95.789,-79.390,47.553,1],
58586=>[95.841,-79.385,47.516,1],
58587=>[95.894,-79.381,47.478,1],
58588=>[95.923,-79.360,47.439,1],
58589=>[95.942,-79.344,47.401,1],
58590=>[95.989,-79.366,47.364,1],
58591=>[96.014,-79.375,47.328,1],
58592=>[96.034,-79.384,47.293,1],
58593=>[96.054,-79.392,47.259,1],
58594=>[96.075,-79.400,47.226,1],
58595=>[96.095,-79.408,47.192,1],
58596=>[96.116,-79.416,47.159,1],
58597=>[96.136,-79.425,47.126,1],
58598=>[96.157,-79.432,47.093,1],
58599=>[96.177,-79.441,47.061,1],
58600=>[96.197,-79.449,47.029,1],
58601=>[96.218,-79.457,46.997,1],
58602=>[96.238,-79.465,46.966,1],
58603=>[96.258,-79.475,46.934,1],
58604=>[96.277,-79.485,46.902,1],
58605=>[96.297,-79.497,46.871,1],
58606=>[96.316,-79.507,46.840,1],
58607=>[96.336,-79.519,46.809,1],
58608=>[96.356,-79.529,46.779,1],
58609=>[96.378,-79.535,46.748,1],
58610=>[96.403,-79.538,46.717,1],
58611=>[96.429,-79.541,46.687,1],
58612=>[96.454,-79.543,46.656,1],
58613=>[96.478,-79.545,46.629,1],
58614=>[96.504,-79.548,46.602,1],
58615=>[96.529,-79.550,46.575,1],
58616=>[96.554,-79.552,46.550,1],
58617=>[96.579,-79.555,46.525,1],
58618=>[96.604,-79.557,46.500,1],
58619=>[96.629,-79.560,46.476,1],
58620=>[96.655,-79.562,46.453,1],
58621=>[96.680,-79.564,46.431,1],
58622=>[96.704,-79.567,46.408,1],
58623=>[96.730,-79.569,46.386,1],
58624=>[96.755,-79.572,46.363,1],
58625=>[96.780,-79.574,46.341,1],
58626=>[96.811,-79.571,46.316,1],
58627=>[96.844,-79.566,46.294,1],
58628=>[96.869,-79.561,46.274,1],
58629=>[96.888,-79.557,46.252,1],
58630=>[96.908,-79.553,46.230,1],
58631=>[96.925,-79.554,46.208,1],
58632=>[96.948,-79.560,46.184,1],
58633=>[96.970,-79.556,46.158,1],
58634=>[96.998,-79.550,46.133,1],
58635=>[97.025,-79.544,46.110,1],
58636=>[97.053,-79.537,46.086,1],
58637=>[97.081,-79.531,46.063,1],
58638=>[97.108,-79.525,46.040,1],
58639=>[97.136,-79.518,46.016,1],
58640=>[97.163,-79.507,45.991,1],
58641=>[97.183,-79.502,45.966,1],
58642=>[97.196,-79.505,45.940,1],
58643=>[97.208,-79.508,45.913,1],
58644=>[97.223,-79.517,45.887,1],
58645=>[97.222,-79.522,45.862,1],
58646=>[97.220,-79.527,45.837,1],
58647=>[97.193,-79.566,45.812,1],
58648=>[97.167,-79.604,45.788,1],
58649=>[97.167,-79.618,45.765,1],
58650=>[97.174,-79.626,45.743,1],
58651=>[97.181,-79.634,45.721,1],
58652=>[97.188,-79.642,45.700,1],
58653=>[97.195,-79.649,45.679,1],
58654=>[97.203,-79.657,45.658,1],
58655=>[97.210,-79.664,45.638,1],
58656=>[97.217,-79.672,45.620,1],
58657=>[97.224,-79.679,45.602,1],
58658=>[97.231,-79.687,45.584,1],
58659=>[97.238,-79.695,45.566,1],
58673=>[97.337,-79.802,45.313,1],
59064=>[93.201,-79.306,53.429,1],
59065=>[93.215,-79.294,53.415,1],
59066=>[93.229,-79.281,53.401,1],
59067=>[93.243,-79.269,53.386,1],
59068=>[93.258,-79.257,53.372,1],
59069=>[93.272,-79.245,53.357,1],
59070=>[93.286,-79.233,53.342,1],
59071=>[93.305,-79.225,53.327,1],
59072=>[93.314,-79.222,53.312,1],
59073=>[93.325,-79.219,53.297,1],
59074=>[93.334,-79.217,53.284,1],
59075=>[93.344,-79.215,53.270,1],
59076=>[93.353,-79.212,53.257,1],
59077=>[93.363,-79.208,53.243,1],
59078=>[93.375,-79.198,53.228,1],
59079=>[93.387,-79.187,53.214,1],
59080=>[93.398,-79.177,53.200,1],
59081=>[93.407,-79.169,53.187,1],
59082=>[93.416,-79.162,53.174,1],
59083=>[93.422,-79.165,53.161,1],
59084=>[93.438,-79.156,53.150,1],
59085=>[93.457,-79.143,53.140,1],
59086=>[93.476,-79.131,53.130,1],
59087=>[93.490,-79.126,53.122,1],
59088=>[93.505,-79.122,53.117,1],
59089=>[93.519,-79.117,53.115,1],
59090=>[93.534,-79.112,53.113,1],
59091=>[93.548,-79.107,53.109,1],
59092=>[93.563,-79.102,53.101,1],
59093=>[93.576,-79.099,53.094,1],
59094=>[93.588,-79.097,53.086,1],
59095=>[93.601,-79.096,53.080,1],
59096=>[93.613,-79.094,53.074,1],
59097=>[93.625,-79.093,53.068,1],
59098=>[93.633,-79.097,53.063,1],
59099=>[93.640,-79.102,53.057,1],
59100=>[93.648,-79.107,53.051,1],
59101=>[93.663,-79.108,53.043,1],
59102=>[93.681,-79.108,53.034,1],
59103=>[93.697,-79.108,53.025,1],
59104=>[93.711,-79.107,53.015,1],
59105=>[93.726,-79.107,53.005,1],
59106=>[93.741,-79.106,52.994,1],
59107=>[93.756,-79.106,52.984,1],
59108=>[93.771,-79.106,52.972,1],
59109=>[93.786,-79.106,52.959,1],
59110=>[93.800,-79.106,52.947,1],
59111=>[93.816,-79.105,52.934,1],
59112=>[93.830,-79.103,52.921,1],
59113=>[93.837,-79.101,52.908,1],
59114=>[93.841,-79.100,52.894,1],
59115=>[93.845,-79.099,52.880,1],
59116=>[93.849,-79.097,52.864,1],
59117=>[93.853,-79.096,52.845,1],
59118=>[93.856,-79.094,52.827,1],
59119=>[93.860,-79.093,52.808,1],
59120=>[93.868,-79.090,52.788,1],
59121=>[93.875,-79.092,52.769,1],
59122=>[93.882,-79.096,52.753,1],
59123=>[93.888,-79.100,52.739,1],
59124=>[93.894,-79.103,52.726,1],
59125=>[93.900,-79.106,52.714,1],
59126=>[93.904,-79.109,52.700,1],
59127=>[93.907,-79.112,52.686,1],
59128=>[93.910,-79.114,52.672,1],
59129=>[93.914,-79.116,52.661,1],
59130=>[93.917,-79.118,52.648,1],
59131=>[93.920,-79.122,52.636,1],
59132=>[93.923,-79.124,52.623,1],
59133=>[93.926,-79.126,52.611,1],
59134=>[93.929,-79.128,52.599,1],
59135=>[93.933,-79.131,52.586,1],
59136=>[93.936,-79.140,52.573,1],
59137=>[93.940,-79.148,52.560,1],
59138=>[93.946,-79.152,52.545,1],
59139=>[93.953,-79.150,52.533,1],
59140=>[93.960,-79.150,52.521,1],
59141=>[93.966,-79.148,52.508,1],
59142=>[93.973,-79.147,52.495,1],
59143=>[93.980,-79.146,52.480,1],
59144=>[93.993,-79.140,52.461,1],
59145=>[94.000,-79.139,52.440,1],
59146=>[94.000,-79.141,52.416,1],
59147=>[93.999,-79.143,52.390,1],
59148=>[93.999,-79.146,52.362,1],
59149=>[93.999,-79.148,52.334,1],
59150=>[93.999,-79.149,52.306,1],
59151=>[93.999,-79.150,52.276,1],
59152=>[93.999,-79.152,52.244,1],
59153=>[93.999,-79.153,52.215,1],
59154=>[94.000,-79.155,52.185,1],
59155=>[94.002,-79.156,52.155,1],
59156=>[94.010,-79.153,52.127,1],
59157=>[94.019,-79.152,52.100,1],
59158=>[94.028,-79.150,52.072,1],
59159=>[94.036,-79.148,52.043,1],
59160=>[94.045,-79.146,52.017,1],
59161=>[94.056,-79.144,51.993,1],
59162=>[94.067,-79.143,51.970,1],
59163=>[94.075,-79.142,51.951,1],
59164=>[94.074,-79.138,51.934,1],
59165=>[94.072,-79.134,51.917,1],
59166=>[94.088,-79.111,51.899,1],
59167=>[94.107,-79.084,51.879,1],
59168=>[94.126,-79.057,51.856,1],
59169=>[94.144,-79.031,51.832,1],
59170=>[94.165,-79.009,51.811,1],
59171=>[94.186,-78.987,51.791,1],
59172=>[94.207,-78.965,51.772,1],
59173=>[94.228,-78.943,51.750,1],
59174=>[94.250,-78.921,51.724,1],
59175=>[94.266,-78.911,51.694,1],
59176=>[94.285,-78.919,51.660,1],
59177=>[94.304,-78.927,51.620,1],
59178=>[94.324,-78.937,51.580,1],
59179=>[94.343,-78.945,51.541,1],
59180=>[94.362,-78.953,51.500,1],
59181=>[94.382,-78.962,51.460,1],
59182=>[94.401,-78.971,51.419,1],
59183=>[94.420,-78.979,51.381,1],
59184=>[94.439,-78.987,51.346,1],
59185=>[94.459,-78.996,51.313,1],
59186=>[94.476,-78.971,51.281,1],
59187=>[94.498,-78.965,51.247,1],
59188=>[94.520,-78.956,51.212,1],
59189=>[94.542,-78.949,51.175,1],
59190=>[94.559,-78.951,51.136,1],
59191=>[94.575,-78.956,51.095,1],
59192=>[94.588,-78.953,51.055,1],
59193=>[94.599,-78.947,51.016,1],
59194=>[94.609,-78.940,50.976,1],
59195=>[94.620,-78.934,50.936,1],
59196=>[94.631,-78.927,50.895,1],
59197=>[94.642,-78.922,50.856,1],
59198=>[94.653,-78.918,50.817,1],
59199=>[94.664,-78.915,50.778,1],
59200=>[94.676,-78.911,50.740,1],
59201=>[94.687,-78.908,50.702,1],
59202=>[94.698,-78.904,50.663,1],
59203=>[94.709,-78.900,50.625,1],
59204=>[94.720,-78.896,50.587,1],
59205=>[94.732,-78.893,50.549,1],
59206=>[94.743,-78.889,50.511,1],
59207=>[94.752,-78.895,50.471,1],
59208=>[94.760,-78.902,50.433,1],
59209=>[94.769,-78.909,50.395,1],
59210=>[94.777,-78.917,50.356,1],
59211=>[94.785,-78.924,50.318,1],
59212=>[94.793,-78.932,50.281,1],
59213=>[94.802,-78.940,50.243,1],
59214=>[94.810,-78.947,50.204,1],
59215=>[94.818,-78.955,50.167,1],
59216=>[94.827,-78.962,50.129,1],
59217=>[94.835,-78.969,50.092,1],
59218=>[94.843,-78.977,50.054,1],
59219=>[94.851,-78.984,50.017,1],
59220=>[94.859,-78.992,49.979,1],
59221=>[94.868,-78.999,49.942,1],
59222=>[94.876,-79.007,49.904,1],
59223=>[94.885,-79.015,49.866,1],
59224=>[94.893,-79.021,49.830,1],
59225=>[94.901,-79.029,49.792,1],
59226=>[94.909,-79.037,49.754,1],
59227=>[94.918,-79.044,49.715,1],
59228=>[94.926,-79.052,49.677,1],
59229=>[94.934,-79.059,49.639,1],
59230=>[94.944,-79.071,49.601,1],
59231=>[94.957,-79.089,49.564,1],
59232=>[94.969,-79.107,49.525,1],
59233=>[94.981,-79.125,49.487,1],
59234=>[94.993,-79.143,49.450,1],
59235=>[95.005,-79.162,49.413,1],
59236=>[95.013,-79.176,49.377,1],
59237=>[95.020,-79.188,49.341,1],
59238=>[95.026,-79.201,49.305,1],
59239=>[95.032,-79.214,49.271,1],
59240=>[95.039,-79.227,49.237,1],
59241=>[95.045,-79.239,49.202,1],
59242=>[95.051,-79.252,49.169,1],
59243=>[95.058,-79.265,49.136,1],
59244=>[95.067,-79.277,49.102,1],
59245=>[95.082,-79.290,49.068,1],
59246=>[95.096,-79.303,49.033,1],
59247=>[95.111,-79.315,48.999,1],
59248=>[95.131,-79.321,48.963,1],
59249=>[95.151,-79.326,48.926,1],
59250=>[95.168,-79.331,48.889,1],
59251=>[95.179,-79.332,48.852,1],
59252=>[95.191,-79.333,48.816,1],
59253=>[95.212,-79.338,48.780,1],
59254=>[95.237,-79.342,48.743,1],
59255=>[95.262,-79.347,48.705,1],
59256=>[95.286,-79.351,48.667,1],
59257=>[95.311,-79.357,48.630,1],
59258=>[95.336,-79.361,48.592,1],
59259=>[95.361,-79.366,48.553,1],
59260=>[95.384,-79.368,48.515,1],
59261=>[95.402,-79.362,48.476,1],
59262=>[95.419,-79.360,48.436,1],
59263=>[95.432,-79.375,48.396,1],
59264=>[95.456,-79.386,48.356,1],
59265=>[95.495,-79.391,48.316,1],
59266=>[95.534,-79.394,48.276,1],
59267=>[95.563,-79.389,48.237,1],
59268=>[95.586,-79.375,48.197,1],
59269=>[95.598,-79.369,48.156,1],
59270=>[95.608,-79.364,48.116,1],
59271=>[95.618,-79.358,48.075,1],
59272=>[95.628,-79.353,48.038,1],
59273=>[95.639,-79.347,48.002,1],
59274=>[95.649,-79.342,47.966,1],
59275=>[95.659,-79.336,47.932,1],
59276=>[95.670,-79.331,47.899,1],
59277=>[95.680,-79.325,47.865,1],
59278=>[95.690,-79.320,47.831,1],
59279=>[95.700,-79.314,47.794,1],
59280=>[95.723,-79.317,47.757,1],
59281=>[95.736,-79.340,47.721,1],
59282=>[95.746,-79.350,47.687,1],
59283=>[95.757,-79.360,47.652,1],
59284=>[95.767,-79.370,47.616,1],
59285=>[95.777,-79.381,47.581,1],
59286=>[95.804,-79.385,47.544,1],
59287=>[95.856,-79.380,47.508,1],
59288=>[95.909,-79.375,47.470,1],
59289=>[95.912,-79.337,47.433,1],
59290=>[95.922,-79.310,47.396,1],
59291=>[95.970,-79.332,47.359,1],
59292=>[96.018,-79.353,47.324,1],
59293=>[96.046,-79.366,47.289,1],
59294=>[96.066,-79.373,47.255,1],
59295=>[96.087,-79.382,47.222,1],
59296=>[96.107,-79.390,47.188,1],
59297=>[96.128,-79.398,47.155,1],
59298=>[96.148,-79.407,47.122,1],
59299=>[96.169,-79.414,47.088,1],
59300=>[96.189,-79.422,47.056,1],
59301=>[96.209,-79.431,47.024,1],
59302=>[96.230,-79.439,46.993,1],
59303=>[96.250,-79.447,46.962,1],
59304=>[96.270,-79.455,46.929,1],
59305=>[96.291,-79.463,46.897,1],
59306=>[96.311,-79.472,46.865,1],
59307=>[96.331,-79.479,46.835,1],
59308=>[96.352,-79.488,46.804,1],
59309=>[96.372,-79.496,46.774,1],
59310=>[96.393,-79.504,46.743,1],
59311=>[96.413,-79.512,46.713,1],
59312=>[96.434,-79.520,46.682,1],
59313=>[96.453,-79.530,46.652,1],
59314=>[96.473,-79.541,46.625,1],
59315=>[96.493,-79.552,46.598,1],
59316=>[96.513,-79.561,46.571,1],
59317=>[96.538,-79.563,46.546,1],
59318=>[96.563,-79.566,46.521,1],
59319=>[96.588,-79.568,46.497,1],
59320=>[96.613,-79.571,46.473,1],
59321=>[96.639,-79.573,46.450,1],
59322=>[96.664,-79.576,46.428,1],
59323=>[96.689,-79.578,46.407,1],
59324=>[96.714,-79.580,46.386,1],
59325=>[96.739,-79.582,46.365,1],
59326=>[96.770,-79.579,46.344,1],
59327=>[96.804,-79.574,46.321,1],
59328=>[96.837,-79.568,46.300,1],
59329=>[96.860,-79.564,46.279,1],
59330=>[96.880,-79.560,46.256,1],
59331=>[96.900,-79.554,46.233,1],
59332=>[96.925,-79.543,46.209,1],
59333=>[96.951,-79.529,46.185,1],
59334=>[96.978,-79.523,46.156,1],
59335=>[97.006,-79.516,46.130,1],
59336=>[97.033,-79.510,46.107,1],
59337=>[97.061,-79.504,46.081,1],
59338=>[97.089,-79.498,46.057,1],
59339=>[97.116,-79.491,46.034,1],
59340=>[97.144,-79.483,46.010,1],
59341=>[97.168,-79.475,45.986,1],
59342=>[97.180,-79.477,45.962,1],
59343=>[97.192,-79.480,45.937,1],
59344=>[97.205,-79.483,45.911,1],
59345=>[97.217,-79.486,45.886,1],
59346=>[97.232,-79.498,45.860,1],
59347=>[97.231,-79.503,45.835,1],
59348=>[97.230,-79.508,45.810,1],
59349=>[97.226,-79.516,45.786,1],
59350=>[97.200,-79.554,45.764,1],
59351=>[97.174,-79.592,45.741,1],
59352=>[97.182,-79.599,45.719,1],
59353=>[97.189,-79.607,45.697,1],
59354=>[97.196,-79.614,45.677,1],
59355=>[97.203,-79.622,45.656,1],
59356=>[97.210,-79.629,45.637,1],
59357=>[97.217,-79.637,45.618,1],
59358=>[97.224,-79.645,45.601,1],
59359=>[97.231,-79.653,45.583,1],
59360=>[97.238,-79.661,45.564,1],
59361=>[97.245,-79.668,45.547,1],
59362=>[97.252,-79.676,45.528,1],
59363=>[97.259,-79.683,45.509,1],
59364=>[97.266,-79.691,45.492,1],
59365=>[97.274,-79.698,45.474,1],
59366=>[97.281,-79.706,45.456,1],
59367=>[97.288,-79.714,45.438,1],
59368=>[97.295,-79.721,45.419,1],
59369=>[97.302,-79.729,45.400,1],
59370=>[97.309,-79.736,45.382,1],
59371=>[97.316,-79.744,45.365,1],
59372=>[97.323,-79.751,45.348,1],
59373=>[97.330,-79.760,45.331,1],
59374=>[97.337,-79.767,45.314,1],
59375=>[97.345,-79.775,45.296,1],
59766=>[93.214,-79.284,53.440,1],
59767=>[93.228,-79.272,53.426,1],
59768=>[93.242,-79.259,53.411,1],
59769=>[93.257,-79.247,53.397,1],
59770=>[93.271,-79.235,53.382,1],
59771=>[93.286,-79.223,53.368,1],
59772=>[93.305,-79.214,53.353,1],
59773=>[93.315,-79.211,53.337,1],
59774=>[93.325,-79.209,53.322,1],
59775=>[93.334,-79.206,53.308,1],
59776=>[93.344,-79.204,53.295,1],
59777=>[93.354,-79.201,53.281,1],
59778=>[93.363,-79.199,53.267,1],
59779=>[93.373,-79.194,53.252,1],
59780=>[93.385,-79.184,53.238,1],
59781=>[93.397,-79.173,53.224,1],
59782=>[93.408,-79.163,53.210,1],
59783=>[93.417,-79.156,53.197,1],
59784=>[93.425,-79.148,53.184,1],
59785=>[93.432,-79.148,53.172,1],
59786=>[93.439,-79.150,53.161,1],
59787=>[93.459,-79.138,53.150,1],
59788=>[93.478,-79.125,53.141,1],
59789=>[93.497,-79.112,53.137,1],
59790=>[93.513,-79.104,53.135,1],
59791=>[93.528,-79.100,53.134,1],
59792=>[93.543,-79.094,53.133,1],
59793=>[93.557,-79.090,53.129,1],
59794=>[93.571,-79.085,53.123,1],
59795=>[93.583,-79.084,53.116,1],
59796=>[93.595,-79.082,53.110,1],
59797=>[93.608,-79.081,53.104,1],
59798=>[93.616,-79.084,53.097,1],
59799=>[93.624,-79.090,53.092,1],
59800=>[93.631,-79.094,53.086,1],
59801=>[93.639,-79.099,53.079,1],
59802=>[93.656,-79.100,53.071,1],
59803=>[93.674,-79.100,53.062,1],
59804=>[93.690,-79.100,53.053,1],
59805=>[93.705,-79.099,53.043,1],
59806=>[93.719,-79.099,53.034,1],
59807=>[93.734,-79.098,53.023,1],
59808=>[93.749,-79.098,53.012,1],
59809=>[93.764,-79.097,53.000,1],
59810=>[93.779,-79.097,52.987,1],
59811=>[93.794,-79.096,52.974,1],
59812=>[93.808,-79.095,52.960,1],
59813=>[93.823,-79.091,52.946,1],
59814=>[93.830,-79.090,52.932,1],
59815=>[93.834,-79.088,52.918,1],
59816=>[93.838,-79.087,52.904,1],
59817=>[93.841,-79.085,52.888,1],
59818=>[93.845,-79.084,52.870,1],
59819=>[93.849,-79.083,52.850,1],
59820=>[93.856,-79.081,52.831,1],
59821=>[93.864,-79.078,52.813,1],
59822=>[93.872,-79.075,52.794,1],
59823=>[93.878,-79.079,52.778,1],
59824=>[93.885,-79.083,52.765,1],
59825=>[93.891,-79.087,52.752,1],
59826=>[93.897,-79.090,52.739,1],
59827=>[93.900,-79.093,52.726,1],
59828=>[93.903,-79.096,52.713,1],
59829=>[93.906,-79.098,52.701,1],
59830=>[93.909,-79.100,52.689,1],
59831=>[93.912,-79.103,52.676,1],
59832=>[93.915,-79.105,52.662,1],
59833=>[93.918,-79.107,52.650,1],
59834=>[93.921,-79.110,52.638,1],
59835=>[93.925,-79.112,52.625,1],
59836=>[93.928,-79.116,52.612,1],
59837=>[93.932,-79.125,52.600,1],
59838=>[93.936,-79.132,52.588,1],
59839=>[93.940,-79.140,52.574,1],
59840=>[93.945,-79.143,52.562,1],
59841=>[93.953,-79.142,52.550,1],
59842=>[93.959,-79.140,52.536,1],
59843=>[93.966,-79.140,52.522,1],
59844=>[93.981,-79.134,52.506,1],
59845=>[93.998,-79.126,52.486,1],
59846=>[94.001,-79.127,52.464,1],
59847=>[94.001,-79.129,52.440,1],
59848=>[94.000,-79.131,52.413,1],
59849=>[94.000,-79.134,52.385,1],
59850=>[93.999,-79.137,52.354,1],
59851=>[93.999,-79.139,52.324,1],
59852=>[93.998,-79.141,52.293,1],
59853=>[93.998,-79.143,52.260,1],
59854=>[93.998,-79.144,52.228,1],
59855=>[93.998,-79.146,52.196,1],
59856=>[94.002,-79.146,52.166,1],
59857=>[94.010,-79.144,52.138,1],
59858=>[94.019,-79.142,52.111,1],
59859=>[94.028,-79.140,52.084,1],
59860=>[94.036,-79.138,52.057,1],
59861=>[94.045,-79.136,52.033,1],
59862=>[94.053,-79.134,52.011,1],
59863=>[94.063,-79.133,51.992,1],
59864=>[94.074,-79.131,51.975,1],
59865=>[94.075,-79.128,51.958,1],
59866=>[94.082,-79.114,51.941,1],
59867=>[94.101,-79.087,51.921,1],
59868=>[94.120,-79.060,51.899,1],
59869=>[94.138,-79.034,51.875,1],
59870=>[94.156,-79.007,51.850,1],
59871=>[94.176,-78.982,51.829,1],
59872=>[94.197,-78.960,51.809,1],
59873=>[94.218,-78.938,51.789,1],
59874=>[94.240,-78.916,51.765,1],
59875=>[94.261,-78.894,51.736,1],
59876=>[94.274,-78.895,51.704,1],
59877=>[94.285,-78.891,51.668,1],
59878=>[94.304,-78.900,51.630,1],
59879=>[94.324,-78.908,51.591,1],
59880=>[94.343,-78.917,51.552,1],
59881=>[94.362,-78.926,51.512,1],
59882=>[94.382,-78.934,51.472,1],
59883=>[94.401,-78.943,51.433,1],
59884=>[94.420,-78.951,51.395,1],
59885=>[94.439,-78.960,51.361,1],
59886=>[94.458,-78.954,51.329,1],
59887=>[94.478,-78.942,51.298,1],
59888=>[94.501,-78.952,51.265,1],
59889=>[94.524,-78.946,51.230,1],
59890=>[94.546,-78.937,51.193,1],
59891=>[94.562,-78.942,51.154,1],
59892=>[94.578,-78.946,51.114,1],
59893=>[94.595,-78.952,51.074,1],
59894=>[94.605,-78.945,51.033,1],
59895=>[94.616,-78.939,50.995,1],
59896=>[94.627,-78.932,50.955,1],
59897=>[94.637,-78.926,50.914,1],
59898=>[94.648,-78.919,50.874,1],
59899=>[94.659,-78.913,50.834,1],
59900=>[94.670,-78.906,50.795,1],
59901=>[94.681,-78.902,50.757,1],
59902=>[94.692,-78.899,50.718,1],
59903=>[94.703,-78.895,50.680,1],
59904=>[94.715,-78.891,50.641,1],
59905=>[94.726,-78.887,50.603,1],
59906=>[94.737,-78.883,50.565,1],
59907=>[94.749,-78.880,50.526,1],
59908=>[94.760,-78.877,50.486,1],
59909=>[94.769,-78.882,50.448,1],
59910=>[94.777,-78.890,50.409,1],
59911=>[94.785,-78.897,50.371,1],
59912=>[94.793,-78.904,50.332,1],
59913=>[94.802,-78.912,50.294,1],
59914=>[94.810,-78.919,50.257,1],
59915=>[94.818,-78.927,50.218,1],
59916=>[94.827,-78.934,50.180,1],
59917=>[94.835,-78.942,50.143,1],
59918=>[94.843,-78.949,50.106,1],
59919=>[94.851,-78.956,50.068,1],
59920=>[94.860,-78.964,50.031,1],
59921=>[94.868,-78.971,49.993,1],
59922=>[94.877,-78.979,49.956,1],
59923=>[94.885,-78.987,49.919,1],
59924=>[94.893,-78.994,49.881,1],
59925=>[94.901,-79.002,49.844,1],
59926=>[94.909,-79.009,49.806,1],
59927=>[94.918,-79.016,49.768,1],
59928=>[94.927,-79.026,49.729,1],
59929=>[94.939,-79.044,49.691,1],
59930=>[94.952,-79.062,49.653,1],
59931=>[94.964,-79.081,49.615,1],
59932=>[94.976,-79.100,49.577,1],
59933=>[94.985,-79.115,49.539,1],
59934=>[94.991,-79.127,49.501,1],
59935=>[94.998,-79.140,49.463,1],
59936=>[95.004,-79.153,49.427,1],
59937=>[95.011,-79.165,49.391,1],
59938=>[95.017,-79.178,49.355,1],
59939=>[95.024,-79.190,49.320,1],
59940=>[95.030,-79.203,49.287,1],
59941=>[95.037,-79.216,49.254,1],
59942=>[95.043,-79.228,49.220,1],
59943=>[95.049,-79.241,49.188,1],
59944=>[95.060,-79.254,49.155,1],
59945=>[95.074,-79.266,49.121,1],
59946=>[95.089,-79.279,49.086,1],
59947=>[95.103,-79.291,49.050,1],
59948=>[95.119,-79.303,49.015,1],
59949=>[95.139,-79.308,48.979,1],
59950=>[95.160,-79.314,48.942,1],
59951=>[95.180,-79.320,48.905,1],
59952=>[95.192,-79.322,48.868,1],
59953=>[95.204,-79.324,48.832,1],
59954=>[95.225,-79.328,48.796,1],
59955=>[95.249,-79.332,48.760,1],
59956=>[95.274,-79.337,48.721,1],
59957=>[95.299,-79.341,48.682,1],
59958=>[95.324,-79.347,48.644,1],
59959=>[95.348,-79.351,48.605,1],
59960=>[95.370,-79.350,48.565,1],
59961=>[95.388,-79.344,48.524,1],
59962=>[95.405,-79.338,48.484,1],
59963=>[95.420,-79.347,48.442,1],
59964=>[95.433,-79.362,48.401,1],
59965=>[95.453,-79.375,48.360,1],
59966=>[95.492,-79.379,48.320,1],
59967=>[95.531,-79.384,48.279,1],
59968=>[95.560,-79.378,48.239,1],
59969=>[95.583,-79.365,48.199,1],
59970=>[95.601,-79.354,48.158,1],
59971=>[95.611,-79.349,48.117,1],
59972=>[95.621,-79.344,48.077,1],
59973=>[95.631,-79.338,48.038,1],
59974=>[95.641,-79.332,48.000,1],
59975=>[95.652,-79.327,47.964,1],
59976=>[95.662,-79.322,47.930,1],
59977=>[95.672,-79.316,47.895,1],
59978=>[95.682,-79.310,47.860,1],
59979=>[95.692,-79.305,47.825,1],
59980=>[95.703,-79.300,47.788,1],
59981=>[95.730,-79.305,47.752,1],
59982=>[95.750,-79.325,47.715,1],
59983=>[95.759,-79.346,47.679,1],
59984=>[95.769,-79.356,47.644,1],
59985=>[95.779,-79.366,47.609,1],
59986=>[95.790,-79.376,47.573,1],
59987=>[95.819,-79.380,47.536,1],
59988=>[95.872,-79.375,47.500,1],
59989=>[95.905,-79.357,47.463,1],
59990=>[95.901,-79.313,47.427,1],
59991=>[95.903,-79.277,47.391,1],
59992=>[95.951,-79.298,47.355,1],
59993=>[95.999,-79.319,47.320,1],
59994=>[96.046,-79.341,47.285,1],
59995=>[96.079,-79.355,47.251,1],
59996=>[96.099,-79.363,47.218,1],
59997=>[96.120,-79.372,47.185,1],
59998=>[96.140,-79.380,47.151,1],
59999=>[96.160,-79.388,47.117,1],
60000=>[96.181,-79.396,47.084,1],
60001=>[96.201,-79.404,47.051,1],
60002=>[96.222,-79.413,47.020,1],
60003=>[96.242,-79.420,46.988,1],
60004=>[96.262,-79.429,46.956,1],
60005=>[96.283,-79.437,46.924,1],
60006=>[96.303,-79.445,46.891,1],
60007=>[96.323,-79.453,46.859,1],
60008=>[96.344,-79.461,46.829,1],
60009=>[96.364,-79.469,46.799,1],
60010=>[96.384,-79.478,46.769,1],
60011=>[96.405,-79.485,46.738,1],
60012=>[96.425,-79.494,46.708,1],
60013=>[96.446,-79.502,46.677,1],
60014=>[96.466,-79.510,46.647,1],
60015=>[96.486,-79.518,46.620,1],
60016=>[96.507,-79.526,46.595,1],
60017=>[96.527,-79.535,46.569,1],
60018=>[96.547,-79.543,46.543,1],
60019=>[96.568,-79.551,46.518,1],
60020=>[96.588,-79.559,46.493,1],
60021=>[96.608,-79.567,46.469,1],
60022=>[96.629,-79.576,46.447,1],
60023=>[96.649,-79.585,46.426,1],
60024=>[96.673,-79.589,46.406,1],
60025=>[96.698,-79.592,46.387,1],
60026=>[96.730,-79.588,46.367,1],
60027=>[96.763,-79.582,46.346,1],
60028=>[96.796,-79.573,46.324,1],
60029=>[96.829,-79.563,46.303,1],
60030=>[96.859,-79.555,46.282,1],
60031=>[96.883,-79.544,46.258,1],
60032=>[96.907,-79.532,46.234,1],
60033=>[96.932,-79.521,46.209,1],
60034=>[96.957,-79.507,46.183,1],
60035=>[96.986,-79.490,46.153,1],
60036=>[97.014,-79.483,46.126,1],
60037=>[97.042,-79.477,46.102,1],
60038=>[97.069,-79.470,46.077,1],
60039=>[97.097,-79.464,46.052,1],
60040=>[97.124,-79.458,46.028,1],
60041=>[97.152,-79.447,46.005,1],
60042=>[97.164,-79.450,45.982,1],
60043=>[97.176,-79.452,45.958,1],
60044=>[97.188,-79.455,45.933,1],
60045=>[97.201,-79.458,45.909,1],
60046=>[97.213,-79.461,45.885,1],
60047=>[97.231,-79.469,45.859,1],
60048=>[97.241,-79.479,45.833,1],
60049=>[97.240,-79.484,45.808,1],
60050=>[97.239,-79.488,45.784,1],
60051=>[97.237,-79.494,45.761,1],
60052=>[97.232,-79.504,45.740,1],
60053=>[97.206,-79.542,45.717,1],
60054=>[97.189,-79.573,45.695,1],
60055=>[97.196,-79.580,45.675,1],
60056=>[97.203,-79.588,45.654,1],
60057=>[97.210,-79.595,45.634,1],
60058=>[97.217,-79.603,45.617,1],
60059=>[97.224,-79.610,45.598,1],
60060=>[97.231,-79.618,45.580,1],
60061=>[97.238,-79.626,45.563,1],
60062=>[97.245,-79.633,45.545,1],
60063=>[97.253,-79.641,45.527,1],
60064=>[97.260,-79.648,45.509,1],
60065=>[97.267,-79.656,45.491,1],
60066=>[97.274,-79.664,45.474,1],
60067=>[97.281,-79.672,45.456,1],
60068=>[97.288,-79.679,45.437,1],
60069=>[97.295,-79.687,45.419,1],
60070=>[97.302,-79.695,45.401,1],
60071=>[97.309,-79.702,45.382,1],
60072=>[97.316,-79.710,45.366,1],
60073=>[97.323,-79.717,45.349,1],
60074=>[97.330,-79.725,45.332,1],
60075=>[97.337,-79.733,45.315,1],
60076=>[97.345,-79.740,45.297,1],
60077=>[97.352,-79.748,45.280,1],
60469=>[93.241,-79.249,53.436,1],
60470=>[93.256,-79.237,53.421,1],
60471=>[93.270,-79.225,53.407,1],
60472=>[93.285,-79.212,53.393,1],
60473=>[93.305,-79.203,53.378,1],
60474=>[93.315,-79.200,53.363,1],
60475=>[93.325,-79.198,53.348,1],
60476=>[93.335,-79.195,53.333,1],
60477=>[93.344,-79.193,53.319,1],
60478=>[93.354,-79.190,53.305,1],
60479=>[93.364,-79.188,53.290,1],
60480=>[93.373,-79.185,53.277,1],
60481=>[93.383,-79.180,53.262,1],
60482=>[93.395,-79.169,53.248,1],
60483=>[93.407,-79.159,53.234,1],
60484=>[93.418,-79.149,53.220,1],
60485=>[93.426,-79.142,53.207,1],
60486=>[93.434,-79.135,53.195,1],
60487=>[93.442,-79.131,53.183,1],
60488=>[93.447,-79.136,53.172,1],
60489=>[93.460,-79.132,53.163,1],
60490=>[93.480,-79.119,53.157,1],
60491=>[93.499,-79.106,53.155,1],
60492=>[93.518,-79.093,53.154,1],
60493=>[93.537,-79.082,53.155,1],
60494=>[93.551,-79.077,53.153,1],
60495=>[93.565,-79.072,53.150,1],
60496=>[93.578,-79.069,53.145,1],
60497=>[93.590,-79.068,53.139,1],
60498=>[93.599,-79.071,53.134,1],
60499=>[93.607,-79.077,53.128,1],
60500=>[93.615,-79.081,53.122,1],
60501=>[93.622,-79.087,53.116,1],
60502=>[93.630,-79.091,53.109,1],
60503=>[93.648,-79.091,53.101,1],
60504=>[93.666,-79.091,53.092,1],
60505=>[93.683,-79.090,53.082,1],
60506=>[93.698,-79.090,53.072,1],
60507=>[93.713,-79.090,53.063,1],
60508=>[93.727,-79.090,53.053,1],
60509=>[93.743,-79.089,53.041,1],
60510=>[93.757,-79.089,53.029,1],
60511=>[93.772,-79.089,53.015,1],
60512=>[93.787,-79.087,53.001,1],
60513=>[93.801,-79.083,52.985,1],
60514=>[93.817,-79.079,52.970,1],
60515=>[93.823,-79.078,52.956,1],
60516=>[93.827,-79.076,52.941,1],
60517=>[93.830,-79.075,52.927,1],
60518=>[93.834,-79.074,52.911,1],
60519=>[93.838,-79.072,52.894,1],
60520=>[93.844,-79.070,52.874,1],
60521=>[93.852,-79.068,52.855,1],
60522=>[93.860,-79.065,52.837,1],
60523=>[93.868,-79.062,52.820,1],
60524=>[93.875,-79.063,52.805,1],
60525=>[93.881,-79.067,52.792,1],
60526=>[93.888,-79.071,52.779,1],
60527=>[93.894,-79.075,52.765,1],
60528=>[93.896,-79.077,52.752,1],
60529=>[93.898,-79.080,52.740,1],
60530=>[93.901,-79.082,52.730,1],
60531=>[93.904,-79.084,52.718,1],
60532=>[93.907,-79.087,52.705,1],
60533=>[93.911,-79.089,52.691,1],
60534=>[93.914,-79.091,52.679,1],
60535=>[93.917,-79.093,52.666,1],
60536=>[93.920,-79.096,52.653,1],
60537=>[93.923,-79.101,52.640,1],
60538=>[93.927,-79.109,52.627,1],
60539=>[93.931,-79.117,52.615,1],
60540=>[93.935,-79.125,52.603,1],
60541=>[93.939,-79.134,52.591,1],
60542=>[93.945,-79.134,52.579,1],
60543=>[93.953,-79.133,52.565,1],
60544=>[93.969,-79.126,52.549,1],
60545=>[93.986,-79.119,52.531,1],
60546=>[94.002,-79.112,52.511,1],
60547=>[94.002,-79.115,52.488,1],
60548=>[94.001,-79.117,52.462,1],
60549=>[94.001,-79.119,52.434,1],
60550=>[94.000,-79.122,52.405,1],
60551=>[94.000,-79.125,52.375,1],
60552=>[93.999,-79.127,52.343,1],
60553=>[93.999,-79.129,52.309,1],
60554=>[93.998,-79.132,52.275,1],
60555=>[93.998,-79.134,52.241,1],
60556=>[93.997,-79.137,52.209,1],
60557=>[94.002,-79.136,52.179,1],
60558=>[94.010,-79.134,52.150,1],
60559=>[94.019,-79.132,52.123,1],
60560=>[94.028,-79.131,52.098,1],
60561=>[94.036,-79.128,52.074,1],
60562=>[94.045,-79.127,52.051,1],
60563=>[94.053,-79.125,52.031,1],
60564=>[94.062,-79.122,52.014,1],
60565=>[94.071,-79.121,51.998,1],
60566=>[94.076,-79.118,51.981,1],
60567=>[94.095,-79.090,51.964,1],
60568=>[94.114,-79.064,51.942,1],
60569=>[94.132,-79.037,51.918,1],
60570=>[94.150,-79.010,51.894,1],
60571=>[94.169,-78.984,51.869,1],
60572=>[94.188,-78.956,51.847,1],
60573=>[94.208,-78.933,51.826,1],
60574=>[94.229,-78.911,51.806,1],
60575=>[94.250,-78.889,51.778,1],
60576=>[94.269,-78.876,51.747,1],
60577=>[94.282,-78.878,51.712,1],
60578=>[94.294,-78.882,51.676,1],
60579=>[94.304,-78.872,51.639,1],
60580=>[94.324,-78.880,51.601,1],
60581=>[94.343,-78.890,51.564,1],
60582=>[94.362,-78.898,51.524,1],
60583=>[94.382,-78.906,51.485,1],
60584=>[94.401,-78.915,51.446,1],
60585=>[94.420,-78.924,51.410,1],
60586=>[94.439,-78.932,51.377,1],
60587=>[94.458,-78.912,51.345,1],
60588=>[94.481,-78.921,51.314,1],
60589=>[94.504,-78.931,51.282,1],
60590=>[94.527,-78.935,51.248,1],
60591=>[94.549,-78.927,51.211,1],
60592=>[94.565,-78.932,51.172,1],
60593=>[94.581,-78.937,51.132,1],
60594=>[94.598,-78.942,51.092,1],
60595=>[94.612,-78.943,51.053,1],
60596=>[94.623,-78.937,51.014,1],
60597=>[94.633,-78.930,50.975,1],
60598=>[94.644,-78.924,50.934,1],
60599=>[94.655,-78.918,50.893,1],
60600=>[94.666,-78.911,50.853,1],
60601=>[94.677,-78.904,50.814,1],
60602=>[94.687,-78.898,50.775,1],
60603=>[94.698,-78.891,50.736,1],
60604=>[94.709,-78.886,50.697,1],
60605=>[94.720,-78.882,50.658,1],
60606=>[94.732,-78.878,50.620,1],
60607=>[94.743,-78.874,50.581,1],
60608=>[94.754,-78.871,50.542,1],
60609=>[94.765,-78.868,50.502,1],
60610=>[94.776,-78.864,50.464,1],
60611=>[94.785,-78.869,50.425,1],
60612=>[94.793,-78.877,50.387,1],
60613=>[94.802,-78.884,50.348,1],
60614=>[94.810,-78.891,50.310,1],
60615=>[94.819,-78.899,50.271,1],
60616=>[94.827,-78.906,50.233,1],
60617=>[94.835,-78.914,50.196,1],
60618=>[94.843,-78.921,50.159,1],
60619=>[94.851,-78.929,50.122,1],
60620=>[94.860,-78.937,50.084,1],
60621=>[94.868,-78.944,50.047,1],
60622=>[94.877,-78.951,50.009,1],
60623=>[94.885,-78.959,49.971,1],
60624=>[94.893,-78.966,49.933,1],
60625=>[94.901,-78.974,49.896,1],
60626=>[94.910,-78.981,49.858,1],
60627=>[94.922,-78.999,49.821,1],
60628=>[94.934,-79.018,49.783,1],
60629=>[94.947,-79.036,49.743,1],
60630=>[94.957,-79.053,49.705,1],
60631=>[94.964,-79.065,49.667,1],
60632=>[94.970,-79.078,49.629,1],
60633=>[94.976,-79.091,49.592,1],
60634=>[94.983,-79.104,49.554,1],
60635=>[94.989,-79.116,49.516,1],
60636=>[94.996,-79.129,49.479,1],
60637=>[95.002,-79.142,49.442,1],
60638=>[95.008,-79.155,49.406,1],
60639=>[95.015,-79.167,49.371,1],
60640=>[95.022,-79.180,49.338,1],
60641=>[95.028,-79.193,49.305,1],
60642=>[95.034,-79.205,49.274,1],
60643=>[95.041,-79.218,49.244,1],
60644=>[95.053,-79.231,49.211,1],
60645=>[95.067,-79.243,49.177,1],
60646=>[95.082,-79.256,49.142,1],
60647=>[95.096,-79.268,49.106,1],
60648=>[95.110,-79.281,49.070,1],
60649=>[95.127,-79.290,49.035,1],
60650=>[95.148,-79.296,48.997,1],
60651=>[95.168,-79.302,48.960,1],
60652=>[95.188,-79.308,48.923,1],
60653=>[95.206,-79.313,48.886,1],
60654=>[95.217,-79.314,48.850,1],
60655=>[95.237,-79.318,48.814,1],
60656=>[95.262,-79.322,48.777,1],
60657=>[95.286,-79.327,48.738,1],
60658=>[95.312,-79.332,48.697,1],
60659=>[95.336,-79.337,48.656,1],
60660=>[95.355,-79.332,48.614,1],
60661=>[95.373,-79.326,48.573,1],
60662=>[95.391,-79.320,48.531,1],
60663=>[95.408,-79.318,48.488,1],
60664=>[95.421,-79.334,48.446,1],
60665=>[95.434,-79.350,48.404,1],
60666=>[95.450,-79.364,48.363,1],
60667=>[95.489,-79.368,48.321,1],
60668=>[95.528,-79.372,48.280,1],
60669=>[95.558,-79.366,48.239,1],
60670=>[95.580,-79.353,48.199,1],
60671=>[95.603,-79.340,48.158,1],
60672=>[95.613,-79.335,48.118,1],
60673=>[95.624,-79.328,48.079,1],
60674=>[95.634,-79.323,48.038,1],
60675=>[95.644,-79.318,48.001,1],
60676=>[95.654,-79.313,47.964,1],
60677=>[95.665,-79.306,47.928,1],
60678=>[95.675,-79.301,47.891,1],
60679=>[95.685,-79.296,47.855,1],
60680=>[95.695,-79.291,47.819,1],
60681=>[95.705,-79.285,47.783,1],
60682=>[95.737,-79.293,47.748,1],
60683=>[95.763,-79.308,47.711,1],
60684=>[95.772,-79.336,47.674,1],
60685=>[95.782,-79.351,47.638,1],
60686=>[95.792,-79.362,47.602,1],
60687=>[95.802,-79.372,47.566,1],
60688=>[95.834,-79.375,47.529,1],
60689=>[95.886,-79.370,47.493,1],
60690=>[95.894,-79.334,47.458,1],
60691=>[95.890,-79.290,47.421,1],
60692=>[95.886,-79.246,47.386,1],
60693=>[95.932,-79.265,47.351,1],
60694=>[95.979,-79.286,47.316,1],
60695=>[96.027,-79.307,47.281,1],
60696=>[96.075,-79.329,47.248,1],
60697=>[96.111,-79.345,47.215,1],
60698=>[96.132,-79.353,47.181,1],
60699=>[96.152,-79.361,47.147,1],
60700=>[96.173,-79.369,47.112,1],
60701=>[96.193,-79.378,47.079,1],
60702=>[96.214,-79.386,47.047,1],
60703=>[96.234,-79.394,47.015,1],
60704=>[96.254,-79.402,46.982,1],
60705=>[96.274,-79.410,46.950,1],
60706=>[96.295,-79.419,46.918,1],
60707=>[96.315,-79.427,46.886,1],
60708=>[96.335,-79.435,46.854,1],
60709=>[96.356,-79.443,46.823,1],
60710=>[96.376,-79.451,46.793,1],
60711=>[96.397,-79.460,46.763,1],
60712=>[96.417,-79.467,46.733,1],
60713=>[96.438,-79.476,46.702,1],
60714=>[96.458,-79.484,46.672,1],
60715=>[96.478,-79.492,46.642,1],
60716=>[96.499,-79.500,46.616,1],
60717=>[96.519,-79.508,46.592,1],
60718=>[96.539,-79.516,46.568,1],
60719=>[96.559,-79.525,46.542,1],
60720=>[96.580,-79.532,46.515,1],
60721=>[96.600,-79.541,46.490,1],
60722=>[96.621,-79.549,46.466,1],
60723=>[96.641,-79.557,46.445,1],
60724=>[96.662,-79.566,46.425,1],
60725=>[96.681,-79.576,46.407,1],
60726=>[96.699,-79.576,46.386,1],
60727=>[96.719,-79.555,46.365,1],
60728=>[96.752,-79.545,46.342,1],
60729=>[96.785,-79.535,46.320,1],
60730=>[96.818,-79.525,46.299,1],
60731=>[96.851,-79.515,46.278,1],
60732=>[96.891,-79.522,46.253,1],
60733=>[96.915,-79.510,46.228,1],
60734=>[96.940,-79.498,46.202,1],
60735=>[96.964,-79.487,46.178,1],
60736=>[96.994,-79.463,46.148,1],
60737=>[97.022,-79.450,46.121,1],
60738=>[97.050,-79.444,46.097,1],
60739=>[97.078,-79.438,46.072,1],
60740=>[97.105,-79.431,46.048,1],
60741=>[97.133,-79.422,46.024,1],
60742=>[97.148,-79.422,46.000,1],
60743=>[97.161,-79.425,45.976,1],
60744=>[97.173,-79.427,45.953,1],
60745=>[97.185,-79.430,45.928,1],
60746=>[97.198,-79.435,45.905,1],
60747=>[97.215,-79.439,45.882,1],
60748=>[97.232,-79.446,45.858,1],
60749=>[97.248,-79.454,45.833,1],
60750=>[97.250,-79.460,45.808,1],
60751=>[97.249,-79.464,45.783,1],
60752=>[97.248,-79.469,45.759,1],
60753=>[97.247,-79.475,45.737,1],
60754=>[97.245,-79.479,45.715,1],
60755=>[97.239,-79.492,45.693,1],
60756=>[97.212,-79.531,45.672,1],
60757=>[97.203,-79.553,45.652,1],
60758=>[97.210,-79.560,45.632,1],
60759=>[97.217,-79.568,45.615,1],
60760=>[97.225,-79.576,45.597,1],
60761=>[97.232,-79.583,45.579,1],
60762=>[97.239,-79.592,45.561,1],
60763=>[97.246,-79.599,45.544,1],
60764=>[97.253,-79.607,45.526,1],
60765=>[97.260,-79.614,45.508,1],
60766=>[97.267,-79.622,45.491,1],
60767=>[97.274,-79.629,45.473,1],
60768=>[97.281,-79.637,45.455,1],
60769=>[97.288,-79.645,45.437,1],
60770=>[97.295,-79.652,45.419,1],
60771=>[97.302,-79.660,45.401,1],
60772=>[97.309,-79.667,45.383,1],
60773=>[97.316,-79.675,45.367,1],
60774=>[97.324,-79.683,45.349,1],
60775=>[97.331,-79.690,45.332,1],
60776=>[97.338,-79.698,45.316,1],
60777=>[97.345,-79.706,45.298,1],
60778=>[97.352,-79.714,45.281,1],
60779=>[97.371,-79.729,45.265,1],
60835=>[98.445,-80.585,44.578,1],
60836=>[98.464,-80.600,44.572,1],
60837=>[98.487,-80.607,44.565,1],
60838=>[98.512,-80.609,44.558,1],
61172=>[93.269,-79.214,53.433,1],
61173=>[93.285,-79.202,53.418,1],
61174=>[93.306,-79.192,53.402,1],
61175=>[93.315,-79.190,53.388,1],
61176=>[93.325,-79.187,53.373,1],
61177=>[93.335,-79.184,53.358,1],
61178=>[93.345,-79.182,53.344,1],
61179=>[93.354,-79.180,53.330,1],
61180=>[93.364,-79.177,53.315,1],
61181=>[93.373,-79.175,53.300,1],
61182=>[93.383,-79.172,53.286,1],
61183=>[93.394,-79.165,53.272,1],
61184=>[93.405,-79.155,53.258,1],
61185=>[93.417,-79.145,53.244,1],
61186=>[93.427,-79.135,53.231,1],
61187=>[93.436,-79.128,53.219,1],
61188=>[93.444,-79.122,53.207,1],
61189=>[93.452,-79.115,53.195,1],
61190=>[93.458,-79.119,53.185,1],
61191=>[93.464,-79.125,53.178,1],
61192=>[93.481,-79.113,53.174,1],
61193=>[93.500,-79.100,53.173,1],
61194=>[93.519,-79.088,53.175,1],
61195=>[93.539,-79.075,53.176,1],
61196=>[93.558,-79.062,53.175,1],
61197=>[93.574,-79.056,53.172,1],
61198=>[93.582,-79.059,53.167,1],
61199=>[93.590,-79.064,53.162,1],
61200=>[93.598,-79.068,53.157,1],
61201=>[93.606,-79.074,53.152,1],
61202=>[93.613,-79.078,53.145,1],
61203=>[93.623,-79.082,53.139,1],
61204=>[93.640,-79.082,53.130,1],
61205=>[93.658,-79.082,53.121,1],
61206=>[93.676,-79.082,53.112,1],
61207=>[93.691,-79.082,53.102,1],
61208=>[93.706,-79.081,53.091,1],
61209=>[93.721,-79.081,53.080,1],
61210=>[93.736,-79.081,53.068,1],
61211=>[93.751,-79.081,53.054,1],
61212=>[93.765,-79.078,53.039,1],
61213=>[93.780,-79.075,53.024,1],
61214=>[93.795,-79.071,53.008,1],
61215=>[93.809,-79.068,52.993,1],
61216=>[93.815,-79.065,52.978,1],
61217=>[93.819,-79.065,52.964,1],
61218=>[93.823,-79.063,52.949,1],
61219=>[93.827,-79.062,52.934,1],
61220=>[93.832,-79.060,52.917,1],
61221=>[93.840,-79.057,52.898,1],
61222=>[93.848,-79.054,52.879,1],
61223=>[93.856,-79.052,52.862,1],
61224=>[93.864,-79.049,52.847,1],
61225=>[93.871,-79.047,52.834,1],
61226=>[93.878,-79.051,52.821,1],
61227=>[93.884,-79.054,52.808,1],
61228=>[93.891,-79.058,52.792,1],
61229=>[93.893,-79.061,52.780,1],
61230=>[93.894,-79.063,52.769,1],
61231=>[93.896,-79.065,52.758,1],
61232=>[93.900,-79.068,52.747,1],
61233=>[93.903,-79.071,52.735,1],
61234=>[93.906,-79.073,52.720,1],
61235=>[93.909,-79.075,52.707,1],
61236=>[93.912,-79.078,52.694,1],
61237=>[93.915,-79.080,52.680,1],
61238=>[93.919,-79.085,52.666,1],
61239=>[93.923,-79.093,52.653,1],
61240=>[93.927,-79.102,52.641,1],
61241=>[93.931,-79.110,52.629,1],
61242=>[93.935,-79.118,52.619,1],
61243=>[93.939,-79.125,52.606,1],
61244=>[93.957,-79.119,52.591,1],
61245=>[93.974,-79.112,52.574,1],
61246=>[93.991,-79.105,52.556,1],
61247=>[94.003,-79.100,52.535,1],
61248=>[94.003,-79.103,52.510,1],
61249=>[94.002,-79.105,52.483,1],
61250=>[94.002,-79.108,52.454,1],
61251=>[94.001,-79.110,52.424,1],
61252=>[94.001,-79.112,52.392,1],
61253=>[94.000,-79.115,52.359,1],
61254=>[94.000,-79.117,52.324,1],
61255=>[93.999,-79.120,52.288,1],
61256=>[94.000,-79.117,52.254,1],
61257=>[94.001,-79.114,52.222,1],
61258=>[94.006,-79.112,52.191,1],
61259=>[94.014,-79.110,52.164,1],
61260=>[94.023,-79.109,52.138,1],
61261=>[94.032,-79.107,52.114,1],
61262=>[94.040,-79.106,52.091,1],
61263=>[94.048,-79.104,52.070,1],
61264=>[94.057,-79.103,52.051,1],
61265=>[94.065,-79.102,52.035,1],
61266=>[94.074,-79.100,52.018,1],
61267=>[94.086,-79.095,52.001,1],
61268=>[94.107,-79.068,51.982,1],
61269=>[94.126,-79.040,51.958,1],
61270=>[94.145,-79.013,51.933,1],
61271=>[94.163,-78.987,51.908,1],
61272=>[94.182,-78.959,51.883,1],
61273=>[94.200,-78.933,51.862,1],
61274=>[94.219,-78.906,51.841,1],
61275=>[94.240,-78.884,51.820,1],
61276=>[94.261,-78.862,51.790,1],
61277=>[94.277,-78.858,51.756,1],
61278=>[94.290,-78.861,51.721,1],
61279=>[94.303,-78.864,51.686,1],
61280=>[94.314,-78.867,51.649,1],
61281=>[94.324,-78.853,51.612,1],
61282=>[94.343,-78.861,51.575,1],
61283=>[94.362,-78.870,51.536,1],
61284=>[94.382,-78.879,51.497,1],
61285=>[94.401,-78.887,51.460,1],
61286=>[94.420,-78.896,51.425,1],
61287=>[94.438,-78.880,51.392,1],
61288=>[94.461,-78.890,51.360,1],
61289=>[94.484,-78.901,51.330,1],
61290=>[94.507,-78.911,51.298,1],
61291=>[94.531,-78.921,51.264,1],
61292=>[94.552,-78.918,51.230,1],
61293=>[94.568,-78.922,51.190,1],
61294=>[94.584,-78.927,51.151,1],
61295=>[94.601,-78.932,51.111,1],
61296=>[94.617,-78.937,51.073,1],
61297=>[94.629,-78.935,51.035,1],
61298=>[94.640,-78.928,50.996,1],
61299=>[94.651,-78.922,50.957,1],
61300=>[94.662,-78.915,50.915,1],
61301=>[94.672,-78.909,50.874,1],
61302=>[94.683,-78.902,50.835,1],
61303=>[94.694,-78.896,50.795,1],
61304=>[94.705,-78.890,50.756,1],
61305=>[94.715,-78.883,50.717,1],
61306=>[94.726,-78.877,50.678,1],
61307=>[94.737,-78.870,50.639,1],
61308=>[94.748,-78.865,50.600,1],
61309=>[94.759,-78.861,50.560,1],
61310=>[94.771,-78.858,50.521,1],
61311=>[94.782,-78.855,50.481,1],
61312=>[94.793,-78.851,50.442,1],
61313=>[94.802,-78.856,50.404,1],
61314=>[94.810,-78.864,50.365,1],
61315=>[94.819,-78.871,50.326,1],
61316=>[94.827,-78.879,50.287,1],
61317=>[94.835,-78.886,50.249,1],
61318=>[94.843,-78.893,50.212,1],
61319=>[94.852,-78.901,50.175,1],
61320=>[94.860,-78.908,50.138,1],
61321=>[94.868,-78.916,50.100,1],
61322=>[94.877,-78.924,50.063,1],
61323=>[94.885,-78.931,50.025,1],
61324=>[94.893,-78.938,49.987,1],
61325=>[94.905,-78.955,49.949,1],
61326=>[94.917,-78.973,49.912,1],
61327=>[94.929,-78.992,49.874,1],
61328=>[94.936,-79.004,49.836,1],
61329=>[94.942,-79.017,49.798,1],
61330=>[94.949,-79.030,49.759,1],
61331=>[94.955,-79.043,49.720,1],
61332=>[94.962,-79.055,49.682,1],
61333=>[94.968,-79.068,49.644,1],
61334=>[94.974,-79.081,49.607,1],
61335=>[94.981,-79.093,49.569,1],
61336=>[94.987,-79.106,49.532,1],
61337=>[94.993,-79.118,49.495,1],
61338=>[95.000,-79.131,49.459,1],
61339=>[95.006,-79.143,49.423,1],
61340=>[95.013,-79.156,49.390,1],
61341=>[95.016,-79.165,49.359,1],
61342=>[95.019,-79.174,49.328,1],
61343=>[95.025,-79.193,49.298,1],
61344=>[95.044,-79.203,49.267,1],
61345=>[95.059,-79.218,49.234,1],
61346=>[95.075,-79.232,49.201,1],
61347=>[95.089,-79.245,49.166,1],
61348=>[95.103,-79.257,49.130,1],
61349=>[95.118,-79.270,49.093,1],
61350=>[95.136,-79.278,49.056,1],
61351=>[95.156,-79.284,49.018,1],
61352=>[95.177,-79.290,48.979,1],
61353=>[95.197,-79.296,48.941,1],
61354=>[95.217,-79.302,48.903,1],
61355=>[95.231,-79.304,48.865,1],
61356=>[95.250,-79.308,48.827,1],
61357=>[95.274,-79.313,48.788,1],
61358=>[95.299,-79.317,48.747,1],
61359=>[95.323,-79.321,48.705,1],
61360=>[95.341,-79.315,48.663,1],
61361=>[95.359,-79.309,48.620,1],
61362=>[95.377,-79.303,48.577,1],
61363=>[95.395,-79.297,48.535,1],
61364=>[95.409,-79.306,48.492,1],
61365=>[95.422,-79.321,48.448,1],
61366=>[95.435,-79.337,48.406,1],
61367=>[95.448,-79.353,48.364,1],
61368=>[95.486,-79.357,48.323,1],
61369=>[95.526,-79.362,48.282,1],
61370=>[95.555,-79.355,48.240,1],
61371=>[95.577,-79.342,48.200,1],
61372=>[95.600,-79.328,48.159,1],
61373=>[95.616,-79.319,48.119,1],
61374=>[95.626,-79.314,48.079,1],
61375=>[95.636,-79.309,48.040,1],
61376=>[95.647,-79.303,48.002,1],
61377=>[95.657,-79.297,47.965,1],
61378=>[95.667,-79.292,47.928,1],
61379=>[95.677,-79.287,47.891,1],
61380=>[95.687,-79.281,47.854,1],
61381=>[95.698,-79.275,47.817,1],
61382=>[95.709,-79.271,47.780,1],
61383=>[95.743,-79.281,47.744,1],
61384=>[95.776,-79.291,47.708,1],
61385=>[95.785,-79.319,47.671,1],
61386=>[95.795,-79.347,47.634,1],
61387=>[95.805,-79.357,47.598,1],
61388=>[95.815,-79.367,47.562,1],
61389=>[95.849,-79.369,47.525,1],
61390=>[95.887,-79.355,47.490,1],
61391=>[95.883,-79.311,47.455,1],
61392=>[95.879,-79.267,47.419,1],
61393=>[95.875,-79.223,47.383,1],
61394=>[95.912,-79.231,47.347,1],
61395=>[95.960,-79.253,47.312,1],
61396=>[96.008,-79.274,47.278,1],
61397=>[96.055,-79.295,47.244,1],
61398=>[96.103,-79.317,47.210,1],
61399=>[96.144,-79.335,47.176,1],
61400=>[96.164,-79.343,47.142,1],
61401=>[96.185,-79.351,47.108,1],
61402=>[96.205,-79.360,47.074,1],
61403=>[96.226,-79.368,47.041,1],
61404=>[96.246,-79.375,47.009,1],
61405=>[96.266,-79.384,46.977,1],
61406=>[96.287,-79.392,46.945,1],
61407=>[96.307,-79.400,46.913,1],
61408=>[96.327,-79.408,46.881,1],
61409=>[96.347,-79.416,46.849,1],
61410=>[96.368,-79.425,46.818,1],
61411=>[96.388,-79.433,46.787,1],
61412=>[96.409,-79.441,46.757,1],
61413=>[96.429,-79.449,46.727,1],
61414=>[96.450,-79.457,46.697,1],
61415=>[96.470,-79.466,46.667,1],
61416=>[96.490,-79.473,46.637,1],
61417=>[96.511,-79.482,46.610,1],
61418=>[96.531,-79.490,46.585,1],
61419=>[96.551,-79.498,46.560,1],
61420=>[96.572,-79.506,46.535,1],
61421=>[96.592,-79.514,46.510,1],
61422=>[96.613,-79.523,46.484,1],
61423=>[96.633,-79.534,46.460,1],
61424=>[96.654,-79.544,46.439,1],
61425=>[96.670,-79.549,46.419,1],
61426=>[96.684,-79.548,46.399,1],
61427=>[96.707,-79.551,46.377,1],
61428=>[96.726,-79.531,46.354,1],
61429=>[96.744,-79.510,46.331,1],
61430=>[96.773,-79.497,46.309,1],
61431=>[96.806,-79.487,46.289,1],
61432=>[96.839,-79.476,46.269,1],
61433=>[96.875,-79.472,46.245,1],
61434=>[96.920,-79.485,46.220,1],
61435=>[96.947,-79.476,46.194,1],
61436=>[96.971,-79.464,46.169,1],
61437=>[97.000,-79.444,46.141,1],
61438=>[97.030,-79.418,46.116,1],
61439=>[97.058,-79.410,46.093,1],
61440=>[97.086,-79.404,46.069,1],
61441=>[97.113,-79.397,46.045,1],
61442=>[97.133,-79.394,46.021,1],
61443=>[97.145,-79.397,45.997,1],
61444=>[97.157,-79.399,45.973,1],
61445=>[97.170,-79.404,45.950,1],
61446=>[97.184,-79.408,45.927,1],
61447=>[97.198,-79.413,45.904,1],
61448=>[97.220,-79.416,45.880,1],
61449=>[97.235,-79.424,45.855,1],
61450=>[97.255,-79.432,45.830,1],
61451=>[97.261,-79.441,45.805,1],
61452=>[97.257,-79.446,45.781,1],
61453=>[97.258,-79.445,45.756,1],
61454=>[97.257,-79.451,45.734,1],
61455=>[97.256,-79.455,45.713,1],
61456=>[97.254,-79.460,45.692,1],
61457=>[97.253,-79.466,45.671,1],
61458=>[97.245,-79.480,45.650,1],
61459=>[97.218,-79.519,45.631,1],
61460=>[97.218,-79.534,45.613,1],
61461=>[97.225,-79.541,45.596,1],
61462=>[97.232,-79.549,45.578,1],
61463=>[97.239,-79.557,45.560,1],
61464=>[97.246,-79.564,45.543,1],
61465=>[97.253,-79.572,45.525,1],
61466=>[97.260,-79.579,45.507,1],
61467=>[97.267,-79.587,45.490,1],
61468=>[97.274,-79.595,45.473,1],
61469=>[97.281,-79.602,45.455,1],
61470=>[97.288,-79.610,45.438,1],
61471=>[97.296,-79.618,45.419,1],
61472=>[97.303,-79.626,45.401,1],
61473=>[97.310,-79.633,45.384,1],
61474=>[97.317,-79.641,45.368,1],
61475=>[97.324,-79.648,45.350,1],
61476=>[97.331,-79.656,45.333,1],
61477=>[97.338,-79.664,45.317,1],
61478=>[97.345,-79.671,45.299,1],
61479=>[97.358,-79.683,45.282,1],
61480=>[97.377,-79.698,45.266,1],
61481=>[97.396,-79.713,45.251,1],
61534=>[98.412,-80.522,44.601,1],
61535=>[98.431,-80.538,44.592,1],
61536=>[98.450,-80.554,44.586,1],
61537=>[98.469,-80.569,44.579,1],
61538=>[98.492,-80.576,44.572,1],
61539=>[98.517,-80.578,44.566,1],
61540=>[98.542,-80.581,44.559,1],
61541=>[98.567,-80.583,44.551,1],
61542=>[98.591,-80.585,44.543,1],
61543=>[98.616,-80.588,44.535,1],
61544=>[98.641,-80.591,44.528,1],
61545=>[98.665,-80.593,44.522,1],
61546=>[98.690,-80.596,44.515,1],
61547=>[98.715,-80.599,44.507,1],
61548=>[98.741,-80.604,44.500,1],
61549=>[98.767,-80.607,44.495,1],
61550=>[98.792,-80.611,44.488,1],
61551=>[98.817,-80.615,44.481,1],
61552=>[98.843,-80.620,44.476,1],
61553=>[98.867,-80.627,44.471,1],
61874=>[93.284,-79.192,53.443,1],
61875=>[93.306,-79.181,53.427,1],
61876=>[93.315,-79.178,53.413,1],
61877=>[93.326,-79.176,53.398,1],
61878=>[93.335,-79.174,53.384,1],
61879=>[93.345,-79.171,53.369,1],
61880=>[93.354,-79.169,53.355,1],
61881=>[93.364,-79.166,53.340,1],
61882=>[93.374,-79.164,53.326,1],
61883=>[93.383,-79.161,53.311,1],
61884=>[93.393,-79.159,53.296,1],
61885=>[93.404,-79.151,53.282,1],
61886=>[93.415,-79.141,53.268,1],
61887=>[93.427,-79.131,53.255,1],
61888=>[93.437,-79.122,53.242,1],
61889=>[93.445,-79.115,53.229,1],
61890=>[93.453,-79.108,53.217,1],
61891=>[93.462,-79.101,53.207,1],
61892=>[93.468,-79.102,53.199,1],
61893=>[93.474,-79.107,53.195,1],
61894=>[93.483,-79.108,53.192,1],
61895=>[93.502,-79.095,53.195,1],
61896=>[93.521,-79.082,53.197,1],
61897=>[93.541,-79.069,53.198,1],
61898=>[93.560,-79.056,53.196,1],
61899=>[93.573,-79.053,53.193,1],
61900=>[93.581,-79.056,53.190,1],
61901=>[93.588,-79.061,53.185,1],
61902=>[93.596,-79.065,53.180,1],
61903=>[93.604,-79.071,53.174,1],
61904=>[93.615,-79.074,53.168,1],
61905=>[93.633,-79.074,53.159,1],
61906=>[93.650,-79.074,53.150,1],
61907=>[93.668,-79.074,53.140,1],
61908=>[93.685,-79.073,53.130,1],
61909=>[93.699,-79.073,53.118,1],
61910=>[93.714,-79.073,53.105,1],
61911=>[93.729,-79.072,53.093,1],
61912=>[93.744,-79.069,53.078,1],
61913=>[93.759,-79.066,53.063,1],
61914=>[93.773,-79.062,53.047,1],
61915=>[93.788,-79.059,53.031,1],
61916=>[93.802,-79.056,53.016,1],
61917=>[93.808,-79.054,53.001,1],
61918=>[93.812,-79.053,52.986,1],
61919=>[93.816,-79.051,52.972,1],
61920=>[93.820,-79.049,52.957,1],
61921=>[93.828,-79.047,52.940,1],
61922=>[93.836,-79.044,52.922,1],
61923=>[93.844,-79.041,52.905,1],
61924=>[93.852,-79.039,52.889,1],
61925=>[93.860,-79.036,52.874,1],
61926=>[93.868,-79.033,52.862,1],
61927=>[93.874,-79.034,52.850,1],
61928=>[93.881,-79.038,52.837,1],
61929=>[93.887,-79.042,52.823,1],
61930=>[93.890,-79.045,52.809,1],
61931=>[93.891,-79.047,52.797,1],
61932=>[93.892,-79.049,52.785,1],
61933=>[93.895,-79.052,52.775,1],
61934=>[93.898,-79.054,52.763,1],
61935=>[93.901,-79.057,52.749,1],
61936=>[93.904,-79.059,52.734,1],
61937=>[93.908,-79.062,52.719,1],
61938=>[93.911,-79.064,52.704,1],
61939=>[93.914,-79.070,52.689,1],
61940=>[93.918,-79.078,52.677,1],
61941=>[93.922,-79.087,52.666,1],
61942=>[93.926,-79.094,52.654,1],
61943=>[93.930,-79.103,52.643,1],
61944=>[93.936,-79.103,52.630,1],
61945=>[93.962,-79.105,52.614,1],
61946=>[93.979,-79.098,52.598,1],
61947=>[93.995,-79.090,52.579,1],
61948=>[94.004,-79.088,52.557,1],
61949=>[94.003,-79.090,52.530,1],
61950=>[94.003,-79.093,52.502,1],
61951=>[94.002,-79.096,52.472,1],
61952=>[94.002,-79.098,52.441,1],
61953=>[94.001,-79.100,52.408,1],
61954=>[94.002,-79.099,52.374,1],
61955=>[94.003,-79.095,52.339,1],
61956=>[94.004,-79.092,52.302,1],
61957=>[94.005,-79.088,52.268,1],
61958=>[94.006,-79.085,52.235,1],
61959=>[94.012,-79.083,52.204,1],
61960=>[94.020,-79.081,52.178,1],
61961=>[94.029,-79.080,52.154,1],
61962=>[94.037,-79.078,52.131,1],
61963=>[94.046,-79.077,52.110,1],
61964=>[94.054,-79.075,52.090,1],
61965=>[94.062,-79.074,52.071,1],
61966=>[94.071,-79.072,52.054,1],
61967=>[94.080,-79.071,52.036,1],
61968=>[94.095,-79.063,52.017,1],
61969=>[94.112,-79.053,51.997,1],
61970=>[94.132,-79.025,51.972,1],
61971=>[94.153,-78.995,51.947,1],
61972=>[94.175,-78.965,51.923,1],
61973=>[94.194,-78.936,51.899,1],
61974=>[94.213,-78.909,51.878,1],
61975=>[94.231,-78.882,51.857,1],
61976=>[94.251,-78.858,51.833,1],
61977=>[94.271,-78.839,51.802,1],
61978=>[94.285,-78.841,51.768,1],
61979=>[94.298,-78.843,51.733,1],
61980=>[94.312,-78.846,51.697,1],
61981=>[94.323,-78.851,51.660,1],
61982=>[94.330,-78.840,51.623,1],
61983=>[94.343,-78.834,51.587,1],
61984=>[94.362,-78.843,51.548,1],
61985=>[94.382,-78.851,51.510,1],
61986=>[94.401,-78.859,51.474,1],
61987=>[94.420,-78.861,51.439,1],
61988=>[94.441,-78.860,51.407,1],
61989=>[94.465,-78.870,51.376,1],
61990=>[94.487,-78.880,51.346,1],
61991=>[94.510,-78.890,51.314,1],
61992=>[94.534,-78.900,51.282,1],
61993=>[94.555,-78.908,51.248,1],
61994=>[94.571,-78.912,51.209,1],
61995=>[94.588,-78.918,51.170,1],
61996=>[94.604,-78.923,51.132,1],
61997=>[94.620,-78.927,51.094,1],
61998=>[94.636,-78.933,51.057,1],
61999=>[94.647,-78.927,51.019,1],
62000=>[94.657,-78.920,50.982,1],
62001=>[94.668,-78.914,50.939,1],
62002=>[94.679,-78.907,50.899,1],
62003=>[94.690,-78.901,50.859,1],
62004=>[94.700,-78.894,50.821,1],
62005=>[94.711,-78.887,50.781,1],
62006=>[94.722,-78.881,50.741,1],
62007=>[94.733,-78.874,50.701,1],
62008=>[94.744,-78.868,50.661,1],
62009=>[94.754,-78.861,50.622,1],
62010=>[94.765,-78.855,50.583,1],
62011=>[94.776,-78.849,50.542,1],
62012=>[94.787,-78.846,50.501,1],
62013=>[94.799,-78.842,50.461,1],
62014=>[94.810,-78.838,50.422,1],
62015=>[94.819,-78.843,50.382,1],
62016=>[94.827,-78.851,50.343,1],
62017=>[94.835,-78.858,50.305,1],
62018=>[94.843,-78.866,50.266,1],
62019=>[94.852,-78.874,50.228,1],
62020=>[94.860,-78.880,50.191,1],
62021=>[94.868,-78.888,50.154,1],
62022=>[94.877,-78.896,50.116,1],
62023=>[94.888,-78.910,50.079,1],
62024=>[94.900,-78.929,50.041,1],
62025=>[94.908,-78.943,50.003,1],
62026=>[94.914,-78.955,49.965,1],
62027=>[94.921,-78.968,49.928,1],
62028=>[94.927,-78.981,49.890,1],
62029=>[94.933,-78.993,49.853,1],
62030=>[94.940,-79.006,49.814,1],
62031=>[94.947,-79.019,49.775,1],
62032=>[94.953,-79.031,49.736,1],
62033=>[94.959,-79.044,49.698,1],
62034=>[94.963,-79.053,49.660,1],
62035=>[94.965,-79.062,49.622,1],
62036=>[94.968,-79.070,49.585,1],
62037=>[94.970,-79.078,49.548,1],
62038=>[94.973,-79.087,49.511,1],
62039=>[94.975,-79.095,49.476,1],
62040=>[94.978,-79.103,49.442,1],
62041=>[94.979,-79.117,49.410,1],
62042=>[94.975,-79.158,49.380,1],
62043=>[95.007,-79.165,49.350,1],
62044=>[95.029,-79.173,49.320,1],
62045=>[95.045,-79.182,49.288,1],
62046=>[95.061,-79.197,49.255,1],
62047=>[95.076,-79.211,49.221,1],
62048=>[95.092,-79.225,49.187,1],
62049=>[95.108,-79.241,49.152,1],
62050=>[95.123,-79.255,49.114,1],
62051=>[95.144,-79.265,49.075,1],
62052=>[95.165,-79.272,49.036,1],
62053=>[95.185,-79.278,48.996,1],
62054=>[95.205,-79.284,48.957,1],
62055=>[95.226,-79.290,48.917,1],
62056=>[95.244,-79.295,48.877,1],
62057=>[95.262,-79.298,48.837,1],
62058=>[95.287,-79.303,48.796,1],
62059=>[95.309,-79.303,48.754,1],
62060=>[95.327,-79.297,48.712,1],
62061=>[95.344,-79.291,48.669,1],
62062=>[95.362,-79.285,48.625,1],
62063=>[95.380,-79.279,48.582,1],
62064=>[95.397,-79.277,48.539,1],
62065=>[95.410,-79.293,48.496,1],
62066=>[95.423,-79.309,48.452,1],
62067=>[95.436,-79.324,48.409,1],
62068=>[95.449,-79.340,48.368,1],
62069=>[95.483,-79.346,48.327,1],
62070=>[95.523,-79.350,48.285,1],
62071=>[95.552,-79.344,48.243,1],
62072=>[95.574,-79.331,48.202,1],
62073=>[95.597,-79.318,48.162,1],
62074=>[95.619,-79.305,48.122,1],
62075=>[95.629,-79.299,48.082,1],
62076=>[95.639,-79.294,48.043,1],
62077=>[95.650,-79.288,48.005,1],
62078=>[95.660,-79.283,47.967,1],
62079=>[95.670,-79.277,47.929,1],
62080=>[95.680,-79.272,47.892,1],
62081=>[95.690,-79.266,47.854,1],
62082=>[95.700,-79.261,47.817,1],
62083=>[95.716,-79.259,47.779,1],
62084=>[95.750,-79.268,47.742,1],
62085=>[95.783,-79.278,47.706,1],
62086=>[95.799,-79.301,47.669,1],
62087=>[95.808,-79.329,47.632,1],
62088=>[95.818,-79.353,47.596,1],
62089=>[95.828,-79.363,47.559,1],
62090=>[95.864,-79.364,47.522,1],
62091=>[95.876,-79.332,47.487,1],
62092=>[95.872,-79.288,47.451,1],
62093=>[95.868,-79.244,47.416,1],
62094=>[95.864,-79.200,47.380,1],
62095=>[95.893,-79.197,47.344,1],
62096=>[95.941,-79.219,47.309,1],
62097=>[95.988,-79.241,47.274,1],
62098=>[96.036,-79.262,47.240,1],
62099=>[96.084,-79.283,47.205,1],
62100=>[96.131,-79.305,47.171,1],
62101=>[96.177,-79.325,47.137,1],
62102=>[96.197,-79.333,47.103,1],
62103=>[96.217,-79.341,47.069,1],
62104=>[96.238,-79.349,47.036,1],
62105=>[96.258,-79.357,47.003,1],
62106=>[96.278,-79.366,46.971,1],
62107=>[96.299,-79.374,46.939,1],
62108=>[96.319,-79.382,46.907,1],
62109=>[96.339,-79.390,46.875,1],
62110=>[96.360,-79.398,46.843,1],
62111=>[96.380,-79.407,46.812,1],
62112=>[96.400,-79.414,46.781,1],
62113=>[96.421,-79.422,46.751,1],
62114=>[96.441,-79.431,46.721,1],
62115=>[96.462,-79.439,46.691,1],
62116=>[96.482,-79.447,46.661,1],
62117=>[96.503,-79.455,46.631,1],
62118=>[96.523,-79.463,46.604,1],
62119=>[96.543,-79.472,46.578,1],
62120=>[96.564,-79.481,46.552,1],
62121=>[96.585,-79.491,46.528,1],
62122=>[96.605,-79.501,46.503,1],
62123=>[96.626,-79.512,46.477,1],
62124=>[96.647,-79.523,46.453,1],
62125=>[96.658,-79.523,46.431,1],
62126=>[96.669,-79.521,46.410,1],
62127=>[96.692,-79.523,46.388,1],
62128=>[96.715,-79.526,46.365,1],
62129=>[96.734,-79.507,46.341,1],
62130=>[96.752,-79.486,46.317,1],
62131=>[96.771,-79.465,46.295,1],
62132=>[96.795,-79.448,46.275,1],
62133=>[96.827,-79.438,46.256,1],
62134=>[96.861,-79.428,46.234,1],
62135=>[96.899,-79.429,46.210,1],
62136=>[96.945,-79.442,46.185,1],
62137=>[96.979,-79.442,46.159,1],
62138=>[97.005,-79.427,46.133,1],
62139=>[97.036,-79.400,46.109,1],
62140=>[97.066,-79.377,46.087,1],
62141=>[97.094,-79.371,46.065,1],
62142=>[97.116,-79.366,46.042,1],
62143=>[97.129,-79.369,46.018,1],
62144=>[97.143,-79.373,45.995,1],
62145=>[97.156,-79.378,45.971,1],
62146=>[97.170,-79.382,45.948,1],
62147=>[97.184,-79.386,45.927,1],
62148=>[97.203,-79.391,45.904,1],
62149=>[97.223,-79.395,45.877,1],
62150=>[97.239,-79.403,45.850,1],
62151=>[97.268,-79.410,45.825,1],
62152=>[97.279,-79.419,45.801,1],
62153=>[97.272,-79.429,45.777,1],
62154=>[97.264,-79.438,45.755,1],
62155=>[97.261,-79.441,45.733,1],
62156=>[97.266,-79.432,45.711,1],
62157=>[97.265,-79.436,45.690,1],
62158=>[97.263,-79.441,45.670,1],
62159=>[97.262,-79.447,45.650,1],
62160=>[97.261,-79.451,45.631,1],
62161=>[97.251,-79.469,45.614,1],
62162=>[97.225,-79.507,45.596,1],
62163=>[97.232,-79.514,45.578,1],
62164=>[97.239,-79.522,45.561,1],
62165=>[97.246,-79.529,45.543,1],
62166=>[97.253,-79.538,45.525,1],
62167=>[97.260,-79.545,45.507,1],
62168=>[97.267,-79.553,45.490,1],
62169=>[97.275,-79.560,45.473,1],
62170=>[97.282,-79.568,45.456,1],
62171=>[97.289,-79.576,45.438,1],
62172=>[97.296,-79.583,45.420,1],
62173=>[97.303,-79.591,45.402,1],
62174=>[97.310,-79.598,45.385,1],
62175=>[97.317,-79.606,45.369,1],
62176=>[97.324,-79.614,45.352,1],
62177=>[97.331,-79.621,45.335,1],
62178=>[97.338,-79.629,45.319,1],
62179=>[97.345,-79.637,45.301,1],
62180=>[97.363,-79.651,45.285,1],
62181=>[97.382,-79.667,45.269,1],
62182=>[97.401,-79.682,45.254,1],
62233=>[98.379,-80.461,44.623,1],
62234=>[98.398,-80.476,44.616,1],
62235=>[98.417,-80.491,44.609,1],
62236=>[98.436,-80.507,44.601,1],
62237=>[98.455,-80.522,44.594,1],
62238=>[98.475,-80.538,44.587,1],
62239=>[98.498,-80.544,44.581,1],
62240=>[98.522,-80.547,44.574,1],
62241=>[98.547,-80.549,44.566,1],
62242=>[98.572,-80.552,44.559,1],
62243=>[98.597,-80.554,44.552,1],
62244=>[98.622,-80.557,44.543,1],
62245=>[98.646,-80.560,44.536,1],
62246=>[98.671,-80.562,44.530,1],
62247=>[98.696,-80.565,44.523,1],
62248=>[98.721,-80.568,44.516,1],
62249=>[98.746,-80.572,44.508,1],
62250=>[98.772,-80.576,44.501,1],
62251=>[98.797,-80.580,44.495,1],
62252=>[98.823,-80.584,44.489,1],
62253=>[98.848,-80.589,44.484,1],
62254=>[98.871,-80.600,44.478,1],
62577=>[93.316,-79.168,53.438,1],
62578=>[93.326,-79.165,53.423,1],
62579=>[93.335,-79.162,53.409,1],
62580=>[93.345,-79.160,53.395,1],
62581=>[93.355,-79.158,53.379,1],
62582=>[93.364,-79.156,53.365,1],
62583=>[93.374,-79.153,53.351,1],
62584=>[93.384,-79.150,53.336,1],
62585=>[93.394,-79.148,53.321,1],
62586=>[93.403,-79.146,53.306,1],
62587=>[93.414,-79.137,53.292,1],
62588=>[93.425,-79.127,53.278,1],
62589=>[93.437,-79.116,53.265,1],
62590=>[93.446,-79.109,53.252,1],
62591=>[93.454,-79.101,53.239,1],
62592=>[93.463,-79.094,53.229,1],
62593=>[93.471,-79.087,53.221,1],
62594=>[93.479,-79.085,53.214,1],
62595=>[93.484,-79.090,53.210,1],
62596=>[93.490,-79.095,53.211,1],
62597=>[93.504,-79.089,53.212,1],
62598=>[93.523,-79.076,53.213,1],
62599=>[93.542,-79.063,53.213,1],
62600=>[93.561,-79.051,53.212,1],
62601=>[93.572,-79.051,53.210,1],
62602=>[93.579,-79.056,53.207,1],
62603=>[93.587,-79.059,53.203,1],
62604=>[93.595,-79.064,53.198,1],
62605=>[93.608,-79.065,53.192,1],
62606=>[93.625,-79.065,53.185,1],
62607=>[93.643,-79.065,53.176,1],
62608=>[93.660,-79.065,53.166,1],
62609=>[93.678,-79.065,53.156,1],
62610=>[93.693,-79.065,53.143,1],
62611=>[93.707,-79.064,53.129,1],
62612=>[93.722,-79.061,53.115,1],
62613=>[93.737,-79.057,53.101,1],
62614=>[93.752,-79.054,53.085,1],
62615=>[93.766,-79.050,53.069,1],
62616=>[93.781,-79.047,53.054,1],
62617=>[93.795,-79.043,53.039,1],
62618=>[93.800,-79.042,53.024,1],
62619=>[93.804,-79.040,53.009,1],
62620=>[93.808,-79.039,52.995,1],
62621=>[93.816,-79.037,52.980,1],
62622=>[93.824,-79.034,52.964,1],
62623=>[93.832,-79.031,52.947,1],
62624=>[93.840,-79.028,52.931,1],
62625=>[93.848,-79.025,52.916,1],
62626=>[93.856,-79.023,52.902,1],
62627=>[93.863,-79.020,52.891,1],
62628=>[93.871,-79.018,52.880,1],
62629=>[93.877,-79.022,52.867,1],
62630=>[93.884,-79.026,52.853,1],
62631=>[93.887,-79.028,52.839,1],
62632=>[93.888,-79.031,52.825,1],
62633=>[93.889,-79.034,52.813,1],
62634=>[93.890,-79.036,52.802,1],
62635=>[93.893,-79.038,52.789,1],
62636=>[93.897,-79.040,52.774,1],
62637=>[93.900,-79.043,52.759,1],
62638=>[93.903,-79.045,52.743,1],
62639=>[93.906,-79.048,52.727,1],
62640=>[93.910,-79.055,52.712,1],
62641=>[93.914,-79.063,52.700,1],
62642=>[93.918,-79.071,52.687,1],
62643=>[93.922,-79.079,52.674,1],
62644=>[93.922,-79.080,52.662,1],
62645=>[93.933,-79.080,52.649,1],
62646=>[93.959,-79.082,52.634,1],
62647=>[93.984,-79.084,52.616,1],
62648=>[94.000,-79.076,52.596,1],
62649=>[94.005,-79.076,52.573,1],
62650=>[94.004,-79.078,52.547,1],
62651=>[94.004,-79.081,52.519,1],
62652=>[94.004,-79.081,52.489,1],
62653=>[94.005,-79.077,52.457,1],
62654=>[94.006,-79.074,52.423,1],
62655=>[94.007,-79.070,52.389,1],
62656=>[94.008,-79.066,52.355,1],
62657=>[94.010,-79.063,52.318,1],
62658=>[94.011,-79.059,52.282,1],
62659=>[94.012,-79.056,52.249,1],
62660=>[94.017,-79.054,52.218,1],
62661=>[94.026,-79.053,52.193,1],
62662=>[94.034,-79.051,52.171,1],
62663=>[94.043,-79.049,52.150,1],
62664=>[94.051,-79.048,52.130,1],
62665=>[94.060,-79.046,52.111,1],
62666=>[94.069,-79.045,52.092,1],
62667=>[94.078,-79.043,52.072,1],
62668=>[94.087,-79.041,52.052,1],
62669=>[94.104,-79.031,52.031,1],
62670=>[94.120,-79.021,52.009,1],
62671=>[94.137,-79.012,51.984,1],
62672=>[94.158,-78.983,51.960,1],
62673=>[94.179,-78.952,51.937,1],
62674=>[94.200,-78.921,51.916,1],
62675=>[94.221,-78.891,51.894,1],
62676=>[94.243,-78.861,51.872,1],
62677=>[94.262,-78.832,51.847,1],
62678=>[94.279,-78.821,51.815,1],
62679=>[94.292,-78.824,51.780,1],
62680=>[94.306,-78.826,51.745,1],
62681=>[94.320,-78.829,51.708,1],
62682=>[94.332,-78.833,51.671,1],
62683=>[94.343,-78.838,51.635,1],
62684=>[94.346,-78.814,51.600,1],
62685=>[94.362,-78.814,51.562,1],
62686=>[94.382,-78.824,51.525,1],
62687=>[94.401,-78.832,51.489,1],
62688=>[94.421,-78.829,51.454,1],
62689=>[94.445,-78.839,51.422,1],
62690=>[94.468,-78.849,51.391,1],
62691=>[94.491,-78.859,51.361,1],
62692=>[94.515,-78.876,51.330,1],
62693=>[94.536,-78.893,51.298,1],
62694=>[94.550,-78.901,51.265,1],
62695=>[94.569,-78.906,51.228,1],
62696=>[94.591,-78.908,51.190,1],
62697=>[94.607,-78.913,51.151,1],
62698=>[94.623,-78.918,51.114,1],
62699=>[94.639,-78.923,51.077,1],
62700=>[94.653,-78.924,51.041,1],
62701=>[94.664,-78.918,51.005,1],
62702=>[94.675,-78.912,50.964,1],
62703=>[94.686,-78.905,50.924,1],
62704=>[94.696,-78.899,50.886,1],
62705=>[94.707,-78.893,50.849,1],
62706=>[94.718,-78.886,50.811,1],
62707=>[94.729,-78.879,50.771,1],
62708=>[94.740,-78.873,50.731,1],
62709=>[94.750,-78.866,50.690,1],
62710=>[94.761,-78.860,50.650,1],
62711=>[94.772,-78.853,50.609,1],
62712=>[94.782,-78.847,50.568,1],
62713=>[94.793,-78.840,50.525,1],
62714=>[94.804,-78.833,50.483,1],
62715=>[94.815,-78.829,50.443,1],
62716=>[94.826,-78.825,50.402,1],
62717=>[94.835,-78.830,50.363,1],
62718=>[94.844,-78.838,50.325,1],
62719=>[94.852,-78.846,50.286,1],
62720=>[94.860,-78.853,50.248,1],
62721=>[94.871,-78.865,50.210,1],
62722=>[94.880,-78.881,50.172,1],
62723=>[94.887,-78.894,50.134,1],
62724=>[94.893,-78.907,50.096,1],
62725=>[94.899,-78.919,50.058,1],
62726=>[94.906,-78.932,50.020,1],
62727=>[94.909,-78.942,49.982,1],
62728=>[94.912,-78.950,49.945,1],
62729=>[94.914,-78.959,49.907,1],
62730=>[94.917,-78.966,49.869,1],
62731=>[94.919,-78.974,49.831,1],
62732=>[94.922,-78.983,49.791,1],
62733=>[94.924,-78.991,49.753,1],
62734=>[94.927,-78.999,49.715,1],
62735=>[94.929,-79.008,49.677,1],
62736=>[94.932,-79.016,49.639,1],
62737=>[94.934,-79.024,49.602,1],
62738=>[94.936,-79.032,49.566,1],
62739=>[94.939,-79.040,49.530,1],
62740=>[94.935,-79.076,49.496,1],
62741=>[94.929,-79.118,49.464,1],
62742=>[94.957,-79.129,49.432,1],
62743=>[94.989,-79.136,49.400,1],
62744=>[95.013,-79.143,49.368,1],
62745=>[95.030,-79.153,49.335,1],
62746=>[95.047,-79.162,49.302,1],
62747=>[95.063,-79.175,49.269,1],
62748=>[95.078,-79.190,49.235,1],
62749=>[95.094,-79.204,49.201,1],
62750=>[95.109,-79.219,49.166,1],
62751=>[95.126,-79.231,49.129,1],
62752=>[95.148,-79.241,49.090,1],
62753=>[95.170,-79.250,49.050,1],
62754=>[95.191,-79.259,49.009,1],
62755=>[95.212,-79.269,48.968,1],
62756=>[95.234,-79.278,48.928,1],
62757=>[95.254,-79.284,48.887,1],
62758=>[95.274,-79.288,48.845,1],
62759=>[95.294,-79.285,48.802,1],
62760=>[95.312,-79.279,48.759,1],
62761=>[95.330,-79.273,48.717,1],
62762=>[95.348,-79.267,48.674,1],
62763=>[95.366,-79.261,48.632,1],
62764=>[95.384,-79.255,48.588,1],
62765=>[95.398,-79.265,48.544,1],
62766=>[95.411,-79.280,48.501,1],
62767=>[95.424,-79.296,48.458,1],
62768=>[95.437,-79.312,48.416,1],
62769=>[95.450,-79.327,48.374,1],
62770=>[95.481,-79.335,48.331,1],
62771=>[95.520,-79.339,48.289,1],
62772=>[95.549,-79.332,48.247,1],
62773=>[95.571,-79.319,48.205,1],
62774=>[95.594,-79.306,48.166,1],
62775=>[95.616,-79.293,48.127,1],
62776=>[95.631,-79.285,48.087,1],
62777=>[95.641,-79.279,48.049,1],
62778=>[95.652,-79.273,48.010,1],
62779=>[95.662,-79.268,47.971,1],
62780=>[95.672,-79.263,47.932,1],
62781=>[95.683,-79.257,47.895,1],
62782=>[95.693,-79.251,47.857,1],
62783=>[95.703,-79.246,47.819,1],
62784=>[95.723,-79.247,47.780,1],
62785=>[95.757,-79.256,47.742,1],
62786=>[95.790,-79.266,47.705,1],
62787=>[95.812,-79.284,47.668,1],
62788=>[95.821,-79.312,47.632,1],
62789=>[95.831,-79.341,47.595,1],
62790=>[95.840,-79.359,47.557,1],
62791=>[95.869,-79.352,47.521,1],
62792=>[95.865,-79.308,47.485,1],
62793=>[95.861,-79.264,47.449,1],
62794=>[95.857,-79.220,47.413,1],
62795=>[95.853,-79.176,47.376,1],
62796=>[95.874,-79.164,47.341,1],
62797=>[95.921,-79.185,47.305,1],
62798=>[95.969,-79.206,47.270,1],
62799=>[96.017,-79.228,47.236,1],
62800=>[96.064,-79.250,47.201,1],
62801=>[96.112,-79.271,47.166,1],
62802=>[96.160,-79.293,47.132,1],
62803=>[96.207,-79.314,47.097,1],
62804=>[96.230,-79.322,47.062,1],
62805=>[96.250,-79.331,47.030,1],
62806=>[96.270,-79.339,46.997,1],
62807=>[96.291,-79.347,46.965,1],
62808=>[96.311,-79.356,46.932,1],
62809=>[96.331,-79.363,46.900,1],
62810=>[96.352,-79.372,46.868,1],
62811=>[96.372,-79.380,46.835,1],
62812=>[96.392,-79.388,46.805,1],
62813=>[96.413,-79.396,46.775,1],
62814=>[96.433,-79.404,46.745,1],
62815=>[96.454,-79.413,46.714,1],
62816=>[96.474,-79.421,46.684,1],
62817=>[96.494,-79.429,46.655,1],
62818=>[96.515,-79.438,46.626,1],
62819=>[96.536,-79.448,46.598,1],
62820=>[96.556,-79.459,46.571,1],
62821=>[96.577,-79.469,46.545,1],
62822=>[96.598,-79.479,46.519,1],
62823=>[96.619,-79.490,46.494,1],
62824=>[96.637,-79.498,46.470,1],
62825=>[96.646,-79.496,46.445,1],
62826=>[96.655,-79.494,46.422,1],
62827=>[96.677,-79.496,46.399,1],
62828=>[96.699,-79.498,46.376,1],
62829=>[96.722,-79.501,46.352,1],
62830=>[96.742,-79.484,46.328,1],
62831=>[96.760,-79.463,46.305,1],
62832=>[96.779,-79.442,46.281,1],
62833=>[96.798,-79.421,46.259,1],
62834=>[96.816,-79.400,46.239,1],
62835=>[96.849,-79.390,46.217,1],
62836=>[96.882,-79.379,46.195,1],
62837=>[96.924,-79.387,46.173,1],
62838=>[96.969,-79.400,46.148,1],
62839=>[97.011,-79.408,46.122,1],
62840=>[97.041,-79.382,46.098,1],
62841=>[97.072,-79.356,46.077,1],
62842=>[97.101,-79.338,46.056,1],
62843=>[97.114,-79.342,46.034,1],
62844=>[97.128,-79.347,46.011,1],
62845=>[97.142,-79.351,45.987,1],
62846=>[97.156,-79.356,45.963,1],
62847=>[97.169,-79.360,45.941,1],
62848=>[97.186,-79.364,45.919,1],
62849=>[97.208,-79.368,45.894,1],
62850=>[97.226,-79.374,45.870,1],
62851=>[97.251,-79.382,45.845,1],
62852=>[97.281,-79.389,45.820,1],
62853=>[97.296,-79.398,45.797,1],
62854=>[97.289,-79.407,45.774,1],
62855=>[97.282,-79.417,45.752,1],
62856=>[97.275,-79.427,45.731,1],
62857=>[97.267,-79.437,45.710,1],
62858=>[97.265,-79.437,45.689,1],
62859=>[97.271,-79.424,45.669,1],
62860=>[97.273,-79.422,45.649,1],
62861=>[97.272,-79.427,45.630,1],
62862=>[97.271,-79.432,45.613,1],
62863=>[97.269,-79.438,45.596,1],
62864=>[97.257,-79.457,45.578,1],
62865=>[97.239,-79.488,45.560,1],
62866=>[97.246,-79.495,45.543,1],
62867=>[97.253,-79.503,45.525,1],
62868=>[97.260,-79.510,45.507,1],
62869=>[97.267,-79.518,45.490,1],
62870=>[97.275,-79.526,45.473,1],
62871=>[97.282,-79.533,45.456,1],
62872=>[97.289,-79.541,45.438,1],
62873=>[97.296,-79.548,45.421,1],
62874=>[97.303,-79.557,45.403,1],
62875=>[97.310,-79.564,45.386,1],
62876=>[97.317,-79.572,45.369,1],
62877=>[97.324,-79.579,45.353,1],
62878=>[97.331,-79.587,45.337,1],
62879=>[97.338,-79.595,45.320,1],
62880=>[97.349,-79.604,45.304,1],
62881=>[97.368,-79.620,45.288,1],
62882=>[97.387,-79.635,45.272,1],
62883=>[97.406,-79.651,45.256,1],
62884=>[97.426,-79.666,45.241,1],
62931=>[98.327,-80.384,44.654,1],
62932=>[98.346,-80.399,44.646,1],
62933=>[98.365,-80.415,44.639,1],
62934=>[98.384,-80.430,44.632,1],
62935=>[98.404,-80.445,44.625,1],
62936=>[98.423,-80.460,44.618,1],
62937=>[98.442,-80.475,44.610,1],
62938=>[98.461,-80.491,44.603,1],
62939=>[98.480,-80.506,44.596,1],
62940=>[98.503,-80.513,44.590,1],
62941=>[98.528,-80.516,44.583,1],
62942=>[98.553,-80.518,44.576,1],
62943=>[98.577,-80.520,44.568,1],
62944=>[98.602,-80.523,44.560,1],
62945=>[98.627,-80.526,44.551,1],
62946=>[98.652,-80.529,44.544,1],
62947=>[98.676,-80.531,44.538,1],
62948=>[98.701,-80.533,44.531,1],
62949=>[98.726,-80.537,44.524,1],
62950=>[98.751,-80.541,44.516,1],
62951=>[98.777,-80.544,44.509,1],
62952=>[98.803,-80.548,44.503,1],
62953=>[98.828,-80.553,44.498,1],
62954=>[98.852,-80.562,44.492,1],
62955=>[98.875,-80.573,44.486,1],
62956=>[98.899,-80.583,44.481,1],
63280=>[93.336,-79.152,53.433,1],
63281=>[93.345,-79.150,53.418,1],
63282=>[93.355,-79.147,53.403,1],
63283=>[93.365,-79.144,53.389,1],
63284=>[93.374,-79.142,53.374,1],
63285=>[93.384,-79.140,53.359,1],
63286=>[93.394,-79.137,53.343,1],
63287=>[93.404,-79.134,53.330,1],
63288=>[93.413,-79.132,53.316,1],
63289=>[93.424,-79.123,53.301,1],
63290=>[93.436,-79.112,53.289,1],
63291=>[93.447,-79.102,53.275,1],
63292=>[93.455,-79.095,53.262,1],
63293=>[93.464,-79.088,53.251,1],
63294=>[93.472,-79.081,53.241,1],
63295=>[93.481,-79.074,53.234,1],
63296=>[93.489,-79.068,53.228,1],
63297=>[93.494,-79.073,53.226,1],
63298=>[93.500,-79.078,53.225,1],
63299=>[93.505,-79.083,53.226,1],
63300=>[93.524,-79.070,53.227,1],
63301=>[93.544,-79.058,53.227,1],
63302=>[93.562,-79.046,53.227,1],
63303=>[93.570,-79.050,53.225,1],
63304=>[93.578,-79.054,53.222,1],
63305=>[93.586,-79.059,53.218,1],
63306=>[93.601,-79.059,53.213,1],
63307=>[93.618,-79.058,53.206,1],
63308=>[93.635,-79.057,53.197,1],
63309=>[93.653,-79.056,53.187,1],
63310=>[93.671,-79.056,53.178,1],
63311=>[93.686,-79.056,53.164,1],
63312=>[93.701,-79.053,53.150,1],
63313=>[93.715,-79.049,53.135,1],
63314=>[93.730,-79.046,53.121,1],
63315=>[93.745,-79.042,53.106,1],
63316=>[93.759,-79.038,53.090,1],
63317=>[93.774,-79.035,53.077,1],
63318=>[93.788,-79.031,53.063,1],
63319=>[93.793,-79.030,53.049,1],
63320=>[93.797,-79.029,53.034,1],
63321=>[93.803,-79.027,53.021,1],
63322=>[93.812,-79.024,53.006,1],
63323=>[93.820,-79.021,52.990,1],
63324=>[93.828,-79.018,52.974,1],
63325=>[93.836,-79.015,52.958,1],
63326=>[93.844,-79.012,52.944,1],
63327=>[93.851,-79.010,52.931,1],
63328=>[93.859,-79.007,52.921,1],
63329=>[93.867,-79.004,52.910,1],
63330=>[93.874,-79.006,52.897,1],
63331=>[93.880,-79.009,52.883,1],
63332=>[93.883,-79.012,52.869,1],
63333=>[93.884,-79.015,52.855,1],
63334=>[93.885,-79.017,52.842,1],
63335=>[93.887,-79.020,52.828,1],
63336=>[93.889,-79.022,52.814,1],
63337=>[93.892,-79.024,52.799,1],
63338=>[93.895,-79.027,52.783,1],
63339=>[93.898,-79.029,52.767,1],
63340=>[93.901,-79.031,52.751,1],
63341=>[93.905,-79.040,52.735,1],
63342=>[93.909,-79.047,52.721,1],
63343=>[93.913,-79.056,52.708,1],
63344=>[93.915,-79.059,52.693,1],
63345=>[93.913,-79.056,52.680,1],
63346=>[93.929,-79.057,52.666,1],
63347=>[93.956,-79.059,52.651,1],
63348=>[93.981,-79.062,52.632,1],
63349=>[94.005,-79.062,52.612,1],
63350=>[94.006,-79.062,52.589,1],
63351=>[94.007,-79.059,52.562,1],
63352=>[94.008,-79.055,52.533,1],
63353=>[94.009,-79.052,52.504,1],
63354=>[94.010,-79.048,52.473,1],
63355=>[94.012,-79.044,52.439,1],
63356=>[94.013,-79.041,52.406,1],
63357=>[94.014,-79.037,52.372,1],
63358=>[94.015,-79.034,52.334,1],
63359=>[94.016,-79.031,52.300,1],
63360=>[94.017,-79.028,52.268,1],
63361=>[94.023,-79.024,52.238,1],
63362=>[94.031,-79.024,52.213,1],
63363=>[94.040,-79.022,52.191,1],
63364=>[94.048,-79.021,52.171,1],
63365=>[94.057,-79.018,52.149,1],
63366=>[94.067,-79.017,52.129,1],
63367=>[94.076,-79.015,52.109,1],
63368=>[94.085,-79.013,52.088,1],
63369=>[94.096,-79.009,52.066,1],
63370=>[94.113,-78.999,52.045,1],
63371=>[94.129,-78.990,52.024,1],
63372=>[94.146,-78.981,52.001,1],
63373=>[94.162,-78.971,51.977,1],
63374=>[94.183,-78.940,51.954,1],
63375=>[94.204,-78.909,51.932,1],
63376=>[94.226,-78.879,51.911,1],
63377=>[94.247,-78.849,51.888,1],
63378=>[94.268,-78.818,51.862,1],
63379=>[94.285,-78.808,51.828,1],
63380=>[94.300,-78.806,51.793,1],
63381=>[94.314,-78.809,51.757,1],
63382=>[94.327,-78.811,51.720,1],
63383=>[94.340,-78.814,51.684,1],
63384=>[94.352,-78.820,51.648,1],
63385=>[94.363,-78.824,51.613,1],
63386=>[94.363,-78.788,51.577,1],
63387=>[94.382,-78.796,51.540,1],
63388=>[94.402,-78.798,51.504,1],
63389=>[94.424,-78.808,51.470,1],
63390=>[94.448,-78.820,51.437,1],
63391=>[94.474,-78.845,51.406,1],
63392=>[94.500,-78.869,51.377,1],
63393=>[94.515,-78.877,51.346,1],
63394=>[94.530,-78.886,51.314,1],
63395=>[94.544,-78.894,51.281,1],
63396=>[94.558,-78.902,51.247,1],
63397=>[94.578,-78.906,51.210,1],
63398=>[94.601,-78.908,51.171,1],
63399=>[94.623,-78.910,51.134,1],
63400=>[94.642,-78.914,51.097,1],
63401=>[94.658,-78.918,51.062,1],
63402=>[94.671,-78.916,51.027,1],
63403=>[94.682,-78.910,50.988,1],
63404=>[94.692,-78.903,50.950,1],
63405=>[94.703,-78.897,50.912,1],
63406=>[94.714,-78.890,50.877,1],
63407=>[94.724,-78.884,50.839,1],
63408=>[94.736,-78.877,50.800,1],
63409=>[94.746,-78.871,50.760,1],
63410=>[94.757,-78.865,50.719,1],
63411=>[94.768,-78.858,50.677,1],
63412=>[94.778,-78.852,50.635,1],
63413=>[94.789,-78.845,50.593,1],
63414=>[94.800,-78.838,50.549,1],
63415=>[94.811,-78.832,50.505,1],
63416=>[94.822,-78.825,50.464,1],
63417=>[94.832,-78.819,50.425,1],
63418=>[94.843,-78.812,50.387,1],
63419=>[94.852,-78.820,50.349,1],
63420=>[94.856,-78.830,50.311,1],
63421=>[94.858,-78.838,50.272,1],
63422=>[94.861,-78.846,50.233,1],
63423=>[94.863,-78.855,50.194,1],
63424=>[94.866,-78.863,50.154,1],
63425=>[94.868,-78.871,50.115,1],
63426=>[94.871,-78.879,50.076,1],
63427=>[94.874,-78.887,50.037,1],
63428=>[94.876,-78.896,49.999,1],
63429=>[94.879,-78.904,49.962,1],
63430=>[94.881,-78.912,49.924,1],
63431=>[94.884,-78.921,49.886,1],
63432=>[94.886,-78.929,49.848,1],
63433=>[94.888,-78.937,49.809,1],
63434=>[94.891,-78.945,49.770,1],
63435=>[94.893,-78.953,49.732,1],
63436=>[94.896,-78.962,49.694,1],
63437=>[94.898,-78.970,49.657,1],
63438=>[94.897,-78.992,49.620,1],
63439=>[94.892,-79.034,49.585,1],
63440=>[94.886,-79.077,49.549,1],
63441=>[94.907,-79.093,49.515,1],
63442=>[94.939,-79.100,49.482,1],
63443=>[94.972,-79.107,49.449,1],
63444=>[94.997,-79.115,49.415,1],
63445=>[95.014,-79.124,49.382,1],
63446=>[95.031,-79.134,49.349,1],
63447=>[95.048,-79.143,49.315,1],
63448=>[95.064,-79.153,49.282,1],
63449=>[95.079,-79.168,49.249,1],
63450=>[95.095,-79.182,49.215,1],
63451=>[95.111,-79.197,49.178,1],
63452=>[95.130,-79.208,49.141,1],
63453=>[95.152,-79.217,49.102,1],
63454=>[95.174,-79.226,49.062,1],
63455=>[95.195,-79.235,49.021,1],
63456=>[95.216,-79.245,48.979,1],
63457=>[95.238,-79.254,48.938,1],
63458=>[95.261,-79.262,48.895,1],
63459=>[95.281,-79.266,48.853,1],
63460=>[95.298,-79.261,48.810,1],
63461=>[95.316,-79.255,48.766,1],
63462=>[95.334,-79.250,48.723,1],
63463=>[95.351,-79.244,48.680,1],
63464=>[95.370,-79.237,48.637,1],
63465=>[95.386,-79.236,48.593,1],
63466=>[95.399,-79.252,48.550,1],
63467=>[95.412,-79.267,48.507,1],
63468=>[95.425,-79.283,48.463,1],
63469=>[95.438,-79.299,48.420,1],
63470=>[95.451,-79.314,48.378,1],
63471=>[95.478,-79.324,48.335,1],
63472=>[95.517,-79.328,48.293,1],
63473=>[95.546,-79.322,48.252,1],
63474=>[95.568,-79.308,48.212,1],
63475=>[95.591,-79.295,48.172,1],
63476=>[95.613,-79.281,48.133,1],
63477=>[95.634,-79.269,48.093,1],
63478=>[95.644,-79.264,48.053,1],
63479=>[95.655,-79.259,48.014,1],
63480=>[95.665,-79.253,47.975,1],
63481=>[95.675,-79.247,47.936,1],
63482=>[95.685,-79.242,47.898,1],
63483=>[95.695,-79.237,47.859,1],
63484=>[95.705,-79.231,47.821,1],
63485=>[95.730,-79.234,47.782,1],
63486=>[95.763,-79.244,47.744,1],
63487=>[95.797,-79.253,47.707,1],
63488=>[95.825,-79.266,47.669,1],
63489=>[95.835,-79.294,47.632,1],
63490=>[95.844,-79.323,47.594,1],
63491=>[95.853,-79.351,47.556,1],
63492=>[95.858,-79.328,47.520,1],
63493=>[95.853,-79.285,47.483,1],
63494=>[95.849,-79.241,47.447,1],
63495=>[95.846,-79.197,47.411,1],
63496=>[95.842,-79.153,47.375,1],
63497=>[95.855,-79.130,47.339,1],
63498=>[95.902,-79.152,47.303,1],
63499=>[95.950,-79.173,47.267,1],
63500=>[95.997,-79.194,47.232,1],
63501=>[96.045,-79.216,47.197,1],
63502=>[96.093,-79.237,47.162,1],
63503=>[96.141,-79.259,47.128,1],
63504=>[96.188,-79.280,47.093,1],
63505=>[96.236,-79.302,47.058,1],
63506=>[96.262,-79.313,47.025,1],
63507=>[96.283,-79.321,46.993,1],
63508=>[96.303,-79.329,46.960,1],
63509=>[96.323,-79.337,46.927,1],
63510=>[96.343,-79.345,46.895,1],
63511=>[96.364,-79.353,46.863,1],
63512=>[96.384,-79.362,46.831,1],
63513=>[96.404,-79.369,46.800,1],
63514=>[96.425,-79.378,46.770,1],
63515=>[96.445,-79.386,46.740,1],
63516=>[96.466,-79.395,46.710,1],
63517=>[96.486,-79.406,46.680,1],
63518=>[96.508,-79.416,46.650,1],
63519=>[96.528,-79.426,46.621,1],
63520=>[96.549,-79.437,46.593,1],
63521=>[96.570,-79.447,46.565,1],
63522=>[96.591,-79.457,46.538,1],
63523=>[96.611,-79.468,46.512,1],
63524=>[96.625,-79.471,46.487,1],
63525=>[96.635,-79.469,46.462,1],
63526=>[96.644,-79.467,46.435,1],
63527=>[96.662,-79.468,46.411,1],
63528=>[96.684,-79.471,46.389,1],
63529=>[96.707,-79.473,46.365,1],
63530=>[96.730,-79.476,46.341,1],
63531=>[96.750,-79.460,46.316,1],
63532=>[96.768,-79.439,46.292,1],
63533=>[96.787,-79.419,46.268,1],
63534=>[96.806,-79.397,46.246,1],
63535=>[96.824,-79.376,46.225,1],
63536=>[96.843,-79.355,46.203,1],
63537=>[96.870,-79.341,46.181,1],
63538=>[96.903,-79.332,46.159,1],
63539=>[96.949,-79.344,46.136,1],
63540=>[96.994,-79.357,46.111,1],
63541=>[97.043,-79.347,46.088,1],
63542=>[97.058,-79.307,46.067,1],
63543=>[97.098,-79.323,46.047,1],
63544=>[97.113,-79.324,46.025,1],
63545=>[97.127,-79.325,46.002,1],
63546=>[97.141,-79.329,45.978,1],
63547=>[97.155,-79.334,45.954,1],
63548=>[97.169,-79.338,45.932,1],
63549=>[97.191,-79.342,45.912,1],
63550=>[97.213,-79.346,45.887,1],
63551=>[97.234,-79.353,45.864,1],
63552=>[97.264,-79.360,45.841,1],
63553=>[97.290,-79.371,45.817,1],
63554=>[97.307,-79.375,45.793,1],
63555=>[97.306,-79.386,45.771,1],
63556=>[97.299,-79.396,45.749,1],
63557=>[97.292,-79.406,45.729,1],
63558=>[97.285,-79.415,45.708,1],
63559=>[97.278,-79.425,45.688,1],
63560=>[97.271,-79.435,45.668,1],
63561=>[97.270,-79.432,45.648,1],
63562=>[97.276,-79.419,45.630,1],
63563=>[97.281,-79.408,45.613,1],
63564=>[97.280,-79.413,45.595,1],
63565=>[97.278,-79.418,45.577,1],
63566=>[97.277,-79.423,45.559,1],
63567=>[97.263,-79.445,45.542,1],
63568=>[97.253,-79.468,45.524,1],
63569=>[97.260,-79.476,45.507,1],
63570=>[97.267,-79.484,45.490,1],
63571=>[97.275,-79.491,45.473,1],
63572=>[97.282,-79.499,45.456,1],
63573=>[97.289,-79.507,45.439,1],
63574=>[97.296,-79.514,45.422,1],
63575=>[97.303,-79.522,45.404,1],
63576=>[97.310,-79.529,45.386,1],
63577=>[97.317,-79.537,45.370,1],
63578=>[97.324,-79.545,45.354,1],
63579=>[97.331,-79.552,45.338,1],
63580=>[97.338,-79.560,45.322,1],
63581=>[97.355,-79.573,45.306,1],
63582=>[97.374,-79.588,45.290,1],
63583=>[97.393,-79.604,45.274,1],
63584=>[97.412,-79.619,45.259,1],
63585=>[97.431,-79.635,45.244,1],
63586=>[97.450,-79.650,45.229,1],
63587=>[97.469,-79.665,45.213,1],
63588=>[97.489,-79.680,45.198,1],
63630=>[98.294,-80.322,44.680,1],
63631=>[98.313,-80.337,44.672,1],
63632=>[98.332,-80.353,44.662,1],
63633=>[98.351,-80.368,44.655,1],
63634=>[98.370,-80.383,44.648,1],
63635=>[98.390,-80.398,44.641,1],
63636=>[98.409,-80.414,44.634,1],
63637=>[98.428,-80.429,44.627,1],
63638=>[98.447,-80.444,44.619,1],
63639=>[98.466,-80.460,44.612,1],
63640=>[98.486,-80.475,44.605,1],
63641=>[98.508,-80.482,44.599,1],
63642=>[98.533,-80.484,44.592,1],
63643=>[98.558,-80.487,44.585,1],
63644=>[98.583,-80.489,44.578,1],
63645=>[98.607,-80.492,44.569,1],
63646=>[98.632,-80.494,44.560,1],
63647=>[98.657,-80.497,44.553,1],
63648=>[98.682,-80.500,44.547,1],
63649=>[98.707,-80.502,44.539,1],
63650=>[98.731,-80.505,44.532,1],
63651=>[98.757,-80.509,44.525,1],
63652=>[98.783,-80.513,44.518,1],
63653=>[98.808,-80.517,44.512,1],
63654=>[98.833,-80.524,44.506,1],
63655=>[98.856,-80.535,44.502,1],
63656=>[98.879,-80.545,44.496,1],
63657=>[98.903,-80.556,44.491,1],
63658=>[98.926,-80.566,44.485,1],
63983=>[93.355,-79.136,53.426,1],
63984=>[93.365,-79.134,53.412,1],
63985=>[93.374,-79.131,53.397,1],
63986=>[93.384,-79.128,53.382,1],
63987=>[93.394,-79.126,53.367,1],
63988=>[93.404,-79.124,53.353,1],
63989=>[93.413,-79.122,53.338,1],
63990=>[93.423,-79.118,53.325,1],
63991=>[93.434,-79.109,53.311,1],
63992=>[93.446,-79.098,53.297,1],
63993=>[93.457,-79.088,53.284,1],
63994=>[93.465,-79.081,53.272,1],
63995=>[93.474,-79.075,53.261,1],
63996=>[93.482,-79.068,53.252,1],
63997=>[93.490,-79.061,53.246,1],
63998=>[93.498,-79.053,53.240,1],
63999=>[93.505,-79.056,53.237,1],
64000=>[93.510,-79.061,53.237,1],
64001=>[93.515,-79.066,53.238,1],
64002=>[93.526,-79.065,53.239,1],
64003=>[93.546,-79.052,53.240,1],
64004=>[93.561,-79.044,53.240,1],
64005=>[93.569,-79.049,53.238,1],
64006=>[93.577,-79.053,53.235,1],
64007=>[93.594,-79.052,53.232,1],
64008=>[93.612,-79.051,53.225,1],
64009=>[93.629,-79.050,53.217,1],
64010=>[93.646,-79.049,53.207,1],
64011=>[93.664,-79.046,53.198,1],
64012=>[93.680,-79.043,53.185,1],
64013=>[93.694,-79.040,53.171,1],
64014=>[93.708,-79.037,53.155,1],
64015=>[93.723,-79.034,53.142,1],
64016=>[93.737,-79.030,53.128,1],
64017=>[93.752,-79.027,53.113,1],
64018=>[93.767,-79.023,53.101,1],
64019=>[93.782,-79.020,53.088,1],
64020=>[93.786,-79.018,53.075,1],
64021=>[93.791,-79.016,53.060,1],
64022=>[93.799,-79.014,53.046,1],
64023=>[93.807,-79.011,53.032,1],
64024=>[93.816,-79.008,53.017,1],
64025=>[93.824,-79.005,53.001,1],
64026=>[93.832,-79.002,52.987,1],
64027=>[93.839,-78.999,52.974,1],
64028=>[93.847,-78.996,52.961,1],
64029=>[93.855,-78.994,52.951,1],
64030=>[93.863,-78.991,52.941,1],
64031=>[93.871,-78.990,52.928,1],
64032=>[93.877,-78.993,52.914,1],
64033=>[93.880,-78.996,52.900,1],
64034=>[93.881,-78.999,52.885,1],
64035=>[93.882,-79.001,52.872,1],
64036=>[93.883,-79.003,52.858,1],
64037=>[93.884,-79.006,52.843,1],
64038=>[93.887,-79.009,52.826,1],
64039=>[93.890,-79.011,52.809,1],
64040=>[93.894,-79.013,52.791,1],
64041=>[93.897,-79.016,52.775,1],
64042=>[93.901,-79.024,52.758,1],
64043=>[93.905,-79.032,52.743,1],
64044=>[93.908,-79.039,52.727,1],
64045=>[93.906,-79.036,52.712,1],
64046=>[93.905,-79.033,52.697,1],
64047=>[93.926,-79.034,52.681,1],
64048=>[93.952,-79.037,52.665,1],
64049=>[93.978,-79.039,52.646,1],
64050=>[93.997,-79.043,52.626,1],
64051=>[94.008,-79.044,52.603,1],
64052=>[94.010,-79.038,52.576,1],
64053=>[94.012,-79.032,52.546,1],
64054=>[94.014,-79.026,52.517,1],
64055=>[94.016,-79.020,52.489,1],
64056=>[94.017,-79.015,52.456,1],
64057=>[94.018,-79.012,52.423,1],
64058=>[94.019,-79.009,52.388,1],
64059=>[94.020,-79.006,52.352,1],
64060=>[94.022,-79.002,52.319,1],
64061=>[94.023,-78.999,52.289,1],
64062=>[94.028,-78.996,52.260,1],
64063=>[94.037,-78.995,52.236,1],
64064=>[94.046,-78.993,52.214,1],
64065=>[94.055,-78.991,52.193,1],
64066=>[94.064,-78.989,52.170,1],
64067=>[94.073,-78.987,52.148,1],
64068=>[94.082,-78.986,52.126,1],
64069=>[94.092,-78.984,52.105,1],
64070=>[94.105,-78.977,52.083,1],
64071=>[94.121,-78.968,52.062,1],
64072=>[94.138,-78.959,52.042,1],
64073=>[94.154,-78.949,52.018,1],
64074=>[94.171,-78.939,51.995,1],
64075=>[94.188,-78.927,51.973,1],
64076=>[94.209,-78.897,51.951,1],
64077=>[94.230,-78.867,51.928,1],
64078=>[94.251,-78.836,51.903,1],
64079=>[94.272,-78.805,51.875,1],
64080=>[94.289,-78.800,51.842,1],
64081=>[94.305,-78.797,51.807,1],
64082=>[94.321,-78.795,51.770,1],
64083=>[94.335,-78.794,51.733,1],
64084=>[94.348,-78.797,51.698,1],
64085=>[94.360,-78.802,51.663,1],
64086=>[94.372,-78.807,51.628,1],
64087=>[94.380,-78.799,51.593,1],
64088=>[94.382,-78.767,51.557,1],
64089=>[94.407,-78.789,51.520,1],
64090=>[94.433,-78.814,51.487,1],
64091=>[94.460,-78.838,51.454,1],
64092=>[94.480,-78.854,51.422,1],
64093=>[94.494,-78.862,51.392,1],
64094=>[94.509,-78.871,51.361,1],
64095=>[94.525,-78.877,51.330,1],
64096=>[94.543,-78.881,51.298,1],
64097=>[94.562,-78.885,51.265,1],
64098=>[94.581,-78.890,51.228,1],
64099=>[94.600,-78.895,51.190,1],
64100=>[94.619,-78.899,51.153,1],
64101=>[94.638,-78.904,51.118,1],
64102=>[94.657,-78.909,51.083,1],
64103=>[94.677,-78.914,51.050,1],
64104=>[94.688,-78.907,51.012,1],
64105=>[94.698,-78.899,50.973,1],
64106=>[94.709,-78.892,50.934,1],
64107=>[94.719,-78.884,50.898,1],
64108=>[94.730,-78.877,50.862,1],
64109=>[94.741,-78.869,50.824,1],
64110=>[94.751,-78.861,50.784,1],
64111=>[94.762,-78.854,50.743,1],
64112=>[94.772,-78.846,50.701,1],
64113=>[94.782,-78.839,50.660,1],
64114=>[94.793,-78.831,50.617,1],
64115=>[94.804,-78.824,50.573,1],
64116=>[94.814,-78.816,50.529,1],
64117=>[94.821,-78.812,50.487,1],
64118=>[94.825,-78.811,50.450,1],
64119=>[94.834,-78.812,50.414,1],
64120=>[94.857,-78.814,50.378,1],
64121=>[94.855,-78.815,50.339,1],
64122=>[94.849,-78.814,50.299,1],
64123=>[94.843,-78.814,50.259,1],
64124=>[94.836,-78.814,50.217,1],
64125=>[94.833,-78.817,50.176,1],
64126=>[94.835,-78.825,50.135,1],
64127=>[94.838,-78.833,50.095,1],
64128=>[94.840,-78.842,50.056,1],
64129=>[94.842,-78.849,50.017,1],
64130=>[94.845,-78.858,49.980,1],
64131=>[94.847,-78.866,49.943,1],
64132=>[94.850,-78.874,49.904,1],
64133=>[94.852,-78.883,49.865,1],
64134=>[94.855,-78.891,49.827,1],
64135=>[94.857,-78.899,49.788,1],
64136=>[94.859,-78.908,49.750,1],
64137=>[94.854,-78.950,49.712,1],
64138=>[94.848,-78.993,49.675,1],
64139=>[94.845,-79.032,49.638,1],
64140=>[94.854,-79.059,49.603,1],
64141=>[94.889,-79.065,49.569,1],
64142=>[94.922,-79.071,49.534,1],
64143=>[94.954,-79.078,49.499,1],
64144=>[94.982,-79.085,49.465,1],
64145=>[94.998,-79.095,49.431,1],
64146=>[95.016,-79.104,49.398,1],
64147=>[95.032,-79.114,49.365,1],
64148=>[95.049,-79.124,49.331,1],
64149=>[95.065,-79.133,49.297,1],
64150=>[95.081,-79.146,49.263,1],
64151=>[95.097,-79.161,49.229,1],
64152=>[95.113,-79.175,49.192,1],
64153=>[95.134,-79.184,49.153,1],
64154=>[95.156,-79.194,49.114,1],
64155=>[95.177,-79.203,49.074,1],
64156=>[95.199,-79.212,49.032,1],
64157=>[95.222,-79.220,48.990,1],
64158=>[95.247,-79.225,48.947,1],
64159=>[95.273,-79.228,48.904,1],
64160=>[95.296,-79.233,48.861,1],
64161=>[95.301,-79.237,48.817,1],
64162=>[95.319,-79.231,48.773,1],
64163=>[95.337,-79.225,48.730,1],
64164=>[95.355,-79.219,48.686,1],
64165=>[95.373,-79.213,48.643,1],
64166=>[95.387,-79.223,48.599,1],
64167=>[95.400,-79.239,48.555,1],
64168=>[95.413,-79.255,48.512,1],
64169=>[95.426,-79.270,48.468,1],
64170=>[95.439,-79.286,48.425,1],
64171=>[95.452,-79.302,48.383,1],
64172=>[95.475,-79.313,48.340,1],
64173=>[95.515,-79.317,48.299,1],
64174=>[95.543,-79.310,48.258,1],
64175=>[95.565,-79.297,48.219,1],
64176=>[95.588,-79.284,48.178,1],
64177=>[95.610,-79.271,48.138,1],
64178=>[95.633,-79.257,48.097,1],
64179=>[95.647,-79.250,48.057,1],
64180=>[95.657,-79.244,48.018,1],
64181=>[95.667,-79.238,47.979,1],
64182=>[95.678,-79.233,47.940,1],
64183=>[95.688,-79.228,47.901,1],
64184=>[95.698,-79.222,47.862,1],
64185=>[95.708,-79.216,47.823,1],
64186=>[95.736,-79.222,47.785,1],
64187=>[95.770,-79.231,47.746,1],
64188=>[95.804,-79.241,47.708,1],
64189=>[95.837,-79.250,47.670,1],
64190=>[95.848,-79.278,47.632,1],
64191=>[95.858,-79.306,47.594,1],
64192=>[95.866,-79.332,47.556,1],
64193=>[95.861,-79.310,47.519,1],
64194=>[95.843,-79.262,47.483,1],
64195=>[95.838,-79.218,47.446,1],
64196=>[95.835,-79.174,47.411,1],
64197=>[95.831,-79.130,47.375,1],
64198=>[95.835,-79.096,47.339,1],
64199=>[95.883,-79.118,47.302,1],
64200=>[95.931,-79.140,47.266,1],
64201=>[95.978,-79.161,47.230,1],
64202=>[96.026,-79.182,47.195,1],
64203=>[96.074,-79.204,47.159,1],
64204=>[96.121,-79.225,47.124,1],
64205=>[96.169,-79.247,47.089,1],
64206=>[96.217,-79.268,47.055,1],
64207=>[96.264,-79.290,47.021,1],
64208=>[96.295,-79.303,46.988,1],
64209=>[96.315,-79.310,46.955,1],
64210=>[96.335,-79.319,46.922,1],
64211=>[96.356,-79.327,46.890,1],
64212=>[96.376,-79.335,46.858,1],
64213=>[96.396,-79.343,46.826,1],
64214=>[96.417,-79.353,46.795,1],
64215=>[96.438,-79.363,46.765,1],
64216=>[96.459,-79.373,46.735,1],
64217=>[96.479,-79.384,46.705,1],
64218=>[96.500,-79.394,46.675,1],
64219=>[96.521,-79.404,46.645,1],
64220=>[96.542,-79.415,46.616,1],
64221=>[96.562,-79.426,46.588,1],
64222=>[96.583,-79.435,46.560,1],
64223=>[96.604,-79.446,46.532,1],
64224=>[96.614,-79.444,46.506,1],
64225=>[96.623,-79.443,46.479,1],
64226=>[96.631,-79.441,46.454,1],
64227=>[96.647,-79.441,46.426,1],
64228=>[96.669,-79.443,46.402,1],
64229=>[96.692,-79.445,46.379,1],
64230=>[96.715,-79.448,46.355,1],
64231=>[96.738,-79.451,46.331,1],
64232=>[96.758,-79.437,46.306,1],
64233=>[96.777,-79.416,46.280,1],
64234=>[96.795,-79.395,46.256,1],
64235=>[96.814,-79.374,46.233,1],
64236=>[96.832,-79.353,46.212,1],
64237=>[96.851,-79.332,46.190,1],
64238=>[96.870,-79.311,46.168,1],
64239=>[96.892,-79.293,46.147,1],
64240=>[96.928,-79.289,46.125,1],
64241=>[96.974,-79.301,46.100,1],
64242=>[97.007,-79.277,46.078,1],
64243=>[97.056,-79.294,46.058,1],
64244=>[97.094,-79.312,46.037,1],
64245=>[97.109,-79.313,46.015,1],
64246=>[97.124,-79.313,45.992,1],
64247=>[97.139,-79.314,45.968,1],
64248=>[97.154,-79.315,45.945,1],
64249=>[97.174,-79.316,45.924,1],
64250=>[97.196,-79.320,45.904,1],
64251=>[97.218,-79.324,45.880,1],
64252=>[97.220,-79.350,45.859,1],
64253=>[97.209,-79.381,45.837,1],
64254=>[97.246,-79.363,45.814,1],
64255=>[97.280,-79.353,45.790,1],
64256=>[97.296,-79.357,45.768,1],
64257=>[97.300,-79.370,45.747,1],
64258=>[97.304,-79.382,45.726,1],
64259=>[97.302,-79.394,45.707,1],
64260=>[97.295,-79.404,45.687,1],
64261=>[97.288,-79.413,45.667,1],
64262=>[97.281,-79.422,45.647,1],
64263=>[97.274,-79.432,45.629,1],
64264=>[97.274,-79.428,45.613,1],
64265=>[97.280,-79.415,45.595,1],
64266=>[97.285,-79.403,45.577,1],
64267=>[97.288,-79.399,45.559,1],
64268=>[97.286,-79.404,45.542,1],
64269=>[97.285,-79.409,45.524,1],
64270=>[97.269,-79.434,45.506,1],
64271=>[97.267,-79.449,45.490,1],
64272=>[97.275,-79.457,45.473,1],
64273=>[97.282,-79.464,45.456,1],
64274=>[97.289,-79.472,45.439,1],
64275=>[97.296,-79.479,45.422,1],
64276=>[97.303,-79.487,45.405,1],
64277=>[97.310,-79.494,45.387,1],
64278=>[97.317,-79.503,45.372,1],
64279=>[97.324,-79.510,45.355,1],
64280=>[97.331,-79.518,45.339,1],
64281=>[97.341,-79.527,45.325,1],
64282=>[97.360,-79.542,45.308,1],
64283=>[97.379,-79.557,45.292,1],
64284=>[97.398,-79.573,45.277,1],
64285=>[97.418,-79.588,45.261,1],
64286=>[97.437,-79.603,45.247,1],
64287=>[97.456,-79.618,45.232,1],
64288=>[97.475,-79.634,45.216,1],
64289=>[97.494,-79.649,45.202,1],
64290=>[97.513,-79.664,45.187,1],
64291=>[97.532,-79.679,45.172,1],
64292=>[97.551,-79.695,45.158,1],
64329=>[98.261,-80.260,44.706,1],
64330=>[98.280,-80.275,44.697,1],
64331=>[98.299,-80.291,44.689,1],
64332=>[98.318,-80.306,44.680,1],
64333=>[98.338,-80.322,44.671,1],
64334=>[98.357,-80.337,44.664,1],
64335=>[98.376,-80.352,44.657,1],
64336=>[98.395,-80.367,44.650,1],
64337=>[98.414,-80.382,44.643,1],
64338=>[98.433,-80.398,44.636,1],
64339=>[98.452,-80.413,44.629,1],
64340=>[98.472,-80.428,44.621,1],
64341=>[98.491,-80.444,44.615,1],
64342=>[98.514,-80.450,44.609,1],
64343=>[98.538,-80.453,44.602,1],
64344=>[98.564,-80.455,44.595,1],
64345=>[98.588,-80.458,44.587,1],
64346=>[98.613,-80.460,44.578,1],
64347=>[98.638,-80.463,44.569,1],
64348=>[98.662,-80.466,44.562,1],
64349=>[98.687,-80.468,44.556,1],
64350=>[98.712,-80.471,44.549,1],
64351=>[98.737,-80.474,44.542,1],
64352=>[98.763,-80.478,44.535,1],
64353=>[98.788,-80.482,44.528,1],
64354=>[98.813,-80.486,44.521,1],
64355=>[98.837,-80.497,44.515,1],
64356=>[98.860,-80.507,44.510,1],
64357=>[98.883,-80.518,44.505,1],
64358=>[98.907,-80.529,44.499,1],
64359=>[98.930,-80.539,44.493,1],
64360=>[98.953,-80.549,44.488,1],
64686=>[93.375,-79.120,53.420,1],
64687=>[93.384,-79.118,53.405,1],
64688=>[93.394,-79.115,53.390,1],
64689=>[93.404,-79.112,53.376,1],
64690=>[93.414,-79.110,53.362,1],
64691=>[93.423,-79.108,53.348,1],
64692=>[93.433,-79.105,53.333,1],
64693=>[93.444,-79.094,53.319,1],
64694=>[93.456,-79.084,53.306,1],
64695=>[93.466,-79.075,53.294,1],
64696=>[93.475,-79.068,53.283,1],
64697=>[93.483,-79.061,53.273,1],
64698=>[93.491,-79.054,53.265,1],
64699=>[93.500,-79.047,53.258,1],
64700=>[93.508,-79.040,53.253,1],
64701=>[93.515,-79.039,53.250,1],
64702=>[93.520,-79.044,53.249,1],
64703=>[93.526,-79.049,53.249,1],
64704=>[93.532,-79.054,53.251,1],
64705=>[93.547,-79.046,53.253,1],
64706=>[93.560,-79.043,53.254,1],
64707=>[93.570,-79.046,53.253,1],
64708=>[93.587,-79.045,53.250,1],
64709=>[93.605,-79.044,53.243,1],
64710=>[93.624,-79.040,53.235,1],
64711=>[93.643,-79.034,53.226,1],
64712=>[93.661,-79.030,53.217,1],
64713=>[93.675,-79.028,53.205,1],
64714=>[93.689,-79.025,53.191,1],
64715=>[93.703,-79.023,53.176,1],
64716=>[93.716,-79.021,53.164,1],
64717=>[93.730,-79.018,53.151,1],
64718=>[93.746,-79.015,53.138,1],
64719=>[93.760,-79.011,53.126,1],
64720=>[93.775,-79.008,53.114,1],
64721=>[93.779,-79.006,53.101,1],
64722=>[93.787,-79.003,53.087,1],
64723=>[93.795,-79.000,53.073,1],
64724=>[93.803,-78.998,53.058,1],
64725=>[93.812,-78.995,53.044,1],
64726=>[93.820,-78.992,53.029,1],
64727=>[93.827,-78.990,53.016,1],
64728=>[93.835,-78.987,53.004,1],
64729=>[93.843,-78.984,52.992,1],
64730=>[93.851,-78.981,52.982,1],
64731=>[93.859,-78.978,52.971,1],
64732=>[93.867,-78.975,52.959,1],
64733=>[93.874,-78.977,52.945,1],
64734=>[93.876,-78.980,52.931,1],
64735=>[93.877,-78.983,52.916,1],
64736=>[93.879,-78.985,52.901,1],
64737=>[93.880,-78.987,52.887,1],
64738=>[93.881,-78.990,52.872,1],
64739=>[93.883,-78.992,52.855,1],
64740=>[93.886,-78.995,52.837,1],
64741=>[93.889,-78.997,52.819,1],
64742=>[93.892,-79.001,52.802,1],
64743=>[93.896,-79.009,52.784,1],
64744=>[93.900,-79.017,52.766,1],
64745=>[93.899,-79.015,52.749,1],
64746=>[93.898,-79.012,52.731,1],
64747=>[93.897,-79.009,52.714,1],
64748=>[93.923,-79.012,52.696,1],
64749=>[93.949,-79.014,52.677,1],
64750=>[93.968,-79.019,52.658,1],
64751=>[93.985,-79.024,52.637,1],
64752=>[94.003,-79.029,52.615,1],
64753=>[94.009,-79.027,52.588,1],
64754=>[94.011,-79.021,52.559,1],
64755=>[94.013,-79.015,52.530,1],
64756=>[94.015,-79.009,52.502,1],
64757=>[94.017,-79.002,52.471,1],
64758=>[94.019,-78.996,52.439,1],
64759=>[94.022,-78.990,52.406,1],
64760=>[94.024,-78.984,52.372,1],
64761=>[94.026,-78.978,52.341,1],
64762=>[94.028,-78.972,52.311,1],
64763=>[94.034,-78.967,52.284,1],
64764=>[94.044,-78.965,52.261,1],
64765=>[94.053,-78.963,52.239,1],
64766=>[94.062,-78.962,52.216,1],
64767=>[94.071,-78.959,52.192,1],
64768=>[94.080,-78.958,52.168,1],
64769=>[94.089,-78.956,52.144,1],
64770=>[94.099,-78.954,52.123,1],
64771=>[94.114,-78.946,52.102,1],
64772=>[94.130,-78.937,52.081,1],
64773=>[94.146,-78.927,52.061,1],
64774=>[94.163,-78.917,52.037,1],
64775=>[94.180,-78.907,52.014,1],
64776=>[94.196,-78.897,51.993,1],
64777=>[94.213,-78.885,51.969,1],
64778=>[94.235,-78.855,51.945,1],
64779=>[94.256,-78.824,51.919,1],
64780=>[94.276,-78.796,51.889,1],
64781=>[94.292,-78.793,51.856,1],
64782=>[94.308,-78.789,51.821,1],
64783=>[94.324,-78.786,51.784,1],
64784=>[94.340,-78.784,51.748,1],
64785=>[94.356,-78.781,51.714,1],
64786=>[94.368,-78.786,51.680,1],
64787=>[94.379,-78.793,51.646,1],
64788=>[94.391,-78.802,51.610,1],
64789=>[94.395,-78.786,51.574,1],
64790=>[94.419,-78.807,51.538,1],
64791=>[94.445,-78.830,51.503,1],
64792=>[94.459,-78.839,51.470,1],
64793=>[94.475,-78.845,51.439,1],
64794=>[94.494,-78.849,51.408,1],
64795=>[94.512,-78.853,51.377,1],
64796=>[94.531,-78.857,51.346,1],
64797=>[94.550,-78.861,51.315,1],
64798=>[94.568,-78.865,51.282,1],
64799=>[94.587,-78.870,51.246,1],
64800=>[94.607,-78.874,51.209,1],
64801=>[94.626,-78.880,51.172,1],
64802=>[94.645,-78.884,51.137,1],
64803=>[94.663,-78.888,51.103,1],
64804=>[94.677,-78.889,51.070,1],
64805=>[94.690,-78.885,51.034,1],
64806=>[94.700,-78.877,50.995,1],
64807=>[94.711,-78.870,50.957,1],
64808=>[94.721,-78.862,50.921,1],
64809=>[94.732,-78.855,50.885,1],
64810=>[94.742,-78.847,50.847,1],
64811=>[94.753,-78.839,50.807,1],
64812=>[94.763,-78.832,50.765,1],
64813=>[94.774,-78.824,50.723,1],
64814=>[94.784,-78.817,50.681,1],
64815=>[94.789,-78.815,50.638,1],
64816=>[94.793,-78.814,50.594,1],
64817=>[94.797,-78.814,50.550,1],
64818=>[94.801,-78.813,50.507,1],
64819=>[94.805,-78.813,50.469,1],
64820=>[94.827,-78.815,50.434,1],
64821=>[94.850,-78.818,50.399,1],
64822=>[94.874,-78.821,50.362,1],
64823=>[94.871,-78.821,50.324,1],
64824=>[94.864,-78.821,50.285,1],
64825=>[94.858,-78.821,50.243,1],
64826=>[94.851,-78.821,50.200,1],
64827=>[94.845,-78.820,50.158,1],
64828=>[94.839,-78.820,50.116,1],
64829=>[94.832,-78.820,50.076,1],
64830=>[94.826,-78.820,50.037,1],
64831=>[94.820,-78.820,49.999,1],
64832=>[94.814,-78.820,49.961,1],
64833=>[94.817,-78.828,49.924,1],
64834=>[94.819,-78.836,49.886,1],
64835=>[94.817,-78.866,49.847,1],
64836=>[94.824,-78.895,49.809,1],
64837=>[94.832,-78.923,49.771,1],
64838=>[94.840,-78.951,49.733,1],
64839=>[94.848,-78.979,49.694,1],
64840=>[94.856,-79.007,49.658,1],
64841=>[94.863,-79.035,49.623,1],
64842=>[94.896,-79.045,49.588,1],
64843=>[94.935,-79.049,49.553,1],
64844=>[94.966,-79.056,49.518,1],
64845=>[94.983,-79.065,49.485,1],
64846=>[95.000,-79.075,49.452,1],
64847=>[95.017,-79.085,49.419,1],
64848=>[95.033,-79.094,49.386,1],
64849=>[95.050,-79.104,49.352,1],
64850=>[95.066,-79.113,49.316,1],
64851=>[95.083,-79.125,49.280,1],
64852=>[95.098,-79.139,49.243,1],
64853=>[95.117,-79.151,49.206,1],
64854=>[95.138,-79.160,49.167,1],
64855=>[95.160,-79.169,49.126,1],
64856=>[95.182,-79.178,49.085,1],
64857=>[95.207,-79.183,49.043,1],
64858=>[95.233,-79.187,49.000,1],
64859=>[95.259,-79.191,48.957,1],
64860=>[95.284,-79.196,48.913,1],
64861=>[95.310,-79.200,48.869,1],
64862=>[95.314,-79.206,48.824,1],
64863=>[95.323,-79.208,48.781,1],
64864=>[95.341,-79.202,48.737,1],
64865=>[95.358,-79.196,48.694,1],
64866=>[95.376,-79.195,48.650,1],
64867=>[95.388,-79.211,48.606,1],
64868=>[95.401,-79.226,48.562,1],
64869=>[95.414,-79.242,48.517,1],
64870=>[95.427,-79.258,48.474,1],
64871=>[95.440,-79.273,48.431,1],
64872=>[95.453,-79.289,48.389,1],
64873=>[95.472,-79.302,48.348,1],
64874=>[95.512,-79.306,48.306,1],
64875=>[95.540,-79.299,48.265,1],
64876=>[95.562,-79.285,48.225,1],
64877=>[95.585,-79.272,48.184,1],
64878=>[95.607,-79.259,48.142,1],
64879=>[95.630,-79.246,48.100,1],
64880=>[95.650,-79.234,48.060,1],
64881=>[95.660,-79.229,48.020,1],
64882=>[95.670,-79.224,47.981,1],
64883=>[95.680,-79.218,47.943,1],
64884=>[95.690,-79.212,47.904,1],
64885=>[95.700,-79.207,47.865,1],
64886=>[95.711,-79.202,47.826,1],
64887=>[95.743,-79.210,47.787,1],
64888=>[95.776,-79.219,47.748,1],
64889=>[95.810,-79.228,47.710,1],
64890=>[95.844,-79.238,47.672,1],
64891=>[95.862,-79.260,47.634,1],
64892=>[95.871,-79.288,47.595,1],
64893=>[95.875,-79.297,47.557,1],
64894=>[95.870,-79.278,47.520,1],
64895=>[95.861,-79.247,47.484,1],
64896=>[95.843,-79.200,47.448,1],
64897=>[95.825,-79.151,47.412,1],
64898=>[95.820,-79.106,47.376,1],
64899=>[95.816,-79.063,47.340,1],
64900=>[95.864,-79.084,47.303,1],
64901=>[95.911,-79.106,47.266,1],
64902=>[95.959,-79.128,47.230,1],
64903=>[96.007,-79.149,47.194,1],
64904=>[96.054,-79.170,47.158,1],
64905=>[96.102,-79.192,47.122,1],
64906=>[96.150,-79.213,47.087,1],
64907=>[96.197,-79.234,47.052,1],
64908=>[96.245,-79.256,47.017,1],
64909=>[96.293,-79.278,46.984,1],
64910=>[96.327,-79.292,46.951,1],
64911=>[96.347,-79.300,46.918,1],
64912=>[96.368,-79.310,46.885,1],
64913=>[96.389,-79.320,46.853,1],
64914=>[96.409,-79.331,46.821,1],
64915=>[96.431,-79.341,46.791,1],
64916=>[96.451,-79.351,46.760,1],
64917=>[96.472,-79.362,46.730,1],
64918=>[96.493,-79.372,46.700,1],
64919=>[96.514,-79.382,46.671,1],
64920=>[96.534,-79.393,46.641,1],
64921=>[96.555,-79.404,46.612,1],
64922=>[96.576,-79.414,46.584,1],
64923=>[96.593,-79.420,46.556,1],
64924=>[96.602,-79.418,46.527,1],
64925=>[96.611,-79.416,46.500,1],
64926=>[96.620,-79.414,46.473,1],
64927=>[96.631,-79.413,46.445,1],
64928=>[96.654,-79.416,46.418,1],
64929=>[96.677,-79.418,46.393,1],
64930=>[96.700,-79.420,46.369,1],
64931=>[96.723,-79.423,46.345,1],
64932=>[96.745,-79.426,46.321,1],
64933=>[96.765,-79.413,46.297,1],
64934=>[96.784,-79.393,46.271,1],
64935=>[96.803,-79.372,46.246,1],
64936=>[96.821,-79.350,46.223,1],
64937=>[96.840,-79.329,46.201,1],
64938=>[96.859,-79.309,46.179,1],
64939=>[96.877,-79.288,46.159,1],
64940=>[96.896,-79.266,46.137,1],
64941=>[96.914,-79.245,46.115,1],
64942=>[96.955,-79.245,46.091,1],
64943=>[97.000,-79.255,46.069,1],
64944=>[97.058,-79.287,46.047,1],
64945=>[97.091,-79.300,46.026,1],
64946=>[97.105,-79.301,46.005,1],
64947=>[97.120,-79.302,45.983,1],
64948=>[97.135,-79.303,45.961,1],
64949=>[97.157,-79.304,45.939,1],
64950=>[97.179,-79.306,45.919,1],
64951=>[97.197,-79.307,45.898,1],
64952=>[97.205,-79.313,45.875,1],
64953=>[97.171,-79.351,45.854,1],
64954=>[97.180,-79.355,45.832,1],
64955=>[97.215,-79.345,45.809,1],
64956=>[97.249,-79.335,45.786,1],
64957=>[97.282,-79.327,45.764,1],
64958=>[97.286,-79.340,45.744,1],
64959=>[97.290,-79.352,45.724,1],
64960=>[97.294,-79.365,45.705,1],
64961=>[97.298,-79.378,45.685,1],
64962=>[97.302,-79.391,45.666,1],
64963=>[97.298,-79.401,45.647,1],
64964=>[97.291,-79.411,45.629,1],
64965=>[97.284,-79.420,45.612,1],
64966=>[97.277,-79.430,45.594,1],
64967=>[97.279,-79.423,45.576,1],
64968=>[97.284,-79.410,45.560,1],
64969=>[97.290,-79.398,45.542,1],
64970=>[97.295,-79.385,45.524,1],
64971=>[97.294,-79.390,45.507,1],
64972=>[97.293,-79.395,45.489,1],
64973=>[97.276,-79.422,45.474,1],
64974=>[97.282,-79.430,45.457,1],
64975=>[97.289,-79.438,45.440,1],
64976=>[97.296,-79.445,45.423,1],
64977=>[97.303,-79.453,45.405,1],
64978=>[97.310,-79.460,45.389,1],
64979=>[97.317,-79.468,45.373,1],
64980=>[97.324,-79.476,45.357,1],
64981=>[97.331,-79.483,45.341,1],
64982=>[97.346,-79.495,45.326,1],
64983=>[97.365,-79.511,45.311,1],
64984=>[97.384,-79.526,45.295,1],
64985=>[97.403,-79.541,45.280,1],
64986=>[97.423,-79.557,45.265,1],
64987=>[97.442,-79.572,45.250,1],
64988=>[97.461,-79.587,45.235,1],
64989=>[97.480,-79.602,45.220,1],
64990=>[97.500,-79.618,45.205,1],
64991=>[97.519,-79.633,45.191,1],
64992=>[97.538,-79.648,45.176,1],
64993=>[97.557,-79.664,45.163,1],
64994=>[97.576,-79.679,45.149,1],
64995=>[97.595,-79.694,45.135,1],
64996=>[97.614,-79.710,45.121,1],
64997=>[97.634,-79.725,45.107,1],
65028=>[98.228,-80.199,44.732,1],
65029=>[98.247,-80.214,44.724,1],
65030=>[98.266,-80.229,44.714,1],
65031=>[98.286,-80.244,44.706,1],
65032=>[98.305,-80.259,44.697,1],
65033=>[98.324,-80.275,44.689,1],
65034=>[98.343,-80.290,44.681,1],
65035=>[98.362,-80.306,44.673,1],
65036=>[98.381,-80.321,44.666,1],
65037=>[98.401,-80.336,44.659,1],
65038=>[98.420,-80.351,44.653,1],
65039=>[98.439,-80.366,44.646,1],
65040=>[98.458,-80.382,44.638,1],
65041=>[98.477,-80.397,44.631,1],
65042=>[98.496,-80.413,44.625,1],
65043=>[98.519,-80.419,44.618,1],
65044=>[98.544,-80.422,44.611,1],
65045=>[98.569,-80.424,44.604,1],
65046=>[98.593,-80.427,44.597,1],
65047=>[98.619,-80.429,44.588,1],
65048=>[98.643,-80.431,44.579,1],
65049=>[98.668,-80.435,44.572,1],
65050=>[98.693,-80.437,44.565,1],
65051=>[98.717,-80.440,44.558,1],
65052=>[98.742,-80.442,44.551,1],
65053=>[98.768,-80.447,44.544,1],
65054=>[98.793,-80.450,44.538,1],
65055=>[98.817,-80.459,44.531,1],
65056=>[98.841,-80.469,44.525,1],
65057=>[98.864,-80.480,44.519,1],
65058=>[98.887,-80.491,44.514,1],
65059=>[98.911,-80.501,44.508,1],
65060=>[98.934,-80.512,44.503,1],
65061=>[98.957,-80.522,44.497,1],
65062=>[98.981,-80.532,44.491,1],
65388=>[93.385,-79.106,53.428,1],
65389=>[93.395,-79.104,53.413,1],
65390=>[93.404,-79.102,53.399,1],
65391=>[93.414,-79.100,53.385,1],
65392=>[93.424,-79.096,53.371,1],
65393=>[93.433,-79.094,53.356,1],
65394=>[93.443,-79.090,53.342,1],
65395=>[93.454,-79.080,53.329,1],
65396=>[93.466,-79.070,53.316,1],
65397=>[93.476,-79.062,53.305,1],
65398=>[93.484,-79.055,53.294,1],
65399=>[93.492,-79.047,53.285,1],
65400=>[93.501,-79.040,53.277,1],
65401=>[93.509,-79.034,53.270,1],
65402=>[93.517,-79.027,53.266,1],
65403=>[93.525,-79.022,53.263,1],
65404=>[93.531,-79.027,53.263,1],
65405=>[93.536,-79.032,53.264,1],
65406=>[93.542,-79.037,53.268,1],
65407=>[93.549,-79.040,53.270,1],
65408=>[93.564,-79.039,53.271,1],
65409=>[93.583,-79.034,53.268,1],
65410=>[93.602,-79.028,53.262,1],
65411=>[93.621,-79.024,53.254,1],
65412=>[93.640,-79.018,53.244,1],
65413=>[93.656,-79.015,53.235,1],
65414=>[93.671,-79.012,53.223,1],
65415=>[93.684,-79.010,53.211,1],
65416=>[93.698,-79.008,53.199,1],
65417=>[93.712,-79.006,53.187,1],
65418=>[93.726,-79.003,53.176,1],
65419=>[93.740,-79.001,53.164,1],
65420=>[93.754,-78.999,53.153,1],
65421=>[93.768,-78.996,53.141,1],
65422=>[93.775,-78.993,53.128,1],
65423=>[93.783,-78.990,53.114,1],
65424=>[93.791,-78.987,53.101,1],
65425=>[93.799,-78.985,53.087,1],
65426=>[93.807,-78.982,53.072,1],
65427=>[93.815,-78.979,53.058,1],
65428=>[93.823,-78.977,53.046,1],
65429=>[93.831,-78.974,53.035,1],
65430=>[93.839,-78.971,53.024,1],
65431=>[93.847,-78.968,53.013,1],
65432=>[93.855,-78.965,53.001,1],
65433=>[93.863,-78.962,52.989,1],
65434=>[93.871,-78.961,52.976,1],
65435=>[93.873,-78.964,52.962,1],
65436=>[93.874,-78.966,52.947,1],
65437=>[93.875,-78.968,52.931,1],
65438=>[93.876,-78.971,52.917,1],
65439=>[93.877,-78.974,52.902,1],
65440=>[93.878,-78.976,52.884,1],
65441=>[93.881,-78.978,52.866,1],
65442=>[93.884,-78.981,52.848,1],
65443=>[93.888,-78.985,52.830,1],
65444=>[93.892,-78.993,52.810,1],
65445=>[93.892,-78.994,52.791,1],
65446=>[93.890,-78.991,52.771,1],
65447=>[93.889,-78.988,52.751,1],
65448=>[93.894,-78.987,52.731,1],
65449=>[93.920,-78.989,52.710,1],
65450=>[93.938,-78.994,52.689,1],
65451=>[93.956,-78.999,52.668,1],
65452=>[93.973,-79.004,52.647,1],
65453=>[93.991,-79.009,52.624,1],
65454=>[94.009,-79.015,52.598,1],
65455=>[94.011,-79.009,52.571,1],
65456=>[94.013,-79.002,52.542,1],
65457=>[94.015,-78.997,52.514,1],
65458=>[94.017,-78.991,52.484,1],
65459=>[94.019,-78.985,52.454,1],
65460=>[94.022,-78.979,52.424,1],
65461=>[94.023,-78.973,52.392,1],
65462=>[94.027,-78.965,52.363,1],
65463=>[94.037,-78.955,52.335,1],
65464=>[94.045,-78.944,52.310,1],
65465=>[94.053,-78.940,52.286,1],
65466=>[94.060,-78.934,52.263,1],
65467=>[94.068,-78.932,52.241,1],
65468=>[94.078,-78.930,52.216,1],
65469=>[94.087,-78.928,52.191,1],
65470=>[94.096,-78.927,52.168,1],
65471=>[94.106,-78.924,52.145,1],
65472=>[94.122,-78.915,52.123,1],
65473=>[94.139,-78.905,52.101,1],
65474=>[94.155,-78.895,52.080,1],
65475=>[94.172,-78.885,52.056,1],
65476=>[94.188,-78.875,52.033,1],
65477=>[94.205,-78.866,52.010,1],
65478=>[94.221,-78.856,51.986,1],
65479=>[94.239,-78.843,51.962,1],
65480=>[94.260,-78.811,51.935,1],
65481=>[94.280,-78.788,51.905,1],
65482=>[94.296,-78.785,51.871,1],
65483=>[94.312,-78.782,51.836,1],
65484=>[94.328,-78.780,51.801,1],
65485=>[94.343,-78.780,51.765,1],
65486=>[94.359,-78.781,51.731,1],
65487=>[94.374,-78.776,51.699,1],
65488=>[94.386,-78.782,51.665,1],
65489=>[94.397,-78.791,51.629,1],
65490=>[94.409,-78.805,51.592,1],
65491=>[94.426,-78.813,51.557,1],
65492=>[94.445,-78.817,51.521,1],
65493=>[94.463,-78.821,51.487,1],
65494=>[94.482,-78.825,51.455,1],
65495=>[94.500,-78.829,51.424,1],
65496=>[94.519,-78.833,51.393,1],
65497=>[94.538,-78.837,51.361,1],
65498=>[94.556,-78.841,51.331,1],
65499=>[94.575,-78.846,51.298,1],
65500=>[94.594,-78.849,51.264,1],
65501=>[94.613,-78.855,51.228,1],
65502=>[94.632,-78.859,51.190,1],
65503=>[94.648,-78.861,51.155,1],
65504=>[94.663,-78.862,51.121,1],
65505=>[94.678,-78.863,51.089,1],
65506=>[94.691,-78.862,51.054,1],
65507=>[94.702,-78.855,51.017,1],
65508=>[94.712,-78.847,50.979,1],
65509=>[94.723,-78.839,50.943,1],
65510=>[94.734,-78.832,50.907,1],
65511=>[94.744,-78.824,50.869,1],
65512=>[94.753,-78.818,50.827,1],
65513=>[94.757,-78.818,50.786,1],
65514=>[94.761,-78.818,50.743,1],
65515=>[94.765,-78.817,50.699,1],
65516=>[94.769,-78.816,50.656,1],
65517=>[94.773,-78.815,50.612,1],
65518=>[94.777,-78.814,50.569,1],
65519=>[94.781,-78.814,50.525,1],
65520=>[94.796,-78.816,50.487,1],
65521=>[94.820,-78.818,50.451,1],
65522=>[94.843,-78.821,50.417,1],
65523=>[94.866,-78.824,50.382,1],
65524=>[94.890,-78.827,50.345,1],
65525=>[94.886,-78.827,50.307,1],
65526=>[94.880,-78.827,50.266,1],
65527=>[94.873,-78.826,50.223,1],
65528=>[94.864,-78.826,50.181,1],
65529=>[94.857,-78.825,50.139,1],
65530=>[94.849,-78.825,50.097,1],
65531=>[94.841,-78.824,50.058,1],
65532=>[94.833,-78.824,50.020,1],
65533=>[94.825,-78.824,49.983,1],
65534=>[94.817,-78.823,49.946,1],
65535=>[94.816,-78.824,49.908,1],
65536=>[94.827,-78.842,49.867,1],
65537=>[94.835,-78.870,49.829,1],
65538=>[94.843,-78.898,49.790,1],
65539=>[94.850,-78.926,49.750,1],
65540=>[94.858,-78.954,49.711,1],
65541=>[94.866,-78.982,49.674,1],
65542=>[94.874,-79.010,49.638,1],
65543=>[94.898,-79.026,49.604,1],
65544=>[94.937,-79.031,49.569,1],
65545=>[94.968,-79.037,49.534,1],
65546=>[94.985,-79.046,49.501,1],
65547=>[95.001,-79.056,49.469,1],
65548=>[95.018,-79.065,49.436,1],
65549=>[95.034,-79.075,49.404,1],
65550=>[95.051,-79.084,49.370,1],
65551=>[95.067,-79.093,49.333,1],
65552=>[95.084,-79.103,49.296,1],
65553=>[95.100,-79.117,49.258,1],
65554=>[95.120,-79.128,49.219,1],
65555=>[95.142,-79.137,49.178,1],
65556=>[95.168,-79.141,49.137,1],
65557=>[95.193,-79.146,49.095,1],
65558=>[95.219,-79.150,49.052,1],
65559=>[95.245,-79.154,49.009,1],
65560=>[95.270,-79.159,48.965,1],
65561=>[95.296,-79.163,48.922,1],
65562=>[95.321,-79.167,48.878,1],
65563=>[95.329,-79.173,48.835,1],
65564=>[95.332,-79.179,48.791,1],
65565=>[95.344,-79.178,48.747,1],
65566=>[95.362,-79.172,48.703,1],
65567=>[95.377,-79.182,48.660,1],
65568=>[95.389,-79.198,48.616,1],
65569=>[95.402,-79.214,48.571,1],
65570=>[95.415,-79.229,48.526,1],
65571=>[95.428,-79.245,48.483,1],
65572=>[95.441,-79.261,48.441,1],
65573=>[95.454,-79.276,48.398,1],
65574=>[95.470,-79.291,48.356,1],
65575=>[95.509,-79.295,48.314,1],
65576=>[95.537,-79.288,48.272,1],
65577=>[95.559,-79.275,48.230,1],
65578=>[95.582,-79.261,48.189,1],
65579=>[95.604,-79.248,48.147,1],
65580=>[95.627,-79.234,48.105,1],
65581=>[95.649,-79.222,48.065,1],
65582=>[95.663,-79.214,48.025,1],
65583=>[95.673,-79.209,47.986,1],
65584=>[95.683,-79.203,47.947,1],
65585=>[95.693,-79.198,47.907,1],
65586=>[95.703,-79.192,47.868,1],
65587=>[95.716,-79.188,47.829,1],
65588=>[95.750,-79.198,47.790,1],
65589=>[95.783,-79.207,47.751,1],
65590=>[95.817,-79.216,47.712,1],
65591=>[95.850,-79.225,47.673,1],
65592=>[95.875,-79.243,47.635,1],
65593=>[95.884,-79.271,47.596,1],
65594=>[95.883,-79.262,47.558,1],
65595=>[95.878,-79.242,47.520,1],
65596=>[95.873,-79.222,47.484,1],
65597=>[95.861,-79.185,47.449,1],
65598=>[95.843,-79.137,47.413,1],
65599=>[95.826,-79.089,47.377,1],
65600=>[95.808,-79.040,47.340,1],
65601=>[95.848,-79.058,47.303,1],
65602=>[95.898,-79.082,47.266,1],
65603=>[95.948,-79.106,47.229,1],
65604=>[95.997,-79.131,47.192,1],
65605=>[96.046,-79.156,47.157,1],
65606=>[96.096,-79.180,47.120,1],
65607=>[96.145,-79.204,47.084,1],
65608=>[96.194,-79.229,47.049,1],
65609=>[96.244,-79.253,47.014,1],
65610=>[96.294,-79.278,46.980,1],
65611=>[96.325,-79.235,46.947,1],
65612=>[96.356,-79.283,46.915,1],
65613=>[96.381,-79.298,46.882,1],
65614=>[96.402,-79.309,46.850,1],
65615=>[96.423,-79.319,46.819,1],
65616=>[96.444,-79.329,46.789,1],
65617=>[96.465,-79.340,46.758,1],
65618=>[96.485,-79.350,46.728,1],
65619=>[96.506,-79.361,46.699,1],
65620=>[96.527,-79.371,46.669,1],
65621=>[96.548,-79.382,46.639,1],
65622=>[96.569,-79.392,46.609,1],
65623=>[96.581,-79.394,46.580,1],
65624=>[96.590,-79.391,46.552,1],
65625=>[96.599,-79.390,46.524,1],
65626=>[96.608,-79.388,46.496,1],
65627=>[96.617,-79.385,46.468,1],
65628=>[96.639,-79.388,46.440,1],
65629=>[96.662,-79.391,46.413,1],
65630=>[96.685,-79.393,46.387,1],
65631=>[96.708,-79.395,46.362,1],
65632=>[96.730,-79.398,46.337,1],
65633=>[96.753,-79.400,46.313,1],
65634=>[96.773,-79.391,46.288,1],
65635=>[96.792,-79.369,46.262,1],
65636=>[96.811,-79.348,46.237,1],
65637=>[96.829,-79.327,46.215,1],
65638=>[96.848,-79.306,46.193,1],
65639=>[96.867,-79.285,46.172,1],
65640=>[96.885,-79.264,46.150,1],
65641=>[96.904,-79.243,46.129,1],
65642=>[96.923,-79.222,46.107,1],
65643=>[96.950,-79.216,46.084,1],
65644=>[97.002,-79.247,46.061,1],
65645=>[97.060,-79.279,46.040,1],
65646=>[97.087,-79.289,46.019,1],
65647=>[97.102,-79.290,45.998,1],
65648=>[97.117,-79.291,45.976,1],
65649=>[97.140,-79.292,45.954,1],
65650=>[97.159,-79.294,45.932,1],
65651=>[97.173,-79.294,45.911,1],
65652=>[97.188,-79.294,45.890,1],
65653=>[97.197,-79.298,45.869,1],
65654=>[97.163,-79.338,45.848,1],
65655=>[97.164,-79.336,45.826,1],
65656=>[97.183,-79.327,45.804,1],
65657=>[97.218,-79.317,45.782,1],
65658=>[97.252,-79.307,45.761,1],
65659=>[97.271,-79.310,45.742,1],
65660=>[97.275,-79.322,45.723,1],
65661=>[97.279,-79.335,45.703,1],
65662=>[97.283,-79.347,45.684,1],
65663=>[97.287,-79.360,45.665,1],
65664=>[97.291,-79.373,45.647,1],
65665=>[97.295,-79.385,45.629,1],
65666=>[97.299,-79.398,45.611,1],
65667=>[97.294,-79.409,45.594,1],
65668=>[97.287,-79.418,45.577,1],
65669=>[97.280,-79.428,45.560,1],
65670=>[97.283,-79.419,45.542,1],
65671=>[97.288,-79.407,45.524,1],
65672=>[97.294,-79.394,45.507,1],
65673=>[97.300,-79.381,45.490,1],
65674=>[97.302,-79.376,45.474,1],
65675=>[97.301,-79.381,45.458,1],
65676=>[97.289,-79.403,45.441,1],
65677=>[97.296,-79.410,45.424,1],
65678=>[97.303,-79.418,45.407,1],
65679=>[97.310,-79.426,45.390,1],
65680=>[97.318,-79.433,45.374,1],
65681=>[97.325,-79.441,45.359,1],
65682=>[97.332,-79.449,45.343,1],
65683=>[97.352,-79.464,45.328,1],
65684=>[97.371,-79.479,45.313,1],
65685=>[97.390,-79.495,45.298,1],
65686=>[97.409,-79.510,45.283,1],
65687=>[97.428,-79.526,45.268,1],
65688=>[97.447,-79.541,45.253,1],
65689=>[97.466,-79.556,45.238,1],
65690=>[97.486,-79.571,45.224,1],
65691=>[97.505,-79.586,45.209,1],
65692=>[97.524,-79.602,45.195,1],
65693=>[97.543,-79.617,45.181,1],
65694=>[97.563,-79.632,45.167,1],
65695=>[97.582,-79.648,45.153,1],
65696=>[97.601,-79.663,45.139,1],
65697=>[97.620,-79.678,45.126,1],
65698=>[97.639,-79.694,45.112,1],
65699=>[97.658,-79.709,45.099,1],
65700=>[97.677,-79.724,45.085,1],
65701=>[97.697,-79.739,45.073,1],
65702=>[97.716,-79.755,45.060,1],
65703=>[97.735,-79.770,45.046,1],
65704=>[97.754,-79.786,45.034,1],
65705=>[97.773,-79.801,45.021,1],
65724=>[98.138,-80.091,44.788,1],
65725=>[98.157,-80.106,44.779,1],
65726=>[98.176,-80.121,44.769,1],
65727=>[98.195,-80.137,44.759,1],
65728=>[98.214,-80.152,44.750,1],
65729=>[98.233,-80.168,44.741,1],
65730=>[98.252,-80.183,44.732,1],
65731=>[98.272,-80.198,44.723,1],
65732=>[98.291,-80.213,44.715,1],
65733=>[98.310,-80.228,44.707,1],
65734=>[98.329,-80.243,44.698,1],
65735=>[98.348,-80.259,44.690,1],
65736=>[98.367,-80.275,44.683,1],
65737=>[98.387,-80.290,44.676,1],
65738=>[98.406,-80.305,44.669,1],
65739=>[98.425,-80.320,44.662,1],
65740=>[98.444,-80.335,44.655,1],
65741=>[98.463,-80.350,44.648,1],
65742=>[98.483,-80.366,44.641,1],
65743=>[98.502,-80.381,44.635,1],
65744=>[98.525,-80.388,44.628,1],
65745=>[98.550,-80.391,44.621,1],
65746=>[98.574,-80.393,44.614,1],
65747=>[98.599,-80.395,44.607,1],
65748=>[98.624,-80.398,44.598,1],
65749=>[98.649,-80.400,44.590,1],
65750=>[98.673,-80.403,44.582,1],
65751=>[98.698,-80.406,44.575,1],
65752=>[98.723,-80.408,44.568,1],
65753=>[98.747,-80.411,44.561,1],
65754=>[98.773,-80.415,44.554,1],
65755=>[98.798,-80.421,44.547,1],
65756=>[98.821,-80.431,44.540,1],
65757=>[98.845,-80.442,44.534,1],
65758=>[98.868,-80.453,44.528,1],
65759=>[98.891,-80.463,44.523,1],
65760=>[98.915,-80.474,44.518,1],
65761=>[98.938,-80.485,44.513,1],
65762=>[98.961,-80.495,44.507,1],
65763=>[98.985,-80.505,44.501,1],
65764=>[99.008,-80.516,44.496,1],
66091=>[93.405,-79.091,53.422,1],
66092=>[93.414,-79.088,53.408,1],
66093=>[93.424,-79.086,53.393,1],
66094=>[93.433,-79.084,53.379,1],
66095=>[93.443,-79.081,53.366,1],
66096=>[93.453,-79.076,53.352,1],
66097=>[93.465,-79.066,53.340,1],
66098=>[93.476,-79.056,53.328,1],
66099=>[93.485,-79.048,53.317,1],
66100=>[93.493,-79.041,53.307,1],
66101=>[93.502,-79.034,53.298,1],
66102=>[93.510,-79.027,53.290,1],
66103=>[93.518,-79.020,53.285,1],
66104=>[93.527,-79.013,53.280,1],
66105=>[93.535,-79.006,53.279,1],
66106=>[93.541,-79.010,53.279,1],
66107=>[93.547,-79.015,53.283,1],
66108=>[93.552,-79.020,53.286,1],
66109=>[93.561,-79.022,53.287,1],
66110=>[93.580,-79.017,53.285,1],
66111=>[93.599,-79.012,53.279,1],
66112=>[93.618,-79.007,53.272,1],
66113=>[93.637,-79.002,53.263,1],
66114=>[93.652,-78.999,53.253,1],
66115=>[93.666,-78.997,53.243,1],
66116=>[93.680,-78.995,53.232,1],
66117=>[93.694,-78.993,53.222,1],
66118=>[93.707,-78.990,53.211,1],
66119=>[93.721,-78.988,53.199,1],
66120=>[93.735,-78.986,53.188,1],
66121=>[93.751,-78.983,53.178,1],
66122=>[93.763,-78.981,53.166,1],
66123=>[93.770,-78.981,53.154,1],
66124=>[93.777,-78.981,53.141,1],
66125=>[93.785,-78.978,53.128,1],
66126=>[93.793,-78.974,53.114,1],
66127=>[93.801,-78.971,53.099,1],
66128=>[93.810,-78.968,53.085,1],
66129=>[93.818,-78.965,53.074,1],
66130=>[93.826,-78.962,53.064,1],
66131=>[93.834,-78.959,53.053,1],
66132=>[93.843,-78.956,53.042,1],
66133=>[93.851,-78.952,53.031,1],
66134=>[93.859,-78.949,53.019,1],
66135=>[93.867,-78.946,53.006,1],
66136=>[93.870,-78.948,52.992,1],
66137=>[93.871,-78.950,52.978,1],
66138=>[93.872,-78.952,52.962,1],
66139=>[93.873,-78.955,52.947,1],
66140=>[93.874,-78.958,52.932,1],
66141=>[93.875,-78.960,52.915,1],
66142=>[93.876,-78.962,52.896,1],
66143=>[93.880,-78.965,52.877,1],
66144=>[93.883,-78.970,52.858,1],
66145=>[93.885,-78.974,52.837,1],
66146=>[93.883,-78.971,52.816,1],
66147=>[93.882,-78.968,52.794,1],
66148=>[93.880,-78.965,52.772,1],
66149=>[93.891,-78.965,52.749,1],
66150=>[93.908,-78.969,52.725,1],
66151=>[93.926,-78.974,52.701,1],
66152=>[93.944,-78.980,52.679,1],
66153=>[93.962,-78.984,52.656,1],
66154=>[93.979,-78.990,52.633,1],
66155=>[93.997,-78.995,52.607,1],
66156=>[94.011,-78.997,52.580,1],
66157=>[94.013,-78.991,52.553,1],
66158=>[94.015,-78.985,52.525,1],
66159=>[94.017,-78.979,52.496,1],
66160=>[94.019,-78.973,52.468,1],
66161=>[94.021,-78.967,52.440,1],
66162=>[94.029,-78.957,52.411,1],
66163=>[94.038,-78.946,52.384,1],
66164=>[94.047,-78.937,52.358,1],
66165=>[94.056,-78.926,52.333,1],
66166=>[94.064,-78.918,52.309,1],
66167=>[94.072,-78.913,52.285,1],
66168=>[94.079,-78.908,52.263,1],
66169=>[94.086,-78.903,52.237,1],
66170=>[94.094,-78.899,52.213,1],
66171=>[94.103,-78.897,52.189,1],
66172=>[94.115,-78.893,52.166,1],
66173=>[94.131,-78.883,52.142,1],
66174=>[94.147,-78.873,52.119,1],
66175=>[94.164,-78.863,52.097,1],
66176=>[94.181,-78.854,52.072,1],
66177=>[94.197,-78.844,52.048,1],
66178=>[94.214,-78.834,52.025,1],
66179=>[94.230,-78.824,52.002,1],
66180=>[94.247,-78.814,51.977,1],
66181=>[94.264,-78.799,51.950,1],
66182=>[94.283,-78.780,51.920,1],
66183=>[94.299,-78.777,51.886,1],
66184=>[94.315,-78.778,51.851,1],
66185=>[94.331,-78.779,51.816,1],
66186=>[94.346,-78.780,51.781,1],
66187=>[94.362,-78.781,51.749,1],
66188=>[94.378,-78.782,51.717,1],
66189=>[94.393,-78.771,51.683,1],
66190=>[94.404,-78.780,51.647,1],
66191=>[94.419,-78.788,51.610,1],
66192=>[94.437,-78.793,51.573,1],
66193=>[94.455,-78.796,51.538,1],
66194=>[94.472,-78.801,51.503,1],
66195=>[94.490,-78.805,51.470,1],
66196=>[94.507,-78.809,51.440,1],
66197=>[94.526,-78.813,51.408,1],
66198=>[94.544,-78.818,51.376,1],
66199=>[94.563,-78.821,51.345,1],
66200=>[94.581,-78.826,51.313,1],
66201=>[94.600,-78.830,51.280,1],
66202=>[94.619,-78.834,51.245,1],
66203=>[94.634,-78.835,51.207,1],
66204=>[94.648,-78.836,51.171,1],
66205=>[94.663,-78.837,51.137,1],
66206=>[94.678,-78.838,51.105,1],
66207=>[94.692,-78.839,51.073,1],
66208=>[94.703,-78.833,51.037,1],
66209=>[94.714,-78.825,50.999,1],
66210=>[94.721,-78.821,50.964,1],
66211=>[94.725,-78.821,50.927,1],
66212=>[94.729,-78.821,50.887,1],
66213=>[94.733,-78.820,50.846,1],
66214=>[94.737,-78.819,50.803,1],
66215=>[94.741,-78.818,50.759,1],
66216=>[94.745,-78.818,50.714,1],
66217=>[94.749,-78.817,50.672,1],
66218=>[94.753,-78.817,50.629,1],
66219=>[94.757,-78.816,50.585,1],
66220=>[94.766,-78.816,50.541,1],
66221=>[94.790,-78.819,50.503,1],
66222=>[94.813,-78.821,50.467,1],
66223=>[94.836,-78.824,50.433,1],
66224=>[94.860,-78.827,50.398,1],
66225=>[94.889,-78.821,50.363,1],
66226=>[94.893,-78.830,50.327,1],
66227=>[94.885,-78.829,50.287,1],
66228=>[94.878,-78.829,50.245,1],
66229=>[94.870,-78.828,50.203,1],
66230=>[94.861,-78.828,50.162,1],
66231=>[94.853,-78.827,50.119,1],
66232=>[94.845,-78.827,50.078,1],
66233=>[94.838,-78.827,50.041,1],
66234=>[94.830,-78.826,50.005,1],
66235=>[94.822,-78.825,49.968,1],
66236=>[94.817,-78.825,49.929,1],
66237=>[94.833,-78.828,49.887,1],
66238=>[94.845,-78.845,49.847,1],
66239=>[94.853,-78.873,49.807,1],
66240=>[94.861,-78.901,49.766,1],
66241=>[94.868,-78.929,49.727,1],
66242=>[94.877,-78.957,49.689,1],
66243=>[94.885,-78.985,49.653,1],
66244=>[94.900,-79.007,49.618,1],
66245=>[94.939,-79.012,49.583,1],
66246=>[94.971,-79.018,49.549,1],
66247=>[94.987,-79.028,49.516,1],
66248=>[95.003,-79.037,49.484,1],
66249=>[95.020,-79.046,49.452,1],
66250=>[95.036,-79.056,49.420,1],
66251=>[95.052,-79.065,49.385,1],
66252=>[95.069,-79.075,49.348,1],
66253=>[95.085,-79.084,49.310,1],
66254=>[95.103,-79.094,49.271,1],
66255=>[95.128,-79.100,49.230,1],
66256=>[95.154,-79.104,49.188,1],
66257=>[95.179,-79.108,49.146,1],
66258=>[95.205,-79.112,49.104,1],
66259=>[95.231,-79.117,49.061,1],
66260=>[95.256,-79.122,49.018,1],
66261=>[95.282,-79.125,48.975,1],
66262=>[95.307,-79.130,48.931,1],
66263=>[95.333,-79.134,48.888,1],
66264=>[95.345,-79.140,48.845,1],
66265=>[95.347,-79.146,48.801,1],
66266=>[95.350,-79.153,48.757,1],
66267=>[95.365,-79.154,48.713,1],
66268=>[95.378,-79.169,48.670,1],
66269=>[95.390,-79.185,48.625,1],
66270=>[95.403,-79.201,48.580,1],
66271=>[95.416,-79.217,48.535,1],
66272=>[95.429,-79.232,48.492,1],
66273=>[95.442,-79.248,48.449,1],
66274=>[95.455,-79.264,48.406,1],
66275=>[95.468,-79.279,48.364,1],
66276=>[95.506,-79.285,48.322,1],
66277=>[95.534,-79.276,48.280,1],
66278=>[95.556,-79.263,48.237,1],
66279=>[95.579,-79.250,48.195,1],
66280=>[95.601,-79.237,48.153,1],
66281=>[95.624,-79.224,48.112,1],
66282=>[95.646,-79.210,48.071,1],
66283=>[95.665,-79.200,48.031,1],
66284=>[95.675,-79.194,47.991,1],
66285=>[95.685,-79.188,47.952,1],
66286=>[95.696,-79.183,47.912,1],
66287=>[95.706,-79.178,47.873,1],
66288=>[95.723,-79.176,47.834,1],
66289=>[95.756,-79.185,47.794,1],
66290=>[95.790,-79.195,47.755,1],
66291=>[95.824,-79.204,47.716,1],
66292=>[95.857,-79.213,47.676,1],
66293=>[95.888,-79.225,47.637,1],
66294=>[95.895,-79.247,47.599,1],
66295=>[95.891,-79.227,47.560,1],
66296=>[95.886,-79.207,47.522,1],
66297=>[95.881,-79.187,47.486,1],
66298=>[95.877,-79.167,47.450,1],
66299=>[95.863,-79.130,47.414,1],
66300=>[95.849,-79.093,47.377,1],
66301=>[95.836,-79.057,47.340,1],
66302=>[95.867,-79.069,47.303,1],
66303=>[95.917,-79.103,47.265,1],
66304=>[95.969,-79.136,47.228,1],
66305=>[96.019,-79.169,47.191,1],
66306=>[96.068,-79.193,47.155,1],
66307=>[96.118,-79.217,47.119,1],
66308=>[96.168,-79.241,47.082,1],
66309=>[96.217,-79.266,47.046,1],
66310=>[96.252,-79.239,47.012,1],
66311=>[96.281,-79.188,46.978,1],
66312=>[96.310,-79.137,46.945,1],
66313=>[96.341,-79.176,46.913,1],
66314=>[96.372,-79.235,46.881,1],
66315=>[96.403,-79.285,46.849,1],
66316=>[96.431,-79.303,46.818,1],
66317=>[96.457,-79.318,46.788,1],
66318=>[96.478,-79.328,46.758,1],
66319=>[96.499,-79.339,46.728,1],
66320=>[96.520,-79.349,46.698,1],
66321=>[96.540,-79.360,46.667,1],
66322=>[96.560,-79.369,46.637,1],
66323=>[96.570,-79.367,46.606,1],
66324=>[96.579,-79.365,46.577,1],
66325=>[96.588,-79.363,46.549,1],
66326=>[96.596,-79.361,46.521,1],
66327=>[96.605,-79.359,46.492,1],
66328=>[96.624,-79.360,46.464,1],
66329=>[96.647,-79.363,46.436,1],
66330=>[96.670,-79.365,46.408,1],
66331=>[96.692,-79.368,46.382,1],
66332=>[96.715,-79.370,46.356,1],
66333=>[96.738,-79.372,46.331,1],
66334=>[96.761,-79.375,46.306,1],
66335=>[96.782,-79.367,46.280,1],
66336=>[96.800,-79.346,46.255,1],
66337=>[96.819,-79.325,46.230,1],
66338=>[96.837,-79.303,46.207,1],
66339=>[96.856,-79.283,46.186,1],
66340=>[96.875,-79.262,46.164,1],
66341=>[96.893,-79.241,46.142,1],
66342=>[96.912,-79.219,46.121,1],
66343=>[96.934,-79.203,46.099,1],
66344=>[96.971,-79.214,46.077,1],
66345=>[97.004,-79.240,46.055,1],
66346=>[97.062,-79.272,46.034,1],
66347=>[97.083,-79.278,46.014,1],
66348=>[97.100,-79.278,45.992,1],
66349=>[97.120,-79.280,45.970,1],
66350=>[97.135,-79.280,45.948,1],
66351=>[97.150,-79.281,45.925,1],
66352=>[97.165,-79.281,45.904,1],
66353=>[97.179,-79.281,45.883,1],
66354=>[97.190,-79.284,45.864,1],
66355=>[97.156,-79.323,45.842,1],
66356=>[97.164,-79.315,45.821,1],
66357=>[97.166,-79.308,45.800,1],
66358=>[97.186,-79.300,45.779,1],
66359=>[97.221,-79.289,45.759,1],
66360=>[97.255,-79.279,45.740,1],
66361=>[97.260,-79.291,45.721,1],
66362=>[97.264,-79.304,45.702,1],
66363=>[97.268,-79.317,45.683,1],
66364=>[97.272,-79.330,45.665,1],
66365=>[97.276,-79.343,45.646,1],
66366=>[97.280,-79.355,45.629,1],
66367=>[97.284,-79.368,45.612,1],
66368=>[97.288,-79.381,45.595,1],
66369=>[97.292,-79.394,45.578,1],
66370=>[97.296,-79.407,45.560,1],
66371=>[97.290,-79.416,45.543,1],
66372=>[97.283,-79.425,45.525,1],
66373=>[97.287,-79.414,45.508,1],
66374=>[97.293,-79.402,45.491,1],
66375=>[97.298,-79.389,45.476,1],
66376=>[97.304,-79.376,45.460,1],
66377=>[97.309,-79.363,45.443,1],
66378=>[97.309,-79.367,45.426,1],
66379=>[97.304,-79.384,45.410,1],
66380=>[97.311,-79.391,45.393,1],
66381=>[97.318,-79.399,45.377,1],
66382=>[97.325,-79.407,45.362,1],
66383=>[97.337,-79.418,45.347,1],
66384=>[97.357,-79.433,45.331,1],
66385=>[97.376,-79.448,45.316,1],
66386=>[97.395,-79.463,45.301,1],
66387=>[97.415,-79.479,45.286,1],
66388=>[97.434,-79.494,45.272,1],
66389=>[97.453,-79.510,45.258,1],
66390=>[97.472,-79.525,45.243,1],
66391=>[97.491,-79.540,45.228,1],
66392=>[97.510,-79.555,45.214,1],
66393=>[97.529,-79.570,45.200,1],
66394=>[97.548,-79.586,45.186,1],
66395=>[97.568,-79.601,45.172,1],
66396=>[97.587,-79.617,45.158,1],
66397=>[97.606,-79.632,45.145,1],
66398=>[97.625,-79.647,45.132,1],
66399=>[97.645,-79.662,45.119,1],
66400=>[97.664,-79.678,45.105,1],
66401=>[97.683,-79.693,45.092,1],
66402=>[97.702,-79.708,45.080,1],
66403=>[97.721,-79.723,45.067,1],
66404=>[97.740,-79.739,45.054,1],
66405=>[97.759,-79.754,45.041,1],
66406=>[97.779,-79.770,45.028,1],
66407=>[97.798,-79.785,45.016,1],
66408=>[97.817,-79.800,45.003,1],
66409=>[97.836,-79.815,44.990,1],
66410=>[97.855,-79.830,44.977,1],
66411=>[97.874,-79.845,44.963,1],
66412=>[97.893,-79.861,44.950,1],
66413=>[97.913,-79.877,44.936,1],
66414=>[97.932,-79.892,44.923,1],
66415=>[97.951,-79.907,44.910,1],
66416=>[97.970,-79.922,44.898,1],
66417=>[97.990,-79.937,44.886,1],
66418=>[98.009,-79.952,44.874,1],
66419=>[98.028,-79.968,44.862,1],
66420=>[98.047,-79.983,44.850,1],
66421=>[98.066,-79.999,44.839,1],
66422=>[98.085,-80.014,44.828,1],
66423=>[98.104,-80.029,44.818,1],
66424=>[98.124,-80.044,44.807,1],
66425=>[98.143,-80.060,44.797,1],
66426=>[98.162,-80.075,44.788,1],
66427=>[98.181,-80.090,44.778,1],
66428=>[98.201,-80.106,44.768,1],
66429=>[98.220,-80.121,44.759,1],
66430=>[98.239,-80.136,44.750,1],
66431=>[98.258,-80.152,44.742,1],
66432=>[98.277,-80.167,44.733,1],
66433=>[98.296,-80.182,44.725,1],
66434=>[98.315,-80.197,44.716,1],
66435=>[98.335,-80.212,44.708,1],
66436=>[98.354,-80.228,44.700,1],
66437=>[98.373,-80.243,44.692,1],
66438=>[98.392,-80.259,44.685,1],
66439=>[98.411,-80.274,44.678,1],
66440=>[98.430,-80.289,44.672,1],
66441=>[98.449,-80.304,44.665,1],
66442=>[98.469,-80.319,44.658,1],
66443=>[98.488,-80.334,44.652,1],
66444=>[98.507,-80.350,44.645,1],
66445=>[98.530,-80.356,44.639,1],
66446=>[98.555,-80.359,44.633,1],
66447=>[98.580,-80.362,44.625,1],
66448=>[98.604,-80.364,44.617,1],
66449=>[98.629,-80.366,44.609,1],
66450=>[98.654,-80.369,44.600,1],
66451=>[98.678,-80.372,44.593,1],
66452=>[98.704,-80.375,44.585,1],
66453=>[98.728,-80.377,44.578,1],
66454=>[98.753,-80.380,44.571,1],
66455=>[98.779,-80.384,44.564,1],
66456=>[98.802,-80.394,44.557,1],
66457=>[98.826,-80.404,44.550,1],
66458=>[98.849,-80.415,44.544,1],
66459=>[98.872,-80.425,44.539,1],
66460=>[98.896,-80.436,44.533,1],
66461=>[98.919,-80.447,44.527,1],
66462=>[98.942,-80.457,44.522,1],
66463=>[98.966,-80.468,44.517,1],
66464=>[98.989,-80.478,44.510,1],
66465=>[99.012,-80.488,44.505,1],
66466=>[99.035,-80.499,44.501,1],
66794=>[93.424,-79.075,53.416,1],
66795=>[93.434,-79.072,53.402,1],
66796=>[93.443,-79.070,53.389,1],
66797=>[93.453,-79.068,53.376,1],
66798=>[93.464,-79.062,53.363,1],
66799=>[93.475,-79.052,53.351,1],
66800=>[93.486,-79.041,53.340,1],
66801=>[93.495,-79.034,53.329,1],
66802=>[93.503,-79.028,53.320,1],
66803=>[93.511,-79.021,53.312,1],
66804=>[93.519,-79.014,53.304,1],
66805=>[93.528,-79.007,53.299,1],
66806=>[93.536,-78.999,53.296,1],
66807=>[93.545,-78.993,53.294,1],
66808=>[93.551,-78.993,53.295,1],
66809=>[93.557,-78.998,53.298,1],
66810=>[93.562,-79.002,53.300,1],
66811=>[93.577,-79.001,53.299,1],
66812=>[93.596,-78.996,53.295,1],
66813=>[93.615,-78.991,53.289,1],
66814=>[93.633,-78.986,53.282,1],
66815=>[93.647,-78.984,53.273,1],
66816=>[93.661,-78.981,53.263,1],
66817=>[93.675,-78.979,53.253,1],
66818=>[93.689,-78.977,53.245,1],
66819=>[93.703,-78.974,53.234,1],
66820=>[93.717,-78.972,53.222,1],
66821=>[93.734,-78.970,53.212,1],
66822=>[93.750,-78.968,53.202,1],
66823=>[93.759,-78.967,53.191,1],
66824=>[93.766,-78.967,53.179,1],
66825=>[93.773,-78.967,53.166,1],
66826=>[93.780,-78.967,53.153,1],
66827=>[93.786,-78.967,53.139,1],
66828=>[93.794,-78.964,53.124,1],
66829=>[93.802,-78.961,53.111,1],
66830=>[93.811,-78.958,53.100,1],
66831=>[93.819,-78.954,53.090,1],
66832=>[93.827,-78.951,53.080,1],
66833=>[93.836,-78.948,53.069,1],
66834=>[93.844,-78.945,53.057,1],
66835=>[93.852,-78.942,53.045,1],
66836=>[93.862,-78.933,53.032,1],
66837=>[93.865,-78.933,53.018,1],
66838=>[93.866,-78.936,53.004,1],
66839=>[93.868,-78.937,52.989,1],
66840=>[93.869,-78.939,52.974,1],
66841=>[93.871,-78.941,52.959,1],
66842=>[93.872,-78.943,52.942,1],
66843=>[93.873,-78.946,52.923,1],
66844=>[93.875,-78.949,52.904,1],
66845=>[93.877,-78.953,52.884,1],
66846=>[93.876,-78.950,52.861,1],
66847=>[93.874,-78.947,52.838,1],
66848=>[93.872,-78.944,52.815,1],
66849=>[93.869,-78.940,52.791,1],
66850=>[93.880,-78.943,52.765,1],
66851=>[93.897,-78.949,52.740,1],
66852=>[93.914,-78.955,52.715,1],
66853=>[93.932,-78.960,52.690,1],
66854=>[93.949,-78.965,52.665,1],
66855=>[93.967,-78.970,52.640,1],
66856=>[93.985,-78.975,52.614,1],
66857=>[94.003,-78.981,52.588,1],
66858=>[94.013,-78.980,52.561,1],
66859=>[94.015,-78.974,52.534,1],
66860=>[94.017,-78.968,52.506,1],
66861=>[94.022,-78.960,52.479,1],
66862=>[94.031,-78.949,52.454,1],
66863=>[94.040,-78.939,52.428,1],
66864=>[94.049,-78.928,52.402,1],
66865=>[94.058,-78.918,52.376,1],
66866=>[94.067,-78.907,52.353,1],
66867=>[94.076,-78.896,52.329,1],
66868=>[94.083,-78.892,52.306,1],
66869=>[94.091,-78.886,52.283,1],
66870=>[94.098,-78.882,52.257,1],
66871=>[94.105,-78.877,52.232,1],
66872=>[94.113,-78.872,52.209,1],
66873=>[94.125,-78.866,52.185,1],
66874=>[94.142,-78.856,52.161,1],
66875=>[94.158,-78.846,52.137,1],
66876=>[94.175,-78.836,52.113,1],
66877=>[94.191,-78.826,52.087,1],
66878=>[94.207,-78.816,52.062,1],
66879=>[94.224,-78.806,52.039,1],
66880=>[94.241,-78.796,52.015,1],
66881=>[94.257,-78.786,51.990,1],
66882=>[94.273,-78.777,51.963,1],
66883=>[94.287,-78.774,51.933,1],
66884=>[94.302,-78.776,51.899,1],
66885=>[94.318,-78.778,51.865,1],
66886=>[94.334,-78.779,51.829,1],
66887=>[94.349,-78.780,51.796,1],
66888=>[94.365,-78.781,51.764,1],
66889=>[94.381,-78.782,51.733,1],
66890=>[94.397,-78.774,51.700,1],
66891=>[94.413,-78.765,51.664,1],
66892=>[94.430,-78.770,51.626,1],
66893=>[94.448,-78.774,51.589,1],
66894=>[94.466,-78.778,51.553,1],
66895=>[94.483,-78.783,51.518,1],
66896=>[94.500,-78.787,51.485,1],
66897=>[94.518,-78.791,51.454,1],
66898=>[94.535,-78.796,51.422,1],
66899=>[94.553,-78.800,51.390,1],
66900=>[94.570,-78.805,51.359,1],
66901=>[94.588,-78.808,51.327,1],
66902=>[94.608,-78.814,51.295,1],
66903=>[94.626,-78.816,51.260,1],
66904=>[94.640,-78.818,51.223,1],
66905=>[94.655,-78.819,51.186,1],
66906=>[94.671,-78.820,51.151,1],
66907=>[94.685,-78.821,51.119,1],
66908=>[94.700,-78.822,51.088,1],
66909=>[94.698,-78.826,51.054,1],
66910=>[94.697,-78.823,51.018,1],
66911=>[94.701,-78.823,50.983,1],
66912=>[94.705,-78.822,50.944,1],
66913=>[94.709,-78.821,50.904,1],
66914=>[94.713,-78.821,50.861,1],
66915=>[94.717,-78.820,50.817,1],
66916=>[94.721,-78.819,50.773,1],
66917=>[94.725,-78.819,50.729,1],
66918=>[94.729,-78.818,50.687,1],
66919=>[94.733,-78.818,50.643,1],
66920=>[94.737,-78.817,50.599,1],
66921=>[94.760,-78.819,50.558,1],
66922=>[94.783,-78.822,50.518,1],
66923=>[94.806,-78.825,50.481,1],
66924=>[94.833,-78.822,50.447,1],
66925=>[94.864,-78.814,50.413,1],
66926=>[94.887,-78.809,50.379,1],
66927=>[94.892,-78.818,50.344,1],
66928=>[94.890,-78.832,50.305,1],
66929=>[94.882,-78.831,50.264,1],
66930=>[94.874,-78.831,50.222,1],
66931=>[94.866,-78.830,50.182,1],
66932=>[94.858,-78.830,50.139,1],
66933=>[94.850,-78.830,50.097,1],
66934=>[94.842,-78.829,50.058,1],
66935=>[94.834,-78.828,50.020,1],
66936=>[94.826,-78.828,49.983,1],
66937=>[94.819,-78.827,49.944,1],
66938=>[94.834,-78.830,49.902,1],
66939=>[94.851,-78.833,49.863,1],
66940=>[94.863,-78.848,49.822,1],
66941=>[94.872,-78.876,49.779,1],
66942=>[94.879,-78.904,49.741,1],
66943=>[94.887,-78.932,49.703,1],
66944=>[94.895,-78.961,49.666,1],
66945=>[94.903,-78.989,49.631,1],
66946=>[94.942,-78.993,49.596,1],
66947=>[94.973,-78.999,49.561,1],
66948=>[94.990,-79.009,49.528,1],
66949=>[95.006,-79.018,49.498,1],
66950=>[95.023,-79.028,49.466,1],
66951=>[95.039,-79.037,49.434,1],
66952=>[95.055,-79.046,49.398,1],
66953=>[95.071,-79.056,49.360,1],
66954=>[95.089,-79.065,49.321,1],
66955=>[95.119,-79.071,49.281,1],
66956=>[95.143,-79.074,49.240,1],
66957=>[95.168,-79.076,49.198,1],
66958=>[95.192,-79.078,49.155,1],
66959=>[95.217,-79.081,49.112,1],
66960=>[95.242,-79.084,49.070,1],
66961=>[95.268,-79.088,49.027,1],
66962=>[95.293,-79.093,48.985,1],
66963=>[95.319,-79.097,48.942,1],
66964=>[95.344,-79.101,48.898,1],
66965=>[95.360,-79.106,48.854,1],
66966=>[95.362,-79.113,48.811,1],
66967=>[95.365,-79.125,48.768,1],
66968=>[95.368,-79.141,48.724,1],
66969=>[95.379,-79.157,48.679,1],
66970=>[95.391,-79.172,48.633,1],
66971=>[95.404,-79.188,48.589,1],
66972=>[95.417,-79.204,48.545,1],
66973=>[95.430,-79.219,48.501,1],
66974=>[95.443,-79.235,48.457,1],
66975=>[95.456,-79.251,48.413,1],
66976=>[95.469,-79.266,48.372,1],
66977=>[95.503,-79.273,48.329,1],
66978=>[95.531,-79.265,48.287,1],
66979=>[95.553,-79.252,48.245,1],
66980=>[95.576,-79.238,48.203,1],
66981=>[95.598,-79.225,48.162,1],
66982=>[95.621,-79.212,48.120,1],
66983=>[95.643,-79.199,48.079,1],
66984=>[95.666,-79.186,48.038,1],
66985=>[95.678,-79.179,47.998,1],
66986=>[95.688,-79.174,47.957,1],
66987=>[95.698,-79.169,47.918,1],
66988=>[95.708,-79.162,47.879,1],
66989=>[95.729,-79.164,47.840,1],
66990=>[95.763,-79.173,47.800,1],
66991=>[95.797,-79.183,47.761,1],
66992=>[95.830,-79.192,47.722,1],
66993=>[95.864,-79.201,47.682,1],
66994=>[95.898,-79.210,47.641,1],
66995=>[95.903,-79.211,47.602,1],
66996=>[95.899,-79.191,47.563,1],
66997=>[95.894,-79.182,47.525,1],
66998=>[95.890,-79.173,47.487,1],
66999=>[95.886,-79.164,47.451,1],
67000=>[95.891,-79.147,47.414,1],
67001=>[95.878,-79.110,47.378,1],
67002=>[95.864,-79.074,47.341,1],
67003=>[95.884,-79.074,47.303,1],
67004=>[95.935,-79.108,47.265,1],
67005=>[95.986,-79.141,47.227,1],
67006=>[96.037,-79.175,47.190,1],
67007=>[96.088,-79.209,47.153,1],
67008=>[96.138,-79.243,47.117,1],
67009=>[96.182,-79.247,47.080,1],
67010=>[96.209,-79.194,47.044,1],
67011=>[96.238,-79.141,47.010,1],
67012=>[96.266,-79.090,46.977,1],
67013=>[96.295,-79.039,46.945,1],
67014=>[96.326,-79.068,46.912,1],
67015=>[96.357,-79.128,46.880,1],
67016=>[96.388,-79.187,46.849,1],
67017=>[96.420,-79.246,46.818,1],
67018=>[96.450,-79.288,46.788,1],
67019=>[96.478,-79.304,46.758,1],
67020=>[96.506,-79.322,46.729,1],
67021=>[96.533,-79.338,46.698,1],
67022=>[96.549,-79.343,46.667,1],
67023=>[96.558,-79.341,46.635,1],
67024=>[96.567,-79.338,46.605,1],
67025=>[96.576,-79.337,46.576,1],
67026=>[96.585,-79.335,46.547,1],
67027=>[96.594,-79.332,46.517,1],
67028=>[96.609,-79.332,46.489,1],
67029=>[96.631,-79.335,46.461,1],
67030=>[96.655,-79.338,46.432,1],
67031=>[96.677,-79.340,46.404,1],
67032=>[96.700,-79.343,46.378,1],
67033=>[96.723,-79.345,46.352,1],
67034=>[96.746,-79.347,46.327,1],
67035=>[96.768,-79.350,46.301,1],
67036=>[96.790,-79.344,46.274,1],
67037=>[96.808,-79.322,46.248,1],
67038=>[96.827,-79.301,46.224,1],
67039=>[96.846,-79.280,46.201,1],
67040=>[96.864,-79.259,46.179,1],
67041=>[96.883,-79.238,46.156,1],
67042=>[96.901,-79.217,46.135,1],
67043=>[96.920,-79.196,46.114,1],
67044=>[96.955,-79.203,46.092,1],
67045=>[96.992,-79.212,46.071,1],
67046=>[97.029,-79.223,46.050,1],
67047=>[97.064,-79.265,46.029,1],
67048=>[97.082,-79.266,46.010,1],
67049=>[97.097,-79.266,45.988,1],
67050=>[97.112,-79.267,45.965,1],
67051=>[97.126,-79.267,45.943,1],
67052=>[97.141,-79.267,45.921,1],
67053=>[97.156,-79.267,45.900,1],
67054=>[97.171,-79.267,45.880,1],
67055=>[97.183,-79.269,45.861,1],
67056=>[97.152,-79.306,45.840,1],
67057=>[97.165,-79.294,45.819,1],
67058=>[97.166,-79.287,45.798,1],
67059=>[97.168,-79.280,45.777,1],
67060=>[97.190,-79.272,45.758,1],
67061=>[97.224,-79.261,45.740,1],
67062=>[97.245,-79.261,45.722,1],
67063=>[97.249,-79.274,45.703,1],
67064=>[97.253,-79.287,45.685,1],
67065=>[97.257,-79.300,45.666,1],
67066=>[97.261,-79.313,45.647,1],
67067=>[97.265,-79.325,45.629,1],
67068=>[97.270,-79.338,45.613,1],
67069=>[97.274,-79.350,45.597,1],
67070=>[97.278,-79.363,45.580,1],
67071=>[97.282,-79.376,45.562,1],
67072=>[97.286,-79.388,45.544,1],
67073=>[97.290,-79.401,45.527,1],
67074=>[97.293,-79.414,45.510,1],
67075=>[97.286,-79.422,45.494,1],
67076=>[97.291,-79.410,45.478,1],
67077=>[97.297,-79.397,45.462,1],
67078=>[97.303,-79.385,45.446,1],
67079=>[97.308,-79.372,45.429,1],
67080=>[97.314,-79.359,45.413,1],
67081=>[97.317,-79.353,45.397,1],
67082=>[97.318,-79.364,45.381,1],
67083=>[97.325,-79.372,45.366,1],
67084=>[97.343,-79.387,45.351,1],
67085=>[97.362,-79.402,45.336,1],
67086=>[97.381,-79.417,45.320,1],
67087=>[97.400,-79.432,45.305,1],
67088=>[97.420,-79.447,45.290,1],
67089=>[97.439,-79.463,45.276,1],
67090=>[97.458,-79.479,45.262,1],
67091=>[97.477,-79.494,45.248,1],
67092=>[97.497,-79.509,45.233,1],
67093=>[97.516,-79.524,45.219,1],
67094=>[97.535,-79.539,45.206,1],
67095=>[97.554,-79.554,45.192,1],
67096=>[97.573,-79.570,45.178,1],
67097=>[97.592,-79.585,45.165,1],
67098=>[97.611,-79.601,45.152,1],
67099=>[97.631,-79.616,45.139,1],
67100=>[97.650,-79.631,45.125,1],
67101=>[97.669,-79.646,45.112,1],
67102=>[97.688,-79.662,45.100,1],
67103=>[97.707,-79.677,45.087,1],
67104=>[97.727,-79.692,45.074,1],
67105=>[97.746,-79.708,45.061,1],
67106=>[97.765,-79.723,45.049,1],
67107=>[97.784,-79.738,45.036,1],
67108=>[97.803,-79.754,45.024,1],
67109=>[97.822,-79.769,45.011,1],
67110=>[97.842,-79.784,44.999,1],
67111=>[97.861,-79.799,44.986,1],
67112=>[97.880,-79.814,44.973,1],
67113=>[97.899,-79.830,44.959,1],
67114=>[97.918,-79.845,44.945,1],
67115=>[97.937,-79.861,44.932,1],
67116=>[97.956,-79.876,44.919,1],
67117=>[97.975,-79.891,44.907,1],
67118=>[97.995,-79.906,44.894,1],
67119=>[98.014,-79.921,44.882,1],
67120=>[98.033,-79.936,44.870,1],
67121=>[98.053,-79.952,44.859,1],
67122=>[98.072,-79.968,44.848,1],
67123=>[98.091,-79.983,44.837,1],
67124=>[98.110,-79.998,44.827,1],
67125=>[98.129,-80.013,44.816,1],
67126=>[98.148,-80.028,44.806,1],
67127=>[98.167,-80.044,44.797,1],
67128=>[98.186,-80.059,44.787,1],
67129=>[98.206,-80.074,44.778,1],
67130=>[98.225,-80.090,44.769,1],
67131=>[98.244,-80.105,44.761,1],
67132=>[98.263,-80.120,44.752,1],
67133=>[98.283,-80.135,44.743,1],
67134=>[98.302,-80.151,44.735,1],
67135=>[98.321,-80.166,44.727,1],
67136=>[98.340,-80.181,44.719,1],
67137=>[98.359,-80.196,44.711,1],
67138=>[98.378,-80.212,44.703,1],
67139=>[98.397,-80.227,44.696,1],
67140=>[98.417,-80.243,44.690,1],
67141=>[98.436,-80.258,44.683,1],
67142=>[98.455,-80.273,44.676,1],
67143=>[98.474,-80.288,44.669,1],
67144=>[98.493,-80.303,44.662,1],
67145=>[98.512,-80.319,44.656,1],
67146=>[98.535,-80.325,44.650,1],
67147=>[98.560,-80.328,44.644,1],
67148=>[98.585,-80.330,44.636,1],
67149=>[98.610,-80.333,44.629,1],
67150=>[98.635,-80.335,44.621,1],
67151=>[98.659,-80.338,44.612,1],
67152=>[98.684,-80.341,44.605,1],
67153=>[98.709,-80.343,44.598,1],
67154=>[98.734,-80.346,44.591,1],
67155=>[98.759,-80.348,44.583,1],
67156=>[98.783,-80.356,44.576,1],
67157=>[98.806,-80.366,44.568,1],
67158=>[98.830,-80.377,44.560,1],
67159=>[98.853,-80.388,44.554,1],
67160=>[98.876,-80.398,44.549,1],
67161=>[98.900,-80.409,44.543,1],
67162=>[98.923,-80.419,44.537,1],
67163=>[98.946,-80.430,44.532,1],
67164=>[98.970,-80.441,44.526,1],
67165=>[98.993,-80.451,44.520,1],
67166=>[99.016,-80.461,44.515,1],
67167=>[99.039,-80.472,44.510,1],
67168=>[99.063,-80.482,44.506,1],
67496=>[93.434,-79.062,53.425,1],
67497=>[93.444,-79.059,53.412,1],
67498=>[93.453,-79.057,53.399,1],
67499=>[93.463,-79.054,53.386,1],
67500=>[93.474,-79.048,53.374,1],
67501=>[93.485,-79.037,53.363,1],
67502=>[93.496,-79.028,53.352,1],
67503=>[93.504,-79.021,53.342,1],
67504=>[93.512,-79.014,53.333,1],
67505=>[93.521,-79.007,53.325,1],
67506=>[93.529,-79.000,53.319,1],
67507=>[93.538,-78.993,53.314,1],
67508=>[93.546,-78.987,53.310,1],
67509=>[93.554,-78.979,53.309,1],
67510=>[93.562,-78.976,53.310,1],
67511=>[93.567,-78.981,53.313,1],
67512=>[93.574,-78.985,53.313,1],
67513=>[93.593,-78.980,53.309,1],
67514=>[93.612,-78.974,53.304,1],
67515=>[93.629,-78.971,53.299,1],
67516=>[93.643,-78.968,53.291,1],
67517=>[93.656,-78.966,53.281,1],
67518=>[93.671,-78.964,53.272,1],
67519=>[93.685,-78.962,53.264,1],
67520=>[93.701,-78.959,53.254,1],
67521=>[93.718,-78.957,53.244,1],
67522=>[93.735,-78.955,53.233,1],
67523=>[93.745,-78.953,53.223,1],
67524=>[93.755,-78.952,53.212,1],
67525=>[93.763,-78.952,53.200,1],
67526=>[93.769,-78.952,53.188,1],
67527=>[93.776,-78.952,53.176,1],
67528=>[93.782,-78.952,53.162,1],
67529=>[93.789,-78.952,53.147,1],
67530=>[93.796,-78.952,53.135,1],
67531=>[93.803,-78.949,53.124,1],
67532=>[93.812,-78.946,53.114,1],
67533=>[93.820,-78.943,53.104,1],
67534=>[93.828,-78.940,53.093,1],
67535=>[93.837,-78.937,53.081,1],
67536=>[93.846,-78.929,53.068,1],
67537=>[93.857,-78.918,53.055,1],
67538=>[93.859,-78.920,53.041,1],
67539=>[93.860,-78.922,53.028,1],
67540=>[93.862,-78.924,53.014,1],
67541=>[93.863,-78.926,52.999,1],
67542=>[93.865,-78.927,52.983,1],
67543=>[93.867,-78.929,52.966,1],
67544=>[93.868,-78.931,52.947,1],
67545=>[93.870,-78.933,52.927,1],
67546=>[93.866,-78.929,52.906,1],
67547=>[93.863,-78.925,52.881,1],
67548=>[93.860,-78.922,52.857,1],
67549=>[93.857,-78.919,52.833,1],
67550=>[93.855,-78.916,52.807,1],
67551=>[93.872,-78.922,52.780,1],
67552=>[93.889,-78.927,52.754,1],
67553=>[93.906,-78.933,52.728,1],
67554=>[93.923,-78.938,52.701,1],
67555=>[93.940,-78.944,52.675,1],
67556=>[93.957,-78.949,52.650,1],
67557=>[93.974,-78.955,52.623,1],
67558=>[93.991,-78.961,52.596,1],
67559=>[94.008,-78.965,52.570,1],
67560=>[94.014,-78.962,52.544,1],
67561=>[94.024,-78.952,52.517,1],
67562=>[94.033,-78.941,52.491,1],
67563=>[94.042,-78.930,52.468,1],
67564=>[94.051,-78.920,52.443,1],
67565=>[94.060,-78.909,52.418,1],
67566=>[94.069,-78.899,52.393,1],
67567=>[94.078,-78.888,52.370,1],
67568=>[94.087,-78.878,52.346,1],
67569=>[94.096,-78.871,52.323,1],
67570=>[94.103,-78.865,52.299,1],
67571=>[94.110,-78.861,52.273,1],
67572=>[94.117,-78.855,52.248,1],
67573=>[94.125,-78.851,52.223,1],
67574=>[94.139,-78.848,52.199,1],
67575=>[94.155,-78.838,52.175,1],
67576=>[94.172,-78.828,52.150,1],
67577=>[94.189,-78.818,52.126,1],
67578=>[94.205,-78.808,52.100,1],
67579=>[94.221,-78.798,52.074,1],
67580=>[94.238,-78.788,52.049,1],
67581=>[94.254,-78.778,52.025,1],
67582=>[94.271,-78.768,52.000,1],
67583=>[94.282,-78.763,51.972,1],
67584=>[94.292,-78.761,51.943,1],
67585=>[94.308,-78.763,51.909,1],
67586=>[94.323,-78.765,51.875,1],
67587=>[94.339,-78.767,51.840,1],
67588=>[94.354,-78.770,51.807,1],
67589=>[94.369,-78.771,51.777,1],
67590=>[94.385,-78.774,51.747,1],
67591=>[94.400,-78.773,51.715,1],
67592=>[94.416,-78.757,51.679,1],
67593=>[94.433,-78.761,51.641,1],
67594=>[94.451,-78.765,51.603,1],
67595=>[94.468,-78.770,51.567,1],
67596=>[94.486,-78.774,51.533,1],
67597=>[94.503,-78.778,51.499,1],
67598=>[94.521,-78.783,51.468,1],
67599=>[94.538,-78.787,51.436,1],
67600=>[94.555,-78.791,51.403,1],
67601=>[94.573,-78.796,51.372,1],
67602=>[94.593,-78.801,51.341,1],
67603=>[94.620,-78.808,51.309,1],
67604=>[94.646,-78.814,51.275,1],
67605=>[94.661,-78.815,51.238,1],
67606=>[94.676,-78.817,51.200,1],
67607=>[94.691,-78.818,51.164,1],
67608=>[94.706,-78.819,51.132,1],
67609=>[94.718,-78.821,51.102,1],
67610=>[94.716,-78.830,51.070,1],
67611=>[94.712,-78.837,51.035,1],
67612=>[94.690,-78.827,50.999,1],
67613=>[94.685,-78.823,50.961,1],
67614=>[94.689,-78.822,50.920,1],
67615=>[94.693,-78.821,50.876,1],
67616=>[94.697,-78.821,50.831,1],
67617=>[94.701,-78.821,50.787,1],
67618=>[94.705,-78.820,50.744,1],
67619=>[94.709,-78.819,50.702,1],
67620=>[94.713,-78.818,50.658,1],
67621=>[94.729,-78.820,50.614,1],
67622=>[94.753,-78.823,50.574,1],
67623=>[94.777,-78.824,50.534,1],
67624=>[94.808,-78.816,50.495,1],
67625=>[94.839,-78.808,50.460,1],
67626=>[94.866,-78.802,50.426,1],
67627=>[94.885,-78.798,50.393,1],
67628=>[94.891,-78.807,50.359,1],
67629=>[94.890,-78.822,50.321,1],
67630=>[94.887,-78.834,50.281,1],
67631=>[94.879,-78.833,50.239,1],
67632=>[94.871,-78.833,50.198,1],
67633=>[94.863,-78.833,50.155,1],
67634=>[94.855,-78.832,50.113,1],
67635=>[94.847,-78.832,50.073,1],
67636=>[94.839,-78.831,50.033,1],
67637=>[94.831,-78.830,49.995,1],
67638=>[94.823,-78.830,49.956,1],
67639=>[94.835,-78.833,49.916,1],
67640=>[94.852,-78.836,49.875,1],
67641=>[94.868,-78.839,49.834,1],
67642=>[94.882,-78.851,49.792,1],
67643=>[94.890,-78.879,49.755,1],
67644=>[94.897,-78.908,49.717,1],
67645=>[94.905,-78.936,49.680,1],
67646=>[94.913,-78.964,49.644,1],
67647=>[94.944,-78.974,49.609,1],
67648=>[94.976,-78.981,49.574,1],
67649=>[94.992,-78.990,49.541,1],
67650=>[95.008,-78.999,49.510,1],
67651=>[95.025,-79.009,49.477,1],
67652=>[95.041,-79.018,49.444,1],
67653=>[95.057,-79.028,49.407,1],
67654=>[95.076,-79.036,49.369,1],
67655=>[95.106,-79.043,49.329,1],
67656=>[95.135,-79.049,49.289,1],
67657=>[95.162,-79.055,49.248,1],
67658=>[95.187,-79.057,49.206,1],
67659=>[95.211,-79.059,49.164,1],
67660=>[95.236,-79.062,49.122,1],
67661=>[95.260,-79.064,49.080,1],
67662=>[95.285,-79.066,49.038,1],
67663=>[95.309,-79.068,48.996,1],
67664=>[95.334,-79.071,48.952,1],
67665=>[95.358,-79.073,48.909,1],
67666=>[95.375,-79.080,48.865,1],
67667=>[95.378,-79.096,48.822,1],
67668=>[95.380,-79.112,48.778,1],
67669=>[95.382,-79.128,48.733,1],
67670=>[95.385,-79.144,48.688,1],
67671=>[95.392,-79.160,48.643,1],
67672=>[95.405,-79.175,48.598,1],
67673=>[95.418,-79.191,48.554,1],
67674=>[95.431,-79.207,48.510,1],
67675=>[95.444,-79.222,48.467,1],
67676=>[95.457,-79.238,48.424,1],
67677=>[95.470,-79.254,48.381,1],
67678=>[95.500,-79.262,48.338,1],
67679=>[95.528,-79.253,48.296,1],
67680=>[95.550,-79.241,48.254,1],
67681=>[95.572,-79.228,48.211,1],
67682=>[95.595,-79.214,48.169,1],
67683=>[95.618,-79.201,48.127,1],
67684=>[95.640,-79.187,48.086,1],
67685=>[95.663,-79.175,48.045,1],
67686=>[95.680,-79.165,48.004,1],
67687=>[95.691,-79.159,47.964,1],
67688=>[95.701,-79.153,47.925,1],
67689=>[95.711,-79.148,47.886,1],
67690=>[95.736,-79.152,47.847,1],
67691=>[95.769,-79.161,47.807,1],
67692=>[95.803,-79.170,47.767,1],
67693=>[95.837,-79.180,47.727,1],
67694=>[95.871,-79.189,47.687,1],
67695=>[95.899,-79.197,47.647,1],
67696=>[95.912,-79.202,47.608,1],
67697=>[95.908,-79.193,47.567,1],
67698=>[95.903,-79.184,47.529,1],
67699=>[95.899,-79.175,47.491,1],
67700=>[95.895,-79.166,47.453,1],
67701=>[95.893,-79.157,47.415,1],
67702=>[95.905,-79.128,47.377,1],
67703=>[95.892,-79.091,47.339,1],
67704=>[95.901,-79.079,47.301,1],
67705=>[95.952,-79.113,47.263,1],
67706=>[96.003,-79.147,47.225,1],
67707=>[96.054,-79.181,47.188,1],
67708=>[96.105,-79.214,47.151,1],
67709=>[96.151,-79.231,47.114,1],
67710=>[96.179,-79.178,47.079,1],
67711=>[96.207,-79.125,47.044,1],
67712=>[96.235,-79.071,47.010,1],
67713=>[96.263,-79.021,46.977,1],
67714=>[96.297,-79.008,46.944,1],
67715=>[96.327,-79.037,46.911,1],
67716=>[96.356,-79.083,46.880,1],
67717=>[96.384,-79.128,46.849,1],
67718=>[96.412,-79.175,46.818,1],
67719=>[96.441,-79.220,46.788,1],
67720=>[96.469,-79.266,46.758,1],
67721=>[96.496,-79.288,46.728,1],
67722=>[96.523,-79.303,46.698,1],
67723=>[96.546,-79.314,46.667,1],
67724=>[96.555,-79.312,46.635,1],
67725=>[96.564,-79.310,46.604,1],
67726=>[96.573,-79.308,46.574,1],
67727=>[96.582,-79.306,46.545,1],
67728=>[96.594,-79.305,46.516,1],
67729=>[96.616,-79.307,46.487,1],
67730=>[96.640,-79.310,46.458,1],
67731=>[96.662,-79.313,46.429,1],
67732=>[96.685,-79.315,46.401,1],
67733=>[96.708,-79.318,46.374,1],
67734=>[96.731,-79.320,46.348,1],
67735=>[96.753,-79.322,46.322,1],
67736=>[96.776,-79.325,46.296,1],
67737=>[96.798,-79.320,46.271,1],
67738=>[96.816,-79.299,46.245,1],
67739=>[96.835,-79.278,46.219,1],
67740=>[96.854,-79.257,46.196,1],
67741=>[96.872,-79.236,46.174,1],
67742=>[96.891,-79.215,46.152,1],
67743=>[96.909,-79.194,46.130,1],
67744=>[96.939,-79.190,46.108,1],
67745=>[96.976,-79.201,46.087,1],
67746=>[97.013,-79.211,46.066,1],
67747=>[97.050,-79.222,46.045,1],
67748=>[97.076,-79.228,46.024,1],
67749=>[97.074,-79.253,46.004,1],
67750=>[97.088,-79.253,45.982,1],
67751=>[97.103,-79.253,45.960,1],
67752=>[97.117,-79.253,45.938,1],
67753=>[97.133,-79.254,45.917,1],
67754=>[97.147,-79.254,45.897,1],
67755=>[97.162,-79.254,45.878,1],
67756=>[97.175,-79.256,45.858,1],
67757=>[97.151,-79.285,45.838,1],
67758=>[97.165,-79.273,45.818,1],
67759=>[97.167,-79.266,45.797,1],
67760=>[97.168,-79.259,45.777,1],
67761=>[97.170,-79.252,45.758,1],
67762=>[97.193,-79.244,45.740,1],
67763=>[97.228,-79.233,45.722,1],
67764=>[97.235,-79.244,45.704,1],
67765=>[97.239,-79.256,45.686,1],
67766=>[97.243,-79.269,45.667,1],
67767=>[97.247,-79.282,45.648,1],
67768=>[97.251,-79.294,45.631,1],
67769=>[97.255,-79.307,45.615,1],
67770=>[97.259,-79.320,45.598,1],
67771=>[97.263,-79.333,45.581,1],
67772=>[97.267,-79.346,45.564,1],
67773=>[97.271,-79.358,45.546,1],
67774=>[97.275,-79.371,45.529,1],
67775=>[97.279,-79.384,45.512,1],
67776=>[97.283,-79.397,45.496,1],
67777=>[97.287,-79.410,45.480,1],
67778=>[97.290,-79.418,45.464,1],
67779=>[97.296,-79.406,45.449,1],
67780=>[97.302,-79.392,45.433,1],
67781=>[97.309,-79.379,45.417,1],
67782=>[97.317,-79.364,45.401,1],
67783=>[97.325,-79.350,45.386,1],
67784=>[97.329,-79.341,45.371,1],
67785=>[97.349,-79.355,45.356,1],
67786=>[97.368,-79.370,45.341,1],
67787=>[97.387,-79.386,45.325,1],
67788=>[97.406,-79.401,45.310,1],
67789=>[97.425,-79.416,45.295,1],
67790=>[97.444,-79.432,45.281,1],
67791=>[97.463,-79.447,45.267,1],
67792=>[97.483,-79.463,45.253,1],
67793=>[97.502,-79.478,45.239,1],
67794=>[97.521,-79.493,45.225,1],
67795=>[97.540,-79.508,45.212,1],
67796=>[97.560,-79.523,45.198,1],
67797=>[97.579,-79.538,45.185,1],
67798=>[97.598,-79.554,45.172,1],
67799=>[97.617,-79.570,45.159,1],
67800=>[97.636,-79.585,45.145,1],
67801=>[97.655,-79.600,45.132,1],
67802=>[97.674,-79.615,45.119,1],
67803=>[97.693,-79.630,45.107,1],
67804=>[97.713,-79.646,45.095,1],
67805=>[97.732,-79.661,45.082,1],
67806=>[97.751,-79.676,45.070,1],
67807=>[97.770,-79.692,45.058,1],
67808=>[97.789,-79.707,45.045,1],
67809=>[97.809,-79.722,45.033,1],
67810=>[97.828,-79.737,45.020,1],
67811=>[97.847,-79.753,45.008,1],
67812=>[97.866,-79.768,44.995,1],
67813=>[97.885,-79.783,44.982,1],
67814=>[97.904,-79.798,44.968,1],
67815=>[97.924,-79.814,44.955,1],
67816=>[97.943,-79.829,44.942,1],
67817=>[97.962,-79.845,44.930,1],
67818=>[97.981,-79.860,44.917,1],
67819=>[98.000,-79.875,44.904,1],
67820=>[98.019,-79.890,44.891,1],
67821=>[98.038,-79.905,44.880,1],
67822=>[98.058,-79.921,44.869,1],
67823=>[98.077,-79.936,44.858,1],
67824=>[98.096,-79.952,44.846,1],
67825=>[98.115,-79.967,44.837,1],
67826=>[98.135,-79.982,44.827,1],
67827=>[98.154,-79.997,44.817,1],
67828=>[98.173,-80.012,44.808,1],
67829=>[98.192,-80.028,44.798,1],
67830=>[98.211,-80.043,44.788,1],
67831=>[98.230,-80.059,44.779,1],
67832=>[98.249,-80.074,44.771,1],
67833=>[98.269,-80.089,44.762,1],
67834=>[98.288,-80.104,44.754,1],
67835=>[98.307,-80.119,44.745,1],
67836=>[98.326,-80.135,44.738,1],
67837=>[98.345,-80.150,44.730,1],
67838=>[98.365,-80.165,44.723,1],
67839=>[98.384,-80.181,44.715,1],
67840=>[98.403,-80.196,44.708,1],
67841=>[98.422,-80.211,44.701,1],
67842=>[98.441,-80.227,44.695,1],
67843=>[98.460,-80.242,44.688,1],
67844=>[98.480,-80.257,44.681,1],
67845=>[98.499,-80.272,44.674,1],
67846=>[98.518,-80.287,44.668,1],
67847=>[98.541,-80.294,44.662,1],
67848=>[98.566,-80.297,44.656,1],
67849=>[98.590,-80.299,44.648,1],
67850=>[98.616,-80.302,44.641,1],
67851=>[98.640,-80.304,44.634,1],
67852=>[98.665,-80.306,44.626,1],
67853=>[98.690,-80.309,44.619,1],
67854=>[98.714,-80.312,44.613,1],
67855=>[98.739,-80.314,44.606,1],
67856=>[98.762,-80.319,44.597,1],
67857=>[98.787,-80.328,44.589,1],
67858=>[98.810,-80.339,44.581,1],
67859=>[98.834,-80.350,44.572,1],
67860=>[98.857,-80.360,44.564,1],
67861=>[98.880,-80.371,44.558,1],
67862=>[98.904,-80.381,44.554,1],
67863=>[98.927,-80.392,44.548,1],
67864=>[98.950,-80.403,44.542,1],
67865=>[98.974,-80.413,44.535,1],
67866=>[98.997,-80.424,44.530,1],
67867=>[99.020,-80.435,44.525,1],
67868=>[99.043,-80.444,44.519,1],
67869=>[99.067,-80.455,44.514,1],
67870=>[99.090,-80.466,44.510,1],
67871=>[99.113,-80.476,44.506,1],
68198=>[93.444,-79.048,53.434,1],
68199=>[93.453,-79.046,53.421,1],
68200=>[93.464,-79.043,53.408,1],
68201=>[93.473,-79.041,53.396,1],
68202=>[93.484,-79.034,53.385,1],
68203=>[93.495,-79.023,53.375,1],
68204=>[93.505,-79.015,53.364,1],
68205=>[93.513,-79.008,53.355,1],
68206=>[93.522,-79.001,53.346,1],
68207=>[93.530,-78.993,53.340,1],
68208=>[93.539,-78.987,53.333,1],
68209=>[93.547,-78.980,53.328,1],
68210=>[93.555,-78.973,53.324,1],
68211=>[93.564,-78.966,53.324,1],
68212=>[93.572,-78.959,53.325,1],
68213=>[93.577,-78.964,53.325,1],
68214=>[93.590,-78.963,53.323,1],
68215=>[93.609,-78.959,53.319,1],
68216=>[93.624,-78.955,53.314,1],
68217=>[93.638,-78.953,53.306,1],
68218=>[93.652,-78.951,53.297,1],
68219=>[93.669,-78.949,53.288,1],
68220=>[93.685,-78.946,53.280,1],
68221=>[93.702,-78.943,53.272,1],
68222=>[93.719,-78.941,53.262,1],
68223=>[93.731,-78.940,53.251,1],
68224=>[93.741,-78.939,53.242,1],
68225=>[93.751,-78.937,53.231,1],
68226=>[93.759,-78.937,53.219,1],
68227=>[93.765,-78.937,53.207,1],
68228=>[93.772,-78.937,53.195,1],
68229=>[93.779,-78.937,53.182,1],
68230=>[93.785,-78.937,53.168,1],
68231=>[93.792,-78.937,53.157,1],
68232=>[93.798,-78.937,53.146,1],
68233=>[93.805,-78.937,53.136,1],
68234=>[93.813,-78.935,53.126,1],
68235=>[93.821,-78.932,53.115,1],
68236=>[93.831,-78.924,53.102,1],
68237=>[93.842,-78.913,53.089,1],
68238=>[93.851,-78.905,53.075,1],
68239=>[93.853,-78.906,53.062,1],
68240=>[93.854,-78.908,53.048,1],
68241=>[93.856,-78.910,53.034,1],
68242=>[93.857,-78.912,53.020,1],
68243=>[93.859,-78.914,53.005,1],
68244=>[93.861,-78.916,52.987,1],
68245=>[93.861,-78.916,52.967,1],
68246=>[93.857,-78.911,52.946,1],
68247=>[93.852,-78.905,52.922,1],
68248=>[93.848,-78.901,52.897,1],
68249=>[93.845,-78.897,52.872,1],
68250=>[93.842,-78.894,52.848,1],
68251=>[93.847,-78.894,52.820,1],
68252=>[93.864,-78.900,52.793,1],
68253=>[93.881,-78.905,52.767,1],
68254=>[93.898,-78.911,52.741,1],
68255=>[93.915,-78.917,52.714,1],
68256=>[93.932,-78.922,52.687,1],
68257=>[93.948,-78.927,52.661,1],
68258=>[93.968,-78.931,52.632,1],
68259=>[93.988,-78.933,52.605,1],
68260=>[94.008,-78.936,52.580,1],
68261=>[94.024,-78.936,52.554,1],
68262=>[94.034,-78.932,52.529,1],
68263=>[94.044,-78.923,52.505,1],
68264=>[94.053,-78.912,52.482,1],
68265=>[94.062,-78.902,52.458,1],
68266=>[94.071,-78.891,52.434,1],
68267=>[94.080,-78.880,52.409,1],
68268=>[94.089,-78.870,52.386,1],
68269=>[94.099,-78.859,52.363,1],
68270=>[94.108,-78.849,52.339,1],
68271=>[94.115,-78.844,52.314,1],
68272=>[94.122,-78.839,52.289,1],
68273=>[94.129,-78.834,52.262,1],
68274=>[94.140,-78.830,52.236,1],
68275=>[94.154,-78.828,52.211,1],
68276=>[94.170,-78.820,52.187,1],
68277=>[94.186,-78.810,52.162,1],
68278=>[94.202,-78.800,52.137,1],
68279=>[94.219,-78.790,52.110,1],
68280=>[94.236,-78.780,52.084,1],
68281=>[94.252,-78.770,52.057,1],
68282=>[94.268,-78.760,52.032,1],
68283=>[94.281,-78.754,52.005,1],
68284=>[94.290,-78.752,51.977,1],
68285=>[94.298,-78.749,51.947,1],
68286=>[94.313,-78.750,51.915,1],
68287=>[94.328,-78.752,51.882,1],
68288=>[94.343,-78.755,51.847,1],
68289=>[94.359,-78.757,51.815,1],
68290=>[94.374,-78.758,51.784,1],
68291=>[94.390,-78.761,51.754,1],
68292=>[94.403,-78.766,51.722,1],
68293=>[94.418,-78.748,51.688,1],
68294=>[94.436,-78.752,51.652,1],
68295=>[94.454,-78.756,51.615,1],
68296=>[94.471,-78.761,51.581,1],
68297=>[94.488,-78.765,51.547,1],
68298=>[94.506,-78.770,51.514,1],
68299=>[94.523,-78.774,51.483,1],
68300=>[94.541,-78.778,51.450,1],
68301=>[94.558,-78.783,51.418,1],
68302=>[94.577,-78.787,51.386,1],
68303=>[94.604,-78.794,51.354,1],
68304=>[94.631,-78.801,51.322,1],
68305=>[94.659,-78.808,51.288,1],
68306=>[94.682,-78.813,51.251,1],
68307=>[94.696,-78.814,51.214,1],
68308=>[94.711,-78.815,51.178,1],
68309=>[94.726,-78.817,51.145,1],
68310=>[94.733,-78.822,51.114,1],
68311=>[94.730,-78.831,51.082,1],
68312=>[94.728,-78.840,51.049,1],
68313=>[94.725,-78.849,51.014,1],
68314=>[94.704,-78.839,50.975,1],
68315=>[94.683,-78.828,50.934,1],
68316=>[94.673,-78.823,50.890,1],
68317=>[94.677,-78.822,50.847,1],
68318=>[94.681,-78.821,50.804,1],
68319=>[94.685,-78.821,50.761,1],
68320=>[94.689,-78.820,50.718,1],
68321=>[94.699,-78.821,50.675,1],
68322=>[94.722,-78.823,50.632,1],
68323=>[94.751,-78.818,50.590,1],
68324=>[94.782,-78.811,50.549,1],
68325=>[94.813,-78.802,50.509,1],
68326=>[94.844,-78.795,50.471,1],
68327=>[94.864,-78.790,50.438,1],
68328=>[94.883,-78.787,50.405,1],
68329=>[94.889,-78.795,50.372,1],
68330=>[94.888,-78.811,50.335,1],
68331=>[94.887,-78.826,50.296,1],
68332=>[94.884,-78.836,50.255,1],
68333=>[94.876,-78.836,50.211,1],
68334=>[94.867,-78.835,50.170,1],
68335=>[94.859,-78.835,50.129,1],
68336=>[94.852,-78.834,50.088,1],
68337=>[94.844,-78.833,50.046,1],
68338=>[94.836,-78.833,50.006,1],
68339=>[94.828,-78.833,49.967,1],
68340=>[94.836,-78.834,49.928,1],
68341=>[94.852,-78.837,49.887,1],
68342=>[94.870,-78.840,49.846,1],
68343=>[94.886,-78.843,49.806,1],
68344=>[94.900,-78.855,49.768,1],
68345=>[94.908,-78.883,49.730,1],
68346=>[94.916,-78.911,49.692,1],
68347=>[94.923,-78.939,49.657,1],
68348=>[94.946,-78.955,49.622,1],
68349=>[94.978,-78.962,49.587,1],
68350=>[94.995,-78.971,49.554,1],
68351=>[95.011,-78.981,49.521,1],
68352=>[95.028,-78.990,49.487,1],
68353=>[95.044,-78.999,49.453,1],
68354=>[95.063,-79.008,49.415,1],
68355=>[95.093,-79.015,49.376,1],
68356=>[95.122,-79.021,49.336,1],
68357=>[95.151,-79.028,49.297,1],
68358=>[95.181,-79.035,49.256,1],
68359=>[95.205,-79.037,49.215,1],
68360=>[95.230,-79.040,49.174,1],
68361=>[95.255,-79.042,49.132,1],
68362=>[95.279,-79.044,49.091,1],
68363=>[95.304,-79.046,49.049,1],
68364=>[95.328,-79.049,49.006,1],
68365=>[95.353,-79.051,48.963,1],
68366=>[95.376,-79.054,48.919,1],
68367=>[95.385,-79.059,48.876,1],
68368=>[95.390,-79.078,48.832,1],
68369=>[95.394,-79.099,48.787,1],
68370=>[95.397,-79.115,48.742,1],
68371=>[95.399,-79.131,48.698,1],
68372=>[95.402,-79.147,48.653,1],
68373=>[95.406,-79.163,48.608,1],
68374=>[95.419,-79.178,48.564,1],
68375=>[95.432,-79.194,48.520,1],
68376=>[95.445,-79.210,48.477,1],
68377=>[95.458,-79.225,48.434,1],
68378=>[95.471,-79.241,48.391,1],
68379=>[95.497,-79.251,48.347,1],
68380=>[95.525,-79.242,48.304,1],
68381=>[95.547,-79.229,48.261,1],
68382=>[95.569,-79.216,48.219,1],
68383=>[95.592,-79.203,48.177,1],
68384=>[95.615,-79.190,48.135,1],
68385=>[95.637,-79.177,48.093,1],
68386=>[95.660,-79.163,48.051,1],
68387=>[95.682,-79.150,48.010,1],
68388=>[95.693,-79.144,47.970,1],
68389=>[95.703,-79.139,47.930,1],
68390=>[95.713,-79.133,47.891,1],
68391=>[95.743,-79.140,47.852,1],
68392=>[95.776,-79.149,47.811,1],
68393=>[95.810,-79.158,47.771,1],
68394=>[95.843,-79.168,47.731,1],
68395=>[95.871,-79.174,47.690,1],
68396=>[95.883,-79.175,47.651,1],
68397=>[95.895,-79.175,47.611,1],
68398=>[95.912,-79.189,47.571,1],
68399=>[95.912,-79.186,47.531,1],
68400=>[95.908,-79.178,47.492,1],
68401=>[95.903,-79.169,47.454,1],
68402=>[95.899,-79.159,47.415,1],
68403=>[95.933,-79.144,47.376,1],
68404=>[95.919,-79.108,47.337,1],
68405=>[95.918,-79.084,47.298,1],
68406=>[95.969,-79.118,47.260,1],
68407=>[96.020,-79.152,47.223,1],
68408=>[96.071,-79.186,47.186,1],
68409=>[96.121,-79.216,47.149,1],
68410=>[96.149,-79.162,47.113,1],
68411=>[96.176,-79.109,47.078,1],
68412=>[96.204,-79.056,47.043,1],
68413=>[96.237,-79.032,47.009,1],
68414=>[96.271,-79.019,46.976,1],
68415=>[96.305,-79.006,46.943,1],
68416=>[96.335,-79.037,46.911,1],
68417=>[96.364,-79.082,46.880,1],
68418=>[96.392,-79.128,46.849,1],
68419=>[96.420,-79.174,46.818,1],
68420=>[96.449,-79.219,46.788,1],
68421=>[96.475,-79.256,46.758,1],
68422=>[96.489,-79.257,46.727,1],
68423=>[96.511,-79.265,46.697,1],
68424=>[96.537,-79.280,46.666,1],
68425=>[96.552,-79.284,46.634,1],
68426=>[96.561,-79.281,46.603,1],
68427=>[96.570,-79.279,46.573,1],
68428=>[96.579,-79.278,46.543,1],
68429=>[96.601,-79.280,46.514,1],
68430=>[96.624,-79.282,46.485,1],
68431=>[96.647,-79.285,46.456,1],
68432=>[96.670,-79.288,46.427,1],
68433=>[96.693,-79.290,46.399,1],
68434=>[96.716,-79.292,46.372,1],
68435=>[96.738,-79.295,46.345,1],
68436=>[96.761,-79.297,46.319,1],
68437=>[96.784,-79.300,46.294,1],
68438=>[96.806,-79.297,46.268,1],
68439=>[96.824,-79.275,46.242,1],
68440=>[96.843,-79.254,46.216,1],
68441=>[96.862,-79.234,46.193,1],
68442=>[96.880,-79.212,46.171,1],
68443=>[96.899,-79.191,46.149,1],
68444=>[96.923,-79.179,46.126,1],
68445=>[96.960,-79.190,46.104,1],
68446=>[96.997,-79.200,46.082,1],
68447=>[97.034,-79.210,46.061,1],
68448=>[97.051,-79.213,46.040,1],
68449=>[97.079,-79.218,46.020,1],
68450=>[97.080,-79.219,45.999,1],
68451=>[97.079,-79.240,45.978,1],
68452=>[97.094,-79.241,45.957,1],
68453=>[97.109,-79.241,45.935,1],
68454=>[97.123,-79.241,45.914,1],
68455=>[97.139,-79.241,45.895,1],
68456=>[97.153,-79.241,45.876,1],
68457=>[97.168,-79.241,45.857,1],
68458=>[97.150,-79.265,45.837,1],
68459=>[97.166,-79.252,45.817,1],
68460=>[97.167,-79.245,45.796,1],
68461=>[97.169,-79.238,45.777,1],
68462=>[97.171,-79.231,45.759,1],
68463=>[97.172,-79.225,45.741,1],
68464=>[97.196,-79.216,45.723,1],
68465=>[97.220,-79.213,45.705,1],
68466=>[97.224,-79.226,45.687,1],
68467=>[97.228,-79.239,45.669,1],
68468=>[97.232,-79.252,45.650,1],
68469=>[97.236,-79.264,45.632,1],
68470=>[97.240,-79.277,45.616,1],
68471=>[97.244,-79.290,45.600,1],
68472=>[97.248,-79.303,45.583,1],
68473=>[97.252,-79.316,45.566,1],
68474=>[97.256,-79.328,45.549,1],
68475=>[97.260,-79.341,45.531,1],
68476=>[97.264,-79.353,45.514,1],
68477=>[97.277,-79.370,45.499,1],
68478=>[97.291,-79.387,45.484,1],
68479=>[97.293,-79.405,45.468,1],
68480=>[97.321,-79.393,45.452,1],
68481=>[97.346,-79.379,45.437,1],
68482=>[97.354,-79.364,45.421,1],
68483=>[97.360,-79.352,45.405,1],
68484=>[97.366,-79.339,45.390,1],
68485=>[97.372,-79.327,45.375,1],
68486=>[97.374,-79.325,45.360,1],
68487=>[97.361,-79.356,45.346,1],
68488=>[97.395,-79.351,45.330,1],
68489=>[97.415,-79.366,45.315,1],
68490=>[97.434,-79.382,45.300,1],
68491=>[97.453,-79.397,45.286,1],
68492=>[97.472,-79.413,45.273,1],
68493=>[97.491,-79.428,45.259,1],
68494=>[97.510,-79.444,45.244,1],
68495=>[97.529,-79.459,45.231,1],
68496=>[97.548,-79.474,45.217,1],
68497=>[97.567,-79.490,45.204,1],
68498=>[97.586,-79.505,45.191,1],
68499=>[97.605,-79.520,45.178,1],
68500=>[97.625,-79.536,45.165,1],
68501=>[97.644,-79.551,45.152,1],
68502=>[97.662,-79.567,45.139,1],
68503=>[97.681,-79.582,45.127,1],
68504=>[97.701,-79.598,45.115,1],
68505=>[97.720,-79.613,45.102,1],
68506=>[97.739,-79.628,45.090,1],
68507=>[97.758,-79.644,45.078,1],
68508=>[97.777,-79.659,45.066,1],
68509=>[97.796,-79.674,45.054,1],
68510=>[97.815,-79.690,45.042,1],
68511=>[97.834,-79.705,45.029,1],
68512=>[97.853,-79.720,45.017,1],
68513=>[97.872,-79.736,45.005,1],
68514=>[97.891,-79.751,44.991,1],
68515=>[97.911,-79.767,44.978,1],
68516=>[97.930,-79.783,44.965,1],
68517=>[97.948,-79.798,44.952,1],
68518=>[97.967,-79.813,44.939,1],
68519=>[97.987,-79.828,44.926,1],
68520=>[98.006,-79.844,44.913,1],
68521=>[98.025,-79.859,44.901,1],
68522=>[98.044,-79.874,44.890,1],
68523=>[98.063,-79.889,44.879,1],
68524=>[98.082,-79.905,44.868,1],
68525=>[98.101,-79.921,44.856,1],
68526=>[98.121,-79.936,44.847,1],
68527=>[98.140,-79.951,44.838,1],
68528=>[98.159,-79.966,44.828,1],
68529=>[98.178,-79.981,44.818,1],
68530=>[98.198,-79.996,44.808,1],
68531=>[98.217,-80.012,44.799,1],
68532=>[98.236,-80.027,44.789,1],
68533=>[98.255,-80.043,44.781,1],
68534=>[98.274,-80.058,44.773,1],
68535=>[98.293,-80.073,44.765,1],
68536=>[98.312,-80.088,44.757,1],
68537=>[98.332,-80.103,44.749,1],
68538=>[98.351,-80.119,44.742,1],
68539=>[98.370,-80.134,44.734,1],
68540=>[98.389,-80.149,44.728,1],
68541=>[98.408,-80.165,44.721,1],
68542=>[98.427,-80.180,44.713,1],
68543=>[98.447,-80.195,44.707,1],
68544=>[98.466,-80.211,44.700,1],
68545=>[98.485,-80.226,44.693,1],
68546=>[98.504,-80.241,44.686,1],
68547=>[98.523,-80.256,44.680,1],
68548=>[98.547,-80.262,44.674,1],
68549=>[98.571,-80.265,44.668,1],
68550=>[98.596,-80.268,44.662,1],
68551=>[98.621,-80.270,44.655,1],
68552=>[98.644,-80.274,44.649,1],
68553=>[98.666,-80.278,44.643,1],
68554=>[98.688,-80.282,44.638,1],
68555=>[98.709,-80.287,44.633,1],
68556=>[98.730,-80.291,44.626,1],
68557=>[98.752,-80.297,44.617,1],
68558=>[98.773,-80.307,44.606,1],
68559=>[98.814,-80.312,44.594,1],
68560=>[98.838,-80.322,44.584,1],
68561=>[98.861,-80.333,44.576,1],
68562=>[98.884,-80.344,44.570,1],
68563=>[98.908,-80.354,44.564,1],
68564=>[98.931,-80.365,44.558,1],
68565=>[98.954,-80.375,44.552,1],
68566=>[98.977,-80.386,44.546,1],
68567=>[99.001,-80.397,44.540,1],
68568=>[99.024,-80.407,44.534,1],
68569=>[99.047,-80.417,44.529,1],
68570=>[99.071,-80.428,44.524,1],
68571=>[99.094,-80.438,44.520,1],
68572=>[99.117,-80.449,44.515,1],
68573=>[99.141,-80.460,44.510,1],
68574=>[99.164,-80.470,44.505,1],
68575=>[99.187,-80.481,44.501,1],
68900=>[93.454,-79.035,53.442,1],
68901=>[93.464,-79.033,53.429,1],
68902=>[93.473,-79.030,53.417,1],
68903=>[93.483,-79.028,53.406,1],
68904=>[93.494,-79.019,53.395,1],
68905=>[93.505,-79.009,53.385,1],
68906=>[93.514,-79.001,53.375,1],
68907=>[93.523,-78.994,53.365,1],
68908=>[93.532,-78.987,53.358,1],
68909=>[93.540,-78.981,53.352,1],
68910=>[93.548,-78.973,53.345,1],
68911=>[93.556,-78.966,53.341,1],
68912=>[93.565,-78.959,53.338,1],
68913=>[93.573,-78.952,53.337,1],
68914=>[93.581,-78.946,53.336,1],
68915=>[93.588,-78.946,53.335,1],
68916=>[93.606,-78.942,53.333,1],
68917=>[93.620,-78.940,53.327,1],
68918=>[93.635,-78.937,53.319,1],
68919=>[93.652,-78.935,53.311,1],
68920=>[93.669,-78.933,53.303,1],
68921=>[93.686,-78.930,53.294,1],
68922=>[93.703,-78.928,53.286,1],
68923=>[93.718,-78.926,53.278,1],
68924=>[93.727,-78.925,53.268,1],
68925=>[93.737,-78.924,53.259,1],
68926=>[93.747,-78.923,53.249,1],
68927=>[93.755,-78.922,53.237,1],
68928=>[93.762,-78.922,53.225,1],
68929=>[93.768,-78.922,53.213,1],
68930=>[93.775,-78.922,53.201,1],
68931=>[93.781,-78.922,53.189,1],
68932=>[93.788,-78.922,53.177,1],
68933=>[93.795,-78.922,53.167,1],
68934=>[93.801,-78.922,53.156,1],
68935=>[93.808,-78.922,53.146,1],
68936=>[93.815,-78.921,53.135,1],
68937=>[93.827,-78.908,53.123,1],
68938=>[93.838,-78.897,53.109,1],
68939=>[93.845,-78.891,53.095,1],
68940=>[93.846,-78.893,53.081,1],
68941=>[93.848,-78.895,53.067,1],
68942=>[93.850,-78.896,53.053,1],
68943=>[93.851,-78.899,53.038,1],
68944=>[93.853,-78.900,53.023,1],
68945=>[93.852,-78.899,53.003,1],
68946=>[93.848,-78.893,52.982,1],
68947=>[93.843,-78.889,52.959,1],
68948=>[93.839,-78.883,52.935,1],
68949=>[93.834,-78.878,52.910,1],
68950=>[93.830,-78.873,52.885,1],
68951=>[93.827,-78.869,52.860,1],
68952=>[93.839,-78.873,52.832,1],
68953=>[93.856,-78.878,52.805,1],
68954=>[93.873,-78.883,52.779,1],
68955=>[93.893,-78.886,52.753,1],
68956=>[93.913,-78.888,52.726,1],
68957=>[93.934,-78.890,52.699,1],
68958=>[93.954,-78.893,52.672,1],
68959=>[93.974,-78.895,52.644,1],
68960=>[93.995,-78.897,52.617,1],
68961=>[94.015,-78.899,52.591,1],
68962=>[94.033,-78.899,52.567,1],
68963=>[94.043,-78.896,52.543,1],
68964=>[94.053,-78.892,52.520,1],
68965=>[94.063,-78.888,52.497,1],
68966=>[94.073,-78.883,52.473,1],
68967=>[94.082,-78.872,52.448,1],
68968=>[94.091,-78.861,52.424,1],
68969=>[94.100,-78.851,52.401,1],
68970=>[94.109,-78.840,52.378,1],
68971=>[94.118,-78.830,52.354,1],
68972=>[94.127,-78.823,52.329,1],
68973=>[94.134,-78.818,52.303,1],
68974=>[94.141,-78.813,52.276,1],
68975=>[94.154,-78.810,52.247,1],
68976=>[94.169,-78.808,52.222,1],
68977=>[94.184,-78.802,52.197,1],
68978=>[94.200,-78.792,52.172,1],
68979=>[94.216,-78.782,52.147,1],
68980=>[94.233,-78.772,52.120,1],
68981=>[94.249,-78.762,52.092,1],
68982=>[94.266,-78.752,52.064,1],
68983=>[94.280,-78.744,52.037,1],
68984=>[94.288,-78.742,52.009,1],
68985=>[94.297,-78.740,51.981,1],
68986=>[94.306,-78.738,51.951,1],
68987=>[94.317,-78.737,51.920,1],
68988=>[94.333,-78.739,51.888,1],
68989=>[94.348,-78.742,51.855,1],
68990=>[94.364,-78.743,51.823,1],
68991=>[94.379,-78.745,51.792,1],
68992=>[94.393,-78.749,51.761,1],
68993=>[94.406,-78.755,51.729,1],
68994=>[94.421,-78.741,51.696,1],
68995=>[94.438,-78.743,51.663,1],
68996=>[94.456,-78.748,51.627,1],
68997=>[94.473,-78.752,51.595,1],
68998=>[94.491,-78.756,51.562,1],
68999=>[94.508,-78.761,51.530,1],
69000=>[94.526,-78.765,51.498,1],
69001=>[94.543,-78.770,51.465,1],
69002=>[94.561,-78.774,51.433,1],
69003=>[94.588,-78.781,51.400,1],
69004=>[94.615,-78.788,51.367,1],
69005=>[94.642,-78.795,51.334,1],
69006=>[94.670,-78.802,51.300,1],
69007=>[94.697,-78.808,51.264,1],
69008=>[94.717,-78.812,51.227,1],
69009=>[94.732,-78.813,51.191,1],
69010=>[94.747,-78.814,51.157,1],
69011=>[94.747,-78.823,51.125,1],
69012=>[94.744,-78.831,51.092,1],
69013=>[94.742,-78.840,51.059,1],
69014=>[94.740,-78.849,51.025,1],
69015=>[94.737,-78.858,50.988,1],
69016=>[94.718,-78.851,50.949,1],
69017=>[94.697,-78.840,50.907,1],
69018=>[94.675,-78.830,50.864,1],
69019=>[94.661,-78.822,50.821,1],
69020=>[94.665,-78.821,50.778,1],
69021=>[94.669,-78.821,50.735,1],
69022=>[94.694,-78.821,50.692,1],
69023=>[94.725,-78.813,50.649,1],
69024=>[94.756,-78.805,50.608,1],
69025=>[94.787,-78.797,50.566,1],
69026=>[94.818,-78.789,50.525,1],
69027=>[94.844,-78.783,50.484,1],
69028=>[94.862,-78.779,50.448,1],
69029=>[94.881,-78.776,50.413,1],
69030=>[94.888,-78.783,50.379,1],
69031=>[94.887,-78.799,50.344,1],
69032=>[94.886,-78.814,50.307,1],
69033=>[94.884,-78.830,50.268,1],
69034=>[94.880,-78.838,50.227,1],
69035=>[94.872,-78.838,50.186,1],
69036=>[94.864,-78.837,50.145,1],
69037=>[94.856,-78.836,50.103,1],
69038=>[94.848,-78.836,50.060,1],
69039=>[94.840,-78.836,50.019,1],
69040=>[94.833,-78.835,49.978,1],
69041=>[94.837,-78.836,49.939,1],
69042=>[94.853,-78.839,49.899,1],
69043=>[94.870,-78.843,49.859,1],
69044=>[94.887,-78.846,49.821,1],
69045=>[94.904,-78.849,49.781,1],
69046=>[94.918,-78.858,49.743,1],
69047=>[94.926,-78.886,49.705,1],
69048=>[94.934,-78.914,49.670,1],
69049=>[94.949,-78.937,49.635,1],
69050=>[94.981,-78.943,49.600,1],
69051=>[94.997,-78.952,49.567,1],
69052=>[95.014,-78.962,49.531,1],
69053=>[95.030,-78.971,49.496,1],
69054=>[95.050,-78.980,49.461,1],
69055=>[95.079,-78.987,49.422,1],
69056=>[95.109,-78.993,49.383,1],
69057=>[95.138,-79.000,49.343,1],
69058=>[95.168,-79.007,49.303,1],
69059=>[95.197,-79.014,49.263,1],
69060=>[95.225,-79.018,49.224,1],
69061=>[95.249,-79.021,49.185,1],
69062=>[95.273,-79.023,49.143,1],
69063=>[95.298,-79.025,49.101,1],
69064=>[95.323,-79.028,49.059,1],
69065=>[95.347,-79.030,49.017,1],
69066=>[95.372,-79.032,48.974,1],
69067=>[95.385,-79.037,48.931,1],
69068=>[95.394,-79.043,48.886,1],
69069=>[95.400,-79.057,48.842,1],
69070=>[95.404,-79.077,48.796,1],
69071=>[95.409,-79.097,48.750,1],
69072=>[95.414,-79.118,48.707,1],
69073=>[95.416,-79.134,48.663,1],
69074=>[95.419,-79.150,48.619,1],
69075=>[95.421,-79.166,48.575,1],
69076=>[95.433,-79.181,48.531,1],
69077=>[95.446,-79.197,48.487,1],
69078=>[95.459,-79.213,48.444,1],
69079=>[95.472,-79.228,48.401,1],
69080=>[95.495,-79.240,48.357,1],
69081=>[95.522,-79.231,48.312,1],
69082=>[95.544,-79.218,48.267,1],
69083=>[95.566,-79.205,48.227,1],
69084=>[95.589,-79.191,48.185,1],
69085=>[95.612,-79.178,48.142,1],
69086=>[95.634,-79.165,48.099,1],
69087=>[95.657,-79.152,48.057,1],
69088=>[95.679,-79.139,48.016,1],
69089=>[95.696,-79.129,47.976,1],
69090=>[95.706,-79.124,47.935,1],
69091=>[95.716,-79.118,47.894,1],
69092=>[95.749,-79.128,47.855,1],
69093=>[95.783,-79.137,47.813,1],
69094=>[95.817,-79.146,47.772,1],
69095=>[95.842,-79.152,47.732,1],
69096=>[95.854,-79.153,47.692,1],
69097=>[95.867,-79.153,47.652,1],
69098=>[95.879,-79.154,47.612,1],
69099=>[95.891,-79.155,47.573,1],
69100=>[95.909,-79.174,47.532,1],
69101=>[95.917,-79.179,47.492,1],
69102=>[95.912,-79.171,47.453,1],
69103=>[95.908,-79.162,47.414,1],
69104=>[95.919,-79.150,47.374,1],
69105=>[95.947,-79.125,47.335,1],
69106=>[95.935,-79.090,47.296,1],
69107=>[95.986,-79.124,47.258,1],
69108=>[96.037,-79.157,47.221,1],
69109=>[96.088,-79.190,47.184,1],
69110=>[96.118,-79.147,47.148,1],
69111=>[96.146,-79.093,47.112,1],
69112=>[96.176,-79.056,47.077,1],
69113=>[96.210,-79.043,47.042,1],
69114=>[96.245,-79.031,47.008,1],
69115=>[96.279,-79.018,46.975,1],
69116=>[96.313,-79.005,46.943,1],
69117=>[96.343,-79.036,46.911,1],
69118=>[96.372,-79.082,46.880,1],
69119=>[96.400,-79.128,46.849,1],
69120=>[96.429,-79.173,46.819,1],
69121=>[96.457,-79.219,46.788,1],
69122=>[96.477,-79.236,46.758,1],
69123=>[96.491,-79.237,46.727,1],
69124=>[96.506,-79.237,46.696,1],
69125=>[96.525,-79.243,46.664,1],
69126=>[96.549,-79.255,46.632,1],
69127=>[96.558,-79.253,46.601,1],
69128=>[96.568,-79.251,46.572,1],
69129=>[96.586,-79.252,46.542,1],
69130=>[96.609,-79.255,46.512,1],
69131=>[96.632,-79.257,46.483,1],
69132=>[96.655,-79.259,46.454,1],
69133=>[96.678,-79.263,46.426,1],
69134=>[96.700,-79.265,46.397,1],
69135=>[96.723,-79.267,46.370,1],
69136=>[96.746,-79.270,46.343,1],
69137=>[96.769,-79.272,46.318,1],
69138=>[96.792,-79.275,46.292,1],
69139=>[96.814,-79.273,46.266,1],
69140=>[96.832,-79.252,46.240,1],
69141=>[96.851,-79.231,46.215,1],
69142=>[96.870,-79.210,46.191,1],
69143=>[96.888,-79.189,46.168,1],
69144=>[96.907,-79.168,46.145,1],
69145=>[96.944,-79.178,46.123,1],
69146=>[96.981,-79.188,46.101,1],
69147=>[97.018,-79.198,46.078,1],
69148=>[97.021,-79.213,46.056,1],
69149=>[97.056,-79.179,46.035,1],
69150=>[97.081,-79.208,46.015,1],
69151=>[97.077,-79.209,45.996,1],
69152=>[97.085,-79.209,45.975,1],
69153=>[97.085,-79.227,45.955,1],
69154=>[97.100,-79.227,45.934,1],
69155=>[97.115,-79.227,45.913,1],
69156=>[97.130,-79.228,45.893,1],
69157=>[97.145,-79.228,45.874,1],
69158=>[97.159,-79.228,45.856,1],
69159=>[97.149,-79.244,45.837,1],
69160=>[97.166,-79.231,45.817,1],
69161=>[97.168,-79.225,45.797,1],
69162=>[97.169,-79.217,45.778,1],
69163=>[97.171,-79.210,45.759,1],
69164=>[97.173,-79.203,45.742,1],
69165=>[97.174,-79.197,45.724,1],
69166=>[97.199,-79.187,45.706,1],
69167=>[97.210,-79.196,45.688,1],
69168=>[97.214,-79.209,45.669,1],
69169=>[97.218,-79.222,45.652,1],
69170=>[97.221,-79.234,45.635,1],
69171=>[97.225,-79.247,45.619,1],
69172=>[97.229,-79.259,45.602,1],
69173=>[97.233,-79.272,45.585,1],
69174=>[97.237,-79.285,45.568,1],
69175=>[97.251,-79.302,45.551,1],
69176=>[97.265,-79.319,45.534,1],
69177=>[97.280,-79.335,45.518,1],
69178=>[97.294,-79.353,45.503,1],
69179=>[97.308,-79.369,45.488,1],
69180=>[97.297,-79.388,45.472,1],
69181=>[97.318,-79.380,45.456,1],
69182=>[97.353,-79.366,45.441,1],
69183=>[97.374,-79.353,45.425,1],
69184=>[97.387,-79.341,45.409,1],
69185=>[97.400,-79.329,45.394,1],
69186=>[97.412,-79.317,45.379,1],
69187=>[97.418,-79.305,45.365,1],
69188=>[97.418,-79.307,45.350,1],
69189=>[97.404,-79.339,45.335,1],
69190=>[97.391,-79.370,45.320,1],
69191=>[97.433,-79.357,45.306,1],
69192=>[97.461,-79.363,45.292,1],
69193=>[97.480,-79.378,45.278,1],
69194=>[97.500,-79.394,45.265,1],
69195=>[97.519,-79.409,45.250,1],
69196=>[97.537,-79.424,45.237,1],
69197=>[97.557,-79.440,45.224,1],
69198=>[97.576,-79.455,45.210,1],
69199=>[97.595,-79.470,45.198,1],
69200=>[97.614,-79.486,45.185,1],
69201=>[97.633,-79.501,45.172,1],
69202=>[97.652,-79.516,45.160,1],
69203=>[97.671,-79.532,45.147,1],
69204=>[97.690,-79.548,45.135,1],
69205=>[97.709,-79.563,45.122,1],
69206=>[97.728,-79.578,45.110,1],
69207=>[97.747,-79.594,45.098,1],
69208=>[97.767,-79.609,45.086,1],
69209=>[97.786,-79.624,45.074,1],
69210=>[97.805,-79.640,45.062,1],
69211=>[97.823,-79.655,45.050,1],
69212=>[97.843,-79.670,45.038,1],
69213=>[97.862,-79.686,45.027,1],
69214=>[97.881,-79.701,45.014,1],
69215=>[97.900,-79.717,45.001,1],
69216=>[97.919,-79.733,44.987,1],
69217=>[97.938,-79.748,44.974,1],
69218=>[97.957,-79.763,44.961,1],
69219=>[97.976,-79.778,44.948,1],
69220=>[97.995,-79.794,44.935,1],
69221=>[98.014,-79.809,44.923,1],
69222=>[98.033,-79.824,44.911,1],
69223=>[98.053,-79.840,44.899,1],
69224=>[98.072,-79.855,44.888,1],
69225=>[98.090,-79.871,44.877,1],
69226=>[98.109,-79.886,44.867,1],
69227=>[98.129,-79.902,44.857,1],
69228=>[98.148,-79.917,44.848,1],
69229=>[98.167,-79.933,44.839,1],
69230=>[98.186,-79.948,44.829,1],
69231=>[98.205,-79.963,44.819,1],
69232=>[98.224,-79.978,44.810,1],
69233=>[98.243,-79.994,44.800,1],
69234=>[98.262,-80.009,44.793,1],
69235=>[98.281,-80.024,44.785,1],
69236=>[98.300,-80.040,44.777,1],
69237=>[98.319,-80.055,44.769,1],
69238=>[98.339,-80.071,44.762,1],
69239=>[98.357,-80.087,44.754,1],
69240=>[98.376,-80.102,44.746,1],
69241=>[98.395,-80.117,44.739,1],
69242=>[98.415,-80.133,44.732,1],
69243=>[98.434,-80.148,44.725,1],
69244=>[98.453,-80.163,44.719,1],
69245=>[98.472,-80.178,44.713,1],
69246=>[98.491,-80.194,44.706,1],
69247=>[98.508,-80.211,44.700,1],
69248=>[98.526,-80.227,44.695,1],
69249=>[98.550,-80.233,44.689,1],
69250=>[98.570,-80.237,44.683,1],
69251=>[98.591,-80.242,44.678,1],
69252=>[98.613,-80.247,44.673,1],
69253=>[98.635,-80.251,44.668,1],
69254=>[98.656,-80.255,44.662,1],
69255=>[98.678,-80.259,44.656,1],
69256=>[98.700,-80.264,44.650,1],
69257=>[98.721,-80.269,44.644,1],
69258=>[98.742,-80.275,44.633,1],
69259=>[98.762,-80.286,44.621,1],
69260=>[98.786,-80.294,44.607,1],
69261=>[98.836,-80.293,44.596,1],
69262=>[98.865,-80.306,44.588,1],
69263=>[98.888,-80.316,44.581,1],
69264=>[98.912,-80.327,44.574,1],
69265=>[98.935,-80.337,44.568,1],
69266=>[98.958,-80.348,44.562,1],
69267=>[98.981,-80.359,44.557,1],
69268=>[99.005,-80.369,44.550,1],
69269=>[99.028,-80.380,44.544,1],
69270=>[99.051,-80.391,44.539,1],
69271=>[99.075,-80.400,44.535,1],
69272=>[99.098,-80.411,44.530,1],
69273=>[99.121,-80.422,44.525,1],
69274=>[99.144,-80.432,44.520,1],
69275=>[99.168,-80.443,44.514,1],
69276=>[99.191,-80.453,44.510,1],
69277=>[99.214,-80.464,44.507,1],
69278=>[99.238,-80.475,44.503,1],
69602=>[93.464,-79.021,53.450,1],
69603=>[93.474,-79.019,53.438,1],
69604=>[93.483,-79.017,53.426,1],
69605=>[93.493,-79.014,53.415,1],
69606=>[93.504,-79.006,53.405,1],
69607=>[93.515,-78.995,53.395,1],
69608=>[93.524,-78.987,53.385,1],
69609=>[93.533,-78.981,53.377,1],
69610=>[93.541,-78.974,53.370,1],
69611=>[93.549,-78.967,53.363,1],
69612=>[93.557,-78.960,53.357,1],
69613=>[93.566,-78.953,53.353,1],
69614=>[93.574,-78.946,53.349,1],
69615=>[93.582,-78.939,53.347,1],
69616=>[93.591,-78.932,53.345,1],
69617=>[93.602,-78.927,53.342,1],
69618=>[93.619,-78.924,53.337,1],
69619=>[93.636,-78.922,53.330,1],
69620=>[93.653,-78.920,53.323,1],
69621=>[93.670,-78.918,53.315,1],
69622=>[93.687,-78.915,53.307,1],
69623=>[93.704,-78.912,53.299,1],
69624=>[93.713,-78.912,53.291,1],
69625=>[93.723,-78.910,53.282,1],
69626=>[93.733,-78.909,53.274,1],
69627=>[93.743,-78.908,53.265,1],
69628=>[93.751,-78.907,53.255,1],
69629=>[93.758,-78.907,53.243,1],
69630=>[93.764,-78.907,53.231,1],
69631=>[93.771,-78.907,53.219,1],
69632=>[93.778,-78.907,53.209,1],
69633=>[93.784,-78.907,53.198,1],
69634=>[93.791,-78.908,53.187,1],
69635=>[93.798,-78.907,53.175,1],
69636=>[93.805,-78.905,53.165,1],
69637=>[93.812,-78.902,53.155,1],
69638=>[93.822,-78.893,53.144,1],
69639=>[93.833,-78.881,53.129,1],
69640=>[93.839,-78.877,53.115,1],
69641=>[93.840,-78.879,53.100,1],
69642=>[93.842,-78.881,53.085,1],
69643=>[93.844,-78.883,53.069,1],
69644=>[93.845,-78.885,53.054,1],
69645=>[93.843,-78.882,53.038,1],
69646=>[93.839,-78.877,53.017,1],
69647=>[93.834,-78.871,52.994,1],
69648=>[93.830,-78.866,52.971,1],
69649=>[93.825,-78.861,52.947,1],
69650=>[93.821,-78.855,52.921,1],
69651=>[93.817,-78.850,52.896,1],
69652=>[93.821,-78.846,52.871,1],
69653=>[93.839,-78.843,52.843,1],
69654=>[93.859,-78.845,52.816,1],
69655=>[93.880,-78.847,52.790,1],
69656=>[93.900,-78.849,52.764,1],
69657=>[93.920,-78.852,52.737,1],
69658=>[93.940,-78.854,52.710,1],
69659=>[93.961,-78.856,52.683,1],
69660=>[93.981,-78.858,52.656,1],
69661=>[94.002,-78.860,52.629,1],
69662=>[94.022,-78.862,52.604,1],
69663=>[94.041,-78.864,52.580,1],
69664=>[94.051,-78.860,52.556,1],
69665=>[94.061,-78.856,52.533,1],
69666=>[94.071,-78.852,52.510,1],
69667=>[94.081,-78.849,52.486,1],
69668=>[94.091,-78.845,52.462,1],
69669=>[94.102,-78.840,52.438,1],
69670=>[94.111,-78.833,52.414,1],
69671=>[94.120,-78.822,52.390,1],
69672=>[94.129,-78.811,52.366,1],
69673=>[94.138,-78.801,52.342,1],
69674=>[94.145,-78.796,52.315,1],
69675=>[94.155,-78.793,52.288,1],
69676=>[94.170,-78.789,52.260,1],
69677=>[94.183,-78.787,52.233,1],
69678=>[94.197,-78.783,52.207,1],
69679=>[94.214,-78.774,52.182,1],
69680=>[94.230,-78.764,52.156,1],
69681=>[94.247,-78.754,52.128,1],
69682=>[94.263,-78.744,52.099,1],
69683=>[94.278,-78.735,52.071,1],
69684=>[94.287,-78.733,52.042,1],
69685=>[94.296,-78.730,52.013,1],
69686=>[94.305,-78.728,51.984,1],
69687=>[94.313,-78.727,51.955,1],
69688=>[94.322,-78.724,51.924,1],
69689=>[94.338,-78.727,51.893,1],
69690=>[94.353,-78.729,51.862,1],
69691=>[94.368,-78.730,51.831,1],
69692=>[94.384,-78.733,51.800,1],
69693=>[94.397,-78.738,51.769,1],
69694=>[94.410,-78.742,51.736,1],
69695=>[94.424,-78.737,51.705,1],
69696=>[94.441,-78.735,51.674,1],
69697=>[94.459,-78.739,51.642,1],
69698=>[94.476,-78.743,51.609,1],
69699=>[94.493,-78.748,51.578,1],
69700=>[94.511,-78.752,51.548,1],
69701=>[94.529,-78.756,51.514,1],
69702=>[94.546,-78.761,51.481,1],
69703=>[94.572,-78.767,51.447,1],
69704=>[94.600,-78.774,51.413,1],
69705=>[94.627,-78.781,51.380,1],
69706=>[94.654,-78.788,51.347,1],
69707=>[94.681,-78.795,51.313,1],
69708=>[94.708,-78.802,51.277,1],
69709=>[94.736,-78.809,51.241,1],
69710=>[94.752,-78.811,51.205,1],
69711=>[94.763,-78.814,51.170,1],
69712=>[94.761,-78.823,51.136,1],
69713=>[94.759,-78.832,51.102,1],
69714=>[94.756,-78.841,51.069,1],
69715=>[94.754,-78.850,51.035,1],
69716=>[94.752,-78.859,50.999,1],
69717=>[94.748,-78.863,50.962,1],
69718=>[94.728,-78.853,50.922,1],
69719=>[94.706,-78.843,50.879,1],
69720=>[94.684,-78.832,50.836,1],
69721=>[94.662,-78.821,50.793,1],
69722=>[94.668,-78.815,50.750,1],
69723=>[94.699,-78.807,50.708,1],
69724=>[94.731,-78.799,50.665,1],
69725=>[94.762,-78.791,50.623,1],
69726=>[94.792,-78.783,50.581,1],
69727=>[94.824,-78.775,50.539,1],
69728=>[94.843,-78.771,50.497,1],
69729=>[94.861,-78.768,50.458,1],
69730=>[94.879,-78.764,50.421,1],
69731=>[94.887,-78.771,50.386,1],
69732=>[94.885,-78.787,50.352,1],
69733=>[94.884,-78.802,50.316,1],
69734=>[94.883,-78.818,50.279,1],
69735=>[94.882,-78.833,50.240,1],
69736=>[94.877,-78.840,50.200,1],
69737=>[94.869,-78.839,50.159,1],
69738=>[94.861,-78.839,50.117,1],
69739=>[94.853,-78.839,50.074,1],
69740=>[94.845,-78.838,50.032,1],
69741=>[94.837,-78.838,49.991,1],
69742=>[94.837,-78.839,49.952,1],
69743=>[94.854,-78.842,49.913,1],
69744=>[94.871,-78.845,49.873,1],
69745=>[94.888,-78.848,49.835,1],
69746=>[94.904,-78.851,49.795,1],
69747=>[94.921,-78.854,49.756,1],
69748=>[94.936,-78.861,49.719,1],
69749=>[94.945,-78.889,49.683,1],
69750=>[94.952,-78.917,49.648,1],
69751=>[94.983,-78.924,49.612,1],
69752=>[95.000,-78.933,49.578,1],
69753=>[95.016,-78.943,49.544,1],
69754=>[95.037,-78.951,49.508,1],
69755=>[95.066,-78.958,49.471,1],
69756=>[95.096,-78.965,49.432,1],
69757=>[95.125,-78.971,49.392,1],
69758=>[95.155,-78.978,49.351,1],
69759=>[95.184,-78.985,49.311,1],
69760=>[95.213,-78.992,49.272,1],
69761=>[95.243,-78.999,49.233,1],
69762=>[95.268,-79.002,49.194,1],
69763=>[95.293,-79.004,49.152,1],
69764=>[95.317,-79.006,49.111,1],
69765=>[95.341,-79.009,49.069,1],
69766=>[95.366,-79.011,49.026,1],
69767=>[95.386,-79.014,48.983,1],
69768=>[95.394,-79.020,48.939,1],
69769=>[95.403,-79.026,48.895,1],
69770=>[95.410,-79.035,48.851,1],
69771=>[95.415,-79.056,48.807,1],
69772=>[95.419,-79.076,48.762,1],
69773=>[95.424,-79.096,48.718,1],
69774=>[95.428,-79.116,48.675,1],
69775=>[95.433,-79.136,48.631,1],
69776=>[95.436,-79.153,48.585,1],
69777=>[95.439,-79.169,48.542,1],
69778=>[95.447,-79.184,48.498,1],
69779=>[95.460,-79.200,48.455,1],
69780=>[95.473,-79.216,48.412,1],
69781=>[95.492,-79.229,48.368,1],
69782=>[95.519,-79.220,48.324,1],
69783=>[95.541,-79.206,48.279,1],
69784=>[95.563,-79.194,48.237,1],
69785=>[95.586,-79.181,48.194,1],
69786=>[95.609,-79.167,48.151,1],
69787=>[95.631,-79.154,48.108,1],
69788=>[95.654,-79.140,48.066,1],
69789=>[95.676,-79.128,48.023,1],
69790=>[95.698,-79.115,47.981,1],
69791=>[95.709,-79.109,47.939,1],
69792=>[95.723,-79.106,47.898,1],
69793=>[95.756,-79.115,47.856,1],
69794=>[95.790,-79.125,47.815,1],
69795=>[95.813,-79.130,47.774,1],
69796=>[95.826,-79.131,47.732,1],
69797=>[95.838,-79.131,47.692,1],
69798=>[95.850,-79.132,47.651,1],
69799=>[95.862,-79.133,47.611,1],
69800=>[95.875,-79.134,47.572,1],
69801=>[95.888,-79.137,47.531,1],
69802=>[95.907,-79.158,47.491,1],
69803=>[95.921,-79.172,47.451,1],
69804=>[95.917,-79.164,47.412,1],
69805=>[95.913,-79.155,47.373,1],
69806=>[95.960,-79.137,47.335,1],
69807=>[95.961,-79.105,47.297,1],
69808=>[96.003,-79.129,47.258,1],
69809=>[96.054,-79.162,47.221,1],
69810=>[96.088,-79.131,47.184,1],
69811=>[96.116,-79.080,47.148,1],
69812=>[96.150,-79.068,47.111,1],
69813=>[96.184,-79.055,47.075,1],
69814=>[96.219,-79.042,47.041,1],
69815=>[96.253,-79.029,47.008,1],
69816=>[96.287,-79.016,46.975,1],
69817=>[96.321,-79.003,46.942,1],
69818=>[96.352,-79.035,46.912,1],
69819=>[96.380,-79.081,46.881,1],
69820=>[96.408,-79.127,46.850,1],
69821=>[96.437,-79.172,46.819,1],
69822=>[96.464,-79.215,46.789,1],
69823=>[96.479,-79.216,46.758,1],
69824=>[96.493,-79.216,46.728,1],
69825=>[96.508,-79.216,46.695,1],
69826=>[96.523,-79.217,46.663,1],
69827=>[96.540,-79.220,46.631,1],
69828=>[96.555,-79.225,46.601,1],
69829=>[96.572,-79.225,46.571,1],
69830=>[96.594,-79.227,46.541,1],
69831=>[96.617,-79.230,46.511,1],
69832=>[96.640,-79.232,46.482,1],
69833=>[96.663,-79.234,46.454,1],
69834=>[96.685,-79.237,46.427,1],
69835=>[96.708,-79.240,46.398,1],
69836=>[96.731,-79.242,46.370,1],
69837=>[96.754,-79.245,46.344,1],
69838=>[96.777,-79.247,46.318,1],
69839=>[96.799,-79.250,46.292,1],
69840=>[96.822,-79.250,46.266,1],
69841=>[96.840,-79.228,46.240,1],
69842=>[96.859,-79.208,46.214,1],
69843=>[96.878,-79.187,46.191,1],
69844=>[96.896,-79.165,46.168,1],
69845=>[96.928,-79.166,46.145,1],
69846=>[96.965,-79.177,46.122,1],
69847=>[96.999,-79.189,46.099,1],
69848=>[96.991,-79.213,46.076,1],
69849=>[97.026,-79.177,46.054,1],
69850=>[97.064,-79.174,46.033,1],
69851=>[97.084,-79.198,46.014,1],
69852=>[97.080,-79.199,45.994,1],
69853=>[97.081,-79.200,45.974,1],
69854=>[97.090,-79.200,45.954,1],
69855=>[97.099,-79.200,45.933,1],
69856=>[97.106,-79.214,45.913,1],
69857=>[97.121,-79.214,45.894,1],
69858=>[97.136,-79.214,45.875,1],
69859=>[97.151,-79.215,45.856,1],
69860=>[97.148,-79.224,45.837,1],
69861=>[97.167,-79.210,45.818,1],
69862=>[97.168,-79.203,45.799,1],
69863=>[97.170,-79.197,45.779,1],
69864=>[97.172,-79.190,45.761,1],
69865=>[97.173,-79.182,45.743,1],
69866=>[97.175,-79.175,45.726,1],
69867=>[97.177,-79.169,45.708,1],
69868=>[97.194,-79.165,45.690,1],
69869=>[97.198,-79.178,45.672,1],
69870=>[97.203,-79.191,45.654,1],
69871=>[97.207,-79.203,45.637,1],
69872=>[97.212,-79.217,45.621,1],
69873=>[97.226,-79.234,45.604,1],
69874=>[97.240,-79.250,45.588,1],
69875=>[97.254,-79.268,45.571,1],
69876=>[97.268,-79.285,45.554,1],
69877=>[97.283,-79.301,45.537,1],
69878=>[97.297,-79.319,45.522,1],
69879=>[97.311,-79.335,45.507,1],
69880=>[97.316,-79.356,45.491,1],
69881=>[97.300,-79.372,45.476,1],
69882=>[97.316,-79.366,45.460,1],
69883=>[97.350,-79.352,45.445,1],
69884=>[97.373,-79.339,45.429,1],
69885=>[97.386,-79.327,45.413,1],
69886=>[97.399,-79.316,45.398,1],
69887=>[97.412,-79.303,45.384,1],
69888=>[97.425,-79.292,45.370,1],
69889=>[97.447,-79.312,45.355,1],
69890=>[97.475,-79.402,45.340,1],
69891=>[97.461,-79.400,45.325,1],
69892=>[97.443,-79.396,45.312,1],
69893=>[97.424,-79.392,45.297,1],
69894=>[97.461,-79.374,45.284,1],
69895=>[97.508,-79.359,45.270,1],
69896=>[97.527,-79.374,45.257,1],
69897=>[97.546,-79.390,45.244,1],
69898=>[97.565,-79.405,45.230,1],
69899=>[97.584,-79.420,45.217,1],
69900=>[97.603,-79.436,45.204,1],
69901=>[97.623,-79.451,45.192,1],
69902=>[97.642,-79.466,45.180,1],
69903=>[97.661,-79.482,45.167,1],
69904=>[97.680,-79.498,45.155,1],
69905=>[97.699,-79.513,45.142,1],
69906=>[97.718,-79.529,45.130,1],
69907=>[97.737,-79.544,45.118,1],
69908=>[97.756,-79.559,45.106,1],
69909=>[97.775,-79.574,45.094,1],
69910=>[97.794,-79.590,45.082,1],
69911=>[97.813,-79.605,45.071,1],
69912=>[97.832,-79.620,45.059,1],
69913=>[97.851,-79.636,45.047,1],
69914=>[97.870,-79.651,45.035,1],
69915=>[97.889,-79.667,45.022,1],
69916=>[97.909,-79.683,45.009,1],
69917=>[97.928,-79.698,44.996,1],
69918=>[97.947,-79.713,44.983,1],
69919=>[97.965,-79.729,44.970,1],
69920=>[97.985,-79.744,44.957,1],
69921=>[98.004,-79.759,44.945,1],
69922=>[98.023,-79.774,44.933,1],
69923=>[98.042,-79.790,44.921,1],
69924=>[98.061,-79.805,44.909,1],
69925=>[98.080,-79.820,44.899,1],
69926=>[98.098,-79.837,44.888,1],
69927=>[98.114,-79.855,44.878,1],
69928=>[98.132,-79.871,44.869,1],
69929=>[98.149,-79.889,44.859,1],
69930=>[98.166,-79.905,44.849,1],
69931=>[98.182,-79.923,44.840,1],
69932=>[98.200,-79.940,44.831,1],
69933=>[98.217,-79.957,44.822,1],
69934=>[98.233,-79.974,44.813,1],
69935=>[98.250,-79.991,44.805,1],
69936=>[98.268,-80.008,44.797,1],
69937=>[98.285,-80.025,44.789,1],
69938=>[98.302,-80.042,44.781,1],
69939=>[98.319,-80.058,44.774,1],
69940=>[98.336,-80.074,44.767,1],
69941=>[98.354,-80.090,44.758,1],
69942=>[98.371,-80.106,44.751,1],
69943=>[98.388,-80.121,44.744,1],
69944=>[98.406,-80.137,44.738,1],
69945=>[98.423,-80.153,44.732,1],
69946=>[98.446,-80.168,44.726,1],
69947=>[98.469,-80.182,44.719,1],
69948=>[98.503,-80.179,44.713,1],
69949=>[98.530,-80.194,44.709,1],
69950=>[98.557,-80.206,44.704,1],
69951=>[98.577,-80.211,44.698,1],
69952=>[98.598,-80.215,44.693,1],
69953=>[98.620,-80.220,44.689,1],
69954=>[98.640,-80.225,44.685,1],
69955=>[98.661,-80.229,44.679,1],
69956=>[98.683,-80.234,44.673,1],
69957=>[98.704,-80.237,44.666,1],
69958=>[98.728,-80.240,44.659,1],
69959=>[98.754,-80.249,44.648,1],
69960=>[98.779,-80.260,44.634,1],
69961=>[98.790,-80.269,44.620,1],
69962=>[98.797,-80.275,44.608,1],
69963=>[98.845,-80.275,44.600,1],
69964=>[98.892,-80.289,44.592,1],
69965=>[98.915,-80.300,44.585,1],
69966=>[98.939,-80.310,44.579,1],
69967=>[98.962,-80.321,44.572,1],
69968=>[98.985,-80.331,44.566,1],
69969=>[99.009,-80.342,44.559,1],
69970=>[99.032,-80.353,44.554,1],
69971=>[99.055,-80.363,44.549,1],
69972=>[99.079,-80.374,44.544,1],
69973=>[99.102,-80.384,44.539,1],
69974=>[99.125,-80.394,44.534,1],
69975=>[99.148,-80.405,44.529,1],
69976=>[99.172,-80.416,44.524,1],
69977=>[99.195,-80.426,44.520,1],
69978=>[99.218,-80.437,44.516,1],
69979=>[99.242,-80.447,44.512,1],
69980=>[99.265,-80.458,44.509,1],
69981=>[99.288,-80.469,44.505,1],
69982=>[99.311,-80.479,44.501,1],
70304=>[93.474,-79.009,53.458,1],
70305=>[93.484,-79.006,53.446,1],
70306=>[93.493,-79.003,53.435,1],
70307=>[93.503,-79.001,53.425,1],
70308=>[93.514,-78.991,53.415,1],
70309=>[93.525,-78.981,53.406,1],
70310=>[93.534,-78.974,53.397,1],
70311=>[93.542,-78.967,53.388,1],
70312=>[93.550,-78.960,53.380,1],
70313=>[93.559,-78.953,53.374,1],
70314=>[93.567,-78.946,53.368,1],
70315=>[93.575,-78.940,53.361,1],
70316=>[93.583,-78.933,53.358,1],
70317=>[93.592,-78.925,53.355,1],
70318=>[93.609,-78.915,53.351,1],
70319=>[93.620,-78.908,53.346,1],
70320=>[93.637,-78.906,53.340,1],
70321=>[93.654,-78.904,53.333,1],
70322=>[93.671,-78.902,53.326,1],
70323=>[93.688,-78.899,53.318,1],
70324=>[93.700,-78.898,53.311,1],
70325=>[93.709,-78.896,53.304,1],
70326=>[93.719,-78.896,53.296,1],
70327=>[93.729,-78.894,53.289,1],
70328=>[93.739,-78.893,53.280,1],
70329=>[93.747,-78.893,53.271,1],
70330=>[93.754,-78.893,53.260,1],
70331=>[93.761,-78.893,53.249,1],
70332=>[93.767,-78.893,53.239,1],
70333=>[93.774,-78.893,53.227,1],
70334=>[93.781,-78.893,53.216,1],
70335=>[93.787,-78.890,53.206,1],
70336=>[93.794,-78.888,53.195,1],
70337=>[93.801,-78.886,53.184,1],
70338=>[93.808,-78.883,53.173,1],
70339=>[93.818,-78.877,53.161,1],
70340=>[93.829,-78.865,53.147,1],
70341=>[93.833,-78.864,53.133,1],
70342=>[93.834,-78.866,53.118,1],
70343=>[93.836,-78.868,53.101,1],
70344=>[93.838,-78.869,53.084,1],
70345=>[93.834,-78.865,53.068,1],
70346=>[93.830,-78.860,53.050,1],
70347=>[93.825,-78.855,53.028,1],
70348=>[93.821,-78.849,53.005,1],
70349=>[93.816,-78.844,52.981,1],
70350=>[93.817,-78.839,52.955,1],
70351=>[93.822,-78.834,52.930,1],
70352=>[93.828,-78.830,52.906,1],
70353=>[93.837,-78.825,52.882,1],
70354=>[93.852,-78.819,52.854,1],
70355=>[93.868,-78.812,52.826,1],
70356=>[93.887,-78.811,52.800,1],
70357=>[93.907,-78.813,52.774,1],
70358=>[93.927,-78.814,52.747,1],
70359=>[93.947,-78.817,52.721,1],
70360=>[93.968,-78.819,52.694,1],
70361=>[93.988,-78.821,52.667,1],
70362=>[94.009,-78.824,52.642,1],
70363=>[94.029,-78.826,52.618,1],
70364=>[94.049,-78.828,52.593,1],
70365=>[94.059,-78.824,52.569,1],
70366=>[94.069,-78.821,52.546,1],
70367=>[94.079,-78.816,52.523,1],
70368=>[94.090,-78.812,52.500,1],
70369=>[94.100,-78.808,52.475,1],
70370=>[94.110,-78.805,52.451,1],
70371=>[94.120,-78.801,52.426,1],
70372=>[94.130,-78.797,52.401,1],
70373=>[94.140,-78.793,52.378,1],
70374=>[94.149,-78.782,52.354,1],
70375=>[94.157,-78.775,52.327,1],
70376=>[94.171,-78.772,52.300,1],
70377=>[94.184,-78.769,52.273,1],
70378=>[94.198,-78.767,52.245,1],
70379=>[94.212,-78.764,52.219,1],
70380=>[94.228,-78.755,52.194,1],
70381=>[94.244,-78.745,52.168,1],
70382=>[94.261,-78.736,52.139,1],
70383=>[94.277,-78.726,52.110,1],
70384=>[94.286,-78.724,52.081,1],
70385=>[94.294,-78.721,52.052,1],
70386=>[94.303,-78.719,52.023,1],
70387=>[94.312,-78.717,51.994,1],
70388=>[94.320,-78.714,51.965,1],
70389=>[94.329,-78.712,51.935,1],
70390=>[94.343,-78.714,51.904,1],
70391=>[94.358,-78.715,51.873,1],
70392=>[94.373,-78.717,51.842,1],
70393=>[94.387,-78.722,51.812,1],
70394=>[94.400,-78.727,51.781,1],
70395=>[94.414,-78.731,51.750,1],
70396=>[94.427,-78.733,51.718,1],
70397=>[94.443,-78.726,51.687,1],
70398=>[94.461,-78.730,51.656,1],
70399=>[94.479,-78.735,51.625,1],
70400=>[94.496,-78.739,51.595,1],
70401=>[94.513,-78.743,51.565,1],
70402=>[94.531,-78.748,51.533,1],
70403=>[94.557,-78.755,51.498,1],
70404=>[94.584,-78.761,51.462,1],
70405=>[94.611,-78.768,51.427,1],
70406=>[94.638,-78.775,51.393,1],
70407=>[94.666,-78.782,51.359,1],
70408=>[94.693,-78.789,51.325,1],
70409=>[94.720,-78.796,51.290,1],
70410=>[94.747,-78.802,51.255,1],
70411=>[94.773,-78.809,51.219,1],
70412=>[94.777,-78.814,51.183,1],
70413=>[94.775,-78.824,51.148,1],
70414=>[94.771,-78.826,51.113,1],
70415=>[94.768,-78.827,51.079,1],
70416=>[94.764,-78.828,51.044,1],
70417=>[94.760,-78.830,51.009,1],
70418=>[94.756,-78.830,50.973,1],
70419=>[94.737,-78.821,50.934,1],
70420=>[94.715,-78.811,50.893,1],
70421=>[94.693,-78.800,50.851,1],
70422=>[94.676,-78.801,50.807,1],
70423=>[94.679,-78.803,50.765,1],
70424=>[94.705,-78.793,50.723,1],
70425=>[94.736,-78.785,50.681,1],
70426=>[94.767,-78.777,50.637,1],
70427=>[94.798,-78.769,50.594,1],
70428=>[94.823,-78.764,50.551,1],
70429=>[94.841,-78.760,50.510,1],
70430=>[94.859,-78.757,50.470,1],
70431=>[94.877,-78.754,50.431,1],
70432=>[94.885,-78.760,50.394,1],
70433=>[94.884,-78.775,50.360,1],
70434=>[94.883,-78.791,50.324,1],
70435=>[94.882,-78.806,50.287,1],
70436=>[94.881,-78.822,50.251,1],
70437=>[94.879,-78.837,50.211,1],
70438=>[94.874,-78.843,50.171,1],
70439=>[94.866,-78.842,50.130,1],
70440=>[94.858,-78.841,50.088,1],
70441=>[94.850,-78.841,50.047,1],
70442=>[94.842,-78.840,50.006,1],
70443=>[94.838,-78.840,49.967,1],
70444=>[94.855,-78.843,49.928,1],
70445=>[94.872,-78.846,49.888,1],
70446=>[94.889,-78.849,49.849,1],
70447=>[94.905,-78.852,49.808,1],
70448=>[94.922,-78.855,49.769,1],
70449=>[94.939,-78.858,49.732,1],
70450=>[94.955,-78.864,49.696,1],
70451=>[94.963,-78.892,49.660,1],
70452=>[94.986,-78.905,49.625,1],
70453=>[95.002,-78.915,49.590,1],
70454=>[95.024,-78.923,49.555,1],
70455=>[95.054,-78.930,49.518,1],
70456=>[95.083,-78.937,49.481,1],
70457=>[95.112,-78.943,49.441,1],
70458=>[95.142,-78.950,49.400,1],
70459=>[95.171,-78.957,49.359,1],
70460=>[95.200,-78.964,49.318,1],
70461=>[95.230,-78.971,49.280,1],
70462=>[95.259,-78.977,49.242,1],
70463=>[95.287,-78.983,49.202,1],
70464=>[95.311,-78.985,49.160,1],
70465=>[95.336,-78.987,49.120,1],
70466=>[95.360,-78.990,49.079,1],
70467=>[95.385,-78.992,49.036,1],
70468=>[95.395,-78.997,48.992,1],
70469=>[95.403,-79.003,48.949,1],
70470=>[95.412,-79.009,48.905,1],
70471=>[95.420,-79.015,48.861,1],
70472=>[95.425,-79.034,48.817,1],
70473=>[95.429,-79.054,48.773,1],
70474=>[95.434,-79.075,48.729,1],
70475=>[95.439,-79.094,48.686,1],
70476=>[95.444,-79.115,48.642,1],
70477=>[95.448,-79.134,48.596,1],
70478=>[95.453,-79.155,48.553,1],
70479=>[95.456,-79.172,48.510,1],
70480=>[95.461,-79.187,48.467,1],
70481=>[95.474,-79.203,48.423,1],
70482=>[95.489,-79.218,48.379,1],
70483=>[95.516,-79.209,48.335,1],
70484=>[95.538,-79.195,48.291,1],
70485=>[95.560,-79.182,48.247,1],
70486=>[95.583,-79.169,48.203,1],
70487=>[95.606,-79.156,48.161,1],
70488=>[95.628,-79.143,48.117,1],
70489=>[95.651,-79.130,48.074,1],
70490=>[95.673,-79.116,48.031,1],
70491=>[95.696,-79.103,47.988,1],
70492=>[95.711,-79.094,47.944,1],
70493=>[95.729,-79.093,47.901,1],
70494=>[95.763,-79.103,47.859,1],
70495=>[95.784,-79.108,47.817,1],
70496=>[95.797,-79.109,47.776,1],
70497=>[95.809,-79.109,47.734,1],
70498=>[95.821,-79.110,47.693,1],
70499=>[95.834,-79.111,47.652,1],
70500=>[95.846,-79.112,47.611,1],
70501=>[95.858,-79.112,47.571,1],
70502=>[95.871,-79.113,47.532,1],
70503=>[95.886,-79.122,47.491,1],
70504=>[95.905,-79.143,47.451,1],
70505=>[95.925,-79.165,47.412,1],
70506=>[95.921,-79.157,47.373,1],
70507=>[95.945,-79.143,47.335,1],
70508=>[95.989,-79.122,47.297,1],
70509=>[96.020,-79.134,47.259,1],
70510=>[96.057,-79.115,47.221,1],
70511=>[96.090,-79.091,47.184,1],
70512=>[96.124,-79.079,47.148,1],
70513=>[96.158,-79.066,47.111,1],
70514=>[96.192,-79.053,47.076,1],
70515=>[96.227,-79.040,47.042,1],
70516=>[96.261,-79.028,47.009,1],
70517=>[96.295,-79.015,46.976,1],
70518=>[96.329,-79.002,46.943,1],
70519=>[96.359,-79.035,46.913,1],
70520=>[96.388,-79.081,46.882,1],
70521=>[96.416,-79.126,46.851,1],
70522=>[96.445,-79.172,46.819,1],
70523=>[96.466,-79.194,46.788,1],
70524=>[96.480,-79.195,46.757,1],
70525=>[96.496,-79.195,46.726,1],
70526=>[96.510,-79.196,46.694,1],
70527=>[96.525,-79.196,46.662,1],
70528=>[96.540,-79.197,46.631,1],
70529=>[96.554,-79.197,46.602,1],
70530=>[96.579,-79.200,46.571,1],
70531=>[96.602,-79.202,46.541,1],
70532=>[96.624,-79.204,46.512,1],
70533=>[96.648,-79.207,46.483,1],
70534=>[96.670,-79.209,46.455,1],
70535=>[96.693,-79.212,46.427,1],
70536=>[96.716,-79.215,46.399,1],
70537=>[96.739,-79.217,46.372,1],
70538=>[96.761,-79.219,46.345,1],
70539=>[96.784,-79.222,46.318,1],
70540=>[96.807,-79.225,46.293,1],
70541=>[96.830,-79.226,46.267,1],
70542=>[96.849,-79.205,46.241,1],
70543=>[96.867,-79.184,46.215,1],
70544=>[96.886,-79.163,46.191,1],
70545=>[96.912,-79.155,46.168,1],
70546=>[96.949,-79.165,46.145,1],
70547=>[96.972,-79.184,46.122,1],
70548=>[96.960,-79.212,46.098,1],
70549=>[96.996,-79.177,46.075,1],
70550=>[97.031,-79.140,46.053,1],
70551=>[97.072,-79.169,46.032,1],
70552=>[97.087,-79.188,46.013,1],
70553=>[97.083,-79.189,45.993,1],
70554=>[97.078,-79.190,45.974,1],
70555=>[97.086,-79.190,45.954,1],
70556=>[97.095,-79.191,45.933,1],
70557=>[97.104,-79.191,45.913,1],
70558=>[97.112,-79.201,45.895,1],
70559=>[97.127,-79.201,45.877,1],
70560=>[97.142,-79.201,45.857,1],
70561=>[97.147,-79.203,45.838,1],
70562=>[97.167,-79.190,45.820,1],
70563=>[97.169,-79.182,45.801,1],
70564=>[97.171,-79.175,45.781,1],
70565=>[97.172,-79.169,45.763,1],
70566=>[97.174,-79.162,45.745,1],
70567=>[97.175,-79.155,45.728,1],
70568=>[97.177,-79.147,45.710,1],
70569=>[97.179,-79.140,45.693,1],
70570=>[97.186,-79.149,45.675,1],
70571=>[97.201,-79.165,45.657,1],
70572=>[97.215,-79.183,45.640,1],
70573=>[97.229,-79.200,45.624,1],
70574=>[97.243,-79.216,45.607,1],
70575=>[97.257,-79.234,45.591,1],
70576=>[97.272,-79.250,45.574,1],
70577=>[97.286,-79.267,45.557,1],
70578=>[97.300,-79.284,45.541,1],
70579=>[97.314,-79.301,45.526,1],
70580=>[97.328,-79.318,45.511,1],
70581=>[97.306,-79.350,45.495,1],
70582=>[97.304,-79.357,45.479,1],
70583=>[97.319,-79.350,45.464,1],
70584=>[97.347,-79.338,45.449,1],
70585=>[97.373,-79.325,45.433,1],
70586=>[97.385,-79.313,45.418,1],
70587=>[97.398,-79.302,45.404,1],
70588=>[97.412,-79.290,45.389,1],
70589=>[97.428,-79.285,45.374,1],
70590=>[97.458,-79.342,45.360,1],
70591=>[97.475,-79.388,45.345,1],
70592=>[97.482,-79.397,45.331,1],
70593=>[97.478,-79.400,45.317,1],
70594=>[97.460,-79.397,45.303,1],
70595=>[97.471,-79.390,45.290,1],
70596=>[97.496,-79.382,45.276,1],
70597=>[97.520,-79.375,45.263,1],
70598=>[97.543,-79.368,45.250,1],
70599=>[97.574,-79.370,45.237,1],
70600=>[97.593,-79.386,45.224,1],
70601=>[97.612,-79.401,45.212,1],
70602=>[97.631,-79.416,45.199,1],
70603=>[97.650,-79.432,45.187,1],
70604=>[97.669,-79.447,45.174,1],
70605=>[97.687,-79.463,45.162,1],
70606=>[97.704,-79.481,45.150,1],
70607=>[97.721,-79.498,45.138,1],
70608=>[97.738,-79.515,45.126,1],
70609=>[97.755,-79.532,45.114,1],
70610=>[97.772,-79.549,45.103,1],
70611=>[97.789,-79.567,45.091,1],
70612=>[97.806,-79.583,45.080,1],
70613=>[97.823,-79.601,45.068,1],
70614=>[97.840,-79.617,45.056,1],
70615=>[97.857,-79.635,45.044,1],
70616=>[97.874,-79.652,45.031,1],
70617=>[97.891,-79.669,45.018,1],
70618=>[97.908,-79.686,45.006,1],
70619=>[97.925,-79.703,44.992,1],
70620=>[97.942,-79.720,44.980,1],
70621=>[97.959,-79.737,44.967,1],
70622=>[97.976,-79.755,44.955,1],
70623=>[97.993,-79.771,44.942,1],
70624=>[98.010,-79.789,44.931,1],
70625=>[98.027,-79.806,44.919,1],
70626=>[98.043,-79.823,44.909,1],
70627=>[98.061,-79.840,44.899,1],
70628=>[98.078,-79.856,44.889,1],
70629=>[98.095,-79.872,44.879,1],
70630=>[98.112,-79.888,44.870,1],
70631=>[98.130,-79.905,44.860,1],
70632=>[98.147,-79.921,44.852,1],
70633=>[98.164,-79.936,44.843,1],
70634=>[98.181,-79.952,44.834,1],
70635=>[98.199,-79.968,44.825,1],
70636=>[98.216,-79.984,44.817,1],
70637=>[98.233,-80.000,44.809,1],
70638=>[98.251,-80.016,44.801,1],
70639=>[98.268,-80.032,44.794,1],
70640=>[98.285,-80.048,44.787,1],
70641=>[98.303,-80.064,44.780,1],
70642=>[98.320,-80.080,44.772,1],
70643=>[98.342,-80.095,44.764,1],
70644=>[98.366,-80.109,44.758,1],
70645=>[98.389,-80.123,44.751,1],
70646=>[98.414,-80.137,44.745,1],
70647=>[98.449,-80.125,44.739,1],
70648=>[98.480,-80.133,44.733,1],
70649=>[98.507,-80.148,44.726,1],
70650=>[98.534,-80.162,44.722,1],
70651=>[98.562,-80.178,44.717,1],
70652=>[98.585,-80.184,44.711,1],
70653=>[98.605,-80.189,44.707,1],
70654=>[98.627,-80.193,44.702,1],
70655=>[98.648,-80.198,44.697,1],
70656=>[98.672,-80.201,44.692,1],
70657=>[98.696,-80.203,44.688,1],
70658=>[98.720,-80.206,44.682,1],
70659=>[98.745,-80.213,44.674,1],
70660=>[98.772,-80.224,44.659,1],
70661=>[98.797,-80.234,44.645,1],
70662=>[98.803,-80.240,44.632,1],
70663=>[98.805,-80.243,44.619,1],
70664=>[98.821,-80.253,44.611,1],
70665=>[98.858,-80.262,44.603,1],
70666=>[98.917,-80.271,44.595,1],
70667=>[98.943,-80.283,44.589,1],
70668=>[98.966,-80.294,44.582,1],
70669=>[98.989,-80.304,44.575,1],
70670=>[99.013,-80.315,44.569,1],
70671=>[99.036,-80.325,44.564,1],
70672=>[99.059,-80.336,44.559,1],
70673=>[99.082,-80.347,44.554,1],
70674=>[99.106,-80.356,44.549,1],
70675=>[99.129,-80.367,44.544,1],
70676=>[99.152,-80.378,44.538,1],
70677=>[99.176,-80.388,44.533,1],
70678=>[99.199,-80.399,44.529,1],
70679=>[99.222,-80.410,44.525,1],
70680=>[99.246,-80.420,44.521,1],
70681=>[99.269,-80.431,44.518,1],
70682=>[99.292,-80.441,44.514,1],
70683=>[99.315,-80.452,44.510,1],
70684=>[99.342,-80.461,44.507,1],
70685=>[99.381,-80.465,44.503,1],
71006=>[93.484,-78.995,53.465,1],
71007=>[93.493,-78.993,53.454,1],
71008=>[93.503,-78.990,53.444,1],
71009=>[93.513,-78.987,53.434,1],
71010=>[93.524,-78.977,53.424,1],
71011=>[93.535,-78.968,53.415,1],
71012=>[93.543,-78.961,53.406,1],
71013=>[93.551,-78.954,53.397,1],
71014=>[93.560,-78.946,53.390,1],
71015=>[93.568,-78.940,53.383,1],
71016=>[93.576,-78.933,53.377,1],
71017=>[93.585,-78.926,53.371,1],
71018=>[93.593,-78.919,53.365,1],
71019=>[93.602,-78.912,53.359,1],
71020=>[93.622,-78.893,53.353,1],
71021=>[93.638,-78.891,53.348,1],
71022=>[93.654,-78.889,53.343,1],
71023=>[93.672,-78.886,53.338,1],
71024=>[93.686,-78.884,53.329,1],
71025=>[93.696,-78.883,53.322,1],
71026=>[93.705,-78.882,53.316,1],
71027=>[93.715,-78.880,53.311,1],
71028=>[93.725,-78.880,53.304,1],
71029=>[93.734,-78.878,53.296,1],
71030=>[93.744,-78.877,53.287,1],
71031=>[93.750,-78.877,53.278,1],
71032=>[93.757,-78.877,53.268,1],
71033=>[93.764,-78.877,53.258,1],
71034=>[93.770,-78.877,53.246,1],
71035=>[93.777,-78.874,53.235,1],
71036=>[93.784,-78.872,53.224,1],
71037=>[93.791,-78.870,53.213,1],
71038=>[93.798,-78.868,53.202,1],
71039=>[93.805,-78.865,53.190,1],
71040=>[93.813,-78.861,53.178,1],
71041=>[93.825,-78.849,53.163,1],
71042=>[93.827,-78.850,53.148,1],
71043=>[93.828,-78.852,53.133,1],
71044=>[93.829,-78.853,53.116,1],
71045=>[93.825,-78.848,53.098,1],
71046=>[93.821,-78.843,53.080,1],
71047=>[93.816,-78.837,53.061,1],
71048=>[93.814,-78.832,53.038,1],
71049=>[93.819,-78.827,53.014,1],
71050=>[93.824,-78.824,52.990,1],
71051=>[93.830,-78.819,52.964,1],
71052=>[93.835,-78.814,52.939,1],
71053=>[93.840,-78.810,52.914,1],
71054=>[93.852,-78.805,52.889,1],
71055=>[93.868,-78.798,52.861,1],
71056=>[93.884,-78.792,52.834,1],
71057=>[93.900,-78.786,52.808,1],
71058=>[93.916,-78.780,52.783,1],
71059=>[93.934,-78.778,52.756,1],
71060=>[93.955,-78.780,52.730,1],
71061=>[93.975,-78.783,52.704,1],
71062=>[93.995,-78.785,52.677,1],
71063=>[94.015,-78.787,52.653,1],
71064=>[94.036,-78.789,52.630,1],
71065=>[94.056,-78.792,52.606,1],
71066=>[94.068,-78.788,52.583,1],
71067=>[94.078,-78.784,52.560,1],
71068=>[94.088,-78.780,52.537,1],
71069=>[94.098,-78.777,52.513,1],
71070=>[94.108,-78.773,52.489,1],
71071=>[94.118,-78.769,52.463,1],
71072=>[94.128,-78.765,52.437,1],
71073=>[94.138,-78.761,52.413,1],
71074=>[94.149,-78.758,52.389,1],
71075=>[94.159,-78.753,52.366,1],
71076=>[94.173,-78.754,52.339,1],
71077=>[94.185,-78.752,52.312,1],
71078=>[94.199,-78.749,52.286,1],
71079=>[94.213,-78.746,52.258,1],
71080=>[94.226,-78.744,52.233,1],
71081=>[94.242,-78.737,52.207,1],
71082=>[94.258,-78.727,52.181,1],
71083=>[94.275,-78.717,52.152,1],
71084=>[94.284,-78.714,52.123,1],
71085=>[94.293,-78.712,52.094,1],
71086=>[94.301,-78.710,52.064,1],
71087=>[94.310,-78.708,52.035,1],
71088=>[94.319,-78.705,52.007,1],
71089=>[94.328,-78.703,51.979,1],
71090=>[94.336,-78.701,51.949,1],
71091=>[94.347,-78.701,51.918,1],
71092=>[94.363,-78.702,51.888,1],
71093=>[94.378,-78.705,51.857,1],
71094=>[94.391,-78.710,51.826,1],
71095=>[94.404,-78.715,51.795,1],
71096=>[94.417,-78.720,51.764,1],
71097=>[94.430,-78.724,51.733,1],
71098=>[94.447,-78.717,51.702,1],
71099=>[94.464,-78.721,51.671,1],
71100=>[94.481,-78.726,51.641,1],
71101=>[94.499,-78.730,51.611,1],
71102=>[94.516,-78.735,51.581,1],
71103=>[94.541,-78.741,51.549,1],
71104=>[94.568,-78.748,51.514,1],
71105=>[94.596,-78.755,51.477,1],
71106=>[94.623,-78.761,51.441,1],
71107=>[94.650,-78.768,51.406,1],
71108=>[94.677,-78.775,51.372,1],
71109=>[94.704,-78.783,51.338,1],
71110=>[94.732,-78.789,51.304,1],
71111=>[94.755,-78.795,51.270,1],
71112=>[94.773,-78.796,51.234,1],
71113=>[94.784,-78.795,51.198,1],
71114=>[94.783,-78.792,51.162,1],
71115=>[94.779,-78.793,51.126,1],
71116=>[94.775,-78.794,51.091,1],
71117=>[94.771,-78.796,51.055,1],
71118=>[94.768,-78.796,51.020,1],
71119=>[94.764,-78.798,50.984,1],
71120=>[94.747,-78.789,50.946,1],
71121=>[94.724,-78.779,50.906,1],
71122=>[94.705,-78.773,50.865,1],
71123=>[94.693,-78.790,50.822,1],
71124=>[94.695,-78.793,50.781,1],
71125=>[94.714,-78.781,50.739,1],
71126=>[94.741,-78.771,50.696,1],
71127=>[94.772,-78.763,50.653,1],
71128=>[94.803,-78.755,50.610,1],
71129=>[94.821,-78.752,50.567,1],
71130=>[94.839,-78.749,50.527,1],
71131=>[94.857,-78.745,50.485,1],
71132=>[94.875,-78.742,50.444,1],
71133=>[94.884,-78.749,50.404,1],
71134=>[94.883,-78.764,50.367,1],
71135=>[94.882,-78.779,50.330,1],
71136=>[94.880,-78.795,50.293,1],
71137=>[94.879,-78.810,50.256,1],
71138=>[94.878,-78.826,50.217,1],
71139=>[94.877,-78.841,50.179,1],
71140=>[94.871,-78.845,50.141,1],
71141=>[94.862,-78.844,50.102,1],
71142=>[94.854,-78.843,50.062,1],
71143=>[94.847,-78.843,50.023,1],
71144=>[94.839,-78.843,49.984,1],
71145=>[94.856,-78.846,49.944,1],
71146=>[94.873,-78.849,49.903,1],
71147=>[94.890,-78.852,49.863,1],
71148=>[94.906,-78.855,49.821,1],
71149=>[94.923,-78.858,49.781,1],
71150=>[94.939,-78.861,49.744,1],
71151=>[94.957,-78.864,49.708,1],
71152=>[94.973,-78.868,49.674,1],
71153=>[94.989,-78.886,49.639,1],
71154=>[95.012,-78.895,49.603,1],
71155=>[95.041,-78.902,49.565,1],
71156=>[95.070,-78.908,49.527,1],
71157=>[95.100,-78.915,49.490,1],
71158=>[95.129,-78.922,49.449,1],
71159=>[95.158,-78.929,49.408,1],
71160=>[95.188,-78.936,49.366,1],
71161=>[95.217,-78.943,49.325,1],
71162=>[95.246,-78.949,49.288,1],
71163=>[95.276,-78.956,49.250,1],
71164=>[95.305,-78.963,49.210,1],
71165=>[95.330,-78.965,49.168,1],
71166=>[95.355,-78.968,49.127,1],
71167=>[95.379,-78.970,49.086,1],
71168=>[95.395,-78.974,49.044,1],
71169=>[95.404,-78.981,49.001,1],
71170=>[95.412,-78.986,48.958,1],
71171=>[95.421,-78.992,48.915,1],
71172=>[95.429,-78.998,48.871,1],
71173=>[95.435,-79.012,48.827,1],
71174=>[95.440,-79.033,48.784,1],
71175=>[95.445,-79.053,48.740,1],
71176=>[95.449,-79.073,48.697,1],
71177=>[95.454,-79.093,48.653,1],
71178=>[95.458,-79.113,48.608,1],
71179=>[95.463,-79.133,48.566,1],
71180=>[95.467,-79.153,48.523,1],
71181=>[95.472,-79.173,48.479,1],
71182=>[95.475,-79.190,48.435,1],
71183=>[95.488,-79.206,48.391,1],
71184=>[95.513,-79.197,48.347,1],
71185=>[95.535,-79.184,48.302,1],
71186=>[95.557,-79.171,48.257,1],
71187=>[95.580,-79.158,48.213,1],
71188=>[95.603,-79.144,48.170,1],
71189=>[95.625,-79.131,48.127,1],
71190=>[95.648,-79.118,48.083,1],
71191=>[95.670,-79.105,48.039,1],
71192=>[95.693,-79.092,47.995,1],
71193=>[95.714,-79.080,47.949,1],
71194=>[95.736,-79.081,47.905,1],
71195=>[95.756,-79.085,47.862,1],
71196=>[95.768,-79.086,47.820,1],
71197=>[95.780,-79.087,47.778,1],
71198=>[95.793,-79.087,47.736,1],
71199=>[95.805,-79.088,47.695,1],
71200=>[95.817,-79.089,47.654,1],
71201=>[95.830,-79.090,47.613,1],
71202=>[95.842,-79.090,47.572,1],
71203=>[95.854,-79.091,47.533,1],
71204=>[95.867,-79.092,47.494,1],
71205=>[95.883,-79.106,47.453,1],
71206=>[95.903,-79.128,47.414,1],
71207=>[95.923,-79.149,47.375,1],
71208=>[95.930,-79.150,47.336,1],
71209=>[95.986,-79.131,47.298,1],
71210=>[96.029,-79.115,47.260,1],
71211=>[96.063,-79.103,47.222,1],
71212=>[96.098,-79.090,47.184,1],
71213=>[96.132,-79.078,47.148,1],
71214=>[96.166,-79.065,47.112,1],
71215=>[96.200,-79.052,47.077,1],
71216=>[96.235,-79.039,47.043,1],
71217=>[96.269,-79.026,47.010,1],
71218=>[96.303,-79.014,46.977,1],
71219=>[96.337,-79.001,46.944,1],
71220=>[96.367,-79.034,46.914,1],
71221=>[96.396,-79.080,46.883,1],
71222=>[96.424,-79.126,46.851,1],
71223=>[96.453,-79.172,46.819,1],
71224=>[96.468,-79.174,46.788,1],
71225=>[96.482,-79.174,46.756,1],
71226=>[96.498,-79.175,46.724,1],
71227=>[96.512,-79.175,46.693,1],
71228=>[96.527,-79.175,46.662,1],
71229=>[96.544,-79.180,46.632,1],
71230=>[96.568,-79.191,46.602,1],
71231=>[96.573,-79.181,46.571,1],
71232=>[96.600,-79.178,46.541,1],
71233=>[96.632,-79.179,46.513,1],
71234=>[96.655,-79.182,46.483,1],
71235=>[96.678,-79.184,46.455,1],
71236=>[96.701,-79.187,46.428,1],
71237=>[96.724,-79.190,46.400,1],
71238=>[96.746,-79.192,46.374,1],
71239=>[96.769,-79.194,46.348,1],
71240=>[96.792,-79.197,46.320,1],
71241=>[96.815,-79.200,46.295,1],
71242=>[96.837,-79.202,46.269,1],
71243=>[96.857,-79.182,46.243,1],
71244=>[96.875,-79.161,46.218,1],
71245=>[96.896,-79.143,46.193,1],
71246=>[96.933,-79.153,46.169,1],
71247=>[96.945,-79.178,46.146,1],
71248=>[96.930,-79.212,46.123,1],
71249=>[96.965,-79.176,46.099,1],
71250=>[97.001,-79.140,46.075,1],
71251=>[97.037,-79.118,46.053,1],
71252=>[97.079,-79.163,46.033,1],
71253=>[97.090,-79.178,46.014,1],
71254=>[97.085,-79.179,45.994,1],
71255=>[97.081,-79.180,45.974,1],
71256=>[97.081,-79.181,45.955,1],
71257=>[97.091,-79.181,45.935,1],
71258=>[97.100,-79.181,45.916,1],
71259=>[97.109,-79.182,45.897,1],
71260=>[97.118,-79.187,45.879,1],
71261=>[97.133,-79.187,45.859,1],
71262=>[97.146,-79.184,45.840,1],
71263=>[97.168,-79.169,45.822,1],
71264=>[97.169,-79.162,45.804,1],
71265=>[97.171,-79.155,45.784,1],
71266=>[97.173,-79.147,45.766,1],
71267=>[97.174,-79.145,45.749,1],
71268=>[97.175,-79.144,45.731,1],
71269=>[97.176,-79.143,45.714,1],
71270=>[97.177,-79.142,45.696,1],
71271=>[97.195,-79.138,45.679,1],
71272=>[97.218,-79.148,45.660,1],
71273=>[97.232,-79.165,45.643,1],
71274=>[97.246,-79.182,45.627,1],
71275=>[97.260,-79.199,45.611,1],
71276=>[97.275,-79.216,45.595,1],
71277=>[97.289,-79.233,45.578,1],
71278=>[97.303,-79.250,45.562,1],
71279=>[97.317,-79.266,45.546,1],
71280=>[97.331,-79.284,45.530,1],
71281=>[97.346,-79.300,45.515,1],
71282=>[97.296,-79.344,45.500,1],
71283=>[97.308,-79.340,45.485,1],
71284=>[97.323,-79.334,45.469,1],
71285=>[97.344,-79.325,45.454,1],
71286=>[97.372,-79.311,45.438,1],
71287=>[97.385,-79.300,45.424,1],
71288=>[97.397,-79.288,45.409,1],
71289=>[97.411,-79.277,45.395,1],
71290=>[97.438,-79.288,45.381,1],
71291=>[97.469,-79.368,45.367,1],
71292=>[97.474,-79.375,45.352,1],
71293=>[97.480,-79.383,45.338,1],
71294=>[97.489,-79.392,45.324,1],
71295=>[97.496,-79.400,45.310,1],
71296=>[97.505,-79.394,45.297,1],
71297=>[97.527,-79.385,45.284,1],
71298=>[97.543,-79.373,45.270,1],
71299=>[97.558,-79.361,45.258,1],
71300=>[97.562,-79.357,45.245,1],
71301=>[97.567,-79.367,45.232,1],
71302=>[97.582,-79.398,45.220,1],
71303=>[97.599,-79.415,45.207,1],
71304=>[97.616,-79.432,45.195,1],
71305=>[97.633,-79.449,45.182,1],
71306=>[97.650,-79.466,45.170,1],
71307=>[97.667,-79.483,45.158,1],
71308=>[97.684,-79.501,45.146,1],
71309=>[97.701,-79.518,45.135,1],
71310=>[97.718,-79.535,45.123,1],
71311=>[97.735,-79.552,45.112,1],
71312=>[97.752,-79.569,45.101,1],
71313=>[97.769,-79.586,45.089,1],
71314=>[97.786,-79.603,45.077,1],
71315=>[97.803,-79.620,45.064,1],
71316=>[97.820,-79.637,45.052,1],
71317=>[97.837,-79.654,45.040,1],
71318=>[97.854,-79.671,45.027,1],
71319=>[97.871,-79.687,45.016,1],
71320=>[97.888,-79.703,45.002,1],
71321=>[97.906,-79.719,44.989,1],
71322=>[97.923,-79.735,44.977,1],
71323=>[97.941,-79.751,44.964,1],
71324=>[97.958,-79.767,44.952,1],
71325=>[97.975,-79.783,44.941,1],
71326=>[97.993,-79.798,44.930,1],
71327=>[98.010,-79.814,44.920,1],
71328=>[98.027,-79.830,44.910,1],
71329=>[98.044,-79.846,44.900,1],
71330=>[98.062,-79.863,44.890,1],
71331=>[98.079,-79.879,44.881,1],
71332=>[98.096,-79.895,44.872,1],
71333=>[98.113,-79.911,44.863,1],
71334=>[98.131,-79.927,44.854,1],
71335=>[98.148,-79.943,44.845,1],
71336=>[98.165,-79.958,44.837,1],
71337=>[98.182,-79.974,44.830,1],
71338=>[98.200,-79.990,44.823,1],
71339=>[98.217,-80.006,44.815,1],
71340=>[98.238,-80.021,44.807,1],
71341=>[98.262,-80.036,44.800,1],
71342=>[98.286,-80.050,44.793,1],
71343=>[98.309,-80.065,44.786,1],
71344=>[98.333,-80.078,44.780,1],
71345=>[98.357,-80.093,44.774,1],
71346=>[98.385,-80.098,44.768,1],
71347=>[98.429,-80.071,44.760,1],
71348=>[98.456,-80.087,44.753,1],
71349=>[98.484,-80.102,44.747,1],
71350=>[98.511,-80.116,44.741,1],
71351=>[98.538,-80.131,44.737,1],
71352=>[98.566,-80.146,44.731,1],
71353=>[98.592,-80.158,44.725,1],
71354=>[98.615,-80.161,44.719,1],
71355=>[98.640,-80.164,44.715,1],
71356=>[98.664,-80.167,44.710,1],
71357=>[98.688,-80.169,44.705,1],
71358=>[98.712,-80.172,44.700,1],
71359=>[98.737,-80.178,44.694,1],
71360=>[98.763,-80.187,44.685,1],
71361=>[98.789,-80.198,44.670,1],
71362=>[98.810,-80.209,44.655,1],
71363=>[98.819,-80.210,44.642,1],
71364=>[98.822,-80.212,44.630,1],
71365=>[98.834,-80.221,44.622,1],
71366=>[98.850,-80.232,44.614,1],
71367=>[98.869,-80.243,44.606,1],
71368=>[98.917,-80.243,44.599,1],
71369=>[98.970,-80.266,44.592,1],
71370=>[98.993,-80.277,44.585,1],
71371=>[99.017,-80.287,44.580,1],
71372=>[99.040,-80.298,44.574,1],
71373=>[99.063,-80.309,44.568,1],
71374=>[99.086,-80.319,44.564,1],
71375=>[99.110,-80.330,44.558,1],
71376=>[99.133,-80.340,44.553,1],
71377=>[99.156,-80.350,44.548,1],
71378=>[99.180,-80.361,44.542,1],
71379=>[99.203,-80.372,44.538,1],
71380=>[99.226,-80.382,44.534,1],
71381=>[99.250,-80.393,44.530,1],
71382=>[99.273,-80.403,44.528,1],
71383=>[99.296,-80.414,44.525,1],
71384=>[99.320,-80.425,44.521,1],
71385=>[99.353,-80.431,44.516,1],
71386=>[99.392,-80.435,44.513,1],
71387=>[99.430,-80.438,44.509,1],
71388=>[99.469,-80.442,44.506,1],
71708=>[93.494,-78.981,53.473,1],
71709=>[93.503,-78.979,53.462,1],
71710=>[93.513,-78.977,53.452,1],
71711=>[93.523,-78.973,53.442,1],
71712=>[93.535,-78.962,53.433,1],
71713=>[93.544,-78.954,53.424,1],
71714=>[93.552,-78.947,53.415,1],
71715=>[93.561,-78.940,53.407,1],
71716=>[93.569,-78.933,53.399,1],
71717=>[93.577,-78.927,53.392,1],
71718=>[93.586,-78.919,53.385,1],
71719=>[93.594,-78.912,53.378,1],
71720=>[93.603,-78.905,53.371,1],
71721=>[93.655,-78.879,53.365,1],
71722=>[93.638,-78.875,53.359,1],
71723=>[93.655,-78.873,53.354,1],
71724=>[93.672,-78.871,53.349,1],
71725=>[93.682,-78.869,53.342,1],
71726=>[93.692,-78.868,53.336,1],
71727=>[93.701,-78.868,53.331,1],
71728=>[93.711,-78.866,53.325,1],
71729=>[93.720,-78.865,53.320,1],
71730=>[93.730,-78.864,53.314,1],
71731=>[93.740,-78.863,53.305,1],
71732=>[93.746,-78.863,53.297,1],
71733=>[93.753,-78.863,53.287,1],
71734=>[93.760,-78.861,53.277,1],
71735=>[93.767,-78.858,53.265,1],
71736=>[93.774,-78.855,53.254,1],
71737=>[93.781,-78.853,53.242,1],
71738=>[93.788,-78.851,53.230,1],
71739=>[93.795,-78.849,53.219,1],
71740=>[93.802,-78.846,53.207,1],
71741=>[93.809,-78.844,53.194,1],
71742=>[93.819,-78.835,53.178,1],
71743=>[93.821,-78.836,53.162,1],
71744=>[93.820,-78.836,53.147,1],
71745=>[93.816,-78.831,53.130,1],
71746=>[93.812,-78.826,53.111,1],
71747=>[93.816,-78.821,53.091,1],
71748=>[93.821,-78.817,53.071,1],
71749=>[93.826,-78.812,53.048,1],
71750=>[93.831,-78.808,53.023,1],
71751=>[93.837,-78.803,52.999,1],
71752=>[93.842,-78.799,52.973,1],
71753=>[93.847,-78.795,52.947,1],
71754=>[93.852,-78.790,52.922,1],
71755=>[93.867,-78.784,52.897,1],
71756=>[93.884,-78.777,52.869,1],
71757=>[93.899,-78.771,52.842,1],
71758=>[93.915,-78.765,52.815,1],
71759=>[93.931,-78.758,52.790,1],
71760=>[93.947,-78.752,52.764,1],
71761=>[93.963,-78.746,52.738,1],
71762=>[93.982,-78.746,52.714,1],
71763=>[94.002,-78.748,52.688,1],
71764=>[94.023,-78.750,52.664,1],
71765=>[94.043,-78.752,52.642,1],
71766=>[94.063,-78.755,52.618,1],
71767=>[94.076,-78.752,52.595,1],
71768=>[94.086,-78.749,52.573,1],
71769=>[94.097,-78.745,52.551,1],
71770=>[94.107,-78.741,52.527,1],
71771=>[94.117,-78.737,52.503,1],
71772=>[94.127,-78.733,52.477,1],
71773=>[94.137,-78.729,52.451,1],
71774=>[94.145,-78.730,52.426,1],
71775=>[94.149,-78.737,52.402,1],
71776=>[94.169,-78.730,52.379,1],
71777=>[94.196,-78.734,52.352,1],
71778=>[94.206,-78.731,52.325,1],
71779=>[94.216,-78.729,52.298,1],
71780=>[94.227,-78.726,52.272,1],
71781=>[94.242,-78.724,52.247,1],
71782=>[94.256,-78.720,52.222,1],
71783=>[94.272,-78.709,52.195,1],
71784=>[94.283,-78.705,52.167,1],
71785=>[94.291,-78.703,52.139,1],
71786=>[94.300,-78.701,52.109,1],
71787=>[94.309,-78.698,52.079,1],
71788=>[94.318,-78.696,52.051,1],
71789=>[94.326,-78.694,52.023,1],
71790=>[94.335,-78.692,51.996,1],
71791=>[94.343,-78.689,51.966,1],
71792=>[94.352,-78.687,51.936,1],
71793=>[94.368,-78.689,51.905,1],
71794=>[94.382,-78.694,51.874,1],
71795=>[94.395,-78.698,51.842,1],
71796=>[94.408,-78.703,51.811,1],
71797=>[94.421,-78.708,51.781,1],
71798=>[94.434,-78.713,51.750,1],
71799=>[94.449,-78.708,51.718,1],
71800=>[94.467,-78.713,51.687,1],
71801=>[94.484,-78.717,51.656,1],
71802=>[94.501,-78.721,51.626,1],
71803=>[94.526,-78.727,51.596,1],
71804=>[94.553,-78.734,51.564,1],
71805=>[94.580,-78.742,51.528,1],
71806=>[94.607,-78.749,51.491,1],
71807=>[94.634,-78.755,51.454,1],
71808=>[94.662,-78.762,51.419,1],
71809=>[94.687,-78.768,51.385,1],
71810=>[94.705,-78.771,51.352,1],
71811=>[94.723,-78.772,51.318,1],
71812=>[94.741,-78.774,51.284,1],
71813=>[94.759,-78.777,51.250,1],
71814=>[94.770,-78.779,51.215,1],
71815=>[94.778,-78.774,51.178,1],
71816=>[94.784,-78.764,51.142,1],
71817=>[94.783,-78.761,51.106,1],
71818=>[94.779,-78.762,51.069,1],
71819=>[94.775,-78.764,51.032,1],
71820=>[94.772,-78.764,50.995,1],
71821=>[94.756,-78.758,50.957,1],
71822=>[94.734,-78.747,50.918,1],
71823=>[94.721,-78.762,50.878,1],
71824=>[94.710,-78.779,50.836,1],
71825=>[94.711,-78.783,50.796,1],
71826=>[94.730,-78.771,50.753,1],
71827=>[94.749,-78.758,50.709,1],
71828=>[94.777,-78.749,50.667,1],
71829=>[94.801,-78.745,50.625,1],
71830=>[94.819,-78.741,50.582,1],
71831=>[94.837,-78.738,50.541,1],
71832=>[94.855,-78.735,50.499,1],
71833=>[94.873,-78.731,50.457,1],
71834=>[94.883,-78.736,50.415,1],
71835=>[94.881,-78.752,50.375,1],
71836=>[94.880,-78.767,50.336,1],
71837=>[94.879,-78.783,50.299,1],
71838=>[94.878,-78.799,50.263,1],
71839=>[94.877,-78.814,50.226,1],
71840=>[94.876,-78.830,50.188,1],
71841=>[94.874,-78.845,50.152,1],
71842=>[94.867,-78.846,50.114,1],
71843=>[94.859,-78.846,50.076,1],
71844=>[94.851,-78.846,50.037,1],
71845=>[94.843,-78.845,49.998,1],
71846=>[94.857,-78.848,49.958,1],
71847=>[94.874,-78.851,49.917,1],
71848=>[94.890,-78.854,49.876,1],
71849=>[94.907,-78.857,49.834,1],
71850=>[94.924,-78.860,49.793,1],
71851=>[94.941,-78.863,49.755,1],
71852=>[94.957,-78.866,49.719,1],
71853=>[94.974,-78.869,49.685,1],
71854=>[94.998,-78.868,49.650,1],
71855=>[95.028,-78.874,49.614,1],
71856=>[95.057,-78.880,49.575,1],
71857=>[95.087,-78.886,49.537,1],
71858=>[95.116,-78.893,49.498,1],
71859=>[95.145,-78.900,49.456,1],
71860=>[95.175,-78.907,49.415,1],
71861=>[95.204,-78.914,49.374,1],
71862=>[95.234,-78.921,49.334,1],
71863=>[95.263,-78.927,49.295,1],
71864=>[95.292,-78.934,49.257,1],
71865=>[95.322,-78.941,49.217,1],
71866=>[95.349,-78.946,49.176,1],
71867=>[95.374,-78.949,49.135,1],
71868=>[95.396,-78.952,49.095,1],
71869=>[95.404,-78.958,49.051,1],
71870=>[95.413,-78.963,49.009,1],
71871=>[95.421,-78.969,48.967,1],
71872=>[95.429,-78.975,48.924,1],
71873=>[95.438,-78.981,48.880,1],
71874=>[95.446,-78.991,48.837,1],
71875=>[95.450,-79.011,48.795,1],
71876=>[95.455,-79.031,48.753,1],
71877=>[95.459,-79.051,48.710,1],
71878=>[95.464,-79.071,48.666,1],
71879=>[95.468,-79.091,48.622,1],
71880=>[95.473,-79.112,48.578,1],
71881=>[95.478,-79.131,48.535,1],
71882=>[95.482,-79.152,48.492,1],
71883=>[95.487,-79.172,48.447,1],
71884=>[95.491,-79.192,48.403,1],
71885=>[95.511,-79.187,48.358,1],
71886=>[95.533,-79.173,48.313,1],
71887=>[95.556,-79.160,48.268,1],
71888=>[95.578,-79.147,48.223,1],
71889=>[95.601,-79.134,48.179,1],
71890=>[95.623,-79.120,48.134,1],
71891=>[95.645,-79.107,48.090,1],
71892=>[95.668,-79.094,48.045,1],
71893=>[95.690,-79.081,48.000,1],
71894=>[95.712,-79.068,47.955,1],
71895=>[95.728,-79.063,47.911,1],
71896=>[95.740,-79.064,47.867,1],
71897=>[95.752,-79.065,47.824,1],
71898=>[95.764,-79.065,47.782,1],
71899=>[95.776,-79.066,47.741,1],
71900=>[95.789,-79.067,47.699,1],
71901=>[95.801,-79.068,47.657,1],
71902=>[95.813,-79.068,47.616,1],
71903=>[95.825,-79.069,47.575,1],
71904=>[95.838,-79.070,47.537,1],
71905=>[95.850,-79.071,47.497,1],
71906=>[95.862,-79.071,47.457,1],
71907=>[95.881,-79.090,47.418,1],
71908=>[95.901,-79.112,47.378,1],
71909=>[95.921,-79.134,47.338,1],
71910=>[95.947,-79.106,47.300,1],
71911=>[96.035,-79.106,47.261,1],
71912=>[96.072,-79.101,47.223,1],
71913=>[96.106,-79.089,47.186,1],
71914=>[96.140,-79.076,47.149,1],
71915=>[96.174,-79.063,47.114,1],
71916=>[96.208,-79.050,47.079,1],
71917=>[96.243,-79.037,47.043,1],
71918=>[96.277,-79.024,47.011,1],
71919=>[96.311,-79.012,46.978,1],
71920=>[96.345,-78.999,46.945,1],
71921=>[96.375,-79.034,46.914,1],
71922=>[96.404,-79.079,46.883,1],
71923=>[96.432,-79.125,46.852,1],
71924=>[96.455,-79.153,46.820,1],
71925=>[96.470,-79.153,46.789,1],
71926=>[96.484,-79.153,46.758,1],
71927=>[96.499,-79.154,46.726,1],
71928=>[96.514,-79.154,46.696,1],
71929=>[96.532,-79.159,46.664,1],
71930=>[96.556,-79.172,46.632,1],
71931=>[96.580,-79.183,46.601,1],
71932=>[96.593,-79.184,46.570,1],
71933=>[96.591,-79.166,46.541,1],
71934=>[96.608,-79.159,46.514,1],
71935=>[96.645,-79.159,46.484,1],
71936=>[96.681,-79.160,46.457,1],
71937=>[96.709,-79.162,46.430,1],
71938=>[96.731,-79.165,46.402,1],
71939=>[96.754,-79.167,46.376,1],
71940=>[96.777,-79.169,46.350,1],
71941=>[96.800,-79.172,46.323,1],
71942=>[96.822,-79.175,46.297,1],
71943=>[96.846,-79.177,46.271,1],
71944=>[96.865,-79.159,46.245,1],
71945=>[96.883,-79.137,46.220,1],
71946=>[96.916,-79.142,46.196,1],
71947=>[96.919,-79.173,46.172,1],
71948=>[96.899,-79.212,46.149,1],
71949=>[96.935,-79.176,46.126,1],
71950=>[96.970,-79.140,46.103,1],
71951=>[97.006,-79.103,46.079,1],
71952=>[97.044,-79.112,46.056,1],
71953=>[97.087,-79.158,46.036,1],
71954=>[97.093,-79.169,46.016,1],
71955=>[97.088,-79.169,45.996,1],
71956=>[97.084,-79.170,45.977,1],
71957=>[97.080,-79.171,45.958,1],
71958=>[97.086,-79.172,45.939,1],
71959=>[97.096,-79.172,45.919,1],
71960=>[97.105,-79.172,45.901,1],
71961=>[97.114,-79.173,45.883,1],
71962=>[97.124,-79.175,45.864,1],
71963=>[97.145,-79.163,45.845,1],
71964=>[97.164,-79.151,45.826,1],
71965=>[97.171,-79.142,45.808,1],
71966=>[97.171,-79.143,45.788,1],
71967=>[97.172,-79.143,45.770,1],
71968=>[97.173,-79.143,45.753,1],
71969=>[97.173,-79.144,45.737,1],
71970=>[97.174,-79.145,45.719,1],
71971=>[97.175,-79.148,45.702,1],
71972=>[97.185,-79.143,45.684,1],
71973=>[97.223,-79.141,45.665,1],
71974=>[97.249,-79.148,45.648,1],
71975=>[97.263,-79.165,45.633,1],
71976=>[97.278,-79.181,45.617,1],
71977=>[97.292,-79.199,45.600,1],
71978=>[97.306,-79.216,45.584,1],
71979=>[97.320,-79.232,45.568,1],
71980=>[97.334,-79.250,45.552,1],
71981=>[97.349,-79.266,45.536,1],
71982=>[97.341,-79.292,45.521,1],
71983=>[97.296,-79.330,45.506,1],
71984=>[97.312,-79.324,45.491,1],
71985=>[97.327,-79.317,45.475,1],
71986=>[97.343,-79.311,45.460,1],
71987=>[97.371,-79.297,45.445,1],
71988=>[97.384,-79.286,45.430,1],
71989=>[97.397,-79.274,45.416,1],
71990=>[97.421,-79.281,45.402,1],
71991=>[97.449,-79.298,45.388,1],
71992=>[97.468,-79.354,45.374,1],
71993=>[97.474,-79.363,45.359,1],
71994=>[97.479,-79.370,45.345,1],
71995=>[97.486,-79.379,45.331,1],
71996=>[97.495,-79.388,45.317,1],
71997=>[97.510,-79.380,45.305,1],
71998=>[97.526,-79.368,45.292,1],
71999=>[97.536,-79.359,45.278,1],
72000=>[97.540,-79.354,45.266,1],
72001=>[97.544,-79.350,45.253,1],
72002=>[97.547,-79.345,45.240,1],
72003=>[97.551,-79.341,45.228,1],
72004=>[97.559,-79.438,45.215,1],
72005=>[97.575,-79.462,45.203,1],
72006=>[97.596,-79.452,45.191,1],
72007=>[97.613,-79.469,45.178,1],
72008=>[97.630,-79.485,45.167,1],
72009=>[97.648,-79.501,45.155,1],
72010=>[97.665,-79.517,45.144,1],
72011=>[97.682,-79.534,45.134,1],
72012=>[97.700,-79.550,45.122,1],
72013=>[97.717,-79.566,45.110,1],
72014=>[97.734,-79.582,45.098,1],
72015=>[97.751,-79.598,45.086,1],
72016=>[97.769,-79.614,45.074,1],
72017=>[97.786,-79.629,45.062,1],
72018=>[97.803,-79.645,45.049,1],
72019=>[97.820,-79.661,45.037,1],
72020=>[97.838,-79.677,45.025,1],
72021=>[97.855,-79.693,45.011,1],
72022=>[97.872,-79.709,44.999,1],
72023=>[97.890,-79.725,44.988,1],
72024=>[97.907,-79.741,44.975,1],
72025=>[97.924,-79.757,44.963,1],
72026=>[97.942,-79.773,44.952,1],
72027=>[97.959,-79.789,44.941,1],
72028=>[97.976,-79.805,44.931,1],
72029=>[97.994,-79.821,44.921,1],
72030=>[98.011,-79.837,44.912,1],
72031=>[98.028,-79.853,44.903,1],
72032=>[98.045,-79.869,44.893,1],
72033=>[98.063,-79.885,44.884,1],
72034=>[98.080,-79.901,44.877,1],
72035=>[98.097,-79.917,44.868,1],
72036=>[98.114,-79.933,44.860,1],
72037=>[98.134,-79.948,44.852,1],
72038=>[98.158,-79.962,44.845,1],
72039=>[98.181,-79.977,44.838,1],
72040=>[98.205,-79.991,44.831,1],
72041=>[98.229,-80.005,44.823,1],
72042=>[98.253,-80.020,44.817,1],
72043=>[98.276,-80.034,44.810,1],
72044=>[98.302,-80.047,44.804,1],
72045=>[98.334,-80.046,44.796,1],
72046=>[98.346,-80.048,44.790,1],
72047=>[98.387,-80.033,44.783,1],
72048=>[98.434,-80.044,44.775,1],
72049=>[98.462,-80.059,44.768,1],
72050=>[98.489,-80.074,44.762,1],
72051=>[98.517,-80.089,44.757,1],
72052=>[98.544,-80.104,44.752,1],
72053=>[98.572,-80.119,44.746,1],
72054=>[98.600,-80.127,44.739,1],
72055=>[98.630,-80.130,44.731,1],
72056=>[98.655,-80.133,44.727,1],
72057=>[98.679,-80.135,44.723,1],
72058=>[98.704,-80.138,44.717,1],
72059=>[98.728,-80.142,44.711,1],
72060=>[98.754,-80.152,44.704,1],
72061=>[98.776,-80.163,44.694,1],
72062=>[98.789,-80.177,44.679,1],
72063=>[98.808,-80.188,44.665,1],
72064=>[98.831,-80.187,44.652,1],
72065=>[98.839,-80.182,44.641,1],
72066=>[98.847,-80.188,44.632,1],
72067=>[98.863,-80.200,44.624,1],
72068=>[98.880,-80.211,44.616,1],
72069=>[98.896,-80.222,44.609,1],
72070=>[98.929,-80.231,44.602,1],
72071=>[98.997,-80.250,44.596,1],
72072=>[99.021,-80.260,44.590,1],
72073=>[99.044,-80.271,44.584,1],
72074=>[99.067,-80.281,44.579,1],
72075=>[99.090,-80.292,44.573,1],
72076=>[99.114,-80.303,44.568,1],
72077=>[99.137,-80.312,44.563,1],
72078=>[99.160,-80.323,44.557,1],
72079=>[99.184,-80.334,44.552,1],
72080=>[99.207,-80.344,44.548,1],
72081=>[99.230,-80.355,44.544,1],
72082=>[99.254,-80.366,44.540,1],
72083=>[99.277,-80.376,44.537,1],
72084=>[99.300,-80.387,44.534,1],
72085=>[99.326,-80.397,44.530,1],
72086=>[99.364,-80.400,44.526,1],
72087=>[99.403,-80.404,44.523,1],
72088=>[99.441,-80.408,44.520,1],
72089=>[99.480,-80.413,44.516,1],
72090=>[99.518,-80.416,44.512,1],
72091=>[99.557,-80.420,44.509,1],
72410=>[93.504,-78.968,53.481,1],
72411=>[93.513,-78.965,53.470,1],
72412=>[93.523,-78.963,53.460,1],
72413=>[93.533,-78.959,53.450,1],
72414=>[93.545,-78.949,53.441,1],
72415=>[93.554,-78.940,53.432,1],
72416=>[93.562,-78.933,53.423,1],
72417=>[93.570,-78.927,53.415,1],
72418=>[93.578,-78.920,53.408,1],
72419=>[93.587,-78.913,53.399,1],
72420=>[93.595,-78.906,53.391,1],
72421=>[93.604,-78.899,53.384,1],
72422=>[93.643,-78.878,53.377,1],
72423=>[93.660,-78.860,53.371,1],
72424=>[93.656,-78.858,53.366,1],
72425=>[93.668,-78.856,53.361,1],
72426=>[93.678,-78.855,53.356,1],
72427=>[93.688,-78.854,53.351,1],
72428=>[93.697,-78.852,53.346,1],
72429=>[93.707,-78.852,53.341,1],
72430=>[93.716,-78.850,53.336,1],
72431=>[93.726,-78.849,53.330,1],
72432=>[93.736,-78.848,53.322,1],
72433=>[93.743,-78.846,53.313,1],
72434=>[93.750,-78.844,53.304,1],
72435=>[93.757,-78.842,53.295,1],
72436=>[93.764,-78.839,53.283,1],
72437=>[93.771,-78.837,53.271,1],
72438=>[93.778,-78.835,53.259,1],
72439=>[93.785,-78.833,53.247,1],
72440=>[93.792,-78.830,53.236,1],
72441=>[93.799,-78.827,53.223,1],
72442=>[93.806,-78.825,53.209,1],
72443=>[93.813,-78.821,53.193,1],
72444=>[93.811,-78.819,53.176,1],
72445=>[93.812,-78.814,53.157,1],
72446=>[93.818,-78.810,53.140,1],
72447=>[93.823,-78.805,53.120,1],
72448=>[93.828,-78.801,53.101,1],
72449=>[93.833,-78.796,53.081,1],
72450=>[93.839,-78.793,53.057,1],
72451=>[93.844,-78.788,53.033,1],
72452=>[93.849,-78.783,53.007,1],
72453=>[93.854,-78.779,52.981,1],
72454=>[93.860,-78.774,52.954,1],
72455=>[93.867,-78.770,52.929,1],
72456=>[93.883,-78.764,52.904,1],
72457=>[93.899,-78.757,52.876,1],
72458=>[93.915,-78.751,52.849,1],
72459=>[93.930,-78.745,52.822,1],
72460=>[93.946,-78.738,52.797,1],
72461=>[93.963,-78.732,52.772,1],
72462=>[93.978,-78.726,52.747,1],
72463=>[93.994,-78.719,52.723,1],
72464=>[94.010,-78.713,52.699,1],
72465=>[94.030,-78.714,52.675,1],
72466=>[94.050,-78.716,52.653,1],
72467=>[94.070,-78.718,52.630,1],
72468=>[94.084,-78.717,52.607,1],
72469=>[94.095,-78.713,52.585,1],
72470=>[94.105,-78.709,52.563,1],
72471=>[94.115,-78.705,52.540,1],
72472=>[94.125,-78.701,52.516,1],
72473=>[94.130,-78.707,52.491,1],
72474=>[94.134,-78.715,52.465,1],
72475=>[94.139,-78.723,52.439,1],
72476=>[94.153,-78.702,52.414,1],
72477=>[94.205,-78.715,52.391,1],
72478=>[94.219,-78.714,52.365,1],
72479=>[94.229,-78.711,52.338,1],
72480=>[94.239,-78.708,52.311,1],
72481=>[94.249,-78.706,52.286,1],
72482=>[94.259,-78.703,52.262,1],
72483=>[94.270,-78.701,52.238,1],
72484=>[94.281,-78.696,52.212,1],
72485=>[94.290,-78.694,52.183,1],
72486=>[94.299,-78.692,52.154,1],
72487=>[94.308,-78.689,52.125,1],
72488=>[94.316,-78.687,52.096,1],
72489=>[94.325,-78.685,52.069,1],
72490=>[94.334,-78.683,52.042,1],
72491=>[94.342,-78.680,52.014,1],
72492=>[94.351,-78.678,51.986,1],
72493=>[94.359,-78.676,51.956,1],
72494=>[94.372,-78.677,51.927,1],
72495=>[94.385,-78.683,51.895,1],
72496=>[94.398,-78.687,51.863,1],
72497=>[94.411,-78.692,51.831,1],
72498=>[94.424,-78.696,51.799,1],
72499=>[94.437,-78.702,51.769,1],
72500=>[94.452,-78.700,51.739,1],
72501=>[94.469,-78.704,51.708,1],
72502=>[94.486,-78.708,51.675,1],
72503=>[94.509,-78.714,51.642,1],
72504=>[94.537,-78.721,51.609,1],
72505=>[94.564,-78.728,51.576,1],
72506=>[94.591,-78.735,51.541,1],
72507=>[94.618,-78.742,51.503,1],
72508=>[94.636,-78.744,51.467,1],
72509=>[94.654,-78.745,51.432,1],
72510=>[94.672,-78.748,51.398,1],
72511=>[94.690,-78.750,51.364,1],
72512=>[94.708,-78.752,51.332,1],
72513=>[94.726,-78.755,51.298,1],
72514=>[94.745,-78.757,51.265,1],
72515=>[94.755,-78.759,51.232,1],
72516=>[94.766,-78.761,51.196,1],
72517=>[94.773,-78.754,51.159,1],
72518=>[94.779,-78.744,51.124,1],
72519=>[94.784,-78.733,51.085,1],
72520=>[94.783,-78.730,51.046,1],
72521=>[94.779,-78.732,51.006,1],
72522=>[94.765,-78.726,50.968,1],
72523=>[94.750,-78.734,50.930,1],
72524=>[94.739,-78.751,50.891,1],
72525=>[94.727,-78.767,50.850,1],
72526=>[94.726,-78.774,50.810,1],
72527=>[94.745,-78.761,50.767,1],
72528=>[94.764,-78.749,50.722,1],
72529=>[94.781,-78.736,50.680,1],
72530=>[94.799,-78.733,50.638,1],
72531=>[94.817,-78.730,50.596,1],
72532=>[94.835,-78.727,50.555,1],
72533=>[94.853,-78.724,50.513,1],
72534=>[94.872,-78.720,50.471,1],
72535=>[94.881,-78.725,50.427,1],
72536=>[94.880,-78.740,50.384,1],
72537=>[94.879,-78.756,50.344,1],
72538=>[94.878,-78.771,50.306,1],
72539=>[94.877,-78.786,50.271,1],
72540=>[94.875,-78.802,50.234,1],
72541=>[94.874,-78.818,50.198,1],
72542=>[94.873,-78.833,50.161,1],
72543=>[94.872,-78.849,50.124,1],
72544=>[94.864,-78.849,50.087,1],
72545=>[94.856,-78.848,50.048,1],
72546=>[94.848,-78.848,50.008,1],
72547=>[94.857,-78.849,49.969,1],
72548=>[94.875,-78.852,49.929,1],
72549=>[94.891,-78.855,49.888,1],
72550=>[94.908,-78.858,49.846,1],
72551=>[94.924,-78.861,49.805,1],
72552=>[94.942,-78.865,49.767,1],
72553=>[94.958,-78.868,49.731,1],
72554=>[94.987,-78.863,49.696,1],
72555=>[95.016,-78.858,49.660,1],
72556=>[95.045,-78.858,49.623,1],
72557=>[95.074,-78.865,49.584,1],
72558=>[95.103,-78.870,49.544,1],
72559=>[95.132,-78.876,49.505,1],
72560=>[95.162,-78.881,49.462,1],
72561=>[95.191,-78.887,49.421,1],
72562=>[95.220,-78.893,49.380,1],
72563=>[95.250,-78.899,49.341,1],
72564=>[95.279,-78.906,49.302,1],
72565=>[95.309,-78.913,49.263,1],
72566=>[95.338,-78.920,49.224,1],
72567=>[95.368,-78.927,49.183,1],
72568=>[95.393,-78.930,49.142,1],
72569=>[95.405,-78.935,49.101,1],
72570=>[95.413,-78.940,49.057,1],
72571=>[95.421,-78.946,49.016,1],
72572=>[95.430,-78.952,48.975,1],
72573=>[95.439,-78.958,48.932,1],
72574=>[95.447,-78.964,48.889,1],
72575=>[95.456,-78.970,48.847,1],
72576=>[95.460,-78.990,48.805,1],
72577=>[95.465,-79.009,48.763,1],
72578=>[95.469,-79.030,48.721,1],
72579=>[95.474,-79.049,48.677,1],
72580=>[95.479,-79.070,48.633,1],
72581=>[95.483,-79.090,48.589,1],
72582=>[95.488,-79.110,48.546,1],
72583=>[95.492,-79.130,48.503,1],
72584=>[95.497,-79.150,48.458,1],
72585=>[95.511,-79.165,48.414,1],
72586=>[95.526,-79.178,48.370,1],
72587=>[95.548,-79.166,48.324,1],
72588=>[95.570,-79.153,48.278,1],
72589=>[95.593,-79.140,48.232,1],
72590=>[95.615,-79.127,48.186,1],
72591=>[95.637,-79.114,48.141,1],
72592=>[95.660,-79.100,48.095,1],
72593=>[95.682,-79.087,48.050,1],
72594=>[95.705,-79.074,48.004,1],
72595=>[95.725,-79.062,47.960,1],
72596=>[95.734,-79.059,47.916,1],
72597=>[95.741,-79.056,47.872,1],
72598=>[95.747,-79.052,47.830,1],
72599=>[95.753,-79.048,47.788,1],
72600=>[95.760,-79.045,47.747,1],
72601=>[95.772,-79.046,47.704,1],
72602=>[95.784,-79.046,47.662,1],
72603=>[95.797,-79.047,47.620,1],
72604=>[95.809,-79.048,47.579,1],
72605=>[95.821,-79.049,47.540,1],
72606=>[95.834,-79.049,47.500,1],
72607=>[95.846,-79.050,47.460,1],
72608=>[95.859,-79.054,47.420,1],
72609=>[95.879,-79.075,47.380,1],
72610=>[95.899,-79.093,47.340,1],
72611=>[95.941,-79.084,47.302,1],
72612=>[96.037,-79.088,47.263,1],
72613=>[96.077,-79.091,47.225,1],
72614=>[96.114,-79.087,47.188,1],
72615=>[96.148,-79.075,47.151,1],
72616=>[96.182,-79.062,47.116,1],
72617=>[96.217,-79.049,47.081,1],
72618=>[96.251,-79.036,47.044,1],
72619=>[96.285,-79.024,47.012,1],
72620=>[96.320,-79.011,46.979,1],
72621=>[96.354,-78.998,46.947,1],
72622=>[96.383,-79.033,46.915,1],
72623=>[96.412,-79.079,46.884,1],
72624=>[96.440,-79.125,46.853,1],
72625=>[96.457,-79.132,46.822,1],
72626=>[96.472,-79.132,46.790,1],
72627=>[96.486,-79.133,46.759,1],
72628=>[96.501,-79.134,46.728,1],
72629=>[96.520,-79.139,46.697,1],
72630=>[96.544,-79.151,46.665,1],
72631=>[96.568,-79.162,46.633,1],
72632=>[96.591,-79.175,46.601,1],
72633=>[96.614,-79.185,46.571,1],
72634=>[96.612,-79.169,46.541,1],
72635=>[96.610,-79.152,46.514,1],
72636=>[96.617,-79.138,46.486,1],
72637=>[96.653,-79.139,46.458,1],
72638=>[96.690,-79.140,46.431,1],
72639=>[96.726,-79.141,46.403,1],
72640=>[96.762,-79.142,46.377,1],
72641=>[96.785,-79.144,46.351,1],
72642=>[96.807,-79.147,46.326,1],
72643=>[96.830,-79.150,46.299,1],
72644=>[96.853,-79.152,46.274,1],
72645=>[96.872,-79.135,46.249,1],
72646=>[96.901,-79.131,46.224,1],
72647=>[96.892,-79.168,46.200,1],
72648=>[96.869,-79.212,46.177,1],
72649=>[96.904,-79.175,46.154,1],
72650=>[96.940,-79.140,46.130,1],
72651=>[96.975,-79.103,46.106,1],
72652=>[97.011,-79.067,46.082,1],
72653=>[97.052,-79.107,46.060,1],
72654=>[97.094,-79.152,46.040,1],
72655=>[97.095,-79.158,46.020,1],
72656=>[97.091,-79.159,46.000,1],
72657=>[97.087,-79.160,45.981,1],
72658=>[97.082,-79.161,45.962,1],
72659=>[97.082,-79.162,45.944,1],
72660=>[97.091,-79.162,45.924,1],
72661=>[97.100,-79.163,45.905,1],
72662=>[97.104,-79.171,45.887,1],
72663=>[97.108,-79.174,45.869,1],
72664=>[97.124,-79.161,45.850,1],
72665=>[97.145,-79.146,45.831,1],
72666=>[97.168,-79.127,45.812,1],
72667=>[97.184,-79.219,45.793,1],
72668=>[97.181,-79.128,45.775,1],
72669=>[97.180,-79.098,45.759,1],
72670=>[97.181,-79.099,45.743,1],
72671=>[97.170,-79.112,45.725,1],
72672=>[97.168,-79.148,45.708,1],
72673=>[97.178,-79.147,45.690,1],
72674=>[97.213,-79.146,45.671,1],
72675=>[97.250,-79.144,45.655,1],
72676=>[97.281,-79.147,45.639,1],
72677=>[97.295,-79.165,45.623,1],
72678=>[97.309,-79.181,45.607,1],
72679=>[97.323,-79.198,45.591,1],
72680=>[97.337,-79.215,45.575,1],
72681=>[97.352,-79.232,45.559,1],
72682=>[97.366,-79.249,45.544,1],
72683=>[97.330,-79.286,45.529,1],
72684=>[97.300,-79.314,45.513,1],
72685=>[97.315,-79.307,45.498,1],
72686=>[97.331,-79.301,45.483,1],
72687=>[97.347,-79.294,45.468,1],
72688=>[97.370,-79.284,45.452,1],
72689=>[97.383,-79.272,45.438,1],
72690=>[97.404,-79.273,45.425,1],
72691=>[97.432,-79.285,45.410,1],
72692=>[97.461,-79.328,45.396,1],
72693=>[97.468,-79.341,45.382,1],
72694=>[97.473,-79.349,45.368,1],
72695=>[97.479,-79.357,45.353,1],
72696=>[97.485,-79.365,45.339,1],
72697=>[97.493,-79.374,45.325,1],
72698=>[97.508,-79.363,45.313,1],
72699=>[97.514,-79.357,45.300,1],
72700=>[97.518,-79.352,45.287,1],
72701=>[97.522,-79.347,45.274,1],
72702=>[97.525,-79.343,45.262,1],
72703=>[97.529,-79.338,45.250,1],
72704=>[97.533,-79.334,45.237,1],
72705=>[97.537,-79.329,45.225,1],
72706=>[97.543,-79.410,45.213,1],
72707=>[97.566,-79.400,45.200,1],
72708=>[97.585,-79.435,45.188,1],
72709=>[97.605,-79.469,45.177,1],
72710=>[97.620,-79.523,45.166,1],
72711=>[97.635,-79.524,45.154,1],
72712=>[97.649,-79.525,45.143,1],
72713=>[97.666,-79.540,45.131,1],
72714=>[97.683,-79.556,45.120,1],
72715=>[97.701,-79.572,45.108,1],
72716=>[97.718,-79.588,45.097,1],
72717=>[97.735,-79.604,45.085,1],
72718=>[97.752,-79.620,45.073,1],
72719=>[97.770,-79.636,45.061,1],
72720=>[97.787,-79.651,45.048,1],
72721=>[97.804,-79.667,45.036,1],
72722=>[97.821,-79.683,45.023,1],
72723=>[97.839,-79.699,45.010,1],
72724=>[97.856,-79.715,44.998,1],
72725=>[97.873,-79.731,44.987,1],
72726=>[97.891,-79.747,44.975,1],
72727=>[97.908,-79.763,44.964,1],
72728=>[97.925,-79.779,44.954,1],
72729=>[97.943,-79.795,44.944,1],
72730=>[97.960,-79.811,44.934,1],
72731=>[97.977,-79.827,44.925,1],
72732=>[97.995,-79.843,44.916,1],
72733=>[98.012,-79.859,44.907,1],
72734=>[98.029,-79.875,44.898,1],
72735=>[98.054,-79.889,44.891,1],
72736=>[98.077,-79.903,44.883,1],
72737=>[98.101,-79.918,44.875,1],
72738=>[98.125,-79.932,44.868,1],
72739=>[98.148,-79.947,44.861,1],
72740=>[98.171,-79.961,44.855,1],
72741=>[98.196,-79.974,44.849,1],
72742=>[98.222,-79.987,44.842,1],
72743=>[98.253,-79.991,44.836,1],
72744=>[98.266,-79.993,44.829,1],
72745=>[98.278,-79.994,44.821,1],
72746=>[98.290,-79.996,44.813,1],
72747=>[98.319,-80.002,44.805,1],
72748=>[98.371,-80.012,44.797,1],
72749=>[98.423,-80.021,44.790,1],
72750=>[98.467,-80.032,44.783,1],
72751=>[98.495,-80.047,44.778,1],
72752=>[98.522,-80.062,44.774,1],
72753=>[98.550,-80.077,44.767,1],
72754=>[98.578,-80.091,44.760,1],
72755=>[98.607,-80.094,44.752,1],
72756=>[98.637,-80.098,44.744,1],
72757=>[98.667,-80.101,44.739,1],
72758=>[98.696,-80.104,44.736,1],
72759=>[98.720,-80.107,44.731,1],
72760=>[98.742,-80.117,44.722,1],
72761=>[98.756,-80.131,44.712,1],
72762=>[98.769,-80.144,44.702,1],
72763=>[98.782,-80.157,44.687,1],
72764=>[98.807,-80.168,44.674,1],
72765=>[98.833,-80.175,44.662,1],
72766=>[98.849,-80.159,44.652,1],
72767=>[98.859,-80.156,44.643,1],
72768=>[98.876,-80.167,44.634,1],
72769=>[98.892,-80.178,44.627,1],
72770=>[98.909,-80.190,44.620,1],
72771=>[98.926,-80.201,44.613,1],
72772=>[98.942,-80.212,44.606,1],
72773=>[98.995,-80.219,44.600,1],
72774=>[99.048,-80.243,44.594,1],
72775=>[99.071,-80.254,44.589,1],
72776=>[99.094,-80.265,44.584,1],
72777=>[99.118,-80.275,44.578,1],
72778=>[99.141,-80.286,44.572,1],
72779=>[99.164,-80.296,44.567,1],
72780=>[99.188,-80.306,44.562,1],
72781=>[99.211,-80.317,44.558,1],
72782=>[99.234,-80.328,44.554,1],
72783=>[99.258,-80.338,44.550,1],
72784=>[99.281,-80.349,44.546,1],
72785=>[99.304,-80.359,44.543,1],
72786=>[99.336,-80.366,44.540,1],
72787=>[99.375,-80.370,44.536,1],
72788=>[99.413,-80.374,44.533,1],
72789=>[99.452,-80.378,44.529,1],
72790=>[99.491,-80.382,44.525,1],
72791=>[99.529,-80.386,44.521,1],
72792=>[99.564,-80.391,44.518,1],
72793=>[99.567,-80.414,44.514,1],
72794=>[99.570,-80.436,44.510,1],
72795=>[99.574,-80.458,44.506,1],
73112=>[93.513,-78.955,53.486,1],
73113=>[93.523,-78.952,53.475,1],
73114=>[93.533,-78.949,53.465,1],
73115=>[93.543,-78.944,53.455,1],
73116=>[93.555,-78.934,53.447,1],
73117=>[93.563,-78.927,53.439,1],
73118=>[93.571,-78.921,53.430,1],
73119=>[93.580,-78.913,53.421,1],
73120=>[93.588,-78.906,53.413,1],
73121=>[93.596,-78.899,53.405,1],
73122=>[93.605,-78.893,53.397,1],
73123=>[93.631,-78.877,53.389,1],
73124=>[93.697,-78.845,53.383,1],
73125=>[93.666,-78.841,53.378,1],
73126=>[93.662,-78.836,53.374,1],
73127=>[93.672,-78.833,53.369,1],
73128=>[93.682,-78.832,53.365,1],
73129=>[93.691,-78.830,53.362,1],
73130=>[93.700,-78.828,53.357,1],
73131=>[93.710,-78.827,53.352,1],
73132=>[93.721,-78.830,53.345,1],
73133=>[93.732,-78.839,53.337,1],
73134=>[93.739,-78.836,53.329,1],
73135=>[93.746,-78.833,53.320,1],
73136=>[93.753,-78.830,53.311,1],
73137=>[93.760,-78.827,53.298,1],
73138=>[93.767,-78.825,53.286,1],
73139=>[93.774,-78.822,53.274,1],
73140=>[93.781,-78.819,53.262,1],
73141=>[93.788,-78.816,53.250,1],
73142=>[93.795,-78.814,53.237,1],
73143=>[93.802,-78.811,53.223,1],
73144=>[93.814,-78.803,53.206,1],
73145=>[93.820,-78.799,53.187,1],
73146=>[93.825,-78.794,53.168,1],
73147=>[93.830,-78.789,53.149,1],
73148=>[93.835,-78.786,53.128,1],
73149=>[93.841,-78.781,53.107,1],
73150=>[93.846,-78.777,53.087,1],
73151=>[93.851,-78.772,53.063,1],
73152=>[93.856,-78.767,53.039,1],
73153=>[93.862,-78.763,53.014,1],
73154=>[93.867,-78.759,52.988,1],
73155=>[93.872,-78.755,52.962,1],
73156=>[93.883,-78.749,52.936,1],
73157=>[93.898,-78.742,52.910,1],
73158=>[93.914,-78.736,52.883,1],
73159=>[93.930,-78.730,52.856,1],
73160=>[93.946,-78.724,52.830,1],
73161=>[93.962,-78.717,52.805,1],
73162=>[93.978,-78.711,52.779,1],
73163=>[93.994,-78.705,52.755,1],
73164=>[94.009,-78.698,52.732,1],
73165=>[94.026,-78.692,52.708,1],
73166=>[94.041,-78.686,52.685,1],
73167=>[94.057,-78.680,52.664,1],
73168=>[94.077,-78.681,52.641,1],
73169=>[94.092,-78.681,52.619,1],
73170=>[94.103,-78.677,52.596,1],
73171=>[94.111,-78.677,52.573,1],
73172=>[94.115,-78.685,52.551,1],
73173=>[94.120,-78.692,52.528,1],
73174=>[94.124,-78.700,52.504,1],
73175=>[94.128,-78.708,52.478,1],
73176=>[94.144,-78.684,52.452,1],
73177=>[94.189,-78.686,52.426,1],
73178=>[94.232,-78.696,52.402,1],
73179=>[94.242,-78.694,52.377,1],
73180=>[94.252,-78.691,52.351,1],
73181=>[94.262,-78.689,52.325,1],
73182=>[94.272,-78.686,52.300,1],
73183=>[94.281,-78.683,52.277,1],
73184=>[94.282,-78.688,52.254,1],
73185=>[94.290,-78.685,52.228,1],
73186=>[94.299,-78.683,52.199,1],
73187=>[94.308,-78.680,52.170,1],
73188=>[94.316,-78.678,52.142,1],
73189=>[94.325,-78.676,52.114,1],
73190=>[94.333,-78.673,52.087,1],
73191=>[94.342,-78.671,52.061,1],
73192=>[94.351,-78.669,52.034,1],
73193=>[94.359,-78.667,52.006,1],
73194=>[94.368,-78.664,51.977,1],
73195=>[94.380,-78.665,51.948,1],
73196=>[94.390,-78.670,51.917,1],
73197=>[94.402,-78.676,51.885,1],
73198=>[94.415,-78.680,51.853,1],
73199=>[94.428,-78.685,51.820,1],
73200=>[94.441,-78.690,51.790,1],
73201=>[94.455,-78.694,51.760,1],
73202=>[94.472,-78.695,51.729,1],
73203=>[94.494,-78.701,51.696,1],
73204=>[94.521,-78.708,51.661,1],
73205=>[94.548,-78.714,51.625,1],
73206=>[94.567,-78.717,51.590,1],
73207=>[94.585,-78.720,51.553,1],
73208=>[94.603,-78.721,51.515,1],
73209=>[94.621,-78.724,51.479,1],
73210=>[94.639,-78.726,51.444,1],
73211=>[94.657,-78.728,51.411,1],
73212=>[94.676,-78.730,51.378,1],
73213=>[94.694,-78.733,51.346,1],
73214=>[94.712,-78.735,51.314,1],
73215=>[94.730,-78.737,51.282,1],
73216=>[94.740,-78.739,51.250,1],
73217=>[94.751,-78.741,51.215,1],
73218=>[94.762,-78.743,51.178,1],
73219=>[94.768,-78.733,51.141,1],
73220=>[94.773,-78.724,51.102,1],
73221=>[94.779,-78.713,51.062,1],
73222=>[94.784,-78.702,51.022,1],
73223=>[94.779,-78.706,50.983,1],
73224=>[94.767,-78.723,50.944,1],
73225=>[94.756,-78.739,50.905,1],
73226=>[94.744,-78.756,50.865,1],
73227=>[94.742,-78.764,50.823,1],
73228=>[94.761,-78.751,50.780,1],
73229=>[94.778,-78.739,50.735,1],
73230=>[94.787,-78.730,50.692,1],
73231=>[94.796,-78.722,50.651,1],
73232=>[94.815,-78.719,50.610,1],
73233=>[94.833,-78.715,50.569,1],
73234=>[94.851,-78.712,50.528,1],
73235=>[94.870,-78.709,50.485,1],
73236=>[94.880,-78.713,50.440,1],
73237=>[94.879,-78.729,50.397,1],
73238=>[94.878,-78.744,50.355,1],
73239=>[94.876,-78.760,50.315,1],
73240=>[94.875,-78.775,50.278,1],
73241=>[94.874,-78.790,50.241,1],
73242=>[94.873,-78.806,50.204,1],
73243=>[94.872,-78.821,50.167,1],
73244=>[94.871,-78.837,50.130,1],
73245=>[94.868,-78.851,50.092,1],
73246=>[94.860,-78.851,50.052,1],
73247=>[94.853,-78.850,50.014,1],
73248=>[94.858,-78.852,49.975,1],
73249=>[94.875,-78.855,49.935,1],
73250=>[94.892,-78.858,49.895,1],
73251=>[94.909,-78.861,49.855,1],
73252=>[94.925,-78.864,49.817,1],
73253=>[94.947,-78.864,49.781,1],
73254=>[94.975,-78.859,49.745,1],
73255=>[95.004,-78.855,49.708,1],
73256=>[95.033,-78.850,49.670,1],
73257=>[95.061,-78.846,49.632,1],
73258=>[95.091,-78.849,49.591,1],
73259=>[95.120,-78.855,49.550,1],
73260=>[95.149,-78.861,49.509,1],
73261=>[95.179,-78.867,49.467,1],
73262=>[95.208,-78.872,49.426,1],
73263=>[95.237,-78.878,49.386,1],
73264=>[95.266,-78.883,49.346,1],
73265=>[95.296,-78.890,49.307,1],
73266=>[95.325,-78.895,49.268,1],
73267=>[95.354,-78.901,49.230,1],
73268=>[95.384,-78.906,49.190,1],
73269=>[95.405,-78.912,49.149,1],
73270=>[95.414,-78.918,49.106,1],
73271=>[95.422,-78.924,49.063,1],
73272=>[95.430,-78.930,49.022,1],
73273=>[95.439,-78.935,48.981,1],
73274=>[95.448,-78.941,48.939,1],
73275=>[95.456,-78.947,48.897,1],
73276=>[95.465,-78.952,48.855,1],
73277=>[95.471,-78.968,48.813,1],
73278=>[95.475,-78.988,48.771,1],
73279=>[95.480,-79.008,48.729,1],
73280=>[95.484,-79.028,48.686,1],
73281=>[95.489,-79.048,48.640,1],
73282=>[95.493,-79.068,48.598,1],
73283=>[95.498,-79.088,48.556,1],
73284=>[95.502,-79.109,48.513,1],
73285=>[95.516,-79.123,48.469,1],
73286=>[95.531,-79.137,48.425,1],
73287=>[95.546,-79.150,48.380,1],
73288=>[95.562,-79.160,48.334,1],
73289=>[95.585,-79.147,48.286,1],
73290=>[95.607,-79.134,48.239,1],
73291=>[95.629,-79.120,48.192,1],
73292=>[95.652,-79.107,48.146,1],
73293=>[95.674,-79.094,48.100,1],
73294=>[95.697,-79.081,48.055,1],
73295=>[95.719,-79.068,48.009,1],
73296=>[95.733,-79.061,47.964,1],
73297=>[95.742,-79.057,47.920,1],
73298=>[95.750,-79.053,47.877,1],
73299=>[95.756,-79.049,47.836,1],
73300=>[95.763,-79.046,47.795,1],
73301=>[95.769,-79.043,47.753,1],
73302=>[95.776,-79.039,47.711,1],
73303=>[95.782,-79.035,47.667,1],
73304=>[95.789,-79.031,47.625,1],
73305=>[95.795,-79.028,47.583,1],
73306=>[95.805,-79.027,47.543,1],
73307=>[95.817,-79.028,47.502,1],
73308=>[95.830,-79.028,47.462,1],
73309=>[95.842,-79.029,47.422,1],
73310=>[95.857,-79.038,47.382,1],
73311=>[95.877,-79.043,47.343,1],
73312=>[95.943,-79.061,47.304,1],
73313=>[96.030,-79.071,47.266,1],
73314=>[96.079,-79.073,47.228,1],
73315=>[96.118,-79.076,47.190,1],
73316=>[96.156,-79.073,47.153,1],
73317=>[96.190,-79.060,47.118,1],
73318=>[96.225,-79.047,47.083,1],
73319=>[96.259,-79.035,47.047,1],
73320=>[96.294,-79.022,47.013,1],
73321=>[96.328,-79.009,46.981,1],
73322=>[96.362,-78.996,46.949,1],
73323=>[96.391,-79.033,46.918,1],
73324=>[96.419,-79.078,46.887,1],
73325=>[96.444,-79.111,46.856,1],
73326=>[96.459,-79.112,46.824,1],
73327=>[96.474,-79.112,46.792,1],
73328=>[96.488,-79.112,46.760,1],
73329=>[96.508,-79.119,46.729,1],
73330=>[96.532,-79.131,46.697,1],
73331=>[96.555,-79.143,46.666,1],
73332=>[96.579,-79.154,46.635,1],
73333=>[96.603,-79.166,46.603,1],
73334=>[96.626,-79.178,46.572,1],
73335=>[96.633,-79.170,46.543,1],
73336=>[96.631,-79.153,46.515,1],
73337=>[96.629,-79.137,46.488,1],
73338=>[96.627,-79.120,46.460,1],
73339=>[96.662,-79.119,46.433,1],
73340=>[96.698,-79.120,46.406,1],
73341=>[96.735,-79.121,46.379,1],
73342=>[96.771,-79.122,46.353,1],
73343=>[96.808,-79.123,46.328,1],
73344=>[96.838,-79.125,46.304,1],
73345=>[96.861,-79.127,46.279,1],
73346=>[96.885,-79.118,46.254,1],
73347=>[96.865,-79.162,46.229,1],
73348=>[96.840,-79.209,46.206,1],
73349=>[96.874,-79.175,46.183,1],
73350=>[96.909,-79.139,46.160,1],
73351=>[96.945,-79.103,46.135,1],
73352=>[96.980,-79.067,46.110,1],
73353=>[97.018,-79.057,46.086,1],
73354=>[97.060,-79.102,46.065,1],
73355=>[97.102,-79.147,46.045,1],
73356=>[97.098,-79.148,46.026,1],
73357=>[97.094,-79.150,46.006,1],
73358=>[97.090,-79.150,45.986,1],
73359=>[97.085,-79.151,45.967,1],
73360=>[97.074,-79.146,45.948,1],
73361=>[97.076,-79.167,45.929,1],
73362=>[97.079,-79.175,45.910,1],
73363=>[97.082,-79.184,45.892,1],
73364=>[97.088,-79.173,45.874,1],
73365=>[97.104,-79.159,45.856,1],
73366=>[97.126,-79.140,45.837,1],
73367=>[97.149,-79.118,45.818,1],
73368=>[97.171,-79.127,45.800,1],
73369=>[97.191,-79.244,45.782,1],
73370=>[97.196,-79.235,45.766,1],
73371=>[97.197,-79.145,45.750,1],
73372=>[97.170,-79.119,45.732,1],
73373=>[97.149,-79.137,45.714,1],
73374=>[97.176,-79.153,45.696,1],
73375=>[97.203,-79.150,45.679,1],
73376=>[97.240,-79.148,45.662,1],
73377=>[97.278,-79.147,45.646,1],
73378=>[97.312,-79.147,45.630,1],
73379=>[97.326,-79.164,45.615,1],
73380=>[97.341,-79.181,45.599,1],
73381=>[97.355,-79.198,45.583,1],
73382=>[97.369,-79.215,45.567,1],
73383=>[97.375,-79.235,45.551,1],
73384=>[97.320,-79.280,45.537,1],
73385=>[97.304,-79.297,45.521,1],
73386=>[97.319,-79.291,45.506,1],
73387=>[97.334,-79.285,45.491,1],
73388=>[97.350,-79.278,45.477,1],
73389=>[97.369,-79.270,45.462,1],
73390=>[97.387,-79.266,45.447,1],
73391=>[97.414,-79.277,45.434,1],
73392=>[97.442,-79.289,45.419,1],
73393=>[97.462,-79.320,45.405,1],
73394=>[97.467,-79.328,45.391,1],
73395=>[97.473,-79.336,45.376,1],
73396=>[97.478,-79.344,45.362,1],
73397=>[97.484,-79.352,45.349,1],
73398=>[97.491,-79.360,45.335,1],
73399=>[97.495,-79.356,45.322,1],
73400=>[97.499,-79.352,45.309,1],
73401=>[97.503,-79.347,45.297,1],
73402=>[97.507,-79.343,45.284,1],
73403=>[97.511,-79.338,45.271,1],
73404=>[97.515,-79.334,45.259,1],
73405=>[97.519,-79.330,45.247,1],
73406=>[97.523,-79.325,45.234,1],
73407=>[97.527,-79.321,45.222,1],
73408=>[97.540,-79.342,45.210,1],
73409=>[97.557,-79.372,45.198,1],
73410=>[97.576,-79.407,45.187,1],
73411=>[97.595,-79.441,45.176,1],
73412=>[97.614,-79.476,45.164,1],
73413=>[97.634,-79.520,45.153,1],
73414=>[97.648,-79.607,45.142,1],
73415=>[97.662,-79.607,45.130,1],
73416=>[97.676,-79.609,45.119,1],
73417=>[97.691,-79.610,45.107,1],
73418=>[97.705,-79.611,45.096,1],
73419=>[97.719,-79.612,45.084,1],
73420=>[97.736,-79.626,45.072,1],
73421=>[97.753,-79.642,45.060,1],
73422=>[97.771,-79.657,45.047,1],
73423=>[97.788,-79.673,45.035,1],
73424=>[97.805,-79.689,45.022,1],
73425=>[97.822,-79.705,45.010,1],
73426=>[97.840,-79.721,44.999,1],
73427=>[97.857,-79.737,44.988,1],
73428=>[97.874,-79.754,44.977,1],
73429=>[97.892,-79.770,44.967,1],
73430=>[97.909,-79.786,44.958,1],
73431=>[97.926,-79.802,44.948,1],
73432=>[97.949,-79.816,44.939,1],
73433=>[97.973,-79.830,44.931,1],
73434=>[97.997,-79.845,44.922,1],
73435=>[98.020,-79.859,44.913,1],
73436=>[98.043,-79.874,44.906,1],
73437=>[98.066,-79.889,44.899,1],
73438=>[98.090,-79.902,44.892,1],
73439=>[98.116,-79.914,44.886,1],
73440=>[98.143,-79.927,44.880,1],
73441=>[98.171,-79.935,44.874,1],
73442=>[98.184,-79.936,44.868,1],
73443=>[98.199,-79.939,44.862,1],
73444=>[98.222,-79.948,44.855,1],
73445=>[98.246,-79.955,44.847,1],
73446=>[98.270,-79.964,44.838,1],
73447=>[98.295,-79.969,44.828,1],
73448=>[98.324,-79.977,44.819,1],
73449=>[98.362,-79.989,44.811,1],
73450=>[98.406,-79.999,44.804,1],
73451=>[98.458,-80.009,44.798,1],
73452=>[98.501,-80.021,44.794,1],
73453=>[98.528,-80.036,44.790,1],
73454=>[98.556,-80.051,44.783,1],
73455=>[98.585,-80.059,44.775,1],
73456=>[98.614,-80.062,44.765,1],
73457=>[98.644,-80.065,44.755,1],
73458=>[98.673,-80.068,44.748,1],
73459=>[98.703,-80.073,44.743,1],
73460=>[98.723,-80.083,44.737,1],
73461=>[98.735,-80.098,44.727,1],
73462=>[98.748,-80.112,44.717,1],
73463=>[98.761,-80.124,44.706,1],
73464=>[98.779,-80.137,44.693,1],
73465=>[98.805,-80.147,44.682,1],
73466=>[98.833,-80.156,44.672,1],
73467=>[98.861,-80.145,44.662,1],
73468=>[98.875,-80.131,44.653,1],
73469=>[98.889,-80.135,44.645,1],
73470=>[98.905,-80.146,44.638,1],
73471=>[98.922,-80.157,44.631,1],
73472=>[98.938,-80.168,44.624,1],
73473=>[98.955,-80.180,44.617,1],
73474=>[98.971,-80.191,44.610,1],
73475=>[99.001,-80.199,44.604,1],
73476=>[99.075,-80.227,44.599,1],
73477=>[99.098,-80.237,44.594,1],
73478=>[99.122,-80.248,44.588,1],
73479=>[99.145,-80.259,44.582,1],
73480=>[99.168,-80.269,44.577,1],
73481=>[99.192,-80.279,44.572,1],
73482=>[99.215,-80.290,44.568,1],
73483=>[99.238,-80.300,44.563,1],
73484=>[99.262,-80.311,44.559,1],
73485=>[99.285,-80.322,44.556,1],
73486=>[99.308,-80.332,44.552,1],
73487=>[99.347,-80.336,44.549,1],
73488=>[99.385,-80.340,44.546,1],
73489=>[99.424,-80.344,44.542,1],
73490=>[99.463,-80.348,44.538,1],
73491=>[99.501,-80.352,44.535,1],
73492=>[99.540,-80.356,44.531,1],
73493=>[99.561,-80.369,44.527,1],
73494=>[99.564,-80.391,44.524,1],
73495=>[99.567,-80.413,44.519,1],
73496=>[99.570,-80.435,44.515,1],
73497=>[99.573,-80.457,44.510,1],
73498=>[99.577,-80.479,44.505,1],
73814=>[93.523,-78.941,53.490,1],
73815=>[93.533,-78.939,53.479,1],
73816=>[93.543,-78.937,53.470,1],
73817=>[93.553,-78.930,53.461,1],
73818=>[93.564,-78.921,53.452,1],
73819=>[93.572,-78.914,53.443,1],
73820=>[93.581,-78.907,53.435,1],
73821=>[93.589,-78.900,53.426,1],
73822=>[93.597,-78.893,53.418,1],
73823=>[93.606,-78.886,53.410,1],
73824=>[93.619,-78.877,53.403,1],
73825=>[93.688,-78.843,53.397,1],
73826=>[93.703,-78.826,53.391,1],
73827=>[93.699,-78.820,53.386,1],
73828=>[93.695,-78.814,53.383,1],
73829=>[93.691,-78.808,53.380,1],
73830=>[93.687,-78.802,53.377,1],
73831=>[93.694,-78.805,53.372,1],
73832=>[93.707,-78.818,53.367,1],
73833=>[93.720,-78.830,53.361,1],
73834=>[93.728,-78.831,53.352,1],
73835=>[93.735,-78.829,53.343,1],
73836=>[93.742,-78.826,53.335,1],
73837=>[93.749,-78.823,53.325,1],
73838=>[93.756,-78.821,53.313,1],
73839=>[93.763,-78.818,53.300,1],
73840=>[93.770,-78.814,53.288,1],
73841=>[93.777,-78.811,53.275,1],
73842=>[93.784,-78.809,53.262,1],
73843=>[93.791,-78.806,53.248,1],
73844=>[93.807,-78.797,53.235,1],
73845=>[93.813,-78.789,53.216,1],
73846=>[93.827,-78.781,53.197,1],
73847=>[93.837,-78.774,53.177,1],
73848=>[93.843,-78.770,53.157,1],
73849=>[93.848,-78.765,53.136,1],
73850=>[93.853,-78.761,53.114,1],
73851=>[93.858,-78.757,53.093,1],
73852=>[93.863,-78.752,53.069,1],
73853=>[93.869,-78.748,53.045,1],
73854=>[93.874,-78.743,53.020,1],
73855=>[93.880,-78.739,52.995,1],
73856=>[93.885,-78.734,52.969,1],
73857=>[93.898,-78.729,52.943,1],
73858=>[93.914,-78.722,52.918,1],
73859=>[93.930,-78.716,52.890,1],
73860=>[93.945,-78.710,52.864,1],
73861=>[93.962,-78.703,52.839,1],
73862=>[93.977,-78.697,52.813,1],
73863=>[93.993,-78.691,52.788,1],
73864=>[94.009,-78.685,52.764,1],
73865=>[94.025,-78.678,52.742,1],
73866=>[94.041,-78.672,52.718,1],
73867=>[94.057,-78.666,52.696,1],
73868=>[94.073,-78.659,52.675,1],
73869=>[94.088,-78.653,52.653,1],
73870=>[94.097,-78.655,52.631,1],
73871=>[94.101,-78.662,52.608,1],
73872=>[94.105,-78.670,52.585,1],
73873=>[94.109,-78.678,52.561,1],
73874=>[94.114,-78.686,52.537,1],
73875=>[94.118,-78.694,52.512,1],
73876=>[94.135,-78.665,52.488,1],
73877=>[94.174,-78.658,52.463,1],
73878=>[94.225,-78.671,52.438,1],
73879=>[94.255,-78.677,52.414,1],
73880=>[94.265,-78.673,52.389,1],
73881=>[94.275,-78.671,52.364,1],
73882=>[94.285,-78.668,52.339,1],
73883=>[94.294,-78.666,52.315,1],
73884=>[94.296,-78.670,52.292,1],
73885=>[94.288,-78.682,52.269,1],
73886=>[94.293,-78.681,52.244,1],
73887=>[94.308,-78.671,52.215,1],
73888=>[94.317,-78.669,52.186,1],
73889=>[94.325,-78.667,52.159,1],
73890=>[94.334,-78.664,52.132,1],
73891=>[94.343,-78.662,52.105,1],
73892=>[94.351,-78.660,52.079,1],
73893=>[94.360,-78.658,52.054,1],
73894=>[94.368,-78.655,52.026,1],
73895=>[94.377,-78.653,51.998,1],
73896=>[94.391,-78.652,51.969,1],
73897=>[94.403,-78.658,51.939,1],
73898=>[94.413,-78.662,51.907,1],
73899=>[94.424,-78.667,51.874,1],
73900=>[94.435,-78.673,51.842,1],
73901=>[94.445,-78.678,51.811,1],
73902=>[94.458,-78.683,51.781,1],
73903=>[94.478,-78.688,51.750,1],
73904=>[94.498,-78.691,51.716,1],
73905=>[94.516,-78.693,51.680,1],
73906=>[94.534,-78.695,51.642,1],
73907=>[94.552,-78.697,51.604,1],
73908=>[94.570,-78.699,51.566,1],
73909=>[94.589,-78.702,51.528,1],
73910=>[94.607,-78.704,51.492,1],
73911=>[94.625,-78.706,51.458,1],
73912=>[94.643,-78.708,51.425,1],
73913=>[94.661,-78.711,51.392,1],
73914=>[94.679,-78.712,51.360,1],
73915=>[94.697,-78.714,51.330,1],
73916=>[94.714,-78.717,51.299,1],
73917=>[94.725,-78.719,51.266,1],
73918=>[94.736,-78.721,51.232,1],
73919=>[94.747,-78.724,51.197,1],
73920=>[94.757,-78.724,51.159,1],
73921=>[94.762,-78.714,51.119,1],
73922=>[94.768,-78.703,51.079,1],
73923=>[94.773,-78.696,51.038,1],
73924=>[94.776,-78.705,50.998,1],
73925=>[94.780,-78.714,50.957,1],
73926=>[94.773,-78.728,50.918,1],
73927=>[94.761,-78.745,50.879,1],
73928=>[94.758,-78.754,50.837,1],
73929=>[94.776,-78.741,50.793,1],
73930=>[94.785,-78.733,50.748,1],
73931=>[94.794,-78.724,50.705,1],
73932=>[94.803,-78.716,50.663,1],
73933=>[94.813,-78.708,50.623,1],
73934=>[94.831,-78.705,50.583,1],
73935=>[94.849,-78.701,50.540,1],
73936=>[94.867,-78.698,50.497,1],
73937=>[94.879,-78.702,50.452,1],
73938=>[94.877,-78.717,50.408,1],
73939=>[94.876,-78.733,50.365,1],
73940=>[94.875,-78.748,50.323,1],
73941=>[94.874,-78.764,50.285,1],
73942=>[94.873,-78.779,50.247,1],
73943=>[94.872,-78.794,50.209,1],
73944=>[94.870,-78.810,50.172,1],
73945=>[94.869,-78.825,50.134,1],
73946=>[94.867,-78.841,50.095,1],
73947=>[94.865,-78.853,50.056,1],
73948=>[94.857,-78.853,50.017,1],
73949=>[94.859,-78.854,49.977,1],
73950=>[94.876,-78.857,49.938,1],
73951=>[94.893,-78.860,49.899,1],
73952=>[94.910,-78.863,49.860,1],
73953=>[94.935,-78.860,49.822,1],
73954=>[94.964,-78.855,49.785,1],
73955=>[94.992,-78.851,49.748,1],
73956=>[95.021,-78.846,49.710,1],
73957=>[95.050,-78.842,49.672,1],
73958=>[95.078,-78.837,49.632,1],
73959=>[95.107,-78.835,49.591,1],
73960=>[95.137,-78.840,49.550,1],
73961=>[95.166,-78.846,49.510,1],
73962=>[95.195,-78.852,49.470,1],
73963=>[95.225,-78.858,49.430,1],
73964=>[95.254,-78.863,49.389,1],
73965=>[95.283,-78.869,49.349,1],
73966=>[95.313,-78.874,49.308,1],
73967=>[95.342,-78.880,49.268,1],
73968=>[95.370,-78.886,49.227,1],
73969=>[95.389,-78.899,49.189,1],
73970=>[95.407,-78.905,49.149,1],
73971=>[95.421,-78.903,49.109,1],
73972=>[95.431,-78.907,49.067,1],
73973=>[95.440,-78.912,49.026,1],
73974=>[95.448,-78.918,48.984,1],
73975=>[95.457,-78.924,48.941,1],
73976=>[95.465,-78.930,48.900,1],
73977=>[95.473,-78.936,48.857,1],
73978=>[95.481,-78.946,48.815,1],
73979=>[95.485,-78.966,48.774,1],
73980=>[95.490,-78.987,48.732,1],
73981=>[95.494,-79.006,48.689,1],
73982=>[95.499,-79.027,48.646,1],
73983=>[95.503,-79.046,48.606,1],
73984=>[95.509,-79.067,48.565,1],
73985=>[95.521,-79.082,48.522,1],
73986=>[95.536,-79.095,48.478,1],
73987=>[95.551,-79.109,48.433,1],
73988=>[95.566,-79.122,48.387,1],
73989=>[95.582,-79.134,48.341,1],
73990=>[95.599,-79.140,48.293,1],
73991=>[95.621,-79.127,48.245,1],
73992=>[95.644,-79.114,48.199,1],
73993=>[95.666,-79.100,48.153,1],
73994=>[95.689,-79.087,48.107,1],
73995=>[95.711,-79.074,48.061,1],
73996=>[95.731,-79.062,48.014,1],
73997=>[95.740,-79.059,47.970,1],
73998=>[95.749,-79.055,47.927,1],
73999=>[95.758,-79.051,47.884,1],
74000=>[95.766,-79.048,47.842,1],
74001=>[95.772,-79.044,47.800,1],
74002=>[95.779,-79.040,47.758,1],
74003=>[95.785,-79.037,47.715,1],
74004=>[95.792,-79.033,47.672,1],
74005=>[95.798,-79.030,47.630,1],
74006=>[95.805,-79.026,47.588,1],
74007=>[95.811,-79.022,47.547,1],
74008=>[95.817,-79.018,47.507,1],
74009=>[95.824,-79.015,47.466,1],
74010=>[95.830,-79.012,47.426,1],
74011=>[95.838,-79.009,47.386,1],
74012=>[95.877,-79.019,47.347,1],
74013=>[95.944,-79.037,47.306,1],
74014=>[96.017,-79.053,47.268,1],
74015=>[96.081,-79.055,47.230,1],
74016=>[96.120,-79.058,47.193,1],
74017=>[96.160,-79.060,47.157,1],
74018=>[96.198,-79.059,47.122,1],
74019=>[96.233,-79.046,47.086,1],
74020=>[96.267,-79.034,47.051,1],
74021=>[96.302,-79.021,47.016,1],
74022=>[96.336,-79.008,46.984,1],
74023=>[96.370,-78.995,46.953,1],
74024=>[96.399,-79.032,46.922,1],
74025=>[96.428,-79.078,46.891,1],
74026=>[96.446,-79.090,46.859,1],
74027=>[96.461,-79.091,46.827,1],
74028=>[96.476,-79.091,46.795,1],
74029=>[96.496,-79.099,46.763,1],
74030=>[96.520,-79.110,46.732,1],
74031=>[96.543,-79.122,46.699,1],
74032=>[96.567,-79.134,46.668,1],
74033=>[96.590,-79.146,46.637,1],
74034=>[96.614,-79.158,46.605,1],
74035=>[96.638,-79.169,46.575,1],
74036=>[96.654,-79.172,46.547,1],
74037=>[96.652,-79.156,46.519,1],
74038=>[96.650,-79.138,46.491,1],
74039=>[96.648,-79.122,46.463,1],
74040=>[96.646,-79.105,46.435,1],
74041=>[96.670,-79.100,46.408,1],
74042=>[96.707,-79.100,46.381,1],
74043=>[96.743,-79.101,46.355,1],
74044=>[96.780,-79.102,46.331,1],
74045=>[96.816,-79.103,46.307,1],
74046=>[96.863,-79.106,46.282,1],
74047=>[96.838,-79.157,46.258,1],
74048=>[96.813,-79.204,46.233,1],
74049=>[96.844,-79.175,46.210,1],
74050=>[96.879,-79.139,46.187,1],
74051=>[96.914,-79.103,46.162,1],
74052=>[96.950,-79.066,46.138,1],
74053=>[96.985,-79.030,46.114,1],
74054=>[97.025,-79.052,46.092,1],
74055=>[97.068,-79.096,46.070,1],
74056=>[97.105,-79.137,46.050,1],
74057=>[97.101,-79.138,46.031,1],
74058=>[97.097,-79.140,46.013,1],
74059=>[97.092,-79.140,45.993,1],
74060=>[97.060,-79.115,45.974,1],
74061=>[97.068,-79.181,45.954,1],
74062=>[97.064,-79.186,45.935,1],
74063=>[97.060,-79.190,45.917,1],
74064=>[97.060,-79.197,45.899,1],
74065=>[97.068,-79.172,45.881,1],
74066=>[97.084,-79.156,45.863,1],
74067=>[97.107,-79.134,45.844,1],
74068=>[97.130,-79.113,45.825,1],
74069=>[97.153,-79.092,45.807,1],
74070=>[97.174,-79.126,45.790,1],
74071=>[97.173,-79.229,45.774,1],
74072=>[97.225,-79.238,45.757,1],
74073=>[97.277,-79.247,45.740,1],
74074=>[97.233,-79.188,45.722,1],
74075=>[97.165,-79.149,45.705,1],
74076=>[97.193,-79.154,45.688,1],
74077=>[97.231,-79.153,45.671,1],
74078=>[97.267,-79.151,45.654,1],
74079=>[97.305,-79.150,45.638,1],
74080=>[97.342,-79.148,45.622,1],
74081=>[97.358,-79.163,45.606,1],
74082=>[97.372,-79.181,45.591,1],
74083=>[97.386,-79.197,45.575,1],
74084=>[97.365,-79.229,45.559,1],
74085=>[97.311,-79.274,45.545,1],
74086=>[97.307,-79.281,45.530,1],
74087=>[97.323,-79.275,45.515,1],
74088=>[97.338,-79.269,45.501,1],
74089=>[97.354,-79.262,45.486,1],
74090=>[97.364,-79.258,45.471,1],
74091=>[97.397,-79.269,45.457,1],
74092=>[97.425,-79.281,45.443,1],
74093=>[97.452,-79.293,45.429,1],
74094=>[97.461,-79.307,45.415,1],
74095=>[97.460,-79.318,45.401,1],
74096=>[97.454,-79.331,45.385,1],
74097=>[97.463,-79.338,45.371,1],
74098=>[97.477,-79.344,45.358,1],
74099=>[97.491,-79.350,45.345,1],
74100=>[97.508,-79.361,45.332,1],
74101=>[97.522,-79.369,45.319,1],
74102=>[97.526,-79.365,45.306,1],
74103=>[97.530,-79.360,45.294,1],
74104=>[97.534,-79.356,45.281,1],
74105=>[97.538,-79.351,45.268,1],
74106=>[97.542,-79.347,45.256,1],
74107=>[97.546,-79.343,45.243,1],
74108=>[97.550,-79.338,45.231,1],
74109=>[97.564,-79.362,45.219,1],
74110=>[97.579,-79.390,45.208,1],
74111=>[97.594,-79.417,45.197,1],
74112=>[97.608,-79.445,45.186,1],
74113=>[97.624,-79.473,45.174,1],
74114=>[97.639,-79.501,45.165,1],
74115=>[97.647,-79.513,45.154,1],
74116=>[97.658,-79.598,45.141,1],
74117=>[97.672,-79.648,45.129,1],
74118=>[97.684,-79.654,45.117,1],
74119=>[97.698,-79.662,45.106,1],
74120=>[97.710,-79.669,45.094,1],
74121=>[97.723,-79.676,45.082,1],
74122=>[97.736,-79.683,45.070,1],
74123=>[97.748,-79.691,45.058,1],
74124=>[97.761,-79.697,45.046,1],
74125=>[97.776,-79.698,45.034,1],
74126=>[97.790,-79.699,45.023,1],
74127=>[97.806,-79.712,45.013,1],
74128=>[97.823,-79.728,45.002,1],
74129=>[97.845,-79.742,44.991,1],
74130=>[97.868,-79.758,44.981,1],
74131=>[97.891,-79.772,44.972,1],
74132=>[97.915,-79.786,44.962,1],
74133=>[97.938,-79.801,44.954,1],
74134=>[97.961,-79.816,44.946,1],
74135=>[97.985,-79.830,44.938,1],
74136=>[98.011,-79.842,44.931,1],
74137=>[98.037,-79.855,44.925,1],
74138=>[98.064,-79.867,44.920,1],
74139=>[98.090,-79.879,44.914,1],
74140=>[98.113,-79.886,44.908,1],
74141=>[98.137,-79.894,44.901,1],
74142=>[98.160,-79.902,44.894,1],
74143=>[98.184,-79.911,44.887,1],
74144=>[98.208,-79.919,44.880,1],
74145=>[98.231,-79.927,44.872,1],
74146=>[98.256,-79.933,44.862,1],
74147=>[98.282,-79.939,44.852,1],
74148=>[98.307,-79.944,44.841,1],
74149=>[98.335,-79.951,44.832,1],
74150=>[98.373,-79.963,44.825,1],
74151=>[98.411,-79.974,44.820,1],
74152=>[98.449,-79.987,44.815,1],
74153=>[98.493,-79.997,44.809,1],
74154=>[98.534,-80.009,44.804,1],
74155=>[98.562,-80.024,44.797,1],
74156=>[98.591,-80.027,44.787,1],
74157=>[98.621,-80.030,44.776,1],
74158=>[98.650,-80.035,44.764,1],
74159=>[98.679,-80.040,44.756,1],
74160=>[98.708,-80.045,44.749,1],
74161=>[98.719,-80.060,44.742,1],
74162=>[98.731,-80.074,44.732,1],
74163=>[98.743,-80.090,44.721,1],
74164=>[98.755,-80.105,44.711,1],
74165=>[98.786,-80.108,44.700,1],
74166=>[98.821,-80.108,44.691,1],
74167=>[98.857,-80.107,44.682,1],
74168=>[98.882,-80.117,44.673,1],
74169=>[98.896,-80.118,44.664,1],
74170=>[98.905,-80.116,44.656,1],
74171=>[98.921,-80.121,44.649,1],
74172=>[98.936,-80.127,44.641,1],
74173=>[98.951,-80.136,44.634,1],
74174=>[98.968,-80.147,44.627,1],
74175=>[98.984,-80.158,44.620,1],
74176=>[99.001,-80.169,44.615,1],
74177=>[99.017,-80.181,44.610,1],
74178=>[99.075,-80.197,44.604,1],
74179=>[99.126,-80.221,44.599,1],
74180=>[99.149,-80.231,44.593,1],
74181=>[99.172,-80.242,44.587,1],
74182=>[99.196,-80.252,44.582,1],
74183=>[99.219,-80.262,44.579,1],
74184=>[99.242,-80.273,44.575,1],
74185=>[99.266,-80.284,44.570,1],
74186=>[99.289,-80.294,44.566,1],
74187=>[99.320,-80.302,44.562,1],
74188=>[99.358,-80.306,44.559,1],
74189=>[99.397,-80.309,44.555,1],
74190=>[99.435,-80.314,44.551,1],
74191=>[99.474,-80.318,44.548,1],
74192=>[99.512,-80.322,44.545,1],
74193=>[99.551,-80.325,44.541,1],
74194=>[99.557,-80.346,44.537,1],
74195=>[99.560,-80.368,44.532,1],
74196=>[99.563,-80.391,44.528,1],
74197=>[99.567,-80.413,44.523,1],
74198=>[99.570,-80.435,44.519,1],
74199=>[99.573,-80.457,44.513,1],
74200=>[99.576,-80.478,44.508,1],
74516=>[93.534,-78.928,53.494,1],
74517=>[93.543,-78.925,53.484,1],
74518=>[93.553,-78.923,53.474,1],
74519=>[93.563,-78.916,53.465,1],
74520=>[93.573,-78.907,53.456,1],
74521=>[93.582,-78.900,53.448,1],
74522=>[93.590,-78.893,53.439,1],
74523=>[93.599,-78.886,53.431,1],
74524=>[93.607,-78.880,53.423,1],
74525=>[93.615,-78.873,53.416,1],
74526=>[93.677,-78.842,53.410,1],
74527=>[93.736,-78.812,53.404,1],
74528=>[93.725,-78.809,53.400,1],
74529=>[93.714,-78.805,53.397,1],
74530=>[93.704,-78.802,53.394,1],
74531=>[93.693,-78.799,53.392,1],
74532=>[93.693,-78.804,53.388,1],
74533=>[93.706,-78.817,53.383,1],
74534=>[93.717,-78.824,53.376,1],
74535=>[93.724,-78.824,53.367,1],
74536=>[93.731,-78.821,53.358,1],
74537=>[93.738,-78.818,53.349,1],
74538=>[93.745,-78.816,53.338,1],
74539=>[93.752,-78.813,53.327,1],
74540=>[93.759,-78.810,53.314,1],
74541=>[93.766,-78.808,53.300,1],
74542=>[93.773,-78.805,53.288,1],
74543=>[93.780,-78.802,53.273,1],
74544=>[93.795,-78.794,53.258,1],
74545=>[93.809,-78.783,53.244,1],
74546=>[93.813,-78.774,53.225,1],
74547=>[93.826,-78.767,53.205,1],
74548=>[93.840,-78.758,53.184,1],
74549=>[93.854,-78.750,53.165,1],
74550=>[93.860,-78.745,53.143,1],
74551=>[93.865,-78.741,53.122,1],
74552=>[93.871,-78.736,53.101,1],
74553=>[93.876,-78.732,53.076,1],
74554=>[93.882,-78.727,53.051,1],
74555=>[93.887,-78.724,53.025,1],
74556=>[93.892,-78.719,53.000,1],
74557=>[93.898,-78.714,52.976,1],
74558=>[93.913,-78.708,52.951,1],
74559=>[93.929,-78.702,52.926,1],
74560=>[93.945,-78.695,52.898,1],
74561=>[93.961,-78.689,52.872,1],
74562=>[93.977,-78.683,52.848,1],
74563=>[93.993,-78.677,52.822,1],
74564=>[94.009,-78.670,52.798,1],
74565=>[94.025,-78.664,52.774,1],
74566=>[94.041,-78.658,52.752,1],
74567=>[94.056,-78.651,52.730,1],
74568=>[94.069,-78.648,52.708,1],
74569=>[94.079,-78.646,52.687,1],
74570=>[94.089,-78.645,52.665,1],
74571=>[94.091,-78.648,52.642,1],
74572=>[94.095,-78.655,52.620,1],
74573=>[94.099,-78.664,52.596,1],
74574=>[94.103,-78.671,52.572,1],
74575=>[94.107,-78.679,52.547,1],
74576=>[94.126,-78.647,52.522,1],
74577=>[94.158,-78.630,52.498,1],
74578=>[94.209,-78.643,52.474,1],
74579=>[94.261,-78.656,52.450,1],
74580=>[94.278,-78.656,52.427,1],
74581=>[94.288,-78.654,52.403,1],
74582=>[94.298,-78.651,52.378,1],
74583=>[94.308,-78.648,52.355,1],
74584=>[94.310,-78.652,52.332,1],
74585=>[94.302,-78.664,52.308,1],
74586=>[94.294,-78.676,52.285,1],
74587=>[94.295,-78.680,52.260,1],
74588=>[94.312,-78.667,52.233,1],
74589=>[94.326,-78.658,52.204,1],
74590=>[94.335,-78.655,52.178,1],
74591=>[94.343,-78.653,52.151,1],
74592=>[94.352,-78.651,52.125,1],
74593=>[94.360,-78.648,52.098,1],
74594=>[94.369,-78.646,52.072,1],
74595=>[94.378,-78.644,52.045,1],
74596=>[94.387,-78.642,52.017,1],
74597=>[94.400,-78.642,51.987,1],
74598=>[94.415,-78.644,51.957,1],
74599=>[94.425,-78.649,51.925,1],
74600=>[94.436,-78.655,51.892,1],
74601=>[94.447,-78.660,51.859,1],
74602=>[94.458,-78.665,51.829,1],
74603=>[94.468,-78.672,51.799,1],
74604=>[94.482,-78.683,51.767,1],
74605=>[94.497,-78.683,51.733,1],
74606=>[94.511,-78.683,51.696,1],
74607=>[94.527,-78.682,51.658,1],
74608=>[94.542,-78.681,51.619,1],
74609=>[94.557,-78.680,51.580,1],
74610=>[94.574,-78.682,51.542,1],
74611=>[94.592,-78.684,51.506,1],
74612=>[94.610,-78.686,51.472,1],
74613=>[94.628,-78.688,51.439,1],
74614=>[94.646,-78.690,51.406,1],
74615=>[94.665,-78.692,51.376,1],
74616=>[94.683,-78.695,51.345,1],
74617=>[94.699,-78.697,51.314,1],
74618=>[94.710,-78.699,51.282,1],
74619=>[94.720,-78.702,51.249,1],
74620=>[94.732,-78.704,51.214,1],
74621=>[94.742,-78.706,51.177,1],
74622=>[94.751,-78.704,51.136,1],
74623=>[94.757,-78.693,51.095,1],
74624=>[94.760,-78.702,51.053,1],
74625=>[94.764,-78.710,51.012,1],
74626=>[94.767,-78.718,50.971,1],
74627=>[94.771,-78.727,50.930,1],
74628=>[94.774,-78.736,50.892,1],
74629=>[94.773,-78.744,50.850,1],
74630=>[94.783,-78.735,50.807,1],
74631=>[94.792,-78.727,50.762,1],
74632=>[94.801,-78.717,50.718,1],
74633=>[94.810,-78.709,50.676,1],
74634=>[94.819,-78.701,50.636,1],
74635=>[94.829,-78.693,50.596,1],
74636=>[94.847,-78.690,50.552,1],
74637=>[94.865,-78.686,50.508,1],
74638=>[94.877,-78.690,50.463,1],
74639=>[94.876,-78.705,50.419,1],
74640=>[94.875,-78.720,50.375,1],
74641=>[94.874,-78.736,50.332,1],
74642=>[94.873,-78.752,50.292,1],
74643=>[94.871,-78.767,50.253,1],
74644=>[94.870,-78.783,50.214,1],
74645=>[94.868,-78.798,50.177,1],
74646=>[94.867,-78.814,50.138,1],
74647=>[94.866,-78.829,50.099,1],
74648=>[94.865,-78.845,50.059,1],
74649=>[94.862,-78.855,50.019,1],
74650=>[94.860,-78.856,49.980,1],
74651=>[94.877,-78.859,49.941,1],
74652=>[94.895,-78.861,49.902,1],
74653=>[94.923,-78.856,49.863,1],
74654=>[94.952,-78.852,49.824,1],
74655=>[94.981,-78.847,49.786,1],
74656=>[95.010,-78.843,49.749,1],
74657=>[95.038,-78.838,49.710,1],
74658=>[95.067,-78.833,49.670,1],
74659=>[95.096,-78.829,49.629,1],
74660=>[95.124,-78.824,49.588,1],
74661=>[95.154,-78.826,49.548,1],
74662=>[95.183,-78.831,49.509,1],
74663=>[95.212,-78.837,49.469,1],
74664=>[95.242,-78.843,49.430,1],
74665=>[95.271,-78.849,49.389,1],
74666=>[95.300,-78.854,49.349,1],
74667=>[95.329,-78.860,49.307,1],
74668=>[95.350,-78.871,49.266,1],
74669=>[95.370,-78.882,49.224,1],
74670=>[95.390,-78.894,49.186,1],
74671=>[95.407,-78.902,49.148,1],
74672=>[95.421,-78.899,49.108,1],
74673=>[95.435,-78.897,49.067,1],
74674=>[95.449,-78.896,49.026,1],
74675=>[95.457,-78.902,48.984,1],
74676=>[95.466,-78.907,48.941,1],
74677=>[95.474,-78.913,48.900,1],
74678=>[95.482,-78.919,48.858,1],
74679=>[95.491,-78.925,48.816,1],
74680=>[95.495,-78.945,48.775,1],
74681=>[95.500,-78.965,48.734,1],
74682=>[95.505,-78.985,48.692,1],
74683=>[95.510,-79.005,48.651,1],
74684=>[95.514,-79.025,48.612,1],
74685=>[95.526,-79.040,48.571,1],
74686=>[95.541,-79.053,48.529,1],
74687=>[95.556,-79.067,48.484,1],
74688=>[95.571,-79.080,48.439,1],
74689=>[95.587,-79.093,48.393,1],
74690=>[95.602,-79.106,48.346,1],
74691=>[95.617,-79.120,48.298,1],
74692=>[95.636,-79.120,48.251,1],
74693=>[95.659,-79.107,48.204,1],
74694=>[95.681,-79.093,48.158,1],
74695=>[95.703,-79.081,48.111,1],
74696=>[95.726,-79.068,48.065,1],
74697=>[95.739,-79.061,48.020,1],
74698=>[95.748,-79.057,47.977,1],
74699=>[95.757,-79.053,47.934,1],
74700=>[95.766,-79.049,47.891,1],
74701=>[95.775,-79.046,47.849,1],
74702=>[95.782,-79.042,47.806,1],
74703=>[95.789,-79.038,47.763,1],
74704=>[95.795,-79.035,47.720,1],
74705=>[95.801,-79.031,47.677,1],
74706=>[95.808,-79.028,47.635,1],
74707=>[95.814,-79.024,47.594,1],
74708=>[95.821,-79.021,47.553,1],
74709=>[95.827,-79.017,47.512,1],
74710=>[95.833,-79.013,47.472,1],
74711=>[95.840,-79.009,47.431,1],
74712=>[95.851,-79.006,47.391,1],
74713=>[95.888,-79.002,47.351,1],
74714=>[95.946,-79.014,47.310,1],
74715=>[96.012,-79.031,47.272,1],
74716=>[96.083,-79.037,47.234,1],
74717=>[96.123,-79.040,47.197,1],
74718=>[96.163,-79.042,47.161,1],
74719=>[96.202,-79.045,47.125,1],
74720=>[96.241,-79.045,47.090,1],
74721=>[96.275,-79.032,47.054,1],
74722=>[96.310,-79.019,47.020,1],
74723=>[96.344,-79.006,46.988,1],
74724=>[96.378,-78.993,46.957,1],
74725=>[96.407,-79.031,46.927,1],
74726=>[96.434,-79.069,46.896,1],
74727=>[96.448,-79.070,46.864,1],
74728=>[96.463,-79.070,46.832,1],
74729=>[96.484,-79.078,46.799,1],
74730=>[96.508,-79.090,46.767,1],
74731=>[96.531,-79.102,46.736,1],
74732=>[96.554,-79.114,46.703,1],
74733=>[96.578,-79.125,46.672,1],
74734=>[96.602,-79.137,46.641,1],
74735=>[96.625,-79.149,46.609,1],
74736=>[96.649,-79.161,46.580,1],
74737=>[96.673,-79.172,46.551,1],
74738=>[96.672,-79.157,46.524,1],
74739=>[96.671,-79.140,46.495,1],
74740=>[96.669,-79.123,46.467,1],
74741=>[96.667,-79.106,46.439,1],
74742=>[96.665,-79.090,46.411,1],
74743=>[96.679,-79.080,46.384,1],
74744=>[96.716,-79.081,46.358,1],
74745=>[96.768,-79.085,46.334,1],
74746=>[96.827,-79.090,46.310,1],
74747=>[96.885,-79.095,46.285,1],
74748=>[96.832,-79.167,46.261,1],
74749=>[96.814,-79.175,46.236,1],
74750=>[96.849,-79.138,46.213,1],
74751=>[96.884,-79.103,46.189,1],
74752=>[96.920,-79.066,46.165,1],
74753=>[96.955,-79.030,46.141,1],
74754=>[96.991,-79.001,46.119,1],
74755=>[97.033,-79.046,46.097,1],
74756=>[97.075,-79.091,46.076,1],
74757=>[97.108,-79.128,46.056,1],
74758=>[97.104,-79.128,46.038,1],
74759=>[97.085,-79.115,46.020,1],
74760=>[97.050,-79.087,46.001,1],
74761=>[97.020,-79.062,45.981,1],
74762=>[97.058,-79.201,45.961,1],
74763=>[97.054,-79.206,45.942,1],
74764=>[97.050,-79.210,45.924,1],
74765=>[97.049,-79.194,45.906,1],
74766=>[97.049,-79.171,45.889,1],
74767=>[97.065,-79.150,45.871,1],
74768=>[97.066,-79.140,45.853,1],
74769=>[97.076,-79.130,45.834,1],
74770=>[97.087,-79.118,45.816,1],
74771=>[97.097,-79.107,45.799,1],
74772=>[97.119,-79.096,45.783,1],
74773=>[97.169,-79.121,45.767,1],
74774=>[97.219,-79.146,45.749,1],
74775=>[97.268,-79.171,45.732,1],
74776=>[97.221,-79.158,45.715,1],
74777=>[97.187,-79.158,45.697,1],
74778=>[97.221,-79.157,45.680,1],
74779=>[97.258,-79.156,45.664,1],
74780=>[97.295,-79.154,45.647,1],
74781=>[97.332,-79.153,45.631,1],
74782=>[97.369,-79.151,45.615,1],
74783=>[97.389,-79.163,45.599,1],
74784=>[97.403,-79.180,45.583,1],
74785=>[97.355,-79.222,45.568,1],
74786=>[97.301,-79.268,45.554,1],
74787=>[97.311,-79.265,45.539,1],
74788=>[97.327,-79.259,45.525,1],
74789=>[97.331,-79.256,45.510,1],
74790=>[97.330,-79.258,45.495,1],
74791=>[97.354,-79.259,45.480,1],
74792=>[97.394,-79.263,45.466,1],
74793=>[97.412,-79.279,45.452,1],
74794=>[97.424,-79.300,45.439,1],
74795=>[97.423,-79.311,45.424,1],
74796=>[97.436,-79.317,45.410,1],
74797=>[97.450,-79.322,45.395,1],
74798=>[97.463,-79.328,45.380,1],
74799=>[97.477,-79.334,45.367,1],
74800=>[97.491,-79.340,45.354,1],
74801=>[97.506,-79.348,45.341,1],
74802=>[97.524,-79.362,45.328,1],
74803=>[97.543,-79.376,45.315,1],
74804=>[97.552,-79.378,45.303,1],
74805=>[97.557,-79.373,45.290,1],
74806=>[97.561,-79.369,45.277,1],
74807=>[97.565,-79.365,45.264,1],
74808=>[97.569,-79.360,45.252,1],
74809=>[97.573,-79.356,45.241,1],
74810=>[97.587,-79.382,45.229,1],
74811=>[97.602,-79.410,45.217,1],
74812=>[97.617,-79.438,45.206,1],
74813=>[97.632,-79.465,45.196,1],
74814=>[97.645,-79.488,45.185,1],
74815=>[97.651,-79.494,45.175,1],
74816=>[97.657,-79.499,45.165,1],
74817=>[97.668,-79.578,45.154,1],
74818=>[97.683,-79.623,45.142,1],
74819=>[97.696,-79.630,45.130,1],
74820=>[97.709,-79.638,45.119,1],
74821=>[97.721,-79.645,45.108,1],
74822=>[97.734,-79.651,45.096,1],
74823=>[97.747,-79.659,45.085,1],
74824=>[97.759,-79.666,45.073,1],
74825=>[97.773,-79.673,45.061,1],
74826=>[97.785,-79.680,45.049,1],
74827=>[97.798,-79.688,45.037,1],
74828=>[97.811,-79.697,45.026,1],
74829=>[97.828,-79.709,45.016,1],
74830=>[97.850,-79.723,45.006,1],
74831=>[97.872,-79.738,44.997,1],
74832=>[97.894,-79.753,44.987,1],
74833=>[97.916,-79.768,44.978,1],
74834=>[97.941,-79.789,44.970,1],
74835=>[97.975,-79.818,44.962,1],
74836=>[98.004,-79.833,44.956,1],
74837=>[98.032,-79.849,44.949,1],
74838=>[98.058,-79.856,44.943,1],
74839=>[98.078,-79.852,44.938,1],
74840=>[98.099,-79.853,44.933,1],
74841=>[98.123,-79.863,44.928,1],
74842=>[98.146,-79.873,44.921,1],
74843=>[98.169,-79.882,44.913,1],
74844=>[98.193,-79.889,44.905,1],
74845=>[98.218,-79.896,44.897,1],
74846=>[98.243,-79.902,44.887,1],
74847=>[98.269,-79.908,44.876,1],
74848=>[98.294,-79.913,44.865,1],
74849=>[98.319,-79.919,44.852,1],
74850=>[98.346,-79.926,44.845,1],
74851=>[98.384,-79.937,44.839,1],
74852=>[98.422,-79.949,44.835,1],
74853=>[98.459,-79.961,44.831,1],
74854=>[98.497,-79.972,44.824,1],
74855=>[98.535,-79.984,44.816,1],
74856=>[98.568,-79.992,44.808,1],
74857=>[98.598,-79.996,44.797,1],
74858=>[98.627,-80.002,44.784,1],
74859=>[98.656,-80.006,44.771,1],
74860=>[98.686,-80.011,44.761,1],
74861=>[98.704,-80.021,44.752,1],
74862=>[98.716,-80.037,44.745,1],
74863=>[98.727,-80.052,44.737,1],
74864=>[98.743,-80.065,44.727,1],
74865=>[98.769,-80.073,44.717,1],
74866=>[98.799,-80.077,44.708,1],
74867=>[98.834,-80.077,44.700,1],
74868=>[98.866,-80.080,44.691,1],
74869=>[98.887,-80.089,44.683,1],
74870=>[98.910,-80.099,44.674,1],
74871=>[98.921,-80.098,44.666,1],
74872=>[98.937,-80.102,44.659,1],
74873=>[98.953,-80.108,44.652,1],
74874=>[98.969,-80.112,44.645,1],
74875=>[98.984,-80.120,44.638,1],
74876=>[98.999,-80.128,44.632,1],
74877=>[99.013,-80.137,44.626,1],
74878=>[99.030,-80.148,44.620,1],
74879=>[99.047,-80.159,44.615,1],
74880=>[99.073,-80.167,44.610,1],
74881=>[99.153,-80.204,44.605,1],
74882=>[99.177,-80.215,44.599,1],
74883=>[99.200,-80.225,44.593,1],
74884=>[99.223,-80.235,44.589,1],
74885=>[99.246,-80.246,44.585,1],
74886=>[99.270,-80.256,44.580,1],
74887=>[99.293,-80.267,44.577,1],
74888=>[99.330,-80.272,44.573,1],
74889=>[99.369,-80.275,44.569,1],
74890=>[99.407,-80.279,44.565,1],
74891=>[99.446,-80.284,44.562,1],
74892=>[99.485,-80.287,44.558,1],
74893=>[99.523,-80.291,44.555,1],
74894=>[99.550,-80.301,44.550,1],
74895=>[99.554,-80.323,44.546,1],
74896=>[99.557,-80.345,44.541,1],
74897=>[99.560,-80.367,44.536,1],
74898=>[99.563,-80.390,44.531,1],
74899=>[99.566,-80.412,44.526,1],
74900=>[99.570,-80.434,44.522,1],
74901=>[99.573,-80.456,44.516,1],
74902=>[99.576,-80.478,44.510,1],
75218=>[93.544,-78.915,53.497,1],
75219=>[93.553,-78.912,53.488,1],
75220=>[93.563,-78.910,53.478,1],
75221=>[93.574,-78.902,53.469,1],
75222=>[93.583,-78.894,53.461,1],
75223=>[93.591,-78.886,53.452,1],
75224=>[93.600,-78.880,53.443,1],
75225=>[93.608,-78.873,53.437,1],
75226=>[93.616,-78.866,53.429,1],
75227=>[93.664,-78.842,53.423,1],
75228=>[93.725,-78.810,53.417,1],
75229=>[93.723,-78.808,53.414,1],
75230=>[93.714,-78.805,53.412,1],
75231=>[93.703,-78.802,53.410,1],
75232=>[93.692,-78.799,53.407,1],
75233=>[93.692,-78.803,53.404,1],
75234=>[93.705,-78.816,53.398,1],
75235=>[93.713,-78.817,53.391,1],
75236=>[93.720,-78.816,53.382,1],
75237=>[93.727,-78.814,53.373,1],
75238=>[93.734,-78.811,53.363,1],
75239=>[93.741,-78.808,53.352,1],
75240=>[93.748,-78.805,53.341,1],
75241=>[93.755,-78.803,53.327,1],
75242=>[93.762,-78.800,53.314,1],
75243=>[93.769,-78.797,53.301,1],
75244=>[93.781,-78.791,53.286,1],
75245=>[93.806,-78.777,53.270,1],
75246=>[93.810,-78.768,53.254,1],
75247=>[93.814,-78.760,53.235,1],
75248=>[93.825,-78.752,53.214,1],
75249=>[93.839,-78.744,53.193,1],
75250=>[93.853,-78.736,53.172,1],
75251=>[93.867,-78.728,53.151,1],
75252=>[93.878,-78.721,53.130,1],
75253=>[93.884,-78.717,53.109,1],
75254=>[93.889,-78.712,53.085,1],
75255=>[93.894,-78.708,53.060,1],
75256=>[93.899,-78.703,53.034,1],
75257=>[93.905,-78.698,53.009,1],
75258=>[93.913,-78.694,52.984,1],
75259=>[93.929,-78.687,52.958,1],
75260=>[93.944,-78.681,52.933,1],
75261=>[93.961,-78.675,52.907,1],
75262=>[93.976,-78.669,52.881,1],
75263=>[93.992,-78.662,52.855,1],
75264=>[94.008,-78.656,52.831,1],
75265=>[94.024,-78.650,52.808,1],
75266=>[94.039,-78.645,52.787,1],
75267=>[94.048,-78.643,52.765,1],
75268=>[94.058,-78.642,52.743,1],
75269=>[94.068,-78.639,52.721,1],
75270=>[94.078,-78.638,52.700,1],
75271=>[94.088,-78.636,52.677,1],
75272=>[94.088,-78.642,52.654,1],
75273=>[94.088,-78.649,52.631,1],
75274=>[94.092,-78.657,52.608,1],
75275=>[94.097,-78.664,52.583,1],
75276=>[94.117,-78.629,52.558,1],
75277=>[94.142,-78.601,52.533,1],
75278=>[94.194,-78.614,52.509,1],
75279=>[94.246,-78.628,52.486,1],
75280=>[94.291,-78.639,52.463,1],
75281=>[94.301,-78.636,52.440,1],
75282=>[94.311,-78.633,52.417,1],
75283=>[94.321,-78.631,52.393,1],
75284=>[94.324,-78.634,52.371,1],
75285=>[94.316,-78.646,52.349,1],
75286=>[94.309,-78.658,52.326,1],
75287=>[94.300,-78.670,52.302,1],
75288=>[94.297,-78.677,52.278,1],
75289=>[94.314,-78.665,52.251,1],
75290=>[94.330,-78.653,52.224,1],
75291=>[94.344,-78.644,52.197,1],
75292=>[94.352,-78.642,52.172,1],
75293=>[94.361,-78.639,52.145,1],
75294=>[94.370,-78.637,52.117,1],
75295=>[94.379,-78.636,52.091,1],
75296=>[94.387,-78.633,52.064,1],
75297=>[94.396,-78.631,52.036,1],
75298=>[94.410,-78.630,52.005,1],
75299=>[94.427,-78.631,51.974,1],
75300=>[94.438,-78.636,51.942,1],
75301=>[94.449,-78.642,51.909,1],
75302=>[94.459,-78.647,51.876,1],
75303=>[94.470,-78.651,51.846,1],
75304=>[94.480,-78.675,51.815,1],
75305=>[94.493,-78.688,51.781,1],
75306=>[94.508,-78.687,51.746,1],
75307=>[94.524,-78.686,51.710,1],
75308=>[94.539,-78.686,51.672,1],
75309=>[94.553,-78.686,51.632,1],
75310=>[94.568,-78.685,51.593,1],
75311=>[94.583,-78.684,51.555,1],
75312=>[94.599,-78.683,51.519,1],
75313=>[94.614,-78.683,51.484,1],
75314=>[94.629,-78.682,51.452,1],
75315=>[94.643,-78.681,51.420,1],
75316=>[94.659,-78.680,51.390,1],
75317=>[94.674,-78.680,51.361,1],
75318=>[94.686,-78.679,51.331,1],
75319=>[94.697,-78.681,51.297,1],
75320=>[94.708,-78.683,51.262,1],
75321=>[94.718,-78.686,51.226,1],
75322=>[94.730,-78.688,51.189,1],
75323=>[94.740,-78.690,51.149,1],
75324=>[94.748,-78.695,51.109,1],
75325=>[94.754,-78.703,51.067,1],
75326=>[94.760,-78.711,51.026,1],
75327=>[94.765,-78.718,50.984,1],
75328=>[94.771,-78.726,50.942,1],
75329=>[94.776,-78.733,50.903,1],
75330=>[94.783,-78.733,50.862,1],
75331=>[94.791,-78.724,50.819,1],
75332=>[94.799,-78.720,50.774,1],
75333=>[94.807,-78.711,50.730,1],
75334=>[94.816,-78.703,50.689,1],
75335=>[94.825,-78.695,50.649,1],
75336=>[94.834,-78.686,50.608,1],
75337=>[94.845,-78.679,50.564,1],
75338=>[94.863,-78.676,50.519,1],
75339=>[94.876,-78.678,50.474,1],
75340=>[94.875,-78.694,50.429,1],
75341=>[94.874,-78.709,50.385,1],
75342=>[94.872,-78.724,50.342,1],
75343=>[94.871,-78.740,50.302,1],
75344=>[94.870,-78.755,50.261,1],
75345=>[94.868,-78.771,50.221,1],
75346=>[94.867,-78.786,50.183,1],
75347=>[94.866,-78.802,50.144,1],
75348=>[94.865,-78.818,50.105,1],
75349=>[94.864,-78.833,50.064,1],
75350=>[94.862,-78.849,50.023,1],
75351=>[94.861,-78.858,49.984,1],
75352=>[94.883,-78.858,49.945,1],
75353=>[94.912,-78.852,49.905,1],
75354=>[94.941,-78.848,49.863,1],
75355=>[94.969,-78.843,49.823,1],
75356=>[94.998,-78.839,49.784,1],
75357=>[95.027,-78.834,49.747,1],
75358=>[95.055,-78.830,49.707,1],
75359=>[95.084,-78.825,49.666,1],
75360=>[95.113,-78.821,49.625,1],
75361=>[95.141,-78.816,49.585,1],
75362=>[95.170,-78.811,49.545,1],
75363=>[95.200,-78.817,49.504,1],
75364=>[95.229,-78.822,49.466,1],
75365=>[95.258,-78.828,49.426,1],
75366=>[95.287,-78.833,49.386,1],
75367=>[95.312,-78.843,49.346,1],
75368=>[95.331,-78.854,49.304,1],
75369=>[95.351,-78.866,49.263,1],
75370=>[95.370,-78.877,49.221,1],
75371=>[95.390,-78.890,49.183,1],
75372=>[95.408,-78.898,49.144,1],
75373=>[95.422,-78.896,49.104,1],
75374=>[95.436,-78.893,49.064,1],
75375=>[95.450,-78.891,49.023,1],
75376=>[95.464,-78.888,48.982,1],
75377=>[95.474,-78.890,48.941,1],
75378=>[95.483,-78.896,48.899,1],
75379=>[95.491,-78.902,48.858,1],
75380=>[95.500,-78.908,48.817,1],
75381=>[95.506,-78.923,48.776,1],
75382=>[95.511,-78.943,48.734,1],
75383=>[95.515,-78.963,48.694,1],
75384=>[95.520,-78.984,48.655,1],
75385=>[95.531,-78.999,48.615,1],
75386=>[95.546,-79.012,48.576,1],
75387=>[95.562,-79.025,48.535,1],
75388=>[95.577,-79.039,48.490,1],
75389=>[95.592,-79.052,48.444,1],
75390=>[95.607,-79.065,48.397,1],
75391=>[95.622,-79.078,48.350,1],
75392=>[95.637,-79.092,48.303,1],
75393=>[95.653,-79.105,48.256,1],
75394=>[95.673,-79.100,48.209,1],
75395=>[95.695,-79.087,48.161,1],
75396=>[95.718,-79.074,48.115,1],
75397=>[95.737,-79.062,48.070,1],
75398=>[95.746,-79.059,48.026,1],
75399=>[95.755,-79.055,47.984,1],
75400=>[95.765,-79.051,47.942,1],
75401=>[95.774,-79.047,47.899,1],
75402=>[95.783,-79.044,47.856,1],
75403=>[95.792,-79.040,47.812,1],
75404=>[95.798,-79.037,47.768,1],
75405=>[95.805,-79.033,47.726,1],
75406=>[95.811,-79.029,47.683,1],
75407=>[95.817,-79.025,47.641,1],
75408=>[95.824,-79.022,47.599,1],
75409=>[95.830,-79.018,47.558,1],
75410=>[95.836,-79.015,47.518,1],
75411=>[95.843,-79.011,47.478,1],
75412=>[95.849,-79.008,47.437,1],
75413=>[95.882,-79.004,47.396,1],
75414=>[95.918,-78.999,47.355,1],
75415=>[95.955,-78.996,47.316,1],
75416=>[96.014,-79.008,47.277,1],
75417=>[96.085,-79.018,47.239,1],
75418=>[96.125,-79.021,47.201,1],
75419=>[96.165,-79.024,47.165,1],
75420=>[96.204,-79.027,47.129,1],
75421=>[96.244,-79.030,47.094,1],
75422=>[96.284,-79.031,47.059,1],
75423=>[96.318,-79.018,47.025,1],
75424=>[96.352,-79.005,46.992,1],
75425=>[96.386,-78.992,46.962,1],
75426=>[96.415,-79.031,46.932,1],
75427=>[96.435,-79.049,46.901,1],
75428=>[96.450,-79.049,46.870,1],
75429=>[96.471,-79.058,46.839,1],
75430=>[96.495,-79.070,46.805,1],
75431=>[96.519,-79.082,46.772,1],
75432=>[96.542,-79.093,46.741,1],
75433=>[96.566,-79.106,46.709,1],
75434=>[96.590,-79.117,46.678,1],
75435=>[96.613,-79.129,46.647,1],
75436=>[96.637,-79.140,46.615,1],
75437=>[96.661,-79.153,46.585,1],
75438=>[96.684,-79.164,46.557,1],
75439=>[96.693,-79.159,46.529,1],
75440=>[96.691,-79.142,46.499,1],
75441=>[96.689,-79.125,46.471,1],
75442=>[96.687,-79.109,46.443,1],
75443=>[96.688,-79.090,46.415,1],
75444=>[96.690,-79.071,46.388,1],
75445=>[96.751,-79.039,46.362,1],
75446=>[96.791,-79.075,46.336,1],
75447=>[96.849,-79.080,46.312,1],
75448=>[96.908,-79.085,46.288,1],
75449=>[96.876,-79.131,46.264,1],
75450=>[96.853,-79.125,46.240,1],
75451=>[96.876,-79.093,46.216,1],
75452=>[96.900,-79.062,46.192,1],
75453=>[96.925,-79.030,46.168,1],
75454=>[96.960,-78.993,46.146,1],
75455=>[96.999,-78.996,46.124,1],
75456=>[97.041,-79.041,46.102,1],
75457=>[97.083,-79.086,46.083,1],
75458=>[97.110,-79.117,46.064,1],
75459=>[97.075,-79.088,46.045,1],
75460=>[97.040,-79.060,46.028,1],
75461=>[97.005,-79.032,46.009,1],
75462=>[97.011,-79.048,45.989,1],
75463=>[97.049,-79.222,45.969,1],
75464=>[97.045,-79.226,45.950,1],
75465=>[97.043,-79.211,45.932,1],
75466=>[97.044,-79.191,45.915,1],
75467=>[97.050,-79.182,45.898,1],
75468=>[97.058,-79.172,45.881,1],
75469=>[97.069,-79.161,45.864,1],
75470=>[97.080,-79.150,45.848,1],
75471=>[97.091,-79.138,45.830,1],
75472=>[97.100,-79.124,45.814,1],
75473=>[97.104,-79.101,45.798,1],
75474=>[97.124,-79.086,45.781,1],
75475=>[97.162,-79.079,45.763,1],
75476=>[97.207,-79.092,45.745,1],
75477=>[97.224,-79.104,45.727,1],
75478=>[97.214,-79.122,45.708,1],
75479=>[97.231,-79.159,45.690,1],
75480=>[97.262,-79.162,45.674,1],
75481=>[97.296,-79.159,45.657,1],
75482=>[97.329,-79.158,45.640,1],
75483=>[97.363,-79.156,45.624,1],
75484=>[97.397,-79.153,45.609,1],
75485=>[97.399,-79.172,45.593,1],
75486=>[97.345,-79.216,45.578,1],
75487=>[97.300,-79.255,45.564,1],
75488=>[97.309,-79.255,45.550,1],
75489=>[97.320,-79.255,45.536,1],
75490=>[97.331,-79.256,45.522,1],
75491=>[97.343,-79.256,45.507,1],
75492=>[97.373,-79.259,45.493,1],
75493=>[97.404,-79.266,45.478,1],
75494=>[97.402,-79.291,45.465,1],
75495=>[97.410,-79.297,45.451,1],
75496=>[97.423,-79.301,45.436,1],
75497=>[97.436,-79.307,45.422,1],
75498=>[97.450,-79.313,45.407,1],
75499=>[97.463,-79.319,45.393,1],
75500=>[97.477,-79.324,45.379,1],
75501=>[97.490,-79.330,45.366,1],
75502=>[97.504,-79.335,45.353,1],
75503=>[97.522,-79.349,45.340,1],
75504=>[97.541,-79.363,45.327,1],
75505=>[97.560,-79.377,45.314,1],
75506=>[97.579,-79.391,45.301,1],
75507=>[97.583,-79.387,45.288,1],
75508=>[97.587,-79.382,45.275,1],
75509=>[97.591,-79.378,45.263,1],
75510=>[97.595,-79.375,45.251,1],
75511=>[97.610,-79.402,45.240,1],
75512=>[97.626,-79.430,45.228,1],
75513=>[97.640,-79.457,45.217,1],
75514=>[97.649,-79.469,45.207,1],
75515=>[97.655,-79.474,45.197,1],
75516=>[97.661,-79.479,45.187,1],
75517=>[97.667,-79.485,45.178,1],
75518=>[97.677,-79.557,45.168,1],
75519=>[97.693,-79.589,45.157,1],
75520=>[97.707,-79.606,45.145,1],
75521=>[97.720,-79.613,45.134,1],
75522=>[97.733,-79.620,45.123,1],
75523=>[97.745,-79.627,45.111,1],
75524=>[97.758,-79.635,45.100,1],
75525=>[97.771,-79.642,45.088,1],
75526=>[97.784,-79.649,45.076,1],
75527=>[97.796,-79.656,45.064,1],
75528=>[97.810,-79.666,45.052,1],
75529=>[97.825,-79.677,45.040,1],
75530=>[97.841,-79.689,45.031,1],
75531=>[97.862,-79.702,45.022,1],
75532=>[97.883,-79.717,45.013,1],
75533=>[97.906,-79.732,45.004,1],
75534=>[97.927,-79.746,44.995,1],
75535=>[97.964,-79.786,44.987,1],
75536=>[98.003,-79.831,44.980,1],
75537=>[98.027,-79.835,44.974,1],
75538=>[98.047,-79.831,44.967,1],
75539=>[98.068,-79.827,44.959,1],
75540=>[98.088,-79.823,44.952,1],
75541=>[98.110,-79.828,44.948,1],
75542=>[98.133,-79.838,44.944,1],
75543=>[98.157,-79.848,44.939,1],
75544=>[98.180,-79.860,44.932,1],
75545=>[98.205,-79.866,44.923,1],
75546=>[98.230,-79.871,44.912,1],
75547=>[98.255,-79.877,44.902,1],
75548=>[98.281,-79.883,44.889,1],
75549=>[98.306,-79.888,44.875,1],
75550=>[98.331,-79.894,44.862,1],
75551=>[98.357,-79.900,44.853,1],
75552=>[98.395,-79.911,44.847,1],
75553=>[98.433,-79.924,44.842,1],
75554=>[98.471,-79.935,44.836,1],
75555=>[98.508,-79.947,44.830,1],
75556=>[98.542,-79.956,44.821,1],
75557=>[98.574,-79.963,44.812,1],
75558=>[98.603,-79.968,44.801,1],
75559=>[98.633,-79.973,44.790,1],
75560=>[98.662,-79.977,44.778,1],
75561=>[98.689,-79.983,44.768,1],
75562=>[98.701,-79.999,44.759,1],
75563=>[98.712,-80.014,44.752,1],
75564=>[98.733,-80.024,44.745,1],
75565=>[98.759,-80.033,44.736,1],
75566=>[98.784,-80.041,44.726,1],
75567=>[98.812,-80.047,44.718,1],
75568=>[98.847,-80.047,44.709,1],
75569=>[98.874,-80.053,44.701,1],
75570=>[98.895,-80.062,44.692,1],
75571=>[98.916,-80.072,44.684,1],
75572=>[98.938,-80.082,44.677,1],
75573=>[98.952,-80.085,44.669,1],
75574=>[98.969,-80.090,44.663,1],
75575=>[98.985,-80.094,44.657,1],
75576=>[99.001,-80.099,44.650,1],
75577=>[99.017,-80.104,44.643,1],
75578=>[99.031,-80.112,44.638,1],
75579=>[99.046,-80.121,44.632,1],
75580=>[99.061,-80.129,44.627,1],
75581=>[99.076,-80.138,44.622,1],
75582=>[99.092,-80.149,44.616,1],
75583=>[99.156,-80.176,44.611,1],
75584=>[99.204,-80.198,44.605,1],
75585=>[99.227,-80.208,44.601,1],
75586=>[99.251,-80.218,44.596,1],
75587=>[99.274,-80.229,44.591,1],
75588=>[99.302,-80.237,44.588,1],
75589=>[99.341,-80.241,44.584,1],
75590=>[99.379,-80.245,44.580,1],
75591=>[99.418,-80.250,44.576,1],
75592=>[99.457,-80.253,44.573,1],
75593=>[99.495,-80.257,44.569,1],
75594=>[99.534,-80.261,44.564,1],
75595=>[99.547,-80.278,44.560,1],
75596=>[99.550,-80.300,44.556,1],
75597=>[99.553,-80.322,44.551,1],
75598=>[99.556,-80.344,44.546,1],
75599=>[99.560,-80.367,44.541,1],
75600=>[99.563,-80.389,44.535,1],
75601=>[99.566,-80.411,44.530,1],
75602=>[99.569,-80.433,44.524,1],
75603=>[99.572,-80.455,44.518,1],
75604=>[99.576,-80.478,44.512,1],
75605=>[99.579,-80.500,44.505,1],
75606=>[99.582,-80.522,44.498,1],
75607=>[99.585,-80.544,44.491,1],
75608=>[99.588,-80.566,44.483,1],
75609=>[99.592,-80.588,44.476,1],
75610=>[99.595,-80.610,44.468,1],
75611=>[99.598,-80.632,44.460,1],
75612=>[99.602,-80.654,44.452,1],
75613=>[99.605,-80.677,44.443,1],
75614=>[99.608,-80.699,44.434,1],
75615=>[99.611,-80.721,44.426,1],
75616=>[99.615,-80.743,44.416,1],
75617=>[99.632,-80.760,44.407,1],
75919=>[93.544,-78.904,53.510,1],
75920=>[93.553,-78.901,53.501,1],
75921=>[93.563,-78.899,53.491,1],
75922=>[93.573,-78.896,53.481,1],
75923=>[93.584,-78.887,53.474,1],
75924=>[93.592,-78.880,53.465,1],
75925=>[93.601,-78.874,53.456,1],
75926=>[93.609,-78.866,53.450,1],
75927=>[93.618,-78.859,53.442,1],
75928=>[93.652,-78.841,53.437,1],
75929=>[93.717,-78.808,53.433,1],
75930=>[93.712,-78.806,53.430,1],
75931=>[93.710,-78.805,53.428,1],
75932=>[93.703,-78.802,53.427,1],
75933=>[93.692,-78.799,53.426,1],
75934=>[93.691,-78.802,53.420,1],
75935=>[93.702,-78.809,53.414,1],
75936=>[93.709,-78.809,53.407,1],
75937=>[93.716,-78.808,53.398,1],
75938=>[93.723,-78.807,53.387,1],
75939=>[93.730,-78.804,53.377,1],
75940=>[93.737,-78.801,53.368,1],
75941=>[93.744,-78.799,53.355,1],
75942=>[93.751,-78.796,53.342,1],
75943=>[93.758,-78.793,53.328,1],
75944=>[93.768,-78.788,53.314,1],
75945=>[93.793,-78.774,53.298,1],
75946=>[93.808,-78.763,53.282,1],
75947=>[93.812,-78.754,53.265,1],
75948=>[93.815,-78.745,53.245,1],
75949=>[93.824,-78.737,53.224,1],
75950=>[93.838,-78.730,53.202,1],
75951=>[93.852,-78.721,53.181,1],
75952=>[93.866,-78.714,53.160,1],
75953=>[93.880,-78.705,53.140,1],
75954=>[93.894,-78.697,53.118,1],
75955=>[93.901,-78.692,53.095,1],
75956=>[93.906,-78.688,53.070,1],
75957=>[93.912,-78.683,53.044,1],
75958=>[93.917,-78.679,53.018,1],
75959=>[93.928,-78.673,52.993,1],
75960=>[93.944,-78.667,52.967,1],
75961=>[93.960,-78.661,52.941,1],
75962=>[93.976,-78.655,52.916,1],
75963=>[93.992,-78.648,52.891,1],
75964=>[94.008,-78.642,52.866,1],
75965=>[94.018,-78.640,52.844,1],
75966=>[94.028,-78.639,52.822,1],
75967=>[94.038,-78.636,52.800,1],
75968=>[94.048,-78.635,52.781,1],
75969=>[94.058,-78.633,52.758,1],
75970=>[94.067,-78.632,52.735,1],
75971=>[94.077,-78.630,52.713,1],
75972=>[94.085,-78.630,52.690,1],
75973=>[94.084,-78.636,52.668,1],
75974=>[94.083,-78.642,52.645,1],
75975=>[94.088,-78.646,52.622,1],
75976=>[94.108,-78.611,52.597,1],
75977=>[94.128,-78.574,52.572,1],
75978=>[94.179,-78.586,52.547,1],
75979=>[94.230,-78.599,52.522,1],
75980=>[94.282,-78.613,52.499,1],
75981=>[94.314,-78.619,52.476,1],
75982=>[94.324,-78.616,52.455,1],
75983=>[94.334,-78.614,52.432,1],
75984=>[94.338,-78.616,52.409,1],
75985=>[94.330,-78.628,52.387,1],
75986=>[94.322,-78.640,52.366,1],
75987=>[94.315,-78.652,52.344,1],
75988=>[94.307,-78.664,52.321,1],
75989=>[94.299,-78.676,52.297,1],
75990=>[94.316,-78.664,52.271,1],
75991=>[94.332,-78.651,52.244,1],
75992=>[94.349,-78.639,52.218,1],
75993=>[94.362,-78.631,52.193,1],
75994=>[94.370,-78.629,52.167,1],
75995=>[94.379,-78.626,52.139,1],
75996=>[94.388,-78.624,52.112,1],
75997=>[94.396,-78.622,52.084,1],
75998=>[94.405,-78.620,52.055,1],
75999=>[94.419,-78.619,52.024,1],
76000=>[94.437,-78.620,51.992,1],
76001=>[94.450,-78.623,51.959,1],
76002=>[94.461,-78.628,51.926,1],
76003=>[94.472,-78.633,51.893,1],
76004=>[94.482,-78.644,51.862,1],
76005=>[94.492,-78.677,51.830,1],
76006=>[94.505,-78.692,51.795,1],
76007=>[94.520,-78.692,51.759,1],
76008=>[94.535,-78.691,51.723,1],
76009=>[94.550,-78.690,51.684,1],
76010=>[94.565,-78.690,51.644,1],
76011=>[94.580,-78.689,51.605,1],
76012=>[94.596,-78.689,51.566,1],
76013=>[94.610,-78.688,51.531,1],
76014=>[94.625,-78.687,51.496,1],
76015=>[94.640,-78.686,51.464,1],
76016=>[94.653,-78.683,51.433,1],
76017=>[94.665,-78.680,51.403,1],
76018=>[94.677,-78.676,51.374,1],
76019=>[94.688,-78.673,51.344,1],
76020=>[94.699,-78.675,51.310,1],
76021=>[94.710,-78.677,51.274,1],
76022=>[94.720,-78.680,51.237,1],
76023=>[94.732,-78.682,51.199,1],
76024=>[94.744,-78.684,51.160,1],
76025=>[94.758,-78.689,51.120,1],
76026=>[94.764,-78.697,51.080,1],
76027=>[94.769,-78.705,51.038,1],
76028=>[94.775,-78.712,50.996,1],
76029=>[94.780,-78.720,50.954,1],
76030=>[94.786,-78.727,50.914,1],
76031=>[94.793,-78.724,50.873,1],
76032=>[94.803,-78.711,50.832,1],
76033=>[94.812,-78.698,50.787,1],
76034=>[94.819,-78.695,50.742,1],
76035=>[94.825,-78.692,50.700,1],
76036=>[94.832,-78.688,50.660,1],
76037=>[94.841,-78.680,50.618,1],
76038=>[94.849,-78.671,50.574,1],
76039=>[94.862,-78.664,50.529,1],
76040=>[94.875,-78.667,50.484,1],
76041=>[94.873,-78.682,50.438,1],
76042=>[94.872,-78.698,50.393,1],
76043=>[94.871,-78.713,50.349,1],
76044=>[94.870,-78.728,50.310,1],
76045=>[94.868,-78.744,50.270,1],
76046=>[94.867,-78.759,50.231,1],
76047=>[94.866,-78.775,50.192,1],
76048=>[94.865,-78.790,50.153,1],
76049=>[94.867,-78.804,50.113,1],
76050=>[94.868,-78.818,50.071,1],
76051=>[94.871,-78.833,50.028,1],
76052=>[94.876,-78.844,49.987,1],
76053=>[94.896,-78.846,49.946,1],
76054=>[94.926,-78.842,49.904,1],
76055=>[94.956,-78.838,49.862,1],
76056=>[94.986,-78.834,49.821,1],
76057=>[95.015,-78.830,49.781,1],
76058=>[95.044,-78.826,49.743,1],
76059=>[95.072,-78.821,49.704,1],
76060=>[95.101,-78.817,49.663,1],
76061=>[95.130,-78.812,49.622,1],
76062=>[95.159,-78.808,49.583,1],
76063=>[95.187,-78.803,49.543,1],
76064=>[95.216,-78.802,49.504,1],
76065=>[95.246,-78.808,49.464,1],
76066=>[95.273,-78.814,49.424,1],
76067=>[95.293,-78.826,49.383,1],
76068=>[95.312,-78.838,49.344,1],
76069=>[95.331,-78.849,49.303,1],
76070=>[95.351,-78.861,49.261,1],
76071=>[95.371,-78.873,49.220,1],
76072=>[95.390,-78.885,49.181,1],
76073=>[95.408,-78.893,49.142,1],
76074=>[95.422,-78.891,49.102,1],
76075=>[95.436,-78.889,49.062,1],
76076=>[95.450,-78.886,49.021,1],
76077=>[95.464,-78.884,48.981,1],
76078=>[95.478,-78.882,48.942,1],
76079=>[95.492,-78.880,48.901,1],
76080=>[95.500,-78.885,48.859,1],
76081=>[95.509,-78.891,48.817,1],
76082=>[95.516,-78.902,48.776,1],
76083=>[95.521,-78.921,48.735,1],
76084=>[95.525,-78.942,48.694,1],
76085=>[95.537,-78.958,48.654,1],
76086=>[95.552,-78.971,48.614,1],
76087=>[95.567,-78.984,48.574,1],
76088=>[95.582,-78.997,48.534,1],
76089=>[95.597,-79.011,48.492,1],
76090=>[95.612,-79.024,48.447,1],
76091=>[95.627,-79.037,48.401,1],
76092=>[95.643,-79.050,48.356,1],
76093=>[95.658,-79.064,48.309,1],
76094=>[95.673,-79.077,48.261,1],
76095=>[95.688,-79.090,48.212,1],
76096=>[95.710,-79.081,48.164,1],
76097=>[95.732,-79.068,48.119,1],
76098=>[95.745,-79.061,48.076,1],
76099=>[95.754,-79.057,48.032,1],
76100=>[95.763,-79.053,47.991,1],
76101=>[95.772,-79.049,47.949,1],
76102=>[95.781,-79.046,47.906,1],
76103=>[95.791,-79.042,47.862,1],
76104=>[95.800,-79.038,47.819,1],
76105=>[95.808,-79.034,47.776,1],
76106=>[95.814,-79.031,47.734,1],
76107=>[95.820,-79.028,47.691,1],
76108=>[95.827,-79.024,47.648,1],
76109=>[95.833,-79.020,47.605,1],
76110=>[95.840,-79.016,47.565,1],
76111=>[95.846,-79.013,47.524,1],
76112=>[95.852,-79.009,47.483,1],
76113=>[95.877,-79.006,47.442,1],
76114=>[95.913,-79.002,47.401,1],
76115=>[95.950,-78.997,47.361,1],
76116=>[95.986,-78.993,47.321,1],
76117=>[96.023,-78.990,47.282,1],
76118=>[96.087,-79.000,47.245,1],
76119=>[96.127,-79.003,47.208,1],
76120=>[96.167,-79.006,47.171,1],
76121=>[96.206,-79.009,47.135,1],
76122=>[96.246,-79.012,47.099,1],
76123=>[96.286,-79.014,47.063,1],
76124=>[96.326,-79.016,47.031,1],
76125=>[96.360,-79.003,46.998,1],
76126=>[96.394,-78.991,46.967,1],
76127=>[96.422,-79.028,46.937,1],
76128=>[96.437,-79.028,46.906,1],
76129=>[96.459,-79.038,46.875,1],
76130=>[96.483,-79.049,46.844,1],
76131=>[96.507,-79.062,46.813,1],
76132=>[96.530,-79.073,46.780,1],
76133=>[96.554,-79.085,46.748,1],
76134=>[96.578,-79.096,46.716,1],
76135=>[96.601,-79.109,46.684,1],
76136=>[96.625,-79.120,46.653,1],
76137=>[96.649,-79.132,46.621,1],
76138=>[96.672,-79.143,46.592,1],
76139=>[96.696,-79.156,46.563,1],
76140=>[96.714,-79.161,46.534,1],
76141=>[96.716,-79.142,46.505,1],
76142=>[96.718,-79.123,46.476,1],
76143=>[96.720,-79.104,46.447,1],
76144=>[96.722,-79.085,46.419,1],
76145=>[96.724,-79.066,46.393,1],
76146=>[96.788,-79.032,46.367,1],
76147=>[96.862,-78.996,46.342,1],
76148=>[96.915,-79.001,46.318,1],
76149=>[96.949,-79.045,46.293,1],
76150=>[96.938,-79.068,46.269,1],
76151=>[96.911,-79.065,46.244,1],
76152=>[96.915,-79.045,46.220,1],
76153=>[96.939,-79.012,46.197,1],
76154=>[96.958,-78.983,46.174,1],
76155=>[96.970,-78.958,46.153,1],
76156=>[96.978,-78.976,46.131,1],
76157=>[96.979,-78.987,46.110,1],
76158=>[97.012,-79.026,46.091,1],
76159=>[97.034,-79.056,46.073,1],
76160=>[96.991,-79.025,46.055,1],
76161=>[96.979,-79.006,46.037,1],
76162=>[96.976,-78.987,46.018,1],
76163=>[97.007,-79.090,45.999,1],
76164=>[97.039,-79.241,45.979,1],
76165=>[97.038,-79.228,45.960,1],
76166=>[97.043,-79.219,45.942,1],
76167=>[97.049,-79.211,45.925,1],
76168=>[97.055,-79.202,45.908,1],
76169=>[97.063,-79.193,45.892,1],
76170=>[97.074,-79.181,45.876,1],
76171=>[97.085,-79.170,45.859,1],
76172=>[97.095,-79.159,45.841,1],
76173=>[97.101,-79.139,45.824,1],
76174=>[97.106,-79.117,45.808,1],
76175=>[97.110,-79.094,45.792,1],
76176=>[97.131,-79.078,45.774,1],
76177=>[97.168,-79.071,45.756,1],
76178=>[97.205,-79.064,45.738,1],
76179=>[97.230,-79.094,45.719,1],
76180=>[97.254,-79.125,45.701,1],
76181=>[97.275,-79.159,45.685,1],
76182=>[97.303,-79.166,45.669,1],
76183=>[97.334,-79.161,45.652,1],
76184=>[97.366,-79.156,45.636,1],
76185=>[97.397,-79.150,45.620,1],
76186=>[97.407,-79.162,45.605,1],
76187=>[97.401,-79.182,45.591,1],
76188=>[97.349,-79.227,45.577,1],
76189=>[97.322,-79.253,45.562,1],
76190=>[97.333,-79.253,45.548,1],
76191=>[97.344,-79.253,45.534,1],
76192=>[97.355,-79.254,45.520,1],
76193=>[97.392,-79.257,45.506,1],
76194=>[97.399,-79.277,45.492,1],
76195=>[97.404,-79.288,45.478,1],
76196=>[97.414,-79.291,45.464,1],
76197=>[97.425,-79.294,45.449,1],
76198=>[97.436,-79.297,45.435,1],
76199=>[97.450,-79.303,45.421,1],
76200=>[97.463,-79.309,45.406,1],
76201=>[97.476,-79.314,45.393,1],
76202=>[97.490,-79.320,45.380,1],
76203=>[97.504,-79.325,45.367,1],
76204=>[97.520,-79.336,45.354,1],
76205=>[97.539,-79.350,45.340,1],
76206=>[97.558,-79.364,45.326,1],
76207=>[97.577,-79.378,45.313,1],
76208=>[97.596,-79.392,45.300,1],
76209=>[97.609,-79.400,45.288,1],
76210=>[97.613,-79.395,45.274,1],
76211=>[97.619,-79.394,45.262,1],
76212=>[97.634,-79.422,45.250,1],
76213=>[97.647,-79.444,45.239,1],
76214=>[97.653,-79.450,45.229,1],
76215=>[97.658,-79.455,45.220,1],
76216=>[97.664,-79.460,45.211,1],
76217=>[97.670,-79.466,45.201,1],
76218=>[97.676,-79.472,45.192,1],
76219=>[97.687,-79.525,45.183,1],
76220=>[97.703,-79.556,45.174,1],
76221=>[97.719,-79.582,45.162,1],
76222=>[97.731,-79.588,45.150,1],
76223=>[97.744,-79.596,45.139,1],
76224=>[97.757,-79.603,45.127,1],
76225=>[97.770,-79.610,45.115,1],
76226=>[97.782,-79.617,45.103,1],
76227=>[97.795,-79.624,45.090,1],
76228=>[97.809,-79.635,45.078,1],
76229=>[97.823,-79.647,45.067,1],
76230=>[97.838,-79.658,45.056,1],
76231=>[97.853,-79.670,45.048,1],
76232=>[97.874,-79.683,45.040,1],
76233=>[97.895,-79.696,45.032,1],
76234=>[97.917,-79.710,45.021,1],
76235=>[97.947,-79.739,45.013,1],
76236=>[97.961,-79.744,45.005,1],
76237=>[97.971,-79.741,44.998,1],
76238=>[97.996,-79.752,44.991,1],
76239=>[98.030,-79.766,44.984,1],
76240=>[98.064,-79.780,44.977,1],
76241=>[98.097,-79.794,44.971,1],
76242=>[98.121,-79.805,44.963,1],
76243=>[98.144,-79.817,44.957,1],
76244=>[98.167,-79.829,44.951,1],
76245=>[98.192,-79.839,44.943,1],
76246=>[98.217,-79.843,44.934,1],
76247=>[98.242,-79.848,44.923,1],
76248=>[98.267,-79.852,44.910,1],
76249=>[98.293,-79.858,44.896,1],
76250=>[98.318,-79.863,44.882,1],
76251=>[98.343,-79.869,44.870,1],
76252=>[98.368,-79.875,44.860,1],
76253=>[98.406,-79.886,44.853,1],
76254=>[98.443,-79.898,44.846,1],
76255=>[98.481,-79.910,44.840,1],
76256=>[98.515,-79.918,44.832,1],
76257=>[98.547,-79.925,44.824,1],
76258=>[98.578,-79.933,44.815,1],
76259=>[98.609,-79.939,44.805,1],
76260=>[98.639,-79.944,44.795,1],
76261=>[98.668,-79.949,44.785,1],
76262=>[98.685,-79.961,44.776,1],
76263=>[98.698,-79.975,44.767,1],
76264=>[98.723,-79.983,44.759,1],
76265=>[98.748,-79.992,44.753,1],
76266=>[98.774,-80.000,44.745,1],
76267=>[98.799,-80.008,44.736,1],
76268=>[98.825,-80.017,44.728,1],
76269=>[98.860,-80.018,44.719,1],
76270=>[98.881,-80.027,44.710,1],
76271=>[98.903,-80.036,44.701,1],
76272=>[98.924,-80.044,44.694,1],
76273=>[98.944,-80.043,44.687,1],
76274=>[98.961,-80.047,44.680,1],
76275=>[98.981,-80.061,44.675,1],
76276=>[99.000,-80.075,44.669,1],
76277=>[99.016,-80.081,44.662,1],
76278=>[99.032,-80.086,44.655,1],
76279=>[99.049,-80.091,44.651,1],
76280=>[99.065,-80.096,44.646,1],
76281=>[99.079,-80.105,44.641,1],
76282=>[99.093,-80.113,44.635,1],
76283=>[99.108,-80.121,44.629,1],
76284=>[99.123,-80.130,44.624,1],
76285=>[99.153,-80.145,44.619,1],
76286=>[99.231,-80.181,44.613,1],
76287=>[99.255,-80.191,44.608,1],
76288=>[99.278,-80.202,44.604,1],
76289=>[99.313,-80.207,44.600,1],
76290=>[99.352,-80.211,44.596,1],
76291=>[99.391,-80.215,44.592,1],
76292=>[99.429,-80.219,44.587,1],
76293=>[99.468,-80.223,44.583,1],
76294=>[99.506,-80.227,44.579,1],
76295=>[99.540,-80.233,44.575,1],
76296=>[99.543,-80.256,44.570,1],
76297=>[99.547,-80.278,44.566,1],
76298=>[99.550,-80.300,44.561,1],
76299=>[99.553,-80.322,44.556,1],
76300=>[99.556,-80.344,44.550,1],
76301=>[99.559,-80.366,44.544,1],
76302=>[99.563,-80.388,44.538,1],
76303=>[99.566,-80.410,44.532,1],
76304=>[99.569,-80.432,44.526,1],
76305=>[99.572,-80.455,44.520,1],
76306=>[99.575,-80.477,44.513,1],
76307=>[99.579,-80.499,44.505,1],
76308=>[99.582,-80.521,44.497,1],
76309=>[99.585,-80.543,44.490,1],
76310=>[99.588,-80.566,44.482,1],
76311=>[99.591,-80.588,44.474,1],
76312=>[99.595,-80.610,44.466,1],
76313=>[99.598,-80.632,44.458,1],
76314=>[99.601,-80.654,44.449,1],
76315=>[99.605,-80.676,44.440,1],
76316=>[99.608,-80.698,44.431,1],
76317=>[99.611,-80.720,44.421,1],
76318=>[99.640,-80.733,44.412,1],
76319=>[99.688,-80.739,44.402,1],
76320=>[99.736,-80.744,44.391,1],
76321=>[99.784,-80.750,44.381,1],
76620=>[93.544,-78.893,53.523,1],
76621=>[93.554,-78.890,53.513,1],
76622=>[93.563,-78.888,53.503,1],
76623=>[93.573,-78.885,53.493,1],
76624=>[93.582,-78.883,53.486,1],
76625=>[93.593,-78.874,53.478,1],
76626=>[93.602,-78.867,53.470,1],
76627=>[93.610,-78.860,53.463,1],
76628=>[93.619,-78.853,53.456,1],
76629=>[93.641,-78.840,53.451,1],
76630=>[93.709,-78.806,53.448,1],
76631=>[93.700,-78.805,53.447,1],
76632=>[93.698,-78.802,53.446,1],
76633=>[93.697,-78.801,53.445,1],
76634=>[93.692,-78.799,53.443,1],
76635=>[93.690,-78.802,53.437,1],
76636=>[93.698,-78.802,53.430,1],
76637=>[93.705,-78.802,53.422,1],
76638=>[93.711,-78.801,53.412,1],
76639=>[93.718,-78.799,53.402,1],
76640=>[93.726,-78.797,53.393,1],
76641=>[93.733,-78.794,53.382,1],
76642=>[93.740,-78.791,53.370,1],
76643=>[93.747,-78.788,53.356,1],
76644=>[93.755,-78.785,53.342,1],
76645=>[93.779,-78.771,53.327,1],
76646=>[93.804,-78.757,53.310,1],
76647=>[93.809,-78.749,53.293,1],
76648=>[93.813,-78.739,53.275,1],
76649=>[93.816,-78.731,53.255,1],
76650=>[93.823,-78.723,53.234,1],
76651=>[93.837,-78.715,53.213,1],
76652=>[93.851,-78.707,53.191,1],
76653=>[93.865,-78.699,53.172,1],
76654=>[93.879,-78.691,53.152,1],
76655=>[93.893,-78.683,53.130,1],
76656=>[93.907,-78.675,53.106,1],
76657=>[93.919,-78.667,53.080,1],
76658=>[93.924,-78.663,53.054,1],
76659=>[93.929,-78.659,53.029,1],
76660=>[93.943,-78.653,53.003,1],
76661=>[93.960,-78.646,52.977,1],
76662=>[93.976,-78.640,52.951,1],
76663=>[93.987,-78.637,52.926,1],
76664=>[93.997,-78.636,52.901,1],
76665=>[94.007,-78.633,52.878,1],
76666=>[94.017,-78.632,52.857,1],
76667=>[94.027,-78.630,52.836,1],
76668=>[94.037,-78.629,52.815,1],
76669=>[94.047,-78.627,52.796,1],
76670=>[94.057,-78.626,52.773,1],
76671=>[94.067,-78.623,52.750,1],
76672=>[94.077,-78.622,52.728,1],
76673=>[94.082,-78.623,52.705,1],
76674=>[94.081,-78.630,52.682,1],
76675=>[94.079,-78.636,52.659,1],
76676=>[94.099,-78.592,52.636,1],
76677=>[94.119,-78.556,52.611,1],
76678=>[94.163,-78.557,52.586,1],
76679=>[94.214,-78.571,52.560,1],
76680=>[94.266,-78.584,52.536,1],
76681=>[94.318,-78.598,52.513,1],
76682=>[94.337,-78.598,52.492,1],
76683=>[94.347,-78.596,52.472,1],
76684=>[94.351,-78.598,52.450,1],
76685=>[94.344,-78.610,52.427,1],
76686=>[94.336,-78.622,52.406,1],
76687=>[94.328,-78.634,52.384,1],
76688=>[94.321,-78.646,52.362,1],
76689=>[94.313,-78.658,52.339,1],
76690=>[94.305,-78.670,52.316,1],
76691=>[94.318,-78.661,52.292,1],
76692=>[94.334,-78.649,52.266,1],
76693=>[94.351,-78.637,52.240,1],
76694=>[94.367,-78.624,52.214,1],
76695=>[94.380,-78.617,52.188,1],
76696=>[94.388,-78.615,52.161,1],
76697=>[94.397,-78.613,52.135,1],
76698=>[94.405,-78.611,52.107,1],
76699=>[94.414,-78.608,52.077,1],
76700=>[94.428,-78.608,52.046,1],
76701=>[94.447,-78.608,52.012,1],
76702=>[94.462,-78.610,51.978,1],
76703=>[94.473,-78.615,51.945,1],
76704=>[94.484,-78.620,51.911,1],
76705=>[94.494,-78.646,51.878,1],
76706=>[94.504,-78.680,51.845,1],
76707=>[94.517,-78.697,51.810,1],
76708=>[94.532,-78.696,51.773,1],
76709=>[94.547,-78.695,51.735,1],
76710=>[94.562,-78.695,51.696,1],
76711=>[94.577,-78.694,51.656,1],
76712=>[94.592,-78.693,51.617,1],
76713=>[94.607,-78.693,51.577,1],
76714=>[94.620,-78.689,51.541,1],
76715=>[94.631,-78.686,51.507,1],
76716=>[94.643,-78.682,51.475,1],
76717=>[94.655,-78.678,51.444,1],
76718=>[94.667,-78.674,51.414,1],
76719=>[94.679,-78.670,51.384,1],
76720=>[94.690,-78.667,51.354,1],
76721=>[94.701,-78.669,51.320,1],
76722=>[94.712,-78.671,51.283,1],
76723=>[94.723,-78.673,51.245,1],
76724=>[94.734,-78.676,51.208,1],
76725=>[94.751,-78.679,51.169,1],
76726=>[94.768,-78.683,51.130,1],
76727=>[94.773,-78.691,51.091,1],
76728=>[94.779,-78.698,51.050,1],
76729=>[94.784,-78.705,51.008,1],
76730=>[94.790,-78.713,50.966,1],
76731=>[94.795,-78.720,50.924,1],
76732=>[94.804,-78.714,50.884,1],
76733=>[94.813,-78.701,50.843,1],
76734=>[94.822,-78.688,50.799,1],
76735=>[94.832,-78.675,50.754,1],
76736=>[94.839,-78.670,50.711,1],
76737=>[94.845,-78.666,50.669,1],
76738=>[94.852,-78.663,50.628,1],
76739=>[94.858,-78.659,50.583,1],
76740=>[94.865,-78.655,50.538,1],
76741=>[94.873,-78.655,50.493,1],
76742=>[94.872,-78.670,50.445,1],
76743=>[94.873,-78.685,50.400,1],
76744=>[94.875,-78.698,50.356,1],
76745=>[94.877,-78.713,50.316,1],
76746=>[94.879,-78.727,50.278,1],
76747=>[94.881,-78.741,50.240,1],
76748=>[94.882,-78.755,50.200,1],
76749=>[94.884,-78.769,50.161,1],
76750=>[94.886,-78.783,50.120,1],
76751=>[94.888,-78.797,50.076,1],
76752=>[94.890,-78.811,50.032,1],
76753=>[94.900,-78.819,49.989,1],
76754=>[94.914,-78.824,49.946,1],
76755=>[94.934,-78.825,49.903,1],
76756=>[94.964,-78.822,49.860,1],
76757=>[94.993,-78.818,49.819,1],
76758=>[95.024,-78.814,49.779,1],
76759=>[95.053,-78.811,49.740,1],
76760=>[95.083,-78.807,49.701,1],
76761=>[95.113,-78.804,49.662,1],
76762=>[95.143,-78.800,49.622,1],
76763=>[95.173,-78.796,49.582,1],
76764=>[95.202,-78.793,49.543,1],
76765=>[95.233,-78.789,49.504,1],
76766=>[95.254,-78.798,49.463,1],
76767=>[95.273,-78.810,49.423,1],
76768=>[95.293,-78.821,49.382,1],
76769=>[95.312,-78.833,49.342,1],
76770=>[95.332,-78.845,49.302,1],
76771=>[95.351,-78.857,49.261,1],
76772=>[95.371,-78.868,49.220,1],
76773=>[95.390,-78.880,49.182,1],
76774=>[95.409,-78.890,49.142,1],
76775=>[95.422,-78.887,49.102,1],
76776=>[95.437,-78.885,49.061,1],
76777=>[95.451,-78.883,49.021,1],
76778=>[95.464,-78.880,48.982,1],
76779=>[95.478,-78.878,48.943,1],
76780=>[95.492,-78.876,48.902,1],
76781=>[95.506,-78.873,48.860,1],
76782=>[95.518,-78.874,48.818,1],
76783=>[95.526,-78.880,48.777,1],
76784=>[95.531,-78.900,48.736,1],
76785=>[95.542,-78.916,48.695,1],
76786=>[95.557,-78.930,48.654,1],
76787=>[95.572,-78.943,48.613,1],
76788=>[95.587,-78.956,48.573,1],
76789=>[95.602,-78.969,48.532,1],
76790=>[95.618,-78.983,48.492,1],
76791=>[95.633,-78.996,48.450,1],
76792=>[95.648,-79.009,48.406,1],
76793=>[95.663,-79.022,48.360,1],
76794=>[95.678,-79.035,48.312,1],
76795=>[95.693,-79.049,48.264,1],
76796=>[95.708,-79.062,48.216,1],
76797=>[95.724,-79.074,48.170,1],
76798=>[95.744,-79.063,48.126,1],
76799=>[95.753,-79.059,48.083,1],
76800=>[95.762,-79.056,48.039,1],
76801=>[95.771,-79.052,47.998,1],
76802=>[95.780,-79.048,47.956,1],
76803=>[95.789,-79.044,47.912,1],
76804=>[95.798,-79.040,47.869,1],
76805=>[95.807,-79.037,47.827,1],
76806=>[95.816,-79.033,47.785,1],
76807=>[95.824,-79.029,47.742,1],
76808=>[95.830,-79.025,47.699,1],
76809=>[95.836,-79.021,47.656,1],
76810=>[95.843,-79.018,47.612,1],
76811=>[95.849,-79.015,47.572,1],
76812=>[95.855,-79.011,47.530,1],
76813=>[95.871,-79.007,47.489,1],
76814=>[95.907,-79.003,47.448,1],
76815=>[95.944,-78.999,47.408,1],
76816=>[95.980,-78.996,47.368,1],
76817=>[96.017,-78.991,47.328,1],
76818=>[96.053,-78.987,47.289,1],
76819=>[96.090,-78.984,47.251,1],
76820=>[96.129,-78.985,47.214,1],
76821=>[96.169,-78.987,47.177,1],
76822=>[96.208,-78.990,47.141,1],
76823=>[96.248,-78.993,47.105,1],
76824=>[96.288,-78.996,47.070,1],
76825=>[96.328,-78.999,47.037,1],
76826=>[96.368,-79.001,47.005,1],
76827=>[96.402,-78.990,46.974,1],
76828=>[96.425,-79.007,46.943,1],
76829=>[96.447,-79.018,46.913,1],
76830=>[96.471,-79.030,46.882,1],
76831=>[96.495,-79.041,46.851,1],
76832=>[96.518,-79.053,46.820,1],
76833=>[96.542,-79.065,46.789,1],
76834=>[96.566,-79.077,46.757,1],
76835=>[96.584,-79.086,46.724,1],
76836=>[96.603,-79.096,46.691,1],
76837=>[96.621,-79.105,46.660,1],
76838=>[96.640,-79.115,46.629,1],
76839=>[96.658,-79.124,46.599,1],
76840=>[96.677,-79.134,46.570,1],
76841=>[96.707,-79.138,46.539,1],
76842=>[96.743,-79.134,46.510,1],
76843=>[96.752,-79.118,46.481,1],
76844=>[96.754,-79.099,46.452,1],
76845=>[96.756,-79.080,46.425,1],
76846=>[96.758,-79.061,46.398,1],
76847=>[96.823,-79.027,46.373,1],
76848=>[96.897,-78.990,46.348,1],
76849=>[96.972,-78.954,46.324,1],
76850=>[96.989,-78.949,46.299,1],
76851=>[96.965,-78.977,46.274,1],
76852=>[96.942,-79.006,46.249,1],
76853=>[96.935,-79.006,46.226,1],
76854=>[96.946,-78.981,46.204,1],
76855=>[96.958,-78.955,46.182,1],
76856=>[96.969,-78.943,46.161,1],
76857=>[96.977,-78.963,46.140,1],
76858=>[96.985,-78.993,46.119,1],
76859=>[96.993,-79.021,46.100,1],
76860=>[96.983,-79.019,46.082,1],
76861=>[96.959,-79.006,46.065,1],
76862=>[96.976,-78.987,46.046,1],
76863=>[96.994,-78.979,46.027,1],
76864=>[97.045,-79.140,46.008,1],
76865=>[97.037,-79.256,45.989,1],
76866=>[97.043,-79.247,45.970,1],
76867=>[97.048,-79.239,45.953,1],
76868=>[97.054,-79.231,45.936,1],
76869=>[97.061,-79.222,45.918,1],
76870=>[97.068,-79.213,45.902,1],
76871=>[97.078,-79.202,45.886,1],
76872=>[97.089,-79.190,45.869,1],
76873=>[97.099,-79.177,45.850,1],
76874=>[97.103,-79.154,45.833,1],
76875=>[97.107,-79.132,45.817,1],
76876=>[97.112,-79.109,45.801,1],
76877=>[97.116,-79.087,45.785,1],
76878=>[97.137,-79.071,45.767,1],
76879=>[97.169,-79.078,45.749,1],
76880=>[97.193,-79.109,45.730,1],
76881=>[97.229,-79.134,45.713,1],
76882=>[97.268,-79.156,45.697,1],
76883=>[97.301,-79.159,45.682,1],
76884=>[97.332,-79.153,45.666,1],
76885=>[97.364,-79.148,45.650,1],
76886=>[97.385,-79.151,45.633,1],
76887=>[97.391,-79.165,45.619,1],
76888=>[97.398,-79.179,45.605,1],
76889=>[97.404,-79.193,45.590,1],
76890=>[97.362,-79.232,45.576,1],
76891=>[97.346,-79.251,45.562,1],
76892=>[97.357,-79.252,45.548,1],
76893=>[97.371,-79.253,45.533,1],
76894=>[97.397,-79.263,45.520,1],
76895=>[97.400,-79.276,45.505,1],
76896=>[97.407,-79.282,45.491,1],
76897=>[97.417,-79.286,45.478,1],
76898=>[97.428,-79.288,45.464,1],
76899=>[97.439,-79.291,45.450,1],
76900=>[97.450,-79.294,45.436,1],
76901=>[97.463,-79.299,45.422,1],
76902=>[97.476,-79.304,45.409,1],
76903=>[97.490,-79.310,45.396,1],
76904=>[97.504,-79.316,45.383,1],
76905=>[97.518,-79.322,45.369,1],
76906=>[97.537,-79.337,45.356,1],
76907=>[97.556,-79.350,45.342,1],
76908=>[97.575,-79.365,45.329,1],
76909=>[97.594,-79.379,45.315,1],
76910=>[97.612,-79.393,45.301,1],
76911=>[97.632,-79.407,45.288,1],
76912=>[97.642,-79.414,45.275,1],
76913=>[97.650,-79.425,45.262,1],
76914=>[97.656,-79.431,45.251,1],
76915=>[97.662,-79.436,45.243,1],
76916=>[97.668,-79.441,45.234,1],
76917=>[97.674,-79.447,45.225,1],
76918=>[97.680,-79.452,45.214,1],
76919=>[97.686,-79.457,45.205,1],
76920=>[97.697,-79.491,45.196,1],
76921=>[97.713,-79.523,45.185,1],
76922=>[97.729,-79.554,45.174,1],
76923=>[97.743,-79.564,45.163,1],
76924=>[97.755,-79.571,45.153,1],
76925=>[97.768,-79.579,45.141,1],
76926=>[97.781,-79.585,45.129,1],
76927=>[97.794,-79.593,45.117,1],
76928=>[97.808,-79.604,45.104,1],
76929=>[97.822,-79.616,45.091,1],
76930=>[97.837,-79.627,45.080,1],
76931=>[97.852,-79.639,45.072,1],
76932=>[97.866,-79.651,45.065,1],
76933=>[97.886,-79.664,45.057,1],
76934=>[97.908,-79.676,45.048,1],
76935=>[97.928,-79.689,45.039,1],
76936=>[97.943,-79.695,45.031,1],
76937=>[97.956,-79.701,45.024,1],
76938=>[97.973,-79.709,45.016,1],
76939=>[97.981,-79.733,45.007,1],
76940=>[98.026,-79.735,45.000,1],
76941=>[98.066,-79.752,44.992,1],
76942=>[98.105,-79.773,44.985,1],
76943=>[98.132,-79.786,44.977,1],
76944=>[98.155,-79.798,44.969,1],
76945=>[98.178,-79.811,44.961,1],
76946=>[98.204,-79.817,44.952,1],
76947=>[98.229,-79.820,44.943,1],
76948=>[98.254,-79.825,44.932,1],
76949=>[98.279,-79.829,44.917,1],
76950=>[98.304,-79.833,44.902,1],
76951=>[98.330,-79.838,44.889,1],
76952=>[98.355,-79.844,44.877,1],
76953=>[98.380,-79.850,44.868,1],
76954=>[98.417,-79.861,44.859,1],
76955=>[98.454,-79.872,44.851,1],
76956=>[98.487,-79.880,44.843,1],
76957=>[98.519,-79.888,44.835,1],
76958=>[98.551,-79.895,44.826,1],
76959=>[98.582,-79.902,44.818,1],
76960=>[98.614,-79.909,44.809,1],
76961=>[98.644,-79.915,44.800,1],
76962=>[98.670,-79.922,44.793,1],
76963=>[98.688,-79.935,44.784,1],
76964=>[98.713,-79.943,44.775,1],
76965=>[98.738,-79.952,44.767,1],
76966=>[98.764,-79.960,44.761,1],
76967=>[98.789,-79.968,44.754,1],
76968=>[98.814,-79.977,44.746,1],
76969=>[98.840,-79.985,44.738,1],
76970=>[98.867,-79.991,44.729,1],
76971=>[98.888,-79.996,44.721,1],
76972=>[98.909,-79.996,44.712,1],
76973=>[98.929,-79.994,44.705,1],
76974=>[98.950,-79.993,44.698,1],
76975=>[98.964,-79.988,44.692,1],
76976=>[98.983,-80.002,44.687,1],
76977=>[99.002,-80.016,44.681,1],
76978=>[99.021,-80.030,44.675,1],
76979=>[99.040,-80.044,44.668,1],
76980=>[99.059,-80.059,44.664,1],
76981=>[99.078,-80.072,44.659,1],
76982=>[99.096,-80.083,44.654,1],
76983=>[99.112,-80.088,44.649,1],
76984=>[99.127,-80.097,44.643,1],
76985=>[99.209,-80.128,44.638,1],
76986=>[99.214,-80.128,44.632,1],
76987=>[99.219,-80.129,44.627,1],
76988=>[99.243,-80.153,44.622,1],
76989=>[99.286,-80.173,44.617,1],
76990=>[99.324,-80.177,44.613,1],
76991=>[99.363,-80.181,44.609,1],
76992=>[99.402,-80.185,44.605,1],
76993=>[99.440,-80.189,44.599,1],
76994=>[99.479,-80.193,44.595,1],
76995=>[99.517,-80.196,44.591,1],
76996=>[99.537,-80.210,44.586,1],
76997=>[99.540,-80.232,44.581,1],
76998=>[99.543,-80.255,44.576,1],
76999=>[99.546,-80.277,44.571,1],
77000=>[99.550,-80.299,44.565,1],
77001=>[99.553,-80.321,44.559,1],
77002=>[99.556,-80.344,44.553,1],
77003=>[99.559,-80.366,44.546,1],
77004=>[99.562,-80.388,44.540,1],
77005=>[99.566,-80.410,44.534,1],
77006=>[99.569,-80.431,44.527,1],
77007=>[99.572,-80.454,44.520,1],
77008=>[99.575,-80.476,44.512,1],
77009=>[99.578,-80.498,44.504,1],
77010=>[99.581,-80.520,44.496,1],
77011=>[99.585,-80.542,44.489,1],
77012=>[99.588,-80.565,44.481,1],
77013=>[99.591,-80.587,44.472,1],
77014=>[99.594,-80.609,44.464,1],
77015=>[99.597,-80.631,44.455,1],
77016=>[99.601,-80.654,44.445,1],
77017=>[99.604,-80.676,44.436,1],
77018=>[99.608,-80.698,44.426,1],
77019=>[99.648,-80.706,44.416,1],
77020=>[99.697,-80.711,44.406,1],
77021=>[99.745,-80.717,44.396,1],
77022=>[99.792,-80.723,44.386,1],
77023=>[99.840,-80.728,44.375,1],
77024=>[99.888,-80.734,44.363,1],
77025=>[99.936,-80.739,44.353,1],
77321=>[93.544,-78.882,53.534,1],
77322=>[93.554,-78.880,53.525,1],
77323=>[93.564,-78.877,53.515,1],
77324=>[93.573,-78.874,53.506,1],
77325=>[93.583,-78.872,53.498,1],
77326=>[93.592,-78.870,53.490,1],
77327=>[93.603,-78.860,53.483,1],
77328=>[93.611,-78.853,53.476,1],
77329=>[93.620,-78.846,53.469,1],
77330=>[93.629,-78.839,53.465,1],
77331=>[93.698,-78.805,53.463,1],
77332=>[93.688,-78.802,53.464,1],
77333=>[93.687,-78.801,53.464,1],
77334=>[93.685,-78.799,53.462,1],
77335=>[93.684,-78.797,53.459,1],
77336=>[93.687,-78.795,53.453,1],
77337=>[93.694,-78.795,53.446,1],
77338=>[93.701,-78.794,53.438,1],
77339=>[93.707,-78.793,53.427,1],
77340=>[93.714,-78.793,53.417,1],
77341=>[93.721,-78.789,53.407,1],
77342=>[93.728,-78.786,53.396,1],
77343=>[93.736,-78.783,53.383,1],
77344=>[93.743,-78.781,53.370,1],
77345=>[93.766,-78.768,53.355,1],
77346=>[93.791,-78.754,53.338,1],
77347=>[93.807,-78.742,53.321,1],
77348=>[93.811,-78.734,53.303,1],
77349=>[93.814,-78.725,53.285,1],
77350=>[93.817,-78.717,53.265,1],
77351=>[93.822,-78.708,53.244,1],
77352=>[93.836,-78.701,53.223,1],
77353=>[93.850,-78.692,53.202,1],
77354=>[93.864,-78.684,53.182,1],
77355=>[93.878,-78.677,53.163,1],
77356=>[93.892,-78.668,53.141,1],
77357=>[93.906,-78.661,53.117,1],
77358=>[93.920,-78.652,53.091,1],
77359=>[93.934,-78.645,53.065,1],
77360=>[93.943,-78.639,53.040,1],
77361=>[93.957,-78.634,53.013,1],
77362=>[93.967,-78.633,52.986,1],
77363=>[93.977,-78.631,52.960,1],
77364=>[93.987,-78.629,52.936,1],
77365=>[93.996,-78.627,52.913,1],
77366=>[94.006,-78.626,52.890,1],
77367=>[94.016,-78.624,52.869,1],
77368=>[94.027,-78.623,52.849,1],
77369=>[94.036,-78.620,52.830,1],
77370=>[94.046,-78.619,52.810,1],
77371=>[94.056,-78.617,52.788,1],
77372=>[94.066,-78.616,52.765,1],
77373=>[94.076,-78.614,52.742,1],
77374=>[94.079,-78.617,52.720,1],
77375=>[94.077,-78.624,52.697,1],
77376=>[94.076,-78.606,52.674,1],
77377=>[94.105,-78.551,52.650,1],
77378=>[94.147,-78.529,52.625,1],
77379=>[94.199,-78.542,52.599,1],
77380=>[94.251,-78.556,52.573,1],
77381=>[94.302,-78.570,52.551,1],
77382=>[94.350,-78.582,52.529,1],
77383=>[94.360,-78.579,52.508,1],
77384=>[94.365,-78.580,52.489,1],
77385=>[94.357,-78.592,52.467,1],
77386=>[94.350,-78.604,52.445,1],
77387=>[94.342,-78.617,52.424,1],
77388=>[94.334,-78.628,52.402,1],
77389=>[94.327,-78.640,52.380,1],
77390=>[94.319,-78.652,52.357,1],
77391=>[94.312,-78.664,52.335,1],
77392=>[94.320,-78.660,52.312,1],
77393=>[94.336,-78.647,52.288,1],
77394=>[94.353,-78.635,52.261,1],
77395=>[94.369,-78.623,52.235,1],
77396=>[94.386,-78.611,52.209,1],
77397=>[94.397,-78.604,52.184,1],
77398=>[94.406,-78.601,52.158,1],
77399=>[94.415,-78.599,52.129,1],
77400=>[94.423,-78.597,52.098,1],
77401=>[94.437,-78.596,52.065,1],
77402=>[94.456,-78.597,52.030,1],
77403=>[94.474,-78.598,51.996,1],
77404=>[94.485,-78.602,51.964,1],
77405=>[94.496,-78.616,51.929,1],
77406=>[94.506,-78.649,51.894,1],
77407=>[94.517,-78.683,51.859,1],
77408=>[94.529,-78.702,51.825,1],
77409=>[94.544,-78.701,51.787,1],
77410=>[94.559,-78.700,51.748,1],
77411=>[94.574,-78.699,51.708,1],
77412=>[94.586,-78.696,51.668,1],
77413=>[94.598,-78.692,51.629,1],
77414=>[94.610,-78.689,51.589,1],
77415=>[94.622,-78.685,51.554,1],
77416=>[94.633,-78.680,51.520,1],
77417=>[94.645,-78.677,51.486,1],
77418=>[94.657,-78.673,51.455,1],
77419=>[94.669,-78.669,51.423,1],
77420=>[94.681,-78.665,51.392,1],
77421=>[94.692,-78.661,51.361,1],
77422=>[94.703,-78.663,51.325,1],
77423=>[94.714,-78.665,51.288,1],
77424=>[94.725,-78.667,51.251,1],
77425=>[94.739,-78.670,51.214,1],
77426=>[94.757,-78.673,51.176,1],
77427=>[94.776,-78.677,51.138,1],
77428=>[94.783,-78.684,51.099,1],
77429=>[94.788,-78.692,51.059,1],
77430=>[94.794,-78.699,51.018,1],
77431=>[94.800,-78.707,50.977,1],
77432=>[94.806,-78.714,50.935,1],
77433=>[94.814,-78.704,50.894,1],
77434=>[94.824,-78.691,50.853,1],
77435=>[94.833,-78.678,50.809,1],
77436=>[94.842,-78.665,50.764,1],
77437=>[94.851,-78.652,50.720,1],
77438=>[94.859,-78.645,50.677,1],
77439=>[94.865,-78.641,50.636,1],
77440=>[94.872,-78.637,50.591,1],
77441=>[94.879,-78.634,50.546,1],
77442=>[94.886,-78.638,50.500,1],
77443=>[94.891,-78.649,50.452,1],
77444=>[94.892,-78.664,50.405,1],
77445=>[94.894,-78.677,50.361,1],
77446=>[94.896,-78.692,50.322,1],
77447=>[94.898,-78.705,50.284,1],
77448=>[94.899,-78.720,50.246,1],
77449=>[94.901,-78.733,50.206,1],
77450=>[94.903,-78.748,50.166,1],
77451=>[94.905,-78.762,50.124,1],
77452=>[94.907,-78.776,50.080,1],
77453=>[94.909,-78.789,50.034,1],
77454=>[94.923,-78.794,49.989,1],
77455=>[94.938,-78.799,49.945,1],
77456=>[94.953,-78.803,49.902,1],
77457=>[94.972,-78.805,49.860,1],
77458=>[95.001,-78.802,49.819,1],
77459=>[95.031,-78.799,49.779,1],
77460=>[95.061,-78.795,49.738,1],
77461=>[95.091,-78.791,49.700,1],
77462=>[95.121,-78.787,49.662,1],
77463=>[95.151,-78.783,49.623,1],
77464=>[95.181,-78.780,49.584,1],
77465=>[95.210,-78.777,49.544,1],
77466=>[95.232,-78.774,49.504,1],
77467=>[95.252,-78.793,49.464,1],
77468=>[95.273,-78.805,49.423,1],
77469=>[95.293,-78.817,49.383,1],
77470=>[95.312,-78.829,49.341,1],
77471=>[95.332,-78.840,49.301,1],
77472=>[95.351,-78.852,49.262,1],
77473=>[95.371,-78.864,49.222,1],
77474=>[95.390,-78.876,49.183,1],
77475=>[95.409,-78.886,49.143,1],
77476=>[95.423,-78.883,49.103,1],
77477=>[95.437,-78.881,49.062,1],
77478=>[95.451,-78.878,49.023,1],
77479=>[95.465,-78.876,48.983,1],
77480=>[95.479,-78.874,48.943,1],
77481=>[95.492,-78.871,48.903,1],
77482=>[95.507,-78.869,48.862,1],
77483=>[95.520,-78.867,48.820,1],
77484=>[95.534,-78.865,48.779,1],
77485=>[95.547,-78.875,48.737,1],
77486=>[95.562,-78.888,48.696,1],
77487=>[95.577,-78.902,48.655,1],
77488=>[95.592,-78.915,48.613,1],
77489=>[95.606,-78.928,48.572,1],
77490=>[95.620,-78.941,48.531,1],
77491=>[95.633,-78.955,48.492,1],
77492=>[95.648,-78.968,48.451,1],
77493=>[95.662,-78.981,48.408,1],
77494=>[95.675,-78.994,48.362,1],
77495=>[95.689,-79.008,48.313,1],
77496=>[95.703,-79.021,48.265,1],
77497=>[95.717,-79.034,48.219,1],
77498=>[95.731,-79.048,48.176,1],
77499=>[95.747,-79.056,48.133,1],
77500=>[95.760,-79.057,48.090,1],
77501=>[95.769,-79.053,48.046,1],
77502=>[95.778,-79.049,48.005,1],
77503=>[95.788,-79.046,47.963,1],
77504=>[95.797,-79.042,47.919,1],
77505=>[95.806,-79.038,47.877,1],
77506=>[95.815,-79.034,47.835,1],
77507=>[95.824,-79.031,47.793,1],
77508=>[95.833,-79.027,47.750,1],
77509=>[95.839,-79.023,47.707,1],
77510=>[95.846,-79.020,47.664,1],
77511=>[95.852,-79.016,47.620,1],
77512=>[95.859,-79.012,47.578,1],
77513=>[95.866,-79.009,47.537,1],
77514=>[95.902,-79.005,47.496,1],
77515=>[95.939,-79.001,47.456,1],
77516=>[95.975,-78.997,47.416,1],
77517=>[96.012,-78.993,47.376,1],
77518=>[96.048,-78.990,47.336,1],
77519=>[96.072,-78.984,47.297,1],
77520=>[96.095,-78.977,47.259,1],
77521=>[96.129,-78.976,47.222,1],
77522=>[96.169,-78.977,47.184,1],
77523=>[96.209,-78.979,47.148,1],
77524=>[96.249,-78.981,47.112,1],
77525=>[96.290,-78.982,47.078,1],
77526=>[96.329,-78.984,47.044,1],
77527=>[96.370,-78.985,47.012,1],
77528=>[96.409,-78.987,46.981,1],
77529=>[96.429,-78.995,46.950,1],
77530=>[96.447,-79.004,46.920,1],
77531=>[96.466,-79.014,46.890,1],
77532=>[96.484,-79.023,46.858,1],
77533=>[96.503,-79.033,46.828,1],
77534=>[96.522,-79.042,46.797,1],
77535=>[96.540,-79.052,46.766,1],
77536=>[96.559,-79.061,46.732,1],
77537=>[96.578,-79.071,46.700,1],
77538=>[96.596,-79.080,46.668,1],
77539=>[96.615,-79.090,46.637,1],
77540=>[96.633,-79.100,46.607,1],
77541=>[96.648,-79.106,46.576,1],
77542=>[96.687,-79.109,46.545,1],
77543=>[96.735,-79.111,46.516,1],
77544=>[96.764,-79.103,46.487,1],
77545=>[96.788,-79.093,46.459,1],
77546=>[96.790,-79.075,46.431,1],
77547=>[96.792,-79.056,46.405,1],
77548=>[96.859,-79.021,46.380,1],
77549=>[96.929,-78.984,46.355,1],
77550=>[96.961,-78.938,46.330,1],
77551=>[96.981,-78.954,46.305,1],
77552=>[96.953,-78.981,46.280,1],
77553=>[96.930,-79.009,46.255,1],
77554=>[96.934,-78.979,46.233,1],
77555=>[96.946,-78.954,46.212,1],
77556=>[96.957,-78.928,46.191,1],
77557=>[96.967,-78.933,46.170,1],
77558=>[96.975,-78.952,46.149,1],
77559=>[96.983,-78.980,46.129,1],
77560=>[96.991,-79.009,46.108,1],
77561=>[96.999,-79.037,46.091,1],
77562=>[96.984,-79.002,46.074,1],
77563=>[96.967,-78.962,46.056,1],
77564=>[97.006,-78.972,46.037,1],
77565=>[97.014,-79.100,46.019,1],
77566=>[97.029,-79.228,46.000,1],
77567=>[97.048,-79.267,45.982,1],
77568=>[97.054,-79.259,45.965,1],
77569=>[97.060,-79.250,45.948,1],
77570=>[97.066,-79.242,45.928,1],
77571=>[97.072,-79.234,45.911,1],
77572=>[97.083,-79.222,45.895,1],
77573=>[97.093,-79.211,45.878,1],
77574=>[97.100,-79.192,45.859,1],
77575=>[97.105,-79.170,45.843,1],
77576=>[97.109,-79.147,45.828,1],
77577=>[97.114,-79.125,45.811,1],
77578=>[97.118,-79.102,45.796,1],
77579=>[97.123,-79.079,45.779,1],
77580=>[97.150,-79.084,45.761,1],
77581=>[97.189,-79.106,45.742,1],
77582=>[97.228,-79.129,45.726,1],
77583=>[97.267,-79.152,45.711,1],
77584=>[97.299,-79.151,45.695,1],
77585=>[97.330,-79.146,45.680,1],
77586=>[97.362,-79.140,45.664,1],
77587=>[97.369,-79.154,45.649,1],
77588=>[97.375,-79.169,45.634,1],
77589=>[97.382,-79.182,45.621,1],
77590=>[97.388,-79.197,45.609,1],
77591=>[97.395,-79.210,45.596,1],
77592=>[97.375,-79.237,45.582,1],
77593=>[97.369,-79.250,45.567,1],
77594=>[97.391,-79.251,45.552,1],
77595=>[97.396,-79.265,45.537,1],
77596=>[97.403,-79.271,45.523,1],
77597=>[97.410,-79.278,45.509,1],
77598=>[97.421,-79.280,45.496,1],
77599=>[97.432,-79.283,45.483,1],
77600=>[97.443,-79.286,45.469,1],
77601=>[97.454,-79.288,45.455,1],
77602=>[97.465,-79.291,45.441,1],
77603=>[97.476,-79.294,45.427,1],
77604=>[97.490,-79.300,45.414,1],
77605=>[97.504,-79.306,45.400,1],
77606=>[97.517,-79.312,45.387,1],
77607=>[97.535,-79.324,45.373,1],
77608=>[97.554,-79.338,45.358,1],
77609=>[97.573,-79.352,45.344,1],
77610=>[97.592,-79.366,45.330,1],
77611=>[97.610,-79.380,45.317,1],
77612=>[97.630,-79.393,45.303,1],
77613=>[97.648,-79.400,45.288,1],
77614=>[97.661,-79.407,45.275,1],
77615=>[97.667,-79.413,45.264,1],
77616=>[97.672,-79.419,45.256,1],
77617=>[97.678,-79.424,45.247,1],
77618=>[97.684,-79.430,45.239,1],
77619=>[97.690,-79.436,45.229,1],
77620=>[97.696,-79.442,45.219,1],
77621=>[97.707,-79.457,45.209,1],
77622=>[97.723,-79.488,45.198,1],
77623=>[97.739,-79.520,45.187,1],
77624=>[97.754,-79.540,45.176,1],
77625=>[97.767,-79.547,45.168,1],
77626=>[97.780,-79.554,45.155,1],
77627=>[97.793,-79.562,45.142,1],
77628=>[97.807,-79.573,45.129,1],
77629=>[97.821,-79.585,45.115,1],
77630=>[97.836,-79.597,45.102,1],
77631=>[97.851,-79.608,45.092,1],
77632=>[97.865,-79.620,45.087,1],
77633=>[97.879,-79.632,45.081,1],
77634=>[97.898,-79.644,45.074,1],
77635=>[97.919,-79.656,45.065,1],
77636=>[97.940,-79.667,45.057,1],
77637=>[97.956,-79.675,45.049,1],
77638=>[97.968,-79.679,45.041,1],
77639=>[97.981,-79.684,45.033,1],
77640=>[98.000,-79.693,45.023,1],
77641=>[98.035,-79.711,45.013,1],
77642=>[98.074,-79.732,45.005,1],
77643=>[98.112,-79.752,44.997,1],
77644=>[98.143,-79.767,44.989,1],
77645=>[98.166,-79.780,44.980,1],
77646=>[98.190,-79.789,44.970,1],
77647=>[98.215,-79.793,44.960,1],
77648=>[98.241,-79.798,44.949,1],
77649=>[98.266,-79.802,44.937,1],
77650=>[98.291,-79.806,44.923,1],
77651=>[98.316,-79.811,44.910,1],
77652=>[98.342,-79.815,44.898,1],
77653=>[98.367,-79.819,44.887,1],
77654=>[98.392,-79.825,44.880,1],
77655=>[98.427,-79.835,44.871,1],
77656=>[98.460,-79.843,44.862,1],
77657=>[98.492,-79.850,44.851,1],
77658=>[98.523,-79.858,44.841,1],
77659=>[98.555,-79.864,44.832,1],
77660=>[98.586,-79.872,44.824,1],
77661=>[98.618,-79.879,44.816,1],
77662=>[98.650,-79.886,44.809,1],
77663=>[98.675,-79.895,44.802,1],
77664=>[98.700,-79.903,44.794,1],
77665=>[98.724,-79.912,44.785,1],
77666=>[98.749,-79.921,44.777,1],
77667=>[98.773,-79.930,44.770,1],
77668=>[98.798,-79.938,44.764,1],
77669=>[98.822,-79.947,44.757,1],
77670=>[98.847,-79.955,44.749,1],
77671=>[98.870,-79.956,44.740,1],
77672=>[98.892,-79.952,44.731,1],
77673=>[98.914,-79.947,44.724,1],
77674=>[98.935,-79.943,44.717,1],
77675=>[98.956,-79.942,44.711,1],
77676=>[98.966,-79.930,44.705,1],
77677=>[98.985,-79.943,44.700,1],
77678=>[99.005,-79.960,44.694,1],
77679=>[99.024,-79.977,44.688,1],
77680=>[99.044,-79.994,44.682,1],
77681=>[99.063,-80.012,44.677,1],
77682=>[99.082,-80.028,44.672,1],
77683=>[99.101,-80.046,44.667,1],
77684=>[99.121,-80.062,44.663,1],
77685=>[99.147,-80.077,44.657,1],
77686=>[99.211,-80.102,44.652,1],
77687=>[99.248,-80.121,44.646,1],
77688=>[99.255,-80.126,44.640,1],
77689=>[99.267,-80.126,44.635,1],
77690=>[99.297,-80.150,44.631,1],
77691=>[99.337,-80.151,44.628,1],
77692=>[99.373,-80.151,44.623,1],
77693=>[99.412,-80.155,44.617,1],
77694=>[99.451,-80.159,44.613,1],
77695=>[99.489,-80.162,44.608,1],
77696=>[99.528,-80.166,44.602,1],
77697=>[99.533,-80.187,44.597,1],
77698=>[99.536,-80.209,44.592,1],
77699=>[99.540,-80.231,44.586,1],
77700=>[99.543,-80.254,44.581,1],
77701=>[99.546,-80.276,44.575,1],
77702=>[99.549,-80.298,44.567,1],
77703=>[99.552,-80.320,44.561,1],
77704=>[99.556,-80.343,44.555,1],
77705=>[99.559,-80.365,44.548,1],
77706=>[99.562,-80.387,44.540,1],
77707=>[99.565,-80.409,44.533,1],
77708=>[99.568,-80.431,44.527,1],
77709=>[99.572,-80.453,44.519,1],
77710=>[99.575,-80.475,44.510,1],
77711=>[99.578,-80.497,44.503,1],
77712=>[99.581,-80.519,44.495,1],
77713=>[99.584,-80.542,44.487,1],
77714=>[99.588,-80.564,44.478,1],
77715=>[99.591,-80.586,44.469,1],
77716=>[99.594,-80.608,44.460,1],
77717=>[99.597,-80.630,44.451,1],
77718=>[99.600,-80.653,44.441,1],
77719=>[99.609,-80.673,44.431,1],
77720=>[99.657,-80.679,44.421,1],
77721=>[99.705,-80.684,44.411,1],
77722=>[99.753,-80.690,44.402,1],
77723=>[99.800,-80.695,44.390,1],
77724=>[99.849,-80.701,44.379,1],
77725=>[99.897,-80.707,44.367,1],
77726=>[99.944,-80.712,44.356,1],
77727=>[99.992,-80.718,44.346,1],
77728=>[100.040,-80.723,44.335,1],
78022=>[93.545,-78.871,53.545,1],
78023=>[93.554,-78.868,53.536,1],
78024=>[93.564,-78.866,53.527,1],
78025=>[93.573,-78.864,53.518,1],
78026=>[93.583,-78.861,53.509,1],
78027=>[93.593,-78.858,53.501,1],
78028=>[93.603,-78.855,53.494,1],
78029=>[93.613,-78.847,53.488,1],
78030=>[93.621,-78.840,53.481,1],
78031=>[93.629,-78.833,53.478,1],
78032=>[93.686,-78.805,53.477,1],
78033=>[93.676,-78.801,53.478,1],
78034=>[93.675,-78.799,53.478,1],
78035=>[93.674,-78.797,53.477,1],
78036=>[93.678,-78.795,53.474,1],
78037=>[93.683,-78.790,53.468,1],
78038=>[93.690,-78.787,53.461,1],
78039=>[93.697,-78.786,53.453,1],
78040=>[93.703,-78.786,53.443,1],
78041=>[93.710,-78.785,53.432,1],
78042=>[93.717,-78.782,53.421,1],
78043=>[93.724,-78.780,53.410,1],
78044=>[93.731,-78.777,53.397,1],
78045=>[93.753,-78.765,53.382,1],
78046=>[93.777,-78.751,53.366,1],
78047=>[93.802,-78.737,53.349,1],
78048=>[93.808,-78.728,53.331,1],
78049=>[93.812,-78.720,53.313,1],
78050=>[93.815,-78.711,53.295,1],
78051=>[93.819,-78.702,53.274,1],
78052=>[93.822,-78.694,53.254,1],
78053=>[93.835,-78.686,53.233,1],
78054=>[93.849,-78.678,53.212,1],
78055=>[93.863,-78.670,53.192,1],
78056=>[93.877,-78.662,53.172,1],
78057=>[93.891,-78.654,53.150,1],
78058=>[93.905,-78.646,53.126,1],
78059=>[93.919,-78.638,53.101,1],
78060=>[93.933,-78.630,53.075,1],
78061=>[93.945,-78.619,53.048,1],
78062=>[93.956,-78.625,53.021,1],
78063=>[93.966,-78.624,52.995,1],
78064=>[93.976,-78.623,52.970,1],
78065=>[93.986,-78.621,52.946,1],
78066=>[93.996,-78.620,52.923,1],
78067=>[94.006,-78.617,52.900,1],
78068=>[94.016,-78.616,52.881,1],
78069=>[94.026,-78.614,52.862,1],
78070=>[94.036,-78.613,52.843,1],
78071=>[94.046,-78.611,52.824,1],
78072=>[94.055,-78.610,52.802,1],
78073=>[94.065,-78.608,52.778,1],
78074=>[94.075,-78.606,52.754,1],
78075=>[94.075,-78.611,52.731,1],
78076=>[94.073,-78.616,52.708,1],
78077=>[94.081,-78.567,52.685,1],
78078=>[94.115,-78.522,52.661,1],
78079=>[94.176,-78.524,52.636,1],
78080=>[94.235,-78.527,52.610,1],
78081=>[94.287,-78.541,52.586,1],
78082=>[94.339,-78.554,52.565,1],
78083=>[94.373,-78.561,52.544,1],
78084=>[94.379,-78.562,52.525,1],
78085=>[94.371,-78.574,52.506,1],
78086=>[94.363,-78.586,52.485,1],
78087=>[94.356,-78.598,52.463,1],
78088=>[94.348,-78.611,52.441,1],
78089=>[94.340,-78.623,52.419,1],
78090=>[94.333,-78.634,52.397,1],
78091=>[94.325,-78.646,52.374,1],
78092=>[94.318,-78.658,52.355,1],
78093=>[94.322,-78.658,52.332,1],
78094=>[94.339,-78.645,52.308,1],
78095=>[94.355,-78.633,52.282,1],
78096=>[94.371,-78.620,52.256,1],
78097=>[94.388,-78.608,52.231,1],
78098=>[94.404,-78.596,52.207,1],
78099=>[94.415,-78.590,52.179,1],
78100=>[94.424,-78.588,52.150,1],
78101=>[94.432,-78.586,52.118,1],
78102=>[94.447,-78.585,52.083,1],
78103=>[94.465,-78.586,52.049,1],
78104=>[94.483,-78.586,52.015,1],
78105=>[94.497,-78.589,51.982,1],
78106=>[94.508,-78.618,51.946,1],
78107=>[94.519,-78.651,51.909,1],
78108=>[94.529,-78.685,51.872,1],
78109=>[94.541,-78.706,51.839,1],
78110=>[94.553,-78.702,51.801,1],
78111=>[94.564,-78.698,51.761,1],
78112=>[94.576,-78.695,51.720,1],
78113=>[94.588,-78.691,51.681,1],
78114=>[94.600,-78.687,51.641,1],
78115=>[94.612,-78.683,51.602,1],
78116=>[94.624,-78.680,51.566,1],
78117=>[94.635,-78.676,51.532,1],
78118=>[94.647,-78.672,51.498,1],
78119=>[94.659,-78.668,51.465,1],
78120=>[94.671,-78.664,51.432,1],
78121=>[94.683,-78.660,51.399,1],
78122=>[94.694,-78.656,51.366,1],
78123=>[94.705,-78.657,51.331,1],
78124=>[94.716,-78.659,51.295,1],
78125=>[94.727,-78.661,51.258,1],
78126=>[94.745,-78.664,51.221,1],
78127=>[94.764,-78.668,51.183,1],
78128=>[94.782,-78.672,51.145,1],
78129=>[94.792,-78.678,51.105,1],
78130=>[94.798,-78.686,51.066,1],
78131=>[94.804,-78.693,51.026,1],
78132=>[94.810,-78.701,50.986,1],
78133=>[94.815,-78.706,50.944,1],
78134=>[94.825,-78.693,50.903,1],
78135=>[94.834,-78.680,50.861,1],
78136=>[94.843,-78.667,50.818,1],
78137=>[94.852,-78.655,50.773,1],
78138=>[94.861,-78.642,50.728,1],
78139=>[94.871,-78.629,50.684,1],
78140=>[94.879,-78.619,50.642,1],
78141=>[94.886,-78.616,50.597,1],
78142=>[94.893,-78.612,50.550,1],
78143=>[94.899,-78.622,50.503,1],
78144=>[94.906,-78.631,50.455,1],
78145=>[94.911,-78.642,50.409,1],
78146=>[94.913,-78.656,50.364,1],
78147=>[94.915,-78.670,50.324,1],
78148=>[94.917,-78.684,50.285,1],
78149=>[94.918,-78.698,50.246,1],
78150=>[94.920,-78.713,50.205,1],
78151=>[94.922,-78.727,50.164,1],
78152=>[94.924,-78.741,50.121,1],
78153=>[94.926,-78.755,50.078,1],
78154=>[94.933,-78.765,50.032,1],
78155=>[94.948,-78.769,49.988,1],
78156=>[94.962,-78.774,49.945,1],
78157=>[94.977,-78.778,49.902,1],
78158=>[94.992,-78.783,49.860,1],
78159=>[95.010,-78.786,49.819,1],
78160=>[95.039,-78.782,49.779,1],
78161=>[95.069,-78.778,49.739,1],
78162=>[95.099,-78.775,49.700,1],
78163=>[95.129,-78.771,49.662,1],
78164=>[95.159,-78.767,49.624,1],
78165=>[95.189,-78.764,49.586,1],
78166=>[95.218,-78.760,49.546,1],
78167=>[95.215,-78.761,49.505,1],
78168=>[95.244,-78.780,49.465,1],
78169=>[95.273,-78.800,49.424,1],
78170=>[95.293,-78.812,49.384,1],
78171=>[95.313,-78.824,49.343,1],
78172=>[95.332,-78.836,49.303,1],
78173=>[95.351,-78.848,49.263,1],
78174=>[95.371,-78.859,49.223,1],
78175=>[95.391,-78.871,49.185,1],
78176=>[95.409,-78.881,49.146,1],
78177=>[95.423,-78.879,49.106,1],
78178=>[95.438,-78.877,49.066,1],
78179=>[95.451,-78.874,49.025,1],
78180=>[95.465,-78.872,48.986,1],
78181=>[95.479,-78.870,48.946,1],
78182=>[95.493,-78.868,48.905,1],
78183=>[95.507,-78.865,48.864,1],
78184=>[95.521,-78.863,48.823,1],
78185=>[95.529,-78.855,48.781,1],
78186=>[95.545,-78.852,48.739,1],
78187=>[95.551,-78.863,48.698,1],
78188=>[95.562,-78.875,48.657,1],
78189=>[95.576,-78.888,48.614,1],
78190=>[95.590,-78.902,48.572,1],
78191=>[95.604,-78.915,48.530,1],
78192=>[95.617,-78.928,48.488,1],
78193=>[95.631,-78.942,48.445,1],
78194=>[95.645,-78.955,48.401,1],
78195=>[95.659,-78.968,48.357,1],
78196=>[95.673,-78.981,48.310,1],
78197=>[95.687,-78.995,48.265,1],
78198=>[95.701,-79.008,48.222,1],
78199=>[95.715,-79.021,48.181,1],
78200=>[95.730,-79.031,48.140,1],
78201=>[95.747,-79.034,48.097,1],
78202=>[95.764,-79.038,48.054,1],
78203=>[95.780,-79.042,48.013,1],
78204=>[95.796,-79.044,47.970,1],
78205=>[95.805,-79.040,47.928,1],
78206=>[95.814,-79.037,47.884,1],
78207=>[95.823,-79.033,47.842,1],
78208=>[95.832,-79.029,47.800,1],
78209=>[95.841,-79.025,47.757,1],
78210=>[95.849,-79.021,47.714,1],
78211=>[95.855,-79.018,47.672,1],
78212=>[95.862,-79.014,47.628,1],
78213=>[95.869,-79.010,47.586,1],
78214=>[95.897,-79.006,47.545,1],
78215=>[95.933,-79.002,47.504,1],
78216=>[95.970,-78.999,47.465,1],
78217=>[96.005,-78.995,47.425,1],
78218=>[96.028,-78.989,47.385,1],
78219=>[96.051,-78.983,47.345,1],
78220=>[96.075,-78.976,47.307,1],
78221=>[96.098,-78.970,47.268,1],
78222=>[96.129,-78.968,47.231,1],
78223=>[96.169,-78.969,47.193,1],
78224=>[96.209,-78.971,47.157,1],
78225=>[96.249,-78.972,47.120,1],
78226=>[96.289,-78.974,47.085,1],
78227=>[96.329,-78.975,47.050,1],
78228=>[96.369,-78.977,47.018,1],
78229=>[96.404,-78.971,46.988,1],
78230=>[96.416,-78.971,46.957,1],
78231=>[96.422,-78.979,46.926,1],
78232=>[96.441,-78.989,46.896,1],
78233=>[96.460,-78.998,46.865,1],
78234=>[96.478,-79.008,46.835,1],
78235=>[96.497,-79.018,46.804,1],
78236=>[96.516,-79.027,46.773,1],
78237=>[96.534,-79.037,46.741,1],
78238=>[96.553,-79.046,46.709,1],
78239=>[96.572,-79.056,46.677,1],
78240=>[96.590,-79.065,46.645,1],
78241=>[96.605,-79.072,46.614,1],
78242=>[96.620,-79.079,46.583,1],
78243=>[96.668,-79.081,46.552,1],
78244=>[96.717,-79.083,46.522,1],
78245=>[96.756,-79.081,46.494,1],
78246=>[96.785,-79.072,46.466,1],
78247=>[96.814,-79.065,46.438,1],
78248=>[96.826,-79.050,46.412,1],
78249=>[96.879,-79.011,46.386,1],
78250=>[96.911,-78.963,46.361,1],
78251=>[96.937,-78.947,46.336,1],
78252=>[96.957,-78.963,46.311,1],
78253=>[96.946,-78.985,46.287,1],
78254=>[96.924,-78.996,46.263,1],
78255=>[96.934,-78.953,46.242,1],
78256=>[96.945,-78.927,46.221,1],
78257=>[96.956,-78.905,46.201,1],
78258=>[96.965,-78.924,46.181,1],
78259=>[96.974,-78.942,46.161,1],
78260=>[96.982,-78.967,46.141,1],
78261=>[96.990,-78.996,46.120,1],
78262=>[96.990,-79.002,46.101,1],
78263=>[96.974,-78.964,46.083,1],
78264=>[96.970,-78.967,46.065,1],
78265=>[96.945,-79.078,46.046,1],
78266=>[97.004,-79.047,46.028,1],
78267=>[97.019,-79.192,46.009,1],
78268=>[97.037,-79.231,45.992,1],
78269=>[97.056,-79.269,45.976,1],
78270=>[97.065,-79.270,45.959,1],
78271=>[97.071,-79.262,45.941,1],
78272=>[97.077,-79.253,45.924,1],
78273=>[97.087,-79.242,45.907,1],
78274=>[97.097,-79.230,45.890,1],
78275=>[97.102,-79.207,45.871,1],
78276=>[97.106,-79.185,45.855,1],
78277=>[97.111,-79.162,45.839,1],
78278=>[97.115,-79.140,45.823,1],
78279=>[97.124,-79.109,45.807,1],
78280=>[97.133,-79.078,45.791,1],
78281=>[97.149,-79.079,45.774,1],
78282=>[97.188,-79.102,45.757,1],
78283=>[97.227,-79.125,45.741,1],
78284=>[97.265,-79.147,45.726,1],
78285=>[97.297,-79.143,45.710,1],
78286=>[97.328,-79.138,45.696,1],
78287=>[97.346,-79.144,45.680,1],
78288=>[97.353,-79.158,45.664,1],
78289=>[97.359,-79.172,45.650,1],
78290=>[97.366,-79.186,45.637,1],
78291=>[97.372,-79.200,45.625,1],
78292=>[97.379,-79.214,45.613,1],
78293=>[97.385,-79.228,45.600,1],
78294=>[97.388,-79.244,45.586,1],
78295=>[97.393,-79.253,45.571,1],
78296=>[97.399,-79.259,45.555,1],
78297=>[97.406,-79.266,45.540,1],
78298=>[97.414,-79.272,45.527,1],
78299=>[97.425,-79.275,45.515,1],
78300=>[97.436,-79.278,45.502,1],
78301=>[97.447,-79.280,45.489,1],
78302=>[97.457,-79.283,45.475,1],
78303=>[97.468,-79.285,45.460,1],
78304=>[97.479,-79.288,45.446,1],
78305=>[97.491,-79.291,45.433,1],
78306=>[97.504,-79.296,45.419,1],
78307=>[97.517,-79.302,45.405,1],
78308=>[97.532,-79.310,45.390,1],
78309=>[97.551,-79.325,45.374,1],
78310=>[97.571,-79.338,45.359,1],
78311=>[97.589,-79.353,45.346,1],
78312=>[97.608,-79.363,45.333,1],
78313=>[97.627,-79.370,45.317,1],
78314=>[97.646,-79.378,45.301,1],
78315=>[97.664,-79.385,45.287,1],
78316=>[97.677,-79.391,45.277,1],
78317=>[97.683,-79.397,45.268,1],
78318=>[97.689,-79.404,45.260,1],
78319=>[97.695,-79.410,45.252,1],
78320=>[97.703,-79.418,45.243,1],
78321=>[97.714,-79.433,45.233,1],
78322=>[97.725,-79.448,45.221,1],
78323=>[97.736,-79.463,45.211,1],
78324=>[97.749,-79.486,45.200,1],
78325=>[97.766,-79.515,45.191,1],
78326=>[97.778,-79.523,45.182,1],
78327=>[97.791,-79.531,45.171,1],
78328=>[97.806,-79.542,45.156,1],
78329=>[97.820,-79.554,45.140,1],
78330=>[97.835,-79.566,45.125,1],
78331=>[97.849,-79.577,45.112,1],
78332=>[97.864,-79.589,45.103,1],
78333=>[97.878,-79.601,45.099,1],
78334=>[97.892,-79.613,45.095,1],
78335=>[97.909,-79.625,45.089,1],
78336=>[97.930,-79.636,45.081,1],
78337=>[97.950,-79.647,45.074,1],
78338=>[97.973,-79.657,45.065,1],
78339=>[97.992,-79.667,45.056,1],
78340=>[98.012,-79.676,45.046,1],
78341=>[98.031,-79.686,45.037,1],
78342=>[98.051,-79.695,45.028,1],
78343=>[98.082,-79.711,45.020,1],
78344=>[98.121,-79.732,45.012,1],
78345=>[98.154,-79.749,45.003,1],
78346=>[98.177,-79.761,44.993,1],
78347=>[98.202,-79.767,44.981,1],
78348=>[98.227,-79.770,44.972,1],
78349=>[98.252,-79.775,44.960,1],
78350=>[98.278,-79.780,44.948,1],
78351=>[98.303,-79.783,44.935,1],
78352=>[98.329,-79.788,44.922,1],
78353=>[98.354,-79.792,44.908,1],
78354=>[98.379,-79.796,44.898,1],
78355=>[98.405,-79.802,44.890,1],
78356=>[98.435,-79.811,44.882,1],
78357=>[98.468,-79.820,44.871,1],
78358=>[98.501,-79.830,44.860,1],
78359=>[98.533,-79.839,44.849,1],
78360=>[98.566,-79.848,44.840,1],
78361=>[98.598,-79.857,44.832,1],
78362=>[98.631,-79.867,44.825,1],
78363=>[98.662,-79.874,44.818,1],
78364=>[98.679,-79.872,44.811,1],
78365=>[98.700,-79.880,44.803,1],
78366=>[98.721,-79.887,44.795,1],
78367=>[98.743,-79.896,44.788,1],
78368=>[98.768,-79.904,44.781,1],
78369=>[98.793,-79.913,44.774,1],
78370=>[98.817,-79.921,44.768,1],
78371=>[98.842,-79.930,44.760,1],
78372=>[98.865,-79.931,44.751,1],
78373=>[98.887,-79.927,44.743,1],
78374=>[98.909,-79.922,44.736,1],
78375=>[98.932,-79.918,44.730,1],
78376=>[98.957,-79.919,44.724,1],
78377=>[98.973,-79.914,44.718,1],
78378=>[98.992,-79.926,44.713,1],
78379=>[99.011,-79.943,44.707,1],
78380=>[99.030,-79.960,44.701,1],
78381=>[99.050,-79.977,44.696,1],
78382=>[99.069,-79.994,44.691,1],
78383=>[99.089,-80.011,44.686,1],
78384=>[99.108,-80.028,44.681,1],
78385=>[99.128,-80.045,44.675,1],
78386=>[99.157,-80.059,44.669,1],
78387=>[99.189,-80.071,44.664,1],
78388=>[99.243,-80.093,44.658,1],
78389=>[99.272,-80.109,44.653,1],
78390=>[99.277,-80.118,44.650,1],
78391=>[99.305,-80.127,44.647,1],
78392=>[99.353,-80.137,44.644,1],
78393=>[99.396,-80.142,44.639,1],
78394=>[99.425,-80.128,44.634,1],
78395=>[99.462,-80.128,44.631,1],
78396=>[99.500,-80.132,44.626,1],
78397=>[99.526,-80.143,44.620,1],
78398=>[99.529,-80.165,44.612,1],
78399=>[99.533,-80.187,44.604,1],
78400=>[99.536,-80.209,44.597,1],
78401=>[99.539,-80.231,44.590,1],
78402=>[99.543,-80.253,44.583,1],
78403=>[99.546,-80.275,44.575,1],
78404=>[99.549,-80.297,44.568,1],
78405=>[99.552,-80.319,44.562,1],
78406=>[99.555,-80.342,44.555,1],
78407=>[99.559,-80.364,44.547,1],
78408=>[99.562,-80.386,44.539,1],
78409=>[99.565,-80.408,44.533,1],
78410=>[99.568,-80.431,44.524,1],
78411=>[99.571,-80.453,44.516,1],
78412=>[99.575,-80.475,44.509,1],
78413=>[99.578,-80.497,44.501,1],
78414=>[99.581,-80.519,44.492,1],
78415=>[99.584,-80.541,44.484,1],
78416=>[99.587,-80.563,44.475,1],
78417=>[99.591,-80.585,44.466,1],
78418=>[99.594,-80.607,44.457,1],
78419=>[99.597,-80.630,44.446,1],
78420=>[99.617,-80.646,44.436,1],
78421=>[99.665,-80.651,44.427,1],
78422=>[99.713,-80.657,44.417,1],
78423=>[99.761,-80.663,44.406,1],
78424=>[99.809,-80.668,44.394,1],
78425=>[99.857,-80.674,44.383,1],
78426=>[99.905,-80.679,44.372,1],
78427=>[99.952,-80.685,44.361,1],
78428=>[100.001,-80.691,44.350,1],
78429=>[100.049,-80.696,44.339,1],
78430=>[100.097,-80.701,44.328,1],
78724=>[93.554,-78.858,53.546,1],
78725=>[93.564,-78.855,53.537,1],
78726=>[93.574,-78.852,53.528,1],
78727=>[93.583,-78.850,53.520,1],
78728=>[93.593,-78.848,53.512,1],
78729=>[93.603,-78.846,53.504,1],
78730=>[93.613,-78.841,53.499,1],
78731=>[93.622,-78.833,53.493,1],
78732=>[93.630,-78.827,53.490,1],
78733=>[93.674,-78.804,53.490,1],
78734=>[93.664,-78.799,53.492,1],
78735=>[93.665,-78.796,53.491,1],
78736=>[93.670,-78.794,53.490,1],
78737=>[93.675,-78.791,53.487,1],
78738=>[93.680,-78.786,53.482,1],
78739=>[93.686,-78.782,53.475,1],
78740=>[93.692,-78.779,53.467,1],
78741=>[93.699,-78.779,53.457,1],
78742=>[93.706,-78.777,53.446,1],
78743=>[93.713,-78.775,53.435,1],
78744=>[93.720,-78.772,53.423,1],
78745=>[93.739,-78.762,53.409,1],
78746=>[93.764,-78.748,53.393,1],
78747=>[93.788,-78.734,53.377,1],
78748=>[93.806,-78.722,53.360,1],
78749=>[93.809,-78.714,53.342,1],
78750=>[93.813,-78.705,53.324,1],
78751=>[93.816,-78.697,53.306,1],
78752=>[93.820,-78.688,53.285,1],
78753=>[93.823,-78.680,53.263,1],
78754=>[93.834,-78.671,53.242,1],
78755=>[93.848,-78.664,53.221,1],
78756=>[93.862,-78.655,53.200,1],
78757=>[93.876,-78.648,53.180,1],
78758=>[93.890,-78.639,53.159,1],
78759=>[93.904,-78.632,53.135,1],
78760=>[93.918,-78.622,53.110,1],
78761=>[93.930,-78.609,53.083,1],
78762=>[93.943,-78.596,53.056,1],
78763=>[93.954,-78.601,53.029,1],
78764=>[93.965,-78.608,53.003,1],
78765=>[93.975,-78.614,52.979,1],
78766=>[93.985,-78.613,52.956,1],
78767=>[93.995,-78.611,52.933,1],
78768=>[94.005,-78.610,52.911,1],
78769=>[94.015,-78.608,52.892,1],
78770=>[94.025,-78.607,52.874,1],
78771=>[94.035,-78.604,52.855,1],
78772=>[94.045,-78.603,52.837,1],
78773=>[94.055,-78.601,52.815,1],
78774=>[94.065,-78.600,52.791,1],
78775=>[94.073,-78.599,52.766,1],
78776=>[94.072,-78.606,52.743,1],
78777=>[94.065,-78.582,52.720,1],
78778=>[94.085,-78.529,52.696,1],
78779=>[94.140,-78.520,52.672,1],
78780=>[94.201,-78.523,52.647,1],
78781=>[94.262,-78.525,52.622,1],
78782=>[94.323,-78.526,52.599,1],
78783=>[94.374,-78.539,52.579,1],
78784=>[94.393,-78.544,52.560,1],
78785=>[94.385,-78.556,52.541,1],
78786=>[94.378,-78.568,52.522,1],
78787=>[94.369,-78.580,52.502,1],
78788=>[94.362,-78.592,52.480,1],
78789=>[94.354,-78.604,52.458,1],
78790=>[94.347,-78.617,52.435,1],
78791=>[94.339,-78.629,52.414,1],
78792=>[94.331,-78.640,52.392,1],
78793=>[94.324,-78.652,52.372,1],
78794=>[94.324,-78.656,52.350,1],
78795=>[94.341,-78.644,52.325,1],
78796=>[94.357,-78.631,52.301,1],
78797=>[94.373,-78.619,52.276,1],
78798=>[94.390,-78.607,52.251,1],
78799=>[94.406,-78.594,52.227,1],
78800=>[94.422,-78.582,52.199,1],
78801=>[94.433,-78.576,52.169,1],
78802=>[94.442,-78.575,52.137,1],
78803=>[94.456,-78.574,52.102,1],
78804=>[94.474,-78.574,52.068,1],
78805=>[94.492,-78.575,52.034,1],
78806=>[94.506,-78.580,51.998,1],
78807=>[94.515,-78.611,51.961,1],
78808=>[94.524,-78.642,51.924,1],
78809=>[94.533,-78.673,51.886,1],
78810=>[94.542,-78.692,51.850,1],
78811=>[94.554,-78.692,51.813,1],
78812=>[94.566,-78.691,51.774,1],
78813=>[94.578,-78.689,51.733,1],
78814=>[94.590,-78.686,51.693,1],
78815=>[94.602,-78.682,51.654,1],
78816=>[94.614,-78.678,51.615,1],
78817=>[94.626,-78.674,51.578,1],
78818=>[94.637,-78.670,51.543,1],
78819=>[94.649,-78.667,51.509,1],
78820=>[94.661,-78.663,51.474,1],
78821=>[94.673,-78.659,51.440,1],
78822=>[94.685,-78.655,51.406,1],
78823=>[94.696,-78.651,51.372,1],
78824=>[94.708,-78.651,51.338,1],
78825=>[94.718,-78.653,51.302,1],
78826=>[94.733,-78.656,51.265,1],
78827=>[94.751,-78.659,51.227,1],
78828=>[94.770,-78.663,51.190,1],
78829=>[94.789,-78.667,51.151,1],
78830=>[94.802,-78.672,51.111,1],
78831=>[94.808,-78.680,51.073,1],
78832=>[94.814,-78.687,51.034,1],
78833=>[94.819,-78.694,50.993,1],
78834=>[94.826,-78.696,50.953,1],
78835=>[94.835,-78.683,50.911,1],
78836=>[94.844,-78.670,50.869,1],
78837=>[94.853,-78.658,50.827,1],
78838=>[94.862,-78.645,50.781,1],
78839=>[94.872,-78.632,50.735,1],
78840=>[94.881,-78.619,50.691,1],
78841=>[94.890,-78.606,50.647,1],
78842=>[94.899,-78.594,50.601,1],
78843=>[94.906,-78.596,50.554,1],
78844=>[94.913,-78.605,50.506,1],
78845=>[94.920,-78.615,50.458,1],
78846=>[94.927,-78.624,50.411,1],
78847=>[94.932,-78.635,50.366,1],
78848=>[94.934,-78.649,50.325,1],
78849=>[94.935,-78.664,50.284,1],
78850=>[94.937,-78.677,50.244,1],
78851=>[94.939,-78.692,50.202,1],
78852=>[94.941,-78.705,50.160,1],
78853=>[94.943,-78.720,50.118,1],
78854=>[94.945,-78.733,50.074,1],
78855=>[94.957,-78.740,50.030,1],
78856=>[94.972,-78.745,49.987,1],
78857=>[94.986,-78.749,49.944,1],
78858=>[95.001,-78.753,49.902,1],
78859=>[95.016,-78.758,49.860,1],
78860=>[95.031,-78.762,49.819,1],
78861=>[95.047,-78.766,49.779,1],
78862=>[95.077,-78.762,49.741,1],
78863=>[95.107,-78.758,49.702,1],
78864=>[95.137,-78.755,49.664,1],
78865=>[95.167,-78.751,49.627,1],
78866=>[95.196,-78.748,49.589,1],
78867=>[95.227,-78.744,49.549,1],
78868=>[95.207,-78.749,49.507,1],
78869=>[95.236,-78.769,49.466,1],
78870=>[95.265,-78.789,49.426,1],
78871=>[95.294,-78.808,49.386,1],
78872=>[95.313,-78.820,49.345,1],
78873=>[95.332,-78.831,49.306,1],
78874=>[95.352,-78.843,49.267,1],
78875=>[95.371,-78.855,49.228,1],
78876=>[95.391,-78.866,49.189,1],
78877=>[95.410,-78.877,49.149,1],
78878=>[95.424,-78.875,49.109,1],
78879=>[95.438,-78.873,49.069,1],
78880=>[95.452,-78.871,49.029,1],
78881=>[95.466,-78.868,48.989,1],
78882=>[95.479,-78.866,48.949,1],
78883=>[95.493,-78.864,48.908,1],
78884=>[95.508,-78.861,48.867,1],
78885=>[95.516,-78.854,48.825,1],
78886=>[95.520,-78.843,48.783,1],
78887=>[95.535,-78.839,48.741,1],
78888=>[95.554,-78.843,48.699,1],
78889=>[95.559,-78.854,48.657,1],
78890=>[95.565,-78.864,48.615,1],
78891=>[95.573,-78.875,48.572,1],
78892=>[95.588,-78.889,48.530,1],
78893=>[95.601,-78.902,48.487,1],
78894=>[95.615,-78.915,48.443,1],
78895=>[95.629,-78.928,48.399,1],
78896=>[95.643,-78.942,48.355,1],
78897=>[95.657,-78.955,48.312,1],
78898=>[95.671,-78.968,48.270,1],
78899=>[95.685,-78.982,48.228,1],
78900=>[95.699,-78.995,48.188,1],
78901=>[95.714,-79.006,48.146,1],
78902=>[95.731,-79.009,48.105,1],
78903=>[95.747,-79.013,48.063,1],
78904=>[95.764,-79.017,48.021,1],
78905=>[95.781,-79.021,47.979,1],
78906=>[95.798,-79.024,47.935,1],
78907=>[95.815,-79.028,47.893,1],
78908=>[95.830,-79.031,47.850,1],
78909=>[95.839,-79.027,47.807,1],
78910=>[95.848,-79.023,47.764,1],
78911=>[95.858,-79.019,47.721,1],
78912=>[95.865,-79.015,47.679,1],
78913=>[95.872,-79.012,47.636,1],
78914=>[95.891,-79.009,47.595,1],
78915=>[95.927,-79.005,47.554,1],
78916=>[95.961,-79.000,47.513,1],
78917=>[95.984,-78.994,47.474,1],
78918=>[96.007,-78.987,47.433,1],
78919=>[96.030,-78.981,47.393,1],
78920=>[96.053,-78.975,47.354,1],
78921=>[96.077,-78.969,47.315,1],
78922=>[96.100,-78.963,47.277,1],
78923=>[96.129,-78.960,47.240,1],
78924=>[96.169,-78.962,47.201,1],
78925=>[96.209,-78.963,47.165,1],
78926=>[96.249,-78.965,47.129,1],
78927=>[96.289,-78.966,47.092,1],
78928=>[96.329,-78.968,47.058,1],
78929=>[96.365,-78.964,47.026,1],
78930=>[96.398,-78.956,46.995,1],
78931=>[96.424,-78.951,46.964,1],
78932=>[96.419,-78.957,46.933,1],
78933=>[96.416,-78.964,46.902,1],
78934=>[96.435,-78.974,46.872,1],
78935=>[96.454,-78.983,46.842,1],
78936=>[96.472,-78.993,46.812,1],
78937=>[96.491,-79.002,46.780,1],
78938=>[96.510,-79.012,46.749,1],
78939=>[96.528,-79.021,46.717,1],
78940=>[96.547,-79.031,46.685,1],
78941=>[96.562,-79.038,46.653,1],
78942=>[96.576,-79.045,46.621,1],
78943=>[96.601,-79.050,46.589,1],
78944=>[96.649,-79.052,46.558,1],
78945=>[96.697,-79.054,46.529,1],
78946=>[96.745,-79.056,46.500,1],
78947=>[96.778,-79.049,46.472,1],
78948=>[96.806,-79.042,46.444,1],
78949=>[96.844,-79.036,46.418,1],
78950=>[96.861,-78.990,46.392,1],
78951=>[96.892,-78.943,46.367,1],
78952=>[96.913,-78.956,46.342,1],
78953=>[96.933,-78.972,46.318,1],
78954=>[96.942,-78.990,46.294,1],
78955=>[96.939,-78.993,46.271,1],
78956=>[96.934,-78.929,46.251,1],
78957=>[96.945,-78.899,46.231,1],
78958=>[96.955,-78.895,46.212,1],
78959=>[96.963,-78.914,46.193,1],
78960=>[96.972,-78.932,46.173,1],
78961=>[96.980,-78.954,46.153,1],
78962=>[96.988,-78.983,46.131,1],
78963=>[96.979,-78.964,46.112,1],
78964=>[96.973,-78.959,46.093,1],
78965=>[96.973,-78.974,46.074,1],
78966=>[96.973,-78.990,46.056,1],
78967=>[96.997,-79.008,46.038,1],
78968=>[97.008,-79.155,46.020,1],
78969=>[97.027,-79.194,46.003,1],
78970=>[97.046,-79.233,45.987,1],
78971=>[97.065,-79.272,45.971,1],
78972=>[97.076,-79.281,45.955,1],
78973=>[97.082,-79.273,45.937,1],
78974=>[97.092,-79.263,45.919,1],
78975=>[97.099,-79.245,45.901,1],
78976=>[97.103,-79.223,45.883,1],
78977=>[97.108,-79.200,45.867,1],
78978=>[97.116,-79.171,45.852,1],
78979=>[97.125,-79.140,45.836,1],
78980=>[97.134,-79.109,45.820,1],
78981=>[97.143,-79.078,45.804,1],
78982=>[97.158,-79.081,45.788,1],
78983=>[97.186,-79.097,45.771,1],
78984=>[97.226,-79.120,45.756,1],
78985=>[97.264,-79.141,45.741,1],
78986=>[97.295,-79.136,45.726,1],
78987=>[97.323,-79.134,45.712,1],
78988=>[97.330,-79.147,45.697,1],
78989=>[97.336,-79.162,45.681,1],
78990=>[97.343,-79.175,45.666,1],
78991=>[97.350,-79.190,45.653,1],
78992=>[97.356,-79.203,45.639,1],
78993=>[97.363,-79.217,45.626,1],
78994=>[97.371,-79.231,45.616,1],
78995=>[97.384,-79.240,45.604,1],
78996=>[97.395,-79.248,45.590,1],
78997=>[97.402,-79.255,45.572,1],
78998=>[97.409,-79.261,45.557,1],
78999=>[97.417,-79.266,45.546,1],
79000=>[97.428,-79.269,45.536,1],
79001=>[97.439,-79.272,45.523,1],
79002=>[97.450,-79.275,45.509,1],
79003=>[97.461,-79.278,45.495,1],
79004=>[97.472,-79.280,45.481,1],
79005=>[97.483,-79.283,45.467,1],
79006=>[97.494,-79.285,45.452,1],
79007=>[97.505,-79.288,45.437,1],
79008=>[97.517,-79.292,45.422,1],
79009=>[97.530,-79.297,45.407,1],
79010=>[97.549,-79.311,45.393,1],
79011=>[97.568,-79.325,45.376,1],
79012=>[97.587,-79.334,45.361,1],
79013=>[97.606,-79.341,45.345,1],
79014=>[97.625,-79.348,45.328,1],
79015=>[97.643,-79.355,45.312,1],
79016=>[97.662,-79.363,45.299,1],
79017=>[97.681,-79.370,45.291,1],
79018=>[97.694,-79.376,45.282,1],
79019=>[97.700,-79.382,45.274,1],
79020=>[97.710,-79.395,45.266,1],
79021=>[97.721,-79.410,45.257,1],
79022=>[97.732,-79.426,45.247,1],
79023=>[97.743,-79.441,45.236,1],
79024=>[97.754,-79.456,45.224,1],
79025=>[97.766,-79.471,45.212,1],
79026=>[97.777,-79.486,45.202,1],
79027=>[97.790,-79.500,45.193,1],
79028=>[97.804,-79.513,45.177,1],
79029=>[97.817,-79.527,45.161,1],
79030=>[97.831,-79.541,45.145,1],
79031=>[97.845,-79.554,45.131,1],
79032=>[97.858,-79.569,45.118,1],
79033=>[97.871,-79.582,45.109,1],
79034=>[97.885,-79.596,45.104,1],
79035=>[97.897,-79.608,45.098,1],
79036=>[97.911,-79.620,45.092,1],
79037=>[97.931,-79.631,45.086,1],
79038=>[97.952,-79.642,45.079,1],
79039=>[97.975,-79.652,45.073,1],
79040=>[98.004,-79.661,45.066,1],
79041=>[98.032,-79.670,45.057,1],
79042=>[98.061,-79.679,45.049,1],
79043=>[98.083,-79.689,45.041,1],
79044=>[98.102,-79.698,45.033,1],
79045=>[98.129,-79.711,45.025,1],
79046=>[98.165,-79.730,45.016,1],
79047=>[98.189,-79.739,45.006,1],
79048=>[98.214,-79.744,44.995,1],
79049=>[98.239,-79.748,44.984,1],
79050=>[98.265,-79.752,44.972,1],
79051=>[98.290,-79.757,44.959,1],
79052=>[98.316,-79.763,44.946,1],
79053=>[98.343,-79.770,44.931,1],
79054=>[98.369,-79.776,44.918,1],
79055=>[98.395,-79.783,44.907,1],
79056=>[98.422,-79.789,44.899,1],
79057=>[98.449,-79.800,44.890,1],
79058=>[98.482,-79.809,44.879,1],
79059=>[98.515,-79.818,44.869,1],
79060=>[98.548,-79.828,44.858,1],
79061=>[98.580,-79.837,44.849,1],
79062=>[98.613,-79.846,44.841,1],
79063=>[98.646,-79.855,44.834,1],
79064=>[98.670,-79.858,44.827,1],
79065=>[98.685,-79.852,44.821,1],
79066=>[98.706,-79.858,44.812,1],
79067=>[98.727,-79.866,44.806,1],
79068=>[98.748,-79.874,44.799,1],
79069=>[98.769,-79.880,44.793,1],
79070=>[98.790,-79.888,44.785,1],
79071=>[98.812,-79.896,44.779,1],
79072=>[98.837,-79.905,44.772,1],
79073=>[98.860,-79.906,44.764,1],
79074=>[98.883,-79.904,44.757,1],
79075=>[98.908,-79.904,44.751,1],
79076=>[98.934,-79.905,44.744,1],
79077=>[98.959,-79.905,44.739,1],
79078=>[98.981,-79.904,44.734,1],
79079=>[98.998,-79.909,44.728,1],
79080=>[99.018,-79.926,44.721,1],
79081=>[99.038,-79.943,44.714,1],
79082=>[99.057,-79.960,44.708,1],
79083=>[99.076,-79.977,44.704,1],
79084=>[99.095,-79.994,44.699,1],
79085=>[99.115,-80.011,44.694,1],
79086=>[99.135,-80.027,44.689,1],
79087=>[99.167,-80.040,44.682,1],
79088=>[99.199,-80.052,44.676,1],
79089=>[99.231,-80.065,44.671,1],
79090=>[99.276,-80.083,44.667,1],
79091=>[99.296,-80.096,44.664,1],
79092=>[99.303,-80.098,44.661,1],
79093=>[99.349,-80.108,44.658,1],
79094=>[99.404,-80.122,44.654,1],
79095=>[99.454,-80.133,44.650,1],
79096=>[99.484,-80.119,44.647,1],
79097=>[99.513,-80.106,44.642,1],
79098=>[99.523,-80.120,44.635,1],
79099=>[99.526,-80.142,44.627,1],
79100=>[99.529,-80.164,44.617,1],
79101=>[99.533,-80.186,44.608,1],
79102=>[99.536,-80.208,44.599,1],
79103=>[99.539,-80.231,44.591,1],
79104=>[99.542,-80.253,44.583,1],
79105=>[99.545,-80.275,44.576,1],
79106=>[99.549,-80.297,44.569,1],
79107=>[99.552,-80.319,44.561,1],
79108=>[99.555,-80.341,44.554,1],
79109=>[99.558,-80.363,44.546,1],
79110=>[99.561,-80.385,44.539,1],
79111=>[99.565,-80.407,44.530,1],
79112=>[99.568,-80.430,44.521,1],
79113=>[99.571,-80.452,44.513,1],
79114=>[99.574,-80.474,44.506,1],
79115=>[99.577,-80.496,44.498,1],
79116=>[99.581,-80.519,44.489,1],
79117=>[99.584,-80.541,44.481,1],
79118=>[99.587,-80.563,44.471,1],
79119=>[99.590,-80.585,44.462,1],
79120=>[99.593,-80.607,44.451,1],
79121=>[99.625,-80.619,44.441,1],
79122=>[99.674,-80.624,44.431,1],
79123=>[99.721,-80.629,44.421,1],
79124=>[99.769,-80.635,44.410,1],
79125=>[99.817,-80.641,44.399,1],
79126=>[99.865,-80.647,44.387,1],
79127=>[99.913,-80.652,44.376,1],
79128=>[99.961,-80.657,44.365,1],
79129=>[100.009,-80.663,44.353,1],
79130=>[100.057,-80.669,44.342,1],
79131=>[100.105,-80.675,44.331,1],
79425=>[93.555,-78.846,53.555,1],
79426=>[93.564,-78.844,53.545,1],
79427=>[93.574,-78.842,53.537,1],
79428=>[93.584,-78.839,53.529,1],
79429=>[93.593,-78.836,53.521,1],
79430=>[93.603,-78.834,53.514,1],
79431=>[93.613,-78.832,53.510,1],
79432=>[93.623,-78.827,53.505,1],
79433=>[93.631,-78.820,53.502,1],
79434=>[93.662,-78.803,53.503,1],
79435=>[93.658,-78.796,53.505,1],
79436=>[93.662,-78.794,53.504,1],
79437=>[93.666,-78.791,53.502,1],
79438=>[93.672,-78.788,53.499,1],
79439=>[93.677,-78.783,53.495,1],
79440=>[93.683,-78.778,53.489,1],
79441=>[93.689,-78.774,53.481,1],
79442=>[93.695,-78.771,53.471,1],
79443=>[93.702,-78.771,53.460,1],
79444=>[93.709,-78.767,53.448,1],
79445=>[93.726,-78.759,53.435,1],
79446=>[93.751,-78.745,53.420,1],
79447=>[93.775,-78.731,53.404,1],
79448=>[93.800,-78.717,53.388,1],
79449=>[93.807,-78.708,53.370,1],
79450=>[93.811,-78.699,53.352,1],
79451=>[93.814,-78.691,53.333,1],
79452=>[93.818,-78.683,53.315,1],
79453=>[93.821,-78.673,53.294,1],
79454=>[93.824,-78.665,53.272,1],
79455=>[93.833,-78.657,53.251,1],
79456=>[93.847,-78.649,53.230,1],
79457=>[93.861,-78.641,53.209,1],
79458=>[93.875,-78.633,53.188,1],
79459=>[93.889,-78.625,53.167,1],
79460=>[93.903,-78.614,53.143,1],
79461=>[93.915,-78.601,53.118,1],
79462=>[93.928,-78.588,53.091,1],
79463=>[93.940,-78.575,53.064,1],
79464=>[93.952,-78.579,53.038,1],
79465=>[93.963,-78.585,53.013,1],
79466=>[93.973,-78.592,52.990,1],
79467=>[93.984,-78.598,52.967,1],
79468=>[93.994,-78.604,52.944,1],
79469=>[94.004,-78.601,52.923,1],
79470=>[94.014,-78.600,52.904,1],
79471=>[94.024,-78.598,52.886,1],
79472=>[94.034,-78.597,52.868,1],
79473=>[94.044,-78.595,52.848,1],
79474=>[94.054,-78.594,52.827,1],
79475=>[94.064,-78.592,52.804,1],
79476=>[94.070,-78.593,52.779,1],
79477=>[94.067,-78.590,52.755,1],
79478=>[94.062,-78.546,52.731,1],
79479=>[94.105,-78.517,52.707,1],
79480=>[94.166,-78.520,52.682,1],
79481=>[94.226,-78.521,52.658,1],
79482=>[94.287,-78.523,52.634,1],
79483=>[94.348,-78.526,52.612,1],
79484=>[94.400,-78.521,52.594,1],
79485=>[94.399,-78.539,52.575,1],
79486=>[94.391,-78.550,52.556,1],
79487=>[94.384,-78.562,52.538,1],
79488=>[94.376,-78.574,52.518,1],
79489=>[94.368,-78.586,52.496,1],
79490=>[94.360,-78.598,52.474,1],
79491=>[94.353,-78.611,52.451,1],
79492=>[94.345,-78.623,52.430,1],
79493=>[94.337,-78.635,52.409,1],
79494=>[94.330,-78.646,52.389,1],
79495=>[94.326,-78.655,52.366,1],
79496=>[94.343,-78.642,52.343,1],
79497=>[94.359,-78.630,52.319,1],
79498=>[94.376,-78.617,52.295,1],
79499=>[94.392,-78.604,52.271,1],
79500=>[94.408,-78.592,52.245,1],
79501=>[94.424,-78.580,52.217,1],
79502=>[94.441,-78.567,52.187,1],
79503=>[94.451,-78.564,52.155,1],
79504=>[94.465,-78.563,52.121,1],
79505=>[94.483,-78.563,52.086,1],
79506=>[94.495,-78.570,52.051,1],
79507=>[94.507,-78.578,52.014,1],
79508=>[94.518,-78.594,51.976,1],
79509=>[94.527,-78.624,51.937,1],
79510=>[94.536,-78.655,51.899,1],
79511=>[94.544,-78.673,51.862,1],
79512=>[94.555,-78.675,51.824,1],
79513=>[94.567,-78.674,51.786,1],
79514=>[94.579,-78.673,51.747,1],
79515=>[94.591,-78.673,51.708,1],
79516=>[94.604,-78.673,51.670,1],
79517=>[94.616,-78.672,51.631,1],
79518=>[94.628,-78.669,51.593,1],
79519=>[94.639,-78.665,51.557,1],
79520=>[94.651,-78.661,51.521,1],
79521=>[94.663,-78.658,51.486,1],
79522=>[94.675,-78.654,51.450,1],
79523=>[94.687,-78.650,51.414,1],
79524=>[94.698,-78.646,51.378,1],
79525=>[94.710,-78.645,51.344,1],
79526=>[94.720,-78.647,51.308,1],
79527=>[94.739,-78.651,51.271,1],
79528=>[94.758,-78.654,51.232,1],
79529=>[94.777,-78.658,51.194,1],
79530=>[94.795,-78.661,51.156,1],
79531=>[94.812,-78.665,51.116,1],
79532=>[94.818,-78.673,51.078,1],
79533=>[94.823,-78.680,51.039,1],
79534=>[94.829,-78.688,50.999,1],
79535=>[94.836,-78.686,50.959,1],
79536=>[94.845,-78.673,50.918,1],
79537=>[94.854,-78.661,50.876,1],
79538=>[94.864,-78.648,50.833,1],
79539=>[94.873,-78.635,50.787,1],
79540=>[94.882,-78.622,50.742,1],
79541=>[94.892,-78.609,50.697,1],
79542=>[94.901,-78.596,50.652,1],
79543=>[94.919,-78.587,50.606,1],
79544=>[94.929,-78.586,50.558,1],
79545=>[94.927,-78.589,50.510,1],
79546=>[94.934,-78.598,50.461,1],
79547=>[94.941,-78.608,50.413,1],
79548=>[94.948,-78.617,50.365,1],
79549=>[94.953,-78.628,50.322,1],
79550=>[94.955,-78.642,50.281,1],
79551=>[94.957,-78.656,50.240,1],
79552=>[94.958,-78.670,50.199,1],
79553=>[94.960,-78.684,50.157,1],
79554=>[94.962,-78.698,50.114,1],
79555=>[94.966,-78.711,50.071,1],
79556=>[94.981,-78.715,50.028,1],
79557=>[94.995,-78.720,49.985,1],
79558=>[95.011,-78.724,49.943,1],
79559=>[95.025,-78.728,49.900,1],
79560=>[95.040,-78.733,49.860,1],
79561=>[95.055,-78.737,49.820,1],
79562=>[95.069,-78.742,49.781,1],
79563=>[95.085,-78.745,49.744,1],
79564=>[95.115,-78.742,49.706,1],
79565=>[95.144,-78.739,49.668,1],
79566=>[95.175,-78.735,49.631,1],
79567=>[95.204,-78.731,49.592,1],
79568=>[95.226,-78.729,49.551,1],
79569=>[95.199,-78.738,49.510,1],
79570=>[95.228,-78.758,49.468,1],
79571=>[95.257,-78.777,49.428,1],
79572=>[95.286,-78.797,49.388,1],
79573=>[95.313,-78.815,49.348,1],
79574=>[95.332,-78.827,49.310,1],
79575=>[95.352,-78.838,49.272,1],
79576=>[95.372,-78.850,49.234,1],
79577=>[95.391,-78.861,49.194,1],
79578=>[95.410,-78.874,49.154,1],
79579=>[95.424,-78.871,49.114,1],
79580=>[95.438,-78.868,49.073,1],
79581=>[95.452,-78.866,49.034,1],
79582=>[95.466,-78.864,48.994,1],
79583=>[95.480,-78.861,48.953,1],
79584=>[95.494,-78.859,48.912,1],
79585=>[95.502,-78.852,48.870,1],
79586=>[95.507,-78.841,48.828,1],
79587=>[95.510,-78.830,48.786,1],
79588=>[95.525,-78.825,48.743,1],
79589=>[95.548,-78.827,48.700,1],
79590=>[95.562,-78.834,48.658,1],
79591=>[95.568,-78.844,48.616,1],
79592=>[95.574,-78.855,48.573,1],
79593=>[95.580,-78.865,48.530,1],
79594=>[95.586,-78.876,48.486,1],
79595=>[95.599,-78.889,48.443,1],
79596=>[95.613,-78.902,48.399,1],
79597=>[95.627,-78.915,48.356,1],
79598=>[95.641,-78.929,48.316,1],
79599=>[95.655,-78.942,48.276,1],
79600=>[95.669,-78.955,48.235,1],
79601=>[95.683,-78.968,48.194,1],
79602=>[95.697,-78.980,48.154,1],
79603=>[95.714,-78.984,48.113,1],
79604=>[95.731,-78.987,48.072,1],
79605=>[95.748,-78.991,48.030,1],
79606=>[95.765,-78.995,47.987,1],
79607=>[95.781,-78.999,47.943,1],
79608=>[95.799,-79.002,47.901,1],
79609=>[95.815,-79.006,47.858,1],
79610=>[95.832,-79.010,47.814,1],
79611=>[95.849,-79.014,47.772,1],
79612=>[95.866,-79.018,47.730,1],
79613=>[95.875,-79.014,47.687,1],
79614=>[95.886,-79.010,47.645,1],
79615=>[95.916,-79.006,47.605,1],
79616=>[95.940,-78.999,47.564,1],
79617=>[95.963,-78.993,47.523,1],
79618=>[95.986,-78.987,47.482,1],
79619=>[96.009,-78.981,47.442,1],
79620=>[96.032,-78.974,47.402,1],
79621=>[96.055,-78.968,47.362,1],
79622=>[96.079,-78.962,47.323,1],
79623=>[96.102,-78.956,47.285,1],
79624=>[96.129,-78.952,47.248,1],
79625=>[96.169,-78.953,47.209,1],
79626=>[96.209,-78.955,47.172,1],
79627=>[96.249,-78.956,47.136,1],
79628=>[96.289,-78.958,47.100,1],
79629=>[96.326,-78.956,47.066,1],
79630=>[96.359,-78.948,47.033,1],
79631=>[96.392,-78.940,47.003,1],
79632=>[96.425,-78.933,46.971,1],
79633=>[96.427,-78.937,46.939,1],
79634=>[96.422,-78.943,46.909,1],
79635=>[96.417,-78.949,46.879,1],
79636=>[96.429,-78.959,46.849,1],
79637=>[96.447,-78.968,46.819,1],
79638=>[96.466,-78.977,46.788,1],
79639=>[96.484,-78.987,46.757,1],
79640=>[96.503,-78.996,46.724,1],
79641=>[96.519,-79.004,46.692,1],
79642=>[96.533,-79.011,46.660,1],
79643=>[96.547,-79.018,46.627,1],
79644=>[96.582,-79.021,46.595,1],
79645=>[96.630,-79.024,46.564,1],
79646=>[96.678,-79.025,46.535,1],
79647=>[96.726,-79.028,46.506,1],
79648=>[96.773,-79.030,46.477,1],
79649=>[96.806,-79.049,46.450,1],
79650=>[96.825,-79.057,46.423,1],
79651=>[96.845,-78.996,46.397,1],
79652=>[96.871,-78.946,46.373,1],
79653=>[96.892,-78.961,46.349,1],
79654=>[96.912,-78.976,46.325,1],
79655=>[96.931,-78.986,46.302,1],
79656=>[96.937,-78.968,46.280,1],
79657=>[96.933,-78.905,46.260,1],
79658=>[96.944,-78.872,46.241,1],
79659=>[96.953,-78.885,46.223,1],
79660=>[96.961,-78.904,46.204,1],
79661=>[96.970,-78.923,46.185,1],
79662=>[96.979,-78.941,46.164,1],
79663=>[96.984,-78.965,46.142,1],
79664=>[96.976,-78.951,46.122,1],
79665=>[96.976,-78.967,46.103,1],
79666=>[96.976,-78.983,46.084,1],
79667=>[96.976,-78.999,46.066,1],
79668=>[96.974,-79.024,46.048,1],
79669=>[96.999,-79.103,46.031,1],
79670=>[97.017,-79.159,46.014,1],
79671=>[97.036,-79.197,45.997,1],
79672=>[97.055,-79.235,45.982,1],
79673=>[97.074,-79.274,45.968,1],
79674=>[97.088,-79.293,45.950,1],
79675=>[97.096,-79.283,45.932,1],
79676=>[97.101,-79.260,45.912,1],
79677=>[97.108,-79.232,45.895,1],
79678=>[97.117,-79.201,45.880,1],
79679=>[97.126,-79.170,45.865,1],
79680=>[97.136,-79.139,45.849,1],
79681=>[97.145,-79.109,45.833,1],
79682=>[97.154,-79.078,45.818,1],
79683=>[97.168,-79.084,45.803,1],
79684=>[97.185,-79.093,45.786,1],
79685=>[97.224,-79.115,45.770,1],
79686=>[97.262,-79.134,45.755,1],
79687=>[97.293,-79.129,45.741,1],
79688=>[97.307,-79.137,45.727,1],
79689=>[97.314,-79.151,45.713,1],
79690=>[97.320,-79.165,45.698,1],
79691=>[97.327,-79.179,45.684,1],
79692=>[97.333,-79.193,45.669,1],
79693=>[97.343,-79.205,45.656,1],
79694=>[97.357,-79.215,45.643,1],
79695=>[97.371,-79.224,45.630,1],
79696=>[97.385,-79.234,45.617,1],
79697=>[97.398,-79.244,45.603,1],
79698=>[97.405,-79.250,45.587,1],
79699=>[97.412,-79.256,45.572,1],
79700=>[97.421,-79.261,45.559,1],
79701=>[97.432,-79.263,45.547,1],
79702=>[97.443,-79.266,45.534,1],
79703=>[97.454,-79.269,45.521,1],
79704=>[97.465,-79.272,45.507,1],
79705=>[97.476,-79.275,45.494,1],
79706=>[97.487,-79.277,45.480,1],
79707=>[97.498,-79.280,45.467,1],
79708=>[97.509,-79.283,45.454,1],
79709=>[97.520,-79.285,45.440,1],
79710=>[97.531,-79.288,45.425,1],
79711=>[97.547,-79.297,45.409,1],
79712=>[97.566,-79.304,45.392,1],
79713=>[97.585,-79.311,45.374,1],
79714=>[97.603,-79.319,45.355,1],
79715=>[97.624,-79.327,45.336,1],
79716=>[97.643,-79.335,45.320,1],
79717=>[97.663,-79.344,45.307,1],
79718=>[97.683,-79.353,45.299,1],
79719=>[97.700,-79.360,45.291,1],
79720=>[97.713,-79.374,45.283,1],
79721=>[97.723,-79.390,45.274,1],
79722=>[97.733,-79.405,45.264,1],
79723=>[97.744,-79.420,45.254,1],
79724=>[97.754,-79.435,45.242,1],
79725=>[97.764,-79.451,45.230,1],
79726=>[97.775,-79.466,45.218,1],
79727=>[97.785,-79.482,45.208,1],
79728=>[97.797,-79.497,45.197,1],
79729=>[97.810,-79.510,45.181,1],
79730=>[97.823,-79.524,45.166,1],
79731=>[97.837,-79.538,45.151,1],
79732=>[97.851,-79.551,45.137,1],
79733=>[97.864,-79.566,45.125,1],
79734=>[97.877,-79.579,45.115,1],
79735=>[97.889,-79.592,45.107,1],
79736=>[97.901,-79.604,45.100,1],
79737=>[97.913,-79.615,45.093,1],
79738=>[97.933,-79.626,45.087,1],
79739=>[97.953,-79.637,45.080,1],
79740=>[97.978,-79.647,45.076,1],
79741=>[98.006,-79.656,45.072,1],
79742=>[98.034,-79.665,45.066,1],
79743=>[98.063,-79.674,45.058,1],
79744=>[98.091,-79.683,45.051,1],
79745=>[98.120,-79.692,45.045,1],
79746=>[98.148,-79.701,45.036,1],
79747=>[98.175,-79.711,45.027,1],
79748=>[98.201,-79.717,45.018,1],
79749=>[98.227,-79.724,45.009,1],
79750=>[98.253,-79.730,44.997,1],
79751=>[98.280,-79.737,44.984,1],
79752=>[98.306,-79.743,44.969,1],
79753=>[98.333,-79.750,44.953,1],
79754=>[98.359,-79.756,44.938,1],
79755=>[98.385,-79.763,44.924,1],
79756=>[98.412,-79.770,44.913,1],
79757=>[98.438,-79.778,44.904,1],
79758=>[98.465,-79.789,44.895,1],
79759=>[98.496,-79.798,44.887,1],
79760=>[98.529,-79.808,44.877,1],
79761=>[98.562,-79.817,44.867,1],
79762=>[98.594,-79.826,44.858,1],
79763=>[98.627,-79.836,44.851,1],
79764=>[98.660,-79.845,44.845,1],
79765=>[98.678,-79.842,44.839,1],
79766=>[98.693,-79.835,44.833,1],
79767=>[98.711,-79.836,44.826,1],
79768=>[98.732,-79.844,44.819,1],
79769=>[98.754,-79.852,44.812,1],
79770=>[98.775,-79.859,44.806,1],
79771=>[98.796,-79.867,44.799,1],
79772=>[98.817,-79.874,44.792,1],
79773=>[98.838,-79.882,44.785,1],
79774=>[98.860,-79.889,44.779,1],
79775=>[98.885,-79.890,44.773,1],
79776=>[98.911,-79.890,44.766,1],
79777=>[98.936,-79.891,44.759,1],
79778=>[98.961,-79.892,44.753,1],
79779=>[98.987,-79.892,44.748,1],
79780=>[99.002,-79.893,44.741,1],
79781=>[99.024,-79.908,44.734,1],
79782=>[99.044,-79.925,44.727,1],
79783=>[99.063,-79.943,44.721,1],
79784=>[99.083,-79.959,44.717,1],
79785=>[99.102,-79.977,44.713,1],
79786=>[99.122,-79.993,44.708,1],
79787=>[99.145,-80.008,44.702,1],
79788=>[99.178,-80.021,44.695,1],
79789=>[99.209,-80.034,44.689,1],
79790=>[99.241,-80.046,44.684,1],
79791=>[99.273,-80.059,44.681,1],
79792=>[99.308,-80.073,44.678,1],
79793=>[99.322,-80.077,44.675,1],
79794=>[99.336,-80.074,44.671,1],
79795=>[99.381,-80.087,44.668,1],
79796=>[99.427,-80.099,44.664,1],
79797=>[99.472,-80.111,44.660,1],
79798=>[99.502,-80.103,44.655,1],
79799=>[99.526,-80.090,44.648,1],
79800=>[99.526,-80.113,44.639,1],
79801=>[99.526,-80.141,44.628,1],
79802=>[99.529,-80.163,44.618,1],
79803=>[99.532,-80.185,44.608,1],
79804=>[99.536,-80.208,44.599,1],
79805=>[99.539,-80.230,44.590,1],
79806=>[99.542,-80.252,44.583,1],
79807=>[99.545,-80.274,44.575,1],
79808=>[99.548,-80.296,44.567,1],
79809=>[99.552,-80.319,44.559,1],
79810=>[99.555,-80.341,44.552,1],
79811=>[99.558,-80.363,44.545,1],
79812=>[99.561,-80.385,44.536,1],
79813=>[99.564,-80.407,44.527,1],
79814=>[99.568,-80.429,44.519,1],
79815=>[99.571,-80.451,44.511,1],
79816=>[99.574,-80.473,44.503,1],
79817=>[99.577,-80.495,44.494,1],
79818=>[99.580,-80.518,44.486,1],
79819=>[99.584,-80.540,44.476,1],
79820=>[99.587,-80.562,44.467,1],
79821=>[99.590,-80.584,44.456,1],
79822=>[99.634,-80.591,44.445,1],
79823=>[99.682,-80.597,44.435,1],
79824=>[99.729,-80.603,44.425,1],
79825=>[99.777,-80.608,44.415,1],
79826=>[99.826,-80.613,44.403,1],
79827=>[99.873,-80.620,44.391,1],
79828=>[99.921,-80.625,44.380,1],
79829=>[99.969,-80.631,44.368,1],
79830=>[100.017,-80.636,44.357,1],
79831=>[100.065,-80.641,44.345,1],
79832=>[100.113,-80.648,44.334,1],
80126=>[93.555,-78.836,53.563,1],
80127=>[93.565,-78.833,53.554,1],
80128=>[93.574,-78.831,53.546,1],
80129=>[93.584,-78.828,53.538,1],
80130=>[93.593,-78.826,53.531,1],
80131=>[93.604,-78.824,53.524,1],
80132=>[93.613,-78.821,53.519,1],
80133=>[93.623,-78.818,53.515,1],
80134=>[93.632,-78.814,53.513,1],
80135=>[93.650,-78.802,53.515,1],
80136=>[93.654,-78.794,53.518,1],
80137=>[93.658,-78.791,53.518,1],
80138=>[93.663,-78.789,53.517,1],
80139=>[93.669,-78.784,53.514,1],
80140=>[93.674,-78.780,53.510,1],
80141=>[93.680,-78.775,53.503,1],
80142=>[93.686,-78.770,53.494,1],
80143=>[93.692,-78.765,53.485,1],
80144=>[93.698,-78.763,53.474,1],
80145=>[93.712,-78.756,53.461,1],
80146=>[93.737,-78.742,53.448,1],
80147=>[93.762,-78.728,53.432,1],
80148=>[93.786,-78.714,53.415,1],
80149=>[93.805,-78.702,53.399,1],
80150=>[93.808,-78.693,53.381,1],
80151=>[93.812,-78.685,53.362,1],
80152=>[93.815,-78.677,53.343,1],
80153=>[93.819,-78.668,53.323,1],
80154=>[93.822,-78.659,53.302,1],
80155=>[93.826,-78.651,53.281,1],
80156=>[93.832,-78.642,53.261,1],
80157=>[93.846,-78.635,53.240,1],
80158=>[93.860,-78.626,53.218,1],
80159=>[93.874,-78.618,53.196,1],
80160=>[93.887,-78.606,53.175,1],
80161=>[93.900,-78.593,53.151,1],
80162=>[93.913,-78.580,53.126,1],
80163=>[93.925,-78.567,53.099,1],
80164=>[93.938,-78.554,53.073,1],
80165=>[93.949,-78.555,53.048,1],
80166=>[93.960,-78.562,53.023,1],
80167=>[93.971,-78.568,53.001,1],
80168=>[93.982,-78.575,52.978,1],
80169=>[93.992,-78.581,52.955,1],
80170=>[94.003,-78.588,52.935,1],
80171=>[94.013,-78.592,52.917,1],
80172=>[94.024,-78.591,52.899,1],
80173=>[94.034,-78.589,52.881,1],
80174=>[94.043,-78.587,52.861,1],
80175=>[94.053,-78.586,52.839,1],
80176=>[94.063,-78.584,52.815,1],
80177=>[94.066,-78.587,52.791,1],
80178=>[94.058,-78.557,52.766,1],
80179=>[94.070,-78.514,52.741,1],
80180=>[94.131,-78.517,52.717,1],
80181=>[94.192,-78.518,52.692,1],
80182=>[94.245,-78.515,52.668,1],
80183=>[94.290,-78.506,52.646,1],
80184=>[94.334,-78.496,52.626,1],
80185=>[94.379,-78.487,52.607,1],
80186=>[94.390,-78.535,52.589,1],
80187=>[94.397,-78.545,52.571,1],
80188=>[94.390,-78.557,52.553,1],
80189=>[94.382,-78.568,52.533,1],
80190=>[94.374,-78.580,52.511,1],
80191=>[94.366,-78.592,52.488,1],
80192=>[94.359,-78.604,52.466,1],
80193=>[94.351,-78.617,52.445,1],
80194=>[94.343,-78.629,52.425,1],
80195=>[94.336,-78.641,52.404,1],
80196=>[94.328,-78.652,52.383,1],
80197=>[94.345,-78.640,52.360,1],
80198=>[94.361,-78.627,52.336,1],
80199=>[94.378,-78.615,52.313,1],
80200=>[94.394,-78.603,52.289,1],
80201=>[94.410,-78.590,52.263,1],
80202=>[94.426,-78.578,52.233,1],
80203=>[94.443,-78.566,52.203,1],
80204=>[94.459,-78.554,52.172,1],
80205=>[94.473,-78.552,52.138,1],
80206=>[94.485,-78.560,52.103,1],
80207=>[94.496,-78.568,52.067,1],
80208=>[94.507,-78.576,52.029,1],
80209=>[94.519,-78.583,51.990,1],
80210=>[94.529,-78.608,51.951,1],
80211=>[94.538,-78.638,51.913,1],
80212=>[94.546,-78.652,51.875,1],
80213=>[94.555,-78.658,51.838,1],
80214=>[94.567,-78.658,51.801,1],
80215=>[94.579,-78.657,51.764,1],
80216=>[94.592,-78.656,51.726,1],
80217=>[94.604,-78.656,51.687,1],
80218=>[94.616,-78.655,51.649,1],
80219=>[94.628,-78.655,51.609,1],
80220=>[94.641,-78.655,51.572,1],
80221=>[94.653,-78.654,51.535,1],
80222=>[94.665,-78.652,51.499,1],
80223=>[94.677,-78.648,51.461,1],
80224=>[94.689,-78.645,51.424,1],
80225=>[94.700,-78.641,51.386,1],
80226=>[94.712,-78.639,51.351,1],
80227=>[94.726,-78.642,51.314,1],
80228=>[94.746,-78.645,51.276,1],
80229=>[94.764,-78.648,51.237,1],
80230=>[94.783,-78.652,51.199,1],
80231=>[94.802,-78.656,51.160,1],
80232=>[94.821,-78.659,51.121,1],
80233=>[94.827,-78.667,51.083,1],
80234=>[94.833,-78.674,51.044,1],
80235=>[94.838,-78.682,51.004,1],
80236=>[94.846,-78.676,50.965,1],
80237=>[94.855,-78.664,50.924,1],
80238=>[94.865,-78.651,50.881,1],
80239=>[94.874,-78.638,50.838,1],
80240=>[94.883,-78.625,50.793,1],
80241=>[94.893,-78.612,50.747,1],
80242=>[94.902,-78.599,50.702,1],
80243=>[94.923,-78.592,50.656,1],
80244=>[94.961,-78.590,50.608,1],
80245=>[94.972,-78.589,50.559,1],
80246=>[94.964,-78.589,50.509,1],
80247=>[94.956,-78.588,50.460,1],
80248=>[94.955,-78.592,50.413,1],
80249=>[94.962,-78.601,50.366,1],
80250=>[94.969,-78.610,50.323,1],
80251=>[94.974,-78.621,50.281,1],
80252=>[94.976,-78.635,50.239,1],
80253=>[94.977,-78.649,50.197,1],
80254=>[94.979,-78.663,50.155,1],
80255=>[94.981,-78.677,50.112,1],
80256=>[94.990,-78.686,50.069,1],
80257=>[95.005,-78.690,50.026,1],
80258=>[95.020,-78.695,49.984,1],
80259=>[95.035,-78.699,49.941,1],
80260=>[95.049,-78.704,49.900,1],
80261=>[95.064,-78.708,49.861,1],
80262=>[95.079,-78.712,49.823,1],
80263=>[95.094,-78.717,49.786,1],
80264=>[95.109,-78.721,49.749,1],
80265=>[95.123,-78.726,49.712,1],
80266=>[95.153,-78.722,49.674,1],
80267=>[95.183,-78.718,49.635,1],
80268=>[95.212,-78.715,49.595,1],
80269=>[95.209,-78.715,49.554,1],
80270=>[95.191,-78.726,49.513,1],
80271=>[95.219,-78.745,49.472,1],
80272=>[95.249,-78.766,49.431,1],
80273=>[95.278,-78.786,49.391,1],
80274=>[95.307,-78.805,49.351,1],
80275=>[95.333,-78.822,49.313,1],
80276=>[95.352,-78.833,49.276,1],
80277=>[95.372,-78.846,49.239,1],
80278=>[95.391,-78.857,49.200,1],
80279=>[95.411,-78.869,49.160,1],
80280=>[95.425,-78.867,49.120,1],
80281=>[95.439,-78.865,49.080,1],
80282=>[95.453,-78.862,49.039,1],
80283=>[95.466,-78.860,48.999,1],
80284=>[95.480,-78.858,48.959,1],
80285=>[95.489,-78.851,48.917,1],
80286=>[95.493,-78.839,48.874,1],
80287=>[95.497,-78.828,48.831,1],
80288=>[95.500,-78.817,48.789,1],
80289=>[95.515,-78.812,48.745,1],
80290=>[95.538,-78.814,48.702,1],
80291=>[95.561,-78.816,48.661,1],
80292=>[95.570,-78.824,48.617,1],
80293=>[95.577,-78.835,48.574,1],
80294=>[95.582,-78.846,48.530,1],
80295=>[95.588,-78.856,48.488,1],
80296=>[95.594,-78.867,48.445,1],
80297=>[95.600,-78.877,48.402,1],
80298=>[95.611,-78.889,48.360,1],
80299=>[95.625,-78.902,48.320,1],
80300=>[95.639,-78.916,48.281,1],
80301=>[95.653,-78.929,48.241,1],
80302=>[95.667,-78.943,48.202,1],
80303=>[95.681,-78.954,48.163,1],
80304=>[95.698,-78.958,48.124,1],
80305=>[95.715,-78.962,48.082,1],
80306=>[95.732,-78.965,48.040,1],
80307=>[95.748,-78.970,47.997,1],
80308=>[95.765,-78.974,47.953,1],
80309=>[95.782,-78.977,47.910,1],
80310=>[95.799,-78.981,47.867,1],
80311=>[95.816,-78.985,47.824,1],
80312=>[95.832,-78.989,47.781,1],
80313=>[95.852,-78.993,47.739,1],
80314=>[95.876,-78.999,47.698,1],
80315=>[95.895,-79.003,47.656,1],
80316=>[95.918,-78.998,47.615,1],
80317=>[95.942,-78.992,47.574,1],
80318=>[95.965,-78.986,47.532,1],
80319=>[95.988,-78.980,47.491,1],
80320=>[96.012,-78.974,47.451,1],
80321=>[96.035,-78.968,47.411,1],
80322=>[96.058,-78.962,47.370,1],
80323=>[96.081,-78.955,47.332,1],
80324=>[96.104,-78.949,47.294,1],
80325=>[96.128,-78.943,47.255,1],
80326=>[96.169,-78.945,47.217,1],
80327=>[96.208,-78.946,47.180,1],
80328=>[96.249,-78.948,47.143,1],
80329=>[96.288,-78.949,47.107,1],
80330=>[96.321,-78.940,47.073,1],
80331=>[96.354,-78.933,47.041,1],
80332=>[96.386,-78.925,47.009,1],
80333=>[96.417,-78.917,46.979,1],
80334=>[96.430,-78.916,46.948,1],
80335=>[96.430,-78.922,46.917,1],
80336=>[96.425,-78.929,46.886,1],
80337=>[96.420,-78.936,46.856,1],
80338=>[96.422,-78.943,46.826,1],
80339=>[96.441,-78.952,46.795,1],
80340=>[96.460,-78.962,46.762,1],
80341=>[96.476,-78.970,46.730,1],
80342=>[96.490,-78.977,46.697,1],
80343=>[96.504,-78.984,46.664,1],
80344=>[96.518,-78.990,46.632,1],
80345=>[96.562,-78.993,46.602,1],
80346=>[96.610,-78.995,46.572,1],
80347=>[96.659,-78.996,46.542,1],
80348=>[96.704,-79.028,46.514,1],
80349=>[96.739,-79.048,46.485,1],
80350=>[96.764,-79.046,46.457,1],
80351=>[96.790,-79.045,46.431,1],
80352=>[96.814,-79.043,46.405,1],
80353=>[96.853,-78.967,46.381,1],
80354=>[96.884,-78.946,46.358,1],
80355=>[96.900,-78.949,46.335,1],
80356=>[96.910,-78.937,46.313,1],
80357=>[96.922,-78.929,46.290,1],
80358=>[96.933,-78.917,46.270,1],
80359=>[96.943,-78.857,46.252,1],
80360=>[96.951,-78.876,46.234,1],
80361=>[96.960,-78.894,46.216,1],
80362=>[96.968,-78.913,46.196,1],
80363=>[96.977,-78.931,46.176,1],
80364=>[96.979,-78.943,46.153,1],
80365=>[96.979,-78.959,46.133,1],
80366=>[96.979,-78.974,46.114,1],
80367=>[96.979,-78.990,46.096,1],
80368=>[96.979,-79.006,46.078,1],
80369=>[96.979,-79.022,46.061,1],
80370=>[96.989,-79.049,46.043,1],
80371=>[97.007,-79.122,46.026,1],
80372=>[97.026,-79.161,46.010,1],
80373=>[97.045,-79.199,45.995,1],
80374=>[97.064,-79.237,45.978,1],
80375=>[97.083,-79.276,45.962,1],
80376=>[97.100,-79.294,45.945,1],
80377=>[97.109,-79.263,45.926,1],
80378=>[97.118,-79.231,45.909,1],
80379=>[97.127,-79.200,45.895,1],
80380=>[97.137,-79.169,45.880,1],
80381=>[97.146,-79.139,45.864,1],
80382=>[97.155,-79.108,45.850,1],
80383=>[97.164,-79.079,45.835,1],
80384=>[97.179,-79.087,45.819,1],
80385=>[97.194,-79.095,45.803,1],
80386=>[97.223,-79.112,45.787,1],
80387=>[97.260,-79.127,45.772,1],
80388=>[97.285,-79.126,45.757,1],
80389=>[97.291,-79.140,45.742,1],
80390=>[97.298,-79.154,45.728,1],
80391=>[97.304,-79.169,45.714,1],
80392=>[97.315,-79.179,45.699,1],
80393=>[97.329,-79.189,45.685,1],
80394=>[97.343,-79.199,45.671,1],
80395=>[97.357,-79.209,45.658,1],
80396=>[97.371,-79.218,45.644,1],
80397=>[97.385,-79.228,45.630,1],
80398=>[97.398,-79.237,45.616,1],
80399=>[97.408,-79.245,45.601,1],
80400=>[97.415,-79.251,45.586,1],
80401=>[97.424,-79.255,45.572,1],
80402=>[97.435,-79.258,45.559,1],
80403=>[97.446,-79.261,45.546,1],
80404=>[97.457,-79.263,45.533,1],
80405=>[97.468,-79.266,45.520,1],
80406=>[97.479,-79.269,45.506,1],
80407=>[97.491,-79.272,45.493,1],
80408=>[97.502,-79.275,45.481,1],
80409=>[97.513,-79.277,45.468,1],
80410=>[97.526,-79.280,45.454,1],
80411=>[97.541,-79.283,45.438,1],
80412=>[97.560,-79.290,45.421,1],
80413=>[97.579,-79.299,45.402,1],
80414=>[97.599,-79.307,45.383,1],
80415=>[97.619,-79.316,45.362,1],
80416=>[97.639,-79.324,45.342,1],
80417=>[97.659,-79.332,45.326,1],
80418=>[97.678,-79.341,45.314,1],
80419=>[97.691,-79.346,45.304,1],
80420=>[97.691,-79.346,45.296,1],
80421=>[97.706,-79.362,45.287,1],
80422=>[97.724,-79.382,45.277,1],
80423=>[97.740,-79.401,45.267,1],
80424=>[97.750,-79.416,45.255,1],
80425=>[97.761,-79.432,45.243,1],
80426=>[97.771,-79.447,45.231,1],
80427=>[97.782,-79.463,45.220,1],
80428=>[97.792,-79.478,45.208,1],
80429=>[97.802,-79.494,45.196,1],
80430=>[97.816,-79.507,45.183,1],
80431=>[97.829,-79.521,45.170,1],
80432=>[97.843,-79.535,45.158,1],
80433=>[97.856,-79.548,45.144,1],
80434=>[97.870,-79.563,45.131,1],
80435=>[97.882,-79.575,45.120,1],
80436=>[97.893,-79.586,45.112,1],
80437=>[97.905,-79.598,45.103,1],
80438=>[97.917,-79.610,45.096,1],
80439=>[97.934,-79.621,45.090,1],
80440=>[97.955,-79.632,45.084,1],
80441=>[97.980,-79.642,45.078,1],
80442=>[98.008,-79.651,45.074,1],
80443=>[98.036,-79.660,45.070,1],
80444=>[98.065,-79.669,45.064,1],
80445=>[98.093,-79.678,45.057,1],
80446=>[98.122,-79.686,45.049,1],
80447=>[98.150,-79.695,45.040,1],
80448=>[98.186,-79.689,45.030,1],
80449=>[98.218,-79.704,45.020,1],
80450=>[98.244,-79.711,45.009,1],
80451=>[98.270,-79.717,44.997,1],
80452=>[98.296,-79.724,44.985,1],
80453=>[98.323,-79.730,44.972,1],
80454=>[98.349,-79.737,44.957,1],
80455=>[98.375,-79.743,44.944,1],
80456=>[98.402,-79.750,44.931,1],
80457=>[98.428,-79.757,44.921,1],
80458=>[98.455,-79.767,44.911,1],
80459=>[98.483,-79.777,44.903,1],
80460=>[98.511,-79.787,44.895,1],
80461=>[98.544,-79.797,44.886,1],
80462=>[98.576,-79.806,44.878,1],
80463=>[98.609,-79.815,44.870,1],
80464=>[98.641,-79.824,44.863,1],
80465=>[98.672,-79.832,44.857,1],
80466=>[98.687,-79.825,44.852,1],
80467=>[98.701,-79.818,44.846,1],
80468=>[98.717,-79.815,44.839,1],
80469=>[98.738,-79.823,44.832,1],
80470=>[98.759,-79.830,44.825,1],
80471=>[98.780,-79.837,44.820,1],
80472=>[98.801,-79.845,44.813,1],
80473=>[98.822,-79.852,44.806,1],
80474=>[98.844,-79.860,44.800,1],
80475=>[98.865,-79.868,44.794,1],
80476=>[98.887,-79.876,44.788,1],
80477=>[98.913,-79.877,44.782,1],
80478=>[98.938,-79.877,44.775,1],
80479=>[98.963,-79.878,44.768,1],
80480=>[98.989,-79.879,44.761,1],
80481=>[99.005,-79.878,44.753,1],
80482=>[99.029,-79.892,44.746,1],
80483=>[99.051,-79.908,44.741,1],
80484=>[99.070,-79.925,44.736,1],
80485=>[99.089,-79.942,44.730,1],
80486=>[99.109,-79.959,44.726,1],
80487=>[99.128,-79.976,44.721,1],
80488=>[99.155,-79.990,44.714,1],
80489=>[99.188,-80.002,44.707,1],
80490=>[99.219,-80.015,44.703,1],
80491=>[99.251,-80.027,44.699,1],
80492=>[99.283,-80.040,44.696,1],
80493=>[99.314,-80.052,44.692,1],
80494=>[99.337,-80.057,44.687,1],
80495=>[99.360,-80.062,44.681,1],
80496=>[99.372,-80.060,44.675,1],
80497=>[99.385,-80.059,44.669,1],
80498=>[99.429,-80.070,44.663,1],
80499=>[99.474,-80.082,44.657,1],
80500=>[99.514,-80.087,44.651,1],
80501=>[99.538,-80.072,44.643,1],
80502=>[99.540,-80.095,44.634,1],
80503=>[99.531,-80.133,44.624,1],
80504=>[99.528,-80.162,44.615,1],
80505=>[99.532,-80.184,44.605,1],
80506=>[99.535,-80.207,44.597,1],
80507=>[99.539,-80.229,44.589,1],
80508=>[99.542,-80.251,44.581,1],
80509=>[99.545,-80.273,44.573,1],
80510=>[99.548,-80.295,44.564,1],
80511=>[99.551,-80.318,44.557,1],
80512=>[99.554,-80.340,44.549,1],
80513=>[99.558,-80.362,44.541,1],
80514=>[99.561,-80.384,44.533,1],
80515=>[99.564,-80.406,44.525,1],
80516=>[99.567,-80.428,44.516,1],
80517=>[99.570,-80.450,44.508,1],
80518=>[99.574,-80.472,44.499,1],
80519=>[99.577,-80.494,44.491,1],
80520=>[99.580,-80.517,44.481,1],
80521=>[99.583,-80.539,44.472,1],
80522=>[99.594,-80.559,44.461,1],
80523=>[99.642,-80.564,44.450,1],
80524=>[99.690,-80.569,44.440,1],
80525=>[99.738,-80.576,44.430,1],
80526=>[99.786,-80.581,44.419,1],
80527=>[99.834,-80.586,44.407,1],
80528=>[99.881,-80.592,44.395,1],
80529=>[99.929,-80.598,44.383,1],
80530=>[99.978,-80.604,44.372,1],
80531=>[100.025,-80.609,44.361,1],
80532=>[100.073,-80.614,44.350,1],
80533=>[100.121,-80.620,44.338,1],
80827=>[93.555,-78.825,53.571,1],
80828=>[93.565,-78.822,53.563,1],
80829=>[93.574,-78.820,53.555,1],
80830=>[93.584,-78.818,53.547,1],
80831=>[93.594,-78.815,53.540,1],
80832=>[93.604,-78.812,53.534,1],
80833=>[93.613,-78.810,53.529,1],
80834=>[93.623,-78.808,53.525,1],
80835=>[93.633,-78.805,53.524,1],
80836=>[93.642,-78.800,53.526,1],
80837=>[93.651,-78.792,53.529,1],
80838=>[93.655,-78.789,53.530,1],
80839=>[93.659,-78.785,53.529,1],
80840=>[93.665,-78.780,53.527,1],
80841=>[93.672,-78.776,53.522,1],
80842=>[93.677,-78.771,53.516,1],
80843=>[93.683,-78.767,53.508,1],
80844=>[93.689,-78.762,53.498,1],
80845=>[93.699,-78.755,53.486,1],
80846=>[93.724,-78.739,53.474,1],
80847=>[93.749,-78.725,53.460,1],
80848=>[93.773,-78.711,53.444,1],
80849=>[93.798,-78.697,53.427,1],
80850=>[93.806,-78.687,53.410,1],
80851=>[93.809,-78.679,53.391,1],
80852=>[93.813,-78.670,53.371,1],
80853=>[93.817,-78.662,53.351,1],
80854=>[93.820,-78.654,53.331,1],
80855=>[93.823,-78.645,53.311,1],
80856=>[93.827,-78.636,53.290,1],
80857=>[93.832,-78.628,53.270,1],
80858=>[93.845,-78.620,53.249,1],
80859=>[93.859,-78.611,53.227,1],
80860=>[93.872,-78.598,53.204,1],
80861=>[93.885,-78.586,53.182,1],
80862=>[93.898,-78.573,53.159,1],
80863=>[93.910,-78.560,53.134,1],
80864=>[93.923,-78.547,53.108,1],
80865=>[93.935,-78.534,53.083,1],
80866=>[93.947,-78.532,53.059,1],
80867=>[93.958,-78.539,53.033,1],
80868=>[93.969,-78.545,53.011,1],
80869=>[93.979,-78.551,52.988,1],
80870=>[93.990,-78.557,52.966,1],
80871=>[94.001,-78.564,52.947,1],
80872=>[94.011,-78.570,52.929,1],
80873=>[94.023,-78.577,52.911,1],
80874=>[94.033,-78.581,52.893,1],
80875=>[94.043,-78.579,52.873,1],
80876=>[94.053,-78.577,52.851,1],
80877=>[94.062,-78.576,52.826,1],
80878=>[94.060,-78.565,52.802,1],
80879=>[94.050,-78.523,52.777,1],
80880=>[94.090,-78.509,52.752,1],
80881=>[94.135,-78.500,52.727,1],
80882=>[94.180,-78.491,52.703,1],
80883=>[94.224,-78.481,52.680,1],
80884=>[94.269,-78.472,52.660,1],
80885=>[94.313,-78.462,52.641,1],
80886=>[94.357,-78.454,52.622,1],
80887=>[94.365,-78.537,52.604,1],
80888=>[94.380,-78.544,52.587,1],
80889=>[94.395,-78.551,52.569,1],
80890=>[94.388,-78.563,52.549,1],
80891=>[94.381,-78.574,52.527,1],
80892=>[94.372,-78.586,52.505,1],
80893=>[94.365,-78.598,52.483,1],
80894=>[94.357,-78.611,52.461,1],
80895=>[94.350,-78.623,52.440,1],
80896=>[94.342,-78.635,52.420,1],
80897=>[94.334,-78.647,52.399,1],
80898=>[94.347,-78.638,52.376,1],
80899=>[94.363,-78.626,52.352,1],
80900=>[94.380,-78.614,52.329,1],
80901=>[94.396,-78.601,52.305,1],
80902=>[94.412,-78.589,52.279,1],
80903=>[94.428,-78.576,52.251,1],
80904=>[94.445,-78.564,52.222,1],
80905=>[94.460,-78.551,52.190,1],
80906=>[94.471,-78.552,52.156,1],
80907=>[94.484,-78.558,52.120,1],
80908=>[94.497,-78.566,52.083,1],
80909=>[94.508,-78.573,52.044,1],
80910=>[94.520,-78.581,52.006,1],
80911=>[94.531,-78.590,51.968,1],
80912=>[94.540,-78.620,51.930,1],
80913=>[94.548,-78.632,51.893,1],
80914=>[94.556,-78.641,51.857,1],
80915=>[94.568,-78.641,51.820,1],
80916=>[94.580,-78.640,51.782,1],
80917=>[94.592,-78.639,51.745,1],
80918=>[94.605,-78.639,51.706,1],
80919=>[94.617,-78.639,51.668,1],
80920=>[94.629,-78.638,51.628,1],
80921=>[94.641,-78.637,51.588,1],
80922=>[94.653,-78.637,51.550,1],
80923=>[94.666,-78.636,51.512,1],
80924=>[94.678,-78.636,51.474,1],
80925=>[94.690,-78.635,51.435,1],
80926=>[94.702,-78.635,51.396,1],
80927=>[94.714,-78.633,51.359,1],
80928=>[94.733,-78.636,51.321,1],
80929=>[94.752,-78.640,51.282,1],
80930=>[94.771,-78.643,51.243,1],
80931=>[94.789,-78.647,51.204,1],
80932=>[94.809,-78.651,51.165,1],
80933=>[94.827,-78.654,51.127,1],
80934=>[94.837,-78.661,51.088,1],
80935=>[94.842,-78.668,51.049,1],
80936=>[94.848,-78.676,51.009,1],
80937=>[94.857,-78.666,50.970,1],
80938=>[94.866,-78.653,50.929,1],
80939=>[94.875,-78.640,50.886,1],
80940=>[94.885,-78.627,50.842,1],
80941=>[94.894,-78.614,50.798,1],
80942=>[94.903,-78.601,50.752,1],
80943=>[94.928,-78.595,50.706,1],
80944=>[94.965,-78.595,50.658,1],
80945=>[95.002,-78.593,50.608,1],
80946=>[95.014,-78.592,50.558,1],
80947=>[95.006,-78.592,50.507,1],
80948=>[94.998,-78.591,50.459,1],
80949=>[94.991,-78.591,50.412,1],
80950=>[94.983,-78.590,50.366,1],
80951=>[94.982,-78.594,50.323,1],
80952=>[94.989,-78.603,50.280,1],
80953=>[94.994,-78.614,50.237,1],
80954=>[94.996,-78.628,50.196,1],
80955=>[94.998,-78.642,50.154,1],
80956=>[95.000,-78.656,50.111,1],
80957=>[95.014,-78.661,50.068,1],
80958=>[95.029,-78.665,50.026,1],
80959=>[95.044,-78.670,49.984,1],
80960=>[95.058,-78.674,49.941,1],
80961=>[95.073,-78.679,49.901,1],
80962=>[95.088,-78.683,49.863,1],
80963=>[95.103,-78.687,49.826,1],
80964=>[95.118,-78.692,49.790,1],
80965=>[95.132,-78.696,49.753,1],
80966=>[95.147,-78.701,49.716,1],
80967=>[95.162,-78.705,49.678,1],
80968=>[95.190,-78.702,49.638,1],
80969=>[95.220,-78.698,49.598,1],
80970=>[95.192,-78.702,49.557,1],
80971=>[95.182,-78.714,49.516,1],
80972=>[95.211,-78.734,49.476,1],
80973=>[95.241,-78.754,49.436,1],
80974=>[95.270,-78.774,49.396,1],
80975=>[95.299,-78.793,49.357,1],
80976=>[95.328,-78.813,49.318,1],
80977=>[95.352,-78.829,49.280,1],
80978=>[95.372,-78.841,49.242,1],
80979=>[95.391,-78.852,49.204,1],
80980=>[95.411,-78.865,49.165,1],
80981=>[95.425,-78.863,49.126,1],
80982=>[95.439,-78.861,49.086,1],
80983=>[95.453,-78.858,49.046,1],
80984=>[95.467,-78.856,49.005,1],
80985=>[95.476,-78.849,48.965,1],
80986=>[95.479,-78.838,48.923,1],
80987=>[95.483,-78.827,48.880,1],
80988=>[95.487,-78.815,48.836,1],
80989=>[95.491,-78.804,48.793,1],
80990=>[95.504,-78.799,48.749,1],
80991=>[95.528,-78.800,48.705,1],
80992=>[95.551,-78.802,48.664,1],
80993=>[95.573,-78.805,48.620,1],
80994=>[95.579,-78.815,48.576,1],
80995=>[95.585,-78.826,48.533,1],
80996=>[95.591,-78.836,48.492,1],
80997=>[95.597,-78.847,48.449,1],
80998=>[95.603,-78.857,48.406,1],
80999=>[95.609,-78.868,48.365,1],
81000=>[95.614,-78.878,48.325,1],
81001=>[95.623,-78.890,48.286,1],
81002=>[95.637,-78.902,48.247,1],
81003=>[95.651,-78.916,48.209,1],
81004=>[95.665,-78.929,48.171,1],
81005=>[95.682,-78.933,48.133,1],
81006=>[95.698,-78.937,48.092,1],
81007=>[95.716,-78.940,48.050,1],
81008=>[95.732,-78.944,48.008,1],
81009=>[95.749,-78.948,47.964,1],
81010=>[95.768,-78.952,47.920,1],
81011=>[95.792,-78.958,47.877,1],
81012=>[95.816,-78.963,47.834,1],
81013=>[95.839,-78.968,47.791,1],
81014=>[95.864,-78.974,47.749,1],
81015=>[95.875,-78.988,47.708,1],
81016=>[95.894,-78.991,47.666,1],
81017=>[95.918,-78.987,47.625,1],
81018=>[95.943,-78.983,47.584,1],
81019=>[95.967,-78.979,47.543,1],
81020=>[95.990,-78.973,47.501,1],
81021=>[96.014,-78.967,47.461,1],
81022=>[96.037,-78.961,47.421,1],
81023=>[96.060,-78.954,47.381,1],
81024=>[96.083,-78.948,47.342,1],
81025=>[96.106,-78.942,47.303,1],
81026=>[96.129,-78.936,47.263,1],
81027=>[96.168,-78.937,47.225,1],
81028=>[96.208,-78.939,47.188,1],
81029=>[96.249,-78.940,47.151,1],
81030=>[96.282,-78.933,47.115,1],
81031=>[96.315,-78.925,47.081,1],
81032=>[96.347,-78.917,47.048,1],
81033=>[96.373,-78.908,47.017,1],
81034=>[96.398,-78.899,46.986,1],
81035=>[96.414,-78.896,46.956,1],
81036=>[96.415,-78.902,46.925,1],
81037=>[96.416,-78.908,46.894,1],
81038=>[96.418,-78.915,46.864,1],
81039=>[96.419,-78.921,46.833,1],
81040=>[96.418,-78.928,46.802,1],
81041=>[96.433,-78.936,46.769,1],
81042=>[96.447,-78.943,46.737,1],
81043=>[96.461,-78.949,46.704,1],
81044=>[96.475,-78.956,46.670,1],
81045=>[96.495,-78.963,46.639,1],
81046=>[96.543,-78.965,46.609,1],
81047=>[96.589,-78.986,46.579,1],
81048=>[96.632,-78.986,46.551,1],
81049=>[96.675,-78.978,46.522,1],
81050=>[96.717,-78.971,46.494,1],
81051=>[96.759,-78.962,46.465,1],
81052=>[96.802,-78.955,46.440,1],
81053=>[96.839,-78.949,46.415,1],
81054=>[96.855,-78.940,46.392,1],
81055=>[96.866,-78.943,46.369,1],
81056=>[96.889,-78.932,46.347,1],
81057=>[96.901,-78.926,46.325,1],
81058=>[96.913,-78.919,46.302,1],
81059=>[96.925,-78.910,46.282,1],
81060=>[96.927,-78.857,46.263,1],
81061=>[96.916,-78.865,46.245,1],
81062=>[96.924,-78.882,46.227,1],
81063=>[96.939,-78.902,46.207,1],
81064=>[96.967,-78.924,46.186,1],
81065=>[96.986,-78.945,46.165,1],
81066=>[96.985,-78.962,46.145,1],
81067=>[96.984,-78.980,46.126,1],
81068=>[96.984,-78.996,46.108,1],
81069=>[96.983,-79.014,46.091,1],
81070=>[96.982,-79.031,46.073,1],
81071=>[96.982,-79.046,46.056,1],
81072=>[96.997,-79.086,46.039,1],
81073=>[97.017,-79.129,46.023,1],
81074=>[97.038,-79.176,46.007,1],
81075=>[97.059,-79.222,45.990,1],
81076=>[97.080,-79.269,45.975,1],
81077=>[97.100,-79.269,45.959,1],
81078=>[97.119,-79.262,45.942,1],
81079=>[97.129,-79.231,45.926,1],
81080=>[97.138,-79.200,45.911,1],
81081=>[97.147,-79.169,45.896,1],
81082=>[97.156,-79.138,45.881,1],
81083=>[97.165,-79.107,45.867,1],
81084=>[97.175,-79.082,45.852,1],
81085=>[97.189,-79.090,45.837,1],
81086=>[97.205,-79.097,45.820,1],
81087=>[97.222,-79.107,45.805,1],
81088=>[97.258,-79.119,45.790,1],
81089=>[97.268,-79.130,45.773,1],
81090=>[97.275,-79.143,45.757,1],
81091=>[97.288,-79.154,45.743,1],
81092=>[97.302,-79.164,45.730,1],
81093=>[97.316,-79.173,45.714,1],
81094=>[97.329,-79.183,45.700,1],
81095=>[97.344,-79.193,45.687,1],
81096=>[97.357,-79.202,45.673,1],
81097=>[97.371,-79.212,45.659,1],
81098=>[97.385,-79.222,45.644,1],
81099=>[97.398,-79.231,45.629,1],
81100=>[97.411,-79.240,45.614,1],
81101=>[97.418,-79.247,45.600,1],
81102=>[97.428,-79.250,45.587,1],
81103=>[97.439,-79.253,45.573,1],
81104=>[97.450,-79.255,45.558,1],
81105=>[97.461,-79.258,45.545,1],
81106=>[97.472,-79.261,45.533,1],
81107=>[97.483,-79.263,45.519,1],
81108=>[97.496,-79.266,45.507,1],
81109=>[97.511,-79.269,45.495,1],
81110=>[97.525,-79.272,45.479,1],
81111=>[97.540,-79.275,45.462,1],
81112=>[97.555,-79.278,45.444,1],
81113=>[97.575,-79.287,45.424,1],
81114=>[97.595,-79.295,45.404,1],
81115=>[97.615,-79.304,45.384,1],
81116=>[97.635,-79.313,45.366,1],
81117=>[97.654,-79.321,45.346,1],
81118=>[97.674,-79.329,45.332,1],
81119=>[97.682,-79.332,45.319,1],
81120=>[97.682,-79.332,45.307,1],
81121=>[97.682,-79.332,45.296,1],
81122=>[97.698,-79.349,45.286,1],
81123=>[97.717,-79.369,45.277,1],
81124=>[97.735,-79.390,45.268,1],
81125=>[97.753,-79.410,45.257,1],
81126=>[97.768,-79.429,45.246,1],
81127=>[97.778,-79.444,45.236,1],
81128=>[97.789,-79.459,45.224,1],
81129=>[97.799,-79.475,45.212,1],
81130=>[97.809,-79.490,45.199,1],
81131=>[97.822,-79.504,45.187,1],
81132=>[97.836,-79.518,45.175,1],
81133=>[97.849,-79.532,45.162,1],
81134=>[97.862,-79.545,45.149,1],
81135=>[97.874,-79.558,45.137,1],
81136=>[97.886,-79.570,45.127,1],
81137=>[97.897,-79.582,45.118,1],
81138=>[97.909,-79.593,45.109,1],
81139=>[97.921,-79.605,45.102,1],
81140=>[97.936,-79.617,45.095,1],
81141=>[97.956,-79.627,45.088,1],
81142=>[97.982,-79.637,45.081,1],
81143=>[98.010,-79.646,45.075,1],
81144=>[98.038,-79.655,45.071,1],
81145=>[98.067,-79.664,45.065,1],
81146=>[98.095,-79.673,45.058,1],
81147=>[98.124,-79.682,45.050,1],
81148=>[98.160,-79.674,45.041,1],
81149=>[98.197,-79.665,45.031,1],
81150=>[98.231,-79.686,45.021,1],
81151=>[98.261,-79.698,45.010,1],
81152=>[98.287,-79.704,44.999,1],
81153=>[98.313,-79.711,44.987,1],
81154=>[98.340,-79.717,44.975,1],
81155=>[98.366,-79.724,44.962,1],
81156=>[98.392,-79.730,44.951,1],
81157=>[98.418,-79.737,44.940,1],
81158=>[98.445,-79.745,44.929,1],
81159=>[98.472,-79.755,44.920,1],
81160=>[98.499,-79.766,44.912,1],
81161=>[98.526,-79.776,44.904,1],
81162=>[98.558,-79.786,44.896,1],
81163=>[98.590,-79.795,44.889,1],
81164=>[98.623,-79.805,44.883,1],
81165=>[98.656,-79.814,44.876,1],
81166=>[98.680,-79.816,44.871,1],
81167=>[98.695,-79.809,44.865,1],
81168=>[98.709,-79.802,44.860,1],
81169=>[98.723,-79.795,44.853,1],
81170=>[98.743,-79.801,44.846,1],
81171=>[98.765,-79.808,44.840,1],
81172=>[98.786,-79.816,44.834,1],
81173=>[98.807,-79.824,44.828,1],
81174=>[98.828,-79.831,44.822,1],
81175=>[98.849,-79.839,44.815,1],
81176=>[98.871,-79.847,44.810,1],
81177=>[98.893,-79.855,44.804,1],
81178=>[98.915,-79.863,44.797,1],
81179=>[98.940,-79.864,44.789,1],
81180=>[98.965,-79.864,44.782,1],
81181=>[98.991,-79.865,44.775,1],
81182=>[99.009,-79.863,44.768,1],
81183=>[99.033,-79.877,44.761,1],
81184=>[99.057,-79.891,44.755,1],
81185=>[99.077,-79.908,44.749,1],
81186=>[99.096,-79.925,44.745,1],
81187=>[99.116,-79.942,44.740,1],
81188=>[99.135,-79.958,44.734,1],
81189=>[99.166,-79.971,44.727,1],
81190=>[99.198,-79.984,44.720,1],
81191=>[99.229,-79.996,44.714,1],
81192=>[99.261,-80.009,44.709,1],
81193=>[99.290,-80.019,44.705,1],
81194=>[99.313,-80.024,44.699,1],
81195=>[99.337,-80.028,44.693,1],
81196=>[99.360,-80.034,44.687,1],
81197=>[99.383,-80.038,44.679,1],
81198=>[99.406,-80.043,44.673,1],
81199=>[99.426,-80.046,44.667,1],
81200=>[99.439,-80.044,44.660,1],
81201=>[99.476,-80.053,44.654,1],
81202=>[99.521,-80.065,44.647,1],
81203=>[99.550,-80.055,44.638,1],
81204=>[99.552,-80.077,44.630,1],
81205=>[99.544,-80.115,44.621,1],
81206=>[99.536,-80.152,44.611,1],
81207=>[99.532,-80.184,44.602,1],
81208=>[99.535,-80.206,44.594,1],
81209=>[99.538,-80.228,44.586,1],
81210=>[99.541,-80.250,44.578,1],
81211=>[99.545,-80.272,44.570,1],
81212=>[99.548,-80.295,44.561,1],
81213=>[99.551,-80.317,44.553,1],
81214=>[99.554,-80.339,44.546,1],
81215=>[99.557,-80.361,44.538,1],
81216=>[99.561,-80.383,44.530,1],
81217=>[99.564,-80.406,44.522,1],
81218=>[99.567,-80.428,44.513,1],
81219=>[99.570,-80.450,44.505,1],
81220=>[99.573,-80.472,44.496,1],
81221=>[99.577,-80.494,44.486,1],
81222=>[99.580,-80.516,44.476,1],
81223=>[99.603,-80.532,44.466,1],
81224=>[99.650,-80.537,44.456,1],
81225=>[99.698,-80.542,44.445,1],
81226=>[99.746,-80.548,44.435,1],
81227=>[99.794,-80.554,44.424,1],
81228=>[99.842,-80.560,44.412,1],
81229=>[99.890,-80.565,44.400,1],
81230=>[99.938,-80.570,44.388,1],
81231=>[99.986,-80.576,44.376,1],
81232=>[100.034,-80.582,44.365,1],
81233=>[100.081,-80.588,44.353,1],
81234=>[100.130,-80.593,44.341,1],
81528=>[93.556,-78.814,53.581,1],
81529=>[93.565,-78.811,53.571,1],
81530=>[93.575,-78.809,53.563,1],
81531=>[93.584,-78.807,53.556,1],
81532=>[93.594,-78.804,53.549,1],
81533=>[93.604,-78.802,53.543,1],
81534=>[93.614,-78.799,53.539,1],
81535=>[93.623,-78.797,53.535,1],
81536=>[93.633,-78.794,53.534,1],
81537=>[93.642,-78.792,53.535,1],
81538=>[93.647,-78.789,53.539,1],
81539=>[93.650,-78.784,53.541,1],
81540=>[93.654,-78.780,53.540,1],
81541=>[93.663,-78.778,53.538,1],
81542=>[93.669,-78.774,53.534,1],
81543=>[93.675,-78.769,53.528,1],
81544=>[93.680,-78.764,53.519,1],
81545=>[93.688,-78.759,53.509,1],
81546=>[93.712,-78.742,53.498,1],
81547=>[93.736,-78.727,53.485,1],
81548=>[93.760,-78.710,53.470,1],
81549=>[93.784,-78.694,53.454,1],
81550=>[93.804,-78.682,53.437,1],
81551=>[93.807,-78.673,53.419,1],
81552=>[93.811,-78.664,53.399,1],
81553=>[93.814,-78.656,53.379,1],
81554=>[93.818,-78.648,53.359,1],
81555=>[93.821,-78.639,53.339,1],
81556=>[93.825,-78.630,53.319,1],
81557=>[93.828,-78.622,53.298,1],
81558=>[93.831,-78.614,53.277,1],
81559=>[93.844,-78.604,53.255,1],
81560=>[93.857,-78.591,53.232,1],
81561=>[93.869,-78.578,53.210,1],
81562=>[93.882,-78.565,53.187,1],
81563=>[93.895,-78.552,53.164,1],
81564=>[93.908,-78.539,53.140,1],
81565=>[93.920,-78.526,53.115,1],
81566=>[93.933,-78.514,53.090,1],
81567=>[93.945,-78.509,53.066,1],
81568=>[93.956,-78.515,53.041,1],
81569=>[93.967,-78.522,53.018,1],
81570=>[93.977,-78.528,52.996,1],
81571=>[93.988,-78.535,52.975,1],
81572=>[93.999,-78.541,52.957,1],
81573=>[94.009,-78.548,52.939,1],
81574=>[94.020,-78.554,52.921,1],
81575=>[94.031,-78.561,52.903,1],
81576=>[94.042,-78.567,52.885,1],
81577=>[94.052,-78.570,52.863,1],
81578=>[94.060,-78.569,52.838,1],
81579=>[94.055,-78.535,52.813,1],
81580=>[94.060,-78.511,52.788,1],
81581=>[94.074,-78.480,52.762,1],
81582=>[94.114,-78.466,52.736,1],
81583=>[94.158,-78.456,52.714,1],
81584=>[94.203,-78.447,52.693,1],
81585=>[94.248,-78.438,52.674,1],
81586=>[94.292,-78.428,52.656,1],
81587=>[94.336,-78.421,52.637,1],
81588=>[94.343,-78.511,52.619,1],
81589=>[94.355,-78.545,52.602,1],
81590=>[94.370,-78.552,52.584,1],
81591=>[94.385,-78.559,52.565,1],
81592=>[94.387,-78.569,52.544,1],
81593=>[94.379,-78.580,52.521,1],
81594=>[94.371,-78.592,52.499,1],
81595=>[94.363,-78.604,52.478,1],
81596=>[94.356,-78.617,52.456,1],
81597=>[94.348,-78.629,52.436,1],
81598=>[94.340,-78.641,52.414,1],
81599=>[94.349,-78.636,52.390,1],
81600=>[94.365,-78.624,52.367,1],
81601=>[94.382,-78.611,52.343,1],
81602=>[94.398,-78.599,52.319,1],
81603=>[94.414,-78.587,52.294,1],
81604=>[94.430,-78.574,52.268,1],
81605=>[94.445,-78.561,52.239,1],
81606=>[94.453,-78.547,52.208,1],
81607=>[94.466,-78.553,52.173,1],
81608=>[94.479,-78.560,52.137,1],
81609=>[94.493,-78.566,52.100,1],
81610=>[94.506,-78.573,52.062,1],
81611=>[94.520,-78.579,52.024,1],
81612=>[94.532,-78.586,51.987,1],
81613=>[94.542,-78.602,51.951,1],
81614=>[94.550,-78.611,51.915,1],
81615=>[94.558,-78.620,51.878,1],
81616=>[94.568,-78.623,51.841,1],
81617=>[94.580,-78.623,51.804,1],
81618=>[94.593,-78.623,51.767,1],
81619=>[94.605,-78.622,51.729,1],
81620=>[94.617,-78.621,51.690,1],
81621=>[94.629,-78.621,51.648,1],
81622=>[94.642,-78.620,51.606,1],
81623=>[94.654,-78.620,51.566,1],
81624=>[94.666,-78.620,51.527,1],
81625=>[94.679,-78.620,51.488,1],
81626=>[94.692,-78.623,51.448,1],
81627=>[94.705,-78.624,51.409,1],
81628=>[94.718,-78.626,51.371,1],
81629=>[94.740,-78.631,51.332,1],
81630=>[94.758,-78.634,51.293,1],
81631=>[94.777,-78.638,51.253,1],
81632=>[94.796,-78.642,51.214,1],
81633=>[94.815,-78.645,51.174,1],
81634=>[94.834,-78.648,51.133,1],
81635=>[94.846,-78.654,51.093,1],
81636=>[94.852,-78.661,51.053,1],
81637=>[94.858,-78.669,51.013,1],
81638=>[94.867,-78.656,50.974,1],
81639=>[94.876,-78.643,50.933,1],
81640=>[94.886,-78.630,50.891,1],
81641=>[94.895,-78.617,50.847,1],
81642=>[94.904,-78.604,50.802,1],
81643=>[94.932,-78.600,50.756,1],
81644=>[94.970,-78.598,50.708,1],
81645=>[95.007,-78.598,50.659,1],
81646=>[95.044,-78.596,50.608,1],
81647=>[95.056,-78.595,50.556,1],
81648=>[95.048,-78.595,50.507,1],
81649=>[95.041,-78.595,50.459,1],
81650=>[95.033,-78.594,50.412,1],
81651=>[95.025,-78.593,50.366,1],
81652=>[95.018,-78.592,50.323,1],
81653=>[95.010,-78.592,50.280,1],
81654=>[95.010,-78.596,50.237,1],
81655=>[95.016,-78.607,50.194,1],
81656=>[95.017,-78.620,50.153,1],
81657=>[95.023,-78.632,50.111,1],
81658=>[95.038,-78.636,50.069,1],
81659=>[95.053,-78.640,50.027,1],
81660=>[95.068,-78.645,49.985,1],
81661=>[95.083,-78.649,49.944,1],
81662=>[95.097,-78.654,49.903,1],
81663=>[95.112,-78.658,49.865,1],
81664=>[95.127,-78.663,49.829,1],
81665=>[95.142,-78.667,49.793,1],
81666=>[95.157,-78.671,49.757,1],
81667=>[95.171,-78.676,49.719,1],
81668=>[95.186,-78.680,49.680,1],
81669=>[95.201,-78.685,49.640,1],
81670=>[95.219,-78.683,49.600,1],
81671=>[95.176,-78.689,49.560,1],
81672=>[95.174,-78.703,49.521,1],
81673=>[95.203,-78.723,49.480,1],
81674=>[95.233,-78.742,49.440,1],
81675=>[95.262,-78.762,49.401,1],
81676=>[95.290,-78.782,49.363,1],
81677=>[95.320,-78.802,49.324,1],
81678=>[95.349,-78.821,49.284,1],
81679=>[95.372,-78.836,49.245,1],
81680=>[95.392,-78.848,49.207,1],
81681=>[95.411,-78.860,49.169,1],
81682=>[95.425,-78.858,49.130,1],
81683=>[95.440,-78.856,49.091,1],
81684=>[95.453,-78.854,49.051,1],
81685=>[95.462,-78.847,49.011,1],
81686=>[95.466,-78.836,48.971,1],
81687=>[95.470,-78.824,48.929,1],
81688=>[95.474,-78.813,48.886,1],
81689=>[95.478,-78.802,48.841,1],
81690=>[95.482,-78.790,48.798,1],
81691=>[95.494,-78.785,48.754,1],
81692=>[95.517,-78.787,48.710,1],
81693=>[95.541,-78.789,48.667,1],
81694=>[95.564,-78.791,48.624,1],
81695=>[95.581,-78.796,48.581,1],
81696=>[95.587,-78.806,48.538,1],
81697=>[95.593,-78.817,48.496,1],
81698=>[95.599,-78.827,48.454,1],
81699=>[95.605,-78.837,48.411,1],
81700=>[95.611,-78.848,48.371,1],
81701=>[95.617,-78.858,48.331,1],
81702=>[95.623,-78.869,48.292,1],
81703=>[95.629,-78.879,48.254,1],
81704=>[95.635,-78.890,48.217,1],
81705=>[95.649,-78.903,48.180,1],
81706=>[95.665,-78.907,48.143,1],
81707=>[95.683,-78.912,48.102,1],
81708=>[95.707,-78.917,48.061,1],
81709=>[95.731,-78.922,48.019,1],
81710=>[95.755,-78.927,47.976,1],
81711=>[95.779,-78.933,47.932,1],
81712=>[95.803,-78.938,47.888,1],
81713=>[95.827,-78.943,47.845,1],
81714=>[95.850,-78.949,47.802,1],
81715=>[95.862,-78.963,47.760,1],
81716=>[95.874,-78.978,47.718,1],
81717=>[95.894,-78.980,47.676,1],
81718=>[95.918,-78.975,47.636,1],
81719=>[95.943,-78.971,47.595,1],
81720=>[95.967,-78.967,47.554,1],
81721=>[95.991,-78.963,47.513,1],
81722=>[96.016,-78.959,47.473,1],
81723=>[96.039,-78.953,47.433,1],
81724=>[96.062,-78.947,47.392,1],
81725=>[96.085,-78.941,47.352,1],
81726=>[96.108,-78.935,47.312,1],
81727=>[96.131,-78.929,47.273,1],
81728=>[96.168,-78.929,47.234,1],
81729=>[96.208,-78.930,47.197,1],
81730=>[96.243,-78.925,47.160,1],
81731=>[96.276,-78.918,47.124,1],
81732=>[96.304,-78.908,47.090,1],
81733=>[96.329,-78.899,47.057,1],
81734=>[96.354,-78.890,47.025,1],
81735=>[96.379,-78.881,46.994,1],
81736=>[96.398,-78.877,46.963,1],
81737=>[96.399,-78.883,46.932,1],
81738=>[96.401,-78.889,46.902,1],
81739=>[96.402,-78.896,46.871,1],
81740=>[96.403,-78.902,46.841,1],
81741=>[96.406,-78.910,46.810,1],
81742=>[96.417,-78.921,46.777,1],
81743=>[96.427,-78.924,46.744,1],
81744=>[96.437,-78.927,46.712,1],
81745=>[96.446,-78.930,46.678,1],
81746=>[96.474,-78.935,46.647,1],
81747=>[96.518,-78.930,46.617,1],
81748=>[96.563,-78.930,46.587,1],
81749=>[96.608,-78.930,46.560,1],
81750=>[96.654,-78.930,46.531,1],
81751=>[96.699,-78.930,46.503,1],
81752=>[96.744,-78.930,46.475,1],
81753=>[96.790,-78.930,46.450,1],
81754=>[96.832,-78.927,46.427,1],
81755=>[96.851,-78.923,46.404,1],
81756=>[96.861,-78.922,46.382,1],
81757=>[96.871,-78.926,46.360,1],
81758=>[96.892,-78.916,46.338,1],
81759=>[96.904,-78.909,46.316,1],
81760=>[96.916,-78.902,46.295,1],
81761=>[96.915,-78.864,46.275,1],
81762=>[96.905,-78.871,46.256,1],
81763=>[96.907,-78.878,46.237,1],
81764=>[96.938,-78.899,46.217,1],
81765=>[96.966,-78.921,46.196,1],
81766=>[96.995,-78.943,46.176,1],
81767=>[96.996,-78.961,46.157,1],
81768=>[96.995,-78.978,46.138,1],
81769=>[96.994,-78.995,46.121,1],
81770=>[96.993,-79.012,46.103,1],
81771=>[96.990,-79.028,46.086,1],
81772=>[96.983,-79.043,46.069,1],
81773=>[96.994,-79.077,46.051,1],
81774=>[97.015,-79.123,46.035,1],
81775=>[97.036,-79.170,46.019,1],
81776=>[97.057,-79.216,46.003,1],
81777=>[97.078,-79.245,45.989,1],
81778=>[97.098,-79.240,45.974,1],
81779=>[97.118,-79.234,45.959,1],
81780=>[97.139,-79.229,45.944,1],
81781=>[97.148,-79.200,45.928,1],
81782=>[97.157,-79.169,45.913,1],
81783=>[97.166,-79.137,45.900,1],
81784=>[97.175,-79.107,45.885,1],
81785=>[97.185,-79.085,45.869,1],
81786=>[97.201,-79.093,45.854,1],
81787=>[97.215,-79.100,45.837,1],
81788=>[97.230,-79.109,45.823,1],
81789=>[97.247,-79.119,45.808,1],
81790=>[97.260,-79.128,45.791,1],
81791=>[97.275,-79.138,45.774,1],
81792=>[97.288,-79.148,45.759,1],
81793=>[97.302,-79.157,45.745,1],
81794=>[97.316,-79.167,45.728,1],
81795=>[97.329,-79.177,45.714,1],
81796=>[97.344,-79.187,45.701,1],
81797=>[97.357,-79.196,45.687,1],
81798=>[97.371,-79.206,45.673,1],
81799=>[97.385,-79.216,45.658,1],
81800=>[97.399,-79.225,45.642,1],
81801=>[97.413,-79.234,45.627,1],
81802=>[97.421,-79.241,45.613,1],
81803=>[97.432,-79.244,45.600,1],
81804=>[97.443,-79.247,45.585,1],
81805=>[97.454,-79.250,45.572,1],
81806=>[97.465,-79.253,45.559,1],
81807=>[97.480,-79.256,45.546,1],
81808=>[97.495,-79.258,45.532,1],
81809=>[97.510,-79.261,45.519,1],
81810=>[97.524,-79.264,45.505,1],
81811=>[97.539,-79.267,45.488,1],
81812=>[97.554,-79.270,45.470,1],
81813=>[97.571,-79.275,45.450,1],
81814=>[97.591,-79.284,45.428,1],
81815=>[97.610,-79.292,45.407,1],
81816=>[97.630,-79.300,45.388,1],
81817=>[97.650,-79.309,45.370,1],
81818=>[97.670,-79.318,45.353,1],
81819=>[97.674,-79.319,45.339,1],
81820=>[97.674,-79.319,45.325,1],
81821=>[97.674,-79.318,45.312,1],
81822=>[97.674,-79.318,45.301,1],
81823=>[97.690,-79.336,45.290,1],
81824=>[97.709,-79.357,45.280,1],
81825=>[97.727,-79.377,45.270,1],
81826=>[97.745,-79.397,45.261,1],
81827=>[97.764,-79.418,45.251,1],
81828=>[97.782,-79.438,45.241,1],
81829=>[97.796,-79.456,45.229,1],
81830=>[97.806,-79.471,45.216,1],
81831=>[97.816,-79.486,45.205,1],
81832=>[97.828,-79.501,45.192,1],
81833=>[97.842,-79.515,45.180,1],
81834=>[97.855,-79.529,45.168,1],
81835=>[97.867,-79.541,45.155,1],
81836=>[97.878,-79.553,45.144,1],
81837=>[97.890,-79.564,45.134,1],
81838=>[97.901,-79.576,45.125,1],
81839=>[97.913,-79.588,45.116,1],
81840=>[97.925,-79.600,45.109,1],
81841=>[97.937,-79.611,45.101,1],
81842=>[97.958,-79.623,45.093,1],
81843=>[97.984,-79.632,45.085,1],
81844=>[98.012,-79.641,45.077,1],
81845=>[98.040,-79.650,45.071,1],
81846=>[98.069,-79.659,45.065,1],
81847=>[98.097,-79.667,45.057,1],
81848=>[98.134,-79.659,45.049,1],
81849=>[98.171,-79.650,45.041,1],
81850=>[98.208,-79.641,45.032,1],
81851=>[98.241,-79.661,45.022,1],
81852=>[98.277,-79.685,45.012,1],
81853=>[98.303,-79.692,45.002,1],
81854=>[98.329,-79.698,44.991,1],
81855=>[98.356,-79.704,44.981,1],
81856=>[98.382,-79.711,44.969,1],
81857=>[98.409,-79.717,44.960,1],
81858=>[98.435,-79.724,44.950,1],
81859=>[98.462,-79.734,44.940,1],
81860=>[98.489,-79.745,44.930,1],
81861=>[98.516,-79.755,44.922,1],
81862=>[98.544,-79.765,44.914,1],
81863=>[98.572,-79.775,44.908,1],
81864=>[98.604,-79.784,44.902,1],
81865=>[98.637,-79.794,44.896,1],
81866=>[98.670,-79.803,44.889,1],
81867=>[98.688,-79.799,44.884,1],
81868=>[98.703,-79.792,44.879,1],
81869=>[98.717,-79.786,44.873,1],
81870=>[98.731,-79.779,44.867,1],
81871=>[98.749,-79.780,44.861,1],
81872=>[98.770,-79.787,44.854,1],
81873=>[98.791,-79.794,44.849,1],
81874=>[98.812,-79.802,44.843,1],
81875=>[98.833,-79.809,44.837,1],
81876=>[98.855,-79.817,44.830,1],
81877=>[98.877,-79.825,44.824,1],
81878=>[98.899,-79.833,44.818,1],
81879=>[98.920,-79.842,44.812,1],
81880=>[98.942,-79.849,44.804,1],
81881=>[98.968,-79.851,44.797,1],
81882=>[98.993,-79.852,44.790,1],
81883=>[99.015,-79.851,44.783,1],
81884=>[99.037,-79.861,44.776,1],
81885=>[99.061,-79.875,44.769,1],
81886=>[99.083,-79.890,44.763,1],
81887=>[99.102,-79.908,44.758,1],
81888=>[99.122,-79.924,44.752,1],
81889=>[99.144,-79.940,44.746,1],
81890=>[99.176,-79.953,44.739,1],
81891=>[99.208,-79.965,44.731,1],
81892=>[99.239,-79.978,44.724,1],
81893=>[99.266,-79.986,44.718,1],
81894=>[99.289,-79.990,44.711,1],
81895=>[99.312,-79.996,44.704,1],
81896=>[99.336,-80.000,44.697,1],
81897=>[99.359,-80.005,44.689,1],
81898=>[99.382,-80.009,44.683,1],
81899=>[99.406,-80.015,44.676,1],
81900=>[99.429,-80.019,44.670,1],
81901=>[99.452,-80.024,44.664,1],
81902=>[99.475,-80.028,44.658,1],
81903=>[99.493,-80.030,44.650,1],
81904=>[99.523,-80.036,44.642,1],
81905=>[99.562,-80.039,44.634,1],
81906=>[99.565,-80.059,44.625,1],
81907=>[99.556,-80.096,44.616,1],
81908=>[99.548,-80.134,44.608,1],
81909=>[99.540,-80.171,44.598,1],
81910=>[99.535,-80.206,44.590,1],
81911=>[99.538,-80.228,44.583,1],
81912=>[99.541,-80.250,44.574,1],
81913=>[99.544,-80.272,44.566,1],
81914=>[99.548,-80.294,44.558,1],
81915=>[99.551,-80.316,44.551,1],
81916=>[99.554,-80.338,44.543,1],
81917=>[99.557,-80.360,44.535,1],
81918=>[99.560,-80.383,44.527,1],
81919=>[99.564,-80.405,44.518,1],
81920=>[99.567,-80.427,44.510,1],
81921=>[99.570,-80.449,44.501,1],
81922=>[99.573,-80.471,44.491,1],
81923=>[99.576,-80.494,44.481,1],
81924=>[99.611,-80.504,44.471,1],
81925=>[99.658,-80.510,44.462,1],
81926=>[99.706,-80.516,44.451,1],
81927=>[99.755,-80.521,44.439,1],
81928=>[99.802,-80.526,44.428,1],
81929=>[99.850,-80.532,44.416,1],
81930=>[99.898,-80.538,44.404,1],
81931=>[99.946,-80.543,44.393,1],
81932=>[99.994,-80.549,44.380,1],
81933=>[100.042,-80.554,44.369,1],
81934=>[100.092,-80.565,44.357,1],
81935=>[100.143,-80.578,44.344,1],
82229=>[93.556,-78.803,53.589,1],
82230=>[93.565,-78.801,53.581,1],
82231=>[93.575,-78.798,53.572,1],
82232=>[93.585,-78.796,53.565,1],
82233=>[93.594,-78.793,53.558,1],
82234=>[93.604,-78.791,53.552,1],
82235=>[93.614,-78.788,53.547,1],
82236=>[93.624,-78.786,53.544,1],
82237=>[93.633,-78.783,53.542,1],
82238=>[93.641,-78.780,53.541,1],
82239=>[93.641,-78.783,53.545,1],
82240=>[93.644,-78.778,53.547,1],
82241=>[93.648,-78.774,53.547,1],
82242=>[93.658,-78.774,53.548,1],
82243=>[93.666,-78.772,53.544,1],
82244=>[93.672,-78.767,53.537,1],
82245=>[93.678,-78.763,53.529,1],
82246=>[93.700,-78.747,53.520,1],
82247=>[93.724,-78.731,53.508,1],
82248=>[93.749,-78.714,53.494,1],
82249=>[93.770,-78.698,53.478,1],
82250=>[93.789,-78.681,53.462,1],
82251=>[93.801,-78.667,53.444,1],
82252=>[93.804,-78.659,53.425,1],
82253=>[93.808,-78.651,53.406,1],
82254=>[93.812,-78.642,53.387,1],
82255=>[93.815,-78.634,53.367,1],
82256=>[93.818,-78.625,53.347,1],
82257=>[93.822,-78.617,53.326,1],
82258=>[93.825,-78.608,53.304,1],
82259=>[93.828,-78.596,53.282,1],
82260=>[93.840,-78.589,53.259,1],
82261=>[93.852,-78.577,53.236,1],
82262=>[93.865,-78.564,53.214,1],
82263=>[93.878,-78.551,53.191,1],
82264=>[93.891,-78.539,53.167,1],
82265=>[93.903,-78.526,53.143,1],
82266=>[93.916,-78.514,53.119,1],
82267=>[93.928,-78.501,53.094,1],
82268=>[93.950,-78.498,53.070,1],
82269=>[93.960,-78.504,53.046,1],
82270=>[93.970,-78.510,53.025,1],
82271=>[93.980,-78.516,53.004,1],
82272=>[93.991,-78.521,52.983,1],
82273=>[94.001,-78.527,52.965,1],
82274=>[94.011,-78.532,52.946,1],
82275=>[94.022,-78.539,52.928,1],
82276=>[94.032,-78.545,52.911,1],
82277=>[94.043,-78.550,52.892,1],
82278=>[94.053,-78.556,52.871,1],
82279=>[94.066,-78.556,52.847,1],
82280=>[94.072,-78.532,52.822,1],
82281=>[94.077,-78.509,52.797,1],
82282=>[94.087,-78.481,52.771,1],
82283=>[94.107,-78.445,52.745,1],
82284=>[94.137,-78.422,52.724,1],
82285=>[94.182,-78.413,52.704,1],
82286=>[94.226,-78.403,52.685,1],
82287=>[94.271,-78.394,52.668,1],
82288=>[94.314,-78.388,52.650,1],
82289=>[94.321,-78.479,52.632,1],
82290=>[94.330,-78.547,52.616,1],
82291=>[94.345,-78.554,52.598,1],
82292=>[94.360,-78.560,52.578,1],
82293=>[94.375,-78.567,52.557,1],
82294=>[94.385,-78.575,52.536,1],
82295=>[94.377,-78.586,52.515,1],
82296=>[94.369,-78.598,52.494,1],
82297=>[94.362,-78.611,52.473,1],
82298=>[94.354,-78.623,52.451,1],
82299=>[94.346,-78.635,52.428,1],
82300=>[94.351,-78.634,52.404,1],
82301=>[94.367,-78.622,52.381,1],
82302=>[94.384,-78.610,52.357,1],
82303=>[94.400,-78.598,52.333,1],
82304=>[94.416,-78.585,52.309,1],
82305=>[94.431,-78.572,52.284,1],
82306=>[94.439,-78.557,52.255,1],
82307=>[94.448,-78.548,52.224,1],
82308=>[94.461,-78.554,52.189,1],
82309=>[94.474,-78.561,52.154,1],
82310=>[94.488,-78.567,52.118,1],
82311=>[94.501,-78.574,52.080,1],
82312=>[94.514,-78.580,52.043,1],
82313=>[94.530,-78.585,52.006,1],
82314=>[94.546,-78.589,51.973,1],
82315=>[94.552,-78.592,51.937,1],
82316=>[94.560,-78.600,51.901,1],
82317=>[94.569,-78.607,51.864,1],
82318=>[94.581,-78.606,51.826,1],
82319=>[94.593,-78.606,51.789,1],
82320=>[94.606,-78.605,51.751,1],
82321=>[94.618,-78.604,51.712,1],
82322=>[94.630,-78.606,51.668,1],
82323=>[94.643,-78.608,51.624,1],
82324=>[94.657,-78.611,51.581,1],
82325=>[94.670,-78.612,51.541,1],
82326=>[94.683,-78.614,51.500,1],
82327=>[94.695,-78.617,51.460,1],
82328=>[94.708,-78.618,51.419,1],
82329=>[94.722,-78.620,51.380,1],
82330=>[94.743,-78.625,51.341,1],
82331=>[94.764,-78.629,51.301,1],
82332=>[94.784,-78.633,51.260,1],
82333=>[94.803,-78.636,51.219,1],
82334=>[94.821,-78.640,51.179,1],
82335=>[94.840,-78.643,51.137,1],
82336=>[94.856,-78.648,51.095,1],
82337=>[94.862,-78.655,51.054,1],
82338=>[94.868,-78.659,51.013,1],
82339=>[94.878,-78.646,50.973,1],
82340=>[94.887,-78.633,50.931,1],
82341=>[94.896,-78.620,50.889,1],
82342=>[94.905,-78.608,50.846,1],
82343=>[94.937,-78.604,50.800,1],
82344=>[94.974,-78.603,50.752,1],
82345=>[95.012,-78.601,50.704,1],
82346=>[95.049,-78.601,50.654,1],
82347=>[95.086,-78.600,50.604,1],
82348=>[95.098,-78.598,50.555,1],
82349=>[95.091,-78.598,50.506,1],
82350=>[95.083,-78.598,50.459,1],
82351=>[95.075,-78.597,50.413,1],
82352=>[95.067,-78.596,50.367,1],
82353=>[95.060,-78.595,50.323,1],
82354=>[95.052,-78.595,50.279,1],
82355=>[95.044,-78.594,50.236,1],
82356=>[95.037,-78.593,50.195,1],
82357=>[95.036,-78.600,50.154,1],
82358=>[95.047,-78.607,50.112,1],
82359=>[95.062,-78.611,50.069,1],
82360=>[95.077,-78.616,50.028,1],
82361=>[95.092,-78.620,49.986,1],
82362=>[95.107,-78.624,49.945,1],
82363=>[95.121,-78.629,49.905,1],
82364=>[95.131,-78.632,49.867,1],
82365=>[95.140,-78.636,49.830,1],
82366=>[95.149,-78.639,49.795,1],
82367=>[95.159,-78.642,49.758,1],
82368=>[95.169,-78.645,49.720,1],
82369=>[95.178,-78.648,49.680,1],
82370=>[95.188,-78.652,49.642,1],
82371=>[95.196,-78.657,49.603,1],
82372=>[95.177,-78.664,49.564,1],
82373=>[95.192,-78.686,49.524,1],
82374=>[95.208,-78.708,49.483,1],
82375=>[95.225,-78.731,49.443,1],
82376=>[95.253,-78.751,49.404,1],
82377=>[95.282,-78.771,49.367,1],
82378=>[95.312,-78.790,49.329,1],
82379=>[95.341,-78.810,49.291,1],
82380=>[95.370,-78.830,49.252,1],
82381=>[95.392,-78.843,49.213,1],
82382=>[95.411,-78.855,49.173,1],
82383=>[95.426,-78.855,49.134,1],
82384=>[95.440,-78.852,49.095,1],
82385=>[95.449,-78.846,49.056,1],
82386=>[95.453,-78.834,49.016,1],
82387=>[95.457,-78.823,48.975,1],
82388=>[95.460,-78.811,48.934,1],
82389=>[95.464,-78.800,48.892,1],
82390=>[95.468,-78.789,48.848,1],
82391=>[95.472,-78.777,48.804,1],
82392=>[95.483,-78.771,48.760,1],
82393=>[95.507,-78.774,48.716,1],
82394=>[95.530,-78.775,48.672,1],
82395=>[95.554,-78.777,48.629,1],
82396=>[95.577,-78.779,48.587,1],
82397=>[95.590,-78.786,48.544,1],
82398=>[95.596,-78.797,48.502,1],
82399=>[95.602,-78.808,48.460,1],
82400=>[95.607,-78.818,48.419,1],
82401=>[95.613,-78.828,48.378,1],
82402=>[95.619,-78.839,48.339,1],
82403=>[95.625,-78.849,48.300,1],
82404=>[95.631,-78.860,48.263,1],
82405=>[95.637,-78.870,48.226,1],
82406=>[95.645,-78.878,48.191,1],
82407=>[95.670,-78.886,48.154,1],
82408=>[95.694,-78.892,48.114,1],
82409=>[95.718,-78.897,48.073,1],
82410=>[95.742,-78.902,48.031,1],
82411=>[95.766,-78.908,47.988,1],
82412=>[95.790,-78.913,47.945,1],
82413=>[95.814,-78.918,47.901,1],
82414=>[95.837,-78.924,47.858,1],
82415=>[95.849,-78.938,47.815,1],
82416=>[95.861,-78.953,47.772,1],
82417=>[95.872,-78.968,47.730,1],
82418=>[95.893,-78.968,47.687,1],
82419=>[95.918,-78.964,47.648,1],
82420=>[95.942,-78.959,47.608,1],
82421=>[95.966,-78.955,47.567,1],
82422=>[95.990,-78.951,47.527,1],
82423=>[96.015,-78.947,47.487,1],
82424=>[96.039,-78.943,47.447,1],
82425=>[96.063,-78.939,47.405,1],
82426=>[96.088,-78.934,47.364,1],
82427=>[96.111,-78.928,47.323,1],
82428=>[96.134,-78.922,47.283,1],
82429=>[96.168,-78.921,47.245,1],
82430=>[96.204,-78.918,47.208,1],
82431=>[96.234,-78.909,47.171,1],
82432=>[96.259,-78.900,47.133,1],
82433=>[96.285,-78.891,47.099,1],
82434=>[96.310,-78.882,47.066,1],
82435=>[96.335,-78.873,47.033,1],
82436=>[96.360,-78.864,47.002,1],
82437=>[96.382,-78.856,46.971,1],
82438=>[96.384,-78.863,46.939,1],
82439=>[96.385,-78.869,46.909,1],
82440=>[96.386,-78.876,46.880,1],
82441=>[96.388,-78.882,46.849,1],
82442=>[96.397,-78.897,46.818,1],
82443=>[96.408,-78.914,46.785,1],
82444=>[96.418,-78.916,46.752,1],
82445=>[96.428,-78.919,46.719,1],
82446=>[96.437,-78.921,46.686,1],
82447=>[96.466,-78.923,46.655,1],
82448=>[96.512,-78.922,46.625,1],
82449=>[96.557,-78.922,46.596,1],
82450=>[96.602,-78.922,46.568,1],
82451=>[96.648,-78.922,46.540,1],
82452=>[96.693,-78.922,46.512,1],
82453=>[96.738,-78.921,46.485,1],
82454=>[96.781,-78.919,46.461,1],
82455=>[96.822,-78.915,46.438,1],
82456=>[96.847,-78.911,46.417,1],
82457=>[96.858,-78.908,46.395,1],
82458=>[96.868,-78.905,46.373,1],
82459=>[96.878,-78.906,46.351,1],
82460=>[96.895,-78.899,46.331,1],
82461=>[96.907,-78.893,46.309,1],
82462=>[96.904,-78.870,46.288,1],
82463=>[96.909,-78.872,46.268,1],
82464=>[96.918,-78.878,46.247,1],
82465=>[96.934,-78.900,46.228,1],
82466=>[96.964,-78.919,46.208,1],
82467=>[96.995,-78.940,46.188,1],
82468=>[97.006,-78.959,46.170,1],
82469=>[97.005,-78.976,46.152,1],
82470=>[96.999,-78.991,46.135,1],
82471=>[96.993,-79.006,46.118,1],
82472=>[96.986,-79.021,46.100,1],
82473=>[96.980,-79.036,46.082,1],
82474=>[96.991,-79.071,46.065,1],
82475=>[97.012,-79.117,46.050,1],
82476=>[97.033,-79.164,46.035,1],
82477=>[97.054,-79.210,46.020,1],
82478=>[97.075,-79.215,46.006,1],
82479=>[97.095,-79.210,45.990,1],
82480=>[97.115,-79.205,45.975,1],
82481=>[97.136,-79.200,45.960,1],
82482=>[97.156,-79.194,45.944,1],
82483=>[97.167,-79.169,45.930,1],
82484=>[97.176,-79.137,45.916,1],
82485=>[97.185,-79.106,45.901,1],
82486=>[97.196,-79.088,45.886,1],
82487=>[97.211,-79.096,45.870,1],
82488=>[97.226,-79.103,45.855,1],
82489=>[97.238,-79.109,45.840,1],
82490=>[97.248,-79.115,45.825,1],
82491=>[97.261,-79.125,45.808,1],
82492=>[97.275,-79.134,45.791,1],
82493=>[97.289,-79.143,45.776,1],
82494=>[97.303,-79.153,45.761,1],
82495=>[97.316,-79.162,45.744,1],
82496=>[97.330,-79.172,45.731,1],
82497=>[97.344,-79.181,45.717,1],
82498=>[97.358,-79.190,45.702,1],
82499=>[97.371,-79.200,45.688,1],
82500=>[97.385,-79.209,45.673,1],
82501=>[97.399,-79.219,45.658,1],
82502=>[97.413,-79.228,45.642,1],
82503=>[97.424,-79.236,45.627,1],
82504=>[97.435,-79.238,45.612,1],
82505=>[97.450,-79.241,45.596,1],
82506=>[97.465,-79.244,45.582,1],
82507=>[97.479,-79.247,45.569,1],
82508=>[97.494,-79.250,45.554,1],
82509=>[97.509,-79.253,45.539,1],
82510=>[97.523,-79.256,45.524,1],
82511=>[97.538,-79.259,45.509,1],
82512=>[97.553,-79.262,45.492,1],
82513=>[97.568,-79.265,45.474,1],
82514=>[97.586,-79.272,45.453,1],
82515=>[97.606,-79.281,45.431,1],
82516=>[97.626,-79.289,45.411,1],
82517=>[97.646,-79.297,45.393,1],
82518=>[97.665,-79.306,45.376,1],
82519=>[97.665,-79.306,45.361,1],
82520=>[97.665,-79.305,45.346,1],
82521=>[97.665,-79.304,45.332,1],
82522=>[97.665,-79.304,45.319,1],
82523=>[97.665,-79.303,45.307,1],
82524=>[97.682,-79.323,45.296,1],
82525=>[97.701,-79.344,45.286,1],
82526=>[97.719,-79.364,45.275,1],
82527=>[97.737,-79.385,45.265,1],
82528=>[97.756,-79.405,45.256,1],
82529=>[97.774,-79.426,45.246,1],
82530=>[97.792,-79.446,45.234,1],
82531=>[97.811,-79.466,45.222,1],
82532=>[97.823,-79.483,45.211,1],
82533=>[97.834,-79.498,45.198,1],
82534=>[97.847,-79.512,45.186,1],
82535=>[97.860,-79.524,45.175,1],
82536=>[97.871,-79.536,45.163,1],
82537=>[97.882,-79.548,45.152,1],
82538=>[97.894,-79.560,45.142,1],
82539=>[97.906,-79.571,45.133,1],
82540=>[97.917,-79.582,45.123,1],
82541=>[97.929,-79.595,45.116,1],
82542=>[97.940,-79.606,45.108,1],
82543=>[97.959,-79.617,45.099,1],
82544=>[97.986,-79.627,45.091,1],
82545=>[98.014,-79.636,45.083,1],
82546=>[98.042,-79.645,45.076,1],
82547=>[98.071,-79.653,45.069,1],
82548=>[98.108,-79.644,45.061,1],
82549=>[98.145,-79.635,45.053,1],
82550=>[98.182,-79.626,45.046,1],
82551=>[98.218,-79.616,45.037,1],
82552=>[98.251,-79.636,45.027,1],
82553=>[98.287,-79.661,45.018,1],
82554=>[98.320,-79.679,45.009,1],
82555=>[98.346,-79.685,44.999,1],
82556=>[98.372,-79.692,44.989,1],
82557=>[98.398,-79.698,44.978,1],
82558=>[98.425,-79.704,44.968,1],
82559=>[98.451,-79.712,44.959,1],
82560=>[98.479,-79.723,44.949,1],
82561=>[98.506,-79.733,44.941,1],
82562=>[98.533,-79.743,44.933,1],
82563=>[98.560,-79.754,44.925,1],
82564=>[98.587,-79.764,44.920,1],
82565=>[98.619,-79.773,44.914,1],
82566=>[98.652,-79.783,44.908,1],
82567=>[98.681,-79.789,44.902,1],
82568=>[98.696,-79.783,44.897,1],
82569=>[98.710,-79.776,44.892,1],
82570=>[98.725,-79.770,44.888,1],
82571=>[98.739,-79.763,44.882,1],
82572=>[98.755,-79.758,44.875,1],
82573=>[98.776,-79.765,44.869,1],
82574=>[98.796,-79.773,44.864,1],
82575=>[98.817,-79.780,44.858,1],
82576=>[98.839,-79.788,44.852,1],
82577=>[98.861,-79.796,44.845,1],
82578=>[98.882,-79.804,44.839,1],
82579=>[98.905,-79.812,44.833,1],
82580=>[98.926,-79.820,44.826,1],
82581=>[98.948,-79.828,44.819,1],
82582=>[98.970,-79.836,44.813,1],
82583=>[98.995,-79.838,44.806,1],
82584=>[99.020,-79.839,44.799,1],
82585=>[99.041,-79.846,44.792,1],
82586=>[99.065,-79.860,44.784,1],
82587=>[99.089,-79.874,44.776,1],
82588=>[99.110,-79.890,44.770,1],
82589=>[99.129,-79.907,44.764,1],
82590=>[99.154,-79.922,44.758,1],
82591=>[99.186,-79.934,44.750,1],
82592=>[99.218,-79.947,44.742,1],
82593=>[99.242,-79.952,44.733,1],
82594=>[99.265,-79.958,44.724,1],
82595=>[99.288,-79.962,44.717,1],
82596=>[99.311,-79.967,44.710,1],
82597=>[99.335,-79.971,44.702,1],
82598=>[99.358,-79.977,44.694,1],
82599=>[99.381,-79.981,44.687,1],
82600=>[99.405,-79.986,44.681,1],
82601=>[99.428,-79.990,44.674,1],
82602=>[99.451,-79.995,44.668,1],
82603=>[99.474,-80.000,44.661,1],
82604=>[99.497,-80.005,44.654,1],
82605=>[99.521,-80.009,44.647,1],
82606=>[99.544,-80.014,44.639,1],
82607=>[99.571,-80.019,44.630,1],
82608=>[99.577,-80.040,44.621,1],
82609=>[99.569,-80.078,44.612,1],
82610=>[99.561,-80.115,44.603,1],
82611=>[99.553,-80.153,44.595,1],
82612=>[99.544,-80.191,44.587,1],
82613=>[99.538,-80.227,44.579,1],
82614=>[99.541,-80.249,44.571,1],
82615=>[99.544,-80.272,44.563,1],
82616=>[99.547,-80.294,44.556,1],
82617=>[99.550,-80.316,44.548,1],
82618=>[99.554,-80.337,44.540,1],
82619=>[99.557,-80.359,44.532,1],
82620=>[99.560,-80.382,44.523,1],
82621=>[99.563,-80.404,44.515,1],
82622=>[99.566,-80.426,44.507,1],
82623=>[99.570,-80.448,44.497,1],
82624=>[99.573,-80.471,44.487,1],
82625=>[99.619,-80.477,44.477,1],
82626=>[99.667,-80.482,44.467,1],
82627=>[99.715,-80.488,44.456,1],
82628=>[99.763,-80.494,44.444,1],
82629=>[99.810,-80.499,44.432,1],
82630=>[99.858,-80.505,44.420,1],
82631=>[99.906,-80.510,44.409,1],
82632=>[99.955,-80.516,44.397,1],
82633=>[100.005,-80.527,44.384,1],
82634=>[100.056,-80.540,44.373,1],
82635=>[100.107,-80.553,44.361,1],
82636=>[100.158,-80.566,44.349,1],
82930=>[93.556,-78.793,53.597,1],
82931=>[93.566,-78.789,53.589,1],
82932=>[93.575,-78.787,53.581,1],
82933=>[93.585,-78.785,53.573,1],
82934=>[93.594,-78.783,53.566,1],
82935=>[93.605,-78.780,53.560,1],
82936=>[93.614,-78.777,53.555,1],
82937=>[93.624,-78.775,53.551,1],
82938=>[93.633,-78.773,53.548,1],
82939=>[93.638,-78.767,53.546,1],
82940=>[93.637,-78.758,53.549,1],
82941=>[93.638,-78.773,53.552,1],
82942=>[93.642,-78.769,53.554,1],
82943=>[93.652,-78.768,53.554,1],
82944=>[93.661,-78.767,53.551,1],
82945=>[93.669,-78.765,53.545,1],
82946=>[93.689,-78.752,53.536,1],
82947=>[93.708,-78.735,53.525,1],
82948=>[93.727,-78.718,53.513,1],
82949=>[93.747,-78.701,53.499,1],
82950=>[93.766,-78.684,53.484,1],
82951=>[93.785,-78.667,53.466,1],
82952=>[93.796,-78.655,53.448,1],
82953=>[93.799,-78.645,53.429,1],
82954=>[93.803,-78.637,53.410,1],
82955=>[93.806,-78.629,53.391,1],
82956=>[93.809,-78.620,53.372,1],
82957=>[93.813,-78.612,53.351,1],
82958=>[93.817,-78.603,53.331,1],
82959=>[93.819,-78.589,53.309,1],
82960=>[93.822,-78.575,53.286,1],
82961=>[93.835,-78.579,53.262,1],
82962=>[93.847,-78.566,53.238,1],
82963=>[93.860,-78.554,53.216,1],
82964=>[93.873,-78.541,53.193,1],
82965=>[93.886,-78.529,53.169,1],
82966=>[93.898,-78.516,53.143,1],
82967=>[93.911,-78.503,53.120,1],
82968=>[93.939,-78.488,53.096,1],
82969=>[93.960,-78.486,53.073,1],
82970=>[93.964,-78.495,53.051,1],
82971=>[93.974,-78.501,53.031,1],
82972=>[93.985,-78.507,53.011,1],
82973=>[93.995,-78.512,52.990,1],
82974=>[94.005,-78.518,52.972,1],
82975=>[94.016,-78.523,52.953,1],
82976=>[94.027,-78.529,52.935,1],
82977=>[94.037,-78.535,52.917,1],
82978=>[94.048,-78.540,52.898,1],
82979=>[94.062,-78.539,52.876,1],
82980=>[94.077,-78.537,52.853,1],
82981=>[94.089,-78.529,52.827,1],
82982=>[94.094,-78.506,52.802,1],
82983=>[94.100,-78.482,52.777,1],
82984=>[94.119,-78.447,52.752,1],
82985=>[94.139,-78.411,52.731,1],
82986=>[94.161,-78.379,52.711,1],
82987=>[94.205,-78.369,52.694,1],
82988=>[94.250,-78.360,52.677,1],
82989=>[94.292,-78.356,52.660,1],
82990=>[94.299,-78.445,52.643,1],
82991=>[94.307,-78.535,52.626,1],
82992=>[94.321,-78.555,52.608,1],
82993=>[94.335,-78.561,52.589,1],
82994=>[94.350,-78.568,52.568,1],
82995=>[94.365,-78.575,52.547,1],
82996=>[94.380,-78.582,52.527,1],
82997=>[94.376,-78.593,52.507,1],
82998=>[94.368,-78.604,52.486,1],
82999=>[94.360,-78.617,52.464,1],
83000=>[94.352,-78.629,52.442,1],
83001=>[94.353,-78.633,52.418,1],
83002=>[94.369,-78.620,52.395,1],
83003=>[94.386,-78.608,52.371,1],
83004=>[94.402,-78.595,52.347,1],
83005=>[94.418,-78.582,52.323,1],
83006=>[94.425,-78.568,52.298,1],
83007=>[94.432,-78.553,52.269,1],
83008=>[94.442,-78.549,52.238,1],
83009=>[94.456,-78.555,52.204,1],
83010=>[94.470,-78.561,52.170,1],
83011=>[94.485,-78.566,52.135,1],
83012=>[94.501,-78.570,52.097,1],
83013=>[94.517,-78.574,52.061,1],
83014=>[94.532,-78.579,52.026,1],
83015=>[94.548,-78.583,51.992,1],
83016=>[94.557,-78.586,51.958,1],
83017=>[94.563,-78.588,51.923,1],
83018=>[94.570,-78.590,51.886,1],
83019=>[94.582,-78.592,51.848,1],
83020=>[94.595,-78.594,51.810,1],
83021=>[94.608,-78.596,51.771,1],
83022=>[94.621,-78.598,51.731,1],
83023=>[94.634,-78.600,51.688,1],
83024=>[94.647,-78.602,51.643,1],
83025=>[94.660,-78.604,51.596,1],
83026=>[94.673,-78.606,51.554,1],
83027=>[94.686,-78.608,51.512,1],
83028=>[94.699,-78.610,51.470,1],
83029=>[94.712,-78.612,51.428,1],
83030=>[94.725,-78.614,51.387,1],
83031=>[94.747,-78.619,51.346,1],
83032=>[94.768,-78.623,51.305,1],
83033=>[94.789,-78.627,51.262,1],
83034=>[94.809,-78.631,51.221,1],
83035=>[94.828,-78.635,51.180,1],
83036=>[94.846,-78.638,51.138,1],
83037=>[94.865,-78.642,51.095,1],
83038=>[94.872,-78.649,51.052,1],
83039=>[94.879,-78.648,51.009,1],
83040=>[94.888,-78.636,50.967,1],
83041=>[94.897,-78.623,50.925,1],
83042=>[94.906,-78.611,50.882,1],
83043=>[94.942,-78.608,50.840,1],
83044=>[94.979,-78.608,50.794,1],
83045=>[95.016,-78.606,50.746,1],
83046=>[95.053,-78.605,50.698,1],
83047=>[95.072,-78.605,50.649,1],
83048=>[95.075,-78.607,50.601,1],
83049=>[95.069,-78.606,50.553,1],
83050=>[95.064,-78.605,50.505,1],
83051=>[95.058,-78.604,50.459,1],
83052=>[95.052,-78.604,50.413,1],
83053=>[95.047,-78.603,50.367,1],
83054=>[95.041,-78.602,50.324,1],
83055=>[95.036,-78.601,50.279,1],
83056=>[95.030,-78.601,50.236,1],
83057=>[95.030,-78.595,50.194,1],
83058=>[95.046,-78.580,50.154,1],
83059=>[95.061,-78.585,50.112,1],
83060=>[95.072,-78.589,50.069,1],
83061=>[95.083,-78.592,50.027,1],
83062=>[95.094,-78.596,49.986,1],
83063=>[95.104,-78.599,49.945,1],
83064=>[95.115,-78.603,49.906,1],
83065=>[95.126,-78.607,49.867,1],
83066=>[95.136,-78.611,49.830,1],
83067=>[95.147,-78.614,49.794,1],
83068=>[95.158,-78.618,49.757,1],
83069=>[95.168,-78.622,49.719,1],
83070=>[95.179,-78.625,49.681,1],
83071=>[95.190,-78.629,49.643,1],
83072=>[95.214,-78.641,49.606,1],
83073=>[95.224,-78.652,49.567,1],
83074=>[95.232,-78.670,49.527,1],
83075=>[95.246,-78.691,49.486,1],
83076=>[95.259,-78.712,49.446,1],
83077=>[95.274,-78.733,49.407,1],
83078=>[95.290,-78.756,49.370,1],
83079=>[95.305,-78.778,49.333,1],
83080=>[95.333,-78.799,49.297,1],
83081=>[95.361,-78.818,49.259,1],
83082=>[95.391,-78.838,49.220,1],
83083=>[95.411,-78.850,49.181,1],
83084=>[95.426,-78.851,49.140,1],
83085=>[95.436,-78.844,49.100,1],
83086=>[95.439,-78.833,49.061,1],
83087=>[95.443,-78.821,49.020,1],
83088=>[95.447,-78.810,48.980,1],
83089=>[95.451,-78.799,48.939,1],
83090=>[95.455,-78.787,48.897,1],
83091=>[95.459,-78.776,48.854,1],
83092=>[95.463,-78.764,48.809,1],
83093=>[95.473,-78.758,48.765,1],
83094=>[95.496,-78.760,48.721,1],
83095=>[95.520,-78.761,48.677,1],
83096=>[95.543,-78.764,48.635,1],
83097=>[95.567,-78.766,48.593,1],
83098=>[95.590,-78.767,48.550,1],
83099=>[95.598,-78.777,48.508,1],
83100=>[95.604,-78.788,48.467,1],
83101=>[95.610,-78.798,48.427,1],
83102=>[95.616,-78.808,48.387,1],
83103=>[95.622,-78.819,48.348,1],
83104=>[95.628,-78.830,48.310,1],
83105=>[95.633,-78.840,48.273,1],
83106=>[95.641,-78.849,48.237,1],
83107=>[95.654,-78.852,48.202,1],
83108=>[95.678,-78.862,48.166,1],
83109=>[95.705,-78.872,48.127,1],
83110=>[95.729,-78.877,48.086,1],
83111=>[95.753,-78.883,48.045,1],
83112=>[95.777,-78.888,48.001,1],
83113=>[95.801,-78.893,47.958,1],
83114=>[95.825,-78.899,47.915,1],
83115=>[95.837,-78.913,47.872,1],
83116=>[95.848,-78.928,47.828,1],
83117=>[95.859,-78.943,47.786,1],
83118=>[95.873,-78.953,47.743,1],
83119=>[95.894,-78.952,47.700,1],
83120=>[95.918,-78.949,47.660,1],
83121=>[95.942,-78.945,47.619,1],
83122=>[95.966,-78.942,47.579,1],
83123=>[95.990,-78.939,47.540,1],
83124=>[96.015,-78.935,47.500,1],
83125=>[96.039,-78.931,47.459,1],
83126=>[96.063,-78.927,47.416,1],
83127=>[96.088,-78.923,47.374,1],
83128=>[96.112,-78.919,47.334,1],
83129=>[96.136,-78.915,47.294,1],
83130=>[96.165,-78.910,47.256,1],
83131=>[96.190,-78.901,47.219,1],
83132=>[96.215,-78.892,47.181,1],
83133=>[96.240,-78.883,47.144,1],
83134=>[96.265,-78.874,47.108,1],
83135=>[96.291,-78.865,47.074,1],
83136=>[96.316,-78.855,47.042,1],
83137=>[96.340,-78.846,47.011,1],
83138=>[96.366,-78.837,46.980,1],
83139=>[96.368,-78.843,46.948,1],
83140=>[96.369,-78.849,46.916,1],
83141=>[96.371,-78.855,46.886,1],
83142=>[96.376,-78.868,46.854,1],
83143=>[96.388,-78.885,46.822,1],
83144=>[96.399,-78.902,46.791,1],
83145=>[96.409,-78.908,46.758,1],
83146=>[96.418,-78.911,46.726,1],
83147=>[96.429,-78.914,46.694,1],
83148=>[96.461,-78.915,46.664,1],
83149=>[96.506,-78.915,46.634,1],
83150=>[96.551,-78.914,46.606,1],
83151=>[96.596,-78.914,46.577,1],
83152=>[96.642,-78.914,46.550,1],
83153=>[96.687,-78.914,46.523,1],
83154=>[96.731,-78.912,46.497,1],
83155=>[96.771,-78.907,46.473,1],
83156=>[96.812,-78.902,46.451,1],
83157=>[96.844,-78.898,46.430,1],
83158=>[96.854,-78.895,46.408,1],
83159=>[96.864,-78.893,46.386,1],
83160=>[96.874,-78.890,46.365,1],
83161=>[96.885,-78.887,46.345,1],
83162=>[96.898,-78.883,46.322,1],
83163=>[96.901,-78.873,46.301,1],
83164=>[96.922,-78.869,46.280,1],
83165=>[96.929,-78.877,46.259,1],
83166=>[96.929,-78.902,46.239,1],
83167=>[96.960,-78.921,46.220,1],
83168=>[96.990,-78.946,46.201,1],
83169=>[97.008,-78.954,46.184,1],
83170=>[97.002,-78.969,46.167,1],
83171=>[96.996,-78.984,46.150,1],
83172=>[96.990,-78.999,46.132,1],
83173=>[96.983,-79.013,46.115,1],
83174=>[96.977,-79.028,46.097,1],
83175=>[96.989,-79.065,46.080,1],
83176=>[97.010,-79.111,46.066,1],
83177=>[97.031,-79.158,46.052,1],
83178=>[97.052,-79.190,46.038,1],
83179=>[97.073,-79.185,46.022,1],
83180=>[97.093,-79.180,46.006,1],
83181=>[97.113,-79.175,45.991,1],
83182=>[97.133,-79.170,45.976,1],
83183=>[97.153,-79.165,45.962,1],
83184=>[97.174,-79.159,45.948,1],
83185=>[97.186,-79.137,45.933,1],
83186=>[97.195,-79.106,45.918,1],
83187=>[97.207,-79.091,45.903,1],
83188=>[97.222,-79.099,45.888,1],
83189=>[97.232,-79.104,45.873,1],
83190=>[97.239,-79.107,45.857,1],
83191=>[97.249,-79.112,45.842,1],
83192=>[97.262,-79.122,45.825,1],
83193=>[97.277,-79.131,45.809,1],
83194=>[97.290,-79.140,45.793,1],
83195=>[97.304,-79.150,45.777,1],
83196=>[97.317,-79.159,45.761,1],
83197=>[97.331,-79.169,45.746,1],
83198=>[97.345,-79.178,45.733,1],
83199=>[97.359,-79.187,45.717,1],
83200=>[97.372,-79.197,45.702,1],
83201=>[97.386,-79.206,45.687,1],
83202=>[97.401,-79.215,45.673,1],
83203=>[97.416,-79.223,45.657,1],
83204=>[97.429,-79.225,45.640,1],
83205=>[97.449,-79.234,45.622,1],
83206=>[97.464,-79.237,45.604,1],
83207=>[97.478,-79.239,45.589,1],
83208=>[97.493,-79.242,45.574,1],
83209=>[97.508,-79.245,45.558,1],
83210=>[97.523,-79.248,45.541,1],
83211=>[97.537,-79.251,45.523,1],
83212=>[97.552,-79.254,45.506,1],
83213=>[97.567,-79.257,45.489,1],
83214=>[97.582,-79.260,45.471,1],
83215=>[97.602,-79.269,45.453,1],
83216=>[97.621,-79.278,45.435,1],
83217=>[97.642,-79.286,45.417,1],
83218=>[97.657,-79.292,45.401,1],
83219=>[97.657,-79.292,45.385,1],
83220=>[97.657,-79.291,45.370,1],
83221=>[97.657,-79.291,45.355,1],
83222=>[97.656,-79.291,45.341,1],
83223=>[97.656,-79.290,45.328,1],
83224=>[97.657,-79.291,45.315,1],
83225=>[97.675,-79.310,45.303,1],
83226=>[97.693,-79.331,45.293,1],
83227=>[97.712,-79.351,45.282,1],
83228=>[97.730,-79.372,45.273,1],
83229=>[97.748,-79.392,45.263,1],
83230=>[97.767,-79.413,45.252,1],
83231=>[97.785,-79.433,45.241,1],
83232=>[97.803,-79.454,45.230,1],
83233=>[97.821,-79.473,45.219,1],
83234=>[97.840,-79.494,45.207,1],
83235=>[97.852,-79.507,45.195,1],
83236=>[97.863,-79.519,45.183,1],
83237=>[97.875,-79.531,45.172,1],
83238=>[97.886,-79.542,45.161,1],
83239=>[97.898,-79.554,45.150,1],
83240=>[97.910,-79.566,45.141,1],
83241=>[97.921,-79.578,45.131,1],
83242=>[97.933,-79.589,45.123,1],
83243=>[97.944,-79.601,45.115,1],
83244=>[97.961,-79.612,45.106,1],
83245=>[97.988,-79.622,45.097,1],
83246=>[98.016,-79.631,45.089,1],
83247=>[98.045,-79.638,45.082,1],
83248=>[98.082,-79.629,45.075,1],
83249=>[98.119,-79.620,45.067,1],
83250=>[98.156,-79.611,45.060,1],
83251=>[98.194,-79.602,45.053,1],
83252=>[98.229,-79.592,45.044,1],
83253=>[98.262,-79.610,45.035,1],
83254=>[98.298,-79.636,45.027,1],
83255=>[98.334,-79.660,45.017,1],
83256=>[98.363,-79.672,45.008,1],
83257=>[98.389,-79.679,44.998,1],
83258=>[98.415,-79.685,44.988,1],
83259=>[98.441,-79.692,44.978,1],
83260=>[98.468,-79.701,44.968,1],
83261=>[98.496,-79.711,44.960,1],
83262=>[98.523,-79.722,44.952,1],
83263=>[98.550,-79.732,44.944,1],
83264=>[98.577,-79.742,44.937,1],
83265=>[98.604,-79.752,44.931,1],
83266=>[98.633,-79.763,44.925,1],
83267=>[98.666,-79.772,44.920,1],
83268=>[98.690,-79.773,44.915,1],
83269=>[98.704,-79.767,44.910,1],
83270=>[98.718,-79.760,44.907,1],
83271=>[98.733,-79.753,44.903,1],
83272=>[98.747,-79.746,44.897,1],
83273=>[98.762,-79.739,44.890,1],
83274=>[98.781,-79.744,44.884,1],
83275=>[98.802,-79.751,44.878,1],
83276=>[98.823,-79.758,44.873,1],
83277=>[98.845,-79.767,44.867,1],
83278=>[98.867,-79.774,44.860,1],
83279=>[98.888,-79.783,44.854,1],
83280=>[98.910,-79.791,44.847,1],
83281=>[98.932,-79.798,44.841,1],
83282=>[98.954,-79.807,44.835,1],
83283=>[98.976,-79.815,44.828,1],
83284=>[98.997,-79.823,44.821,1],
83285=>[99.022,-79.825,44.814,1],
83286=>[99.045,-79.830,44.807,1],
83287=>[99.069,-79.845,44.798,1],
83288=>[99.093,-79.858,44.789,1],
83289=>[99.116,-79.873,44.783,1],
83290=>[99.135,-79.889,44.776,1],
83291=>[99.164,-79.903,44.769,1],
83292=>[99.195,-79.914,44.760,1],
83293=>[99.218,-79.920,44.750,1],
83294=>[99.241,-79.924,44.740,1],
83295=>[99.264,-79.929,44.730,1],
83296=>[99.287,-79.933,44.722,1],
83297=>[99.311,-79.938,44.714,1],
83298=>[99.334,-79.943,44.706,1],
83299=>[99.357,-79.948,44.699,1],
83300=>[99.380,-79.952,44.692,1],
83301=>[99.404,-79.957,44.686,1],
83302=>[99.427,-79.962,44.679,1],
83303=>[99.450,-79.967,44.672,1],
83304=>[99.474,-79.971,44.665,1],
83305=>[99.497,-79.976,44.658,1],
83306=>[99.520,-79.982,44.651,1],
83307=>[99.544,-79.988,44.643,1],
83308=>[99.568,-79.995,44.634,1],
83309=>[99.588,-79.998,44.625,1],
83310=>[99.587,-80.026,44.616,1],
83311=>[99.582,-80.060,44.607,1],
83312=>[99.573,-80.097,44.599,1],
83313=>[99.565,-80.135,44.591,1],
83314=>[99.557,-80.173,44.583,1],
83315=>[99.549,-80.210,44.576,1],
83316=>[99.541,-80.248,44.569,1],
83317=>[99.544,-80.271,44.561,1],
83318=>[99.547,-80.293,44.553,1],
83319=>[99.550,-80.315,44.545,1],
83320=>[99.553,-80.337,44.537,1],
83321=>[99.557,-80.359,44.529,1],
83322=>[99.560,-80.381,44.520,1],
83323=>[99.563,-80.403,44.512,1],
83324=>[99.566,-80.425,44.502,1],
83325=>[99.579,-80.444,44.493,1],
83326=>[99.627,-80.450,44.483,1],
83327=>[99.675,-80.455,44.471,1],
83328=>[99.723,-80.461,44.461,1],
83329=>[99.771,-80.466,44.450,1],
83330=>[99.819,-80.472,44.439,1],
83331=>[99.867,-80.478,44.426,1],
83332=>[99.917,-80.489,44.414,1],
83333=>[99.969,-80.501,44.403,1],
83334=>[100.020,-80.514,44.390,1],
83335=>[100.071,-80.527,44.378,1],
83336=>[100.122,-80.540,44.366,1],
83337=>[100.174,-80.553,44.353,1],
83632=>[93.566,-78.779,53.597,1],
83633=>[93.576,-78.777,53.588,1],
83634=>[93.585,-78.774,53.579,1],
83635=>[93.595,-78.771,53.573,1],
83636=>[93.605,-78.769,53.568,1],
83637=>[93.614,-78.767,53.562,1],
83638=>[93.624,-78.764,53.557,1],
83639=>[93.634,-78.761,53.553,1],
83640=>[93.635,-78.754,53.551,1],
83641=>[93.633,-78.745,53.554,1],
83642=>[93.632,-78.767,53.557,1],
83643=>[93.636,-78.763,53.560,1],
83644=>[93.645,-78.762,53.559,1],
83645=>[93.655,-78.761,53.556,1],
83646=>[93.667,-78.749,53.550,1],
83647=>[93.685,-78.738,53.541,1],
83648=>[93.704,-78.720,53.530,1],
83649=>[93.723,-78.704,53.517,1],
83650=>[93.743,-78.686,53.503,1],
83651=>[93.762,-78.670,53.488,1],
83652=>[93.781,-78.653,53.470,1],
83653=>[93.791,-78.641,53.452,1],
83654=>[93.794,-78.633,53.433,1],
83655=>[93.797,-78.623,53.414,1],
83656=>[93.801,-78.615,53.395,1],
83657=>[93.804,-78.607,53.375,1],
83658=>[93.807,-78.596,53.355,1],
83659=>[93.811,-78.582,53.333,1],
83660=>[93.813,-78.568,53.310,1],
83661=>[93.816,-78.554,53.286,1],
83662=>[93.824,-78.550,53.262,1],
83663=>[93.842,-78.555,53.238,1],
83664=>[93.855,-78.542,53.215,1],
83665=>[93.868,-78.530,53.192,1],
83666=>[93.880,-78.517,53.168,1],
83667=>[93.893,-78.505,53.143,1],
83668=>[93.908,-78.492,53.119,1],
83669=>[93.952,-78.474,53.096,1],
83670=>[93.970,-78.474,53.075,1],
83671=>[93.971,-78.484,53.055,1],
83672=>[93.979,-78.492,53.038,1],
83673=>[93.989,-78.497,53.019,1],
83674=>[94.000,-78.503,52.998,1],
83675=>[94.010,-78.508,52.978,1],
83676=>[94.020,-78.514,52.959,1],
83677=>[94.031,-78.520,52.941,1],
83678=>[94.043,-78.523,52.922,1],
83679=>[94.058,-78.521,52.902,1],
83680=>[94.072,-78.520,52.880,1],
83681=>[94.087,-78.518,52.856,1],
83682=>[94.102,-78.517,52.830,1],
83683=>[94.111,-78.503,52.804,1],
83684=>[94.117,-78.479,52.780,1],
83685=>[94.132,-78.448,52.757,1],
83686=>[94.151,-78.412,52.736,1],
83687=>[94.171,-78.376,52.717,1],
83688=>[94.190,-78.341,52.701,1],
83689=>[94.229,-78.326,52.686,1],
83690=>[94.271,-78.322,52.669,1],
83691=>[94.278,-78.413,52.652,1],
83692=>[94.285,-78.503,52.635,1],
83693=>[94.295,-78.556,52.617,1],
83694=>[94.311,-78.563,52.598,1],
83695=>[94.325,-78.570,52.577,1],
83696=>[94.340,-78.576,52.557,1],
83697=>[94.355,-78.583,52.538,1],
83698=>[94.370,-78.589,52.519,1],
83699=>[94.374,-78.599,52.498,1],
83700=>[94.366,-78.611,52.477,1],
83701=>[94.359,-78.623,52.455,1],
83702=>[94.355,-78.631,52.432,1],
83703=>[94.371,-78.618,52.409,1],
83704=>[94.388,-78.606,52.385,1],
83705=>[94.404,-78.594,52.361,1],
83706=>[94.411,-78.579,52.337,1],
83707=>[94.418,-78.564,52.310,1],
83708=>[94.427,-78.549,52.281,1],
83709=>[94.441,-78.547,52.249,1],
83710=>[94.457,-78.551,52.216,1],
83711=>[94.472,-78.556,52.183,1],
83712=>[94.488,-78.560,52.148,1],
83713=>[94.503,-78.564,52.112,1],
83714=>[94.519,-78.569,52.076,1],
83715=>[94.535,-78.573,52.041,1],
83716=>[94.550,-78.577,52.008,1],
83717=>[94.563,-78.581,51.976,1],
83718=>[94.569,-78.582,51.942,1],
83719=>[94.575,-78.585,51.905,1],
83720=>[94.585,-78.583,51.866,1],
83721=>[94.599,-78.587,51.828,1],
83722=>[94.612,-78.590,51.789,1],
83723=>[94.625,-78.592,51.748,1],
83724=>[94.638,-78.594,51.705,1],
83725=>[94.651,-78.596,51.658,1],
83726=>[94.664,-78.598,51.611,1],
83727=>[94.677,-78.600,51.566,1],
83728=>[94.690,-78.602,51.522,1],
83729=>[94.703,-78.604,51.478,1],
83730=>[94.716,-78.606,51.434,1],
83731=>[94.729,-78.608,51.389,1],
83732=>[94.750,-78.612,51.345,1],
83733=>[94.771,-78.617,51.301,1],
83734=>[94.792,-78.621,51.258,1],
83735=>[94.814,-78.625,51.215,1],
83736=>[94.834,-78.630,51.173,1],
83737=>[94.853,-78.633,51.130,1],
83738=>[94.872,-78.636,51.085,1],
83739=>[94.881,-78.643,51.042,1],
83740=>[94.889,-78.639,50.999,1],
83741=>[94.898,-78.626,50.955,1],
83742=>[94.909,-78.614,50.913,1],
83743=>[94.946,-78.613,50.871,1],
83744=>[94.983,-78.611,50.829,1],
83745=>[95.021,-78.611,50.784,1],
83746=>[95.030,-78.612,50.738,1],
83747=>[95.034,-78.614,50.692,1],
83748=>[95.039,-78.616,50.644,1],
83749=>[95.034,-78.615,50.597,1],
83750=>[95.029,-78.614,50.551,1],
83751=>[95.023,-78.614,50.504,1],
83752=>[95.017,-78.613,50.459,1],
83753=>[95.012,-78.612,50.414,1],
83754=>[95.006,-78.611,50.369,1],
83755=>[95.000,-78.611,50.324,1],
83756=>[95.006,-78.599,50.280,1],
83757=>[95.021,-78.581,50.237,1],
83758=>[95.035,-78.564,50.194,1],
83759=>[95.054,-78.561,50.152,1],
83760=>[95.074,-78.566,50.110,1],
83761=>[95.086,-78.570,50.068,1],
83762=>[95.097,-78.573,50.026,1],
83763=>[95.108,-78.576,49.984,1],
83764=>[95.118,-78.580,49.943,1],
83765=>[95.129,-78.584,49.905,1],
83766=>[95.139,-78.588,49.866,1],
83767=>[95.150,-78.592,49.828,1],
83768=>[95.161,-78.595,49.791,1],
83769=>[95.172,-78.598,49.754,1],
83770=>[95.182,-78.602,49.717,1],
83771=>[95.193,-78.606,49.680,1],
83772=>[95.208,-78.612,49.644,1],
83773=>[95.241,-78.630,49.606,1],
83774=>[95.274,-78.646,49.568,1],
83775=>[95.275,-78.656,49.528,1],
83776=>[95.289,-78.677,49.488,1],
83777=>[95.303,-78.698,49.448,1],
83778=>[95.317,-78.720,49.409,1],
83779=>[95.331,-78.741,49.372,1],
83780=>[95.345,-78.762,49.337,1],
83781=>[95.358,-78.783,49.302,1],
83782=>[95.373,-78.804,49.266,1],
83783=>[95.387,-78.825,49.228,1],
83784=>[95.412,-78.846,49.189,1],
83785=>[95.422,-78.843,49.148,1],
83786=>[95.426,-78.831,49.107,1],
83787=>[95.429,-78.820,49.066,1],
83788=>[95.433,-78.808,49.026,1],
83789=>[95.438,-78.797,48.985,1],
83790=>[95.442,-78.786,48.944,1],
83791=>[95.445,-78.774,48.902,1],
83792=>[95.449,-78.763,48.859,1],
83793=>[95.453,-78.752,48.815,1],
83794=>[95.463,-78.744,48.770,1],
83795=>[95.486,-78.746,48.725,1],
83796=>[95.510,-78.749,48.682,1],
83797=>[95.533,-78.750,48.641,1],
83798=>[95.556,-78.752,48.599,1],
83799=>[95.580,-78.754,48.557,1],
83800=>[95.600,-78.758,48.515,1],
83801=>[95.606,-78.768,48.475,1],
83802=>[95.612,-78.779,48.436,1],
83803=>[95.618,-78.789,48.397,1],
83804=>[95.624,-78.799,48.358,1],
83805=>[95.630,-78.810,48.320,1],
83806=>[95.637,-78.819,48.283,1],
83807=>[95.650,-78.824,48.248,1],
83808=>[95.661,-78.827,48.213,1],
83809=>[95.684,-78.836,48.178,1],
83810=>[95.713,-78.849,48.139,1],
83811=>[95.740,-78.858,48.099,1],
83812=>[95.764,-78.863,48.058,1],
83813=>[95.788,-78.868,48.014,1],
83814=>[95.812,-78.874,47.971,1],
83815=>[95.824,-78.888,47.929,1],
83816=>[95.835,-78.903,47.886,1],
83817=>[95.850,-78.908,47.843,1],
83818=>[95.868,-78.910,47.800,1],
83819=>[95.883,-78.914,47.757,1],
83820=>[95.896,-78.917,47.714,1],
83821=>[95.920,-78.914,47.673,1],
83822=>[95.945,-78.911,47.631,1],
83823=>[95.969,-78.907,47.590,1],
83824=>[95.993,-78.904,47.551,1],
83825=>[96.017,-78.901,47.511,1],
83826=>[96.041,-78.898,47.469,1],
83827=>[96.065,-78.894,47.427,1],
83828=>[96.090,-78.891,47.385,1],
83829=>[96.114,-78.888,47.344,1],
83830=>[96.138,-78.885,47.305,1],
83831=>[96.156,-78.896,47.267,1],
83832=>[96.172,-78.883,47.230,1],
83833=>[96.196,-78.874,47.193,1],
83834=>[96.221,-78.865,47.155,1],
83835=>[96.246,-78.855,47.118,1],
83836=>[96.271,-78.846,47.083,1],
83837=>[96.297,-78.837,47.051,1],
83838=>[96.321,-78.828,47.020,1],
83839=>[96.346,-78.820,46.989,1],
83840=>[96.352,-78.824,46.956,1],
83841=>[96.353,-78.830,46.923,1],
83842=>[96.356,-78.837,46.891,1],
83843=>[96.367,-78.855,46.858,1],
83844=>[96.378,-78.872,46.826,1],
83845=>[96.389,-78.890,46.796,1],
83846=>[96.400,-78.900,46.764,1],
83847=>[96.410,-78.903,46.732,1],
83848=>[96.419,-78.905,46.702,1],
83849=>[96.455,-78.906,46.672,1],
83850=>[96.500,-78.906,46.643,1],
83851=>[96.545,-78.906,46.616,1],
83852=>[96.591,-78.905,46.587,1],
83853=>[96.636,-78.905,46.560,1],
83854=>[96.680,-78.905,46.534,1],
83855=>[96.721,-78.899,46.508,1],
83856=>[96.761,-78.895,46.485,1],
83857=>[96.802,-78.890,46.463,1],
83858=>[96.840,-78.885,46.443,1],
83859=>[96.851,-78.883,46.421,1],
83860=>[96.861,-78.880,46.399,1],
83861=>[96.871,-78.877,46.379,1],
83862=>[96.881,-78.874,46.357,1],
83863=>[96.891,-78.871,46.335,1],
83864=>[96.911,-78.870,46.313,1],
83865=>[96.932,-78.866,46.292,1],
83866=>[96.938,-78.876,46.271,1],
83867=>[96.925,-78.905,46.251,1],
83868=>[96.954,-78.952,46.232,1],
83869=>[96.982,-78.993,46.214,1],
83870=>[96.995,-78.968,46.198,1],
83871=>[96.999,-78.962,46.181,1],
83872=>[96.992,-78.976,46.165,1],
83873=>[96.986,-78.991,46.147,1],
83874=>[96.979,-79.006,46.129,1],
83875=>[96.973,-79.021,46.112,1],
83876=>[96.987,-79.059,46.096,1],
83877=>[97.008,-79.105,46.082,1],
83878=>[97.029,-79.152,46.069,1],
83879=>[97.049,-79.160,46.056,1],
83880=>[97.070,-79.156,46.038,1],
83881=>[97.090,-79.150,46.022,1],
83882=>[97.110,-79.145,46.008,1],
83883=>[97.131,-79.140,45.993,1],
83884=>[97.151,-79.134,45.980,1],
83885=>[97.171,-79.129,45.966,1],
83886=>[97.191,-79.125,45.953,1],
83887=>[97.206,-79.106,45.938,1],
83888=>[97.218,-79.094,45.924,1],
83889=>[97.227,-79.099,45.909,1],
83890=>[97.234,-79.101,45.892,1],
83891=>[97.240,-79.104,45.875,1],
83892=>[97.250,-79.110,45.859,1],
83893=>[97.264,-79.119,45.843,1],
83894=>[97.278,-79.128,45.827,1],
83895=>[97.292,-79.138,45.810,1],
83896=>[97.305,-79.147,45.793,1],
83897=>[97.319,-79.156,45.774,1],
83898=>[97.333,-79.165,45.759,1],
83899=>[97.348,-79.175,45.744,1],
83900=>[97.363,-79.183,45.729,1],
83901=>[97.378,-79.192,45.711,1],
83902=>[97.393,-79.200,45.693,1],
83903=>[97.408,-79.209,45.674,1],
83904=>[97.419,-79.208,45.657,1],
83905=>[97.431,-79.207,45.641,1],
83906=>[97.452,-79.217,45.624,1],
83907=>[97.474,-79.228,45.607,1],
83908=>[97.492,-79.234,45.591,1],
83909=>[97.507,-79.237,45.575,1],
83910=>[97.522,-79.240,45.559,1],
83911=>[97.536,-79.243,45.542,1],
83912=>[97.551,-79.246,45.526,1],
83913=>[97.566,-79.249,45.509,1],
83914=>[97.580,-79.252,45.493,1],
83915=>[97.597,-79.257,45.476,1],
83916=>[97.617,-79.266,45.459,1],
83917=>[97.637,-79.274,45.441,1],
83918=>[97.648,-79.278,45.425,1],
83919=>[97.648,-79.278,45.409,1],
83920=>[97.648,-79.278,45.394,1],
83921=>[97.648,-79.278,45.380,1],
83922=>[97.648,-79.277,45.366,1],
83923=>[97.648,-79.276,45.351,1],
83924=>[97.648,-79.276,45.338,1],
83925=>[97.649,-79.278,45.325,1],
83926=>[97.667,-79.297,45.313,1],
83927=>[97.685,-79.318,45.303,1],
83928=>[97.704,-79.338,45.293,1],
83929=>[97.722,-79.359,45.283,1],
83930=>[97.740,-79.379,45.272,1],
83931=>[97.758,-79.400,45.260,1],
83932=>[97.777,-79.420,45.248,1],
83933=>[97.795,-79.441,45.237,1],
83934=>[97.813,-79.461,45.226,1],
83935=>[97.840,-79.480,45.215,1],
83936=>[97.854,-79.492,45.204,1],
83937=>[97.866,-79.507,45.192,1],
83938=>[97.878,-79.523,45.180,1],
83939=>[97.890,-79.537,45.169,1],
83940=>[97.902,-79.549,45.159,1],
83941=>[97.914,-79.560,45.149,1],
83942=>[97.925,-79.573,45.140,1],
83943=>[97.937,-79.584,45.131,1],
83944=>[97.948,-79.596,45.123,1],
83945=>[97.962,-79.607,45.114,1],
83946=>[97.989,-79.617,45.105,1],
83947=>[98.019,-79.623,45.097,1],
83948=>[98.056,-79.614,45.090,1],
83949=>[98.093,-79.605,45.082,1],
83950=>[98.130,-79.596,45.075,1],
83951=>[98.167,-79.587,45.068,1],
83952=>[98.205,-79.578,45.062,1],
83953=>[98.239,-79.567,45.053,1],
83954=>[98.272,-79.585,45.045,1],
83955=>[98.308,-79.610,45.036,1],
83956=>[98.344,-79.635,45.027,1],
83957=>[98.379,-79.659,45.017,1],
83958=>[98.406,-79.666,45.008,1],
83959=>[98.432,-79.672,44.999,1],
83960=>[98.458,-79.679,44.988,1],
83961=>[98.486,-79.689,44.979,1],
83962=>[98.512,-79.700,44.971,1],
83963=>[98.539,-79.711,44.963,1],
83964=>[98.567,-79.720,44.956,1],
83965=>[98.594,-79.731,44.949,1],
83966=>[98.621,-79.742,44.942,1],
83967=>[98.648,-79.751,44.937,1],
83968=>[98.680,-79.761,44.932,1],
83969=>[98.698,-79.757,44.928,1],
83970=>[98.712,-79.750,44.923,1],
83971=>[98.726,-79.744,44.919,1],
83972=>[98.741,-79.737,44.915,1],
83973=>[98.755,-79.730,44.910,1],
83974=>[98.770,-79.723,44.904,1],
83975=>[98.786,-79.722,44.898,1],
83976=>[98.807,-79.730,44.893,1],
83977=>[98.829,-79.737,44.888,1],
83978=>[98.851,-79.745,44.882,1],
83979=>[98.872,-79.753,44.876,1],
83980=>[98.894,-79.761,44.869,1],
83981=>[98.916,-79.769,44.863,1],
83982=>[98.938,-79.777,44.857,1],
83983=>[98.959,-79.786,44.850,1],
83984=>[98.981,-79.793,44.843,1],
83985=>[99.003,-79.802,44.837,1],
83986=>[99.025,-79.810,44.829,1],
83987=>[99.049,-79.815,44.821,1],
83988=>[99.072,-79.829,44.811,1],
83989=>[99.096,-79.843,44.802,1],
83990=>[99.121,-79.857,44.795,1],
83991=>[99.142,-79.872,44.788,1],
83992=>[99.170,-79.881,44.778,1],
83993=>[99.194,-79.886,44.768,1],
83994=>[99.217,-79.891,44.757,1],
83995=>[99.240,-79.896,44.746,1],
83996=>[99.264,-79.900,44.736,1],
83997=>[99.287,-79.905,44.727,1],
83998=>[99.310,-79.912,44.719,1],
83999=>[99.334,-79.918,44.711,1],
84000=>[99.358,-79.924,44.704,1],
84001=>[99.382,-79.930,44.697,1],
84002=>[99.406,-79.937,44.691,1],
84003=>[99.429,-79.943,44.685,1],
84004=>[99.453,-79.949,44.676,1],
84005=>[99.477,-79.955,44.668,1],
84006=>[99.500,-79.962,44.661,1],
84007=>[99.524,-79.968,44.654,1],
84008=>[99.548,-79.974,44.646,1],
84009=>[99.570,-79.980,44.637,1],
84010=>[99.584,-79.977,44.628,1],
84011=>[99.582,-80.005,44.618,1],
84012=>[99.581,-80.034,44.610,1],
84013=>[99.580,-80.062,44.602,1],
84014=>[99.579,-80.090,44.595,1],
84015=>[99.577,-80.118,44.587,1],
84016=>[99.570,-80.155,44.580,1],
84017=>[99.561,-80.192,44.572,1],
84018=>[99.553,-80.230,44.564,1],
84019=>[99.545,-80.268,44.557,1],
84020=>[99.547,-80.292,44.549,1],
84021=>[99.550,-80.314,44.541,1],
84022=>[99.553,-80.336,44.533,1],
84023=>[99.556,-80.359,44.525,1],
84024=>[99.559,-80.381,44.517,1],
84025=>[99.563,-80.403,44.507,1],
84026=>[99.587,-80.417,44.498,1],
84027=>[99.635,-80.422,44.487,1],
84028=>[99.683,-80.428,44.476,1],
84029=>[99.731,-80.434,44.466,1],
84030=>[99.779,-80.439,44.455,1],
84031=>[99.830,-80.450,44.444,1],
84032=>[99.881,-80.463,44.432,1],
84033=>[99.932,-80.476,44.420,1],
84034=>[99.984,-80.489,44.408,1],
84035=>[100.035,-80.502,44.396,1],
84036=>[100.086,-80.515,44.383,1],
84037=>[100.137,-80.527,44.370,1],
84038=>[100.189,-80.540,44.358,1],
84039=>[100.240,-80.553,44.346,1],
84333=>[93.566,-78.767,53.603,1],
84334=>[93.576,-78.765,53.595,1],
84335=>[93.585,-78.763,53.587,1],
84336=>[93.595,-78.761,53.579,1],
84337=>[93.605,-78.758,53.573,1],
84338=>[93.615,-78.755,53.568,1],
84339=>[93.624,-78.753,53.562,1],
84340=>[93.633,-78.750,53.558,1],
84341=>[93.631,-78.740,53.555,1],
84342=>[93.630,-78.731,53.556,1],
84343=>[93.628,-78.739,53.559,1],
84344=>[93.630,-78.757,53.562,1],
84345=>[93.639,-78.756,53.562,1],
84346=>[93.650,-78.739,53.559,1],
84347=>[93.665,-78.727,53.553,1],
84348=>[93.683,-78.717,53.544,1],
84349=>[93.700,-78.706,53.533,1],
84350=>[93.719,-78.689,53.521,1],
84351=>[93.739,-78.673,53.506,1],
84352=>[93.758,-78.655,53.491,1],
84353=>[93.777,-78.639,53.474,1],
84354=>[93.785,-78.627,53.455,1],
84355=>[93.789,-78.619,53.436,1],
84356=>[93.792,-78.611,53.417,1],
84357=>[93.796,-78.601,53.397,1],
84358=>[93.799,-78.589,53.377,1],
84359=>[93.801,-78.575,53.357,1],
84360=>[93.804,-78.561,53.334,1],
84361=>[93.807,-78.547,53.310,1],
84362=>[93.809,-78.532,53.285,1],
84363=>[93.812,-78.518,53.260,1],
84364=>[93.837,-78.544,53.236,1],
84365=>[93.850,-78.532,53.213,1],
84366=>[93.863,-78.519,53.190,1],
84367=>[93.875,-78.507,53.166,1],
84368=>[93.888,-78.494,53.141,1],
84369=>[93.921,-78.478,53.118,1],
84370=>[93.965,-78.460,53.097,1],
84371=>[93.980,-78.462,53.078,1],
84372=>[93.981,-78.472,53.060,1],
84373=>[93.984,-78.482,53.044,1],
84374=>[93.994,-78.488,53.025,1],
84375=>[94.004,-78.494,53.004,1],
84376=>[94.015,-78.499,52.984,1],
84377=>[94.025,-78.505,52.964,1],
84378=>[94.039,-78.504,52.944,1],
84379=>[94.054,-78.503,52.923,1],
84380=>[94.068,-78.501,52.903,1],
84381=>[94.082,-78.501,52.880,1],
84382=>[94.097,-78.499,52.855,1],
84383=>[94.112,-78.498,52.828,1],
84384=>[94.126,-78.496,52.804,1],
84385=>[94.133,-78.476,52.782,1],
84386=>[94.144,-78.448,52.762,1],
84387=>[94.164,-78.413,52.743,1],
84388=>[94.183,-78.377,52.725,1],
84389=>[94.203,-78.341,52.708,1],
84390=>[94.222,-78.306,52.692,1],
84391=>[94.249,-78.290,52.676,1],
84392=>[94.256,-78.380,52.659,1],
84393=>[94.263,-78.470,52.641,1],
84394=>[94.271,-78.557,52.623,1],
84395=>[94.286,-78.564,52.604,1],
84396=>[94.300,-78.571,52.584,1],
84397=>[94.316,-78.578,52.565,1],
84398=>[94.330,-78.584,52.546,1],
84399=>[94.345,-78.591,52.527,1],
84400=>[94.360,-78.598,52.508,1],
84401=>[94.372,-78.605,52.489,1],
84402=>[94.365,-78.617,52.468,1],
84403=>[94.357,-78.629,52.444,1],
84404=>[94.373,-78.617,52.422,1],
84405=>[94.390,-78.604,52.399,1],
84406=>[94.397,-78.589,52.375,1],
84407=>[94.406,-78.574,52.349,1],
84408=>[94.423,-78.560,52.322,1],
84409=>[94.441,-78.545,52.292,1],
84410=>[94.450,-78.545,52.259,1],
84411=>[94.460,-78.545,52.227,1],
84412=>[94.475,-78.550,52.194,1],
84413=>[94.490,-78.554,52.160,1],
84414=>[94.506,-78.558,52.124,1],
84415=>[94.522,-78.563,52.088,1],
84416=>[94.537,-78.567,52.054,1],
84417=>[94.553,-78.571,52.022,1],
84418=>[94.568,-78.576,51.991,1],
84419=>[94.574,-78.577,51.957,1],
84420=>[94.580,-78.579,51.921,1],
84421=>[94.591,-78.578,51.882,1],
84422=>[94.601,-78.577,51.844,1],
84423=>[94.615,-78.581,51.804,1],
84424=>[94.628,-78.585,51.763,1],
84425=>[94.641,-78.588,51.719,1],
84426=>[94.654,-78.590,51.672,1],
84427=>[94.668,-78.592,51.623,1],
84428=>[94.680,-78.594,51.577,1],
84429=>[94.693,-78.596,51.530,1],
84430=>[94.706,-78.598,51.485,1],
84431=>[94.719,-78.600,51.438,1],
84432=>[94.733,-78.602,51.391,1],
84433=>[94.754,-78.606,51.345,1],
84434=>[94.775,-78.611,51.299,1],
84435=>[94.796,-78.615,51.255,1],
84436=>[94.817,-78.619,51.211,1],
84437=>[94.839,-78.623,51.166,1],
84438=>[94.859,-78.627,51.121,1],
84439=>[94.878,-78.631,51.076,1],
84440=>[94.891,-78.636,51.032,1],
84441=>[94.899,-78.629,50.989,1],
84442=>[94.913,-78.618,50.945,1],
84443=>[94.951,-78.617,50.903,1],
84444=>[94.982,-78.616,50.861,1],
84445=>[94.987,-78.618,50.818,1],
84446=>[94.991,-78.620,50.775,1],
84447=>[94.996,-78.622,50.732,1],
84448=>[95.000,-78.623,50.688,1],
84449=>[94.999,-78.624,50.641,1],
84450=>[94.993,-78.623,50.595,1],
84451=>[94.987,-78.623,50.550,1],
84452=>[94.982,-78.622,50.505,1],
84453=>[94.976,-78.620,50.460,1],
84454=>[94.971,-78.620,50.415,1],
84455=>[94.983,-78.604,50.370,1],
84456=>[94.997,-78.586,50.325,1],
84457=>[95.012,-78.568,50.281,1],
84458=>[95.026,-78.550,50.238,1],
84459=>[95.041,-78.535,50.194,1],
84460=>[95.062,-78.540,50.151,1],
84461=>[95.082,-78.545,50.109,1],
84462=>[95.100,-78.550,50.067,1],
84463=>[95.111,-78.554,50.025,1],
84464=>[95.121,-78.557,49.984,1],
84465=>[95.132,-78.561,49.942,1],
84466=>[95.143,-78.565,49.903,1],
84467=>[95.154,-78.569,49.865,1],
84468=>[95.164,-78.572,49.827,1],
84469=>[95.175,-78.576,49.790,1],
84470=>[95.186,-78.579,49.753,1],
84471=>[95.196,-78.583,49.716,1],
84472=>[95.207,-78.587,49.679,1],
84473=>[95.235,-78.601,49.641,1],
84474=>[95.268,-78.617,49.602,1],
84475=>[95.301,-78.635,49.564,1],
84476=>[95.333,-78.651,49.526,1],
84477=>[95.333,-78.664,49.487,1],
84478=>[95.346,-78.686,49.448,1],
84479=>[95.360,-78.706,49.410,1],
84480=>[95.375,-78.727,49.374,1],
84481=>[95.388,-78.749,49.340,1],
84482=>[95.402,-78.770,49.306,1],
84483=>[95.416,-78.791,49.271,1],
84484=>[95.430,-78.811,49.234,1],
84485=>[95.438,-78.825,49.196,1],
84486=>[95.429,-78.824,49.156,1],
84487=>[95.416,-78.818,49.115,1],
84488=>[95.420,-78.807,49.074,1],
84489=>[95.424,-78.796,49.033,1],
84490=>[95.428,-78.784,48.992,1],
84491=>[95.432,-78.773,48.951,1],
84492=>[95.436,-78.761,48.908,1],
84493=>[95.440,-78.750,48.864,1],
84494=>[95.444,-78.739,48.819,1],
84495=>[95.453,-78.731,48.775,1],
84496=>[95.476,-78.733,48.731,1],
84497=>[95.499,-78.735,48.688,1],
84498=>[95.523,-78.736,48.647,1],
84499=>[95.546,-78.739,48.606,1],
84500=>[95.570,-78.741,48.564,1],
84501=>[95.593,-78.742,48.523,1],
84502=>[95.609,-78.749,48.483,1],
84503=>[95.615,-78.759,48.444,1],
84504=>[95.621,-78.769,48.406,1],
84505=>[95.626,-78.780,48.367,1],
84506=>[95.633,-78.789,48.330,1],
84507=>[95.645,-78.794,48.294,1],
84508=>[95.657,-78.798,48.260,1],
84509=>[95.669,-78.802,48.225,1],
84510=>[95.690,-78.811,48.189,1],
84511=>[95.719,-78.822,48.150,1],
84512=>[95.748,-78.834,48.111,1],
84513=>[95.775,-78.843,48.070,1],
84514=>[95.799,-78.849,48.026,1],
84515=>[95.812,-78.863,47.984,1],
84516=>[95.828,-78.865,47.942,1],
84517=>[95.845,-78.866,47.900,1],
84518=>[95.863,-78.867,47.858,1],
84519=>[95.879,-78.870,47.815,1],
84520=>[95.894,-78.875,47.772,1],
84521=>[95.901,-78.881,47.729,1],
84522=>[95.923,-78.879,47.686,1],
84523=>[95.948,-78.876,47.645,1],
84524=>[95.972,-78.873,47.603,1],
84525=>[95.996,-78.869,47.562,1],
84526=>[96.020,-78.866,47.520,1],
84527=>[96.044,-78.863,47.478,1],
84528=>[96.068,-78.860,47.436,1],
84529=>[96.093,-78.856,47.395,1],
84530=>[96.117,-78.853,47.355,1],
84531=>[96.137,-78.861,47.317,1],
84532=>[96.155,-78.879,47.278,1],
84533=>[96.172,-78.873,47.242,1],
84534=>[96.188,-78.861,47.205,1],
84535=>[96.205,-78.849,47.167,1],
84536=>[96.227,-78.838,47.130,1],
84537=>[96.252,-78.829,47.094,1],
84538=>[96.277,-78.820,47.060,1],
84539=>[96.302,-78.811,47.028,1],
84540=>[96.327,-78.802,46.997,1],
84541=>[96.336,-78.803,46.965,1],
84542=>[96.337,-78.810,46.930,1],
84543=>[96.346,-78.824,46.897,1],
84544=>[96.358,-78.843,46.864,1],
84545=>[96.369,-78.860,46.832,1],
84546=>[96.380,-78.877,46.801,1],
84547=>[96.391,-78.893,46.771,1],
84548=>[96.401,-78.895,46.740,1],
84549=>[96.410,-78.898,46.710,1],
84550=>[96.449,-78.898,46.681,1],
84551=>[96.494,-78.898,46.653,1],
84552=>[96.539,-78.898,46.626,1],
84553=>[96.585,-78.898,46.598,1],
84554=>[96.629,-78.897,46.572,1],
84555=>[96.670,-78.893,46.546,1],
84556=>[96.711,-78.887,46.520,1],
84557=>[96.751,-78.883,46.496,1],
84558=>[96.791,-78.878,46.474,1],
84559=>[96.832,-78.873,46.454,1],
84560=>[96.848,-78.870,46.432,1],
84561=>[96.858,-78.867,46.410,1],
84562=>[96.868,-78.865,46.387,1],
84563=>[96.878,-78.861,46.366,1],
84564=>[96.890,-78.862,46.345,1],
84565=>[96.911,-78.865,46.324,1],
84566=>[96.932,-78.861,46.304,1],
84567=>[96.940,-78.869,46.284,1],
84568=>[96.930,-78.900,46.265,1],
84569=>[96.956,-78.957,46.246,1],
84570=>[96.971,-78.996,46.228,1],
84571=>[96.980,-78.984,46.212,1],
84572=>[96.993,-78.959,46.195,1],
84573=>[96.989,-78.968,46.178,1],
84574=>[96.982,-78.984,46.162,1],
84575=>[96.976,-78.998,46.146,1],
84576=>[96.970,-79.013,46.129,1],
84577=>[96.984,-79.053,46.113,1],
84578=>[97.006,-79.099,46.098,1],
84579=>[97.027,-79.136,46.084,1],
84580=>[97.047,-79.131,46.069,1],
84581=>[97.067,-79.125,46.054,1],
84582=>[97.087,-79.120,46.038,1],
84583=>[97.108,-79.115,46.023,1],
84584=>[97.128,-79.110,46.009,1],
84585=>[97.148,-79.105,45.996,1],
84586=>[97.168,-79.100,45.983,1],
84587=>[97.188,-79.094,45.971,1],
84588=>[97.209,-79.089,45.957,1],
84589=>[97.223,-79.093,45.942,1],
84590=>[97.229,-79.096,45.926,1],
84591=>[97.235,-79.099,45.909,1],
84592=>[97.242,-79.102,45.892,1],
84593=>[97.251,-79.107,45.875,1],
84594=>[97.265,-79.117,45.858,1],
84595=>[97.280,-79.125,45.839,1],
84596=>[97.295,-79.134,45.821,1],
84597=>[97.310,-79.143,45.803,1],
84598=>[97.325,-79.152,45.783,1],
84599=>[97.341,-79.160,45.766,1],
84600=>[97.356,-79.169,45.750,1],
84601=>[97.371,-79.178,45.734,1],
84602=>[97.385,-79.187,45.716,1],
84603=>[97.400,-79.193,45.697,1],
84604=>[97.411,-79.192,45.678,1],
84605=>[97.423,-79.191,45.660,1],
84606=>[97.434,-79.190,45.644,1],
84607=>[97.453,-79.198,45.628,1],
84608=>[97.475,-79.209,45.612,1],
84609=>[97.498,-79.220,45.595,1],
84610=>[97.520,-79.231,45.578,1],
84611=>[97.535,-79.235,45.562,1],
84612=>[97.550,-79.238,45.546,1],
84613=>[97.565,-79.241,45.530,1],
84614=>[97.580,-79.244,45.514,1],
84615=>[97.594,-79.247,45.499,1],
84616=>[97.613,-79.254,45.482,1],
84617=>[97.633,-79.263,45.465,1],
84618=>[97.640,-79.266,45.449,1],
84619=>[97.640,-79.265,45.434,1],
84620=>[97.640,-79.264,45.419,1],
84621=>[97.639,-79.264,45.405,1],
84622=>[97.639,-79.263,45.392,1],
84623=>[97.639,-79.263,45.377,1],
84624=>[97.639,-79.263,45.363,1],
84625=>[97.639,-79.262,45.349,1],
84626=>[97.641,-79.265,45.335,1],
84627=>[97.659,-79.285,45.325,1],
84628=>[97.678,-79.305,45.315,1],
84629=>[97.696,-79.325,45.303,1],
84630=>[97.714,-79.346,45.293,1],
84631=>[97.733,-79.366,45.281,1],
84632=>[97.751,-79.387,45.268,1],
84633=>[97.769,-79.407,45.255,1],
84634=>[97.788,-79.428,45.244,1],
84635=>[97.816,-79.450,45.233,1],
84636=>[97.840,-79.463,45.223,1],
84637=>[97.855,-79.473,45.212,1],
84638=>[97.867,-79.488,45.201,1],
84639=>[97.879,-79.504,45.190,1],
84640=>[97.892,-79.519,45.178,1],
84641=>[97.904,-79.534,45.168,1],
84642=>[97.916,-79.549,45.158,1],
84643=>[97.929,-79.564,45.150,1],
84644=>[97.941,-79.579,45.140,1],
84645=>[97.952,-79.591,45.131,1],
84646=>[97.964,-79.602,45.123,1],
84647=>[97.993,-79.608,45.115,1],
84648=>[98.030,-79.599,45.107,1],
84649=>[98.067,-79.590,45.099,1],
84650=>[98.104,-79.581,45.092,1],
84651=>[98.142,-79.572,45.085,1],
84652=>[98.178,-79.563,45.077,1],
84653=>[98.216,-79.554,45.070,1],
84654=>[98.249,-79.542,45.062,1],
84655=>[98.282,-79.560,45.054,1],
84656=>[98.318,-79.585,45.046,1],
84657=>[98.354,-79.610,45.037,1],
84658=>[98.389,-79.635,45.027,1],
84659=>[98.422,-79.653,45.018,1],
84660=>[98.448,-79.659,45.009,1],
84661=>[98.475,-79.668,45.000,1],
84662=>[98.502,-79.679,44.991,1],
84663=>[98.529,-79.689,44.983,1],
84664=>[98.557,-79.699,44.976,1],
84665=>[98.584,-79.709,44.968,1],
84666=>[98.611,-79.720,44.961,1],
84667=>[98.638,-79.730,44.954,1],
84668=>[98.665,-79.740,44.949,1],
84669=>[98.692,-79.748,44.944,1],
84670=>[98.706,-79.741,44.940,1],
84671=>[98.720,-79.734,44.936,1],
84672=>[98.734,-79.727,44.932,1],
84673=>[98.749,-79.720,44.928,1],
84674=>[98.763,-79.714,44.923,1],
84675=>[98.778,-79.707,44.919,1],
84676=>[98.792,-79.701,44.913,1],
84677=>[98.813,-79.708,44.908,1],
84678=>[98.835,-79.716,44.903,1],
84679=>[98.856,-79.723,44.897,1],
84680=>[98.878,-79.732,44.891,1],
84681=>[98.900,-79.740,44.884,1],
84682=>[98.922,-79.748,44.879,1],
84683=>[98.943,-79.756,44.872,1],
84684=>[98.966,-79.764,44.865,1],
84685=>[98.987,-79.772,44.858,1],
84686=>[99.008,-79.781,44.851,1],
84687=>[99.027,-79.792,44.843,1],
84688=>[99.058,-79.799,44.834,1],
84689=>[99.082,-79.813,44.824,1],
84690=>[99.106,-79.827,44.814,1],
84691=>[99.130,-79.841,44.806,1],
84692=>[99.148,-79.855,44.797,1],
84693=>[99.172,-79.861,44.786,1],
84694=>[99.196,-79.867,44.774,1],
84695=>[99.219,-79.874,44.763,1],
84696=>[99.243,-79.880,44.752,1],
84697=>[99.267,-79.886,44.743,1],
84698=>[99.291,-79.892,44.735,1],
84699=>[99.314,-79.899,44.727,1],
84700=>[99.338,-79.905,44.719,1],
84701=>[99.362,-79.911,44.711,1],
84702=>[99.385,-79.917,44.703,1],
84703=>[99.409,-79.924,44.697,1],
84704=>[99.433,-79.930,44.690,1],
84705=>[99.457,-79.936,44.681,1],
84706=>[99.481,-79.942,44.673,1],
84707=>[99.504,-79.949,44.665,1],
84708=>[99.528,-79.955,44.657,1],
84709=>[99.552,-79.961,44.648,1],
84710=>[99.567,-79.956,44.641,1],
84711=>[99.579,-79.957,44.632,1],
84712=>[99.578,-79.985,44.622,1],
84713=>[99.576,-80.013,44.614,1],
84714=>[99.575,-80.041,44.605,1],
84715=>[99.574,-80.069,44.597,1],
84716=>[99.573,-80.097,44.590,1],
84717=>[99.571,-80.125,44.583,1],
84718=>[99.570,-80.153,44.575,1],
84719=>[99.569,-80.181,44.567,1],
84720=>[99.566,-80.212,44.560,1],
84721=>[99.558,-80.250,44.553,1],
84722=>[99.549,-80.287,44.545,1],
84723=>[99.550,-80.313,44.538,1],
84724=>[99.553,-80.335,44.530,1],
84725=>[99.556,-80.358,44.521,1],
84726=>[99.559,-80.380,44.512,1],
84727=>[99.595,-80.390,44.502,1],
84728=>[99.644,-80.395,44.492,1],
84729=>[99.692,-80.401,44.481,1],
84730=>[99.742,-80.413,44.471,1],
84731=>[99.793,-80.425,44.460,1],
84732=>[99.845,-80.438,44.449,1],
84733=>[99.896,-80.450,44.437,1],
84734=>[99.947,-80.463,44.425,1],
84735=>[99.999,-80.476,44.413,1],
84736=>[100.050,-80.489,44.401,1],
84737=>[100.101,-80.502,44.387,1],
84738=>[100.152,-80.515,44.375,1],
84739=>[100.198,-80.530,44.363,1],
84740=>[100.243,-80.547,44.349,1],
85034=>[93.566,-78.757,53.610,1],
85035=>[93.576,-78.755,53.602,1],
85036=>[93.586,-78.752,53.594,1],
85037=>[93.595,-78.749,53.586,1],
85038=>[93.605,-78.747,53.578,1],
85039=>[93.615,-78.745,53.573,1],
85040=>[93.625,-78.742,53.567,1],
85041=>[93.629,-78.736,53.562,1],
85042=>[93.628,-78.727,53.559,1],
85043=>[93.627,-78.718,53.559,1],
85044=>[93.625,-78.709,53.561,1],
85045=>[93.624,-78.749,53.565,1],
85046=>[93.635,-78.732,53.564,1],
85047=>[93.646,-78.715,53.560,1],
85048=>[93.663,-78.705,53.555,1],
85049=>[93.681,-78.694,53.546,1],
85050=>[93.698,-78.683,53.535,1],
85051=>[93.716,-78.673,53.522,1],
85052=>[93.734,-78.658,53.508,1],
85053=>[93.754,-78.642,53.492,1],
85054=>[93.773,-78.624,53.475,1],
85055=>[93.780,-78.614,53.456,1],
85056=>[93.784,-78.605,53.437,1],
85057=>[93.787,-78.596,53.418,1],
85058=>[93.790,-78.582,53.398,1],
85059=>[93.792,-78.568,53.377,1],
85060=>[93.795,-78.554,53.355,1],
85061=>[93.798,-78.540,53.332,1],
85062=>[93.800,-78.526,53.308,1],
85063=>[93.803,-78.511,53.283,1],
85064=>[93.806,-78.497,53.258,1],
85065=>[93.827,-78.517,53.233,1],
85066=>[93.845,-78.520,53.209,1],
85067=>[93.858,-78.508,53.186,1],
85068=>[93.870,-78.495,53.162,1],
85069=>[93.889,-78.482,53.137,1],
85070=>[93.933,-78.464,53.117,1],
85071=>[93.977,-78.447,53.098,1],
85072=>[93.990,-78.450,53.081,1],
85073=>[93.991,-78.460,53.065,1],
85074=>[93.992,-78.470,53.048,1],
85075=>[93.998,-78.479,53.030,1],
85076=>[94.009,-78.484,53.009,1],
85077=>[94.020,-78.489,52.988,1],
85078=>[94.035,-78.487,52.966,1],
85079=>[94.049,-78.485,52.945,1],
85080=>[94.064,-78.484,52.923,1],
85081=>[94.078,-78.482,52.902,1],
85082=>[94.093,-78.481,52.879,1],
85083=>[94.108,-78.479,52.853,1],
85084=>[94.122,-78.478,52.827,1],
85085=>[94.137,-78.476,52.805,1],
85086=>[94.150,-78.474,52.785,1],
85087=>[94.157,-78.449,52.767,1],
85088=>[94.177,-78.413,52.749,1],
85089=>[94.196,-78.379,52.731,1],
85090=>[94.215,-78.343,52.714,1],
85091=>[94.233,-78.310,52.697,1],
85092=>[94.236,-78.304,52.680,1],
85093=>[94.237,-78.360,52.662,1],
85094=>[94.242,-78.438,52.643,1],
85095=>[94.249,-78.528,52.626,1],
85096=>[94.261,-78.566,52.608,1],
85097=>[94.276,-78.573,52.589,1],
85098=>[94.290,-78.579,52.571,1],
85099=>[94.306,-78.586,52.552,1],
85100=>[94.321,-78.592,52.534,1],
85101=>[94.335,-78.599,52.515,1],
85102=>[94.350,-78.606,52.497,1],
85103=>[94.365,-78.612,52.478,1],
85104=>[94.363,-78.623,52.455,1],
85105=>[94.376,-78.614,52.433,1],
85106=>[94.385,-78.600,52.410,1],
85107=>[94.402,-78.586,52.385,1],
85108=>[94.420,-78.570,52.360,1],
85109=>[94.437,-78.556,52.332,1],
85110=>[94.453,-78.545,52.302,1],
85111=>[94.462,-78.545,52.269,1],
85112=>[94.471,-78.545,52.236,1],
85113=>[94.480,-78.546,52.202,1],
85114=>[94.493,-78.548,52.167,1],
85115=>[94.508,-78.552,52.132,1],
85116=>[94.524,-78.557,52.098,1],
85117=>[94.540,-78.561,52.064,1],
85118=>[94.555,-78.565,52.032,1],
85119=>[94.571,-78.570,52.002,1],
85120=>[94.579,-78.572,51.969,1],
85121=>[94.586,-78.574,51.932,1],
85122=>[94.596,-78.573,51.895,1],
85123=>[94.607,-78.572,51.856,1],
85124=>[94.617,-78.571,51.816,1],
85125=>[94.631,-78.574,51.774,1],
85126=>[94.644,-78.578,51.730,1],
85127=>[94.657,-78.582,51.684,1],
85128=>[94.671,-78.586,51.635,1],
85129=>[94.684,-78.588,51.587,1],
85130=>[94.697,-78.590,51.538,1],
85131=>[94.710,-78.592,51.489,1],
85132=>[94.723,-78.594,51.442,1],
85133=>[94.736,-78.596,51.393,1],
85134=>[94.757,-78.600,51.345,1],
85135=>[94.778,-78.604,51.298,1],
85136=>[94.800,-78.608,51.252,1],
85137=>[94.821,-78.613,51.206,1],
85138=>[94.842,-78.617,51.160,1],
85139=>[94.863,-78.621,51.114,1],
85140=>[94.885,-78.626,51.069,1],
85141=>[94.901,-78.630,51.025,1],
85142=>[94.918,-78.622,50.982,1],
85143=>[94.939,-78.623,50.937,1],
85144=>[94.944,-78.624,50.894,1],
85145=>[94.949,-78.626,50.852,1],
85146=>[94.953,-78.628,50.809,1],
85147=>[94.958,-78.630,50.767,1],
85148=>[94.962,-78.632,50.725,1],
85149=>[94.964,-78.633,50.684,1],
85150=>[94.958,-78.632,50.639,1],
85151=>[94.952,-78.631,50.594,1],
85152=>[94.947,-78.630,50.549,1],
85153=>[94.945,-78.626,50.505,1],
85154=>[94.959,-78.608,50.461,1],
85155=>[94.974,-78.591,50.416,1],
85156=>[94.988,-78.573,50.371,1],
85157=>[95.002,-78.554,50.327,1],
85158=>[95.017,-78.537,50.283,1],
85159=>[95.031,-78.519,50.238,1],
85160=>[95.049,-78.515,50.195,1],
85161=>[95.069,-78.520,50.152,1],
85162=>[95.090,-78.526,50.109,1],
85163=>[95.111,-78.530,50.067,1],
85164=>[95.125,-78.535,50.025,1],
85165=>[95.135,-78.539,49.983,1],
85166=>[95.146,-78.542,49.942,1],
85167=>[95.157,-78.545,49.902,1],
85168=>[95.168,-78.549,49.864,1],
85169=>[95.178,-78.553,49.827,1],
85170=>[95.189,-78.557,49.789,1],
85171=>[95.199,-78.561,49.752,1],
85172=>[95.210,-78.564,49.715,1],
85173=>[95.229,-78.573,49.677,1],
85174=>[95.261,-78.589,49.639,1],
85175=>[95.295,-78.606,49.600,1],
85176=>[95.328,-78.623,49.562,1],
85177=>[95.360,-78.640,49.524,1],
85178=>[95.381,-78.654,49.487,1],
85179=>[95.390,-78.672,49.449,1],
85180=>[95.404,-78.693,49.410,1],
85181=>[95.418,-78.714,49.376,1],
85182=>[95.432,-78.736,49.342,1],
85183=>[95.446,-78.756,49.308,1],
85184=>[95.460,-78.777,49.273,1],
85185=>[95.471,-78.796,49.238,1],
85186=>[95.465,-78.795,49.201,1],
85187=>[95.460,-78.794,49.163,1],
85188=>[95.450,-78.792,49.122,1],
85189=>[95.432,-78.786,49.082,1],
85190=>[95.415,-78.782,49.040,1],
85191=>[95.418,-78.771,48.999,1],
85192=>[95.422,-78.759,48.957,1],
85193=>[95.426,-78.748,48.913,1],
85194=>[95.430,-78.737,48.868,1],
85195=>[95.434,-78.726,48.824,1],
85196=>[95.443,-78.717,48.780,1],
85197=>[95.466,-78.719,48.736,1],
85198=>[95.489,-78.721,48.694,1],
85199=>[95.513,-78.724,48.653,1],
85200=>[95.536,-78.725,48.612,1],
85201=>[95.559,-78.727,48.572,1],
85202=>[95.583,-78.729,48.531,1],
85203=>[95.606,-78.731,48.492,1],
85204=>[95.617,-78.739,48.453,1],
85205=>[95.623,-78.749,48.414,1],
85206=>[95.629,-78.760,48.376,1],
85207=>[95.641,-78.764,48.339,1],
85208=>[95.653,-78.768,48.303,1],
85209=>[95.665,-78.773,48.268,1],
85210=>[95.677,-78.777,48.233,1],
85211=>[95.695,-78.784,48.197,1],
85212=>[95.725,-78.796,48.159,1],
85213=>[95.753,-78.808,48.120,1],
85214=>[95.782,-78.820,48.079,1],
85215=>[95.806,-78.821,48.038,1],
85216=>[95.823,-78.822,47.998,1],
85217=>[95.841,-78.823,47.956,1],
85218=>[95.858,-78.824,47.914,1],
85219=>[95.875,-78.826,47.872,1],
85220=>[95.890,-78.831,47.829,1],
85221=>[95.904,-78.836,47.787,1],
85222=>[95.911,-78.843,47.744,1],
85223=>[95.926,-78.844,47.702,1],
85224=>[95.950,-78.841,47.659,1],
85225=>[95.974,-78.838,47.616,1],
85226=>[95.999,-78.835,47.573,1],
85227=>[96.023,-78.831,47.531,1],
85228=>[96.047,-78.828,47.489,1],
85229=>[96.071,-78.825,47.447,1],
85230=>[96.095,-78.822,47.407,1],
85231=>[96.119,-78.821,47.367,1],
85232=>[96.136,-78.839,47.329,1],
85233=>[96.154,-78.856,47.291,1],
85234=>[96.171,-78.862,47.254,1],
85235=>[96.188,-78.850,47.217,1],
85236=>[96.204,-78.838,47.179,1],
85237=>[96.221,-78.825,47.142,1],
85238=>[96.237,-78.813,47.106,1],
85239=>[96.258,-78.802,47.071,1],
85240=>[96.283,-78.793,47.039,1],
85241=>[96.308,-78.784,47.007,1],
85242=>[96.320,-78.783,46.974,1],
85243=>[96.325,-78.794,46.939,1],
85244=>[96.337,-78.812,46.906,1],
85245=>[96.348,-78.830,46.874,1],
85246=>[96.360,-78.847,46.842,1],
85247=>[96.371,-78.865,46.811,1],
85248=>[96.382,-78.883,46.781,1],
85249=>[96.392,-78.887,46.750,1],
85250=>[96.401,-78.890,46.720,1],
85251=>[96.443,-78.890,46.691,1],
85252=>[96.488,-78.890,46.664,1],
85253=>[96.533,-78.890,46.637,1],
85254=>[96.579,-78.890,46.610,1],
85255=>[96.619,-78.885,46.584,1],
85256=>[96.660,-78.880,46.558,1],
85257=>[96.700,-78.875,46.531,1],
85258=>[96.741,-78.871,46.508,1],
85259=>[96.781,-78.866,46.486,1],
85260=>[96.822,-78.861,46.466,1],
85261=>[96.844,-78.857,46.444,1],
85262=>[96.855,-78.855,46.421,1],
85263=>[96.865,-78.852,46.398,1],
85264=>[96.875,-78.849,46.378,1],
85265=>[96.890,-78.853,46.357,1],
85266=>[96.910,-78.861,46.337,1],
85267=>[96.931,-78.857,46.317,1],
85268=>[96.941,-78.862,46.297,1],
85269=>[96.934,-78.896,46.278,1],
85270=>[96.960,-78.952,46.260,1],
85271=>[96.971,-78.978,46.242,1],
85272=>[96.966,-78.993,46.226,1],
85273=>[96.977,-78.976,46.210,1],
85274=>[96.985,-78.961,46.193,1],
85275=>[96.979,-78.976,46.177,1],
85276=>[96.973,-78.990,46.161,1],
85277=>[96.966,-79.006,46.145,1],
85278=>[96.982,-79.046,46.129,1],
85279=>[97.004,-79.093,46.114,1],
85280=>[97.024,-79.106,46.099,1],
85281=>[97.044,-79.101,46.084,1],
85282=>[97.065,-79.096,46.069,1],
85283=>[97.085,-79.090,46.053,1],
85284=>[97.105,-79.085,46.037,1],
85285=>[97.125,-79.080,46.023,1],
85286=>[97.146,-79.075,46.011,1],
85287=>[97.166,-79.070,45.999,1],
85288=>[97.189,-79.073,45.986,1],
85289=>[97.213,-79.078,45.972,1],
85290=>[97.230,-79.087,45.956,1],
85291=>[97.237,-79.091,45.938,1],
85292=>[97.243,-79.095,45.922,1],
85293=>[97.248,-79.098,45.906,1],
85294=>[97.257,-79.103,45.889,1],
85295=>[97.272,-79.112,45.870,1],
85296=>[97.287,-79.120,45.849,1],
85297=>[97.302,-79.129,45.829,1],
85298=>[97.317,-79.137,45.810,1],
85299=>[97.332,-79.147,45.791,1],
85300=>[97.348,-79.155,45.772,1],
85301=>[97.363,-79.164,45.755,1],
85302=>[97.378,-79.173,45.738,1],
85303=>[97.391,-79.178,45.720,1],
85304=>[97.403,-79.177,45.702,1],
85305=>[97.414,-79.176,45.683,1],
85306=>[97.426,-79.175,45.666,1],
85307=>[97.437,-79.175,45.650,1],
85308=>[97.454,-79.179,45.634,1],
85309=>[97.476,-79.190,45.618,1],
85310=>[97.498,-79.201,45.602,1],
85311=>[97.520,-79.212,45.585,1],
85312=>[97.542,-79.223,45.568,1],
85313=>[97.564,-79.233,45.552,1],
85314=>[97.579,-79.236,45.536,1],
85315=>[97.593,-79.239,45.521,1],
85316=>[97.608,-79.243,45.506,1],
85317=>[97.629,-79.251,45.489,1],
85318=>[97.631,-79.252,45.473,1],
85319=>[97.631,-79.251,45.458,1],
85320=>[97.631,-79.250,45.444,1],
85321=>[97.631,-79.250,45.430,1],
85322=>[97.631,-79.250,45.417,1],
85323=>[97.631,-79.250,45.404,1],
85324=>[97.630,-79.249,45.389,1],
85325=>[97.630,-79.249,45.375,1],
85326=>[97.630,-79.248,45.360,1],
85327=>[97.634,-79.252,45.346,1],
85328=>[97.652,-79.272,45.335,1],
85329=>[97.670,-79.292,45.325,1],
85330=>[97.688,-79.313,45.312,1],
85331=>[97.707,-79.333,45.300,1],
85332=>[97.725,-79.353,45.288,1],
85333=>[97.743,-79.374,45.276,1],
85334=>[97.761,-79.394,45.263,1],
85335=>[97.788,-79.416,45.252,1],
85336=>[97.823,-79.436,45.241,1],
85337=>[97.840,-79.444,45.231,1],
85338=>[97.856,-79.454,45.220,1],
85339=>[97.868,-79.469,45.210,1],
85340=>[97.880,-79.485,45.200,1],
85341=>[97.892,-79.500,45.189,1],
85342=>[97.905,-79.515,45.179,1],
85343=>[97.917,-79.530,45.170,1],
85344=>[97.930,-79.545,45.160,1],
85345=>[97.942,-79.561,45.152,1],
85346=>[97.954,-79.576,45.143,1],
85347=>[97.967,-79.591,45.134,1],
85348=>[97.995,-79.595,45.125,1],
85349=>[98.041,-79.575,45.117,1],
85350=>[98.078,-79.566,45.109,1],
85351=>[98.115,-79.557,45.102,1],
85352=>[98.153,-79.548,45.095,1],
85353=>[98.190,-79.538,45.087,1],
85354=>[98.227,-79.529,45.080,1],
85355=>[98.260,-79.517,45.071,1],
85356=>[98.293,-79.535,45.063,1],
85357=>[98.329,-79.560,45.055,1],
85358=>[98.364,-79.585,45.047,1],
85359=>[98.400,-79.610,45.038,1],
85360=>[98.436,-79.634,45.029,1],
85361=>[98.465,-79.646,45.020,1],
85362=>[98.492,-79.657,45.011,1],
85363=>[98.519,-79.667,45.003,1],
85364=>[98.546,-79.677,44.996,1],
85365=>[98.573,-79.688,44.988,1],
85366=>[98.598,-79.697,44.980,1],
85367=>[98.624,-79.706,44.973,1],
85368=>[98.649,-79.715,44.966,1],
85369=>[98.675,-79.724,44.960,1],
85370=>[98.690,-79.738,44.956,1],
85371=>[98.707,-79.729,44.952,1],
85372=>[98.724,-79.720,44.948,1],
85373=>[98.741,-79.712,44.944,1],
85374=>[98.757,-79.704,44.940,1],
85375=>[98.771,-79.698,44.937,1],
85376=>[98.786,-79.691,44.933,1],
85377=>[98.800,-79.684,44.929,1],
85378=>[98.818,-79.686,44.923,1],
85379=>[98.841,-79.695,44.919,1],
85380=>[98.862,-79.702,44.913,1],
85381=>[98.884,-79.711,44.907,1],
85382=>[98.905,-79.720,44.900,1],
85383=>[98.924,-79.731,44.894,1],
85384=>[98.944,-79.742,44.887,1],
85385=>[98.963,-79.754,44.879,1],
85386=>[98.982,-79.765,44.870,1],
85387=>[99.001,-79.776,44.862,1],
85388=>[99.037,-79.780,44.853,1],
85389=>[99.076,-79.783,44.844,1],
85390=>[99.100,-79.796,44.834,1],
85391=>[99.125,-79.811,44.822,1],
85392=>[99.148,-79.824,44.810,1],
85393=>[99.157,-79.839,44.800,1],
85394=>[99.176,-79.847,44.789,1],
85395=>[99.200,-79.853,44.778,1],
85396=>[99.223,-79.859,44.768,1],
85397=>[99.247,-79.866,44.758,1],
85398=>[99.271,-79.872,44.749,1],
85399=>[99.294,-79.878,44.742,1],
85400=>[99.319,-79.884,44.734,1],
85401=>[99.342,-79.891,44.726,1],
85402=>[99.366,-79.897,44.717,1],
85403=>[99.390,-79.903,44.709,1],
85404=>[99.413,-79.909,44.701,1],
85405=>[99.437,-79.916,44.694,1],
85406=>[99.461,-79.922,44.685,1],
85407=>[99.484,-79.928,44.677,1],
85408=>[99.508,-79.935,44.669,1],
85409=>[99.532,-79.941,44.660,1],
85410=>[99.549,-79.938,44.651,1],
85411=>[99.564,-79.932,44.644,1],
85412=>[99.574,-79.936,44.636,1],
85413=>[99.573,-79.965,44.626,1],
85414=>[99.572,-79.993,44.617,1],
85415=>[99.571,-80.021,44.608,1],
85416=>[99.569,-80.049,44.600,1],
85417=>[99.568,-80.077,44.593,1],
85418=>[99.567,-80.105,44.585,1],
85419=>[99.566,-80.133,44.577,1],
85420=>[99.564,-80.161,44.571,1],
85421=>[99.563,-80.189,44.563,1],
85422=>[99.562,-80.216,44.555,1],
85423=>[99.561,-80.244,44.549,1],
85424=>[99.559,-80.272,44.541,1],
85425=>[99.554,-80.306,44.533,1],
85426=>[99.553,-80.335,44.525,1],
85427=>[99.556,-80.357,44.517,1],
85428=>[99.604,-80.363,44.507,1],
85429=>[99.655,-80.374,44.497,1],
85430=>[99.706,-80.387,44.487,1],
85431=>[99.757,-80.400,44.476,1],
85432=>[99.808,-80.413,44.465,1],
85433=>[99.860,-80.425,44.453,1],
85434=>[99.911,-80.438,44.441,1],
85435=>[99.963,-80.451,44.430,1],
85436=>[100.014,-80.463,44.417,1],
85437=>[100.065,-80.476,44.405,1],
85438=>[100.112,-80.492,44.392,1],
85439=>[100.156,-80.508,44.379,1],
85440=>[100.201,-80.525,44.367,1],
85441=>[100.245,-80.541,44.354,1],
85735=>[93.567,-78.746,53.617,1],
85736=>[93.576,-78.743,53.609,1],
85737=>[93.586,-78.741,53.600,1],
85738=>[93.596,-78.739,53.592,1],
85739=>[93.606,-78.736,53.585,1],
85740=>[93.615,-78.733,53.578,1],
85741=>[93.625,-78.731,53.571,1],
85742=>[93.626,-78.724,53.565,1],
85743=>[93.625,-78.714,53.563,1],
85744=>[93.623,-78.705,53.561,1],
85745=>[93.622,-78.695,53.562,1],
85746=>[93.620,-78.721,53.565,1],
85747=>[93.630,-78.707,53.563,1],
85748=>[93.644,-78.692,53.560,1],
85749=>[93.661,-78.682,53.554,1],
85750=>[93.679,-78.671,53.545,1],
85751=>[93.697,-78.661,53.534,1],
85752=>[93.714,-78.651,53.522,1],
85753=>[93.731,-78.640,53.508,1],
85754=>[93.750,-78.627,53.491,1],
85755=>[93.769,-78.611,53.474,1],
85756=>[93.775,-78.600,53.454,1],
85757=>[93.778,-78.589,53.434,1],
85758=>[93.781,-78.576,53.414,1],
85759=>[93.784,-78.561,53.393,1],
85760=>[93.786,-78.547,53.372,1],
85761=>[93.789,-78.532,53.350,1],
85762=>[93.792,-78.519,53.326,1],
85763=>[93.794,-78.504,53.302,1],
85764=>[93.797,-78.490,53.277,1],
85765=>[93.800,-78.476,53.252,1],
85766=>[93.815,-78.485,53.227,1],
85767=>[93.840,-78.510,53.203,1],
85768=>[93.853,-78.497,53.180,1],
85769=>[93.865,-78.485,53.158,1],
85770=>[93.902,-78.468,53.135,1],
85771=>[93.945,-78.451,53.116,1],
85772=>[93.989,-78.433,53.098,1],
85773=>[94.000,-78.438,53.081,1],
85774=>[94.001,-78.448,53.066,1],
85775=>[94.002,-78.458,53.051,1],
85776=>[94.004,-78.469,53.033,1],
85777=>[94.015,-78.471,53.012,1],
85778=>[94.030,-78.470,52.989,1],
85779=>[94.045,-78.468,52.966,1],
85780=>[94.059,-78.467,52.943,1],
85781=>[94.074,-78.465,52.922,1],
85782=>[94.088,-78.463,52.900,1],
85783=>[94.103,-78.462,52.876,1],
85784=>[94.118,-78.460,52.850,1],
85785=>[94.132,-78.459,52.827,1],
85786=>[94.147,-78.457,52.808,1],
85787=>[94.161,-78.456,52.790,1],
85788=>[94.173,-78.448,52.772,1],
85789=>[94.189,-78.415,52.755,1],
85790=>[94.208,-78.379,52.737,1],
85791=>[94.220,-78.357,52.718,1],
85792=>[94.222,-78.351,52.701,1],
85793=>[94.225,-78.344,52.683,1],
85794=>[94.227,-78.384,52.665,1],
85795=>[94.228,-78.445,52.646,1],
85796=>[94.229,-78.507,52.629,1],
85797=>[94.236,-78.567,52.612,1],
85798=>[94.251,-78.574,52.594,1],
85799=>[94.266,-78.580,52.576,1],
85800=>[94.281,-78.587,52.558,1],
85801=>[94.296,-78.594,52.540,1],
85802=>[94.312,-78.599,52.522,1],
85803=>[94.328,-78.605,52.505,1],
85804=>[94.345,-78.611,52.486,1],
85805=>[94.361,-78.617,52.464,1],
85806=>[94.381,-78.611,52.442,1],
85807=>[94.399,-78.596,52.419,1],
85808=>[94.416,-78.582,52.395,1],
85809=>[94.433,-78.567,52.370,1],
85810=>[94.451,-78.552,52.342,1],
85811=>[94.464,-78.545,52.312,1],
85812=>[94.473,-78.545,52.279,1],
85813=>[94.483,-78.546,52.245,1],
85814=>[94.492,-78.546,52.211,1],
85815=>[94.501,-78.546,52.176,1],
85816=>[94.510,-78.546,52.141,1],
85817=>[94.526,-78.551,52.108,1],
85818=>[94.542,-78.555,52.075,1],
85819=>[94.557,-78.559,52.042,1],
85820=>[94.573,-78.564,52.010,1],
85821=>[94.585,-78.567,51.976,1],
85822=>[94.591,-78.569,51.941,1],
85823=>[94.602,-78.567,51.904,1],
85824=>[94.612,-78.567,51.866,1],
85825=>[94.622,-78.565,51.826,1],
85826=>[94.633,-78.564,51.784,1],
85827=>[94.647,-78.568,51.739,1],
85828=>[94.660,-78.572,51.693,1],
85829=>[94.674,-78.576,51.644,1],
85830=>[94.687,-78.579,51.594,1],
85831=>[94.700,-78.582,51.545,1],
85832=>[94.713,-78.586,51.496,1],
85833=>[94.726,-78.588,51.446,1],
85834=>[94.740,-78.589,51.396,1],
85835=>[94.761,-78.594,51.347,1],
85836=>[94.782,-78.598,51.299,1],
85837=>[94.803,-78.602,51.251,1],
85838=>[94.824,-78.607,51.204,1],
85839=>[94.845,-78.611,51.157,1],
85840=>[94.867,-78.615,51.110,1],
85841=>[94.888,-78.619,51.065,1],
85842=>[94.904,-78.622,51.020,1],
85843=>[94.901,-78.630,50.976,1],
85844=>[94.906,-78.633,50.931,1],
85845=>[94.910,-78.634,50.888,1],
85846=>[94.915,-78.636,50.845,1],
85847=>[94.919,-78.638,50.803,1],
85848=>[94.924,-78.640,50.761,1],
85849=>[94.928,-78.642,50.720,1],
85850=>[94.922,-78.641,50.679,1],
85851=>[94.917,-78.640,50.636,1],
85852=>[94.921,-78.631,50.592,1],
85853=>[94.935,-78.613,50.549,1],
85854=>[94.950,-78.595,50.506,1],
85855=>[94.964,-78.577,50.462,1],
85856=>[94.979,-78.559,50.417,1],
85857=>[94.993,-78.542,50.372,1],
85858=>[95.007,-78.523,50.328,1],
85859=>[95.022,-78.506,50.284,1],
85860=>[95.037,-78.490,50.239,1],
85861=>[95.057,-78.495,50.195,1],
85862=>[95.077,-78.500,50.152,1],
85863=>[95.098,-78.505,50.109,1],
85864=>[95.118,-78.510,50.065,1],
85865=>[95.139,-78.516,50.024,1],
85866=>[95.149,-78.519,49.982,1],
85867=>[95.160,-78.523,49.941,1],
85868=>[95.171,-78.526,49.902,1],
85869=>[95.181,-78.530,49.864,1],
85870=>[95.192,-78.534,49.826,1],
85871=>[95.203,-78.538,49.788,1],
85872=>[95.213,-78.542,49.751,1],
85873=>[95.224,-78.545,49.713,1],
85874=>[95.255,-78.561,49.674,1],
85875=>[95.288,-78.577,49.637,1],
85876=>[95.321,-78.595,49.599,1],
85877=>[95.354,-78.611,49.561,1],
85878=>[95.387,-78.628,49.523,1],
85879=>[95.420,-78.645,49.486,1],
85880=>[95.433,-78.659,49.449,1],
85881=>[95.448,-78.680,49.412,1],
85882=>[95.462,-78.701,49.377,1],
85883=>[95.475,-78.722,49.343,1],
85884=>[95.489,-78.743,49.309,1],
85885=>[95.503,-78.764,49.276,1],
85886=>[95.498,-78.764,49.242,1],
85887=>[95.493,-78.764,49.206,1],
85888=>[95.488,-78.764,49.169,1],
85889=>[95.483,-78.763,49.129,1],
85890=>[95.469,-78.759,49.089,1],
85891=>[95.452,-78.755,49.047,1],
85892=>[95.435,-78.749,49.006,1],
85893=>[95.418,-78.745,48.963,1],
85894=>[95.416,-78.735,48.918,1],
85895=>[95.420,-78.724,48.872,1],
85896=>[95.424,-78.712,48.828,1],
85897=>[95.432,-78.704,48.785,1],
85898=>[95.456,-78.706,48.742,1],
85899=>[95.479,-78.708,48.700,1],
85900=>[95.502,-78.710,48.659,1],
85901=>[95.526,-78.711,48.619,1],
85902=>[95.549,-78.714,48.580,1],
85903=>[95.572,-78.716,48.540,1],
85904=>[95.596,-78.717,48.501,1],
85905=>[95.619,-78.720,48.462,1],
85906=>[95.625,-78.730,48.423,1],
85907=>[95.637,-78.735,48.386,1],
85908=>[95.649,-78.739,48.350,1],
85909=>[95.661,-78.743,48.313,1],
85910=>[95.673,-78.748,48.277,1],
85911=>[95.685,-78.752,48.241,1],
85912=>[95.701,-78.758,48.204,1],
85913=>[95.730,-78.770,48.167,1],
85914=>[95.759,-78.782,48.127,1],
85915=>[95.788,-78.786,48.087,1],
85916=>[95.818,-78.780,48.047,1],
85917=>[95.836,-78.780,48.007,1],
85918=>[95.853,-78.781,47.967,1],
85919=>[95.870,-78.782,47.925,1],
85920=>[95.886,-78.787,47.883,1],
85921=>[95.901,-78.793,47.841,1],
85922=>[95.914,-78.798,47.799,1],
85923=>[95.921,-78.803,47.757,1],
85924=>[95.930,-78.809,47.715,1],
85925=>[95.953,-78.806,47.672,1],
85926=>[95.977,-78.803,47.629,1],
85927=>[96.002,-78.800,47.585,1],
85928=>[96.026,-78.797,47.544,1],
85929=>[96.050,-78.793,47.502,1],
85930=>[96.074,-78.790,47.460,1],
85931=>[96.098,-78.787,47.420,1],
85932=>[96.117,-78.799,47.380,1],
85933=>[96.135,-78.816,47.341,1],
85934=>[96.153,-78.834,47.303,1],
85935=>[96.171,-78.852,47.266,1],
85936=>[96.187,-78.839,47.229,1],
85937=>[96.203,-78.827,47.192,1],
85938=>[96.220,-78.815,47.155,1],
85939=>[96.237,-78.802,47.118,1],
85940=>[96.253,-78.790,47.083,1],
85941=>[96.269,-78.777,47.049,1],
85942=>[96.289,-78.767,47.017,1],
85943=>[96.305,-78.764,46.984,1],
85944=>[96.316,-78.782,46.950,1],
85945=>[96.327,-78.799,46.917,1],
85946=>[96.339,-78.818,46.885,1],
85947=>[96.350,-78.835,46.854,1],
85948=>[96.361,-78.852,46.823,1],
85949=>[96.373,-78.870,46.792,1],
85950=>[96.383,-78.879,46.761,1],
85951=>[96.393,-78.882,46.731,1],
85952=>[96.437,-78.882,46.703,1],
85953=>[96.482,-78.882,46.676,1],
85954=>[96.527,-78.881,46.649,1],
85955=>[96.569,-78.877,46.623,1],
85956=>[96.609,-78.873,46.597,1],
85957=>[96.650,-78.868,46.570,1],
85958=>[96.690,-78.863,46.542,1],
85959=>[96.731,-78.858,46.520,1],
85960=>[96.771,-78.853,46.499,1],
85961=>[96.812,-78.849,46.478,1],
85962=>[96.841,-78.845,46.456,1],
85963=>[96.851,-78.842,46.433,1],
85964=>[96.861,-78.839,46.411,1],
85965=>[96.871,-78.836,46.391,1],
85966=>[96.889,-78.844,46.371,1],
85967=>[96.909,-78.855,46.351,1],
85968=>[96.930,-78.852,46.332,1],
85969=>[96.943,-78.855,46.311,1],
85970=>[96.938,-78.890,46.292,1],
85971=>[96.965,-78.947,46.273,1],
85972=>[96.971,-78.959,46.256,1],
85973=>[96.958,-78.977,46.240,1],
85974=>[96.963,-78.988,46.224,1],
85975=>[96.975,-78.968,46.209,1],
85976=>[96.975,-78.968,46.193,1],
85977=>[96.969,-78.983,46.177,1],
85978=>[96.963,-78.998,46.161,1],
85979=>[96.980,-79.040,46.144,1],
85980=>[97.001,-79.081,46.130,1],
85981=>[97.022,-79.076,46.115,1],
85982=>[97.042,-79.071,46.101,1],
85983=>[97.062,-79.066,46.083,1],
85984=>[97.082,-79.061,46.066,1],
85985=>[97.102,-79.056,46.050,1],
85986=>[97.122,-79.050,46.035,1],
85987=>[97.146,-79.053,46.025,1],
85988=>[97.169,-79.057,46.012,1],
85989=>[97.193,-79.062,45.996,1],
85990=>[97.216,-79.066,45.982,1],
85991=>[97.232,-79.078,45.965,1],
85992=>[97.246,-79.087,45.947,1],
85993=>[97.251,-79.090,45.931,1],
85994=>[97.257,-79.093,45.915,1],
85995=>[97.264,-79.097,45.897,1],
85996=>[97.280,-79.106,45.877,1],
85997=>[97.295,-79.115,45.856,1],
85998=>[97.310,-79.124,45.836,1],
85999=>[97.325,-79.132,45.817,1],
86000=>[97.340,-79.141,45.798,1],
86001=>[97.355,-79.150,45.781,1],
86002=>[97.370,-79.159,45.763,1],
86003=>[97.383,-79.162,45.745,1],
86004=>[97.394,-79.161,45.727,1],
86005=>[97.406,-79.160,45.709,1],
86006=>[97.417,-79.159,45.691,1],
86007=>[97.429,-79.159,45.675,1],
86008=>[97.440,-79.158,45.659,1],
86009=>[97.454,-79.160,45.644,1],
86010=>[97.476,-79.172,45.628,1],
86011=>[97.499,-79.182,45.612,1],
86012=>[97.521,-79.194,45.595,1],
86013=>[97.543,-79.204,45.578,1],
86014=>[97.566,-79.215,45.562,1],
86015=>[97.588,-79.226,45.546,1],
86016=>[97.607,-79.234,45.531,1],
86017=>[97.623,-79.238,45.516,1],
86018=>[97.623,-79.238,45.501,1],
86019=>[97.623,-79.237,45.486,1],
86020=>[97.622,-79.237,45.471,1],
86021=>[97.622,-79.237,45.456,1],
86022=>[97.622,-79.236,45.444,1],
86023=>[97.622,-79.236,45.431,1],
86024=>[97.621,-79.235,45.418,1],
86025=>[97.621,-79.235,45.402,1],
86026=>[97.621,-79.234,45.386,1],
86027=>[97.621,-79.234,45.370,1],
86028=>[97.626,-79.239,45.355,1],
86029=>[97.644,-79.259,45.343,1],
86030=>[97.662,-79.279,45.332,1],
86031=>[97.680,-79.300,45.320,1],
86032=>[97.699,-79.320,45.308,1],
86033=>[97.717,-79.341,45.296,1],
86034=>[97.735,-79.361,45.284,1],
86035=>[97.759,-79.382,45.272,1],
86036=>[97.799,-79.406,45.260,1],
86037=>[97.823,-79.419,45.249,1],
86038=>[97.840,-79.427,45.239,1],
86039=>[97.856,-79.435,45.229,1],
86040=>[97.869,-79.451,45.219,1],
86041=>[97.881,-79.466,45.209,1],
86042=>[97.893,-79.481,45.200,1],
86043=>[97.906,-79.496,45.191,1],
86044=>[97.918,-79.511,45.181,1],
86045=>[97.931,-79.526,45.171,1],
86046=>[97.943,-79.541,45.163,1],
86047=>[97.955,-79.557,45.155,1],
86048=>[97.975,-79.569,45.145,1],
86049=>[97.999,-79.576,45.136,1],
86050=>[98.024,-79.584,45.128,1],
86051=>[98.055,-79.583,45.120,1],
86052=>[98.108,-79.555,45.113,1],
86053=>[98.161,-79.527,45.106,1],
86054=>[98.201,-79.514,45.099,1],
86055=>[98.238,-79.505,45.091,1],
86056=>[98.271,-79.493,45.082,1],
86057=>[98.303,-79.510,45.073,1],
86058=>[98.339,-79.535,45.066,1],
86059=>[98.374,-79.560,45.057,1],
86060=>[98.414,-79.591,45.049,1],
86061=>[98.444,-79.620,45.041,1],
86062=>[98.476,-79.632,45.033,1],
86063=>[98.502,-79.641,45.024,1],
86064=>[98.527,-79.650,45.016,1],
86065=>[98.553,-79.659,45.007,1],
86066=>[98.578,-79.668,44.999,1],
86067=>[98.604,-79.677,44.991,1],
86068=>[98.629,-79.686,44.985,1],
86069=>[98.655,-79.695,44.978,1],
86070=>[98.680,-79.704,44.972,1],
86071=>[98.691,-79.723,44.968,1],
86072=>[98.701,-79.723,44.964,1],
86073=>[98.718,-79.714,44.959,1],
86074=>[98.735,-79.705,44.956,1],
86075=>[98.752,-79.696,44.952,1],
86076=>[98.770,-79.688,44.949,1],
86077=>[98.787,-79.679,44.946,1],
86078=>[98.803,-79.670,44.942,1],
86079=>[98.821,-79.670,44.938,1],
86080=>[98.840,-79.681,44.933,1],
86081=>[98.860,-79.692,44.927,1],
86082=>[98.879,-79.704,44.921,1],
86083=>[98.898,-79.715,44.913,1],
86084=>[98.917,-79.726,44.905,1],
86085=>[98.936,-79.739,44.897,1],
86086=>[98.955,-79.750,44.888,1],
86087=>[98.975,-79.761,44.878,1],
86088=>[99.013,-79.764,44.868,1],
86089=>[99.055,-79.764,44.860,1],
86090=>[99.094,-79.766,44.851,1],
86091=>[99.119,-79.780,44.840,1],
86092=>[99.143,-79.794,44.828,1],
86093=>[99.164,-79.808,44.815,1],
86094=>[99.168,-79.822,44.803,1],
86095=>[99.180,-79.833,44.792,1],
86096=>[99.204,-79.839,44.781,1],
86097=>[99.227,-79.845,44.773,1],
86098=>[99.251,-79.852,44.764,1],
86099=>[99.275,-79.858,44.755,1],
86100=>[99.298,-79.864,44.748,1],
86101=>[99.322,-79.871,44.740,1],
86102=>[99.346,-79.877,44.732,1],
86103=>[99.369,-79.883,44.723,1],
86104=>[99.394,-79.889,44.713,1],
86105=>[99.417,-79.896,44.706,1],
86106=>[99.441,-79.902,44.697,1],
86107=>[99.465,-79.908,44.688,1],
86108=>[99.488,-79.914,44.681,1],
86109=>[99.512,-79.921,44.673,1],
86110=>[99.531,-79.921,44.663,1],
86111=>[99.546,-79.914,44.655,1],
86112=>[99.561,-79.908,44.647,1],
86113=>[99.570,-79.916,44.638,1],
86114=>[99.568,-79.944,44.628,1],
86115=>[99.567,-79.972,44.620,1],
86116=>[99.566,-80.000,44.612,1],
86117=>[99.565,-80.028,44.603,1],
86118=>[99.564,-80.056,44.595,1],
86119=>[99.562,-80.084,44.587,1],
86120=>[99.561,-80.112,44.580,1],
86121=>[99.560,-80.140,44.574,1],
86122=>[99.559,-80.168,44.566,1],
86123=>[99.557,-80.196,44.559,1],
86124=>[99.556,-80.224,44.552,1],
86125=>[99.555,-80.252,44.544,1],
86126=>[99.554,-80.280,44.537,1],
86127=>[99.552,-80.308,44.529,1],
86128=>[99.567,-80.337,44.521,1],
86129=>[99.619,-80.349,44.511,1],
86130=>[99.669,-80.362,44.501,1],
86131=>[99.721,-80.375,44.491,1],
86132=>[99.772,-80.387,44.481,1],
86133=>[99.824,-80.400,44.470,1],
86134=>[99.875,-80.413,44.458,1],
86135=>[99.926,-80.425,44.446,1],
86136=>[99.978,-80.438,44.434,1],
86137=>[100.025,-80.453,44.422,1],
86138=>[100.069,-80.469,44.409,1],
86139=>[100.114,-80.486,44.396,1],
86140=>[100.158,-80.502,44.384,1],
86141=>[100.203,-80.519,44.371,1],
86142=>[100.248,-80.535,44.358,1],
86436=>[93.567,-78.735,53.624,1],
86437=>[93.577,-78.733,53.615,1],
86438=>[93.586,-78.730,53.606,1],
86439=>[93.596,-78.728,53.597,1],
86440=>[93.606,-78.725,53.590,1],
86441=>[93.616,-78.723,53.582,1],
86442=>[93.624,-78.720,53.575,1],
86443=>[93.623,-78.711,53.569,1],
86444=>[93.621,-78.701,53.565,1],
86445=>[93.620,-78.692,53.561,1],
86446=>[93.619,-78.683,53.560,1],
86447=>[93.617,-78.688,53.564,1],
86448=>[93.625,-78.681,53.562,1],
86449=>[93.642,-78.670,53.557,1],
86450=>[93.659,-78.660,53.550,1],
86451=>[93.677,-78.649,53.541,1],
86452=>[93.695,-78.639,53.532,1],
86453=>[93.712,-78.628,53.520,1],
86454=>[93.729,-78.617,53.505,1],
86455=>[93.747,-78.607,53.488,1],
86456=>[93.765,-78.596,53.469,1],
86457=>[93.770,-78.582,53.449,1],
86458=>[93.772,-78.568,53.427,1],
86459=>[93.775,-78.554,53.406,1],
86460=>[93.778,-78.540,53.384,1],
86461=>[93.780,-78.526,53.363,1],
86462=>[93.783,-78.512,53.341,1],
86463=>[93.786,-78.498,53.318,1],
86464=>[93.788,-78.483,53.295,1],
86465=>[93.791,-78.469,53.270,1],
86466=>[93.794,-78.455,53.245,1],
86467=>[93.803,-78.453,53.221,1],
86468=>[93.830,-78.485,53.198,1],
86469=>[93.848,-78.486,53.175,1],
86470=>[93.870,-78.472,53.154,1],
86471=>[93.914,-78.454,53.132,1],
86472=>[93.958,-78.437,53.115,1],
86473=>[94.002,-78.420,53.098,1],
86474=>[94.010,-78.426,53.081,1],
86475=>[94.011,-78.436,53.065,1],
86476=>[94.012,-78.447,53.050,1],
86477=>[94.008,-78.459,53.032,1],
86478=>[94.018,-78.463,53.010,1],
86479=>[94.034,-78.460,52.986,1],
86480=>[94.049,-78.457,52.963,1],
86481=>[94.065,-78.454,52.940,1],
86482=>[94.080,-78.451,52.918,1],
86483=>[94.096,-78.448,52.896,1],
86484=>[94.112,-78.445,52.873,1],
86485=>[94.127,-78.443,52.849,1],
86486=>[94.142,-78.440,52.829,1],
86487=>[94.157,-78.438,52.811,1],
86488=>[94.172,-78.437,52.795,1],
86489=>[94.186,-78.435,52.778,1],
86490=>[94.202,-78.416,52.760,1],
86491=>[94.207,-78.404,52.741,1],
86492=>[94.209,-78.398,52.721,1],
86493=>[94.212,-78.391,52.703,1],
86494=>[94.215,-78.385,52.685,1],
86495=>[94.217,-78.408,52.668,1],
86496=>[94.218,-78.470,52.649,1],
86497=>[94.219,-78.532,52.633,1],
86498=>[94.231,-78.557,52.617,1],
86499=>[94.247,-78.562,52.599,1],
86500=>[94.263,-78.568,52.582,1],
86501=>[94.280,-78.573,52.564,1],
86502=>[94.296,-78.579,52.546,1],
86503=>[94.312,-78.586,52.529,1],
86504=>[94.329,-78.591,52.511,1],
86505=>[94.345,-78.597,52.493,1],
86506=>[94.362,-78.600,52.471,1],
86507=>[94.386,-78.593,52.450,1],
86508=>[94.408,-78.587,52.428,1],
86509=>[94.429,-78.578,52.404,1],
86510=>[94.447,-78.564,52.379,1],
86511=>[94.464,-78.548,52.351,1],
86512=>[94.476,-78.545,52.321,1],
86513=>[94.485,-78.545,52.289,1],
86514=>[94.494,-78.546,52.255,1],
86515=>[94.503,-78.546,52.220,1],
86516=>[94.513,-78.546,52.185,1],
86517=>[94.522,-78.546,52.151,1],
86518=>[94.532,-78.547,52.119,1],
86519=>[94.544,-78.549,52.086,1],
86520=>[94.560,-78.553,52.051,1],
86521=>[94.575,-78.557,52.017,1],
86522=>[94.590,-78.561,51.983,1],
86523=>[94.597,-78.564,51.948,1],
86524=>[94.607,-78.562,51.912,1],
86525=>[94.617,-78.561,51.874,1],
86526=>[94.628,-78.560,51.835,1],
86527=>[94.638,-78.558,51.793,1],
86528=>[94.649,-78.558,51.748,1],
86529=>[94.663,-78.562,51.702,1],
86530=>[94.676,-78.566,51.653,1],
86531=>[94.690,-78.569,51.602,1],
86532=>[94.703,-78.573,51.552,1],
86533=>[94.716,-78.576,51.502,1],
86534=>[94.730,-78.580,51.451,1],
86535=>[94.743,-78.583,51.401,1],
86536=>[94.764,-78.587,51.351,1],
86537=>[94.784,-78.590,51.301,1],
86538=>[94.806,-78.594,51.252,1],
86539=>[94.827,-78.597,51.204,1],
86540=>[94.847,-78.601,51.155,1],
86541=>[94.868,-78.604,51.108,1],
86542=>[94.889,-78.608,51.062,1],
86543=>[94.893,-78.611,51.017,1],
86544=>[94.896,-78.616,50.972,1],
86545=>[94.890,-78.622,50.928,1],
86546=>[94.886,-78.634,50.884,1],
86547=>[94.881,-78.646,50.842,1],
86548=>[94.886,-78.648,50.800,1],
86549=>[94.890,-78.650,50.758,1],
86550=>[94.887,-78.650,50.717,1],
86551=>[94.898,-78.636,50.677,1],
86552=>[94.912,-78.617,50.635,1],
86553=>[94.926,-78.600,50.592,1],
86554=>[94.941,-78.582,50.549,1],
86555=>[94.955,-78.564,50.506,1],
86556=>[94.969,-78.546,50.463,1],
86557=>[94.984,-78.528,50.419,1],
86558=>[94.998,-78.510,50.375,1],
86559=>[95.013,-78.492,50.330,1],
86560=>[95.027,-78.475,50.285,1],
86561=>[95.045,-78.470,50.240,1],
86562=>[95.065,-78.475,50.196,1],
86563=>[95.086,-78.480,50.153,1],
86564=>[95.106,-78.485,50.110,1],
86565=>[95.126,-78.490,50.066,1],
86566=>[95.147,-78.495,50.024,1],
86567=>[95.163,-78.500,49.982,1],
86568=>[95.174,-78.504,49.941,1],
86569=>[95.185,-78.507,49.903,1],
86570=>[95.195,-78.511,49.864,1],
86571=>[95.206,-78.515,49.826,1],
86572=>[95.217,-78.518,49.787,1],
86573=>[95.228,-78.522,49.750,1],
86574=>[95.249,-78.532,49.712,1],
86575=>[95.282,-78.549,49.675,1],
86576=>[95.315,-78.566,49.638,1],
86577=>[95.348,-78.582,49.600,1],
86578=>[95.381,-78.600,49.562,1],
86579=>[95.414,-78.617,49.524,1],
86580=>[95.447,-78.633,49.488,1],
86581=>[95.480,-78.650,49.452,1],
86582=>[95.491,-78.667,49.416,1],
86583=>[95.505,-78.688,49.380,1],
86584=>[95.519,-78.709,49.346,1],
86585=>[95.533,-78.730,49.312,1],
86586=>[95.532,-78.734,49.280,1],
86587=>[95.527,-78.733,49.247,1],
86588=>[95.522,-78.733,49.213,1],
86589=>[95.516,-78.733,49.176,1],
86590=>[95.511,-78.732,49.136,1],
86591=>[95.506,-78.732,49.096,1],
86592=>[95.489,-78.727,49.054,1],
86593=>[95.472,-78.722,49.012,1],
86594=>[95.455,-78.717,48.969,1],
86595=>[95.438,-78.712,48.923,1],
86596=>[95.421,-78.708,48.877,1],
86597=>[95.415,-78.699,48.834,1],
86598=>[95.422,-78.690,48.792,1],
86599=>[95.445,-78.692,48.749,1],
86600=>[95.469,-78.694,48.709,1],
86601=>[95.492,-78.696,48.668,1],
86602=>[95.516,-78.698,48.629,1],
86603=>[95.539,-78.700,48.589,1],
86604=>[95.563,-78.702,48.550,1],
86605=>[95.588,-78.702,48.511,1],
86606=>[95.613,-78.702,48.472,1],
86607=>[95.632,-78.705,48.435,1],
86608=>[95.644,-78.710,48.397,1],
86609=>[95.657,-78.714,48.361,1],
86610=>[95.669,-78.718,48.325,1],
86611=>[95.681,-78.723,48.289,1],
86612=>[95.692,-78.727,48.251,1],
86613=>[95.707,-78.732,48.212,1],
86614=>[95.736,-78.744,48.172,1],
86615=>[95.765,-78.755,48.132,1],
86616=>[95.794,-78.748,48.091,1],
86617=>[95.824,-78.742,48.051,1],
86618=>[95.848,-78.738,48.011,1],
86619=>[95.866,-78.739,47.971,1],
86620=>[95.881,-78.743,47.931,1],
86621=>[95.896,-78.749,47.889,1],
86622=>[95.911,-78.753,47.848,1],
86623=>[95.924,-78.759,47.807,1],
86624=>[95.932,-78.764,47.766,1],
86625=>[95.940,-78.771,47.725,1],
86626=>[95.956,-78.772,47.684,1],
86627=>[95.980,-78.769,47.642,1],
86628=>[96.004,-78.765,47.599,1],
86629=>[96.028,-78.762,47.557,1],
86630=>[96.052,-78.759,47.516,1],
86631=>[96.077,-78.755,47.474,1],
86632=>[96.099,-78.759,47.434,1],
86633=>[96.116,-78.777,47.393,1],
86634=>[96.134,-78.794,47.354,1],
86635=>[96.152,-78.811,47.316,1],
86636=>[96.170,-78.829,47.279,1],
86637=>[96.186,-78.829,47.241,1],
86638=>[96.203,-78.817,47.204,1],
86639=>[96.220,-78.805,47.167,1],
86640=>[96.236,-78.792,47.130,1],
86641=>[96.252,-78.780,47.094,1],
86642=>[96.269,-78.767,47.061,1],
86643=>[96.286,-78.755,47.028,1],
86644=>[96.297,-78.759,46.995,1],
86645=>[96.307,-78.769,46.962,1],
86646=>[96.318,-78.787,46.930,1],
86647=>[96.329,-78.805,46.898,1],
86648=>[96.340,-78.822,46.866,1],
86649=>[96.352,-78.840,46.836,1],
86650=>[96.363,-78.858,46.805,1],
86651=>[96.374,-78.871,46.775,1],
86652=>[96.385,-78.874,46.745,1],
86653=>[96.431,-78.874,46.717,1],
86654=>[96.476,-78.874,46.690,1],
86655=>[96.518,-78.871,46.665,1],
86656=>[96.559,-78.865,46.638,1],
86657=>[96.599,-78.861,46.612,1],
86658=>[96.640,-78.856,46.585,1],
86659=>[96.680,-78.851,46.557,1],
86660=>[96.721,-78.846,46.534,1],
86661=>[96.761,-78.841,46.512,1],
86662=>[96.802,-78.836,46.490,1],
86663=>[96.837,-78.832,46.469,1],
86664=>[96.848,-78.829,46.448,1],
86665=>[96.858,-78.827,46.426,1],
86666=>[96.869,-78.824,46.405,1],
86667=>[96.889,-78.835,46.386,1],
86668=>[96.909,-78.846,46.367,1],
86669=>[96.930,-78.847,46.349,1],
86670=>[96.945,-78.849,46.328,1],
86671=>[96.943,-78.886,46.308,1],
86672=>[96.966,-78.935,46.289,1],
86673=>[96.971,-78.941,46.272,1],
86674=>[96.958,-78.959,46.257,1],
86675=>[96.952,-78.973,46.241,1],
86676=>[96.960,-78.984,46.226,1],
86677=>[96.972,-78.961,46.209,1],
86678=>[96.966,-78.976,46.194,1],
86679=>[96.959,-78.990,46.178,1],
86680=>[96.978,-79.034,46.161,1],
86681=>[96.999,-79.052,46.146,1],
86682=>[97.019,-79.046,46.132,1],
86683=>[97.039,-79.041,46.117,1],
86684=>[97.060,-79.036,46.100,1],
86685=>[97.080,-79.031,46.082,1],
86686=>[97.102,-79.033,46.064,1],
86687=>[97.126,-79.037,46.049,1],
86688=>[97.150,-79.042,46.037,1],
86689=>[97.173,-79.046,46.024,1],
86690=>[97.197,-79.051,46.009,1],
86691=>[97.219,-79.057,45.995,1],
86692=>[97.234,-79.068,45.978,1],
86693=>[97.250,-79.079,45.961,1],
86694=>[97.260,-79.086,45.943,1],
86695=>[97.266,-79.089,45.924,1],
86696=>[97.272,-79.092,45.905,1],
86697=>[97.287,-79.101,45.885,1],
86698=>[97.302,-79.109,45.866,1],
86699=>[97.317,-79.118,45.846,1],
86700=>[97.332,-79.127,45.827,1],
86701=>[97.348,-79.136,45.808,1],
86702=>[97.363,-79.145,45.791,1],
86703=>[97.375,-79.147,45.773,1],
86704=>[97.386,-79.146,45.756,1],
86705=>[97.398,-79.145,45.738,1],
86706=>[97.409,-79.144,45.720,1],
86707=>[97.421,-79.143,45.703,1],
86708=>[97.432,-79.143,45.686,1],
86709=>[97.443,-79.141,45.671,1],
86710=>[97.455,-79.141,45.655,1],
86711=>[97.477,-79.153,45.639,1],
86712=>[97.500,-79.163,45.624,1],
86713=>[97.522,-79.175,45.608,1],
86714=>[97.544,-79.185,45.591,1],
86715=>[97.566,-79.196,45.576,1],
86716=>[97.588,-79.207,45.560,1],
86717=>[97.610,-79.219,45.544,1],
86718=>[97.614,-79.225,45.528,1],
86719=>[97.613,-79.224,45.514,1],
86720=>[97.613,-79.224,45.499,1],
86721=>[97.613,-79.223,45.483,1],
86722=>[97.613,-79.223,45.468,1],
86723=>[97.613,-79.222,45.455,1],
86724=>[97.613,-79.222,45.443,1],
86725=>[97.613,-79.222,45.430,1],
86726=>[97.613,-79.221,45.413,1],
86727=>[97.612,-79.221,45.396,1],
86728=>[97.612,-79.220,45.379,1],
86729=>[97.618,-79.226,45.364,1],
86730=>[97.636,-79.247,45.351,1],
86731=>[97.655,-79.266,45.339,1],
86732=>[97.673,-79.287,45.327,1],
86733=>[97.691,-79.307,45.316,1],
86734=>[97.709,-79.328,45.305,1],
86735=>[97.731,-79.349,45.293,1],
86736=>[97.771,-79.372,45.281,1],
86737=>[97.806,-79.393,45.269,1],
86738=>[97.823,-79.401,45.258,1],
86739=>[97.840,-79.410,45.248,1],
86740=>[97.856,-79.418,45.239,1],
86741=>[97.870,-79.432,45.229,1],
86742=>[97.882,-79.447,45.220,1],
86743=>[97.894,-79.462,45.211,1],
86744=>[97.907,-79.477,45.202,1],
86745=>[97.919,-79.492,45.193,1],
86746=>[97.932,-79.507,45.182,1],
86747=>[97.944,-79.523,45.174,1],
86748=>[97.959,-79.537,45.166,1],
86749=>[97.982,-79.547,45.158,1],
86750=>[98.006,-79.554,45.149,1],
86751=>[98.031,-79.562,45.142,1],
86752=>[98.056,-79.569,45.135,1],
86753=>[98.080,-79.576,45.128,1],
86754=>[98.114,-79.572,45.120,1],
86755=>[98.167,-79.544,45.111,1],
86756=>[98.220,-79.516,45.103,1],
86757=>[98.283,-79.508,45.095,1],
86758=>[98.329,-79.528,45.087,1],
86759=>[98.354,-79.551,45.078,1],
86760=>[98.379,-79.574,45.069,1],
86761=>[98.406,-79.595,45.060,1],
86762=>[98.439,-79.604,45.051,1],
86763=>[98.472,-79.613,45.042,1],
86764=>[98.505,-79.621,45.033,1],
86765=>[98.533,-79.630,45.025,1],
86766=>[98.558,-79.639,45.018,1],
86767=>[98.584,-79.648,45.010,1],
86768=>[98.609,-79.657,45.003,1],
86769=>[98.634,-79.667,44.997,1],
86770=>[98.660,-79.676,44.990,1],
86771=>[98.685,-79.686,44.984,1],
86772=>[98.692,-79.705,44.980,1],
86773=>[98.696,-79.716,44.975,1],
86774=>[98.713,-79.708,44.972,1],
86775=>[98.730,-79.698,44.968,1],
86776=>[98.747,-79.690,44.964,1],
86777=>[98.764,-79.681,44.961,1],
86778=>[98.781,-79.673,44.957,1],
86779=>[98.798,-79.665,44.953,1],
86780=>[98.814,-79.665,44.949,1],
86781=>[98.833,-79.676,44.944,1],
86782=>[98.852,-79.689,44.938,1],
86783=>[98.872,-79.700,44.931,1],
86784=>[98.891,-79.711,44.923,1],
86785=>[98.910,-79.723,44.914,1],
86786=>[98.929,-79.734,44.905,1],
86787=>[98.949,-79.745,44.895,1],
86788=>[98.990,-79.747,44.885,1],
86789=>[99.031,-79.748,44.874,1],
86790=>[99.072,-79.748,44.864,1],
86791=>[99.113,-79.750,44.856,1],
86792=>[99.137,-79.764,44.844,1],
86793=>[99.161,-79.777,44.831,1],
86794=>[99.175,-79.792,44.819,1],
86795=>[99.179,-79.806,44.806,1],
86796=>[99.184,-79.820,44.795,1],
86797=>[99.207,-79.826,44.784,1],
86798=>[99.231,-79.832,44.776,1],
86799=>[99.255,-79.839,44.768,1],
86800=>[99.279,-79.845,44.760,1],
86801=>[99.302,-79.851,44.752,1],
86802=>[99.326,-79.857,44.745,1],
86803=>[99.350,-79.864,44.736,1],
86804=>[99.373,-79.870,44.727,1],
86805=>[99.397,-79.876,44.718,1],
86806=>[99.421,-79.882,44.709,1],
86807=>[99.445,-79.889,44.701,1],
86808=>[99.469,-79.895,44.692,1],
86809=>[99.492,-79.901,44.684,1],
86810=>[99.512,-79.902,44.676,1],
86811=>[99.527,-79.897,44.667,1],
86812=>[99.543,-79.891,44.659,1],
86813=>[99.558,-79.885,44.651,1],
86814=>[99.565,-79.896,44.642,1],
86815=>[99.564,-79.924,44.632,1],
86816=>[99.563,-79.952,44.624,1],
86817=>[99.561,-79.980,44.616,1],
86818=>[99.560,-80.008,44.607,1],
86819=>[99.559,-80.036,44.599,1],
86820=>[99.558,-80.064,44.591,1],
86821=>[99.556,-80.092,44.584,1],
86822=>[99.555,-80.120,44.577,1],
86823=>[99.554,-80.148,44.570,1],
86824=>[99.553,-80.175,44.562,1],
86825=>[99.551,-80.203,44.555,1],
86826=>[99.550,-80.231,44.548,1],
86827=>[99.549,-80.259,44.541,1],
86828=>[99.565,-80.284,44.533,1],
86829=>[99.590,-80.314,44.524,1],
86830=>[99.628,-80.355,44.515,1],
86831=>[99.685,-80.349,44.505,1],
86832=>[99.736,-80.362,44.495,1],
86833=>[99.787,-80.375,44.485,1],
86834=>[99.839,-80.388,44.474,1],
86835=>[99.890,-80.400,44.463,1],
86836=>[99.938,-80.415,44.451,1],
86837=>[99.982,-80.431,44.439,1],
86838=>[100.027,-80.447,44.427,1],
86839=>[100.071,-80.464,44.414,1],
86840=>[100.116,-80.480,44.401,1],
86841=>[100.160,-80.497,44.389,1],
86842=>[100.205,-80.513,44.375,1],
86843=>[100.250,-80.529,44.362,1],
87137=>[93.567,-78.724,53.631,1],
87138=>[93.577,-78.722,53.621,1],
87139=>[93.586,-78.719,53.611,1],
87140=>[93.596,-78.717,53.602,1],
87141=>[93.606,-78.714,53.594,1],
87142=>[93.616,-78.712,53.586,1],
87143=>[93.620,-78.706,53.579,1],
87144=>[93.619,-78.697,53.571,1],
87145=>[93.618,-78.688,53.566,1],
87146=>[93.617,-78.679,53.561,1],
87147=>[93.615,-78.670,53.559,1],
87148=>[93.614,-78.661,53.560,1],
87149=>[93.623,-78.658,53.557,1],
87150=>[93.640,-78.648,53.553,1],
87151=>[93.658,-78.637,53.545,1],
87152=>[93.675,-78.626,53.536,1],
87153=>[93.694,-78.616,53.524,1],
87154=>[93.713,-78.606,53.510,1],
87155=>[93.733,-78.595,53.495,1],
87156=>[93.753,-78.585,53.476,1],
87157=>[93.767,-78.579,53.456,1],
87158=>[93.775,-78.570,53.434,1],
87159=>[93.774,-78.553,53.412,1],
87160=>[93.772,-78.535,53.390,1],
87161=>[93.771,-78.519,53.368,1],
87162=>[93.774,-78.504,53.348,1],
87163=>[93.777,-78.491,53.328,1],
87164=>[93.779,-78.476,53.307,1],
87165=>[93.782,-78.462,53.286,1],
87166=>[93.785,-78.448,53.262,1],
87167=>[93.787,-78.434,53.238,1],
87168=>[93.791,-78.420,53.215,1],
87169=>[93.818,-78.452,53.192,1],
87170=>[93.843,-78.476,53.171,1],
87171=>[93.883,-78.458,53.150,1],
87172=>[93.926,-78.441,53.129,1],
87173=>[93.970,-78.423,53.113,1],
87174=>[94.014,-78.406,53.097,1],
87175=>[94.019,-78.413,53.081,1],
87176=>[94.018,-78.426,53.063,1],
87177=>[94.014,-78.438,53.046,1],
87178=>[94.010,-78.451,53.028,1],
87179=>[94.019,-78.458,53.006,1],
87180=>[94.033,-78.458,52.981,1],
87181=>[94.049,-78.455,52.958,1],
87182=>[94.064,-78.452,52.935,1],
87183=>[94.080,-78.449,52.913,1],
87184=>[94.096,-78.446,52.892,1],
87185=>[94.111,-78.443,52.870,1],
87186=>[94.127,-78.440,52.847,1],
87187=>[94.142,-78.437,52.830,1],
87188=>[94.158,-78.434,52.814,1],
87189=>[94.174,-78.431,52.798,1],
87190=>[94.189,-78.428,52.782,1],
87191=>[94.196,-78.433,52.764,1],
87192=>[94.197,-78.445,52.745,1],
87193=>[94.199,-78.438,52.725,1],
87194=>[94.202,-78.432,52.706,1],
87195=>[94.204,-78.425,52.689,1],
87196=>[94.206,-78.432,52.673,1],
87197=>[94.208,-78.495,52.655,1],
87198=>[94.214,-78.537,52.639,1],
87199=>[94.231,-78.542,52.623,1],
87200=>[94.248,-78.548,52.605,1],
87201=>[94.264,-78.554,52.587,1],
87202=>[94.280,-78.560,52.570,1],
87203=>[94.296,-78.565,52.552,1],
87204=>[94.313,-78.571,52.535,1],
87205=>[94.329,-78.577,52.518,1],
87206=>[94.345,-78.582,52.498,1],
87207=>[94.365,-78.581,52.477,1],
87208=>[94.388,-78.574,52.456,1],
87209=>[94.411,-78.567,52.434,1],
87210=>[94.434,-78.561,52.412,1],
87211=>[94.457,-78.554,52.386,1],
87212=>[94.478,-78.545,52.359,1],
87213=>[94.487,-78.545,52.330,1],
87214=>[94.496,-78.545,52.297,1],
87215=>[94.506,-78.546,52.263,1],
87216=>[94.515,-78.546,52.229,1],
87217=>[94.525,-78.546,52.194,1],
87218=>[94.534,-78.546,52.162,1],
87219=>[94.543,-78.547,52.129,1],
87220=>[94.552,-78.547,52.096,1],
87221=>[94.562,-78.547,52.060,1],
87222=>[94.578,-78.551,52.025,1],
87223=>[94.594,-78.556,51.990,1],
87224=>[94.602,-78.558,51.954,1],
87225=>[94.613,-78.557,51.919,1],
87226=>[94.623,-78.555,51.882,1],
87227=>[94.633,-78.554,51.845,1],
87228=>[94.643,-78.553,51.803,1],
87229=>[94.654,-78.551,51.758,1],
87230=>[94.666,-78.552,51.710,1],
87231=>[94.679,-78.555,51.663,1],
87232=>[94.692,-78.559,51.612,1],
87233=>[94.705,-78.563,51.560,1],
87234=>[94.719,-78.567,51.509,1],
87235=>[94.733,-78.570,51.458,1],
87236=>[94.747,-78.572,51.407,1],
87237=>[94.765,-78.576,51.355,1],
87238=>[94.786,-78.579,51.304,1],
87239=>[94.807,-78.582,51.254,1],
87240=>[94.828,-78.586,51.204,1],
87241=>[94.849,-78.589,51.155,1],
87242=>[94.870,-78.592,51.107,1],
87243=>[94.879,-78.596,51.061,1],
87244=>[94.882,-78.601,51.015,1],
87245=>[94.885,-78.604,50.970,1],
87246=>[94.888,-78.609,50.926,1],
87247=>[94.880,-78.612,50.883,1],
87248=>[94.875,-78.624,50.841,1],
87249=>[94.871,-78.636,50.799,1],
87250=>[94.874,-78.640,50.757,1],
87251=>[94.888,-78.622,50.716,1],
87252=>[94.903,-78.604,50.676,1],
87253=>[94.917,-78.586,50.634,1],
87254=>[94.931,-78.569,50.591,1],
87255=>[94.946,-78.551,50.549,1],
87256=>[94.960,-78.532,50.505,1],
87257=>[94.974,-78.515,50.463,1],
87258=>[94.989,-78.497,50.419,1],
87259=>[95.003,-78.479,50.375,1],
87260=>[95.018,-78.461,50.331,1],
87261=>[95.032,-78.445,50.286,1],
87262=>[95.053,-78.450,50.242,1],
87263=>[95.073,-78.454,50.198,1],
87264=>[95.094,-78.460,50.155,1],
87265=>[95.114,-78.465,50.111,1],
87266=>[95.134,-78.470,50.068,1],
87267=>[95.155,-78.476,50.025,1],
87268=>[95.175,-78.480,49.983,1],
87269=>[95.188,-78.485,49.942,1],
87270=>[95.199,-78.489,49.904,1],
87271=>[95.209,-78.492,49.865,1],
87272=>[95.220,-78.495,49.827,1],
87273=>[95.231,-78.499,49.788,1],
87274=>[95.243,-78.504,49.750,1],
87275=>[95.276,-78.520,49.713,1],
87276=>[95.309,-78.538,49.676,1],
87277=>[95.342,-78.554,49.639,1],
87278=>[95.375,-78.571,49.602,1],
87279=>[95.408,-78.588,49.564,1],
87280=>[95.441,-78.605,49.528,1],
87281=>[95.474,-78.622,49.492,1],
87282=>[95.507,-78.639,49.456,1],
87283=>[95.538,-78.655,49.419,1],
87284=>[95.549,-78.674,49.384,1],
87285=>[95.562,-78.695,49.350,1],
87286=>[95.565,-78.704,49.316,1],
87287=>[95.560,-78.704,49.284,1],
87288=>[95.555,-78.703,49.252,1],
87289=>[95.549,-78.702,49.218,1],
87290=>[95.544,-78.702,49.183,1],
87291=>[95.539,-78.702,49.143,1],
87292=>[95.534,-78.701,49.103,1],
87293=>[95.526,-78.699,49.061,1],
87294=>[95.509,-78.695,49.018,1],
87295=>[95.492,-78.690,48.973,1],
87296=>[95.475,-78.685,48.928,1],
87297=>[95.458,-78.680,48.883,1],
87298=>[95.441,-78.675,48.840,1],
87299=>[95.421,-78.672,48.798,1],
87300=>[95.442,-78.673,48.757,1],
87301=>[95.467,-78.673,48.717,1],
87302=>[95.491,-78.673,48.678,1],
87303=>[95.517,-78.674,48.638,1],
87304=>[95.541,-78.675,48.597,1],
87305=>[95.566,-78.675,48.558,1],
87306=>[95.591,-78.676,48.520,1],
87307=>[95.616,-78.677,48.481,1],
87308=>[95.633,-78.680,48.443,1],
87309=>[95.649,-78.684,48.406,1],
87310=>[95.663,-78.689,48.370,1],
87311=>[95.676,-78.693,48.335,1],
87312=>[95.688,-78.697,48.299,1],
87313=>[95.700,-78.702,48.261,1],
87314=>[95.713,-78.706,48.220,1],
87315=>[95.742,-78.717,48.180,1],
87316=>[95.771,-78.717,48.139,1],
87317=>[95.800,-78.710,48.099,1],
87318=>[95.830,-78.704,48.058,1],
87319=>[95.859,-78.697,48.019,1],
87320=>[95.877,-78.699,47.979,1],
87321=>[95.892,-78.704,47.937,1],
87322=>[95.907,-78.709,47.895,1],
87323=>[95.922,-78.714,47.854,1],
87324=>[95.934,-78.720,47.812,1],
87325=>[95.942,-78.726,47.772,1],
87326=>[95.950,-78.732,47.731,1],
87327=>[95.958,-78.737,47.691,1],
87328=>[95.982,-78.734,47.651,1],
87329=>[96.007,-78.731,47.610,1],
87330=>[96.031,-78.727,47.570,1],
87331=>[96.055,-78.724,47.530,1],
87332=>[96.079,-78.721,47.489,1],
87333=>[96.098,-78.736,47.449,1],
87334=>[96.115,-78.754,47.409,1],
87335=>[96.133,-78.771,47.370,1],
87336=>[96.151,-78.789,47.331,1],
87337=>[96.168,-78.806,47.293,1],
87338=>[96.186,-78.819,47.254,1],
87339=>[96.202,-78.806,47.218,1],
87340=>[96.219,-78.794,47.180,1],
87341=>[96.235,-78.782,47.143,1],
87342=>[96.252,-78.769,47.107,1],
87343=>[96.268,-78.757,47.073,1],
87344=>[96.280,-78.759,47.041,1],
87345=>[96.290,-78.767,47.009,1],
87346=>[96.300,-78.776,46.977,1],
87347=>[96.310,-78.783,46.944,1],
87348=>[96.320,-78.793,46.913,1],
87349=>[96.331,-78.810,46.882,1],
87350=>[96.342,-78.827,46.851,1],
87351=>[96.354,-78.845,46.821,1],
87352=>[96.365,-78.863,46.791,1],
87353=>[96.379,-78.865,46.761,1],
87354=>[96.425,-78.865,46.734,1],
87355=>[96.468,-78.863,46.707,1],
87356=>[96.508,-78.858,46.680,1],
87357=>[96.549,-78.853,46.654,1],
87358=>[96.589,-78.849,46.627,1],
87359=>[96.629,-78.844,46.599,1],
87360=>[96.670,-78.839,46.573,1],
87361=>[96.711,-78.834,46.549,1],
87362=>[96.751,-78.829,46.527,1],
87363=>[96.792,-78.824,46.505,1],
87364=>[96.832,-78.820,46.484,1],
87365=>[96.844,-78.817,46.464,1],
87366=>[96.855,-78.814,46.443,1],
87367=>[96.868,-78.815,46.421,1],
87368=>[96.888,-78.826,46.402,1],
87369=>[96.908,-78.836,46.383,1],
87370=>[96.929,-78.843,46.364,1],
87371=>[96.946,-78.842,46.343,1],
87372=>[96.947,-78.880,46.324,1],
87373=>[96.965,-78.918,46.305,1],
87374=>[96.969,-78.924,46.289,1],
87375=>[96.958,-78.940,46.274,1],
87376=>[96.944,-78.957,46.258,1],
87377=>[96.950,-78.968,46.242,1],
87378=>[96.958,-78.977,46.226,1],
87379=>[96.962,-78.968,46.210,1],
87380=>[96.956,-78.983,46.194,1],
87381=>[96.976,-79.027,46.178,1],
87382=>[96.996,-79.021,46.164,1],
87383=>[97.016,-79.016,46.149,1],
87384=>[97.036,-79.012,46.133,1],
87385=>[97.059,-79.012,46.116,1],
87386=>[97.083,-79.017,46.098,1],
87387=>[97.106,-79.021,46.079,1],
87388=>[97.130,-79.026,46.062,1],
87389=>[97.154,-79.031,46.049,1],
87390=>[97.177,-79.035,46.035,1],
87391=>[97.201,-79.040,46.022,1],
87392=>[97.221,-79.047,46.007,1],
87393=>[97.237,-79.059,45.992,1],
87394=>[97.252,-79.069,45.976,1],
87395=>[97.268,-79.081,45.957,1],
87396=>[97.275,-79.084,45.936,1],
87397=>[97.280,-79.087,45.916,1],
87398=>[97.295,-79.096,45.896,1],
87399=>[97.310,-79.104,45.878,1],
87400=>[97.325,-79.113,45.859,1],
87401=>[97.340,-79.122,45.839,1],
87402=>[97.355,-79.131,45.821,1],
87403=>[97.367,-79.131,45.803,1],
87404=>[97.378,-79.131,45.786,1],
87405=>[97.389,-79.129,45.769,1],
87406=>[97.401,-79.128,45.752,1],
87407=>[97.412,-79.128,45.735,1],
87408=>[97.424,-79.127,45.719,1],
87409=>[97.435,-79.126,45.700,1],
87410=>[97.446,-79.125,45.684,1],
87411=>[97.457,-79.125,45.669,1],
87412=>[97.478,-79.134,45.653,1],
87413=>[97.500,-79.144,45.638,1],
87414=>[97.522,-79.156,45.623,1],
87415=>[97.544,-79.166,45.608,1],
87416=>[97.567,-79.178,45.593,1],
87417=>[97.588,-79.190,45.576,1],
87418=>[97.610,-79.206,45.559,1],
87419=>[97.612,-79.211,45.543,1],
87420=>[97.607,-79.210,45.529,1],
87421=>[97.605,-79.209,45.512,1],
87422=>[97.605,-79.209,45.494,1],
87423=>[97.604,-79.209,45.478,1],
87424=>[97.604,-79.208,45.465,1],
87425=>[97.604,-79.208,45.451,1],
87426=>[97.604,-79.207,45.437,1],
87427=>[97.604,-79.207,45.420,1],
87428=>[97.604,-79.206,45.403,1],
87429=>[97.604,-79.206,45.387,1],
87430=>[97.610,-79.213,45.373,1],
87431=>[97.629,-79.234,45.360,1],
87432=>[97.647,-79.254,45.348,1],
87433=>[97.665,-79.274,45.337,1],
87434=>[97.683,-79.294,45.326,1],
87435=>[97.703,-79.315,45.314,1],
87436=>[97.743,-79.339,45.303,1],
87437=>[97.783,-79.363,45.291,1],
87438=>[97.806,-79.375,45.280,1],
87439=>[97.823,-79.384,45.270,1],
87440=>[97.840,-79.392,45.260,1],
87441=>[97.856,-79.400,45.251,1],
87442=>[97.871,-79.412,45.242,1],
87443=>[97.883,-79.428,45.232,1],
87444=>[97.895,-79.443,45.223,1],
87445=>[97.908,-79.458,45.215,1],
87446=>[97.920,-79.473,45.206,1],
87447=>[97.933,-79.488,45.197,1],
87448=>[97.945,-79.504,45.189,1],
87449=>[97.966,-79.514,45.181,1],
87450=>[97.990,-79.524,45.173,1],
87451=>[98.014,-79.532,45.166,1],
87452=>[98.038,-79.540,45.158,1],
87453=>[98.063,-79.547,45.151,1],
87454=>[98.087,-79.554,45.143,1],
87455=>[98.112,-79.561,45.135,1],
87456=>[98.137,-79.569,45.126,1],
87457=>[98.179,-79.564,45.117,1],
87458=>[98.249,-79.545,45.108,1],
87459=>[98.314,-79.528,45.099,1],
87460=>[98.340,-79.551,45.089,1],
87461=>[98.369,-79.567,45.080,1],
87462=>[98.402,-79.576,45.071,1],
87463=>[98.435,-79.585,45.062,1],
87464=>[98.468,-79.594,45.053,1],
87465=>[98.502,-79.602,45.044,1],
87466=>[98.535,-79.611,45.036,1],
87467=>[98.563,-79.620,45.029,1],
87468=>[98.589,-79.629,45.022,1],
87469=>[98.614,-79.639,45.016,1],
87470=>[98.640,-79.648,45.009,1],
87471=>[98.665,-79.657,45.003,1],
87472=>[98.691,-79.666,44.997,1],
87473=>[98.694,-79.688,44.992,1],
87474=>[98.690,-79.709,44.987,1],
87475=>[98.707,-79.701,44.984,1],
87476=>[98.724,-79.692,44.980,1],
87477=>[98.741,-79.683,44.976,1],
87478=>[98.758,-79.675,44.973,1],
87479=>[98.775,-79.666,44.968,1],
87480=>[98.791,-79.663,44.963,1],
87481=>[98.807,-79.662,44.958,1],
87482=>[98.826,-79.673,44.950,1],
87483=>[98.845,-79.684,44.943,1],
87484=>[98.864,-79.695,44.935,1],
87485=>[98.884,-79.708,44.928,1],
87486=>[98.903,-79.719,44.919,1],
87487=>[98.925,-79.729,44.910,1],
87488=>[98.966,-79.730,44.902,1],
87489=>[99.007,-79.731,44.892,1],
87490=>[99.048,-79.732,44.879,1],
87491=>[99.089,-79.733,44.867,1],
87492=>[99.131,-79.734,44.855,1],
87493=>[99.155,-79.747,44.843,1],
87494=>[99.180,-79.761,44.832,1],
87495=>[99.185,-79.775,44.822,1],
87496=>[99.189,-79.789,44.810,1],
87497=>[99.192,-79.804,44.799,1],
87498=>[99.211,-79.812,44.789,1],
87499=>[99.235,-79.818,44.780,1],
87500=>[99.259,-79.824,44.770,1],
87501=>[99.282,-79.831,44.761,1],
87502=>[99.306,-79.837,44.754,1],
87503=>[99.330,-79.843,44.747,1],
87504=>[99.354,-79.849,44.739,1],
87505=>[99.377,-79.856,44.730,1],
87506=>[99.401,-79.862,44.721,1],
87507=>[99.425,-79.868,44.712,1],
87508=>[99.448,-79.874,44.704,1],
87509=>[99.472,-79.881,44.695,1],
87510=>[99.494,-79.885,44.687,1],
87511=>[99.509,-79.879,44.678,1],
87512=>[99.524,-79.874,44.670,1],
87513=>[99.540,-79.867,44.662,1],
87514=>[99.555,-79.861,44.653,1],
87515=>[99.561,-79.875,44.645,1],
87516=>[99.559,-79.903,44.636,1],
87517=>[99.558,-79.931,44.628,1],
87518=>[99.557,-79.959,44.619,1],
87519=>[99.556,-79.987,44.611,1],
87520=>[99.554,-80.015,44.603,1],
87521=>[99.553,-80.043,44.595,1],
87522=>[99.552,-80.071,44.588,1],
87523=>[99.551,-80.099,44.581,1],
87524=>[99.549,-80.127,44.573,1],
87525=>[99.548,-80.155,44.566,1],
87526=>[99.547,-80.183,44.559,1],
87527=>[99.548,-80.211,44.552,1],
87528=>[99.567,-80.235,44.545,1],
87529=>[99.587,-80.260,44.537,1],
87530=>[99.613,-80.290,44.529,1],
87531=>[99.651,-80.331,44.520,1],
87532=>[99.690,-80.369,44.511,1],
87533=>[99.751,-80.349,44.501,1],
87534=>[99.802,-80.362,44.490,1],
87535=>[99.851,-80.376,44.480,1],
87536=>[99.896,-80.392,44.468,1],
87537=>[99.940,-80.409,44.456,1],
87538=>[99.985,-80.425,44.444,1],
87539=>[100.029,-80.441,44.432,1],
87540=>[100.074,-80.458,44.419,1],
87541=>[100.118,-80.474,44.407,1],
87542=>[100.163,-80.491,44.394,1],
87543=>[100.207,-80.507,44.380,1],
87544=>[100.252,-80.523,44.366,1],
87838=>[93.567,-78.714,53.638,1],
87839=>[93.577,-78.711,53.628,1],
87840=>[93.587,-78.708,53.617,1],
87841=>[93.596,-78.706,53.607,1],
87842=>[93.606,-78.704,53.598,1],
87843=>[93.616,-78.701,53.590,1],
87844=>[93.617,-78.693,53.582,1],
87845=>[93.616,-78.684,53.574,1],
87846=>[93.615,-78.675,53.567,1],
87847=>[93.613,-78.666,53.561,1],
87848=>[93.612,-78.656,53.557,1],
87849=>[93.611,-78.647,53.556,1],
87850=>[93.624,-78.636,53.552,1],
87851=>[93.644,-78.626,53.547,1],
87852=>[93.663,-78.615,53.539,1],
87853=>[93.683,-78.604,53.528,1],
87854=>[93.703,-78.595,53.514,1],
87855=>[93.722,-78.584,53.498,1],
87856=>[93.741,-78.575,53.481,1],
87857=>[93.755,-78.570,53.460,1],
87858=>[93.770,-78.564,53.439,1],
87859=>[93.784,-78.559,53.416,1],
87860=>[93.786,-78.545,53.393,1],
87861=>[93.784,-78.527,53.371,1],
87862=>[93.783,-78.510,53.350,1],
87863=>[93.781,-78.493,53.329,1],
87864=>[93.779,-78.476,53.310,1],
87865=>[93.778,-78.458,53.292,1],
87866=>[93.776,-78.442,53.273,1],
87867=>[93.779,-78.427,53.252,1],
87868=>[93.781,-78.413,53.231,1],
87869=>[93.784,-78.398,53.209,1],
87870=>[93.806,-78.420,53.187,1],
87871=>[93.844,-78.444,53.166,1],
87872=>[93.891,-78.432,53.145,1],
87873=>[93.935,-78.418,53.126,1],
87874=>[93.981,-78.404,53.111,1],
87875=>[94.024,-78.391,53.095,1],
87876=>[94.024,-78.404,53.079,1],
87877=>[94.020,-78.417,53.059,1],
87878=>[94.016,-78.430,53.041,1],
87879=>[94.012,-78.442,53.021,1],
87880=>[94.021,-78.450,52.999,1],
87881=>[94.033,-78.455,52.974,1],
87882=>[94.048,-78.452,52.951,1],
87883=>[94.064,-78.449,52.929,1],
87884=>[94.079,-78.446,52.907,1],
87885=>[94.095,-78.443,52.886,1],
87886=>[94.111,-78.440,52.867,1],
87887=>[94.126,-78.438,52.846,1],
87888=>[94.141,-78.435,52.831,1],
87889=>[94.157,-78.432,52.816,1],
87890=>[94.172,-78.429,52.801,1],
87891=>[94.185,-78.428,52.786,1],
87892=>[94.190,-78.435,52.769,1],
87893=>[94.190,-78.447,52.750,1],
87894=>[94.191,-78.459,52.729,1],
87895=>[94.191,-78.470,52.712,1],
87896=>[94.194,-78.466,52.695,1],
87897=>[94.196,-78.459,52.679,1],
87898=>[94.198,-78.518,52.662,1],
87899=>[94.214,-78.523,52.646,1],
87900=>[94.231,-78.529,52.630,1],
87901=>[94.248,-78.534,52.612,1],
87902=>[94.264,-78.539,52.594,1],
87903=>[94.280,-78.545,52.576,1],
87904=>[94.296,-78.551,52.559,1],
87905=>[94.313,-78.557,52.542,1],
87906=>[94.329,-78.563,52.525,1],
87907=>[94.346,-78.568,52.506,1],
87908=>[94.368,-78.561,52.485,1],
87909=>[94.391,-78.554,52.463,1],
87910=>[94.414,-78.548,52.441,1],
87911=>[94.437,-78.542,52.418,1],
87912=>[94.460,-78.535,52.393,1],
87913=>[94.470,-78.548,52.367,1],
87914=>[94.484,-78.542,52.338,1],
87915=>[94.497,-78.538,52.305,1],
87916=>[94.509,-78.540,52.272,1],
87917=>[94.522,-78.543,52.238,1],
87918=>[94.535,-78.545,52.203,1],
87919=>[94.545,-78.546,52.171,1],
87920=>[94.555,-78.547,52.140,1],
87921=>[94.564,-78.547,52.107,1],
87922=>[94.573,-78.547,52.072,1],
87923=>[94.582,-78.547,52.037,1],
87924=>[94.596,-78.550,52.002,1],
87925=>[94.608,-78.553,51.967,1],
87926=>[94.618,-78.551,51.931,1],
87927=>[94.628,-78.550,51.894,1],
87928=>[94.639,-78.549,51.856,1],
87929=>[94.649,-78.548,51.815,1],
87930=>[94.660,-78.546,51.769,1],
87931=>[94.670,-78.545,51.722,1],
87932=>[94.681,-78.545,51.674,1],
87933=>[94.695,-78.549,51.622,1],
87934=>[94.708,-78.553,51.570,1],
87935=>[94.722,-78.555,51.518,1],
87936=>[94.737,-78.558,51.466,1],
87937=>[94.751,-78.561,51.414,1],
87938=>[94.767,-78.564,51.361,1],
87939=>[94.788,-78.567,51.308,1],
87940=>[94.809,-78.570,51.258,1],
87941=>[94.830,-78.574,51.208,1],
87942=>[94.851,-78.577,51.158,1],
87943=>[94.865,-78.581,51.109,1],
87944=>[94.868,-78.586,51.061,1],
87945=>[94.871,-78.589,51.015,1],
87946=>[94.874,-78.594,50.970,1],
87947=>[94.877,-78.598,50.926,1],
87948=>[94.879,-78.602,50.883,1],
87949=>[94.872,-78.604,50.841,1],
87950=>[94.869,-78.618,50.799,1],
87951=>[94.881,-78.608,50.757,1],
87952=>[94.893,-78.591,50.716,1],
87953=>[94.908,-78.573,50.676,1],
87954=>[94.922,-78.555,50.633,1],
87955=>[94.936,-78.538,50.590,1],
87956=>[94.951,-78.520,50.547,1],
87957=>[94.965,-78.501,50.505,1],
87958=>[94.979,-78.484,50.461,1],
87959=>[94.994,-78.466,50.417,1],
87960=>[95.008,-78.448,50.373,1],
87961=>[95.023,-78.430,50.330,1],
87962=>[95.040,-78.424,50.287,1],
87963=>[95.061,-78.429,50.244,1],
87964=>[95.081,-78.435,50.200,1],
87965=>[95.102,-78.440,50.157,1],
87966=>[95.122,-78.445,50.113,1],
87967=>[95.142,-78.450,50.069,1],
87968=>[95.163,-78.455,50.027,1],
87969=>[95.183,-78.460,49.986,1],
87970=>[95.202,-78.465,49.944,1],
87971=>[95.212,-78.469,49.906,1],
87972=>[95.224,-78.473,49.867,1],
87973=>[95.234,-78.476,49.829,1],
87974=>[95.245,-78.480,49.790,1],
87975=>[95.269,-78.492,49.752,1],
87976=>[95.303,-78.509,49.714,1],
87977=>[95.335,-78.526,49.677,1],
87978=>[95.369,-78.542,49.642,1],
87979=>[95.401,-78.560,49.604,1],
87980=>[95.435,-78.576,49.567,1],
87981=>[95.467,-78.593,49.532,1],
87982=>[95.500,-78.610,49.496,1],
87983=>[95.533,-78.627,49.459,1],
87984=>[95.566,-78.644,49.423,1],
87985=>[95.592,-78.661,49.389,1],
87986=>[95.599,-78.673,49.354,1],
87987=>[95.593,-78.673,49.320,1],
87988=>[95.588,-78.673,49.288,1],
87989=>[95.583,-78.672,49.256,1],
87990=>[95.578,-78.672,49.222,1],
87991=>[95.572,-78.671,49.187,1],
87992=>[95.567,-78.670,49.148,1],
87993=>[95.561,-78.670,49.108,1],
87994=>[95.556,-78.670,49.068,1],
87995=>[95.546,-78.667,49.024,1],
87996=>[95.529,-78.662,48.979,1],
87997=>[95.512,-78.658,48.934,1],
87998=>[95.495,-78.653,48.890,1],
87999=>[95.478,-78.648,48.847,1],
88000=>[95.454,-78.646,48.806,1],
88001=>[95.445,-78.646,48.766,1],
88002=>[95.470,-78.647,48.726,1],
88003=>[95.495,-78.648,48.688,1],
88004=>[95.520,-78.648,48.648,1],
88005=>[95.544,-78.648,48.606,1],
88006=>[95.569,-78.649,48.567,1],
88007=>[95.594,-78.650,48.528,1],
88008=>[95.619,-78.650,48.489,1],
88009=>[95.635,-78.654,48.451,1],
88010=>[95.650,-78.658,48.414,1],
88011=>[95.665,-78.663,48.378,1],
88012=>[95.680,-78.667,48.343,1],
88013=>[95.694,-78.672,48.308,1],
88014=>[95.708,-78.677,48.269,1],
88015=>[95.720,-78.680,48.228,1],
88016=>[95.748,-78.685,48.187,1],
88017=>[95.777,-78.678,48.147,1],
88018=>[95.806,-78.673,48.106,1],
88019=>[95.834,-78.669,48.066,1],
88020=>[95.862,-78.667,48.027,1],
88021=>[95.883,-78.666,47.986,1],
88022=>[95.903,-78.665,47.944,1],
88023=>[95.918,-78.670,47.903,1],
88024=>[95.933,-78.676,47.862,1],
88025=>[95.944,-78.681,47.820,1],
88026=>[95.952,-78.687,47.779,1],
88027=>[95.960,-78.693,47.738,1],
88028=>[95.967,-78.699,47.698,1],
88029=>[95.985,-78.699,47.659,1],
88030=>[96.010,-78.696,47.619,1],
88031=>[96.034,-78.693,47.580,1],
88032=>[96.058,-78.689,47.541,1],
88033=>[96.079,-78.696,47.500,1],
88034=>[96.097,-78.714,47.462,1],
88035=>[96.114,-78.732,47.422,1],
88036=>[96.132,-78.749,47.383,1],
88037=>[96.150,-78.767,47.344,1],
88038=>[96.167,-78.784,47.305,1],
88039=>[96.185,-78.802,47.267,1],
88040=>[96.202,-78.796,47.231,1],
88041=>[96.218,-78.783,47.193,1],
88042=>[96.235,-78.771,47.156,1],
88043=>[96.251,-78.758,47.119,1],
88044=>[96.264,-78.759,47.085,1],
88045=>[96.273,-78.767,47.053,1],
88046=>[96.284,-78.775,47.022,1],
88047=>[96.294,-78.783,46.992,1],
88048=>[96.304,-78.792,46.960,1],
88049=>[96.313,-78.800,46.929,1],
88050=>[96.323,-78.808,46.899,1],
88051=>[96.333,-78.817,46.868,1],
88052=>[96.344,-78.833,46.838,1],
88053=>[96.356,-78.850,46.808,1],
88054=>[96.374,-78.858,46.779,1],
88055=>[96.417,-78.855,46.752,1],
88056=>[96.458,-78.851,46.724,1],
88057=>[96.498,-78.846,46.695,1],
88058=>[96.538,-78.841,46.670,1],
88059=>[96.579,-78.836,46.642,1],
88060=>[96.619,-78.831,46.614,1],
88061=>[96.660,-78.827,46.589,1],
88062=>[96.700,-78.822,46.565,1],
88063=>[96.741,-78.817,46.543,1],
88064=>[96.782,-78.812,46.522,1],
88065=>[96.822,-78.808,46.501,1],
88066=>[96.841,-78.804,46.481,1],
88067=>[96.852,-78.802,46.460,1],
88068=>[96.868,-78.807,46.438,1],
88069=>[96.888,-78.817,46.419,1],
88070=>[96.908,-78.827,46.399,1],
88071=>[96.928,-78.838,46.379,1],
88072=>[96.948,-78.835,46.359,1],
88073=>[96.952,-78.876,46.340,1],
88074=>[96.964,-78.899,46.322,1],
88075=>[96.968,-78.906,46.305,1],
88076=>[96.958,-78.921,46.290,1],
88077=>[96.944,-78.938,46.275,1],
88078=>[96.939,-78.953,46.259,1],
88079=>[96.947,-78.964,46.243,1],
88080=>[96.955,-78.968,46.227,1],
88081=>[96.953,-78.975,46.210,1],
88082=>[96.973,-78.997,46.195,1],
88083=>[96.994,-78.992,46.181,1],
88084=>[97.016,-78.993,46.165,1],
88085=>[97.039,-78.997,46.148,1],
88086=>[97.063,-79.002,46.131,1],
88087=>[97.087,-79.006,46.113,1],
88088=>[97.110,-79.011,46.094,1],
88089=>[97.134,-79.015,46.076,1],
88090=>[97.158,-79.020,46.061,1],
88091=>[97.181,-79.024,46.047,1],
88092=>[97.205,-79.029,46.033,1],
88093=>[97.223,-79.038,46.021,1],
88094=>[97.239,-79.049,46.007,1],
88095=>[97.254,-79.060,45.991,1],
88096=>[97.271,-79.071,45.973,1],
88097=>[97.283,-79.080,45.953,1],
88098=>[97.289,-79.083,45.933,1],
88099=>[97.302,-79.090,45.911,1],
88100=>[97.317,-79.100,45.893,1],
88101=>[97.332,-79.108,45.874,1],
88102=>[97.348,-79.116,45.855,1],
88103=>[97.359,-79.115,45.837,1],
88104=>[97.370,-79.115,45.820,1],
88105=>[97.381,-79.114,45.803,1],
88106=>[97.392,-79.113,45.787,1],
88107=>[97.404,-79.112,45.770,1],
88108=>[97.415,-79.112,45.754,1],
88109=>[97.427,-79.111,45.737,1],
88110=>[97.438,-79.109,45.720,1],
88111=>[97.449,-79.109,45.704,1],
88112=>[97.460,-79.108,45.690,1],
88113=>[97.478,-79.115,45.675,1],
88114=>[97.501,-79.125,45.660,1],
88115=>[97.523,-79.137,45.645,1],
88116=>[97.544,-79.150,45.630,1],
88117=>[97.566,-79.162,45.613,1],
88118=>[97.587,-79.176,45.594,1],
88119=>[97.611,-79.194,45.574,1],
88120=>[97.610,-79.197,45.555,1],
88121=>[97.605,-79.197,45.540,1],
88122=>[97.600,-79.196,45.523,1],
88123=>[97.596,-79.195,45.506,1],
88124=>[97.596,-79.195,45.490,1],
88125=>[97.596,-79.194,45.474,1],
88126=>[97.595,-79.194,45.459,1],
88127=>[97.595,-79.194,45.444,1],
88128=>[97.595,-79.193,45.429,1],
88129=>[97.595,-79.193,45.414,1],
88130=>[97.595,-79.192,45.399,1],
88131=>[97.602,-79.200,45.383,1],
88132=>[97.620,-79.221,45.370,1],
88133=>[97.639,-79.241,45.358,1],
88134=>[97.657,-79.261,45.347,1],
88135=>[97.675,-79.281,45.336,1],
88136=>[97.714,-79.305,45.325,1],
88137=>[97.754,-79.328,45.314,1],
88138=>[97.789,-79.349,45.302,1],
88139=>[97.806,-79.358,45.292,1],
88140=>[97.823,-79.366,45.283,1],
88141=>[97.840,-79.375,45.273,1],
88142=>[97.856,-79.383,45.264,1],
88143=>[97.872,-79.393,45.254,1],
88144=>[97.884,-79.409,45.245,1],
88145=>[97.896,-79.424,45.236,1],
88146=>[97.909,-79.439,45.228,1],
88147=>[97.921,-79.454,45.220,1],
88148=>[97.934,-79.469,45.213,1],
88149=>[97.951,-79.482,45.205,1],
88150=>[97.973,-79.492,45.197,1],
88151=>[97.997,-79.502,45.190,1],
88152=>[98.021,-79.510,45.183,1],
88153=>[98.045,-79.518,45.175,1],
88154=>[98.070,-79.525,45.167,1],
88155=>[98.095,-79.532,45.158,1],
88156=>[98.119,-79.539,45.150,1],
88157=>[98.144,-79.547,45.141,1],
88158=>[98.183,-79.543,45.131,1],
88159=>[98.238,-79.538,45.120,1],
88160=>[98.293,-79.533,45.110,1],
88161=>[98.332,-79.539,45.100,1],
88162=>[98.365,-79.548,45.092,1],
88163=>[98.398,-79.557,45.083,1],
88164=>[98.432,-79.566,45.074,1],
88165=>[98.465,-79.574,45.065,1],
88166=>[98.499,-79.583,45.056,1],
88167=>[98.532,-79.592,45.049,1],
88168=>[98.565,-79.601,45.042,1],
88169=>[98.594,-79.610,45.036,1],
88170=>[98.620,-79.619,45.029,1],
88171=>[98.645,-79.628,45.023,1],
88172=>[98.670,-79.637,45.018,1],
88173=>[98.696,-79.647,45.011,1],
88174=>[98.695,-79.670,45.006,1],
88175=>[98.687,-79.699,45.000,1],
88176=>[98.701,-79.694,44.995,1],
88177=>[98.718,-79.686,44.991,1],
88178=>[98.735,-79.676,44.988,1],
88179=>[98.752,-79.668,44.984,1],
88180=>[98.769,-79.662,44.978,1],
88181=>[98.785,-79.661,44.971,1],
88182=>[98.800,-79.661,44.965,1],
88183=>[98.819,-79.669,44.957,1],
88184=>[98.838,-79.680,44.947,1],
88185=>[98.857,-79.692,44.938,1],
88186=>[98.876,-79.703,44.929,1],
88187=>[98.902,-79.712,44.920,1],
88188=>[98.942,-79.713,44.911,1],
88189=>[98.984,-79.714,44.902,1],
88190=>[99.025,-79.715,44.893,1],
88191=>[99.066,-79.716,44.881,1],
88192=>[99.107,-79.717,44.868,1],
88193=>[99.148,-79.718,44.857,1],
88194=>[99.174,-79.730,44.845,1],
88195=>[99.192,-79.745,44.835,1],
88196=>[99.196,-79.759,44.825,1],
88197=>[99.199,-79.773,44.814,1],
88198=>[99.203,-79.788,44.804,1],
88199=>[99.215,-79.798,44.794,1],
88200=>[99.239,-79.805,44.784,1],
88201=>[99.263,-79.811,44.774,1],
88202=>[99.286,-79.817,44.764,1],
88203=>[99.310,-79.823,44.756,1],
88204=>[99.334,-79.830,44.749,1],
88205=>[99.357,-79.836,44.741,1],
88206=>[99.381,-79.842,44.731,1],
88207=>[99.405,-79.849,44.723,1],
88208=>[99.429,-79.855,44.715,1],
88209=>[99.452,-79.861,44.707,1],
88210=>[99.476,-79.867,44.698,1],
88211=>[99.491,-79.861,44.689,1],
88212=>[99.506,-79.855,44.680,1],
88213=>[99.521,-79.850,44.672,1],
88214=>[99.537,-79.844,44.664,1],
88215=>[99.552,-79.838,44.655,1],
88216=>[99.556,-79.855,44.647,1],
88217=>[99.555,-79.883,44.640,1],
88218=>[99.553,-79.911,44.632,1],
88219=>[99.552,-79.939,44.623,1],
88220=>[99.551,-79.967,44.614,1],
88221=>[99.550,-79.995,44.606,1],
88222=>[99.548,-80.023,44.599,1],
88223=>[99.547,-80.051,44.592,1],
88224=>[99.546,-80.079,44.585,1],
88225=>[99.545,-80.107,44.577,1],
88226=>[99.543,-80.135,44.570,1],
88227=>[99.550,-80.162,44.563,1],
88228=>[99.569,-80.186,44.556,1],
88229=>[99.589,-80.211,44.549,1],
88230=>[99.609,-80.235,44.542,1],
88231=>[99.636,-80.267,44.534,1],
88232=>[99.674,-80.308,44.525,1],
88233=>[99.712,-80.349,44.516,1],
88234=>[99.747,-80.375,44.506,1],
88235=>[99.809,-80.354,44.496,1],
88236=>[99.853,-80.370,44.485,1],
88237=>[99.898,-80.387,44.474,1],
88238=>[99.942,-80.403,44.462,1],
88239=>[99.987,-80.419,44.450,1],
88240=>[100.031,-80.435,44.437,1],
88241=>[100.076,-80.452,44.425,1],
88242=>[100.121,-80.469,44.412,1],
88243=>[100.165,-80.485,44.399,1],
88244=>[100.210,-80.501,44.386,1],
88245=>[100.255,-80.517,44.371,1],
88246=>[100.299,-80.534,44.357,1],
88247=>[100.344,-80.550,44.344,1],
88248=>[100.388,-80.566,44.330,1],
88539=>[93.568,-78.702,53.644,1],
88540=>[93.577,-78.700,53.633,1],
88541=>[93.587,-78.698,53.623,1],
88542=>[93.597,-78.695,53.612,1],
88543=>[93.607,-78.692,53.602,1],
88544=>[93.615,-78.689,53.593,1],
88545=>[93.614,-78.680,53.584,1],
88546=>[93.612,-78.671,53.575,1],
88547=>[93.611,-78.661,53.567,1],
88548=>[93.610,-78.652,53.560,1],
88549=>[93.609,-78.643,53.555,1],
88550=>[93.608,-78.633,53.552,1],
88551=>[93.631,-78.618,53.547,1],
88552=>[93.653,-78.604,53.540,1],
88553=>[93.673,-78.594,53.530,1],
88554=>[93.692,-78.583,53.518,1],
88555=>[93.712,-78.573,53.502,1],
88556=>[93.729,-78.565,53.484,1],
88557=>[93.744,-78.560,53.464,1],
88558=>[93.758,-78.554,53.442,1],
88559=>[93.773,-78.549,53.419,1],
88560=>[93.787,-78.544,53.397,1],
88561=>[93.798,-78.535,53.374,1],
88562=>[93.796,-78.519,53.353,1],
88563=>[93.795,-78.501,53.332,1],
88564=>[93.793,-78.484,53.313,1],
88565=>[93.791,-78.467,53.294,1],
88566=>[93.790,-78.450,53.277,1],
88567=>[93.788,-78.433,53.259,1],
88568=>[93.787,-78.416,53.241,1],
88569=>[93.785,-78.398,53.222,1],
88570=>[93.783,-78.382,53.201,1],
88571=>[93.799,-78.346,53.180,1],
88572=>[93.847,-78.399,53.159,1],
88573=>[93.895,-78.395,53.139,1],
88574=>[93.940,-78.381,53.121,1],
88575=>[93.980,-78.373,53.105,1],
88576=>[94.007,-78.385,53.089,1],
88577=>[94.026,-78.396,53.073,1],
88578=>[94.022,-78.409,53.054,1],
88579=>[94.018,-78.422,53.035,1],
88580=>[94.014,-78.435,53.014,1],
88581=>[94.023,-78.442,52.992,1],
88582=>[94.035,-78.447,52.969,1],
88583=>[94.048,-78.450,52.947,1],
88584=>[94.063,-78.447,52.924,1],
88585=>[94.078,-78.444,52.904,1],
88586=>[94.094,-78.441,52.886,1],
88587=>[94.110,-78.438,52.868,1],
88588=>[94.125,-78.435,52.850,1],
88589=>[94.141,-78.432,52.836,1],
88590=>[94.155,-78.429,52.821,1],
88591=>[94.168,-78.429,52.805,1],
88592=>[94.181,-78.427,52.790,1],
88593=>[94.184,-78.437,52.773,1],
88594=>[94.184,-78.449,52.755,1],
88595=>[94.185,-78.460,52.735,1],
88596=>[94.185,-78.473,52.718,1],
88597=>[94.186,-78.484,52.702,1],
88598=>[94.186,-78.496,52.687,1],
88599=>[94.198,-78.504,52.670,1],
88600=>[94.214,-78.509,52.653,1],
88601=>[94.231,-78.514,52.637,1],
88602=>[94.248,-78.520,52.619,1],
88603=>[94.264,-78.525,52.601,1],
88604=>[94.280,-78.531,52.584,1],
88605=>[94.297,-78.537,52.567,1],
88606=>[94.313,-78.542,52.550,1],
88607=>[94.329,-78.548,52.533,1],
88608=>[94.348,-78.548,52.514,1],
88609=>[94.371,-78.542,52.493,1],
88610=>[94.394,-78.535,52.470,1],
88611=>[94.417,-78.529,52.447,1],
88612=>[94.439,-78.523,52.425,1],
88613=>[94.449,-78.537,52.400,1],
88614=>[94.459,-78.550,52.374,1],
88615=>[94.472,-78.545,52.347,1],
88616=>[94.486,-78.539,52.313,1],
88617=>[94.500,-78.532,52.281,1],
88618=>[94.513,-78.529,52.247,1],
88619=>[94.526,-78.531,52.213,1],
88620=>[94.538,-78.533,52.181,1],
88621=>[94.551,-78.535,52.150,1],
88622=>[94.563,-78.539,52.120,1],
88623=>[94.576,-78.541,52.086,1],
88624=>[94.589,-78.543,52.052,1],
88625=>[94.601,-78.545,52.017,1],
88626=>[94.613,-78.548,51.982,1],
88627=>[94.623,-78.546,51.945,1],
88628=>[94.634,-78.545,51.907,1],
88629=>[94.644,-78.543,51.869,1],
88630=>[94.654,-78.542,51.827,1],
88631=>[94.665,-78.540,51.781,1],
88632=>[94.675,-78.539,51.734,1],
88633=>[94.685,-78.537,51.685,1],
88634=>[94.698,-78.539,51.632,1],
88635=>[94.712,-78.542,51.578,1],
88636=>[94.726,-78.544,51.525,1],
88637=>[94.740,-78.547,51.472,1],
88638=>[94.754,-78.550,51.420,1],
88639=>[94.769,-78.552,51.367,1],
88640=>[94.789,-78.556,51.313,1],
88641=>[94.811,-78.559,51.262,1],
88642=>[94.832,-78.563,51.211,1],
88643=>[94.851,-78.566,51.160,1],
88644=>[94.854,-78.570,51.111,1],
88645=>[94.857,-78.574,51.063,1],
88646=>[94.860,-78.579,51.017,1],
88647=>[94.862,-78.582,50.972,1],
88648=>[94.865,-78.587,50.929,1],
88649=>[94.868,-78.591,50.886,1],
88650=>[94.871,-78.595,50.845,1],
88651=>[94.876,-78.594,50.803,1],
88652=>[94.887,-78.576,50.761,1],
88653=>[94.899,-78.560,50.719,1],
88654=>[94.913,-78.542,50.677,1],
88655=>[94.927,-78.524,50.634,1],
88656=>[94.942,-78.506,50.591,1],
88657=>[94.956,-78.489,50.547,1],
88658=>[94.970,-78.470,50.504,1],
88659=>[94.985,-78.453,50.461,1],
88660=>[94.999,-78.435,50.416,1],
88661=>[95.014,-78.416,50.373,1],
88662=>[95.028,-78.399,50.329,1],
88663=>[95.048,-78.404,50.285,1],
88664=>[95.068,-78.410,50.242,1],
88665=>[95.089,-78.414,50.201,1],
88666=>[95.110,-78.420,50.159,1],
88667=>[95.130,-78.425,50.115,1],
88668=>[95.150,-78.430,50.071,1],
88669=>[95.171,-78.435,50.029,1],
88670=>[95.191,-78.440,49.988,1],
88671=>[95.212,-78.445,49.946,1],
88672=>[95.227,-78.450,49.908,1],
88673=>[95.237,-78.454,49.869,1],
88674=>[95.248,-78.457,49.831,1],
88675=>[95.263,-78.463,49.795,1],
88676=>[95.296,-78.480,49.756,1],
88677=>[95.329,-78.498,49.719,1],
88678=>[95.362,-78.514,49.682,1],
88679=>[95.395,-78.531,49.645,1],
88680=>[95.428,-78.548,49.607,1],
88681=>[95.461,-78.565,49.570,1],
88682=>[95.494,-78.582,49.535,1],
88683=>[95.527,-78.598,49.499,1],
88684=>[95.560,-78.615,49.464,1],
88685=>[95.589,-78.630,49.429,1],
88686=>[95.612,-78.642,49.394,1],
88687=>[95.620,-78.643,49.359,1],
88688=>[95.621,-78.642,49.324,1],
88689=>[95.616,-78.642,49.291,1],
88690=>[95.611,-78.642,49.258,1],
88691=>[95.605,-78.641,49.223,1],
88692=>[95.600,-78.640,49.188,1],
88693=>[95.595,-78.640,49.150,1],
88694=>[95.590,-78.639,49.112,1],
88695=>[95.584,-78.639,49.072,1],
88696=>[95.579,-78.639,49.029,1],
88697=>[95.566,-78.635,48.985,1],
88698=>[95.549,-78.630,48.941,1],
88699=>[95.532,-78.625,48.898,1],
88700=>[95.514,-78.620,48.856,1],
88701=>[95.487,-78.620,48.816,1],
88702=>[95.461,-78.620,48.776,1],
88703=>[95.473,-78.620,48.737,1],
88704=>[95.498,-78.621,48.697,1],
88705=>[95.523,-78.622,48.657,1],
88706=>[95.548,-78.623,48.615,1],
88707=>[95.572,-78.623,48.575,1],
88708=>[95.597,-78.623,48.535,1],
88709=>[95.621,-78.624,48.496,1],
88710=>[95.636,-78.628,48.458,1],
88711=>[95.652,-78.632,48.421,1],
88712=>[95.666,-78.636,48.384,1],
88713=>[95.681,-78.641,48.349,1],
88714=>[95.696,-78.646,48.314,1],
88715=>[95.711,-78.651,48.277,1],
88716=>[95.726,-78.655,48.237,1],
88717=>[95.752,-78.653,48.195,1],
88718=>[95.780,-78.649,48.154,1],
88719=>[95.808,-78.646,48.113,1],
88720=>[95.837,-78.642,48.073,1],
88721=>[95.859,-78.642,48.034,1],
88722=>[95.881,-78.644,47.994,1],
88723=>[95.902,-78.641,47.953,1],
88724=>[95.923,-78.639,47.913,1],
88725=>[95.944,-78.637,47.873,1],
88726=>[95.954,-78.642,47.831,1],
88727=>[95.962,-78.648,47.787,1],
88728=>[95.970,-78.655,47.747,1],
88729=>[95.977,-78.660,47.706,1],
88730=>[95.988,-78.664,47.666,1],
88731=>[96.012,-78.661,47.626,1],
88732=>[96.036,-78.658,47.586,1],
88733=>[96.060,-78.657,47.546,1],
88734=>[96.078,-78.674,47.507,1],
88735=>[96.096,-78.692,47.470,1],
88736=>[96.113,-78.709,47.431,1],
88737=>[96.131,-78.727,47.392,1],
88738=>[96.149,-78.744,47.354,1],
88739=>[96.166,-78.761,47.316,1],
88740=>[96.184,-78.779,47.279,1],
88741=>[96.201,-78.786,47.242,1],
88742=>[96.218,-78.773,47.205,1],
88743=>[96.234,-78.761,47.168,1],
88744=>[96.247,-78.758,47.132,1],
88745=>[96.257,-78.767,47.097,1],
88746=>[96.267,-78.775,47.066,1],
88747=>[96.277,-78.783,47.037,1],
88748=>[96.287,-78.792,47.007,1],
88749=>[96.297,-78.800,46.978,1],
88750=>[96.307,-78.808,46.948,1],
88751=>[96.317,-78.817,46.918,1],
88752=>[96.327,-78.824,46.888,1],
88753=>[96.337,-78.833,46.857,1],
88754=>[96.346,-78.841,46.827,1],
88755=>[96.367,-78.849,46.797,1],
88756=>[96.407,-78.843,46.768,1],
88757=>[96.448,-78.839,46.739,1],
88758=>[96.488,-78.834,46.710,1],
88759=>[96.528,-78.829,46.683,1],
88760=>[96.569,-78.824,46.656,1],
88761=>[96.609,-78.819,46.629,1],
88762=>[96.650,-78.814,46.605,1],
88763=>[96.690,-78.810,46.583,1],
88764=>[96.731,-78.805,46.562,1],
88765=>[96.771,-78.800,46.540,1],
88766=>[96.812,-78.796,46.519,1],
88767=>[96.838,-78.791,46.498,1],
88768=>[96.848,-78.789,46.477,1],
88769=>[96.867,-78.798,46.455,1],
88770=>[96.887,-78.808,46.436,1],
88771=>[96.907,-78.818,46.417,1],
88772=>[96.928,-78.829,46.398,1],
88773=>[96.948,-78.830,46.378,1],
88774=>[96.956,-78.871,46.357,1],
88775=>[96.963,-78.882,46.338,1],
88776=>[96.967,-78.888,46.319,1],
88777=>[96.958,-78.902,46.304,1],
88778=>[96.944,-78.920,46.289,1],
88779=>[96.931,-78.937,46.273,1],
88780=>[96.936,-78.949,46.257,1],
88781=>[96.944,-78.959,46.241,1],
88782=>[96.950,-78.969,46.225,1],
88783=>[96.972,-78.973,46.208,1],
88784=>[96.996,-78.977,46.192,1],
88785=>[97.020,-78.982,46.176,1],
88786=>[97.043,-78.987,46.159,1],
88787=>[97.067,-78.991,46.142,1],
88788=>[97.091,-78.996,46.125,1],
88789=>[97.114,-79.000,46.107,1],
88790=>[97.138,-79.005,46.090,1],
88791=>[97.162,-79.009,46.075,1],
88792=>[97.185,-79.014,46.061,1],
88793=>[97.209,-79.018,46.046,1],
88794=>[97.226,-79.028,46.034,1],
88795=>[97.241,-79.040,46.020,1],
88796=>[97.257,-79.050,46.005,1],
88797=>[97.273,-79.062,45.988,1],
88798=>[97.289,-79.072,45.971,1],
88799=>[97.298,-79.078,45.952,1],
88800=>[97.310,-79.085,45.932,1],
88801=>[97.325,-79.094,45.911,1],
88802=>[97.339,-79.101,45.890,1],
88803=>[97.351,-79.100,45.871,1],
88804=>[97.362,-79.100,45.854,1],
88805=>[97.373,-79.099,45.838,1],
88806=>[97.384,-79.097,45.822,1],
88807=>[97.396,-79.096,45.806,1],
88808=>[97.407,-79.096,45.788,1],
88809=>[97.418,-79.095,45.771,1],
88810=>[97.430,-79.094,45.753,1],
88811=>[97.441,-79.093,45.736,1],
88812=>[97.452,-79.093,45.721,1],
88813=>[97.463,-79.092,45.708,1],
88814=>[97.479,-79.096,45.695,1],
88815=>[97.501,-79.108,45.679,1],
88816=>[97.522,-79.121,45.663,1],
88817=>[97.543,-79.134,45.645,1],
88818=>[97.565,-79.147,45.627,1],
88819=>[97.586,-79.161,45.607,1],
88820=>[97.612,-79.184,45.587,1],
88821=>[97.607,-79.183,45.568,1],
88822=>[97.603,-79.182,45.552,1],
88823=>[97.598,-79.182,45.536,1],
88824=>[97.593,-79.181,45.519,1],
88825=>[97.588,-79.181,45.502,1],
88826=>[97.587,-79.181,45.485,1],
88827=>[97.587,-79.180,45.469,1],
88828=>[97.587,-79.179,45.453,1],
88829=>[97.586,-79.179,45.439,1],
88830=>[97.586,-79.178,45.425,1],
88831=>[97.586,-79.178,45.409,1],
88832=>[97.595,-79.187,45.394,1],
88833=>[97.613,-79.208,45.381,1],
88834=>[97.631,-79.228,45.369,1],
88835=>[97.650,-79.248,45.358,1],
88836=>[97.686,-79.272,45.347,1],
88837=>[97.726,-79.295,45.336,1],
88838=>[97.766,-79.319,45.325,1],
88839=>[97.789,-79.332,45.315,1],
88840=>[97.806,-79.341,45.305,1],
88841=>[97.823,-79.349,45.296,1],
88842=>[97.840,-79.357,45.287,1],
88843=>[97.856,-79.366,45.277,1],
88844=>[97.873,-79.374,45.267,1],
88845=>[97.885,-79.389,45.258,1],
88846=>[97.897,-79.405,45.250,1],
88847=>[97.910,-79.420,45.242,1],
88848=>[97.922,-79.435,45.235,1],
88849=>[97.935,-79.451,45.228,1],
88850=>[97.958,-79.460,45.220,1],
88851=>[97.981,-79.470,45.213,1],
88852=>[98.004,-79.480,45.206,1],
88853=>[98.028,-79.488,45.199,1],
88854=>[98.053,-79.496,45.191,1],
88855=>[98.077,-79.503,45.183,1],
88856=>[98.102,-79.510,45.174,1],
88857=>[98.127,-79.517,45.165,1],
88858=>[98.151,-79.519,45.155,1],
88859=>[98.195,-79.514,45.144,1],
88860=>[98.250,-79.509,45.132,1],
88861=>[98.301,-79.505,45.121,1],
88862=>[98.330,-79.512,45.111,1],
88863=>[98.363,-79.523,45.103,1],
88864=>[98.395,-79.535,45.094,1],
88865=>[98.428,-79.547,45.086,1],
88866=>[98.462,-79.555,45.078,1],
88867=>[98.495,-79.564,45.070,1],
88868=>[98.528,-79.573,45.064,1],
88869=>[98.562,-79.582,45.057,1],
88870=>[98.595,-79.591,45.050,1],
88871=>[98.625,-79.600,45.044,1],
88872=>[98.650,-79.609,45.038,1],
88873=>[98.675,-79.618,45.032,1],
88874=>[98.701,-79.627,45.026,1],
88875=>[98.697,-79.653,45.020,1],
88876=>[98.688,-79.682,45.014,1],
88877=>[98.696,-79.687,45.008,1],
88878=>[98.713,-79.679,45.002,1],
88879=>[98.730,-79.670,44.997,1],
88880=>[98.747,-79.661,44.993,1],
88881=>[98.763,-79.661,44.986,1],
88882=>[98.778,-79.660,44.979,1],
88883=>[98.794,-79.659,44.972,1],
88884=>[98.812,-79.665,44.964,1],
88885=>[98.831,-79.676,44.953,1],
88886=>[98.850,-79.688,44.942,1],
88887=>[98.878,-79.695,44.933,1],
88888=>[98.919,-79.696,44.923,1],
88889=>[98.960,-79.697,44.912,1],
88890=>[99.001,-79.698,44.902,1],
88891=>[99.042,-79.699,44.893,1],
88892=>[99.083,-79.700,44.882,1],
88893=>[99.124,-79.701,44.870,1],
88894=>[99.165,-79.702,44.860,1],
88895=>[99.192,-79.714,44.849,1],
88896=>[99.203,-79.728,44.838,1],
88897=>[99.206,-79.742,44.827,1],
88898=>[99.210,-79.757,44.818,1],
88899=>[99.213,-79.771,44.808,1],
88900=>[99.219,-79.785,44.798,1],
88901=>[99.242,-79.791,44.790,1],
88902=>[99.267,-79.797,44.781,1],
88903=>[99.290,-79.803,44.771,1],
88904=>[99.314,-79.810,44.761,1],
88905=>[99.338,-79.816,44.752,1],
88906=>[99.361,-79.822,44.743,1],
88907=>[99.385,-79.828,44.733,1],
88908=>[99.409,-79.835,44.725,1],
88909=>[99.432,-79.841,44.717,1],
88910=>[99.456,-79.847,44.708,1],
88911=>[99.473,-79.844,44.700,1],
88912=>[99.488,-79.838,44.691,1],
88913=>[99.503,-79.832,44.683,1],
88914=>[99.518,-79.827,44.675,1],
88915=>[99.534,-79.820,44.666,1],
88916=>[99.549,-79.814,44.658,1],
88917=>[99.551,-79.834,44.651,1],
88918=>[99.550,-79.862,44.643,1],
88919=>[99.549,-79.890,44.635,1],
88920=>[99.548,-79.918,44.627,1],
88921=>[99.546,-79.946,44.619,1],
88922=>[99.545,-79.974,44.610,1],
88923=>[99.544,-80.002,44.604,1],
88924=>[99.543,-80.030,44.596,1],
88925=>[99.541,-80.059,44.589,1],
88926=>[99.540,-80.087,44.582,1],
88927=>[99.552,-80.112,44.574,1],
88928=>[99.571,-80.137,44.567,1],
88929=>[99.591,-80.162,44.561,1],
88930=>[99.611,-80.186,44.554,1],
88931=>[99.630,-80.210,44.547,1],
88932=>[99.659,-80.243,44.539,1],
88933=>[99.697,-80.284,44.531,1],
88934=>[99.735,-80.325,44.521,1],
88935=>[99.765,-80.362,44.511,1],
88936=>[99.815,-80.346,44.502,1],
88937=>[99.859,-80.359,44.490,1],
88938=>[99.900,-80.381,44.479,1],
88939=>[99.945,-80.397,44.468,1],
88940=>[99.989,-80.413,44.456,1],
88941=>[100.034,-80.430,44.444,1],
88942=>[100.078,-80.446,44.431,1],
88943=>[100.123,-80.463,44.417,1],
88944=>[100.168,-80.478,44.404,1],
88945=>[100.212,-80.495,44.391,1],
88946=>[100.257,-80.512,44.377,1],
88947=>[100.301,-80.528,44.362,1],
88948=>[100.346,-80.544,44.348,1],
88949=>[100.391,-80.560,44.334,1],
88950=>[100.435,-80.577,44.321,1],
88951=>[100.480,-80.593,44.307,1],
89241=>[93.578,-78.689,53.639,1],
89242=>[93.587,-78.686,53.628,1],
89243=>[93.597,-78.684,53.617,1],
89244=>[93.607,-78.682,53.606,1],
89245=>[93.612,-78.677,53.596,1],
89246=>[93.610,-78.667,53.586,1],
89247=>[93.609,-78.658,53.575,1],
89248=>[93.608,-78.648,53.566,1],
89249=>[93.606,-78.639,53.558,1],
89250=>[93.605,-78.630,53.550,1],
89251=>[93.614,-78.618,53.545,1],
89252=>[93.636,-78.603,53.538,1],
89253=>[93.658,-78.588,53.530,1],
89254=>[93.681,-78.573,53.519,1],
89255=>[93.701,-78.561,53.504,1],
89256=>[93.717,-78.555,53.487,1],
89257=>[93.731,-78.550,53.467,1],
89258=>[93.747,-78.545,53.446,1],
89259=>[93.761,-78.539,53.425,1],
89260=>[93.776,-78.534,53.404,1],
89261=>[93.790,-78.529,53.382,1],
89262=>[93.805,-78.523,53.360,1],
89263=>[93.808,-78.510,53.340,1],
89264=>[93.807,-78.493,53.319,1],
89265=>[93.805,-78.476,53.300,1],
89266=>[93.803,-78.459,53.282,1],
89267=>[93.802,-78.442,53.264,1],
89268=>[93.800,-78.424,53.246,1],
89269=>[93.799,-78.407,53.229,1],
89270=>[93.797,-78.390,53.210,1],
89271=>[93.795,-78.373,53.191,1],
89272=>[93.815,-78.358,53.171,1],
89273=>[93.849,-78.354,53.151,1],
89274=>[93.900,-78.358,53.132,1],
89275=>[93.936,-78.355,53.115,1],
89276=>[93.964,-78.366,53.098,1],
89277=>[93.991,-78.377,53.082,1],
89278=>[94.018,-78.388,53.066,1],
89279=>[94.024,-78.401,53.048,1],
89280=>[94.020,-78.413,53.029,1],
89281=>[94.016,-78.426,53.009,1],
89282=>[94.025,-78.433,52.987,1],
89283=>[94.036,-78.438,52.966,1],
89284=>[94.048,-78.444,52.943,1],
89285=>[94.062,-78.444,52.921,1],
89286=>[94.078,-78.441,52.903,1],
89287=>[94.094,-78.438,52.887,1],
89288=>[94.109,-78.435,52.871,1],
89289=>[94.125,-78.432,52.855,1],
89290=>[94.138,-78.430,52.840,1],
89291=>[94.151,-78.429,52.826,1],
89292=>[94.165,-78.428,52.811,1],
89293=>[94.177,-78.428,52.795,1],
89294=>[94.178,-78.439,52.779,1],
89295=>[94.178,-78.451,52.762,1],
89296=>[94.179,-78.463,52.743,1],
89297=>[94.179,-78.475,52.727,1],
89298=>[94.180,-78.486,52.711,1],
89299=>[94.183,-78.492,52.696,1],
89300=>[94.197,-78.492,52.679,1],
89301=>[94.215,-78.495,52.663,1],
89302=>[94.231,-78.501,52.647,1],
89303=>[94.248,-78.506,52.629,1],
89304=>[94.264,-78.511,52.611,1],
89305=>[94.281,-78.517,52.593,1],
89306=>[94.297,-78.523,52.577,1],
89307=>[94.313,-78.529,52.559,1],
89308=>[94.330,-78.534,52.541,1],
89309=>[94.351,-78.529,52.523,1],
89310=>[94.374,-78.523,52.502,1],
89311=>[94.397,-78.517,52.480,1],
89312=>[94.418,-78.512,52.457,1],
89313=>[94.428,-78.526,52.435,1],
89314=>[94.438,-78.539,52.411,1],
89315=>[94.448,-78.552,52.385,1],
89316=>[94.461,-78.548,52.357,1],
89317=>[94.475,-78.542,52.324,1],
89318=>[94.488,-78.535,52.291,1],
89319=>[94.502,-78.529,52.258,1],
89320=>[94.516,-78.523,52.225,1],
89321=>[94.529,-78.519,52.193,1],
89322=>[94.542,-78.521,52.163,1],
89323=>[94.554,-78.523,52.134,1],
89324=>[94.567,-78.526,52.102,1],
89325=>[94.579,-78.529,52.069,1],
89326=>[94.593,-78.531,52.034,1],
89327=>[94.609,-78.532,51.999,1],
89328=>[94.625,-78.534,51.961,1],
89329=>[94.635,-78.532,51.922,1],
89330=>[94.645,-78.531,51.882,1],
89331=>[94.655,-78.529,51.839,1],
89332=>[94.666,-78.528,51.793,1],
89333=>[94.676,-78.526,51.745,1],
89334=>[94.687,-78.525,51.696,1],
89335=>[94.700,-78.526,51.641,1],
89336=>[94.715,-78.529,51.585,1],
89337=>[94.730,-78.532,51.530,1],
89338=>[94.744,-78.535,51.477,1],
89339=>[94.758,-78.539,51.425,1],
89340=>[94.772,-78.541,51.372,1],
89341=>[94.791,-78.545,51.318,1],
89342=>[94.812,-78.548,51.266,1],
89343=>[94.833,-78.551,51.214,1],
89344=>[94.840,-78.555,51.163,1],
89345=>[94.843,-78.559,51.114,1],
89346=>[94.846,-78.564,51.066,1],
89347=>[94.849,-78.567,51.020,1],
89348=>[94.852,-78.572,50.976,1],
89349=>[94.854,-78.576,50.933,1],
89350=>[94.863,-78.578,50.891,1],
89351=>[94.873,-78.578,50.850,1],
89352=>[94.883,-78.562,50.808,1],
89353=>[94.894,-78.545,50.766,1],
89354=>[94.905,-78.528,50.723,1],
89355=>[94.918,-78.510,50.680,1],
89356=>[94.932,-78.493,50.636,1],
89357=>[94.947,-78.475,50.592,1],
89358=>[94.961,-78.457,50.547,1],
89359=>[94.975,-78.439,50.504,1],
89360=>[94.990,-78.422,50.460,1],
89361=>[95.004,-78.404,50.416,1],
89362=>[95.019,-78.385,50.372,1],
89363=>[95.036,-78.379,50.328,1],
89364=>[95.056,-78.384,50.284,1],
89365=>[95.076,-78.389,50.241,1],
89366=>[95.097,-78.395,50.200,1],
89367=>[95.117,-78.400,50.158,1],
89368=>[95.138,-78.405,50.115,1],
89369=>[95.159,-78.410,50.072,1],
89370=>[95.179,-78.415,50.031,1],
89371=>[95.199,-78.420,49.990,1],
89372=>[95.220,-78.426,49.950,1],
89373=>[95.240,-78.431,49.912,1],
89374=>[95.251,-78.434,49.874,1],
89375=>[95.262,-78.438,49.837,1],
89376=>[95.290,-78.452,49.800,1],
89377=>[95.323,-78.469,49.762,1],
89378=>[95.356,-78.485,49.724,1],
89379=>[95.389,-78.503,49.686,1],
89380=>[95.422,-78.520,49.649,1],
89381=>[95.455,-78.536,49.611,1],
89382=>[95.483,-78.551,49.574,1],
89383=>[95.508,-78.563,49.539,1],
89384=>[95.532,-78.575,49.503,1],
89385=>[95.555,-78.586,49.467,1],
89386=>[95.580,-78.598,49.433,1],
89387=>[95.603,-78.611,49.397,1],
89388=>[95.611,-78.612,49.362,1],
89389=>[95.616,-78.611,49.328,1],
89390=>[95.621,-78.611,49.294,1],
89391=>[95.626,-78.611,49.260,1],
89392=>[95.631,-78.610,49.225,1],
89393=>[95.628,-78.610,49.190,1],
89394=>[95.623,-78.609,49.154,1],
89395=>[95.617,-78.608,49.117,1],
89396=>[95.612,-78.608,49.078,1],
89397=>[95.607,-78.608,49.036,1],
89398=>[95.602,-78.607,48.993,1],
89399=>[95.586,-78.603,48.950,1],
89400=>[95.568,-78.598,48.908,1],
89401=>[95.547,-78.595,48.867,1],
89402=>[95.521,-78.595,48.827,1],
89403=>[95.494,-78.595,48.788,1],
89404=>[95.476,-78.595,48.749,1],
89405=>[95.501,-78.595,48.709,1],
89406=>[95.526,-78.595,48.668,1],
89407=>[95.551,-78.596,48.626,1],
89408=>[95.576,-78.597,48.585,1],
89409=>[95.601,-78.598,48.544,1],
89410=>[95.623,-78.599,48.505,1],
89411=>[95.638,-78.602,48.467,1],
89412=>[95.653,-78.606,48.429,1],
89413=>[95.668,-78.611,48.392,1],
89414=>[95.683,-78.615,48.355,1],
89415=>[95.697,-78.620,48.319,1],
89416=>[95.712,-78.624,48.281,1],
89417=>[95.730,-78.627,48.241,1],
89418=>[95.754,-78.626,48.200,1],
89419=>[95.782,-78.623,48.158,1],
89420=>[95.811,-78.619,48.118,1],
89421=>[95.835,-78.618,48.079,1],
89422=>[95.856,-78.619,48.040,1],
89423=>[95.878,-78.620,48.000,1],
89424=>[95.900,-78.619,47.959,1],
89425=>[95.921,-78.616,47.918,1],
89426=>[95.941,-78.614,47.878,1],
89427=>[95.957,-78.613,47.838,1],
89428=>[95.972,-78.610,47.797,1],
89429=>[95.980,-78.615,47.757,1],
89430=>[95.987,-78.621,47.717,1],
89431=>[95.995,-78.627,47.677,1],
89432=>[96.015,-78.626,47.636,1],
89433=>[96.039,-78.623,47.596,1],
89434=>[96.059,-78.634,47.556,1],
89435=>[96.077,-78.651,47.516,1],
89436=>[96.094,-78.669,47.478,1],
89437=>[96.112,-78.686,47.439,1],
89438=>[96.130,-78.704,47.400,1],
89439=>[96.148,-78.722,47.362,1],
89440=>[96.165,-78.739,47.324,1],
89441=>[96.183,-78.757,47.286,1],
89442=>[96.200,-78.774,47.250,1],
89443=>[96.217,-78.762,47.214,1],
89444=>[96.231,-78.758,47.178,1],
89445=>[96.241,-78.767,47.143,1],
89446=>[96.251,-78.775,47.109,1],
89447=>[96.261,-78.783,47.078,1],
89448=>[96.270,-78.792,47.048,1],
89449=>[96.281,-78.800,47.019,1],
89450=>[96.291,-78.808,46.988,1],
89451=>[96.303,-78.812,46.958,1],
89452=>[96.315,-78.816,46.929,1],
89453=>[96.328,-78.819,46.899,1],
89454=>[96.341,-78.823,46.869,1],
89455=>[96.354,-78.826,46.839,1],
89456=>[96.352,-78.815,46.810,1],
89457=>[96.393,-78.817,46.781,1],
89458=>[96.436,-78.818,46.752,1],
89459=>[96.477,-78.820,46.725,1],
89460=>[96.518,-78.817,46.698,1],
89461=>[96.559,-78.812,46.672,1],
89462=>[96.599,-78.807,46.648,1],
89463=>[96.640,-78.802,46.625,1],
89464=>[96.680,-78.798,46.603,1],
89465=>[96.721,-78.793,46.581,1],
89466=>[96.761,-78.788,46.561,1],
89467=>[96.802,-78.783,46.539,1],
89468=>[96.835,-78.779,46.518,1],
89469=>[96.847,-78.778,46.496,1],
89470=>[96.867,-78.789,46.475,1],
89471=>[96.887,-78.799,46.455,1],
89472=>[96.907,-78.810,46.435,1],
89473=>[96.927,-78.820,46.415,1],
89474=>[96.947,-78.824,46.395,1],
89475=>[96.957,-78.858,46.374,1],
89476=>[96.962,-78.864,46.354,1],
89477=>[96.966,-78.871,46.337,1],
89478=>[96.958,-78.884,46.321,1],
89479=>[96.945,-78.901,46.305,1],
89480=>[96.931,-78.918,46.288,1],
89481=>[96.925,-78.933,46.273,1],
89482=>[96.933,-78.944,46.257,1],
89483=>[96.949,-78.955,46.240,1],
89484=>[96.974,-78.961,46.221,1],
89485=>[97.000,-78.966,46.204,1],
89486=>[97.024,-78.971,46.186,1],
89487=>[97.047,-78.975,46.169,1],
89488=>[97.071,-78.980,46.153,1],
89489=>[97.095,-78.984,46.136,1],
89490=>[97.118,-78.989,46.119,1],
89491=>[97.142,-78.993,46.102,1],
89492=>[97.166,-78.998,46.088,1],
89493=>[97.189,-79.002,46.074,1],
89494=>[97.212,-79.008,46.060,1],
89495=>[97.228,-79.019,46.048,1],
89496=>[97.243,-79.030,46.034,1],
89497=>[97.259,-79.041,46.019,1],
89498=>[97.275,-79.052,46.003,1],
89499=>[97.291,-79.063,45.988,1],
89500=>[97.306,-79.074,45.971,1],
89501=>[97.317,-79.080,45.952,1],
89502=>[97.331,-79.085,45.929,1],
89503=>[97.342,-79.084,45.907,1],
89504=>[97.354,-79.084,45.886,1],
89505=>[97.365,-79.083,45.869,1],
89506=>[97.376,-79.082,45.854,1],
89507=>[97.387,-79.081,45.839,1],
89508=>[97.399,-79.081,45.823,1],
89509=>[97.410,-79.080,45.805,1],
89510=>[97.422,-79.079,45.787,1],
89511=>[97.436,-79.078,45.768,1],
89512=>[97.449,-79.078,45.750,1],
89513=>[97.462,-79.078,45.736,1],
89514=>[97.471,-79.075,45.724,1],
89515=>[97.479,-79.079,45.712,1],
89516=>[97.500,-79.093,45.696,1],
89517=>[97.521,-79.106,45.677,1],
89518=>[97.542,-79.119,45.657,1],
89519=>[97.564,-79.132,45.638,1],
89520=>[97.585,-79.146,45.618,1],
89521=>[97.610,-79.169,45.599,1],
89522=>[97.605,-79.169,45.581,1],
89523=>[97.600,-79.169,45.565,1],
89524=>[97.596,-79.168,45.549,1],
89525=>[97.591,-79.168,45.532,1],
89526=>[97.586,-79.167,45.514,1],
89527=>[97.581,-79.166,45.497,1],
89528=>[97.578,-79.165,45.480,1],
89529=>[97.578,-79.165,45.464,1],
89530=>[97.578,-79.165,45.449,1],
89531=>[97.578,-79.165,45.434,1],
89532=>[97.578,-79.164,45.419,1],
89533=>[97.587,-79.175,45.405,1],
89534=>[97.605,-79.195,45.392,1],
89535=>[97.624,-79.216,45.380,1],
89536=>[97.658,-79.238,45.369,1],
89537=>[97.698,-79.262,45.359,1],
89538=>[97.738,-79.285,45.348,1],
89539=>[97.773,-79.306,45.337,1],
89540=>[97.789,-79.314,45.327,1],
89541=>[97.806,-79.322,45.317,1],
89542=>[97.823,-79.332,45.308,1],
89543=>[97.840,-79.340,45.299,1],
89544=>[97.856,-79.348,45.289,1],
89545=>[97.873,-79.357,45.279,1],
89546=>[97.886,-79.370,45.271,1],
89547=>[97.898,-79.385,45.264,1],
89548=>[97.911,-79.401,45.256,1],
89549=>[97.923,-79.416,45.249,1],
89550=>[97.942,-79.429,45.242,1],
89551=>[97.965,-79.438,45.234,1],
89552=>[97.988,-79.448,45.227,1],
89553=>[98.011,-79.458,45.219,1],
89554=>[98.035,-79.466,45.210,1],
89555=>[98.060,-79.473,45.202,1],
89556=>[98.084,-79.481,45.193,1],
89557=>[98.109,-79.488,45.184,1],
89558=>[98.134,-79.494,45.174,1],
89559=>[98.158,-79.490,45.164,1],
89560=>[98.207,-79.485,45.154,1],
89561=>[98.262,-79.480,45.144,1],
89562=>[98.301,-79.479,45.133,1],
89563=>[98.328,-79.484,45.123,1],
89564=>[98.361,-79.496,45.116,1],
89565=>[98.394,-79.507,45.107,1],
89566=>[98.427,-79.520,45.099,1],
89567=>[98.459,-79.531,45.092,1],
89568=>[98.492,-79.543,45.085,1],
89569=>[98.525,-79.554,45.078,1],
89570=>[98.558,-79.563,45.072,1],
89571=>[98.591,-79.572,45.066,1],
89572=>[98.625,-79.581,45.060,1],
89573=>[98.655,-79.589,45.053,1],
89574=>[98.680,-79.598,45.047,1],
89575=>[98.706,-79.607,45.041,1],
89576=>[98.699,-79.636,45.035,1],
89577=>[98.690,-79.665,45.029,1],
89578=>[98.690,-79.681,45.022,1],
89579=>[98.707,-79.672,45.014,1],
89580=>[98.724,-79.664,45.007,1],
89581=>[98.740,-79.660,45.000,1],
89582=>[98.756,-79.659,44.994,1],
89583=>[98.772,-79.658,44.987,1],
89584=>[98.788,-79.657,44.980,1],
89585=>[98.804,-79.661,44.971,1],
89586=>[98.823,-79.672,44.960,1],
89587=>[98.854,-79.678,44.950,1],
89588=>[98.895,-79.679,44.940,1],
89589=>[98.936,-79.680,44.928,1],
89590=>[98.978,-79.681,44.917,1],
89591=>[99.018,-79.683,44.906,1],
89592=>[99.060,-79.683,44.896,1],
89593=>[99.101,-79.684,44.884,1],
89594=>[99.142,-79.685,44.873,1],
89595=>[99.183,-79.686,44.863,1],
89596=>[99.209,-79.698,44.853,1],
89597=>[99.213,-79.712,44.842,1],
89598=>[99.216,-79.726,44.832,1],
89599=>[99.220,-79.740,44.823,1],
89600=>[99.223,-79.755,44.814,1],
89601=>[99.227,-79.769,44.805,1],
89602=>[99.246,-79.777,44.796,1],
89603=>[99.270,-79.783,44.786,1],
89604=>[99.294,-79.789,44.776,1],
89605=>[99.317,-79.796,44.766,1],
89606=>[99.342,-79.802,44.756,1],
89607=>[99.365,-79.808,44.746,1],
89608=>[99.389,-79.814,44.737,1],
89609=>[99.413,-79.821,44.728,1],
89610=>[99.436,-79.827,44.720,1],
89611=>[99.454,-79.826,44.711,1],
89612=>[99.470,-79.820,44.702,1],
89613=>[99.485,-79.814,44.694,1],
89614=>[99.500,-79.808,44.685,1],
89615=>[99.515,-79.803,44.677,1],
89616=>[99.530,-79.797,44.669,1],
89617=>[99.545,-79.791,44.662,1],
89618=>[99.547,-79.814,44.655,1],
89619=>[99.545,-79.842,44.647,1],
89620=>[99.544,-79.870,44.639,1],
89621=>[99.543,-79.898,44.632,1],
89622=>[99.542,-79.926,44.624,1],
89623=>[99.540,-79.954,44.615,1],
89624=>[99.539,-79.982,44.608,1],
89625=>[99.538,-80.010,44.601,1],
89626=>[99.537,-80.038,44.593,1],
89627=>[99.554,-80.063,44.587,1],
89628=>[99.573,-80.087,44.579,1],
89629=>[99.593,-80.112,44.572,1],
89630=>[99.613,-80.137,44.566,1],
89631=>[99.632,-80.161,44.558,1],
89632=>[99.652,-80.186,44.551,1],
89633=>[99.682,-80.220,44.543,1],
89634=>[99.720,-80.261,44.534,1],
89635=>[99.758,-80.302,44.525,1],
89636=>[99.783,-80.336,44.516,1],
89637=>[99.807,-80.356,44.506,1],
89638=>[99.868,-80.350,44.495,1],
89639=>[99.913,-80.361,44.484,1],
89640=>[99.947,-80.391,44.473,1],
89641=>[99.992,-80.407,44.461,1],
89642=>[100.036,-80.424,44.448,1],
89643=>[100.081,-80.441,44.436,1],
89644=>[100.125,-80.457,44.423,1],
89645=>[100.170,-80.473,44.410,1],
89646=>[100.214,-80.489,44.396,1],
89647=>[100.259,-80.506,44.382,1],
89648=>[100.303,-80.522,44.367,1],
89649=>[100.348,-80.538,44.353,1],
89650=>[100.393,-80.555,44.339,1],
89651=>[100.437,-80.571,44.325,1],
89652=>[100.482,-80.588,44.311,1],
89653=>[100.527,-80.604,44.296,1],
89654=>[100.571,-80.620,44.282,1],
89655=>[100.616,-80.636,44.267,1],
89942=>[93.578,-78.678,53.644,1],
89943=>[93.588,-78.676,53.632,1],
89944=>[93.597,-78.673,53.620,1],
89945=>[93.607,-78.670,53.609,1],
89946=>[93.608,-78.663,53.598,1],
89947=>[93.607,-78.654,53.587,1],
89948=>[93.606,-78.645,53.575,1],
89949=>[93.604,-78.636,53.565,1],
89950=>[93.603,-78.626,53.555,1],
89951=>[93.602,-78.617,53.546,1],
89952=>[93.619,-78.602,53.538,1],
89953=>[93.641,-78.587,53.528,1],
89954=>[93.664,-78.572,53.518,1],
89955=>[93.687,-78.557,53.505,1],
89956=>[93.705,-78.545,53.490,1],
89957=>[93.720,-78.539,53.471,1],
89958=>[93.734,-78.535,53.451,1],
89959=>[93.749,-78.529,53.431,1],
89960=>[93.764,-78.524,53.412,1],
89961=>[93.778,-78.519,53.392,1],
89962=>[93.793,-78.514,53.371,1],
89963=>[93.807,-78.508,53.350,1],
89964=>[93.821,-78.501,53.330,1],
89965=>[93.819,-78.485,53.310,1],
89966=>[93.817,-78.467,53.291,1],
89967=>[93.816,-78.451,53.272,1],
89968=>[93.814,-78.433,53.254,1],
89969=>[93.813,-78.416,53.235,1],
89970=>[93.811,-78.399,53.218,1],
89971=>[93.809,-78.382,53.201,1],
89972=>[93.807,-78.364,53.182,1],
89973=>[93.830,-78.350,53.163,1],
89974=>[93.859,-78.336,53.144,1],
89975=>[93.893,-78.337,53.125,1],
89976=>[93.920,-78.348,53.108,1],
89977=>[93.947,-78.359,53.092,1],
89978=>[93.975,-78.370,53.076,1],
89979=>[94.002,-78.381,53.060,1],
89980=>[94.026,-78.392,53.043,1],
89981=>[94.022,-78.405,53.025,1],
89982=>[94.018,-78.418,53.005,1],
89983=>[94.026,-78.425,52.985,1],
89984=>[94.038,-78.430,52.963,1],
89985=>[94.050,-78.435,52.942,1],
89986=>[94.062,-78.441,52.921,1],
89987=>[94.077,-78.438,52.905,1],
89988=>[94.093,-78.435,52.890,1],
89989=>[94.109,-78.432,52.875,1],
89990=>[94.122,-78.431,52.860,1],
89991=>[94.135,-78.430,52.845,1],
89992=>[94.148,-78.429,52.831,1],
89993=>[94.161,-78.428,52.817,1],
89994=>[94.171,-78.429,52.802,1],
89995=>[94.171,-78.442,52.786,1],
89996=>[94.172,-78.453,52.770,1],
89997=>[94.172,-78.465,52.753,1],
89998=>[94.173,-78.477,52.736,1],
89999=>[94.176,-78.482,52.721,1],
90000=>[94.180,-78.486,52.706,1],
90001=>[94.191,-78.488,52.690,1],
90002=>[94.213,-78.483,52.674,1],
90003=>[94.231,-78.486,52.658,1],
90004=>[94.248,-78.492,52.641,1],
90005=>[94.265,-78.497,52.623,1],
90006=>[94.281,-78.503,52.605,1],
90007=>[94.297,-78.508,52.589,1],
90008=>[94.314,-78.514,52.570,1],
90009=>[94.332,-78.517,52.553,1],
90010=>[94.354,-78.510,52.535,1],
90011=>[94.377,-78.504,52.514,1],
90012=>[94.397,-78.501,52.492,1],
90013=>[94.407,-78.514,52.470,1],
90014=>[94.417,-78.528,52.447,1],
90015=>[94.427,-78.542,52.422,1],
90016=>[94.436,-78.554,52.396,1],
90017=>[94.450,-78.552,52.369,1],
90018=>[94.463,-78.545,52.336,1],
90019=>[94.477,-78.539,52.303,1],
90020=>[94.491,-78.532,52.270,1],
90021=>[94.504,-78.526,52.238,1],
90022=>[94.518,-78.520,52.206,1],
90023=>[94.532,-78.513,52.175,1],
90024=>[94.545,-78.509,52.145,1],
90025=>[94.558,-78.512,52.114,1],
90026=>[94.571,-78.514,52.081,1],
90027=>[94.588,-78.516,52.046,1],
90028=>[94.604,-78.517,52.011,1],
90029=>[94.621,-78.519,51.973,1],
90030=>[94.637,-78.520,51.934,1],
90031=>[94.647,-78.518,51.893,1],
90032=>[94.657,-78.517,51.850,1],
90033=>[94.668,-78.515,51.802,1],
90034=>[94.678,-78.514,51.752,1],
90035=>[94.688,-78.512,51.702,1],
90036=>[94.701,-78.514,51.646,1],
90037=>[94.716,-78.517,51.591,1],
90038=>[94.732,-78.520,51.535,1],
90039=>[94.748,-78.524,51.481,1],
90040=>[94.762,-78.527,51.429,1],
90041=>[94.776,-78.529,51.376,1],
90042=>[94.793,-78.532,51.323,1],
90043=>[94.814,-78.536,51.270,1],
90044=>[94.826,-78.540,51.219,1],
90045=>[94.829,-78.544,51.168,1],
90046=>[94.832,-78.548,51.120,1],
90047=>[94.835,-78.552,51.071,1],
90048=>[94.841,-78.555,51.024,1],
90049=>[94.851,-78.557,50.981,1],
90050=>[94.861,-78.558,50.939,1],
90051=>[94.871,-78.560,50.899,1],
90052=>[94.881,-78.546,50.858,1],
90053=>[94.890,-78.529,50.816,1],
90054=>[94.900,-78.514,50.773,1],
90055=>[94.911,-78.497,50.729,1],
90056=>[94.923,-78.479,50.685,1],
90057=>[94.937,-78.462,50.640,1],
90058=>[94.952,-78.444,50.594,1],
90059=>[94.966,-78.426,50.548,1],
90060=>[94.980,-78.408,50.504,1],
90061=>[94.995,-78.390,50.460,1],
90062=>[95.009,-78.373,50.415,1],
90063=>[95.024,-78.354,50.371,1],
90064=>[95.044,-78.359,50.327,1],
90065=>[95.064,-78.364,50.284,1],
90066=>[95.085,-78.369,50.240,1],
90067=>[95.105,-78.374,50.198,1],
90068=>[95.125,-78.379,50.156,1],
90069=>[95.146,-78.385,50.114,1],
90070=>[95.167,-78.390,50.073,1],
90071=>[95.187,-78.395,50.033,1],
90072=>[95.207,-78.400,49.993,1],
90073=>[95.228,-78.405,49.953,1],
90074=>[95.248,-78.410,49.916,1],
90075=>[95.265,-78.415,49.879,1],
90076=>[95.283,-78.423,49.842,1],
90077=>[95.317,-78.440,49.804,1],
90078=>[95.349,-78.457,49.766,1],
90079=>[95.379,-78.472,49.729,1],
90080=>[95.402,-78.484,49.691,1],
90081=>[95.426,-78.495,49.653,1],
90082=>[95.451,-78.507,49.616,1],
90083=>[95.474,-78.520,49.579,1],
90084=>[95.498,-78.532,49.543,1],
90085=>[95.523,-78.543,49.506,1],
90086=>[95.546,-78.555,49.471,1],
90087=>[95.570,-78.567,49.436,1],
90088=>[95.594,-78.579,49.400,1],
90089=>[95.602,-78.580,49.366,1],
90090=>[95.607,-78.580,49.332,1],
90091=>[95.612,-78.579,49.298,1],
90092=>[95.617,-78.579,49.263,1],
90093=>[95.622,-78.579,49.228,1],
90094=>[95.628,-78.579,49.194,1],
90095=>[95.633,-78.578,49.159,1],
90096=>[95.638,-78.578,49.123,1],
90097=>[95.640,-78.577,49.085,1],
90098=>[95.635,-78.576,49.045,1],
90099=>[95.629,-78.576,49.003,1],
90100=>[95.623,-78.575,48.961,1],
90101=>[95.606,-78.570,48.919,1],
90102=>[95.581,-78.570,48.878,1],
90103=>[95.554,-78.569,48.839,1],
90104=>[95.527,-78.569,48.800,1],
90105=>[95.501,-78.569,48.762,1],
90106=>[95.504,-78.569,48.721,1],
90107=>[95.529,-78.570,48.680,1],
90108=>[95.554,-78.570,48.637,1],
90109=>[95.579,-78.571,48.595,1],
90110=>[95.604,-78.571,48.554,1],
90111=>[95.624,-78.573,48.515,1],
90112=>[95.639,-78.577,48.476,1],
90113=>[95.655,-78.581,48.438,1],
90114=>[95.670,-78.585,48.400,1],
90115=>[95.684,-78.589,48.362,1],
90116=>[95.699,-78.594,48.325,1],
90117=>[95.714,-78.598,48.286,1],
90118=>[95.735,-78.599,48.246,1],
90119=>[95.758,-78.598,48.206,1],
90120=>[95.784,-78.596,48.165,1],
90121=>[95.811,-78.594,48.124,1],
90122=>[95.832,-78.595,48.085,1],
90123=>[95.854,-78.595,48.046,1],
90124=>[95.876,-78.596,48.006,1],
90125=>[95.897,-78.597,47.965,1],
90126=>[95.917,-78.595,47.925,1],
90127=>[95.934,-78.594,47.885,1],
90128=>[95.951,-78.593,47.845,1],
90129=>[95.966,-78.590,47.805,1],
90130=>[95.981,-78.587,47.766,1],
90131=>[95.997,-78.583,47.727,1],
90132=>[96.006,-78.589,47.687,1],
90133=>[96.018,-78.592,47.647,1],
90134=>[96.040,-78.594,47.607,1],
90135=>[96.058,-78.611,47.567,1],
90136=>[96.076,-78.629,47.528,1],
90137=>[96.093,-78.647,47.488,1],
90138=>[96.111,-78.664,47.449,1],
90139=>[96.128,-78.682,47.410,1],
90140=>[96.147,-78.699,47.372,1],
90141=>[96.164,-78.717,47.334,1],
90142=>[96.182,-78.734,47.296,1],
90143=>[96.199,-78.752,47.260,1],
90144=>[96.215,-78.758,47.224,1],
90145=>[96.225,-78.766,47.189,1],
90146=>[96.238,-78.769,47.155,1],
90147=>[96.250,-78.773,47.123,1],
90148=>[96.263,-78.776,47.092,1],
90149=>[96.276,-78.779,47.061,1],
90150=>[96.289,-78.783,47.030,1],
90151=>[96.302,-78.786,47.000,1],
90152=>[96.315,-78.789,46.970,1],
90153=>[96.327,-78.793,46.940,1],
90154=>[96.340,-78.796,46.911,1],
90155=>[96.353,-78.799,46.882,1],
90156=>[96.366,-78.802,46.852,1],
90157=>[96.357,-78.788,46.823,1],
90158=>[96.377,-78.777,46.795,1],
90159=>[96.419,-78.779,46.767,1],
90160=>[96.461,-78.780,46.741,1],
90161=>[96.503,-78.782,46.714,1],
90162=>[96.545,-78.784,46.690,1],
90163=>[96.587,-78.786,46.667,1],
90164=>[96.629,-78.787,46.645,1],
90165=>[96.670,-78.786,46.622,1],
90166=>[96.711,-78.780,46.601,1],
90167=>[96.751,-78.776,46.581,1],
90168=>[96.792,-78.771,46.561,1],
90169=>[96.831,-78.766,46.538,1],
90170=>[96.846,-78.769,46.516,1],
90171=>[96.866,-78.780,46.494,1],
90172=>[96.886,-78.790,46.474,1],
90173=>[96.906,-78.801,46.453,1],
90174=>[96.927,-78.811,46.432,1],
90175=>[96.947,-78.820,46.412,1],
90176=>[96.956,-78.840,46.391,1],
90177=>[96.960,-78.846,46.370,1],
90178=>[96.965,-78.852,46.353,1],
90179=>[96.958,-78.865,46.337,1],
90180=>[96.945,-78.883,46.320,1],
90181=>[96.931,-78.900,46.304,1],
90182=>[96.917,-78.918,46.289,1],
90183=>[96.931,-78.931,46.272,1],
90184=>[96.947,-78.943,46.253,1],
90185=>[96.973,-78.948,46.234,1],
90186=>[96.999,-78.953,46.215,1],
90187=>[97.024,-78.959,46.197,1],
90188=>[97.050,-78.964,46.179,1],
90189=>[97.075,-78.969,46.163,1],
90190=>[97.099,-78.974,46.147,1],
90191=>[97.122,-78.978,46.131,1],
90192=>[97.146,-78.983,46.114,1],
90193=>[97.170,-78.987,46.100,1],
90194=>[97.193,-78.992,46.087,1],
90195=>[97.214,-78.998,46.075,1],
90196=>[97.230,-79.009,46.062,1],
90197=>[97.246,-79.020,46.047,1],
90198=>[97.261,-79.031,46.032,1],
90199=>[97.277,-79.042,46.018,1],
90200=>[97.293,-79.053,46.003,1],
90201=>[97.309,-79.065,45.987,1],
90202=>[97.325,-79.071,45.970,1],
90203=>[97.338,-79.070,45.947,1],
90204=>[97.352,-79.070,45.924,1],
90205=>[97.365,-79.069,45.901,1],
90206=>[97.379,-79.069,45.882,1],
90207=>[97.392,-79.069,45.867,1],
90208=>[97.405,-79.068,45.852,1],
90209=>[97.419,-79.068,45.836,1],
90210=>[97.433,-79.068,45.819,1],
90211=>[97.445,-79.067,45.802,1],
90212=>[97.453,-79.065,45.783,1],
90213=>[97.462,-79.062,45.765,1],
90214=>[97.470,-79.060,45.750,1],
90215=>[97.478,-79.058,45.736,1],
90216=>[97.487,-79.056,45.723,1],
90217=>[97.499,-79.078,45.706,1],
90218=>[97.520,-79.091,45.688,1],
90219=>[97.541,-79.104,45.668,1],
90220=>[97.562,-79.118,45.651,1],
90221=>[97.586,-79.135,45.632,1],
90222=>[97.608,-79.156,45.614,1],
90223=>[97.603,-79.155,45.597,1],
90224=>[97.598,-79.155,45.579,1],
90225=>[97.593,-79.154,45.561,1],
90226=>[97.589,-79.153,45.542,1],
90227=>[97.584,-79.153,45.524,1],
90228=>[97.579,-79.153,45.508,1],
90229=>[97.574,-79.152,45.492,1],
90230=>[97.570,-79.151,45.476,1],
90231=>[97.569,-79.151,45.461,1],
90232=>[97.569,-79.150,45.445,1],
90233=>[97.569,-79.150,45.430,1],
90234=>[97.579,-79.162,45.417,1],
90235=>[97.597,-79.182,45.404,1],
90236=>[97.630,-79.204,45.392,1],
90237=>[97.669,-79.228,45.380,1],
90238=>[97.709,-79.252,45.371,1],
90239=>[97.749,-79.275,45.360,1],
90240=>[97.773,-79.288,45.350,1],
90241=>[97.790,-79.297,45.339,1],
90242=>[97.806,-79.305,45.329,1],
90243=>[97.823,-79.313,45.320,1],
90244=>[97.840,-79.322,45.310,1],
90245=>[97.856,-79.331,45.301,1],
90246=>[97.873,-79.339,45.292,1],
90247=>[97.887,-79.351,45.284,1],
90248=>[97.899,-79.366,45.276,1],
90249=>[97.912,-79.382,45.269,1],
90250=>[97.926,-79.396,45.261,1],
90251=>[97.949,-79.406,45.255,1],
90252=>[97.972,-79.416,45.247,1],
90253=>[97.996,-79.426,45.239,1],
90254=>[98.019,-79.435,45.231,1],
90255=>[98.042,-79.444,45.222,1],
90256=>[98.067,-79.451,45.212,1],
90257=>[98.092,-79.459,45.203,1],
90258=>[98.116,-79.466,45.194,1],
90259=>[98.141,-79.465,45.184,1],
90260=>[98.165,-79.461,45.174,1],
90261=>[98.218,-79.456,45.164,1],
90262=>[98.274,-79.451,45.155,1],
90263=>[98.301,-79.454,45.145,1],
90264=>[98.327,-79.457,45.136,1],
90265=>[98.359,-79.468,45.130,1],
90266=>[98.392,-79.479,45.121,1],
90267=>[98.425,-79.491,45.114,1],
90268=>[98.457,-79.503,45.107,1],
90269=>[98.490,-79.515,45.100,1],
90270=>[98.523,-79.527,45.094,1],
90271=>[98.556,-79.538,45.088,1],
90272=>[98.588,-79.551,45.083,1],
90273=>[98.622,-79.561,45.077,1],
90274=>[98.655,-79.570,45.070,1],
90275=>[98.686,-79.579,45.063,1],
90276=>[98.709,-79.590,45.057,1],
90277=>[98.700,-79.619,45.050,1],
90278=>[98.692,-79.648,45.044,1],
90279=>[98.685,-79.674,45.037,1],
90280=>[98.701,-79.666,45.028,1],
90281=>[98.718,-79.659,45.020,1],
90282=>[98.734,-79.658,45.014,1],
90283=>[98.749,-79.657,45.007,1],
90284=>[98.765,-79.657,45.000,1],
90285=>[98.781,-79.655,44.991,1],
90286=>[98.797,-79.657,44.982,1],
90287=>[98.831,-79.661,44.971,1],
90288=>[98.872,-79.663,44.960,1],
90289=>[98.913,-79.664,44.949,1],
90290=>[98.954,-79.664,44.936,1],
90291=>[98.995,-79.665,44.924,1],
90292=>[99.036,-79.667,44.913,1],
90293=>[99.077,-79.667,44.903,1],
90294=>[99.118,-79.668,44.891,1],
90295=>[99.159,-79.670,44.880,1],
90296=>[99.200,-79.670,44.870,1],
90297=>[99.220,-79.681,44.861,1],
90298=>[99.223,-79.695,44.850,1],
90299=>[99.227,-79.710,44.840,1],
90300=>[99.230,-79.724,44.830,1],
90301=>[99.234,-79.739,44.821,1],
90302=>[99.237,-79.753,44.812,1],
90303=>[99.251,-79.764,44.802,1],
90304=>[99.274,-79.770,44.792,1],
90305=>[99.298,-79.776,44.782,1],
90306=>[99.322,-79.783,44.772,1],
90307=>[99.345,-79.789,44.761,1],
90308=>[99.369,-79.795,44.751,1],
90309=>[99.393,-79.801,44.742,1],
90310=>[99.417,-79.808,44.733,1],
90311=>[99.436,-79.808,44.724,1],
90312=>[99.451,-79.802,44.714,1],
90313=>[99.467,-79.796,44.705,1],
90314=>[99.482,-79.791,44.697,1],
90315=>[99.497,-79.785,44.688,1],
90316=>[99.512,-79.779,44.680,1],
90317=>[99.527,-79.773,44.674,1],
90318=>[99.542,-79.767,44.667,1],
90319=>[99.542,-79.793,44.661,1],
90320=>[99.541,-79.821,44.654,1],
90321=>[99.540,-79.849,44.647,1],
90322=>[99.538,-79.877,44.639,1],
90323=>[99.537,-79.905,44.629,1],
90324=>[99.536,-79.933,44.620,1],
90325=>[99.535,-79.961,44.612,1],
90326=>[99.536,-79.989,44.604,1],
90327=>[99.555,-80.014,44.597,1],
90328=>[99.575,-80.038,44.591,1],
90329=>[99.594,-80.062,44.584,1],
90330=>[99.614,-80.087,44.577,1],
90331=>[99.634,-80.112,44.571,1],
90332=>[99.654,-80.137,44.563,1],
90333=>[99.674,-80.161,44.556,1],
90334=>[99.705,-80.196,44.548,1],
90335=>[99.743,-80.237,44.539,1],
90336=>[99.778,-80.277,44.530,1],
90337=>[99.801,-80.309,44.521,1],
90338=>[99.825,-80.342,44.511,1],
90339=>[99.869,-80.347,44.500,1],
90340=>[99.921,-80.354,44.