use v5.20;
use strict;
use utf8;
use Test::More;
use Test::Exception;

use_ok("Crypt::URandom::Password" => qw(urandom_password));

isnt urandom_password(), urandom_password(), "two passwords are not the same";

like urandom_password(),                    qr/^[A-Za-z0-9]{44}$/,   "44 alphanumeric chars (default)";
like urandom_password(16),                  qr/^[A-Za-z0-9]{16}$/,   "16 alphanumeric chars";
like urandom_password(4096),                qr/^[A-Za-z0-9]{4096}$/, "4096 alphanumeric chars";

like urandom_password(128, [qw/⚀ ⚁ ⚂ ⚃ ⚄ ⚅/]), qr/^[⚀⚁⚂⚃⚄⚅]{128}$/,       "128 custom alphabet chars, as arrayref";
like urandom_password(128, "⚀⚁⚂⚃⚄⚅"),          qr/^[⚀⚁⚂⚃⚄⚅]{128}$/,       "128 custom alphabet chars, as string";

throws_ok sub { urandom_password(16, "a" x 1) },    qr/alphabet size must be between 2 and 256/, 'throws when alphabet is too small';
throws_ok sub { urandom_password(16, "a" x 257 ) }, qr/alphabet size must be between 2 and 256/, 'throws when alphabet is too large';

lives_ok( sub { urandom_password(16, "a" x 2 ) },   'lives when alphabet is 2');
lives_ok( sub { urandom_password(16, "a" x 256 ) }, 'lives when alphabet is 256');

done_testing();
