use 5.20.0;
use strict;
use warnings;

package Art::World::Util {

  use Zydeco;

  class Math {
    method pick ( Int $min, Int $max ) {
      return $min + int ( rand ( $max - $min ));
    }
  }

  # Looks like the Art::World::Meta toolkit
  # See also https://metacpan.org/pod/Class::MOP::Class for extreme cases
  # my $meta = $self->meta;
  class Meta {
    # TODO See also Zydeco's $class object
    method get_class( Object $klass ) {
      return ref $klass;
    }

    method get_set_attributes_only( Object $clazz ) {
      return keys %{ $clazz };
    }

    method get_all_attributes( Object $claxx ) {
      return keys( %{
        'Moo'->_constructor_maker_for(
          $self->get_class( $claxx )
         )->all_attribute_specs
       });
    }

    method random_set_of_agents ( Int $num ) { }
  }

  class Person {
    require Faker;
    method fake_name {
      my $f = Faker->new;
      return $f->person_first_name . ' ' . $f->person_last_name;
    }

    method generate_discourse( ArrayRef $buzz = [] ) {
      for ( 0 .. int rand( 3 )) { push $buzz->@*, Faker->new->company_buzzword_type1 };
      return join ' ', $buzz->@*;
    }
  }

  class String {
    method titlify( Str $token ) {
      return join '', map { ucfirst lc $_ } split /(\s+)/, $token;
    }
  }
}

1;

__END__

=encoding UTF-8

=head1 NAME

Art::World::Util - Generating all kind of data for the Art::World

=head1 SYNOPSIS

  use Art::World::Util;

  say Art::World::Util->new_person->fake_name;
  #==> Firtname Lastname

  say Art::World::Util->new_math->pick( 10, 1000 ));
  #==> 666

=head1 DESCRIPTION

C<Art::World::Util> provide useful generation tools for automated C<Agents>
creation, data manipulation and other utilities that are not strictly related to
the Art::World entities.

=head2 Methods

=head3 Art::World::Math

=head4 pick()

Pick an integer between a range that can be passed as a parameter. Mostly a way
to not have to memorize C<$min + int ( rand ( $max - $min ))>.

=head3 Art::World::Meta

=head4 get_class()

=head4 get_set_attributes_only()

=head4 get_all_attributes()

=head3 Art::World::Person

=head4 fake_name()

Generate a complete person name using L<Faker>.

=head3 Art::World::String

=head4 titlify()

=head1 AUTHOR

Sébastien Feugère <sebastien@feugere.net>

=head1 COPYRIGHT AND LICENSE

Copyright 2006-2021 Sebastien Feugère

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.
