use Test::More;
use Art::World;
use Faker;

my $f = Faker->new;
my $artist_name = $f->person_first_name . ' ' . $f->person_last_name;

my $rep = 1.7;

my $artist = Art::World->new_artist(
  reputation => $rep,
  name => $artist_name
);

ok $artist->does('Art::World::Fame'), 'Artist does the Fame role';
can_ok $artist, 'bump_fame';

use Data::Printer;

my $reputation = $artist->bump_fame;
is $reputation, $rep + 1, 'Artist reputation got bumped without parameter';
$reputation = $artist->bump_fame( 0.4 );
is $reputation, $rep + 1 + 0.4, 'Artist reputation got bumped positively';
$reputation = $artist->bump_fame( -1.4 );
is $reputation, $rep, 'Artist reputation got bumped negatively';
$reputation = $artist->bump_fame( 12.1212 );
is $reputation, $rep + 12.1212, 'Using a weird 4 digits floating point';
$reputation = $artist->bump_fame( -0.1212 );
$reputation = $artist->bump_fame( -12 );
is $reputation, $rep, 'Reputation back to it\'s previous value after calculating with 4 digits floating point';
$reputation = $artist->bump_fame( 0.1212 );
$reputation = $artist->bump_fame( 12 );
my $smoll = -0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001;
$reputation = $artist->bump_fame( $smoll );
is $reputation, $rep + 0.1212 + 12 - $smoll, 'Looks like extreme floating point stability';
$reputation = $artist->bump_fame( -0.1212 - 12 + $smoll );
my $large = 1_000_000_000_000_000_000_000_000_000_000_000_000_000_000_000;
$reputation = $artist->bump_fame( $large );
is $reputation, $rep + $large , 'Even large numbers are fine';
$reputation = $artist->bump_fame( -$large );
$reputation = $artist->bump_fame( -100 );
p $reputation;

done_testing;
