use Test::More;
use Art::World;
use Faker;

my $f = Faker->new;
my $artist_name = $f->person_first_name . ' ' . $f->person_last_name;

my $rep = 1.7;

my $artist = Art::World->new_artist(
  reputation => $rep,
  name => $artist_name
);

ok $artist->does('Art::World::Fame'), 'Artist does the Fame role';
can_ok $artist, 'bump_fame';

use Data::Printer;

my $reputation = $artist->bump_fame;
is $reputation, $rep + 1, 'Artist reputation got bumped without parameter';
$reputation = $artist->bump_fame( 0.4 );
is $reputation, $rep + 1 + 0.4, 'Artist reputation got bumped positively';
$reputation = $artist->bump_fame( -1.4 );
is $reputation, $rep, 'Artist reputation got bumped negatively';
$reputation = $artist->bump_fame( 1000000000000000000000000000000000000000000000 );
is $reputation, $rep + 1000000000000000000000000000000000000000000000, 'Artist reputation got bumped with a silly reputation';

done_testing;
