use v5.16;
use Test::More;
use Art::Wildlife;
use Art;
use Data::Printer;
use Faker;
use List::Util qw/any/;

my $f = Faker->new;


use_ok 'Art::World';
my $aw = Art::World->new_playground;
ok $aw, 'The world is created';

use_ok 'Art::Wildlife::Agent';
use_ok 'Art::Wildlife::Artist';
use_ok 'Art::Wildlife::Collector';
# use-ok 'Art::Entities::Artwork';

my $agent = Art::Wildlife->new_agent( name => $f->person_name );
can_ok $agent, 'participate';

# does-ok $agent, Art::Behavior::Crudable;

my $artist_name = $f->person_first_name . ' ' . $f->person_last_name;
my $artist = Art::Wildlife->new_artist(
    name => $artist_name, id => 1
   );

isa_ok $artist, 'Art::Wildlife::Agent';
can_ok $artist, 'create';
can_ok $artist, 'participate';
can_ok $artist, 'has_collectors';
can_ok $artist, 'have_idea';

ok $artist->id, 'Artist got an id attr';
is $artist->name, $artist_name, 'Artist got a name attr';
ok $artist->is_underground, 'Artist status not homogenic yet';

my $collectors = [ $f->person_name, $f->person_name ];
my $homogenic_artist = Art::Wildlife->new_artist(
    name => $f->person_name,
    collectors => $collectors
   );

ok $homogenic_artist->is_homogenic, 'Artist status is homogenic since it has collectors';

# can-ok $artist, 'save';
# does-ok $artist, Art::Behavior::Crudable;

# my $artwork = Art::Entities::Artwork.new;
# does-ok $artwork, Art::Behavior::Collectionable;
# can-ok $artwork, 'belong-to';
# can-ok $artwork, 'for-sale';

my $munnies= 100;

my $collector = Art::Wildlife
        ->new_collector(
            name => Faker->new->person_name,
            money => $munnies,
            id => 3
           );

isa_ok $collector, 'Art::Wildlife::Agent';
can_ok $collector, 'acquire';

ok $collector->money, 'Collector got a money attr';
ok $collector->collection, 'Collector got a collection attr';

is $collector->money, $munnies, 'Collector money value is valid';

ok $collector->does('Art::Wildlife::Buyer'), 'Collector does role Buyer';

my $art_abstraction = Art->new_abstract;
ok $art_abstraction->does('Art::Abstractions'), 'Art does role Abstractions';

my $artwork = Art->new_artwork( creator => [ $artist, $homogenic_artist ]  , value => 10_000 );
ok $artwork->does('Art::Showable'), 'Artwork does role Showable';
ok $artwork->value, 'Artwork got a value attribute';

my $bool = any { $_ eq $artist_name } map { $_->name } @{ $artwork->creator };
ok $bool, 'One of the artwork creator is ' . $artist_name;

done_testing();
