use v5.16;
use utf8;
package Art::World;

# use Art::Agent;
#has Art::Agent::Artist @.artists;

our $VERSION = '0.15_04';

use Zydeco;

class Playground {};

1;

=encoding UTF-8

=head1 NAME

Art::World - Agents interactions modeling  🎨

=head1 SYNOPSIS

  use Art::World;

=head1 OBJECTIVES


Art::World is an attempt to model and simulate a system describing the interactions and influences between the various I<agents> of the art world.

If a correct API is reached, we'll try to build a "game of art" frontend.

=head1 DESCRIPTION

=begin html

<p>
  <img alt="Some illustrations sticked on a wall" src="https://gitlab.com/smonff/art-world/-/raw/master/spec/schema_v2.png"
    width="600px">
</p>

=end html

=over

=item 01 Idea is the first step of process

=item 02 Idea is inserted in the file (through process)

=item 03 Idea comes from discourse (given about project)

=item 04 Idea come when there is no time left

=item 05 Ideas constitue the project

=back

=over

=item 06 Process allows ideas to evolve

=item 07 Process allows to fill the file (with ideas + discourse)

=item 08 Process allows to generate some discourse

=item 09 Process allows to save time

=item 10 Process allows to set up the project

=back

=over

=item 11 File is made of ideas

=item 12 File is filled and emptied with the process

=item 13 File is made of discourse

=item 14 File archive ideas, that makes possible to forget them

=item 15 File generate a project

=back

=over

=item 16 Discourse steers ideas

=item 17 Discourse analyze process

=item 18 Discourse talks about the file

=item 19 Discourse allows to link various stages of the projet

=item 20 Discourse is a constituent of the project

=back

=over

=item 21 From time to time, ideas appears

=item 22 Time needed to apply the process

=item 23 Time is suspended into file, process is off there

=item 24 Discourse's time (reading time)

=item 25 Various times contained in project give it's shape

=back

=over

=item 26 Project is updated by new ideas

=item 27 Project is constantly updated by the process

=item 28 Project is set up when file is updated

=item 29 Project and discourse are inseparable

=item 30 Project is what takes the longuest time to set up

=back

=head1 HISTORY

This is a long term continuation of an art project started circa 2006.

In 2008 I benefited of an artist residency in an agricultural college with a
creation grant of 10 000€. I urged to keep go on my Art World and Creative
Processes schema projects initiated during art school. It didn't went very well
because the then local state Plastic Art I<Inspector> didn't like what I was
doing with her money and strongly advised to change orientation. In my idea, it
was a perfect thing that the instutition itself would exhibit it's inherent
processes and operations. In the end, there were an exhibition, but she didn't
come to the opening.

=begin html

<p>
  <img alt="Pencil schema with mountains" src="https://gitlab.com/smonff/art-world/-/raw/master/spec/schema_v4.png"
    width="600px">
</p>

=end html

Then I almost got hit by a fellow artist who was participating at a collective
exhibition mostly for the money and not for the fun.

In 2008, I finally decided to start a training to learn programming and being
able to design a proper database and system for I<managing a virtual Art
World>. I became a web developer, but I totally forgot the main aim. Sometimes I
thought about it, and in 2017, I restarted my project while getting into Raku
(it was still Perl6 at this time), but learning Raku was too much effort and I
abandonned again.

Ten years later I am still on it. This project is L<following me in my
dreams|https://smonff.gitlab.io/art-school-story/>. I'll give it another try.


=head1 AUTHOR

Sébastien Feugère <sebastien@feugere.net>
Seb. Hu-Rillettes <shr@balik.network>

=head1 COPYRIGHT AND LICENSE

Copyright 2006-2020 Seb. Hu-Rillettes

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.

=cut
