package Date::Manip::TZ::asjeru00;
# Copyright (c) 2008-2011 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Mon Jan 10 15:35:53 EST 2011
#    Data version: tzdata2010o
#    Code version: tzcode2010n

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::asjeru00 - Support for the Asia/Jerusalem time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.21';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,2,20,56],'+02:20:56',[2,20,56],
          'LMT',0,[1879,12,31,21,39,3],[1879,12,31,23,59,59],
          '0001010200:00:00','0001010202:20:56','1879123121:39:03','1879123123:59:59' ],
     ],
   1879 =>
     [
        [ [1879,12,31,21,39,4],[1879,12,31,23,59,44],'+02:20:40',[2,20,40],
          'JMT',0,[1917,12,31,21,39,19],[1917,12,31,23,59,59],
          '1879123121:39:04','1879123123:59:44','1917123121:39:19','1917123123:59:59' ],
     ],
   1917 =>
     [
        [ [1917,12,31,21,39,20],[1917,12,31,23,39,20],'+02:00:00',[2,0,0],
          'IST',0,[1940,5,31,21,59,59],[1940,5,31,23,59,59],
          '1917123121:39:20','1917123123:39:20','1940053121:59:59','1940053123:59:59' ],
     ],
   1940 =>
     [
        [ [1940,5,31,22,0,0],[1940,6,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1942,10,31,20,59,59],[1942,10,31,23,59,59],
          '1940053122:00:00','1940060101:00:00','1942103120:59:59','1942103123:59:59' ],
     ],
   1942 =>
     [
        [ [1942,10,31,21,0,0],[1942,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1943,3,31,23,59,59],[1943,4,1,1,59,59],
          '1942103121:00:00','1942103123:00:00','1943033123:59:59','1943040101:59:59' ],
     ],
   1943 =>
     [
        [ [1943,4,1,0,0,0],[1943,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1943,10,31,20,59,59],[1943,10,31,23,59,59],
          '1943040100:00:00','1943040103:00:00','1943103120:59:59','1943103123:59:59' ],
        [ [1943,10,31,21,0,0],[1943,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1944,3,31,21,59,59],[1944,3,31,23,59,59],
          '1943103121:00:00','1943103123:00:00','1944033121:59:59','1944033123:59:59' ],
     ],
   1944 =>
     [
        [ [1944,3,31,22,0,0],[1944,4,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1944,10,31,20,59,59],[1944,10,31,23,59,59],
          '1944033122:00:00','1944040101:00:00','1944103120:59:59','1944103123:59:59' ],
        [ [1944,10,31,21,0,0],[1944,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1945,4,15,21,59,59],[1945,4,15,23,59,59],
          '1944103121:00:00','1944103123:00:00','1945041521:59:59','1945041523:59:59' ],
     ],
   1945 =>
     [
        [ [1945,4,15,22,0,0],[1945,4,16,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1945,10,31,22,59,59],[1945,11,1,1,59,59],
          '1945041522:00:00','1945041601:00:00','1945103122:59:59','1945110101:59:59' ],
        [ [1945,10,31,23,0,0],[1945,11,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1946,4,15,23,59,59],[1946,4,16,1,59,59],
          '1945103123:00:00','1945110101:00:00','1946041523:59:59','1946041601:59:59' ],
     ],
   1946 =>
     [
        [ [1946,4,16,0,0,0],[1946,4,16,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1946,10,31,20,59,59],[1946,10,31,23,59,59],
          '1946041600:00:00','1946041603:00:00','1946103120:59:59','1946103123:59:59' ],
        [ [1946,10,31,21,0,0],[1946,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1948,5,22,21,59,59],[1948,5,22,23,59,59],
          '1946103121:00:00','1946103123:00:00','1948052221:59:59','1948052223:59:59' ],
     ],
   1948 =>
     [
        [ [1948,5,22,22,0,0],[1948,5,23,2,0,0],'+04:00:00',[4,0,0],
          'IDDT',1,[1948,8,31,19,59,59],[1948,8,31,23,59,59],
          '1948052222:00:00','1948052302:00:00','1948083119:59:59','1948083123:59:59' ],
        [ [1948,8,31,20,0,0],[1948,8,31,23,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1948,10,31,22,59,59],[1948,11,1,1,59,59],
          '1948083120:00:00','1948083123:00:00','1948103122:59:59','1948110101:59:59' ],
        [ [1948,10,31,23,0,0],[1948,11,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1949,4,30,21,59,59],[1949,4,30,23,59,59],
          '1948103123:00:00','1948110101:00:00','1949043021:59:59','1949043023:59:59' ],
     ],
   1949 =>
     [
        [ [1949,4,30,22,0,0],[1949,5,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1949,10,31,22,59,59],[1949,11,1,1,59,59],
          '1949043022:00:00','1949050101:00:00','1949103122:59:59','1949110101:59:59' ],
        [ [1949,10,31,23,0,0],[1949,11,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1950,4,15,21,59,59],[1950,4,15,23,59,59],
          '1949103123:00:00','1949110101:00:00','1950041521:59:59','1950041523:59:59' ],
     ],
   1950 =>
     [
        [ [1950,4,15,22,0,0],[1950,4,16,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1950,9,14,23,59,59],[1950,9,15,2,59,59],
          '1950041522:00:00','1950041601:00:00','1950091423:59:59','1950091502:59:59' ],
        [ [1950,9,15,0,0,0],[1950,9,15,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1951,3,31,21,59,59],[1951,3,31,23,59,59],
          '1950091500:00:00','1950091502:00:00','1951033121:59:59','1951033123:59:59' ],
     ],
   1951 =>
     [
        [ [1951,3,31,22,0,0],[1951,4,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1951,11,10,23,59,59],[1951,11,11,2,59,59],
          '1951033122:00:00','1951040101:00:00','1951111023:59:59','1951111102:59:59' ],
        [ [1951,11,11,0,0,0],[1951,11,11,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1952,4,19,23,59,59],[1952,4,20,1,59,59],
          '1951111100:00:00','1951111102:00:00','1952041923:59:59','1952042001:59:59' ],
     ],
   1952 =>
     [
        [ [1952,4,20,0,0,0],[1952,4,20,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1952,10,18,23,59,59],[1952,10,19,2,59,59],
          '1952042000:00:00','1952042003:00:00','1952101823:59:59','1952101902:59:59' ],
        [ [1952,10,19,0,0,0],[1952,10,19,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1953,4,11,23,59,59],[1953,4,12,1,59,59],
          '1952101900:00:00','1952101902:00:00','1953041123:59:59','1953041201:59:59' ],
     ],
   1953 =>
     [
        [ [1953,4,12,0,0,0],[1953,4,12,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1953,9,12,23,59,59],[1953,9,13,2,59,59],
          '1953041200:00:00','1953041203:00:00','1953091223:59:59','1953091302:59:59' ],
        [ [1953,9,13,0,0,0],[1953,9,13,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1954,6,12,21,59,59],[1954,6,12,23,59,59],
          '1953091300:00:00','1953091302:00:00','1954061221:59:59','1954061223:59:59' ],
     ],
   1954 =>
     [
        [ [1954,6,12,22,0,0],[1954,6,13,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1954,9,11,20,59,59],[1954,9,11,23,59,59],
          '1954061222:00:00','1954061301:00:00','1954091120:59:59','1954091123:59:59' ],
        [ [1954,9,11,21,0,0],[1954,9,11,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1955,6,10,23,59,59],[1955,6,11,1,59,59],
          '1954091121:00:00','1954091123:00:00','1955061023:59:59','1955061101:59:59' ],
     ],
   1955 =>
     [
        [ [1955,6,11,0,0,0],[1955,6,11,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1955,9,10,20,59,59],[1955,9,10,23,59,59],
          '1955061100:00:00','1955061103:00:00','1955091020:59:59','1955091023:59:59' ],
        [ [1955,9,10,21,0,0],[1955,9,10,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1956,6,2,21,59,59],[1956,6,2,23,59,59],
          '1955091021:00:00','1955091023:00:00','1956060221:59:59','1956060223:59:59' ],
     ],
   1956 =>
     [
        [ [1956,6,2,22,0,0],[1956,6,3,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1956,9,29,23,59,59],[1956,9,30,2,59,59],
          '1956060222:00:00','1956060301:00:00','1956092923:59:59','1956093002:59:59' ],
        [ [1956,9,30,0,0,0],[1956,9,30,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1957,4,28,23,59,59],[1957,4,29,1,59,59],
          '1956093000:00:00','1956093002:00:00','1957042823:59:59','1957042901:59:59' ],
     ],
   1957 =>
     [
        [ [1957,4,29,0,0,0],[1957,4,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1957,9,21,20,59,59],[1957,9,21,23,59,59],
          '1957042900:00:00','1957042903:00:00','1957092120:59:59','1957092123:59:59' ],
        [ [1957,9,21,21,0,0],[1957,9,21,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1974,7,6,21,59,59],[1974,7,6,23,59,59],
          '1957092121:00:00','1957092123:00:00','1974070621:59:59','1974070623:59:59' ],
     ],
   1974 =>
     [
        [ [1974,7,6,22,0,0],[1974,7,7,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1974,10,12,20,59,59],[1974,10,12,23,59,59],
          '1974070622:00:00','1974070701:00:00','1974101220:59:59','1974101223:59:59' ],
        [ [1974,10,12,21,0,0],[1974,10,12,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1975,4,19,21,59,59],[1975,4,19,23,59,59],
          '1974101221:00:00','1974101223:00:00','1975041921:59:59','1975041923:59:59' ],
     ],
   1975 =>
     [
        [ [1975,4,19,22,0,0],[1975,4,20,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1975,8,30,20,59,59],[1975,8,30,23,59,59],
          '1975041922:00:00','1975042001:00:00','1975083020:59:59','1975083023:59:59' ],
        [ [1975,8,30,21,0,0],[1975,8,30,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1985,4,13,21,59,59],[1985,4,13,23,59,59],
          '1975083021:00:00','1975083023:00:00','1985041321:59:59','1985041323:59:59' ],
     ],
   1985 =>
     [
        [ [1985,4,13,22,0,0],[1985,4,14,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1985,9,14,20,59,59],[1985,9,14,23,59,59],
          '1985041322:00:00','1985041401:00:00','1985091420:59:59','1985091423:59:59' ],
        [ [1985,9,14,21,0,0],[1985,9,14,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1986,5,17,21,59,59],[1986,5,17,23,59,59],
          '1985091421:00:00','1985091423:00:00','1986051721:59:59','1986051723:59:59' ],
     ],
   1986 =>
     [
        [ [1986,5,17,22,0,0],[1986,5,18,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1986,9,6,20,59,59],[1986,9,6,23,59,59],
          '1986051722:00:00','1986051801:00:00','1986090620:59:59','1986090623:59:59' ],
        [ [1986,9,6,21,0,0],[1986,9,6,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1987,4,14,21,59,59],[1987,4,14,23,59,59],
          '1986090621:00:00','1986090623:00:00','1987041421:59:59','1987041423:59:59' ],
     ],
   1987 =>
     [
        [ [1987,4,14,22,0,0],[1987,4,15,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1987,9,12,20,59,59],[1987,9,12,23,59,59],
          '1987041422:00:00','1987041501:00:00','1987091220:59:59','1987091223:59:59' ],
        [ [1987,9,12,21,0,0],[1987,9,12,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1988,4,8,21,59,59],[1988,4,8,23,59,59],
          '1987091221:00:00','1987091223:00:00','1988040821:59:59','1988040823:59:59' ],
     ],
   1988 =>
     [
        [ [1988,4,8,22,0,0],[1988,4,9,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1988,9,2,20,59,59],[1988,9,2,23,59,59],
          '1988040822:00:00','1988040901:00:00','1988090220:59:59','1988090223:59:59' ],
        [ [1988,9,2,21,0,0],[1988,9,2,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1989,4,29,21,59,59],[1989,4,29,23,59,59],
          '1988090221:00:00','1988090223:00:00','1989042921:59:59','1989042923:59:59' ],
     ],
   1989 =>
     [
        [ [1989,4,29,22,0,0],[1989,4,30,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1989,9,2,20,59,59],[1989,9,2,23,59,59],
          '1989042922:00:00','1989043001:00:00','1989090220:59:59','1989090223:59:59' ],
        [ [1989,9,2,21,0,0],[1989,9,2,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1990,3,24,21,59,59],[1990,3,24,23,59,59],
          '1989090221:00:00','1989090223:00:00','1990032421:59:59','1990032423:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,24,22,0,0],[1990,3,25,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1990,8,25,20,59,59],[1990,8,25,23,59,59],
          '1990032422:00:00','1990032501:00:00','1990082520:59:59','1990082523:59:59' ],
        [ [1990,8,25,21,0,0],[1990,8,25,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1991,3,23,21,59,59],[1991,3,23,23,59,59],
          '1990082521:00:00','1990082523:00:00','1991032321:59:59','1991032323:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,23,22,0,0],[1991,3,24,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1991,8,31,20,59,59],[1991,8,31,23,59,59],
          '1991032322:00:00','1991032401:00:00','1991083120:59:59','1991083123:59:59' ],
        [ [1991,8,31,21,0,0],[1991,8,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1992,3,28,21,59,59],[1992,3,28,23,59,59],
          '1991083121:00:00','1991083123:00:00','1992032821:59:59','1992032823:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,28,22,0,0],[1992,3,29,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1992,9,5,20,59,59],[1992,9,5,23,59,59],
          '1992032822:00:00','1992032901:00:00','1992090520:59:59','1992090523:59:59' ],
        [ [1992,9,5,21,0,0],[1992,9,5,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1993,4,1,21,59,59],[1993,4,1,23,59,59],
          '1992090521:00:00','1992090523:00:00','1993040121:59:59','1993040123:59:59' ],
     ],
   1993 =>
     [
        [ [1993,4,1,22,0,0],[1993,4,2,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1993,9,4,20,59,59],[1993,9,4,23,59,59],
          '1993040122:00:00','1993040201:00:00','1993090420:59:59','1993090423:59:59' ],
        [ [1993,9,4,21,0,0],[1993,9,4,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1994,3,31,21,59,59],[1994,3,31,23,59,59],
          '1993090421:00:00','1993090423:00:00','1994033121:59:59','1994033123:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,31,22,0,0],[1994,4,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1994,8,27,20,59,59],[1994,8,27,23,59,59],
          '1994033122:00:00','1994040101:00:00','1994082720:59:59','1994082723:59:59' ],
        [ [1994,8,27,21,0,0],[1994,8,27,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1995,3,30,21,59,59],[1995,3,30,23,59,59],
          '1994082721:00:00','1994082723:00:00','1995033021:59:59','1995033023:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,30,22,0,0],[1995,3,31,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1995,9,2,20,59,59],[1995,9,2,23,59,59],
          '1995033022:00:00','1995033101:00:00','1995090220:59:59','1995090223:59:59' ],
        [ [1995,9,2,21,0,0],[1995,9,2,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1996,3,14,21,59,59],[1996,3,14,23,59,59],
          '1995090221:00:00','1995090223:00:00','1996031421:59:59','1996031423:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,14,22,0,0],[1996,3,15,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1996,9,15,20,59,59],[1996,9,15,23,59,59],
          '1996031422:00:00','1996031501:00:00','1996091520:59:59','1996091523:59:59' ],
        [ [1996,9,15,21,0,0],[1996,9,15,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1997,3,20,21,59,59],[1997,3,20,23,59,59],
          '1996091521:00:00','1996091523:00:00','1997032021:59:59','1997032023:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,20,22,0,0],[1997,3,21,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1997,9,13,20,59,59],[1997,9,13,23,59,59],
          '1997032022:00:00','1997032101:00:00','1997091320:59:59','1997091323:59:59' ],
        [ [1997,9,13,21,0,0],[1997,9,13,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1998,3,19,21,59,59],[1998,3,19,23,59,59],
          '1997091321:00:00','1997091323:00:00','1998031921:59:59','1998031923:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,19,22,0,0],[1998,3,20,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1998,9,5,20,59,59],[1998,9,5,23,59,59],
          '1998031922:00:00','1998032001:00:00','1998090520:59:59','1998090523:59:59' ],
        [ [1998,9,5,21,0,0],[1998,9,5,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1999,4,1,23,59,59],[1999,4,2,1,59,59],
          '1998090521:00:00','1998090523:00:00','1999040123:59:59','1999040201:59:59' ],
     ],
   1999 =>
     [
        [ [1999,4,2,0,0,0],[1999,4,2,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1999,9,2,22,59,59],[1999,9,3,1,59,59],
          '1999040200:00:00','1999040203:00:00','1999090222:59:59','1999090301:59:59' ],
        [ [1999,9,2,23,0,0],[1999,9,3,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2000,4,13,23,59,59],[2000,4,14,1,59,59],
          '1999090223:00:00','1999090301:00:00','2000041323:59:59','2000041401:59:59' ],
     ],
   2000 =>
     [
        [ [2000,4,14,0,0,0],[2000,4,14,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2000,10,5,21,59,59],[2000,10,6,0,59,59],
          '2000041400:00:00','2000041403:00:00','2000100521:59:59','2000100600:59:59' ],
        [ [2000,10,5,22,0,0],[2000,10,6,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2001,4,8,22,59,59],[2001,4,9,0,59,59],
          '2000100522:00:00','2000100600:00:00','2001040822:59:59','2001040900:59:59' ],
     ],
   2001 =>
     [
        [ [2001,4,8,23,0,0],[2001,4,9,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2001,9,23,21,59,59],[2001,9,24,0,59,59],
          '2001040823:00:00','2001040902:00:00','2001092321:59:59','2001092400:59:59' ],
        [ [2001,9,23,22,0,0],[2001,9,24,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2002,3,28,22,59,59],[2002,3,29,0,59,59],
          '2001092322:00:00','2001092400:00:00','2002032822:59:59','2002032900:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,28,23,0,0],[2002,3,29,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2002,10,6,21,59,59],[2002,10,7,0,59,59],
          '2002032823:00:00','2002032902:00:00','2002100621:59:59','2002100700:59:59' ],
        [ [2002,10,6,22,0,0],[2002,10,7,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2003,3,27,22,59,59],[2003,3,28,0,59,59],
          '2002100622:00:00','2002100700:00:00','2003032722:59:59','2003032800:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,27,23,0,0],[2003,3,28,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2003,10,2,21,59,59],[2003,10,3,0,59,59],
          '2003032723:00:00','2003032802:00:00','2003100221:59:59','2003100300:59:59' ],
        [ [2003,10,2,22,0,0],[2003,10,3,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2004,4,6,22,59,59],[2004,4,7,0,59,59],
          '2003100222:00:00','2003100300:00:00','2004040622:59:59','2004040700:59:59' ],
     ],
   2004 =>
     [
        [ [2004,4,6,23,0,0],[2004,4,7,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2004,9,21,21,59,59],[2004,9,22,0,59,59],
          '2004040623:00:00','2004040702:00:00','2004092121:59:59','2004092200:59:59' ],
        [ [2004,9,21,22,0,0],[2004,9,22,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2005,3,31,23,59,59],[2005,4,1,1,59,59],
          '2004092122:00:00','2004092200:00:00','2005033123:59:59','2005040101:59:59' ],
     ],
   2005 =>
     [
        [ [2005,4,1,0,0,0],[2005,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2005,10,8,22,59,59],[2005,10,9,1,59,59],
          '2005040100:00:00','2005040103:00:00','2005100822:59:59','2005100901:59:59' ],
        [ [2005,10,8,23,0,0],[2005,10,9,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2006,3,30,23,59,59],[2006,3,31,1,59,59],
          '2005100823:00:00','2005100901:00:00','2006033023:59:59','2006033101:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,31,0,0,0],[2006,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2006,9,30,22,59,59],[2006,10,1,1,59,59],
          '2006033100:00:00','2006033103:00:00','2006093022:59:59','2006100101:59:59' ],
        [ [2006,9,30,23,0,0],[2006,10,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2007,3,29,23,59,59],[2007,3,30,1,59,59],
          '2006093023:00:00','2006100101:00:00','2007032923:59:59','2007033001:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,30,0,0,0],[2007,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2007,9,15,22,59,59],[2007,9,16,1,59,59],
          '2007033000:00:00','2007033003:00:00','2007091522:59:59','2007091601:59:59' ],
        [ [2007,9,15,23,0,0],[2007,9,16,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2008,3,27,23,59,59],[2008,3,28,1,59,59],
          '2007091523:00:00','2007091601:00:00','2008032723:59:59','2008032801:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,28,0,0,0],[2008,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2008,10,4,22,59,59],[2008,10,5,1,59,59],
          '2008032800:00:00','2008032803:00:00','2008100422:59:59','2008100501:59:59' ],
        [ [2008,10,4,23,0,0],[2008,10,5,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2009,3,26,23,59,59],[2009,3,27,1,59,59],
          '2008100423:00:00','2008100501:00:00','2009032623:59:59','2009032701:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,27,0,0,0],[2009,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2009,9,26,22,59,59],[2009,9,27,1,59,59],
          '2009032700:00:00','2009032703:00:00','2009092622:59:59','2009092701:59:59' ],
        [ [2009,9,26,23,0,0],[2009,9,27,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2010,3,25,23,59,59],[2010,3,26,1,59,59],
          '2009092623:00:00','2009092701:00:00','2010032523:59:59','2010032601:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,26,0,0,0],[2010,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2010,9,11,22,59,59],[2010,9,12,1,59,59],
          '2010032600:00:00','2010032603:00:00','2010091122:59:59','2010091201:59:59' ],
        [ [2010,9,11,23,0,0],[2010,9,12,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2011,3,31,23,59,59],[2011,4,1,1,59,59],
          '2010091123:00:00','2010091201:00:00','2011033123:59:59','2011040101:59:59' ],
     ],
   2011 =>
     [
        [ [2011,4,1,0,0,0],[2011,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2011,10,1,22,59,59],[2011,10,2,1,59,59],
          '2011040100:00:00','2011040103:00:00','2011100122:59:59','2011100201:59:59' ],
        [ [2011,10,1,23,0,0],[2011,10,2,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2012,3,29,23,59,59],[2012,3,30,1,59,59],
          '2011100123:00:00','2011100201:00:00','2012032923:59:59','2012033001:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,30,0,0,0],[2012,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2012,9,22,22,59,59],[2012,9,23,1,59,59],
          '2012033000:00:00','2012033003:00:00','2012092222:59:59','2012092301:59:59' ],
        [ [2012,9,22,23,0,0],[2012,9,23,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2013,3,28,23,59,59],[2013,3,29,1,59,59],
          '2012092223:00:00','2012092301:00:00','2013032823:59:59','2013032901:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,29,0,0,0],[2013,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2013,9,7,22,59,59],[2013,9,8,1,59,59],
          '2013032900:00:00','2013032903:00:00','2013090722:59:59','2013090801:59:59' ],
        [ [2013,9,7,23,0,0],[2013,9,8,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2014,3,27,23,59,59],[2014,3,28,1,59,59],
          '2013090723:00:00','2013090801:00:00','2014032723:59:59','2014032801:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,28,0,0,0],[2014,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2014,9,27,22,59,59],[2014,9,28,1,59,59],
          '2014032800:00:00','2014032803:00:00','2014092722:59:59','2014092801:59:59' ],
        [ [2014,9,27,23,0,0],[2014,9,28,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2015,3,26,23,59,59],[2015,3,27,1,59,59],
          '2014092723:00:00','2014092801:00:00','2015032623:59:59','2015032701:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,27,0,0,0],[2015,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2015,9,19,22,59,59],[2015,9,20,1,59,59],
          '2015032700:00:00','2015032703:00:00','2015091922:59:59','2015092001:59:59' ],
        [ [2015,9,19,23,0,0],[2015,9,20,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2016,3,31,23,59,59],[2016,4,1,1,59,59],
          '2015091923:00:00','2015092001:00:00','2016033123:59:59','2016040101:59:59' ],
     ],
   2016 =>
     [
        [ [2016,4,1,0,0,0],[2016,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2016,10,8,22,59,59],[2016,10,9,1,59,59],
          '2016040100:00:00','2016040103:00:00','2016100822:59:59','2016100901:59:59' ],
        [ [2016,10,8,23,0,0],[2016,10,9,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2017,3,30,23,59,59],[2017,3,31,1,59,59],
          '2016100823:00:00','2016100901:00:00','2017033023:59:59','2017033101:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,31,0,0,0],[2017,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2017,9,23,22,59,59],[2017,9,24,1,59,59],
          '2017033100:00:00','2017033103:00:00','2017092322:59:59','2017092401:59:59' ],
        [ [2017,9,23,23,0,0],[2017,9,24,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2018,3,29,23,59,59],[2018,3,30,1,59,59],
          '2017092323:00:00','2017092401:00:00','2018032923:59:59','2018033001:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,30,0,0,0],[2018,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2018,9,15,22,59,59],[2018,9,16,1,59,59],
          '2018033000:00:00','2018033003:00:00','2018091522:59:59','2018091601:59:59' ],
        [ [2018,9,15,23,0,0],[2018,9,16,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2019,3,28,23,59,59],[2019,3,29,1,59,59],
          '2018091523:00:00','2018091601:00:00','2019032823:59:59','2019032901:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,29,0,0,0],[2019,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2019,10,5,22,59,59],[2019,10,6,1,59,59],
          '2019032900:00:00','2019032903:00:00','2019100522:59:59','2019100601:59:59' ],
        [ [2019,10,5,23,0,0],[2019,10,6,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2020,3,26,23,59,59],[2020,3,27,1,59,59],
          '2019100523:00:00','2019100601:00:00','2020032623:59:59','2020032701:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,27,0,0,0],[2020,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2020,9,26,22,59,59],[2020,9,27,1,59,59],
          '2020032700:00:00','2020032703:00:00','2020092622:59:59','2020092701:59:59' ],
        [ [2020,9,26,23,0,0],[2020,9,27,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2021,3,25,23,59,59],[2021,3,26,1,59,59],
          '2020092623:00:00','2020092701:00:00','2021032523:59:59','2021032601:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,26,0,0,0],[2021,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2021,9,11,22,59,59],[2021,9,12,1,59,59],
          '2021032600:00:00','2021032603:00:00','2021091122:59:59','2021091201:59:59' ],
        [ [2021,9,11,23,0,0],[2021,9,12,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2022,3,31,23,59,59],[2022,4,1,1,59,59],
          '2021091123:00:00','2021091201:00:00','2022033123:59:59','2022040101:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,1,0,0,0],[2022,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2022,10,1,22,59,59],[2022,10,2,1,59,59],
          '2022040100:00:00','2022040103:00:00','2022100122:59:59','2022100201:59:59' ],
        [ [2022,10,1,23,0,0],[2022,10,2,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2023,3,30,23,59,59],[2023,3,31,1,59,59],
          '2022100123:00:00','2022100201:00:00','2023033023:59:59','2023033101:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,31,0,0,0],[2023,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2023,9,23,22,59,59],[2023,9,24,1,59,59],
          '2023033100:00:00','2023033103:00:00','2023092322:59:59','2023092401:59:59' ],
        [ [2023,9,23,23,0,0],[2023,9,24,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2024,3,28,23,59,59],[2024,3,29,1,59,59],
          '2023092323:00:00','2023092401:00:00','2024032823:59:59','2024032901:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,29,0,0,0],[2024,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2024,10,5,22,59,59],[2024,10,6,1,59,59],
          '2024032900:00:00','2024032903:00:00','2024100522:59:59','2024100601:59:59' ],
        [ [2024,10,5,23,0,0],[2024,10,6,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2025,3,27,23,59,59],[2025,3,28,1,59,59],
          '2024100523:00:00','2024100601:00:00','2025032723:59:59','2025032801:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,28,0,0,0],[2025,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2025,9,27,22,59,59],[2025,9,28,1,59,59],
          '2025032800:00:00','2025032803:00:00','2025092722:59:59','2025092801:59:59' ],
        [ [2025,9,27,23,0,0],[2025,9,28,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2026,3,26,23,59,59],[2026,3,27,1,59,59],
          '2025092723:00:00','2025092801:00:00','2026032623:59:59','2026032701:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,27,0,0,0],[2026,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2026,9,19,22,59,59],[2026,9,20,1,59,59],
          '2026032700:00:00','2026032703:00:00','2026091922:59:59','2026092001:59:59' ],
        [ [2026,9,19,23,0,0],[2026,9,20,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2027,3,25,23,59,59],[2027,3,26,1,59,59],
          '2026091923:00:00','2026092001:00:00','2027032523:59:59','2027032601:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,26,0,0,0],[2027,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2027,10,9,22,59,59],[2027,10,10,1,59,59],
          '2027032600:00:00','2027032603:00:00','2027100922:59:59','2027101001:59:59' ],
        [ [2027,10,9,23,0,0],[2027,10,10,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2028,3,30,23,59,59],[2028,3,31,1,59,59],
          '2027100923:00:00','2027101001:00:00','2028033023:59:59','2028033101:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,31,0,0,0],[2028,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2028,9,23,22,59,59],[2028,9,24,1,59,59],
          '2028033100:00:00','2028033103:00:00','2028092322:59:59','2028092401:59:59' ],
        [ [2028,9,23,23,0,0],[2028,9,24,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2029,3,29,23,59,59],[2029,3,30,1,59,59],
          '2028092323:00:00','2028092401:00:00','2029032923:59:59','2029033001:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,30,0,0,0],[2029,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2029,9,15,22,59,59],[2029,9,16,1,59,59],
          '2029033000:00:00','2029033003:00:00','2029091522:59:59','2029091601:59:59' ],
        [ [2029,9,15,23,0,0],[2029,9,16,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2030,3,28,23,59,59],[2030,3,29,1,59,59],
          '2029091523:00:00','2029091601:00:00','2030032823:59:59','2030032901:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,29,0,0,0],[2030,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2030,10,5,22,59,59],[2030,10,6,1,59,59],
          '2030032900:00:00','2030032903:00:00','2030100522:59:59','2030100601:59:59' ],
        [ [2030,10,5,23,0,0],[2030,10,6,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2031,3,27,23,59,59],[2031,3,28,1,59,59],
          '2030100523:00:00','2030100601:00:00','2031032723:59:59','2031032801:59:59' ],
     ],
   2031 =>
     [
        [ [2031,3,28,0,0,0],[2031,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2031,9,20,22,59,59],[2031,9,21,1,59,59],
          '2031032800:00:00','2031032803:00:00','2031092022:59:59','2031092101:59:59' ],
        [ [2031,9,20,23,0,0],[2031,9,21,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2032,3,25,23,59,59],[2032,3,26,1,59,59],
          '2031092023:00:00','2031092101:00:00','2032032523:59:59','2032032601:59:59' ],
     ],
   2032 =>
     [
        [ [2032,3,26,0,0,0],[2032,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2032,9,11,22,59,59],[2032,9,12,1,59,59],
          '2032032600:00:00','2032032603:00:00','2032091122:59:59','2032091201:59:59' ],
        [ [2032,9,11,23,0,0],[2032,9,12,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2033,3,31,23,59,59],[2033,4,1,1,59,59],
          '2032091123:00:00','2032091201:00:00','2033033123:59:59','2033040101:59:59' ],
     ],
   2033 =>
     [
        [ [2033,4,1,0,0,0],[2033,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2033,10,1,22,59,59],[2033,10,2,1,59,59],
          '2033040100:00:00','2033040103:00:00','2033100122:59:59','2033100201:59:59' ],
        [ [2033,10,1,23,0,0],[2033,10,2,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2034,3,30,23,59,59],[2034,3,31,1,59,59],
          '2033100123:00:00','2033100201:00:00','2034033023:59:59','2034033101:59:59' ],
     ],
   2034 =>
     [
        [ [2034,3,31,0,0,0],[2034,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2034,9,16,22,59,59],[2034,9,17,1,59,59],
          '2034033100:00:00','2034033103:00:00','2034091622:59:59','2034091701:59:59' ],
        [ [2034,9,16,23,0,0],[2034,9,17,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2035,3,29,23,59,59],[2035,3,30,1,59,59],
          '2034091623:00:00','2034091701:00:00','2035032923:59:59','2035033001:59:59' ],
     ],
   2035 =>
     [
        [ [2035,3,30,0,0,0],[2035,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2035,10,6,22,59,59],[2035,10,7,1,59,59],
          '2035033000:00:00','2035033003:00:00','2035100622:59:59','2035100701:59:59' ],
        [ [2035,10,6,23,0,0],[2035,10,7,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2036,3,27,23,59,59],[2036,3,28,1,59,59],
          '2035100623:00:00','2035100701:00:00','2036032723:59:59','2036032801:59:59' ],
     ],
   2036 =>
     [
        [ [2036,3,28,0,0,0],[2036,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2036,9,27,22,59,59],[2036,9,28,1,59,59],
          '2036032800:00:00','2036032803:00:00','2036092722:59:59','2036092801:59:59' ],
        [ [2036,9,27,23,0,0],[2036,9,28,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2037,3,26,23,59,59],[2037,3,27,1,59,59],
          '2036092723:00:00','2036092801:00:00','2037032623:59:59','2037032701:59:59' ],
     ],
   2037 =>
     [
        [ [2037,3,27,0,0,0],[2037,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2037,9,12,22,59,59],[2037,9,13,1,59,59],
          '2037032700:00:00','2037032703:00:00','2037091222:59:59','2037091301:59:59' ],
        [ [2037,9,12,23,0,0],[2037,9,13,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[9999,12,31,0,0,0],[9999,12,31,2,0,0],
          '2037091223:00:00','2037091301:00:00','9999123100:00:00','9999123102:00:00' ],
     ],
);

%LastRule      = (
);

1;
